DROP TABLE api_templates;

CREATE TABLE `api_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `base_url` text NOT NULL,
  `success_word` varchar(100) NOT NULL,
  `json_encode` int(11) NOT NULL,
  `request_type` varchar(20) NOT NULL DEFAULT 'GET',
  `sender_field` text NOT NULL,
  `recipient_field` text NOT NULL,
  `message_field` text NOT NULL,
  `param1_field` text NOT NULL,
  `param2_field` text NOT NULL,
  `param3_field` text NOT NULL,
  `param4_field` text NOT NULL,
  `param1_value` text NOT NULL,
  `param2_value` text NOT NULL,
  `param3_value` text NOT NULL,
  `param4_value` text NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `language_field` text NOT NULL,
  `audio_field` text NOT NULL,
  `timeout_field` text NOT NULL,
  `speed_field` text NOT NULL,
  `authentication` text NOT NULL,
  `base64_encode` int(11) NOT NULL,
  `success_logic` varchar(333) NOT NULL DEFAULT 'contain',
  `dlr_enabled` int(11) NOT NULL DEFAULT '0',
  `dlr_callback` varchar(555) NOT NULL,
  `alias` varchar(333) NOT NULL DEFAULT 'custom',
  `param5_field` varchar(555) NOT NULL,
  `param5_value` varchar(555) NOT NULL,
  `param5_label` varchar(555) NOT NULL,
  `param4_label` varchar(555) NOT NULL,
  `param3_label` varchar(555) NOT NULL,
  `param2_label` varchar(555) NOT NULL,
  `param1_label` varchar(555) NOT NULL,
  `tts_enabled` int(11) NOT NULL DEFAULT '1',
  `file_enabled` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE backups;

CREATE TABLE `backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `type` varchar(200) NOT NULL,
  `file` varchar(500) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE blacklist;

CREATE TABLE `blacklist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `phone` varchar(30) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO blacklist VALUES("1","2017-11-28 18:03:29","378307693696","9");
INSERT INTO blacklist VALUES("2","2017-12-12 14:29:35","0993686933","0");



DROP TABLE contacts;

CREATE TABLE `contacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(40) NOT NULL DEFAULT 'No Name',
  `phone` varchar(20) NOT NULL,
  `phonebook_id` int(11) NOT NULL,
  `birthday` date NOT NULL,
  `last_name` varchar(555) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1;

INSERT INTO contacts VALUES("1","Names","37093369","1","2017-11-14","Jagon");
INSERT INTO contacts VALUES("2","Galk","95804744","2","2017-11-01","Hallen");
INSERT INTO contacts VALUES("3","James","95804744","2","2017-11-01","Hallen");
INSERT INTO contacts VALUES("6","Harry","447936373073","1","0000-00-00","Porter");
INSERT INTO contacts VALUES("7","John","2347088335536","1","1970-01-01","Wick");
INSERT INTO contacts VALUES("8","Harry","447936373073","1","1970-01-01","Porter");
INSERT INTO contacts VALUES("9","Charles","0773933222","1","2017-11-08","Lange");
INSERT INTO contacts VALUES("10","Chams","4545522242","14","2012-11-08","Hars");
INSERT INTO contacts VALUES("11","Test","12345678","3","1970-01-01","One");
INSERT INTO contacts VALUES("12","Tetser","2345678","3","2017-12-12","Two");



DROP TABLE countries;

CREATE TABLE `countries` (
  `country_code` char(2) COLLATE utf8_bin DEFAULT NULL,
  `country_name` varchar(45) COLLATE utf8_bin DEFAULT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`),
  KEY `idx_country_code` (`country_code`)
) ENGINE=MyISAM AUTO_INCREMENT=253 DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=DYNAMIC;

INSERT INTO countries VALUES("AD","Andorra","1");
INSERT INTO countries VALUES("AE","United Arab Emirates","2");
INSERT INTO countries VALUES("AF","Afghanistan","3");
INSERT INTO countries VALUES("AG","Antigua and Barbuda","4");
INSERT INTO countries VALUES("AI","Anguilla","5");
INSERT INTO countries VALUES("AL","Albania","6");
INSERT INTO countries VALUES("AM","Armenia","7");
INSERT INTO countries VALUES("AN","Netherlands Antilles","8");
INSERT INTO countries VALUES("AO","Angola","9");
INSERT INTO countries VALUES("AQ","Antarctica","10");
INSERT INTO countries VALUES("AR","Argentina","11");
INSERT INTO countries VALUES("AS","American Samoa","12");
INSERT INTO countries VALUES("AT","Austria","13");
INSERT INTO countries VALUES("AU","Australia","14");
INSERT INTO countries VALUES("AW","Aruba","15");
INSERT INTO countries VALUES("AX","Aland Islands","16");
INSERT INTO countries VALUES("AZ","Azerbaijan","17");
INSERT INTO countries VALUES("BA","Bosnia and Herzegovina","18");
INSERT INTO countries VALUES("BB","Barbados","19");
INSERT INTO countries VALUES("BD","Bangladesh","20");
INSERT INTO countries VALUES("BE","Belgium","21");
INSERT INTO countries VALUES("BF","Burkina Faso","22");
INSERT INTO countries VALUES("BG","Bulgaria","23");
INSERT INTO countries VALUES("BH","Bahrain","24");
INSERT INTO countries VALUES("BI","Burundi","25");
INSERT INTO countries VALUES("BJ","Benin","26");
INSERT INTO countries VALUES("BL","Saint Barthlemy","27");
INSERT INTO countries VALUES("BM","Bermuda","28");
INSERT INTO countries VALUES("BN","Brunei","29");
INSERT INTO countries VALUES("BO","Bolivia","30");
INSERT INTO countries VALUES("BQ","Bonaire, Saint Eustatius and Saba ","31");
INSERT INTO countries VALUES("BR","Brazil","32");
INSERT INTO countries VALUES("BS","Bahamas","33");
INSERT INTO countries VALUES("BT","Bhutan","34");
INSERT INTO countries VALUES("BV","Bouvet Island","35");
INSERT INTO countries VALUES("BW","Botswana","36");
INSERT INTO countries VALUES("BY","Belarus","37");
INSERT INTO countries VALUES("BZ","Belize","38");
INSERT INTO countries VALUES("CA","Canada","39");
INSERT INTO countries VALUES("CC","Cocos Islands","40");
INSERT INTO countries VALUES("CD","Democratic Republic of the Congo","41");
INSERT INTO countries VALUES("CF","Central African Republic","42");
INSERT INTO countries VALUES("CG","Republic of the Congo","43");
INSERT INTO countries VALUES("CH","Switzerland","44");
INSERT INTO countries VALUES("CI","Ivory Coast","45");
INSERT INTO countries VALUES("CK","Cook Islands","46");
INSERT INTO countries VALUES("CL","Chile","47");
INSERT INTO countries VALUES("CM","Cameroon","48");
INSERT INTO countries VALUES("CN","China","49");
INSERT INTO countries VALUES("CO","Colombia","50");
INSERT INTO countries VALUES("CR","Costa Rica","51");
INSERT INTO countries VALUES("CS","Serbia and Montenegro","52");
INSERT INTO countries VALUES("CU","Cuba","53");
INSERT INTO countries VALUES("CV","Cape Verde","54");
INSERT INTO countries VALUES("CW","Curaao","55");
INSERT INTO countries VALUES("CX","Christmas Island","56");
INSERT INTO countries VALUES("CY","Cyprus","57");
INSERT INTO countries VALUES("CZ","Czech Republic","58");
INSERT INTO countries VALUES("DE","Germany","59");
INSERT INTO countries VALUES("DJ","Djibouti","60");
INSERT INTO countries VALUES("DK","Denmark","61");
INSERT INTO countries VALUES("DM","Dominica","62");
INSERT INTO countries VALUES("DO","Dominican Republic","63");
INSERT INTO countries VALUES("DZ","Algeria","64");
INSERT INTO countries VALUES("EC","Ecuador","65");
INSERT INTO countries VALUES("EE","Estonia","66");
INSERT INTO countries VALUES("EG","Egypt","67");
INSERT INTO countries VALUES("EH","Western Sahara","68");
INSERT INTO countries VALUES("ER","Eritrea","69");
INSERT INTO countries VALUES("ES","Spain","70");
INSERT INTO countries VALUES("ET","Ethiopia","71");
INSERT INTO countries VALUES("FI","Finland","72");
INSERT INTO countries VALUES("FJ","Fiji","73");
INSERT INTO countries VALUES("FK","Falkland Islands","74");
INSERT INTO countries VALUES("FM","Micronesia","75");
INSERT INTO countries VALUES("FO","Faroe Islands","76");
INSERT INTO countries VALUES("FR","France","77");
INSERT INTO countries VALUES("GA","Gabon","78");
INSERT INTO countries VALUES("GB","United Kingdom","79");
INSERT INTO countries VALUES("GD","Grenada","80");
INSERT INTO countries VALUES("GE","Georgia","81");
INSERT INTO countries VALUES("GF","French Guiana","82");
INSERT INTO countries VALUES("GG","Guernsey","83");
INSERT INTO countries VALUES("GH","Ghana","84");
INSERT INTO countries VALUES("GI","Gibraltar","85");
INSERT INTO countries VALUES("GL","Greenland","86");
INSERT INTO countries VALUES("GM","Gambia","87");
INSERT INTO countries VALUES("GN","Guinea","88");
INSERT INTO countries VALUES("GP","Guadeloupe","89");
INSERT INTO countries VALUES("GQ","Equatorial Guinea","90");
INSERT INTO countries VALUES("GR","Greece","91");
INSERT INTO countries VALUES("GS","South Georgia and the South Sandwich Islands","92");
INSERT INTO countries VALUES("GT","Guatemala","93");
INSERT INTO countries VALUES("GU","Guam","94");
INSERT INTO countries VALUES("GW","Guinea-Bissau","95");
INSERT INTO countries VALUES("GY","Guyana","96");
INSERT INTO countries VALUES("HK","Hong Kong","97");
INSERT INTO countries VALUES("HM","Heard Island and McDonald Islands","98");
INSERT INTO countries VALUES("HN","Honduras","99");
INSERT INTO countries VALUES("HR","Croatia","100");
INSERT INTO countries VALUES("HT","Haiti","101");
INSERT INTO countries VALUES("HU","Hungary","102");
INSERT INTO countries VALUES("ID","Indonesia","103");
INSERT INTO countries VALUES("IE","Ireland","104");
INSERT INTO countries VALUES("IL","Israel","105");
INSERT INTO countries VALUES("IM","Isle of Man","106");
INSERT INTO countries VALUES("IN","India","107");
INSERT INTO countries VALUES("IO","British Indian Ocean Territory","108");
INSERT INTO countries VALUES("IQ","Iraq","109");
INSERT INTO countries VALUES("IR","Iran","110");
INSERT INTO countries VALUES("IS","Iceland","111");
INSERT INTO countries VALUES("IT","Italy","112");
INSERT INTO countries VALUES("JE","Jersey","113");
INSERT INTO countries VALUES("JM","Jamaica","114");
INSERT INTO countries VALUES("JO","Jordan","115");
INSERT INTO countries VALUES("JP","Japan","116");
INSERT INTO countries VALUES("KE","Kenya","117");
INSERT INTO countries VALUES("KG","Kyrgyzstan","118");
INSERT INTO countries VALUES("KH","Cambodia","119");
INSERT INTO countries VALUES("KI","Kiribati","120");
INSERT INTO countries VALUES("KM","Comoros","121");
INSERT INTO countries VALUES("KN","Saint Kitts and Nevis","122");
INSERT INTO countries VALUES("KP","North Korea","123");
INSERT INTO countries VALUES("KR","South Korea","124");
INSERT INTO countries VALUES("KW","Kuwait","125");
INSERT INTO countries VALUES("KY","Cayman Islands","126");
INSERT INTO countries VALUES("KZ","Kazakhstan","127");
INSERT INTO countries VALUES("LA","Laos","128");
INSERT INTO countries VALUES("LB","Lebanon","129");
INSERT INTO countries VALUES("LC","Saint Lucia","130");
INSERT INTO countries VALUES("LI","Liechtenstein","131");
INSERT INTO countries VALUES("LK","Sri Lanka","132");
INSERT INTO countries VALUES("LR","Liberia","133");
INSERT INTO countries VALUES("LS","Lesotho","134");
INSERT INTO countries VALUES("LT","Lithuania","135");
INSERT INTO countries VALUES("LU","Luxembourg","136");
INSERT INTO countries VALUES("LV","Latvia","137");
INSERT INTO countries VALUES("LY","Libya","138");
INSERT INTO countries VALUES("MA","Morocco","139");
INSERT INTO countries VALUES("MC","Monaco","140");
INSERT INTO countries VALUES("MD","Moldova","141");
INSERT INTO countries VALUES("ME","Montenegro","142");
INSERT INTO countries VALUES("MF","Saint Martin","143");
INSERT INTO countries VALUES("MG","Madagascar","144");
INSERT INTO countries VALUES("MH","Marshall Islands","145");
INSERT INTO countries VALUES("MK","Macedonia","146");
INSERT INTO countries VALUES("ML","Mali","147");
INSERT INTO countries VALUES("MM","Myanmar","148");
INSERT INTO countries VALUES("MN","Mongolia","149");
INSERT INTO countries VALUES("MO","Macao","150");
INSERT INTO countries VALUES("MP","Northern Mariana Islands","151");
INSERT INTO countries VALUES("MQ","Martinique","152");
INSERT INTO countries VALUES("MR","Mauritania","153");
INSERT INTO countries VALUES("MS","Montserrat","154");
INSERT INTO countries VALUES("MT","Malta","155");
INSERT INTO countries VALUES("MU","Mauritius","156");
INSERT INTO countries VALUES("MV","Maldives","157");
INSERT INTO countries VALUES("MW","Malawi","158");
INSERT INTO countries VALUES("MX","Mexico","159");
INSERT INTO countries VALUES("MY","Malaysia","160");
INSERT INTO countries VALUES("MZ","Mozambique","161");
INSERT INTO countries VALUES("NA","Namibia","162");
INSERT INTO countries VALUES("NC","New Caledonia","163");
INSERT INTO countries VALUES("NE","Niger","164");
INSERT INTO countries VALUES("NF","Norfolk Island","165");
INSERT INTO countries VALUES("NG","Nigeria","166");
INSERT INTO countries VALUES("NI","Nicaragua","167");
INSERT INTO countries VALUES("NL","Netherlands","168");
INSERT INTO countries VALUES("NO","Norway","169");
INSERT INTO countries VALUES("NP","Nepal","170");
INSERT INTO countries VALUES("NR","Nauru","171");
INSERT INTO countries VALUES("NU","Niue","172");
INSERT INTO countries VALUES("NZ","New Zealand","173");
INSERT INTO countries VALUES("OM","Oman","174");
INSERT INTO countries VALUES("PA","Panama","175");
INSERT INTO countries VALUES("PE","Peru","176");
INSERT INTO countries VALUES("PF","French Polynesia","177");
INSERT INTO countries VALUES("PG","Papua New Guinea","178");
INSERT INTO countries VALUES("PH","Philippines","179");
INSERT INTO countries VALUES("PK","Pakistan","180");
INSERT INTO countries VALUES("PL","Poland","181");
INSERT INTO countries VALUES("PM","Saint Pierre and Miquelon","182");
INSERT INTO countries VALUES("PN","Pitcairn","183");
INSERT INTO countries VALUES("PR","Puerto Rico","184");
INSERT INTO countries VALUES("PS","Palestinian Territory","185");
INSERT INTO countries VALUES("PT","Portugal","186");
INSERT INTO countries VALUES("PW","Palau","187");
INSERT INTO countries VALUES("PY","Paraguay","188");
INSERT INTO countries VALUES("QA","Qatar","189");
INSERT INTO countries VALUES("RE","Reunion","190");
INSERT INTO countries VALUES("RO","Romania","191");
INSERT INTO countries VALUES("RS","Serbia","192");
INSERT INTO countries VALUES("RU","Russia","193");
INSERT INTO countries VALUES("RW","Rwanda","194");
INSERT INTO countries VALUES("SA","Saudi Arabia","195");
INSERT INTO countries VALUES("SB","Solomon Islands","196");
INSERT INTO countries VALUES("SC","Seychelles","197");
INSERT INTO countries VALUES("SD","Sudan","198");
INSERT INTO countries VALUES("SE","Sweden","199");
INSERT INTO countries VALUES("SG","Singapore","200");
INSERT INTO countries VALUES("SH","Saint Helena","201");
INSERT INTO countries VALUES("SI","Slovenia","202");
INSERT INTO countries VALUES("SJ","Svalbard and Jan Mayen","203");
INSERT INTO countries VALUES("SK","Slovakia","204");
INSERT INTO countries VALUES("SL","Sierra Leone","205");
INSERT INTO countries VALUES("SM","San Marino","206");
INSERT INTO countries VALUES("SN","Senegal","207");
INSERT INTO countries VALUES("SO","Somalia","208");
INSERT INTO countries VALUES("SR","Suriname","209");
INSERT INTO countries VALUES("SS","South Sudan","210");
INSERT INTO countries VALUES("ST","Sao Tome and Principe","211");
INSERT INTO countries VALUES("SV","El Salvador","212");
INSERT INTO countries VALUES("SX","Sint Maarten","213");
INSERT INTO countries VALUES("SY","Syria","214");
INSERT INTO countries VALUES("SZ","Swaziland","215");
INSERT INTO countries VALUES("TC","Turks and Caicos Islands","216");
INSERT INTO countries VALUES("TD","Chad","217");
INSERT INTO countries VALUES("TF","French Southern Territories","218");
INSERT INTO countries VALUES("TG","Togo","219");
INSERT INTO countries VALUES("TH","Thailand","220");
INSERT INTO countries VALUES("TJ","Tajikistan","221");
INSERT INTO countries VALUES("TK","Tokelau","222");
INSERT INTO countries VALUES("TL","East Timor","223");
INSERT INTO countries VALUES("TM","Turkmenistan","224");
INSERT INTO countries VALUES("TN","Tunisia","225");
INSERT INTO countries VALUES("TO","Tonga","226");
INSERT INTO countries VALUES("TR","Turkey","227");
INSERT INTO countries VALUES("TT","Trinidad and Tobago","228");
INSERT INTO countries VALUES("TV","Tuvalu","229");
INSERT INTO countries VALUES("TW","Taiwan","230");
INSERT INTO countries VALUES("TZ","Tanzania","231");
INSERT INTO countries VALUES("UA","Ukraine","232");
INSERT INTO countries VALUES("UG","Uganda","233");
INSERT INTO countries VALUES("UM","United States Minor Outlying Islands","234");
INSERT INTO countries VALUES("US","United States","235");
INSERT INTO countries VALUES("UY","Uruguay","236");
INSERT INTO countries VALUES("UZ","Uzbekistan","237");
INSERT INTO countries VALUES("VA","Vatican","238");
INSERT INTO countries VALUES("VC","Saint Vincent and the Grenadines","239");
INSERT INTO countries VALUES("VE","Venezuela","240");
INSERT INTO countries VALUES("VG","British Virgin Islands","241");
INSERT INTO countries VALUES("VI","U.S. Virgin Islands","242");
INSERT INTO countries VALUES("VN","Vietnam","243");
INSERT INTO countries VALUES("VU","Vanuatu","244");
INSERT INTO countries VALUES("WF","Wallis and Futuna","245");
INSERT INTO countries VALUES("WS","Samoa","246");
INSERT INTO countries VALUES("XK","Kosovo","247");
INSERT INTO countries VALUES("YE","Yemen","248");
INSERT INTO countries VALUES("YT","Mayotte","249");
INSERT INTO countries VALUES("ZA","South Africa","250");
INSERT INTO countries VALUES("ZM","Zambia","251");
INSERT INTO countries VALUES("ZW","Zimbabwe","252");



DROP TABLE country_codes;

CREATE TABLE `country_codes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(300) NOT NULL,
  `code` varchar(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=195 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

INSERT INTO country_codes VALUES("3","+91 India","+91");
INSERT INTO country_codes VALUES("4","+234 Nigeria","+234");
INSERT INTO country_codes VALUES("5","+7 Abkhazia","+7");
INSERT INTO country_codes VALUES("6","+93 Afghanistan","+93");
INSERT INTO country_codes VALUES("7","+355 Albania","+355");
INSERT INTO country_codes VALUES("8","+213 Algeria","+213");
INSERT INTO country_codes VALUES("9","+376 Andorra","+376");
INSERT INTO country_codes VALUES("10","+244 Angola","+244");
INSERT INTO country_codes VALUES("11","+54 Argentina","+54");
INSERT INTO country_codes VALUES("12","+297 Aruba","+297");
INSERT INTO country_codes VALUES("13","+61 Australia","+61");
INSERT INTO country_codes VALUES("14","+43 Austria","+43");
INSERT INTO country_codes VALUES("15","+994  Azerbaijan","+994");
INSERT INTO country_codes VALUES("16","+973 Bahrain","+973");
INSERT INTO country_codes VALUES("17","+880 Bangladesh","+880");
INSERT INTO country_codes VALUES("18","+375 Belarus","+375");
INSERT INTO country_codes VALUES("19","+32  Belgium","+32");
INSERT INTO country_codes VALUES("20","+501 Belize","+501");
INSERT INTO country_codes VALUES("21","+229 Benin","+229");
INSERT INTO country_codes VALUES("22","+975 Bhutan","+975");
INSERT INTO country_codes VALUES("23","+591 Bolivia","+591");
INSERT INTO country_codes VALUES("24","+387 Bosnia and Herzegovina","+387");
INSERT INTO country_codes VALUES("25","+267 Botswana","+267");
INSERT INTO country_codes VALUES("26","+359 Bulgaria","+359");
INSERT INTO country_codes VALUES("27","+226 Burkina Faso","+226");
INSERT INTO country_codes VALUES("28","+257 Burundi","+257");
INSERT INTO country_codes VALUES("29","+855 Cambodia","+855");
INSERT INTO country_codes VALUES("30","+237 Cameroon","+237");
INSERT INTO country_codes VALUES("31","+238 Cape Verde","+238");
INSERT INTO country_codes VALUES("32","+236 Central African Republic","+236");
INSERT INTO country_codes VALUES("33","+56 Chile","+56");
INSERT INTO country_codes VALUES("34","+86 China","+86");
INSERT INTO country_codes VALUES("35","+1 Canada","+1");
INSERT INTO country_codes VALUES("36","+269 Comoros","+269");
INSERT INTO country_codes VALUES("37","+243 Congo (Democratic)","+243");
INSERT INTO country_codes VALUES("38","+242 Congo (Republic)","+242");
INSERT INTO country_codes VALUES("39","+682 Cook Islands","+682");
INSERT INTO country_codes VALUES("40","+506 Costa Rica","+506");
INSERT INTO country_codes VALUES("41","+225 Cote d\'Ivoire","+225");
INSERT INTO country_codes VALUES("42","+385 Croatia","+385");
INSERT INTO country_codes VALUES("43","+53 Cuba","+53");
INSERT INTO country_codes VALUES("44","+357 Cyprus","+357");
INSERT INTO country_codes VALUES("45","+420 Czech Republic","+420");
INSERT INTO country_codes VALUES("46","+45 Denmark","+45");
INSERT INTO country_codes VALUES("47","+253 Djibouti","+253");
INSERT INTO country_codes VALUES("48","+593 Ecuador","+593");
INSERT INTO country_codes VALUES("49","+20 Egypt","+20");
INSERT INTO country_codes VALUES("50","+503 El Salvador","+503");
INSERT INTO country_codes VALUES("51","+240 Equatorial Guinea","+240");
INSERT INTO country_codes VALUES("52","+291 Eritrea","+291");
INSERT INTO country_codes VALUES("53","+372 Estonia","+372");
INSERT INTO country_codes VALUES("54","+251 Ethiopia","+251");
INSERT INTO country_codes VALUES("55","+33 France","+33");
INSERT INTO country_codes VALUES("56","+241 Gabon","+241");
INSERT INTO country_codes VALUES("57","+220 Gambia","+220");
INSERT INTO country_codes VALUES("58","+30 Greece","+30");
INSERT INTO country_codes VALUES("59","+245 Guinea Bissau","+245");
INSERT INTO country_codes VALUES("60","+36 Hungary","+36");
INSERT INTO country_codes VALUES("61","+374 Armenia","+374");
INSERT INTO country_codes VALUES("62","+235 Chad","+235");
INSERT INTO country_codes VALUES("63","+55 Brazil","+55");
INSERT INTO country_codes VALUES("64","+57 Colombia","+57");
INSERT INTO country_codes VALUES("65","+500 Falkland Islands","+500");
INSERT INTO country_codes VALUES("66","+298 Faroe Islands","+298");
INSERT INTO country_codes VALUES("67","+679 Fiji","+679");
INSERT INTO country_codes VALUES("68","+358 Finland","+358");
INSERT INTO country_codes VALUES("69","+594 French Guiana","+594");
INSERT INTO country_codes VALUES("70","+995 Georgia","+995");
INSERT INTO country_codes VALUES("71","+49  Germany","+49");
INSERT INTO country_codes VALUES("72","+233 Ghana","+233");
INSERT INTO country_codes VALUES("73","+350 Gibraltar","+350");
INSERT INTO country_codes VALUES("74","+299 Greenland","+299");
INSERT INTO country_codes VALUES("75","+590 Guadeloupe","+590");
INSERT INTO country_codes VALUES("76","+502 Guatemala","+502");
INSERT INTO country_codes VALUES("77","+44 Guernsey Channel Islands","+44");
INSERT INTO country_codes VALUES("78","+592  Guyana","+592");
INSERT INTO country_codes VALUES("79","+509 Haiti","+509");
INSERT INTO country_codes VALUES("80","+504 Hondura","+504");
INSERT INTO country_codes VALUES("81","+852  Hong Kong","+852");
INSERT INTO country_codes VALUES("82","+354 Iceland","+354");
INSERT INTO country_codes VALUES("83","+62 Indonesia","+62");
INSERT INTO country_codes VALUES("84","+98 Iran","+98");
INSERT INTO country_codes VALUES("85","+964 Iraq","+964");
INSERT INTO country_codes VALUES("86","+353 Ireland","+353");
INSERT INTO country_codes VALUES("87","+44 Isle of Man","+44");
INSERT INTO country_codes VALUES("88","+972 Israel","+972");
INSERT INTO country_codes VALUES("89","+39 Italy","+39");
INSERT INTO country_codes VALUES("90","+81 Japan","+81");
INSERT INTO country_codes VALUES("91","+44 Jersey","+44");
INSERT INTO country_codes VALUES("92","+962 Jordan","+962");
INSERT INTO country_codes VALUES("93","+7 Kazakhstan","+7");
INSERT INTO country_codes VALUES("94","+254 Kenya","+254");
INSERT INTO country_codes VALUES("95","+82 Korea, South","+82");
INSERT INTO country_codes VALUES("96","+965 Kuwait","+965");
INSERT INTO country_codes VALUES("97","+996 Kyrgyzstan","+996");
INSERT INTO country_codes VALUES("98","+856 Laos","+856");
INSERT INTO country_codes VALUES("99","+371 Latvia","+371");
INSERT INTO country_codes VALUES("100","+961 Lebanon","+961");
INSERT INTO country_codes VALUES("101","+266 Lesotho","+266");
INSERT INTO country_codes VALUES("102","+231 Liberia","+231");
INSERT INTO country_codes VALUES("103","+218 Libya","+218");
INSERT INTO country_codes VALUES("104","+423 Liechtenstein","+423");
INSERT INTO country_codes VALUES("105","+370 Lithuania","+370");
INSERT INTO country_codes VALUES("106","+352 Luxembourg","+352");
INSERT INTO country_codes VALUES("107","+853 Macao","+853");
INSERT INTO country_codes VALUES("108","+389 Macedonia","+389");
INSERT INTO country_codes VALUES("109","+261 Madagascar","+261");
INSERT INTO country_codes VALUES("110","+265 Malawi","+265");
INSERT INTO country_codes VALUES("111","+60 Malaysia","+60");
INSERT INTO country_codes VALUES("112","+960 Maldives","+960");
INSERT INTO country_codes VALUES("113","+223 Mali","+223");
INSERT INTO country_codes VALUES("114","+356 Malta","+356");
INSERT INTO country_codes VALUES("115","+222 Mauritania","+222");
INSERT INTO country_codes VALUES("116","+230 Mauritius","+230");
INSERT INTO country_codes VALUES("117","+262 Mayotte","+262");
INSERT INTO country_codes VALUES("118","+52 Mexico","+52");
INSERT INTO country_codes VALUES("119","+691 Micronesia","+691");
INSERT INTO country_codes VALUES("120","+373 Moldova","+373");
INSERT INTO country_codes VALUES("121","+377 Monaco","+377");
INSERT INTO country_codes VALUES("122","+976 Mongolia","+976");
INSERT INTO country_codes VALUES("123","+382 Montenegro","+382");
INSERT INTO country_codes VALUES("124","+212 Morocco","+212");
INSERT INTO country_codes VALUES("125","+258 Mozambique","+258");
INSERT INTO country_codes VALUES("126","+264 Namibia","+264");
INSERT INTO country_codes VALUES("127","+977 Nepal","+977");
INSERT INTO country_codes VALUES("128","+31 Netherlands","+31");
INSERT INTO country_codes VALUES("129","+599 Netherlands Antilles","+599");
INSERT INTO country_codes VALUES("130","+687 New Caledonia","+687");
INSERT INTO country_codes VALUES("131","+64 New Zealand","+64");
INSERT INTO country_codes VALUES("132","+505 Nicaragua","+505");
INSERT INTO country_codes VALUES("133","+227 Niger","+227");
INSERT INTO country_codes VALUES("134","+47 Norway","+47");
INSERT INTO country_codes VALUES("135","+968 Oman","+92");
INSERT INTO country_codes VALUES("136","+92 Pakistan","+92");
INSERT INTO country_codes VALUES("137","+680 Palau","+680");
INSERT INTO country_codes VALUES("138","+970 Palestine","+970");
INSERT INTO country_codes VALUES("139","+507 Panama","+507");
INSERT INTO country_codes VALUES("140","+675 Papua New Guinea","+675");
INSERT INTO country_codes VALUES("141","+595 Paraguay","+595");
INSERT INTO country_codes VALUES("142","+51 Peru","+61");
INSERT INTO country_codes VALUES("143","+63 Philippines","+63");
INSERT INTO country_codes VALUES("144","+48 Poland","+48");
INSERT INTO country_codes VALUES("145","+351 Portugal","+351");
INSERT INTO country_codes VALUES("146","+974 Qatar","+974");
INSERT INTO country_codes VALUES("147","+40 Romania","+40");
INSERT INTO country_codes VALUES("148","+7 Russia","+7");
INSERT INTO country_codes VALUES("149","+250 Rwanda","+250");
INSERT INTO country_codes VALUES("150","+508 St. Pierre & Miquelon","+508");
INSERT INTO country_codes VALUES("151","+685 Samoa","+685");
INSERT INTO country_codes VALUES("152","+378 San Marino","+378");
INSERT INTO country_codes VALUES("153","+966 Saudi Arabia","+966");
INSERT INTO country_codes VALUES("154","+221 Senegal","+221");
INSERT INTO country_codes VALUES("155","+381 Serbia","+381");
INSERT INTO country_codes VALUES("156","+248 Seychelles","+248");
INSERT INTO country_codes VALUES("157","+232 Sierra Leone","+232");
INSERT INTO country_codes VALUES("158","+65 Singapore","+65");
INSERT INTO country_codes VALUES("159","+421 Slovakia","+421");
INSERT INTO country_codes VALUES("160","+386 Slovenia","+386");
INSERT INTO country_codes VALUES("161","+677 Solomon Islands","+677");
INSERT INTO country_codes VALUES("162","+252 Somalia","+252");
INSERT INTO country_codes VALUES("163","+27 South Africa","+27");
INSERT INTO country_codes VALUES("164","+34 Spain","+34");
INSERT INTO country_codes VALUES("165","+94 Sri Lanka","+94");
INSERT INTO country_codes VALUES("166","+249 Sudan","+249");
INSERT INTO country_codes VALUES("167","+597 Suriname","+597");
INSERT INTO country_codes VALUES("168","+268 Swaziland","+268");
INSERT INTO country_codes VALUES("169","+46 Sweden","+46");
INSERT INTO country_codes VALUES("170","+41 Switzerland","+41");
INSERT INTO country_codes VALUES("171","+963 Syria","+963");
INSERT INTO country_codes VALUES("172","+886 Taiwan","+886");
INSERT INTO country_codes VALUES("173","+992 Tajikistan","+992");
INSERT INTO country_codes VALUES("174","+255 Tanzania","+255");
INSERT INTO country_codes VALUES("175","+66 Thailand","+66");
INSERT INTO country_codes VALUES("176","+228 Togo","+228");
INSERT INTO country_codes VALUES("177","+676 Tonga","+676");
INSERT INTO country_codes VALUES("178","+216 Tunisia","+216");
INSERT INTO country_codes VALUES("179","+90 Turkey","+90");
INSERT INTO country_codes VALUES("180","+993 Turkmenistan","+993");
INSERT INTO country_codes VALUES("181","+256 Uganda","+256");
INSERT INTO country_codes VALUES("182","+380 Ukraine","+380");
INSERT INTO country_codes VALUES("183","+971 United Arab Emirates","+971");
INSERT INTO country_codes VALUES("184","+44 United Kingdom","+44");
INSERT INTO country_codes VALUES("185","+1 United States","+1");
INSERT INTO country_codes VALUES("186","+598 Uruguay","+598");
INSERT INTO country_codes VALUES("187","+998 Uzbekistan","+998");
INSERT INTO country_codes VALUES("188","+678 Vanuatu","+678");
INSERT INTO country_codes VALUES("189","+58 Venezuela","+58");
INSERT INTO country_codes VALUES("190","+84 Vietnam","+84");
INSERT INTO country_codes VALUES("191","+967 Yemen","+967");
INSERT INTO country_codes VALUES("192","+260 Zambia","+260");
INSERT INTO country_codes VALUES("193","+263 Zimbabwe","+263");
INSERT INTO country_codes VALUES("194","+95 Myanmar","+95");



DROP TABLE currencies;

CREATE TABLE `currencies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `symbul` varchar(100) NOT NULL,
  `rate` decimal(11,5) NOT NULL,
  `code` varchar(22) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO currencies VALUES("1","Naira","&#8358;","1.00000","NGN");
INSERT INTO currencies VALUES("2","US Dollar","$","0.00603","USD");
INSERT INTO currencies VALUES("3","Euro","&#8364;","0.00436","EUR");



DROP TABLE customers;

CREATE TABLE `customers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(300) NOT NULL,
  `email` varchar(200) NOT NULL,
  `facebook_id` varchar(300) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `password` varchar(200) NOT NULL,
  `address` varchar(300) NOT NULL,
  `city` varchar(300) NOT NULL,
  `state` varchar(300) NOT NULL,
  `country` varchar(100) NOT NULL,
  `sender_id` varchar(15) NOT NULL,
  `picture` varchar(200) NOT NULL,
  `timezone_id` varchar(300) NOT NULL,
  `is_reseller` int(11) DEFAULT '0',
  `reseller` int(11) DEFAULT '0',
  `allow_2way` int(11) DEFAULT '0',
  `shortcode` varchar(50) NOT NULL,
  `last_login` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `last_ip` varchar(50) NOT NULL,
  `phone_verified` varchar(200) NOT NULL DEFAULT '0',
  `email_verified` varchar(200) NOT NULL DEFAULT '0',
  `is_admin` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `order_limit` decimal(11,2) NOT NULL DEFAULT '1.00',
  `currency_id` int(11) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `credit_limit` decimal(11,2) NOT NULL DEFAULT '0.00',
  `failed_attempts` int(11) NOT NULL DEFAULT '0',
  `custom_price` decimal(11,2) NOT NULL DEFAULT '0.00',
  `status` varchar(50) NOT NULL DEFAULT 'active',
  `last_name` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COMMENT='Keeps details of all SMS customers';

INSERT INTO customers VALUES("1","Super Admin","chucy03@yahoo.com","","","e63f7470607dd0966d5a0095d1fbbbd9:N2u4Eov6tHwvJ77Z35KlVn3I1daaWU0M","","","","","","","Europe/Paris","1","0","0","","0000-00-00 00:00:00","","1","1","66546","0","1.00","1","0","0.00","0","0.00","0","");



DROP TABLE draftmessages;

CREATE TABLE `draftmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `recipients` mediumtext NOT NULL,
  `customer_id` int(11) NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `speed` varchar(11) NOT NULL,
  `language` varchar(11) NOT NULL,
  `title` varchar(200) NOT NULL DEFAULT 'Untitled',
  `media` text NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `sender_id` varchar(20) NOT NULL,
  `phonebook_id` varchar(110) NOT NULL DEFAULT '',
  `marketinglist_id` varchar(110) NOT NULL DEFAULT '',
  `duration` int(11) NOT NULL,
  `file` varchar(444) NOT NULL,
  `country` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO draftmessages VALUES("1","Hi.\nThis is a new line of text. Just checking stuffs","07088538551,08088538551,09088538551","9","sms","","","Untitled","","2017-11-20 17:32:15","Sendroid","","","0","1511194527.6379.xlsx","166");
INSERT INTO draftmessages VALUES("2","Hi.\nThisnis a message sent by admin","08055346246,09076358583,6369363223,","0","sms","","","Untitled","http://localhost/Sendroid Ultimate/account/files/temp/","2017-12-11 17:48:19","Sender56","","","0","","166");
INSERT INTO draftmessages VALUES("3","ok","73969373","0","sms","","","Untitled","http://localhost/Sendroid Ultimate/account/files/temp/","2017-12-11 17:53:09","111111","","","0","","1");



DROP TABLE dynamic_credit_cost;

CREATE TABLE `dynamic_credit_cost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `min_order` decimal(11,2) NOT NULL DEFAULT '0.00',
  `max_order` decimal(11,2) NOT NULL DEFAULT '0.00',
  `cost` decimal(11,4) NOT NULL DEFAULT '0.0000',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `reseller_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO dynamic_credit_cost VALUES("1","0.00","0.00","1.0000","0","0");
INSERT INTO dynamic_credit_cost VALUES("2","100000.00","1000000.00","0.9500","0","0");



DROP TABLE fobidden_sender;

CREATE TABLE `fobidden_sender` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sender_id` varchar(33) NOT NULL,
  `reason` varchar(333) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE forbidden_country;

CREATE TABLE `forbidden_country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `country_id` int(11) NOT NULL,
  `reason` varchar(333) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE forbidden_words;

CREATE TABLE `forbidden_words` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `word` varchar(333) NOT NULL,
  `reason` varchar(333) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE gateway_charges;

CREATE TABLE `gateway_charges` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `gateway_id` int(11) NOT NULL,
  `title` varchar(444) NOT NULL,
  `fixed` decimal(11,3) NOT NULL DEFAULT '0.000',
  `percentage` decimal(11,2) NOT NULL DEFAULT '0.00',
  `reseller_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE inbox;

CREATE TABLE `inbox` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `sender` text NOT NULL,
  `date` datetime DEFAULT NULL,
  `message` text NOT NULL,
  `is_read` int(5) NOT NULL DEFAULT '0',
  `recipient` varchar(50) NOT NULL,
  `cost` decimal(11,6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO inbox VALUES("1","9","+23447746944","2017-11-21 04:19:06","Hi. I got your message. Let me know if you got this","1","2347088665333","0.002000");



DROP TABLE language;

CREATE TABLE `language` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `alias` varchar(11) NOT NULL,
  `title` varchar(333) NOT NULL,
  `enabled` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

INSERT INTO language VALUES("1","en","English","1");



DROP TABLE logs;

CREATE TABLE `logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `event` varchar(555) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `date` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=147 DEFAULT CHARSET=latin1;

INSERT INTO logs VALUES("1","6","Joined Sendroid Ultimate","::1","1509969123");
INSERT INTO logs VALUES("2","7","Joined Sendroid Ultimate","::1","1509969133");
INSERT INTO logs VALUES("3","8","Joined Sendroid Ultimate","::1","1509969196");
INSERT INTO logs VALUES("4","9","Joined Sendroid Ultimate via facebook","::1","1509983447");
INSERT INTO logs VALUES("5","9","Logged into Sendroid Ultimate via facebook","::1","1509983449");
INSERT INTO logs VALUES("6","9","Logged into Sendroid Ultimate","::1","1509983588");
INSERT INTO logs VALUES("7","9","Logged into Sendroid Ultimate","::1","1509983613");
INSERT INTO logs VALUES("8","9","Logged into Sendroid Ultimate","::1","1509987246");
INSERT INTO logs VALUES("9","9","Logged into Sendroid Ultimate","::1","1509987310");
INSERT INTO logs VALUES("10","9","Logged into Sendroid Ultimate","::1","1509987349");
INSERT INTO logs VALUES("11","9","Logged into Sendroid Ultimate","::1","1510058932");
INSERT INTO logs VALUES("12","9","Logged into Sendroid Ultimate","::1","1510059433");
INSERT INTO logs VALUES("13","9","Logged into Sendroid Ultimate","::1","1510059466");
INSERT INTO logs VALUES("14","9","Logged into Sendroid Ultimate","::1","1510059558");
INSERT INTO logs VALUES("15","9","Logged into Sendroid Ultimate","::1","1510059756");
INSERT INTO logs VALUES("16","9","Logged into Sendroid Ultimate","::1","1510060307");
INSERT INTO logs VALUES("17","9","Logged into Sendroid Ultimate","::1","1510140488");
INSERT INTO logs VALUES("18","9","Logged into Sendroid Ultimate","::1","1510140825");
INSERT INTO logs VALUES("19","9","Logged into Sendroid Ultimate","::1","1510141135");
INSERT INTO logs VALUES("20","9","Logged into Sendroid Ultimate","::1","1510141370");
INSERT INTO logs VALUES("21","9","Logged into Sendroid Ultimate","::1","1510142285");
INSERT INTO logs VALUES("22","9","Logged into Sendroid Ultimate","::1","1510142560");
INSERT INTO logs VALUES("23","9","Logged into Sendroid Ultimate","::1","1510143227");
INSERT INTO logs VALUES("24","9","Logged into Sendroid Ultimate","::1","1510217369");
INSERT INTO logs VALUES("25","9","Logged into Sendroid Ultimate","::1","1510217463");
INSERT INTO logs VALUES("26","9","Logged into Sendroid Ultimate","::1","1510217500");
INSERT INTO logs VALUES("27","9","Recharged with a voucher PIN: 538636839916011762","::1","1510756795");
INSERT INTO logs VALUES("28","0","Completed transaction: RPCSg41510760603 via ","::1","1510760605");
INSERT INTO logs VALUES("29","9","Recharged with a voucher PIN: 538636839916011762","::1","1510760605");
INSERT INTO logs VALUES("30","9","Transaction: PQvNsw1510837116 failed","::1","1510858846");
INSERT INTO logs VALUES("31","9","Transaction: PQvNsw1510837116 failed","::1","1510859009");
INSERT INTO logs VALUES("32","0","Transaction: PQvNsw1510837116 failed","::1","1510859176");
INSERT INTO logs VALUES("33","0","Transaction: PQvNsw1510837116 failed","::1","1510860060");
INSERT INTO logs VALUES("34","0","Transaction: PQvNsw1510837116 failed","::1","1510861101");
INSERT INTO logs VALUES("35","9","Canceled message with ID 3] from queued messages","::1","1511356964");
INSERT INTO logs VALUES("36","9","Purchased marketing list #<br />
\n<b>Notice</b>:  Undefined variable: row in <b>C:\\PHP\\htdocs\\Sendroid Ultimate\\account\\system\\hooks\\buycontact.php</b> on line <b>152</b><br />
\n","::1","1511450740");
INSERT INTO logs VALUES("37","9","Purchased marketing list #<br />
\n<b>Notice</b>:  Undefined variable: row in <b>C:\\PHP\\htdocs\\Sendroid Ultimate\\account\\system\\hooks\\buycontact.php</b> on line <b>153</b><br />
\n","::1","1511450920");
INSERT INTO logs VALUES("38","9","Purchased marketing list #2","::1","1511450955");
INSERT INTO logs VALUES("39","9","Created a phonebook with ID 3","::1","1511724509");
INSERT INTO logs VALUES("40","9","Created a phonebook with ID 4","::1","1511725141");
INSERT INTO logs VALUES("41","9","Created a phonebook with ID 5","::1","1511796813");
INSERT INTO logs VALUES("42","9","Created a phonebook with ID 6","::1","1511796832");
INSERT INTO logs VALUES("43","9","Created a phonebook with ID 7","::1","1511796889");
INSERT INTO logs VALUES("44","9","Initiated an  message to 3 recipients","::1","1511797009");
INSERT INTO logs VALUES("45","9","Created a phonebook with ID 8","::1","1511797103");
INSERT INTO logs VALUES("46","9","Created a phonebook with ID 9","::1","1511797110");
INSERT INTO logs VALUES("47","9","Created a phonebook with ID 10","::1","1511797989");
INSERT INTO logs VALUES("48","9","Created a phonebook with ID 11","::1","1511798001");
INSERT INTO logs VALUES("49","9","Created a phonebook with ID 12","::1","1511798425");
INSERT INTO logs VALUES("50","9","Created a phonebook with ID 13","::1","1511798447");
INSERT INTO logs VALUES("51","9","Deleted contact ID 5 from contact lists","::1","1511862173");
INSERT INTO logs VALUES("52","9","Deleted contact ID 4 from contact lists","::1","1511862173");
INSERT INTO logs VALUES("53","9","Created a new contact in phonebook ID 1","::1","1511862635");
INSERT INTO logs VALUES("54","9","Created a phonebook with ID 14","::1","1511871939");
INSERT INTO logs VALUES("55","9","Deleted phonebook ID 13] from phonebooks","::1","1511872357");
INSERT INTO logs VALUES("56","9","Deleted phonebook ID 12] from phonebooks","::1","1511872357");
INSERT INTO logs VALUES("57","9","Deleted phonebook ID 11] from phonebooks","::1","1511872358");
INSERT INTO logs VALUES("58","9","Deleted phonebook ID 10] from phonebooks","::1","1511872358");
INSERT INTO logs VALUES("59","9","Deleted phonebook ID 9] from phonebooks","::1","1511872359");
INSERT INTO logs VALUES("60","9","Deleted phonebook ID 8] from phonebooks","::1","1511872359");
INSERT INTO logs VALUES("61","9","Deleted phonebook ID 7] from phonebooks","::1","1511872359");
INSERT INTO logs VALUES("62","9","Deleted phonebook ID 6] from phonebooks","::1","1511872360");
INSERT INTO logs VALUES("63","9","Deleted phonebook ID 5] from phonebooks","::1","1511872361");
INSERT INTO logs VALUES("64","9","Created a new contact in phonebook ID 14","::1","1511876126");
INSERT INTO logs VALUES("65","9","Created a marketing list with ID 3","::1","1511881234");
INSERT INTO logs VALUES("66","9","shared marketing list ID 3 with chukaokoye@ynetinteractive.com1","::1","1511884215");
INSERT INTO logs VALUES("67","9","shared marketing list ID 3 with chukaokoye@ynetinteractive.com1","::1","1511884343");
INSERT INTO logs VALUES("68","9","shared phonebook ID 3 with chukaokoye@ynetinteractive.com1","::1","1511885011");
INSERT INTO logs VALUES("69","9","Created a marketing list with ID 4","::1","1511886021");
INSERT INTO logs VALUES("70","9","Created a new contact in markeing list ID 4","::1","1511886988");
INSERT INTO logs VALUES("71","9","Deleted list ID 3] from marketing list","::1","1511887934");
INSERT INTO logs VALUES("72","9","added a new contact to blacklist: 378307693696","::1","1511888609");
INSERT INTO logs VALUES("73","9","Purchased a new shortcode: 23477892633","::1","1511953942");
INSERT INTO logs VALUES("74","9","Removed shortcode ID 2] from his account","::1","1511954055");
INSERT INTO logs VALUES("75","9","Purchased a new shortcode: 23477892633","::1","1511957178");
INSERT INTO logs VALUES("76","9","Transfered credits to chukaokoye@ynetinteractive.com1","::1","1512046485");
INSERT INTO logs VALUES("77","9","Transfered credits to chukaokoye@ynetinteractive.com1","::1","1512046598");
INSERT INTO logs VALUES("78","9","Transfered credits to chukaokoye@ynetinteractive.com1","::1","1512046661");
INSERT INTO logs VALUES("79","9","enabled API access","::1","1512059557");
INSERT INTO logs VALUES("80","9","enabled API access","::1","1512069192");
INSERT INTO logs VALUES("81","9","Suspended customer ID 10","::1","1512568497");
INSERT INTO logs VALUES("82","9","Re-activated customer ID 10","::1","1512568507");
INSERT INTO logs VALUES("83","9","shared a shortcode with ID: 2","::1","1512654754");
INSERT INTO logs VALUES("84","9","Unassigned shortcode ID 2]","::1","1512655234");
INSERT INTO logs VALUES("85","9","Created a new sms rate","::1","1512657798");
INSERT INTO logs VALUES("86","9","created a new customer with ID 11","::1","1512660356");
INSERT INTO logs VALUES("87","9","Suspended customer ID 11].","::1","1512661318");
INSERT INTO logs VALUES("88","9","Suspended customer ID 11].","::1","1512661410");
INSERT INTO logs VALUES("89","9","Activated customer ID 11].","::1","1512661417");
INSERT INTO logs VALUES("90","9","Deleted customer ID 14].","::1","1512667130");
INSERT INTO logs VALUES("91","9","Created a new sender ID","::1","1512728524");
INSERT INTO logs VALUES("92","9","Created a new sender ID","::1","1512728556");
INSERT INTO logs VALUES("93","9","shared a sender ID: 1","::1","1512728659");
INSERT INTO logs VALUES("94","9","Created a new sms rate","::1","1512735249");
INSERT INTO logs VALUES("95","9","Created a new sms rate","::1","1512738184");
INSERT INTO logs VALUES("96","9","updated sms rate #","::1","1512738207");
INSERT INTO logs VALUES("97","9","Created new sms vouchers","::1","1512741375");
INSERT INTO logs VALUES("98","9","Created new sms vouchers","::1","1512741460");
INSERT INTO logs VALUES("99","9","Created new sms vouchers","::1","1512741788");
INSERT INTO logs VALUES("100","9","Created new sms vouchers","::1","1512746540");
INSERT INTO logs VALUES("101","9","Created new sms plan","::1","1512748850");
INSERT INTO logs VALUES("102","9","Deleted sms vouchers","::1","1512749198");
INSERT INTO logs VALUES("103","9","Created new sms plan","::1","1512749240");
INSERT INTO logs VALUES("104","9","Created new sms plan","::1","1512749270");
INSERT INTO logs VALUES("105","9","Deleted sms plans","::1","1512749285");
INSERT INTO logs VALUES("106","9","Created new sms payment gateway","::1","1512836083");
INSERT INTO logs VALUES("107","9","Created new sms payment gateway","::1","1512913496");
INSERT INTO logs VALUES("108","9","Created new sms payment gateway","::1","1512915279");
INSERT INTO logs VALUES("109","9","Updated account profile","::1","1512932161");
INSERT INTO logs VALUES("110","9","Updated account profile","::1","1512932192");
INSERT INTO logs VALUES("111","9","Updated account profile","::1","1512932221");
INSERT INTO logs VALUES("112","9","Updated account profile","::1","1512932494");
INSERT INTO logs VALUES("113","9","Updated account profile","::1","1512933124");
INSERT INTO logs VALUES("114","9","Updated account profile","::1","1512933285");
INSERT INTO logs VALUES("115","9","Updated account profile","::1","1512933306");
INSERT INTO logs VALUES("116","9","Completed transaction: OnnhWt1512982642 via 3","::1","1512982731");
INSERT INTO logs VALUES("117","9","Initiated an sms message to 2 recipients","::1","1512982820");
INSERT INTO logs VALUES("118","1","Logged into Sendroid Ultimate","::1","1512985682");
INSERT INTO logs VALUES("119","1","Logged into Sendroid Ultimate","::1","1512987501");
INSERT INTO logs VALUES("120","0","Scheduled a message fro 2017-12-11 17:48:00","::1","1513011192");
INSERT INTO logs VALUES("121","0","Created a new contact in phonebook ID 3","::1","1513077036");
INSERT INTO logs VALUES("122","0","Created a new contact in phonebook ID 3","::1","1513077055");
INSERT INTO logs VALUES("123","1","Removed phonebook owner ID 3","::1","1513079240");
INSERT INTO logs VALUES("124","1","shared phonebook ID 3 with chucy03@yahoo.com","::1","1513079890");
INSERT INTO logs VALUES("125","0","Created a phonebook with ID 15","::1","1513082987");
INSERT INTO logs VALUES("126","1","Deleted phonebook ID 14] from phonebooks","::1","1513083035");
INSERT INTO logs VALUES("127","1","Deleted phonebook ID 4] from phonebooks","::1","1513083035");
INSERT INTO logs VALUES("128","0","Created a marketing list with ID 5","::1","1513085048");
INSERT INTO logs VALUES("129","1","shared marketing list ID 5 with chukaokoye@ynetinteractive.com1","::1","1513085066");
INSERT INTO logs VALUES("130","0","Created a new contact in markeing list ID 5","::1","1513085089");
INSERT INTO logs VALUES("131","1","Deleted list ID 3] from marketing list","::1","1513085115");
INSERT INTO logs VALUES("132","0","added a new contact to blacklist: 0993686933","::1","1513085375");
INSERT INTO logs VALUES("133","1","Deleted customer ID 12].","::1","1513087351");
INSERT INTO logs VALUES("134","1","created a new customer with ID 16","::1","1513087493");
INSERT INTO logs VALUES("135","0","Created a new sms rate","::1","1513087651");
INSERT INTO logs VALUES("136","1","Added 122 credits to user ID 16","::1","1513089464");
INSERT INTO logs VALUES("137","1","Updated account profile","::1","1513093244");
INSERT INTO logs VALUES("138","1","Updated account profile","::1","1513093328");
INSERT INTO logs VALUES("139","1","Created a new sender ID","::1","1513097526");
INSERT INTO logs VALUES("140","1","Rejected sender ID 2","::1","1513098082");
INSERT INTO logs VALUES("141","1","Created a marketing list with ID 6","::1","1513099256");
INSERT INTO logs VALUES("142","1","Created new shortcode","::1","1513172946");
INSERT INTO logs VALUES("143","1","Created new shortcode","::1","1513172979");
INSERT INTO logs VALUES("144","1","Created new shortcode","::1","1513172993");
INSERT INTO logs VALUES("145","1","enabled API access","::1","1513179408");
INSERT INTO logs VALUES("146","1","Hourly cron started","::1","1513181544");



DROP TABLE marketingcontacts;

CREATE TABLE `marketingcontacts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL DEFAULT 'No Name',
  `phone` varchar(20) NOT NULL,
  `marketinglist` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO marketingcontacts VALUES("1","No Name","539639733","1");
INSERT INTO marketingcontacts VALUES("2","Abokes Grad","885694443","1");
INSERT INTO marketingcontacts VALUES("3","Ken David","23439639733","2");
INSERT INTO marketingcontacts VALUES("4","Bob Grad","17885694443","1");
INSERT INTO marketingcontacts VALUES("5","James Hag","33462585822","4");
INSERT INTO marketingcontacts VALUES("6","Fednark","342355432","5");



DROP TABLE marketinglist;

CREATE TABLE `marketinglist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `optout_keyword` varchar(100) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(300) NOT NULL,
  `optin_keyword` varchar(111) NOT NULL,
  `optin_message` varchar(555) NOT NULL,
  `optout_message` varchar(555) NOT NULL,
  `shortcode` varchar(111) NOT NULL,
  `default_sender_id` varchar(30) NOT NULL,
  `is_public` int(11) NOT NULL DEFAULT '0',
  `cost` decimal(11,6) NOT NULL DEFAULT '0.000000',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1;

INSERT INTO marketinglist VALUES("1","Car Owners Database","GETIN","0","This is a database of over 250,000 car owners in Nigeria","LEAVEIT","out you go","Welcome \nHere you are","","","1","10.000000");
INSERT INTO marketinglist VALUES("2","School Owners Database","HHT","0","This is a database of over 2,750,000 school owners in Nigeria","GTT","","","","","1","123.000000");
INSERT INTO marketinglist VALUES("4","Cointruce.com","Dont","9","Testing transfer","Send Reso","","","","","0","0.000000");
INSERT INTO marketinglist VALUES("5","Welcome Customers ","LEV","0","This is a list created from admin","JN","You have joined","You have just left","88358583","88358583","0","0.000000");
INSERT INTO marketinglist VALUES("6","Comm TTR454","6757","0","none test","TRER","","","21324242","21324242","1","23.984000");



DROP TABLE marketinglist_owners;

CREATE TABLE `marketinglist_owners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `is_owner` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1;

INSERT INTO marketinglist_owners VALUES("2","2","9","0");
INSERT INTO marketinglist_owners VALUES("6","4","9","1");
INSERT INTO marketinglist_owners VALUES("7","1","0","1");
INSERT INTO marketinglist_owners VALUES("8","5","0","1");
INSERT INTO marketinglist_owners VALUES("9","5","8","0");
INSERT INTO marketinglist_owners VALUES("10","6","0","1");



DROP TABLE messagedetails;

CREATE TABLE `messagedetails` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message_id` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `recipient` varchar(110) NOT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `gateway_id` int(10) NOT NULL DEFAULT '0',
  `country_id` int(10) NOT NULL DEFAULT '0',
  `operator` varchar(100) NOT NULL DEFAULT 'Unknown',
  `date` varchar(20) NOT NULL,
  `sender_id` varchar(20) NOT NULL,
  `cost` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `api_id` varchar(200) NOT NULL DEFAULT '0',
  `dlr` varchar(100) NOT NULL DEFAULT 'pending',
  `notice` text NOT NULL,
  `last_dlr_check` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `datetime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `duration` int(11) NOT NULL DEFAULT '0',
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO messagedetails VALUES("1","1","","6539659689","sent","0","124","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 10:50:38","0","0");
INSERT INTO messagedetails VALUES("2","1","","016927232","sent","0","22","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 09:10:38","0","0");
INSERT INTO messagedetails VALUES("3","1","","639653013","sent","0","22","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 08:09:18","0","0");
INSERT INTO messagedetails VALUES("4","2","","37069173","sent","0","123","Unknown","","","0.074959","sms","0","pending","","0","9","2017-11-13 13:11:12","0","0");
INSERT INTO messagedetails VALUES("5","2","","08368973","failed","0","138","Unknown","","","0.000000","sms","0","pending","","0","9","2017-11-13 14:07:12","0","0");
INSERT INTO messagedetails VALUES("6","2","","22739733","failed","0","124","Unknown","","","0.000000","sms","0","pending","","0","9","2017-11-13 11:15:12","0","0");
INSERT INTO messagedetails VALUES("7","1","","7739703783","canceled","0","124","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 10:50:38","0","2");
INSERT INTO messagedetails VALUES("8","2","","302792323","sent","0","22","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 14:10:38","0","0");
INSERT INTO messagedetails VALUES("9","2","","370362082","sent","0","22","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 12:09:18","0","0");
INSERT INTO messagedetails VALUES("10","1","","739260823","sent","0","123","Unknown","","","0.034992","sms","0","pending","","0","9","2017-11-13 11:11:12","0","0");
INSERT INTO messagedetails VALUES("11","1","","323723-92","failed","0","138","Unknown","","","0.000000","sms","0","pending","Insufficient balance ","0","9","2017-11-13 14:07:12","0","0");
INSERT INTO messagedetails VALUES("12","2","","37023723","failed","0","124","Unknown","","","0.000000","sms","0","pending","Network error","0","9","2017-11-13 11:15:12","0","0");
INSERT INTO messagedetails VALUES("13","3","","739260823","sent","0","123","Unknown","","","3.035000","sms","0","pending","","0","10","2017-11-13 11:11:12","0","0");
INSERT INTO messagedetails VALUES("14","3","","323723-92","sent","0","138","Unknown","","","10.000000","sms","0","pending","","0","10","2017-11-13 14:07:12","0","0");
INSERT INTO messagedetails VALUES("15","3","","37023723","failed","0","124","Unknown","","","0.000000","sms","0","pending","Network error","0","10","2017-11-13 11:15:12","0","0");



DROP TABLE modules;

CREATE TABLE `modules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(333) NOT NULL,
  `url` varchar(333) NOT NULL,
  `is_system` int(11) NOT NULL DEFAULT '1',
  `privileges` varchar(222) NOT NULL DEFAULT '1,',
  `parent_menu` varchar(333) NOT NULL DEFAULT 'root',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE notice;

CREATE TABLE `notice` (
  `id` int(11) NOT NULL COMMENT 'id',
  `customer_id` int(11) NOT NULL DEFAULT '0' COMMENT 'customer_id',
  `note` varchar(4444) NOT NULL COMMENT 'note',
  `is_seen` int(11) NOT NULL DEFAULT '0' COMMENT 'is_seen',
  `date` varchar(77) NOT NULL COMMENT 'date',
  `link` varchar(333) NOT NULL DEFAULT 'index.php'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

INSERT INTO notice VALUES("0","0","Hi. You have just added 0.000  credits to your account","1","1510760605","index.php");
INSERT INTO notice VALUES("0","9","Congratulations! You have just purchased ","1","1511450741","index.php");
INSERT INTO notice VALUES("0","9","Congratulations! You have just purchased ","1","1511450920","index.php");
INSERT INTO notice VALUES("0","9","Congratulations! You have just purchased School Owners Database","1","1511450955","index.php");
INSERT INTO notice VALUES("0","8","Chuka shared an addressbook with you!","1","1511885011","index.php");
INSERT INTO notice VALUES("0","8","chucy03@yahoo.com transfered 0 SMS credits to you!","1","1512046485","index.php");
INSERT INTO notice VALUES("0","8","chucy03@yahoo.com transfered 0 SMS credits to you!","1","1512046598","index.php");
INSERT INTO notice VALUES("0","8","chucy03@yahoo.com transfered 0 SMS credits to you!","1","1512046661","index.php");
INSERT INTO notice VALUES("0","9","Hi. You have just added 300.000 NGN credits to your account","1","1512982731","index.php");
INSERT INTO notice VALUES("0","9","Test shared an addressbook with you!","1","1513079890","index.php");
INSERT INTO notice VALUES("0","8","Test shared a marketing list with you!","1","1513085066","index.php");
INSERT INTO notice VALUES("0","16","Admin added 122 SMS credits to you!","1","1513089464","index.php");



DROP TABLE paymentalerts;

CREATE TABLE `paymentalerts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `depositor` varchar(200) NOT NULL,
  `transaction_id` int(11) NOT NULL DEFAULT '0',
  `paymentgateway_id` varchar(100) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `reference` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE paymentgateway_templates;

CREATE TABLE `paymentgateway_templates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `alias` varchar(300) NOT NULL DEFAULT 'custom',
  `image` varchar(444) NOT NULL,
  `param3_label` varchar(500) NOT NULL,
  `param4_label` varchar(300) NOT NULL,
  `currency_id` varchar(5) NOT NULL DEFAULT '0',
  `param1_label` varchar(113) NOT NULL,
  `param2_label` varchar(113) NOT NULL,
  `hide_pay_button` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO paymentgateway_templates VALUES("1","InterSwitch WebPay","webpay","","","","NGN","Client ID","MAC Key","0");
INSERT INTO paymentgateway_templates VALUES("2","GTPay","gtpay","","","","NGN","Merchant ID","Hash Key","0");
INSERT INTO paymentgateway_templates VALUES("3","Authorize.net","authorizenet","","","","USD","API Login ID","Transaction Key","0");
INSERT INTO paymentgateway_templates VALUES("4","PayPal","paypal","","","","USD","PayPal Email","","0");
INSERT INTO paymentgateway_templates VALUES("5","Custom Gateway","custom","","","","0","","","0");
INSERT INTO paymentgateway_templates VALUES("6","2Checkout","2checkout","","","","USD","API Key","API Secret","0");
INSERT INTO paymentgateway_templates VALUES("7","Quickteller","quickteller","","","","NGN","Payment Code","","0");
INSERT INTO paymentgateway_templates VALUES("8","VoguePay","voguepay","","","","NGN","Merchant ID","","0");
INSERT INTO paymentgateway_templates VALUES("9","Stripe","strip","","","","USD","API Key","","0");
INSERT INTO paymentgateway_templates VALUES("10","PayStack","paystack","","","","NGN","Public Key","Private Key","0");
INSERT INTO paymentgateway_templates VALUES("11","BitPay","bitpay","","","","USD","","","0");



DROP TABLE paymentgateways;

CREATE TABLE `paymentgateways` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `type` varchar(300) NOT NULL DEFAULT 'custom',
  `enabled` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `image` varchar(444) NOT NULL,
  `param1` varchar(444) NOT NULL,
  `param2` mediumtext NOT NULL,
  `param3` varchar(300) NOT NULL,
  `param4` varchar(300) NOT NULL,
  `currency_id` varchar(10) NOT NULL DEFAULT '0',
  `minimum_order` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `maximum_order` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `charges_perc` varchar(33) NOT NULL DEFAULT '0.00',
  `charges_fix` varchar(55) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1;

INSERT INTO paymentgateways VALUES("1","Interswitch","webpay","0","0","0","","","https://connect.interswitchng.com/documentation/getting-started/","webpay.png","1","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("2","GTPay ","gtpay","0","0","0","","","http://www.gtbank.com/gtpay","gtpay.png","1","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("3","PayStack","paystack","1","0","0","sk_test_cfab945e809dd1f57e7c31474f7aae794b95fc80","pk_test_b63bfd2a728ae26a7d54087133f7fb2f4261d5e6","https://www.simplepay.ng","simplepay.png","1","0.000000","0.000000","0","0.00","50.00");
INSERT INTO paymentgateways VALUES("4","PayPal ","paypal","1","0","0","care@ynetinteractive.com","","https://www.paypal.com","paypal.png","2","0.000000","0.000000","0","1.70","0.00");
INSERT INTO paymentgateways VALUES("5","Bank Payment","custom","1","Pay total invoice amount into our bank account. ","1","Pay total invoice amount into our bank account. ","custom.png","","","1","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("6","2Checkout","2checkout","1","0","0","","2checkout.png","https://www.2checkout.com","","2","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("7","Quickteller ","quickteller","1","0","0","","quickteller.png","https://connect.interswitchng.com/documentation/how-to-get-listed/","","1","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("8","VoguePay ","voguepay","1","0","0","","voguepay.png","https://www.voguepay.com","","1","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("9","Stripe","strip","1","0","0","","stripe.png","https://www.stripe.com","","2","0.000000","0.000000","0","0.00","0.00");
INSERT INTO paymentgateways VALUES("10","Paystack","paystack","1","Paystack will process your payment","","pk_test_shdjkhdj827391nV4Lid","sk_test_shdjkhdj827391nV4Lid","","","NGN","10.000000","0.000000","9","0","0.00");
INSERT INTO paymentgateways VALUES("11","GTBank Deposit","custom","1","Pay a total of into\nBank Name: GTB\nNo. 12345678\nTitle: Sendroid Ultimate","","","","","","0","0.000000","0.000000","9","0.00","0.00");



DROP TABLE phonebook_owners;

CREATE TABLE `phonebook_owners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `phonebook_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `is_owner` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1;

INSERT INTO phonebook_owners VALUES("1","1","9","1");
INSERT INTO phonebook_owners VALUES("2","2","9","0");
INSERT INTO phonebook_owners VALUES("15","2","8","1");
INSERT INTO phonebook_owners VALUES("16","3","8","0");
INSERT INTO phonebook_owners VALUES("17","3","9","1");
INSERT INTO phonebook_owners VALUES("18","15","0","1");



DROP TABLE phonebooks;

CREATE TABLE `phonebooks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `birthday_sms` varchar(500) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1;

INSERT INTO phonebooks VALUES("1","First List for Fun Edited","This is just some dummy useless list","Hi. Just to say HBD\nThis now has line 2","9");
INSERT INTO phonebooks VALUES("2","Second List for Fun","This is just another dummy useless list","Hi. Just to say HBD","0");
INSERT INTO phonebooks VALUES("3","First List for Fun","This is just some dummy useless list","Hi. Just to say HBD to you","9");
INSERT INTO phonebooks VALUES("15","Admin Created Phonebook","This is the first address book created from admin","","0");



DROP TABLE rates;

CREATE TABLE `rates` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `country_code` int(11) NOT NULL DEFAULT '0',
  `operator_code` int(11) NOT NULL DEFAULT '0',
  `rate` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(333) NOT NULL DEFAULT 'sms',
  `reseller_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

INSERT INTO rates VALUES("1","0","0","0","1.000000","0","sms","0");
INSERT INTO rates VALUES("2","0","0","0","1.000000","0","mms","0");
INSERT INTO rates VALUES("3","0","0","0","1.000000","0","unicode","0");
INSERT INTO rates VALUES("4","0","0","0","1.000000","0","flash","0");
INSERT INTO rates VALUES("5","0","0","0","1.000000","0","whatsapp","0");
INSERT INTO rates VALUES("6","0","0","0","1.000000","0","voice","0");
INSERT INTO rates VALUES("7","0","234","70","2.500000","0","voice","0");
INSERT INTO rates VALUES("8","0","234","70","2.500000","0","sms","0");
INSERT INTO rates VALUES("9","0","234","80","1.200000","0","sms","0");
INSERT INTO rates VALUES("10","0","93","12","1.500000","0","sms","0");
INSERT INTO rates VALUES("12","10","234","807","2.500000","0","sms","9");
INSERT INTO rates VALUES("13","0","0","56","3.670000","0","whatsapp","9");
INSERT INTO rates VALUES("14","0","0","0","3.080000","0","sms","9");
INSERT INTO rates VALUES("15","15","0","0","2.000000","0","sms","0");



DROP TABLE route_group;

CREATE TABLE `route_group` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(333) NOT NULL,
  `description` varchar(1000) NOT NULL,
  `has_cost` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO route_group VALUES("1","Default Routs","Default routes allows you to assign a Gateway API to specific destination countries or operators. Routes under this group will only be used when the message recipients number matches the specified country or operator code.","0");
INSERT INTO route_group VALUES("2","Special Routes","Special routes allows you to set special routes such as Transnational routes, Corporate Routes, etc.<br>Customers will be able to choose from these routes when sending a message. You can set custom rates for each routes. ","1");



DROP TABLE routes;

CREATE TABLE `routes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(33) NOT NULL DEFAULT 'sms',
  `title` varchar(333) NOT NULL,
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `country_code` int(11) NOT NULL DEFAULT '0',
  `operator_code` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE scheduledmessages;

CREATE TABLE `scheduledmessages` (
  `message` text NOT NULL,
  `sender_id` varchar(15) NOT NULL,
  `recipients` mediumtext NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `customer_id` int(11) NOT NULL,
  `phonebook_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `speed` varchar(300) NOT NULL,
  `media` varchar(500) NOT NULL DEFAULT '',
  `file` varchar(333) NOT NULL,
  `schedule_date` datetime NOT NULL,
  `retry` varchar(30) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `duration` int(11) NOT NULL DEFAULT '0',
  `country` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;

INSERT INTO scheduledmessages VALUES("Tetsing schedule again","Test Sender","+23447746944","2017-11-21 17:57:21","9","0","sms","0","0","queued","","","","2017-11-22 11:50:00","","1","0","3");
INSERT INTO scheduledmessages VALUES("ok","111111","73969373","2017-12-11 17:53:12","0","0","sms","0","0","queued","","http://localhost/Sendroid Ultimate/account/files/temp/","","2017-12-11 17:48:00","","2","0","1");



DROP TABLE sender_id;

CREATE TABLE `sender_id` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `sender_id` varchar(20) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `resold` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;

INSERT INTO sender_id VALUES("1","9","sms","HP Asset","approved","15");
INSERT INTO sender_id VALUES("2","9","voice","+234702554522","rejected","0");
INSERT INTO sender_id VALUES("3","8","voice","Great-M","approved","0");



DROP TABLE sentmessages;

CREATE TABLE `sentmessages` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `sender_id` varchar(29) NOT NULL,
  `recipients` mediumtext NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `phonebook_id` varchar(111) NOT NULL DEFAULT '',
  `marketinglist_id` varchar(111) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `sent_from` varchar(50) NOT NULL DEFAULT 'portal',
  `speed` varchar(110) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT 'Unknown',
  `media` varchar(500) NOT NULL DEFAULT '',
  `notice` varchar(100) NOT NULL DEFAULT '',
  `duration` int(11) NOT NULL,
  `file` varchar(333) NOT NULL,
  `country` int(11) NOT NULL DEFAULT '0',
  `sent_on` datetime NOT NULL,
  `to_count` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1;

INSERT INTO sentmessages VALUES("1","Hi. I am sending this message to say hello. This is just a test message for design","SMS Send","070667354637,08036735737,0793673578,00936736573,0907365765,2340793783","2017-11-14 10:52:35","9","0","0","completed","sms","portal","0","0","Unknown","","","0","","0","0000-00-00 00:00:00","7");
INSERT INTO sentmessages VALUES("2","This is another message. This is an SMS with some text just to test","Sengat","070667354637,08036735737,0793673578,00936736573,0907365765,2340793783","2017-11-13 09:09:00","9","0","0","processing","sms","portal","0","0","Unknown","","","0","","0","0000-00-00 00:00:00","2");
INSERT INTO sentmessages VALUES("3","Hello.\nI am here to test your messages sending platform. This should be saved in DB if all goes well. ","UT Testers","07077365635,8077356373,234709986746,070663357637","2017-11-21 12:51:54","10","","","completed","sms","web","0","0","::1","","","0","","166","0000-00-00 00:00:00","5");
INSERT INTO sentmessages VALUES("4","Test message to scheduled","Sched","+23447746944","2017-11-21 17:51:54","9","","","queued","sms","web","0","0","::1","","","0","","164","0000-00-00 00:00:00","3");
INSERT INTO sentmessages VALUES("5","test","Test ID","935527572,82553753,931233333333","2017-11-21 17:54:52","9","","","queued","","web","0","0","::1","","","0","","1","0000-00-00 00:00:00","3");
INSERT INTO sentmessages VALUES("6","test","Test ID","935527572,82553753,931233333333","2017-11-27 16:36:49","9","","","queued","","web","0","0","::1","","","0","","1","0000-00-00 00:00:00","3");
INSERT INTO sentmessages VALUES("7","Hi\nAre you ok","Check123","","2017-12-11 10:00:20","9","2","","queued","sms","web","0","0","::1","http://localhost/Sendroid Ultimate/account/files/temp/","","0","","166","0000-00-00 00:00:00","2");



DROP TABLE settings;

CREATE TABLE `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `field` varchar(100) NOT NULL,
  `value` text NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=128 DEFAULT CHARSET=latin1;

INSERT INTO settings VALUES("1","siteBackground","background.jpg","0");
INSERT INTO settings VALUES("2","backgroundColor","#f8f8f8","0");
INSERT INTO settings VALUES("3","headerColor","#122","0");
INSERT INTO settings VALUES("5","siteLogo","","0");
INSERT INTO settings VALUES("6","siteName","Sendroid Ultimate","0");
INSERT INTO settings VALUES("8","activeGateway","1","0");
INSERT INTO settings VALUES("13","businessName","Sendroid Ultimate","0");
INSERT INTO settings VALUES("14","companyAddress","Suite 215, Ambeez Plaza, Opposite Ibro Hotels Ltd, Zone 5","0");
INSERT INTO settings VALUES("15","companyEmail","care@ynetinteractive.com","0");
INSERT INTO settings VALUES("16","companyPhone","8035810726","0");
INSERT INTO settings VALUES("17","defaultCurrency","1","0");
INSERT INTO settings VALUES("18","smsSender","SMS Centre","0");
INSERT INTO settings VALUES("19","emailSender","SMS Customer Service","0");
INSERT INTO settings VALUES("20","newAccountSMS","Hi [CUSTOMER NAME].
\nYour SMS account has been created. Your username is [USERNAME] and your password is [PASSWORD].","0");
INSERT INTO settings VALUES("21","newAccountEmail","<p>Hi [CUSTOMER NAME].</p>
\n
\n<p><br />
\nYour SMS account has been created.</p>
\n
\n<p>Your username is [USERNAME] and your password is [PASSWORD].</p>
\n","0");
INSERT INTO settings VALUES("22","newAccountEmailSubject","Welcome To Your New SMS Account","0");
INSERT INTO settings VALUES("23","newPasswordEmailSubject","Your Password Has Been Recovered","0");
INSERT INTO settings VALUES("24","newPasswordSMS","Hi [CUSTOMER NAME].
\nYour login details has been recovered. Your username is [USERNAME] and your new password is [PASSWORD].","0");
INSERT INTO settings VALUES("25","newPasswordEmail","<p>Hi [CUSTOMER NAME].</p>
\n
\n<p><br />
\nYour login details has been recovered.</p>
\n
\n<p>&nbsp;</p>
\n
\n<p>Your username is [USERNAME] and your new password is [PASSWORD].</p>
\n","0");
INSERT INTO settings VALUES("26","testUnits","5","0");
INSERT INTO settings VALUES("27","timeZone","Africa/Lagos","0");
INSERT INTO settings VALUES("28","orderApproveSMS","Hi [CUSTOMER NAME].
\nYour SMS account has been credited with [UNITS] SMS units. Your new balance is [BALANCE].","0");
INSERT INTO settings VALUES("29","orderApproveEmail","<p>Dear [CUSTOMER NAME].</p>
\n
\n<p><br />
\nYour SMS account has been credited with [UNITS] SMS units.</p>
\n
\n<p>Your new balance is [BALANCE].</p>
\n","0");
INSERT INTO settings VALUES("30","orderApproveEmailSubject","Your Order for SMS Units Has Been Approved","0");
INSERT INTO settings VALUES("32","newAdminPasswordEmail","<p>Hi [CUSTOMER NAME],</p>
\n
\n<p>&nbsp;</p>
\n
\n<p>Your Fome SMS Portal Admin access details have been recovered. Here are your new login details:</p>
\n
\n<p><strong>Username: </strong>[USER NAME]</p>
\n
\n<p><strong>Password: </strong>[PASSWORD]</p>
\n
\n<p>&nbsp;</p>
\n
\n<p>&nbsp;</p>
\n","0");
INSERT INTO settings VALUES("33","acompanyEmail","non-reply@fomesmsportal.com","0");
INSERT INTO settings VALUES("37","dynamicSender","1","0");
INSERT INTO settings VALUES("38","invoiceSignature","ignature.png","0");
INSERT INTO settings VALUES("39","taxAmount","5.00","0");
INSERT INTO settings VALUES("40","vatAmount","0.00","0");
INSERT INTO settings VALUES("44","companyWebsite","http://www.sendroid.com","0");
INSERT INTO settings VALUES("45","redirectToSite","0","0");
INSERT INTO settings VALUES("47","smtpServer","","0");
INSERT INTO settings VALUES("48","smtpUsername","","0");
INSERT INTO settings VALUES("49","smtpPassword","","0");
INSERT INTO settings VALUES("50","watsappEnabled","1","0");
INSERT INTO settings VALUES("51","2WaySMSEnabled","1","0");
INSERT INTO settings VALUES("52","MMSEnabled","1","0");
INSERT INTO settings VALUES("53","defaultLanguage","en","0");
INSERT INTO settings VALUES("54","param","","0");
INSERT INTO settings VALUES("56","activeUnicodeGateway","","0");
INSERT INTO settings VALUES("57","activeMMSGateway","","0");
INSERT INTO settings VALUES("58","defaultCountry","1","0");
INSERT INTO settings VALUES("59","active2WaySMSGateway","","0");
INSERT INTO settings VALUES("60","headerFontColor","#ffffff","0");
INSERT INTO settings VALUES("61","phone_verify","0","0");
INSERT INTO settings VALUES("62","facebook_secrete","","0");
INSERT INTO settings VALUES("63","blackListKeyword","BLACKLIST ME","0");
INSERT INTO settings VALUES("64","facebook_api","290349541470756","0");
INSERT INTO settings VALUES("65","email_verify","1","0");
INSERT INTO settings VALUES("66","activeTheme","default","0");
INSERT INTO settings VALUES("71","smtpPort","587","0");
INSERT INTO settings VALUES("72","smtpSecurity","tls","0");
INSERT INTO settings VALUES("73","GOOGLE_OAUTH_CLIENT_SECRET","","0");
INSERT INTO settings VALUES("74","GOOGLE_OAUTH_CLIENT_ID","1049178870057-usbfluijl3qtq3nijmucnsksr9gvkag4","0");
INSERT INTO settings VALUES("75","lastMessageCron","1491824716","0");
INSERT INTO settings VALUES("76","lastBirthdayCron","1491824716","0");
INSERT INTO settings VALUES("77","google_recaptcha_sitekey","6Lc6jBQUAAAAAAG7utiTXA8rXMbNAzORHHy4D3S2","0");
INSERT INTO settings VALUES("78","google_recaptcha_secret","6Lc6jBQUAAAAALWSkUEnhriOiGXkrkfMP7Rp8M5E","0");
INSERT INTO settings VALUES("79","use_facebook","1","0");
INSERT INTO settings VALUES("80","use_google","0","0");
INSERT INTO settings VALUES("81","unicodeEnabled","1","0");
INSERT INTO settings VALUES("82","voiceEnabled","1","0");
INSERT INTO settings VALUES("85","2wayEnabled","1","0");
INSERT INTO settings VALUES("86","flashEnabled","1","0");
INSERT INTO settings VALUES("87","saleContactEnabled","1","0");
INSERT INTO settings VALUES("88","affiliateEnabled","1","0");
INSERT INTO settings VALUES("89","shareCreditEnabled","1","0");
INSERT INTO settings VALUES("90","dynamicSenderEnabled","1","0");
INSERT INTO settings VALUES("91","minCreditOrder","0","0");
INSERT INTO settings VALUES("92","useSMSPackage","1","0");
INSERT INTO settings VALUES("93","useSMSVoucher","1","0");
INSERT INTO settings VALUES("94","affiliatePayType","percent","0");
INSERT INTO settings VALUES("95","affiliatePayValue","5","0");
INSERT INTO settings VALUES("96","resellerDomain","127.0.0.1","9");
INSERT INTO settings VALUES("99","useSMSVoucher","1","9");
INSERT INTO settings VALUES("100","useSMSPackage","1","9");
INSERT INTO settings VALUES("101","businessName","Ynet Interactive","9");
INSERT INTO settings VALUES("102","companyAddress","Suite 215, Ambeez Plaza","9");
INSERT INTO settings VALUES("103","companyEmail","chukaokoye@ynetinteractive.com","9");
INSERT INTO settings VALUES("104","companyPhone","+2348035810726","9");
INSERT INTO settings VALUES("105","companyWebsite","http://www.ecloudsms.com","9");
INSERT INTO settings VALUES("106","invoiceSignature","1512756688.9028.png","9");
INSERT INTO settings VALUES("107","siteBackground","1512756742.7191.jpg","9");
INSERT INTO settings VALUES("108","siteLogo","1512756755.4472.png","9");
INSERT INTO settings VALUES("109","backgroundColor","#52a42b","9");
INSERT INTO settings VALUES("110","headerColor","#217c25","9");
INSERT INTO settings VALUES("111","redirectToSite","1","9");
INSERT INTO settings VALUES("112","taxAmount","4","9");
INSERT INTO settings VALUES("113","vatAmount","6","9");
INSERT INTO settings VALUES("114","smtpServer","mail.localtextmarketing.com","9");
INSERT INTO settings VALUES("115","smtpUsername","support@localtextmarketing.com","9");
INSERT INTO settings VALUES("116","smtpPassword","hq92SZpg74","9");
INSERT INTO settings VALUES("117","smtpPort","587","9");
INSERT INTO settings VALUES("118","smtpSecurity","tls","9");
INSERT INTO settings VALUES("119","newAccountSMS","Welcomer on","9");
INSERT INTO settings VALUES("120","newAccountEmail","Testing email now","9");
INSERT INTO settings VALUES("121","newPasswordSMS","Password change","9");
INSERT INTO settings VALUES("122","newAccountEmailSubject","Welcome to Reseller","9");
INSERT INTO settings VALUES("123","newPasswordEmailSubject","Here is your new password","9");
INSERT INTO settings VALUES("124","newPasswordEmail","<p>Your password has changed</p>","9");
INSERT INTO settings VALUES("125","orderApproveEmailSubject","Thrasnaction Copmpleted","9");
INSERT INTO settings VALUES("126","orderApproveEmail","<p>Order confirmed</p>","9");
INSERT INTO settings VALUES("127","orderApproveSMS","Order confirmed","9");



DROP TABLE shortcodes;

CREATE TABLE `shortcodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `shortcode` varchar(33) NOT NULL,
  `cost` decimal(11,4) NOT NULL DEFAULT '0.0000',
  `billing` int(11) NOT NULL DEFAULT '1',
  `is_public` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL,
  `resold` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO shortcodes VALUES("1","0","880767333","0.8000","1","0","0000-00-00 00:00:00","0");
INSERT INTO shortcodes VALUES("2","10","23477892633","1.4500","1","0","2017-12-29 13:06:18","0");
INSERT INTO shortcodes VALUES("3","0","91152232","0.0000","1","1","2017-12-13 14:49:05","0");
INSERT INTO shortcodes VALUES("4","0","4543465342","0.0000","1","0","2017-12-13 14:49:39","0");
INSERT INTO shortcodes VALUES("5","10","5643564324","2.1000","1","0","2017-12-13 14:49:52","0");



DROP TABLE sms_gateways;

CREATE TABLE `sms_gateways` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `base_url` text NOT NULL,
  `success_word` varchar(100) NOT NULL,
  `json_encode` int(11) NOT NULL,
  `request_type` varchar(20) NOT NULL DEFAULT 'GET',
  `sender_field` text NOT NULL,
  `recipient_field` text NOT NULL,
  `message_field` text NOT NULL,
  `param1_field` text NOT NULL,
  `param2_field` text NOT NULL,
  `param3_field` text NOT NULL,
  `param4_field` text NOT NULL,
  `param1_value` text NOT NULL,
  `param2_value` text NOT NULL,
  `param3_value` text NOT NULL,
  `param4_value` text NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `language_field` text NOT NULL,
  `audio_field` text NOT NULL,
  `timeout_field` text NOT NULL,
  `speed_field` text NOT NULL,
  `authentication` text NOT NULL,
  `base64_encode` int(11) NOT NULL,
  `success_logic` varchar(333) NOT NULL DEFAULT 'contain',
  `dlr_enabled` int(11) NOT NULL DEFAULT '0',
  `dlr_callback` varchar(555) NOT NULL,
  `param5_field` varchar(555) NOT NULL,
  `param5_value` varchar(555) NOT NULL,
  `tts_enabled` int(11) NOT NULL DEFAULT '0',
  `file_enabled` int(11) NOT NULL DEFAULT '0',
  `cutting_limit` int(11) NOT NULL DEFAULT '0',
  `hour_limit` int(11) NOT NULL DEFAULT '0',
  `cutting_percent` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE sms_plans;

CREATE TABLE `sms_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(444) NOT NULL,
  `price` varchar(333) NOT NULL,
  `credits` varchar(44) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `validity` int(11) NOT NULL DEFAULT '0',
  `recommend` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;

INSERT INTO sms_plans VALUES("1","Standard SMS Pack","10000","12000","0","0","0");
INSERT INTO sms_plans VALUES("2","Premium SMS Pack","50000","70000","0","0","0");
INSERT INTO sms_plans VALUES("4","Standard SMS Pack","1800","2000","9","30","0");
INSERT INTO sms_plans VALUES("5","Regular SMS plan","1000","1200","9","20","0");



DROP TABLE temp_jobs;

CREATE TABLE `temp_jobs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `sender_id` varchar(15) NOT NULL,
  `recipients` mediumtext NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `phonebook_id` int(11) NOT NULL DEFAULT '0',
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `sent_from` varchar(50) NOT NULL DEFAULT 'portal',
  `speed` varchar(110) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT 'Unknown',
  `media` varchar(500) NOT NULL DEFAULT '',
  `notice` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;




DROP TABLE themes;

CREATE TABLE `themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `author` varchar(100) NOT NULL,
  `image` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO themes VALUES("1","Sendroid Default","default","Ynet Interactive","../themes/default/preview.png");
INSERT INTO themes VALUES("2","Sendroid Default","default","Ynet Interactive","../themes/default/preview.png");
INSERT INTO themes VALUES("3","Sendroid Default","default","Ynet Interactive","../themes/default/preview.png");
INSERT INTO themes VALUES("4","Sendroid Default","default","Ynet Interactive","../themes/default/preview.png");



DROP TABLE tickets;

CREATE TABLE `tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
  `admin_reply` int(11) NOT NULL DEFAULT '0',
  `customer_reply` int(11) NOT NULL DEFAULT '0',
  `subject` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `status` varchar(50) NOT NULL DEFAULT 'open',
  `department` varchar(200) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `last_updated` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;

INSERT INTO tickets VALUES("1","9","0","1","How The support ticket appears","<b>Ok</b><br>
\nThis is just another ticket
\n<p>This shouldnt be an issue</p>","2017-12-01 14:08:47","open","","0","2017-12-01 14:15:43");
INSERT INTO tickets VALUES("2","9","1","0","This is how it will look","<b>Ok</b><br>
\nThis is just another ticket
\n<p>This shouldnt be an issue</p>","2017-12-01 12:08:47","answered","","0","2017-12-12 16:29:49");
INSERT INTO tickets VALUES("3","9","1","0","This is how it will look","<b>Ok</b><br>
\nThis is just another ticket
\n<p>This shouldnt be an issue</p>","2017-12-01 12:08:47","","","1","2017-12-01 13:15:43");
INSERT INTO tickets VALUES("4","9","0","1","This is how it will look","That is true","2017-12-01 16:13:15","customer-reply","","2","2017-12-01 16:13:15");
INSERT INTO tickets VALUES("5","9","0","1","This is how it will look","No comments","2017-12-01 16:14:20","customer-reply","","2","2017-12-01 16:14:20");
INSERT INTO tickets VALUES("6","9","1","0","This is how it will look","Ok. Fine i will live it","2017-12-01 16:15:02","customer-reply","","2","2017-12-01 16:15:02");
INSERT INTO tickets VALUES("7","10","1","0","Why is the action buttons working now please","<p>Hi.</p><p>I tested this feature before and it didnt work but now i see it works just fine.&nbsp;</p><p>Let me know what changed so i can work on it.&nbsp;</p>","2017-12-02 12:03:41","answered","","0","2017-12-11 10:12:05");
INSERT INTO tickets VALUES("8","0","1","0","Why is this not working?","<p>Hi</p><p>Can you take a look please</p>","2017-12-02 12:07:10","open","","0","2017-12-02 12:07:10");
INSERT INTO tickets VALUES("9","9","0","1","Whis is it still not working","<p>Please take a look again</p><p>It is still not working</p>","2017-12-02 12:07:43","open","","0","2017-12-02 12:07:43");
INSERT INTO tickets VALUES("10","10","1","0","Hi James. This is working","<p>Hi.</p><p>Just to let you know that is is finnally woring</p>","2017-12-03 17:38:36","open","","0","2017-12-03 17:38:36");
INSERT INTO tickets VALUES("11","10","1","0","Why is the action buttons working now please","<p>Please check again</p>","2017-12-03 17:44:58","answered","","7","2017-12-03 17:44:58");
INSERT INTO tickets VALUES("12","10","0","1","Why is the action buttons working now please","<p>Ok. It looks fine now.</p><p>Who is my account manager?</p>","2017-12-07 14:40:15","customer-reply","","7","2017-12-07 14:40:15");
INSERT INTO tickets VALUES("13","10","1","0","Why is the action buttons working now please","<p>Ok. Glad we could help</p>","2017-12-11 10:12:05","answered","","7","2017-12-11 10:12:05");
INSERT INTO tickets VALUES("14","16","1","0","Regarding message from brycejeje@gmail.com","<p>Hi Gearge</p><p>Hopw you are now able to login. You can also visit <a href=\"http://www.ynetinteractive.com\" target=\"_blank\">http://www.ynetinteractive.com</a> to see how it works</p>","2017-12-12 15:51:42","answered","","0","2017-12-12 16:07:04");
INSERT INTO tickets VALUES("15","16","1","0","Regarding message from brycejeje@gmail.com","<p>Ok.</p><p>Dont forget to let us know too</p>","2017-12-12 16:07:04","answered","","14","2017-12-12 16:07:04");
INSERT INTO tickets VALUES("16","9","1","0","This is how it will look","<p>Ok</p>","2017-12-12 16:29:49","answered","","2","2017-12-12 16:29:49");



DROP TABLE time_zone;

CREATE TABLE `time_zone` (
  `zone_id` int(10) NOT NULL AUTO_INCREMENT,
  `country_code` char(2) COLLATE utf8_bin NOT NULL,
  `zone_name` varchar(35) COLLATE utf8_bin NOT NULL,
  PRIMARY KEY (`zone_id`),
  KEY `idx_country_code` (`country_code`),
  KEY `idx_zone_name` (`zone_name`)
) ENGINE=MyISAM AUTO_INCREMENT=425 DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO time_zone VALUES("1","AD","Europe/Andorra");
INSERT INTO time_zone VALUES("2","AE","Asia/Dubai");
INSERT INTO time_zone VALUES("3","AF","Asia/Kabul");
INSERT INTO time_zone VALUES("4","AG","America/Antigua");
INSERT INTO time_zone VALUES("5","AI","America/Anguilla");
INSERT INTO time_zone VALUES("6","AL","Europe/Tirane");
INSERT INTO time_zone VALUES("7","AM","Asia/Yerevan");
INSERT INTO time_zone VALUES("8","AO","Africa/Luanda");
INSERT INTO time_zone VALUES("9","AQ","Antarctica/McMurdo");
INSERT INTO time_zone VALUES("10","AQ","Antarctica/Casey");
INSERT INTO time_zone VALUES("11","AQ","Antarctica/Davis");
INSERT INTO time_zone VALUES("12","AQ","Antarctica/DumontDUrville");
INSERT INTO time_zone VALUES("13","AQ","Antarctica/Mawson");
INSERT INTO time_zone VALUES("14","AQ","Antarctica/Palmer");
INSERT INTO time_zone VALUES("15","AQ","Antarctica/Rothera");
INSERT INTO time_zone VALUES("16","AQ","Antarctica/Syowa");
INSERT INTO time_zone VALUES("17","AQ","Antarctica/Troll");
INSERT INTO time_zone VALUES("18","AQ","Antarctica/Vostok");
INSERT INTO time_zone VALUES("19","AR","America/Argentina/Buenos_Aires");
INSERT INTO time_zone VALUES("20","AR","America/Argentina/Cordoba");
INSERT INTO time_zone VALUES("21","AR","America/Argentina/Salta");
INSERT INTO time_zone VALUES("22","AR","America/Argentina/Jujuy");
INSERT INTO time_zone VALUES("23","AR","America/Argentina/Tucuman");
INSERT INTO time_zone VALUES("24","AR","America/Argentina/Catamarca");
INSERT INTO time_zone VALUES("25","AR","America/Argentina/La_Rioja");
INSERT INTO time_zone VALUES("26","AR","America/Argentina/San_Juan");
INSERT INTO time_zone VALUES("27","AR","America/Argentina/Mendoza");
INSERT INTO time_zone VALUES("28","AR","America/Argentina/San_Luis");
INSERT INTO time_zone VALUES("29","AR","America/Argentina/Rio_Gallegos");
INSERT INTO time_zone VALUES("30","AR","America/Argentina/Ushuaia");
INSERT INTO time_zone VALUES("31","AS","Pacific/Pago_Pago");
INSERT INTO time_zone VALUES("32","AT","Europe/Vienna");
INSERT INTO time_zone VALUES("33","AU","Australia/Lord_Howe");
INSERT INTO time_zone VALUES("34","AU","Antarctica/Macquarie");
INSERT INTO time_zone VALUES("35","AU","Australia/Hobart");
INSERT INTO time_zone VALUES("36","AU","Australia/Currie");
INSERT INTO time_zone VALUES("37","AU","Australia/Melbourne");
INSERT INTO time_zone VALUES("38","AU","Australia/Sydney");
INSERT INTO time_zone VALUES("39","AU","Australia/Broken_Hill");
INSERT INTO time_zone VALUES("40","AU","Australia/Brisbane");
INSERT INTO time_zone VALUES("41","AU","Australia/Lindeman");
INSERT INTO time_zone VALUES("42","AU","Australia/Adelaide");
INSERT INTO time_zone VALUES("43","AU","Australia/Darwin");
INSERT INTO time_zone VALUES("44","AU","Australia/Perth");
INSERT INTO time_zone VALUES("45","AU","Australia/Eucla");
INSERT INTO time_zone VALUES("46","AW","America/Aruba");
INSERT INTO time_zone VALUES("47","AX","Europe/Mariehamn");
INSERT INTO time_zone VALUES("48","AZ","Asia/Baku");
INSERT INTO time_zone VALUES("49","BA","Europe/Sarajevo");
INSERT INTO time_zone VALUES("50","BB","America/Barbados");
INSERT INTO time_zone VALUES("51","BD","Asia/Dhaka");
INSERT INTO time_zone VALUES("52","BE","Europe/Brussels");
INSERT INTO time_zone VALUES("53","BF","Africa/Ouagadougou");
INSERT INTO time_zone VALUES("54","BG","Europe/Sofia");
INSERT INTO time_zone VALUES("55","BH","Asia/Bahrain");
INSERT INTO time_zone VALUES("56","BI","Africa/Bujumbura");
INSERT INTO time_zone VALUES("57","BJ","Africa/Porto-Novo");
INSERT INTO time_zone VALUES("58","BL","America/St_Barthelemy");
INSERT INTO time_zone VALUES("59","BM","Atlantic/Bermuda");
INSERT INTO time_zone VALUES("60","BN","Asia/Brunei");
INSERT INTO time_zone VALUES("61","BO","America/La_Paz");
INSERT INTO time_zone VALUES("62","BQ","America/Kralendijk");
INSERT INTO time_zone VALUES("63","BR","America/Noronha");
INSERT INTO time_zone VALUES("64","BR","America/Belem");
INSERT INTO time_zone VALUES("65","BR","America/Fortaleza");
INSERT INTO time_zone VALUES("66","BR","America/Recife");
INSERT INTO time_zone VALUES("67","BR","America/Araguaina");
INSERT INTO time_zone VALUES("68","BR","America/Maceio");
INSERT INTO time_zone VALUES("69","BR","America/Bahia");
INSERT INTO time_zone VALUES("70","BR","America/Sao_Paulo");
INSERT INTO time_zone VALUES("71","BR","America/Campo_Grande");
INSERT INTO time_zone VALUES("72","BR","America/Cuiaba");
INSERT INTO time_zone VALUES("73","BR","America/Santarem");
INSERT INTO time_zone VALUES("74","BR","America/Porto_Velho");
INSERT INTO time_zone VALUES("75","BR","America/Boa_Vista");
INSERT INTO time_zone VALUES("76","BR","America/Manaus");
INSERT INTO time_zone VALUES("77","BR","America/Eirunepe");
INSERT INTO time_zone VALUES("78","BR","America/Rio_Branco");
INSERT INTO time_zone VALUES("79","BS","America/Nassau");
INSERT INTO time_zone VALUES("80","BT","Asia/Thimphu");
INSERT INTO time_zone VALUES("81","BW","Africa/Gaborone");
INSERT INTO time_zone VALUES("82","BY","Europe/Minsk");
INSERT INTO time_zone VALUES("83","BZ","America/Belize");
INSERT INTO time_zone VALUES("84","CA","America/St_Johns");
INSERT INTO time_zone VALUES("85","CA","America/Halifax");
INSERT INTO time_zone VALUES("86","CA","America/Glace_Bay");
INSERT INTO time_zone VALUES("87","CA","America/Moncton");
INSERT INTO time_zone VALUES("88","CA","America/Goose_Bay");
INSERT INTO time_zone VALUES("89","CA","America/Blanc-Sablon");
INSERT INTO time_zone VALUES("90","CA","America/Toronto");
INSERT INTO time_zone VALUES("91","CA","America/Nipigon");
INSERT INTO time_zone VALUES("92","CA","America/Thunder_Bay");
INSERT INTO time_zone VALUES("93","CA","America/Iqaluit");
INSERT INTO time_zone VALUES("94","CA","America/Pangnirtung");
INSERT INTO time_zone VALUES("95","CA","America/Atikokan");
INSERT INTO time_zone VALUES("96","CA","America/Winnipeg");
INSERT INTO time_zone VALUES("97","CA","America/Rainy_River");
INSERT INTO time_zone VALUES("98","CA","America/Resolute");
INSERT INTO time_zone VALUES("99","CA","America/Rankin_Inlet");
INSERT INTO time_zone VALUES("100","CA","America/Regina");
INSERT INTO time_zone VALUES("101","CA","America/Swift_Current");
INSERT INTO time_zone VALUES("102","CA","America/Edmonton");
INSERT INTO time_zone VALUES("103","CA","America/Cambridge_Bay");
INSERT INTO time_zone VALUES("104","CA","America/Yellowknife");
INSERT INTO time_zone VALUES("105","CA","America/Inuvik");
INSERT INTO time_zone VALUES("106","CA","America/Creston");
INSERT INTO time_zone VALUES("107","CA","America/Dawson_Creek");
INSERT INTO time_zone VALUES("108","CA","America/Fort_Nelson");
INSERT INTO time_zone VALUES("109","CA","America/Vancouver");
INSERT INTO time_zone VALUES("110","CA","America/Whitehorse");
INSERT INTO time_zone VALUES("111","CA","America/Dawson");
INSERT INTO time_zone VALUES("112","CC","Indian/Cocos");
INSERT INTO time_zone VALUES("113","CD","Africa/Kinshasa");
INSERT INTO time_zone VALUES("114","CD","Africa/Lubumbashi");
INSERT INTO time_zone VALUES("115","CF","Africa/Bangui");
INSERT INTO time_zone VALUES("116","CG","Africa/Brazzaville");
INSERT INTO time_zone VALUES("117","CH","Europe/Zurich");
INSERT INTO time_zone VALUES("118","CI","Africa/Abidjan");
INSERT INTO time_zone VALUES("119","CK","Pacific/Rarotonga");
INSERT INTO time_zone VALUES("120","CL","America/Santiago");
INSERT INTO time_zone VALUES("121","CL","America/Punta_Arenas");
INSERT INTO time_zone VALUES("122","CL","Pacific/Easter");
INSERT INTO time_zone VALUES("123","CM","Africa/Douala");
INSERT INTO time_zone VALUES("124","CN","Asia/Shanghai");
INSERT INTO time_zone VALUES("125","CN","Asia/Urumqi");
INSERT INTO time_zone VALUES("126","CO","America/Bogota");
INSERT INTO time_zone VALUES("127","CR","America/Costa_Rica");
INSERT INTO time_zone VALUES("128","CU","America/Havana");
INSERT INTO time_zone VALUES("129","CV","Atlantic/Cape_Verde");
INSERT INTO time_zone VALUES("130","CW","America/Curacao");
INSERT INTO time_zone VALUES("131","CX","Indian/Christmas");
INSERT INTO time_zone VALUES("132","CY","Asia/Nicosia");
INSERT INTO time_zone VALUES("133","CY","Asia/Famagusta");
INSERT INTO time_zone VALUES("134","CZ","Europe/Prague");
INSERT INTO time_zone VALUES("135","DE","Europe/Berlin");
INSERT INTO time_zone VALUES("136","DE","Europe/Busingen");
INSERT INTO time_zone VALUES("137","DJ","Africa/Djibouti");
INSERT INTO time_zone VALUES("138","DK","Europe/Copenhagen");
INSERT INTO time_zone VALUES("139","DM","America/Dominica");
INSERT INTO time_zone VALUES("140","DO","America/Santo_Domingo");
INSERT INTO time_zone VALUES("141","DZ","Africa/Algiers");
INSERT INTO time_zone VALUES("142","EC","America/Guayaquil");
INSERT INTO time_zone VALUES("143","EC","Pacific/Galapagos");
INSERT INTO time_zone VALUES("144","EE","Europe/Tallinn");
INSERT INTO time_zone VALUES("145","EG","Africa/Cairo");
INSERT INTO time_zone VALUES("146","EH","Africa/El_Aaiun");
INSERT INTO time_zone VALUES("147","ER","Africa/Asmara");
INSERT INTO time_zone VALUES("148","ES","Europe/Madrid");
INSERT INTO time_zone VALUES("149","ES","Africa/Ceuta");
INSERT INTO time_zone VALUES("150","ES","Atlantic/Canary");
INSERT INTO time_zone VALUES("151","ET","Africa/Addis_Ababa");
INSERT INTO time_zone VALUES("152","FI","Europe/Helsinki");
INSERT INTO time_zone VALUES("153","FJ","Pacific/Fiji");
INSERT INTO time_zone VALUES("154","FK","Atlantic/Stanley");
INSERT INTO time_zone VALUES("155","FM","Pacific/Chuuk");
INSERT INTO time_zone VALUES("156","FM","Pacific/Pohnpei");
INSERT INTO time_zone VALUES("157","FM","Pacific/Kosrae");
INSERT INTO time_zone VALUES("158","FO","Atlantic/Faroe");
INSERT INTO time_zone VALUES("159","FR","Europe/Paris");
INSERT INTO time_zone VALUES("160","GA","Africa/Libreville");
INSERT INTO time_zone VALUES("161","GB","Europe/London");
INSERT INTO time_zone VALUES("162","GD","America/Grenada");
INSERT INTO time_zone VALUES("163","GE","Asia/Tbilisi");
INSERT INTO time_zone VALUES("164","GF","America/Cayenne");
INSERT INTO time_zone VALUES("165","GG","Europe/Guernsey");
INSERT INTO time_zone VALUES("166","GH","Africa/Accra");
INSERT INTO time_zone VALUES("167","GI","Europe/Gibraltar");
INSERT INTO time_zone VALUES("168","GL","America/Godthab");
INSERT INTO time_zone VALUES("169","GL","America/Danmarkshavn");
INSERT INTO time_zone VALUES("170","GL","America/Scoresbysund");
INSERT INTO time_zone VALUES("171","GL","America/Thule");
INSERT INTO time_zone VALUES("172","GM","Africa/Banjul");
INSERT INTO time_zone VALUES("173","GN","Africa/Conakry");
INSERT INTO time_zone VALUES("174","GP","America/Guadeloupe");
INSERT INTO time_zone VALUES("175","GQ","Africa/Malabo");
INSERT INTO time_zone VALUES("176","GR","Europe/Athens");
INSERT INTO time_zone VALUES("177","GS","Atlantic/South_Georgia");
INSERT INTO time_zone VALUES("178","GT","America/Guatemala");
INSERT INTO time_zone VALUES("179","GU","Pacific/Guam");
INSERT INTO time_zone VALUES("180","GW","Africa/Bissau");
INSERT INTO time_zone VALUES("181","GY","America/Guyana");
INSERT INTO time_zone VALUES("182","HK","Asia/Hong_Kong");
INSERT INTO time_zone VALUES("183","HN","America/Tegucigalpa");
INSERT INTO time_zone VALUES("184","HR","Europe/Zagreb");
INSERT INTO time_zone VALUES("185","HT","America/Port-au-Prince");
INSERT INTO time_zone VALUES("186","HU","Europe/Budapest");
INSERT INTO time_zone VALUES("187","ID","Asia/Jakarta");
INSERT INTO time_zone VALUES("188","ID","Asia/Pontianak");
INSERT INTO time_zone VALUES("189","ID","Asia/Makassar");
INSERT INTO time_zone VALUES("190","ID","Asia/Jayapura");
INSERT INTO time_zone VALUES("191","IE","Europe/Dublin");
INSERT INTO time_zone VALUES("192","IL","Asia/Jerusalem");
INSERT INTO time_zone VALUES("193","IM","Europe/Isle_of_Man");
INSERT INTO time_zone VALUES("194","IN","Asia/Kolkata");
INSERT INTO time_zone VALUES("195","IO","Indian/Chagos");
INSERT INTO time_zone VALUES("196","IQ","Asia/Baghdad");
INSERT INTO time_zone VALUES("197","IR","Asia/Tehran");
INSERT INTO time_zone VALUES("198","IS","Atlantic/Reykjavik");
INSERT INTO time_zone VALUES("199","IT","Europe/Rome");
INSERT INTO time_zone VALUES("200","JE","Europe/Jersey");
INSERT INTO time_zone VALUES("201","JM","America/Jamaica");
INSERT INTO time_zone VALUES("202","JO","Asia/Amman");
INSERT INTO time_zone VALUES("203","JP","Asia/Tokyo");
INSERT INTO time_zone VALUES("204","KE","Africa/Nairobi");
INSERT INTO time_zone VALUES("205","KG","Asia/Bishkek");
INSERT INTO time_zone VALUES("206","KH","Asia/Phnom_Penh");
INSERT INTO time_zone VALUES("207","KI","Pacific/Tarawa");
INSERT INTO time_zone VALUES("208","KI","Pacific/Enderbury");
INSERT INTO time_zone VALUES("209","KI","Pacific/Kiritimati");
INSERT INTO time_zone VALUES("210","KM","Indian/Comoro");
INSERT INTO time_zone VALUES("211","KN","America/St_Kitts");
INSERT INTO time_zone VALUES("212","KP","Asia/Pyongyang");
INSERT INTO time_zone VALUES("213","KR","Asia/Seoul");
INSERT INTO time_zone VALUES("214","KW","Asia/Kuwait");
INSERT INTO time_zone VALUES("215","KY","America/Cayman");
INSERT INTO time_zone VALUES("216","KZ","Asia/Almaty");
INSERT INTO time_zone VALUES("217","KZ","Asia/Qyzylorda");
INSERT INTO time_zone VALUES("218","KZ","Asia/Aqtobe");
INSERT INTO time_zone VALUES("219","KZ","Asia/Aqtau");
INSERT INTO time_zone VALUES("220","KZ","Asia/Atyrau");
INSERT INTO time_zone VALUES("221","KZ","Asia/Oral");
INSERT INTO time_zone VALUES("222","LA","Asia/Vientiane");
INSERT INTO time_zone VALUES("223","LB","Asia/Beirut");
INSERT INTO time_zone VALUES("224","LC","America/St_Lucia");
INSERT INTO time_zone VALUES("225","LI","Europe/Vaduz");
INSERT INTO time_zone VALUES("226","LK","Asia/Colombo");
INSERT INTO time_zone VALUES("227","LR","Africa/Monrovia");
INSERT INTO time_zone VALUES("228","LS","Africa/Maseru");
INSERT INTO time_zone VALUES("229","LT","Europe/Vilnius");
INSERT INTO time_zone VALUES("230","LU","Europe/Luxembourg");
INSERT INTO time_zone VALUES("231","LV","Europe/Riga");
INSERT INTO time_zone VALUES("232","LY","Africa/Tripoli");
INSERT INTO time_zone VALUES("233","MA","Africa/Casablanca");
INSERT INTO time_zone VALUES("234","MC","Europe/Monaco");
INSERT INTO time_zone VALUES("235","MD","Europe/Chisinau");
INSERT INTO time_zone VALUES("236","ME","Europe/Podgorica");
INSERT INTO time_zone VALUES("237","MF","America/Marigot");
INSERT INTO time_zone VALUES("238","MG","Indian/Antananarivo");
INSERT INTO time_zone VALUES("239","MH","Pacific/Majuro");
INSERT INTO time_zone VALUES("240","MH","Pacific/Kwajalein");
INSERT INTO time_zone VALUES("241","MK","Europe/Skopje");
INSERT INTO time_zone VALUES("242","ML","Africa/Bamako");
INSERT INTO time_zone VALUES("243","MM","Asia/Yangon");
INSERT INTO time_zone VALUES("244","MN","Asia/Ulaanbaatar");
INSERT INTO time_zone VALUES("245","MN","Asia/Hovd");
INSERT INTO time_zone VALUES("246","MN","Asia/Choibalsan");
INSERT INTO time_zone VALUES("247","MO","Asia/Macau");
INSERT INTO time_zone VALUES("248","MP","Pacific/Saipan");
INSERT INTO time_zone VALUES("249","MQ","America/Martinique");
INSERT INTO time_zone VALUES("250","MR","Africa/Nouakchott");
INSERT INTO time_zone VALUES("251","MS","America/Montserrat");
INSERT INTO time_zone VALUES("252","MT","Europe/Malta");
INSERT INTO time_zone VALUES("253","MU","Indian/Mauritius");
INSERT INTO time_zone VALUES("254","MV","Indian/Maldives");
INSERT INTO time_zone VALUES("255","MW","Africa/Blantyre");
INSERT INTO time_zone VALUES("256","MX","America/Mexico_City");
INSERT INTO time_zone VALUES("257","MX","America/Cancun");
INSERT INTO time_zone VALUES("258","MX","America/Merida");
INSERT INTO time_zone VALUES("259","MX","America/Monterrey");
INSERT INTO time_zone VALUES("260","MX","America/Matamoros");
INSERT INTO time_zone VALUES("261","MX","America/Mazatlan");
INSERT INTO time_zone VALUES("262","MX","America/Chihuahua");
INSERT INTO time_zone VALUES("263","MX","America/Ojinaga");
INSERT INTO time_zone VALUES("264","MX","America/Hermosillo");
INSERT INTO time_zone VALUES("265","MX","America/Tijuana");
INSERT INTO time_zone VALUES("266","MX","America/Bahia_Banderas");
INSERT INTO time_zone VALUES("267","MY","Asia/Kuala_Lumpur");
INSERT INTO time_zone VALUES("268","MY","Asia/Kuching");
INSERT INTO time_zone VALUES("269","MZ","Africa/Maputo");
INSERT INTO time_zone VALUES("270","NA","Africa/Windhoek");
INSERT INTO time_zone VALUES("271","NC","Pacific/Noumea");
INSERT INTO time_zone VALUES("272","NE","Africa/Niamey");
INSERT INTO time_zone VALUES("273","NF","Pacific/Norfolk");
INSERT INTO time_zone VALUES("274","NG","Africa/Lagos");
INSERT INTO time_zone VALUES("275","NI","America/Managua");
INSERT INTO time_zone VALUES("276","NL","Europe/Amsterdam");
INSERT INTO time_zone VALUES("277","NO","Europe/Oslo");
INSERT INTO time_zone VALUES("278","NP","Asia/Kathmandu");
INSERT INTO time_zone VALUES("279","NR","Pacific/Nauru");
INSERT INTO time_zone VALUES("280","NU","Pacific/Niue");
INSERT INTO time_zone VALUES("281","NZ","Pacific/Auckland");
INSERT INTO time_zone VALUES("282","NZ","Pacific/Chatham");
INSERT INTO time_zone VALUES("283","OM","Asia/Muscat");
INSERT INTO time_zone VALUES("284","PA","America/Panama");
INSERT INTO time_zone VALUES("285","PE","America/Lima");
INSERT INTO time_zone VALUES("286","PF","Pacific/Tahiti");
INSERT INTO time_zone VALUES("287","PF","Pacific/Marquesas");
INSERT INTO time_zone VALUES("288","PF","Pacific/Gambier");
INSERT INTO time_zone VALUES("289","PG","Pacific/Port_Moresby");
INSERT INTO time_zone VALUES("290","PG","Pacific/Bougainville");
INSERT INTO time_zone VALUES("291","PH","Asia/Manila");
INSERT INTO time_zone VALUES("292","PK","Asia/Karachi");
INSERT INTO time_zone VALUES("293","PL","Europe/Warsaw");
INSERT INTO time_zone VALUES("294","PM","America/Miquelon");
INSERT INTO time_zone VALUES("295","PN","Pacific/Pitcairn");
INSERT INTO time_zone VALUES("296","PR","America/Puerto_Rico");
INSERT INTO time_zone VALUES("297","PS","Asia/Gaza");
INSERT INTO time_zone VALUES("298","PS","Asia/Hebron");
INSERT INTO time_zone VALUES("299","PT","Europe/Lisbon");
INSERT INTO time_zone VALUES("300","PT","Atlantic/Madeira");
INSERT INTO time_zone VALUES("301","PT","Atlantic/Azores");
INSERT INTO time_zone VALUES("302","PW","Pacific/Palau");
INSERT INTO time_zone VALUES("303","PY","America/Asuncion");
INSERT INTO time_zone VALUES("304","QA","Asia/Qatar");
INSERT INTO time_zone VALUES("305","RE","Indian/Reunion");
INSERT INTO time_zone VALUES("306","RO","Europe/Bucharest");
INSERT INTO time_zone VALUES("307","RS","Europe/Belgrade");
INSERT INTO time_zone VALUES("308","RU","Europe/Kaliningrad");
INSERT INTO time_zone VALUES("309","RU","Europe/Moscow");
INSERT INTO time_zone VALUES("310","RU","Europe/Simferopol");
INSERT INTO time_zone VALUES("311","RU","Europe/Volgograd");
INSERT INTO time_zone VALUES("312","RU","Europe/Kirov");
INSERT INTO time_zone VALUES("313","RU","Europe/Astrakhan");
INSERT INTO time_zone VALUES("314","RU","Europe/Saratov");
INSERT INTO time_zone VALUES("315","RU","Europe/Ulyanovsk");
INSERT INTO time_zone VALUES("316","RU","Europe/Samara");
INSERT INTO time_zone VALUES("317","RU","Asia/Yekaterinburg");
INSERT INTO time_zone VALUES("318","RU","Asia/Omsk");
INSERT INTO time_zone VALUES("319","RU","Asia/Novosibirsk");
INSERT INTO time_zone VALUES("320","RU","Asia/Barnaul");
INSERT INTO time_zone VALUES("321","RU","Asia/Tomsk");
INSERT INTO time_zone VALUES("322","RU","Asia/Novokuznetsk");
INSERT INTO time_zone VALUES("323","RU","Asia/Krasnoyarsk");
INSERT INTO time_zone VALUES("324","RU","Asia/Irkutsk");
INSERT INTO time_zone VALUES("325","RU","Asia/Chita");
INSERT INTO time_zone VALUES("326","RU","Asia/Yakutsk");
INSERT INTO time_zone VALUES("327","RU","Asia/Khandyga");
INSERT INTO time_zone VALUES("328","RU","Asia/Vladivostok");
INSERT INTO time_zone VALUES("329","RU","Asia/Ust-Nera");
INSERT INTO time_zone VALUES("330","RU","Asia/Magadan");
INSERT INTO time_zone VALUES("331","RU","Asia/Sakhalin");
INSERT INTO time_zone VALUES("332","RU","Asia/Srednekolymsk");
INSERT INTO time_zone VALUES("333","RU","Asia/Kamchatka");
INSERT INTO time_zone VALUES("334","RU","Asia/Anadyr");
INSERT INTO time_zone VALUES("335","RW","Africa/Kigali");
INSERT INTO time_zone VALUES("336","SA","Asia/Riyadh");
INSERT INTO time_zone VALUES("337","SB","Pacific/Guadalcanal");
INSERT INTO time_zone VALUES("338","SC","Indian/Mahe");
INSERT INTO time_zone VALUES("339","SD","Africa/Khartoum");
INSERT INTO time_zone VALUES("340","SE","Europe/Stockholm");
INSERT INTO time_zone VALUES("341","SG","Asia/Singapore");
INSERT INTO time_zone VALUES("342","SH","Atlantic/St_Helena");
INSERT INTO time_zone VALUES("343","SI","Europe/Ljubljana");
INSERT INTO time_zone VALUES("344","SJ","Arctic/Longyearbyen");
INSERT INTO time_zone VALUES("345","SK","Europe/Bratislava");
INSERT INTO time_zone VALUES("346","SL","Africa/Freetown");
INSERT INTO time_zone VALUES("347","SM","Europe/San_Marino");
INSERT INTO time_zone VALUES("348","SN","Africa/Dakar");
INSERT INTO time_zone VALUES("349","SO","Africa/Mogadishu");
INSERT INTO time_zone VALUES("350","SR","America/Paramaribo");
INSERT INTO time_zone VALUES("351","SS","Africa/Juba");
INSERT INTO time_zone VALUES("352","ST","Africa/Sao_Tome");
INSERT INTO time_zone VALUES("353","SV","America/El_Salvador");
INSERT INTO time_zone VALUES("354","SX","America/Lower_Princes");
INSERT INTO time_zone VALUES("355","SY","Asia/Damascus");
INSERT INTO time_zone VALUES("356","SZ","Africa/Mbabane");
INSERT INTO time_zone VALUES("357","TC","America/Grand_Turk");
INSERT INTO time_zone VALUES("358","TD","Africa/Ndjamena");
INSERT INTO time_zone VALUES("359","TF","Indian/Kerguelen");
INSERT INTO time_zone VALUES("360","TG","Africa/Lome");
INSERT INTO time_zone VALUES("361","TH","Asia/Bangkok");
INSERT INTO time_zone VALUES("362","TJ","Asia/Dushanbe");
INSERT INTO time_zone VALUES("363","TK","Pacific/Fakaofo");
INSERT INTO time_zone VALUES("364","TL","Asia/Dili");
INSERT INTO time_zone VALUES("365","TM","Asia/Ashgabat");
INSERT INTO time_zone VALUES("366","TN","Africa/Tunis");
INSERT INTO time_zone VALUES("367","TO","Pacific/Tongatapu");
INSERT INTO time_zone VALUES("368","TR","Europe/Istanbul");
INSERT INTO time_zone VALUES("369","TT","America/Port_of_Spain");
INSERT INTO time_zone VALUES("370","TV","Pacific/Funafuti");
INSERT INTO time_zone VALUES("371","TW","Asia/Taipei");
INSERT INTO time_zone VALUES("372","TZ","Africa/Dar_es_Salaam");
INSERT INTO time_zone VALUES("373","UA","Europe/Kiev");
INSERT INTO time_zone VALUES("374","UA","Europe/Uzhgorod");
INSERT INTO time_zone VALUES("375","UA","Europe/Zaporozhye");
INSERT INTO time_zone VALUES("376","UG","Africa/Kampala");
INSERT INTO time_zone VALUES("377","UM","Pacific/Midway");
INSERT INTO time_zone VALUES("378","UM","Pacific/Wake");
INSERT INTO time_zone VALUES("379","US","America/New_York");
INSERT INTO time_zone VALUES("380","US","America/Detroit");
INSERT INTO time_zone VALUES("381","US","America/Kentucky/Louisville");
INSERT INTO time_zone VALUES("382","US","America/Kentucky/Monticello");
INSERT INTO time_zone VALUES("383","US","America/Indiana/Indianapolis");
INSERT INTO time_zone VALUES("384","US","America/Indiana/Vincennes");
INSERT INTO time_zone VALUES("385","US","America/Indiana/Winamac");
INSERT INTO time_zone VALUES("386","US","America/Indiana/Marengo");
INSERT INTO time_zone VALUES("387","US","America/Indiana/Petersburg");
INSERT INTO time_zone VALUES("388","US","America/Indiana/Vevay");
INSERT INTO time_zone VALUES("389","US","America/Chicago");
INSERT INTO time_zone VALUES("390","US","America/Indiana/Tell_City");
INSERT INTO time_zone VALUES("391","US","America/Indiana/Knox");
INSERT INTO time_zone VALUES("392","US","America/Menominee");
INSERT INTO time_zone VALUES("393","US","America/North_Dakota/Center");
INSERT INTO time_zone VALUES("394","US","America/North_Dakota/New_Salem");
INSERT INTO time_zone VALUES("395","US","America/North_Dakota/Beulah");
INSERT INTO time_zone VALUES("396","US","America/Denver");
INSERT INTO time_zone VALUES("397","US","America/Boise");
INSERT INTO time_zone VALUES("398","US","America/Phoenix");
INSERT INTO time_zone VALUES("399","US","America/Los_Angeles");
INSERT INTO time_zone VALUES("400","US","America/Anchorage");
INSERT INTO time_zone VALUES("401","US","America/Juneau");
INSERT INTO time_zone VALUES("402","US","America/Sitka");
INSERT INTO time_zone VALUES("403","US","America/Metlakatla");
INSERT INTO time_zone VALUES("404","US","America/Yakutat");
INSERT INTO time_zone VALUES("405","US","America/Nome");
INSERT INTO time_zone VALUES("406","US","America/Adak");
INSERT INTO time_zone VALUES("407","US","Pacific/Honolulu");
INSERT INTO time_zone VALUES("408","UY","America/Montevideo");
INSERT INTO time_zone VALUES("409","UZ","Asia/Samarkand");
INSERT INTO time_zone VALUES("410","UZ","Asia/Tashkent");
INSERT INTO time_zone VALUES("411","VA","Europe/Vatican");
INSERT INTO time_zone VALUES("412","VC","America/St_Vincent");
INSERT INTO time_zone VALUES("413","VE","America/Caracas");
INSERT INTO time_zone VALUES("414","VG","America/Tortola");
INSERT INTO time_zone VALUES("415","VI","America/St_Thomas");
INSERT INTO time_zone VALUES("416","VN","Asia/Ho_Chi_Minh");
INSERT INTO time_zone VALUES("417","VU","Pacific/Efate");
INSERT INTO time_zone VALUES("418","WF","Pacific/Wallis");
INSERT INTO time_zone VALUES("419","WS","Pacific/Apia");
INSERT INTO time_zone VALUES("420","YE","Asia/Aden");
INSERT INTO time_zone VALUES("421","YT","Indian/Mayotte");
INSERT INTO time_zone VALUES("422","ZA","Africa/Johannesburg");
INSERT INTO time_zone VALUES("423","ZM","Africa/Lusaka");
INSERT INTO time_zone VALUES("424","ZW","Africa/Harare");



DROP TABLE timezone;

CREATE TABLE `timezone` (
  `zone_id` int(10) NOT NULL,
  `abbreviation` varchar(6) COLLATE utf8_bin NOT NULL,
  `time_start` decimal(11,0) NOT NULL,
  `gmt_offset` int(11) NOT NULL,
  `dst` char(1) COLLATE utf8_bin NOT NULL,
  KEY `idx_zone_id` (`zone_id`),
  KEY `idx_time_start` (`time_start`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

INSERT INTO timezone VALUES("1","LMT","-2177453165","364","0");
INSERT INTO timezone VALUES("1","WET","-2177453164","0","0");
INSERT INTO timezone VALUES("1","CET","-733881600","3600","0");
INSERT INTO timezone VALUES("1","CEST","481078800","7200","1");
INSERT INTO timezone VALUES("1","CET","496803600","3600","0");
INSERT INTO timezone VALUES("1","CEST","512528400","7200","1");
INSERT INTO timezone VALUES("1","CET","528253200","3600","0");
INSERT INTO timezone VALUES("1","CEST","543978000","7200","1");
INSERT INTO timezone VALUES("1","CET","559702800","3600","0");
INSERT INTO timezone VALUES("1","CEST","575427600","7200","1");
INSERT INTO timezone VALUES("1","CET","591152400","3600","0");
INSERT INTO timezone VALUES("1","CEST","606877200","7200","1");
INSERT INTO timezone VALUES("1","CET","622602000","3600","0");
INSERT INTO timezone VALUES("1","CEST","638326800","7200","1");
INSERT INTO timezone VALUES("1","CET","654656400","3600","0");
INSERT INTO timezone VALUES("1","CEST","670381200","7200","1");
INSERT INTO timezone VALUES("1","CET","686106000","3600","0");
INSERT INTO timezone VALUES("1","CEST","701830800","7200","1");
INSERT INTO timezone VALUES("1","CET","717555600","3600","0");
INSERT INTO timezone VALUES("1","CEST","733280400","7200","1");
INSERT INTO timezone VALUES("1","CET","749005200","3600","0");
INSERT INTO timezone VALUES("1","CEST","764730000","7200","1");
INSERT INTO timezone VALUES("1","CET","780454800","3600","0");
INSERT INTO timezone VALUES("1","CEST","796179600","7200","1");
INSERT INTO timezone VALUES("1","CET","811904400","3600","0");
INSERT INTO timezone VALUES("1","CEST","828234000","7200","1");
INSERT INTO timezone VALUES("1","CET","846378000","3600","0");
INSERT INTO timezone VALUES("1","CEST","859683600","7200","1");
INSERT INTO timezone VALUES("1","CET","877827600","3600","0");
INSERT INTO timezone VALUES("1","CEST","891133200","7200","1");
INSERT INTO timezone VALUES("1","CET","909277200","3600","0");
INSERT INTO timezone VALUES("1","CEST","922582800","7200","1");
INSERT INTO timezone VALUES("1","CET","941331600","3600","0");
INSERT INTO timezone VALUES("1","CEST","954032400","7200","1");
INSERT INTO timezone VALUES("1","CET","972781200","3600","0");
INSERT INTO timezone VALUES("1","CEST","985482000","7200","1");
INSERT INTO timezone VALUES("1","CET","1004230800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1017536400","7200","1");
INSERT INTO timezone VALUES("1","CET","1035680400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1048986000","7200","1");
INSERT INTO timezone VALUES("1","CET","1067130000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1080435600","7200","1");
INSERT INTO timezone VALUES("1","CET","1099184400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1111885200","7200","1");
INSERT INTO timezone VALUES("1","CET","1130634000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1143334800","7200","1");
INSERT INTO timezone VALUES("1","CET","1162083600","3600","0");
INSERT INTO timezone VALUES("1","CEST","1174784400","7200","1");
INSERT INTO timezone VALUES("1","CET","1193533200","3600","0");
INSERT INTO timezone VALUES("1","CEST","1206838800","7200","1");
INSERT INTO timezone VALUES("1","CET","1224982800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1238288400","7200","1");
INSERT INTO timezone VALUES("1","CET","1256432400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1269738000","7200","1");
INSERT INTO timezone VALUES("1","CET","1288486800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1301187600","7200","1");
INSERT INTO timezone VALUES("1","CET","1319936400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1332637200","7200","1");
INSERT INTO timezone VALUES("1","CET","1351386000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1364691600","7200","1");
INSERT INTO timezone VALUES("1","CET","1382835600","3600","0");
INSERT INTO timezone VALUES("1","CEST","1396141200","7200","1");
INSERT INTO timezone VALUES("1","CET","1414285200","3600","0");
INSERT INTO timezone VALUES("1","CEST","1427590800","7200","1");
INSERT INTO timezone VALUES("1","CET","1445734800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1459040400","7200","1");
INSERT INTO timezone VALUES("1","CET","1477789200","3600","0");
INSERT INTO timezone VALUES("1","CEST","1490490000","7200","1");
INSERT INTO timezone VALUES("1","CET","1509238800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1521939600","7200","1");
INSERT INTO timezone VALUES("1","CET","1540688400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1553994000","7200","1");
INSERT INTO timezone VALUES("1","CET","1572138000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1585443600","7200","1");
INSERT INTO timezone VALUES("1","CET","1603587600","3600","0");
INSERT INTO timezone VALUES("1","CEST","1616893200","7200","1");
INSERT INTO timezone VALUES("1","CET","1635642000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1648342800","7200","1");
INSERT INTO timezone VALUES("1","CET","1667091600","3600","0");
INSERT INTO timezone VALUES("1","CEST","1679792400","7200","1");
INSERT INTO timezone VALUES("1","CET","1698541200","3600","0");
INSERT INTO timezone VALUES("1","CEST","1711846800","7200","1");
INSERT INTO timezone VALUES("1","CET","1729990800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1743296400","7200","1");
INSERT INTO timezone VALUES("1","CET","1761440400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1774746000","7200","1");
INSERT INTO timezone VALUES("1","CET","1792890000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1806195600","7200","1");
INSERT INTO timezone VALUES("1","CET","1824944400","3600","0");
INSERT INTO timezone VALUES("1","CEST","1837645200","7200","1");
INSERT INTO timezone VALUES("1","CET","1856394000","3600","0");
INSERT INTO timezone VALUES("1","CEST","1869094800","7200","1");
INSERT INTO timezone VALUES("1","CET","1887843600","3600","0");
INSERT INTO timezone VALUES("1","CEST","1901149200","7200","1");
INSERT INTO timezone VALUES("1","CET","1919293200","3600","0");
INSERT INTO timezone VALUES("1","CEST","1932598800","7200","1");
INSERT INTO timezone VALUES("1","CET","1950742800","3600","0");
INSERT INTO timezone VALUES("1","CEST","1964048400","7200","1");
INSERT INTO timezone VALUES("1","CET","1982797200","3600","0");
INSERT INTO timezone VALUES("1","CEST","1995498000","7200","1");
INSERT INTO timezone VALUES("1","CET","2014246800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2026947600","7200","1");
INSERT INTO timezone VALUES("1","CET","2045696400","3600","0");
INSERT INTO timezone VALUES("1","CEST","2058397200","7200","1");
INSERT INTO timezone VALUES("1","CET","2077146000","3600","0");
INSERT INTO timezone VALUES("1","CEST","2090451600","7200","1");
INSERT INTO timezone VALUES("1","CET","2108595600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2121901200","7200","1");
INSERT INTO timezone VALUES("1","CET","2140045200","3600","0");
INSERT INTO timezone VALUES("1","CEST","2153350800","7200","1");
INSERT INTO timezone VALUES("1","CET","2172099600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2184800400","7200","1");
INSERT INTO timezone VALUES("1","CET","2203549200","3600","0");
INSERT INTO timezone VALUES("1","CEST","2216250000","7200","1");
INSERT INTO timezone VALUES("1","CET","2234998800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2248304400","7200","1");
INSERT INTO timezone VALUES("1","CET","2266448400","3600","0");
INSERT INTO timezone VALUES("1","CEST","2279754000","7200","1");
INSERT INTO timezone VALUES("1","CET","2297898000","3600","0");
INSERT INTO timezone VALUES("1","CEST","2311203600","7200","1");
INSERT INTO timezone VALUES("1","CET","2329347600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2342653200","7200","1");
INSERT INTO timezone VALUES("1","CET","2361402000","3600","0");
INSERT INTO timezone VALUES("1","CEST","2374102800","7200","1");
INSERT INTO timezone VALUES("1","CET","2392851600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2405552400","7200","1");
INSERT INTO timezone VALUES("1","CET","2424301200","3600","0");
INSERT INTO timezone VALUES("1","CEST","2437606800","7200","1");
INSERT INTO timezone VALUES("1","CET","2455750800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2469056400","7200","1");
INSERT INTO timezone VALUES("1","CET","2487200400","3600","0");
INSERT INTO timezone VALUES("1","CEST","2500506000","7200","1");
INSERT INTO timezone VALUES("1","CET","2519254800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2531955600","7200","1");
INSERT INTO timezone VALUES("1","CET","2550704400","3600","0");
INSERT INTO timezone VALUES("1","CEST","2563405200","7200","1");
INSERT INTO timezone VALUES("1","CET","2582154000","3600","0");
INSERT INTO timezone VALUES("1","CEST","2595459600","7200","1");
INSERT INTO timezone VALUES("1","CET","2613603600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2626909200","7200","1");
INSERT INTO timezone VALUES("1","CET","2645053200","3600","0");
INSERT INTO timezone VALUES("1","CEST","2658358800","7200","1");
INSERT INTO timezone VALUES("1","CET","2676502800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2689808400","7200","1");
INSERT INTO timezone VALUES("1","CET","2708557200","3600","0");
INSERT INTO timezone VALUES("1","CEST","2721258000","7200","1");
INSERT INTO timezone VALUES("1","CET","2740006800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2752707600","7200","1");
INSERT INTO timezone VALUES("1","CET","2771456400","3600","0");
INSERT INTO timezone VALUES("1","CEST","2784762000","7200","1");
INSERT INTO timezone VALUES("1","CET","2802906000","3600","0");
INSERT INTO timezone VALUES("1","CEST","2816211600","7200","1");
INSERT INTO timezone VALUES("1","CET","2834355600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2847661200","7200","1");
INSERT INTO timezone VALUES("1","CET","2866410000","3600","0");
INSERT INTO timezone VALUES("1","CEST","2879110800","7200","1");
INSERT INTO timezone VALUES("1","CET","2897859600","3600","0");
INSERT INTO timezone VALUES("1","CEST","2910560400","7200","1");
INSERT INTO timezone VALUES("1","CET","2929309200","3600","0");
INSERT INTO timezone VALUES("1","CEST","2942010000","7200","1");
INSERT INTO timezone VALUES("1","CET","2960758800","3600","0");
INSERT INTO timezone VALUES("1","CEST","2974064400","7200","1");
INSERT INTO timezone VALUES("1","CET","2992208400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3005514000","7200","1");
INSERT INTO timezone VALUES("1","CET","3023658000","3600","0");
INSERT INTO timezone VALUES("1","CEST","3036963600","7200","1");
INSERT INTO timezone VALUES("1","CET","3055712400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3068413200","7200","1");
INSERT INTO timezone VALUES("1","CET","3087162000","3600","0");
INSERT INTO timezone VALUES("1","CEST","3099862800","7200","1");
INSERT INTO timezone VALUES("1","CET","3118611600","3600","0");
INSERT INTO timezone VALUES("1","CEST","3131917200","7200","1");
INSERT INTO timezone VALUES("1","CET","3150061200","3600","0");
INSERT INTO timezone VALUES("1","CEST","3163366800","7200","1");
INSERT INTO timezone VALUES("1","CET","3181510800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3194816400","7200","1");
INSERT INTO timezone VALUES("1","CET","3212960400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3226266000","7200","1");
INSERT INTO timezone VALUES("1","CET","3245014800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3257715600","7200","1");
INSERT INTO timezone VALUES("1","CET","3276464400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3289165200","7200","1");
INSERT INTO timezone VALUES("1","CET","3307914000","3600","0");
INSERT INTO timezone VALUES("1","CEST","3321219600","7200","1");
INSERT INTO timezone VALUES("1","CET","3339363600","3600","0");
INSERT INTO timezone VALUES("1","CEST","3352669200","7200","1");
INSERT INTO timezone VALUES("1","CET","3370813200","3600","0");
INSERT INTO timezone VALUES("1","CEST","3384118800","7200","1");
INSERT INTO timezone VALUES("1","CET","3402867600","3600","0");
INSERT INTO timezone VALUES("1","CEST","3415568400","7200","1");
INSERT INTO timezone VALUES("1","CET","3434317200","3600","0");
INSERT INTO timezone VALUES("1","CEST","3447018000","7200","1");
INSERT INTO timezone VALUES("1","CET","3465766800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3479072400","7200","1");
INSERT INTO timezone VALUES("1","CET","3497216400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3510522000","7200","1");
INSERT INTO timezone VALUES("1","CET","3528666000","3600","0");
INSERT INTO timezone VALUES("1","CEST","3541971600","7200","1");
INSERT INTO timezone VALUES("1","CET","3560115600","3600","0");
INSERT INTO timezone VALUES("1","CEST","3573421200","7200","1");
INSERT INTO timezone VALUES("1","CET","3592170000","3600","0");
INSERT INTO timezone VALUES("1","CEST","3604870800","7200","1");
INSERT INTO timezone VALUES("1","CET","3623619600","3600","0");
INSERT INTO timezone VALUES("1","CEST","3636320400","7200","1");
INSERT INTO timezone VALUES("1","CET","3655069200","3600","0");
INSERT INTO timezone VALUES("1","CEST","3668374800","7200","1");
INSERT INTO timezone VALUES("1","CET","3686518800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3699824400","7200","1");
INSERT INTO timezone VALUES("1","CET","3717968400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3731274000","7200","1");
INSERT INTO timezone VALUES("1","CET","3750022800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3762723600","7200","1");
INSERT INTO timezone VALUES("1","CET","3781472400","3600","0");
INSERT INTO timezone VALUES("1","CEST","3794173200","7200","1");
INSERT INTO timezone VALUES("1","CET","3812922000","3600","0");
INSERT INTO timezone VALUES("1","CEST","3825622800","7200","1");
INSERT INTO timezone VALUES("1","CET","3844371600","3600","0");
INSERT INTO timezone VALUES("1","CEST","3857677200","7200","1");
INSERT INTO timezone VALUES("1","CET","3875821200","3600","0");
INSERT INTO timezone VALUES("1","CEST","3889126800","7200","1");
INSERT INTO timezone VALUES("1","CET","3907270800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3920576400","7200","1");
INSERT INTO timezone VALUES("1","CET","3939325200","3600","0");
INSERT INTO timezone VALUES("1","CEST","3952026000","7200","1");
INSERT INTO timezone VALUES("1","CET","3970774800","3600","0");
INSERT INTO timezone VALUES("1","CEST","3983475600","7200","1");
INSERT INTO timezone VALUES("1","CET","4002224400","3600","0");
INSERT INTO timezone VALUES("1","CEST","4015530000","7200","1");
INSERT INTO timezone VALUES("1","CET","4033674000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4046979600","7200","1");
INSERT INTO timezone VALUES("1","CET","4065123600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4078429200","7200","1");
INSERT INTO timezone VALUES("1","CET","4096573200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4109878800","7200","1");
INSERT INTO timezone VALUES("1","CET","4128627600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4141328400","7200","1");
INSERT INTO timezone VALUES("1","CET","4160077200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4172778000","7200","1");
INSERT INTO timezone VALUES("1","CET","4191526800","3600","0");
INSERT INTO timezone VALUES("1","CEST","4204227600","7200","1");
INSERT INTO timezone VALUES("1","CET","4222976400","3600","0");
INSERT INTO timezone VALUES("1","CEST","4236282000","7200","1");
INSERT INTO timezone VALUES("1","CET","4254426000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4267731600","7200","1");
INSERT INTO timezone VALUES("1","CET","4285875600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4299181200","7200","1");
INSERT INTO timezone VALUES("1","CET","4317930000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4330630800","7200","1");
INSERT INTO timezone VALUES("1","CET","4349379600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4362080400","7200","1");
INSERT INTO timezone VALUES("1","CET","4380829200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4394134800","7200","1");
INSERT INTO timezone VALUES("1","CET","4412278800","3600","0");
INSERT INTO timezone VALUES("1","CEST","4425584400","7200","1");
INSERT INTO timezone VALUES("1","CET","4443728400","3600","0");
INSERT INTO timezone VALUES("1","CEST","4457034000","7200","1");
INSERT INTO timezone VALUES("1","CET","4475178000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4488483600","7200","1");
INSERT INTO timezone VALUES("1","CET","4507232400","3600","0");
INSERT INTO timezone VALUES("1","CEST","4519933200","7200","1");
INSERT INTO timezone VALUES("1","CET","4538682000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4551382800","7200","1");
INSERT INTO timezone VALUES("1","CET","4570131600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4583437200","7200","1");
INSERT INTO timezone VALUES("1","CET","4601581200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4614886800","7200","1");
INSERT INTO timezone VALUES("1","CET","4633030800","3600","0");
INSERT INTO timezone VALUES("1","CEST","4646336400","7200","1");
INSERT INTO timezone VALUES("1","CET","4665085200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4677786000","7200","1");
INSERT INTO timezone VALUES("1","CET","4696534800","3600","0");
INSERT INTO timezone VALUES("1","CEST","4709235600","7200","1");
INSERT INTO timezone VALUES("1","CET","4727984400","3600","0");
INSERT INTO timezone VALUES("1","CEST","4741290000","7200","1");
INSERT INTO timezone VALUES("1","CET","4759434000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4772739600","7200","1");
INSERT INTO timezone VALUES("1","CET","4790883600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4804189200","7200","1");
INSERT INTO timezone VALUES("1","CET","4822333200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4835638800","7200","1");
INSERT INTO timezone VALUES("1","CET","4854387600","3600","0");
INSERT INTO timezone VALUES("1","CEST","4867088400","7200","1");
INSERT INTO timezone VALUES("1","CET","4885837200","3600","0");
INSERT INTO timezone VALUES("1","CEST","4898538000","7200","1");
INSERT INTO timezone VALUES("1","CET","4917286800","3600","0");
INSERT INTO timezone VALUES("1","CEST","4930592400","7200","1");
INSERT INTO timezone VALUES("1","CET","4948736400","3600","0");
INSERT INTO timezone VALUES("1","CEST","4962042000","7200","1");
INSERT INTO timezone VALUES("1","CET","4980186000","3600","0");
INSERT INTO timezone VALUES("1","CEST","4993491600","7200","1");
INSERT INTO timezone VALUES("1","CET","5012240400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5024941200","7200","1");
INSERT INTO timezone VALUES("1","CET","5043690000","3600","0");
INSERT INTO timezone VALUES("1","CEST","5056390800","7200","1");
INSERT INTO timezone VALUES("1","CET","5075139600","3600","0");
INSERT INTO timezone VALUES("1","CEST","5087840400","7200","1");
INSERT INTO timezone VALUES("1","CET","5106589200","3600","0");
INSERT INTO timezone VALUES("1","CEST","5119894800","7200","1");
INSERT INTO timezone VALUES("1","CET","5138038800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5151344400","7200","1");
INSERT INTO timezone VALUES("1","CET","5169488400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5182794000","7200","1");
INSERT INTO timezone VALUES("1","CET","5201542800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5214243600","7200","1");
INSERT INTO timezone VALUES("1","CET","5232992400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5245693200","7200","1");
INSERT INTO timezone VALUES("1","CET","5264442000","3600","0");
INSERT INTO timezone VALUES("1","CEST","5277747600","7200","1");
INSERT INTO timezone VALUES("1","CET","5295891600","3600","0");
INSERT INTO timezone VALUES("1","CEST","5309197200","7200","1");
INSERT INTO timezone VALUES("1","CET","5327341200","3600","0");
INSERT INTO timezone VALUES("1","CEST","5340646800","7200","1");
INSERT INTO timezone VALUES("1","CET","5358790800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5372096400","7200","1");
INSERT INTO timezone VALUES("1","CET","5390845200","3600","0");
INSERT INTO timezone VALUES("1","CEST","5403546000","7200","1");
INSERT INTO timezone VALUES("1","CET","5422294800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5434995600","7200","1");
INSERT INTO timezone VALUES("1","CET","5453744400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5467050000","7200","1");
INSERT INTO timezone VALUES("1","CET","5485194000","3600","0");
INSERT INTO timezone VALUES("1","CEST","5498499600","7200","1");
INSERT INTO timezone VALUES("1","CET","5516643600","3600","0");
INSERT INTO timezone VALUES("1","CEST","5529949200","7200","1");
INSERT INTO timezone VALUES("1","CET","5548698000","3600","0");
INSERT INTO timezone VALUES("1","CEST","5561398800","7200","1");
INSERT INTO timezone VALUES("1","CET","5580147600","3600","0");
INSERT INTO timezone VALUES("1","CEST","5592848400","7200","1");
INSERT INTO timezone VALUES("1","CET","5611597200","3600","0");
INSERT INTO timezone VALUES("1","CEST","5624902800","7200","1");
INSERT INTO timezone VALUES("1","CET","5643046800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5656352400","7200","1");
INSERT INTO timezone VALUES("1","CET","5674496400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5687802000","7200","1");
INSERT INTO timezone VALUES("1","CET","5705946000","3600","0");
INSERT INTO timezone VALUES("1","CEST","5719251600","7200","1");
INSERT INTO timezone VALUES("1","CET","5738000400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5750701200","7200","1");
INSERT INTO timezone VALUES("1","CET","5769450000","3600","0");
INSERT INTO timezone VALUES("1","CEST","5782150800","7200","1");
INSERT INTO timezone VALUES("1","CET","5800899600","3600","0");
INSERT INTO timezone VALUES("1","CEST","5814205200","7200","1");
INSERT INTO timezone VALUES("1","CET","5832349200","3600","0");
INSERT INTO timezone VALUES("1","CEST","5845654800","7200","1");
INSERT INTO timezone VALUES("1","CET","5863798800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5877104400","7200","1");
INSERT INTO timezone VALUES("1","CET","5895853200","3600","0");
INSERT INTO timezone VALUES("1","CEST","5908554000","7200","1");
INSERT INTO timezone VALUES("1","CET","5927302800","3600","0");
INSERT INTO timezone VALUES("1","CEST","5940003600","7200","1");
INSERT INTO timezone VALUES("1","CET","5958752400","3600","0");
INSERT INTO timezone VALUES("1","CEST","5971453200","7200","1");
INSERT INTO timezone VALUES("1","CET","5990202000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6003507600","7200","1");
INSERT INTO timezone VALUES("1","CET","6021651600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6034957200","7200","1");
INSERT INTO timezone VALUES("1","CET","6053101200","3600","0");
INSERT INTO timezone VALUES("1","CEST","6066406800","7200","1");
INSERT INTO timezone VALUES("1","CET","6085155600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6097856400","7200","1");
INSERT INTO timezone VALUES("1","CET","6116605200","3600","0");
INSERT INTO timezone VALUES("1","CEST","6129306000","7200","1");
INSERT INTO timezone VALUES("1","CET","6148054800","3600","0");
INSERT INTO timezone VALUES("1","CEST","6161360400","7200","1");
INSERT INTO timezone VALUES("1","CET","6179504400","3600","0");
INSERT INTO timezone VALUES("1","CEST","6192810000","7200","1");
INSERT INTO timezone VALUES("1","CET","6210954000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6224259600","7200","1");
INSERT INTO timezone VALUES("1","CET","6242403600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6255709200","7200","1");
INSERT INTO timezone VALUES("1","CET","6274458000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6287158800","7200","1");
INSERT INTO timezone VALUES("1","CET","6305907600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6318608400","7200","1");
INSERT INTO timezone VALUES("1","CET","6337357200","3600","0");
INSERT INTO timezone VALUES("1","CEST","6350662800","7200","1");
INSERT INTO timezone VALUES("1","CET","6368806800","3600","0");
INSERT INTO timezone VALUES("1","CEST","6382112400","7200","1");
INSERT INTO timezone VALUES("1","CET","6400256400","3600","0");
INSERT INTO timezone VALUES("1","CEST","6413562000","7200","1");
INSERT INTO timezone VALUES("1","CET","6432310800","3600","0");
INSERT INTO timezone VALUES("1","CEST","6445011600","7200","1");
INSERT INTO timezone VALUES("1","CET","6463760400","3600","0");
INSERT INTO timezone VALUES("1","CEST","6476461200","7200","1");
INSERT INTO timezone VALUES("1","CET","6495210000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6508515600","7200","1");
INSERT INTO timezone VALUES("1","CET","6526659600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6539965200","7200","1");
INSERT INTO timezone VALUES("1","CET","6558109200","3600","0");
INSERT INTO timezone VALUES("1","CEST","6571414800","7200","1");
INSERT INTO timezone VALUES("1","CET","6589558800","3600","0");
INSERT INTO timezone VALUES("1","CEST","6602864400","7200","1");
INSERT INTO timezone VALUES("1","CET","6621613200","3600","0");
INSERT INTO timezone VALUES("1","CEST","6634314000","7200","1");
INSERT INTO timezone VALUES("1","CET","6653062800","3600","0");
INSERT INTO timezone VALUES("1","CEST","6665763600","7200","1");
INSERT INTO timezone VALUES("1","CET","6684512400","3600","0");
INSERT INTO timezone VALUES("1","CEST","6697818000","7200","1");
INSERT INTO timezone VALUES("1","CET","6715962000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6729267600","7200","1");
INSERT INTO timezone VALUES("1","CET","6747411600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6760717200","7200","1");
INSERT INTO timezone VALUES("1","CET","6779466000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6792166800","7200","1");
INSERT INTO timezone VALUES("1","CET","6810915600","3600","0");
INSERT INTO timezone VALUES("1","CEST","6823616400","7200","1");
INSERT INTO timezone VALUES("1","CET","6842365200","3600","0");
INSERT INTO timezone VALUES("1","CEST","6855066000","7200","1");
INSERT INTO timezone VALUES("1","CET","6873814800","3600","0");
INSERT INTO timezone VALUES("1","CEST","6887120400","7200","1");
INSERT INTO timezone VALUES("1","CET","6905264400","3600","0");
INSERT INTO timezone VALUES("1","CEST","6918570000","7200","1");
INSERT INTO timezone VALUES("1","CET","6936714000","3600","0");
INSERT INTO timezone VALUES("1","CEST","6950019600","7200","1");
INSERT INTO timezone VALUES("1","CET","6968768400","3600","0");
INSERT INTO timezone VALUES("1","CEST","6981469200","7200","1");
INSERT INTO timezone VALUES("1","CET","7000218000","3600","0");
INSERT INTO timezone VALUES("1","CEST","7012918800","7200","1");
INSERT INTO timezone VALUES("1","CET","7031667600","3600","0");
INSERT INTO timezone VALUES("1","CEST","7044973200","7200","1");
INSERT INTO timezone VALUES("1","CET","7063117200","3600","0");
INSERT INTO timezone VALUES("1","CEST","7076422800","7200","1");
INSERT INTO timezone VALUES("1","CET","7094566800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7107872400","7200","1");
INSERT INTO timezone VALUES("1","CET","7126016400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7139322000","7200","1");
INSERT INTO timezone VALUES("1","CET","7158070800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7170771600","7200","1");
INSERT INTO timezone VALUES("1","CET","7189520400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7202221200","7200","1");
INSERT INTO timezone VALUES("1","CET","7220970000","3600","0");
INSERT INTO timezone VALUES("1","CEST","7234275600","7200","1");
INSERT INTO timezone VALUES("1","CET","7252419600","3600","0");
INSERT INTO timezone VALUES("1","CEST","7265725200","7200","1");
INSERT INTO timezone VALUES("1","CET","7283869200","3600","0");
INSERT INTO timezone VALUES("1","CEST","7297174800","7200","1");
INSERT INTO timezone VALUES("1","CET","7315318800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7328624400","7200","1");
INSERT INTO timezone VALUES("1","CET","7347373200","3600","0");
INSERT INTO timezone VALUES("1","CEST","7360074000","7200","1");
INSERT INTO timezone VALUES("1","CET","7378822800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7391523600","7200","1");
INSERT INTO timezone VALUES("1","CET","7410272400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7423578000","7200","1");
INSERT INTO timezone VALUES("1","CET","7441722000","3600","0");
INSERT INTO timezone VALUES("1","CEST","7455027600","7200","1");
INSERT INTO timezone VALUES("1","CET","7473171600","3600","0");
INSERT INTO timezone VALUES("1","CEST","7486477200","7200","1");
INSERT INTO timezone VALUES("1","CET","7504621200","3600","0");
INSERT INTO timezone VALUES("1","CEST","7517926800","7200","1");
INSERT INTO timezone VALUES("1","CET","7536675600","3600","0");
INSERT INTO timezone VALUES("1","CEST","7549376400","7200","1");
INSERT INTO timezone VALUES("1","CET","7568125200","3600","0");
INSERT INTO timezone VALUES("1","CEST","7580826000","7200","1");
INSERT INTO timezone VALUES("1","CET","7599574800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7612880400","7200","1");
INSERT INTO timezone VALUES("1","CET","7631024400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7644330000","7200","1");
INSERT INTO timezone VALUES("1","CET","7662474000","3600","0");
INSERT INTO timezone VALUES("1","CEST","7675779600","7200","1");
INSERT INTO timezone VALUES("1","CET","7694528400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7707229200","7200","1");
INSERT INTO timezone VALUES("1","CET","7725978000","3600","0");
INSERT INTO timezone VALUES("1","CEST","7738678800","7200","1");
INSERT INTO timezone VALUES("1","CET","7757427600","3600","0");
INSERT INTO timezone VALUES("1","CEST","7770733200","7200","1");
INSERT INTO timezone VALUES("1","CET","7788877200","3600","0");
INSERT INTO timezone VALUES("1","CEST","7802182800","7200","1");
INSERT INTO timezone VALUES("1","CET","7820326800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7833632400","7200","1");
INSERT INTO timezone VALUES("1","CET","7851776400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7865082000","7200","1");
INSERT INTO timezone VALUES("1","CET","7883830800","3600","0");
INSERT INTO timezone VALUES("1","CEST","7896531600","7200","1");
INSERT INTO timezone VALUES("1","CET","7915280400","3600","0");
INSERT INTO timezone VALUES("1","CEST","7927981200","7200","1");
INSERT INTO timezone VALUES("1","CET","7946730000","3600","0");
INSERT INTO timezone VALUES("1","CEST","7960035600","7200","1");
INSERT INTO timezone VALUES("1","CET","7978179600","3600","0");
INSERT INTO timezone VALUES("1","CEST","7991485200","7200","1");
INSERT INTO timezone VALUES("1","CET","8009629200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8022934800","7200","1");
INSERT INTO timezone VALUES("1","CET","8041683600","3600","0");
INSERT INTO timezone VALUES("1","CEST","8054384400","7200","1");
INSERT INTO timezone VALUES("1","CET","8073133200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8085834000","7200","1");
INSERT INTO timezone VALUES("1","CET","8104582800","3600","0");
INSERT INTO timezone VALUES("1","CEST","8117283600","7200","1");
INSERT INTO timezone VALUES("1","CET","8136032400","3600","0");
INSERT INTO timezone VALUES("1","CEST","8149338000","7200","1");
INSERT INTO timezone VALUES("1","CET","8167482000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8180787600","7200","1");
INSERT INTO timezone VALUES("1","CET","8198931600","3600","0");
INSERT INTO timezone VALUES("1","CEST","8212237200","7200","1");
INSERT INTO timezone VALUES("1","CET","8230986000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8243686800","7200","1");
INSERT INTO timezone VALUES("1","CET","8262435600","3600","0");
INSERT INTO timezone VALUES("1","CEST","8275136400","7200","1");
INSERT INTO timezone VALUES("1","CET","8293885200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8307190800","7200","1");
INSERT INTO timezone VALUES("1","CET","8325334800","3600","0");
INSERT INTO timezone VALUES("1","CEST","8338640400","7200","1");
INSERT INTO timezone VALUES("1","CET","8356784400","3600","0");
INSERT INTO timezone VALUES("1","CEST","8370090000","7200","1");
INSERT INTO timezone VALUES("1","CET","8388234000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8401539600","7200","1");
INSERT INTO timezone VALUES("1","CET","8420288400","3600","0");
INSERT INTO timezone VALUES("1","CEST","8432989200","7200","1");
INSERT INTO timezone VALUES("1","CET","8451738000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8464438800","7200","1");
INSERT INTO timezone VALUES("1","CET","8483187600","3600","0");
INSERT INTO timezone VALUES("1","CEST","8496493200","7200","1");
INSERT INTO timezone VALUES("1","CET","8514637200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8527942800","7200","1");
INSERT INTO timezone VALUES("1","CET","8546086800","3600","0");
INSERT INTO timezone VALUES("1","CEST","8559392400","7200","1");
INSERT INTO timezone VALUES("1","CET","8578141200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8590842000","7200","1");
INSERT INTO timezone VALUES("1","CET","8609590800","3600","0");
INSERT INTO timezone VALUES("1","CEST","8622291600","7200","1");
INSERT INTO timezone VALUES("1","CET","8641040400","3600","0");
INSERT INTO timezone VALUES("1","CEST","8654346000","7200","1");
INSERT INTO timezone VALUES("1","CET","8672490000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8685795600","7200","1");
INSERT INTO timezone VALUES("1","CET","8703939600","3600","0");
INSERT INTO timezone VALUES("1","CEST","8717245200","7200","1");
INSERT INTO timezone VALUES("1","CET","8735389200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8748694800","7200","1");
INSERT INTO timezone VALUES("1","CET","8767443600","3600","0");
INSERT INTO timezone VALUES("1","CEST","8780144400","7200","1");
INSERT INTO timezone VALUES("1","CET","8798893200","3600","0");
INSERT INTO timezone VALUES("1","CEST","8811594000","7200","1");
INSERT INTO timezone VALUES("1","CET","8830342800","3600","0");
INSERT INTO timezone VALUES("1","CEST","8843648400","7200","1");
INSERT INTO timezone VALUES("1","CET","8861792400","3600","0");
INSERT INTO timezone VALUES("1","CEST","8875098000","7200","1");
INSERT INTO timezone VALUES("1","CET","8893242000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8906547600","7200","1");
INSERT INTO timezone VALUES("1","CET","8925296400","3600","0");
INSERT INTO timezone VALUES("1","CEST","8937997200","7200","1");
INSERT INTO timezone VALUES("1","CET","8956746000","3600","0");
INSERT INTO timezone VALUES("1","CEST","8969446800","7200","1");
INSERT INTO timezone VALUES("1","CET","8988195600","3600","0");
INSERT INTO timezone VALUES("1","CEST","9000896400","7200","1");
INSERT INTO timezone VALUES("1","CET","9019645200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9032950800","7200","1");
INSERT INTO timezone VALUES("1","CET","9051094800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9064400400","7200","1");
INSERT INTO timezone VALUES("1","CET","9082544400","3600","0");
INSERT INTO timezone VALUES("1","CEST","9095850000","7200","1");
INSERT INTO timezone VALUES("1","CET","9114598800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9127299600","7200","1");
INSERT INTO timezone VALUES("1","CET","9146048400","3600","0");
INSERT INTO timezone VALUES("1","CEST","9158749200","7200","1");
INSERT INTO timezone VALUES("1","CET","9177498000","3600","0");
INSERT INTO timezone VALUES("1","CEST","9190803600","7200","1");
INSERT INTO timezone VALUES("1","CET","9208947600","3600","0");
INSERT INTO timezone VALUES("1","CEST","9222253200","7200","1");
INSERT INTO timezone VALUES("1","CET","9240397200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9253702800","7200","1");
INSERT INTO timezone VALUES("1","CET","9271846800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9285152400","7200","1");
INSERT INTO timezone VALUES("1","CET","9303901200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9316602000","7200","1");
INSERT INTO timezone VALUES("1","CET","9335350800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9348051600","7200","1");
INSERT INTO timezone VALUES("1","CET","9366800400","3600","0");
INSERT INTO timezone VALUES("1","CEST","9380106000","7200","1");
INSERT INTO timezone VALUES("1","CET","9398250000","3600","0");
INSERT INTO timezone VALUES("1","CEST","9411555600","7200","1");
INSERT INTO timezone VALUES("1","CET","9429699600","3600","0");
INSERT INTO timezone VALUES("1","CEST","9443005200","7200","1");
INSERT INTO timezone VALUES("1","CET","9461754000","3600","0");
INSERT INTO timezone VALUES("1","CEST","9474454800","7200","1");
INSERT INTO timezone VALUES("1","CET","9493203600","3600","0");
INSERT INTO timezone VALUES("1","CEST","9505904400","7200","1");
INSERT INTO timezone VALUES("1","CET","9524653200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9537958800","7200","1");
INSERT INTO timezone VALUES("1","CET","9556102800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9569408400","7200","1");
INSERT INTO timezone VALUES("1","CET","9587552400","3600","0");
INSERT INTO timezone VALUES("1","CEST","9600858000","7200","1");
INSERT INTO timezone VALUES("1","CET","9619002000","3600","0");
INSERT INTO timezone VALUES("1","CEST","9632307600","7200","1");
INSERT INTO timezone VALUES("1","CET","9651056400","3600","0");
INSERT INTO timezone VALUES("1","CEST","9663757200","7200","1");
INSERT INTO timezone VALUES("1","CET","9682506000","3600","0");
INSERT INTO timezone VALUES("1","CEST","9695206800","7200","1");
INSERT INTO timezone VALUES("1","CET","9713955600","3600","0");
INSERT INTO timezone VALUES("1","CEST","9727261200","7200","1");
INSERT INTO timezone VALUES("1","CET","9745405200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9758710800","7200","1");
INSERT INTO timezone VALUES("1","CET","9776854800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9790160400","7200","1");
INSERT INTO timezone VALUES("1","CET","9808909200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9821610000","7200","1");
INSERT INTO timezone VALUES("1","CET","9840358800","3600","0");
INSERT INTO timezone VALUES("1","CEST","9853059600","7200","1");
INSERT INTO timezone VALUES("1","CET","9871808400","3600","0");
INSERT INTO timezone VALUES("1","CEST","9884509200","7200","1");
INSERT INTO timezone VALUES("1","CET","9903258000","3600","0");
INSERT INTO timezone VALUES("1","CEST","9916563600","7200","1");
INSERT INTO timezone VALUES("1","CET","9934707600","3600","0");
INSERT INTO timezone VALUES("1","CEST","9948013200","7200","1");
INSERT INTO timezone VALUES("1","CET","9966157200","3600","0");
INSERT INTO timezone VALUES("1","CEST","9979462800","7200","1");
INSERT INTO timezone VALUES("1","CET","9998211600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10010912400","7200","1");
INSERT INTO timezone VALUES("1","CET","10029661200","3600","0");
INSERT INTO timezone VALUES("1","CEST","10042362000","7200","1");
INSERT INTO timezone VALUES("1","CET","10061110800","3600","0");
INSERT INTO timezone VALUES("1","CEST","10074416400","7200","1");
INSERT INTO timezone VALUES("1","CET","10092560400","3600","0");
INSERT INTO timezone VALUES("1","CEST","10105866000","7200","1");
INSERT INTO timezone VALUES("1","CET","10124010000","3600","0");
INSERT INTO timezone VALUES("1","CEST","10137315600","7200","1");
INSERT INTO timezone VALUES("1","CET","10155459600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10168765200","7200","1");
INSERT INTO timezone VALUES("1","CET","10187514000","3600","0");
INSERT INTO timezone VALUES("1","CEST","10200214800","7200","1");
INSERT INTO timezone VALUES("1","CET","10218963600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10231664400","7200","1");
INSERT INTO timezone VALUES("1","CET","10250413200","3600","0");
INSERT INTO timezone VALUES("1","CEST","10263718800","7200","1");
INSERT INTO timezone VALUES("1","CET","10281862800","3600","0");
INSERT INTO timezone VALUES("1","CEST","10295168400","7200","1");
INSERT INTO timezone VALUES("1","CET","10313312400","3600","0");
INSERT INTO timezone VALUES("1","CEST","10326618000","7200","1");
INSERT INTO timezone VALUES("1","CET","10345366800","3600","0");
INSERT INTO timezone VALUES("1","CEST","10358067600","7200","1");
INSERT INTO timezone VALUES("1","CET","10376816400","3600","0");
INSERT INTO timezone VALUES("1","CEST","10389517200","7200","1");
INSERT INTO timezone VALUES("1","CET","10408266000","3600","0");
INSERT INTO timezone VALUES("1","CEST","10420966800","7200","1");
INSERT INTO timezone VALUES("1","CET","10439715600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10453021200","7200","1");
INSERT INTO timezone VALUES("1","CET","10471165200","3600","0");
INSERT INTO timezone VALUES("1","CEST","10484470800","7200","1");
INSERT INTO timezone VALUES("1","CET","10502614800","3600","0");
INSERT INTO timezone VALUES("1","CEST","10515920400","7200","1");
INSERT INTO timezone VALUES("1","CET","10534064400","3600","0");
INSERT INTO timezone VALUES("1","CEST","10547370000","7200","1");
INSERT INTO timezone VALUES("1","CET","10566118800","3600","0");
INSERT INTO timezone VALUES("1","CEST","10578819600","7200","1");
INSERT INTO timezone VALUES("1","CET","10597568400","3600","0");
INSERT INTO timezone VALUES("1","CEST","10610269200","7200","1");
INSERT INTO timezone VALUES("1","CET","10629018000","3600","0");
INSERT INTO timezone VALUES("1","CEST","10642323600","7200","1");
INSERT INTO timezone VALUES("1","CET","10660467600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10673773200","7200","1");
INSERT INTO timezone VALUES("1","CET","10691917200","3600","0");
INSERT INTO timezone VALUES("1","CEST","10705222800","7200","1");
INSERT INTO timezone VALUES("1","CET","10723971600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10736672400","7200","1");
INSERT INTO timezone VALUES("1","CET","10755421200","3600","0");
INSERT INTO timezone VALUES("1","CEST","10768122000","7200","1");
INSERT INTO timezone VALUES("1","CET","10786870800","3600","0");
INSERT INTO timezone VALUES("1","CEST","10800176400","7200","1");
INSERT INTO timezone VALUES("1","CET","10818320400","3600","0");
INSERT INTO timezone VALUES("1","CEST","10831626000","7200","1");
INSERT INTO timezone VALUES("1","CET","10849770000","3600","0");
INSERT INTO timezone VALUES("1","CEST","10863075600","7200","1");
INSERT INTO timezone VALUES("1","CET","10881219600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10894525200","7200","1");
INSERT INTO timezone VALUES("1","CET","10913274000","3600","0");
INSERT INTO timezone VALUES("1","CEST","10925974800","7200","1");
INSERT INTO timezone VALUES("1","CET","10944723600","3600","0");
INSERT INTO timezone VALUES("1","CEST","10957424400","7200","1");
INSERT INTO timezone VALUES("1","CET","10976173200","3600","0");
INSERT INTO timezone VALUES("1","CEST","10989478800","7200","1");
INSERT INTO timezone VALUES("1","CET","11007622800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11020928400","7200","1");
INSERT INTO timezone VALUES("1","CET","11039072400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11052378000","7200","1");
INSERT INTO timezone VALUES("1","CET","11071126800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11083827600","7200","1");
INSERT INTO timezone VALUES("1","CET","11102576400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11115277200","7200","1");
INSERT INTO timezone VALUES("1","CET","11134026000","3600","0");
INSERT INTO timezone VALUES("1","CEST","11146726800","7200","1");
INSERT INTO timezone VALUES("1","CET","11165475600","3600","0");
INSERT INTO timezone VALUES("1","CEST","11178781200","7200","1");
INSERT INTO timezone VALUES("1","CET","11196925200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11210230800","7200","1");
INSERT INTO timezone VALUES("1","CET","11228374800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11241680400","7200","1");
INSERT INTO timezone VALUES("1","CET","11260429200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11273130000","7200","1");
INSERT INTO timezone VALUES("1","CET","11291878800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11304579600","7200","1");
INSERT INTO timezone VALUES("1","CET","11323328400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11336634000","7200","1");
INSERT INTO timezone VALUES("1","CET","11354778000","3600","0");
INSERT INTO timezone VALUES("1","CEST","11368083600","7200","1");
INSERT INTO timezone VALUES("1","CET","11386227600","3600","0");
INSERT INTO timezone VALUES("1","CEST","11399533200","7200","1");
INSERT INTO timezone VALUES("1","CET","11417677200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11430982800","7200","1");
INSERT INTO timezone VALUES("1","CET","11449731600","3600","0");
INSERT INTO timezone VALUES("1","CEST","11462432400","7200","1");
INSERT INTO timezone VALUES("1","CET","11481181200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11493882000","7200","1");
INSERT INTO timezone VALUES("1","CET","11512630800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11525936400","7200","1");
INSERT INTO timezone VALUES("1","CET","11544080400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11557386000","7200","1");
INSERT INTO timezone VALUES("1","CET","11575530000","3600","0");
INSERT INTO timezone VALUES("1","CEST","11588835600","7200","1");
INSERT INTO timezone VALUES("1","CET","11607584400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11620285200","7200","1");
INSERT INTO timezone VALUES("1","CET","11639034000","3600","0");
INSERT INTO timezone VALUES("1","CEST","11651734800","7200","1");
INSERT INTO timezone VALUES("1","CET","11670483600","3600","0");
INSERT INTO timezone VALUES("1","CEST","11683789200","7200","1");
INSERT INTO timezone VALUES("1","CET","11701933200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11715238800","7200","1");
INSERT INTO timezone VALUES("1","CET","11733382800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11746688400","7200","1");
INSERT INTO timezone VALUES("1","CET","11764832400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11778138000","7200","1");
INSERT INTO timezone VALUES("1","CET","11796886800","3600","0");
INSERT INTO timezone VALUES("1","CEST","11809587600","7200","1");
INSERT INTO timezone VALUES("1","CET","11828336400","3600","0");
INSERT INTO timezone VALUES("1","CEST","11841037200","7200","1");
INSERT INTO timezone VALUES("1","CET","11859786000","3600","0");
INSERT INTO timezone VALUES("1","CEST","11873091600","7200","1");
INSERT INTO timezone VALUES("1","CET","11891235600","3600","0");
INSERT INTO timezone VALUES("1","CEST","11904541200","7200","1");
INSERT INTO timezone VALUES("1","CET","11922685200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11935990800","7200","1");
INSERT INTO timezone VALUES("1","CET","11954739600","3600","0");
INSERT INTO timezone VALUES("1","CEST","11967440400","7200","1");
INSERT INTO timezone VALUES("1","CET","11986189200","3600","0");
INSERT INTO timezone VALUES("1","CEST","11998890000","7200","1");
INSERT INTO timezone VALUES("1","CET","12017638800","3600","0");
INSERT INTO timezone VALUES("1","CEST","12030339600","7200","1");
INSERT INTO timezone VALUES("1","CET","12049088400","3600","0");
INSERT INTO timezone VALUES("1","CEST","12062394000","7200","1");
INSERT INTO timezone VALUES("1","CET","12080538000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12093843600","7200","1");
INSERT INTO timezone VALUES("1","CET","12111987600","3600","0");
INSERT INTO timezone VALUES("1","CEST","12125293200","7200","1");
INSERT INTO timezone VALUES("1","CET","12144042000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12156742800","7200","1");
INSERT INTO timezone VALUES("1","CET","12175491600","3600","0");
INSERT INTO timezone VALUES("1","CEST","12188192400","7200","1");
INSERT INTO timezone VALUES("1","CET","12206941200","3600","0");
INSERT INTO timezone VALUES("1","CEST","12220246800","7200","1");
INSERT INTO timezone VALUES("1","CET","12238390800","3600","0");
INSERT INTO timezone VALUES("1","CEST","12251696400","7200","1");
INSERT INTO timezone VALUES("1","CET","12269840400","3600","0");
INSERT INTO timezone VALUES("1","CEST","12283146000","7200","1");
INSERT INTO timezone VALUES("1","CET","12301290000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12314595600","7200","1");
INSERT INTO timezone VALUES("1","CET","12333344400","3600","0");
INSERT INTO timezone VALUES("1","CEST","12346045200","7200","1");
INSERT INTO timezone VALUES("1","CET","12364794000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12377494800","7200","1");
INSERT INTO timezone VALUES("1","CET","12396243600","3600","0");
INSERT INTO timezone VALUES("1","CEST","12409549200","7200","1");
INSERT INTO timezone VALUES("1","CET","12427693200","3600","0");
INSERT INTO timezone VALUES("1","CEST","12440998800","7200","1");
INSERT INTO timezone VALUES("1","CET","12459142800","3600","0");
INSERT INTO timezone VALUES("1","CEST","12472448400","7200","1");
INSERT INTO timezone VALUES("1","CET","12491197200","3600","0");
INSERT INTO timezone VALUES("1","CEST","12503898000","7200","1");
INSERT INTO timezone VALUES("1","CET","12522646800","3600","0");
INSERT INTO timezone VALUES("1","CEST","12535347600","7200","1");
INSERT INTO timezone VALUES("1","CET","12554096400","3600","0");
INSERT INTO timezone VALUES("1","CEST","12567402000","7200","1");
INSERT INTO timezone VALUES("1","CET","12585546000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12598851600","7200","1");
INSERT INTO timezone VALUES("1","CET","12616995600","3600","0");
INSERT INTO timezone VALUES("1","CEST","12630301200","7200","1");
INSERT INTO timezone VALUES("1","CET","12648445200","3600","0");
INSERT INTO timezone VALUES("1","CEST","12661750800","7200","1");
INSERT INTO timezone VALUES("1","CET","12680499600","3600","0");
INSERT INTO timezone VALUES("1","CEST","12693200400","7200","1");
INSERT INTO timezone VALUES("1","CET","12711949200","3600","0");
INSERT INTO timezone VALUES("1","CEST","12724650000","7200","1");
INSERT INTO timezone VALUES("1","CET","12743398800","3600","0");
INSERT INTO timezone VALUES("1","CEST","12756704400","7200","1");
INSERT INTO timezone VALUES("1","CET","12774848400","3600","0");
INSERT INTO timezone VALUES("1","CEST","12788154000","7200","1");
INSERT INTO timezone VALUES("1","CET","12806298000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12819603600","7200","1");
INSERT INTO timezone VALUES("1","CET","12838352400","3600","0");
INSERT INTO timezone VALUES("1","CEST","12851053200","7200","1");
INSERT INTO timezone VALUES("1","CET","12869802000","3600","0");
INSERT INTO timezone VALUES("1","CEST","12882502800","7200","1");
INSERT INTO timezone VALUES("1","CET","12901251600","3600","0");
INSERT INTO timezone VALUES("1","CEST","12913952400","7200","1");
INSERT INTO timezone VALUES("1","CET","12932701200","3600","0");
INSERT INTO timezone VALUES("1","CEST","12946006800","7200","1");
INSERT INTO timezone VALUES("1","CET","12964150800","3600","0");
INSERT INTO timezone VALUES("1","CEST","12977456400","7200","1");
INSERT INTO timezone VALUES("1","CET","12995600400","3600","0");
INSERT INTO timezone VALUES("1","CEST","13008906000","7200","1");
INSERT INTO timezone VALUES("1","CET","13027654800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13040355600","7200","1");
INSERT INTO timezone VALUES("1","CET","13059104400","3600","0");
INSERT INTO timezone VALUES("1","CEST","13071805200","7200","1");
INSERT INTO timezone VALUES("1","CET","13090554000","3600","0");
INSERT INTO timezone VALUES("1","CEST","13103859600","7200","1");
INSERT INTO timezone VALUES("1","CET","13122003600","3600","0");
INSERT INTO timezone VALUES("1","CEST","13135309200","7200","1");
INSERT INTO timezone VALUES("1","CET","13153453200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13166758800","7200","1");
INSERT INTO timezone VALUES("1","CET","13184902800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13198208400","7200","1");
INSERT INTO timezone VALUES("1","CET","13216957200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13229658000","7200","1");
INSERT INTO timezone VALUES("1","CET","13248406800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13261107600","7200","1");
INSERT INTO timezone VALUES("1","CET","13279856400","3600","0");
INSERT INTO timezone VALUES("1","CEST","13293162000","7200","1");
INSERT INTO timezone VALUES("1","CET","13311306000","3600","0");
INSERT INTO timezone VALUES("1","CEST","13324611600","7200","1");
INSERT INTO timezone VALUES("1","CET","13342755600","3600","0");
INSERT INTO timezone VALUES("1","CEST","13356061200","7200","1");
INSERT INTO timezone VALUES("1","CET","13374810000","3600","0");
INSERT INTO timezone VALUES("1","CEST","13387510800","7200","1");
INSERT INTO timezone VALUES("1","CET","13406259600","3600","0");
INSERT INTO timezone VALUES("1","CEST","13418960400","7200","1");
INSERT INTO timezone VALUES("1","CET","13437709200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13451014800","7200","1");
INSERT INTO timezone VALUES("1","CET","13469158800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13482464400","7200","1");
INSERT INTO timezone VALUES("1","CET","13500608400","3600","0");
INSERT INTO timezone VALUES("1","CEST","13513914000","7200","1");
INSERT INTO timezone VALUES("1","CET","13532058000","3600","0");
INSERT INTO timezone VALUES("1","CEST","13545363600","7200","1");
INSERT INTO timezone VALUES("1","CET","13564112400","3600","0");
INSERT INTO timezone VALUES("1","CEST","13576813200","7200","1");
INSERT INTO timezone VALUES("1","CET","13595562000","3600","0");
INSERT INTO timezone VALUES("1","CEST","13608262800","7200","1");
INSERT INTO timezone VALUES("1","CET","13627011600","3600","0");
INSERT INTO timezone VALUES("1","CEST","13640317200","7200","1");
INSERT INTO timezone VALUES("1","CET","13658461200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13671766800","7200","1");
INSERT INTO timezone VALUES("1","CET","13689910800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13703216400","7200","1");
INSERT INTO timezone VALUES("1","CET","13721965200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13734666000","7200","1");
INSERT INTO timezone VALUES("1","CET","13753414800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13766115600","7200","1");
INSERT INTO timezone VALUES("1","CET","13784864400","3600","0");
INSERT INTO timezone VALUES("1","CEST","13797565200","7200","1");
INSERT INTO timezone VALUES("1","CET","13816314000","3600","0");
INSERT INTO timezone VALUES("1","CEST","13829619600","7200","1");
INSERT INTO timezone VALUES("1","CET","13847763600","3600","0");
INSERT INTO timezone VALUES("1","CEST","13861069200","7200","1");
INSERT INTO timezone VALUES("1","CET","13879213200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13892518800","7200","1");
INSERT INTO timezone VALUES("1","CET","13911267600","3600","0");
INSERT INTO timezone VALUES("1","CEST","13923968400","7200","1");
INSERT INTO timezone VALUES("1","CET","13942717200","3600","0");
INSERT INTO timezone VALUES("1","CEST","13955418000","7200","1");
INSERT INTO timezone VALUES("1","CET","13974166800","3600","0");
INSERT INTO timezone VALUES("1","CEST","13987472400","7200","1");
INSERT INTO timezone VALUES("1","CET","14005616400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14018922000","7200","1");
INSERT INTO timezone VALUES("1","CET","14037066000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14050371600","7200","1");
INSERT INTO timezone VALUES("1","CET","14068515600","3600","0");
INSERT INTO timezone VALUES("1","CEST","14081821200","7200","1");
INSERT INTO timezone VALUES("1","CET","14100570000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14113270800","7200","1");
INSERT INTO timezone VALUES("1","CET","14132019600","3600","0");
INSERT INTO timezone VALUES("1","CEST","14144720400","7200","1");
INSERT INTO timezone VALUES("1","CET","14163469200","3600","0");
INSERT INTO timezone VALUES("1","CEST","14176774800","7200","1");
INSERT INTO timezone VALUES("1","CET","14194918800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14208224400","7200","1");
INSERT INTO timezone VALUES("1","CET","14226368400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14239674000","7200","1");
INSERT INTO timezone VALUES("1","CET","14258422800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14271123600","7200","1");
INSERT INTO timezone VALUES("1","CET","14289872400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14302573200","7200","1");
INSERT INTO timezone VALUES("1","CET","14321322000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14334627600","7200","1");
INSERT INTO timezone VALUES("1","CET","14352771600","3600","0");
INSERT INTO timezone VALUES("1","CEST","14366077200","7200","1");
INSERT INTO timezone VALUES("1","CET","14384221200","3600","0");
INSERT INTO timezone VALUES("1","CEST","14397526800","7200","1");
INSERT INTO timezone VALUES("1","CET","14415670800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14428976400","7200","1");
INSERT INTO timezone VALUES("1","CET","14447725200","3600","0");
INSERT INTO timezone VALUES("1","CEST","14460426000","7200","1");
INSERT INTO timezone VALUES("1","CET","14479174800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14491875600","7200","1");
INSERT INTO timezone VALUES("1","CET","14510624400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14523930000","7200","1");
INSERT INTO timezone VALUES("1","CET","14542074000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14555379600","7200","1");
INSERT INTO timezone VALUES("1","CET","14573523600","3600","0");
INSERT INTO timezone VALUES("1","CEST","14586829200","7200","1");
INSERT INTO timezone VALUES("1","CET","14605578000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14618278800","7200","1");
INSERT INTO timezone VALUES("1","CET","14637027600","3600","0");
INSERT INTO timezone VALUES("1","CEST","14649728400","7200","1");
INSERT INTO timezone VALUES("1","CET","14668477200","3600","0");
INSERT INTO timezone VALUES("1","CEST","14681178000","7200","1");
INSERT INTO timezone VALUES("1","CET","14699926800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14713232400","7200","1");
INSERT INTO timezone VALUES("1","CET","14731376400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14744682000","7200","1");
INSERT INTO timezone VALUES("1","CET","14762826000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14776131600","7200","1");
INSERT INTO timezone VALUES("1","CET","14794880400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14807581200","7200","1");
INSERT INTO timezone VALUES("1","CET","14826330000","3600","0");
INSERT INTO timezone VALUES("1","CEST","14839030800","7200","1");
INSERT INTO timezone VALUES("1","CET","14857779600","3600","0");
INSERT INTO timezone VALUES("1","CEST","14871085200","7200","1");
INSERT INTO timezone VALUES("1","CET","14889229200","3600","0");
INSERT INTO timezone VALUES("1","CEST","14902534800","7200","1");
INSERT INTO timezone VALUES("1","CET","14920678800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14933984400","7200","1");
INSERT INTO timezone VALUES("1","CET","14952128400","3600","0");
INSERT INTO timezone VALUES("1","CEST","14965434000","7200","1");
INSERT INTO timezone VALUES("1","CET","14984182800","3600","0");
INSERT INTO timezone VALUES("1","CEST","14996883600","7200","1");
INSERT INTO timezone VALUES("1","CET","15015632400","3600","0");
INSERT INTO timezone VALUES("1","CEST","15028333200","7200","1");
INSERT INTO timezone VALUES("1","CET","15047082000","3600","0");
INSERT INTO timezone VALUES("1","CEST","15060387600","7200","1");
INSERT INTO timezone VALUES("1","CET","15078531600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15091837200","7200","1");
INSERT INTO timezone VALUES("1","CET","15109981200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15123286800","7200","1");
INSERT INTO timezone VALUES("1","CET","15142035600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15154736400","7200","1");
INSERT INTO timezone VALUES("1","CET","15173485200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15186186000","7200","1");
INSERT INTO timezone VALUES("1","CET","15204934800","3600","0");
INSERT INTO timezone VALUES("1","CEST","15218240400","7200","1");
INSERT INTO timezone VALUES("1","CET","15236384400","3600","0");
INSERT INTO timezone VALUES("1","CEST","15249690000","7200","1");
INSERT INTO timezone VALUES("1","CET","15267834000","3600","0");
INSERT INTO timezone VALUES("1","CEST","15281139600","7200","1");
INSERT INTO timezone VALUES("1","CET","15299283600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15312589200","7200","1");
INSERT INTO timezone VALUES("1","CET","15331338000","3600","0");
INSERT INTO timezone VALUES("1","CEST","15344038800","7200","1");
INSERT INTO timezone VALUES("1","CET","15362787600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15375488400","7200","1");
INSERT INTO timezone VALUES("1","CET","15394237200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15407542800","7200","1");
INSERT INTO timezone VALUES("1","CET","15425686800","3600","0");
INSERT INTO timezone VALUES("1","CEST","15438992400","7200","1");
INSERT INTO timezone VALUES("1","CET","15457136400","3600","0");
INSERT INTO timezone VALUES("1","CEST","15470442000","7200","1");
INSERT INTO timezone VALUES("1","CET","15489190800","3600","0");
INSERT INTO timezone VALUES("1","CEST","15501891600","7200","1");
INSERT INTO timezone VALUES("1","CET","15520640400","3600","0");
INSERT INTO timezone VALUES("1","CEST","15533341200","7200","1");
INSERT INTO timezone VALUES("1","CET","15552090000","3600","0");
INSERT INTO timezone VALUES("1","CEST","15564790800","7200","1");
INSERT INTO timezone VALUES("1","CET","15583539600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15596845200","7200","1");
INSERT INTO timezone VALUES("1","CET","15614989200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15628294800","7200","1");
INSERT INTO timezone VALUES("1","CET","15646438800","3600","0");
INSERT INTO timezone VALUES("1","CEST","15659744400","7200","1");
INSERT INTO timezone VALUES("1","CET","15678493200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15691194000","7200","1");
INSERT INTO timezone VALUES("1","CET","15709942800","3600","0");
INSERT INTO timezone VALUES("1","CEST","15722643600","7200","1");
INSERT INTO timezone VALUES("1","CET","15741392400","3600","0");
INSERT INTO timezone VALUES("1","CEST","15754698000","7200","1");
INSERT INTO timezone VALUES("1","CET","15772842000","3600","0");
INSERT INTO timezone VALUES("1","CEST","15786147600","7200","1");
INSERT INTO timezone VALUES("1","CET","15804291600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15817597200","7200","1");
INSERT INTO timezone VALUES("1","CET","15835741200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15849046800","7200","1");
INSERT INTO timezone VALUES("1","CET","15867795600","3600","0");
INSERT INTO timezone VALUES("1","CEST","15880496400","7200","1");
INSERT INTO timezone VALUES("1","CET","15899245200","3600","0");
INSERT INTO timezone VALUES("1","CEST","15911946000","7200","1");
INSERT INTO timezone VALUES("1","CET","15930694800","3600","0");
INSERT INTO timezone VALUES("1","CEST","15944000400","7200","1");
INSERT INTO timezone VALUES("1","CET","15962144400","3600","0");
INSERT INTO timezone VALUES("1","CEST","15975450000","7200","1");
INSERT INTO timezone VALUES("1","CET","15993594000","3600","0");
INSERT INTO timezone VALUES("1","CEST","16006899600","7200","1");
INSERT INTO timezone VALUES("1","CET","16025648400","3600","0");
INSERT INTO timezone VALUES("1","CEST","16038349200","7200","1");
INSERT INTO timezone VALUES("1","CET","16057098000","3600","0");
INSERT INTO timezone VALUES("1","CEST","16069798800","7200","1");
INSERT INTO timezone VALUES("1","CET","16088547600","3600","0");
INSERT INTO timezone VALUES("1","CEST","16101853200","7200","1");
INSERT INTO timezone VALUES("1","CET","16119997200","3600","0");
INSERT INTO timezone VALUES("1","CEST","16133302800","7200","1");
INSERT INTO timezone VALUES("1","CET","16151446800","3600","0");
INSERT INTO timezone VALUES("1","CEST","16164752400","7200","1");
INSERT INTO timezone VALUES("1","CET","16182896400","3600","0");
INSERT INTO timezone VALUES("1","CEST","16196202000","7200","1");
INSERT INTO timezone VALUES("1","CET","16214950800","3600","0");
INSERT INTO timezone VALUES("1","CEST","16227651600","7200","1");
INSERT INTO timezone VALUES("1","CET","16246400400","3600","0");
INSERT INTO timezone VALUES("1","CEST","16259101200","7200","1");
INSERT INTO timezone VALUES("1","CET","16277850000","3600","0");
INSERT INTO timezone VALUES("1","CEST","16291155600","7200","1");
INSERT INTO timezone VALUES("1","CET","16309299600","3600","0");
INSERT INTO timezone VALUES("1","CEST","16322605200","7200","1");
INSERT INTO timezone VALUES("1","CET","16340749200","3600","0");
INSERT INTO timezone VALUES("1","CEST","16354054800","7200","1");
INSERT INTO timezone VALUES("1","CET","16372803600","3600","0");
INSERT INTO timezone VALUES("1","CEST","16385504400","7200","1");
INSERT INTO timezone VALUES("1","CET","16404253200","3600","0");
INSERT INTO timezone VALUES("1","CEST","16416954000","7200","1");
INSERT INTO timezone VALUES("1","CET","16435702800","3600","0");
INSERT INTO timezone VALUES("1","CEST","16448403600","7200","1");
INSERT INTO timezone VALUES("1","CET","16467152400","3600","0");
INSERT INTO timezone VALUES("1","CEST","16480458000","7200","1");
INSERT INTO timezone VALUES("1","CET","16498602000","3600","0");
INSERT INTO timezone VALUES("1","CEST","16511907600","7200","1");
INSERT INTO timezone VALUES("1","CET","16530051600","3600","0");
INSERT INTO timezone VALUES("1","CEST","16543357200","7200","1");
INSERT INTO timezone VALUES("1","CET","16562106000","3600","0");
INSERT INTO timezone VALUES("1","CEST","16574806800","7200","1");
INSERT INTO timezone VALUES("1","CET","16593555600","3600","0");
INSERT INTO timezone VALUES("1","CEST","16606256400","7200","1");
INSERT INTO timezone VALUES("1","CET","16625005200","3600","0");
INSERT INTO timezone VALUES("1","CEST","16638310800","7200","1");
INSERT INTO timezone VALUES("1","CET","16656454800","3600","0");
INSERT INTO timezone VALUES("1","CEST","16669760400","7200","1");
INSERT INTO timezone VALUES("1","CET","16687904400","3600","0");
INSERT INTO timezone VALUES("1","CEST","16701210000","7200","1");
INSERT INTO timezone VALUES("1","CET","16719354000","3600","0");
INSERT INTO timezone VALUES("2","LMT","-1577936473","13272","0");
INSERT INTO timezone VALUES("2","+04","-1577936472","14400","0");
INSERT INTO timezone VALUES("3","LMT","-2524538209","16608","0");
INSERT INTO timezone VALUES("3","+04","-2524538208","14400","0");
INSERT INTO timezone VALUES("3","+0430","-788932800","16200","0");
INSERT INTO timezone VALUES("4","LMT","-1825098837","-14764","0");
INSERT INTO timezone VALUES("4","AST","-1825098836","-14400","0");
INSERT INTO timezone VALUES("5","LMT","-1825098837","-14764","0");
INSERT INTO timezone VALUES("5","AST","-1825098836","-14400","0");
INSERT INTO timezone VALUES("6","LMT","-1767230361","4760","0");
INSERT INTO timezone VALUES("6","CET","-1767230360","3600","0");
INSERT INTO timezone VALUES("6","CEST","-932346000","7200","1");
INSERT INTO timezone VALUES("6","CET","-857257200","3600","0");
INSERT INTO timezone VALUES("6","CEST","-844556400","7200","1");
INSERT INTO timezone VALUES("6","CET","-843519600","3600","0");
INSERT INTO timezone VALUES("6","CEST","136854000","7200","1");
INSERT INTO timezone VALUES("6","CET","149896800","3600","0");
INSERT INTO timezone VALUES("6","CEST","168130800","7200","1");
INSERT INTO timezone VALUES("6","CET","181432800","3600","0");
INSERT INTO timezone VALUES("6","CEST","199839600","7200","1");
INSERT INTO timezone VALUES("6","CET","213141600","3600","0");
INSERT INTO timezone VALUES("6","CEST","231894000","7200","1");
INSERT INTO timezone VALUES("6","CET","244591200","3600","0");
INSERT INTO timezone VALUES("6","CEST","263257200","7200","1");
INSERT INTO timezone VALUES("6","CET","276040800","3600","0");
INSERT INTO timezone VALUES("6","CEST","294706800","7200","1");
INSERT INTO timezone VALUES("6","CET","307490400","3600","0");
INSERT INTO timezone VALUES("6","CEST","326156400","7200","1");
INSERT INTO timezone VALUES("6","CET","339458400","3600","0");
INSERT INTO timezone VALUES("6","CEST","357087600","7200","1");
INSERT INTO timezone VALUES("6","CET","370389600","3600","0");
INSERT INTO timezone VALUES("6","CEST","389142000","7200","1");
INSERT INTO timezone VALUES("6","CET","402444000","3600","0");
INSERT INTO timezone VALUES("6","CEST","419468400","7200","1");
INSERT INTO timezone VALUES("6","CET","433807200","3600","0");
INSERT INTO timezone VALUES("6","CEST","449622000","7200","1");
INSERT INTO timezone VALUES("6","CET","465354000","3600","0");
INSERT INTO timezone VALUES("6","CEST","481078800","7200","1");
INSERT INTO timezone VALUES("6","CET","496803600","3600","0");
INSERT INTO timezone VALUES("6","CEST","512528400","7200","1");
INSERT INTO timezone VALUES("6","CET","528253200","3600","0");
INSERT INTO timezone VALUES("6","CEST","543978000","7200","1");
INSERT INTO timezone VALUES("6","CET","559702800","3600","0");
INSERT INTO timezone VALUES("6","CEST","575427600","7200","1");
INSERT INTO timezone VALUES("6","CET","591152400","3600","0");
INSERT INTO timezone VALUES("6","CEST","606877200","7200","1");
INSERT INTO timezone VALUES("6","CET","622602000","3600","0");
INSERT INTO timezone VALUES("6","CEST","638326800","7200","1");
INSERT INTO timezone VALUES("6","CET","654656400","3600","0");
INSERT INTO timezone VALUES("6","CEST","670381200","7200","1");
INSERT INTO timezone VALUES("6","CET","686106000","3600","0");
INSERT INTO timezone VALUES("6","CEST","701830800","7200","1");
INSERT INTO timezone VALUES("6","CET","717555600","3600","0");
INSERT INTO timezone VALUES("6","CEST","733280400","7200","1");
INSERT INTO timezone VALUES("6","CET","749005200","3600","0");
INSERT INTO timezone VALUES("6","CEST","764730000","7200","1");
INSERT INTO timezone VALUES("6","CET","780454800","3600","0");
INSERT INTO timezone VALUES("6","CEST","796179600","7200","1");
INSERT INTO timezone VALUES("6","CET","811904400","3600","0");
INSERT INTO timezone VALUES("6","CEST","828234000","7200","1");
INSERT INTO timezone VALUES("6","CET","846378000","3600","0");
INSERT INTO timezone VALUES("6","CEST","859683600","7200","1");
INSERT INTO timezone VALUES("6","CET","877827600","3600","0");
INSERT INTO timezone VALUES("6","CEST","891133200","7200","1");
INSERT INTO timezone VALUES("6","CET","909277200","3600","0");
INSERT INTO timezone VALUES("6","CEST","922582800","7200","1");
INSERT INTO timezone VALUES("6","CET","941331600","3600","0");
INSERT INTO timezone VALUES("6","CEST","954032400","7200","1");
INSERT INTO timezone VALUES("6","CET","972781200","3600","0");
INSERT INTO timezone VALUES("6","CEST","985482000","7200","1");
INSERT INTO timezone VALUES("6","CET","1004230800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1017536400","7200","1");
INSERT INTO timezone VALUES("6","CET","1035680400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1048986000","7200","1");
INSERT INTO timezone VALUES("6","CET","1067130000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1080435600","7200","1");
INSERT INTO timezone VALUES("6","CET","1099184400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1111885200","7200","1");
INSERT INTO timezone VALUES("6","CET","1130634000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1143334800","7200","1");
INSERT INTO timezone VALUES("6","CET","1162083600","3600","0");
INSERT INTO timezone VALUES("6","CEST","1174784400","7200","1");
INSERT INTO timezone VALUES("6","CET","1193533200","3600","0");
INSERT INTO timezone VALUES("6","CEST","1206838800","7200","1");
INSERT INTO timezone VALUES("6","CET","1224982800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1238288400","7200","1");
INSERT INTO timezone VALUES("6","CET","1256432400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1269738000","7200","1");
INSERT INTO timezone VALUES("6","CET","1288486800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1301187600","7200","1");
INSERT INTO timezone VALUES("6","CET","1319936400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1332637200","7200","1");
INSERT INTO timezone VALUES("6","CET","1351386000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1364691600","7200","1");
INSERT INTO timezone VALUES("6","CET","1382835600","3600","0");
INSERT INTO timezone VALUES("6","CEST","1396141200","7200","1");
INSERT INTO timezone VALUES("6","CET","1414285200","3600","0");
INSERT INTO timezone VALUES("6","CEST","1427590800","7200","1");
INSERT INTO timezone VALUES("6","CET","1445734800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1459040400","7200","1");
INSERT INTO timezone VALUES("6","CET","1477789200","3600","0");
INSERT INTO timezone VALUES("6","CEST","1490490000","7200","1");
INSERT INTO timezone VALUES("6","CET","1509238800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1521939600","7200","1");
INSERT INTO timezone VALUES("6","CET","1540688400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1553994000","7200","1");
INSERT INTO timezone VALUES("6","CET","1572138000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1585443600","7200","1");
INSERT INTO timezone VALUES("6","CET","1603587600","3600","0");
INSERT INTO timezone VALUES("6","CEST","1616893200","7200","1");
INSERT INTO timezone VALUES("6","CET","1635642000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1648342800","7200","1");
INSERT INTO timezone VALUES("6","CET","1667091600","3600","0");
INSERT INTO timezone VALUES("6","CEST","1679792400","7200","1");
INSERT INTO timezone VALUES("6","CET","1698541200","3600","0");
INSERT INTO timezone VALUES("6","CEST","1711846800","7200","1");
INSERT INTO timezone VALUES("6","CET","1729990800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1743296400","7200","1");
INSERT INTO timezone VALUES("6","CET","1761440400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1774746000","7200","1");
INSERT INTO timezone VALUES("6","CET","1792890000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1806195600","7200","1");
INSERT INTO timezone VALUES("6","CET","1824944400","3600","0");
INSERT INTO timezone VALUES("6","CEST","1837645200","7200","1");
INSERT INTO timezone VALUES("6","CET","1856394000","3600","0");
INSERT INTO timezone VALUES("6","CEST","1869094800","7200","1");
INSERT INTO timezone VALUES("6","CET","1887843600","3600","0");
INSERT INTO timezone VALUES("6","CEST","1901149200","7200","1");
INSERT INTO timezone VALUES("6","CET","1919293200","3600","0");
INSERT INTO timezone VALUES("6","CEST","1932598800","7200","1");
INSERT INTO timezone VALUES("6","CET","1950742800","3600","0");
INSERT INTO timezone VALUES("6","CEST","1964048400","7200","1");
INSERT INTO timezone VALUES("6","CET","1982797200","3600","0");
INSERT INTO timezone VALUES("6","CEST","1995498000","7200","1");
INSERT INTO timezone VALUES("6","CET","2014246800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2026947600","7200","1");
INSERT INTO timezone VALUES("6","CET","2045696400","3600","0");
INSERT INTO timezone VALUES("6","CEST","2058397200","7200","1");
INSERT INTO timezone VALUES("6","CET","2077146000","3600","0");
INSERT INTO timezone VALUES("6","CEST","2090451600","7200","1");
INSERT INTO timezone VALUES("6","CET","2108595600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2121901200","7200","1");
INSERT INTO timezone VALUES("6","CET","2140045200","3600","0");
INSERT INTO timezone VALUES("6","CEST","2153350800","7200","1");
INSERT INTO timezone VALUES("6","CET","2172099600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2184800400","7200","1");
INSERT INTO timezone VALUES("6","CET","2203549200","3600","0");
INSERT INTO timezone VALUES("6","CEST","2216250000","7200","1");
INSERT INTO timezone VALUES("6","CET","2234998800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2248304400","7200","1");
INSERT INTO timezone VALUES("6","CET","2266448400","3600","0");
INSERT INTO timezone VALUES("6","CEST","2279754000","7200","1");
INSERT INTO timezone VALUES("6","CET","2297898000","3600","0");
INSERT INTO timezone VALUES("6","CEST","2311203600","7200","1");
INSERT INTO timezone VALUES("6","CET","2329347600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2342653200","7200","1");
INSERT INTO timezone VALUES("6","CET","2361402000","3600","0");
INSERT INTO timezone VALUES("6","CEST","2374102800","7200","1");
INSERT INTO timezone VALUES("6","CET","2392851600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2405552400","7200","1");
INSERT INTO timezone VALUES("6","CET","2424301200","3600","0");
INSERT INTO timezone VALUES("6","CEST","2437606800","7200","1");
INSERT INTO timezone VALUES("6","CET","2455750800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2469056400","7200","1");
INSERT INTO timezone VALUES("6","CET","2487200400","3600","0");
INSERT INTO timezone VALUES("6","CEST","2500506000","7200","1");
INSERT INTO timezone VALUES("6","CET","2519254800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2531955600","7200","1");
INSERT INTO timezone VALUES("6","CET","2550704400","3600","0");
INSERT INTO timezone VALUES("6","CEST","2563405200","7200","1");
INSERT INTO timezone VALUES("6","CET","2582154000","3600","0");
INSERT INTO timezone VALUES("6","CEST","2595459600","7200","1");
INSERT INTO timezone VALUES("6","CET","2613603600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2626909200","7200","1");
INSERT INTO timezone VALUES("6","CET","2645053200","3600","0");
INSERT INTO timezone VALUES("6","CEST","2658358800","7200","1");
INSERT INTO timezone VALUES("6","CET","2676502800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2689808400","7200","1");
INSERT INTO timezone VALUES("6","CET","2708557200","3600","0");
INSERT INTO timezone VALUES("6","CEST","2721258000","7200","1");
INSERT INTO timezone VALUES("6","CET","2740006800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2752707600","7200","1");
INSERT INTO timezone VALUES("6","CET","2771456400","3600","0");
INSERT INTO timezone VALUES("6","CEST","2784762000","7200","1");
INSERT INTO timezone VALUES("6","CET","2802906000","3600","0");
INSERT INTO timezone VALUES("6","CEST","2816211600","7200","1");
INSERT INTO timezone VALUES("6","CET","2834355600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2847661200","7200","1");
INSERT INTO timezone VALUES("6","CET","2866410000","3600","0");
INSERT INTO timezone VALUES("6","CEST","2879110800","7200","1");
INSERT INTO timezone VALUES("6","CET","2897859600","3600","0");
INSERT INTO timezone VALUES("6","CEST","2910560400","7200","1");
INSERT INTO timezone VALUES("6","CET","2929309200","3600","0");
INSERT INTO timezone VALUES("6","CEST","2942010000","7200","1");
INSERT INTO timezone VALUES("6","CET","2960758800","3600","0");
INSERT INTO timezone VALUES("6","CEST","2974064400","7200","1");
INSERT INTO timezone VALUES("6","CET","2992208400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3005514000","7200","1");
INSERT INTO timezone VALUES("6","CET","3023658000","3600","0");
INSERT INTO timezone VALUES("6","CEST","3036963600","7200","1");
INSERT INTO timezone VALUES("6","CET","3055712400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3068413200","7200","1");
INSERT INTO timezone VALUES("6","CET","3087162000","3600","0");
INSERT INTO timezone VALUES("6","CEST","3099862800","7200","1");
INSERT INTO timezone VALUES("6","CET","3118611600","3600","0");
INSERT INTO timezone VALUES("6","CEST","3131917200","7200","1");
INSERT INTO timezone VALUES("6","CET","3150061200","3600","0");
INSERT INTO timezone VALUES("6","CEST","3163366800","7200","1");
INSERT INTO timezone VALUES("6","CET","3181510800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3194816400","7200","1");
INSERT INTO timezone VALUES("6","CET","3212960400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3226266000","7200","1");
INSERT INTO timezone VALUES("6","CET","3245014800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3257715600","7200","1");
INSERT INTO timezone VALUES("6","CET","3276464400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3289165200","7200","1");
INSERT INTO timezone VALUES("6","CET","3307914000","3600","0");
INSERT INTO timezone VALUES("6","CEST","3321219600","7200","1");
INSERT INTO timezone VALUES("6","CET","3339363600","3600","0");
INSERT INTO timezone VALUES("6","CEST","3352669200","7200","1");
INSERT INTO timezone VALUES("6","CET","3370813200","3600","0");
INSERT INTO timezone VALUES("6","CEST","3384118800","7200","1");
INSERT INTO timezone VALUES("6","CET","3402867600","3600","0");
INSERT INTO timezone VALUES("6","CEST","3415568400","7200","1");
INSERT INTO timezone VALUES("6","CET","3434317200","3600","0");
INSERT INTO timezone VALUES("6","CEST","3447018000","7200","1");
INSERT INTO timezone VALUES("6","CET","3465766800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3479072400","7200","1");
INSERT INTO timezone VALUES("6","CET","3497216400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3510522000","7200","1");
INSERT INTO timezone VALUES("6","CET","3528666000","3600","0");
INSERT INTO timezone VALUES("6","CEST","3541971600","7200","1");
INSERT INTO timezone VALUES("6","CET","3560115600","3600","0");
INSERT INTO timezone VALUES("6","CEST","3573421200","7200","1");
INSERT INTO timezone VALUES("6","CET","3592170000","3600","0");
INSERT INTO timezone VALUES("6","CEST","3604870800","7200","1");
INSERT INTO timezone VALUES("6","CET","3623619600","3600","0");
INSERT INTO timezone VALUES("6","CEST","3636320400","7200","1");
INSERT INTO timezone VALUES("6","CET","3655069200","3600","0");
INSERT INTO timezone VALUES("6","CEST","3668374800","7200","1");
INSERT INTO timezone VALUES("6","CET","3686518800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3699824400","7200","1");
INSERT INTO timezone VALUES("6","CET","3717968400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3731274000","7200","1");
INSERT INTO timezone VALUES("6","CET","3750022800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3762723600","7200","1");
INSERT INTO timezone VALUES("6","CET","3781472400","3600","0");
INSERT INTO timezone VALUES("6","CEST","3794173200","7200","1");
INSERT INTO timezone VALUES("6","CET","3812922000","3600","0");
INSERT INTO timezone VALUES("6","CEST","3825622800","7200","1");
INSERT INTO timezone VALUES("6","CET","3844371600","3600","0");
INSERT INTO timezone VALUES("6","CEST","3857677200","7200","1");
INSERT INTO timezone VALUES("6","CET","3875821200","3600","0");
INSERT INTO timezone VALUES("6","CEST","3889126800","7200","1");
INSERT INTO timezone VALUES("6","CET","3907270800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3920576400","7200","1");
INSERT INTO timezone VALUES("6","CET","3939325200","3600","0");
INSERT INTO timezone VALUES("6","CEST","3952026000","7200","1");
INSERT INTO timezone VALUES("6","CET","3970774800","3600","0");
INSERT INTO timezone VALUES("6","CEST","3983475600","7200","1");
INSERT INTO timezone VALUES("6","CET","4002224400","3600","0");
INSERT INTO timezone VALUES("6","CEST","4015530000","7200","1");
INSERT INTO timezone VALUES("6","CET","4033674000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4046979600","7200","1");
INSERT INTO timezone VALUES("6","CET","4065123600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4078429200","7200","1");
INSERT INTO timezone VALUES("6","CET","4096573200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4109878800","7200","1");
INSERT INTO timezone VALUES("6","CET","4128627600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4141328400","7200","1");
INSERT INTO timezone VALUES("6","CET","4160077200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4172778000","7200","1");
INSERT INTO timezone VALUES("6","CET","4191526800","3600","0");
INSERT INTO timezone VALUES("6","CEST","4204227600","7200","1");
INSERT INTO timezone VALUES("6","CET","4222976400","3600","0");
INSERT INTO timezone VALUES("6","CEST","4236282000","7200","1");
INSERT INTO timezone VALUES("6","CET","4254426000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4267731600","7200","1");
INSERT INTO timezone VALUES("6","CET","4285875600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4299181200","7200","1");
INSERT INTO timezone VALUES("6","CET","4317930000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4330630800","7200","1");
INSERT INTO timezone VALUES("6","CET","4349379600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4362080400","7200","1");
INSERT INTO timezone VALUES("6","CET","4380829200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4394134800","7200","1");
INSERT INTO timezone VALUES("6","CET","4412278800","3600","0");
INSERT INTO timezone VALUES("6","CEST","4425584400","7200","1");
INSERT INTO timezone VALUES("6","CET","4443728400","3600","0");
INSERT INTO timezone VALUES("6","CEST","4457034000","7200","1");
INSERT INTO timezone VALUES("6","CET","4475178000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4488483600","7200","1");
INSERT INTO timezone VALUES("6","CET","4507232400","3600","0");
INSERT INTO timezone VALUES("6","CEST","4519933200","7200","1");
INSERT INTO timezone VALUES("6","CET","4538682000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4551382800","7200","1");
INSERT INTO timezone VALUES("6","CET","4570131600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4583437200","7200","1");
INSERT INTO timezone VALUES("6","CET","4601581200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4614886800","7200","1");
INSERT INTO timezone VALUES("6","CET","4633030800","3600","0");
INSERT INTO timezone VALUES("6","CEST","4646336400","7200","1");
INSERT INTO timezone VALUES("6","CET","4665085200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4677786000","7200","1");
INSERT INTO timezone VALUES("6","CET","4696534800","3600","0");
INSERT INTO timezone VALUES("6","CEST","4709235600","7200","1");
INSERT INTO timezone VALUES("6","CET","4727984400","3600","0");
INSERT INTO timezone VALUES("6","CEST","4741290000","7200","1");
INSERT INTO timezone VALUES("6","CET","4759434000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4772739600","7200","1");
INSERT INTO timezone VALUES("6","CET","4790883600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4804189200","7200","1");
INSERT INTO timezone VALUES("6","CET","4822333200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4835638800","7200","1");
INSERT INTO timezone VALUES("6","CET","4854387600","3600","0");
INSERT INTO timezone VALUES("6","CEST","4867088400","7200","1");
INSERT INTO timezone VALUES("6","CET","4885837200","3600","0");
INSERT INTO timezone VALUES("6","CEST","4898538000","7200","1");
INSERT INTO timezone VALUES("6","CET","4917286800","3600","0");
INSERT INTO timezone VALUES("6","CEST","4930592400","7200","1");
INSERT INTO timezone VALUES("6","CET","4948736400","3600","0");
INSERT INTO timezone VALUES("6","CEST","4962042000","7200","1");
INSERT INTO timezone VALUES("6","CET","4980186000","3600","0");
INSERT INTO timezone VALUES("6","CEST","4993491600","7200","1");
INSERT INTO timezone VALUES("6","CET","5012240400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5024941200","7200","1");
INSERT INTO timezone VALUES("6","CET","5043690000","3600","0");
INSERT INTO timezone VALUES("6","CEST","5056390800","7200","1");
INSERT INTO timezone VALUES("6","CET","5075139600","3600","0");
INSERT INTO timezone VALUES("6","CEST","5087840400","7200","1");
INSERT INTO timezone VALUES("6","CET","5106589200","3600","0");
INSERT INTO timezone VALUES("6","CEST","5119894800","7200","1");
INSERT INTO timezone VALUES("6","CET","5138038800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5151344400","7200","1");
INSERT INTO timezone VALUES("6","CET","5169488400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5182794000","7200","1");
INSERT INTO timezone VALUES("6","CET","5201542800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5214243600","7200","1");
INSERT INTO timezone VALUES("6","CET","5232992400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5245693200","7200","1");
INSERT INTO timezone VALUES("6","CET","5264442000","3600","0");
INSERT INTO timezone VALUES("6","CEST","5277747600","7200","1");
INSERT INTO timezone VALUES("6","CET","5295891600","3600","0");
INSERT INTO timezone VALUES("6","CEST","5309197200","7200","1");
INSERT INTO timezone VALUES("6","CET","5327341200","3600","0");
INSERT INTO timezone VALUES("6","CEST","5340646800","7200","1");
INSERT INTO timezone VALUES("6","CET","5358790800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5372096400","7200","1");
INSERT INTO timezone VALUES("6","CET","5390845200","3600","0");
INSERT INTO timezone VALUES("6","CEST","5403546000","7200","1");
INSERT INTO timezone VALUES("6","CET","5422294800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5434995600","7200","1");
INSERT INTO timezone VALUES("6","CET","5453744400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5467050000","7200","1");
INSERT INTO timezone VALUES("6","CET","5485194000","3600","0");
INSERT INTO timezone VALUES("6","CEST","5498499600","7200","1");
INSERT INTO timezone VALUES("6","CET","5516643600","3600","0");
INSERT INTO timezone VALUES("6","CEST","5529949200","7200","1");
INSERT INTO timezone VALUES("6","CET","5548698000","3600","0");
INSERT INTO timezone VALUES("6","CEST","5561398800","7200","1");
INSERT INTO timezone VALUES("6","CET","5580147600","3600","0");
INSERT INTO timezone VALUES("6","CEST","5592848400","7200","1");
INSERT INTO timezone VALUES("6","CET","5611597200","3600","0");
INSERT INTO timezone VALUES("6","CEST","5624902800","7200","1");
INSERT INTO timezone VALUES("6","CET","5643046800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5656352400","7200","1");
INSERT INTO timezone VALUES("6","CET","5674496400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5687802000","7200","1");
INSERT INTO timezone VALUES("6","CET","5705946000","3600","0");
INSERT INTO timezone VALUES("6","CEST","5719251600","7200","1");
INSERT INTO timezone VALUES("6","CET","5738000400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5750701200","7200","1");
INSERT INTO timezone VALUES("6","CET","5769450000","3600","0");
INSERT INTO timezone VALUES("6","CEST","5782150800","7200","1");
INSERT INTO timezone VALUES("6","CET","5800899600","3600","0");
INSERT INTO timezone VALUES("6","CEST","5814205200","7200","1");
INSERT INTO timezone VALUES("6","CET","5832349200","3600","0");
INSERT INTO timezone VALUES("6","CEST","5845654800","7200","1");
INSERT INTO timezone VALUES("6","CET","5863798800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5877104400","7200","1");
INSERT INTO timezone VALUES("6","CET","5895853200","3600","0");
INSERT INTO timezone VALUES("6","CEST","5908554000","7200","1");
INSERT INTO timezone VALUES("6","CET","5927302800","3600","0");
INSERT INTO timezone VALUES("6","CEST","5940003600","7200","1");
INSERT INTO timezone VALUES("6","CET","5958752400","3600","0");
INSERT INTO timezone VALUES("6","CEST","5971453200","7200","1");
INSERT INTO timezone VALUES("6","CET","5990202000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6003507600","7200","1");
INSERT INTO timezone VALUES("6","CET","6021651600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6034957200","7200","1");
INSERT INTO timezone VALUES("6","CET","6053101200","3600","0");
INSERT INTO timezone VALUES("6","CEST","6066406800","7200","1");
INSERT INTO timezone VALUES("6","CET","6085155600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6097856400","7200","1");
INSERT INTO timezone VALUES("6","CET","6116605200","3600","0");
INSERT INTO timezone VALUES("6","CEST","6129306000","7200","1");
INSERT INTO timezone VALUES("6","CET","6148054800","3600","0");
INSERT INTO timezone VALUES("6","CEST","6161360400","7200","1");
INSERT INTO timezone VALUES("6","CET","6179504400","3600","0");
INSERT INTO timezone VALUES("6","CEST","6192810000","7200","1");
INSERT INTO timezone VALUES("6","CET","6210954000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6224259600","7200","1");
INSERT INTO timezone VALUES("6","CET","6242403600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6255709200","7200","1");
INSERT INTO timezone VALUES("6","CET","6274458000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6287158800","7200","1");
INSERT INTO timezone VALUES("6","CET","6305907600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6318608400","7200","1");
INSERT INTO timezone VALUES("6","CET","6337357200","3600","0");
INSERT INTO timezone VALUES("6","CEST","6350662800","7200","1");
INSERT INTO timezone VALUES("6","CET","6368806800","3600","0");
INSERT INTO timezone VALUES("6","CEST","6382112400","7200","1");
INSERT INTO timezone VALUES("6","CET","6400256400","3600","0");
INSERT INTO timezone VALUES("6","CEST","6413562000","7200","1");
INSERT INTO timezone VALUES("6","CET","6432310800","3600","0");
INSERT INTO timezone VALUES("6","CEST","6445011600","7200","1");
INSERT INTO timezone VALUES("6","CET","6463760400","3600","0");
INSERT INTO timezone VALUES("6","CEST","6476461200","7200","1");
INSERT INTO timezone VALUES("6","CET","6495210000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6508515600","7200","1");
INSERT INTO timezone VALUES("6","CET","6526659600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6539965200","7200","1");
INSERT INTO timezone VALUES("6","CET","6558109200","3600","0");
INSERT INTO timezone VALUES("6","CEST","6571414800","7200","1");
INSERT INTO timezone VALUES("6","CET","6589558800","3600","0");
INSERT INTO timezone VALUES("6","CEST","6602864400","7200","1");
INSERT INTO timezone VALUES("6","CET","6621613200","3600","0");
INSERT INTO timezone VALUES("6","CEST","6634314000","7200","1");
INSERT INTO timezone VALUES("6","CET","6653062800","3600","0");
INSERT INTO timezone VALUES("6","CEST","6665763600","7200","1");
INSERT INTO timezone VALUES("6","CET","6684512400","3600","0");
INSERT INTO timezone VALUES("6","CEST","6697818000","7200","1");
INSERT INTO timezone VALUES("6","CET","6715962000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6729267600","7200","1");
INSERT INTO timezone VALUES("6","CET","6747411600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6760717200","7200","1");
INSERT INTO timezone VALUES("6","CET","6779466000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6792166800","7200","1");
INSERT INTO timezone VALUES("6","CET","6810915600","3600","0");
INSERT INTO timezone VALUES("6","CEST","6823616400","7200","1");
INSERT INTO timezone VALUES("6","CET","6842365200","3600","0");
INSERT INTO timezone VALUES("6","CEST","6855066000","7200","1");
INSERT INTO timezone VALUES("6","CET","6873814800","3600","0");
INSERT INTO timezone VALUES("6","CEST","6887120400","7200","1");
INSERT INTO timezone VALUES("6","CET","6905264400","3600","0");
INSERT INTO timezone VALUES("6","CEST","6918570000","7200","1");
INSERT INTO timezone VALUES("6","CET","6936714000","3600","0");
INSERT INTO timezone VALUES("6","CEST","6950019600","7200","1");
INSERT INTO timezone VALUES("6","CET","6968768400","3600","0");
INSERT INTO timezone VALUES("6","CEST","6981469200","7200","1");
INSERT INTO timezone VALUES("6","CET","7000218000","3600","0");
INSERT INTO timezone VALUES("6","CEST","7012918800","7200","1");
INSERT INTO timezone VALUES("6","CET","7031667600","3600","0");
INSERT INTO timezone VALUES("6","CEST","7044973200","7200","1");
INSERT INTO timezone VALUES("6","CET","7063117200","3600","0");
INSERT INTO timezone VALUES("6","CEST","7076422800","7200","1");
INSERT INTO timezone VALUES("6","CET","7094566800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7107872400","7200","1");
INSERT INTO timezone VALUES("6","CET","7126016400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7139322000","7200","1");
INSERT INTO timezone VALUES("6","CET","7158070800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7170771600","7200","1");
INSERT INTO timezone VALUES("6","CET","7189520400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7202221200","7200","1");
INSERT INTO timezone VALUES("6","CET","7220970000","3600","0");
INSERT INTO timezone VALUES("6","CEST","7234275600","7200","1");
INSERT INTO timezone VALUES("6","CET","7252419600","3600","0");
INSERT INTO timezone VALUES("6","CEST","7265725200","7200","1");
INSERT INTO timezone VALUES("6","CET","7283869200","3600","0");
INSERT INTO timezone VALUES("6","CEST","7297174800","7200","1");
INSERT INTO timezone VALUES("6","CET","7315318800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7328624400","7200","1");
INSERT INTO timezone VALUES("6","CET","7347373200","3600","0");
INSERT INTO timezone VALUES("6","CEST","7360074000","7200","1");
INSERT INTO timezone VALUES("6","CET","7378822800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7391523600","7200","1");
INSERT INTO timezone VALUES("6","CET","7410272400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7423578000","7200","1");
INSERT INTO timezone VALUES("6","CET","7441722000","3600","0");
INSERT INTO timezone VALUES("6","CEST","7455027600","7200","1");
INSERT INTO timezone VALUES("6","CET","7473171600","3600","0");
INSERT INTO timezone VALUES("6","CEST","7486477200","7200","1");
INSERT INTO timezone VALUES("6","CET","7504621200","3600","0");
INSERT INTO timezone VALUES("6","CEST","7517926800","7200","1");
INSERT INTO timezone VALUES("6","CET","7536675600","3600","0");
INSERT INTO timezone VALUES("6","CEST","7549376400","7200","1");
INSERT INTO timezone VALUES("6","CET","7568125200","3600","0");
INSERT INTO timezone VALUES("6","CEST","7580826000","7200","1");
INSERT INTO timezone VALUES("6","CET","7599574800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7612880400","7200","1");
INSERT INTO timezone VALUES("6","CET","7631024400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7644330000","7200","1");
INSERT INTO timezone VALUES("6","CET","7662474000","3600","0");
INSERT INTO timezone VALUES("6","CEST","7675779600","7200","1");
INSERT INTO timezone VALUES("6","CET","7694528400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7707229200","7200","1");
INSERT INTO timezone VALUES("6","CET","7725978000","3600","0");
INSERT INTO timezone VALUES("6","CEST","7738678800","7200","1");
INSERT INTO timezone VALUES("6","CET","7757427600","3600","0");
INSERT INTO timezone VALUES("6","CEST","7770733200","7200","1");
INSERT INTO timezone VALUES("6","CET","7788877200","3600","0");
INSERT INTO timezone VALUES("6","CEST","7802182800","7200","1");
INSERT INTO timezone VALUES("6","CET","7820326800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7833632400","7200","1");
INSERT INTO timezone VALUES("6","CET","7851776400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7865082000","7200","1");
INSERT INTO timezone VALUES("6","CET","7883830800","3600","0");
INSERT INTO timezone VALUES("6","CEST","7896531600","7200","1");
INSERT INTO timezone VALUES("6","CET","7915280400","3600","0");
INSERT INTO timezone VALUES("6","CEST","7927981200","7200","1");
INSERT INTO timezone VALUES("6","CET","7946730000","3600","0");
INSERT INTO timezone VALUES("6","CEST","7960035600","7200","1");
INSERT INTO timezone VALUES("6","CET","7978179600","3600","0");
INSERT INTO timezone VALUES("6","CEST","7991485200","7200","1");
INSERT INTO timezone VALUES("6","CET","8009629200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8022934800","7200","1");
INSERT INTO timezone VALUES("6","CET","8041683600","3600","0");
INSERT INTO timezone VALUES("6","CEST","8054384400","7200","1");
INSERT INTO timezone VALUES("6","CET","8073133200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8085834000","7200","1");
INSERT INTO timezone VALUES("6","CET","8104582800","3600","0");
INSERT INTO timezone VALUES("6","CEST","8117283600","7200","1");
INSERT INTO timezone VALUES("6","CET","8136032400","3600","0");
INSERT INTO timezone VALUES("6","CEST","8149338000","7200","1");
INSERT INTO timezone VALUES("6","CET","8167482000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8180787600","7200","1");
INSERT INTO timezone VALUES("6","CET","8198931600","3600","0");
INSERT INTO timezone VALUES("6","CEST","8212237200","7200","1");
INSERT INTO timezone VALUES("6","CET","8230986000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8243686800","7200","1");
INSERT INTO timezone VALUES("6","CET","8262435600","3600","0");
INSERT INTO timezone VALUES("6","CEST","8275136400","7200","1");
INSERT INTO timezone VALUES("6","CET","8293885200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8307190800","7200","1");
INSERT INTO timezone VALUES("6","CET","8325334800","3600","0");
INSERT INTO timezone VALUES("6","CEST","8338640400","7200","1");
INSERT INTO timezone VALUES("6","CET","8356784400","3600","0");
INSERT INTO timezone VALUES("6","CEST","8370090000","7200","1");
INSERT INTO timezone VALUES("6","CET","8388234000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8401539600","7200","1");
INSERT INTO timezone VALUES("6","CET","8420288400","3600","0");
INSERT INTO timezone VALUES("6","CEST","8432989200","7200","1");
INSERT INTO timezone VALUES("6","CET","8451738000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8464438800","7200","1");
INSERT INTO timezone VALUES("6","CET","8483187600","3600","0");
INSERT INTO timezone VALUES("6","CEST","8496493200","7200","1");
INSERT INTO timezone VALUES("6","CET","8514637200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8527942800","7200","1");
INSERT INTO timezone VALUES("6","CET","8546086800","3600","0");
INSERT INTO timezone VALUES("6","CEST","8559392400","7200","1");
INSERT INTO timezone VALUES("6","CET","8578141200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8590842000","7200","1");
INSERT INTO timezone VALUES("6","CET","8609590800","3600","0");
INSERT INTO timezone VALUES("6","CEST","8622291600","7200","1");
INSERT INTO timezone VALUES("6","CET","8641040400","3600","0");
INSERT INTO timezone VALUES("6","CEST","8654346000","7200","1");
INSERT INTO timezone VALUES("6","CET","8672490000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8685795600","7200","1");
INSERT INTO timezone VALUES("6","CET","8703939600","3600","0");
INSERT INTO timezone VALUES("6","CEST","8717245200","7200","1");
INSERT INTO timezone VALUES("6","CET","8735389200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8748694800","7200","1");
INSERT INTO timezone VALUES("6","CET","8767443600","3600","0");
INSERT INTO timezone VALUES("6","CEST","8780144400","7200","1");
INSERT INTO timezone VALUES("6","CET","8798893200","3600","0");
INSERT INTO timezone VALUES("6","CEST","8811594000","7200","1");
INSERT INTO timezone VALUES("6","CET","8830342800","3600","0");
INSERT INTO timezone VALUES("6","CEST","8843648400","7200","1");
INSERT INTO timezone VALUES("6","CET","8861792400","3600","0");
INSERT INTO timezone VALUES("6","CEST","8875098000","7200","1");
INSERT INTO timezone VALUES("6","CET","8893242000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8906547600","7200","1");
INSERT INTO timezone VALUES("6","CET","8925296400","3600","0");
INSERT INTO timezone VALUES("6","CEST","8937997200","7200","1");
INSERT INTO timezone VALUES("6","CET","8956746000","3600","0");
INSERT INTO timezone VALUES("6","CEST","8969446800","7200","1");
INSERT INTO timezone VALUES("6","CET","8988195600","3600","0");
INSERT INTO timezone VALUES("6","CEST","9000896400","7200","1");
INSERT INTO timezone VALUES("6","CET","9019645200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9032950800","7200","1");
INSERT INTO timezone VALUES("6","CET","9051094800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9064400400","7200","1");
INSERT INTO timezone VALUES("6","CET","9082544400","3600","0");
INSERT INTO timezone VALUES("6","CEST","9095850000","7200","1");
INSERT INTO timezone VALUES("6","CET","9114598800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9127299600","7200","1");
INSERT INTO timezone VALUES("6","CET","9146048400","3600","0");
INSERT INTO timezone VALUES("6","CEST","9158749200","7200","1");
INSERT INTO timezone VALUES("6","CET","9177498000","3600","0");
INSERT INTO timezone VALUES("6","CEST","9190803600","7200","1");
INSERT INTO timezone VALUES("6","CET","9208947600","3600","0");
INSERT INTO timezone VALUES("6","CEST","9222253200","7200","1");
INSERT INTO timezone VALUES("6","CET","9240397200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9253702800","7200","1");
INSERT INTO timezone VALUES("6","CET","9271846800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9285152400","7200","1");
INSERT INTO timezone VALUES("6","CET","9303901200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9316602000","7200","1");
INSERT INTO timezone VALUES("6","CET","9335350800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9348051600","7200","1");
INSERT INTO timezone VALUES("6","CET","9366800400","3600","0");
INSERT INTO timezone VALUES("6","CEST","9380106000","7200","1");
INSERT INTO timezone VALUES("6","CET","9398250000","3600","0");
INSERT INTO timezone VALUES("6","CEST","9411555600","7200","1");
INSERT INTO timezone VALUES("6","CET","9429699600","3600","0");
INSERT INTO timezone VALUES("6","CEST","9443005200","7200","1");
INSERT INTO timezone VALUES("6","CET","9461754000","3600","0");
INSERT INTO timezone VALUES("6","CEST","9474454800","7200","1");
INSERT INTO timezone VALUES("6","CET","9493203600","3600","0");
INSERT INTO timezone VALUES("6","CEST","9505904400","7200","1");
INSERT INTO timezone VALUES("6","CET","9524653200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9537958800","7200","1");
INSERT INTO timezone VALUES("6","CET","9556102800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9569408400","7200","1");
INSERT INTO timezone VALUES("6","CET","9587552400","3600","0");
INSERT INTO timezone VALUES("6","CEST","9600858000","7200","1");
INSERT INTO timezone VALUES("6","CET","9619002000","3600","0");
INSERT INTO timezone VALUES("6","CEST","9632307600","7200","1");
INSERT INTO timezone VALUES("6","CET","9651056400","3600","0");
INSERT INTO timezone VALUES("6","CEST","9663757200","7200","1");
INSERT INTO timezone VALUES("6","CET","9682506000","3600","0");
INSERT INTO timezone VALUES("6","CEST","9695206800","7200","1");
INSERT INTO timezone VALUES("6","CET","9713955600","3600","0");
INSERT INTO timezone VALUES("6","CEST","9727261200","7200","1");
INSERT INTO timezone VALUES("6","CET","9745405200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9758710800","7200","1");
INSERT INTO timezone VALUES("6","CET","9776854800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9790160400","7200","1");
INSERT INTO timezone VALUES("6","CET","9808909200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9821610000","7200","1");
INSERT INTO timezone VALUES("6","CET","9840358800","3600","0");
INSERT INTO timezone VALUES("6","CEST","9853059600","7200","1");
INSERT INTO timezone VALUES("6","CET","9871808400","3600","0");
INSERT INTO timezone VALUES("6","CEST","9884509200","7200","1");
INSERT INTO timezone VALUES("6","CET","9903258000","3600","0");
INSERT INTO timezone VALUES("6","CEST","9916563600","7200","1");
INSERT INTO timezone VALUES("6","CET","9934707600","3600","0");
INSERT INTO timezone VALUES("6","CEST","9948013200","7200","1");
INSERT INTO timezone VALUES("6","CET","9966157200","3600","0");
INSERT INTO timezone VALUES("6","CEST","9979462800","7200","1");
INSERT INTO timezone VALUES("6","CET","9998211600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10010912400","7200","1");
INSERT INTO timezone VALUES("6","CET","10029661200","3600","0");
INSERT INTO timezone VALUES("6","CEST","10042362000","7200","1");
INSERT INTO timezone VALUES("6","CET","10061110800","3600","0");
INSERT INTO timezone VALUES("6","CEST","10074416400","7200","1");
INSERT INTO timezone VALUES("6","CET","10092560400","3600","0");
INSERT INTO timezone VALUES("6","CEST","10105866000","7200","1");
INSERT INTO timezone VALUES("6","CET","10124010000","3600","0");
INSERT INTO timezone VALUES("6","CEST","10137315600","7200","1");
INSERT INTO timezone VALUES("6","CET","10155459600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10168765200","7200","1");
INSERT INTO timezone VALUES("6","CET","10187514000","3600","0");
INSERT INTO timezone VALUES("6","CEST","10200214800","7200","1");
INSERT INTO timezone VALUES("6","CET","10218963600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10231664400","7200","1");
INSERT INTO timezone VALUES("6","CET","10250413200","3600","0");
INSERT INTO timezone VALUES("6","CEST","10263718800","7200","1");
INSERT INTO timezone VALUES("6","CET","10281862800","3600","0");
INSERT INTO timezone VALUES("6","CEST","10295168400","7200","1");
INSERT INTO timezone VALUES("6","CET","10313312400","3600","0");
INSERT INTO timezone VALUES("6","CEST","10326618000","7200","1");
INSERT INTO timezone VALUES("6","CET","10345366800","3600","0");
INSERT INTO timezone VALUES("6","CEST","10358067600","7200","1");
INSERT INTO timezone VALUES("6","CET","10376816400","3600","0");
INSERT INTO timezone VALUES("6","CEST","10389517200","7200","1");
INSERT INTO timezone VALUES("6","CET","10408266000","3600","0");
INSERT INTO timezone VALUES("6","CEST","10420966800","7200","1");
INSERT INTO timezone VALUES("6","CET","10439715600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10453021200","7200","1");
INSERT INTO timezone VALUES("6","CET","10471165200","3600","0");
INSERT INTO timezone VALUES("6","CEST","10484470800","7200","1");
INSERT INTO timezone VALUES("6","CET","10502614800","3600","0");
INSERT INTO timezone VALUES("6","CEST","10515920400","7200","1");
INSERT INTO timezone VALUES("6","CET","10534064400","3600","0");
INSERT INTO timezone VALUES("6","CEST","10547370000","7200","1");
INSERT INTO timezone VALUES("6","CET","10566118800","3600","0");
INSERT INTO timezone VALUES("6","CEST","10578819600","7200","1");
INSERT INTO timezone VALUES("6","CET","10597568400","3600","0");
INSERT INTO timezone VALUES("6","CEST","10610269200","7200","1");
INSERT INTO timezone VALUES("6","CET","10629018000","3600","0");
INSERT INTO timezone VALUES("6","CEST","10642323600","7200","1");
INSERT INTO timezone VALUES("6","CET","10660467600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10673773200","7200","1");
INSERT INTO timezone VALUES("6","CET","10691917200","3600","0");
INSERT INTO timezone VALUES("6","CEST","10705222800","7200","1");
INSERT INTO timezone VALUES("6","CET","10723971600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10736672400","7200","1");
INSERT INTO timezone VALUES("6","CET","10755421200","3600","0");
INSERT INTO timezone VALUES("6","CEST","10768122000","7200","1");
INSERT INTO timezone VALUES("6","CET","10786870800","3600","0");
INSERT INTO timezone VALUES("6","CEST","10800176400","7200","1");
INSERT INTO timezone VALUES("6","CET","10818320400","3600","0");
INSERT INTO timezone VALUES("6","CEST","10831626000","7200","1");
INSERT INTO timezone VALUES("6","CET","10849770000","3600","0");
INSERT INTO timezone VALUES("6","CEST","10863075600","7200","1");
INSERT INTO timezone VALUES("6","CET","10881219600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10894525200","7200","1");
INSERT INTO timezone VALUES("6","CET","10913274000","3600","0");
INSERT INTO timezone VALUES("6","CEST","10925974800","7200","1");
INSERT INTO timezone VALUES("6","CET","10944723600","3600","0");
INSERT INTO timezone VALUES("6","CEST","10957424400","7200","1");
INSERT INTO timezone VALUES("6","CET","10976173200","3600","0");
INSERT INTO timezone VALUES("6","CEST","10989478800","7200","1");
INSERT INTO timezone VALUES("6","CET","11007622800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11020928400","7200","1");
INSERT INTO timezone VALUES("6","CET","11039072400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11052378000","7200","1");
INSERT INTO timezone VALUES("6","CET","11071126800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11083827600","7200","1");
INSERT INTO timezone VALUES("6","CET","11102576400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11115277200","7200","1");
INSERT INTO timezone VALUES("6","CET","11134026000","3600","0");
INSERT INTO timezone VALUES("6","CEST","11146726800","7200","1");
INSERT INTO timezone VALUES("6","CET","11165475600","3600","0");
INSERT INTO timezone VALUES("6","CEST","11178781200","7200","1");
INSERT INTO timezone VALUES("6","CET","11196925200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11210230800","7200","1");
INSERT INTO timezone VALUES("6","CET","11228374800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11241680400","7200","1");
INSERT INTO timezone VALUES("6","CET","11260429200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11273130000","7200","1");
INSERT INTO timezone VALUES("6","CET","11291878800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11304579600","7200","1");
INSERT INTO timezone VALUES("6","CET","11323328400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11336634000","7200","1");
INSERT INTO timezone VALUES("6","CET","11354778000","3600","0");
INSERT INTO timezone VALUES("6","CEST","11368083600","7200","1");
INSERT INTO timezone VALUES("6","CET","11386227600","3600","0");
INSERT INTO timezone VALUES("6","CEST","11399533200","7200","1");
INSERT INTO timezone VALUES("6","CET","11417677200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11430982800","7200","1");
INSERT INTO timezone VALUES("6","CET","11449731600","3600","0");
INSERT INTO timezone VALUES("6","CEST","11462432400","7200","1");
INSERT INTO timezone VALUES("6","CET","11481181200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11493882000","7200","1");
INSERT INTO timezone VALUES("6","CET","11512630800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11525936400","7200","1");
INSERT INTO timezone VALUES("6","CET","11544080400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11557386000","7200","1");
INSERT INTO timezone VALUES("6","CET","11575530000","3600","0");
INSERT INTO timezone VALUES("6","CEST","11588835600","7200","1");
INSERT INTO timezone VALUES("6","CET","11607584400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11620285200","7200","1");
INSERT INTO timezone VALUES("6","CET","11639034000","3600","0");
INSERT INTO timezone VALUES("6","CEST","11651734800","7200","1");
INSERT INTO timezone VALUES("6","CET","11670483600","3600","0");
INSERT INTO timezone VALUES("6","CEST","11683789200","7200","1");
INSERT INTO timezone VALUES("6","CET","11701933200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11715238800","7200","1");
INSERT INTO timezone VALUES("6","CET","11733382800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11746688400","7200","1");
INSERT INTO timezone VALUES("6","CET","11764832400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11778138000","7200","1");
INSERT INTO timezone VALUES("6","CET","11796886800","3600","0");
INSERT INTO timezone VALUES("6","CEST","11809587600","7200","1");
INSERT INTO timezone VALUES("6","CET","11828336400","3600","0");
INSERT INTO timezone VALUES("6","CEST","11841037200","7200","1");
INSERT INTO timezone VALUES("6","CET","11859786000","3600","0");
INSERT INTO timezone VALUES("6","CEST","11873091600","7200","1");
INSERT INTO timezone VALUES("6","CET","11891235600","3600","0");
INSERT INTO timezone VALUES("6","CEST","11904541200","7200","1");
INSERT INTO timezone VALUES("6","CET","11922685200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11935990800","7200","1");
INSERT INTO timezone VALUES("6","CET","11954739600","3600","0");
INSERT INTO timezone VALUES("6","CEST","11967440400","7200","1");
INSERT INTO timezone VALUES("6","CET","11986189200","3600","0");
INSERT INTO timezone VALUES("6","CEST","11998890000","7200","1");
INSERT INTO timezone VALUES("6","CET","12017638800","3600","0");
INSERT INTO timezone VALUES("6","CEST","12030339600","7200","1");
INSERT INTO timezone VALUES("6","CET","12049088400","3600","0");
INSERT INTO timezone VALUES("6","CEST","12062394000","7200","1");
INSERT INTO timezone VALUES("6","CET","12080538000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12093843600","7200","1");
INSERT INTO timezone VALUES("6","CET","12111987600","3600","0");
INSERT INTO timezone VALUES("6","CEST","12125293200","7200","1");
INSERT INTO timezone VALUES("6","CET","12144042000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12156742800","7200","1");
INSERT INTO timezone VALUES("6","CET","12175491600","3600","0");
INSERT INTO timezone VALUES("6","CEST","12188192400","7200","1");
INSERT INTO timezone VALUES("6","CET","12206941200","3600","0");
INSERT INTO timezone VALUES("6","CEST","12220246800","7200","1");
INSERT INTO timezone VALUES("6","CET","12238390800","3600","0");
INSERT INTO timezone VALUES("6","CEST","12251696400","7200","1");
INSERT INTO timezone VALUES("6","CET","12269840400","3600","0");
INSERT INTO timezone VALUES("6","CEST","12283146000","7200","1");
INSERT INTO timezone VALUES("6","CET","12301290000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12314595600","7200","1");
INSERT INTO timezone VALUES("6","CET","12333344400","3600","0");
INSERT INTO timezone VALUES("6","CEST","12346045200","7200","1");
INSERT INTO timezone VALUES("6","CET","12364794000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12377494800","7200","1");
INSERT INTO timezone VALUES("6","CET","12396243600","3600","0");
INSERT INTO timezone VALUES("6","CEST","12409549200","7200","1");
INSERT INTO timezone VALUES("6","CET","12427693200","3600","0");
INSERT INTO timezone VALUES("6","CEST","12440998800","7200","1");
INSERT INTO timezone VALUES("6","CET","12459142800","3600","0");
INSERT INTO timezone VALUES("6","CEST","12472448400","7200","1");
INSERT INTO timezone VALUES("6","CET","12491197200","3600","0");
INSERT INTO timezone VALUES("6","CEST","12503898000","7200","1");
INSERT INTO timezone VALUES("6","CET","12522646800","3600","0");
INSERT INTO timezone VALUES("6","CEST","12535347600","7200","1");
INSERT INTO timezone VALUES("6","CET","12554096400","3600","0");
INSERT INTO timezone VALUES("6","CEST","12567402000","7200","1");
INSERT INTO timezone VALUES("6","CET","12585546000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12598851600","7200","1");
INSERT INTO timezone VALUES("6","CET","12616995600","3600","0");
INSERT INTO timezone VALUES("6","CEST","12630301200","7200","1");
INSERT INTO timezone VALUES("6","CET","12648445200","3600","0");
INSERT INTO timezone VALUES("6","CEST","12661750800","7200","1");
INSERT INTO timezone VALUES("6","CET","12680499600","3600","0");
INSERT INTO timezone VALUES("6","CEST","12693200400","7200","1");
INSERT INTO timezone VALUES("6","CET","12711949200","3600","0");
INSERT INTO timezone VALUES("6","CEST","12724650000","7200","1");
INSERT INTO timezone VALUES("6","CET","12743398800","3600","0");
INSERT INTO timezone VALUES("6","CEST","12756704400","7200","1");
INSERT INTO timezone VALUES("6","CET","12774848400","3600","0");
INSERT INTO timezone VALUES("6","CEST","12788154000","7200","1");
INSERT INTO timezone VALUES("6","CET","12806298000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12819603600","7200","1");
INSERT INTO timezone VALUES("6","CET","12838352400","3600","0");
INSERT INTO timezone VALUES("6","CEST","12851053200","7200","1");
INSERT INTO timezone VALUES("6","CET","12869802000","3600","0");
INSERT INTO timezone VALUES("6","CEST","12882502800","7200","1");
INSERT INTO timezone VALUES("6","CET","12901251600","3600","0");
INSERT INTO timezone VALUES("6","CEST","12913952400","7200","1");
INSERT INTO timezone VALUES("6","CET","12932701200","3600","0");
INSERT INTO timezone VALUES("6","CEST","12946006800","7200","1");
INSERT INTO timezone VALUES("6","CET","12964150800","3600","0");
INSERT INTO timezone VALUES("6","CEST","12977456400","7200","1");
INSERT INTO timezone VALUES("6","CET","12995600400","3600","0");
INSERT INTO timezone VALUES("6","CEST","13008906000","7200","1");
INSERT INTO timezone VALUES("6","CET","13027654800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13040355600","7200","1");
INSERT INTO timezone VALUES("6","CET","13059104400","3600","0");
INSERT INTO timezone VALUES("6","CEST","13071805200","7200","1");
INSERT INTO timezone VALUES("6","CET","13090554000","3600","0");
INSERT INTO timezone VALUES("6","CEST","13103859600","7200","1");
INSERT INTO timezone VALUES("6","CET","13122003600","3600","0");
INSERT INTO timezone VALUES("6","CEST","13135309200","7200","1");
INSERT INTO timezone VALUES("6","CET","13153453200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13166758800","7200","1");
INSERT INTO timezone VALUES("6","CET","13184902800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13198208400","7200","1");
INSERT INTO timezone VALUES("6","CET","13216957200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13229658000","7200","1");
INSERT INTO timezone VALUES("6","CET","13248406800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13261107600","7200","1");
INSERT INTO timezone VALUES("6","CET","13279856400","3600","0");
INSERT INTO timezone VALUES("6","CEST","13293162000","7200","1");
INSERT INTO timezone VALUES("6","CET","13311306000","3600","0");
INSERT INTO timezone VALUES("6","CEST","13324611600","7200","1");
INSERT INTO timezone VALUES("6","CET","13342755600","3600","0");
INSERT INTO timezone VALUES("6","CEST","13356061200","7200","1");
INSERT INTO timezone VALUES("6","CET","13374810000","3600","0");
INSERT INTO timezone VALUES("6","CEST","13387510800","7200","1");
INSERT INTO timezone VALUES("6","CET","13406259600","3600","0");
INSERT INTO timezone VALUES("6","CEST","13418960400","7200","1");
INSERT INTO timezone VALUES("6","CET","13437709200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13451014800","7200","1");
INSERT INTO timezone VALUES("6","CET","13469158800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13482464400","7200","1");
INSERT INTO timezone VALUES("6","CET","13500608400","3600","0");
INSERT INTO timezone VALUES("6","CEST","13513914000","7200","1");
INSERT INTO timezone VALUES("6","CET","13532058000","3600","0");
INSERT INTO timezone VALUES("6","CEST","13545363600","7200","1");
INSERT INTO timezone VALUES("6","CET","13564112400","3600","0");
INSERT INTO timezone VALUES("6","CEST","13576813200","7200","1");
INSERT INTO timezone VALUES("6","CET","13595562000","3600","0");
INSERT INTO timezone VALUES("6","CEST","13608262800","7200","1");
INSERT INTO timezone VALUES("6","CET","13627011600","3600","0");
INSERT INTO timezone VALUES("6","CEST","13640317200","7200","1");
INSERT INTO timezone VALUES("6","CET","13658461200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13671766800","7200","1");
INSERT INTO timezone VALUES("6","CET","13689910800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13703216400","7200","1");
INSERT INTO timezone VALUES("6","CET","13721965200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13734666000","7200","1");
INSERT INTO timezone VALUES("6","CET","13753414800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13766115600","7200","1");
INSERT INTO timezone VALUES("6","CET","13784864400","3600","0");
INSERT INTO timezone VALUES("6","CEST","13797565200","7200","1");
INSERT INTO timezone VALUES("6","CET","13816314000","3600","0");
INSERT INTO timezone VALUES("6","CEST","13829619600","7200","1");
INSERT INTO timezone VALUES("6","CET","13847763600","3600","0");
INSERT INTO timezone VALUES("6","CEST","13861069200","7200","1");
INSERT INTO timezone VALUES("6","CET","13879213200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13892518800","7200","1");
INSERT INTO timezone VALUES("6","CET","13911267600","3600","0");
INSERT INTO timezone VALUES("6","CEST","13923968400","7200","1");
INSERT INTO timezone VALUES("6","CET","13942717200","3600","0");
INSERT INTO timezone VALUES("6","CEST","13955418000","7200","1");
INSERT INTO timezone VALUES("6","CET","13974166800","3600","0");
INSERT INTO timezone VALUES("6","CEST","13987472400","7200","1");
INSERT INTO timezone VALUES("6","CET","14005616400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14018922000","7200","1");
INSERT INTO timezone VALUES("6","CET","14037066000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14050371600","7200","1");
INSERT INTO timezone VALUES("6","CET","14068515600","3600","0");
INSERT INTO timezone VALUES("6","CEST","14081821200","7200","1");
INSERT INTO timezone VALUES("6","CET","14100570000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14113270800","7200","1");
INSERT INTO timezone VALUES("6","CET","14132019600","3600","0");
INSERT INTO timezone VALUES("6","CEST","14144720400","7200","1");
INSERT INTO timezone VALUES("6","CET","14163469200","3600","0");
INSERT INTO timezone VALUES("6","CEST","14176774800","7200","1");
INSERT INTO timezone VALUES("6","CET","14194918800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14208224400","7200","1");
INSERT INTO timezone VALUES("6","CET","14226368400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14239674000","7200","1");
INSERT INTO timezone VALUES("6","CET","14258422800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14271123600","7200","1");
INSERT INTO timezone VALUES("6","CET","14289872400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14302573200","7200","1");
INSERT INTO timezone VALUES("6","CET","14321322000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14334627600","7200","1");
INSERT INTO timezone VALUES("6","CET","14352771600","3600","0");
INSERT INTO timezone VALUES("6","CEST","14366077200","7200","1");
INSERT INTO timezone VALUES("6","CET","14384221200","3600","0");
INSERT INTO timezone VALUES("6","CEST","14397526800","7200","1");
INSERT INTO timezone VALUES("6","CET","14415670800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14428976400","7200","1");
INSERT INTO timezone VALUES("6","CET","14447725200","3600","0");
INSERT INTO timezone VALUES("6","CEST","14460426000","7200","1");
INSERT INTO timezone VALUES("6","CET","14479174800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14491875600","7200","1");
INSERT INTO timezone VALUES("6","CET","14510624400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14523930000","7200","1");
INSERT INTO timezone VALUES("6","CET","14542074000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14555379600","7200","1");
INSERT INTO timezone VALUES("6","CET","14573523600","3600","0");
INSERT INTO timezone VALUES("6","CEST","14586829200","7200","1");
INSERT INTO timezone VALUES("6","CET","14605578000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14618278800","7200","1");
INSERT INTO timezone VALUES("6","CET","14637027600","3600","0");
INSERT INTO timezone VALUES("6","CEST","14649728400","7200","1");
INSERT INTO timezone VALUES("6","CET","14668477200","3600","0");
INSERT INTO timezone VALUES("6","CEST","14681178000","7200","1");
INSERT INTO timezone VALUES("6","CET","14699926800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14713232400","7200","1");
INSERT INTO timezone VALUES("6","CET","14731376400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14744682000","7200","1");
INSERT INTO timezone VALUES("6","CET","14762826000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14776131600","7200","1");
INSERT INTO timezone VALUES("6","CET","14794880400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14807581200","7200","1");
INSERT INTO timezone VALUES("6","CET","14826330000","3600","0");
INSERT INTO timezone VALUES("6","CEST","14839030800","7200","1");
INSERT INTO timezone VALUES("6","CET","14857779600","3600","0");
INSERT INTO timezone VALUES("6","CEST","14871085200","7200","1");
INSERT INTO timezone VALUES("6","CET","14889229200","3600","0");
INSERT INTO timezone VALUES("6","CEST","14902534800","7200","1");
INSERT INTO timezone VALUES("6","CET","14920678800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14933984400","7200","1");
INSERT INTO timezone VALUES("6","CET","14952128400","3600","0");
INSERT INTO timezone VALUES("6","CEST","14965434000","7200","1");
INSERT INTO timezone VALUES("6","CET","14984182800","3600","0");
INSERT INTO timezone VALUES("6","CEST","14996883600","7200","1");
INSERT INTO timezone VALUES("6","CET","15015632400","3600","0");
INSERT INTO timezone VALUES("6","CEST","15028333200","7200","1");
INSERT INTO timezone VALUES("6","CET","15047082000","3600","0");
INSERT INTO timezone VALUES("6","CEST","15060387600","7200","1");
INSERT INTO timezone VALUES("6","CET","15078531600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15091837200","7200","1");
INSERT INTO timezone VALUES("6","CET","15109981200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15123286800","7200","1");
INSERT INTO timezone VALUES("6","CET","15142035600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15154736400","7200","1");
INSERT INTO timezone VALUES("6","CET","15173485200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15186186000","7200","1");
INSERT INTO timezone VALUES("6","CET","15204934800","3600","0");
INSERT INTO timezone VALUES("6","CEST","15218240400","7200","1");
INSERT INTO timezone VALUES("6","CET","15236384400","3600","0");
INSERT INTO timezone VALUES("6","CEST","15249690000","7200","1");
INSERT INTO timezone VALUES("6","CET","15267834000","3600","0");
INSERT INTO timezone VALUES("6","CEST","15281139600","7200","1");
INSERT INTO timezone VALUES("6","CET","15299283600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15312589200","7200","1");
INSERT INTO timezone VALUES("6","CET","15331338000","3600","0");
INSERT INTO timezone VALUES("6","CEST","15344038800","7200","1");
INSERT INTO timezone VALUES("6","CET","15362787600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15375488400","7200","1");
INSERT INTO timezone VALUES("6","CET","15394237200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15407542800","7200","1");
INSERT INTO timezone VALUES("6","CET","15425686800","3600","0");
INSERT INTO timezone VALUES("6","CEST","15438992400","7200","1");
INSERT INTO timezone VALUES("6","CET","15457136400","3600","0");
INSERT INTO timezone VALUES("6","CEST","15470442000","7200","1");
INSERT INTO timezone VALUES("6","CET","15489190800","3600","0");
INSERT INTO timezone VALUES("6","CEST","15501891600","7200","1");
INSERT INTO timezone VALUES("6","CET","15520640400","3600","0");
INSERT INTO timezone VALUES("6","CEST","15533341200","7200","1");
INSERT INTO timezone VALUES("6","CET","15552090000","3600","0");
INSERT INTO timezone VALUES("6","CEST","15564790800","7200","1");
INSERT INTO timezone VALUES("6","CET","15583539600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15596845200","7200","1");
INSERT INTO timezone VALUES("6","CET","15614989200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15628294800","7200","1");
INSERT INTO timezone VALUES("6","CET","15646438800","3600","0");
INSERT INTO timezone VALUES("6","CEST","15659744400","7200","1");
INSERT INTO timezone VALUES("6","CET","15678493200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15691194000","7200","1");
INSERT INTO timezone VALUES("6","CET","15709942800","3600","0");
INSERT INTO timezone VALUES("6","CEST","15722643600","7200","1");
INSERT INTO timezone VALUES("6","CET","15741392400","3600","0");
INSERT INTO timezone VALUES("6","CEST","15754698000","7200","1");
INSERT INTO timezone VALUES("6","CET","15772842000","3600","0");
INSERT INTO timezone VALUES("6","CEST","15786147600","7200","1");
INSERT INTO timezone VALUES("6","CET","15804291600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15817597200","7200","1");
INSERT INTO timezone VALUES("6","CET","15835741200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15849046800","7200","1");
INSERT INTO timezone VALUES("6","CET","15867795600","3600","0");
INSERT INTO timezone VALUES("6","CEST","15880496400","7200","1");
INSERT INTO timezone VALUES("6","CET","15899245200","3600","0");
INSERT INTO timezone VALUES("6","CEST","15911946000","7200","1");
INSERT INTO timezone VALUES("6","CET","15930694800","3600","0");
INSERT INTO timezone VALUES("6","CEST","15944000400","7200","1");
INSERT INTO timezone VALUES("6","CET","15962144400","3600","0");
INSERT INTO timezone VALUES("6","CEST","15975450000","7200","1");
INSERT INTO timezone VALUES("6","CET","15993594000","3600","0");
INSERT INTO timezone VALUES("6","CEST","16006899600","7200","1");
INSERT INTO timezone VALUES("6","CET","16025648400","3600","0");
INSERT INTO timezone VALUES("6","CEST","16038349200","7200","1");
INSERT INTO timezone VALUES("6","CET","16057098000","3600","0");
INSERT INTO timezone VALUES("6","CEST","16069798800","7200","1");
INSERT INTO timezone VALUES("6","CET","16088547600","3600","0");
INSERT INTO timezone VALUES("6","CEST","16101853200","7200","1");
INSERT INTO timezone VALUES("6","CET","16119997200","3600","0");
INSERT INTO timezone VALUES("6","CEST","16133302800","7200","1");
INSERT INTO timezone VALUES("6","CET","16151446800","3600","0");
INSERT INTO timezone VALUES("6","CEST","16164752400","7200","1");
INSERT INTO timezone VALUES("6","CET","16182896400","3600","0");
INSERT INTO timezone VALUES("6","CEST","16196202000","7200","1");
INSERT INTO timezone VALUES("6","CET","16214950800","3600","0");
INSERT INTO timezone VALUES("6","CEST","16227651600","7200","1");
INSERT INTO timezone VALUES("6","CET","16246400400","3600","0");
INSERT INTO timezone VALUES("6","CEST","16259101200","7200","1");
INSERT INTO timezone VALUES("6","CET","16277850000","3600","0");
INSERT INTO timezone VALUES("6","CEST","16291155600","7200","1");
INSERT INTO timezone VALUES("6","CET","16309299600","3600","0");
INSERT INTO timezone VALUES("6","CEST","16322605200","7200","1");
INSERT INTO timezone VALUES("6","CET","16340749200","3600","0");
INSERT INTO timezone VALUES("6","CEST","16354054800","7200","1");
INSERT INTO timezone VALUES("6","CET","16372803600","3600","0");
INSERT INTO timezone VALUES("6","CEST","16385504400","7200","1");
INSERT INTO timezone VALUES("6","CET","16404253200","3600","0");
INSERT INTO timezone VALUES("6","CEST","16416954000","7200","1");
INSERT INTO timezone VALUES("6","CET","16435702800","3600","0");
INSERT INTO timezone VALUES("6","CEST","16448403600","7200","1");
INSERT INTO timezone VALUES("6","CET","16467152400","3600","0");
INSERT INTO timezone VALUES("6","CEST","16480458000","7200","1");
INSERT INTO timezone VALUES("6","CET","16498602000","3600","0");
INSERT INTO timezone VALUES("6","CEST","16511907600","7200","1");
INSERT INTO timezone VALUES("6","CET","16530051600","3600","0");
INSERT INTO timezone VALUES("6","CEST","16543357200","7200","1");
INSERT INTO timezone VALUES("6","CET","16562106000","3600","0");
INSERT INTO timezone VALUES("6","CEST","16574806800","7200","1");
INSERT INTO timezone VALUES("6","CET","16593555600","3600","0");
INSERT INTO timezone VALUES("6","CEST","16606256400","7200","1");
INSERT INTO timezone VALUES("6","CET","16625005200","3600","0");
INSERT INTO timezone VALUES("6","CEST","16638310800","7200","1");
INSERT INTO timezone VALUES("6","CET","16656454800","3600","0");
INSERT INTO timezone VALUES("6","CEST","16669760400","7200","1");
INSERT INTO timezone VALUES("6","CET","16687904400","3600","0");
INSERT INTO timezone VALUES("6","CEST","16701210000","7200","1");
INSERT INTO timezone VALUES("6","CET","16719354000","3600","0");
INSERT INTO timezone VALUES("7","LMT","-1441162681","10680","0");
INSERT INTO timezone VALUES("7","+03","-1441162680","10800","0");
INSERT INTO timezone VALUES("7","+04","-405140400","14400","0");
INSERT INTO timezone VALUES("7","+05","354916800","18000","1");
INSERT INTO timezone VALUES("7","+04","370724400","14400","0");
INSERT INTO timezone VALUES("7","+05","386452800","18000","1");
INSERT INTO timezone VALUES("7","+04","402260400","14400","0");
INSERT INTO timezone VALUES("7","+05","417988800","18000","1");
INSERT INTO timezone VALUES("7","+04","433796400","14400","0");
INSERT INTO timezone VALUES("7","+05","449611200","18000","1");
INSERT INTO timezone VALUES("7","+04","465343200","14400","0");
INSERT INTO timezone VALUES("7","+05","481068000","18000","1");
INSERT INTO timezone VALUES("7","+04","496792800","14400","0");
INSERT INTO timezone VALUES("7","+05","512517600","18000","1");
INSERT INTO timezone VALUES("7","+04","528242400","14400","0");
INSERT INTO timezone VALUES("7","+05","543967200","18000","1");
INSERT INTO timezone VALUES("7","+04","559692000","14400","0");
INSERT INTO timezone VALUES("7","+05","575416800","18000","1");
INSERT INTO timezone VALUES("7","+04","591141600","14400","0");
INSERT INTO timezone VALUES("7","+05","606866400","18000","1");
INSERT INTO timezone VALUES("7","+04","622591200","14400","0");
INSERT INTO timezone VALUES("7","+05","638316000","18000","1");
INSERT INTO timezone VALUES("7","+04","654645600","14400","0");
INSERT INTO timezone VALUES("7","+03","686098800","10800","0");
INSERT INTO timezone VALUES("7","+04","701823600","14400","1");
INSERT INTO timezone VALUES("7","+03","717548400","10800","0");
INSERT INTO timezone VALUES("7","+04","733273200","14400","1");
INSERT INTO timezone VALUES("7","+03","748998000","10800","0");
INSERT INTO timezone VALUES("7","+04","764722800","14400","1");
INSERT INTO timezone VALUES("7","+03","780447600","10800","0");
INSERT INTO timezone VALUES("7","+04","796172400","14400","1");
INSERT INTO timezone VALUES("7","+05","859672800","18000","1");
INSERT INTO timezone VALUES("7","+04","877816800","14400","0");
INSERT INTO timezone VALUES("7","+05","891122400","18000","1");
INSERT INTO timezone VALUES("7","+04","909266400","14400","0");
INSERT INTO timezone VALUES("7","+05","922572000","18000","1");
INSERT INTO timezone VALUES("7","+04","941320800","14400","0");
INSERT INTO timezone VALUES("7","+05","954021600","18000","1");
INSERT INTO timezone VALUES("7","+04","972770400","14400","0");
INSERT INTO timezone VALUES("7","+05","985471200","18000","1");
INSERT INTO timezone VALUES("7","+04","1004220000","14400","0");
INSERT INTO timezone VALUES("7","+05","1017525600","18000","1");
INSERT INTO timezone VALUES("7","+04","1035669600","14400","0");
INSERT INTO timezone VALUES("7","+05","1048975200","18000","1");
INSERT INTO timezone VALUES("7","+04","1067119200","14400","0");
INSERT INTO timezone VALUES("7","+05","1080424800","18000","1");
INSERT INTO timezone VALUES("7","+04","1099173600","14400","0");
INSERT INTO timezone VALUES("7","+05","1111874400","18000","1");
INSERT INTO timezone VALUES("7","+04","1130623200","14400","0");
INSERT INTO timezone VALUES("7","+05","1143324000","18000","1");
INSERT INTO timezone VALUES("7","+04","1162072800","14400","0");
INSERT INTO timezone VALUES("7","+05","1174773600","18000","1");
INSERT INTO timezone VALUES("7","+04","1193522400","14400","0");
INSERT INTO timezone VALUES("7","+05","1206828000","18000","1");
INSERT INTO timezone VALUES("7","+04","1224972000","14400","0");
INSERT INTO timezone VALUES("7","+05","1238277600","18000","1");
INSERT INTO timezone VALUES("7","+04","1256421600","14400","0");
INSERT INTO timezone VALUES("7","+05","1269727200","18000","1");
INSERT INTO timezone VALUES("7","+04","1288476000","14400","0");
INSERT INTO timezone VALUES("7","+05","1301176800","18000","1");
INSERT INTO timezone VALUES("7","+04","1319925600","14400","0");
INSERT INTO timezone VALUES("8","LMT","-1588464817","816","0");
INSERT INTO timezone VALUES("8","WAT","-1588464816","3600","0");
INSERT INTO timezone VALUES("9","LMT","-3192435545","41944","0");
INSERT INTO timezone VALUES("9","NZMT","-3192435544","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1330335000","45000","1");
INSERT INTO timezone VALUES("9","NZMT","-1320057000","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1300699800","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1287396000","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1269250200","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1255946400","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1237800600","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1224496800","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1206351000","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1192442400","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1174901400","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1160992800","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1143451800","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1125914400","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1112607000","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1094464800","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1081157400","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1063015200","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1049707800","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1031565600","41400","0");
INSERT INTO timezone VALUES("9","NZST","-1018258200","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-1000116000","41400","0");
INSERT INTO timezone VALUES("9","NZST","-986808600","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-968061600","41400","0");
INSERT INTO timezone VALUES("9","NZST","-955359000","43200","1");
INSERT INTO timezone VALUES("9","NZMT","-936612000","41400","0");
INSERT INTO timezone VALUES("9","NZST","-923304600","43200","1");
INSERT INTO timezone VALUES("9","NZDT","152632800","46800","1");
INSERT INTO timezone VALUES("9","NZST","162309600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","183477600","46800","1");
INSERT INTO timezone VALUES("9","NZST","194968800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","215532000","46800","1");
INSERT INTO timezone VALUES("9","NZST","226418400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","246981600","46800","1");
INSERT INTO timezone VALUES("9","NZST","257868000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","278431200","46800","1");
INSERT INTO timezone VALUES("9","NZST","289317600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","309880800","46800","1");
INSERT INTO timezone VALUES("9","NZST","320767200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","341330400","46800","1");
INSERT INTO timezone VALUES("9","NZST","352216800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","372780000","46800","1");
INSERT INTO timezone VALUES("9","NZST","384271200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","404834400","46800","1");
INSERT INTO timezone VALUES("9","NZST","415720800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","436284000","46800","1");
INSERT INTO timezone VALUES("9","NZST","447170400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","467733600","46800","1");
INSERT INTO timezone VALUES("9","NZST","478620000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","499183200","46800","1");
INSERT INTO timezone VALUES("9","NZST","510069600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","530632800","46800","1");
INSERT INTO timezone VALUES("9","NZST","541519200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","562082400","46800","1");
INSERT INTO timezone VALUES("9","NZST","573573600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","594136800","46800","1");
INSERT INTO timezone VALUES("9","NZST","605023200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","623772000","46800","1");
INSERT INTO timezone VALUES("9","NZST","637682400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","655221600","46800","1");
INSERT INTO timezone VALUES("9","NZST","669132000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","686671200","46800","1");
INSERT INTO timezone VALUES("9","NZST","700581600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","718120800","46800","1");
INSERT INTO timezone VALUES("9","NZST","732636000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","749570400","46800","1");
INSERT INTO timezone VALUES("9","NZST","764085600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","781020000","46800","1");
INSERT INTO timezone VALUES("9","NZST","795535200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","812469600","46800","1");
INSERT INTO timezone VALUES("9","NZST","826984800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","844524000","46800","1");
INSERT INTO timezone VALUES("9","NZST","858434400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","875973600","46800","1");
INSERT INTO timezone VALUES("9","NZST","889884000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","907423200","46800","1");
INSERT INTO timezone VALUES("9","NZST","921938400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","938872800","46800","1");
INSERT INTO timezone VALUES("9","NZST","953388000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","970322400","46800","1");
INSERT INTO timezone VALUES("9","NZST","984837600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1002376800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1016287200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1033826400","46800","1");
INSERT INTO timezone VALUES("9","NZST","1047736800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1065276000","46800","1");
INSERT INTO timezone VALUES("9","NZST","1079791200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1096725600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1111240800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1128175200","46800","1");
INSERT INTO timezone VALUES("9","NZST","1142690400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1159624800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1174140000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1191074400","46800","1");
INSERT INTO timezone VALUES("9","NZST","1207404000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1222524000","46800","1");
INSERT INTO timezone VALUES("9","NZST","1238853600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1253973600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1270303200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1285423200","46800","1");
INSERT INTO timezone VALUES("9","NZST","1301752800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1316872800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1333202400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1348927200","46800","1");
INSERT INTO timezone VALUES("9","NZST","1365256800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1380376800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1396706400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1411826400","46800","1");
INSERT INTO timezone VALUES("9","NZST","1428156000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1443276000","46800","1");
INSERT INTO timezone VALUES("9","NZST","1459605600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1474725600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1491055200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1506175200","46800","1");
INSERT INTO timezone VALUES("9","NZST","1522504800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1538229600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1554559200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1569679200","46800","1");
INSERT INTO timezone VALUES("9","NZST","1586008800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1601128800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1617458400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1632578400","46800","1");
INSERT INTO timezone VALUES("9","NZST","1648908000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1664028000","46800","1");
INSERT INTO timezone VALUES("9","NZST","1680357600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1695477600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1712412000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1727532000","46800","1");
INSERT INTO timezone VALUES("9","NZST","1743861600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1758981600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1775311200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1790431200","46800","1");
INSERT INTO timezone VALUES("9","NZST","1806760800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1821880800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1838210400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1853330400","46800","1");
INSERT INTO timezone VALUES("9","NZST","1869660000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1885384800","46800","1");
INSERT INTO timezone VALUES("9","NZST","1901714400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1916834400","46800","1");
INSERT INTO timezone VALUES("9","NZST","1933164000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1948284000","46800","1");
INSERT INTO timezone VALUES("9","NZST","1964613600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","1979733600","46800","1");
INSERT INTO timezone VALUES("9","NZST","1996063200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2011183200","46800","1");
INSERT INTO timezone VALUES("9","NZST","2027512800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2042632800","46800","1");
INSERT INTO timezone VALUES("9","NZST","2058962400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2074687200","46800","1");
INSERT INTO timezone VALUES("9","NZST","2091016800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2106136800","46800","1");
INSERT INTO timezone VALUES("9","NZST","2122466400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2137586400","46800","1");
INSERT INTO timezone VALUES("9","NZST","2153916000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2169036000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2185365600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2200485600","46800","1");
INSERT INTO timezone VALUES("9","NZST","2216815200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2232540000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2248869600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2263989600","46800","1");
INSERT INTO timezone VALUES("9","NZST","2280319200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2295439200","46800","1");
INSERT INTO timezone VALUES("9","NZST","2311768800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2326888800","46800","1");
INSERT INTO timezone VALUES("9","NZST","2343218400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2358338400","46800","1");
INSERT INTO timezone VALUES("9","NZST","2374668000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2389788000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2406117600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2421842400","46800","1");
INSERT INTO timezone VALUES("9","NZST","2438172000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2453292000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2469621600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2484741600","46800","1");
INSERT INTO timezone VALUES("9","NZST","2501071200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2516191200","46800","1");
INSERT INTO timezone VALUES("9","NZST","2532520800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2547640800","46800","1");
INSERT INTO timezone VALUES("9","NZST","2563970400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2579090400","46800","1");
INSERT INTO timezone VALUES("9","NZST","2596024800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2611144800","46800","1");
INSERT INTO timezone VALUES("9","NZST","2627474400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2642594400","46800","1");
INSERT INTO timezone VALUES("9","NZST","2658924000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2674044000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2690373600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2705493600","46800","1");
INSERT INTO timezone VALUES("9","NZST","2721823200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2736943200","46800","1");
INSERT INTO timezone VALUES("9","NZST","2753272800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2768997600","46800","1");
INSERT INTO timezone VALUES("9","NZST","2785327200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2800447200","46800","1");
INSERT INTO timezone VALUES("9","NZST","2816776800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2831896800","46800","1");
INSERT INTO timezone VALUES("9","NZST","2848226400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2863346400","46800","1");
INSERT INTO timezone VALUES("9","NZST","2879676000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2894796000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2911125600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2926245600","46800","1");
INSERT INTO timezone VALUES("9","NZST","2942575200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2958300000","46800","1");
INSERT INTO timezone VALUES("9","NZST","2974629600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","2989749600","46800","1");
INSERT INTO timezone VALUES("9","NZST","3006079200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3021199200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3037528800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3052648800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3068978400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3084098400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3100428000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3116152800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3132482400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3147602400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3163932000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3179052000","46800","1");
INSERT INTO timezone VALUES("9","NZST","3195381600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3210501600","46800","1");
INSERT INTO timezone VALUES("9","NZST","3226831200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3241951200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3258280800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3273400800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3289730400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3305455200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3321784800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3336904800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3353234400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3368354400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3384684000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3399804000","46800","1");
INSERT INTO timezone VALUES("9","NZST","3416133600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3431253600","46800","1");
INSERT INTO timezone VALUES("9","NZST","3447583200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3462703200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3479637600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3494757600","46800","1");
INSERT INTO timezone VALUES("9","NZST","3511087200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3526207200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3542536800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3557656800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3573986400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3589106400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3605436000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3620556000","46800","1");
INSERT INTO timezone VALUES("9","NZST","3636885600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3652610400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3668940000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3684060000","46800","1");
INSERT INTO timezone VALUES("9","NZST","3700389600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3715509600","46800","1");
INSERT INTO timezone VALUES("9","NZST","3731839200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3746959200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3763288800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3778408800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3794738400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3809858400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3826188000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3841912800","46800","1");
INSERT INTO timezone VALUES("9","NZST","3858242400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3873362400","46800","1");
INSERT INTO timezone VALUES("9","NZST","3889692000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3904812000","46800","1");
INSERT INTO timezone VALUES("9","NZST","3921141600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3936261600","46800","1");
INSERT INTO timezone VALUES("9","NZST","3952591200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3967711200","46800","1");
INSERT INTO timezone VALUES("9","NZST","3984040800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","3999765600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4016095200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4031215200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4047544800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4062664800","46800","1");
INSERT INTO timezone VALUES("9","NZST","4078994400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4094114400","46800","1");
INSERT INTO timezone VALUES("9","NZST","4110444000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4125564000","46800","1");
INSERT INTO timezone VALUES("9","NZST","4141893600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4157013600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4173343200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4188463200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4204792800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4220517600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4236847200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4251967200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4268296800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4283416800","46800","1");
INSERT INTO timezone VALUES("9","NZST","4299746400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4314866400","46800","1");
INSERT INTO timezone VALUES("9","NZST","4331196000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4346316000","46800","1");
INSERT INTO timezone VALUES("9","NZST","4362645600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4378370400","46800","1");
INSERT INTO timezone VALUES("9","NZST","4394700000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4409820000","46800","1");
INSERT INTO timezone VALUES("9","NZST","4426149600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4441269600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4457599200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4472719200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4489048800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4504168800","46800","1");
INSERT INTO timezone VALUES("9","NZST","4520498400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4535618400","46800","1");
INSERT INTO timezone VALUES("9","NZST","4551948000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4567672800","46800","1");
INSERT INTO timezone VALUES("9","NZST","4584002400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4599122400","46800","1");
INSERT INTO timezone VALUES("9","NZST","4615452000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4630572000","46800","1");
INSERT INTO timezone VALUES("9","NZST","4646901600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4662021600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4678351200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4693471200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4709800800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4724920800","46800","1");
INSERT INTO timezone VALUES("9","NZST","4741855200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4756975200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4773304800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4788424800","46800","1");
INSERT INTO timezone VALUES("9","NZST","4804754400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4819874400","46800","1");
INSERT INTO timezone VALUES("9","NZST","4836204000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4851324000","46800","1");
INSERT INTO timezone VALUES("9","NZST","4867653600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4882773600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4899103200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4914828000","46800","1");
INSERT INTO timezone VALUES("9","NZST","4931157600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4946277600","46800","1");
INSERT INTO timezone VALUES("9","NZST","4962607200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","4977727200","46800","1");
INSERT INTO timezone VALUES("9","NZST","4994056800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5009176800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5025506400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5040626400","46800","1");
INSERT INTO timezone VALUES("9","NZST","5056956000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5072076000","46800","1");
INSERT INTO timezone VALUES("9","NZST","5088405600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5104130400","46800","1");
INSERT INTO timezone VALUES("9","NZST","5120460000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5135580000","46800","1");
INSERT INTO timezone VALUES("9","NZST","5151909600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5167029600","46800","1");
INSERT INTO timezone VALUES("9","NZST","5183359200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5198479200","46800","1");
INSERT INTO timezone VALUES("9","NZST","5214808800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5229928800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5246258400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5261983200","46800","1");
INSERT INTO timezone VALUES("9","NZST","5278312800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5293432800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5309762400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5324882400","46800","1");
INSERT INTO timezone VALUES("9","NZST","5341212000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5356332000","46800","1");
INSERT INTO timezone VALUES("9","NZST","5372661600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5387781600","46800","1");
INSERT INTO timezone VALUES("9","NZST","5404111200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5419231200","46800","1");
INSERT INTO timezone VALUES("9","NZST","5435560800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5451285600","46800","1");
INSERT INTO timezone VALUES("9","NZST","5467615200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5482735200","46800","1");
INSERT INTO timezone VALUES("9","NZST","5499064800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5514184800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5530514400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5545634400","46800","1");
INSERT INTO timezone VALUES("9","NZST","5561964000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5577084000","46800","1");
INSERT INTO timezone VALUES("9","NZST","5593413600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5608533600","46800","1");
INSERT INTO timezone VALUES("9","NZST","5625468000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5640588000","46800","1");
INSERT INTO timezone VALUES("9","NZST","5656917600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5672037600","46800","1");
INSERT INTO timezone VALUES("9","NZST","5688367200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5703487200","46800","1");
INSERT INTO timezone VALUES("9","NZST","5719816800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5734936800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5751266400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5766386400","46800","1");
INSERT INTO timezone VALUES("9","NZST","5782716000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5798440800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5814770400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5829890400","46800","1");
INSERT INTO timezone VALUES("9","NZST","5846220000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5861340000","46800","1");
INSERT INTO timezone VALUES("9","NZST","5877669600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5892789600","46800","1");
INSERT INTO timezone VALUES("9","NZST","5909119200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5924239200","46800","1");
INSERT INTO timezone VALUES("9","NZST","5940568800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5955688800","46800","1");
INSERT INTO timezone VALUES("9","NZST","5972018400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","5987743200","46800","1");
INSERT INTO timezone VALUES("9","NZST","6004072800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6019192800","46800","1");
INSERT INTO timezone VALUES("9","NZST","6035522400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6050642400","46800","1");
INSERT INTO timezone VALUES("9","NZST","6066972000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6082092000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6098421600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6113541600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6129871200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6145596000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6161925600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6177045600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6193375200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6208495200","46800","1");
INSERT INTO timezone VALUES("9","NZST","6224824800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6239944800","46800","1");
INSERT INTO timezone VALUES("9","NZST","6256274400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6271394400","46800","1");
INSERT INTO timezone VALUES("9","NZST","6287724000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6302844000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6319173600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6334898400","46800","1");
INSERT INTO timezone VALUES("9","NZST","6351228000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6366348000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6382677600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6397797600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6414127200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6429247200","46800","1");
INSERT INTO timezone VALUES("9","NZST","6445576800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6460696800","46800","1");
INSERT INTO timezone VALUES("9","NZST","6477026400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6492146400","46800","1");
INSERT INTO timezone VALUES("9","NZST","6509080800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6524200800","46800","1");
INSERT INTO timezone VALUES("9","NZST","6540530400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6555650400","46800","1");
INSERT INTO timezone VALUES("9","NZST","6571980000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6587100000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6603429600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6618549600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6634879200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6649999200","46800","1");
INSERT INTO timezone VALUES("9","NZST","6666328800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6682053600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6698383200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6713503200","46800","1");
INSERT INTO timezone VALUES("9","NZST","6729832800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6744952800","46800","1");
INSERT INTO timezone VALUES("9","NZST","6761282400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6776402400","46800","1");
INSERT INTO timezone VALUES("9","NZST","6792732000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6807852000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6824181600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6839301600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6855631200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6871356000","46800","1");
INSERT INTO timezone VALUES("9","NZST","6887685600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6902805600","46800","1");
INSERT INTO timezone VALUES("9","NZST","6919135200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6934255200","46800","1");
INSERT INTO timezone VALUES("9","NZST","6950584800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6965704800","46800","1");
INSERT INTO timezone VALUES("9","NZST","6982034400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","6997154400","46800","1");
INSERT INTO timezone VALUES("9","NZST","7013484000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7029208800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7045538400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7060658400","46800","1");
INSERT INTO timezone VALUES("9","NZST","7076988000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7092108000","46800","1");
INSERT INTO timezone VALUES("9","NZST","7108437600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7123557600","46800","1");
INSERT INTO timezone VALUES("9","NZST","7139887200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7155007200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7171336800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7186456800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7202786400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7218511200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7234840800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7249960800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7266290400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7281410400","46800","1");
INSERT INTO timezone VALUES("9","NZST","7297740000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7312860000","46800","1");
INSERT INTO timezone VALUES("9","NZST","7329189600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7344309600","46800","1");
INSERT INTO timezone VALUES("9","NZST","7360639200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7375759200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7392088800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7407813600","46800","1");
INSERT INTO timezone VALUES("9","NZST","7424143200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7439263200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7455592800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7470712800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7487042400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7502162400","46800","1");
INSERT INTO timezone VALUES("9","NZST","7518492000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7533612000","46800","1");
INSERT INTO timezone VALUES("9","NZST","7549941600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7565061600","46800","1");
INSERT INTO timezone VALUES("9","NZST","7581391200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7597116000","46800","1");
INSERT INTO timezone VALUES("9","NZST","7613445600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7628565600","46800","1");
INSERT INTO timezone VALUES("9","NZST","7644895200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7660015200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7676344800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7691464800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7707794400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7722914400","46800","1");
INSERT INTO timezone VALUES("9","NZST","7739244000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7754364000","46800","1");
INSERT INTO timezone VALUES("9","NZST","7771298400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7786418400","46800","1");
INSERT INTO timezone VALUES("9","NZST","7802748000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7817868000","46800","1");
INSERT INTO timezone VALUES("9","NZST","7834197600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7849317600","46800","1");
INSERT INTO timezone VALUES("9","NZST","7865647200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7880767200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7897096800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7912216800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7928546400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7944271200","46800","1");
INSERT INTO timezone VALUES("9","NZST","7960600800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","7975720800","46800","1");
INSERT INTO timezone VALUES("9","NZST","7992050400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8007170400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8023500000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8038620000","46800","1");
INSERT INTO timezone VALUES("9","NZST","8054949600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8070069600","46800","1");
INSERT INTO timezone VALUES("9","NZST","8086399200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8101519200","46800","1");
INSERT INTO timezone VALUES("9","NZST","8117848800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8133573600","46800","1");
INSERT INTO timezone VALUES("9","NZST","8149903200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8165023200","46800","1");
INSERT INTO timezone VALUES("9","NZST","8181352800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8196472800","46800","1");
INSERT INTO timezone VALUES("9","NZST","8212802400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8227922400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8244252000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8259372000","46800","1");
INSERT INTO timezone VALUES("9","NZST","8275701600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8291426400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8307756000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8322876000","46800","1");
INSERT INTO timezone VALUES("9","NZST","8339205600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8354325600","46800","1");
INSERT INTO timezone VALUES("9","NZST","8370655200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8385775200","46800","1");
INSERT INTO timezone VALUES("9","NZST","8402104800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8417224800","46800","1");
INSERT INTO timezone VALUES("9","NZST","8433554400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8448674400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8465004000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8480728800","46800","1");
INSERT INTO timezone VALUES("9","NZST","8497058400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8512178400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8528508000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8543628000","46800","1");
INSERT INTO timezone VALUES("9","NZST","8559957600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8575077600","46800","1");
INSERT INTO timezone VALUES("9","NZST","8591407200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8606527200","46800","1");
INSERT INTO timezone VALUES("9","NZST","8622856800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8637976800","46800","1");
INSERT INTO timezone VALUES("9","NZST","8654911200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8670031200","46800","1");
INSERT INTO timezone VALUES("9","NZST","8686360800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8701480800","46800","1");
INSERT INTO timezone VALUES("9","NZST","8717810400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8732930400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8749260000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8764380000","46800","1");
INSERT INTO timezone VALUES("9","NZST","8780709600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8795829600","46800","1");
INSERT INTO timezone VALUES("9","NZST","8812159200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8827884000","46800","1");
INSERT INTO timezone VALUES("9","NZST","8844213600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8859333600","46800","1");
INSERT INTO timezone VALUES("9","NZST","8875663200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8890783200","46800","1");
INSERT INTO timezone VALUES("9","NZST","8907112800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8922232800","46800","1");
INSERT INTO timezone VALUES("9","NZST","8938562400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8953682400","46800","1");
INSERT INTO timezone VALUES("9","NZST","8970012000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","8985132000","46800","1");
INSERT INTO timezone VALUES("9","NZST","9001461600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9017186400","46800","1");
INSERT INTO timezone VALUES("9","NZST","9033516000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9048636000","46800","1");
INSERT INTO timezone VALUES("9","NZST","9064965600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9080085600","46800","1");
INSERT INTO timezone VALUES("9","NZST","9096415200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9111535200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9127864800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9142984800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9159314400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9175039200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9191368800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9206488800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9222818400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9237938400","46800","1");
INSERT INTO timezone VALUES("9","NZST","9254268000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9269388000","46800","1");
INSERT INTO timezone VALUES("9","NZST","9285717600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9300837600","46800","1");
INSERT INTO timezone VALUES("9","NZST","9317167200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9332287200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9348616800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9364341600","46800","1");
INSERT INTO timezone VALUES("9","NZST","9380671200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9395791200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9412120800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9427240800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9443570400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9458690400","46800","1");
INSERT INTO timezone VALUES("9","NZST","9475020000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9490140000","46800","1");
INSERT INTO timezone VALUES("9","NZST","9506469600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9521589600","46800","1");
INSERT INTO timezone VALUES("9","NZST","9538524000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9553644000","46800","1");
INSERT INTO timezone VALUES("9","NZST","9569973600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9585093600","46800","1");
INSERT INTO timezone VALUES("9","NZST","9601423200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9616543200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9632872800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9647992800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9664322400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9679442400","46800","1");
INSERT INTO timezone VALUES("9","NZST","9695772000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9711496800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9727826400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9742946400","46800","1");
INSERT INTO timezone VALUES("9","NZST","9759276000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9774396000","46800","1");
INSERT INTO timezone VALUES("9","NZST","9790725600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9805845600","46800","1");
INSERT INTO timezone VALUES("9","NZST","9822175200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9837295200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9853624800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9868744800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9885074400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9900799200","46800","1");
INSERT INTO timezone VALUES("9","NZST","9917128800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9932248800","46800","1");
INSERT INTO timezone VALUES("9","NZST","9948578400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9963698400","46800","1");
INSERT INTO timezone VALUES("9","NZST","9980028000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","9995148000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10011477600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10026597600","46800","1");
INSERT INTO timezone VALUES("9","NZST","10042927200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10058652000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10074981600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10090101600","46800","1");
INSERT INTO timezone VALUES("9","NZST","10106431200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10121551200","46800","1");
INSERT INTO timezone VALUES("9","NZST","10137880800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10153000800","46800","1");
INSERT INTO timezone VALUES("9","NZST","10169330400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10184450400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10200780000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10215900000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10232229600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10247954400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10264284000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10279404000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10295733600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10310853600","46800","1");
INSERT INTO timezone VALUES("9","NZST","10327183200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10342303200","46800","1");
INSERT INTO timezone VALUES("9","NZST","10358632800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10373752800","46800","1");
INSERT INTO timezone VALUES("9","NZST","10390082400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10405202400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10421532000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10437256800","46800","1");
INSERT INTO timezone VALUES("9","NZST","10453586400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10468706400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10485036000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10500156000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10516485600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10531605600","46800","1");
INSERT INTO timezone VALUES("9","NZST","10547935200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10563055200","46800","1");
INSERT INTO timezone VALUES("9","NZST","10579384800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10594504800","46800","1");
INSERT INTO timezone VALUES("9","NZST","10610834400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10626559200","46800","1");
INSERT INTO timezone VALUES("9","NZST","10642888800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10658008800","46800","1");
INSERT INTO timezone VALUES("9","NZST","10674338400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10689458400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10705788000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10720908000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10737237600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10752357600","46800","1");
INSERT INTO timezone VALUES("9","NZST","10768687200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10783807200","46800","1");
INSERT INTO timezone VALUES("9","NZST","10800741600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10815861600","46800","1");
INSERT INTO timezone VALUES("9","NZST","10832191200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10847311200","46800","1");
INSERT INTO timezone VALUES("9","NZST","10863640800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10878760800","46800","1");
INSERT INTO timezone VALUES("9","NZST","10895090400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10910210400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10926540000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10941660000","46800","1");
INSERT INTO timezone VALUES("9","NZST","10957989600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","10973714400","46800","1");
INSERT INTO timezone VALUES("9","NZST","10990044000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11005164000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11021493600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11036613600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11052943200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11068063200","46800","1");
INSERT INTO timezone VALUES("9","NZST","11084392800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11099512800","46800","1");
INSERT INTO timezone VALUES("9","NZST","11115842400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11130962400","46800","1");
INSERT INTO timezone VALUES("9","NZST","11147292000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11163016800","46800","1");
INSERT INTO timezone VALUES("9","NZST","11179346400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11194466400","46800","1");
INSERT INTO timezone VALUES("9","NZST","11210796000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11225916000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11242245600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11257365600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11273695200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11288815200","46800","1");
INSERT INTO timezone VALUES("9","NZST","11305144800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11320869600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11337199200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11352319200","46800","1");
INSERT INTO timezone VALUES("9","NZST","11368648800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11383768800","46800","1");
INSERT INTO timezone VALUES("9","NZST","11400098400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11415218400","46800","1");
INSERT INTO timezone VALUES("9","NZST","11431548000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11446668000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11462997600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11478117600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11494447200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11510172000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11526501600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11541621600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11557951200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11573071200","46800","1");
INSERT INTO timezone VALUES("9","NZST","11589400800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11604520800","46800","1");
INSERT INTO timezone VALUES("9","NZST","11620850400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11635970400","46800","1");
INSERT INTO timezone VALUES("9","NZST","11652300000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11667420000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11684354400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11699474400","46800","1");
INSERT INTO timezone VALUES("9","NZST","11715804000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11730924000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11747253600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11762373600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11778703200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11793823200","46800","1");
INSERT INTO timezone VALUES("9","NZST","11810152800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11825272800","46800","1");
INSERT INTO timezone VALUES("9","NZST","11841602400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11857327200","46800","1");
INSERT INTO timezone VALUES("9","NZST","11873656800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11888776800","46800","1");
INSERT INTO timezone VALUES("9","NZST","11905106400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11920226400","46800","1");
INSERT INTO timezone VALUES("9","NZST","11936556000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11951676000","46800","1");
INSERT INTO timezone VALUES("9","NZST","11968005600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","11983125600","46800","1");
INSERT INTO timezone VALUES("9","NZST","11999455200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12014575200","46800","1");
INSERT INTO timezone VALUES("9","NZST","12030904800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12046629600","46800","1");
INSERT INTO timezone VALUES("9","NZST","12062959200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12078079200","46800","1");
INSERT INTO timezone VALUES("9","NZST","12094408800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12109528800","46800","1");
INSERT INTO timezone VALUES("9","NZST","12125858400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12140978400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12157308000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12172428000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12188757600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12204482400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12220812000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12235932000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12252261600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12267381600","46800","1");
INSERT INTO timezone VALUES("9","NZST","12283711200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12298831200","46800","1");
INSERT INTO timezone VALUES("9","NZST","12315160800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12330280800","46800","1");
INSERT INTO timezone VALUES("9","NZST","12346610400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12361730400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12378060000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12393784800","46800","1");
INSERT INTO timezone VALUES("9","NZST","12410114400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12425234400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12441564000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12456684000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12473013600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12488133600","46800","1");
INSERT INTO timezone VALUES("9","NZST","12504463200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12519583200","46800","1");
INSERT INTO timezone VALUES("9","NZST","12535912800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12551032800","46800","1");
INSERT INTO timezone VALUES("9","NZST","12567967200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12583087200","46800","1");
INSERT INTO timezone VALUES("9","NZST","12599416800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12614536800","46800","1");
INSERT INTO timezone VALUES("9","NZST","12630866400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12645986400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12662316000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12677436000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12693765600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12708885600","46800","1");
INSERT INTO timezone VALUES("9","NZST","12725215200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12740940000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12757269600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12772389600","46800","1");
INSERT INTO timezone VALUES("9","NZST","12788719200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12803839200","46800","1");
INSERT INTO timezone VALUES("9","NZST","12820168800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12835288800","46800","1");
INSERT INTO timezone VALUES("9","NZST","12851618400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12866738400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12883068000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12898188000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12914517600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12930242400","46800","1");
INSERT INTO timezone VALUES("9","NZST","12946572000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12961692000","46800","1");
INSERT INTO timezone VALUES("9","NZST","12978021600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","12993141600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13009471200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13024591200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13040920800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13056040800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13072370400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13088095200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13104424800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13119544800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13135874400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13150994400","46800","1");
INSERT INTO timezone VALUES("9","NZST","13167324000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13182444000","46800","1");
INSERT INTO timezone VALUES("9","NZST","13198773600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13213893600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13230223200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13245343200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13261672800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13277397600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13293727200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13308847200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13325176800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13340296800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13356626400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13371746400","46800","1");
INSERT INTO timezone VALUES("9","NZST","13388076000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13403196000","46800","1");
INSERT INTO timezone VALUES("9","NZST","13419525600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13434645600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13451580000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13466700000","46800","1");
INSERT INTO timezone VALUES("9","NZST","13483029600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13498149600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13514479200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13529599200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13545928800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13561048800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13577378400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13592498400","46800","1");
INSERT INTO timezone VALUES("9","NZST","13608828000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13624552800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13640882400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13656002400","46800","1");
INSERT INTO timezone VALUES("9","NZST","13672332000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13687452000","46800","1");
INSERT INTO timezone VALUES("9","NZST","13703781600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13718901600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13735231200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13750351200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13766680800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13781800800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13798130400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13813855200","46800","1");
INSERT INTO timezone VALUES("9","NZST","13830184800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13845304800","46800","1");
INSERT INTO timezone VALUES("9","NZST","13861634400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13876754400","46800","1");
INSERT INTO timezone VALUES("9","NZST","13893084000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13908204000","46800","1");
INSERT INTO timezone VALUES("9","NZST","13924533600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13939653600","46800","1");
INSERT INTO timezone VALUES("9","NZST","13955983200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","13971708000","46800","1");
INSERT INTO timezone VALUES("9","NZST","13988037600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14003157600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14019487200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14034607200","46800","1");
INSERT INTO timezone VALUES("9","NZST","14050936800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14066056800","46800","1");
INSERT INTO timezone VALUES("9","NZST","14082386400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14097506400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14113836000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14128956000","46800","1");
INSERT INTO timezone VALUES("9","NZST","14145285600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14161010400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14177340000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14192460000","46800","1");
INSERT INTO timezone VALUES("9","NZST","14208789600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14223909600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14240239200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14255359200","46800","1");
INSERT INTO timezone VALUES("9","NZST","14271688800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14286808800","46800","1");
INSERT INTO timezone VALUES("9","NZST","14303138400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14318258400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14335192800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14350312800","46800","1");
INSERT INTO timezone VALUES("9","NZST","14366642400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14381762400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14398092000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14413212000","46800","1");
INSERT INTO timezone VALUES("9","NZST","14429541600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14444661600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14460991200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14476111200","46800","1");
INSERT INTO timezone VALUES("9","NZST","14492440800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14508165600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14524495200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14539615200","46800","1");
INSERT INTO timezone VALUES("9","NZST","14555944800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14571064800","46800","1");
INSERT INTO timezone VALUES("9","NZST","14587394400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14602514400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14618844000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14633964000","46800","1");
INSERT INTO timezone VALUES("9","NZST","14650293600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14665413600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14681743200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14697468000","46800","1");
INSERT INTO timezone VALUES("9","NZST","14713797600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14728917600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14745247200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14760367200","46800","1");
INSERT INTO timezone VALUES("9","NZST","14776696800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14791816800","46800","1");
INSERT INTO timezone VALUES("9","NZST","14808146400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14823266400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14839596000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14855320800","46800","1");
INSERT INTO timezone VALUES("9","NZST","14871650400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14886770400","46800","1");
INSERT INTO timezone VALUES("9","NZST","14903100000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14918220000","46800","1");
INSERT INTO timezone VALUES("9","NZST","14934549600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14949669600","46800","1");
INSERT INTO timezone VALUES("9","NZST","14965999200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","14981119200","46800","1");
INSERT INTO timezone VALUES("9","NZST","14997448800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15012568800","46800","1");
INSERT INTO timezone VALUES("9","NZST","15028898400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15044623200","46800","1");
INSERT INTO timezone VALUES("9","NZST","15060952800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15076072800","46800","1");
INSERT INTO timezone VALUES("9","NZST","15092402400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15107522400","46800","1");
INSERT INTO timezone VALUES("9","NZST","15123852000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15138972000","46800","1");
INSERT INTO timezone VALUES("9","NZST","15155301600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15170421600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15186751200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15201871200","46800","1");
INSERT INTO timezone VALUES("9","NZST","15218805600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15233925600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15250255200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15265375200","46800","1");
INSERT INTO timezone VALUES("9","NZST","15281704800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15296824800","46800","1");
INSERT INTO timezone VALUES("9","NZST","15313154400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15328274400","46800","1");
INSERT INTO timezone VALUES("9","NZST","15344604000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15359724000","46800","1");
INSERT INTO timezone VALUES("9","NZST","15376053600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15391778400","46800","1");
INSERT INTO timezone VALUES("9","NZST","15408108000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15423228000","46800","1");
INSERT INTO timezone VALUES("9","NZST","15439557600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15454677600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15471007200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15486127200","46800","1");
INSERT INTO timezone VALUES("9","NZST","15502456800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15517576800","46800","1");
INSERT INTO timezone VALUES("9","NZST","15533906400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15549026400","46800","1");
INSERT INTO timezone VALUES("9","NZST","15565356000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15581080800","46800","1");
INSERT INTO timezone VALUES("9","NZST","15597410400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15612530400","46800","1");
INSERT INTO timezone VALUES("9","NZST","15628860000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15643980000","46800","1");
INSERT INTO timezone VALUES("9","NZST","15660309600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15675429600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15691759200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15706879200","46800","1");
INSERT INTO timezone VALUES("9","NZST","15723208800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15738933600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15755263200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15770383200","46800","1");
INSERT INTO timezone VALUES("9","NZST","15786712800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15801832800","46800","1");
INSERT INTO timezone VALUES("9","NZST","15818162400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15833282400","46800","1");
INSERT INTO timezone VALUES("9","NZST","15849612000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15864732000","46800","1");
INSERT INTO timezone VALUES("9","NZST","15881061600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15896181600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15912511200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15928236000","46800","1");
INSERT INTO timezone VALUES("9","NZST","15944565600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15959685600","46800","1");
INSERT INTO timezone VALUES("9","NZST","15976015200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","15991135200","46800","1");
INSERT INTO timezone VALUES("9","NZST","16007464800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16022584800","46800","1");
INSERT INTO timezone VALUES("9","NZST","16038914400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16054034400","46800","1");
INSERT INTO timezone VALUES("9","NZST","16070364000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16085484000","46800","1");
INSERT INTO timezone VALUES("9","NZST","16102418400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16117538400","46800","1");
INSERT INTO timezone VALUES("9","NZST","16133868000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16148988000","46800","1");
INSERT INTO timezone VALUES("9","NZST","16165317600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16180437600","46800","1");
INSERT INTO timezone VALUES("9","NZST","16196767200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16211887200","46800","1");
INSERT INTO timezone VALUES("9","NZST","16228216800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16243336800","46800","1");
INSERT INTO timezone VALUES("9","NZST","16259666400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16275391200","46800","1");
INSERT INTO timezone VALUES("9","NZST","16291720800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16306840800","46800","1");
INSERT INTO timezone VALUES("9","NZST","16323170400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16338290400","46800","1");
INSERT INTO timezone VALUES("9","NZST","16354620000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16369740000","46800","1");
INSERT INTO timezone VALUES("9","NZST","16386069600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16401189600","46800","1");
INSERT INTO timezone VALUES("9","NZST","16417519200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16432639200","46800","1");
INSERT INTO timezone VALUES("9","NZST","16448968800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16464693600","46800","1");
INSERT INTO timezone VALUES("9","NZST","16481023200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16496143200","46800","1");
INSERT INTO timezone VALUES("9","NZST","16512472800","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16527592800","46800","1");
INSERT INTO timezone VALUES("9","NZST","16543922400","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16559042400","46800","1");
INSERT INTO timezone VALUES("9","NZST","16575372000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16590492000","46800","1");
INSERT INTO timezone VALUES("9","NZST","16606821600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16622546400","46800","1");
INSERT INTO timezone VALUES("9","NZST","16638876000","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16653996000","46800","1");
INSERT INTO timezone VALUES("9","NZST","16670325600","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16685445600","46800","1");
INSERT INTO timezone VALUES("9","NZST","16701775200","43200","0");
INSERT INTO timezone VALUES("9","NZDT","16716895200","46800","1");
INSERT INTO timezone VALUES("10","+08","-31536000","28800","0");
INSERT INTO timezone VALUES("10","+11","1255802400","39600","0");
INSERT INTO timezone VALUES("10","+08","1267714800","28800","0");
INSERT INTO timezone VALUES("10","+11","1319738400","39600","0");
INSERT INTO timezone VALUES("10","+08","1329843600","28800","0");
INSERT INTO timezone VALUES("10","+11","1477065600","39600","0");
INSERT INTO timezone VALUES("11","+07","-409190400","25200","0");
INSERT INTO timezone VALUES("11","+05","1255806000","18000","0");
INSERT INTO timezone VALUES("11","+07","1268251200","25200","0");
INSERT INTO timezone VALUES("11","+05","1319742000","18000","0");
INSERT INTO timezone VALUES("11","+07","1329854400","25200","0");
INSERT INTO timezone VALUES("12","+10","-725846400","36000","0");
INSERT INTO timezone VALUES("13","+06","-501206400","21600","0");
INSERT INTO timezone VALUES("13","+05","1255809600","18000","0");
INSERT INTO timezone VALUES("14","-03","-157766400","-10800","1");
INSERT INTO timezone VALUES("14","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("14","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("14","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("14","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("14","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("14","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("14","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("14","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("14","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("14","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("14","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("14","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("14","-04","389070000","-14400","0");
INSERT INTO timezone VALUES("14","-03","403070400","-10800","1");
INSERT INTO timezone VALUES("14","-04","416372400","-14400","0");
INSERT INTO timezone VALUES("14","-03","434520000","-10800","1");
INSERT INTO timezone VALUES("14","-04","447822000","-14400","0");
INSERT INTO timezone VALUES("14","-03","466574400","-10800","1");
INSERT INTO timezone VALUES("14","-04","479271600","-14400","0");
INSERT INTO timezone VALUES("14","-03","498024000","-10800","1");
INSERT INTO timezone VALUES("14","-04","510721200","-14400","0");
INSERT INTO timezone VALUES("14","-03","529473600","-10800","1");
INSERT INTO timezone VALUES("14","-04","545194800","-14400","0");
INSERT INTO timezone VALUES("14","-03","560923200","-10800","1");
INSERT INTO timezone VALUES("14","-04","574225200","-14400","0");
INSERT INTO timezone VALUES("14","-03","592372800","-10800","1");
INSERT INTO timezone VALUES("14","-04","605674800","-14400","0");
INSERT INTO timezone VALUES("14","-03","624427200","-10800","1");
INSERT INTO timezone VALUES("14","-04","637124400","-14400","0");
INSERT INTO timezone VALUES("14","-03","653457600","-10800","1");
INSERT INTO timezone VALUES("14","-04","668574000","-14400","0");
INSERT INTO timezone VALUES("14","-03","687326400","-10800","1");
INSERT INTO timezone VALUES("14","-04","700628400","-14400","0");
INSERT INTO timezone VALUES("14","-03","718776000","-10800","1");
INSERT INTO timezone VALUES("14","-04","732078000","-14400","0");
INSERT INTO timezone VALUES("14","-03","750225600","-10800","1");
INSERT INTO timezone VALUES("14","-04","763527600","-14400","0");
INSERT INTO timezone VALUES("14","-03","781675200","-10800","1");
INSERT INTO timezone VALUES("14","-04","794977200","-14400","0");
INSERT INTO timezone VALUES("14","-03","813729600","-10800","1");
INSERT INTO timezone VALUES("14","-04","826426800","-14400","0");
INSERT INTO timezone VALUES("14","-03","845179200","-10800","1");
INSERT INTO timezone VALUES("14","-04","859690800","-14400","0");
INSERT INTO timezone VALUES("14","-03","876628800","-10800","1");
INSERT INTO timezone VALUES("14","-04","889930800","-14400","0");
INSERT INTO timezone VALUES("14","-03","906868800","-10800","1");
INSERT INTO timezone VALUES("14","-04","923194800","-14400","0");
INSERT INTO timezone VALUES("14","-03","939528000","-10800","1");
INSERT INTO timezone VALUES("14","-04","952830000","-14400","0");
INSERT INTO timezone VALUES("14","-03","971582400","-10800","1");
INSERT INTO timezone VALUES("14","-04","984279600","-14400","0");
INSERT INTO timezone VALUES("14","-03","1003032000","-10800","1");
INSERT INTO timezone VALUES("14","-04","1015729200","-14400","0");
INSERT INTO timezone VALUES("14","-03","1034481600","-10800","1");
INSERT INTO timezone VALUES("14","-04","1047178800","-14400","0");
INSERT INTO timezone VALUES("14","-03","1065931200","-10800","1");
INSERT INTO timezone VALUES("14","-04","1079233200","-14400","0");
INSERT INTO timezone VALUES("14","-03","1097380800","-10800","1");
INSERT INTO timezone VALUES("14","-04","1110682800","-14400","0");
INSERT INTO timezone VALUES("14","-03","1128830400","-10800","1");
INSERT INTO timezone VALUES("14","-04","1142132400","-14400","0");
INSERT INTO timezone VALUES("14","-03","1160884800","-10800","1");
INSERT INTO timezone VALUES("14","-04","1173582000","-14400","0");
INSERT INTO timezone VALUES("14","-03","1192334400","-10800","1");
INSERT INTO timezone VALUES("14","-04","1206846000","-14400","0");
INSERT INTO timezone VALUES("14","-03","1223784000","-10800","1");
INSERT INTO timezone VALUES("14","-04","1237086000","-14400","0");
INSERT INTO timezone VALUES("14","-03","1255233600","-10800","1");
INSERT INTO timezone VALUES("14","-04","1270350000","-14400","0");
INSERT INTO timezone VALUES("14","-03","1286683200","-10800","1");
INSERT INTO timezone VALUES("14","-04","1304823600","-14400","0");
INSERT INTO timezone VALUES("14","-03","1313899200","-10800","1");
INSERT INTO timezone VALUES("14","-04","1335668400","-14400","0");
INSERT INTO timezone VALUES("14","-03","1346558400","-10800","1");
INSERT INTO timezone VALUES("14","-04","1367118000","-14400","0");
INSERT INTO timezone VALUES("14","-03","1378612800","-10800","1");
INSERT INTO timezone VALUES("14","-04","1398567600","-14400","0");
INSERT INTO timezone VALUES("14","-03","1410062400","-10800","1");
INSERT INTO timezone VALUES("14","-04","1463281200","-14400","0");
INSERT INTO timezone VALUES("14","-03","1471147200","-10800","1");
INSERT INTO timezone VALUES("15","-03","218246400","-10800","0");
INSERT INTO timezone VALUES("16","+03","-407808000","10800","0");
INSERT INTO timezone VALUES("17","+00","1108166400","0","0");
INSERT INTO timezone VALUES("17","+02","1111885200","7200","1");
INSERT INTO timezone VALUES("17","+00","1130634000","0","0");
INSERT INTO timezone VALUES("17","+02","1143334800","7200","1");
INSERT INTO timezone VALUES("17","+00","1162083600","0","0");
INSERT INTO timezone VALUES("17","+02","1174784400","7200","1");
INSERT INTO timezone VALUES("17","+00","1193533200","0","0");
INSERT INTO timezone VALUES("17","+02","1206838800","7200","1");
INSERT INTO timezone VALUES("17","+00","1224982800","0","0");
INSERT INTO timezone VALUES("17","+02","1238288400","7200","1");
INSERT INTO timezone VALUES("17","+00","1256432400","0","0");
INSERT INTO timezone VALUES("17","+02","1269738000","7200","1");
INSERT INTO timezone VALUES("17","+00","1288486800","0","0");
INSERT INTO timezone VALUES("17","+02","1301187600","7200","1");
INSERT INTO timezone VALUES("17","+00","1319936400","0","0");
INSERT INTO timezone VALUES("17","+02","1332637200","7200","1");
INSERT INTO timezone VALUES("17","+00","1351386000","0","0");
INSERT INTO timezone VALUES("17","+02","1364691600","7200","1");
INSERT INTO timezone VALUES("17","+00","1382835600","0","0");
INSERT INTO timezone VALUES("17","+02","1396141200","7200","1");
INSERT INTO timezone VALUES("17","+00","1414285200","0","0");
INSERT INTO timezone VALUES("17","+02","1427590800","7200","1");
INSERT INTO timezone VALUES("17","+00","1445734800","0","0");
INSERT INTO timezone VALUES("17","+02","1459040400","7200","1");
INSERT INTO timezone VALUES("17","+00","1477789200","0","0");
INSERT INTO timezone VALUES("17","+02","1490490000","7200","1");
INSERT INTO timezone VALUES("17","+00","1509238800","0","0");
INSERT INTO timezone VALUES("17","+02","1521939600","7200","1");
INSERT INTO timezone VALUES("17","+00","1540688400","0","0");
INSERT INTO timezone VALUES("17","+02","1553994000","7200","1");
INSERT INTO timezone VALUES("17","+00","1572138000","0","0");
INSERT INTO timezone VALUES("17","+02","1585443600","7200","1");
INSERT INTO timezone VALUES("17","+00","1603587600","0","0");
INSERT INTO timezone VALUES("17","+02","1616893200","7200","1");
INSERT INTO timezone VALUES("17","+00","1635642000","0","0");
INSERT INTO timezone VALUES("17","+02","1648342800","7200","1");
INSERT INTO timezone VALUES("17","+00","1667091600","0","0");
INSERT INTO timezone VALUES("17","+02","1679792400","7200","1");
INSERT INTO timezone VALUES("17","+00","1698541200","0","0");
INSERT INTO timezone VALUES("17","+02","1711846800","7200","1");
INSERT INTO timezone VALUES("17","+00","1729990800","0","0");
INSERT INTO timezone VALUES("17","+02","1743296400","7200","1");
INSERT INTO timezone VALUES("17","+00","1761440400","0","0");
INSERT INTO timezone VALUES("17","+02","1774746000","7200","1");
INSERT INTO timezone VALUES("17","+00","1792890000","0","0");
INSERT INTO timezone VALUES("17","+02","1806195600","7200","1");
INSERT INTO timezone VALUES("17","+00","1824944400","0","0");
INSERT INTO timezone VALUES("17","+02","1837645200","7200","1");
INSERT INTO timezone VALUES("17","+00","1856394000","0","0");
INSERT INTO timezone VALUES("17","+02","1869094800","7200","1");
INSERT INTO timezone VALUES("17","+00","1887843600","0","0");
INSERT INTO timezone VALUES("17","+02","1901149200","7200","1");
INSERT INTO timezone VALUES("17","+00","1919293200","0","0");
INSERT INTO timezone VALUES("17","+02","1932598800","7200","1");
INSERT INTO timezone VALUES("17","+00","1950742800","0","0");
INSERT INTO timezone VALUES("17","+02","1964048400","7200","1");
INSERT INTO timezone VALUES("17","+00","1982797200","0","0");
INSERT INTO timezone VALUES("17","+02","1995498000","7200","1");
INSERT INTO timezone VALUES("17","+00","2014246800","0","0");
INSERT INTO timezone VALUES("17","+02","2026947600","7200","1");
INSERT INTO timezone VALUES("17","+00","2045696400","0","0");
INSERT INTO timezone VALUES("17","+02","2058397200","7200","1");
INSERT INTO timezone VALUES("17","+00","2077146000","0","0");
INSERT INTO timezone VALUES("17","+02","2090451600","7200","1");
INSERT INTO timezone VALUES("17","+00","2108595600","0","0");
INSERT INTO timezone VALUES("17","+02","2121901200","7200","1");
INSERT INTO timezone VALUES("17","+00","2140045200","0","0");
INSERT INTO timezone VALUES("17","+02","2153350800","7200","1");
INSERT INTO timezone VALUES("17","+00","2172099600","0","0");
INSERT INTO timezone VALUES("17","+02","2184800400","7200","1");
INSERT INTO timezone VALUES("17","+00","2203549200","0","0");
INSERT INTO timezone VALUES("17","+02","2216250000","7200","1");
INSERT INTO timezone VALUES("17","+00","2234998800","0","0");
INSERT INTO timezone VALUES("17","+02","2248304400","7200","1");
INSERT INTO timezone VALUES("17","+00","2266448400","0","0");
INSERT INTO timezone VALUES("17","+02","2279754000","7200","1");
INSERT INTO timezone VALUES("17","+00","2297898000","0","0");
INSERT INTO timezone VALUES("17","+02","2311203600","7200","1");
INSERT INTO timezone VALUES("17","+00","2329347600","0","0");
INSERT INTO timezone VALUES("17","+02","2342653200","7200","1");
INSERT INTO timezone VALUES("17","+00","2361402000","0","0");
INSERT INTO timezone VALUES("17","+02","2374102800","7200","1");
INSERT INTO timezone VALUES("17","+00","2392851600","0","0");
INSERT INTO timezone VALUES("17","+02","2405552400","7200","1");
INSERT INTO timezone VALUES("17","+00","2424301200","0","0");
INSERT INTO timezone VALUES("17","+02","2437606800","7200","1");
INSERT INTO timezone VALUES("17","+00","2455750800","0","0");
INSERT INTO timezone VALUES("17","+02","2469056400","7200","1");
INSERT INTO timezone VALUES("17","+00","2487200400","0","0");
INSERT INTO timezone VALUES("17","+02","2500506000","7200","1");
INSERT INTO timezone VALUES("17","+00","2519254800","0","0");
INSERT INTO timezone VALUES("17","+02","2531955600","7200","1");
INSERT INTO timezone VALUES("17","+00","2550704400","0","0");
INSERT INTO timezone VALUES("17","+02","2563405200","7200","1");
INSERT INTO timezone VALUES("17","+00","2582154000","0","0");
INSERT INTO timezone VALUES("17","+02","2595459600","7200","1");
INSERT INTO timezone VALUES("17","+00","2613603600","0","0");
INSERT INTO timezone VALUES("17","+02","2626909200","7200","1");
INSERT INTO timezone VALUES("17","+00","2645053200","0","0");
INSERT INTO timezone VALUES("17","+02","2658358800","7200","1");
INSERT INTO timezone VALUES("17","+00","2676502800","0","0");
INSERT INTO timezone VALUES("17","+02","2689808400","7200","1");
INSERT INTO timezone VALUES("17","+00","2708557200","0","0");
INSERT INTO timezone VALUES("17","+02","2721258000","7200","1");
INSERT INTO timezone VALUES("17","+00","2740006800","0","0");
INSERT INTO timezone VALUES("17","+02","2752707600","7200","1");
INSERT INTO timezone VALUES("17","+00","2771456400","0","0");
INSERT INTO timezone VALUES("17","+02","2784762000","7200","1");
INSERT INTO timezone VALUES("17","+00","2802906000","0","0");
INSERT INTO timezone VALUES("17","+02","2816211600","7200","1");
INSERT INTO timezone VALUES("17","+00","2834355600","0","0");
INSERT INTO timezone VALUES("17","+02","2847661200","7200","1");
INSERT INTO timezone VALUES("17","+00","2866410000","0","0");
INSERT INTO timezone VALUES("17","+02","2879110800","7200","1");
INSERT INTO timezone VALUES("17","+00","2897859600","0","0");
INSERT INTO timezone VALUES("17","+02","2910560400","7200","1");
INSERT INTO timezone VALUES("17","+00","2929309200","0","0");
INSERT INTO timezone VALUES("17","+02","2942010000","7200","1");
INSERT INTO timezone VALUES("17","+00","2960758800","0","0");
INSERT INTO timezone VALUES("17","+02","2974064400","7200","1");
INSERT INTO timezone VALUES("17","+00","2992208400","0","0");
INSERT INTO timezone VALUES("17","+02","3005514000","7200","1");
INSERT INTO timezone VALUES("17","+00","3023658000","0","0");
INSERT INTO timezone VALUES("17","+02","3036963600","7200","1");
INSERT INTO timezone VALUES("17","+00","3055712400","0","0");
INSERT INTO timezone VALUES("17","+02","3068413200","7200","1");
INSERT INTO timezone VALUES("17","+00","3087162000","0","0");
INSERT INTO timezone VALUES("17","+02","3099862800","7200","1");
INSERT INTO timezone VALUES("17","+00","3118611600","0","0");
INSERT INTO timezone VALUES("17","+02","3131917200","7200","1");
INSERT INTO timezone VALUES("17","+00","3150061200","0","0");
INSERT INTO timezone VALUES("17","+02","3163366800","7200","1");
INSERT INTO timezone VALUES("17","+00","3181510800","0","0");
INSERT INTO timezone VALUES("17","+02","3194816400","7200","1");
INSERT INTO timezone VALUES("17","+00","3212960400","0","0");
INSERT INTO timezone VALUES("17","+02","3226266000","7200","1");
INSERT INTO timezone VALUES("17","+00","3245014800","0","0");
INSERT INTO timezone VALUES("17","+02","3257715600","7200","1");
INSERT INTO timezone VALUES("17","+00","3276464400","0","0");
INSERT INTO timezone VALUES("17","+02","3289165200","7200","1");
INSERT INTO timezone VALUES("17","+00","3307914000","0","0");
INSERT INTO timezone VALUES("17","+02","3321219600","7200","1");
INSERT INTO timezone VALUES("17","+00","3339363600","0","0");
INSERT INTO timezone VALUES("17","+02","3352669200","7200","1");
INSERT INTO timezone VALUES("17","+00","3370813200","0","0");
INSERT INTO timezone VALUES("17","+02","3384118800","7200","1");
INSERT INTO timezone VALUES("17","+00","3402867600","0","0");
INSERT INTO timezone VALUES("17","+02","3415568400","7200","1");
INSERT INTO timezone VALUES("17","+00","3434317200","0","0");
INSERT INTO timezone VALUES("17","+02","3447018000","7200","1");
INSERT INTO timezone VALUES("17","+00","3465766800","0","0");
INSERT INTO timezone VALUES("17","+02","3479072400","7200","1");
INSERT INTO timezone VALUES("17","+00","3497216400","0","0");
INSERT INTO timezone VALUES("17","+02","3510522000","7200","1");
INSERT INTO timezone VALUES("17","+00","3528666000","0","0");
INSERT INTO timezone VALUES("17","+02","3541971600","7200","1");
INSERT INTO timezone VALUES("17","+00","3560115600","0","0");
INSERT INTO timezone VALUES("17","+02","3573421200","7200","1");
INSERT INTO timezone VALUES("17","+00","3592170000","0","0");
INSERT INTO timezone VALUES("17","+02","3604870800","7200","1");
INSERT INTO timezone VALUES("17","+00","3623619600","0","0");
INSERT INTO timezone VALUES("17","+02","3636320400","7200","1");
INSERT INTO timezone VALUES("17","+00","3655069200","0","0");
INSERT INTO timezone VALUES("17","+02","3668374800","7200","1");
INSERT INTO timezone VALUES("17","+00","3686518800","0","0");
INSERT INTO timezone VALUES("17","+02","3699824400","7200","1");
INSERT INTO timezone VALUES("17","+00","3717968400","0","0");
INSERT INTO timezone VALUES("17","+02","3731274000","7200","1");
INSERT INTO timezone VALUES("17","+00","3750022800","0","0");
INSERT INTO timezone VALUES("17","+02","3762723600","7200","1");
INSERT INTO timezone VALUES("17","+00","3781472400","0","0");
INSERT INTO timezone VALUES("17","+02","3794173200","7200","1");
INSERT INTO timezone VALUES("17","+00","3812922000","0","0");
INSERT INTO timezone VALUES("17","+02","3825622800","7200","1");
INSERT INTO timezone VALUES("17","+00","3844371600","0","0");
INSERT INTO timezone VALUES("17","+02","3857677200","7200","1");
INSERT INTO timezone VALUES("17","+00","3875821200","0","0");
INSERT INTO timezone VALUES("17","+02","3889126800","7200","1");
INSERT INTO timezone VALUES("17","+00","3907270800","0","0");
INSERT INTO timezone VALUES("17","+02","3920576400","7200","1");
INSERT INTO timezone VALUES("17","+00","3939325200","0","0");
INSERT INTO timezone VALUES("17","+02","3952026000","7200","1");
INSERT INTO timezone VALUES("17","+00","3970774800","0","0");
INSERT INTO timezone VALUES("17","+02","3983475600","7200","1");
INSERT INTO timezone VALUES("17","+00","4002224400","0","0");
INSERT INTO timezone VALUES("17","+02","4015530000","7200","1");
INSERT INTO timezone VALUES("17","+00","4033674000","0","0");
INSERT INTO timezone VALUES("17","+02","4046979600","7200","1");
INSERT INTO timezone VALUES("17","+00","4065123600","0","0");
INSERT INTO timezone VALUES("17","+02","4078429200","7200","1");
INSERT INTO timezone VALUES("17","+00","4096573200","0","0");
INSERT INTO timezone VALUES("17","+02","4109878800","7200","1");
INSERT INTO timezone VALUES("17","+00","4128627600","0","0");
INSERT INTO timezone VALUES("17","+02","4141328400","7200","1");
INSERT INTO timezone VALUES("17","+00","4160077200","0","0");
INSERT INTO timezone VALUES("17","+02","4172778000","7200","1");
INSERT INTO timezone VALUES("17","+00","4191526800","0","0");
INSERT INTO timezone VALUES("17","+02","4204227600","7200","1");
INSERT INTO timezone VALUES("17","+00","4222976400","0","0");
INSERT INTO timezone VALUES("17","+02","4236282000","7200","1");
INSERT INTO timezone VALUES("17","+00","4254426000","0","0");
INSERT INTO timezone VALUES("17","+02","4267731600","7200","1");
INSERT INTO timezone VALUES("17","+00","4285875600","0","0");
INSERT INTO timezone VALUES("17","+02","4299181200","7200","1");
INSERT INTO timezone VALUES("17","+00","4317930000","0","0");
INSERT INTO timezone VALUES("17","+02","4330630800","7200","1");
INSERT INTO timezone VALUES("17","+00","4349379600","0","0");
INSERT INTO timezone VALUES("17","+02","4362080400","7200","1");
INSERT INTO timezone VALUES("17","+00","4380829200","0","0");
INSERT INTO timezone VALUES("17","+02","4394134800","7200","1");
INSERT INTO timezone VALUES("17","+00","4412278800","0","0");
INSERT INTO timezone VALUES("17","+02","4425584400","7200","1");
INSERT INTO timezone VALUES("17","+00","4443728400","0","0");
INSERT INTO timezone VALUES("17","+02","4457034000","7200","1");
INSERT INTO timezone VALUES("17","+00","4475178000","0","0");
INSERT INTO timezone VALUES("17","+02","4488483600","7200","1");
INSERT INTO timezone VALUES("17","+00","4507232400","0","0");
INSERT INTO timezone VALUES("17","+02","4519933200","7200","1");
INSERT INTO timezone VALUES("17","+00","4538682000","0","0");
INSERT INTO timezone VALUES("17","+02","4551382800","7200","1");
INSERT INTO timezone VALUES("17","+00","4570131600","0","0");
INSERT INTO timezone VALUES("17","+02","4583437200","7200","1");
INSERT INTO timezone VALUES("17","+00","4601581200","0","0");
INSERT INTO timezone VALUES("17","+02","4614886800","7200","1");
INSERT INTO timezone VALUES("17","+00","4633030800","0","0");
INSERT INTO timezone VALUES("17","+02","4646336400","7200","1");
INSERT INTO timezone VALUES("17","+00","4665085200","0","0");
INSERT INTO timezone VALUES("17","+02","4677786000","7200","1");
INSERT INTO timezone VALUES("17","+00","4696534800","0","0");
INSERT INTO timezone VALUES("17","+02","4709235600","7200","1");
INSERT INTO timezone VALUES("17","+00","4727984400","0","0");
INSERT INTO timezone VALUES("17","+02","4741290000","7200","1");
INSERT INTO timezone VALUES("17","+00","4759434000","0","0");
INSERT INTO timezone VALUES("17","+02","4772739600","7200","1");
INSERT INTO timezone VALUES("17","+00","4790883600","0","0");
INSERT INTO timezone VALUES("17","+02","4804189200","7200","1");
INSERT INTO timezone VALUES("17","+00","4822333200","0","0");
INSERT INTO timezone VALUES("17","+02","4835638800","7200","1");
INSERT INTO timezone VALUES("17","+00","4854387600","0","0");
INSERT INTO timezone VALUES("17","+02","4867088400","7200","1");
INSERT INTO timezone VALUES("17","+00","4885837200","0","0");
INSERT INTO timezone VALUES("17","+02","4898538000","7200","1");
INSERT INTO timezone VALUES("17","+00","4917286800","0","0");
INSERT INTO timezone VALUES("17","+02","4930592400","7200","1");
INSERT INTO timezone VALUES("17","+00","4948736400","0","0");
INSERT INTO timezone VALUES("17","+02","4962042000","7200","1");
INSERT INTO timezone VALUES("17","+00","4980186000","0","0");
INSERT INTO timezone VALUES("17","+02","4993491600","7200","1");
INSERT INTO timezone VALUES("17","+00","5012240400","0","0");
INSERT INTO timezone VALUES("17","+02","5024941200","7200","1");
INSERT INTO timezone VALUES("17","+00","5043690000","0","0");
INSERT INTO timezone VALUES("17","+02","5056390800","7200","1");
INSERT INTO timezone VALUES("17","+00","5075139600","0","0");
INSERT INTO timezone VALUES("17","+02","5087840400","7200","1");
INSERT INTO timezone VALUES("17","+00","5106589200","0","0");
INSERT INTO timezone VALUES("17","+02","5119894800","7200","1");
INSERT INTO timezone VALUES("17","+00","5138038800","0","0");
INSERT INTO timezone VALUES("17","+02","5151344400","7200","1");
INSERT INTO timezone VALUES("17","+00","5169488400","0","0");
INSERT INTO timezone VALUES("17","+02","5182794000","7200","1");
INSERT INTO timezone VALUES("17","+00","5201542800","0","0");
INSERT INTO timezone VALUES("17","+02","5214243600","7200","1");
INSERT INTO timezone VALUES("17","+00","5232992400","0","0");
INSERT INTO timezone VALUES("17","+02","5245693200","7200","1");
INSERT INTO timezone VALUES("17","+00","5264442000","0","0");
INSERT INTO timezone VALUES("17","+02","5277747600","7200","1");
INSERT INTO timezone VALUES("17","+00","5295891600","0","0");
INSERT INTO timezone VALUES("17","+02","5309197200","7200","1");
INSERT INTO timezone VALUES("17","+00","5327341200","0","0");
INSERT INTO timezone VALUES("17","+02","5340646800","7200","1");
INSERT INTO timezone VALUES("17","+00","5358790800","0","0");
INSERT INTO timezone VALUES("17","+02","5372096400","7200","1");
INSERT INTO timezone VALUES("17","+00","5390845200","0","0");
INSERT INTO timezone VALUES("17","+02","5403546000","7200","1");
INSERT INTO timezone VALUES("17","+00","5422294800","0","0");
INSERT INTO timezone VALUES("17","+02","5434995600","7200","1");
INSERT INTO timezone VALUES("17","+00","5453744400","0","0");
INSERT INTO timezone VALUES("17","+02","5467050000","7200","1");
INSERT INTO timezone VALUES("17","+00","5485194000","0","0");
INSERT INTO timezone VALUES("17","+02","5498499600","7200","1");
INSERT INTO timezone VALUES("17","+00","5516643600","0","0");
INSERT INTO timezone VALUES("17","+02","5529949200","7200","1");
INSERT INTO timezone VALUES("17","+00","5548698000","0","0");
INSERT INTO timezone VALUES("17","+02","5561398800","7200","1");
INSERT INTO timezone VALUES("17","+00","5580147600","0","0");
INSERT INTO timezone VALUES("17","+02","5592848400","7200","1");
INSERT INTO timezone VALUES("17","+00","5611597200","0","0");
INSERT INTO timezone VALUES("17","+02","5624902800","7200","1");
INSERT INTO timezone VALUES("17","+00","5643046800","0","0");
INSERT INTO timezone VALUES("17","+02","5656352400","7200","1");
INSERT INTO timezone VALUES("17","+00","5674496400","0","0");
INSERT INTO timezone VALUES("17","+02","5687802000","7200","1");
INSERT INTO timezone VALUES("17","+00","5705946000","0","0");
INSERT INTO timezone VALUES("17","+02","5719251600","7200","1");
INSERT INTO timezone VALUES("17","+00","5738000400","0","0");
INSERT INTO timezone VALUES("17","+02","5750701200","7200","1");
INSERT INTO timezone VALUES("17","+00","5769450000","0","0");
INSERT INTO timezone VALUES("17","+02","5782150800","7200","1");
INSERT INTO timezone VALUES("17","+00","5800899600","0","0");
INSERT INTO timezone VALUES("17","+02","5814205200","7200","1");
INSERT INTO timezone VALUES("17","+00","5832349200","0","0");
INSERT INTO timezone VALUES("17","+02","5845654800","7200","1");
INSERT INTO timezone VALUES("17","+00","5863798800","0","0");
INSERT INTO timezone VALUES("17","+02","5877104400","7200","1");
INSERT INTO timezone VALUES("17","+00","5895853200","0","0");
INSERT INTO timezone VALUES("17","+02","5908554000","7200","1");
INSERT INTO timezone VALUES("17","+00","5927302800","0","0");
INSERT INTO timezone VALUES("17","+02","5940003600","7200","1");
INSERT INTO timezone VALUES("17","+00","5958752400","0","0");
INSERT INTO timezone VALUES("17","+02","5971453200","7200","1");
INSERT INTO timezone VALUES("17","+00","5990202000","0","0");
INSERT INTO timezone VALUES("17","+02","6003507600","7200","1");
INSERT INTO timezone VALUES("17","+00","6021651600","0","0");
INSERT INTO timezone VALUES("17","+02","6034957200","7200","1");
INSERT INTO timezone VALUES("17","+00","6053101200","0","0");
INSERT INTO timezone VALUES("17","+02","6066406800","7200","1");
INSERT INTO timezone VALUES("17","+00","6085155600","0","0");
INSERT INTO timezone VALUES("17","+02","6097856400","7200","1");
INSERT INTO timezone VALUES("17","+00","6116605200","0","0");
INSERT INTO timezone VALUES("17","+02","6129306000","7200","1");
INSERT INTO timezone VALUES("17","+00","6148054800","0","0");
INSERT INTO timezone VALUES("17","+02","6161360400","7200","1");
INSERT INTO timezone VALUES("17","+00","6179504400","0","0");
INSERT INTO timezone VALUES("17","+02","6192810000","7200","1");
INSERT INTO timezone VALUES("17","+00","6210954000","0","0");
INSERT INTO timezone VALUES("17","+02","6224259600","7200","1");
INSERT INTO timezone VALUES("17","+00","6242403600","0","0");
INSERT INTO timezone VALUES("17","+02","6255709200","7200","1");
INSERT INTO timezone VALUES("17","+00","6274458000","0","0");
INSERT INTO timezone VALUES("17","+02","6287158800","7200","1");
INSERT INTO timezone VALUES("17","+00","6305907600","0","0");
INSERT INTO timezone VALUES("17","+02","6318608400","7200","1");
INSERT INTO timezone VALUES("17","+00","6337357200","0","0");
INSERT INTO timezone VALUES("17","+02","6350662800","7200","1");
INSERT INTO timezone VALUES("17","+00","6368806800","0","0");
INSERT INTO timezone VALUES("17","+02","6382112400","7200","1");
INSERT INTO timezone VALUES("17","+00","6400256400","0","0");
INSERT INTO timezone VALUES("17","+02","6413562000","7200","1");
INSERT INTO timezone VALUES("17","+00","6432310800","0","0");
INSERT INTO timezone VALUES("17","+02","6445011600","7200","1");
INSERT INTO timezone VALUES("17","+00","6463760400","0","0");
INSERT INTO timezone VALUES("17","+02","6476461200","7200","1");
INSERT INTO timezone VALUES("17","+00","6495210000","0","0");
INSERT INTO timezone VALUES("17","+02","6508515600","7200","1");
INSERT INTO timezone VALUES("17","+00","6526659600","0","0");
INSERT INTO timezone VALUES("17","+02","6539965200","7200","1");
INSERT INTO timezone VALUES("17","+00","6558109200","0","0");
INSERT INTO timezone VALUES("17","+02","6571414800","7200","1");
INSERT INTO timezone VALUES("17","+00","6589558800","0","0");
INSERT INTO timezone VALUES("17","+02","6602864400","7200","1");
INSERT INTO timezone VALUES("17","+00","6621613200","0","0");
INSERT INTO timezone VALUES("17","+02","6634314000","7200","1");
INSERT INTO timezone VALUES("17","+00","6653062800","0","0");
INSERT INTO timezone VALUES("17","+02","6665763600","7200","1");
INSERT INTO timezone VALUES("17","+00","6684512400","0","0");
INSERT INTO timezone VALUES("17","+02","6697818000","7200","1");
INSERT INTO timezone VALUES("17","+00","6715962000","0","0");
INSERT INTO timezone VALUES("17","+02","6729267600","7200","1");
INSERT INTO timezone VALUES("17","+00","6747411600","0","0");
INSERT INTO timezone VALUES("17","+02","6760717200","7200","1");
INSERT INTO timezone VALUES("17","+00","6779466000","0","0");
INSERT INTO timezone VALUES("17","+02","6792166800","7200","1");
INSERT INTO timezone VALUES("17","+00","6810915600","0","0");
INSERT INTO timezone VALUES("17","+02","6823616400","7200","1");
INSERT INTO timezone VALUES("17","+00","6842365200","0","0");
INSERT INTO timezone VALUES("17","+02","6855066000","7200","1");
INSERT INTO timezone VALUES("17","+00","6873814800","0","0");
INSERT INTO timezone VALUES("17","+02","6887120400","7200","1");
INSERT INTO timezone VALUES("17","+00","6905264400","0","0");
INSERT INTO timezone VALUES("17","+02","6918570000","7200","1");
INSERT INTO timezone VALUES("17","+00","6936714000","0","0");
INSERT INTO timezone VALUES("17","+02","6950019600","7200","1");
INSERT INTO timezone VALUES("17","+00","6968768400","0","0");
INSERT INTO timezone VALUES("17","+02","6981469200","7200","1");
INSERT INTO timezone VALUES("17","+00","7000218000","0","0");
INSERT INTO timezone VALUES("17","+02","7012918800","7200","1");
INSERT INTO timezone VALUES("17","+00","7031667600","0","0");
INSERT INTO timezone VALUES("17","+02","7044973200","7200","1");
INSERT INTO timezone VALUES("17","+00","7063117200","0","0");
INSERT INTO timezone VALUES("17","+02","7076422800","7200","1");
INSERT INTO timezone VALUES("17","+00","7094566800","0","0");
INSERT INTO timezone VALUES("17","+02","7107872400","7200","1");
INSERT INTO timezone VALUES("17","+00","7126016400","0","0");
INSERT INTO timezone VALUES("17","+02","7139322000","7200","1");
INSERT INTO timezone VALUES("17","+00","7158070800","0","0");
INSERT INTO timezone VALUES("17","+02","7170771600","7200","1");
INSERT INTO timezone VALUES("17","+00","7189520400","0","0");
INSERT INTO timezone VALUES("17","+02","7202221200","7200","1");
INSERT INTO timezone VALUES("17","+00","7220970000","0","0");
INSERT INTO timezone VALUES("17","+02","7234275600","7200","1");
INSERT INTO timezone VALUES("17","+00","7252419600","0","0");
INSERT INTO timezone VALUES("17","+02","7265725200","7200","1");
INSERT INTO timezone VALUES("17","+00","7283869200","0","0");
INSERT INTO timezone VALUES("17","+02","7297174800","7200","1");
INSERT INTO timezone VALUES("17","+00","7315318800","0","0");
INSERT INTO timezone VALUES("17","+02","7328624400","7200","1");
INSERT INTO timezone VALUES("17","+00","7347373200","0","0");
INSERT INTO timezone VALUES("17","+02","7360074000","7200","1");
INSERT INTO timezone VALUES("17","+00","7378822800","0","0");
INSERT INTO timezone VALUES("17","+02","7391523600","7200","1");
INSERT INTO timezone VALUES("17","+00","7410272400","0","0");
INSERT INTO timezone VALUES("17","+02","7423578000","7200","1");
INSERT INTO timezone VALUES("17","+00","7441722000","0","0");
INSERT INTO timezone VALUES("17","+02","7455027600","7200","1");
INSERT INTO timezone VALUES("17","+00","7473171600","0","0");
INSERT INTO timezone VALUES("17","+02","7486477200","7200","1");
INSERT INTO timezone VALUES("17","+00","7504621200","0","0");
INSERT INTO timezone VALUES("17","+02","7517926800","7200","1");
INSERT INTO timezone VALUES("17","+00","7536675600","0","0");
INSERT INTO timezone VALUES("17","+02","7549376400","7200","1");
INSERT INTO timezone VALUES("17","+00","7568125200","0","0");
INSERT INTO timezone VALUES("17","+02","7580826000","7200","1");
INSERT INTO timezone VALUES("17","+00","7599574800","0","0");
INSERT INTO timezone VALUES("17","+02","7612880400","7200","1");
INSERT INTO timezone VALUES("17","+00","7631024400","0","0");
INSERT INTO timezone VALUES("17","+02","7644330000","7200","1");
INSERT INTO timezone VALUES("17","+00","7662474000","0","0");
INSERT INTO timezone VALUES("17","+02","7675779600","7200","1");
INSERT INTO timezone VALUES("17","+00","7694528400","0","0");
INSERT INTO timezone VALUES("17","+02","7707229200","7200","1");
INSERT INTO timezone VALUES("17","+00","7725978000","0","0");
INSERT INTO timezone VALUES("17","+02","7738678800","7200","1");
INSERT INTO timezone VALUES("17","+00","7757427600","0","0");
INSERT INTO timezone VALUES("17","+02","7770733200","7200","1");
INSERT INTO timezone VALUES("17","+00","7788877200","0","0");
INSERT INTO timezone VALUES("17","+02","7802182800","7200","1");
INSERT INTO timezone VALUES("17","+00","7820326800","0","0");
INSERT INTO timezone VALUES("17","+02","7833632400","7200","1");
INSERT INTO timezone VALUES("17","+00","7851776400","0","0");
INSERT INTO timezone VALUES("17","+02","7865082000","7200","1");
INSERT INTO timezone VALUES("17","+00","7883830800","0","0");
INSERT INTO timezone VALUES("17","+02","7896531600","7200","1");
INSERT INTO timezone VALUES("17","+00","7915280400","0","0");
INSERT INTO timezone VALUES("17","+02","7927981200","7200","1");
INSERT INTO timezone VALUES("17","+00","7946730000","0","0");
INSERT INTO timezone VALUES("17","+02","7960035600","7200","1");
INSERT INTO timezone VALUES("17","+00","7978179600","0","0");
INSERT INTO timezone VALUES("17","+02","7991485200","7200","1");
INSERT INTO timezone VALUES("17","+00","8009629200","0","0");
INSERT INTO timezone VALUES("17","+02","8022934800","7200","1");
INSERT INTO timezone VALUES("17","+00","8041683600","0","0");
INSERT INTO timezone VALUES("17","+02","8054384400","7200","1");
INSERT INTO timezone VALUES("17","+00","8073133200","0","0");
INSERT INTO timezone VALUES("17","+02","8085834000","7200","1");
INSERT INTO timezone VALUES("17","+00","8104582800","0","0");
INSERT INTO timezone VALUES("17","+02","8117283600","7200","1");
INSERT INTO timezone VALUES("17","+00","8136032400","0","0");
INSERT INTO timezone VALUES("17","+02","8149338000","7200","1");
INSERT INTO timezone VALUES("17","+00","8167482000","0","0");
INSERT INTO timezone VALUES("17","+02","8180787600","7200","1");
INSERT INTO timezone VALUES("17","+00","8198931600","0","0");
INSERT INTO timezone VALUES("17","+02","8212237200","7200","1");
INSERT INTO timezone VALUES("17","+00","8230986000","0","0");
INSERT INTO timezone VALUES("17","+02","8243686800","7200","1");
INSERT INTO timezone VALUES("17","+00","8262435600","0","0");
INSERT INTO timezone VALUES("17","+02","8275136400","7200","1");
INSERT INTO timezone VALUES("17","+00","8293885200","0","0");
INSERT INTO timezone VALUES("17","+02","8307190800","7200","1");
INSERT INTO timezone VALUES("17","+00","8325334800","0","0");
INSERT INTO timezone VALUES("17","+02","8338640400","7200","1");
INSERT INTO timezone VALUES("17","+00","8356784400","0","0");
INSERT INTO timezone VALUES("17","+02","8370090000","7200","1");
INSERT INTO timezone VALUES("17","+00","8388234000","0","0");
INSERT INTO timezone VALUES("17","+02","8401539600","7200","1");
INSERT INTO timezone VALUES("17","+00","8420288400","0","0");
INSERT INTO timezone VALUES("17","+02","8432989200","7200","1");
INSERT INTO timezone VALUES("17","+00","8451738000","0","0");
INSERT INTO timezone VALUES("17","+02","8464438800","7200","1");
INSERT INTO timezone VALUES("17","+00","8483187600","0","0");
INSERT INTO timezone VALUES("17","+02","8496493200","7200","1");
INSERT INTO timezone VALUES("17","+00","8514637200","0","0");
INSERT INTO timezone VALUES("17","+02","8527942800","7200","1");
INSERT INTO timezone VALUES("17","+00","8546086800","0","0");
INSERT INTO timezone VALUES("17","+02","8559392400","7200","1");
INSERT INTO timezone VALUES("17","+00","8578141200","0","0");
INSERT INTO timezone VALUES("17","+02","8590842000","7200","1");
INSERT INTO timezone VALUES("17","+00","8609590800","0","0");
INSERT INTO timezone VALUES("17","+02","8622291600","7200","1");
INSERT INTO timezone VALUES("17","+00","8641040400","0","0");
INSERT INTO timezone VALUES("17","+02","8654346000","7200","1");
INSERT INTO timezone VALUES("17","+00","8672490000","0","0");
INSERT INTO timezone VALUES("17","+02","8685795600","7200","1");
INSERT INTO timezone VALUES("17","+00","8703939600","0","0");
INSERT INTO timezone VALUES("17","+02","8717245200","7200","1");
INSERT INTO timezone VALUES("17","+00","8735389200","0","0");
INSERT INTO timezone VALUES("17","+02","8748694800","7200","1");
INSERT INTO timezone VALUES("17","+00","8767443600","0","0");
INSERT INTO timezone VALUES("17","+02","8780144400","7200","1");
INSERT INTO timezone VALUES("17","+00","8798893200","0","0");
INSERT INTO timezone VALUES("17","+02","8811594000","7200","1");
INSERT INTO timezone VALUES("17","+00","8830342800","0","0");
INSERT INTO timezone VALUES("17","+02","8843648400","7200","1");
INSERT INTO timezone VALUES("17","+00","8861792400","0","0");
INSERT INTO timezone VALUES("17","+02","8875098000","7200","1");
INSERT INTO timezone VALUES("17","+00","8893242000","0","0");
INSERT INTO timezone VALUES("17","+02","8906547600","7200","1");
INSERT INTO timezone VALUES("17","+00","8925296400","0","0");
INSERT INTO timezone VALUES("17","+02","8937997200","7200","1");
INSERT INTO timezone VALUES("17","+00","8956746000","0","0");
INSERT INTO timezone VALUES("17","+02","8969446800","7200","1");
INSERT INTO timezone VALUES("17","+00","8988195600","0","0");
INSERT INTO timezone VALUES("17","+02","9000896400","7200","1");
INSERT INTO timezone VALUES("17","+00","9019645200","0","0");
INSERT INTO timezone VALUES("17","+02","9032950800","7200","1");
INSERT INTO timezone VALUES("17","+00","9051094800","0","0");
INSERT INTO timezone VALUES("17","+02","9064400400","7200","1");
INSERT INTO timezone VALUES("17","+00","9082544400","0","0");
INSERT INTO timezone VALUES("17","+02","9095850000","7200","1");
INSERT INTO timezone VALUES("17","+00","9114598800","0","0");
INSERT INTO timezone VALUES("17","+02","9127299600","7200","1");
INSERT INTO timezone VALUES("17","+00","9146048400","0","0");
INSERT INTO timezone VALUES("17","+02","9158749200","7200","1");
INSERT INTO timezone VALUES("17","+00","9177498000","0","0");
INSERT INTO timezone VALUES("17","+02","9190803600","7200","1");
INSERT INTO timezone VALUES("17","+00","9208947600","0","0");
INSERT INTO timezone VALUES("17","+02","9222253200","7200","1");
INSERT INTO timezone VALUES("17","+00","9240397200","0","0");
INSERT INTO timezone VALUES("17","+02","9253702800","7200","1");
INSERT INTO timezone VALUES("17","+00","9271846800","0","0");
INSERT INTO timezone VALUES("17","+02","9285152400","7200","1");
INSERT INTO timezone VALUES("17","+00","9303901200","0","0");
INSERT INTO timezone VALUES("17","+02","9316602000","7200","1");
INSERT INTO timezone VALUES("17","+00","9335350800","0","0");
INSERT INTO timezone VALUES("17","+02","9348051600","7200","1");
INSERT INTO timezone VALUES("17","+00","9366800400","0","0");
INSERT INTO timezone VALUES("17","+02","9380106000","7200","1");
INSERT INTO timezone VALUES("17","+00","9398250000","0","0");
INSERT INTO timezone VALUES("17","+02","9411555600","7200","1");
INSERT INTO timezone VALUES("17","+00","9429699600","0","0");
INSERT INTO timezone VALUES("17","+02","9443005200","7200","1");
INSERT INTO timezone VALUES("17","+00","9461754000","0","0");
INSERT INTO timezone VALUES("17","+02","9474454800","7200","1");
INSERT INTO timezone VALUES("17","+00","9493203600","0","0");
INSERT INTO timezone VALUES("17","+02","9505904400","7200","1");
INSERT INTO timezone VALUES("17","+00","9524653200","0","0");
INSERT INTO timezone VALUES("17","+02","9537958800","7200","1");
INSERT INTO timezone VALUES("17","+00","9556102800","0","0");
INSERT INTO timezone VALUES("17","+02","9569408400","7200","1");
INSERT INTO timezone VALUES("17","+00","9587552400","0","0");
INSERT INTO timezone VALUES("17","+02","9600858000","7200","1");
INSERT INTO timezone VALUES("17","+00","9619002000","0","0");
INSERT INTO timezone VALUES("17","+02","9632307600","7200","1");
INSERT INTO timezone VALUES("17","+00","9651056400","0","0");
INSERT INTO timezone VALUES("17","+02","9663757200","7200","1");
INSERT INTO timezone VALUES("17","+00","9682506000","0","0");
INSERT INTO timezone VALUES("17","+02","9695206800","7200","1");
INSERT INTO timezone VALUES("17","+00","9713955600","0","0");
INSERT INTO timezone VALUES("17","+02","9727261200","7200","1");
INSERT INTO timezone VALUES("17","+00","9745405200","0","0");
INSERT INTO timezone VALUES("17","+02","9758710800","7200","1");
INSERT INTO timezone VALUES("17","+00","9776854800","0","0");
INSERT INTO timezone VALUES("17","+02","9790160400","7200","1");
INSERT INTO timezone VALUES("17","+00","9808909200","0","0");
INSERT INTO timezone VALUES("17","+02","9821610000","7200","1");
INSERT INTO timezone VALUES("17","+00","9840358800","0","0");
INSERT INTO timezone VALUES("17","+02","9853059600","7200","1");
INSERT INTO timezone VALUES("17","+00","9871808400","0","0");
INSERT INTO timezone VALUES("17","+02","9884509200","7200","1");
INSERT INTO timezone VALUES("17","+00","9903258000","0","0");
INSERT INTO timezone VALUES("17","+02","9916563600","7200","1");
INSERT INTO timezone VALUES("17","+00","9934707600","0","0");
INSERT INTO timezone VALUES("17","+02","9948013200","7200","1");
INSERT INTO timezone VALUES("17","+00","9966157200","0","0");
INSERT INTO timezone VALUES("17","+02","9979462800","7200","1");
INSERT INTO timezone VALUES("17","+00","9998211600","0","0");
INSERT INTO timezone VALUES("17","+02","10010912400","7200","1");
INSERT INTO timezone VALUES("17","+00","10029661200","0","0");
INSERT INTO timezone VALUES("17","+02","10042362000","7200","1");
INSERT INTO timezone VALUES("17","+00","10061110800","0","0");
INSERT INTO timezone VALUES("17","+02","10074416400","7200","1");
INSERT INTO timezone VALUES("17","+00","10092560400","0","0");
INSERT INTO timezone VALUES("17","+02","10105866000","7200","1");
INSERT INTO timezone VALUES("17","+00","10124010000","0","0");
INSERT INTO timezone VALUES("17","+02","10137315600","7200","1");
INSERT INTO timezone VALUES("17","+00","10155459600","0","0");
INSERT INTO timezone VALUES("17","+02","10168765200","7200","1");
INSERT INTO timezone VALUES("17","+00","10187514000","0","0");
INSERT INTO timezone VALUES("17","+02","10200214800","7200","1");
INSERT INTO timezone VALUES("17","+00","10218963600","0","0");
INSERT INTO timezone VALUES("17","+02","10231664400","7200","1");
INSERT INTO timezone VALUES("17","+00","10250413200","0","0");
INSERT INTO timezone VALUES("17","+02","10263718800","7200","1");
INSERT INTO timezone VALUES("17","+00","10281862800","0","0");
INSERT INTO timezone VALUES("17","+02","10295168400","7200","1");
INSERT INTO timezone VALUES("17","+00","10313312400","0","0");
INSERT INTO timezone VALUES("17","+02","10326618000","7200","1");
INSERT INTO timezone VALUES("17","+00","10345366800","0","0");
INSERT INTO timezone VALUES("17","+02","10358067600","7200","1");
INSERT INTO timezone VALUES("17","+00","10376816400","0","0");
INSERT INTO timezone VALUES("17","+02","10389517200","7200","1");
INSERT INTO timezone VALUES("17","+00","10408266000","0","0");
INSERT INTO timezone VALUES("17","+02","10420966800","7200","1");
INSERT INTO timezone VALUES("17","+00","10439715600","0","0");
INSERT INTO timezone VALUES("17","+02","10453021200","7200","1");
INSERT INTO timezone VALUES("17","+00","10471165200","0","0");
INSERT INTO timezone VALUES("17","+02","10484470800","7200","1");
INSERT INTO timezone VALUES("17","+00","10502614800","0","0");
INSERT INTO timezone VALUES("17","+02","10515920400","7200","1");
INSERT INTO timezone VALUES("17","+00","10534064400","0","0");
INSERT INTO timezone VALUES("17","+02","10547370000","7200","1");
INSERT INTO timezone VALUES("17","+00","10566118800","0","0");
INSERT INTO timezone VALUES("17","+02","10578819600","7200","1");
INSERT INTO timezone VALUES("17","+00","10597568400","0","0");
INSERT INTO timezone VALUES("17","+02","10610269200","7200","1");
INSERT INTO timezone VALUES("17","+00","10629018000","0","0");
INSERT INTO timezone VALUES("17","+02","10642323600","7200","1");
INSERT INTO timezone VALUES("17","+00","10660467600","0","0");
INSERT INTO timezone VALUES("17","+02","10673773200","7200","1");
INSERT INTO timezone VALUES("17","+00","10691917200","0","0");
INSERT INTO timezone VALUES("17","+02","10705222800","7200","1");
INSERT INTO timezone VALUES("17","+00","10723971600","0","0");
INSERT INTO timezone VALUES("17","+02","10736672400","7200","1");
INSERT INTO timezone VALUES("17","+00","10755421200","0","0");
INSERT INTO timezone VALUES("17","+02","10768122000","7200","1");
INSERT INTO timezone VALUES("17","+00","10786870800","0","0");
INSERT INTO timezone VALUES("17","+02","10800176400","7200","1");
INSERT INTO timezone VALUES("17","+00","10818320400","0","0");
INSERT INTO timezone VALUES("17","+02","10831626000","7200","1");
INSERT INTO timezone VALUES("17","+00","10849770000","0","0");
INSERT INTO timezone VALUES("17","+02","10863075600","7200","1");
INSERT INTO timezone VALUES("17","+00","10881219600","0","0");
INSERT INTO timezone VALUES("17","+02","10894525200","7200","1");
INSERT INTO timezone VALUES("17","+00","10913274000","0","0");
INSERT INTO timezone VALUES("17","+02","10925974800","7200","1");
INSERT INTO timezone VALUES("17","+00","10944723600","0","0");
INSERT INTO timezone VALUES("17","+02","10957424400","7200","1");
INSERT INTO timezone VALUES("17","+00","10976173200","0","0");
INSERT INTO timezone VALUES("17","+02","10989478800","7200","1");
INSERT INTO timezone VALUES("17","+00","11007622800","0","0");
INSERT INTO timezone VALUES("17","+02","11020928400","7200","1");
INSERT INTO timezone VALUES("17","+00","11039072400","0","0");
INSERT INTO timezone VALUES("17","+02","11052378000","7200","1");
INSERT INTO timezone VALUES("17","+00","11071126800","0","0");
INSERT INTO timezone VALUES("17","+02","11083827600","7200","1");
INSERT INTO timezone VALUES("17","+00","11102576400","0","0");
INSERT INTO timezone VALUES("17","+02","11115277200","7200","1");
INSERT INTO timezone VALUES("17","+00","11134026000","0","0");
INSERT INTO timezone VALUES("17","+02","11146726800","7200","1");
INSERT INTO timezone VALUES("17","+00","11165475600","0","0");
INSERT INTO timezone VALUES("17","+02","11178781200","7200","1");
INSERT INTO timezone VALUES("17","+00","11196925200","0","0");
INSERT INTO timezone VALUES("17","+02","11210230800","7200","1");
INSERT INTO timezone VALUES("17","+00","11228374800","0","0");
INSERT INTO timezone VALUES("17","+02","11241680400","7200","1");
INSERT INTO timezone VALUES("17","+00","11260429200","0","0");
INSERT INTO timezone VALUES("17","+02","11273130000","7200","1");
INSERT INTO timezone VALUES("17","+00","11291878800","0","0");
INSERT INTO timezone VALUES("17","+02","11304579600","7200","1");
INSERT INTO timezone VALUES("17","+00","11323328400","0","0");
INSERT INTO timezone VALUES("17","+02","11336634000","7200","1");
INSERT INTO timezone VALUES("17","+00","11354778000","0","0");
INSERT INTO timezone VALUES("17","+02","11368083600","7200","1");
INSERT INTO timezone VALUES("17","+00","11386227600","0","0");
INSERT INTO timezone VALUES("17","+02","11399533200","7200","1");
INSERT INTO timezone VALUES("17","+00","11417677200","0","0");
INSERT INTO timezone VALUES("17","+02","11430982800","7200","1");
INSERT INTO timezone VALUES("17","+00","11449731600","0","0");
INSERT INTO timezone VALUES("17","+02","11462432400","7200","1");
INSERT INTO timezone VALUES("17","+00","11481181200","0","0");
INSERT INTO timezone VALUES("17","+02","11493882000","7200","1");
INSERT INTO timezone VALUES("17","+00","11512630800","0","0");
INSERT INTO timezone VALUES("17","+02","11525936400","7200","1");
INSERT INTO timezone VALUES("17","+00","11544080400","0","0");
INSERT INTO timezone VALUES("17","+02","11557386000","7200","1");
INSERT INTO timezone VALUES("17","+00","11575530000","0","0");
INSERT INTO timezone VALUES("17","+02","11588835600","7200","1");
INSERT INTO timezone VALUES("17","+00","11607584400","0","0");
INSERT INTO timezone VALUES("17","+02","11620285200","7200","1");
INSERT INTO timezone VALUES("17","+00","11639034000","0","0");
INSERT INTO timezone VALUES("17","+02","11651734800","7200","1");
INSERT INTO timezone VALUES("17","+00","11670483600","0","0");
INSERT INTO timezone VALUES("17","+02","11683789200","7200","1");
INSERT INTO timezone VALUES("17","+00","11701933200","0","0");
INSERT INTO timezone VALUES("17","+02","11715238800","7200","1");
INSERT INTO timezone VALUES("17","+00","11733382800","0","0");
INSERT INTO timezone VALUES("17","+02","11746688400","7200","1");
INSERT INTO timezone VALUES("17","+00","11764832400","0","0");
INSERT INTO timezone VALUES("17","+02","11778138000","7200","1");
INSERT INTO timezone VALUES("17","+00","11796886800","0","0");
INSERT INTO timezone VALUES("17","+02","11809587600","7200","1");
INSERT INTO timezone VALUES("17","+00","11828336400","0","0");
INSERT INTO timezone VALUES("17","+02","11841037200","7200","1");
INSERT INTO timezone VALUES("17","+00","11859786000","0","0");
INSERT INTO timezone VALUES("17","+02","11873091600","7200","1");
INSERT INTO timezone VALUES("17","+00","11891235600","0","0");
INSERT INTO timezone VALUES("17","+02","11904541200","7200","1");
INSERT INTO timezone VALUES("17","+00","11922685200","0","0");
INSERT INTO timezone VALUES("17","+02","11935990800","7200","1");
INSERT INTO timezone VALUES("17","+00","11954739600","0","0");
INSERT INTO timezone VALUES("17","+02","11967440400","7200","1");
INSERT INTO timezone VALUES("17","+00","11986189200","0","0");
INSERT INTO timezone VALUES("17","+02","11998890000","7200","1");
INSERT INTO timezone VALUES("17","+00","12017638800","0","0");
INSERT INTO timezone VALUES("17","+02","12030339600","7200","1");
INSERT INTO timezone VALUES("17","+00","12049088400","0","0");
INSERT INTO timezone VALUES("17","+02","12062394000","7200","1");
INSERT INTO timezone VALUES("17","+00","12080538000","0","0");
INSERT INTO timezone VALUES("17","+02","12093843600","7200","1");
INSERT INTO timezone VALUES("17","+00","12111987600","0","0");
INSERT INTO timezone VALUES("17","+02","12125293200","7200","1");
INSERT INTO timezone VALUES("17","+00","12144042000","0","0");
INSERT INTO timezone VALUES("17","+02","12156742800","7200","1");
INSERT INTO timezone VALUES("17","+00","12175491600","0","0");
INSERT INTO timezone VALUES("17","+02","12188192400","7200","1");
INSERT INTO timezone VALUES("17","+00","12206941200","0","0");
INSERT INTO timezone VALUES("17","+02","12220246800","7200","1");
INSERT INTO timezone VALUES("17","+00","12238390800","0","0");
INSERT INTO timezone VALUES("17","+02","12251696400","7200","1");
INSERT INTO timezone VALUES("17","+00","12269840400","0","0");
INSERT INTO timezone VALUES("17","+02","12283146000","7200","1");
INSERT INTO timezone VALUES("17","+00","12301290000","0","0");
INSERT INTO timezone VALUES("17","+02","12314595600","7200","1");
INSERT INTO timezone VALUES("17","+00","12333344400","0","0");
INSERT INTO timezone VALUES("17","+02","12346045200","7200","1");
INSERT INTO timezone VALUES("17","+00","12364794000","0","0");
INSERT INTO timezone VALUES("17","+02","12377494800","7200","1");
INSERT INTO timezone VALUES("17","+00","12396243600","0","0");
INSERT INTO timezone VALUES("17","+02","12409549200","7200","1");
INSERT INTO timezone VALUES("17","+00","12427693200","0","0");
INSERT INTO timezone VALUES("17","+02","12440998800","7200","1");
INSERT INTO timezone VALUES("17","+00","12459142800","0","0");
INSERT INTO timezone VALUES("17","+02","12472448400","7200","1");
INSERT INTO timezone VALUES("17","+00","12491197200","0","0");
INSERT INTO timezone VALUES("17","+02","12503898000","7200","1");
INSERT INTO timezone VALUES("17","+00","12522646800","0","0");
INSERT INTO timezone VALUES("17","+02","12535347600","7200","1");
INSERT INTO timezone VALUES("17","+00","12554096400","0","0");
INSERT INTO timezone VALUES("17","+02","12567402000","7200","1");
INSERT INTO timezone VALUES("17","+00","12585546000","0","0");
INSERT INTO timezone VALUES("17","+02","12598851600","7200","1");
INSERT INTO timezone VALUES("17","+00","12616995600","0","0");
INSERT INTO timezone VALUES("17","+02","12630301200","7200","1");
INSERT INTO timezone VALUES("17","+00","12648445200","0","0");
INSERT INTO timezone VALUES("17","+02","12661750800","7200","1");
INSERT INTO timezone VALUES("17","+00","12680499600","0","0");
INSERT INTO timezone VALUES("17","+02","12693200400","7200","1");
INSERT INTO timezone VALUES("17","+00","12711949200","0","0");
INSERT INTO timezone VALUES("17","+02","12724650000","7200","1");
INSERT INTO timezone VALUES("17","+00","12743398800","0","0");
INSERT INTO timezone VALUES("17","+02","12756704400","7200","1");
INSERT INTO timezone VALUES("17","+00","12774848400","0","0");
INSERT INTO timezone VALUES("17","+02","12788154000","7200","1");
INSERT INTO timezone VALUES("17","+00","12806298000","0","0");
INSERT INTO timezone VALUES("17","+02","12819603600","7200","1");
INSERT INTO timezone VALUES("17","+00","12838352400","0","0");
INSERT INTO timezone VALUES("17","+02","12851053200","7200","1");
INSERT INTO timezone VALUES("17","+00","12869802000","0","0");
INSERT INTO timezone VALUES("17","+02","12882502800","7200","1");
INSERT INTO timezone VALUES("17","+00","12901251600","0","0");
INSERT INTO timezone VALUES("17","+02","12913952400","7200","1");
INSERT INTO timezone VALUES("17","+00","12932701200","0","0");
INSERT INTO timezone VALUES("17","+02","12946006800","7200","1");
INSERT INTO timezone VALUES("17","+00","12964150800","0","0");
INSERT INTO timezone VALUES("17","+02","12977456400","7200","1");
INSERT INTO timezone VALUES("17","+00","12995600400","0","0");
INSERT INTO timezone VALUES("17","+02","13008906000","7200","1");
INSERT INTO timezone VALUES("17","+00","13027654800","0","0");
INSERT INTO timezone VALUES("17","+02","13040355600","7200","1");
INSERT INTO timezone VALUES("17","+00","13059104400","0","0");
INSERT INTO timezone VALUES("17","+02","13071805200","7200","1");
INSERT INTO timezone VALUES("17","+00","13090554000","0","0");
INSERT INTO timezone VALUES("17","+02","13103859600","7200","1");
INSERT INTO timezone VALUES("17","+00","13122003600","0","0");
INSERT INTO timezone VALUES("17","+02","13135309200","7200","1");
INSERT INTO timezone VALUES("17","+00","13153453200","0","0");
INSERT INTO timezone VALUES("17","+02","13166758800","7200","1");
INSERT INTO timezone VALUES("17","+00","13184902800","0","0");
INSERT INTO timezone VALUES("17","+02","13198208400","7200","1");
INSERT INTO timezone VALUES("17","+00","13216957200","0","0");
INSERT INTO timezone VALUES("17","+02","13229658000","7200","1");
INSERT INTO timezone VALUES("17","+00","13248406800","0","0");
INSERT INTO timezone VALUES("17","+02","13261107600","7200","1");
INSERT INTO timezone VALUES("17","+00","13279856400","0","0");
INSERT INTO timezone VALUES("17","+02","13293162000","7200","1");
INSERT INTO timezone VALUES("17","+00","13311306000","0","0");
INSERT INTO timezone VALUES("17","+02","13324611600","7200","1");
INSERT INTO timezone VALUES("17","+00","13342755600","0","0");
INSERT INTO timezone VALUES("17","+02","13356061200","7200","1");
INSERT INTO timezone VALUES("17","+00","13374810000","0","0");
INSERT INTO timezone VALUES("17","+02","13387510800","7200","1");
INSERT INTO timezone VALUES("17","+00","13406259600","0","0");
INSERT INTO timezone VALUES("17","+02","13418960400","7200","1");
INSERT INTO timezone VALUES("17","+00","13437709200","0","0");
INSERT INTO timezone VALUES("17","+02","13451014800","7200","1");
INSERT INTO timezone VALUES("17","+00","13469158800","0","0");
INSERT INTO timezone VALUES("17","+02","13482464400","7200","1");
INSERT INTO timezone VALUES("17","+00","13500608400","0","0");
INSERT INTO timezone VALUES("17","+02","13513914000","7200","1");
INSERT INTO timezone VALUES("17","+00","13532058000","0","0");
INSERT INTO timezone VALUES("17","+02","13545363600","7200","1");
INSERT INTO timezone VALUES("17","+00","13564112400","0","0");
INSERT INTO timezone VALUES("17","+02","13576813200","7200","1");
INSERT INTO timezone VALUES("17","+00","13595562000","0","0");
INSERT INTO timezone VALUES("17","+02","13608262800","7200","1");
INSERT INTO timezone VALUES("17","+00","13627011600","0","0");
INSERT INTO timezone VALUES("17","+02","13640317200","7200","1");
INSERT INTO timezone VALUES("17","+00","13658461200","0","0");
INSERT INTO timezone VALUES("17","+02","13671766800","7200","1");
INSERT INTO timezone VALUES("17","+00","13689910800","0","0");
INSERT INTO timezone VALUES("17","+02","13703216400","7200","1");
INSERT INTO timezone VALUES("17","+00","13721965200","0","0");
INSERT INTO timezone VALUES("17","+02","13734666000","7200","1");
INSERT INTO timezone VALUES("17","+00","13753414800","0","0");
INSERT INTO timezone VALUES("17","+02","13766115600","7200","1");
INSERT INTO timezone VALUES("17","+00","13784864400","0","0");
INSERT INTO timezone VALUES("17","+02","13797565200","7200","1");
INSERT INTO timezone VALUES("17","+00","13816314000","0","0");
INSERT INTO timezone VALUES("17","+02","13829619600","7200","1");
INSERT INTO timezone VALUES("17","+00","13847763600","0","0");
INSERT INTO timezone VALUES("17","+02","13861069200","7200","1");
INSERT INTO timezone VALUES("17","+00","13879213200","0","0");
INSERT INTO timezone VALUES("17","+02","13892518800","7200","1");
INSERT INTO timezone VALUES("17","+00","13911267600","0","0");
INSERT INTO timezone VALUES("17","+02","13923968400","7200","1");
INSERT INTO timezone VALUES("17","+00","13942717200","0","0");
INSERT INTO timezone VALUES("17","+02","13955418000","7200","1");
INSERT INTO timezone VALUES("17","+00","13974166800","0","0");
INSERT INTO timezone VALUES("17","+02","13987472400","7200","1");
INSERT INTO timezone VALUES("17","+00","14005616400","0","0");
INSERT INTO timezone VALUES("17","+02","14018922000","7200","1");
INSERT INTO timezone VALUES("17","+00","14037066000","0","0");
INSERT INTO timezone VALUES("17","+02","14050371600","7200","1");
INSERT INTO timezone VALUES("17","+00","14068515600","0","0");
INSERT INTO timezone VALUES("17","+02","14081821200","7200","1");
INSERT INTO timezone VALUES("17","+00","14100570000","0","0");
INSERT INTO timezone VALUES("17","+02","14113270800","7200","1");
INSERT INTO timezone VALUES("17","+00","14132019600","0","0");
INSERT INTO timezone VALUES("17","+02","14144720400","7200","1");
INSERT INTO timezone VALUES("17","+00","14163469200","0","0");
INSERT INTO timezone VALUES("17","+02","14176774800","7200","1");
INSERT INTO timezone VALUES("17","+00","14194918800","0","0");
INSERT INTO timezone VALUES("17","+02","14208224400","7200","1");
INSERT INTO timezone VALUES("17","+00","14226368400","0","0");
INSERT INTO timezone VALUES("17","+02","14239674000","7200","1");
INSERT INTO timezone VALUES("17","+00","14258422800","0","0");
INSERT INTO timezone VALUES("17","+02","14271123600","7200","1");
INSERT INTO timezone VALUES("17","+00","14289872400","0","0");
INSERT INTO timezone VALUES("17","+02","14302573200","7200","1");
INSERT INTO timezone VALUES("17","+00","14321322000","0","0");
INSERT INTO timezone VALUES("17","+02","14334627600","7200","1");
INSERT INTO timezone VALUES("17","+00","14352771600","0","0");
INSERT INTO timezone VALUES("17","+02","14366077200","7200","1");
INSERT INTO timezone VALUES("17","+00","14384221200","0","0");
INSERT INTO timezone VALUES("17","+02","14397526800","7200","1");
INSERT INTO timezone VALUES("17","+00","14415670800","0","0");
INSERT INTO timezone VALUES("17","+02","14428976400","7200","1");
INSERT INTO timezone VALUES("17","+00","14447725200","0","0");
INSERT INTO timezone VALUES("17","+02","14460426000","7200","1");
INSERT INTO timezone VALUES("17","+00","14479174800","0","0");
INSERT INTO timezone VALUES("17","+02","14491875600","7200","1");
INSERT INTO timezone VALUES("17","+00","14510624400","0","0");
INSERT INTO timezone VALUES("17","+02","14523930000","7200","1");
INSERT INTO timezone VALUES("17","+00","14542074000","0","0");
INSERT INTO timezone VALUES("17","+02","14555379600","7200","1");
INSERT INTO timezone VALUES("17","+00","14573523600","0","0");
INSERT INTO timezone VALUES("17","+02","14586829200","7200","1");
INSERT INTO timezone VALUES("17","+00","14605578000","0","0");
INSERT INTO timezone VALUES("17","+02","14618278800","7200","1");
INSERT INTO timezone VALUES("17","+00","14637027600","0","0");
INSERT INTO timezone VALUES("17","+02","14649728400","7200","1");
INSERT INTO timezone VALUES("17","+00","14668477200","0","0");
INSERT INTO timezone VALUES("17","+02","14681178000","7200","1");
INSERT INTO timezone VALUES("17","+00","14699926800","0","0");
INSERT INTO timezone VALUES("17","+02","14713232400","7200","1");
INSERT INTO timezone VALUES("17","+00","14731376400","0","0");
INSERT INTO timezone VALUES("17","+02","14744682000","7200","1");
INSERT INTO timezone VALUES("17","+00","14762826000","0","0");
INSERT INTO timezone VALUES("17","+02","14776131600","7200","1");
INSERT INTO timezone VALUES("17","+00","14794880400","0","0");
INSERT INTO timezone VALUES("17","+02","14807581200","7200","1");
INSERT INTO timezone VALUES("17","+00","14826330000","0","0");
INSERT INTO timezone VALUES("17","+02","14839030800","7200","1");
INSERT INTO timezone VALUES("17","+00","14857779600","0","0");
INSERT INTO timezone VALUES("17","+02","14871085200","7200","1");
INSERT INTO timezone VALUES("17","+00","14889229200","0","0");
INSERT INTO timezone VALUES("17","+02","14902534800","7200","1");
INSERT INTO timezone VALUES("17","+00","14920678800","0","0");
INSERT INTO timezone VALUES("17","+02","14933984400","7200","1");
INSERT INTO timezone VALUES("17","+00","14952128400","0","0");
INSERT INTO timezone VALUES("17","+02","14965434000","7200","1");
INSERT INTO timezone VALUES("17","+00","14984182800","0","0");
INSERT INTO timezone VALUES("17","+02","14996883600","7200","1");
INSERT INTO timezone VALUES("17","+00","15015632400","0","0");
INSERT INTO timezone VALUES("17","+02","15028333200","7200","1");
INSERT INTO timezone VALUES("17","+00","15047082000","0","0");
INSERT INTO timezone VALUES("17","+02","15060387600","7200","1");
INSERT INTO timezone VALUES("17","+00","15078531600","0","0");
INSERT INTO timezone VALUES("17","+02","15091837200","7200","1");
INSERT INTO timezone VALUES("17","+00","15109981200","0","0");
INSERT INTO timezone VALUES("17","+02","15123286800","7200","1");
INSERT INTO timezone VALUES("17","+00","15142035600","0","0");
INSERT INTO timezone VALUES("17","+02","15154736400","7200","1");
INSERT INTO timezone VALUES("17","+00","15173485200","0","0");
INSERT INTO timezone VALUES("17","+02","15186186000","7200","1");
INSERT INTO timezone VALUES("17","+00","15204934800","0","0");
INSERT INTO timezone VALUES("17","+02","15218240400","7200","1");
INSERT INTO timezone VALUES("17","+00","15236384400","0","0");
INSERT INTO timezone VALUES("17","+02","15249690000","7200","1");
INSERT INTO timezone VALUES("17","+00","15267834000","0","0");
INSERT INTO timezone VALUES("17","+02","15281139600","7200","1");
INSERT INTO timezone VALUES("17","+00","15299283600","0","0");
INSERT INTO timezone VALUES("17","+02","15312589200","7200","1");
INSERT INTO timezone VALUES("17","+00","15331338000","0","0");
INSERT INTO timezone VALUES("17","+02","15344038800","7200","1");
INSERT INTO timezone VALUES("17","+00","15362787600","0","0");
INSERT INTO timezone VALUES("17","+02","15375488400","7200","1");
INSERT INTO timezone VALUES("17","+00","15394237200","0","0");
INSERT INTO timezone VALUES("17","+02","15407542800","7200","1");
INSERT INTO timezone VALUES("17","+00","15425686800","0","0");
INSERT INTO timezone VALUES("17","+02","15438992400","7200","1");
INSERT INTO timezone VALUES("17","+00","15457136400","0","0");
INSERT INTO timezone VALUES("17","+02","15470442000","7200","1");
INSERT INTO timezone VALUES("17","+00","15489190800","0","0");
INSERT INTO timezone VALUES("17","+02","15501891600","7200","1");
INSERT INTO timezone VALUES("17","+00","15520640400","0","0");
INSERT INTO timezone VALUES("17","+02","15533341200","7200","1");
INSERT INTO timezone VALUES("17","+00","15552090000","0","0");
INSERT INTO timezone VALUES("17","+02","15564790800","7200","1");
INSERT INTO timezone VALUES("17","+00","15583539600","0","0");
INSERT INTO timezone VALUES("17","+02","15596845200","7200","1");
INSERT INTO timezone VALUES("17","+00","15614989200","0","0");
INSERT INTO timezone VALUES("17","+02","15628294800","7200","1");
INSERT INTO timezone VALUES("17","+00","15646438800","0","0");
INSERT INTO timezone VALUES("17","+02","15659744400","7200","1");
INSERT INTO timezone VALUES("17","+00","15678493200","0","0");
INSERT INTO timezone VALUES("17","+02","15691194000","7200","1");
INSERT INTO timezone VALUES("17","+00","15709942800","0","0");
INSERT INTO timezone VALUES("17","+02","15722643600","7200","1");
INSERT INTO timezone VALUES("17","+00","15741392400","0","0");
INSERT INTO timezone VALUES("17","+02","15754698000","7200","1");
INSERT INTO timezone VALUES("17","+00","15772842000","0","0");
INSERT INTO timezone VALUES("17","+02","15786147600","7200","1");
INSERT INTO timezone VALUES("17","+00","15804291600","0","0");
INSERT INTO timezone VALUES("17","+02","15817597200","7200","1");
INSERT INTO timezone VALUES("17","+00","15835741200","0","0");
INSERT INTO timezone VALUES("17","+02","15849046800","7200","1");
INSERT INTO timezone VALUES("17","+00","15867795600","0","0");
INSERT INTO timezone VALUES("17","+02","15880496400","7200","1");
INSERT INTO timezone VALUES("17","+00","15899245200","0","0");
INSERT INTO timezone VALUES("17","+02","15911946000","7200","1");
INSERT INTO timezone VALUES("17","+00","15930694800","0","0");
INSERT INTO timezone VALUES("17","+02","15944000400","7200","1");
INSERT INTO timezone VALUES("17","+00","15962144400","0","0");
INSERT INTO timezone VALUES("17","+02","15975450000","7200","1");
INSERT INTO timezone VALUES("17","+00","15993594000","0","0");
INSERT INTO timezone VALUES("17","+02","16006899600","7200","1");
INSERT INTO timezone VALUES("17","+00","16025648400","0","0");
INSERT INTO timezone VALUES("17","+02","16038349200","7200","1");
INSERT INTO timezone VALUES("17","+00","16057098000","0","0");
INSERT INTO timezone VALUES("17","+02","16069798800","7200","1");
INSERT INTO timezone VALUES("17","+00","16088547600","0","0");
INSERT INTO timezone VALUES("17","+02","16101853200","7200","1");
INSERT INTO timezone VALUES("17","+00","16119997200","0","0");
INSERT INTO timezone VALUES("17","+02","16133302800","7200","1");
INSERT INTO timezone VALUES("17","+00","16151446800","0","0");
INSERT INTO timezone VALUES("17","+02","16164752400","7200","1");
INSERT INTO timezone VALUES("17","+00","16182896400","0","0");
INSERT INTO timezone VALUES("17","+02","16196202000","7200","1");
INSERT INTO timezone VALUES("17","+00","16214950800","0","0");
INSERT INTO timezone VALUES("17","+02","16227651600","7200","1");
INSERT INTO timezone VALUES("17","+00","16246400400","0","0");
INSERT INTO timezone VALUES("17","+02","16259101200","7200","1");
INSERT INTO timezone VALUES("17","+00","16277850000","0","0");
INSERT INTO timezone VALUES("17","+02","16291155600","7200","1");
INSERT INTO timezone VALUES("17","+00","16309299600","0","0");
INSERT INTO timezone VALUES("17","+02","16322605200","7200","1");
INSERT INTO timezone VALUES("17","+00","16340749200","0","0");
INSERT INTO timezone VALUES("17","+02","16354054800","7200","1");
INSERT INTO timezone VALUES("17","+00","16372803600","0","0");
INSERT INTO timezone VALUES("17","+02","16385504400","7200","1");
INSERT INTO timezone VALUES("17","+00","16404253200","0","0");
INSERT INTO timezone VALUES("17","+02","16416954000","7200","1");
INSERT INTO timezone VALUES("17","+00","16435702800","0","0");
INSERT INTO timezone VALUES("17","+02","16448403600","7200","1");
INSERT INTO timezone VALUES("17","+00","16467152400","0","0");
INSERT INTO timezone VALUES("17","+02","16480458000","7200","1");
INSERT INTO timezone VALUES("17","+00","16498602000","0","0");
INSERT INTO timezone VALUES("17","+02","16511907600","7200","1");
INSERT INTO timezone VALUES("17","+00","16530051600","0","0");
INSERT INTO timezone VALUES("17","+02","16543357200","7200","1");
INSERT INTO timezone VALUES("17","+00","16562106000","0","0");
INSERT INTO timezone VALUES("17","+02","16574806800","7200","1");
INSERT INTO timezone VALUES("17","+00","16593555600","0","0");
INSERT INTO timezone VALUES("17","+02","16606256400","7200","1");
INSERT INTO timezone VALUES("17","+00","16625005200","0","0");
INSERT INTO timezone VALUES("17","+02","16638310800","7200","1");
INSERT INTO timezone VALUES("17","+00","16656454800","0","0");
INSERT INTO timezone VALUES("17","+02","16669760400","7200","1");
INSERT INTO timezone VALUES("17","+00","16687904400","0","0");
INSERT INTO timezone VALUES("17","+02","16701210000","7200","1");
INSERT INTO timezone VALUES("17","+00","16719354000","0","0");
INSERT INTO timezone VALUES("18","+06","-380073600","21600","0");
INSERT INTO timezone VALUES("19","LMT","-2372097973","-14028","0");
INSERT INTO timezone VALUES("19","CMT","-2372097972","-15408","0");
INSERT INTO timezone VALUES("19","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("19","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("19","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("19","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("19","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("19","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("19","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("19","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("19","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("19","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("19","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("19","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("19","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("19","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("19","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("19","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("19","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("19","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("19","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("19","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("19","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("19","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("19","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("19","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("19","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("19","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("19","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("19","-03","667965600","-10800","0");
INSERT INTO timezone VALUES("19","-02","687927600","-7200","1");
INSERT INTO timezone VALUES("19","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("19","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("19","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("19","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("19","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("19","-02","1224385200","-7200","1");
INSERT INTO timezone VALUES("19","-03","1237082400","-10800","0");
INSERT INTO timezone VALUES("20","LMT","-2372096593","-15408","0");
INSERT INTO timezone VALUES("20","CMT","-2372096592","-15408","0");
INSERT INTO timezone VALUES("20","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("20","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("20","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("20","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("20","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("20","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("20","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("20","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("20","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("20","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("20","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("20","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("20","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("20","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("20","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("20","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("20","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("20","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("20","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("20","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("20","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("20","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("20","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("20","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("20","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("20","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("20","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("20","-04","667965600","-14400","0");
INSERT INTO timezone VALUES("20","-02","687931200","-7200","1");
INSERT INTO timezone VALUES("20","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("20","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("20","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("20","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("20","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("20","-02","1224385200","-7200","1");
INSERT INTO timezone VALUES("20","-03","1237082400","-10800","0");
INSERT INTO timezone VALUES("21","LMT","-2372096301","-15700","0");
INSERT INTO timezone VALUES("21","CMT","-2372096300","-15408","0");
INSERT INTO timezone VALUES("21","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("21","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("21","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("21","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("21","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("21","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("21","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("21","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("21","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("21","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("21","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("21","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("21","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("21","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("21","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("21","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("21","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("21","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("21","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("21","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("21","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("21","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("21","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("21","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("21","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("21","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("21","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("21","-04","667965600","-14400","0");
INSERT INTO timezone VALUES("21","-02","687931200","-7200","1");
INSERT INTO timezone VALUES("21","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("21","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("21","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("21","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("21","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("22","LMT","-2372096329","-15672","0");
INSERT INTO timezone VALUES("22","CMT","-2372096328","-15408","0");
INSERT INTO timezone VALUES("22","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("22","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("22","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("22","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("22","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("22","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("22","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("22","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("22","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("22","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("22","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("22","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("22","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("22","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("22","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("22","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("22","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("22","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("22","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("22","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("22","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("22","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("22","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("22","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("22","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("22","-04","636516000","-14400","0");
INSERT INTO timezone VALUES("22","-03","657086400","-10800","1");
INSERT INTO timezone VALUES("22","-04","669178800","-14400","0");
INSERT INTO timezone VALUES("22","-02","686721600","-7200","1");
INSERT INTO timezone VALUES("22","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("22","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("22","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("22","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("22","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("23","LMT","-2372096349","-15652","0");
INSERT INTO timezone VALUES("23","CMT","-2372096348","-15408","0");
INSERT INTO timezone VALUES("23","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("23","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("23","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("23","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("23","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("23","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("23","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("23","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("23","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("23","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("23","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("23","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("23","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("23","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("23","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("23","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("23","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("23","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("23","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("23","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("23","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("23","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("23","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("23","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("23","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("23","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("23","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("23","-04","667965600","-14400","0");
INSERT INTO timezone VALUES("23","-02","687931200","-7200","1");
INSERT INTO timezone VALUES("23","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("23","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("23","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("23","-04","1086058800","-14400","0");
INSERT INTO timezone VALUES("23","-03","1087099200","-10800","0");
INSERT INTO timezone VALUES("23","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("23","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("23","-02","1224385200","-7200","1");
INSERT INTO timezone VALUES("23","-03","1237082400","-10800","0");
INSERT INTO timezone VALUES("24","LMT","-2372096213","-15788","0");
INSERT INTO timezone VALUES("24","CMT","-2372096212","-15408","0");
INSERT INTO timezone VALUES("24","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("24","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("24","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("24","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("24","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("24","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("24","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("24","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("24","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("24","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("24","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("24","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("24","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("24","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("24","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("24","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("24","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("24","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("24","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("24","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("24","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("24","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("24","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("24","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("24","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("24","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("24","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("24","-04","667965600","-14400","0");
INSERT INTO timezone VALUES("24","-02","687931200","-7200","1");
INSERT INTO timezone VALUES("24","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("24","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("24","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("24","-04","1086058800","-14400","0");
INSERT INTO timezone VALUES("24","-03","1087704000","-10800","0");
INSERT INTO timezone VALUES("24","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("24","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("25","LMT","-2372095957","-16044","0");
INSERT INTO timezone VALUES("25","CMT","-2372095956","-15408","0");
INSERT INTO timezone VALUES("25","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("25","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("25","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("25","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("25","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("25","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("25","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("25","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("25","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("25","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("25","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("25","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("25","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("25","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("25","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("25","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("25","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("25","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("25","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("25","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("25","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("25","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("25","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("25","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("25","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("25","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("25","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("25","-04","667792800","-14400","0");
INSERT INTO timezone VALUES("25","-03","673588800","-10800","0");
INSERT INTO timezone VALUES("25","-02","687927600","-7200","1");
INSERT INTO timezone VALUES("25","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("25","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("25","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("25","-04","1086058800","-14400","0");
INSERT INTO timezone VALUES("25","-03","1087704000","-10800","0");
INSERT INTO timezone VALUES("25","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("25","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("26","LMT","-2372095557","-16444","0");
INSERT INTO timezone VALUES("26","CMT","-2372095556","-15408","0");
INSERT INTO timezone VALUES("26","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("26","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("26","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("26","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("26","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("26","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("26","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("26","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("26","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("26","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("26","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("26","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("26","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("26","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("26","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("26","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("26","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("26","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("26","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("26","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("26","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("26","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("26","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("26","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("26","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("26","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("26","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("26","-04","667792800","-14400","0");
INSERT INTO timezone VALUES("26","-03","673588800","-10800","0");
INSERT INTO timezone VALUES("26","-02","687927600","-7200","1");
INSERT INTO timezone VALUES("26","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("26","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("26","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("26","-04","1085972400","-14400","0");
INSERT INTO timezone VALUES("26","-03","1090728000","-10800","0");
INSERT INTO timezone VALUES("26","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("26","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("27","LMT","-2372095485","-16516","0");
INSERT INTO timezone VALUES("27","CMT","-2372095484","-15408","0");
INSERT INTO timezone VALUES("27","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("27","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("27","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("27","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("27","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("27","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("27","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("27","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("27","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("27","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("27","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("27","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("27","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("27","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("27","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("27","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("27","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("27","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("27","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("27","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("27","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("27","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("27","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("27","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("27","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("27","-04","636516000","-14400","0");
INSERT INTO timezone VALUES("27","-03","655963200","-10800","1");
INSERT INTO timezone VALUES("27","-04","667796400","-14400","0");
INSERT INTO timezone VALUES("27","-03","687499200","-10800","1");
INSERT INTO timezone VALUES("27","-04","699418800","-14400","0");
INSERT INTO timezone VALUES("27","-02","719380800","-7200","1");
INSERT INTO timezone VALUES("27","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("27","-04","1085281200","-14400","0");
INSERT INTO timezone VALUES("27","-03","1096171200","-10800","0");
INSERT INTO timezone VALUES("27","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("27","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("28","LMT","-2372096077","-15924","0");
INSERT INTO timezone VALUES("28","CMT","-2372096076","-15408","0");
INSERT INTO timezone VALUES("28","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("28","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("28","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("28","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("28","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("28","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("28","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("28","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("28","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("28","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("28","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("28","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("28","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("28","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("28","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("28","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("28","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("28","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("28","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("28","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("28","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("28","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("28","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("28","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("28","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("28","-04","637380000","-14400","0");
INSERT INTO timezone VALUES("28","-03","655963200","-10800","1");
INSERT INTO timezone VALUES("28","-04","667796400","-14400","0");
INSERT INTO timezone VALUES("28","-03","675748800","-10800","0");
INSERT INTO timezone VALUES("28","-04","1085972400","-14400","0");
INSERT INTO timezone VALUES("28","-03","1090728000","-10800","0");
INSERT INTO timezone VALUES("28","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("28","-03","1200880800","-10800","1");
INSERT INTO timezone VALUES("28","-04","1205031600","-14400","0");
INSERT INTO timezone VALUES("28","-03","1223784000","-10800","1");
INSERT INTO timezone VALUES("28","-04","1236481200","-14400","0");
INSERT INTO timezone VALUES("28","-03","1255233600","-10800","0");
INSERT INTO timezone VALUES("29","LMT","-2372095389","-16612","0");
INSERT INTO timezone VALUES("29","CMT","-2372095388","-15408","0");
INSERT INTO timezone VALUES("29","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("29","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("29","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("29","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("29","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("29","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("29","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("29","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("29","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("29","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("29","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("29","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("29","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("29","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("29","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("29","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("29","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("29","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("29","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("29","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("29","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("29","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("29","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("29","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("29","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("29","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("29","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("29","-03","667965600","-10800","0");
INSERT INTO timezone VALUES("29","-02","687927600","-7200","1");
INSERT INTO timezone VALUES("29","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("29","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("29","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("29","-04","1086058800","-14400","0");
INSERT INTO timezone VALUES("29","-03","1087704000","-10800","0");
INSERT INTO timezone VALUES("29","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("29","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("30","LMT","-2372095609","-16392","0");
INSERT INTO timezone VALUES("30","CMT","-2372095608","-15408","0");
INSERT INTO timezone VALUES("30","-04","-1567453392","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1233432000","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1222981200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1205956800","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1194037200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1172865600","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1162501200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1141329600","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1130965200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1109793600","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1099429200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1078257600","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1067806800","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1046635200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1036270800","-14400","0");
INSERT INTO timezone VALUES("30","-03","-1015099200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-1004734800","-14400","0");
INSERT INTO timezone VALUES("30","-03","-983563200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-973198800","-14400","0");
INSERT INTO timezone VALUES("30","-03","-952027200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-941576400","-14400","0");
INSERT INTO timezone VALUES("30","-03","-931032000","-10800","1");
INSERT INTO timezone VALUES("30","-04","-900882000","-14400","0");
INSERT INTO timezone VALUES("30","-03","-890337600","-10800","1");
INSERT INTO timezone VALUES("30","-04","-833749200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-827265600","-10800","1");
INSERT INTO timezone VALUES("30","-04","-752274000","-14400","0");
INSERT INTO timezone VALUES("30","-03","-733780800","-10800","1");
INSERT INTO timezone VALUES("30","-04","-197326800","-14400","0");
INSERT INTO timezone VALUES("30","-03","-190843200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-184194000","-14400","0");
INSERT INTO timezone VALUES("30","-03","-164491200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-152658000","-14400","0");
INSERT INTO timezone VALUES("30","-03","-132955200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-121122000","-14400","0");
INSERT INTO timezone VALUES("30","-03","-101419200","-10800","1");
INSERT INTO timezone VALUES("30","-04","-86821200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-71092800","-10800","1");
INSERT INTO timezone VALUES("30","-04","-54766800","-14400","0");
INSERT INTO timezone VALUES("30","-03","-39038400","-10800","1");
INSERT INTO timezone VALUES("30","-04","-23317200","-14400","0");
INSERT INTO timezone VALUES("30","-03","-7588800","-10800","0");
INSERT INTO timezone VALUES("30","-02","128142000","-7200","1");
INSERT INTO timezone VALUES("30","-03","136605600","-10800","0");
INSERT INTO timezone VALUES("30","-02","596948400","-7200","1");
INSERT INTO timezone VALUES("30","-03","605066400","-10800","0");
INSERT INTO timezone VALUES("30","-02","624423600","-7200","1");
INSERT INTO timezone VALUES("30","-03","636516000","-10800","0");
INSERT INTO timezone VALUES("30","-02","656478000","-7200","1");
INSERT INTO timezone VALUES("30","-03","667965600","-10800","0");
INSERT INTO timezone VALUES("30","-02","687927600","-7200","1");
INSERT INTO timezone VALUES("30","-03","699415200","-10800","0");
INSERT INTO timezone VALUES("30","-02","719377200","-7200","1");
INSERT INTO timezone VALUES("30","-03","731469600","-10800","0");
INSERT INTO timezone VALUES("30","-04","1085886000","-14400","0");
INSERT INTO timezone VALUES("30","-03","1087704000","-10800","0");
INSERT INTO timezone VALUES("30","-02","1198983600","-7200","1");
INSERT INTO timezone VALUES("30","-03","1205632800","-10800","0");
INSERT INTO timezone VALUES("31","LMT","-2855738233","45432","0");
INSERT INTO timezone VALUES("31","LMT","-2855738232","-40968","0");
INSERT INTO timezone VALUES("31","SST","-1861879032","-39600","0");
INSERT INTO timezone VALUES("32","LMT","-2422055122","3921","0");
INSERT INTO timezone VALUES("32","CET","-2422055121","3600","0");
INSERT INTO timezone VALUES("32","CEST","-1693706400","7200","1");
INSERT INTO timezone VALUES("32","CET","-1680483600","3600","0");
INSERT INTO timezone VALUES("32","CEST","-1663455600","7200","1");
INSERT INTO timezone VALUES("32","CET","-1650150000","3600","0");
INSERT INTO timezone VALUES("32","CEST","-1632006000","7200","1");
INSERT INTO timezone VALUES("32","CET","-1618700400","3600","0");
INSERT INTO timezone VALUES("32","CEST","-1569711600","7200","1");
INSERT INTO timezone VALUES("32","CET","-1555801200","3600","0");
INSERT INTO timezone VALUES("32","CEST","-938905200","7200","1");
INSERT INTO timezone VALUES("32","CET","-857257200","3600","0");
INSERT INTO timezone VALUES("32","CEST","-844556400","7200","1");
INSERT INTO timezone VALUES("32","CET","-828226800","3600","0");
INSERT INTO timezone VALUES("32","CEST","-812502000","7200","1");
INSERT INTO timezone VALUES("32","CET","-796777200","3600","0");
INSERT INTO timezone VALUES("32","CEST","-781052400","7200","1");
INSERT INTO timezone VALUES("32","CET","-780188400","3600","0");
INSERT INTO timezone VALUES("32","CEST","-748479600","7200","1");
INSERT INTO timezone VALUES("32","CET","-733359600","3600","0");
INSERT INTO timezone VALUES("32","CEST","-717634800","7200","1");
INSERT INTO timezone VALUES("32","CET","-701910000","3600","0");
INSERT INTO timezone VALUES("32","CEST","-684975600","7200","1");
INSERT INTO timezone VALUES("32","CET","-670460400","3600","0");
INSERT INTO timezone VALUES("32","CEST","323823600","7200","1");
INSERT INTO timezone VALUES("32","CET","338940000","3600","0");
INSERT INTO timezone VALUES("32","CEST","354675600","7200","1");
INSERT INTO timezone VALUES("32","CET","370400400","3600","0");
INSERT INTO timezone VALUES("32","CEST","386125200","7200","1");
INSERT INTO timezone VALUES("32","CET","401850000","3600","0");
INSERT INTO timezone VALUES("32","CEST","417574800","7200","1");
INSERT INTO timezone VALUES("32","CET","433299600","3600","0");
INSERT INTO timezone VALUES("32","CEST","449024400","7200","1");
INSERT INTO timezone VALUES("32","CET","465354000","3600","0");
INSERT INTO timezone VALUES("32","CEST","481078800","7200","1");
INSERT INTO timezone VALUES("32","CET","496803600","3600","0");
INSERT INTO timezone VALUES("32","CEST","512528400","7200","1");
INSERT INTO timezone VALUES("32","CET","528253200","3600","0");
INSERT INTO timezone VALUES("32","CEST","543978000","7200","1");
INSERT INTO timezone VALUES("32","CET","559702800","3600","0");
INSERT INTO timezone VALUES("32","CEST","575427600","7200","1");
INSERT INTO timezone VALUES("32","CET","591152400","3600","0");
INSERT INTO timezone VALUES("32","CEST","606877200","7200","1");
INSERT INTO timezone VALUES("32","CET","622602000","3600","0");
INSERT INTO timezone VALUES("32","CEST","638326800","7200","1");
INSERT INTO timezone VALUES("32","CET","654656400","3600","0");
INSERT INTO timezone VALUES("32","CEST","670381200","7200","1");
INSERT INTO timezone VALUES("32","CET","686106000","3600","0");
INSERT INTO timezone VALUES("32","CEST","701830800","7200","1");
INSERT INTO timezone VALUES("32","CET","717555600","3600","0");
INSERT INTO timezone VALUES("32","CEST","733280400","7200","1");
INSERT INTO timezone VALUES("32","CET","749005200","3600","0");
INSERT INTO timezone VALUES("32","CEST","764730000","7200","1");
INSERT INTO timezone VALUES("32","CET","780454800","3600","0");
INSERT INTO timezone VALUES("32","CEST","796179600","7200","1");
INSERT INTO timezone VALUES("32","CET","811904400","3600","0");
INSERT INTO timezone VALUES("32","CEST","828234000","7200","1");
INSERT INTO timezone VALUES("32","CET","846378000","3600","0");
INSERT INTO timezone VALUES("32","CEST","859683600","7200","1");
INSERT INTO timezone VALUES("32","CET","877827600","3600","0");
INSERT INTO timezone VALUES("32","CEST","891133200","7200","1");
INSERT INTO timezone VALUES("32","CET","909277200","3600","0");
INSERT INTO timezone VALUES("32","CEST","922582800","7200","1");
INSERT INTO timezone VALUES("32","CET","941331600","3600","0");
INSERT INTO timezone VALUES("32","CEST","954032400","7200","1");
INSERT INTO timezone VALUES("32","CET","972781200","3600","0");
INSERT INTO timezone VALUES("32","CEST","985482000","7200","1");
INSERT INTO timezone VALUES("32","CET","1004230800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1017536400","7200","1");
INSERT INTO timezone VALUES("32","CET","1035680400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1048986000","7200","1");
INSERT INTO timezone VALUES("32","CET","1067130000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1080435600","7200","1");
INSERT INTO timezone VALUES("32","CET","1099184400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1111885200","7200","1");
INSERT INTO timezone VALUES("32","CET","1130634000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1143334800","7200","1");
INSERT INTO timezone VALUES("32","CET","1162083600","3600","0");
INSERT INTO timezone VALUES("32","CEST","1174784400","7200","1");
INSERT INTO timezone VALUES("32","CET","1193533200","3600","0");
INSERT INTO timezone VALUES("32","CEST","1206838800","7200","1");
INSERT INTO timezone VALUES("32","CET","1224982800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1238288400","7200","1");
INSERT INTO timezone VALUES("32","CET","1256432400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1269738000","7200","1");
INSERT INTO timezone VALUES("32","CET","1288486800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1301187600","7200","1");
INSERT INTO timezone VALUES("32","CET","1319936400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1332637200","7200","1");
INSERT INTO timezone VALUES("32","CET","1351386000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1364691600","7200","1");
INSERT INTO timezone VALUES("32","CET","1382835600","3600","0");
INSERT INTO timezone VALUES("32","CEST","1396141200","7200","1");
INSERT INTO timezone VALUES("32","CET","1414285200","3600","0");
INSERT INTO timezone VALUES("32","CEST","1427590800","7200","1");
INSERT INTO timezone VALUES("32","CET","1445734800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1459040400","7200","1");
INSERT INTO timezone VALUES("32","CET","1477789200","3600","0");
INSERT INTO timezone VALUES("32","CEST","1490490000","7200","1");
INSERT INTO timezone VALUES("32","CET","1509238800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1521939600","7200","1");
INSERT INTO timezone VALUES("32","CET","1540688400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1553994000","7200","1");
INSERT INTO timezone VALUES("32","CET","1572138000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1585443600","7200","1");
INSERT INTO timezone VALUES("32","CET","1603587600","3600","0");
INSERT INTO timezone VALUES("32","CEST","1616893200","7200","1");
INSERT INTO timezone VALUES("32","CET","1635642000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1648342800","7200","1");
INSERT INTO timezone VALUES("32","CET","1667091600","3600","0");
INSERT INTO timezone VALUES("32","CEST","1679792400","7200","1");
INSERT INTO timezone VALUES("32","CET","1698541200","3600","0");
INSERT INTO timezone VALUES("32","CEST","1711846800","7200","1");
INSERT INTO timezone VALUES("32","CET","1729990800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1743296400","7200","1");
INSERT INTO timezone VALUES("32","CET","1761440400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1774746000","7200","1");
INSERT INTO timezone VALUES("32","CET","1792890000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1806195600","7200","1");
INSERT INTO timezone VALUES("32","CET","1824944400","3600","0");
INSERT INTO timezone VALUES("32","CEST","1837645200","7200","1");
INSERT INTO timezone VALUES("32","CET","1856394000","3600","0");
INSERT INTO timezone VALUES("32","CEST","1869094800","7200","1");
INSERT INTO timezone VALUES("32","CET","1887843600","3600","0");
INSERT INTO timezone VALUES("32","CEST","1901149200","7200","1");
INSERT INTO timezone VALUES("32","CET","1919293200","3600","0");
INSERT INTO timezone VALUES("32","CEST","1932598800","7200","1");
INSERT INTO timezone VALUES("32","CET","1950742800","3600","0");
INSERT INTO timezone VALUES("32","CEST","1964048400","7200","1");
INSERT INTO timezone VALUES("32","CET","1982797200","3600","0");
INSERT INTO timezone VALUES("32","CEST","1995498000","7200","1");
INSERT INTO timezone VALUES("32","CET","2014246800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2026947600","7200","1");
INSERT INTO timezone VALUES("32","CET","2045696400","3600","0");
INSERT INTO timezone VALUES("32","CEST","2058397200","7200","1");
INSERT INTO timezone VALUES("32","CET","2077146000","3600","0");
INSERT INTO timezone VALUES("32","CEST","2090451600","7200","1");
INSERT INTO timezone VALUES("32","CET","2108595600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2121901200","7200","1");
INSERT INTO timezone VALUES("32","CET","2140045200","3600","0");
INSERT INTO timezone VALUES("32","CEST","2153350800","7200","1");
INSERT INTO timezone VALUES("32","CET","2172099600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2184800400","7200","1");
INSERT INTO timezone VALUES("32","CET","2203549200","3600","0");
INSERT INTO timezone VALUES("32","CEST","2216250000","7200","1");
INSERT INTO timezone VALUES("32","CET","2234998800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2248304400","7200","1");
INSERT INTO timezone VALUES("32","CET","2266448400","3600","0");
INSERT INTO timezone VALUES("32","CEST","2279754000","7200","1");
INSERT INTO timezone VALUES("32","CET","2297898000","3600","0");
INSERT INTO timezone VALUES("32","CEST","2311203600","7200","1");
INSERT INTO timezone VALUES("32","CET","2329347600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2342653200","7200","1");
INSERT INTO timezone VALUES("32","CET","2361402000","3600","0");
INSERT INTO timezone VALUES("32","CEST","2374102800","7200","1");
INSERT INTO timezone VALUES("32","CET","2392851600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2405552400","7200","1");
INSERT INTO timezone VALUES("32","CET","2424301200","3600","0");
INSERT INTO timezone VALUES("32","CEST","2437606800","7200","1");
INSERT INTO timezone VALUES("32","CET","2455750800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2469056400","7200","1");
INSERT INTO timezone VALUES("32","CET","2487200400","3600","0");
INSERT INTO timezone VALUES("32","CEST","2500506000","7200","1");
INSERT INTO timezone VALUES("32","CET","2519254800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2531955600","7200","1");
INSERT INTO timezone VALUES("32","CET","2550704400","3600","0");
INSERT INTO timezone VALUES("32","CEST","2563405200","7200","1");
INSERT INTO timezone VALUES("32","CET","2582154000","3600","0");
INSERT INTO timezone VALUES("32","CEST","2595459600","7200","1");
INSERT INTO timezone VALUES("32","CET","2613603600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2626909200","7200","1");
INSERT INTO timezone VALUES("32","CET","2645053200","3600","0");
INSERT INTO timezone VALUES("32","CEST","2658358800","7200","1");
INSERT INTO timezone VALUES("32","CET","2676502800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2689808400","7200","1");
INSERT INTO timezone VALUES("32","CET","2708557200","3600","0");
INSERT INTO timezone VALUES("32","CEST","2721258000","7200","1");
INSERT INTO timezone VALUES("32","CET","2740006800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2752707600","7200","1");
INSERT INTO timezone VALUES("32","CET","2771456400","3600","0");
INSERT INTO timezone VALUES("32","CEST","2784762000","7200","1");
INSERT INTO timezone VALUES("32","CET","2802906000","3600","0");
INSERT INTO timezone VALUES("32","CEST","2816211600","7200","1");
INSERT INTO timezone VALUES("32","CET","2834355600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2847661200","7200","1");
INSERT INTO timezone VALUES("32","CET","2866410000","3600","0");
INSERT INTO timezone VALUES("32","CEST","2879110800","7200","1");
INSERT INTO timezone VALUES("32","CET","2897859600","3600","0");
INSERT INTO timezone VALUES("32","CEST","2910560400","7200","1");
INSERT INTO timezone VALUES("32","CET","2929309200","3600","0");
INSERT INTO timezone VALUES("32","CEST","2942010000","7200","1");
INSERT INTO timezone VALUES("32","CET","2960758800","3600","0");
INSERT INTO timezone VALUES("32","CEST","2974064400","7200","1");
INSERT INTO timezone VALUES("32","CET","2992208400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3005514000","7200","1");
INSERT INTO timezone VALUES("32","CET","3023658000","3600","0");
INSERT INTO timezone VALUES("32","CEST","3036963600","7200","1");
INSERT INTO timezone VALUES("32","CET","3055712400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3068413200","7200","1");
INSERT INTO timezone VALUES("32","CET","3087162000","3600","0");
INSERT INTO timezone VALUES("32","CEST","3099862800","7200","1");
INSERT INTO timezone VALUES("32","CET","3118611600","3600","0");
INSERT INTO timezone VALUES("32","CEST","3131917200","7200","1");
INSERT INTO timezone VALUES("32","CET","3150061200","3600","0");
INSERT INTO timezone VALUES("32","CEST","3163366800","7200","1");
INSERT INTO timezone VALUES("32","CET","3181510800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3194816400","7200","1");
INSERT INTO timezone VALUES("32","CET","3212960400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3226266000","7200","1");
INSERT INTO timezone VALUES("32","CET","3245014800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3257715600","7200","1");
INSERT INTO timezone VALUES("32","CET","3276464400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3289165200","7200","1");
INSERT INTO timezone VALUES("32","CET","3307914000","3600","0");
INSERT INTO timezone VALUES("32","CEST","3321219600","7200","1");
INSERT INTO timezone VALUES("32","CET","3339363600","3600","0");
INSERT INTO timezone VALUES("32","CEST","3352669200","7200","1");
INSERT INTO timezone VALUES("32","CET","3370813200","3600","0");
INSERT INTO timezone VALUES("32","CEST","3384118800","7200","1");
INSERT INTO timezone VALUES("32","CET","3402867600","3600","0");
INSERT INTO timezone VALUES("32","CEST","3415568400","7200","1");
INSERT INTO timezone VALUES("32","CET","3434317200","3600","0");
INSERT INTO timezone VALUES("32","CEST","3447018000","7200","1");
INSERT INTO timezone VALUES("32","CET","3465766800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3479072400","7200","1");
INSERT INTO timezone VALUES("32","CET","3497216400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3510522000","7200","1");
INSERT INTO timezone VALUES("32","CET","3528666000","3600","0");
INSERT INTO timezone VALUES("32","CEST","3541971600","7200","1");
INSERT INTO timezone VALUES("32","CET","3560115600","3600","0");
INSERT INTO timezone VALUES("32","CEST","3573421200","7200","1");
INSERT INTO timezone VALUES("32","CET","3592170000","3600","0");
INSERT INTO timezone VALUES("32","CEST","3604870800","7200","1");
INSERT INTO timezone VALUES("32","CET","3623619600","3600","0");
INSERT INTO timezone VALUES("32","CEST","3636320400","7200","1");
INSERT INTO timezone VALUES("32","CET","3655069200","3600","0");
INSERT INTO timezone VALUES("32","CEST","3668374800","7200","1");
INSERT INTO timezone VALUES("32","CET","3686518800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3699824400","7200","1");
INSERT INTO timezone VALUES("32","CET","3717968400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3731274000","7200","1");
INSERT INTO timezone VALUES("32","CET","3750022800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3762723600","7200","1");
INSERT INTO timezone VALUES("32","CET","3781472400","3600","0");
INSERT INTO timezone VALUES("32","CEST","3794173200","7200","1");
INSERT INTO timezone VALUES("32","CET","3812922000","3600","0");
INSERT INTO timezone VALUES("32","CEST","3825622800","7200","1");
INSERT INTO timezone VALUES("32","CET","3844371600","3600","0");
INSERT INTO timezone VALUES("32","CEST","3857677200","7200","1");
INSERT INTO timezone VALUES("32","CET","3875821200","3600","0");
INSERT INTO timezone VALUES("32","CEST","3889126800","7200","1");
INSERT INTO timezone VALUES("32","CET","3907270800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3920576400","7200","1");
INSERT INTO timezone VALUES("32","CET","3939325200","3600","0");
INSERT INTO timezone VALUES("32","CEST","3952026000","7200","1");
INSERT INTO timezone VALUES("32","CET","3970774800","3600","0");
INSERT INTO timezone VALUES("32","CEST","3983475600","7200","1");
INSERT INTO timezone VALUES("32","CET","4002224400","3600","0");
INSERT INTO timezone VALUES("32","CEST","4015530000","7200","1");
INSERT INTO timezone VALUES("32","CET","4033674000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4046979600","7200","1");
INSERT INTO timezone VALUES("32","CET","4065123600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4078429200","7200","1");
INSERT INTO timezone VALUES("32","CET","4096573200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4109878800","7200","1");
INSERT INTO timezone VALUES("32","CET","4128627600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4141328400","7200","1");
INSERT INTO timezone VALUES("32","CET","4160077200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4172778000","7200","1");
INSERT INTO timezone VALUES("32","CET","4191526800","3600","0");
INSERT INTO timezone VALUES("32","CEST","4204227600","7200","1");
INSERT INTO timezone VALUES("32","CET","4222976400","3600","0");
INSERT INTO timezone VALUES("32","CEST","4236282000","7200","1");
INSERT INTO timezone VALUES("32","CET","4254426000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4267731600","7200","1");
INSERT INTO timezone VALUES("32","CET","4285875600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4299181200","7200","1");
INSERT INTO timezone VALUES("32","CET","4317930000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4330630800","7200","1");
INSERT INTO timezone VALUES("32","CET","4349379600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4362080400","7200","1");
INSERT INTO timezone VALUES("32","CET","4380829200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4394134800","7200","1");
INSERT INTO timezone VALUES("32","CET","4412278800","3600","0");
INSERT INTO timezone VALUES("32","CEST","4425584400","7200","1");
INSERT INTO timezone VALUES("32","CET","4443728400","3600","0");
INSERT INTO timezone VALUES("32","CEST","4457034000","7200","1");
INSERT INTO timezone VALUES("32","CET","4475178000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4488483600","7200","1");
INSERT INTO timezone VALUES("32","CET","4507232400","3600","0");
INSERT INTO timezone VALUES("32","CEST","4519933200","7200","1");
INSERT INTO timezone VALUES("32","CET","4538682000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4551382800","7200","1");
INSERT INTO timezone VALUES("32","CET","4570131600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4583437200","7200","1");
INSERT INTO timezone VALUES("32","CET","4601581200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4614886800","7200","1");
INSERT INTO timezone VALUES("32","CET","4633030800","3600","0");
INSERT INTO timezone VALUES("32","CEST","4646336400","7200","1");
INSERT INTO timezone VALUES("32","CET","4665085200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4677786000","7200","1");
INSERT INTO timezone VALUES("32","CET","4696534800","3600","0");
INSERT INTO timezone VALUES("32","CEST","4709235600","7200","1");
INSERT INTO timezone VALUES("32","CET","4727984400","3600","0");
INSERT INTO timezone VALUES("32","CEST","4741290000","7200","1");
INSERT INTO timezone VALUES("32","CET","4759434000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4772739600","7200","1");
INSERT INTO timezone VALUES("32","CET","4790883600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4804189200","7200","1");
INSERT INTO timezone VALUES("32","CET","4822333200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4835638800","7200","1");
INSERT INTO timezone VALUES("32","CET","4854387600","3600","0");
INSERT INTO timezone VALUES("32","CEST","4867088400","7200","1");
INSERT INTO timezone VALUES("32","CET","4885837200","3600","0");
INSERT INTO timezone VALUES("32","CEST","4898538000","7200","1");
INSERT INTO timezone VALUES("32","CET","4917286800","3600","0");
INSERT INTO timezone VALUES("32","CEST","4930592400","7200","1");
INSERT INTO timezone VALUES("32","CET","4948736400","3600","0");
INSERT INTO timezone VALUES("32","CEST","4962042000","7200","1");
INSERT INTO timezone VALUES("32","CET","4980186000","3600","0");
INSERT INTO timezone VALUES("32","CEST","4993491600","7200","1");
INSERT INTO timezone VALUES("32","CET","5012240400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5024941200","7200","1");
INSERT INTO timezone VALUES("32","CET","5043690000","3600","0");
INSERT INTO timezone VALUES("32","CEST","5056390800","7200","1");
INSERT INTO timezone VALUES("32","CET","5075139600","3600","0");
INSERT INTO timezone VALUES("32","CEST","5087840400","7200","1");
INSERT INTO timezone VALUES("32","CET","5106589200","3600","0");
INSERT INTO timezone VALUES("32","CEST","5119894800","7200","1");
INSERT INTO timezone VALUES("32","CET","5138038800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5151344400","7200","1");
INSERT INTO timezone VALUES("32","CET","5169488400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5182794000","7200","1");
INSERT INTO timezone VALUES("32","CET","5201542800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5214243600","7200","1");
INSERT INTO timezone VALUES("32","CET","5232992400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5245693200","7200","1");
INSERT INTO timezone VALUES("32","CET","5264442000","3600","0");
INSERT INTO timezone VALUES("32","CEST","5277747600","7200","1");
INSERT INTO timezone VALUES("32","CET","5295891600","3600","0");
INSERT INTO timezone VALUES("32","CEST","5309197200","7200","1");
INSERT INTO timezone VALUES("32","CET","5327341200","3600","0");
INSERT INTO timezone VALUES("32","CEST","5340646800","7200","1");
INSERT INTO timezone VALUES("32","CET","5358790800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5372096400","7200","1");
INSERT INTO timezone VALUES("32","CET","5390845200","3600","0");
INSERT INTO timezone VALUES("32","CEST","5403546000","7200","1");
INSERT INTO timezone VALUES("32","CET","5422294800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5434995600","7200","1");
INSERT INTO timezone VALUES("32","CET","5453744400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5467050000","7200","1");
INSERT INTO timezone VALUES("32","CET","5485194000","3600","0");
INSERT INTO timezone VALUES("32","CEST","5498499600","7200","1");
INSERT INTO timezone VALUES("32","CET","5516643600","3600","0");
INSERT INTO timezone VALUES("32","CEST","5529949200","7200","1");
INSERT INTO timezone VALUES("32","CET","5548698000","3600","0");
INSERT INTO timezone VALUES("32","CEST","5561398800","7200","1");
INSERT INTO timezone VALUES("32","CET","5580147600","3600","0");
INSERT INTO timezone VALUES("32","CEST","5592848400","7200","1");
INSERT INTO timezone VALUES("32","CET","5611597200","3600","0");
INSERT INTO timezone VALUES("32","CEST","5624902800","7200","1");
INSERT INTO timezone VALUES("32","CET","5643046800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5656352400","7200","1");
INSERT INTO timezone VALUES("32","CET","5674496400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5687802000","7200","1");
INSERT INTO timezone VALUES("32","CET","5705946000","3600","0");
INSERT INTO timezone VALUES("32","CEST","5719251600","7200","1");
INSERT INTO timezone VALUES("32","CET","5738000400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5750701200","7200","1");
INSERT INTO timezone VALUES("32","CET","5769450000","3600","0");
INSERT INTO timezone VALUES("32","CEST","5782150800","7200","1");
INSERT INTO timezone VALUES("32","CET","5800899600","3600","0");
INSERT INTO timezone VALUES("32","CEST","5814205200","7200","1");
INSERT INTO timezone VALUES("32","CET","5832349200","3600","0");
INSERT INTO timezone VALUES("32","CEST","5845654800","7200","1");
INSERT INTO timezone VALUES("32","CET","5863798800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5877104400","7200","1");
INSERT INTO timezone VALUES("32","CET","5895853200","3600","0");
INSERT INTO timezone VALUES("32","CEST","5908554000","7200","1");
INSERT INTO timezone VALUES("32","CET","5927302800","3600","0");
INSERT INTO timezone VALUES("32","CEST","5940003600","7200","1");
INSERT INTO timezone VALUES("32","CET","5958752400","3600","0");
INSERT INTO timezone VALUES("32","CEST","5971453200","7200","1");
INSERT INTO timezone VALUES("32","CET","5990202000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6003507600","7200","1");
INSERT INTO timezone VALUES("32","CET","6021651600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6034957200","7200","1");
INSERT INTO timezone VALUES("32","CET","6053101200","3600","0");
INSERT INTO timezone VALUES("32","CEST","6066406800","7200","1");
INSERT INTO timezone VALUES("32","CET","6085155600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6097856400","7200","1");
INSERT INTO timezone VALUES("32","CET","6116605200","3600","0");
INSERT INTO timezone VALUES("32","CEST","6129306000","7200","1");
INSERT INTO timezone VALUES("32","CET","6148054800","3600","0");
INSERT INTO timezone VALUES("32","CEST","6161360400","7200","1");
INSERT INTO timezone VALUES("32","CET","6179504400","3600","0");
INSERT INTO timezone VALUES("32","CEST","6192810000","7200","1");
INSERT INTO timezone VALUES("32","CET","6210954000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6224259600","7200","1");
INSERT INTO timezone VALUES("32","CET","6242403600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6255709200","7200","1");
INSERT INTO timezone VALUES("32","CET","6274458000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6287158800","7200","1");
INSERT INTO timezone VALUES("32","CET","6305907600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6318608400","7200","1");
INSERT INTO timezone VALUES("32","CET","6337357200","3600","0");
INSERT INTO timezone VALUES("32","CEST","6350662800","7200","1");
INSERT INTO timezone VALUES("32","CET","6368806800","3600","0");
INSERT INTO timezone VALUES("32","CEST","6382112400","7200","1");
INSERT INTO timezone VALUES("32","CET","6400256400","3600","0");
INSERT INTO timezone VALUES("32","CEST","6413562000","7200","1");
INSERT INTO timezone VALUES("32","CET","6432310800","3600","0");
INSERT INTO timezone VALUES("32","CEST","6445011600","7200","1");
INSERT INTO timezone VALUES("32","CET","6463760400","3600","0");
INSERT INTO timezone VALUES("32","CEST","6476461200","7200","1");
INSERT INTO timezone VALUES("32","CET","6495210000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6508515600","7200","1");
INSERT INTO timezone VALUES("32","CET","6526659600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6539965200","7200","1");
INSERT INTO timezone VALUES("32","CET","6558109200","3600","0");
INSERT INTO timezone VALUES("32","CEST","6571414800","7200","1");
INSERT INTO timezone VALUES("32","CET","6589558800","3600","0");
INSERT INTO timezone VALUES("32","CEST","6602864400","7200","1");
INSERT INTO timezone VALUES("32","CET","6621613200","3600","0");
INSERT INTO timezone VALUES("32","CEST","6634314000","7200","1");
INSERT INTO timezone VALUES("32","CET","6653062800","3600","0");
INSERT INTO timezone VALUES("32","CEST","6665763600","7200","1");
INSERT INTO timezone VALUES("32","CET","6684512400","3600","0");
INSERT INTO timezone VALUES("32","CEST","6697818000","7200","1");
INSERT INTO timezone VALUES("32","CET","6715962000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6729267600","7200","1");
INSERT INTO timezone VALUES("32","CET","6747411600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6760717200","7200","1");
INSERT INTO timezone VALUES("32","CET","6779466000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6792166800","7200","1");
INSERT INTO timezone VALUES("32","CET","6810915600","3600","0");
INSERT INTO timezone VALUES("32","CEST","6823616400","7200","1");
INSERT INTO timezone VALUES("32","CET","6842365200","3600","0");
INSERT INTO timezone VALUES("32","CEST","6855066000","7200","1");
INSERT INTO timezone VALUES("32","CET","6873814800","3600","0");
INSERT INTO timezone VALUES("32","CEST","6887120400","7200","1");
INSERT INTO timezone VALUES("32","CET","6905264400","3600","0");
INSERT INTO timezone VALUES("32","CEST","6918570000","7200","1");
INSERT INTO timezone VALUES("32","CET","6936714000","3600","0");
INSERT INTO timezone VALUES("32","CEST","6950019600","7200","1");
INSERT INTO timezone VALUES("32","CET","6968768400","3600","0");
INSERT INTO timezone VALUES("32","CEST","6981469200","7200","1");
INSERT INTO timezone VALUES("32","CET","7000218000","3600","0");
INSERT INTO timezone VALUES("32","CEST","7012918800","7200","1");
INSERT INTO timezone VALUES("32","CET","7031667600","3600","0");
INSERT INTO timezone VALUES("32","CEST","7044973200","7200","1");
INSERT INTO timezone VALUES("32","CET","7063117200","3600","0");
INSERT INTO timezone VALUES("32","CEST","7076422800","7200","1");
INSERT INTO timezone VALUES("32","CET","7094566800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7107872400","7200","1");
INSERT INTO timezone VALUES("32","CET","7126016400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7139322000","7200","1");
INSERT INTO timezone VALUES("32","CET","7158070800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7170771600","7200","1");
INSERT INTO timezone VALUES("32","CET","7189520400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7202221200","7200","1");
INSERT INTO timezone VALUES("32","CET","7220970000","3600","0");
INSERT INTO timezone VALUES("32","CEST","7234275600","7200","1");
INSERT INTO timezone VALUES("32","CET","7252419600","3600","0");
INSERT INTO timezone VALUES("32","CEST","7265725200","7200","1");
INSERT INTO timezone VALUES("32","CET","7283869200","3600","0");
INSERT INTO timezone VALUES("32","CEST","7297174800","7200","1");
INSERT INTO timezone VALUES("32","CET","7315318800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7328624400","7200","1");
INSERT INTO timezone VALUES("32","CET","7347373200","3600","0");
INSERT INTO timezone VALUES("32","CEST","7360074000","7200","1");
INSERT INTO timezone VALUES("32","CET","7378822800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7391523600","7200","1");
INSERT INTO timezone VALUES("32","CET","7410272400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7423578000","7200","1");
INSERT INTO timezone VALUES("32","CET","7441722000","3600","0");
INSERT INTO timezone VALUES("32","CEST","7455027600","7200","1");
INSERT INTO timezone VALUES("32","CET","7473171600","3600","0");
INSERT INTO timezone VALUES("32","CEST","7486477200","7200","1");
INSERT INTO timezone VALUES("32","CET","7504621200","3600","0");
INSERT INTO timezone VALUES("32","CEST","7517926800","7200","1");
INSERT INTO timezone VALUES("32","CET","7536675600","3600","0");
INSERT INTO timezone VALUES("32","CEST","7549376400","7200","1");
INSERT INTO timezone VALUES("32","CET","7568125200","3600","0");
INSERT INTO timezone VALUES("32","CEST","7580826000","7200","1");
INSERT INTO timezone VALUES("32","CET","7599574800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7612880400","7200","1");
INSERT INTO timezone VALUES("32","CET","7631024400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7644330000","7200","1");
INSERT INTO timezone VALUES("32","CET","7662474000","3600","0");
INSERT INTO timezone VALUES("32","CEST","7675779600","7200","1");
INSERT INTO timezone VALUES("32","CET","7694528400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7707229200","7200","1");
INSERT INTO timezone VALUES("32","CET","7725978000","3600","0");
INSERT INTO timezone VALUES("32","CEST","7738678800","7200","1");
INSERT INTO timezone VALUES("32","CET","7757427600","3600","0");
INSERT INTO timezone VALUES("32","CEST","7770733200","7200","1");
INSERT INTO timezone VALUES("32","CET","7788877200","3600","0");
INSERT INTO timezone VALUES("32","CEST","7802182800","7200","1");
INSERT INTO timezone VALUES("32","CET","7820326800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7833632400","7200","1");
INSERT INTO timezone VALUES("32","CET","7851776400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7865082000","7200","1");
INSERT INTO timezone VALUES("32","CET","7883830800","3600","0");
INSERT INTO timezone VALUES("32","CEST","7896531600","7200","1");
INSERT INTO timezone VALUES("32","CET","7915280400","3600","0");
INSERT INTO timezone VALUES("32","CEST","7927981200","7200","1");
INSERT INTO timezone VALUES("32","CET","7946730000","3600","0");
INSERT INTO timezone VALUES("32","CEST","7960035600","7200","1");
INSERT INTO timezone VALUES("32","CET","7978179600","3600","0");
INSERT INTO timezone VALUES("32","CEST","7991485200","7200","1");
INSERT INTO timezone VALUES("32","CET","8009629200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8022934800","7200","1");
INSERT INTO timezone VALUES("32","CET","8041683600","3600","0");
INSERT INTO timezone VALUES("32","CEST","8054384400","7200","1");
INSERT INTO timezone VALUES("32","CET","8073133200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8085834000","7200","1");
INSERT INTO timezone VALUES("32","CET","8104582800","3600","0");
INSERT INTO timezone VALUES("32","CEST","8117283600","7200","1");
INSERT INTO timezone VALUES("32","CET","8136032400","3600","0");
INSERT INTO timezone VALUES("32","CEST","8149338000","7200","1");
INSERT INTO timezone VALUES("32","CET","8167482000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8180787600","7200","1");
INSERT INTO timezone VALUES("32","CET","8198931600","3600","0");
INSERT INTO timezone VALUES("32","CEST","8212237200","7200","1");
INSERT INTO timezone VALUES("32","CET","8230986000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8243686800","7200","1");
INSERT INTO timezone VALUES("32","CET","8262435600","3600","0");
INSERT INTO timezone VALUES("32","CEST","8275136400","7200","1");
INSERT INTO timezone VALUES("32","CET","8293885200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8307190800","7200","1");
INSERT INTO timezone VALUES("32","CET","8325334800","3600","0");
INSERT INTO timezone VALUES("32","CEST","8338640400","7200","1");
INSERT INTO timezone VALUES("32","CET","8356784400","3600","0");
INSERT INTO timezone VALUES("32","CEST","8370090000","7200","1");
INSERT INTO timezone VALUES("32","CET","8388234000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8401539600","7200","1");
INSERT INTO timezone VALUES("32","CET","8420288400","3600","0");
INSERT INTO timezone VALUES("32","CEST","8432989200","7200","1");
INSERT INTO timezone VALUES("32","CET","8451738000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8464438800","7200","1");
INSERT INTO timezone VALUES("32","CET","8483187600","3600","0");
INSERT INTO timezone VALUES("32","CEST","8496493200","7200","1");
INSERT INTO timezone VALUES("32","CET","8514637200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8527942800","7200","1");
INSERT INTO timezone VALUES("32","CET","8546086800","3600","0");
INSERT INTO timezone VALUES("32","CEST","8559392400","7200","1");
INSERT INTO timezone VALUES("32","CET","8578141200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8590842000","7200","1");
INSERT INTO timezone VALUES("32","CET","8609590800","3600","0");
INSERT INTO timezone VALUES("32","CEST","8622291600","7200","1");
INSERT INTO timezone VALUES("32","CET","8641040400","3600","0");
INSERT INTO timezone VALUES("32","CEST","8654346000","7200","1");
INSERT INTO timezone VALUES("32","CET","8672490000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8685795600","7200","1");
INSERT INTO timezone VALUES("32","CET","8703939600","3600","0");
INSERT INTO timezone VALUES("32","CEST","8717245200","7200","1");
INSERT INTO timezone VALUES("32","CET","8735389200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8748694800","7200","1");
INSERT INTO timezone VALUES("32","CET","8767443600","3600","0");
INSERT INTO timezone VALUES("32","CEST","8780144400","7200","1");
INSERT INTO timezone VALUES("32","CET","8798893200","3600","0");
INSERT INTO timezone VALUES("32","CEST","8811594000","7200","1");
INSERT INTO timezone VALUES("32","CET","8830342800","3600","0");
INSERT INTO timezone VALUES("32","CEST","8843648400","7200","1");
INSERT INTO timezone VALUES("32","CET","8861792400","3600","0");
INSERT INTO timezone VALUES("32","CEST","8875098000","7200","1");
INSERT INTO timezone VALUES("32","CET","8893242000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8906547600","7200","1");
INSERT INTO timezone VALUES("32","CET","8925296400","3600","0");
INSERT INTO timezone VALUES("32","CEST","8937997200","7200","1");
INSERT INTO timezone VALUES("32","CET","8956746000","3600","0");
INSERT INTO timezone VALUES("32","CEST","8969446800","7200","1");
INSERT INTO timezone VALUES("32","CET","8988195600","3600","0");
INSERT INTO timezone VALUES("32","CEST","9000896400","7200","1");
INSERT INTO timezone VALUES("32","CET","9019645200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9032950800","7200","1");
INSERT INTO timezone VALUES("32","CET","9051094800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9064400400","7200","1");
INSERT INTO timezone VALUES("32","CET","9082544400","3600","0");
INSERT INTO timezone VALUES("32","CEST","9095850000","7200","1");
INSERT INTO timezone VALUES("32","CET","9114598800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9127299600","7200","1");
INSERT INTO timezone VALUES("32","CET","9146048400","3600","0");
INSERT INTO timezone VALUES("32","CEST","9158749200","7200","1");
INSERT INTO timezone VALUES("32","CET","9177498000","3600","0");
INSERT INTO timezone VALUES("32","CEST","9190803600","7200","1");
INSERT INTO timezone VALUES("32","CET","9208947600","3600","0");
INSERT INTO timezone VALUES("32","CEST","9222253200","7200","1");
INSERT INTO timezone VALUES("32","CET","9240397200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9253702800","7200","1");
INSERT INTO timezone VALUES("32","CET","9271846800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9285152400","7200","1");
INSERT INTO timezone VALUES("32","CET","9303901200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9316602000","7200","1");
INSERT INTO timezone VALUES("32","CET","9335350800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9348051600","7200","1");
INSERT INTO timezone VALUES("32","CET","9366800400","3600","0");
INSERT INTO timezone VALUES("32","CEST","9380106000","7200","1");
INSERT INTO timezone VALUES("32","CET","9398250000","3600","0");
INSERT INTO timezone VALUES("32","CEST","9411555600","7200","1");
INSERT INTO timezone VALUES("32","CET","9429699600","3600","0");
INSERT INTO timezone VALUES("32","CEST","9443005200","7200","1");
INSERT INTO timezone VALUES("32","CET","9461754000","3600","0");
INSERT INTO timezone VALUES("32","CEST","9474454800","7200","1");
INSERT INTO timezone VALUES("32","CET","9493203600","3600","0");
INSERT INTO timezone VALUES("32","CEST","9505904400","7200","1");
INSERT INTO timezone VALUES("32","CET","9524653200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9537958800","7200","1");
INSERT INTO timezone VALUES("32","CET","9556102800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9569408400","7200","1");
INSERT INTO timezone VALUES("32","CET","9587552400","3600","0");
INSERT INTO timezone VALUES("32","CEST","9600858000","7200","1");
INSERT INTO timezone VALUES("32","CET","9619002000","3600","0");
INSERT INTO timezone VALUES("32","CEST","9632307600","7200","1");
INSERT INTO timezone VALUES("32","CET","9651056400","3600","0");
INSERT INTO timezone VALUES("32","CEST","9663757200","7200","1");
INSERT INTO timezone VALUES("32","CET","9682506000","3600","0");
INSERT INTO timezone VALUES("32","CEST","9695206800","7200","1");
INSERT INTO timezone VALUES("32","CET","9713955600","3600","0");
INSERT INTO timezone VALUES("32","CEST","9727261200","7200","1");
INSERT INTO timezone VALUES("32","CET","9745405200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9758710800","7200","1");
INSERT INTO timezone VALUES("32","CET","9776854800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9790160400","7200","1");
INSERT INTO timezone VALUES("32","CET","9808909200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9821610000","7200","1");
INSERT INTO timezone VALUES("32","CET","9840358800","3600","0");
INSERT INTO timezone VALUES("32","CEST","9853059600","7200","1");
INSERT INTO timezone VALUES("32","CET","9871808400","3600","0");
INSERT INTO timezone VALUES("32","CEST","9884509200","7200","1");
INSERT INTO timezone VALUES("32","CET","9903258000","3600","0");
INSERT INTO timezone VALUES("32","CEST","9916563600","7200","1");
INSERT INTO timezone VALUES("32","CET","9934707600","3600","0");
INSERT INTO timezone VALUES("32","CEST","9948013200","7200","1");
INSERT INTO timezone VALUES("32","CET","9966157200","3600","0");
INSERT INTO timezone VALUES("32","CEST","9979462800","7200","1");
INSERT INTO timezone VALUES("32","CET","9998211600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10010912400","7200","1");
INSERT INTO timezone VALUES("32","CET","10029661200","3600","0");
INSERT INTO timezone VALUES("32","CEST","10042362000","7200","1");
INSERT INTO timezone VALUES("32","CET","10061110800","3600","0");
INSERT INTO timezone VALUES("32","CEST","10074416400","7200","1");
INSERT INTO timezone VALUES("32","CET","10092560400","3600","0");
INSERT INTO timezone VALUES("32","CEST","10105866000","7200","1");
INSERT INTO timezone VALUES("32","CET","10124010000","3600","0");
INSERT INTO timezone VALUES("32","CEST","10137315600","7200","1");
INSERT INTO timezone VALUES("32","CET","10155459600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10168765200","7200","1");
INSERT INTO timezone VALUES("32","CET","10187514000","3600","0");
INSERT INTO timezone VALUES("32","CEST","10200214800","7200","1");
INSERT INTO timezone VALUES("32","CET","10218963600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10231664400","7200","1");
INSERT INTO timezone VALUES("32","CET","10250413200","3600","0");
INSERT INTO timezone VALUES("32","CEST","10263718800","7200","1");
INSERT INTO timezone VALUES("32","CET","10281862800","3600","0");
INSERT INTO timezone VALUES("32","CEST","10295168400","7200","1");
INSERT INTO timezone VALUES("32","CET","10313312400","3600","0");
INSERT INTO timezone VALUES("32","CEST","10326618000","7200","1");
INSERT INTO timezone VALUES("32","CET","10345366800","3600","0");
INSERT INTO timezone VALUES("32","CEST","10358067600","7200","1");
INSERT INTO timezone VALUES("32","CET","10376816400","3600","0");
INSERT INTO timezone VALUES("32","CEST","10389517200","7200","1");
INSERT INTO timezone VALUES("32","CET","10408266000","3600","0");
INSERT INTO timezone VALUES("32","CEST","10420966800","7200","1");
INSERT INTO timezone VALUES("32","CET","10439715600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10453021200","7200","1");
INSERT INTO timezone VALUES("32","CET","10471165200","3600","0");
INSERT INTO timezone VALUES("32","CEST","10484470800","7200","1");
INSERT INTO timezone VALUES("32","CET","10502614800","3600","0");
INSERT INTO timezone VALUES("32","CEST","10515920400","7200","1");
INSERT INTO timezone VALUES("32","CET","10534064400","3600","0");
INSERT INTO timezone VALUES("32","CEST","10547370000","7200","1");
INSERT INTO timezone VALUES("32","CET","10566118800","3600","0");
INSERT INTO timezone VALUES("32","CEST","10578819600","7200","1");
INSERT INTO timezone VALUES("32","CET","10597568400","3600","0");
INSERT INTO timezone VALUES("32","CEST","10610269200","7200","1");
INSERT INTO timezone VALUES("32","CET","10629018000","3600","0");
INSERT INTO timezone VALUES("32","CEST","10642323600","7200","1");
INSERT INTO timezone VALUES("32","CET","10660467600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10673773200","7200","1");
INSERT INTO timezone VALUES("32","CET","10691917200","3600","0");
INSERT INTO timezone VALUES("32","CEST","10705222800","7200","1");
INSERT INTO timezone VALUES("32","CET","10723971600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10736672400","7200","1");
INSERT INTO timezone VALUES("32","CET","10755421200","3600","0");
INSERT INTO timezone VALUES("32","CEST","10768122000","7200","1");
INSERT INTO timezone VALUES("32","CET","10786870800","3600","0");
INSERT INTO timezone VALUES("32","CEST","10800176400","7200","1");
INSERT INTO timezone VALUES("32","CET","10818320400","3600","0");
INSERT INTO timezone VALUES("32","CEST","10831626000","7200","1");
INSERT INTO timezone VALUES("32","CET","10849770000","3600","0");
INSERT INTO timezone VALUES("32","CEST","10863075600","7200","1");
INSERT INTO timezone VALUES("32","CET","10881219600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10894525200","7200","1");
INSERT INTO timezone VALUES("32","CET","10913274000","3600","0");
INSERT INTO timezone VALUES("32","CEST","10925974800","7200","1");
INSERT INTO timezone VALUES("32","CET","10944723600","3600","0");
INSERT INTO timezone VALUES("32","CEST","10957424400","7200","1");
INSERT INTO timezone VALUES("32","CET","10976173200","3600","0");
INSERT INTO timezone VALUES("32","CEST","10989478800","7200","1");
INSERT INTO timezone VALUES("32","CET","11007622800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11020928400","7200","1");
INSERT INTO timezone VALUES("32","CET","11039072400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11052378000","7200","1");
INSERT INTO timezone VALUES("32","CET","11071126800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11083827600","7200","1");
INSERT INTO timezone VALUES("32","CET","11102576400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11115277200","7200","1");
INSERT INTO timezone VALUES("32","CET","11134026000","3600","0");
INSERT INTO timezone VALUES("32","CEST","11146726800","7200","1");
INSERT INTO timezone VALUES("32","CET","11165475600","3600","0");
INSERT INTO timezone VALUES("32","CEST","11178781200","7200","1");
INSERT INTO timezone VALUES("32","CET","11196925200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11210230800","7200","1");
INSERT INTO timezone VALUES("32","CET","11228374800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11241680400","7200","1");
INSERT INTO timezone VALUES("32","CET","11260429200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11273130000","7200","1");
INSERT INTO timezone VALUES("32","CET","11291878800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11304579600","7200","1");
INSERT INTO timezone VALUES("32","CET","11323328400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11336634000","7200","1");
INSERT INTO timezone VALUES("32","CET","11354778000","3600","0");
INSERT INTO timezone VALUES("32","CEST","11368083600","7200","1");
INSERT INTO timezone VALUES("32","CET","11386227600","3600","0");
INSERT INTO timezone VALUES("32","CEST","11399533200","7200","1");
INSERT INTO timezone VALUES("32","CET","11417677200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11430982800","7200","1");
INSERT INTO timezone VALUES("32","CET","11449731600","3600","0");
INSERT INTO timezone VALUES("32","CEST","11462432400","7200","1");
INSERT INTO timezone VALUES("32","CET","11481181200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11493882000","7200","1");
INSERT INTO timezone VALUES("32","CET","11512630800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11525936400","7200","1");
INSERT INTO timezone VALUES("32","CET","11544080400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11557386000","7200","1");
INSERT INTO timezone VALUES("32","CET","11575530000","3600","0");
INSERT INTO timezone VALUES("32","CEST","11588835600","7200","1");
INSERT INTO timezone VALUES("32","CET","11607584400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11620285200","7200","1");
INSERT INTO timezone VALUES("32","CET","11639034000","3600","0");
INSERT INTO timezone VALUES("32","CEST","11651734800","7200","1");
INSERT INTO timezone VALUES("32","CET","11670483600","3600","0");
INSERT INTO timezone VALUES("32","CEST","11683789200","7200","1");
INSERT INTO timezone VALUES("32","CET","11701933200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11715238800","7200","1");
INSERT INTO timezone VALUES("32","CET","11733382800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11746688400","7200","1");
INSERT INTO timezone VALUES("32","CET","11764832400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11778138000","7200","1");
INSERT INTO timezone VALUES("32","CET","11796886800","3600","0");
INSERT INTO timezone VALUES("32","CEST","11809587600","7200","1");
INSERT INTO timezone VALUES("32","CET","11828336400","3600","0");
INSERT INTO timezone VALUES("32","CEST","11841037200","7200","1");
INSERT INTO timezone VALUES("32","CET","11859786000","3600","0");
INSERT INTO timezone VALUES("32","CEST","11873091600","7200","1");
INSERT INTO timezone VALUES("32","CET","11891235600","3600","0");
INSERT INTO timezone VALUES("32","CEST","11904541200","7200","1");
INSERT INTO timezone VALUES("32","CET","11922685200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11935990800","7200","1");
INSERT INTO timezone VALUES("32","CET","11954739600","3600","0");
INSERT INTO timezone VALUES("32","CEST","11967440400","7200","1");
INSERT INTO timezone VALUES("32","CET","11986189200","3600","0");
INSERT INTO timezone VALUES("32","CEST","11998890000","7200","1");
INSERT INTO timezone VALUES("32","CET","12017638800","3600","0");
INSERT INTO timezone VALUES("32","CEST","12030339600","7200","1");
INSERT INTO timezone VALUES("32","CET","12049088400","3600","0");
INSERT INTO timezone VALUES("32","CEST","12062394000","7200","1");
INSERT INTO timezone VALUES("32","CET","12080538000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12093843600","7200","1");
INSERT INTO timezone VALUES("32","CET","12111987600","3600","0");
INSERT INTO timezone VALUES("32","CEST","12125293200","7200","1");
INSERT INTO timezone VALUES("32","CET","12144042000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12156742800","7200","1");
INSERT INTO timezone VALUES("32","CET","12175491600","3600","0");
INSERT INTO timezone VALUES("32","CEST","12188192400","7200","1");
INSERT INTO timezone VALUES("32","CET","12206941200","3600","0");
INSERT INTO timezone VALUES("32","CEST","12220246800","7200","1");
INSERT INTO timezone VALUES("32","CET","12238390800","3600","0");
INSERT INTO timezone VALUES("32","CEST","12251696400","7200","1");
INSERT INTO timezone VALUES("32","CET","12269840400","3600","0");
INSERT INTO timezone VALUES("32","CEST","12283146000","7200","1");
INSERT INTO timezone VALUES("32","CET","12301290000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12314595600","7200","1");
INSERT INTO timezone VALUES("32","CET","12333344400","3600","0");
INSERT INTO timezone VALUES("32","CEST","12346045200","7200","1");
INSERT INTO timezone VALUES("32","CET","12364794000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12377494800","7200","1");
INSERT INTO timezone VALUES("32","CET","12396243600","3600","0");
INSERT INTO timezone VALUES("32","CEST","12409549200","7200","1");
INSERT INTO timezone VALUES("32","CET","12427693200","3600","0");
INSERT INTO timezone VALUES("32","CEST","12440998800","7200","1");
INSERT INTO timezone VALUES("32","CET","12459142800","3600","0");
INSERT INTO timezone VALUES("32","CEST","12472448400","7200","1");
INSERT INTO timezone VALUES("32","CET","12491197200","3600","0");
INSERT INTO timezone VALUES("32","CEST","12503898000","7200","1");
INSERT INTO timezone VALUES("32","CET","12522646800","3600","0");
INSERT INTO timezone VALUES("32","CEST","12535347600","7200","1");
INSERT INTO timezone VALUES("32","CET","12554096400","3600","0");
INSERT INTO timezone VALUES("32","CEST","12567402000","7200","1");
INSERT INTO timezone VALUES("32","CET","12585546000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12598851600","7200","1");
INSERT INTO timezone VALUES("32","CET","12616995600","3600","0");
INSERT INTO timezone VALUES("32","CEST","12630301200","7200","1");
INSERT INTO timezone VALUES("32","CET","12648445200","3600","0");
INSERT INTO timezone VALUES("32","CEST","12661750800","7200","1");
INSERT INTO timezone VALUES("32","CET","12680499600","3600","0");
INSERT INTO timezone VALUES("32","CEST","12693200400","7200","1");
INSERT INTO timezone VALUES("32","CET","12711949200","3600","0");
INSERT INTO timezone VALUES("32","CEST","12724650000","7200","1");
INSERT INTO timezone VALUES("32","CET","12743398800","3600","0");
INSERT INTO timezone VALUES("32","CEST","12756704400","7200","1");
INSERT INTO timezone VALUES("32","CET","12774848400","3600","0");
INSERT INTO timezone VALUES("32","CEST","12788154000","7200","1");
INSERT INTO timezone VALUES("32","CET","12806298000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12819603600","7200","1");
INSERT INTO timezone VALUES("32","CET","12838352400","3600","0");
INSERT INTO timezone VALUES("32","CEST","12851053200","7200","1");
INSERT INTO timezone VALUES("32","CET","12869802000","3600","0");
INSERT INTO timezone VALUES("32","CEST","12882502800","7200","1");
INSERT INTO timezone VALUES("32","CET","12901251600","3600","0");
INSERT INTO timezone VALUES("32","CEST","12913952400","7200","1");
INSERT INTO timezone VALUES("32","CET","12932701200","3600","0");
INSERT INTO timezone VALUES("32","CEST","12946006800","7200","1");
INSERT INTO timezone VALUES("32","CET","12964150800","3600","0");
INSERT INTO timezone VALUES("32","CEST","12977456400","7200","1");
INSERT INTO timezone VALUES("32","CET","12995600400","3600","0");
INSERT INTO timezone VALUES("32","CEST","13008906000","7200","1");
INSERT INTO timezone VALUES("32","CET","13027654800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13040355600","7200","1");
INSERT INTO timezone VALUES("32","CET","13059104400","3600","0");
INSERT INTO timezone VALUES("32","CEST","13071805200","7200","1");
INSERT INTO timezone VALUES("32","CET","13090554000","3600","0");
INSERT INTO timezone VALUES("32","CEST","13103859600","7200","1");
INSERT INTO timezone VALUES("32","CET","13122003600","3600","0");
INSERT INTO timezone VALUES("32","CEST","13135309200","7200","1");
INSERT INTO timezone VALUES("32","CET","13153453200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13166758800","7200","1");
INSERT INTO timezone VALUES("32","CET","13184902800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13198208400","7200","1");
INSERT INTO timezone VALUES("32","CET","13216957200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13229658000","7200","1");
INSERT INTO timezone VALUES("32","CET","13248406800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13261107600","7200","1");
INSERT INTO timezone VALUES("32","CET","13279856400","3600","0");
INSERT INTO timezone VALUES("32","CEST","13293162000","7200","1");
INSERT INTO timezone VALUES("32","CET","13311306000","3600","0");
INSERT INTO timezone VALUES("32","CEST","13324611600","7200","1");
INSERT INTO timezone VALUES("32","CET","13342755600","3600","0");
INSERT INTO timezone VALUES("32","CEST","13356061200","7200","1");
INSERT INTO timezone VALUES("32","CET","13374810000","3600","0");
INSERT INTO timezone VALUES("32","CEST","13387510800","7200","1");
INSERT INTO timezone VALUES("32","CET","13406259600","3600","0");
INSERT INTO timezone VALUES("32","CEST","13418960400","7200","1");
INSERT INTO timezone VALUES("32","CET","13437709200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13451014800","7200","1");
INSERT INTO timezone VALUES("32","CET","13469158800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13482464400","7200","1");
INSERT INTO timezone VALUES("32","CET","13500608400","3600","0");
INSERT INTO timezone VALUES("32","CEST","13513914000","7200","1");
INSERT INTO timezone VALUES("32","CET","13532058000","3600","0");
INSERT INTO timezone VALUES("32","CEST","13545363600","7200","1");
INSERT INTO timezone VALUES("32","CET","13564112400","3600","0");
INSERT INTO timezone VALUES("32","CEST","13576813200","7200","1");
INSERT INTO timezone VALUES("32","CET","13595562000","3600","0");
INSERT INTO timezone VALUES("32","CEST","13608262800","7200","1");
INSERT INTO timezone VALUES("32","CET","13627011600","3600","0");
INSERT INTO timezone VALUES("32","CEST","13640317200","7200","1");
INSERT INTO timezone VALUES("32","CET","13658461200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13671766800","7200","1");
INSERT INTO timezone VALUES("32","CET","13689910800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13703216400","7200","1");
INSERT INTO timezone VALUES("32","CET","13721965200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13734666000","7200","1");
INSERT INTO timezone VALUES("32","CET","13753414800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13766115600","7200","1");
INSERT INTO timezone VALUES("32","CET","13784864400","3600","0");
INSERT INTO timezone VALUES("32","CEST","13797565200","7200","1");
INSERT INTO timezone VALUES("32","CET","13816314000","3600","0");
INSERT INTO timezone VALUES("32","CEST","13829619600","7200","1");
INSERT INTO timezone VALUES("32","CET","13847763600","3600","0");
INSERT INTO timezone VALUES("32","CEST","13861069200","7200","1");
INSERT INTO timezone VALUES("32","CET","13879213200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13892518800","7200","1");
INSERT INTO timezone VALUES("32","CET","13911267600","3600","0");
INSERT INTO timezone VALUES("32","CEST","13923968400","7200","1");
INSERT INTO timezone VALUES("32","CET","13942717200","3600","0");
INSERT INTO timezone VALUES("32","CEST","13955418000","7200","1");
INSERT INTO timezone VALUES("32","CET","13974166800","3600","0");
INSERT INTO timezone VALUES("32","CEST","13987472400","7200","1");
INSERT INTO timezone VALUES("32","CET","14005616400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14018922000","7200","1");
INSERT INTO timezone VALUES("32","CET","14037066000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14050371600","7200","1");
INSERT INTO timezone VALUES("32","CET","14068515600","3600","0");
INSERT INTO timezone VALUES("32","CEST","14081821200","7200","1");
INSERT INTO timezone VALUES("32","CET","14100570000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14113270800","7200","1");
INSERT INTO timezone VALUES("32","CET","14132019600","3600","0");
INSERT INTO timezone VALUES("32","CEST","14144720400","7200","1");
INSERT INTO timezone VALUES("32","CET","14163469200","3600","0");
INSERT INTO timezone VALUES("32","CEST","14176774800","7200","1");
INSERT INTO timezone VALUES("32","CET","14194918800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14208224400","7200","1");
INSERT INTO timezone VALUES("32","CET","14226368400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14239674000","7200","1");
INSERT INTO timezone VALUES("32","CET","14258422800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14271123600","7200","1");
INSERT INTO timezone VALUES("32","CET","14289872400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14302573200","7200","1");
INSERT INTO timezone VALUES("32","CET","14321322000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14334627600","7200","1");
INSERT INTO timezone VALUES("32","CET","14352771600","3600","0");
INSERT INTO timezone VALUES("32","CEST","14366077200","7200","1");
INSERT INTO timezone VALUES("32","CET","14384221200","3600","0");
INSERT INTO timezone VALUES("32","CEST","14397526800","7200","1");
INSERT INTO timezone VALUES("32","CET","14415670800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14428976400","7200","1");
INSERT INTO timezone VALUES("32","CET","14447725200","3600","0");
INSERT INTO timezone VALUES("32","CEST","14460426000","7200","1");
INSERT INTO timezone VALUES("32","CET","14479174800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14491875600","7200","1");
INSERT INTO timezone VALUES("32","CET","14510624400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14523930000","7200","1");
INSERT INTO timezone VALUES("32","CET","14542074000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14555379600","7200","1");
INSERT INTO timezone VALUES("32","CET","14573523600","3600","0");
INSERT INTO timezone VALUES("32","CEST","14586829200","7200","1");
INSERT INTO timezone VALUES("32","CET","14605578000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14618278800","7200","1");
INSERT INTO timezone VALUES("32","CET","14637027600","3600","0");
INSERT INTO timezone VALUES("32","CEST","14649728400","7200","1");
INSERT INTO timezone VALUES("32","CET","14668477200","3600","0");
INSERT INTO timezone VALUES("32","CEST","14681178000","7200","1");
INSERT INTO timezone VALUES("32","CET","14699926800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14713232400","7200","1");
INSERT INTO timezone VALUES("32","CET","14731376400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14744682000","7200","1");
INSERT INTO timezone VALUES("32","CET","14762826000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14776131600","7200","1");
INSERT INTO timezone VALUES("32","CET","14794880400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14807581200","7200","1");
INSERT INTO timezone VALUES("32","CET","14826330000","3600","0");
INSERT INTO timezone VALUES("32","CEST","14839030800","7200","1");
INSERT INTO timezone VALUES("32","CET","14857779600","3600","0");
INSERT INTO timezone VALUES("32","CEST","14871085200","7200","1");
INSERT INTO timezone VALUES("32","CET","14889229200","3600","0");
INSERT INTO timezone VALUES("32","CEST","14902534800","7200","1");
INSERT INTO timezone VALUES("32","CET","14920678800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14933984400","7200","1");
INSERT INTO timezone VALUES("32","CET","14952128400","3600","0");
INSERT INTO timezone VALUES("32","CEST","14965434000","7200","1");
INSERT INTO timezone VALUES("32","CET","14984182800","3600","0");
INSERT INTO timezone VALUES("32","CEST","14996883600","7200","1");
INSERT INTO timezone VALUES("32","CET","15015632400","3600","0");
INSERT INTO timezone VALUES("32","CEST","15028333200","7200","1");
INSERT INTO timezone VALUES("32","CET","15047082000","3600","0");
INSERT INTO timezone VALUES("32","CEST","15060387600","7200","1");
INSERT INTO timezone VALUES("32","CET","15078531600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15091837200","7200","1");
INSERT INTO timezone VALUES("32","CET","15109981200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15123286800","7200","1");
INSERT INTO timezone VALUES("32","CET","15142035600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15154736400","7200","1");
INSERT INTO timezone VALUES("32","CET","15173485200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15186186000","7200","1");
INSERT INTO timezone VALUES("32","CET","15204934800","3600","0");
INSERT INTO timezone VALUES("32","CEST","15218240400","7200","1");
INSERT INTO timezone VALUES("32","CET","15236384400","3600","0");
INSERT INTO timezone VALUES("32","CEST","15249690000","7200","1");
INSERT INTO timezone VALUES("32","CET","15267834000","3600","0");
INSERT INTO timezone VALUES("32","CEST","15281139600","7200","1");
INSERT INTO timezone VALUES("32","CET","15299283600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15312589200","7200","1");
INSERT INTO timezone VALUES("32","CET","15331338000","3600","0");
INSERT INTO timezone VALUES("32","CEST","15344038800","7200","1");
INSERT INTO timezone VALUES("32","CET","15362787600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15375488400","7200","1");
INSERT INTO timezone VALUES("32","CET","15394237200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15407542800","7200","1");
INSERT INTO timezone VALUES("32","CET","15425686800","3600","0");
INSERT INTO timezone VALUES("32","CEST","15438992400","7200","1");
INSERT INTO timezone VALUES("32","CET","15457136400","3600","0");
INSERT INTO timezone VALUES("32","CEST","15470442000","7200","1");
INSERT INTO timezone VALUES("32","CET","15489190800","3600","0");
INSERT INTO timezone VALUES("32","CEST","15501891600","7200","1");
INSERT INTO timezone VALUES("32","CET","15520640400","3600","0");
INSERT INTO timezone VALUES("32","CEST","15533341200","7200","1");
INSERT INTO timezone VALUES("32","CET","15552090000","3600","0");
INSERT INTO timezone VALUES("32","CEST","15564790800","7200","1");
INSERT INTO timezone VALUES("32","CET","15583539600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15596845200","7200","1");
INSERT INTO timezone VALUES("32","CET","15614989200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15628294800","7200","1");
INSERT INTO timezone VALUES("32","CET","15646438800","3600","0");
INSERT INTO timezone VALUES("32","CEST","15659744400","7200","1");
INSERT INTO timezone VALUES("32","CET","15678493200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15691194000","7200","1");
INSERT INTO timezone VALUES("32","CET","15709942800","3600","0");
INSERT INTO timezone VALUES("32","CEST","15722643600","7200","1");
INSERT INTO timezone VALUES("32","CET","15741392400","3600","0");
INSERT INTO timezone VALUES("32","CEST","15754698000","7200","1");
INSERT INTO timezone VALUES("32","CET","15772842000","3600","0");
INSERT INTO timezone VALUES("32","CEST","15786147600","7200","1");
INSERT INTO timezone VALUES("32","CET","15804291600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15817597200","7200","1");
INSERT INTO timezone VALUES("32","CET","15835741200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15849046800","7200","1");
INSERT INTO timezone VALUES("32","CET","15867795600","3600","0");
INSERT INTO timezone VALUES("32","CEST","15880496400","7200","1");
INSERT INTO timezone VALUES("32","CET","15899245200","3600","0");
INSERT INTO timezone VALUES("32","CEST","15911946000","7200","1");
INSERT INTO timezone VALUES("32","CET","15930694800","3600","0");
INSERT INTO timezone VALUES("32","CEST","15944000400","7200","1");
INSERT INTO timezone VALUES("32","CET","15962144400","3600","0");
INSERT INTO timezone VALUES("32","CEST","15975450000","7200","1");
INSERT INTO timezone VALUES("32","CET","15993594000","3600","0");
INSERT INTO timezone VALUES("32","CEST","16006899600","7200","1");
INSERT INTO timezone VALUES("32","CET","16025648400","3600","0");
INSERT INTO timezone VALUES("32","CEST","16038349200","7200","1");
INSERT INTO timezone VALUES("32","CET","16057098000","3600","0");
INSERT INTO timezone VALUES("32","CEST","16069798800","7200","1");
INSERT INTO timezone VALUES("32","CET","16088547600","3600","0");
INSERT INTO timezone VALUES("32","CEST","16101853200","7200","1");
INSERT INTO timezone VALUES("32","CET","16119997200","3600","0");
INSERT INTO timezone VALUES("32","CEST","16133302800","7200","1");
INSERT INTO timezone VALUES("32","CET","16151446800","3600","0");
INSERT INTO timezone VALUES("32","CEST","16164752400","7200","1");
INSERT INTO timezone VALUES("32","CET","16182896400","3600","0");
INSERT INTO timezone VALUES("32","CEST","16196202000","7200","1");
INSERT INTO timezone VALUES("32","CET","16214950800","3600","0");
INSERT INTO timezone VALUES("32","CEST","16227651600","7200","1");
INSERT INTO timezone VALUES("32","CET","16246400400","3600","0");
INSERT INTO timezone VALUES("32","CEST","16259101200","7200","1");
INSERT INTO timezone VALUES("32","CET","16277850000","3600","0");
INSERT INTO timezone VALUES("32","CEST","16291155600","7200","1");
INSERT INTO timezone VALUES("32","CET","16309299600","3600","0");
INSERT INTO timezone VALUES("32","CEST","16322605200","7200","1");
INSERT INTO timezone VALUES("32","CET","16340749200","3600","0");
INSERT INTO timezone VALUES("32","CEST","16354054800","7200","1");
INSERT INTO timezone VALUES("32","CET","16372803600","3600","0");
INSERT INTO timezone VALUES("32","CEST","16385504400","7200","1");
INSERT INTO timezone VALUES("32","CET","16404253200","3600","0");
INSERT INTO timezone VALUES("32","CEST","16416954000","7200","1");
INSERT INTO timezone VALUES("32","CET","16435702800","3600","0");
INSERT INTO timezone VALUES("32","CEST","16448403600","7200","1");
INSERT INTO timezone VALUES("32","CET","16467152400","3600","0");
INSERT INTO timezone VALUES("32","CEST","16480458000","7200","1");
INSERT INTO timezone VALUES("32","CET","16498602000","3600","0");
INSERT INTO timezone VALUES("32","CEST","16511907600","7200","1");
INSERT INTO timezone VALUES("32","CET","16530051600","3600","0");
INSERT INTO timezone VALUES("32","CEST","16543357200","7200","1");
INSERT INTO timezone VALUES("32","CET","16562106000","3600","0");
INSERT INTO timezone VALUES("32","CEST","16574806800","7200","1");
INSERT INTO timezone VALUES("32","CET","16593555600","3600","0");
INSERT INTO timezone VALUES("32","CEST","16606256400","7200","1");
INSERT INTO timezone VALUES("32","CET","16625005200","3600","0");
INSERT INTO timezone VALUES("32","CEST","16638310800","7200","1");
INSERT INTO timezone VALUES("32","CET","16656454800","3600","0");
INSERT INTO timezone VALUES("32","CEST","16669760400","7200","1");
INSERT INTO timezone VALUES("32","CET","16687904400","3600","0");
INSERT INTO timezone VALUES("32","CEST","16701210000","7200","1");
INSERT INTO timezone VALUES("32","CET","16719354000","3600","0");
INSERT INTO timezone VALUES("33","LMT","-2364114981","38180","0");
INSERT INTO timezone VALUES("33","AEST","-2364114980","36000","0");
INSERT INTO timezone VALUES("33","+1030","352216800","37800","0");
INSERT INTO timezone VALUES("33","+1130","372785400","41400","1");
INSERT INTO timezone VALUES("33","+1030","384273000","37800","0");
INSERT INTO timezone VALUES("33","+1130","404839800","41400","1");
INSERT INTO timezone VALUES("33","+1030","415722600","37800","0");
INSERT INTO timezone VALUES("33","+1130","436289400","41400","1");
INSERT INTO timezone VALUES("33","+1030","447172200","37800","0");
INSERT INTO timezone VALUES("33","+1130","467739000","41400","1");
INSERT INTO timezone VALUES("33","+1030","478621800","37800","0");
INSERT INTO timezone VALUES("33","+11","499188600","39600","1");
INSERT INTO timezone VALUES("33","+1030","511282800","37800","0");
INSERT INTO timezone VALUES("33","+11","530033400","39600","1");
INSERT INTO timezone VALUES("33","+1030","542732400","37800","0");
INSERT INTO timezone VALUES("33","+11","562087800","39600","1");
INSERT INTO timezone VALUES("33","+1030","574786800","37800","0");
INSERT INTO timezone VALUES("33","+11","594142200","39600","1");
INSERT INTO timezone VALUES("33","+1030","606236400","37800","0");
INSERT INTO timezone VALUES("33","+11","625591800","39600","1");
INSERT INTO timezone VALUES("33","+1030","636476400","37800","0");
INSERT INTO timezone VALUES("33","+11","657041400","39600","1");
INSERT INTO timezone VALUES("33","+1030","667926000","37800","0");
INSERT INTO timezone VALUES("33","+11","688491000","39600","1");
INSERT INTO timezone VALUES("33","+1030","699375600","37800","0");
INSERT INTO timezone VALUES("33","+11","719940600","39600","1");
INSERT INTO timezone VALUES("33","+1030","731430000","37800","0");
INSERT INTO timezone VALUES("33","+11","751995000","39600","1");
INSERT INTO timezone VALUES("33","+1030","762879600","37800","0");
INSERT INTO timezone VALUES("33","+11","783444600","39600","1");
INSERT INTO timezone VALUES("33","+1030","794329200","37800","0");
INSERT INTO timezone VALUES("33","+11","814894200","39600","1");
INSERT INTO timezone VALUES("33","+1030","828198000","37800","0");
INSERT INTO timezone VALUES("33","+11","846343800","39600","1");
INSERT INTO timezone VALUES("33","+1030","859647600","37800","0");
INSERT INTO timezone VALUES("33","+11","877793400","39600","1");
INSERT INTO timezone VALUES("33","+1030","891097200","37800","0");
INSERT INTO timezone VALUES("33","+11","909243000","39600","1");
INSERT INTO timezone VALUES("33","+1030","922546800","37800","0");
INSERT INTO timezone VALUES("33","+11","941297400","39600","1");
INSERT INTO timezone VALUES("33","+1030","953996400","37800","0");
INSERT INTO timezone VALUES("33","+11","967303800","39600","1");
INSERT INTO timezone VALUES("33","+1030","985446000","37800","0");
INSERT INTO timezone VALUES("33","+11","1004196600","39600","1");
INSERT INTO timezone VALUES("33","+1030","1017500400","37800","0");
INSERT INTO timezone VALUES("33","+11","1035646200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1048950000","37800","0");
INSERT INTO timezone VALUES("33","+11","1067095800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1080399600","37800","0");
INSERT INTO timezone VALUES("33","+11","1099150200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1111849200","37800","0");
INSERT INTO timezone VALUES("33","+11","1130599800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1143903600","37800","0");
INSERT INTO timezone VALUES("33","+11","1162049400","39600","1");
INSERT INTO timezone VALUES("33","+1030","1174748400","37800","0");
INSERT INTO timezone VALUES("33","+11","1193499000","39600","1");
INSERT INTO timezone VALUES("33","+1030","1207407600","37800","0");
INSERT INTO timezone VALUES("33","+11","1223134200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1238857200","37800","0");
INSERT INTO timezone VALUES("33","+11","1254583800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1270306800","37800","0");
INSERT INTO timezone VALUES("33","+11","1286033400","39600","1");
INSERT INTO timezone VALUES("33","+1030","1301756400","37800","0");
INSERT INTO timezone VALUES("33","+11","1317483000","39600","1");
INSERT INTO timezone VALUES("33","+1030","1333206000","37800","0");
INSERT INTO timezone VALUES("33","+11","1349537400","39600","1");
INSERT INTO timezone VALUES("33","+1030","1365260400","37800","0");
INSERT INTO timezone VALUES("33","+11","1380987000","39600","1");
INSERT INTO timezone VALUES("33","+1030","1396710000","37800","0");
INSERT INTO timezone VALUES("33","+11","1412436600","39600","1");
INSERT INTO timezone VALUES("33","+1030","1428159600","37800","0");
INSERT INTO timezone VALUES("33","+11","1443886200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1459609200","37800","0");
INSERT INTO timezone VALUES("33","+11","1475335800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1491058800","37800","0");
INSERT INTO timezone VALUES("33","+11","1506785400","39600","1");
INSERT INTO timezone VALUES("33","+1030","1522508400","37800","0");
INSERT INTO timezone VALUES("33","+11","1538839800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1554562800","37800","0");
INSERT INTO timezone VALUES("33","+11","1570289400","39600","1");
INSERT INTO timezone VALUES("33","+1030","1586012400","37800","0");
INSERT INTO timezone VALUES("33","+11","1601739000","39600","1");
INSERT INTO timezone VALUES("33","+1030","1617462000","37800","0");
INSERT INTO timezone VALUES("33","+11","1633188600","39600","1");
INSERT INTO timezone VALUES("33","+1030","1648911600","37800","0");
INSERT INTO timezone VALUES("33","+11","1664638200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1680361200","37800","0");
INSERT INTO timezone VALUES("33","+11","1696087800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1712415600","37800","0");
INSERT INTO timezone VALUES("33","+11","1728142200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1743865200","37800","0");
INSERT INTO timezone VALUES("33","+11","1759591800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1775314800","37800","0");
INSERT INTO timezone VALUES("33","+11","1791041400","39600","1");
INSERT INTO timezone VALUES("33","+1030","1806764400","37800","0");
INSERT INTO timezone VALUES("33","+11","1822491000","39600","1");
INSERT INTO timezone VALUES("33","+1030","1838214000","37800","0");
INSERT INTO timezone VALUES("33","+11","1853940600","39600","1");
INSERT INTO timezone VALUES("33","+1030","1869663600","37800","0");
INSERT INTO timezone VALUES("33","+11","1885995000","39600","1");
INSERT INTO timezone VALUES("33","+1030","1901718000","37800","0");
INSERT INTO timezone VALUES("33","+11","1917444600","39600","1");
INSERT INTO timezone VALUES("33","+1030","1933167600","37800","0");
INSERT INTO timezone VALUES("33","+11","1948894200","39600","1");
INSERT INTO timezone VALUES("33","+1030","1964617200","37800","0");
INSERT INTO timezone VALUES("33","+11","1980343800","39600","1");
INSERT INTO timezone VALUES("33","+1030","1996066800","37800","0");
INSERT INTO timezone VALUES("33","+11","2011793400","39600","1");
INSERT INTO timezone VALUES("33","+1030","2027516400","37800","0");
INSERT INTO timezone VALUES("33","+11","2043243000","39600","1");
INSERT INTO timezone VALUES("33","+1030","2058966000","37800","0");
INSERT INTO timezone VALUES("33","+11","2075297400","39600","1");
INSERT INTO timezone VALUES("33","+1030","2091020400","37800","0");
INSERT INTO timezone VALUES("33","+11","2106747000","39600","1");
INSERT INTO timezone VALUES("33","+1030","2122470000","37800","0");
INSERT INTO timezone VALUES("33","+11","2138196600","39600","1");
INSERT INTO timezone VALUES("33","+1030","2153919600","37800","0");
INSERT INTO timezone VALUES("33","+11","2169646200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2185369200","37800","0");
INSERT INTO timezone VALUES("33","+11","2201095800","39600","1");
INSERT INTO timezone VALUES("33","+1030","2216818800","37800","0");
INSERT INTO timezone VALUES("33","+11","2233150200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2248873200","37800","0");
INSERT INTO timezone VALUES("33","+11","2264599800","39600","1");
INSERT INTO timezone VALUES("33","+1030","2280322800","37800","0");
INSERT INTO timezone VALUES("33","+11","2296049400","39600","1");
INSERT INTO timezone VALUES("33","+1030","2311772400","37800","0");
INSERT INTO timezone VALUES("33","+11","2327499000","39600","1");
INSERT INTO timezone VALUES("33","+1030","2343222000","37800","0");
INSERT INTO timezone VALUES("33","+11","2358948600","39600","1");
INSERT INTO timezone VALUES("33","+1030","2374671600","37800","0");
INSERT INTO timezone VALUES("33","+11","2390398200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2406121200","37800","0");
INSERT INTO timezone VALUES("33","+11","2422452600","39600","1");
INSERT INTO timezone VALUES("33","+1030","2438175600","37800","0");
INSERT INTO timezone VALUES("33","+11","2453902200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2469625200","37800","0");
INSERT INTO timezone VALUES("33","+11","2485351800","39600","1");
INSERT INTO timezone VALUES("33","+1030","2501074800","37800","0");
INSERT INTO timezone VALUES("33","+11","2516801400","39600","1");
INSERT INTO timezone VALUES("33","+1030","2532524400","37800","0");
INSERT INTO timezone VALUES("33","+11","2548251000","39600","1");
INSERT INTO timezone VALUES("33","+1030","2563974000","37800","0");
INSERT INTO timezone VALUES("33","+11","2579700600","39600","1");
INSERT INTO timezone VALUES("33","+1030","2596028400","37800","0");
INSERT INTO timezone VALUES("33","+11","2611755000","39600","1");
INSERT INTO timezone VALUES("33","+1030","2627478000","37800","0");
INSERT INTO timezone VALUES("33","+11","2643204600","39600","1");
INSERT INTO timezone VALUES("33","+1030","2658927600","37800","0");
INSERT INTO timezone VALUES("33","+11","2674654200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2690377200","37800","0");
INSERT INTO timezone VALUES("33","+11","2706103800","39600","1");
INSERT INTO timezone VALUES("33","+1030","2721826800","37800","0");
INSERT INTO timezone VALUES("33","+11","2737553400","39600","1");
INSERT INTO timezone VALUES("33","+1030","2753276400","37800","0");
INSERT INTO timezone VALUES("33","+11","2769607800","39600","1");
INSERT INTO timezone VALUES("33","+1030","2785330800","37800","0");
INSERT INTO timezone VALUES("33","+11","2801057400","39600","1");
INSERT INTO timezone VALUES("33","+1030","2816780400","37800","0");
INSERT INTO timezone VALUES("33","+11","2832507000","39600","1");
INSERT INTO timezone VALUES("33","+1030","2848230000","37800","0");
INSERT INTO timezone VALUES("33","+11","2863956600","39600","1");
INSERT INTO timezone VALUES("33","+1030","2879679600","37800","0");
INSERT INTO timezone VALUES("33","+11","2895406200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2911129200","37800","0");
INSERT INTO timezone VALUES("33","+11","2926855800","39600","1");
INSERT INTO timezone VALUES("33","+1030","2942578800","37800","0");
INSERT INTO timezone VALUES("33","+11","2958910200","39600","1");
INSERT INTO timezone VALUES("33","+1030","2974633200","37800","0");
INSERT INTO timezone VALUES("33","+11","2990359800","39600","1");
INSERT INTO timezone VALUES("33","+1030","3006082800","37800","0");
INSERT INTO timezone VALUES("33","+11","3021809400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3037532400","37800","0");
INSERT INTO timezone VALUES("33","+11","3053259000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3068982000","37800","0");
INSERT INTO timezone VALUES("33","+11","3084708600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3100431600","37800","0");
INSERT INTO timezone VALUES("33","+11","3116763000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3132486000","37800","0");
INSERT INTO timezone VALUES("33","+11","3148212600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3163935600","37800","0");
INSERT INTO timezone VALUES("33","+11","3179662200","39600","1");
INSERT INTO timezone VALUES("33","+1030","3195385200","37800","0");
INSERT INTO timezone VALUES("33","+11","3211111800","39600","1");
INSERT INTO timezone VALUES("33","+1030","3226834800","37800","0");
INSERT INTO timezone VALUES("33","+11","3242561400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3258284400","37800","0");
INSERT INTO timezone VALUES("33","+11","3274011000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3289734000","37800","0");
INSERT INTO timezone VALUES("33","+11","3306065400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3321788400","37800","0");
INSERT INTO timezone VALUES("33","+11","3337515000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3353238000","37800","0");
INSERT INTO timezone VALUES("33","+11","3368964600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3384687600","37800","0");
INSERT INTO timezone VALUES("33","+11","3400414200","39600","1");
INSERT INTO timezone VALUES("33","+1030","3416137200","37800","0");
INSERT INTO timezone VALUES("33","+11","3431863800","39600","1");
INSERT INTO timezone VALUES("33","+1030","3447586800","37800","0");
INSERT INTO timezone VALUES("33","+11","3463313400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3479641200","37800","0");
INSERT INTO timezone VALUES("33","+11","3495367800","39600","1");
INSERT INTO timezone VALUES("33","+1030","3511090800","37800","0");
INSERT INTO timezone VALUES("33","+11","3526817400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3542540400","37800","0");
INSERT INTO timezone VALUES("33","+11","3558267000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3573990000","37800","0");
INSERT INTO timezone VALUES("33","+11","3589716600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3605439600","37800","0");
INSERT INTO timezone VALUES("33","+11","3621166200","39600","1");
INSERT INTO timezone VALUES("33","+1030","3636889200","37800","0");
INSERT INTO timezone VALUES("33","+11","3653220600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3668943600","37800","0");
INSERT INTO timezone VALUES("33","+11","3684670200","39600","1");
INSERT INTO timezone VALUES("33","+1030","3700393200","37800","0");
INSERT INTO timezone VALUES("33","+11","3716119800","39600","1");
INSERT INTO timezone VALUES("33","+1030","3731842800","37800","0");
INSERT INTO timezone VALUES("33","+11","3747569400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3763292400","37800","0");
INSERT INTO timezone VALUES("33","+11","3779019000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3794742000","37800","0");
INSERT INTO timezone VALUES("33","+11","3810468600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3826191600","37800","0");
INSERT INTO timezone VALUES("33","+11","3842523000","39600","1");
INSERT INTO timezone VALUES("33","+1030","3858246000","37800","0");
INSERT INTO timezone VALUES("33","+11","3873972600","39600","1");
INSERT INTO timezone VALUES("33","+1030","3889695600","37800","0");
INSERT INTO timezone VALUES("33","+11","3905422200","39600","1");
INSERT INTO timezone VALUES("33","+1030","3921145200","37800","0");
INSERT INTO timezone VALUES("33","+11","3936871800","39600","1");
INSERT INTO timezone VALUES("33","+1030","3952594800","37800","0");
INSERT INTO timezone VALUES("33","+11","3968321400","39600","1");
INSERT INTO timezone VALUES("33","+1030","3984044400","37800","0");
INSERT INTO timezone VALUES("33","+11","4000375800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4016098800","37800","0");
INSERT INTO timezone VALUES("33","+11","4031825400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4047548400","37800","0");
INSERT INTO timezone VALUES("33","+11","4063275000","39600","1");
INSERT INTO timezone VALUES("33","+1030","4078998000","37800","0");
INSERT INTO timezone VALUES("33","+11","4094724600","39600","1");
INSERT INTO timezone VALUES("33","+1030","4110447600","37800","0");
INSERT INTO timezone VALUES("33","+11","4126174200","39600","1");
INSERT INTO timezone VALUES("33","+1030","4141897200","37800","0");
INSERT INTO timezone VALUES("33","+11","4157623800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4173346800","37800","0");
INSERT INTO timezone VALUES("33","+11","4189073400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4204796400","37800","0");
INSERT INTO timezone VALUES("33","+11","4221127800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4236850800","37800","0");
INSERT INTO timezone VALUES("33","+11","4252577400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4268300400","37800","0");
INSERT INTO timezone VALUES("33","+11","4284027000","39600","1");
INSERT INTO timezone VALUES("33","+1030","4299750000","37800","0");
INSERT INTO timezone VALUES("33","+11","4315476600","39600","1");
INSERT INTO timezone VALUES("33","+1030","4331199600","37800","0");
INSERT INTO timezone VALUES("33","+11","4346926200","39600","1");
INSERT INTO timezone VALUES("33","+1030","4362649200","37800","0");
INSERT INTO timezone VALUES("33","+11","4378980600","39600","1");
INSERT INTO timezone VALUES("33","+1030","4394703600","37800","0");
INSERT INTO timezone VALUES("33","+11","4410430200","39600","1");
INSERT INTO timezone VALUES("33","+1030","4426153200","37800","0");
INSERT INTO timezone VALUES("33","+11","4441879800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4457602800","37800","0");
INSERT INTO timezone VALUES("33","+11","4473329400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4489052400","37800","0");
INSERT INTO timezone VALUES("33","+11","4504779000","39600","1");
INSERT INTO timezone VALUES("33","+1030","4520502000","37800","0");
INSERT INTO timezone VALUES("33","+11","4536228600","39600","1");
INSERT INTO timezone VALUES("33","+1030","4551951600","37800","0");
INSERT INTO timezone VALUES("33","+11","4568283000","39600","1");
INSERT INTO timezone VALUES("33","+1030","4584006000","37800","0");
INSERT INTO timezone VALUES("33","+11","4599732600","39600","1");
INSERT INTO timezone VALUES("33","+1030","4615455600","37800","0");
INSERT INTO timezone VALUES("33","+11","4631182200","39600","1");
INSERT INTO timezone VALUES("33","+1030","4646905200","37800","0");
INSERT INTO timezone VALUES("33","+11","4662631800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4678354800","37800","0");
INSERT INTO timezone VALUES("33","+11","4694081400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4709804400","37800","0");
INSERT INTO timezone VALUES("33","+11","4725531000","39600","1");
INSERT INTO timezone VALUES("33","+1030","4741858800","37800","0");
INSERT INTO timezone VALUES("33","+11","4757585400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4773308400","37800","0");
INSERT INTO timezone VALUES("33","+11","4789035000","39600","1");
INSERT INTO timezone VALUES("33","+1030","4804758000","37800","0");
INSERT INTO timezone VALUES("33","+11","4820484600","39600","1");
INSERT INTO timezone VALUES("33","+1030","4836207600","37800","0");
INSERT INTO timezone VALUES("33","+11","4851934200","39600","1");
INSERT INTO timezone VALUES("33","+1030","4867657200","37800","0");
INSERT INTO timezone VALUES("33","+11","4883383800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4899106800","37800","0");
INSERT INTO timezone VALUES("33","+11","4915438200","39600","1");
INSERT INTO timezone VALUES("33","+1030","4931161200","37800","0");
INSERT INTO timezone VALUES("33","+11","4946887800","39600","1");
INSERT INTO timezone VALUES("33","+1030","4962610800","37800","0");
INSERT INTO timezone VALUES("33","+11","4978337400","39600","1");
INSERT INTO timezone VALUES("33","+1030","4994060400","37800","0");
INSERT INTO timezone VALUES("33","+11","5009787000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5025510000","37800","0");
INSERT INTO timezone VALUES("33","+11","5041236600","39600","1");
INSERT INTO timezone VALUES("33","+1030","5056959600","37800","0");
INSERT INTO timezone VALUES("33","+11","5072686200","39600","1");
INSERT INTO timezone VALUES("33","+1030","5088409200","37800","0");
INSERT INTO timezone VALUES("33","+11","5104740600","39600","1");
INSERT INTO timezone VALUES("33","+1030","5120463600","37800","0");
INSERT INTO timezone VALUES("33","+11","5136190200","39600","1");
INSERT INTO timezone VALUES("33","+1030","5151913200","37800","0");
INSERT INTO timezone VALUES("33","+11","5167639800","39600","1");
INSERT INTO timezone VALUES("33","+1030","5183362800","37800","0");
INSERT INTO timezone VALUES("33","+11","5199089400","39600","1");
INSERT INTO timezone VALUES("33","+1030","5214812400","37800","0");
INSERT INTO timezone VALUES("33","+11","5230539000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5246262000","37800","0");
INSERT INTO timezone VALUES("33","+11","5262593400","39600","1");
INSERT INTO timezone VALUES("33","+1030","5278316400","37800","0");
INSERT INTO timezone VALUES("33","+11","5294043000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5309766000","37800","0");
INSERT INTO timezone VALUES("33","+11","5325492600","39600","1");
INSERT INTO timezone VALUES("33","+1030","5341215600","37800","0");
INSERT INTO timezone VALUES("33","+11","5356942200","39600","1");
INSERT INTO timezone VALUES("33","+1030","5372665200","37800","0");
INSERT INTO timezone VALUES("33","+11","5388391800","39600","1");
INSERT INTO timezone VALUES("33","+1030","5404114800","37800","0");
INSERT INTO timezone VALUES("33","+11","5419841400","39600","1");
INSERT INTO timezone VALUES("33","+1030","5435564400","37800","0");
INSERT INTO timezone VALUES("33","+11","5451895800","39600","1");
INSERT INTO timezone VALUES("33","+1030","5467618800","37800","0");
INSERT INTO timezone VALUES("33","+11","5483345400","39600","1");
INSERT INTO timezone VALUES("33","+1030","5499068400","37800","0");
INSERT INTO timezone VALUES("33","+11","5514795000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5530518000","37800","0");
INSERT INTO timezone VALUES("33","+11","5546244600","39600","1");
INSERT INTO timezone VALUES("33","+1030","5561967600","37800","0");
INSERT INTO timezone VALUES("33","+11","5577694200","39600","1");
INSERT INTO timezone VALUES("33","+1030","5593417200","37800","0");
INSERT INTO timezone VALUES("33","+11","5609143800","39600","1");
INSERT INTO timezone VALUES("33","+1030","5625471600","37800","0");
INSERT INTO timezone VALUES("33","+11","5641198200","39600","1");
INSERT INTO timezone VALUES("33","+1030","5656921200","37800","0");
INSERT INTO timezone VALUES("33","+11","5672647800","39600","1");
INSERT INTO timezone VALUES("33","+1030","5688370800","37800","0");
INSERT INTO timezone VALUES("33","+11","5704097400","39600","1");
INSERT INTO timezone VALUES("33","+1030","5719820400","37800","0");
INSERT INTO timezone VALUES("33","+11","5735547000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5751270000","37800","0");
INSERT INTO timezone VALUES("33","+11","5766996600","39600","1");
INSERT INTO timezone VALUES("33","+1030","5782719600","37800","0");
INSERT INTO timezone VALUES("33","+11","5799051000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5814774000","37800","0");
INSERT INTO timezone VALUES("33","+11","5830500600","39600","1");
INSERT INTO timezone VALUES("33","+1030","5846223600","37800","0");
INSERT INTO timezone VALUES("33","+11","5861950200","39600","1");
INSERT INTO timezone VALUES("33","+1030","5877673200","37800","0");
INSERT INTO timezone VALUES("33","+11","5893399800","39600","1");
INSERT INTO timezone VALUES("33","+1030","5909122800","37800","0");
INSERT INTO timezone VALUES("33","+11","5924849400","39600","1");
INSERT INTO timezone VALUES("33","+1030","5940572400","37800","0");
INSERT INTO timezone VALUES("33","+11","5956299000","39600","1");
INSERT INTO timezone VALUES("33","+1030","5972022000","37800","0");
INSERT INTO timezone VALUES("33","+11","5988353400","39600","1");
INSERT INTO timezone VALUES("33","+1030","6004076400","37800","0");
INSERT INTO timezone VALUES("33","+11","6019803000","39600","1");
INSERT INTO timezone VALUES("33","+1030","6035526000","37800","0");
INSERT INTO timezone VALUES("33","+11","6051252600","39600","1");
INSERT INTO timezone VALUES("33","+1030","6066975600","37800","0");
INSERT INTO timezone VALUES("33","+11","6082702200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6098425200","37800","0");
INSERT INTO timezone VALUES("33","+11","6114151800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6129874800","37800","0");
INSERT INTO timezone VALUES("33","+11","6146206200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6161929200","37800","0");
INSERT INTO timezone VALUES("33","+11","6177655800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6193378800","37800","0");
INSERT INTO timezone VALUES("33","+11","6209105400","39600","1");
INSERT INTO timezone VALUES("33","+1030","6224828400","37800","0");
INSERT INTO timezone VALUES("33","+11","6240555000","39600","1");
INSERT INTO timezone VALUES("33","+1030","6256278000","37800","0");
INSERT INTO timezone VALUES("33","+11","6272004600","39600","1");
INSERT INTO timezone VALUES("33","+1030","6287727600","37800","0");
INSERT INTO timezone VALUES("33","+11","6303454200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6319177200","37800","0");
INSERT INTO timezone VALUES("33","+11","6335508600","39600","1");
INSERT INTO timezone VALUES("33","+1030","6351231600","37800","0");
INSERT INTO timezone VALUES("33","+11","6366958200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6382681200","37800","0");
INSERT INTO timezone VALUES("33","+11","6398407800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6414130800","37800","0");
INSERT INTO timezone VALUES("33","+11","6429857400","39600","1");
INSERT INTO timezone VALUES("33","+1030","6445580400","37800","0");
INSERT INTO timezone VALUES("33","+11","6461307000","39600","1");
INSERT INTO timezone VALUES("33","+1030","6477030000","37800","0");
INSERT INTO timezone VALUES("33","+11","6492756600","39600","1");
INSERT INTO timezone VALUES("33","+1030","6509084400","37800","0");
INSERT INTO timezone VALUES("33","+11","6524811000","39600","1");
INSERT INTO timezone VALUES("33","+1030","6540534000","37800","0");
INSERT INTO timezone VALUES("33","+11","6556260600","39600","1");
INSERT INTO timezone VALUES("33","+1030","6571983600","37800","0");
INSERT INTO timezone VALUES("33","+11","6587710200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6603433200","37800","0");
INSERT INTO timezone VALUES("33","+11","6619159800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6634882800","37800","0");
INSERT INTO timezone VALUES("33","+11","6650609400","39600","1");
INSERT INTO timezone VALUES("33","+1030","6666332400","37800","0");
INSERT INTO timezone VALUES("33","+11","6682663800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6698386800","37800","0");
INSERT INTO timezone VALUES("33","+11","6714113400","39600","1");
INSERT INTO timezone VALUES("33","+1030","6729836400","37800","0");
INSERT INTO timezone VALUES("33","+11","6745563000","39600","1");
INSERT INTO timezone VALUES("33","+1030","6761286000","37800","0");
INSERT INTO timezone VALUES("33","+11","6777012600","39600","1");
INSERT INTO timezone VALUES("33","+1030","6792735600","37800","0");
INSERT INTO timezone VALUES("33","+11","6808462200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6824185200","37800","0");
INSERT INTO timezone VALUES("33","+11","6839911800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6855634800","37800","0");
INSERT INTO timezone VALUES("33","+11","6871966200","39600","1");
INSERT INTO timezone VALUES("33","+1030","6887689200","37800","0");
INSERT INTO timezone VALUES("33","+11","6903415800","39600","1");
INSERT INTO timezone VALUES("33","+1030","6919138800","37800","0");
INSERT INTO timezone VALUES("33","+11","6934865400","39600","1");
INSERT INTO timezone VALUES("33","+1030","6950588400","37800","0");
INSERT INTO timezone VALUES("33","+11","6966315000","39600","1");
INSERT INTO timezone VALUES("33","+1030","6982038000","37800","0");
INSERT INTO timezone VALUES("33","+11","6997764600","39600","1");
INSERT INTO timezone VALUES("33","+1030","7013487600","37800","0");
INSERT INTO timezone VALUES("33","+11","7029819000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7045542000","37800","0");
INSERT INTO timezone VALUES("33","+11","7061268600","39600","1");
INSERT INTO timezone VALUES("33","+1030","7076991600","37800","0");
INSERT INTO timezone VALUES("33","+11","7092718200","39600","1");
INSERT INTO timezone VALUES("33","+1030","7108441200","37800","0");
INSERT INTO timezone VALUES("33","+11","7124167800","39600","1");
INSERT INTO timezone VALUES("33","+1030","7139890800","37800","0");
INSERT INTO timezone VALUES("33","+11","7155617400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7171340400","37800","0");
INSERT INTO timezone VALUES("33","+11","7187067000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7202790000","37800","0");
INSERT INTO timezone VALUES("33","+11","7219121400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7234844400","37800","0");
INSERT INTO timezone VALUES("33","+11","7250571000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7266294000","37800","0");
INSERT INTO timezone VALUES("33","+11","7282020600","39600","1");
INSERT INTO timezone VALUES("33","+1030","7297743600","37800","0");
INSERT INTO timezone VALUES("33","+11","7313470200","39600","1");
INSERT INTO timezone VALUES("33","+1030","7329193200","37800","0");
INSERT INTO timezone VALUES("33","+11","7344919800","39600","1");
INSERT INTO timezone VALUES("33","+1030","7360642800","37800","0");
INSERT INTO timezone VALUES("33","+11","7376369400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7392092400","37800","0");
INSERT INTO timezone VALUES("33","+11","7408423800","39600","1");
INSERT INTO timezone VALUES("33","+1030","7424146800","37800","0");
INSERT INTO timezone VALUES("33","+11","7439873400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7455596400","37800","0");
INSERT INTO timezone VALUES("33","+11","7471323000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7487046000","37800","0");
INSERT INTO timezone VALUES("33","+11","7502772600","39600","1");
INSERT INTO timezone VALUES("33","+1030","7518495600","37800","0");
INSERT INTO timezone VALUES("33","+11","7534222200","39600","1");
INSERT INTO timezone VALUES("33","+1030","7549945200","37800","0");
INSERT INTO timezone VALUES("33","+11","7565671800","39600","1");
INSERT INTO timezone VALUES("33","+1030","7581394800","37800","0");
INSERT INTO timezone VALUES("33","+11","7597726200","39600","1");
INSERT INTO timezone VALUES("33","+1030","7613449200","37800","0");
INSERT INTO timezone VALUES("33","+11","7629175800","39600","1");
INSERT INTO timezone VALUES("33","+1030","7644898800","37800","0");
INSERT INTO timezone VALUES("33","+11","7660625400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7676348400","37800","0");
INSERT INTO timezone VALUES("33","+11","7692075000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7707798000","37800","0");
INSERT INTO timezone VALUES("33","+11","7723524600","39600","1");
INSERT INTO timezone VALUES("33","+1030","7739247600","37800","0");
INSERT INTO timezone VALUES("33","+11","7754974200","39600","1");
INSERT INTO timezone VALUES("33","+1030","7771302000","37800","0");
INSERT INTO timezone VALUES("33","+11","7787028600","39600","1");
INSERT INTO timezone VALUES("33","+1030","7802751600","37800","0");
INSERT INTO timezone VALUES("33","+11","7818478200","39600","1");
INSERT INTO timezone VALUES("33","+1030","7834201200","37800","0");
INSERT INTO timezone VALUES("33","+11","7849927800","39600","1");
INSERT INTO timezone VALUES("33","+1030","7865650800","37800","0");
INSERT INTO timezone VALUES("33","+11","7881377400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7897100400","37800","0");
INSERT INTO timezone VALUES("33","+11","7912827000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7928550000","37800","0");
INSERT INTO timezone VALUES("33","+11","7944881400","39600","1");
INSERT INTO timezone VALUES("33","+1030","7960604400","37800","0");
INSERT INTO timezone VALUES("33","+11","7976331000","39600","1");
INSERT INTO timezone VALUES("33","+1030","7992054000","37800","0");
INSERT INTO timezone VALUES("33","+11","8007780600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8023503600","37800","0");
INSERT INTO timezone VALUES("33","+11","8039230200","39600","1");
INSERT INTO timezone VALUES("33","+1030","8054953200","37800","0");
INSERT INTO timezone VALUES("33","+11","8070679800","39600","1");
INSERT INTO timezone VALUES("33","+1030","8086402800","37800","0");
INSERT INTO timezone VALUES("33","+11","8102129400","39600","1");
INSERT INTO timezone VALUES("33","+1030","8117852400","37800","0");
INSERT INTO timezone VALUES("33","+11","8134183800","39600","1");
INSERT INTO timezone VALUES("33","+1030","8149906800","37800","0");
INSERT INTO timezone VALUES("33","+11","8165633400","39600","1");
INSERT INTO timezone VALUES("33","+1030","8181356400","37800","0");
INSERT INTO timezone VALUES("33","+11","8197083000","39600","1");
INSERT INTO timezone VALUES("33","+1030","8212806000","37800","0");
INSERT INTO timezone VALUES("33","+11","8228532600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8244255600","37800","0");
INSERT INTO timezone VALUES("33","+11","8259982200","39600","1");
INSERT INTO timezone VALUES("33","+1030","8275705200","37800","0");
INSERT INTO timezone VALUES("33","+11","8292036600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8307759600","37800","0");
INSERT INTO timezone VALUES("33","+11","8323486200","39600","1");
INSERT INTO timezone VALUES("33","+1030","8339209200","37800","0");
INSERT INTO timezone VALUES("33","+11","8354935800","39600","1");
INSERT INTO timezone VALUES("33","+1030","8370658800","37800","0");
INSERT INTO timezone VALUES("33","+11","8386385400","39600","1");
INSERT INTO timezone VALUES("33","+1030","8402108400","37800","0");
INSERT INTO timezone VALUES("33","+11","8417835000","39600","1");
INSERT INTO timezone VALUES("33","+1030","8433558000","37800","0");
INSERT INTO timezone VALUES("33","+11","8449284600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8465007600","37800","0");
INSERT INTO timezone VALUES("33","+11","8481339000","39600","1");
INSERT INTO timezone VALUES("33","+1030","8497062000","37800","0");
INSERT INTO timezone VALUES("33","+11","8512788600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8528511600","37800","0");
INSERT INTO timezone VALUES("33","+11","8544238200","39600","1");
INSERT INTO timezone VALUES("33","+1030","8559961200","37800","0");
INSERT INTO timezone VALUES("33","+11","8575687800","39600","1");
INSERT INTO timezone VALUES("33","+1030","8591410800","37800","0");
INSERT INTO timezone VALUES("33","+11","8607137400","39600","1");
INSERT INTO timezone VALUES("33","+1030","8622860400","37800","0");
INSERT INTO timezone VALUES("33","+11","8638587000","39600","1");
INSERT INTO timezone VALUES("33","+1030","8654914800","37800","0");
INSERT INTO timezone VALUES("33","+11","8670641400","39600","1");
INSERT INTO timezone VALUES("33","+1030","8686364400","37800","0");
INSERT INTO timezone VALUES("33","+11","8702091000","39600","1");
INSERT INTO timezone VALUES("33","+1030","8717814000","37800","0");
INSERT INTO timezone VALUES("33","+11","8733540600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8749263600","37800","0");
INSERT INTO timezone VALUES("33","+11","8764990200","39600","1");
INSERT INTO timezone VALUES("33","+1030","8780713200","37800","0");
INSERT INTO timezone VALUES("33","+11","8796439800","39600","1");
INSERT INTO timezone VALUES("33","+1030","8812162800","37800","0");
INSERT INTO timezone VALUES("33","+11","8828494200","39600","1");
INSERT INTO timezone VALUES("33","+1030","8844217200","37800","0");
INSERT INTO timezone VALUES("33","+11","8859943800","39600","1");
INSERT INTO timezone VALUES("33","+1030","8875666800","37800","0");
INSERT INTO timezone VALUES("33","+11","8891393400","39600","1");
INSERT INTO timezone VALUES("33","+1030","8907116400","37800","0");
INSERT INTO timezone VALUES("33","+11","8922843000","39600","1");
INSERT INTO timezone VALUES("33","+1030","8938566000","37800","0");
INSERT INTO timezone VALUES("33","+11","8954292600","39600","1");
INSERT INTO timezone VALUES("33","+1030","8970015600","37800","0");
INSERT INTO timezone VALUES("33","+11","8985742200","39600","1");
INSERT INTO timezone VALUES("33","+1030","9001465200","37800","0");
INSERT INTO timezone VALUES("33","+11","9017796600","39600","1");
INSERT INTO timezone VALUES("33","+1030","9033519600","37800","0");
INSERT INTO timezone VALUES("33","+11","9049246200","39600","1");
INSERT INTO timezone VALUES("33","+1030","9064969200","37800","0");
INSERT INTO timezone VALUES("33","+11","9080695800","39600","1");
INSERT INTO timezone VALUES("33","+1030","9096418800","37800","0");
INSERT INTO timezone VALUES("33","+11","9112145400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9127868400","37800","0");
INSERT INTO timezone VALUES("33","+11","9143595000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9159318000","37800","0");
INSERT INTO timezone VALUES("33","+11","9175649400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9191372400","37800","0");
INSERT INTO timezone VALUES("33","+11","9207099000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9222822000","37800","0");
INSERT INTO timezone VALUES("33","+11","9238548600","39600","1");
INSERT INTO timezone VALUES("33","+1030","9254271600","37800","0");
INSERT INTO timezone VALUES("33","+11","9269998200","39600","1");
INSERT INTO timezone VALUES("33","+1030","9285721200","37800","0");
INSERT INTO timezone VALUES("33","+11","9301447800","39600","1");
INSERT INTO timezone VALUES("33","+1030","9317170800","37800","0");
INSERT INTO timezone VALUES("33","+11","9332897400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9348620400","37800","0");
INSERT INTO timezone VALUES("33","+11","9364951800","39600","1");
INSERT INTO timezone VALUES("33","+1030","9380674800","37800","0");
INSERT INTO timezone VALUES("33","+11","9396401400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9412124400","37800","0");
INSERT INTO timezone VALUES("33","+11","9427851000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9443574000","37800","0");
INSERT INTO timezone VALUES("33","+11","9459300600","39600","1");
INSERT INTO timezone VALUES("33","+1030","9475023600","37800","0");
INSERT INTO timezone VALUES("33","+11","9490750200","39600","1");
INSERT INTO timezone VALUES("33","+1030","9506473200","37800","0");
INSERT INTO timezone VALUES("33","+11","9522199800","39600","1");
INSERT INTO timezone VALUES("33","+1030","9538527600","37800","0");
INSERT INTO timezone VALUES("33","+11","9554254200","39600","1");
INSERT INTO timezone VALUES("33","+1030","9569977200","37800","0");
INSERT INTO timezone VALUES("33","+11","9585703800","39600","1");
INSERT INTO timezone VALUES("33","+1030","9601426800","37800","0");
INSERT INTO timezone VALUES("33","+11","9617153400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9632876400","37800","0");
INSERT INTO timezone VALUES("33","+11","9648603000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9664326000","37800","0");
INSERT INTO timezone VALUES("33","+11","9680052600","39600","1");
INSERT INTO timezone VALUES("33","+1030","9695775600","37800","0");
INSERT INTO timezone VALUES("33","+11","9712107000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9727830000","37800","0");
INSERT INTO timezone VALUES("33","+11","9743556600","39600","1");
INSERT INTO timezone VALUES("33","+1030","9759279600","37800","0");
INSERT INTO timezone VALUES("33","+11","9775006200","39600","1");
INSERT INTO timezone VALUES("33","+1030","9790729200","37800","0");
INSERT INTO timezone VALUES("33","+11","9806455800","39600","1");
INSERT INTO timezone VALUES("33","+1030","9822178800","37800","0");
INSERT INTO timezone VALUES("33","+11","9837905400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9853628400","37800","0");
INSERT INTO timezone VALUES("33","+11","9869355000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9885078000","37800","0");
INSERT INTO timezone VALUES("33","+11","9901409400","39600","1");
INSERT INTO timezone VALUES("33","+1030","9917132400","37800","0");
INSERT INTO timezone VALUES("33","+11","9932859000","39600","1");
INSERT INTO timezone VALUES("33","+1030","9948582000","37800","0");
INSERT INTO timezone VALUES("33","+11","9964308600","39600","1");
INSERT INTO timezone VALUES("33","+1030","9980031600","37800","0");
INSERT INTO timezone VALUES("33","+11","9995758200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10011481200","37800","0");
INSERT INTO timezone VALUES("33","+11","10027207800","39600","1");
INSERT INTO timezone VALUES("33","+1030","10042930800","37800","0");
INSERT INTO timezone VALUES("33","+11","10059262200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10074985200","37800","0");
INSERT INTO timezone VALUES("33","+11","10090711800","39600","1");
INSERT INTO timezone VALUES("33","+1030","10106434800","37800","0");
INSERT INTO timezone VALUES("33","+11","10122161400","39600","1");
INSERT INTO timezone VALUES("33","+1030","10137884400","37800","0");
INSERT INTO timezone VALUES("33","+11","10153611000","39600","1");
INSERT INTO timezone VALUES("33","+1030","10169334000","37800","0");
INSERT INTO timezone VALUES("33","+11","10185060600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10200783600","37800","0");
INSERT INTO timezone VALUES("33","+11","10216510200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10232233200","37800","0");
INSERT INTO timezone VALUES("33","+11","10248564600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10264287600","37800","0");
INSERT INTO timezone VALUES("33","+11","10280014200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10295737200","37800","0");
INSERT INTO timezone VALUES("33","+11","10311463800","39600","1");
INSERT INTO timezone VALUES("33","+1030","10327186800","37800","0");
INSERT INTO timezone VALUES("33","+11","10342913400","39600","1");
INSERT INTO timezone VALUES("33","+1030","10358636400","37800","0");
INSERT INTO timezone VALUES("33","+11","10374363000","39600","1");
INSERT INTO timezone VALUES("33","+1030","10390086000","37800","0");
INSERT INTO timezone VALUES("33","+11","10405812600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10421535600","37800","0");
INSERT INTO timezone VALUES("33","+11","10437867000","39600","1");
INSERT INTO timezone VALUES("33","+1030","10453590000","37800","0");
INSERT INTO timezone VALUES("33","+11","10469316600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10485039600","37800","0");
INSERT INTO timezone VALUES("33","+11","10500766200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10516489200","37800","0");
INSERT INTO timezone VALUES("33","+11","10532215800","39600","1");
INSERT INTO timezone VALUES("33","+1030","10547938800","37800","0");
INSERT INTO timezone VALUES("33","+11","10563665400","39600","1");
INSERT INTO timezone VALUES("33","+1030","10579388400","37800","0");
INSERT INTO timezone VALUES("33","+11","10595115000","39600","1");
INSERT INTO timezone VALUES("33","+1030","10610838000","37800","0");
INSERT INTO timezone VALUES("33","+11","10627169400","39600","1");
INSERT INTO timezone VALUES("33","+1030","10642892400","37800","0");
INSERT INTO timezone VALUES("33","+11","10658619000","39600","1");
INSERT INTO timezone VALUES("33","+1030","10674342000","37800","0");
INSERT INTO timezone VALUES("33","+11","10690068600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10705791600","37800","0");
INSERT INTO timezone VALUES("33","+11","10721518200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10737241200","37800","0");
INSERT INTO timezone VALUES("33","+11","10752967800","39600","1");
INSERT INTO timezone VALUES("33","+1030","10768690800","37800","0");
INSERT INTO timezone VALUES("33","+11","10784417400","39600","1");
INSERT INTO timezone VALUES("33","+1030","10800745200","37800","0");
INSERT INTO timezone VALUES("33","+11","10816471800","39600","1");
INSERT INTO timezone VALUES("33","+1030","10832194800","37800","0");
INSERT INTO timezone VALUES("33","+11","10847921400","39600","1");
INSERT INTO timezone VALUES("33","+1030","10863644400","37800","0");
INSERT INTO timezone VALUES("33","+11","10879371000","39600","1");
INSERT INTO timezone VALUES("33","+1030","10895094000","37800","0");
INSERT INTO timezone VALUES("33","+11","10910820600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10926543600","37800","0");
INSERT INTO timezone VALUES("33","+11","10942270200","39600","1");
INSERT INTO timezone VALUES("33","+1030","10957993200","37800","0");
INSERT INTO timezone VALUES("33","+11","10974324600","39600","1");
INSERT INTO timezone VALUES("33","+1030","10990047600","37800","0");
INSERT INTO timezone VALUES("33","+11","11005774200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11021497200","37800","0");
INSERT INTO timezone VALUES("33","+11","11037223800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11052946800","37800","0");
INSERT INTO timezone VALUES("33","+11","11068673400","39600","1");
INSERT INTO timezone VALUES("33","+1030","11084396400","37800","0");
INSERT INTO timezone VALUES("33","+11","11100123000","39600","1");
INSERT INTO timezone VALUES("33","+1030","11115846000","37800","0");
INSERT INTO timezone VALUES("33","+11","11131572600","39600","1");
INSERT INTO timezone VALUES("33","+1030","11147295600","37800","0");
INSERT INTO timezone VALUES("33","+11","11163627000","39600","1");
INSERT INTO timezone VALUES("33","+1030","11179350000","37800","0");
INSERT INTO timezone VALUES("33","+11","11195076600","39600","1");
INSERT INTO timezone VALUES("33","+1030","11210799600","37800","0");
INSERT INTO timezone VALUES("33","+11","11226526200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11242249200","37800","0");
INSERT INTO timezone VALUES("33","+11","11257975800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11273698800","37800","0");
INSERT INTO timezone VALUES("33","+11","11289425400","39600","1");
INSERT INTO timezone VALUES("33","+1030","11305148400","37800","0");
INSERT INTO timezone VALUES("33","+11","11321479800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11337202800","37800","0");
INSERT INTO timezone VALUES("33","+11","11352929400","39600","1");
INSERT INTO timezone VALUES("33","+1030","11368652400","37800","0");
INSERT INTO timezone VALUES("33","+11","11384379000","39600","1");
INSERT INTO timezone VALUES("33","+1030","11400102000","37800","0");
INSERT INTO timezone VALUES("33","+11","11415828600","39600","1");
INSERT INTO timezone VALUES("33","+1030","11431551600","37800","0");
INSERT INTO timezone VALUES("33","+11","11447278200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11463001200","37800","0");
INSERT INTO timezone VALUES("33","+11","11478727800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11494450800","37800","0");
INSERT INTO timezone VALUES("33","+11","11510782200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11526505200","37800","0");
INSERT INTO timezone VALUES("33","+11","11542231800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11557954800","37800","0");
INSERT INTO timezone VALUES("33","+11","11573681400","39600","1");
INSERT INTO timezone VALUES("33","+1030","11589404400","37800","0");
INSERT INTO timezone VALUES("33","+11","11605131000","39600","1");
INSERT INTO timezone VALUES("33","+1030","11620854000","37800","0");
INSERT INTO timezone VALUES("33","+11","11636580600","39600","1");
INSERT INTO timezone VALUES("33","+1030","11652303600","37800","0");
INSERT INTO timezone VALUES("33","+11","11668030200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11684358000","37800","0");
INSERT INTO timezone VALUES("33","+11","11700084600","39600","1");
INSERT INTO timezone VALUES("33","+1030","11715807600","37800","0");
INSERT INTO timezone VALUES("33","+11","11731534200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11747257200","37800","0");
INSERT INTO timezone VALUES("33","+11","11762983800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11778706800","37800","0");
INSERT INTO timezone VALUES("33","+11","11794433400","39600","1");
INSERT INTO timezone VALUES("33","+1030","11810156400","37800","0");
INSERT INTO timezone VALUES("33","+11","11825883000","39600","1");
INSERT INTO timezone VALUES("33","+1030","11841606000","37800","0");
INSERT INTO timezone VALUES("33","+11","11857937400","39600","1");
INSERT INTO timezone VALUES("33","+1030","11873660400","37800","0");
INSERT INTO timezone VALUES("33","+11","11889387000","39600","1");
INSERT INTO timezone VALUES("33","+1030","11905110000","37800","0");
INSERT INTO timezone VALUES("33","+11","11920836600","39600","1");
INSERT INTO timezone VALUES("33","+1030","11936559600","37800","0");
INSERT INTO timezone VALUES("33","+11","11952286200","39600","1");
INSERT INTO timezone VALUES("33","+1030","11968009200","37800","0");
INSERT INTO timezone VALUES("33","+11","11983735800","39600","1");
INSERT INTO timezone VALUES("33","+1030","11999458800","37800","0");
INSERT INTO timezone VALUES("33","+11","12015185400","39600","1");
INSERT INTO timezone VALUES("33","+1030","12030908400","37800","0");
INSERT INTO timezone VALUES("33","+11","12047239800","39600","1");
INSERT INTO timezone VALUES("33","+1030","12062962800","37800","0");
INSERT INTO timezone VALUES("33","+11","12078689400","39600","1");
INSERT INTO timezone VALUES("33","+1030","12094412400","37800","0");
INSERT INTO timezone VALUES("33","+11","12110139000","39600","1");
INSERT INTO timezone VALUES("33","+1030","12125862000","37800","0");
INSERT INTO timezone VALUES("33","+11","12141588600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12157311600","37800","0");
INSERT INTO timezone VALUES("33","+11","12173038200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12188761200","37800","0");
INSERT INTO timezone VALUES("33","+11","12205092600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12220815600","37800","0");
INSERT INTO timezone VALUES("33","+11","12236542200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12252265200","37800","0");
INSERT INTO timezone VALUES("33","+11","12267991800","39600","1");
INSERT INTO timezone VALUES("33","+1030","12283714800","37800","0");
INSERT INTO timezone VALUES("33","+11","12299441400","39600","1");
INSERT INTO timezone VALUES("33","+1030","12315164400","37800","0");
INSERT INTO timezone VALUES("33","+11","12330891000","39600","1");
INSERT INTO timezone VALUES("33","+1030","12346614000","37800","0");
INSERT INTO timezone VALUES("33","+11","12362340600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12378063600","37800","0");
INSERT INTO timezone VALUES("33","+11","12394395000","39600","1");
INSERT INTO timezone VALUES("33","+1030","12410118000","37800","0");
INSERT INTO timezone VALUES("33","+11","12425844600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12441567600","37800","0");
INSERT INTO timezone VALUES("33","+11","12457294200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12473017200","37800","0");
INSERT INTO timezone VALUES("33","+11","12488743800","39600","1");
INSERT INTO timezone VALUES("33","+1030","12504466800","37800","0");
INSERT INTO timezone VALUES("33","+11","12520193400","39600","1");
INSERT INTO timezone VALUES("33","+1030","12535916400","37800","0");
INSERT INTO timezone VALUES("33","+11","12551643000","39600","1");
INSERT INTO timezone VALUES("33","+1030","12567970800","37800","0");
INSERT INTO timezone VALUES("33","+11","12583697400","39600","1");
INSERT INTO timezone VALUES("33","+1030","12599420400","37800","0");
INSERT INTO timezone VALUES("33","+11","12615147000","39600","1");
INSERT INTO timezone VALUES("33","+1030","12630870000","37800","0");
INSERT INTO timezone VALUES("33","+11","12646596600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12662319600","37800","0");
INSERT INTO timezone VALUES("33","+11","12678046200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12693769200","37800","0");
INSERT INTO timezone VALUES("33","+11","12709495800","39600","1");
INSERT INTO timezone VALUES("33","+1030","12725218800","37800","0");
INSERT INTO timezone VALUES("33","+11","12741550200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12757273200","37800","0");
INSERT INTO timezone VALUES("33","+11","12772999800","39600","1");
INSERT INTO timezone VALUES("33","+1030","12788722800","37800","0");
INSERT INTO timezone VALUES("33","+11","12804449400","39600","1");
INSERT INTO timezone VALUES("33","+1030","12820172400","37800","0");
INSERT INTO timezone VALUES("33","+11","12835899000","39600","1");
INSERT INTO timezone VALUES("33","+1030","12851622000","37800","0");
INSERT INTO timezone VALUES("33","+11","12867348600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12883071600","37800","0");
INSERT INTO timezone VALUES("33","+11","12898798200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12914521200","37800","0");
INSERT INTO timezone VALUES("33","+11","12930852600","39600","1");
INSERT INTO timezone VALUES("33","+1030","12946575600","37800","0");
INSERT INTO timezone VALUES("33","+11","12962302200","39600","1");
INSERT INTO timezone VALUES("33","+1030","12978025200","37800","0");
INSERT INTO timezone VALUES("33","+11","12993751800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13009474800","37800","0");
INSERT INTO timezone VALUES("33","+11","13025201400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13040924400","37800","0");
INSERT INTO timezone VALUES("33","+11","13056651000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13072374000","37800","0");
INSERT INTO timezone VALUES("33","+11","13088705400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13104428400","37800","0");
INSERT INTO timezone VALUES("33","+11","13120155000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13135878000","37800","0");
INSERT INTO timezone VALUES("33","+11","13151604600","39600","1");
INSERT INTO timezone VALUES("33","+1030","13167327600","37800","0");
INSERT INTO timezone VALUES("33","+11","13183054200","39600","1");
INSERT INTO timezone VALUES("33","+1030","13198777200","37800","0");
INSERT INTO timezone VALUES("33","+11","13214503800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13230226800","37800","0");
INSERT INTO timezone VALUES("33","+11","13245953400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13261676400","37800","0");
INSERT INTO timezone VALUES("33","+11","13278007800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13293730800","37800","0");
INSERT INTO timezone VALUES("33","+11","13309457400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13325180400","37800","0");
INSERT INTO timezone VALUES("33","+11","13340907000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13356630000","37800","0");
INSERT INTO timezone VALUES("33","+11","13372356600","39600","1");
INSERT INTO timezone VALUES("33","+1030","13388079600","37800","0");
INSERT INTO timezone VALUES("33","+11","13403806200","39600","1");
INSERT INTO timezone VALUES("33","+1030","13419529200","37800","0");
INSERT INTO timezone VALUES("33","+11","13435255800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13451583600","37800","0");
INSERT INTO timezone VALUES("33","+11","13467310200","39600","1");
INSERT INTO timezone VALUES("33","+1030","13483033200","37800","0");
INSERT INTO timezone VALUES("33","+11","13498759800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13514482800","37800","0");
INSERT INTO timezone VALUES("33","+11","13530209400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13545932400","37800","0");
INSERT INTO timezone VALUES("33","+11","13561659000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13577382000","37800","0");
INSERT INTO timezone VALUES("33","+11","13593108600","39600","1");
INSERT INTO timezone VALUES("33","+1030","13608831600","37800","0");
INSERT INTO timezone VALUES("33","+11","13625163000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13640886000","37800","0");
INSERT INTO timezone VALUES("33","+11","13656612600","39600","1");
INSERT INTO timezone VALUES("33","+1030","13672335600","37800","0");
INSERT INTO timezone VALUES("33","+11","13688062200","39600","1");
INSERT INTO timezone VALUES("33","+1030","13703785200","37800","0");
INSERT INTO timezone VALUES("33","+11","13719511800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13735234800","37800","0");
INSERT INTO timezone VALUES("33","+11","13750961400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13766684400","37800","0");
INSERT INTO timezone VALUES("33","+11","13782411000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13798134000","37800","0");
INSERT INTO timezone VALUES("33","+11","13814465400","39600","1");
INSERT INTO timezone VALUES("33","+1030","13830188400","37800","0");
INSERT INTO timezone VALUES("33","+11","13845915000","39600","1");
INSERT INTO timezone VALUES("33","+1030","13861638000","37800","0");
INSERT INTO timezone VALUES("33","+11","13877364600","39600","1");
INSERT INTO timezone VALUES("33","+1030","13893087600","37800","0");
INSERT INTO timezone VALUES("33","+11","13908814200","39600","1");
INSERT INTO timezone VALUES("33","+1030","13924537200","37800","0");
INSERT INTO timezone VALUES("33","+11","13940263800","39600","1");
INSERT INTO timezone VALUES("33","+1030","13955986800","37800","0");
INSERT INTO timezone VALUES("33","+11","13972318200","39600","1");
INSERT INTO timezone VALUES("33","+1030","13988041200","37800","0");
INSERT INTO timezone VALUES("33","+11","14003767800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14019490800","37800","0");
INSERT INTO timezone VALUES("33","+11","14035217400","39600","1");
INSERT INTO timezone VALUES("33","+1030","14050940400","37800","0");
INSERT INTO timezone VALUES("33","+11","14066667000","39600","1");
INSERT INTO timezone VALUES("33","+1030","14082390000","37800","0");
INSERT INTO timezone VALUES("33","+11","14098116600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14113839600","37800","0");
INSERT INTO timezone VALUES("33","+11","14129566200","39600","1");
INSERT INTO timezone VALUES("33","+1030","14145289200","37800","0");
INSERT INTO timezone VALUES("33","+11","14161620600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14177343600","37800","0");
INSERT INTO timezone VALUES("33","+11","14193070200","39600","1");
INSERT INTO timezone VALUES("33","+1030","14208793200","37800","0");
INSERT INTO timezone VALUES("33","+11","14224519800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14240242800","37800","0");
INSERT INTO timezone VALUES("33","+11","14255969400","39600","1");
INSERT INTO timezone VALUES("33","+1030","14271692400","37800","0");
INSERT INTO timezone VALUES("33","+11","14287419000","39600","1");
INSERT INTO timezone VALUES("33","+1030","14303142000","37800","0");
INSERT INTO timezone VALUES("33","+11","14318868600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14335196400","37800","0");
INSERT INTO timezone VALUES("33","+11","14350923000","39600","1");
INSERT INTO timezone VALUES("33","+1030","14366646000","37800","0");
INSERT INTO timezone VALUES("33","+11","14382372600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14398095600","37800","0");
INSERT INTO timezone VALUES("33","+11","14413822200","39600","1");
INSERT INTO timezone VALUES("33","+1030","14429545200","37800","0");
INSERT INTO timezone VALUES("33","+11","14445271800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14460994800","37800","0");
INSERT INTO timezone VALUES("33","+11","14476721400","39600","1");
INSERT INTO timezone VALUES("33","+1030","14492444400","37800","0");
INSERT INTO timezone VALUES("33","+11","14508775800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14524498800","37800","0");
INSERT INTO timezone VALUES("33","+11","14540225400","39600","1");
INSERT INTO timezone VALUES("33","+1030","14555948400","37800","0");
INSERT INTO timezone VALUES("33","+11","14571675000","39600","1");
INSERT INTO timezone VALUES("33","+1030","14587398000","37800","0");
INSERT INTO timezone VALUES("33","+11","14603124600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14618847600","37800","0");
INSERT INTO timezone VALUES("33","+11","14634574200","39600","1");
INSERT INTO timezone VALUES("33","+1030","14650297200","37800","0");
INSERT INTO timezone VALUES("33","+11","14666023800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14681746800","37800","0");
INSERT INTO timezone VALUES("33","+11","14698078200","39600","1");
INSERT INTO timezone VALUES("33","+1030","14713801200","37800","0");
INSERT INTO timezone VALUES("33","+11","14729527800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14745250800","37800","0");
INSERT INTO timezone VALUES("33","+11","14760977400","39600","1");
INSERT INTO timezone VALUES("33","+1030","14776700400","37800","0");
INSERT INTO timezone VALUES("33","+11","14792427000","39600","1");
INSERT INTO timezone VALUES("33","+1030","14808150000","37800","0");
INSERT INTO timezone VALUES("33","+11","14823876600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14839599600","37800","0");
INSERT INTO timezone VALUES("33","+11","14855931000","39600","1");
INSERT INTO timezone VALUES("33","+1030","14871654000","37800","0");
INSERT INTO timezone VALUES("33","+11","14887380600","39600","1");
INSERT INTO timezone VALUES("33","+1030","14903103600","37800","0");
INSERT INTO timezone VALUES("33","+11","14918830200","39600","1");
INSERT INTO timezone VALUES("33","+1030","14934553200","37800","0");
INSERT INTO timezone VALUES("33","+11","14950279800","39600","1");
INSERT INTO timezone VALUES("33","+1030","14966002800","37800","0");
INSERT INTO timezone VALUES("33","+11","14981729400","39600","1");
INSERT INTO timezone VALUES("33","+1030","14997452400","37800","0");
INSERT INTO timezone VALUES("33","+11","15013179000","39600","1");
INSERT INTO timezone VALUES("33","+1030","15028902000","37800","0");
INSERT INTO timezone VALUES("33","+11","15045233400","39600","1");
INSERT INTO timezone VALUES("33","+1030","15060956400","37800","0");
INSERT INTO timezone VALUES("33","+11","15076683000","39600","1");
INSERT INTO timezone VALUES("33","+1030","15092406000","37800","0");
INSERT INTO timezone VALUES("33","+11","15108132600","39600","1");
INSERT INTO timezone VALUES("33","+1030","15123855600","37800","0");
INSERT INTO timezone VALUES("33","+11","15139582200","39600","1");
INSERT INTO timezone VALUES("33","+1030","15155305200","37800","0");
INSERT INTO timezone VALUES("33","+11","15171031800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15186754800","37800","0");
INSERT INTO timezone VALUES("33","+11","15202481400","39600","1");
INSERT INTO timezone VALUES("33","+1030","15218809200","37800","0");
INSERT INTO timezone VALUES("33","+11","15234535800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15250258800","37800","0");
INSERT INTO timezone VALUES("33","+11","15265985400","39600","1");
INSERT INTO timezone VALUES("33","+1030","15281708400","37800","0");
INSERT INTO timezone VALUES("33","+11","15297435000","39600","1");
INSERT INTO timezone VALUES("33","+1030","15313158000","37800","0");
INSERT INTO timezone VALUES("33","+11","15328884600","39600","1");
INSERT INTO timezone VALUES("33","+1030","15344607600","37800","0");
INSERT INTO timezone VALUES("33","+11","15360334200","39600","1");
INSERT INTO timezone VALUES("33","+1030","15376057200","37800","0");
INSERT INTO timezone VALUES("33","+11","15392388600","39600","1");
INSERT INTO timezone VALUES("33","+1030","15408111600","37800","0");
INSERT INTO timezone VALUES("33","+11","15423838200","39600","1");
INSERT INTO timezone VALUES("33","+1030","15439561200","37800","0");
INSERT INTO timezone VALUES("33","+11","15455287800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15471010800","37800","0");
INSERT INTO timezone VALUES("33","+11","15486737400","39600","1");
INSERT INTO timezone VALUES("33","+1030","15502460400","37800","0");
INSERT INTO timezone VALUES("33","+11","15518187000","39600","1");
INSERT INTO timezone VALUES("33","+1030","15533910000","37800","0");
INSERT INTO timezone VALUES("33","+11","15549636600","39600","1");
INSERT INTO timezone VALUES("33","+1030","15565359600","37800","0");
INSERT INTO timezone VALUES("33","+11","15581691000","39600","1");
INSERT INTO timezone VALUES("33","+1030","15597414000","37800","0");
INSERT INTO timezone VALUES("33","+11","15613140600","39600","1");
INSERT INTO timezone VALUES("33","+1030","15628863600","37800","0");
INSERT INTO timezone VALUES("33","+11","15644590200","39600","1");
INSERT INTO timezone VALUES("33","+1030","15660313200","37800","0");
INSERT INTO timezone VALUES("33","+11","15676039800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15691762800","37800","0");
INSERT INTO timezone VALUES("33","+11","15707489400","39600","1");
INSERT INTO timezone VALUES("33","+1030","15723212400","37800","0");
INSERT INTO timezone VALUES("33","+11","15739543800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15755266800","37800","0");
INSERT INTO timezone VALUES("33","+11","15770993400","39600","1");
INSERT INTO timezone VALUES("33","+1030","15786716400","37800","0");
INSERT INTO timezone VALUES("33","+11","15802443000","39600","1");
INSERT INTO timezone VALUES("33","+1030","15818166000","37800","0");
INSERT INTO timezone VALUES("33","+11","15833892600","39600","1");
INSERT INTO timezone VALUES("33","+1030","15849615600","37800","0");
INSERT INTO timezone VALUES("33","+11","15865342200","39600","1");
INSERT INTO timezone VALUES("33","+1030","15881065200","37800","0");
INSERT INTO timezone VALUES("33","+11","15896791800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15912514800","37800","0");
INSERT INTO timezone VALUES("33","+11","15928846200","39600","1");
INSERT INTO timezone VALUES("33","+1030","15944569200","37800","0");
INSERT INTO timezone VALUES("33","+11","15960295800","39600","1");
INSERT INTO timezone VALUES("33","+1030","15976018800","37800","0");
INSERT INTO timezone VALUES("33","+11","15991745400","39600","1");
INSERT INTO timezone VALUES("33","+1030","16007468400","37800","0");
INSERT INTO timezone VALUES("33","+11","16023195000","39600","1");
INSERT INTO timezone VALUES("33","+1030","16038918000","37800","0");
INSERT INTO timezone VALUES("33","+11","16054644600","39600","1");
INSERT INTO timezone VALUES("33","+1030","16070367600","37800","0");
INSERT INTO timezone VALUES("33","+11","16086094200","39600","1");
INSERT INTO timezone VALUES("33","+1030","16102422000","37800","0");
INSERT INTO timezone VALUES("33","+11","16118148600","39600","1");
INSERT INTO timezone VALUES("33","+1030","16133871600","37800","0");
INSERT INTO timezone VALUES("33","+11","16149598200","39600","1");
INSERT INTO timezone VALUES("33","+1030","16165321200","37800","0");
INSERT INTO timezone VALUES("33","+11","16181047800","39600","1");
INSERT INTO timezone VALUES("33","+1030","16196770800","37800","0");
INSERT INTO timezone VALUES("33","+11","16212497400","39600","1");
INSERT INTO timezone VALUES("33","+1030","16228220400","37800","0");
INSERT INTO timezone VALUES("33","+11","16243947000","39600","1");
INSERT INTO timezone VALUES("33","+1030","16259670000","37800","0");
INSERT INTO timezone VALUES("33","+11","16276001400","39600","1");
INSERT INTO timezone VALUES("33","+1030","16291724400","37800","0");
INSERT INTO timezone VALUES("33","+11","16307451000","39600","1");
INSERT INTO timezone VALUES("33","+1030","16323174000","37800","0");
INSERT INTO timezone VALUES("33","+11","16338900600","39600","1");
INSERT INTO timezone VALUES("33","+1030","16354623600","37800","0");
INSERT INTO timezone VALUES("33","+11","16370350200","39600","1");
INSERT INTO timezone VALUES("33","+1030","16386073200","37800","0");
INSERT INTO timezone VALUES("33","+11","16401799800","39600","1");
INSERT INTO timezone VALUES("33","+1030","16417522800","37800","0");
INSERT INTO timezone VALUES("33","+11","16433249400","39600","1");
INSERT INTO timezone VALUES("33","+1030","16448972400","37800","0");
INSERT INTO timezone VALUES("33","+11","16465303800","39600","1");
INSERT INTO timezone VALUES("33","+1030","16481026800","37800","0");
INSERT INTO timezone VALUES("33","+11","16496753400","39600","1");
INSERT INTO timezone VALUES("33","+1030","16512476400","37800","0");
INSERT INTO timezone VALUES("33","+11","16528203000","39600","1");
INSERT INTO timezone VALUES("33","+1030","16543926000","37800","0");
INSERT INTO timezone VALUES("33","+11","16559652600","39600","1");
INSERT INTO timezone VALUES("33","+1030","16575375600","37800","0");
INSERT INTO timezone VALUES("33","+11","16591102200","39600","1");
INSERT INTO timezone VALUES("33","+1030","16606825200","37800","0");
INSERT INTO timezone VALUES("33","+11","16623156600","39600","1");
INSERT INTO timezone VALUES("33","+1030","16638879600","37800","0");
INSERT INTO timezone VALUES("33","+11","16654606200","39600","1");
INSERT INTO timezone VALUES("33","+1030","16670329200","37800","0");
INSERT INTO timezone VALUES("33","+11","16686055800","39600","1");
INSERT INTO timezone VALUES("33","+1030","16701778800","37800","0");
INSERT INTO timezone VALUES("33","+11","16717505400","39600","1");
INSERT INTO timezone VALUES("34","AEST","-2214259200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","-1680508800","39600","1");
INSERT INTO timezone VALUES("34","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","-71136000","39600","1");
INSERT INTO timezone VALUES("34","AEST","-55411200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","-37267200","39600","1");
INSERT INTO timezone VALUES("34","AEST","-25776000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","-5817600","39600","1");
INSERT INTO timezone VALUES("34","AEST","5673600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","25632000","39600","1");
INSERT INTO timezone VALUES("34","AEST","37728000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("34","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","89136000","39600","1");
INSERT INTO timezone VALUES("34","AEST","100022400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","120585600","39600","1");
INSERT INTO timezone VALUES("34","AEST","131472000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","152035200","39600","1");
INSERT INTO timezone VALUES("34","AEST","162921600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","183484800","39600","1");
INSERT INTO timezone VALUES("34","AEST","194976000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","215539200","39600","1");
INSERT INTO timezone VALUES("34","AEST","226425600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","246988800","39600","1");
INSERT INTO timezone VALUES("34","AEST","257875200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","278438400","39600","1");
INSERT INTO timezone VALUES("34","AEST","289324800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","309888000","39600","1");
INSERT INTO timezone VALUES("34","AEST","320774400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","341337600","39600","1");
INSERT INTO timezone VALUES("34","AEST","352224000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","372787200","39600","1");
INSERT INTO timezone VALUES("34","AEST","386092800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","404841600","39600","1");
INSERT INTO timezone VALUES("34","AEST","417542400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","436291200","39600","1");
INSERT INTO timezone VALUES("34","AEST","447177600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","467740800","39600","1");
INSERT INTO timezone VALUES("34","AEST","478627200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","499190400","39600","1");
INSERT INTO timezone VALUES("34","AEST","510076800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","530035200","39600","1");
INSERT INTO timezone VALUES("34","AEST","542736000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","562089600","39600","1");
INSERT INTO timezone VALUES("34","AEST","574790400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","594144000","39600","1");
INSERT INTO timezone VALUES("34","AEST","606240000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("34","AEST","637689600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("34","AEST","670348800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","686678400","39600","1");
INSERT INTO timezone VALUES("34","AEST","701798400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","718128000","39600","1");
INSERT INTO timezone VALUES("34","AEST","733248000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","749577600","39600","1");
INSERT INTO timezone VALUES("34","AEST","764697600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","781027200","39600","1");
INSERT INTO timezone VALUES("34","AEST","796147200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","812476800","39600","1");
INSERT INTO timezone VALUES("34","AEST","828201600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","844531200","39600","1");
INSERT INTO timezone VALUES("34","AEST","859651200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","875980800","39600","1");
INSERT INTO timezone VALUES("34","AEST","891100800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","907430400","39600","1");
INSERT INTO timezone VALUES("34","AEST","922550400","36000","0");
INSERT INTO timezone VALUES("34","AEDT","938880000","39600","1");
INSERT INTO timezone VALUES("34","AEST","954000000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","967305600","39600","1");
INSERT INTO timezone VALUES("34","AEST","985449600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1002384000","39600","1");
INSERT INTO timezone VALUES("34","AEST","1017504000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1033833600","39600","1");
INSERT INTO timezone VALUES("34","AEST","1048953600","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1065283200","39600","1");
INSERT INTO timezone VALUES("34","AEST","1080403200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1096732800","39600","1");
INSERT INTO timezone VALUES("34","AEST","1111852800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1128182400","39600","1");
INSERT INTO timezone VALUES("34","AEST","1143907200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1159632000","39600","1");
INSERT INTO timezone VALUES("34","AEST","1174752000","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1191686400","39600","1");
INSERT INTO timezone VALUES("34","AEST","1207411200","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1223136000","39600","1");
INSERT INTO timezone VALUES("34","AEST","1238860800","36000","0");
INSERT INTO timezone VALUES("34","AEDT","1254585600","39600","1");
INSERT INTO timezone VALUES("34","+11","1270310400","39600","0");
INSERT INTO timezone VALUES("35","LMT","-2345795357","35356","0");
INSERT INTO timezone VALUES("35","AEST","-2345795356","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-1680508800","39600","1");
INSERT INTO timezone VALUES("35","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-883641600","39600","1");
INSERT INTO timezone VALUES("35","AEST","-876128400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-860400000","39600","1");
INSERT INTO timezone VALUES("35","AEST","-844678800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-828345600","39600","1");
INSERT INTO timezone VALUES("35","AEST","-813229200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-71136000","39600","1");
INSERT INTO timezone VALUES("35","AEST","-55411200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-37267200","39600","1");
INSERT INTO timezone VALUES("35","AEST","-25776000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","-5817600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5673600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","25632000","39600","1");
INSERT INTO timezone VALUES("35","AEST","37728000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("35","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","89136000","39600","1");
INSERT INTO timezone VALUES("35","AEST","100022400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","120585600","39600","1");
INSERT INTO timezone VALUES("35","AEST","131472000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","152035200","39600","1");
INSERT INTO timezone VALUES("35","AEST","162921600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","183484800","39600","1");
INSERT INTO timezone VALUES("35","AEST","194976000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","215539200","39600","1");
INSERT INTO timezone VALUES("35","AEST","226425600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","246988800","39600","1");
INSERT INTO timezone VALUES("35","AEST","257875200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","278438400","39600","1");
INSERT INTO timezone VALUES("35","AEST","289324800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","309888000","39600","1");
INSERT INTO timezone VALUES("35","AEST","320774400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","341337600","39600","1");
INSERT INTO timezone VALUES("35","AEST","352224000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","372787200","39600","1");
INSERT INTO timezone VALUES("35","AEST","386092800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","404841600","39600","1");
INSERT INTO timezone VALUES("35","AEST","417542400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","436291200","39600","1");
INSERT INTO timezone VALUES("35","AEST","447177600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","467740800","39600","1");
INSERT INTO timezone VALUES("35","AEST","478627200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","499190400","39600","1");
INSERT INTO timezone VALUES("35","AEST","510076800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","530035200","39600","1");
INSERT INTO timezone VALUES("35","AEST","542736000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","562089600","39600","1");
INSERT INTO timezone VALUES("35","AEST","574790400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","594144000","39600","1");
INSERT INTO timezone VALUES("35","AEST","606240000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("35","AEST","637689600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("35","AEST","670348800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","686678400","39600","1");
INSERT INTO timezone VALUES("35","AEST","701798400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","718128000","39600","1");
INSERT INTO timezone VALUES("35","AEST","733248000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","749577600","39600","1");
INSERT INTO timezone VALUES("35","AEST","764697600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","781027200","39600","1");
INSERT INTO timezone VALUES("35","AEST","796147200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","812476800","39600","1");
INSERT INTO timezone VALUES("35","AEST","828201600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","844531200","39600","1");
INSERT INTO timezone VALUES("35","AEST","859651200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","875980800","39600","1");
INSERT INTO timezone VALUES("35","AEST","891100800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","907430400","39600","1");
INSERT INTO timezone VALUES("35","AEST","922550400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","938880000","39600","1");
INSERT INTO timezone VALUES("35","AEST","954000000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","967305600","39600","1");
INSERT INTO timezone VALUES("35","AEST","985449600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1002384000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1017504000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1033833600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1048953600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1065283200","39600","1");
INSERT INTO timezone VALUES("35","AEST","1080403200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1096732800","39600","1");
INSERT INTO timezone VALUES("35","AEST","1111852800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1128182400","39600","1");
INSERT INTO timezone VALUES("35","AEST","1143907200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1159632000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1174752000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1191686400","39600","1");
INSERT INTO timezone VALUES("35","AEST","1207411200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1223136000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1238860800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1254585600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1270310400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1286035200","39600","1");
INSERT INTO timezone VALUES("35","AEST","1301760000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1317484800","39600","1");
INSERT INTO timezone VALUES("35","AEST","1333209600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1349539200","39600","1");
INSERT INTO timezone VALUES("35","AEST","1365264000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1380988800","39600","1");
INSERT INTO timezone VALUES("35","AEST","1396713600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1412438400","39600","1");
INSERT INTO timezone VALUES("35","AEST","1428163200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1443888000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1459612800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1475337600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1491062400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1506787200","39600","1");
INSERT INTO timezone VALUES("35","AEST","1522512000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1538841600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1554566400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1570291200","39600","1");
INSERT INTO timezone VALUES("35","AEST","1586016000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1601740800","39600","1");
INSERT INTO timezone VALUES("35","AEST","1617465600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1633190400","39600","1");
INSERT INTO timezone VALUES("35","AEST","1648915200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1664640000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1680364800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1696089600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1712419200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1728144000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1743868800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1759593600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1775318400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1791043200","39600","1");
INSERT INTO timezone VALUES("35","AEST","1806768000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1822492800","39600","1");
INSERT INTO timezone VALUES("35","AEST","1838217600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1853942400","39600","1");
INSERT INTO timezone VALUES("35","AEST","1869667200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1885996800","39600","1");
INSERT INTO timezone VALUES("35","AEST","1901721600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1917446400","39600","1");
INSERT INTO timezone VALUES("35","AEST","1933171200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1948896000","39600","1");
INSERT INTO timezone VALUES("35","AEST","1964620800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","1980345600","39600","1");
INSERT INTO timezone VALUES("35","AEST","1996070400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2011795200","39600","1");
INSERT INTO timezone VALUES("35","AEST","2027520000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2043244800","39600","1");
INSERT INTO timezone VALUES("35","AEST","2058969600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2075299200","39600","1");
INSERT INTO timezone VALUES("35","AEST","2091024000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2106748800","39600","1");
INSERT INTO timezone VALUES("35","AEST","2122473600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2138198400","39600","1");
INSERT INTO timezone VALUES("35","AEST","2153923200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2169648000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2185372800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2201097600","39600","1");
INSERT INTO timezone VALUES("35","AEST","2216822400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2233152000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2248876800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2264601600","39600","1");
INSERT INTO timezone VALUES("35","AEST","2280326400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2296051200","39600","1");
INSERT INTO timezone VALUES("35","AEST","2311776000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2327500800","39600","1");
INSERT INTO timezone VALUES("35","AEST","2343225600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2358950400","39600","1");
INSERT INTO timezone VALUES("35","AEST","2374675200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2390400000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2406124800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2422454400","39600","1");
INSERT INTO timezone VALUES("35","AEST","2438179200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2453904000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2469628800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2485353600","39600","1");
INSERT INTO timezone VALUES("35","AEST","2501078400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2516803200","39600","1");
INSERT INTO timezone VALUES("35","AEST","2532528000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2548252800","39600","1");
INSERT INTO timezone VALUES("35","AEST","2563977600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2579702400","39600","1");
INSERT INTO timezone VALUES("35","AEST","2596032000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2611756800","39600","1");
INSERT INTO timezone VALUES("35","AEST","2627481600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2643206400","39600","1");
INSERT INTO timezone VALUES("35","AEST","2658931200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2674656000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2690380800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2706105600","39600","1");
INSERT INTO timezone VALUES("35","AEST","2721830400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2737555200","39600","1");
INSERT INTO timezone VALUES("35","AEST","2753280000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2769609600","39600","1");
INSERT INTO timezone VALUES("35","AEST","2785334400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2801059200","39600","1");
INSERT INTO timezone VALUES("35","AEST","2816784000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2832508800","39600","1");
INSERT INTO timezone VALUES("35","AEST","2848233600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2863958400","39600","1");
INSERT INTO timezone VALUES("35","AEST","2879683200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2895408000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2911132800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2926857600","39600","1");
INSERT INTO timezone VALUES("35","AEST","2942582400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2958912000","39600","1");
INSERT INTO timezone VALUES("35","AEST","2974636800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","2990361600","39600","1");
INSERT INTO timezone VALUES("35","AEST","3006086400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3021811200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3037536000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3053260800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3068985600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3084710400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3100435200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3116764800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3132489600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3148214400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3163939200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3179664000","39600","1");
INSERT INTO timezone VALUES("35","AEST","3195388800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3211113600","39600","1");
INSERT INTO timezone VALUES("35","AEST","3226838400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3242563200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3258288000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3274012800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3289737600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3306067200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3321792000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3337516800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3353241600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3368966400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3384691200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3400416000","39600","1");
INSERT INTO timezone VALUES("35","AEST","3416140800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3431865600","39600","1");
INSERT INTO timezone VALUES("35","AEST","3447590400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3463315200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3479644800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3495369600","39600","1");
INSERT INTO timezone VALUES("35","AEST","3511094400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3526819200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3542544000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3558268800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3573993600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3589718400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3605443200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3621168000","39600","1");
INSERT INTO timezone VALUES("35","AEST","3636892800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3653222400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3668947200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3684672000","39600","1");
INSERT INTO timezone VALUES("35","AEST","3700396800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3716121600","39600","1");
INSERT INTO timezone VALUES("35","AEST","3731846400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3747571200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3763296000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3779020800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3794745600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3810470400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3826195200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3842524800","39600","1");
INSERT INTO timezone VALUES("35","AEST","3858249600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3873974400","39600","1");
INSERT INTO timezone VALUES("35","AEST","3889699200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3905424000","39600","1");
INSERT INTO timezone VALUES("35","AEST","3921148800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3936873600","39600","1");
INSERT INTO timezone VALUES("35","AEST","3952598400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","3968323200","39600","1");
INSERT INTO timezone VALUES("35","AEST","3984048000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4000377600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4016102400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4031827200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4047552000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4063276800","39600","1");
INSERT INTO timezone VALUES("35","AEST","4079001600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4094726400","39600","1");
INSERT INTO timezone VALUES("35","AEST","4110451200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4126176000","39600","1");
INSERT INTO timezone VALUES("35","AEST","4141900800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4157625600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4173350400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4189075200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4204800000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4221129600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4236854400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4252579200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4268304000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4284028800","39600","1");
INSERT INTO timezone VALUES("35","AEST","4299753600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4315478400","39600","1");
INSERT INTO timezone VALUES("35","AEST","4331203200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4346928000","39600","1");
INSERT INTO timezone VALUES("35","AEST","4362652800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4378982400","39600","1");
INSERT INTO timezone VALUES("35","AEST","4394707200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4410432000","39600","1");
INSERT INTO timezone VALUES("35","AEST","4426156800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4441881600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4457606400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4473331200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4489056000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4504780800","39600","1");
INSERT INTO timezone VALUES("35","AEST","4520505600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4536230400","39600","1");
INSERT INTO timezone VALUES("35","AEST","4551955200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4568284800","39600","1");
INSERT INTO timezone VALUES("35","AEST","4584009600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4599734400","39600","1");
INSERT INTO timezone VALUES("35","AEST","4615459200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4631184000","39600","1");
INSERT INTO timezone VALUES("35","AEST","4646908800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4662633600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4678358400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4694083200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4709808000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4725532800","39600","1");
INSERT INTO timezone VALUES("35","AEST","4741862400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4757587200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4773312000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4789036800","39600","1");
INSERT INTO timezone VALUES("35","AEST","4804761600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4820486400","39600","1");
INSERT INTO timezone VALUES("35","AEST","4836211200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4851936000","39600","1");
INSERT INTO timezone VALUES("35","AEST","4867660800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4883385600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4899110400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4915440000","39600","1");
INSERT INTO timezone VALUES("35","AEST","4931164800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4946889600","39600","1");
INSERT INTO timezone VALUES("35","AEST","4962614400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","4978339200","39600","1");
INSERT INTO timezone VALUES("35","AEST","4994064000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5009788800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5025513600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5041238400","39600","1");
INSERT INTO timezone VALUES("35","AEST","5056963200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5072688000","39600","1");
INSERT INTO timezone VALUES("35","AEST","5088412800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5104742400","39600","1");
INSERT INTO timezone VALUES("35","AEST","5120467200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5136192000","39600","1");
INSERT INTO timezone VALUES("35","AEST","5151916800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5167641600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5183366400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5199091200","39600","1");
INSERT INTO timezone VALUES("35","AEST","5214816000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5230540800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5246265600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5262595200","39600","1");
INSERT INTO timezone VALUES("35","AEST","5278320000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5294044800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5309769600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5325494400","39600","1");
INSERT INTO timezone VALUES("35","AEST","5341219200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5356944000","39600","1");
INSERT INTO timezone VALUES("35","AEST","5372668800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5388393600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5404118400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5419843200","39600","1");
INSERT INTO timezone VALUES("35","AEST","5435568000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5451897600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5467622400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5483347200","39600","1");
INSERT INTO timezone VALUES("35","AEST","5499072000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5514796800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5530521600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5546246400","39600","1");
INSERT INTO timezone VALUES("35","AEST","5561971200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5577696000","39600","1");
INSERT INTO timezone VALUES("35","AEST","5593420800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5609145600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5625475200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5641200000","39600","1");
INSERT INTO timezone VALUES("35","AEST","5656924800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5672649600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5688374400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5704099200","39600","1");
INSERT INTO timezone VALUES("35","AEST","5719824000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5735548800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5751273600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5766998400","39600","1");
INSERT INTO timezone VALUES("35","AEST","5782723200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5799052800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5814777600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5830502400","39600","1");
INSERT INTO timezone VALUES("35","AEST","5846227200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5861952000","39600","1");
INSERT INTO timezone VALUES("35","AEST","5877676800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5893401600","39600","1");
INSERT INTO timezone VALUES("35","AEST","5909126400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5924851200","39600","1");
INSERT INTO timezone VALUES("35","AEST","5940576000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5956300800","39600","1");
INSERT INTO timezone VALUES("35","AEST","5972025600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","5988355200","39600","1");
INSERT INTO timezone VALUES("35","AEST","6004080000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6019804800","39600","1");
INSERT INTO timezone VALUES("35","AEST","6035529600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6051254400","39600","1");
INSERT INTO timezone VALUES("35","AEST","6066979200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6082704000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6098428800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6114153600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6129878400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6146208000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6161932800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6177657600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6193382400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6209107200","39600","1");
INSERT INTO timezone VALUES("35","AEST","6224832000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6240556800","39600","1");
INSERT INTO timezone VALUES("35","AEST","6256281600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6272006400","39600","1");
INSERT INTO timezone VALUES("35","AEST","6287731200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6303456000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6319180800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6335510400","39600","1");
INSERT INTO timezone VALUES("35","AEST","6351235200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6366960000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6382684800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6398409600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6414134400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6429859200","39600","1");
INSERT INTO timezone VALUES("35","AEST","6445584000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6461308800","39600","1");
INSERT INTO timezone VALUES("35","AEST","6477033600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6492758400","39600","1");
INSERT INTO timezone VALUES("35","AEST","6509088000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6524812800","39600","1");
INSERT INTO timezone VALUES("35","AEST","6540537600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6556262400","39600","1");
INSERT INTO timezone VALUES("35","AEST","6571987200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6587712000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6603436800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6619161600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6634886400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6650611200","39600","1");
INSERT INTO timezone VALUES("35","AEST","6666336000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6682665600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6698390400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6714115200","39600","1");
INSERT INTO timezone VALUES("35","AEST","6729840000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6745564800","39600","1");
INSERT INTO timezone VALUES("35","AEST","6761289600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6777014400","39600","1");
INSERT INTO timezone VALUES("35","AEST","6792739200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6808464000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6824188800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6839913600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6855638400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6871968000","39600","1");
INSERT INTO timezone VALUES("35","AEST","6887692800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6903417600","39600","1");
INSERT INTO timezone VALUES("35","AEST","6919142400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6934867200","39600","1");
INSERT INTO timezone VALUES("35","AEST","6950592000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6966316800","39600","1");
INSERT INTO timezone VALUES("35","AEST","6982041600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","6997766400","39600","1");
INSERT INTO timezone VALUES("35","AEST","7013491200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7029820800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7045545600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7061270400","39600","1");
INSERT INTO timezone VALUES("35","AEST","7076995200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7092720000","39600","1");
INSERT INTO timezone VALUES("35","AEST","7108444800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7124169600","39600","1");
INSERT INTO timezone VALUES("35","AEST","7139894400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7155619200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7171344000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7187068800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7202793600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7219123200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7234848000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7250572800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7266297600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7282022400","39600","1");
INSERT INTO timezone VALUES("35","AEST","7297747200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7313472000","39600","1");
INSERT INTO timezone VALUES("35","AEST","7329196800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7344921600","39600","1");
INSERT INTO timezone VALUES("35","AEST","7360646400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7376371200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7392096000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7408425600","39600","1");
INSERT INTO timezone VALUES("35","AEST","7424150400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7439875200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7455600000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7471324800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7487049600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7502774400","39600","1");
INSERT INTO timezone VALUES("35","AEST","7518499200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7534224000","39600","1");
INSERT INTO timezone VALUES("35","AEST","7549948800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7565673600","39600","1");
INSERT INTO timezone VALUES("35","AEST","7581398400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7597728000","39600","1");
INSERT INTO timezone VALUES("35","AEST","7613452800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7629177600","39600","1");
INSERT INTO timezone VALUES("35","AEST","7644902400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7660627200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7676352000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7692076800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7707801600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7723526400","39600","1");
INSERT INTO timezone VALUES("35","AEST","7739251200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7754976000","39600","1");
INSERT INTO timezone VALUES("35","AEST","7771305600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7787030400","39600","1");
INSERT INTO timezone VALUES("35","AEST","7802755200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7818480000","39600","1");
INSERT INTO timezone VALUES("35","AEST","7834204800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7849929600","39600","1");
INSERT INTO timezone VALUES("35","AEST","7865654400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7881379200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7897104000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7912828800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7928553600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7944883200","39600","1");
INSERT INTO timezone VALUES("35","AEST","7960608000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","7976332800","39600","1");
INSERT INTO timezone VALUES("35","AEST","7992057600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8007782400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8023507200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8039232000","39600","1");
INSERT INTO timezone VALUES("35","AEST","8054956800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8070681600","39600","1");
INSERT INTO timezone VALUES("35","AEST","8086406400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8102131200","39600","1");
INSERT INTO timezone VALUES("35","AEST","8117856000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8134185600","39600","1");
INSERT INTO timezone VALUES("35","AEST","8149910400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8165635200","39600","1");
INSERT INTO timezone VALUES("35","AEST","8181360000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8197084800","39600","1");
INSERT INTO timezone VALUES("35","AEST","8212809600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8228534400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8244259200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8259984000","39600","1");
INSERT INTO timezone VALUES("35","AEST","8275708800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8292038400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8307763200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8323488000","39600","1");
INSERT INTO timezone VALUES("35","AEST","8339212800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8354937600","39600","1");
INSERT INTO timezone VALUES("35","AEST","8370662400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8386387200","39600","1");
INSERT INTO timezone VALUES("35","AEST","8402112000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8417836800","39600","1");
INSERT INTO timezone VALUES("35","AEST","8433561600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8449286400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8465011200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8481340800","39600","1");
INSERT INTO timezone VALUES("35","AEST","8497065600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8512790400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8528515200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8544240000","39600","1");
INSERT INTO timezone VALUES("35","AEST","8559964800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8575689600","39600","1");
INSERT INTO timezone VALUES("35","AEST","8591414400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8607139200","39600","1");
INSERT INTO timezone VALUES("35","AEST","8622864000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8638588800","39600","1");
INSERT INTO timezone VALUES("35","AEST","8654918400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8670643200","39600","1");
INSERT INTO timezone VALUES("35","AEST","8686368000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8702092800","39600","1");
INSERT INTO timezone VALUES("35","AEST","8717817600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8733542400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8749267200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8764992000","39600","1");
INSERT INTO timezone VALUES("35","AEST","8780716800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8796441600","39600","1");
INSERT INTO timezone VALUES("35","AEST","8812166400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8828496000","39600","1");
INSERT INTO timezone VALUES("35","AEST","8844220800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8859945600","39600","1");
INSERT INTO timezone VALUES("35","AEST","8875670400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8891395200","39600","1");
INSERT INTO timezone VALUES("35","AEST","8907120000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8922844800","39600","1");
INSERT INTO timezone VALUES("35","AEST","8938569600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8954294400","39600","1");
INSERT INTO timezone VALUES("35","AEST","8970019200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","8985744000","39600","1");
INSERT INTO timezone VALUES("35","AEST","9001468800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9017798400","39600","1");
INSERT INTO timezone VALUES("35","AEST","9033523200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9049248000","39600","1");
INSERT INTO timezone VALUES("35","AEST","9064972800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9080697600","39600","1");
INSERT INTO timezone VALUES("35","AEST","9096422400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9112147200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9127872000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9143596800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9159321600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9175651200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9191376000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9207100800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9222825600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9238550400","39600","1");
INSERT INTO timezone VALUES("35","AEST","9254275200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9270000000","39600","1");
INSERT INTO timezone VALUES("35","AEST","9285724800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9301449600","39600","1");
INSERT INTO timezone VALUES("35","AEST","9317174400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9332899200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9348624000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9364953600","39600","1");
INSERT INTO timezone VALUES("35","AEST","9380678400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9396403200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9412128000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9427852800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9443577600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9459302400","39600","1");
INSERT INTO timezone VALUES("35","AEST","9475027200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9490752000","39600","1");
INSERT INTO timezone VALUES("35","AEST","9506476800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9522201600","39600","1");
INSERT INTO timezone VALUES("35","AEST","9538531200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9554256000","39600","1");
INSERT INTO timezone VALUES("35","AEST","9569980800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9585705600","39600","1");
INSERT INTO timezone VALUES("35","AEST","9601430400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9617155200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9632880000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9648604800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9664329600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9680054400","39600","1");
INSERT INTO timezone VALUES("35","AEST","9695779200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9712108800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9727833600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9743558400","39600","1");
INSERT INTO timezone VALUES("35","AEST","9759283200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9775008000","39600","1");
INSERT INTO timezone VALUES("35","AEST","9790732800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9806457600","39600","1");
INSERT INTO timezone VALUES("35","AEST","9822182400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9837907200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9853632000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9869356800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9885081600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9901411200","39600","1");
INSERT INTO timezone VALUES("35","AEST","9917136000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9932860800","39600","1");
INSERT INTO timezone VALUES("35","AEST","9948585600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9964310400","39600","1");
INSERT INTO timezone VALUES("35","AEST","9980035200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","9995760000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10011484800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10027209600","39600","1");
INSERT INTO timezone VALUES("35","AEST","10042934400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10059264000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10074988800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10090713600","39600","1");
INSERT INTO timezone VALUES("35","AEST","10106438400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10122163200","39600","1");
INSERT INTO timezone VALUES("35","AEST","10137888000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10153612800","39600","1");
INSERT INTO timezone VALUES("35","AEST","10169337600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10185062400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10200787200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10216512000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10232236800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10248566400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10264291200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10280016000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10295740800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10311465600","39600","1");
INSERT INTO timezone VALUES("35","AEST","10327190400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10342915200","39600","1");
INSERT INTO timezone VALUES("35","AEST","10358640000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10374364800","39600","1");
INSERT INTO timezone VALUES("35","AEST","10390089600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10405814400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10421539200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10437868800","39600","1");
INSERT INTO timezone VALUES("35","AEST","10453593600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10469318400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10485043200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10500768000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10516492800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10532217600","39600","1");
INSERT INTO timezone VALUES("35","AEST","10547942400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10563667200","39600","1");
INSERT INTO timezone VALUES("35","AEST","10579392000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10595116800","39600","1");
INSERT INTO timezone VALUES("35","AEST","10610841600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10627171200","39600","1");
INSERT INTO timezone VALUES("35","AEST","10642896000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10658620800","39600","1");
INSERT INTO timezone VALUES("35","AEST","10674345600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10690070400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10705795200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10721520000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10737244800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10752969600","39600","1");
INSERT INTO timezone VALUES("35","AEST","10768694400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10784419200","39600","1");
INSERT INTO timezone VALUES("35","AEST","10800748800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10816473600","39600","1");
INSERT INTO timezone VALUES("35","AEST","10832198400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10847923200","39600","1");
INSERT INTO timezone VALUES("35","AEST","10863648000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10879372800","39600","1");
INSERT INTO timezone VALUES("35","AEST","10895097600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10910822400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10926547200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10942272000","39600","1");
INSERT INTO timezone VALUES("35","AEST","10957996800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","10974326400","39600","1");
INSERT INTO timezone VALUES("35","AEST","10990051200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11005776000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11021500800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11037225600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11052950400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11068675200","39600","1");
INSERT INTO timezone VALUES("35","AEST","11084400000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11100124800","39600","1");
INSERT INTO timezone VALUES("35","AEST","11115849600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11131574400","39600","1");
INSERT INTO timezone VALUES("35","AEST","11147299200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11163628800","39600","1");
INSERT INTO timezone VALUES("35","AEST","11179353600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11195078400","39600","1");
INSERT INTO timezone VALUES("35","AEST","11210803200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11226528000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11242252800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11257977600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11273702400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11289427200","39600","1");
INSERT INTO timezone VALUES("35","AEST","11305152000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11321481600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11337206400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11352931200","39600","1");
INSERT INTO timezone VALUES("35","AEST","11368656000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11384380800","39600","1");
INSERT INTO timezone VALUES("35","AEST","11400105600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11415830400","39600","1");
INSERT INTO timezone VALUES("35","AEST","11431555200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11447280000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11463004800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11478729600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11494454400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11510784000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11526508800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11542233600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11557958400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11573683200","39600","1");
INSERT INTO timezone VALUES("35","AEST","11589408000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11605132800","39600","1");
INSERT INTO timezone VALUES("35","AEST","11620857600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11636582400","39600","1");
INSERT INTO timezone VALUES("35","AEST","11652307200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11668032000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11684361600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11700086400","39600","1");
INSERT INTO timezone VALUES("35","AEST","11715811200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11731536000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11747260800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11762985600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11778710400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11794435200","39600","1");
INSERT INTO timezone VALUES("35","AEST","11810160000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11825884800","39600","1");
INSERT INTO timezone VALUES("35","AEST","11841609600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11857939200","39600","1");
INSERT INTO timezone VALUES("35","AEST","11873664000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11889388800","39600","1");
INSERT INTO timezone VALUES("35","AEST","11905113600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11920838400","39600","1");
INSERT INTO timezone VALUES("35","AEST","11936563200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11952288000","39600","1");
INSERT INTO timezone VALUES("35","AEST","11968012800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","11983737600","39600","1");
INSERT INTO timezone VALUES("35","AEST","11999462400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12015187200","39600","1");
INSERT INTO timezone VALUES("35","AEST","12030912000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12047241600","39600","1");
INSERT INTO timezone VALUES("35","AEST","12062966400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12078691200","39600","1");
INSERT INTO timezone VALUES("35","AEST","12094416000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12110140800","39600","1");
INSERT INTO timezone VALUES("35","AEST","12125865600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12141590400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12157315200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12173040000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12188764800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12205094400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12220819200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12236544000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12252268800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12267993600","39600","1");
INSERT INTO timezone VALUES("35","AEST","12283718400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12299443200","39600","1");
INSERT INTO timezone VALUES("35","AEST","12315168000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12330892800","39600","1");
INSERT INTO timezone VALUES("35","AEST","12346617600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12362342400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12378067200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12394396800","39600","1");
INSERT INTO timezone VALUES("35","AEST","12410121600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12425846400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12441571200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12457296000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12473020800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12488745600","39600","1");
INSERT INTO timezone VALUES("35","AEST","12504470400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12520195200","39600","1");
INSERT INTO timezone VALUES("35","AEST","12535920000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12551644800","39600","1");
INSERT INTO timezone VALUES("35","AEST","12567974400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12583699200","39600","1");
INSERT INTO timezone VALUES("35","AEST","12599424000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12615148800","39600","1");
INSERT INTO timezone VALUES("35","AEST","12630873600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12646598400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12662323200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12678048000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12693772800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12709497600","39600","1");
INSERT INTO timezone VALUES("35","AEST","12725222400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12741552000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12757276800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12773001600","39600","1");
INSERT INTO timezone VALUES("35","AEST","12788726400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12804451200","39600","1");
INSERT INTO timezone VALUES("35","AEST","12820176000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12835900800","39600","1");
INSERT INTO timezone VALUES("35","AEST","12851625600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12867350400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12883075200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12898800000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12914524800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12930854400","39600","1");
INSERT INTO timezone VALUES("35","AEST","12946579200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12962304000","39600","1");
INSERT INTO timezone VALUES("35","AEST","12978028800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","12993753600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13009478400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13025203200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13040928000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13056652800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13072377600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13088707200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13104432000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13120156800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13135881600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13151606400","39600","1");
INSERT INTO timezone VALUES("35","AEST","13167331200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13183056000","39600","1");
INSERT INTO timezone VALUES("35","AEST","13198780800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13214505600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13230230400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13245955200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13261680000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13278009600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13293734400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13309459200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13325184000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13340908800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13356633600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13372358400","39600","1");
INSERT INTO timezone VALUES("35","AEST","13388083200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13403808000","39600","1");
INSERT INTO timezone VALUES("35","AEST","13419532800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13435257600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13451587200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13467312000","39600","1");
INSERT INTO timezone VALUES("35","AEST","13483036800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13498761600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13514486400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13530211200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13545936000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13561660800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13577385600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13593110400","39600","1");
INSERT INTO timezone VALUES("35","AEST","13608835200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13625164800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13640889600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13656614400","39600","1");
INSERT INTO timezone VALUES("35","AEST","13672339200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13688064000","39600","1");
INSERT INTO timezone VALUES("35","AEST","13703788800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13719513600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13735238400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13750963200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13766688000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13782412800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13798137600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13814467200","39600","1");
INSERT INTO timezone VALUES("35","AEST","13830192000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13845916800","39600","1");
INSERT INTO timezone VALUES("35","AEST","13861641600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13877366400","39600","1");
INSERT INTO timezone VALUES("35","AEST","13893091200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13908816000","39600","1");
INSERT INTO timezone VALUES("35","AEST","13924540800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13940265600","39600","1");
INSERT INTO timezone VALUES("35","AEST","13955990400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","13972320000","39600","1");
INSERT INTO timezone VALUES("35","AEST","13988044800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14003769600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14019494400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14035219200","39600","1");
INSERT INTO timezone VALUES("35","AEST","14050944000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14066668800","39600","1");
INSERT INTO timezone VALUES("35","AEST","14082393600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14098118400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14113843200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14129568000","39600","1");
INSERT INTO timezone VALUES("35","AEST","14145292800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14161622400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14177347200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14193072000","39600","1");
INSERT INTO timezone VALUES("35","AEST","14208796800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14224521600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14240246400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14255971200","39600","1");
INSERT INTO timezone VALUES("35","AEST","14271696000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14287420800","39600","1");
INSERT INTO timezone VALUES("35","AEST","14303145600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14318870400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14335200000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14350924800","39600","1");
INSERT INTO timezone VALUES("35","AEST","14366649600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14382374400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14398099200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14413824000","39600","1");
INSERT INTO timezone VALUES("35","AEST","14429548800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14445273600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14460998400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14476723200","39600","1");
INSERT INTO timezone VALUES("35","AEST","14492448000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14508777600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14524502400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14540227200","39600","1");
INSERT INTO timezone VALUES("35","AEST","14555952000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14571676800","39600","1");
INSERT INTO timezone VALUES("35","AEST","14587401600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14603126400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14618851200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14634576000","39600","1");
INSERT INTO timezone VALUES("35","AEST","14650300800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14666025600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14681750400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14698080000","39600","1");
INSERT INTO timezone VALUES("35","AEST","14713804800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14729529600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14745254400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14760979200","39600","1");
INSERT INTO timezone VALUES("35","AEST","14776704000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14792428800","39600","1");
INSERT INTO timezone VALUES("35","AEST","14808153600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14823878400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14839603200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14855932800","39600","1");
INSERT INTO timezone VALUES("35","AEST","14871657600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14887382400","39600","1");
INSERT INTO timezone VALUES("35","AEST","14903107200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14918832000","39600","1");
INSERT INTO timezone VALUES("35","AEST","14934556800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14950281600","39600","1");
INSERT INTO timezone VALUES("35","AEST","14966006400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","14981731200","39600","1");
INSERT INTO timezone VALUES("35","AEST","14997456000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15013180800","39600","1");
INSERT INTO timezone VALUES("35","AEST","15028905600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15045235200","39600","1");
INSERT INTO timezone VALUES("35","AEST","15060960000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15076684800","39600","1");
INSERT INTO timezone VALUES("35","AEST","15092409600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15108134400","39600","1");
INSERT INTO timezone VALUES("35","AEST","15123859200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15139584000","39600","1");
INSERT INTO timezone VALUES("35","AEST","15155308800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15171033600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15186758400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15202483200","39600","1");
INSERT INTO timezone VALUES("35","AEST","15218812800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15234537600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15250262400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15265987200","39600","1");
INSERT INTO timezone VALUES("35","AEST","15281712000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15297436800","39600","1");
INSERT INTO timezone VALUES("35","AEST","15313161600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15328886400","39600","1");
INSERT INTO timezone VALUES("35","AEST","15344611200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15360336000","39600","1");
INSERT INTO timezone VALUES("35","AEST","15376060800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15392390400","39600","1");
INSERT INTO timezone VALUES("35","AEST","15408115200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15423840000","39600","1");
INSERT INTO timezone VALUES("35","AEST","15439564800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15455289600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15471014400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15486739200","39600","1");
INSERT INTO timezone VALUES("35","AEST","15502464000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15518188800","39600","1");
INSERT INTO timezone VALUES("35","AEST","15533913600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15549638400","39600","1");
INSERT INTO timezone VALUES("35","AEST","15565363200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15581692800","39600","1");
INSERT INTO timezone VALUES("35","AEST","15597417600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15613142400","39600","1");
INSERT INTO timezone VALUES("35","AEST","15628867200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15644592000","39600","1");
INSERT INTO timezone VALUES("35","AEST","15660316800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15676041600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15691766400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15707491200","39600","1");
INSERT INTO timezone VALUES("35","AEST","15723216000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15739545600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15755270400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15770995200","39600","1");
INSERT INTO timezone VALUES("35","AEST","15786720000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15802444800","39600","1");
INSERT INTO timezone VALUES("35","AEST","15818169600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15833894400","39600","1");
INSERT INTO timezone VALUES("35","AEST","15849619200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15865344000","39600","1");
INSERT INTO timezone VALUES("35","AEST","15881068800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15896793600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15912518400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15928848000","39600","1");
INSERT INTO timezone VALUES("35","AEST","15944572800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15960297600","39600","1");
INSERT INTO timezone VALUES("35","AEST","15976022400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","15991747200","39600","1");
INSERT INTO timezone VALUES("35","AEST","16007472000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16023196800","39600","1");
INSERT INTO timezone VALUES("35","AEST","16038921600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16054646400","39600","1");
INSERT INTO timezone VALUES("35","AEST","16070371200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16086096000","39600","1");
INSERT INTO timezone VALUES("35","AEST","16102425600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16118150400","39600","1");
INSERT INTO timezone VALUES("35","AEST","16133875200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16149600000","39600","1");
INSERT INTO timezone VALUES("35","AEST","16165324800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16181049600","39600","1");
INSERT INTO timezone VALUES("35","AEST","16196774400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16212499200","39600","1");
INSERT INTO timezone VALUES("35","AEST","16228224000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16243948800","39600","1");
INSERT INTO timezone VALUES("35","AEST","16259673600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16276003200","39600","1");
INSERT INTO timezone VALUES("35","AEST","16291728000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16307452800","39600","1");
INSERT INTO timezone VALUES("35","AEST","16323177600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16338902400","39600","1");
INSERT INTO timezone VALUES("35","AEST","16354627200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16370352000","39600","1");
INSERT INTO timezone VALUES("35","AEST","16386076800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16401801600","39600","1");
INSERT INTO timezone VALUES("35","AEST","16417526400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16433251200","39600","1");
INSERT INTO timezone VALUES("35","AEST","16448976000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16465305600","39600","1");
INSERT INTO timezone VALUES("35","AEST","16481030400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16496755200","39600","1");
INSERT INTO timezone VALUES("35","AEST","16512480000","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16528204800","39600","1");
INSERT INTO timezone VALUES("35","AEST","16543929600","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16559654400","39600","1");
INSERT INTO timezone VALUES("35","AEST","16575379200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16591104000","39600","1");
INSERT INTO timezone VALUES("35","AEST","16606828800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16623158400","39600","1");
INSERT INTO timezone VALUES("35","AEST","16638883200","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16654608000","39600","1");
INSERT INTO timezone VALUES("35","AEST","16670332800","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16686057600","39600","1");
INSERT INTO timezone VALUES("35","AEST","16701782400","36000","0");
INSERT INTO timezone VALUES("35","AEDT","16717507200","39600","1");
INSERT INTO timezone VALUES("36","LMT","-2345794529","34528","0");
INSERT INTO timezone VALUES("36","AEST","-2345794528","36000","0");
INSERT INTO timezone VALUES("36","AEDT","-1680508800","39600","1");
INSERT INTO timezone VALUES("36","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","-883641600","39600","1");
INSERT INTO timezone VALUES("36","AEST","-876128400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","-860400000","39600","1");
INSERT INTO timezone VALUES("36","AEST","-844678800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","-828345600","39600","1");
INSERT INTO timezone VALUES("36","AEST","-813229200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("36","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","89136000","39600","1");
INSERT INTO timezone VALUES("36","AEST","100022400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","120585600","39600","1");
INSERT INTO timezone VALUES("36","AEST","131472000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","152035200","39600","1");
INSERT INTO timezone VALUES("36","AEST","162921600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","183484800","39600","1");
INSERT INTO timezone VALUES("36","AEST","194976000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","215539200","39600","1");
INSERT INTO timezone VALUES("36","AEST","226425600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","246988800","39600","1");
INSERT INTO timezone VALUES("36","AEST","257875200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","278438400","39600","1");
INSERT INTO timezone VALUES("36","AEST","289324800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","309888000","39600","1");
INSERT INTO timezone VALUES("36","AEST","320774400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","341337600","39600","1");
INSERT INTO timezone VALUES("36","AEST","352224000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","372787200","39600","1");
INSERT INTO timezone VALUES("36","AEST","386092800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","404841600","39600","1");
INSERT INTO timezone VALUES("36","AEST","417542400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","436291200","39600","1");
INSERT INTO timezone VALUES("36","AEST","447177600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","467740800","39600","1");
INSERT INTO timezone VALUES("36","AEST","478627200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","499190400","39600","1");
INSERT INTO timezone VALUES("36","AEST","510076800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","530035200","39600","1");
INSERT INTO timezone VALUES("36","AEST","542736000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","562089600","39600","1");
INSERT INTO timezone VALUES("36","AEST","574790400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","594144000","39600","1");
INSERT INTO timezone VALUES("36","AEST","606240000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("36","AEST","637689600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("36","AEST","670348800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","686678400","39600","1");
INSERT INTO timezone VALUES("36","AEST","701798400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","718128000","39600","1");
INSERT INTO timezone VALUES("36","AEST","733248000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","749577600","39600","1");
INSERT INTO timezone VALUES("36","AEST","764697600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","781027200","39600","1");
INSERT INTO timezone VALUES("36","AEST","796147200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","812476800","39600","1");
INSERT INTO timezone VALUES("36","AEST","828201600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","844531200","39600","1");
INSERT INTO timezone VALUES("36","AEST","859651200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","875980800","39600","1");
INSERT INTO timezone VALUES("36","AEST","891100800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","907430400","39600","1");
INSERT INTO timezone VALUES("36","AEST","922550400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","938880000","39600","1");
INSERT INTO timezone VALUES("36","AEST","954000000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","967305600","39600","1");
INSERT INTO timezone VALUES("36","AEST","985449600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1002384000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1017504000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1033833600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1048953600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1065283200","39600","1");
INSERT INTO timezone VALUES("36","AEST","1080403200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1096732800","39600","1");
INSERT INTO timezone VALUES("36","AEST","1111852800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1128182400","39600","1");
INSERT INTO timezone VALUES("36","AEST","1143907200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1159632000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1174752000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1191686400","39600","1");
INSERT INTO timezone VALUES("36","AEST","1207411200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1223136000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1238860800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1254585600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1270310400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1286035200","39600","1");
INSERT INTO timezone VALUES("36","AEST","1301760000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1317484800","39600","1");
INSERT INTO timezone VALUES("36","AEST","1333209600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1349539200","39600","1");
INSERT INTO timezone VALUES("36","AEST","1365264000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1380988800","39600","1");
INSERT INTO timezone VALUES("36","AEST","1396713600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1412438400","39600","1");
INSERT INTO timezone VALUES("36","AEST","1428163200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1443888000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1459612800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1475337600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1491062400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1506787200","39600","1");
INSERT INTO timezone VALUES("36","AEST","1522512000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1538841600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1554566400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1570291200","39600","1");
INSERT INTO timezone VALUES("36","AEST","1586016000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1601740800","39600","1");
INSERT INTO timezone VALUES("36","AEST","1617465600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1633190400","39600","1");
INSERT INTO timezone VALUES("36","AEST","1648915200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1664640000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1680364800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1696089600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1712419200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1728144000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1743868800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1759593600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1775318400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1791043200","39600","1");
INSERT INTO timezone VALUES("36","AEST","1806768000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1822492800","39600","1");
INSERT INTO timezone VALUES("36","AEST","1838217600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1853942400","39600","1");
INSERT INTO timezone VALUES("36","AEST","1869667200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1885996800","39600","1");
INSERT INTO timezone VALUES("36","AEST","1901721600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1917446400","39600","1");
INSERT INTO timezone VALUES("36","AEST","1933171200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1948896000","39600","1");
INSERT INTO timezone VALUES("36","AEST","1964620800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","1980345600","39600","1");
INSERT INTO timezone VALUES("36","AEST","1996070400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2011795200","39600","1");
INSERT INTO timezone VALUES("36","AEST","2027520000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2043244800","39600","1");
INSERT INTO timezone VALUES("36","AEST","2058969600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2075299200","39600","1");
INSERT INTO timezone VALUES("36","AEST","2091024000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2106748800","39600","1");
INSERT INTO timezone VALUES("36","AEST","2122473600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2138198400","39600","1");
INSERT INTO timezone VALUES("36","AEST","2153923200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2169648000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2185372800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2201097600","39600","1");
INSERT INTO timezone VALUES("36","AEST","2216822400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2233152000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2248876800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2264601600","39600","1");
INSERT INTO timezone VALUES("36","AEST","2280326400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2296051200","39600","1");
INSERT INTO timezone VALUES("36","AEST","2311776000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2327500800","39600","1");
INSERT INTO timezone VALUES("36","AEST","2343225600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2358950400","39600","1");
INSERT INTO timezone VALUES("36","AEST","2374675200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2390400000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2406124800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2422454400","39600","1");
INSERT INTO timezone VALUES("36","AEST","2438179200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2453904000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2469628800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2485353600","39600","1");
INSERT INTO timezone VALUES("36","AEST","2501078400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2516803200","39600","1");
INSERT INTO timezone VALUES("36","AEST","2532528000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2548252800","39600","1");
INSERT INTO timezone VALUES("36","AEST","2563977600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2579702400","39600","1");
INSERT INTO timezone VALUES("36","AEST","2596032000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2611756800","39600","1");
INSERT INTO timezone VALUES("36","AEST","2627481600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2643206400","39600","1");
INSERT INTO timezone VALUES("36","AEST","2658931200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2674656000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2690380800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2706105600","39600","1");
INSERT INTO timezone VALUES("36","AEST","2721830400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2737555200","39600","1");
INSERT INTO timezone VALUES("36","AEST","2753280000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2769609600","39600","1");
INSERT INTO timezone VALUES("36","AEST","2785334400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2801059200","39600","1");
INSERT INTO timezone VALUES("36","AEST","2816784000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2832508800","39600","1");
INSERT INTO timezone VALUES("36","AEST","2848233600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2863958400","39600","1");
INSERT INTO timezone VALUES("36","AEST","2879683200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2895408000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2911132800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2926857600","39600","1");
INSERT INTO timezone VALUES("36","AEST","2942582400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2958912000","39600","1");
INSERT INTO timezone VALUES("36","AEST","2974636800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","2990361600","39600","1");
INSERT INTO timezone VALUES("36","AEST","3006086400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3021811200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3037536000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3053260800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3068985600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3084710400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3100435200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3116764800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3132489600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3148214400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3163939200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3179664000","39600","1");
INSERT INTO timezone VALUES("36","AEST","3195388800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3211113600","39600","1");
INSERT INTO timezone VALUES("36","AEST","3226838400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3242563200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3258288000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3274012800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3289737600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3306067200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3321792000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3337516800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3353241600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3368966400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3384691200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3400416000","39600","1");
INSERT INTO timezone VALUES("36","AEST","3416140800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3431865600","39600","1");
INSERT INTO timezone VALUES("36","AEST","3447590400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3463315200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3479644800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3495369600","39600","1");
INSERT INTO timezone VALUES("36","AEST","3511094400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3526819200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3542544000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3558268800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3573993600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3589718400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3605443200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3621168000","39600","1");
INSERT INTO timezone VALUES("36","AEST","3636892800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3653222400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3668947200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3684672000","39600","1");
INSERT INTO timezone VALUES("36","AEST","3700396800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3716121600","39600","1");
INSERT INTO timezone VALUES("36","AEST","3731846400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3747571200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3763296000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3779020800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3794745600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3810470400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3826195200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3842524800","39600","1");
INSERT INTO timezone VALUES("36","AEST","3858249600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3873974400","39600","1");
INSERT INTO timezone VALUES("36","AEST","3889699200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3905424000","39600","1");
INSERT INTO timezone VALUES("36","AEST","3921148800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3936873600","39600","1");
INSERT INTO timezone VALUES("36","AEST","3952598400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","3968323200","39600","1");
INSERT INTO timezone VALUES("36","AEST","3984048000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4000377600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4016102400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4031827200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4047552000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4063276800","39600","1");
INSERT INTO timezone VALUES("36","AEST","4079001600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4094726400","39600","1");
INSERT INTO timezone VALUES("36","AEST","4110451200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4126176000","39600","1");
INSERT INTO timezone VALUES("36","AEST","4141900800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4157625600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4173350400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4189075200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4204800000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4221129600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4236854400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4252579200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4268304000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4284028800","39600","1");
INSERT INTO timezone VALUES("36","AEST","4299753600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4315478400","39600","1");
INSERT INTO timezone VALUES("36","AEST","4331203200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4346928000","39600","1");
INSERT INTO timezone VALUES("36","AEST","4362652800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4378982400","39600","1");
INSERT INTO timezone VALUES("36","AEST","4394707200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4410432000","39600","1");
INSERT INTO timezone VALUES("36","AEST","4426156800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4441881600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4457606400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4473331200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4489056000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4504780800","39600","1");
INSERT INTO timezone VALUES("36","AEST","4520505600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4536230400","39600","1");
INSERT INTO timezone VALUES("36","AEST","4551955200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4568284800","39600","1");
INSERT INTO timezone VALUES("36","AEST","4584009600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4599734400","39600","1");
INSERT INTO timezone VALUES("36","AEST","4615459200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4631184000","39600","1");
INSERT INTO timezone VALUES("36","AEST","4646908800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4662633600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4678358400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4694083200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4709808000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4725532800","39600","1");
INSERT INTO timezone VALUES("36","AEST","4741862400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4757587200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4773312000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4789036800","39600","1");
INSERT INTO timezone VALUES("36","AEST","4804761600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4820486400","39600","1");
INSERT INTO timezone VALUES("36","AEST","4836211200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4851936000","39600","1");
INSERT INTO timezone VALUES("36","AEST","4867660800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4883385600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4899110400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4915440000","39600","1");
INSERT INTO timezone VALUES("36","AEST","4931164800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4946889600","39600","1");
INSERT INTO timezone VALUES("36","AEST","4962614400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","4978339200","39600","1");
INSERT INTO timezone VALUES("36","AEST","4994064000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5009788800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5025513600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5041238400","39600","1");
INSERT INTO timezone VALUES("36","AEST","5056963200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5072688000","39600","1");
INSERT INTO timezone VALUES("36","AEST","5088412800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5104742400","39600","1");
INSERT INTO timezone VALUES("36","AEST","5120467200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5136192000","39600","1");
INSERT INTO timezone VALUES("36","AEST","5151916800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5167641600","39600","1");
INSERT INTO timezone VALUES("36","AEST","5183366400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5199091200","39600","1");
INSERT INTO timezone VALUES("36","AEST","5214816000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5230540800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5246265600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5262595200","39600","1");
INSERT INTO timezone VALUES("36","AEST","5278320000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5294044800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5309769600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5325494400","39600","1");
INSERT INTO timezone VALUES("36","AEST","5341219200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5356944000","39600","1");
INSERT INTO timezone VALUES("36","AEST","5372668800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5388393600","39600","1");
INSERT INTO timezone VALUES("36","AEST","5404118400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5419843200","39600","1");
INSERT INTO timezone VALUES("36","AEST","5435568000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5451897600","39600","1");
INSERT INTO timezone VALUES("36","AEST","5467622400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5483347200","39600","1");
INSERT INTO timezone VALUES("36","AEST","5499072000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5514796800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5530521600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5546246400","39600","1");
INSERT INTO timezone VALUES("36","AEST","5561971200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5577696000","39600","1");
INSERT INTO timezone VALUES("36","AEST","5593420800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5609145600","39600","1");
INSERT INTO timezone VALUES("36","AEST","5625475200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5641200000","39600","1");
INSERT INTO timezone VALUES("36","AEST","5656924800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5672649600","39600","1");
INSERT INTO timezone VALUES("36","AEST","5688374400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5704099200","39600","1");
INSERT INTO timezone VALUES("36","AEST","5719824000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5735548800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5751273600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5766998400","39600","1");
INSERT INTO timezone VALUES("36","AEST","5782723200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5799052800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5814777600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5830502400","39600","1");
INSERT INTO timezone VALUES("36","AEST","5846227200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5861952000","39600","1");
INSERT INTO timezone VALUES("36","AEST","5877676800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5893401600","39600","1");
INSERT INTO timezone VALUES("36","AEST","5909126400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5924851200","39600","1");
INSERT INTO timezone VALUES("36","AEST","5940576000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5956300800","39600","1");
INSERT INTO timezone VALUES("36","AEST","5972025600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","5988355200","39600","1");
INSERT INTO timezone VALUES("36","AEST","6004080000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6019804800","39600","1");
INSERT INTO timezone VALUES("36","AEST","6035529600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6051254400","39600","1");
INSERT INTO timezone VALUES("36","AEST","6066979200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6082704000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6098428800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6114153600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6129878400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6146208000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6161932800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6177657600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6193382400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6209107200","39600","1");
INSERT INTO timezone VALUES("36","AEST","6224832000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6240556800","39600","1");
INSERT INTO timezone VALUES("36","AEST","6256281600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6272006400","39600","1");
INSERT INTO timezone VALUES("36","AEST","6287731200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6303456000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6319180800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6335510400","39600","1");
INSERT INTO timezone VALUES("36","AEST","6351235200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6366960000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6382684800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6398409600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6414134400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6429859200","39600","1");
INSERT INTO timezone VALUES("36","AEST","6445584000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6461308800","39600","1");
INSERT INTO timezone VALUES("36","AEST","6477033600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6492758400","39600","1");
INSERT INTO timezone VALUES("36","AEST","6509088000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6524812800","39600","1");
INSERT INTO timezone VALUES("36","AEST","6540537600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6556262400","39600","1");
INSERT INTO timezone VALUES("36","AEST","6571987200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6587712000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6603436800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6619161600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6634886400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6650611200","39600","1");
INSERT INTO timezone VALUES("36","AEST","6666336000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6682665600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6698390400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6714115200","39600","1");
INSERT INTO timezone VALUES("36","AEST","6729840000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6745564800","39600","1");
INSERT INTO timezone VALUES("36","AEST","6761289600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6777014400","39600","1");
INSERT INTO timezone VALUES("36","AEST","6792739200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6808464000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6824188800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6839913600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6855638400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6871968000","39600","1");
INSERT INTO timezone VALUES("36","AEST","6887692800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6903417600","39600","1");
INSERT INTO timezone VALUES("36","AEST","6919142400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6934867200","39600","1");
INSERT INTO timezone VALUES("36","AEST","6950592000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6966316800","39600","1");
INSERT INTO timezone VALUES("36","AEST","6982041600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","6997766400","39600","1");
INSERT INTO timezone VALUES("36","AEST","7013491200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7029820800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7045545600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7061270400","39600","1");
INSERT INTO timezone VALUES("36","AEST","7076995200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7092720000","39600","1");
INSERT INTO timezone VALUES("36","AEST","7108444800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7124169600","39600","1");
INSERT INTO timezone VALUES("36","AEST","7139894400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7155619200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7171344000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7187068800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7202793600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7219123200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7234848000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7250572800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7266297600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7282022400","39600","1");
INSERT INTO timezone VALUES("36","AEST","7297747200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7313472000","39600","1");
INSERT INTO timezone VALUES("36","AEST","7329196800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7344921600","39600","1");
INSERT INTO timezone VALUES("36","AEST","7360646400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7376371200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7392096000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7408425600","39600","1");
INSERT INTO timezone VALUES("36","AEST","7424150400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7439875200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7455600000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7471324800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7487049600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7502774400","39600","1");
INSERT INTO timezone VALUES("36","AEST","7518499200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7534224000","39600","1");
INSERT INTO timezone VALUES("36","AEST","7549948800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7565673600","39600","1");
INSERT INTO timezone VALUES("36","AEST","7581398400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7597728000","39600","1");
INSERT INTO timezone VALUES("36","AEST","7613452800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7629177600","39600","1");
INSERT INTO timezone VALUES("36","AEST","7644902400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7660627200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7676352000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7692076800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7707801600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7723526400","39600","1");
INSERT INTO timezone VALUES("36","AEST","7739251200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7754976000","39600","1");
INSERT INTO timezone VALUES("36","AEST","7771305600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7787030400","39600","1");
INSERT INTO timezone VALUES("36","AEST","7802755200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7818480000","39600","1");
INSERT INTO timezone VALUES("36","AEST","7834204800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7849929600","39600","1");
INSERT INTO timezone VALUES("36","AEST","7865654400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7881379200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7897104000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7912828800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7928553600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7944883200","39600","1");
INSERT INTO timezone VALUES("36","AEST","7960608000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","7976332800","39600","1");
INSERT INTO timezone VALUES("36","AEST","7992057600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8007782400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8023507200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8039232000","39600","1");
INSERT INTO timezone VALUES("36","AEST","8054956800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8070681600","39600","1");
INSERT INTO timezone VALUES("36","AEST","8086406400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8102131200","39600","1");
INSERT INTO timezone VALUES("36","AEST","8117856000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8134185600","39600","1");
INSERT INTO timezone VALUES("36","AEST","8149910400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8165635200","39600","1");
INSERT INTO timezone VALUES("36","AEST","8181360000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8197084800","39600","1");
INSERT INTO timezone VALUES("36","AEST","8212809600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8228534400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8244259200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8259984000","39600","1");
INSERT INTO timezone VALUES("36","AEST","8275708800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8292038400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8307763200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8323488000","39600","1");
INSERT INTO timezone VALUES("36","AEST","8339212800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8354937600","39600","1");
INSERT INTO timezone VALUES("36","AEST","8370662400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8386387200","39600","1");
INSERT INTO timezone VALUES("36","AEST","8402112000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8417836800","39600","1");
INSERT INTO timezone VALUES("36","AEST","8433561600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8449286400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8465011200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8481340800","39600","1");
INSERT INTO timezone VALUES("36","AEST","8497065600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8512790400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8528515200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8544240000","39600","1");
INSERT INTO timezone VALUES("36","AEST","8559964800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8575689600","39600","1");
INSERT INTO timezone VALUES("36","AEST","8591414400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8607139200","39600","1");
INSERT INTO timezone VALUES("36","AEST","8622864000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8638588800","39600","1");
INSERT INTO timezone VALUES("36","AEST","8654918400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8670643200","39600","1");
INSERT INTO timezone VALUES("36","AEST","8686368000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8702092800","39600","1");
INSERT INTO timezone VALUES("36","AEST","8717817600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8733542400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8749267200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8764992000","39600","1");
INSERT INTO timezone VALUES("36","AEST","8780716800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8796441600","39600","1");
INSERT INTO timezone VALUES("36","AEST","8812166400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8828496000","39600","1");
INSERT INTO timezone VALUES("36","AEST","8844220800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8859945600","39600","1");
INSERT INTO timezone VALUES("36","AEST","8875670400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8891395200","39600","1");
INSERT INTO timezone VALUES("36","AEST","8907120000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8922844800","39600","1");
INSERT INTO timezone VALUES("36","AEST","8938569600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8954294400","39600","1");
INSERT INTO timezone VALUES("36","AEST","8970019200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","8985744000","39600","1");
INSERT INTO timezone VALUES("36","AEST","9001468800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9017798400","39600","1");
INSERT INTO timezone VALUES("36","AEST","9033523200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9049248000","39600","1");
INSERT INTO timezone VALUES("36","AEST","9064972800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9080697600","39600","1");
INSERT INTO timezone VALUES("36","AEST","9096422400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9112147200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9127872000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9143596800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9159321600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9175651200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9191376000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9207100800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9222825600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9238550400","39600","1");
INSERT INTO timezone VALUES("36","AEST","9254275200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9270000000","39600","1");
INSERT INTO timezone VALUES("36","AEST","9285724800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9301449600","39600","1");
INSERT INTO timezone VALUES("36","AEST","9317174400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9332899200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9348624000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9364953600","39600","1");
INSERT INTO timezone VALUES("36","AEST","9380678400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9396403200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9412128000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9427852800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9443577600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9459302400","39600","1");
INSERT INTO timezone VALUES("36","AEST","9475027200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9490752000","39600","1");
INSERT INTO timezone VALUES("36","AEST","9506476800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9522201600","39600","1");
INSERT INTO timezone VALUES("36","AEST","9538531200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9554256000","39600","1");
INSERT INTO timezone VALUES("36","AEST","9569980800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9585705600","39600","1");
INSERT INTO timezone VALUES("36","AEST","9601430400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9617155200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9632880000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9648604800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9664329600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9680054400","39600","1");
INSERT INTO timezone VALUES("36","AEST","9695779200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9712108800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9727833600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9743558400","39600","1");
INSERT INTO timezone VALUES("36","AEST","9759283200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9775008000","39600","1");
INSERT INTO timezone VALUES("36","AEST","9790732800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9806457600","39600","1");
INSERT INTO timezone VALUES("36","AEST","9822182400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9837907200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9853632000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9869356800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9885081600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9901411200","39600","1");
INSERT INTO timezone VALUES("36","AEST","9917136000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9932860800","39600","1");
INSERT INTO timezone VALUES("36","AEST","9948585600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9964310400","39600","1");
INSERT INTO timezone VALUES("36","AEST","9980035200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","9995760000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10011484800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10027209600","39600","1");
INSERT INTO timezone VALUES("36","AEST","10042934400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10059264000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10074988800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10090713600","39600","1");
INSERT INTO timezone VALUES("36","AEST","10106438400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10122163200","39600","1");
INSERT INTO timezone VALUES("36","AEST","10137888000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10153612800","39600","1");
INSERT INTO timezone VALUES("36","AEST","10169337600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10185062400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10200787200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10216512000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10232236800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10248566400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10264291200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10280016000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10295740800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10311465600","39600","1");
INSERT INTO timezone VALUES("36","AEST","10327190400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10342915200","39600","1");
INSERT INTO timezone VALUES("36","AEST","10358640000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10374364800","39600","1");
INSERT INTO timezone VALUES("36","AEST","10390089600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10405814400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10421539200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10437868800","39600","1");
INSERT INTO timezone VALUES("36","AEST","10453593600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10469318400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10485043200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10500768000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10516492800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10532217600","39600","1");
INSERT INTO timezone VALUES("36","AEST","10547942400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10563667200","39600","1");
INSERT INTO timezone VALUES("36","AEST","10579392000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10595116800","39600","1");
INSERT INTO timezone VALUES("36","AEST","10610841600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10627171200","39600","1");
INSERT INTO timezone VALUES("36","AEST","10642896000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10658620800","39600","1");
INSERT INTO timezone VALUES("36","AEST","10674345600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10690070400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10705795200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10721520000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10737244800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10752969600","39600","1");
INSERT INTO timezone VALUES("36","AEST","10768694400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10784419200","39600","1");
INSERT INTO timezone VALUES("36","AEST","10800748800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10816473600","39600","1");
INSERT INTO timezone VALUES("36","AEST","10832198400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10847923200","39600","1");
INSERT INTO timezone VALUES("36","AEST","10863648000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10879372800","39600","1");
INSERT INTO timezone VALUES("36","AEST","10895097600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10910822400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10926547200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10942272000","39600","1");
INSERT INTO timezone VALUES("36","AEST","10957996800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","10974326400","39600","1");
INSERT INTO timezone VALUES("36","AEST","10990051200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11005776000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11021500800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11037225600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11052950400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11068675200","39600","1");
INSERT INTO timezone VALUES("36","AEST","11084400000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11100124800","39600","1");
INSERT INTO timezone VALUES("36","AEST","11115849600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11131574400","39600","1");
INSERT INTO timezone VALUES("36","AEST","11147299200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11163628800","39600","1");
INSERT INTO timezone VALUES("36","AEST","11179353600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11195078400","39600","1");
INSERT INTO timezone VALUES("36","AEST","11210803200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11226528000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11242252800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11257977600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11273702400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11289427200","39600","1");
INSERT INTO timezone VALUES("36","AEST","11305152000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11321481600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11337206400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11352931200","39600","1");
INSERT INTO timezone VALUES("36","AEST","11368656000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11384380800","39600","1");
INSERT INTO timezone VALUES("36","AEST","11400105600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11415830400","39600","1");
INSERT INTO timezone VALUES("36","AEST","11431555200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11447280000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11463004800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11478729600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11494454400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11510784000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11526508800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11542233600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11557958400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11573683200","39600","1");
INSERT INTO timezone VALUES("36","AEST","11589408000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11605132800","39600","1");
INSERT INTO timezone VALUES("36","AEST","11620857600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11636582400","39600","1");
INSERT INTO timezone VALUES("36","AEST","11652307200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11668032000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11684361600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11700086400","39600","1");
INSERT INTO timezone VALUES("36","AEST","11715811200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11731536000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11747260800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11762985600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11778710400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11794435200","39600","1");
INSERT INTO timezone VALUES("36","AEST","11810160000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11825884800","39600","1");
INSERT INTO timezone VALUES("36","AEST","11841609600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11857939200","39600","1");
INSERT INTO timezone VALUES("36","AEST","11873664000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11889388800","39600","1");
INSERT INTO timezone VALUES("36","AEST","11905113600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11920838400","39600","1");
INSERT INTO timezone VALUES("36","AEST","11936563200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11952288000","39600","1");
INSERT INTO timezone VALUES("36","AEST","11968012800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","11983737600","39600","1");
INSERT INTO timezone VALUES("36","AEST","11999462400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12015187200","39600","1");
INSERT INTO timezone VALUES("36","AEST","12030912000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12047241600","39600","1");
INSERT INTO timezone VALUES("36","AEST","12062966400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12078691200","39600","1");
INSERT INTO timezone VALUES("36","AEST","12094416000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12110140800","39600","1");
INSERT INTO timezone VALUES("36","AEST","12125865600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12141590400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12157315200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12173040000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12188764800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12205094400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12220819200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12236544000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12252268800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12267993600","39600","1");
INSERT INTO timezone VALUES("36","AEST","12283718400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12299443200","39600","1");
INSERT INTO timezone VALUES("36","AEST","12315168000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12330892800","39600","1");
INSERT INTO timezone VALUES("36","AEST","12346617600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12362342400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12378067200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12394396800","39600","1");
INSERT INTO timezone VALUES("36","AEST","12410121600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12425846400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12441571200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12457296000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12473020800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12488745600","39600","1");
INSERT INTO timezone VALUES("36","AEST","12504470400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12520195200","39600","1");
INSERT INTO timezone VALUES("36","AEST","12535920000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12551644800","39600","1");
INSERT INTO timezone VALUES("36","AEST","12567974400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12583699200","39600","1");
INSERT INTO timezone VALUES("36","AEST","12599424000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12615148800","39600","1");
INSERT INTO timezone VALUES("36","AEST","12630873600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12646598400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12662323200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12678048000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12693772800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12709497600","39600","1");
INSERT INTO timezone VALUES("36","AEST","12725222400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12741552000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12757276800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12773001600","39600","1");
INSERT INTO timezone VALUES("36","AEST","12788726400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12804451200","39600","1");
INSERT INTO timezone VALUES("36","AEST","12820176000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12835900800","39600","1");
INSERT INTO timezone VALUES("36","AEST","12851625600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12867350400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12883075200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12898800000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12914524800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12930854400","39600","1");
INSERT INTO timezone VALUES("36","AEST","12946579200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12962304000","39600","1");
INSERT INTO timezone VALUES("36","AEST","12978028800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","12993753600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13009478400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13025203200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13040928000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13056652800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13072377600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13088707200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13104432000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13120156800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13135881600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13151606400","39600","1");
INSERT INTO timezone VALUES("36","AEST","13167331200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13183056000","39600","1");
INSERT INTO timezone VALUES("36","AEST","13198780800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13214505600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13230230400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13245955200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13261680000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13278009600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13293734400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13309459200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13325184000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13340908800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13356633600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13372358400","39600","1");
INSERT INTO timezone VALUES("36","AEST","13388083200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13403808000","39600","1");
INSERT INTO timezone VALUES("36","AEST","13419532800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13435257600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13451587200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13467312000","39600","1");
INSERT INTO timezone VALUES("36","AEST","13483036800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13498761600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13514486400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13530211200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13545936000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13561660800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13577385600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13593110400","39600","1");
INSERT INTO timezone VALUES("36","AEST","13608835200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13625164800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13640889600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13656614400","39600","1");
INSERT INTO timezone VALUES("36","AEST","13672339200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13688064000","39600","1");
INSERT INTO timezone VALUES("36","AEST","13703788800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13719513600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13735238400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13750963200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13766688000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13782412800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13798137600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13814467200","39600","1");
INSERT INTO timezone VALUES("36","AEST","13830192000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13845916800","39600","1");
INSERT INTO timezone VALUES("36","AEST","13861641600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13877366400","39600","1");
INSERT INTO timezone VALUES("36","AEST","13893091200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13908816000","39600","1");
INSERT INTO timezone VALUES("36","AEST","13924540800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13940265600","39600","1");
INSERT INTO timezone VALUES("36","AEST","13955990400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","13972320000","39600","1");
INSERT INTO timezone VALUES("36","AEST","13988044800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14003769600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14019494400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14035219200","39600","1");
INSERT INTO timezone VALUES("36","AEST","14050944000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14066668800","39600","1");
INSERT INTO timezone VALUES("36","AEST","14082393600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14098118400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14113843200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14129568000","39600","1");
INSERT INTO timezone VALUES("36","AEST","14145292800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14161622400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14177347200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14193072000","39600","1");
INSERT INTO timezone VALUES("36","AEST","14208796800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14224521600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14240246400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14255971200","39600","1");
INSERT INTO timezone VALUES("36","AEST","14271696000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14287420800","39600","1");
INSERT INTO timezone VALUES("36","AEST","14303145600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14318870400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14335200000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14350924800","39600","1");
INSERT INTO timezone VALUES("36","AEST","14366649600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14382374400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14398099200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14413824000","39600","1");
INSERT INTO timezone VALUES("36","AEST","14429548800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14445273600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14460998400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14476723200","39600","1");
INSERT INTO timezone VALUES("36","AEST","14492448000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14508777600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14524502400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14540227200","39600","1");
INSERT INTO timezone VALUES("36","AEST","14555952000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14571676800","39600","1");
INSERT INTO timezone VALUES("36","AEST","14587401600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14603126400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14618851200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14634576000","39600","1");
INSERT INTO timezone VALUES("36","AEST","14650300800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14666025600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14681750400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14698080000","39600","1");
INSERT INTO timezone VALUES("36","AEST","14713804800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14729529600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14745254400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14760979200","39600","1");
INSERT INTO timezone VALUES("36","AEST","14776704000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14792428800","39600","1");
INSERT INTO timezone VALUES("36","AEST","14808153600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14823878400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14839603200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14855932800","39600","1");
INSERT INTO timezone VALUES("36","AEST","14871657600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14887382400","39600","1");
INSERT INTO timezone VALUES("36","AEST","14903107200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14918832000","39600","1");
INSERT INTO timezone VALUES("36","AEST","14934556800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14950281600","39600","1");
INSERT INTO timezone VALUES("36","AEST","14966006400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","14981731200","39600","1");
INSERT INTO timezone VALUES("36","AEST","14997456000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15013180800","39600","1");
INSERT INTO timezone VALUES("36","AEST","15028905600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15045235200","39600","1");
INSERT INTO timezone VALUES("36","AEST","15060960000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15076684800","39600","1");
INSERT INTO timezone VALUES("36","AEST","15092409600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15108134400","39600","1");
INSERT INTO timezone VALUES("36","AEST","15123859200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15139584000","39600","1");
INSERT INTO timezone VALUES("36","AEST","15155308800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15171033600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15186758400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15202483200","39600","1");
INSERT INTO timezone VALUES("36","AEST","15218812800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15234537600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15250262400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15265987200","39600","1");
INSERT INTO timezone VALUES("36","AEST","15281712000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15297436800","39600","1");
INSERT INTO timezone VALUES("36","AEST","15313161600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15328886400","39600","1");
INSERT INTO timezone VALUES("36","AEST","15344611200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15360336000","39600","1");
INSERT INTO timezone VALUES("36","AEST","15376060800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15392390400","39600","1");
INSERT INTO timezone VALUES("36","AEST","15408115200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15423840000","39600","1");
INSERT INTO timezone VALUES("36","AEST","15439564800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15455289600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15471014400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15486739200","39600","1");
INSERT INTO timezone VALUES("36","AEST","15502464000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15518188800","39600","1");
INSERT INTO timezone VALUES("36","AEST","15533913600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15549638400","39600","1");
INSERT INTO timezone VALUES("36","AEST","15565363200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15581692800","39600","1");
INSERT INTO timezone VALUES("36","AEST","15597417600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15613142400","39600","1");
INSERT INTO timezone VALUES("36","AEST","15628867200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15644592000","39600","1");
INSERT INTO timezone VALUES("36","AEST","15660316800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15676041600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15691766400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15707491200","39600","1");
INSERT INTO timezone VALUES("36","AEST","15723216000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15739545600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15755270400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15770995200","39600","1");
INSERT INTO timezone VALUES("36","AEST","15786720000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15802444800","39600","1");
INSERT INTO timezone VALUES("36","AEST","15818169600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15833894400","39600","1");
INSERT INTO timezone VALUES("36","AEST","15849619200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15865344000","39600","1");
INSERT INTO timezone VALUES("36","AEST","15881068800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15896793600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15912518400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15928848000","39600","1");
INSERT INTO timezone VALUES("36","AEST","15944572800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15960297600","39600","1");
INSERT INTO timezone VALUES("36","AEST","15976022400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","15991747200","39600","1");
INSERT INTO timezone VALUES("36","AEST","16007472000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16023196800","39600","1");
INSERT INTO timezone VALUES("36","AEST","16038921600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16054646400","39600","1");
INSERT INTO timezone VALUES("36","AEST","16070371200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16086096000","39600","1");
INSERT INTO timezone VALUES("36","AEST","16102425600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16118150400","39600","1");
INSERT INTO timezone VALUES("36","AEST","16133875200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16149600000","39600","1");
INSERT INTO timezone VALUES("36","AEST","16165324800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16181049600","39600","1");
INSERT INTO timezone VALUES("36","AEST","16196774400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16212499200","39600","1");
INSERT INTO timezone VALUES("36","AEST","16228224000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16243948800","39600","1");
INSERT INTO timezone VALUES("36","AEST","16259673600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16276003200","39600","1");
INSERT INTO timezone VALUES("36","AEST","16291728000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16307452800","39600","1");
INSERT INTO timezone VALUES("36","AEST","16323177600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16338902400","39600","1");
INSERT INTO timezone VALUES("36","AEST","16354627200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16370352000","39600","1");
INSERT INTO timezone VALUES("36","AEST","16386076800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16401801600","39600","1");
INSERT INTO timezone VALUES("36","AEST","16417526400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16433251200","39600","1");
INSERT INTO timezone VALUES("36","AEST","16448976000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16465305600","39600","1");
INSERT INTO timezone VALUES("36","AEST","16481030400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16496755200","39600","1");
INSERT INTO timezone VALUES("36","AEST","16512480000","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16528204800","39600","1");
INSERT INTO timezone VALUES("36","AEST","16543929600","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16559654400","39600","1");
INSERT INTO timezone VALUES("36","AEST","16575379200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16591104000","39600","1");
INSERT INTO timezone VALUES("36","AEST","16606828800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16623158400","39600","1");
INSERT INTO timezone VALUES("36","AEST","16638883200","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16654608000","39600","1");
INSERT INTO timezone VALUES("36","AEST","16670332800","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16686057600","39600","1");
INSERT INTO timezone VALUES("36","AEST","16701782400","36000","0");
INSERT INTO timezone VALUES("36","AEDT","16717507200","39600","1");
INSERT INTO timezone VALUES("37","LMT","-2364111593","34792","0");
INSERT INTO timezone VALUES("37","AEST","-2364111592","36000","0");
INSERT INTO timezone VALUES("37","AEDT","-1672567140","39600","1");
INSERT INTO timezone VALUES("37","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","-883641600","39600","1");
INSERT INTO timezone VALUES("37","AEST","-876128400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","-860400000","39600","1");
INSERT INTO timezone VALUES("37","AEST","-844678800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","-828345600","39600","1");
INSERT INTO timezone VALUES("37","AEST","-813229200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("37","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","89136000","39600","1");
INSERT INTO timezone VALUES("37","AEST","100022400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","120585600","39600","1");
INSERT INTO timezone VALUES("37","AEST","131472000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","152035200","39600","1");
INSERT INTO timezone VALUES("37","AEST","162921600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","183484800","39600","1");
INSERT INTO timezone VALUES("37","AEST","194976000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","215539200","39600","1");
INSERT INTO timezone VALUES("37","AEST","226425600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","246988800","39600","1");
INSERT INTO timezone VALUES("37","AEST","257875200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","278438400","39600","1");
INSERT INTO timezone VALUES("37","AEST","289324800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","309888000","39600","1");
INSERT INTO timezone VALUES("37","AEST","320774400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","341337600","39600","1");
INSERT INTO timezone VALUES("37","AEST","352224000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","372787200","39600","1");
INSERT INTO timezone VALUES("37","AEST","384278400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","404841600","39600","1");
INSERT INTO timezone VALUES("37","AEST","415728000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","436291200","39600","1");
INSERT INTO timezone VALUES("37","AEST","447177600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","467740800","39600","1");
INSERT INTO timezone VALUES("37","AEST","478627200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","499190400","39600","1");
INSERT INTO timezone VALUES("37","AEST","511286400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","530035200","39600","1");
INSERT INTO timezone VALUES("37","AEST","542736000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","561484800","39600","1");
INSERT INTO timezone VALUES("37","AEST","574790400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","594144000","39600","1");
INSERT INTO timezone VALUES("37","AEST","606240000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("37","AEST","637689600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("37","AEST","667929600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","688492800","39600","1");
INSERT INTO timezone VALUES("37","AEST","699379200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","719942400","39600","1");
INSERT INTO timezone VALUES("37","AEST","731433600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","751996800","39600","1");
INSERT INTO timezone VALUES("37","AEST","762883200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","783446400","39600","1");
INSERT INTO timezone VALUES("37","AEST","796147200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","814896000","39600","1");
INSERT INTO timezone VALUES("37","AEST","828201600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","846345600","39600","1");
INSERT INTO timezone VALUES("37","AEST","859651200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","877795200","39600","1");
INSERT INTO timezone VALUES("37","AEST","891100800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","909244800","39600","1");
INSERT INTO timezone VALUES("37","AEST","922550400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","941299200","39600","1");
INSERT INTO timezone VALUES("37","AEST","954000000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","967305600","39600","1");
INSERT INTO timezone VALUES("37","AEST","985449600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1004198400","39600","1");
INSERT INTO timezone VALUES("37","AEST","1017504000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1035648000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1048953600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1067097600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1080403200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1099152000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1111852800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1130601600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1143907200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1162051200","39600","1");
INSERT INTO timezone VALUES("37","AEST","1174752000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1193500800","39600","1");
INSERT INTO timezone VALUES("37","AEST","1207411200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1223136000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1238860800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1254585600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1270310400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1286035200","39600","1");
INSERT INTO timezone VALUES("37","AEST","1301760000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1317484800","39600","1");
INSERT INTO timezone VALUES("37","AEST","1333209600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1349539200","39600","1");
INSERT INTO timezone VALUES("37","AEST","1365264000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1380988800","39600","1");
INSERT INTO timezone VALUES("37","AEST","1396713600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1412438400","39600","1");
INSERT INTO timezone VALUES("37","AEST","1428163200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1443888000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1459612800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1475337600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1491062400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1506787200","39600","1");
INSERT INTO timezone VALUES("37","AEST","1522512000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1538841600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1554566400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1570291200","39600","1");
INSERT INTO timezone VALUES("37","AEST","1586016000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1601740800","39600","1");
INSERT INTO timezone VALUES("37","AEST","1617465600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1633190400","39600","1");
INSERT INTO timezone VALUES("37","AEST","1648915200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1664640000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1680364800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1696089600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1712419200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1728144000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1743868800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1759593600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1775318400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1791043200","39600","1");
INSERT INTO timezone VALUES("37","AEST","1806768000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1822492800","39600","1");
INSERT INTO timezone VALUES("37","AEST","1838217600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1853942400","39600","1");
INSERT INTO timezone VALUES("37","AEST","1869667200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1885996800","39600","1");
INSERT INTO timezone VALUES("37","AEST","1901721600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1917446400","39600","1");
INSERT INTO timezone VALUES("37","AEST","1933171200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1948896000","39600","1");
INSERT INTO timezone VALUES("37","AEST","1964620800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","1980345600","39600","1");
INSERT INTO timezone VALUES("37","AEST","1996070400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2011795200","39600","1");
INSERT INTO timezone VALUES("37","AEST","2027520000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2043244800","39600","1");
INSERT INTO timezone VALUES("37","AEST","2058969600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2075299200","39600","1");
INSERT INTO timezone VALUES("37","AEST","2091024000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2106748800","39600","1");
INSERT INTO timezone VALUES("37","AEST","2122473600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2138198400","39600","1");
INSERT INTO timezone VALUES("37","AEST","2153923200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2169648000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2185372800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2201097600","39600","1");
INSERT INTO timezone VALUES("37","AEST","2216822400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2233152000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2248876800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2264601600","39600","1");
INSERT INTO timezone VALUES("37","AEST","2280326400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2296051200","39600","1");
INSERT INTO timezone VALUES("37","AEST","2311776000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2327500800","39600","1");
INSERT INTO timezone VALUES("37","AEST","2343225600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2358950400","39600","1");
INSERT INTO timezone VALUES("37","AEST","2374675200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2390400000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2406124800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2422454400","39600","1");
INSERT INTO timezone VALUES("37","AEST","2438179200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2453904000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2469628800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2485353600","39600","1");
INSERT INTO timezone VALUES("37","AEST","2501078400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2516803200","39600","1");
INSERT INTO timezone VALUES("37","AEST","2532528000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2548252800","39600","1");
INSERT INTO timezone VALUES("37","AEST","2563977600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2579702400","39600","1");
INSERT INTO timezone VALUES("37","AEST","2596032000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2611756800","39600","1");
INSERT INTO timezone VALUES("37","AEST","2627481600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2643206400","39600","1");
INSERT INTO timezone VALUES("37","AEST","2658931200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2674656000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2690380800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2706105600","39600","1");
INSERT INTO timezone VALUES("37","AEST","2721830400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2737555200","39600","1");
INSERT INTO timezone VALUES("37","AEST","2753280000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2769609600","39600","1");
INSERT INTO timezone VALUES("37","AEST","2785334400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2801059200","39600","1");
INSERT INTO timezone VALUES("37","AEST","2816784000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2832508800","39600","1");
INSERT INTO timezone VALUES("37","AEST","2848233600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2863958400","39600","1");
INSERT INTO timezone VALUES("37","AEST","2879683200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2895408000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2911132800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2926857600","39600","1");
INSERT INTO timezone VALUES("37","AEST","2942582400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2958912000","39600","1");
INSERT INTO timezone VALUES("37","AEST","2974636800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","2990361600","39600","1");
INSERT INTO timezone VALUES("37","AEST","3006086400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3021811200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3037536000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3053260800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3068985600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3084710400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3100435200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3116764800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3132489600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3148214400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3163939200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3179664000","39600","1");
INSERT INTO timezone VALUES("37","AEST","3195388800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3211113600","39600","1");
INSERT INTO timezone VALUES("37","AEST","3226838400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3242563200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3258288000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3274012800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3289737600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3306067200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3321792000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3337516800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3353241600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3368966400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3384691200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3400416000","39600","1");
INSERT INTO timezone VALUES("37","AEST","3416140800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3431865600","39600","1");
INSERT INTO timezone VALUES("37","AEST","3447590400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3463315200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3479644800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3495369600","39600","1");
INSERT INTO timezone VALUES("37","AEST","3511094400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3526819200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3542544000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3558268800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3573993600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3589718400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3605443200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3621168000","39600","1");
INSERT INTO timezone VALUES("37","AEST","3636892800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3653222400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3668947200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3684672000","39600","1");
INSERT INTO timezone VALUES("37","AEST","3700396800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3716121600","39600","1");
INSERT INTO timezone VALUES("37","AEST","3731846400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3747571200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3763296000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3779020800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3794745600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3810470400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3826195200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3842524800","39600","1");
INSERT INTO timezone VALUES("37","AEST","3858249600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3873974400","39600","1");
INSERT INTO timezone VALUES("37","AEST","3889699200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3905424000","39600","1");
INSERT INTO timezone VALUES("37","AEST","3921148800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3936873600","39600","1");
INSERT INTO timezone VALUES("37","AEST","3952598400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","3968323200","39600","1");
INSERT INTO timezone VALUES("37","AEST","3984048000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4000377600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4016102400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4031827200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4047552000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4063276800","39600","1");
INSERT INTO timezone VALUES("37","AEST","4079001600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4094726400","39600","1");
INSERT INTO timezone VALUES("37","AEST","4110451200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4126176000","39600","1");
INSERT INTO timezone VALUES("37","AEST","4141900800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4157625600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4173350400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4189075200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4204800000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4221129600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4236854400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4252579200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4268304000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4284028800","39600","1");
INSERT INTO timezone VALUES("37","AEST","4299753600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4315478400","39600","1");
INSERT INTO timezone VALUES("37","AEST","4331203200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4346928000","39600","1");
INSERT INTO timezone VALUES("37","AEST","4362652800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4378982400","39600","1");
INSERT INTO timezone VALUES("37","AEST","4394707200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4410432000","39600","1");
INSERT INTO timezone VALUES("37","AEST","4426156800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4441881600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4457606400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4473331200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4489056000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4504780800","39600","1");
INSERT INTO timezone VALUES("37","AEST","4520505600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4536230400","39600","1");
INSERT INTO timezone VALUES("37","AEST","4551955200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4568284800","39600","1");
INSERT INTO timezone VALUES("37","AEST","4584009600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4599734400","39600","1");
INSERT INTO timezone VALUES("37","AEST","4615459200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4631184000","39600","1");
INSERT INTO timezone VALUES("37","AEST","4646908800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4662633600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4678358400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4694083200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4709808000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4725532800","39600","1");
INSERT INTO timezone VALUES("37","AEST","4741862400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4757587200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4773312000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4789036800","39600","1");
INSERT INTO timezone VALUES("37","AEST","4804761600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4820486400","39600","1");
INSERT INTO timezone VALUES("37","AEST","4836211200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4851936000","39600","1");
INSERT INTO timezone VALUES("37","AEST","4867660800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4883385600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4899110400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4915440000","39600","1");
INSERT INTO timezone VALUES("37","AEST","4931164800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4946889600","39600","1");
INSERT INTO timezone VALUES("37","AEST","4962614400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","4978339200","39600","1");
INSERT INTO timezone VALUES("37","AEST","4994064000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5009788800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5025513600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5041238400","39600","1");
INSERT INTO timezone VALUES("37","AEST","5056963200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5072688000","39600","1");
INSERT INTO timezone VALUES("37","AEST","5088412800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5104742400","39600","1");
INSERT INTO timezone VALUES("37","AEST","5120467200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5136192000","39600","1");
INSERT INTO timezone VALUES("37","AEST","5151916800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5167641600","39600","1");
INSERT INTO timezone VALUES("37","AEST","5183366400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5199091200","39600","1");
INSERT INTO timezone VALUES("37","AEST","5214816000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5230540800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5246265600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5262595200","39600","1");
INSERT INTO timezone VALUES("37","AEST","5278320000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5294044800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5309769600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5325494400","39600","1");
INSERT INTO timezone VALUES("37","AEST","5341219200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5356944000","39600","1");
INSERT INTO timezone VALUES("37","AEST","5372668800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5388393600","39600","1");
INSERT INTO timezone VALUES("37","AEST","5404118400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5419843200","39600","1");
INSERT INTO timezone VALUES("37","AEST","5435568000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5451897600","39600","1");
INSERT INTO timezone VALUES("37","AEST","5467622400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5483347200","39600","1");
INSERT INTO timezone VALUES("37","AEST","5499072000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5514796800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5530521600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5546246400","39600","1");
INSERT INTO timezone VALUES("37","AEST","5561971200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5577696000","39600","1");
INSERT INTO timezone VALUES("37","AEST","5593420800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5609145600","39600","1");
INSERT INTO timezone VALUES("37","AEST","5625475200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5641200000","39600","1");
INSERT INTO timezone VALUES("37","AEST","5656924800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5672649600","39600","1");
INSERT INTO timezone VALUES("37","AEST","5688374400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5704099200","39600","1");
INSERT INTO timezone VALUES("37","AEST","5719824000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5735548800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5751273600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5766998400","39600","1");
INSERT INTO timezone VALUES("37","AEST","5782723200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5799052800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5814777600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5830502400","39600","1");
INSERT INTO timezone VALUES("37","AEST","5846227200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5861952000","39600","1");
INSERT INTO timezone VALUES("37","AEST","5877676800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5893401600","39600","1");
INSERT INTO timezone VALUES("37","AEST","5909126400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5924851200","39600","1");
INSERT INTO timezone VALUES("37","AEST","5940576000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5956300800","39600","1");
INSERT INTO timezone VALUES("37","AEST","5972025600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","5988355200","39600","1");
INSERT INTO timezone VALUES("37","AEST","6004080000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6019804800","39600","1");
INSERT INTO timezone VALUES("37","AEST","6035529600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6051254400","39600","1");
INSERT INTO timezone VALUES("37","AEST","6066979200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6082704000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6098428800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6114153600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6129878400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6146208000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6161932800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6177657600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6193382400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6209107200","39600","1");
INSERT INTO timezone VALUES("37","AEST","6224832000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6240556800","39600","1");
INSERT INTO timezone VALUES("37","AEST","6256281600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6272006400","39600","1");
INSERT INTO timezone VALUES("37","AEST","6287731200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6303456000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6319180800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6335510400","39600","1");
INSERT INTO timezone VALUES("37","AEST","6351235200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6366960000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6382684800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6398409600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6414134400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6429859200","39600","1");
INSERT INTO timezone VALUES("37","AEST","6445584000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6461308800","39600","1");
INSERT INTO timezone VALUES("37","AEST","6477033600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6492758400","39600","1");
INSERT INTO timezone VALUES("37","AEST","6509088000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6524812800","39600","1");
INSERT INTO timezone VALUES("37","AEST","6540537600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6556262400","39600","1");
INSERT INTO timezone VALUES("37","AEST","6571987200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6587712000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6603436800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6619161600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6634886400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6650611200","39600","1");
INSERT INTO timezone VALUES("37","AEST","6666336000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6682665600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6698390400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6714115200","39600","1");
INSERT INTO timezone VALUES("37","AEST","6729840000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6745564800","39600","1");
INSERT INTO timezone VALUES("37","AEST","6761289600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6777014400","39600","1");
INSERT INTO timezone VALUES("37","AEST","6792739200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6808464000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6824188800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6839913600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6855638400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6871968000","39600","1");
INSERT INTO timezone VALUES("37","AEST","6887692800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6903417600","39600","1");
INSERT INTO timezone VALUES("37","AEST","6919142400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6934867200","39600","1");
INSERT INTO timezone VALUES("37","AEST","6950592000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6966316800","39600","1");
INSERT INTO timezone VALUES("37","AEST","6982041600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","6997766400","39600","1");
INSERT INTO timezone VALUES("37","AEST","7013491200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7029820800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7045545600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7061270400","39600","1");
INSERT INTO timezone VALUES("37","AEST","7076995200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7092720000","39600","1");
INSERT INTO timezone VALUES("37","AEST","7108444800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7124169600","39600","1");
INSERT INTO timezone VALUES("37","AEST","7139894400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7155619200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7171344000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7187068800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7202793600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7219123200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7234848000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7250572800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7266297600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7282022400","39600","1");
INSERT INTO timezone VALUES("37","AEST","7297747200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7313472000","39600","1");
INSERT INTO timezone VALUES("37","AEST","7329196800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7344921600","39600","1");
INSERT INTO timezone VALUES("37","AEST","7360646400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7376371200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7392096000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7408425600","39600","1");
INSERT INTO timezone VALUES("37","AEST","7424150400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7439875200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7455600000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7471324800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7487049600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7502774400","39600","1");
INSERT INTO timezone VALUES("37","AEST","7518499200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7534224000","39600","1");
INSERT INTO timezone VALUES("37","AEST","7549948800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7565673600","39600","1");
INSERT INTO timezone VALUES("37","AEST","7581398400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7597728000","39600","1");
INSERT INTO timezone VALUES("37","AEST","7613452800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7629177600","39600","1");
INSERT INTO timezone VALUES("37","AEST","7644902400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7660627200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7676352000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7692076800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7707801600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7723526400","39600","1");
INSERT INTO timezone VALUES("37","AEST","7739251200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7754976000","39600","1");
INSERT INTO timezone VALUES("37","AEST","7771305600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7787030400","39600","1");
INSERT INTO timezone VALUES("37","AEST","7802755200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7818480000","39600","1");
INSERT INTO timezone VALUES("37","AEST","7834204800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7849929600","39600","1");
INSERT INTO timezone VALUES("37","AEST","7865654400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7881379200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7897104000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7912828800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7928553600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7944883200","39600","1");
INSERT INTO timezone VALUES("37","AEST","7960608000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","7976332800","39600","1");
INSERT INTO timezone VALUES("37","AEST","7992057600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8007782400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8023507200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8039232000","39600","1");
INSERT INTO timezone VALUES("37","AEST","8054956800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8070681600","39600","1");
INSERT INTO timezone VALUES("37","AEST","8086406400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8102131200","39600","1");
INSERT INTO timezone VALUES("37","AEST","8117856000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8134185600","39600","1");
INSERT INTO timezone VALUES("37","AEST","8149910400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8165635200","39600","1");
INSERT INTO timezone VALUES("37","AEST","8181360000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8197084800","39600","1");
INSERT INTO timezone VALUES("37","AEST","8212809600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8228534400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8244259200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8259984000","39600","1");
INSERT INTO timezone VALUES("37","AEST","8275708800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8292038400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8307763200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8323488000","39600","1");
INSERT INTO timezone VALUES("37","AEST","8339212800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8354937600","39600","1");
INSERT INTO timezone VALUES("37","AEST","8370662400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8386387200","39600","1");
INSERT INTO timezone VALUES("37","AEST","8402112000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8417836800","39600","1");
INSERT INTO timezone VALUES("37","AEST","8433561600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8449286400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8465011200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8481340800","39600","1");
INSERT INTO timezone VALUES("37","AEST","8497065600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8512790400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8528515200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8544240000","39600","1");
INSERT INTO timezone VALUES("37","AEST","8559964800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8575689600","39600","1");
INSERT INTO timezone VALUES("37","AEST","8591414400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8607139200","39600","1");
INSERT INTO timezone VALUES("37","AEST","8622864000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8638588800","39600","1");
INSERT INTO timezone VALUES("37","AEST","8654918400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8670643200","39600","1");
INSERT INTO timezone VALUES("37","AEST","8686368000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8702092800","39600","1");
INSERT INTO timezone VALUES("37","AEST","8717817600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8733542400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8749267200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8764992000","39600","1");
INSERT INTO timezone VALUES("37","AEST","8780716800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8796441600","39600","1");
INSERT INTO timezone VALUES("37","AEST","8812166400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8828496000","39600","1");
INSERT INTO timezone VALUES("37","AEST","8844220800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8859945600","39600","1");
INSERT INTO timezone VALUES("37","AEST","8875670400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8891395200","39600","1");
INSERT INTO timezone VALUES("37","AEST","8907120000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8922844800","39600","1");
INSERT INTO timezone VALUES("37","AEST","8938569600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8954294400","39600","1");
INSERT INTO timezone VALUES("37","AEST","8970019200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","8985744000","39600","1");
INSERT INTO timezone VALUES("37","AEST","9001468800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9017798400","39600","1");
INSERT INTO timezone VALUES("37","AEST","9033523200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9049248000","39600","1");
INSERT INTO timezone VALUES("37","AEST","9064972800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9080697600","39600","1");
INSERT INTO timezone VALUES("37","AEST","9096422400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9112147200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9127872000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9143596800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9159321600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9175651200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9191376000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9207100800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9222825600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9238550400","39600","1");
INSERT INTO timezone VALUES("37","AEST","9254275200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9270000000","39600","1");
INSERT INTO timezone VALUES("37","AEST","9285724800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9301449600","39600","1");
INSERT INTO timezone VALUES("37","AEST","9317174400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9332899200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9348624000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9364953600","39600","1");
INSERT INTO timezone VALUES("37","AEST","9380678400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9396403200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9412128000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9427852800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9443577600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9459302400","39600","1");
INSERT INTO timezone VALUES("37","AEST","9475027200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9490752000","39600","1");
INSERT INTO timezone VALUES("37","AEST","9506476800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9522201600","39600","1");
INSERT INTO timezone VALUES("37","AEST","9538531200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9554256000","39600","1");
INSERT INTO timezone VALUES("37","AEST","9569980800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9585705600","39600","1");
INSERT INTO timezone VALUES("37","AEST","9601430400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9617155200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9632880000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9648604800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9664329600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9680054400","39600","1");
INSERT INTO timezone VALUES("37","AEST","9695779200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9712108800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9727833600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9743558400","39600","1");
INSERT INTO timezone VALUES("37","AEST","9759283200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9775008000","39600","1");
INSERT INTO timezone VALUES("37","AEST","9790732800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9806457600","39600","1");
INSERT INTO timezone VALUES("37","AEST","9822182400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9837907200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9853632000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9869356800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9885081600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9901411200","39600","1");
INSERT INTO timezone VALUES("37","AEST","9917136000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9932860800","39600","1");
INSERT INTO timezone VALUES("37","AEST","9948585600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9964310400","39600","1");
INSERT INTO timezone VALUES("37","AEST","9980035200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","9995760000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10011484800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10027209600","39600","1");
INSERT INTO timezone VALUES("37","AEST","10042934400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10059264000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10074988800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10090713600","39600","1");
INSERT INTO timezone VALUES("37","AEST","10106438400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10122163200","39600","1");
INSERT INTO timezone VALUES("37","AEST","10137888000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10153612800","39600","1");
INSERT INTO timezone VALUES("37","AEST","10169337600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10185062400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10200787200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10216512000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10232236800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10248566400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10264291200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10280016000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10295740800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10311465600","39600","1");
INSERT INTO timezone VALUES("37","AEST","10327190400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10342915200","39600","1");
INSERT INTO timezone VALUES("37","AEST","10358640000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10374364800","39600","1");
INSERT INTO timezone VALUES("37","AEST","10390089600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10405814400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10421539200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10437868800","39600","1");
INSERT INTO timezone VALUES("37","AEST","10453593600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10469318400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10485043200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10500768000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10516492800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10532217600","39600","1");
INSERT INTO timezone VALUES("37","AEST","10547942400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10563667200","39600","1");
INSERT INTO timezone VALUES("37","AEST","10579392000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10595116800","39600","1");
INSERT INTO timezone VALUES("37","AEST","10610841600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10627171200","39600","1");
INSERT INTO timezone VALUES("37","AEST","10642896000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10658620800","39600","1");
INSERT INTO timezone VALUES("37","AEST","10674345600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10690070400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10705795200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10721520000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10737244800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10752969600","39600","1");
INSERT INTO timezone VALUES("37","AEST","10768694400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10784419200","39600","1");
INSERT INTO timezone VALUES("37","AEST","10800748800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10816473600","39600","1");
INSERT INTO timezone VALUES("37","AEST","10832198400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10847923200","39600","1");
INSERT INTO timezone VALUES("37","AEST","10863648000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10879372800","39600","1");
INSERT INTO timezone VALUES("37","AEST","10895097600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10910822400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10926547200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10942272000","39600","1");
INSERT INTO timezone VALUES("37","AEST","10957996800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","10974326400","39600","1");
INSERT INTO timezone VALUES("37","AEST","10990051200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11005776000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11021500800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11037225600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11052950400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11068675200","39600","1");
INSERT INTO timezone VALUES("37","AEST","11084400000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11100124800","39600","1");
INSERT INTO timezone VALUES("37","AEST","11115849600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11131574400","39600","1");
INSERT INTO timezone VALUES("37","AEST","11147299200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11163628800","39600","1");
INSERT INTO timezone VALUES("37","AEST","11179353600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11195078400","39600","1");
INSERT INTO timezone VALUES("37","AEST","11210803200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11226528000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11242252800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11257977600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11273702400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11289427200","39600","1");
INSERT INTO timezone VALUES("37","AEST","11305152000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11321481600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11337206400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11352931200","39600","1");
INSERT INTO timezone VALUES("37","AEST","11368656000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11384380800","39600","1");
INSERT INTO timezone VALUES("37","AEST","11400105600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11415830400","39600","1");
INSERT INTO timezone VALUES("37","AEST","11431555200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11447280000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11463004800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11478729600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11494454400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11510784000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11526508800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11542233600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11557958400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11573683200","39600","1");
INSERT INTO timezone VALUES("37","AEST","11589408000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11605132800","39600","1");
INSERT INTO timezone VALUES("37","AEST","11620857600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11636582400","39600","1");
INSERT INTO timezone VALUES("37","AEST","11652307200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11668032000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11684361600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11700086400","39600","1");
INSERT INTO timezone VALUES("37","AEST","11715811200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11731536000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11747260800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11762985600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11778710400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11794435200","39600","1");
INSERT INTO timezone VALUES("37","AEST","11810160000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11825884800","39600","1");
INSERT INTO timezone VALUES("37","AEST","11841609600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11857939200","39600","1");
INSERT INTO timezone VALUES("37","AEST","11873664000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11889388800","39600","1");
INSERT INTO timezone VALUES("37","AEST","11905113600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11920838400","39600","1");
INSERT INTO timezone VALUES("37","AEST","11936563200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11952288000","39600","1");
INSERT INTO timezone VALUES("37","AEST","11968012800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","11983737600","39600","1");
INSERT INTO timezone VALUES("37","AEST","11999462400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12015187200","39600","1");
INSERT INTO timezone VALUES("37","AEST","12030912000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12047241600","39600","1");
INSERT INTO timezone VALUES("37","AEST","12062966400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12078691200","39600","1");
INSERT INTO timezone VALUES("37","AEST","12094416000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12110140800","39600","1");
INSERT INTO timezone VALUES("37","AEST","12125865600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12141590400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12157315200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12173040000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12188764800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12205094400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12220819200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12236544000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12252268800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12267993600","39600","1");
INSERT INTO timezone VALUES("37","AEST","12283718400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12299443200","39600","1");
INSERT INTO timezone VALUES("37","AEST","12315168000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12330892800","39600","1");
INSERT INTO timezone VALUES("37","AEST","12346617600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12362342400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12378067200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12394396800","39600","1");
INSERT INTO timezone VALUES("37","AEST","12410121600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12425846400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12441571200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12457296000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12473020800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12488745600","39600","1");
INSERT INTO timezone VALUES("37","AEST","12504470400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12520195200","39600","1");
INSERT INTO timezone VALUES("37","AEST","12535920000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12551644800","39600","1");
INSERT INTO timezone VALUES("37","AEST","12567974400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12583699200","39600","1");
INSERT INTO timezone VALUES("37","AEST","12599424000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12615148800","39600","1");
INSERT INTO timezone VALUES("37","AEST","12630873600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12646598400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12662323200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12678048000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12693772800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12709497600","39600","1");
INSERT INTO timezone VALUES("37","AEST","12725222400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12741552000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12757276800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12773001600","39600","1");
INSERT INTO timezone VALUES("37","AEST","12788726400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12804451200","39600","1");
INSERT INTO timezone VALUES("37","AEST","12820176000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12835900800","39600","1");
INSERT INTO timezone VALUES("37","AEST","12851625600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12867350400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12883075200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12898800000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12914524800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12930854400","39600","1");
INSERT INTO timezone VALUES("37","AEST","12946579200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12962304000","39600","1");
INSERT INTO timezone VALUES("37","AEST","12978028800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","12993753600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13009478400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13025203200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13040928000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13056652800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13072377600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13088707200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13104432000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13120156800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13135881600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13151606400","39600","1");
INSERT INTO timezone VALUES("37","AEST","13167331200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13183056000","39600","1");
INSERT INTO timezone VALUES("37","AEST","13198780800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13214505600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13230230400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13245955200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13261680000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13278009600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13293734400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13309459200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13325184000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13340908800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13356633600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13372358400","39600","1");
INSERT INTO timezone VALUES("37","AEST","13388083200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13403808000","39600","1");
INSERT INTO timezone VALUES("37","AEST","13419532800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13435257600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13451587200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13467312000","39600","1");
INSERT INTO timezone VALUES("37","AEST","13483036800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13498761600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13514486400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13530211200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13545936000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13561660800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13577385600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13593110400","39600","1");
INSERT INTO timezone VALUES("37","AEST","13608835200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13625164800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13640889600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13656614400","39600","1");
INSERT INTO timezone VALUES("37","AEST","13672339200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13688064000","39600","1");
INSERT INTO timezone VALUES("37","AEST","13703788800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13719513600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13735238400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13750963200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13766688000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13782412800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13798137600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13814467200","39600","1");
INSERT INTO timezone VALUES("37","AEST","13830192000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13845916800","39600","1");
INSERT INTO timezone VALUES("37","AEST","13861641600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13877366400","39600","1");
INSERT INTO timezone VALUES("37","AEST","13893091200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13908816000","39600","1");
INSERT INTO timezone VALUES("37","AEST","13924540800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13940265600","39600","1");
INSERT INTO timezone VALUES("37","AEST","13955990400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","13972320000","39600","1");
INSERT INTO timezone VALUES("37","AEST","13988044800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14003769600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14019494400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14035219200","39600","1");
INSERT INTO timezone VALUES("37","AEST","14050944000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14066668800","39600","1");
INSERT INTO timezone VALUES("37","AEST","14082393600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14098118400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14113843200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14129568000","39600","1");
INSERT INTO timezone VALUES("37","AEST","14145292800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14161622400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14177347200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14193072000","39600","1");
INSERT INTO timezone VALUES("37","AEST","14208796800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14224521600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14240246400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14255971200","39600","1");
INSERT INTO timezone VALUES("37","AEST","14271696000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14287420800","39600","1");
INSERT INTO timezone VALUES("37","AEST","14303145600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14318870400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14335200000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14350924800","39600","1");
INSERT INTO timezone VALUES("37","AEST","14366649600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14382374400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14398099200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14413824000","39600","1");
INSERT INTO timezone VALUES("37","AEST","14429548800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14445273600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14460998400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14476723200","39600","1");
INSERT INTO timezone VALUES("37","AEST","14492448000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14508777600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14524502400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14540227200","39600","1");
INSERT INTO timezone VALUES("37","AEST","14555952000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14571676800","39600","1");
INSERT INTO timezone VALUES("37","AEST","14587401600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14603126400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14618851200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14634576000","39600","1");
INSERT INTO timezone VALUES("37","AEST","14650300800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14666025600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14681750400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14698080000","39600","1");
INSERT INTO timezone VALUES("37","AEST","14713804800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14729529600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14745254400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14760979200","39600","1");
INSERT INTO timezone VALUES("37","AEST","14776704000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14792428800","39600","1");
INSERT INTO timezone VALUES("37","AEST","14808153600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14823878400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14839603200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14855932800","39600","1");
INSERT INTO timezone VALUES("37","AEST","14871657600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14887382400","39600","1");
INSERT INTO timezone VALUES("37","AEST","14903107200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14918832000","39600","1");
INSERT INTO timezone VALUES("37","AEST","14934556800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14950281600","39600","1");
INSERT INTO timezone VALUES("37","AEST","14966006400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","14981731200","39600","1");
INSERT INTO timezone VALUES("37","AEST","14997456000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15013180800","39600","1");
INSERT INTO timezone VALUES("37","AEST","15028905600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15045235200","39600","1");
INSERT INTO timezone VALUES("37","AEST","15060960000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15076684800","39600","1");
INSERT INTO timezone VALUES("37","AEST","15092409600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15108134400","39600","1");
INSERT INTO timezone VALUES("37","AEST","15123859200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15139584000","39600","1");
INSERT INTO timezone VALUES("37","AEST","15155308800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15171033600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15186758400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15202483200","39600","1");
INSERT INTO timezone VALUES("37","AEST","15218812800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15234537600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15250262400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15265987200","39600","1");
INSERT INTO timezone VALUES("37","AEST","15281712000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15297436800","39600","1");
INSERT INTO timezone VALUES("37","AEST","15313161600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15328886400","39600","1");
INSERT INTO timezone VALUES("37","AEST","15344611200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15360336000","39600","1");
INSERT INTO timezone VALUES("37","AEST","15376060800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15392390400","39600","1");
INSERT INTO timezone VALUES("37","AEST","15408115200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15423840000","39600","1");
INSERT INTO timezone VALUES("37","AEST","15439564800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15455289600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15471014400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15486739200","39600","1");
INSERT INTO timezone VALUES("37","AEST","15502464000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15518188800","39600","1");
INSERT INTO timezone VALUES("37","AEST","15533913600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15549638400","39600","1");
INSERT INTO timezone VALUES("37","AEST","15565363200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15581692800","39600","1");
INSERT INTO timezone VALUES("37","AEST","15597417600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15613142400","39600","1");
INSERT INTO timezone VALUES("37","AEST","15628867200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15644592000","39600","1");
INSERT INTO timezone VALUES("37","AEST","15660316800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15676041600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15691766400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15707491200","39600","1");
INSERT INTO timezone VALUES("37","AEST","15723216000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15739545600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15755270400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15770995200","39600","1");
INSERT INTO timezone VALUES("37","AEST","15786720000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15802444800","39600","1");
INSERT INTO timezone VALUES("37","AEST","15818169600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15833894400","39600","1");
INSERT INTO timezone VALUES("37","AEST","15849619200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15865344000","39600","1");
INSERT INTO timezone VALUES("37","AEST","15881068800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15896793600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15912518400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15928848000","39600","1");
INSERT INTO timezone VALUES("37","AEST","15944572800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15960297600","39600","1");
INSERT INTO timezone VALUES("37","AEST","15976022400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","15991747200","39600","1");
INSERT INTO timezone VALUES("37","AEST","16007472000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16023196800","39600","1");
INSERT INTO timezone VALUES("37","AEST","16038921600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16054646400","39600","1");
INSERT INTO timezone VALUES("37","AEST","16070371200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16086096000","39600","1");
INSERT INTO timezone VALUES("37","AEST","16102425600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16118150400","39600","1");
INSERT INTO timezone VALUES("37","AEST","16133875200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16149600000","39600","1");
INSERT INTO timezone VALUES("37","AEST","16165324800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16181049600","39600","1");
INSERT INTO timezone VALUES("37","AEST","16196774400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16212499200","39600","1");
INSERT INTO timezone VALUES("37","AEST","16228224000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16243948800","39600","1");
INSERT INTO timezone VALUES("37","AEST","16259673600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16276003200","39600","1");
INSERT INTO timezone VALUES("37","AEST","16291728000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16307452800","39600","1");
INSERT INTO timezone VALUES("37","AEST","16323177600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16338902400","39600","1");
INSERT INTO timezone VALUES("37","AEST","16354627200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16370352000","39600","1");
INSERT INTO timezone VALUES("37","AEST","16386076800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16401801600","39600","1");
INSERT INTO timezone VALUES("37","AEST","16417526400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16433251200","39600","1");
INSERT INTO timezone VALUES("37","AEST","16448976000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16465305600","39600","1");
INSERT INTO timezone VALUES("37","AEST","16481030400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16496755200","39600","1");
INSERT INTO timezone VALUES("37","AEST","16512480000","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16528204800","39600","1");
INSERT INTO timezone VALUES("37","AEST","16543929600","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16559654400","39600","1");
INSERT INTO timezone VALUES("37","AEST","16575379200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16591104000","39600","1");
INSERT INTO timezone VALUES("37","AEST","16606828800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16623158400","39600","1");
INSERT INTO timezone VALUES("37","AEST","16638883200","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16654608000","39600","1");
INSERT INTO timezone VALUES("37","AEST","16670332800","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16686057600","39600","1");
INSERT INTO timezone VALUES("37","AEST","16701782400","36000","0");
INSERT INTO timezone VALUES("37","AEDT","16717507200","39600","1");
INSERT INTO timezone VALUES("38","LMT","-2364113093","36292","0");
INSERT INTO timezone VALUES("38","AEST","-2364113092","36000","0");
INSERT INTO timezone VALUES("38","AEDT","-1672567140","39600","1");
INSERT INTO timezone VALUES("38","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","-883641600","39600","1");
INSERT INTO timezone VALUES("38","AEST","-876128400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","-860400000","39600","1");
INSERT INTO timezone VALUES("38","AEST","-844678800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","-828345600","39600","1");
INSERT INTO timezone VALUES("38","AEST","-813229200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("38","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","89136000","39600","1");
INSERT INTO timezone VALUES("38","AEST","100022400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","120585600","39600","1");
INSERT INTO timezone VALUES("38","AEST","131472000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","152035200","39600","1");
INSERT INTO timezone VALUES("38","AEST","162921600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","183484800","39600","1");
INSERT INTO timezone VALUES("38","AEST","194976000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","215539200","39600","1");
INSERT INTO timezone VALUES("38","AEST","226425600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","246988800","39600","1");
INSERT INTO timezone VALUES("38","AEST","257875200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","278438400","39600","1");
INSERT INTO timezone VALUES("38","AEST","289324800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","309888000","39600","1");
INSERT INTO timezone VALUES("38","AEST","320774400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","341337600","39600","1");
INSERT INTO timezone VALUES("38","AEST","352224000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","372787200","39600","1");
INSERT INTO timezone VALUES("38","AEST","386697600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","404841600","39600","1");
INSERT INTO timezone VALUES("38","AEST","415728000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","436291200","39600","1");
INSERT INTO timezone VALUES("38","AEST","447177600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","467740800","39600","1");
INSERT INTO timezone VALUES("38","AEST","478627200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","499190400","39600","1");
INSERT INTO timezone VALUES("38","AEST","511286400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","530035200","39600","1");
INSERT INTO timezone VALUES("38","AEST","542736000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","562089600","39600","1");
INSERT INTO timezone VALUES("38","AEST","574790400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","594144000","39600","1");
INSERT INTO timezone VALUES("38","AEST","606240000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("38","AEST","636480000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("38","AEST","667929600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","688492800","39600","1");
INSERT INTO timezone VALUES("38","AEST","699379200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","719942400","39600","1");
INSERT INTO timezone VALUES("38","AEST","731433600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","751996800","39600","1");
INSERT INTO timezone VALUES("38","AEST","762883200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","783446400","39600","1");
INSERT INTO timezone VALUES("38","AEST","794332800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","814896000","39600","1");
INSERT INTO timezone VALUES("38","AEST","828201600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","846345600","39600","1");
INSERT INTO timezone VALUES("38","AEST","859651200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","877795200","39600","1");
INSERT INTO timezone VALUES("38","AEST","891100800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","909244800","39600","1");
INSERT INTO timezone VALUES("38","AEST","922550400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","941299200","39600","1");
INSERT INTO timezone VALUES("38","AEST","954000000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","967305600","39600","1");
INSERT INTO timezone VALUES("38","AEST","985449600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1004198400","39600","1");
INSERT INTO timezone VALUES("38","AEST","1017504000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1035648000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1048953600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1067097600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1080403200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1099152000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1111852800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1130601600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1143907200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1162051200","39600","1");
INSERT INTO timezone VALUES("38","AEST","1174752000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1193500800","39600","1");
INSERT INTO timezone VALUES("38","AEST","1207411200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1223136000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1238860800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1254585600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1270310400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1286035200","39600","1");
INSERT INTO timezone VALUES("38","AEST","1301760000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1317484800","39600","1");
INSERT INTO timezone VALUES("38","AEST","1333209600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1349539200","39600","1");
INSERT INTO timezone VALUES("38","AEST","1365264000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1380988800","39600","1");
INSERT INTO timezone VALUES("38","AEST","1396713600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1412438400","39600","1");
INSERT INTO timezone VALUES("38","AEST","1428163200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1443888000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1459612800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1475337600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1491062400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1506787200","39600","1");
INSERT INTO timezone VALUES("38","AEST","1522512000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1538841600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1554566400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1570291200","39600","1");
INSERT INTO timezone VALUES("38","AEST","1586016000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1601740800","39600","1");
INSERT INTO timezone VALUES("38","AEST","1617465600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1633190400","39600","1");
INSERT INTO timezone VALUES("38","AEST","1648915200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1664640000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1680364800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1696089600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1712419200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1728144000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1743868800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1759593600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1775318400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1791043200","39600","1");
INSERT INTO timezone VALUES("38","AEST","1806768000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1822492800","39600","1");
INSERT INTO timezone VALUES("38","AEST","1838217600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1853942400","39600","1");
INSERT INTO timezone VALUES("38","AEST","1869667200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1885996800","39600","1");
INSERT INTO timezone VALUES("38","AEST","1901721600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1917446400","39600","1");
INSERT INTO timezone VALUES("38","AEST","1933171200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1948896000","39600","1");
INSERT INTO timezone VALUES("38","AEST","1964620800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","1980345600","39600","1");
INSERT INTO timezone VALUES("38","AEST","1996070400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2011795200","39600","1");
INSERT INTO timezone VALUES("38","AEST","2027520000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2043244800","39600","1");
INSERT INTO timezone VALUES("38","AEST","2058969600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2075299200","39600","1");
INSERT INTO timezone VALUES("38","AEST","2091024000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2106748800","39600","1");
INSERT INTO timezone VALUES("38","AEST","2122473600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2138198400","39600","1");
INSERT INTO timezone VALUES("38","AEST","2153923200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2169648000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2185372800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2201097600","39600","1");
INSERT INTO timezone VALUES("38","AEST","2216822400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2233152000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2248876800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2264601600","39600","1");
INSERT INTO timezone VALUES("38","AEST","2280326400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2296051200","39600","1");
INSERT INTO timezone VALUES("38","AEST","2311776000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2327500800","39600","1");
INSERT INTO timezone VALUES("38","AEST","2343225600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2358950400","39600","1");
INSERT INTO timezone VALUES("38","AEST","2374675200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2390400000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2406124800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2422454400","39600","1");
INSERT INTO timezone VALUES("38","AEST","2438179200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2453904000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2469628800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2485353600","39600","1");
INSERT INTO timezone VALUES("38","AEST","2501078400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2516803200","39600","1");
INSERT INTO timezone VALUES("38","AEST","2532528000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2548252800","39600","1");
INSERT INTO timezone VALUES("38","AEST","2563977600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2579702400","39600","1");
INSERT INTO timezone VALUES("38","AEST","2596032000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2611756800","39600","1");
INSERT INTO timezone VALUES("38","AEST","2627481600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2643206400","39600","1");
INSERT INTO timezone VALUES("38","AEST","2658931200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2674656000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2690380800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2706105600","39600","1");
INSERT INTO timezone VALUES("38","AEST","2721830400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2737555200","39600","1");
INSERT INTO timezone VALUES("38","AEST","2753280000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2769609600","39600","1");
INSERT INTO timezone VALUES("38","AEST","2785334400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2801059200","39600","1");
INSERT INTO timezone VALUES("38","AEST","2816784000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2832508800","39600","1");
INSERT INTO timezone VALUES("38","AEST","2848233600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2863958400","39600","1");
INSERT INTO timezone VALUES("38","AEST","2879683200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2895408000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2911132800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2926857600","39600","1");
INSERT INTO timezone VALUES("38","AEST","2942582400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2958912000","39600","1");
INSERT INTO timezone VALUES("38","AEST","2974636800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","2990361600","39600","1");
INSERT INTO timezone VALUES("38","AEST","3006086400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3021811200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3037536000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3053260800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3068985600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3084710400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3100435200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3116764800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3132489600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3148214400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3163939200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3179664000","39600","1");
INSERT INTO timezone VALUES("38","AEST","3195388800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3211113600","39600","1");
INSERT INTO timezone VALUES("38","AEST","3226838400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3242563200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3258288000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3274012800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3289737600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3306067200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3321792000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3337516800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3353241600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3368966400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3384691200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3400416000","39600","1");
INSERT INTO timezone VALUES("38","AEST","3416140800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3431865600","39600","1");
INSERT INTO timezone VALUES("38","AEST","3447590400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3463315200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3479644800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3495369600","39600","1");
INSERT INTO timezone VALUES("38","AEST","3511094400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3526819200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3542544000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3558268800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3573993600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3589718400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3605443200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3621168000","39600","1");
INSERT INTO timezone VALUES("38","AEST","3636892800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3653222400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3668947200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3684672000","39600","1");
INSERT INTO timezone VALUES("38","AEST","3700396800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3716121600","39600","1");
INSERT INTO timezone VALUES("38","AEST","3731846400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3747571200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3763296000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3779020800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3794745600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3810470400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3826195200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3842524800","39600","1");
INSERT INTO timezone VALUES("38","AEST","3858249600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3873974400","39600","1");
INSERT INTO timezone VALUES("38","AEST","3889699200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3905424000","39600","1");
INSERT INTO timezone VALUES("38","AEST","3921148800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3936873600","39600","1");
INSERT INTO timezone VALUES("38","AEST","3952598400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","3968323200","39600","1");
INSERT INTO timezone VALUES("38","AEST","3984048000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4000377600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4016102400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4031827200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4047552000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4063276800","39600","1");
INSERT INTO timezone VALUES("38","AEST","4079001600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4094726400","39600","1");
INSERT INTO timezone VALUES("38","AEST","4110451200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4126176000","39600","1");
INSERT INTO timezone VALUES("38","AEST","4141900800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4157625600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4173350400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4189075200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4204800000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4221129600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4236854400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4252579200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4268304000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4284028800","39600","1");
INSERT INTO timezone VALUES("38","AEST","4299753600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4315478400","39600","1");
INSERT INTO timezone VALUES("38","AEST","4331203200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4346928000","39600","1");
INSERT INTO timezone VALUES("38","AEST","4362652800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4378982400","39600","1");
INSERT INTO timezone VALUES("38","AEST","4394707200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4410432000","39600","1");
INSERT INTO timezone VALUES("38","AEST","4426156800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4441881600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4457606400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4473331200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4489056000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4504780800","39600","1");
INSERT INTO timezone VALUES("38","AEST","4520505600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4536230400","39600","1");
INSERT INTO timezone VALUES("38","AEST","4551955200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4568284800","39600","1");
INSERT INTO timezone VALUES("38","AEST","4584009600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4599734400","39600","1");
INSERT INTO timezone VALUES("38","AEST","4615459200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4631184000","39600","1");
INSERT INTO timezone VALUES("38","AEST","4646908800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4662633600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4678358400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4694083200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4709808000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4725532800","39600","1");
INSERT INTO timezone VALUES("38","AEST","4741862400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4757587200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4773312000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4789036800","39600","1");
INSERT INTO timezone VALUES("38","AEST","4804761600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4820486400","39600","1");
INSERT INTO timezone VALUES("38","AEST","4836211200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4851936000","39600","1");
INSERT INTO timezone VALUES("38","AEST","4867660800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4883385600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4899110400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4915440000","39600","1");
INSERT INTO timezone VALUES("38","AEST","4931164800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4946889600","39600","1");
INSERT INTO timezone VALUES("38","AEST","4962614400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","4978339200","39600","1");
INSERT INTO timezone VALUES("38","AEST","4994064000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5009788800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5025513600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5041238400","39600","1");
INSERT INTO timezone VALUES("38","AEST","5056963200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5072688000","39600","1");
INSERT INTO timezone VALUES("38","AEST","5088412800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5104742400","39600","1");
INSERT INTO timezone VALUES("38","AEST","5120467200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5136192000","39600","1");
INSERT INTO timezone VALUES("38","AEST","5151916800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5167641600","39600","1");
INSERT INTO timezone VALUES("38","AEST","5183366400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5199091200","39600","1");
INSERT INTO timezone VALUES("38","AEST","5214816000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5230540800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5246265600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5262595200","39600","1");
INSERT INTO timezone VALUES("38","AEST","5278320000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5294044800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5309769600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5325494400","39600","1");
INSERT INTO timezone VALUES("38","AEST","5341219200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5356944000","39600","1");
INSERT INTO timezone VALUES("38","AEST","5372668800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5388393600","39600","1");
INSERT INTO timezone VALUES("38","AEST","5404118400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5419843200","39600","1");
INSERT INTO timezone VALUES("38","AEST","5435568000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5451897600","39600","1");
INSERT INTO timezone VALUES("38","AEST","5467622400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5483347200","39600","1");
INSERT INTO timezone VALUES("38","AEST","5499072000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5514796800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5530521600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5546246400","39600","1");
INSERT INTO timezone VALUES("38","AEST","5561971200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5577696000","39600","1");
INSERT INTO timezone VALUES("38","AEST","5593420800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5609145600","39600","1");
INSERT INTO timezone VALUES("38","AEST","5625475200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5641200000","39600","1");
INSERT INTO timezone VALUES("38","AEST","5656924800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5672649600","39600","1");
INSERT INTO timezone VALUES("38","AEST","5688374400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5704099200","39600","1");
INSERT INTO timezone VALUES("38","AEST","5719824000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5735548800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5751273600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5766998400","39600","1");
INSERT INTO timezone VALUES("38","AEST","5782723200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5799052800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5814777600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5830502400","39600","1");
INSERT INTO timezone VALUES("38","AEST","5846227200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5861952000","39600","1");
INSERT INTO timezone VALUES("38","AEST","5877676800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5893401600","39600","1");
INSERT INTO timezone VALUES("38","AEST","5909126400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5924851200","39600","1");
INSERT INTO timezone VALUES("38","AEST","5940576000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5956300800","39600","1");
INSERT INTO timezone VALUES("38","AEST","5972025600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","5988355200","39600","1");
INSERT INTO timezone VALUES("38","AEST","6004080000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6019804800","39600","1");
INSERT INTO timezone VALUES("38","AEST","6035529600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6051254400","39600","1");
INSERT INTO timezone VALUES("38","AEST","6066979200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6082704000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6098428800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6114153600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6129878400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6146208000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6161932800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6177657600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6193382400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6209107200","39600","1");
INSERT INTO timezone VALUES("38","AEST","6224832000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6240556800","39600","1");
INSERT INTO timezone VALUES("38","AEST","6256281600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6272006400","39600","1");
INSERT INTO timezone VALUES("38","AEST","6287731200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6303456000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6319180800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6335510400","39600","1");
INSERT INTO timezone VALUES("38","AEST","6351235200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6366960000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6382684800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6398409600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6414134400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6429859200","39600","1");
INSERT INTO timezone VALUES("38","AEST","6445584000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6461308800","39600","1");
INSERT INTO timezone VALUES("38","AEST","6477033600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6492758400","39600","1");
INSERT INTO timezone VALUES("38","AEST","6509088000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6524812800","39600","1");
INSERT INTO timezone VALUES("38","AEST","6540537600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6556262400","39600","1");
INSERT INTO timezone VALUES("38","AEST","6571987200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6587712000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6603436800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6619161600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6634886400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6650611200","39600","1");
INSERT INTO timezone VALUES("38","AEST","6666336000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6682665600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6698390400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6714115200","39600","1");
INSERT INTO timezone VALUES("38","AEST","6729840000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6745564800","39600","1");
INSERT INTO timezone VALUES("38","AEST","6761289600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6777014400","39600","1");
INSERT INTO timezone VALUES("38","AEST","6792739200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6808464000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6824188800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6839913600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6855638400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6871968000","39600","1");
INSERT INTO timezone VALUES("38","AEST","6887692800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6903417600","39600","1");
INSERT INTO timezone VALUES("38","AEST","6919142400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6934867200","39600","1");
INSERT INTO timezone VALUES("38","AEST","6950592000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6966316800","39600","1");
INSERT INTO timezone VALUES("38","AEST","6982041600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","6997766400","39600","1");
INSERT INTO timezone VALUES("38","AEST","7013491200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7029820800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7045545600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7061270400","39600","1");
INSERT INTO timezone VALUES("38","AEST","7076995200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7092720000","39600","1");
INSERT INTO timezone VALUES("38","AEST","7108444800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7124169600","39600","1");
INSERT INTO timezone VALUES("38","AEST","7139894400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7155619200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7171344000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7187068800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7202793600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7219123200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7234848000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7250572800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7266297600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7282022400","39600","1");
INSERT INTO timezone VALUES("38","AEST","7297747200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7313472000","39600","1");
INSERT INTO timezone VALUES("38","AEST","7329196800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7344921600","39600","1");
INSERT INTO timezone VALUES("38","AEST","7360646400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7376371200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7392096000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7408425600","39600","1");
INSERT INTO timezone VALUES("38","AEST","7424150400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7439875200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7455600000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7471324800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7487049600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7502774400","39600","1");
INSERT INTO timezone VALUES("38","AEST","7518499200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7534224000","39600","1");
INSERT INTO timezone VALUES("38","AEST","7549948800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7565673600","39600","1");
INSERT INTO timezone VALUES("38","AEST","7581398400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7597728000","39600","1");
INSERT INTO timezone VALUES("38","AEST","7613452800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7629177600","39600","1");
INSERT INTO timezone VALUES("38","AEST","7644902400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7660627200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7676352000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7692076800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7707801600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7723526400","39600","1");
INSERT INTO timezone VALUES("38","AEST","7739251200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7754976000","39600","1");
INSERT INTO timezone VALUES("38","AEST","7771305600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7787030400","39600","1");
INSERT INTO timezone VALUES("38","AEST","7802755200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7818480000","39600","1");
INSERT INTO timezone VALUES("38","AEST","7834204800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7849929600","39600","1");
INSERT INTO timezone VALUES("38","AEST","7865654400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7881379200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7897104000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7912828800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7928553600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7944883200","39600","1");
INSERT INTO timezone VALUES("38","AEST","7960608000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","7976332800","39600","1");
INSERT INTO timezone VALUES("38","AEST","7992057600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8007782400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8023507200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8039232000","39600","1");
INSERT INTO timezone VALUES("38","AEST","8054956800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8070681600","39600","1");
INSERT INTO timezone VALUES("38","AEST","8086406400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8102131200","39600","1");
INSERT INTO timezone VALUES("38","AEST","8117856000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8134185600","39600","1");
INSERT INTO timezone VALUES("38","AEST","8149910400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8165635200","39600","1");
INSERT INTO timezone VALUES("38","AEST","8181360000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8197084800","39600","1");
INSERT INTO timezone VALUES("38","AEST","8212809600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8228534400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8244259200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8259984000","39600","1");
INSERT INTO timezone VALUES("38","AEST","8275708800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8292038400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8307763200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8323488000","39600","1");
INSERT INTO timezone VALUES("38","AEST","8339212800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8354937600","39600","1");
INSERT INTO timezone VALUES("38","AEST","8370662400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8386387200","39600","1");
INSERT INTO timezone VALUES("38","AEST","8402112000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8417836800","39600","1");
INSERT INTO timezone VALUES("38","AEST","8433561600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8449286400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8465011200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8481340800","39600","1");
INSERT INTO timezone VALUES("38","AEST","8497065600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8512790400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8528515200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8544240000","39600","1");
INSERT INTO timezone VALUES("38","AEST","8559964800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8575689600","39600","1");
INSERT INTO timezone VALUES("38","AEST","8591414400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8607139200","39600","1");
INSERT INTO timezone VALUES("38","AEST","8622864000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8638588800","39600","1");
INSERT INTO timezone VALUES("38","AEST","8654918400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8670643200","39600","1");
INSERT INTO timezone VALUES("38","AEST","8686368000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8702092800","39600","1");
INSERT INTO timezone VALUES("38","AEST","8717817600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8733542400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8749267200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8764992000","39600","1");
INSERT INTO timezone VALUES("38","AEST","8780716800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8796441600","39600","1");
INSERT INTO timezone VALUES("38","AEST","8812166400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8828496000","39600","1");
INSERT INTO timezone VALUES("38","AEST","8844220800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8859945600","39600","1");
INSERT INTO timezone VALUES("38","AEST","8875670400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8891395200","39600","1");
INSERT INTO timezone VALUES("38","AEST","8907120000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8922844800","39600","1");
INSERT INTO timezone VALUES("38","AEST","8938569600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8954294400","39600","1");
INSERT INTO timezone VALUES("38","AEST","8970019200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","8985744000","39600","1");
INSERT INTO timezone VALUES("38","AEST","9001468800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9017798400","39600","1");
INSERT INTO timezone VALUES("38","AEST","9033523200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9049248000","39600","1");
INSERT INTO timezone VALUES("38","AEST","9064972800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9080697600","39600","1");
INSERT INTO timezone VALUES("38","AEST","9096422400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9112147200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9127872000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9143596800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9159321600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9175651200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9191376000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9207100800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9222825600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9238550400","39600","1");
INSERT INTO timezone VALUES("38","AEST","9254275200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9270000000","39600","1");
INSERT INTO timezone VALUES("38","AEST","9285724800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9301449600","39600","1");
INSERT INTO timezone VALUES("38","AEST","9317174400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9332899200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9348624000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9364953600","39600","1");
INSERT INTO timezone VALUES("38","AEST","9380678400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9396403200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9412128000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9427852800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9443577600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9459302400","39600","1");
INSERT INTO timezone VALUES("38","AEST","9475027200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9490752000","39600","1");
INSERT INTO timezone VALUES("38","AEST","9506476800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9522201600","39600","1");
INSERT INTO timezone VALUES("38","AEST","9538531200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9554256000","39600","1");
INSERT INTO timezone VALUES("38","AEST","9569980800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9585705600","39600","1");
INSERT INTO timezone VALUES("38","AEST","9601430400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9617155200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9632880000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9648604800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9664329600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9680054400","39600","1");
INSERT INTO timezone VALUES("38","AEST","9695779200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9712108800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9727833600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9743558400","39600","1");
INSERT INTO timezone VALUES("38","AEST","9759283200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9775008000","39600","1");
INSERT INTO timezone VALUES("38","AEST","9790732800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9806457600","39600","1");
INSERT INTO timezone VALUES("38","AEST","9822182400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9837907200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9853632000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9869356800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9885081600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9901411200","39600","1");
INSERT INTO timezone VALUES("38","AEST","9917136000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9932860800","39600","1");
INSERT INTO timezone VALUES("38","AEST","9948585600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9964310400","39600","1");
INSERT INTO timezone VALUES("38","AEST","9980035200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","9995760000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10011484800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10027209600","39600","1");
INSERT INTO timezone VALUES("38","AEST","10042934400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10059264000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10074988800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10090713600","39600","1");
INSERT INTO timezone VALUES("38","AEST","10106438400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10122163200","39600","1");
INSERT INTO timezone VALUES("38","AEST","10137888000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10153612800","39600","1");
INSERT INTO timezone VALUES("38","AEST","10169337600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10185062400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10200787200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10216512000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10232236800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10248566400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10264291200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10280016000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10295740800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10311465600","39600","1");
INSERT INTO timezone VALUES("38","AEST","10327190400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10342915200","39600","1");
INSERT INTO timezone VALUES("38","AEST","10358640000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10374364800","39600","1");
INSERT INTO timezone VALUES("38","AEST","10390089600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10405814400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10421539200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10437868800","39600","1");
INSERT INTO timezone VALUES("38","AEST","10453593600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10469318400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10485043200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10500768000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10516492800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10532217600","39600","1");
INSERT INTO timezone VALUES("38","AEST","10547942400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10563667200","39600","1");
INSERT INTO timezone VALUES("38","AEST","10579392000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10595116800","39600","1");
INSERT INTO timezone VALUES("38","AEST","10610841600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10627171200","39600","1");
INSERT INTO timezone VALUES("38","AEST","10642896000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10658620800","39600","1");
INSERT INTO timezone VALUES("38","AEST","10674345600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10690070400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10705795200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10721520000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10737244800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10752969600","39600","1");
INSERT INTO timezone VALUES("38","AEST","10768694400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10784419200","39600","1");
INSERT INTO timezone VALUES("38","AEST","10800748800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10816473600","39600","1");
INSERT INTO timezone VALUES("38","AEST","10832198400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10847923200","39600","1");
INSERT INTO timezone VALUES("38","AEST","10863648000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10879372800","39600","1");
INSERT INTO timezone VALUES("38","AEST","10895097600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10910822400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10926547200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10942272000","39600","1");
INSERT INTO timezone VALUES("38","AEST","10957996800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","10974326400","39600","1");
INSERT INTO timezone VALUES("38","AEST","10990051200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11005776000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11021500800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11037225600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11052950400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11068675200","39600","1");
INSERT INTO timezone VALUES("38","AEST","11084400000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11100124800","39600","1");
INSERT INTO timezone VALUES("38","AEST","11115849600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11131574400","39600","1");
INSERT INTO timezone VALUES("38","AEST","11147299200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11163628800","39600","1");
INSERT INTO timezone VALUES("38","AEST","11179353600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11195078400","39600","1");
INSERT INTO timezone VALUES("38","AEST","11210803200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11226528000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11242252800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11257977600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11273702400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11289427200","39600","1");
INSERT INTO timezone VALUES("38","AEST","11305152000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11321481600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11337206400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11352931200","39600","1");
INSERT INTO timezone VALUES("38","AEST","11368656000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11384380800","39600","1");
INSERT INTO timezone VALUES("38","AEST","11400105600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11415830400","39600","1");
INSERT INTO timezone VALUES("38","AEST","11431555200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11447280000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11463004800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11478729600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11494454400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11510784000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11526508800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11542233600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11557958400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11573683200","39600","1");
INSERT INTO timezone VALUES("38","AEST","11589408000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11605132800","39600","1");
INSERT INTO timezone VALUES("38","AEST","11620857600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11636582400","39600","1");
INSERT INTO timezone VALUES("38","AEST","11652307200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11668032000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11684361600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11700086400","39600","1");
INSERT INTO timezone VALUES("38","AEST","11715811200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11731536000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11747260800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11762985600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11778710400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11794435200","39600","1");
INSERT INTO timezone VALUES("38","AEST","11810160000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11825884800","39600","1");
INSERT INTO timezone VALUES("38","AEST","11841609600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11857939200","39600","1");
INSERT INTO timezone VALUES("38","AEST","11873664000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11889388800","39600","1");
INSERT INTO timezone VALUES("38","AEST","11905113600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11920838400","39600","1");
INSERT INTO timezone VALUES("38","AEST","11936563200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11952288000","39600","1");
INSERT INTO timezone VALUES("38","AEST","11968012800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","11983737600","39600","1");
INSERT INTO timezone VALUES("38","AEST","11999462400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12015187200","39600","1");
INSERT INTO timezone VALUES("38","AEST","12030912000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12047241600","39600","1");
INSERT INTO timezone VALUES("38","AEST","12062966400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12078691200","39600","1");
INSERT INTO timezone VALUES("38","AEST","12094416000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12110140800","39600","1");
INSERT INTO timezone VALUES("38","AEST","12125865600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12141590400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12157315200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12173040000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12188764800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12205094400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12220819200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12236544000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12252268800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12267993600","39600","1");
INSERT INTO timezone VALUES("38","AEST","12283718400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12299443200","39600","1");
INSERT INTO timezone VALUES("38","AEST","12315168000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12330892800","39600","1");
INSERT INTO timezone VALUES("38","AEST","12346617600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12362342400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12378067200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12394396800","39600","1");
INSERT INTO timezone VALUES("38","AEST","12410121600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12425846400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12441571200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12457296000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12473020800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12488745600","39600","1");
INSERT INTO timezone VALUES("38","AEST","12504470400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12520195200","39600","1");
INSERT INTO timezone VALUES("38","AEST","12535920000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12551644800","39600","1");
INSERT INTO timezone VALUES("38","AEST","12567974400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12583699200","39600","1");
INSERT INTO timezone VALUES("38","AEST","12599424000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12615148800","39600","1");
INSERT INTO timezone VALUES("38","AEST","12630873600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12646598400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12662323200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12678048000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12693772800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12709497600","39600","1");
INSERT INTO timezone VALUES("38","AEST","12725222400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12741552000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12757276800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12773001600","39600","1");
INSERT INTO timezone VALUES("38","AEST","12788726400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12804451200","39600","1");
INSERT INTO timezone VALUES("38","AEST","12820176000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12835900800","39600","1");
INSERT INTO timezone VALUES("38","AEST","12851625600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12867350400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12883075200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12898800000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12914524800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12930854400","39600","1");
INSERT INTO timezone VALUES("38","AEST","12946579200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12962304000","39600","1");
INSERT INTO timezone VALUES("38","AEST","12978028800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","12993753600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13009478400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13025203200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13040928000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13056652800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13072377600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13088707200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13104432000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13120156800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13135881600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13151606400","39600","1");
INSERT INTO timezone VALUES("38","AEST","13167331200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13183056000","39600","1");
INSERT INTO timezone VALUES("38","AEST","13198780800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13214505600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13230230400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13245955200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13261680000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13278009600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13293734400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13309459200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13325184000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13340908800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13356633600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13372358400","39600","1");
INSERT INTO timezone VALUES("38","AEST","13388083200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13403808000","39600","1");
INSERT INTO timezone VALUES("38","AEST","13419532800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13435257600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13451587200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13467312000","39600","1");
INSERT INTO timezone VALUES("38","AEST","13483036800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13498761600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13514486400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13530211200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13545936000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13561660800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13577385600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13593110400","39600","1");
INSERT INTO timezone VALUES("38","AEST","13608835200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13625164800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13640889600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13656614400","39600","1");
INSERT INTO timezone VALUES("38","AEST","13672339200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13688064000","39600","1");
INSERT INTO timezone VALUES("38","AEST","13703788800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13719513600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13735238400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13750963200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13766688000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13782412800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13798137600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13814467200","39600","1");
INSERT INTO timezone VALUES("38","AEST","13830192000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13845916800","39600","1");
INSERT INTO timezone VALUES("38","AEST","13861641600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13877366400","39600","1");
INSERT INTO timezone VALUES("38","AEST","13893091200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13908816000","39600","1");
INSERT INTO timezone VALUES("38","AEST","13924540800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13940265600","39600","1");
INSERT INTO timezone VALUES("38","AEST","13955990400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","13972320000","39600","1");
INSERT INTO timezone VALUES("38","AEST","13988044800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14003769600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14019494400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14035219200","39600","1");
INSERT INTO timezone VALUES("38","AEST","14050944000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14066668800","39600","1");
INSERT INTO timezone VALUES("38","AEST","14082393600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14098118400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14113843200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14129568000","39600","1");
INSERT INTO timezone VALUES("38","AEST","14145292800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14161622400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14177347200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14193072000","39600","1");
INSERT INTO timezone VALUES("38","AEST","14208796800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14224521600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14240246400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14255971200","39600","1");
INSERT INTO timezone VALUES("38","AEST","14271696000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14287420800","39600","1");
INSERT INTO timezone VALUES("38","AEST","14303145600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14318870400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14335200000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14350924800","39600","1");
INSERT INTO timezone VALUES("38","AEST","14366649600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14382374400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14398099200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14413824000","39600","1");
INSERT INTO timezone VALUES("38","AEST","14429548800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14445273600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14460998400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14476723200","39600","1");
INSERT INTO timezone VALUES("38","AEST","14492448000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14508777600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14524502400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14540227200","39600","1");
INSERT INTO timezone VALUES("38","AEST","14555952000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14571676800","39600","1");
INSERT INTO timezone VALUES("38","AEST","14587401600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14603126400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14618851200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14634576000","39600","1");
INSERT INTO timezone VALUES("38","AEST","14650300800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14666025600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14681750400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14698080000","39600","1");
INSERT INTO timezone VALUES("38","AEST","14713804800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14729529600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14745254400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14760979200","39600","1");
INSERT INTO timezone VALUES("38","AEST","14776704000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14792428800","39600","1");
INSERT INTO timezone VALUES("38","AEST","14808153600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14823878400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14839603200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14855932800","39600","1");
INSERT INTO timezone VALUES("38","AEST","14871657600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14887382400","39600","1");
INSERT INTO timezone VALUES("38","AEST","14903107200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14918832000","39600","1");
INSERT INTO timezone VALUES("38","AEST","14934556800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14950281600","39600","1");
INSERT INTO timezone VALUES("38","AEST","14966006400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","14981731200","39600","1");
INSERT INTO timezone VALUES("38","AEST","14997456000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15013180800","39600","1");
INSERT INTO timezone VALUES("38","AEST","15028905600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15045235200","39600","1");
INSERT INTO timezone VALUES("38","AEST","15060960000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15076684800","39600","1");
INSERT INTO timezone VALUES("38","AEST","15092409600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15108134400","39600","1");
INSERT INTO timezone VALUES("38","AEST","15123859200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15139584000","39600","1");
INSERT INTO timezone VALUES("38","AEST","15155308800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15171033600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15186758400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15202483200","39600","1");
INSERT INTO timezone VALUES("38","AEST","15218812800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15234537600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15250262400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15265987200","39600","1");
INSERT INTO timezone VALUES("38","AEST","15281712000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15297436800","39600","1");
INSERT INTO timezone VALUES("38","AEST","15313161600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15328886400","39600","1");
INSERT INTO timezone VALUES("38","AEST","15344611200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15360336000","39600","1");
INSERT INTO timezone VALUES("38","AEST","15376060800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15392390400","39600","1");
INSERT INTO timezone VALUES("38","AEST","15408115200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15423840000","39600","1");
INSERT INTO timezone VALUES("38","AEST","15439564800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15455289600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15471014400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15486739200","39600","1");
INSERT INTO timezone VALUES("38","AEST","15502464000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15518188800","39600","1");
INSERT INTO timezone VALUES("38","AEST","15533913600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15549638400","39600","1");
INSERT INTO timezone VALUES("38","AEST","15565363200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15581692800","39600","1");
INSERT INTO timezone VALUES("38","AEST","15597417600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15613142400","39600","1");
INSERT INTO timezone VALUES("38","AEST","15628867200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15644592000","39600","1");
INSERT INTO timezone VALUES("38","AEST","15660316800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15676041600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15691766400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15707491200","39600","1");
INSERT INTO timezone VALUES("38","AEST","15723216000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15739545600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15755270400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15770995200","39600","1");
INSERT INTO timezone VALUES("38","AEST","15786720000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15802444800","39600","1");
INSERT INTO timezone VALUES("38","AEST","15818169600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15833894400","39600","1");
INSERT INTO timezone VALUES("38","AEST","15849619200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15865344000","39600","1");
INSERT INTO timezone VALUES("38","AEST","15881068800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15896793600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15912518400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15928848000","39600","1");
INSERT INTO timezone VALUES("38","AEST","15944572800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15960297600","39600","1");
INSERT INTO timezone VALUES("38","AEST","15976022400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","15991747200","39600","1");
INSERT INTO timezone VALUES("38","AEST","16007472000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16023196800","39600","1");
INSERT INTO timezone VALUES("38","AEST","16038921600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16054646400","39600","1");
INSERT INTO timezone VALUES("38","AEST","16070371200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16086096000","39600","1");
INSERT INTO timezone VALUES("38","AEST","16102425600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16118150400","39600","1");
INSERT INTO timezone VALUES("38","AEST","16133875200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16149600000","39600","1");
INSERT INTO timezone VALUES("38","AEST","16165324800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16181049600","39600","1");
INSERT INTO timezone VALUES("38","AEST","16196774400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16212499200","39600","1");
INSERT INTO timezone VALUES("38","AEST","16228224000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16243948800","39600","1");
INSERT INTO timezone VALUES("38","AEST","16259673600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16276003200","39600","1");
INSERT INTO timezone VALUES("38","AEST","16291728000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16307452800","39600","1");
INSERT INTO timezone VALUES("38","AEST","16323177600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16338902400","39600","1");
INSERT INTO timezone VALUES("38","AEST","16354627200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16370352000","39600","1");
INSERT INTO timezone VALUES("38","AEST","16386076800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16401801600","39600","1");
INSERT INTO timezone VALUES("38","AEST","16417526400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16433251200","39600","1");
INSERT INTO timezone VALUES("38","AEST","16448976000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16465305600","39600","1");
INSERT INTO timezone VALUES("38","AEST","16481030400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16496755200","39600","1");
INSERT INTO timezone VALUES("38","AEST","16512480000","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16528204800","39600","1");
INSERT INTO timezone VALUES("38","AEST","16543929600","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16559654400","39600","1");
INSERT INTO timezone VALUES("38","AEST","16575379200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16591104000","39600","1");
INSERT INTO timezone VALUES("38","AEST","16606828800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16623158400","39600","1");
INSERT INTO timezone VALUES("38","AEST","16638883200","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16654608000","39600","1");
INSERT INTO timezone VALUES("38","AEST","16670332800","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16686057600","39600","1");
INSERT INTO timezone VALUES("38","AEST","16701782400","36000","0");
INSERT INTO timezone VALUES("38","AEDT","16717507200","39600","1");
INSERT INTO timezone VALUES("39","LMT","-2364110749","33948","0");
INSERT INTO timezone VALUES("39","AEST","-2364110748","36000","0");
INSERT INTO timezone VALUES("39","ACST","-2314951200","32400","0");
INSERT INTO timezone VALUES("39","ACST","-2230189200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","-1672565340","37800","1");
INSERT INTO timezone VALUES("39","ACST","-1665390600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","-883639800","37800","1");
INSERT INTO timezone VALUES("39","ACST","-876126600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","-860398200","37800","1");
INSERT INTO timezone VALUES("39","ACST","-844677000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","-828343800","37800","1");
INSERT INTO timezone VALUES("39","ACST","-813227400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","57688200","37800","1");
INSERT INTO timezone VALUES("39","ACST","67969800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","89137800","37800","1");
INSERT INTO timezone VALUES("39","ACST","100024200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","120587400","37800","1");
INSERT INTO timezone VALUES("39","ACST","131473800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","152037000","37800","1");
INSERT INTO timezone VALUES("39","ACST","162923400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","183486600","37800","1");
INSERT INTO timezone VALUES("39","ACST","194977800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","215541000","37800","1");
INSERT INTO timezone VALUES("39","ACST","226427400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","246990600","37800","1");
INSERT INTO timezone VALUES("39","ACST","257877000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","278440200","37800","1");
INSERT INTO timezone VALUES("39","ACST","289326600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","309889800","37800","1");
INSERT INTO timezone VALUES("39","ACST","320776200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","341339400","37800","1");
INSERT INTO timezone VALUES("39","ACST","352225800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","372789000","37800","1");
INSERT INTO timezone VALUES("39","ACST","386699400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","404843400","37800","1");
INSERT INTO timezone VALUES("39","ACST","415729800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","436293000","37800","1");
INSERT INTO timezone VALUES("39","ACST","447179400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","467742600","37800","1");
INSERT INTO timezone VALUES("39","ACST","478629000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","499192200","37800","1");
INSERT INTO timezone VALUES("39","ACST","511288200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","530037000","37800","1");
INSERT INTO timezone VALUES("39","ACST","542737800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","562091400","37800","1");
INSERT INTO timezone VALUES("39","ACST","574792200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","594145800","37800","1");
INSERT INTO timezone VALUES("39","ACST","606241800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","625595400","37800","1");
INSERT INTO timezone VALUES("39","ACST","636481800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","657045000","37800","1");
INSERT INTO timezone VALUES("39","ACST","667931400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","688494600","37800","1");
INSERT INTO timezone VALUES("39","ACST","699381000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","719944200","37800","1");
INSERT INTO timezone VALUES("39","ACST","731435400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","751998600","37800","1");
INSERT INTO timezone VALUES("39","ACST","762885000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","783448200","37800","1");
INSERT INTO timezone VALUES("39","ACST","794334600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","814897800","37800","1");
INSERT INTO timezone VALUES("39","ACST","828203400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","846347400","37800","1");
INSERT INTO timezone VALUES("39","ACST","859653000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","877797000","37800","1");
INSERT INTO timezone VALUES("39","ACST","891102600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","909246600","37800","1");
INSERT INTO timezone VALUES("39","ACST","922552200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","941301000","37800","1");
INSERT INTO timezone VALUES("39","ACST","954001800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","972750600","37800","1");
INSERT INTO timezone VALUES("39","ACST","985451400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1004200200","37800","1");
INSERT INTO timezone VALUES("39","ACST","1017505800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1035649800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1048955400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1067099400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1080405000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1099153800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1111854600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1130603400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1143909000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1162053000","37800","1");
INSERT INTO timezone VALUES("39","ACST","1174753800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1193502600","37800","1");
INSERT INTO timezone VALUES("39","ACST","1207413000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1223137800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1238862600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1254587400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1270312200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1286037000","37800","1");
INSERT INTO timezone VALUES("39","ACST","1301761800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1317486600","37800","1");
INSERT INTO timezone VALUES("39","ACST","1333211400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1349541000","37800","1");
INSERT INTO timezone VALUES("39","ACST","1365265800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1380990600","37800","1");
INSERT INTO timezone VALUES("39","ACST","1396715400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1412440200","37800","1");
INSERT INTO timezone VALUES("39","ACST","1428165000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1443889800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1459614600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1475339400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1491064200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1506789000","37800","1");
INSERT INTO timezone VALUES("39","ACST","1522513800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1538843400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1554568200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1570293000","37800","1");
INSERT INTO timezone VALUES("39","ACST","1586017800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1601742600","37800","1");
INSERT INTO timezone VALUES("39","ACST","1617467400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1633192200","37800","1");
INSERT INTO timezone VALUES("39","ACST","1648917000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1664641800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1680366600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1696091400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1712421000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1728145800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1743870600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1759595400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1775320200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1791045000","37800","1");
INSERT INTO timezone VALUES("39","ACST","1806769800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1822494600","37800","1");
INSERT INTO timezone VALUES("39","ACST","1838219400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1853944200","37800","1");
INSERT INTO timezone VALUES("39","ACST","1869669000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1885998600","37800","1");
INSERT INTO timezone VALUES("39","ACST","1901723400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1917448200","37800","1");
INSERT INTO timezone VALUES("39","ACST","1933173000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1948897800","37800","1");
INSERT INTO timezone VALUES("39","ACST","1964622600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","1980347400","37800","1");
INSERT INTO timezone VALUES("39","ACST","1996072200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2011797000","37800","1");
INSERT INTO timezone VALUES("39","ACST","2027521800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2043246600","37800","1");
INSERT INTO timezone VALUES("39","ACST","2058971400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2075301000","37800","1");
INSERT INTO timezone VALUES("39","ACST","2091025800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2106750600","37800","1");
INSERT INTO timezone VALUES("39","ACST","2122475400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2138200200","37800","1");
INSERT INTO timezone VALUES("39","ACST","2153925000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2169649800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2185374600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2201099400","37800","1");
INSERT INTO timezone VALUES("39","ACST","2216824200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2233153800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2248878600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2264603400","37800","1");
INSERT INTO timezone VALUES("39","ACST","2280328200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2296053000","37800","1");
INSERT INTO timezone VALUES("39","ACST","2311777800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2327502600","37800","1");
INSERT INTO timezone VALUES("39","ACST","2343227400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2358952200","37800","1");
INSERT INTO timezone VALUES("39","ACST","2374677000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2390401800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2406126600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2422456200","37800","1");
INSERT INTO timezone VALUES("39","ACST","2438181000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2453905800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2469630600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2485355400","37800","1");
INSERT INTO timezone VALUES("39","ACST","2501080200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2516805000","37800","1");
INSERT INTO timezone VALUES("39","ACST","2532529800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2548254600","37800","1");
INSERT INTO timezone VALUES("39","ACST","2563979400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2579704200","37800","1");
INSERT INTO timezone VALUES("39","ACST","2596033800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2611758600","37800","1");
INSERT INTO timezone VALUES("39","ACST","2627483400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2643208200","37800","1");
INSERT INTO timezone VALUES("39","ACST","2658933000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2674657800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2690382600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2706107400","37800","1");
INSERT INTO timezone VALUES("39","ACST","2721832200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2737557000","37800","1");
INSERT INTO timezone VALUES("39","ACST","2753281800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2769611400","37800","1");
INSERT INTO timezone VALUES("39","ACST","2785336200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2801061000","37800","1");
INSERT INTO timezone VALUES("39","ACST","2816785800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2832510600","37800","1");
INSERT INTO timezone VALUES("39","ACST","2848235400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2863960200","37800","1");
INSERT INTO timezone VALUES("39","ACST","2879685000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2895409800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2911134600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2926859400","37800","1");
INSERT INTO timezone VALUES("39","ACST","2942584200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2958913800","37800","1");
INSERT INTO timezone VALUES("39","ACST","2974638600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","2990363400","37800","1");
INSERT INTO timezone VALUES("39","ACST","3006088200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3021813000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3037537800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3053262600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3068987400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3084712200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3100437000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3116766600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3132491400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3148216200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3163941000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3179665800","37800","1");
INSERT INTO timezone VALUES("39","ACST","3195390600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3211115400","37800","1");
INSERT INTO timezone VALUES("39","ACST","3226840200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3242565000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3258289800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3274014600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3289739400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3306069000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3321793800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3337518600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3353243400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3368968200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3384693000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3400417800","37800","1");
INSERT INTO timezone VALUES("39","ACST","3416142600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3431867400","37800","1");
INSERT INTO timezone VALUES("39","ACST","3447592200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3463317000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3479646600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3495371400","37800","1");
INSERT INTO timezone VALUES("39","ACST","3511096200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3526821000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3542545800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3558270600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3573995400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3589720200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3605445000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3621169800","37800","1");
INSERT INTO timezone VALUES("39","ACST","3636894600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3653224200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3668949000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3684673800","37800","1");
INSERT INTO timezone VALUES("39","ACST","3700398600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3716123400","37800","1");
INSERT INTO timezone VALUES("39","ACST","3731848200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3747573000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3763297800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3779022600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3794747400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3810472200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3826197000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3842526600","37800","1");
INSERT INTO timezone VALUES("39","ACST","3858251400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3873976200","37800","1");
INSERT INTO timezone VALUES("39","ACST","3889701000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3905425800","37800","1");
INSERT INTO timezone VALUES("39","ACST","3921150600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3936875400","37800","1");
INSERT INTO timezone VALUES("39","ACST","3952600200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","3968325000","37800","1");
INSERT INTO timezone VALUES("39","ACST","3984049800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4000379400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4016104200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4031829000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4047553800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4063278600","37800","1");
INSERT INTO timezone VALUES("39","ACST","4079003400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4094728200","37800","1");
INSERT INTO timezone VALUES("39","ACST","4110453000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4126177800","37800","1");
INSERT INTO timezone VALUES("39","ACST","4141902600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4157627400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4173352200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4189077000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4204801800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4221131400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4236856200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4252581000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4268305800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4284030600","37800","1");
INSERT INTO timezone VALUES("39","ACST","4299755400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4315480200","37800","1");
INSERT INTO timezone VALUES("39","ACST","4331205000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4346929800","37800","1");
INSERT INTO timezone VALUES("39","ACST","4362654600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4378984200","37800","1");
INSERT INTO timezone VALUES("39","ACST","4394709000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4410433800","37800","1");
INSERT INTO timezone VALUES("39","ACST","4426158600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4441883400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4457608200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4473333000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4489057800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4504782600","37800","1");
INSERT INTO timezone VALUES("39","ACST","4520507400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4536232200","37800","1");
INSERT INTO timezone VALUES("39","ACST","4551957000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4568286600","37800","1");
INSERT INTO timezone VALUES("39","ACST","4584011400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4599736200","37800","1");
INSERT INTO timezone VALUES("39","ACST","4615461000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4631185800","37800","1");
INSERT INTO timezone VALUES("39","ACST","4646910600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4662635400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4678360200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4694085000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4709809800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4725534600","37800","1");
INSERT INTO timezone VALUES("39","ACST","4741864200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4757589000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4773313800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4789038600","37800","1");
INSERT INTO timezone VALUES("39","ACST","4804763400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4820488200","37800","1");
INSERT INTO timezone VALUES("39","ACST","4836213000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4851937800","37800","1");
INSERT INTO timezone VALUES("39","ACST","4867662600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4883387400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4899112200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4915441800","37800","1");
INSERT INTO timezone VALUES("39","ACST","4931166600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4946891400","37800","1");
INSERT INTO timezone VALUES("39","ACST","4962616200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","4978341000","37800","1");
INSERT INTO timezone VALUES("39","ACST","4994065800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5009790600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5025515400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5041240200","37800","1");
INSERT INTO timezone VALUES("39","ACST","5056965000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5072689800","37800","1");
INSERT INTO timezone VALUES("39","ACST","5088414600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5104744200","37800","1");
INSERT INTO timezone VALUES("39","ACST","5120469000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5136193800","37800","1");
INSERT INTO timezone VALUES("39","ACST","5151918600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5167643400","37800","1");
INSERT INTO timezone VALUES("39","ACST","5183368200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5199093000","37800","1");
INSERT INTO timezone VALUES("39","ACST","5214817800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5230542600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5246267400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5262597000","37800","1");
INSERT INTO timezone VALUES("39","ACST","5278321800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5294046600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5309771400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5325496200","37800","1");
INSERT INTO timezone VALUES("39","ACST","5341221000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5356945800","37800","1");
INSERT INTO timezone VALUES("39","ACST","5372670600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5388395400","37800","1");
INSERT INTO timezone VALUES("39","ACST","5404120200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5419845000","37800","1");
INSERT INTO timezone VALUES("39","ACST","5435569800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5451899400","37800","1");
INSERT INTO timezone VALUES("39","ACST","5467624200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5483349000","37800","1");
INSERT INTO timezone VALUES("39","ACST","5499073800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5514798600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5530523400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5546248200","37800","1");
INSERT INTO timezone VALUES("39","ACST","5561973000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5577697800","37800","1");
INSERT INTO timezone VALUES("39","ACST","5593422600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5609147400","37800","1");
INSERT INTO timezone VALUES("39","ACST","5625477000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5641201800","37800","1");
INSERT INTO timezone VALUES("39","ACST","5656926600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5672651400","37800","1");
INSERT INTO timezone VALUES("39","ACST","5688376200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5704101000","37800","1");
INSERT INTO timezone VALUES("39","ACST","5719825800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5735550600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5751275400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5767000200","37800","1");
INSERT INTO timezone VALUES("39","ACST","5782725000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5799054600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5814779400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5830504200","37800","1");
INSERT INTO timezone VALUES("39","ACST","5846229000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5861953800","37800","1");
INSERT INTO timezone VALUES("39","ACST","5877678600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5893403400","37800","1");
INSERT INTO timezone VALUES("39","ACST","5909128200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5924853000","37800","1");
INSERT INTO timezone VALUES("39","ACST","5940577800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5956302600","37800","1");
INSERT INTO timezone VALUES("39","ACST","5972027400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","5988357000","37800","1");
INSERT INTO timezone VALUES("39","ACST","6004081800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6019806600","37800","1");
INSERT INTO timezone VALUES("39","ACST","6035531400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6051256200","37800","1");
INSERT INTO timezone VALUES("39","ACST","6066981000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6082705800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6098430600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6114155400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6129880200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6146209800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6161934600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6177659400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6193384200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6209109000","37800","1");
INSERT INTO timezone VALUES("39","ACST","6224833800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6240558600","37800","1");
INSERT INTO timezone VALUES("39","ACST","6256283400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6272008200","37800","1");
INSERT INTO timezone VALUES("39","ACST","6287733000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6303457800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6319182600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6335512200","37800","1");
INSERT INTO timezone VALUES("39","ACST","6351237000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6366961800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6382686600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6398411400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6414136200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6429861000","37800","1");
INSERT INTO timezone VALUES("39","ACST","6445585800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6461310600","37800","1");
INSERT INTO timezone VALUES("39","ACST","6477035400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6492760200","37800","1");
INSERT INTO timezone VALUES("39","ACST","6509089800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6524814600","37800","1");
INSERT INTO timezone VALUES("39","ACST","6540539400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6556264200","37800","1");
INSERT INTO timezone VALUES("39","ACST","6571989000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6587713800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6603438600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6619163400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6634888200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6650613000","37800","1");
INSERT INTO timezone VALUES("39","ACST","6666337800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6682667400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6698392200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6714117000","37800","1");
INSERT INTO timezone VALUES("39","ACST","6729841800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6745566600","37800","1");
INSERT INTO timezone VALUES("39","ACST","6761291400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6777016200","37800","1");
INSERT INTO timezone VALUES("39","ACST","6792741000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6808465800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6824190600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6839915400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6855640200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6871969800","37800","1");
INSERT INTO timezone VALUES("39","ACST","6887694600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6903419400","37800","1");
INSERT INTO timezone VALUES("39","ACST","6919144200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6934869000","37800","1");
INSERT INTO timezone VALUES("39","ACST","6950593800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6966318600","37800","1");
INSERT INTO timezone VALUES("39","ACST","6982043400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","6997768200","37800","1");
INSERT INTO timezone VALUES("39","ACST","7013493000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7029822600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7045547400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7061272200","37800","1");
INSERT INTO timezone VALUES("39","ACST","7076997000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7092721800","37800","1");
INSERT INTO timezone VALUES("39","ACST","7108446600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7124171400","37800","1");
INSERT INTO timezone VALUES("39","ACST","7139896200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7155621000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7171345800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7187070600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7202795400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7219125000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7234849800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7250574600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7266299400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7282024200","37800","1");
INSERT INTO timezone VALUES("39","ACST","7297749000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7313473800","37800","1");
INSERT INTO timezone VALUES("39","ACST","7329198600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7344923400","37800","1");
INSERT INTO timezone VALUES("39","ACST","7360648200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7376373000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7392097800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7408427400","37800","1");
INSERT INTO timezone VALUES("39","ACST","7424152200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7439877000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7455601800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7471326600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7487051400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7502776200","37800","1");
INSERT INTO timezone VALUES("39","ACST","7518501000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7534225800","37800","1");
INSERT INTO timezone VALUES("39","ACST","7549950600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7565675400","37800","1");
INSERT INTO timezone VALUES("39","ACST","7581400200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7597729800","37800","1");
INSERT INTO timezone VALUES("39","ACST","7613454600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7629179400","37800","1");
INSERT INTO timezone VALUES("39","ACST","7644904200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7660629000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7676353800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7692078600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7707803400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7723528200","37800","1");
INSERT INTO timezone VALUES("39","ACST","7739253000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7754977800","37800","1");
INSERT INTO timezone VALUES("39","ACST","7771307400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7787032200","37800","1");
INSERT INTO timezone VALUES("39","ACST","7802757000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7818481800","37800","1");
INSERT INTO timezone VALUES("39","ACST","7834206600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7849931400","37800","1");
INSERT INTO timezone VALUES("39","ACST","7865656200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7881381000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7897105800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7912830600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7928555400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7944885000","37800","1");
INSERT INTO timezone VALUES("39","ACST","7960609800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","7976334600","37800","1");
INSERT INTO timezone VALUES("39","ACST","7992059400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8007784200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8023509000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8039233800","37800","1");
INSERT INTO timezone VALUES("39","ACST","8054958600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8070683400","37800","1");
INSERT INTO timezone VALUES("39","ACST","8086408200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8102133000","37800","1");
INSERT INTO timezone VALUES("39","ACST","8117857800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8134187400","37800","1");
INSERT INTO timezone VALUES("39","ACST","8149912200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8165637000","37800","1");
INSERT INTO timezone VALUES("39","ACST","8181361800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8197086600","37800","1");
INSERT INTO timezone VALUES("39","ACST","8212811400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8228536200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8244261000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8259985800","37800","1");
INSERT INTO timezone VALUES("39","ACST","8275710600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8292040200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8307765000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8323489800","37800","1");
INSERT INTO timezone VALUES("39","ACST","8339214600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8354939400","37800","1");
INSERT INTO timezone VALUES("39","ACST","8370664200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8386389000","37800","1");
INSERT INTO timezone VALUES("39","ACST","8402113800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8417838600","37800","1");
INSERT INTO timezone VALUES("39","ACST","8433563400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8449288200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8465013000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8481342600","37800","1");
INSERT INTO timezone VALUES("39","ACST","8497067400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8512792200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8528517000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8544241800","37800","1");
INSERT INTO timezone VALUES("39","ACST","8559966600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8575691400","37800","1");
INSERT INTO timezone VALUES("39","ACST","8591416200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8607141000","37800","1");
INSERT INTO timezone VALUES("39","ACST","8622865800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8638590600","37800","1");
INSERT INTO timezone VALUES("39","ACST","8654920200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8670645000","37800","1");
INSERT INTO timezone VALUES("39","ACST","8686369800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8702094600","37800","1");
INSERT INTO timezone VALUES("39","ACST","8717819400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8733544200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8749269000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8764993800","37800","1");
INSERT INTO timezone VALUES("39","ACST","8780718600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8796443400","37800","1");
INSERT INTO timezone VALUES("39","ACST","8812168200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8828497800","37800","1");
INSERT INTO timezone VALUES("39","ACST","8844222600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8859947400","37800","1");
INSERT INTO timezone VALUES("39","ACST","8875672200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8891397000","37800","1");
INSERT INTO timezone VALUES("39","ACST","8907121800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8922846600","37800","1");
INSERT INTO timezone VALUES("39","ACST","8938571400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8954296200","37800","1");
INSERT INTO timezone VALUES("39","ACST","8970021000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","8985745800","37800","1");
INSERT INTO timezone VALUES("39","ACST","9001470600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9017800200","37800","1");
INSERT INTO timezone VALUES("39","ACST","9033525000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9049249800","37800","1");
INSERT INTO timezone VALUES("39","ACST","9064974600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9080699400","37800","1");
INSERT INTO timezone VALUES("39","ACST","9096424200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9112149000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9127873800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9143598600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9159323400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9175653000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9191377800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9207102600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9222827400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9238552200","37800","1");
INSERT INTO timezone VALUES("39","ACST","9254277000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9270001800","37800","1");
INSERT INTO timezone VALUES("39","ACST","9285726600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9301451400","37800","1");
INSERT INTO timezone VALUES("39","ACST","9317176200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9332901000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9348625800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9364955400","37800","1");
INSERT INTO timezone VALUES("39","ACST","9380680200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9396405000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9412129800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9427854600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9443579400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9459304200","37800","1");
INSERT INTO timezone VALUES("39","ACST","9475029000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9490753800","37800","1");
INSERT INTO timezone VALUES("39","ACST","9506478600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9522203400","37800","1");
INSERT INTO timezone VALUES("39","ACST","9538533000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9554257800","37800","1");
INSERT INTO timezone VALUES("39","ACST","9569982600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9585707400","37800","1");
INSERT INTO timezone VALUES("39","ACST","9601432200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9617157000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9632881800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9648606600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9664331400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9680056200","37800","1");
INSERT INTO timezone VALUES("39","ACST","9695781000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9712110600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9727835400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9743560200","37800","1");
INSERT INTO timezone VALUES("39","ACST","9759285000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9775009800","37800","1");
INSERT INTO timezone VALUES("39","ACST","9790734600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9806459400","37800","1");
INSERT INTO timezone VALUES("39","ACST","9822184200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9837909000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9853633800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9869358600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9885083400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9901413000","37800","1");
INSERT INTO timezone VALUES("39","ACST","9917137800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9932862600","37800","1");
INSERT INTO timezone VALUES("39","ACST","9948587400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9964312200","37800","1");
INSERT INTO timezone VALUES("39","ACST","9980037000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","9995761800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10011486600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10027211400","37800","1");
INSERT INTO timezone VALUES("39","ACST","10042936200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10059265800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10074990600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10090715400","37800","1");
INSERT INTO timezone VALUES("39","ACST","10106440200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10122165000","37800","1");
INSERT INTO timezone VALUES("39","ACST","10137889800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10153614600","37800","1");
INSERT INTO timezone VALUES("39","ACST","10169339400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10185064200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10200789000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10216513800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10232238600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10248568200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10264293000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10280017800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10295742600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10311467400","37800","1");
INSERT INTO timezone VALUES("39","ACST","10327192200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10342917000","37800","1");
INSERT INTO timezone VALUES("39","ACST","10358641800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10374366600","37800","1");
INSERT INTO timezone VALUES("39","ACST","10390091400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10405816200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10421541000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10437870600","37800","1");
INSERT INTO timezone VALUES("39","ACST","10453595400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10469320200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10485045000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10500769800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10516494600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10532219400","37800","1");
INSERT INTO timezone VALUES("39","ACST","10547944200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10563669000","37800","1");
INSERT INTO timezone VALUES("39","ACST","10579393800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10595118600","37800","1");
INSERT INTO timezone VALUES("39","ACST","10610843400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10627173000","37800","1");
INSERT INTO timezone VALUES("39","ACST","10642897800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10658622600","37800","1");
INSERT INTO timezone VALUES("39","ACST","10674347400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10690072200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10705797000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10721521800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10737246600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10752971400","37800","1");
INSERT INTO timezone VALUES("39","ACST","10768696200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10784421000","37800","1");
INSERT INTO timezone VALUES("39","ACST","10800750600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10816475400","37800","1");
INSERT INTO timezone VALUES("39","ACST","10832200200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10847925000","37800","1");
INSERT INTO timezone VALUES("39","ACST","10863649800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10879374600","37800","1");
INSERT INTO timezone VALUES("39","ACST","10895099400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10910824200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10926549000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10942273800","37800","1");
INSERT INTO timezone VALUES("39","ACST","10957998600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","10974328200","37800","1");
INSERT INTO timezone VALUES("39","ACST","10990053000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11005777800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11021502600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11037227400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11052952200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11068677000","37800","1");
INSERT INTO timezone VALUES("39","ACST","11084401800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11100126600","37800","1");
INSERT INTO timezone VALUES("39","ACST","11115851400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11131576200","37800","1");
INSERT INTO timezone VALUES("39","ACST","11147301000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11163630600","37800","1");
INSERT INTO timezone VALUES("39","ACST","11179355400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11195080200","37800","1");
INSERT INTO timezone VALUES("39","ACST","11210805000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11226529800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11242254600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11257979400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11273704200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11289429000","37800","1");
INSERT INTO timezone VALUES("39","ACST","11305153800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11321483400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11337208200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11352933000","37800","1");
INSERT INTO timezone VALUES("39","ACST","11368657800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11384382600","37800","1");
INSERT INTO timezone VALUES("39","ACST","11400107400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11415832200","37800","1");
INSERT INTO timezone VALUES("39","ACST","11431557000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11447281800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11463006600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11478731400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11494456200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11510785800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11526510600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11542235400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11557960200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11573685000","37800","1");
INSERT INTO timezone VALUES("39","ACST","11589409800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11605134600","37800","1");
INSERT INTO timezone VALUES("39","ACST","11620859400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11636584200","37800","1");
INSERT INTO timezone VALUES("39","ACST","11652309000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11668033800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11684363400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11700088200","37800","1");
INSERT INTO timezone VALUES("39","ACST","11715813000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11731537800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11747262600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11762987400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11778712200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11794437000","37800","1");
INSERT INTO timezone VALUES("39","ACST","11810161800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11825886600","37800","1");
INSERT INTO timezone VALUES("39","ACST","11841611400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11857941000","37800","1");
INSERT INTO timezone VALUES("39","ACST","11873665800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11889390600","37800","1");
INSERT INTO timezone VALUES("39","ACST","11905115400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11920840200","37800","1");
INSERT INTO timezone VALUES("39","ACST","11936565000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11952289800","37800","1");
INSERT INTO timezone VALUES("39","ACST","11968014600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","11983739400","37800","1");
INSERT INTO timezone VALUES("39","ACST","11999464200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12015189000","37800","1");
INSERT INTO timezone VALUES("39","ACST","12030913800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12047243400","37800","1");
INSERT INTO timezone VALUES("39","ACST","12062968200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12078693000","37800","1");
INSERT INTO timezone VALUES("39","ACST","12094417800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12110142600","37800","1");
INSERT INTO timezone VALUES("39","ACST","12125867400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12141592200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12157317000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12173041800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12188766600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12205096200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12220821000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12236545800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12252270600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12267995400","37800","1");
INSERT INTO timezone VALUES("39","ACST","12283720200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12299445000","37800","1");
INSERT INTO timezone VALUES("39","ACST","12315169800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12330894600","37800","1");
INSERT INTO timezone VALUES("39","ACST","12346619400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12362344200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12378069000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12394398600","37800","1");
INSERT INTO timezone VALUES("39","ACST","12410123400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12425848200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12441573000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12457297800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12473022600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12488747400","37800","1");
INSERT INTO timezone VALUES("39","ACST","12504472200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12520197000","37800","1");
INSERT INTO timezone VALUES("39","ACST","12535921800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12551646600","37800","1");
INSERT INTO timezone VALUES("39","ACST","12567976200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12583701000","37800","1");
INSERT INTO timezone VALUES("39","ACST","12599425800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12615150600","37800","1");
INSERT INTO timezone VALUES("39","ACST","12630875400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12646600200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12662325000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12678049800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12693774600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12709499400","37800","1");
INSERT INTO timezone VALUES("39","ACST","12725224200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12741553800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12757278600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12773003400","37800","1");
INSERT INTO timezone VALUES("39","ACST","12788728200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12804453000","37800","1");
INSERT INTO timezone VALUES("39","ACST","12820177800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12835902600","37800","1");
INSERT INTO timezone VALUES("39","ACST","12851627400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12867352200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12883077000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12898801800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12914526600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12930856200","37800","1");
INSERT INTO timezone VALUES("39","ACST","12946581000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12962305800","37800","1");
INSERT INTO timezone VALUES("39","ACST","12978030600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","12993755400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13009480200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13025205000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13040929800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13056654600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13072379400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13088709000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13104433800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13120158600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13135883400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13151608200","37800","1");
INSERT INTO timezone VALUES("39","ACST","13167333000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13183057800","37800","1");
INSERT INTO timezone VALUES("39","ACST","13198782600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13214507400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13230232200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13245957000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13261681800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13278011400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13293736200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13309461000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13325185800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13340910600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13356635400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13372360200","37800","1");
INSERT INTO timezone VALUES("39","ACST","13388085000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13403809800","37800","1");
INSERT INTO timezone VALUES("39","ACST","13419534600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13435259400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13451589000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13467313800","37800","1");
INSERT INTO timezone VALUES("39","ACST","13483038600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13498763400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13514488200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13530213000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13545937800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13561662600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13577387400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13593112200","37800","1");
INSERT INTO timezone VALUES("39","ACST","13608837000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13625166600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13640891400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13656616200","37800","1");
INSERT INTO timezone VALUES("39","ACST","13672341000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13688065800","37800","1");
INSERT INTO timezone VALUES("39","ACST","13703790600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13719515400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13735240200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13750965000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13766689800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13782414600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13798139400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13814469000","37800","1");
INSERT INTO timezone VALUES("39","ACST","13830193800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13845918600","37800","1");
INSERT INTO timezone VALUES("39","ACST","13861643400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13877368200","37800","1");
INSERT INTO timezone VALUES("39","ACST","13893093000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13908817800","37800","1");
INSERT INTO timezone VALUES("39","ACST","13924542600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13940267400","37800","1");
INSERT INTO timezone VALUES("39","ACST","13955992200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","13972321800","37800","1");
INSERT INTO timezone VALUES("39","ACST","13988046600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14003771400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14019496200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14035221000","37800","1");
INSERT INTO timezone VALUES("39","ACST","14050945800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14066670600","37800","1");
INSERT INTO timezone VALUES("39","ACST","14082395400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14098120200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14113845000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14129569800","37800","1");
INSERT INTO timezone VALUES("39","ACST","14145294600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14161624200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14177349000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14193073800","37800","1");
INSERT INTO timezone VALUES("39","ACST","14208798600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14224523400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14240248200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14255973000","37800","1");
INSERT INTO timezone VALUES("39","ACST","14271697800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14287422600","37800","1");
INSERT INTO timezone VALUES("39","ACST","14303147400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14318872200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14335201800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14350926600","37800","1");
INSERT INTO timezone VALUES("39","ACST","14366651400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14382376200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14398101000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14413825800","37800","1");
INSERT INTO timezone VALUES("39","ACST","14429550600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14445275400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14461000200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14476725000","37800","1");
INSERT INTO timezone VALUES("39","ACST","14492449800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14508779400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14524504200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14540229000","37800","1");
INSERT INTO timezone VALUES("39","ACST","14555953800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14571678600","37800","1");
INSERT INTO timezone VALUES("39","ACST","14587403400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14603128200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14618853000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14634577800","37800","1");
INSERT INTO timezone VALUES("39","ACST","14650302600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14666027400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14681752200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14698081800","37800","1");
INSERT INTO timezone VALUES("39","ACST","14713806600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14729531400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14745256200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14760981000","37800","1");
INSERT INTO timezone VALUES("39","ACST","14776705800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14792430600","37800","1");
INSERT INTO timezone VALUES("39","ACST","14808155400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14823880200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14839605000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14855934600","37800","1");
INSERT INTO timezone VALUES("39","ACST","14871659400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14887384200","37800","1");
INSERT INTO timezone VALUES("39","ACST","14903109000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14918833800","37800","1");
INSERT INTO timezone VALUES("39","ACST","14934558600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14950283400","37800","1");
INSERT INTO timezone VALUES("39","ACST","14966008200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","14981733000","37800","1");
INSERT INTO timezone VALUES("39","ACST","14997457800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15013182600","37800","1");
INSERT INTO timezone VALUES("39","ACST","15028907400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15045237000","37800","1");
INSERT INTO timezone VALUES("39","ACST","15060961800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15076686600","37800","1");
INSERT INTO timezone VALUES("39","ACST","15092411400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15108136200","37800","1");
INSERT INTO timezone VALUES("39","ACST","15123861000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15139585800","37800","1");
INSERT INTO timezone VALUES("39","ACST","15155310600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15171035400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15186760200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15202485000","37800","1");
INSERT INTO timezone VALUES("39","ACST","15218814600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15234539400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15250264200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15265989000","37800","1");
INSERT INTO timezone VALUES("39","ACST","15281713800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15297438600","37800","1");
INSERT INTO timezone VALUES("39","ACST","15313163400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15328888200","37800","1");
INSERT INTO timezone VALUES("39","ACST","15344613000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15360337800","37800","1");
INSERT INTO timezone VALUES("39","ACST","15376062600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15392392200","37800","1");
INSERT INTO timezone VALUES("39","ACST","15408117000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15423841800","37800","1");
INSERT INTO timezone VALUES("39","ACST","15439566600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15455291400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15471016200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15486741000","37800","1");
INSERT INTO timezone VALUES("39","ACST","15502465800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15518190600","37800","1");
INSERT INTO timezone VALUES("39","ACST","15533915400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15549640200","37800","1");
INSERT INTO timezone VALUES("39","ACST","15565365000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15581694600","37800","1");
INSERT INTO timezone VALUES("39","ACST","15597419400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15613144200","37800","1");
INSERT INTO timezone VALUES("39","ACST","15628869000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15644593800","37800","1");
INSERT INTO timezone VALUES("39","ACST","15660318600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15676043400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15691768200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15707493000","37800","1");
INSERT INTO timezone VALUES("39","ACST","15723217800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15739547400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15755272200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15770997000","37800","1");
INSERT INTO timezone VALUES("39","ACST","15786721800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15802446600","37800","1");
INSERT INTO timezone VALUES("39","ACST","15818171400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15833896200","37800","1");
INSERT INTO timezone VALUES("39","ACST","15849621000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15865345800","37800","1");
INSERT INTO timezone VALUES("39","ACST","15881070600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15896795400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15912520200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15928849800","37800","1");
INSERT INTO timezone VALUES("39","ACST","15944574600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15960299400","37800","1");
INSERT INTO timezone VALUES("39","ACST","15976024200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","15991749000","37800","1");
INSERT INTO timezone VALUES("39","ACST","16007473800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16023198600","37800","1");
INSERT INTO timezone VALUES("39","ACST","16038923400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16054648200","37800","1");
INSERT INTO timezone VALUES("39","ACST","16070373000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16086097800","37800","1");
INSERT INTO timezone VALUES("39","ACST","16102427400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16118152200","37800","1");
INSERT INTO timezone VALUES("39","ACST","16133877000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16149601800","37800","1");
INSERT INTO timezone VALUES("39","ACST","16165326600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16181051400","37800","1");
INSERT INTO timezone VALUES("39","ACST","16196776200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16212501000","37800","1");
INSERT INTO timezone VALUES("39","ACST","16228225800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16243950600","37800","1");
INSERT INTO timezone VALUES("39","ACST","16259675400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16276005000","37800","1");
INSERT INTO timezone VALUES("39","ACST","16291729800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16307454600","37800","1");
INSERT INTO timezone VALUES("39","ACST","16323179400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16338904200","37800","1");
INSERT INTO timezone VALUES("39","ACST","16354629000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16370353800","37800","1");
INSERT INTO timezone VALUES("39","ACST","16386078600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16401803400","37800","1");
INSERT INTO timezone VALUES("39","ACST","16417528200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16433253000","37800","1");
INSERT INTO timezone VALUES("39","ACST","16448977800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16465307400","37800","1");
INSERT INTO timezone VALUES("39","ACST","16481032200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16496757000","37800","1");
INSERT INTO timezone VALUES("39","ACST","16512481800","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16528206600","37800","1");
INSERT INTO timezone VALUES("39","ACST","16543931400","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16559656200","37800","1");
INSERT INTO timezone VALUES("39","ACST","16575381000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16591105800","37800","1");
INSERT INTO timezone VALUES("39","ACST","16606830600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16623160200","37800","1");
INSERT INTO timezone VALUES("39","ACST","16638885000","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16654609800","37800","1");
INSERT INTO timezone VALUES("39","ACST","16670334600","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16686059400","37800","1");
INSERT INTO timezone VALUES("39","ACST","16701784200","34200","0");
INSERT INTO timezone VALUES("39","ACDT","16717509000","37800","1");
INSERT INTO timezone VALUES("40","LMT","-2366791929","36728","0");
INSERT INTO timezone VALUES("40","AEST","-2366791928","36000","0");
INSERT INTO timezone VALUES("40","AEDT","-1672567140","39600","1");
INSERT INTO timezone VALUES("40","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("40","AEDT","-883641600","39600","1");
INSERT INTO timezone VALUES("40","AEST","-876128400","36000","0");
INSERT INTO timezone VALUES("40","AEDT","-860400000","39600","1");
INSERT INTO timezone VALUES("40","AEST","-844678800","36000","0");
INSERT INTO timezone VALUES("40","AEDT","-828345600","39600","1");
INSERT INTO timezone VALUES("40","AEST","-813229200","36000","0");
INSERT INTO timezone VALUES("40","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("40","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("40","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("40","AEST","636480000","36000","0");
INSERT INTO timezone VALUES("40","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("40","AEST","667929600","36000","0");
INSERT INTO timezone VALUES("40","AEDT","688492800","39600","1");
INSERT INTO timezone VALUES("40","AEST","699379200","36000","0");
INSERT INTO timezone VALUES("41","LMT","-2366790957","35756","0");
INSERT INTO timezone VALUES("41","AEST","-2366790956","36000","0");
INSERT INTO timezone VALUES("41","AEDT","-1672567140","39600","1");
INSERT INTO timezone VALUES("41","AEST","-1665392400","36000","0");
INSERT INTO timezone VALUES("41","AEDT","-883641600","39600","1");
INSERT INTO timezone VALUES("41","AEST","-876128400","36000","0");
INSERT INTO timezone VALUES("41","AEDT","-860400000","39600","1");
INSERT INTO timezone VALUES("41","AEST","-844678800","36000","0");
INSERT INTO timezone VALUES("41","AEDT","-828345600","39600","1");
INSERT INTO timezone VALUES("41","AEST","-813229200","36000","0");
INSERT INTO timezone VALUES("41","AEDT","57686400","39600","1");
INSERT INTO timezone VALUES("41","AEST","67968000","36000","0");
INSERT INTO timezone VALUES("41","AEDT","625593600","39600","1");
INSERT INTO timezone VALUES("41","AEST","636480000","36000","0");
INSERT INTO timezone VALUES("41","AEDT","657043200","39600","1");
INSERT INTO timezone VALUES("41","AEST","667929600","36000","0");
INSERT INTO timezone VALUES("41","AEDT","688492800","39600","1");
INSERT INTO timezone VALUES("41","AEST","699379200","36000","0");
INSERT INTO timezone VALUES("41","AEDT","719942400","39600","1");
INSERT INTO timezone VALUES("41","AEST","731433600","36000","0");
INSERT INTO timezone VALUES("41","AEDT","751996800","39600","1");
INSERT INTO timezone VALUES("41","AEST","762883200","36000","0");
INSERT INTO timezone VALUES("42","LMT","-2364110061","33260","0");
INSERT INTO timezone VALUES("42","ACST","-2364110060","32400","0");
INSERT INTO timezone VALUES("42","ACST","-2230189200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","-1672565340","37800","1");
INSERT INTO timezone VALUES("42","ACST","-1665390600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","-883639800","37800","1");
INSERT INTO timezone VALUES("42","ACST","-876126600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","-860398200","37800","1");
INSERT INTO timezone VALUES("42","ACST","-844677000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","-828343800","37800","1");
INSERT INTO timezone VALUES("42","ACST","-813227400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","57688200","37800","1");
INSERT INTO timezone VALUES("42","ACST","67969800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","89137800","37800","1");
INSERT INTO timezone VALUES("42","ACST","100024200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","120587400","37800","1");
INSERT INTO timezone VALUES("42","ACST","131473800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","152037000","37800","1");
INSERT INTO timezone VALUES("42","ACST","162923400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","183486600","37800","1");
INSERT INTO timezone VALUES("42","ACST","194977800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","215541000","37800","1");
INSERT INTO timezone VALUES("42","ACST","226427400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","246990600","37800","1");
INSERT INTO timezone VALUES("42","ACST","257877000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","278440200","37800","1");
INSERT INTO timezone VALUES("42","ACST","289326600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","309889800","37800","1");
INSERT INTO timezone VALUES("42","ACST","320776200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","341339400","37800","1");
INSERT INTO timezone VALUES("42","ACST","352225800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","372789000","37800","1");
INSERT INTO timezone VALUES("42","ACST","384280200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","404843400","37800","1");
INSERT INTO timezone VALUES("42","ACST","415729800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","436293000","37800","1");
INSERT INTO timezone VALUES("42","ACST","447179400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","467742600","37800","1");
INSERT INTO timezone VALUES("42","ACST","478629000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","499192200","37800","1");
INSERT INTO timezone VALUES("42","ACST","511288200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","530037000","37800","1");
INSERT INTO timezone VALUES("42","ACST","542737800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","562091400","37800","1");
INSERT INTO timezone VALUES("42","ACST","574792200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","594145800","37800","1");
INSERT INTO timezone VALUES("42","ACST","606241800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","625595400","37800","1");
INSERT INTO timezone VALUES("42","ACST","637691400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","657045000","37800","1");
INSERT INTO timezone VALUES("42","ACST","667931400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","688494600","37800","1");
INSERT INTO timezone VALUES("42","ACST","701195400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","719944200","37800","1");
INSERT INTO timezone VALUES("42","ACST","731435400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","751998600","37800","1");
INSERT INTO timezone VALUES("42","ACST","764094600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","783448200","37800","1");
INSERT INTO timezone VALUES("42","ACST","796149000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","814897800","37800","1");
INSERT INTO timezone VALUES("42","ACST","828203400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","846347400","37800","1");
INSERT INTO timezone VALUES("42","ACST","859653000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","877797000","37800","1");
INSERT INTO timezone VALUES("42","ACST","891102600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","909246600","37800","1");
INSERT INTO timezone VALUES("42","ACST","922552200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","941301000","37800","1");
INSERT INTO timezone VALUES("42","ACST","954001800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","972750600","37800","1");
INSERT INTO timezone VALUES("42","ACST","985451400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1004200200","37800","1");
INSERT INTO timezone VALUES("42","ACST","1017505800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1035649800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1048955400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1067099400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1080405000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1099153800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1111854600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1130603400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1143909000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1162053000","37800","1");
INSERT INTO timezone VALUES("42","ACST","1174753800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1193502600","37800","1");
INSERT INTO timezone VALUES("42","ACST","1207413000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1223137800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1238862600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1254587400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1270312200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1286037000","37800","1");
INSERT INTO timezone VALUES("42","ACST","1301761800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1317486600","37800","1");
INSERT INTO timezone VALUES("42","ACST","1333211400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1349541000","37800","1");
INSERT INTO timezone VALUES("42","ACST","1365265800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1380990600","37800","1");
INSERT INTO timezone VALUES("42","ACST","1396715400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1412440200","37800","1");
INSERT INTO timezone VALUES("42","ACST","1428165000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1443889800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1459614600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1475339400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1491064200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1506789000","37800","1");
INSERT INTO timezone VALUES("42","ACST","1522513800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1538843400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1554568200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1570293000","37800","1");
INSERT INTO timezone VALUES("42","ACST","1586017800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1601742600","37800","1");
INSERT INTO timezone VALUES("42","ACST","1617467400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1633192200","37800","1");
INSERT INTO timezone VALUES("42","ACST","1648917000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1664641800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1680366600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1696091400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1712421000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1728145800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1743870600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1759595400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1775320200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1791045000","37800","1");
INSERT INTO timezone VALUES("42","ACST","1806769800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1822494600","37800","1");
INSERT INTO timezone VALUES("42","ACST","1838219400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1853944200","37800","1");
INSERT INTO timezone VALUES("42","ACST","1869669000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1885998600","37800","1");
INSERT INTO timezone VALUES("42","ACST","1901723400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1917448200","37800","1");
INSERT INTO timezone VALUES("42","ACST","1933173000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1948897800","37800","1");
INSERT INTO timezone VALUES("42","ACST","1964622600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","1980347400","37800","1");
INSERT INTO timezone VALUES("42","ACST","1996072200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2011797000","37800","1");
INSERT INTO timezone VALUES("42","ACST","2027521800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2043246600","37800","1");
INSERT INTO timezone VALUES("42","ACST","2058971400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2075301000","37800","1");
INSERT INTO timezone VALUES("42","ACST","2091025800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2106750600","37800","1");
INSERT INTO timezone VALUES("42","ACST","2122475400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2138200200","37800","1");
INSERT INTO timezone VALUES("42","ACST","2153925000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2169649800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2185374600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2201099400","37800","1");
INSERT INTO timezone VALUES("42","ACST","2216824200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2233153800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2248878600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2264603400","37800","1");
INSERT INTO timezone VALUES("42","ACST","2280328200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2296053000","37800","1");
INSERT INTO timezone VALUES("42","ACST","2311777800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2327502600","37800","1");
INSERT INTO timezone VALUES("42","ACST","2343227400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2358952200","37800","1");
INSERT INTO timezone VALUES("42","ACST","2374677000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2390401800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2406126600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2422456200","37800","1");
INSERT INTO timezone VALUES("42","ACST","2438181000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2453905800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2469630600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2485355400","37800","1");
INSERT INTO timezone VALUES("42","ACST","2501080200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2516805000","37800","1");
INSERT INTO timezone VALUES("42","ACST","2532529800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2548254600","37800","1");
INSERT INTO timezone VALUES("42","ACST","2563979400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2579704200","37800","1");
INSERT INTO timezone VALUES("42","ACST","2596033800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2611758600","37800","1");
INSERT INTO timezone VALUES("42","ACST","2627483400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2643208200","37800","1");
INSERT INTO timezone VALUES("42","ACST","2658933000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2674657800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2690382600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2706107400","37800","1");
INSERT INTO timezone VALUES("42","ACST","2721832200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2737557000","37800","1");
INSERT INTO timezone VALUES("42","ACST","2753281800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2769611400","37800","1");
INSERT INTO timezone VALUES("42","ACST","2785336200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2801061000","37800","1");
INSERT INTO timezone VALUES("42","ACST","2816785800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2832510600","37800","1");
INSERT INTO timezone VALUES("42","ACST","2848235400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2863960200","37800","1");
INSERT INTO timezone VALUES("42","ACST","2879685000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2895409800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2911134600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2926859400","37800","1");
INSERT INTO timezone VALUES("42","ACST","2942584200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2958913800","37800","1");
INSERT INTO timezone VALUES("42","ACST","2974638600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","2990363400","37800","1");
INSERT INTO timezone VALUES("42","ACST","3006088200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3021813000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3037537800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3053262600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3068987400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3084712200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3100437000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3116766600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3132491400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3148216200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3163941000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3179665800","37800","1");
INSERT INTO timezone VALUES("42","ACST","3195390600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3211115400","37800","1");
INSERT INTO timezone VALUES("42","ACST","3226840200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3242565000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3258289800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3274014600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3289739400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3306069000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3321793800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3337518600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3353243400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3368968200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3384693000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3400417800","37800","1");
INSERT INTO timezone VALUES("42","ACST","3416142600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3431867400","37800","1");
INSERT INTO timezone VALUES("42","ACST","3447592200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3463317000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3479646600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3495371400","37800","1");
INSERT INTO timezone VALUES("42","ACST","3511096200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3526821000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3542545800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3558270600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3573995400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3589720200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3605445000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3621169800","37800","1");
INSERT INTO timezone VALUES("42","ACST","3636894600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3653224200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3668949000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3684673800","37800","1");
INSERT INTO timezone VALUES("42","ACST","3700398600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3716123400","37800","1");
INSERT INTO timezone VALUES("42","ACST","3731848200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3747573000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3763297800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3779022600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3794747400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3810472200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3826197000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3842526600","37800","1");
INSERT INTO timezone VALUES("42","ACST","3858251400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3873976200","37800","1");
INSERT INTO timezone VALUES("42","ACST","3889701000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3905425800","37800","1");
INSERT INTO timezone VALUES("42","ACST","3921150600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3936875400","37800","1");
INSERT INTO timezone VALUES("42","ACST","3952600200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","3968325000","37800","1");
INSERT INTO timezone VALUES("42","ACST","3984049800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4000379400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4016104200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4031829000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4047553800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4063278600","37800","1");
INSERT INTO timezone VALUES("42","ACST","4079003400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4094728200","37800","1");
INSERT INTO timezone VALUES("42","ACST","4110453000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4126177800","37800","1");
INSERT INTO timezone VALUES("42","ACST","4141902600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4157627400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4173352200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4189077000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4204801800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4221131400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4236856200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4252581000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4268305800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4284030600","37800","1");
INSERT INTO timezone VALUES("42","ACST","4299755400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4315480200","37800","1");
INSERT INTO timezone VALUES("42","ACST","4331205000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4346929800","37800","1");
INSERT INTO timezone VALUES("42","ACST","4362654600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4378984200","37800","1");
INSERT INTO timezone VALUES("42","ACST","4394709000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4410433800","37800","1");
INSERT INTO timezone VALUES("42","ACST","4426158600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4441883400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4457608200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4473333000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4489057800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4504782600","37800","1");
INSERT INTO timezone VALUES("42","ACST","4520507400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4536232200","37800","1");
INSERT INTO timezone VALUES("42","ACST","4551957000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4568286600","37800","1");
INSERT INTO timezone VALUES("42","ACST","4584011400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4599736200","37800","1");
INSERT INTO timezone VALUES("42","ACST","4615461000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4631185800","37800","1");
INSERT INTO timezone VALUES("42","ACST","4646910600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4662635400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4678360200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4694085000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4709809800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4725534600","37800","1");
INSERT INTO timezone VALUES("42","ACST","4741864200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4757589000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4773313800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4789038600","37800","1");
INSERT INTO timezone VALUES("42","ACST","4804763400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4820488200","37800","1");
INSERT INTO timezone VALUES("42","ACST","4836213000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4851937800","37800","1");
INSERT INTO timezone VALUES("42","ACST","4867662600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4883387400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4899112200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4915441800","37800","1");
INSERT INTO timezone VALUES("42","ACST","4931166600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4946891400","37800","1");
INSERT INTO timezone VALUES("42","ACST","4962616200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","4978341000","37800","1");
INSERT INTO timezone VALUES("42","ACST","4994065800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5009790600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5025515400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5041240200","37800","1");
INSERT INTO timezone VALUES("42","ACST","5056965000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5072689800","37800","1");
INSERT INTO timezone VALUES("42","ACST","5088414600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5104744200","37800","1");
INSERT INTO timezone VALUES("42","ACST","5120469000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5136193800","37800","1");
INSERT INTO timezone VALUES("42","ACST","5151918600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5167643400","37800","1");
INSERT INTO timezone VALUES("42","ACST","5183368200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5199093000","37800","1");
INSERT INTO timezone VALUES("42","ACST","5214817800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5230542600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5246267400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5262597000","37800","1");
INSERT INTO timezone VALUES("42","ACST","5278321800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5294046600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5309771400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5325496200","37800","1");
INSERT INTO timezone VALUES("42","ACST","5341221000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5356945800","37800","1");
INSERT INTO timezone VALUES("42","ACST","5372670600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5388395400","37800","1");
INSERT INTO timezone VALUES("42","ACST","5404120200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5419845000","37800","1");
INSERT INTO timezone VALUES("42","ACST","5435569800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5451899400","37800","1");
INSERT INTO timezone VALUES("42","ACST","5467624200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5483349000","37800","1");
INSERT INTO timezone VALUES("42","ACST","5499073800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5514798600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5530523400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5546248200","37800","1");
INSERT INTO timezone VALUES("42","ACST","5561973000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5577697800","37800","1");
INSERT INTO timezone VALUES("42","ACST","5593422600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5609147400","37800","1");
INSERT INTO timezone VALUES("42","ACST","5625477000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5641201800","37800","1");
INSERT INTO timezone VALUES("42","ACST","5656926600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5672651400","37800","1");
INSERT INTO timezone VALUES("42","ACST","5688376200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5704101000","37800","1");
INSERT INTO timezone VALUES("42","ACST","5719825800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5735550600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5751275400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5767000200","37800","1");
INSERT INTO timezone VALUES("42","ACST","5782725000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5799054600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5814779400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5830504200","37800","1");
INSERT INTO timezone VALUES("42","ACST","5846229000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5861953800","37800","1");
INSERT INTO timezone VALUES("42","ACST","5877678600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5893403400","37800","1");
INSERT INTO timezone VALUES("42","ACST","5909128200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5924853000","37800","1");
INSERT INTO timezone VALUES("42","ACST","5940577800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5956302600","37800","1");
INSERT INTO timezone VALUES("42","ACST","5972027400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","5988357000","37800","1");
INSERT INTO timezone VALUES("42","ACST","6004081800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6019806600","37800","1");
INSERT INTO timezone VALUES("42","ACST","6035531400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6051256200","37800","1");
INSERT INTO timezone VALUES("42","ACST","6066981000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6082705800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6098430600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6114155400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6129880200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6146209800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6161934600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6177659400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6193384200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6209109000","37800","1");
INSERT INTO timezone VALUES("42","ACST","6224833800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6240558600","37800","1");
INSERT INTO timezone VALUES("42","ACST","6256283400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6272008200","37800","1");
INSERT INTO timezone VALUES("42","ACST","6287733000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6303457800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6319182600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6335512200","37800","1");
INSERT INTO timezone VALUES("42","ACST","6351237000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6366961800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6382686600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6398411400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6414136200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6429861000","37800","1");
INSERT INTO timezone VALUES("42","ACST","6445585800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6461310600","37800","1");
INSERT INTO timezone VALUES("42","ACST","6477035400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6492760200","37800","1");
INSERT INTO timezone VALUES("42","ACST","6509089800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6524814600","37800","1");
INSERT INTO timezone VALUES("42","ACST","6540539400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6556264200","37800","1");
INSERT INTO timezone VALUES("42","ACST","6571989000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6587713800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6603438600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6619163400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6634888200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6650613000","37800","1");
INSERT INTO timezone VALUES("42","ACST","6666337800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6682667400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6698392200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6714117000","37800","1");
INSERT INTO timezone VALUES("42","ACST","6729841800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6745566600","37800","1");
INSERT INTO timezone VALUES("42","ACST","6761291400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6777016200","37800","1");
INSERT INTO timezone VALUES("42","ACST","6792741000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6808465800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6824190600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6839915400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6855640200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6871969800","37800","1");
INSERT INTO timezone VALUES("42","ACST","6887694600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6903419400","37800","1");
INSERT INTO timezone VALUES("42","ACST","6919144200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6934869000","37800","1");
INSERT INTO timezone VALUES("42","ACST","6950593800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6966318600","37800","1");
INSERT INTO timezone VALUES("42","ACST","6982043400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","6997768200","37800","1");
INSERT INTO timezone VALUES("42","ACST","7013493000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7029822600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7045547400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7061272200","37800","1");
INSERT INTO timezone VALUES("42","ACST","7076997000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7092721800","37800","1");
INSERT INTO timezone VALUES("42","ACST","7108446600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7124171400","37800","1");
INSERT INTO timezone VALUES("42","ACST","7139896200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7155621000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7171345800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7187070600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7202795400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7219125000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7234849800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7250574600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7266299400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7282024200","37800","1");
INSERT INTO timezone VALUES("42","ACST","7297749000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7313473800","37800","1");
INSERT INTO timezone VALUES("42","ACST","7329198600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7344923400","37800","1");
INSERT INTO timezone VALUES("42","ACST","7360648200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7376373000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7392097800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7408427400","37800","1");
INSERT INTO timezone VALUES("42","ACST","7424152200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7439877000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7455601800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7471326600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7487051400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7502776200","37800","1");
INSERT INTO timezone VALUES("42","ACST","7518501000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7534225800","37800","1");
INSERT INTO timezone VALUES("42","ACST","7549950600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7565675400","37800","1");
INSERT INTO timezone VALUES("42","ACST","7581400200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7597729800","37800","1");
INSERT INTO timezone VALUES("42","ACST","7613454600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7629179400","37800","1");
INSERT INTO timezone VALUES("42","ACST","7644904200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7660629000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7676353800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7692078600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7707803400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7723528200","37800","1");
INSERT INTO timezone VALUES("42","ACST","7739253000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7754977800","37800","1");
INSERT INTO timezone VALUES("42","ACST","7771307400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7787032200","37800","1");
INSERT INTO timezone VALUES("42","ACST","7802757000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7818481800","37800","1");
INSERT INTO timezone VALUES("42","ACST","7834206600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7849931400","37800","1");
INSERT INTO timezone VALUES("42","ACST","7865656200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7881381000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7897105800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7912830600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7928555400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7944885000","37800","1");
INSERT INTO timezone VALUES("42","ACST","7960609800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","7976334600","37800","1");
INSERT INTO timezone VALUES("42","ACST","7992059400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8007784200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8023509000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8039233800","37800","1");
INSERT INTO timezone VALUES("42","ACST","8054958600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8070683400","37800","1");
INSERT INTO timezone VALUES("42","ACST","8086408200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8102133000","37800","1");
INSERT INTO timezone VALUES("42","ACST","8117857800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8134187400","37800","1");
INSERT INTO timezone VALUES("42","ACST","8149912200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8165637000","37800","1");
INSERT INTO timezone VALUES("42","ACST","8181361800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8197086600","37800","1");
INSERT INTO timezone VALUES("42","ACST","8212811400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8228536200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8244261000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8259985800","37800","1");
INSERT INTO timezone VALUES("42","ACST","8275710600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8292040200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8307765000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8323489800","37800","1");
INSERT INTO timezone VALUES("42","ACST","8339214600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8354939400","37800","1");
INSERT INTO timezone VALUES("42","ACST","8370664200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8386389000","37800","1");
INSERT INTO timezone VALUES("42","ACST","8402113800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8417838600","37800","1");
INSERT INTO timezone VALUES("42","ACST","8433563400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8449288200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8465013000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8481342600","37800","1");
INSERT INTO timezone VALUES("42","ACST","8497067400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8512792200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8528517000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8544241800","37800","1");
INSERT INTO timezone VALUES("42","ACST","8559966600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8575691400","37800","1");
INSERT INTO timezone VALUES("42","ACST","8591416200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8607141000","37800","1");
INSERT INTO timezone VALUES("42","ACST","8622865800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8638590600","37800","1");
INSERT INTO timezone VALUES("42","ACST","8654920200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8670645000","37800","1");
INSERT INTO timezone VALUES("42","ACST","8686369800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8702094600","37800","1");
INSERT INTO timezone VALUES("42","ACST","8717819400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8733544200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8749269000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8764993800","37800","1");
INSERT INTO timezone VALUES("42","ACST","8780718600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8796443400","37800","1");
INSERT INTO timezone VALUES("42","ACST","8812168200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8828497800","37800","1");
INSERT INTO timezone VALUES("42","ACST","8844222600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8859947400","37800","1");
INSERT INTO timezone VALUES("42","ACST","8875672200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8891397000","37800","1");
INSERT INTO timezone VALUES("42","ACST","8907121800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8922846600","37800","1");
INSERT INTO timezone VALUES("42","ACST","8938571400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8954296200","37800","1");
INSERT INTO timezone VALUES("42","ACST","8970021000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","8985745800","37800","1");
INSERT INTO timezone VALUES("42","ACST","9001470600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9017800200","37800","1");
INSERT INTO timezone VALUES("42","ACST","9033525000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9049249800","37800","1");
INSERT INTO timezone VALUES("42","ACST","9064974600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9080699400","37800","1");
INSERT INTO timezone VALUES("42","ACST","9096424200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9112149000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9127873800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9143598600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9159323400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9175653000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9191377800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9207102600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9222827400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9238552200","37800","1");
INSERT INTO timezone VALUES("42","ACST","9254277000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9270001800","37800","1");
INSERT INTO timezone VALUES("42","ACST","9285726600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9301451400","37800","1");
INSERT INTO timezone VALUES("42","ACST","9317176200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9332901000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9348625800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9364955400","37800","1");
INSERT INTO timezone VALUES("42","ACST","9380680200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9396405000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9412129800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9427854600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9443579400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9459304200","37800","1");
INSERT INTO timezone VALUES("42","ACST","9475029000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9490753800","37800","1");
INSERT INTO timezone VALUES("42","ACST","9506478600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9522203400","37800","1");
INSERT INTO timezone VALUES("42","ACST","9538533000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9554257800","37800","1");
INSERT INTO timezone VALUES("42","ACST","9569982600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9585707400","37800","1");
INSERT INTO timezone VALUES("42","ACST","9601432200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9617157000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9632881800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9648606600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9664331400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9680056200","37800","1");
INSERT INTO timezone VALUES("42","ACST","9695781000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9712110600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9727835400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9743560200","37800","1");
INSERT INTO timezone VALUES("42","ACST","9759285000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9775009800","37800","1");
INSERT INTO timezone VALUES("42","ACST","9790734600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9806459400","37800","1");
INSERT INTO timezone VALUES("42","ACST","9822184200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9837909000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9853633800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9869358600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9885083400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9901413000","37800","1");
INSERT INTO timezone VALUES("42","ACST","9917137800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9932862600","37800","1");
INSERT INTO timezone VALUES("42","ACST","9948587400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9964312200","37800","1");
INSERT INTO timezone VALUES("42","ACST","9980037000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","9995761800","37800","1");
INSERT INTO timezone VALUES("42","ACST","10011486600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10027211400","37800","1");
INSERT INTO timezone VALUES("42","ACST","10042936200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10059265800","37800","1");
INSERT INTO timezone VALUES("42","ACST","10074990600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10090715400","37800","1");
INSERT INTO timezone VALUES("42","ACST","10106440200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10122165000","37800","1");
INSERT INTO timezone VALUES("42","ACST","10137889800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10153614600","37800","1");
INSERT INTO timezone VALUES("42","ACST","10169339400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10185064200","37800","1");
INSERT INTO timezone VALUES("42","ACST","10200789000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10216513800","37800","1");
INSERT INTO timezone VALUES("42","ACST","10232238600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10248568200","37800","1");
INSERT INTO timezone VALUES("42","ACST","10264293000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10280017800","37800","1");
INSERT INTO timezone VALUES("42","ACST","10295742600","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10311467400","37800","1");
INSERT INTO timezone VALUES("42","ACST","10327192200","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10342917000","37800","1");
INSERT INTO timezone VALUES("42","ACST","10358641800","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10374366600","37800","1");
INSERT INTO timezone VALUES("42","ACST","10390091400","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10405816200","37800","1");
INSERT INTO timezone VALUES("42","ACST","10421541000","34200","0");
INSERT INTO timezone VALUES("42","ACDT","10437870600","37800","1");
INSERT INTO timezone VALUES("42","ACST","10453595400","