<?php
define('ENVIRONMENT', 'production');
ob_start();
ini_set( 'session.use_only_cookies', TRUE );				
ini_set( 'session.use_trans_sid', FALSE );
ini_set( 'session.cookie_lifetime', 10800 );
ini_set('max_execution_time', 300); 
session_start();
session_regenerate_id();
$URL = 'dashboard';
// $URL is sanitiesed at module level before use
if(isset($_GET['url'])){ $URL = $_GET['url'];}
if($URL=='incomingCallback') header('HTTP/1.0 200 OK');
global $URL;
$_SESSION['request_token'] = time(); 
if(isset($_GET['exituser'])) {
	$_SESSION['manageUser'] = 0;
	unset($_SESSION['manageUser']);	
	header("location: index.php");
  	exit;
}
if(isset($_GET['SendroidLiteApp'])) {
	$_SESSION['SendroidLiteApp'] = time();
}
// $_SESSION['referrer'] input is sanitiesed at module level before use
if(isset($_GET['ref'])) {$_SESSION['referrer']=$_GET['ref'];} 

if (defined('ENVIRONMENT')){
	switch (ENVIRONMENT)	{
		case 'development':
			error_reporting(E_ALL);
		break;
	
		case 'testing':
		case 'production':
			error_reporting(0);
		break;

		default:
			exit('The application environment is not set correctly.');
	}
}

$system_path = 'system';
$application_folder = 'hooks';
$module_folder = 'modules';

	// Set the current directory correctly for CLI requests
	if (defined('STDIN')){
		chdir(dirname(__FILE__));
	}

	if (realpath($system_path) !== FALSE){
		$system_path = realpath($system_path).'/';
	}

	// ensure there's a trailing slash
	$system_path = rtrim($system_path, '/').'/';

	// Is the system path correct?
	if ( ! is_dir($system_path)){
		exit("Your system folder path does not appear to be set correctly. Please open the following file and correct this: ".pathinfo(__FILE__, PATHINFO_BASENAME));
	}
	// The name of THIS file
	define('SELF', pathinfo(__FILE__, PATHINFO_BASENAME));
	// The PHP file extension
	// this global constant is deprecated.
	define('EXT', '.php');
	// Path to the system folder
	define('BASEPATH', str_replace("\\", "/", $system_path));
	// Path to the front controller (this file)
	define('FCPATH', str_replace(SELF, '', __FILE__));
	// Name of the "system folder"
	define('SYSDIR', trim(strrchr(trim(BASEPATH, '/'), '/'), '/'));

	// The path to the "application" folder
	if (is_dir($application_folder)){
		define('APPPATH', $application_folder.'/');
		define('MODPATH', $module_folder.'/');
	}
	else{
		if ( ! is_dir(BASEPATH.$application_folder.'/'))	{
			exit("Your application folder path does not appear to be set correctly. Please open the following file and correct this: ".SELF);
		}
		define('APPPATH', BASEPATH.$application_folder.'/');
		define('MODPATH', BASEPATH.$module_folder.'/');
	}
if(isset($_GET['lang'])) {
	if(file_exists(BASEPATH.'lang/'.strtolower($_GET['lang']).'.php')) { $_SESSION['lang'] = strtolower($_GET['lang']);}
	header('location: index.php');
} 
	
define('COR', BASEPATH.'core/');	
define('LIB', BASEPATH.'libraries/');	
define('HELP', BASEPATH.'helpers/');	
define('HOOKS', BASEPATH.'eventhooks/');	
require_once 'root.php'; 
require_once BASEPATH.'core/Config.php';
foreach (glob(COR."/*.php") as $filename) { include $filename; }
foreach (glob(HELP."/*.php") as $filename) { include $filename; }
foreach (glob(LIB."/*.php") as $filename) { include $filename; } 
if(getSetting('phpErrorReporting',0)=='1') { error_reporting(E_ALL & ~E_NOTICE); }
if(!empty(setLang(1)) && strtolower(setLang(1))!=".php") { require_once BASEPATH.'lang/'.setLang(1); } 
else { require_once BASEPATH.'lang/en.php'; } 
foreach (glob(HOOKS."/*.php") as $filename) { include $filename; }
global $hooks;
$Config = new CI_Config();
setTimeZone();
$timeout = 1200;
if(isset($_GET['logout'])) {
	$companyWebsite = getSetting('companyWebsite',getUser());
	$redirectToSite = getSetting('redirectToSite',getUser());
	setcookie("SendroidUltimateUser", '', $timeout, '/'); // clear password;
	$_SESSION['SendroidUltimateUser'] = 0;
	unset($_COOKIE['SendroidUltimateUser']);
	unset($_SESSION['SendroidUltimateUser']);
	$_SESSION['manageUser'] = 0;
	unset($_SESSION['manageUser']);
	if(isset($_SESSION['SendroidLiteApp'])) {
		header("location: index.php");
		exit;
	}
	if($redirectToSite=='1' && !empty($companyWebsite)) {
		header("location: ".$companyWebsite);
	} else {
  		header("location: index.php");
	}
  exit;
}
//Upadte session
$current_session=$_COOKIE['SendroidUltimateUser'];
if($_SESSION['SendroidUltimateUser']<1 && $current_session >0) {
	$_SESSION['SendroidUltimateUser'] = $current_session;
}
if($URL!='smsapi'){loadHeaders($URL);}
which_app($URL);
loadFooters($URL);
mysqli_close($server);