﻿DROP TABLE IF EXISTS `smschat`;
CREATE TABLE `smschat` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `sender` varchar(30) NOT NULL,
  `receiver` varchar(30) NOT NULL,
  `message` varchar(666) NOT NULL,
  `number` VARCHAR(44) NOT NULL,
  `date` varchar(44) NOT NULL,
  `sent` INT NOT NULL DEFAULT '0',
  `seen` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

DROP TABLE IF EXISTS `api_templates`;
CREATE TABLE `api_templates` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `base_url` text NOT NULL,
  `success_word` varchar(100) NOT NULL,
  `json_encode` int(11) NOT NULL DEFAULT '0',
  `request_type` varchar(20) NOT NULL DEFAULT 'GET',
  `sender_field` text NOT NULL,
  `recipient_field` text NOT NULL,
  `message_field` text NOT NULL,
  `param1_field` text NOT NULL,
  `param2_field` text NOT NULL,
  `param3_field` text NOT NULL,
  `param4_field` text NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `language_field` text NOT NULL,
  `audio_field` text NOT NULL,
  `timeout_field` text NOT NULL,
  `speed_field` text NOT NULL,
  `authentication` text NOT NULL,
  `success_logic` varchar(333) NOT NULL DEFAULT 'contain',
  `dlr_enabled` int(11) NOT NULL DEFAULT '0',
  `dlr_callback` varchar(555) NOT NULL,
  `alias` varchar(333) NOT NULL DEFAULT 'custom',
  `param5_field` varchar(555) NOT NULL,
  `param5_label` varchar(555) NOT NULL,
  `param4_label` varchar(555) NOT NULL,
  `param3_label` varchar(555) NOT NULL,
  `param2_label` varchar(555) NOT NULL,
  `param1_label` varchar(555) NOT NULL,
  `tts_enabled` int(11) NOT NULL DEFAULT '1',
  `file_enabled` int(11) NOT NULL DEFAULT '1',
  `module_id` varchar(888) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '1',
  `base64_encode` int(11) NOT NULL DEFAULT '1',
  `setup_text` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `api_templates`;
INSERT INTO `api_templates` (`id`, `title`, `base_url`, `success_word`, `json_encode`, `request_type`, `sender_field`, `recipient_field`, `message_field`, `param1_field`, `param2_field`, `param3_field`, `param4_field`, `type`, `language_field`, `audio_field`, `timeout_field`, `speed_field`, `authentication`, `success_logic`, `dlr_enabled`, `dlr_callback`, `alias`, `param5_field`, `param5_label`, `param4_label`, `param3_label`, `param2_label`, `param1_label`, `tts_enabled`, `file_enabled`, `module_id`, `status`, `base64_encode`, `setup_text`) VALUES
(1, 'Custom HTTP Gateway', '', '', 0, 'GET', '', '', '', '', '', '', '', 'sms', '', '', '', '', '0', 'contain', 0, '', 'custom', '', '', '', '', '', '', 1, 1, '0', 1, 1, 'Refer to your SMS gateway API documentation for the correct parameters to use here'),
(2, 'Custom SMPP Gateway', '', 'ok', 0, 'POST', 'from', 'to', 'message', 'port', '', '', '', 'sms', '', '', '', '', '1', 'contain', 0, '', 'smpp', '', '', '', '', '', 'SMPP Port', 0, 0, '0', 1, 0, 'Contact your SMPP gateway for the correct parameters to use here. Please note that this template may not be compatible with all SMPP providers'),
(3, 'Incoming SMS Gateway', '', '', 0, 'GET', '', '', '', '', '', '', '', '2way', '', '', '', '', '0', 'contain', 0, '', 'incoming', '', '', '', '', '', '', 0, 0, '0', 1, 1, 'You must set up your SMS provider to push all incoming messages to the Callback URL before you can see your incoming SMS here!'),
(4, 'Twilio SMS Gateway', 'https://api.twilio.com/2010-04-01', 'queued', 1, 'POST', 'From', 'To', 'Body', '', '', '', '', 'sms', '', '', '', '', '1', 'contain', 0, '', 'twilio', '', '', '', '', '', 'Multimedia URL', 0, 0, '0', 1, 1, 'You will need to signup with https://twilio.com to use this gateway. <br>Use your Twilio SID as Username and Token as Password on this page to setup your gateway'),
(5, 'Twilio MMS Gateway', 'https://api.twilio.com/2010-04-01', 'queued', 1, 'POST', 'From', 'To', 'Body', '', '', '', '', 'mms', '', 'MediaUrl', '', '', '1', 'contain', 0, '', 'twilio', '', '', '', '', '', 'Multimedia URL', 0, 0, '0', 1, 1, 'You will need to signup with https://twilio.com to use this gateway. <br>Use your Twilio SID as Username and Token as Password on this page to setup your gateway'),
(6, 'Infobip SMS Gateway', 'http://api.infobip.com/sms/1/text/single', 'sent', 1, 'POST', 'from', 'to', 'text', '', '', '', '', 'sms', '', '', '', '', '1', 'contain', 1, '', 'infobip', '', '', '', '', '', '', 0, 0, '0', 1, 1, 'You will need to signup with https://infobip.com to use this gateway. <br>Use your Infobip Username and Password on this page to setup your gateway'),
(7, 'Infobip Voice Gateway', 'https://api.infobip.com/tts/2/messages', 'PROCESSING', 1, 'POST', 'from', 'to', 'text', '', '', '', '', 'voice', '', 'audioFileUrl', 'callTimeout', '', '1', 'contain', 0, '', 'infobipvoice', '', '', '', '', '', '', 1, 1, '0', 1, 1, 'You will need to signup with https://infobip.com to use this gateway. <br>Use your Infobip Username and Password on this page to setup your gateway'),
(8, 'Infobip Unicode Gateway', 'http://api.infobip.com/sms/1/binary/advanced', 'sent', 1, 'POST', 'from', 'to', 'hex', '', '', '', '', 'unicode', '', '', '', '', '1', 'contain', 1, '', 'infobipunicode', '', '', '', '', '', '', 0, 0, '0', 1, 1, 'You will need to signup with https://infobip.com to use this gateway. <br>Use your Infobip Username and Password on this page to setup your gateway'),
(9, 'Infobip Flash SMS Gateway', 'http://api.infobip.com/sms/1/text/advanced', 'sent', 1, 'POST', 'from', 'to', 'text', 'flash', '', '', '', 'flash', '', '', '', '', '1', 'contain', 1, '', 'infobipflash', '', '', '', '', '', 'Enable Flash', 0, 0, '0', 1, 1, 'You will need to signup with https://infobip.com to use this gateway. <br>Use your Infobip Username and Password on this page to setup your gateway'),
(10, 'SMSKit WhatsApp Gateway', 'https://account.smskit.net/smsAPI', 'queued', 0, 'GET', '', 'to', 'text', 'route', '', '', '', 'whatsapp', '', '', '', '', '1', 'contain', 0, '', 'smskitwhatsapp', '', '', '', '', '', 'Route ID (optional)', 0, 0, '0', 1, 0, 'You will need to signup with https://smskit.net to use this gateway. <br>Login to your SMSKit.net account and generate your API Key and Token under API menu. Use your API Key and Token as your Username and Password Respectively'),
(11, 'Twilio Voice Gateway', 'https://api.twilio.com/2010-04-01', 'queued', 1, 'POST', 'From', 'To', 'Url', '', '', '', '', 'voice', '', 'Url', '', '', '1', 'contain', 0, '', 'twilio', '', '', '', '', '', 'URL', 0, 0, '0', 1, 1, 'You will need to signup with https://twilio.com to use this gateway. <br>Use your Twilio SID as Username and Token as Password on this page to setup your gateway');

DROP TABLE IF EXISTS `backups`;
CREATE TABLE `backups` (
  `id` int(11) NOT NULL,
  `date` varchar(44) NOT NULL,
  `type` varchar(200) NOT NULL,
  `file` varchar(500) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `backups`;
DROP TABLE IF EXISTS `blacklist`;
CREATE TABLE `blacklist` (
  `id` int(11) NOT NULL,
  `date` varchar(44) NOT NULL ,
  `phone` varchar(30) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `blacklist`;
DROP TABLE IF EXISTS `contacts`;
CREATE TABLE `contacts` (
  `id` int(11) NOT NULL,
  `first_name` varchar(40) NOT NULL DEFAULT 'No Name',
  `phone` varchar(20) NOT NULL,
  `phonebook_id` int(11) NOT NULL,
  `birthday` varchar(44) NOT NULL,
  `last_name` varchar(555) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `contacts`;
DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  `country_code` char(2) COLLATE utf8_bin DEFAULT NULL,
  `country_name` varchar(45) COLLATE utf8_bin DEFAULT NULL,
  `id` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin ROW_FORMAT=DYNAMIC;

TRUNCATE TABLE `countries`;
INSERT INTO `countries` (`country_code`, `country_name`, `id`) VALUES
('AD', 'Andorra', 1),
('AE', 'United Arab Emirates', 2),
('AF', 'Afghanistan', 3),
('AG', 'Antigua and Barbuda', 4),
('AI', 'Anguilla', 5),
('AL', 'Albania', 6),
('AM', 'Armenia', 7),
('AN', 'Netherlands Antilles', 8),
('AO', 'Angola', 9),
('AQ', 'Antarctica', 10),
('AR', 'Argentina', 11),
('AS', 'American Samoa', 12),
('AT', 'Austria', 13),
('AU', 'Australia', 14),
('AW', 'Aruba', 15),
('AX', 'Aland Islands', 16),
('AZ', 'Azerbaijan', 17),
('BA', 'Bosnia and Herzegovina', 18),
('BB', 'Barbados', 19),
('BD', 'Bangladesh', 20),
('BE', 'Belgium', 21),
('BF', 'Burkina Faso', 22),
('BG', 'Bulgaria', 23),
('BH', 'Bahrain', 24),
('BI', 'Burundi', 25),
('BJ', 'Benin', 26),
('BL', 'Saint Barthélemy', 27),
('BM', 'Bermuda', 28),
('BN', 'Brunei', 29),
('BO', 'Bolivia', 30),
('BQ', 'Bonaire, Saint Eustatius and Saba ', 31),
('BR', 'Brazil', 32),
('BS', 'Bahamas', 33),
('BT', 'Bhutan', 34),
('BV', 'Bouvet Island', 35),
('BW', 'Botswana', 36),
('BY', 'Belarus', 37),
('BZ', 'Belize', 38),
('CA', 'Canada', 39),
('CC', 'Cocos Islands', 40),
('CD', 'Democratic Republic of Congo', 41),
('CF', 'Central African Republic', 42),
('CG', 'Republic of the Congo', 43),
('CH', 'Switzerland', 44),
('CI', 'Ivory Coast', 45),
('CK', 'Cook Islands', 46),
('CL', 'Chile', 47),
('CM', 'Cameroon', 48),
('CN', 'China', 49),
('CO', 'Colombia', 50),
('CR', 'Costa Rica', 51),
('CS', 'Serbia and Montenegro', 52),
('CU', 'Cuba', 53),
('CV', 'Cape Verde', 54),
('CW', 'Curaçao', 55),
('CX', 'Christmas Island', 56),
('CY', 'Cyprus', 57),
('CZ', 'Czech Republic', 58),
('DE', 'Germany', 59),
('DJ', 'Djibouti', 60),
('DK', 'Denmark', 61),
('DM', 'Dominica', 62),
('DO', 'Dominican Republic', 63),
('DZ', 'Algeria', 64),
('EC', 'Ecuador', 65),
('EE', 'Estonia', 66),
('EG', 'Egypt', 67),
('EH', 'Western Sahara', 68),
('ER', 'Eritrea', 69),
('ES', 'Spain', 70),
('ET', 'Ethiopia', 71),
('FI', 'Finland', 72),
('FJ', 'Fiji', 73),
('FK', 'Falkland Islands', 74),
('FM', 'Micronesia', 75),
('FO', 'Faroe Islands', 76),
('FR', 'France', 77),
('GA', 'Gabon', 78),
('GB', 'United Kingdom', 79),
('GD', 'Grenada', 80),
('GE', 'Georgia', 81),
('GF', 'French Guiana', 82),
('GG', 'Guernsey', 83),
('GH', 'Ghana', 84),
('GI', 'Gibraltar', 85),
('GL', 'Greenland', 86),
('GM', 'Gambia', 87),
('GN', 'Guinea', 88),
('GP', 'Guadeloupe', 89),
('GQ', 'Equatorial Guinea', 90),
('GR', 'Greece', 91),
('GS', 'South Georgia and the South Sandwich Islands', 92),
('GT', 'Guatemala', 93),
('GU', 'Guam', 94),
('GW', 'Guinea-Bissau', 95),
('GY', 'Guyana', 96),
('HK', 'Hong Kong', 97),
('HM', 'Heard Island and McDonald Islands', 98),
('HN', 'Honduras', 99),
('HR', 'Croatia', 100),
('HT', 'Haiti', 101),
('HU', 'Hungary', 102),
('ID', 'Indonesia', 103),
('IE', 'Ireland', 104),
('IL', 'Israel', 105),
('IM', 'Isle of Man', 106),
('IN', 'India', 107),
('IO', 'British Indian Ocean Territory', 108),
('IQ', 'Iraq', 109),
('IR', 'Iran', 110),
('IS', 'Iceland', 111),
('IT', 'Italy', 112),
('JE', 'Jersey', 113),
('JM', 'Jamaica', 114),
('JO', 'Jordan', 115),
('JP', 'Japan', 116),
('KE', 'Kenya', 117),
('KG', 'Kyrgyzstan', 118),
('KH', 'Cambodia', 119),
('KI', 'Kiribati', 120),
('KM', 'Comoros', 121),
('KN', 'Saint Kitts and Nevis', 122),
('KP', 'North Korea', 123),
('KR', 'South Korea', 124),
('KW', 'Kuwait', 125),
('KY', 'Cayman Islands', 126),
('KZ', 'Kazakhstan', 127),
('LA', 'Laos', 128),
('LB', 'Lebanon', 129),
('LC', 'Saint Lucia', 130),
('LI', 'Liechtenstein', 131),
('LK', 'Sri Lanka', 132),
('LR', 'Liberia', 133),
('LS', 'Lesotho', 134),
('LT', 'Lithuania', 135),
('LU', 'Luxembourg', 136),
('LV', 'Latvia', 137),
('LY', 'Libya', 138),
('MA', 'Morocco', 139),
('MC', 'Monaco', 140),
('MD', 'Moldova', 141),
('ME', 'Montenegro', 142),
('MF', 'Saint Martin', 143),
('MG', 'Madagascar', 144),
('MH', 'Marshall Islands', 145),
('MK', 'Macedonia', 146),
('ML', 'Mali', 147),
('MM', 'Myanmar', 148),
('MN', 'Mongolia', 149),
('MO', 'Macao', 150),
('MP', 'Northern Mariana Islands', 151),
('MQ', 'Martinique', 152),
('MR', 'Mauritania', 153),
('MS', 'Montserrat', 154),
('MT', 'Malta', 155),
('MU', 'Mauritius', 156),
('MV', 'Maldives', 157),
('MW', 'Malawi', 158),
('MX', 'Mexico', 159),
('MY', 'Malaysia', 160),
('MZ', 'Mozambique', 161),
('NA', 'Namibia', 162),
('NC', 'New Caledonia', 163),
('NE', 'Niger', 164),
('NF', 'Norfolk Island', 165),
('NG', 'Nigeria', 166),
('NI', 'Nicaragua', 167),
('NL', 'Netherlands', 168),
('NO', 'Norway', 169),
('NP', 'Nepal', 170),
('NR', 'Nauru', 171),
('NU', 'Niue', 172),
('NZ', 'New Zealand', 173),
('OM', 'Oman', 174),
('PA', 'Panama', 175),
('PE', 'Peru', 176),
('PF', 'French Polynesia', 177),
('PG', 'Papua New Guinea', 178),
('PH', 'Philippines', 179),
('PK', 'Pakistan', 180),
('PL', 'Poland', 181),
('PM', 'Saint Pierre and Miquelon', 182),
('PN', 'Pitcairn', 183),
('PR', 'Puerto Rico', 184),
('PS', 'Palestinian Territory', 185),
('PT', 'Portugal', 186),
('PW', 'Palau', 187),
('PY', 'Paraguay', 188),
('QA', 'Qatar', 189),
('RE', 'Reunion', 190),
('RO', 'Romania', 191),
('RS', 'Serbia', 192),
('RU', 'Russia', 193),
('RW', 'Rwanda', 194),
('SA', 'Saudi Arabia', 195),
('SB', 'Solomon Islands', 196),
('SC', 'Seychelles', 197),
('SD', 'Sudan', 198),
('SE', 'Sweden', 199),
('SG', 'Singapore', 200),
('SH', 'Saint Helena', 201),
('SI', 'Slovenia', 202),
('SJ', 'Svalbard and Jan Mayen', 203),
('SK', 'Slovakia', 204),
('SL', 'Sierra Leone', 205),
('SM', 'San Marino', 206),
('SN', 'Senegal', 207),
('SO', 'Somalia', 208),
('SR', 'Suriname', 209),
('SS', 'South Sudan', 210),
('ST', 'Sao Tome and Principe', 211),
('SV', 'El Salvador', 212),
('SX', 'Sint Maarten', 213),
('SY', 'Syria', 214),
('SZ', 'Swaziland', 215),
('TC', 'Turks and Caicos Islands', 216),
('TD', 'Chad', 217),
('TF', 'French Southern Territories', 218),
('TG', 'Togo', 219),
('TH', 'Thailand', 220),
('TJ', 'Tajikistan', 221),
('TK', 'Tokelau', 222),
('TL', 'East Timor', 223),
('TM', 'Turkmenistan', 224),
('TN', 'Tunisia', 225),
('TO', 'Tonga', 226),
('TR', 'Turkey', 227),
('TT', 'Trinidad and Tobago', 228),
('TV', 'Tuvalu', 229),
('TW', 'Taiwan', 230),
('TZ', 'Tanzania', 231),
('UA', 'Ukraine', 232),
('UG', 'Uganda', 233),
('UM', 'United States Minor Outlying Islands', 234),
('US', 'United States', 235),
('UY', 'Uruguay', 236),
('UZ', 'Uzbekistan', 237),
('VA', 'Vatican', 238),
('VC', 'Saint Vincent and the Grenadines', 239),
('VE', 'Venezuela', 240),
('VG', 'British Virgin Islands', 241),
('VI', 'U.S. Virgin Islands', 242),
('VN', 'Vietnam', 243),
('VU', 'Vanuatu', 244),
('WF', 'Wallis and Futuna', 245),
('WS', 'Samoa', 246),
('XK', 'Kosovo', 247),
('YE', 'Yemen', 248),
('YT', 'Mayotte', 249),
('ZA', 'South Africa', 250),
('ZM', 'Zambia', 251),
('ZW', 'Zimbabwe', 252);

DROP TABLE IF EXISTS `country_codes`;
CREATE TABLE `country_codes` (
  `id` int(11) NOT NULL,
  `title` varchar(300) NOT NULL,
  `code` varchar(10) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

TRUNCATE TABLE `country_codes`;
INSERT INTO `country_codes` (`id`, `title`, `code`) VALUES
(3, '+91 India', '+91'),
(4, '+234 Nigeria', '+234'),
(5, '+7 Abkhazia', '+7'),
(6, '+93 Afghanistan', '+93'),
(7, '+355 Albania', '+355'),
(8, '+213 Algeria', '+213'),
(9, '+376 Andorra', '+376'),
(10, '+244 Angola', '+244'),
(11, '+54 Argentina', '+54'),
(12, '+297 Aruba', '+297'),
(13, '+61 Australia', '+61'),
(14, '+43 Austria', '+43'),
(15, '+994  Azerbaijan', '+994'),
(16, '+973 Bahrain', '+973'),
(17, '+880 Bangladesh', '+880'),
(18, '+375 Belarus', '+375'),
(19, '+32  Belgium', '+32'),
(20, '+501 Belize', '+501'),
(21, '+229 Benin', '+229'),
(22, '+975 Bhutan', '+975'),
(23, '+591 Bolivia', '+591'),
(24, '+387 Bosnia and Herzegovina', '+387'),
(25, '+267 Botswana', '+267'),
(26, '+359 Bulgaria', '+359'),
(27, '+226 Burkina Faso', '+226'),
(28, '+257 Burundi', '+257'),
(29, '+855 Cambodia', '+855'),
(30, '+237 Cameroon', '+237'),
(31, '+238 Cape Verde', '+238'),
(32, '+236 Central African Republic', '+236'),
(33, '+56 Chile', '+56'),
(34, '+86 China', '+86'),
(35, '+1 Canada', '+1'),
(36, '+269 Comoros', '+269'),
(37, '+243 Congo (Democratic)', '+243'),
(38, '+242 Congo (Republic)', '+242'),
(39, '+682 Cook Islands', '+682'),
(40, '+506 Costa Rica', '+506'),
(41, '+225 Ivory Coast', '+225'),
(42, '+385 Croatia', '+385'),
(43, '+53 Cuba', '+53'),
(44, '+357 Cyprus', '+357'),
(45, '+420 Czech Republic', '+420'),
(46, '+45 Denmark', '+45'),
(47, '+253 Djibouti', '+253'),
(48, '+593 Ecuador', '+593'),
(49, '+20 Egypt', '+20'),
(50, '+503 El Salvador', '+503'),
(51, '+240 Equatorial Guinea', '+240'),
(52, '+291 Eritrea', '+291'),
(53, '+372 Estonia', '+372'),
(54, '+251 Ethiopia', '+251'),
(55, '+33 France', '+33'),
(56, '+241 Gabon', '+241'),
(57, '+220 Gambia', '+220'),
(58, '+30 Greece', '+30'),
(59, '+245 Guinea Bissau', '+245'),
(60, '+36 Hungary', '+36'),
(61, '+374 Armenia', '+374'),
(62, '+235 Chad', '+235'),
(63, '+55 Brazil', '+55'),
(64, '+57 Colombia', '+57'),
(65, '+500 Falkland Islands', '+500'),
(66, '+298 Faroe Islands', '+298'),
(67, '+679 Fiji', '+679'),
(68, '+358 Finland', '+358'),
(69, '+594 French Guiana', '+594'),
(70, '+995 Georgia', '+995'),
(71, '+49  Germany', '+49'),
(72, '+233 Ghana', '+233'),
(73, '+350 Gibraltar', '+350'),
(74, '+299 Greenland', '+299'),
(75, '+590 Guadeloupe', '+590'),
(76, '+502 Guatemala', '+502'),
(77, '+44 Guernsey Channel Islands', '+44'),
(78, '+592  Guyana', '+592'),
(79, '+509 Haiti', '+509'),
(80, '+504 Hondura', '+504'),
(81, '+852  Hong Kong', '+852'),
(82, '+354 Iceland', '+354'),
(83, '+62 Indonesia', '+62'),
(84, '+98 Iran', '+98'),
(85, '+964 Iraq', '+964'),
(86, '+353 Ireland', '+353'),
(87, '+44 Isle of Man', '+44'),
(88, '+972 Israel', '+972'),
(89, '+39 Italy', '+39'),
(90, '+81 Japan', '+81'),
(91, '+44 Jersey', '+44'),
(92, '+962 Jordan', '+962'),
(93, '+7 Kazakhstan', '+7'),
(94, '+254 Kenya', '+254'),
(95, '+82 South Korea', '+82'),
(96, '+965 Kuwait', '+965'),
(97, '+996 Kyrgyzstan', '+996'),
(98, '+856 Laos', '+856'),
(99, '+371 Latvia', '+371'),
(100, '+961 Lebanon', '+961'),
(101, '+266 Lesotho', '+266'),
(102, '+231 Liberia', '+231'),
(103, '+218 Libya', '+218'),
(104, '+423 Liechtenstein', '+423'),
(105, '+370 Lithuania', '+370'),
(106, '+352 Luxembourg', '+352'),
(107, '+853 Macao', '+853'),
(108, '+389 Macedonia', '+389'),
(109, '+261 Madagascar', '+261'),
(110, '+265 Malawi', '+265'),
(111, '+60 Malaysia', '+60'),
(112, '+960 Maldives', '+960'),
(113, '+223 Mali', '+223'),
(114, '+356 Malta', '+356'),
(115, '+222 Mauritania', '+222'),
(116, '+230 Mauritius', '+230'),
(117, '+262 Mayotte', '+262'),
(118, '+52 Mexico', '+52'),
(119, '+691 Micronesia', '+691'),
(120, '+373 Moldova', '+373'),
(121, '+377 Monaco', '+377'),
(122, '+976 Mongolia', '+976'),
(123, '+382 Montenegro', '+382'),
(124, '+212 Morocco', '+212'),
(125, '+258 Mozambique', '+258'),
(126, '+264 Namibia', '+264'),
(127, '+977 Nepal', '+977'),
(128, '+31 Netherlands', '+31'),
(129, '+599 Netherlands Antilles', '+599'),
(130, '+687 New Caledonia', '+687'),
(131, '+64 New Zealand', '+64'),
(132, '+505 Nicaragua', '+505'),
(133, '+227 Niger', '+227'),
(134, '+47 Norway', '+47'),
(135, '+968 Oman', '+92'),
(136, '+92 Pakistan', '+92'),
(137, '+680 Palau', '+680'),
(138, '+970 Palestine', '+970'),
(139, '+507 Panama', '+507'),
(140, '+675 Papua New Guinea', '+675'),
(141, '+595 Paraguay', '+595'),
(142, '+51 Peru', '+51'),
(143, '+63 Philippines', '+63'),
(144, '+48 Poland', '+48'),
(145, '+351 Portugal', '+351'),
(146, '+974 Qatar', '+974'),
(147, '+40 Romania', '+40'),
(148, '+7 Russia', '+7'),
(149, '+250 Rwanda', '+250'),
(150, '+508 St. Pierre & Miquelon', '+508'),
(151, '+685 Samoa', '+685'),
(152, '+378 San Marino', '+378'),
(153, '+966 Saudi Arabia', '+966'),
(154, '+221 Senegal', '+221'),
(155, '+381 Serbia', '+381'),
(156, '+248 Seychelles', '+248'),
(157, '+232 Sierra Leone', '+232'),
(158, '+65 Singapore', '+65'),
(159, '+421 Slovakia', '+421'),
(160, '+386 Slovenia', '+386'),
(161, '+677 Solomon Islands', '+677'),
(162, '+252 Somalia', '+252'),
(163, '+27 South Africa', '+27'),
(164, '+34 Spain', '+34'),
(165, '+94 Sri Lanka', '+94'),
(166, '+249 Sudan', '+249'),
(167, '+597 Suriname', '+597'),
(168, '+268 Swaziland', '+268'),
(169, '+46 Sweden', '+46'),
(170, '+41 Switzerland', '+41'),
(171, '+963 Syria', '+963'),
(172, '+886 Taiwan', '+886'),
(173, '+992 Tajikistan', '+992'),
(174, '+255 Tanzania', '+255'),
(175, '+66 Thailand', '+66'),
(176, '+228 Togo', '+228'),
(177, '+676 Tonga', '+676'),
(178, '+216 Tunisia', '+216'),
(179, '+90 Turkey', '+90'),
(180, '+993 Turkmenistan', '+993'),
(181, '+256 Uganda', '+256'),
(182, '+380 Ukraine', '+380'),
(183, '+971 United Arab Emirates', '+971'),
(184, '+44 United Kingdom', '+44'),
(185, '+1 United States', '+1'),
(186, '+598 Uruguay', '+598'),
(187, '+998 Uzbekistan', '+998'),
(188, '+678 Vanuatu', '+678'),
(189, '+58 Venezuela', '+58'),
(190, '+84 Vietnam', '+84'),
(191, '+967 Yemen', '+967'),
(192, '+260 Zambia', '+260'),
(193, '+263 Zimbabwe', '+263'),
(194, '+95 Myanmar', '+95');

DROP TABLE IF EXISTS `crons`;
CREATE TABLE `crons` (
  `id` int(11) NOT NULL,
  `description` varchar(666) NOT NULL,
  `location` varchar(555) NOT NULL,
  `period` varchar(333) NOT NULL DEFAULT 'Once per day'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `crons`;
INSERT INTO `crons` (`id`, `description`, `location`, `period`) VALUES
(1, 'System Hour Cron', 'cronsH.php', 'Once per Hour'),
(2, 'System Minute Cron', 'crons.php', 'Once per Minute'),
(3, 'Infobip Gateway DLR Cron', 'smsapi/infobip/cron.php', 'Once per Minute');

DROP TABLE IF EXISTS `currencies`;
CREATE TABLE `currencies` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `symbul` varchar(100) NOT NULL,
  `rate` decimal(11,5) NOT NULL,
  `code` varchar(22) NOT NULL,
  `zeros` int(11) NOT NULL DEFAULT '2',
  `system` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `currencies`;
INSERT INTO `currencies` (`id`, `title`, `symbul`, `rate`, `code`, `system`) VALUES
(1, 'Naira', '&#8358;', '1.00000', 'NGN', 1),
(2, 'US Dollar', '$', '0.00603', 'USD', 1),
(3, 'Euro', '&euro;', '0.00436', 'EUR', 1);

DROP TABLE IF EXISTS `customers`;
CREATE TABLE `customers` (
  `id` int(11) NOT NULL,
  `first_name` varchar(300) NOT NULL,
  `email` varchar(200) NOT NULL,
  `facebook_id` varchar(300) NOT NULL,
  `phone` varchar(30) NOT NULL,
  `password` varchar(200) NOT NULL,
  `address` varchar(300) NOT NULL,
  `city` varchar(300) NOT NULL,
  `state` varchar(300) NOT NULL,
  `country` varchar(100) NOT NULL,
  `sender_id` varchar(15) NOT NULL,
  `picture` varchar(200) NOT NULL,
  `timezone_id` varchar(300) NOT NULL,
  `is_reseller` int(11) DEFAULT '0',
  `reseller` int(11) DEFAULT '0',
  `allow_2way` int(11) DEFAULT '0',
  `shortcode` varchar(50) NOT NULL,
  `last_login` varchar(44) NOT NULL ,
  `last_ip` varchar(50) NOT NULL,
  `phone_verified` varchar(200) NOT NULL DEFAULT '0',
  `email_verified` varchar(200) NOT NULL DEFAULT '0',
  `is_admin` int(11) NOT NULL DEFAULT '0',
  `language_id` int(11) NOT NULL DEFAULT '1',
  `order_limit` decimal(11,2) NOT NULL DEFAULT '1.00',
  `currency_id` int(11) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `credit_limit` decimal(11,2) NOT NULL DEFAULT '0.00',
  `failed_attempts` int(11) NOT NULL DEFAULT '0',
  `custom_price` decimal(11,2) NOT NULL DEFAULT '0.00',
  `status` varchar(50) NOT NULL DEFAULT 'active',
  `last_name` varchar(200) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COMMENT='Keeps details of all SMS customers';

TRUNCATE TABLE `customers`;
DROP TABLE IF EXISTS `draftmessages`;
CREATE TABLE `draftmessages` (
  `id` int(11) NOT NULL,
  `message` text NOT NULL,
  `recipients` mediumtext NOT NULL,
  `customer_id` int(11) NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `speed` varchar(11) NOT NULL,
  `language` varchar(11) NOT NULL,
  `title` varchar(200) NOT NULL DEFAULT 'Untitled',
  `media` text NOT NULL,
  `date` varchar(44) NOT NULL ,
  `sender_id` varchar(20) NOT NULL,
  `phonebook_id` varchar(110) NOT NULL DEFAULT '',
  `marketinglist_id` varchar(110) NOT NULL DEFAULT '',
  `duration` int(11) NOT NULL,
  `file` varchar(444) NOT NULL,
  `country` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `draftmessages`;
DROP TABLE IF EXISTS `dynamic_credit_cost`;
CREATE TABLE `dynamic_credit_cost` (
  `id` int(11) NOT NULL,
  `min_order` decimal(11,2) NOT NULL DEFAULT '0.00',
  `max_order` decimal(11,2) NOT NULL DEFAULT '0.00',
  `cost` decimal(11,4) NOT NULL DEFAULT '0.0000',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `reseller_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `dynamic_credit_cost`;
DROP TABLE IF EXISTS `emails`;
CREATE TABLE `emails` (
  `id` int(11) NOT NULL,
  `subject` varchar(777) NOT NULL,
  `recipient` longtext NOT NULL,
  `message` text NOT NULL,
  `status` varchar(44) NOT NULL DEFAULT 'queued',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `date` varchar(44) NOT NULL 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `emails`;
DROP TABLE IF EXISTS `fobidden_email`;
CREATE TABLE `fobidden_email` (
  `id` int(11) NOT NULL,
  `email` varchar(166) NOT NULL,
  `reason` varchar(666) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `fobidden_email`;
DROP TABLE IF EXISTS `fobidden_ip`;
CREATE TABLE `fobidden_ip` (
  `id` int(11) NOT NULL,
  `ip` varchar(66) NOT NULL,
  `reason` varchar(666) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `fobidden_ip`;
DROP TABLE IF EXISTS `fobidden_sender`;
CREATE TABLE `fobidden_sender` (
  `id` int(11) NOT NULL,
  `sender_id` varchar(33) NOT NULL,
  `reason` varchar(333) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `fobidden_sender`;
DROP TABLE IF EXISTS `forbidden_country`;
CREATE TABLE `forbidden_country` (
  `id` int(11) NOT NULL,
  `country_id` int(11) NOT NULL,
  `reason` varchar(333) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `forbidden_country`;
DROP TABLE IF EXISTS `forbidden_words`;
CREATE TABLE `forbidden_words` (
  `id` int(11) NOT NULL,
  `word` varchar(333) NOT NULL,
  `reason` varchar(333) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `forbidden_words`;
DROP TABLE IF EXISTS `gateway_charges`;
CREATE TABLE `gateway_charges` (
  `id` int(11) NOT NULL,
  `gateway_id` int(11) NOT NULL,
  `title` varchar(444) NOT NULL,
  `fixed` decimal(11,3) NOT NULL DEFAULT '0.000',
  `percentage` decimal(11,2) NOT NULL DEFAULT '0.00',
  `reseller_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `gateway_charges`;
DROP TABLE IF EXISTS `inbox`;
CREATE TABLE `inbox` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `sender` text NOT NULL,
  `date` varchar(44) DEFAULT NULL,
  `message` text NOT NULL,
  `is_read` int(5) NOT NULL DEFAULT '0',
  `recipient` varchar(50) NOT NULL,
  `cost` decimal(11,6) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `inbox`;
DROP TABLE IF EXISTS `language`;
CREATE TABLE `language` (
  `id` int(11) NOT NULL,
  `alias` varchar(11) NOT NULL,
  `title` varchar(333) NOT NULL,
  `enabled` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `language`;
INSERT INTO `language` (`id`, `alias`, `title`, `enabled`) VALUES
(1, 'en', 'English', 1);
INSERT INTO `language` (`alias`, `title`, `enabled`) VALUES
('ar', 'Arabic', 1);
INSERT INTO `language` (`alias`, `title`, `enabled`) VALUES
('hi', 'Hindi', 1);

DROP TABLE IF EXISTS `logs`;
CREATE TABLE `logs` (
  `id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `event` varchar(555) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `date` varchar(44) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `logs`;
DROP TABLE IF EXISTS `marketingcontacts`;
CREATE TABLE `marketingcontacts` (
  `id` int(11) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT 'No Name',
  `phone` varchar(20) NOT NULL,
  `marketinglist` int(11) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `marketingcontacts`;
DROP TABLE IF EXISTS `marketinglist`;
CREATE TABLE `marketinglist` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `optout_keyword` varchar(100) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `description` varchar(300) NOT NULL,
  `optin_keyword` varchar(111) NOT NULL,
  `optin_message` varchar(555) NOT NULL,
  `optout_message` varchar(555) NOT NULL,
  `shortcode` varchar(111) NOT NULL,
  `default_sender_id` varchar(30) NOT NULL,
  `is_public` int(11) NOT NULL DEFAULT '0',
  `cost` decimal(11,6) NOT NULL DEFAULT '0.000000'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `marketinglist`;
DROP TABLE IF EXISTS `marketinglist_owners`;
CREATE TABLE `marketinglist_owners` (
  `id` int(11) NOT NULL,
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `is_owner` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `marketinglist_owners`;
DROP TABLE IF EXISTS `messagedetails`;
CREATE TABLE `messagedetails` (
  `id` int(11) NOT NULL,
  `message_id` int(11) NOT NULL DEFAULT '0',
  `message` text NOT NULL,
  `recipient` varchar(110) NOT NULL,
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `gateway_id` int(10) NOT NULL DEFAULT '0',
  `country_id` VARCHAR(200) NOT NULL DEFAULT 'Unknown',
  `operator` varchar(100) NOT NULL DEFAULT 'Unknown',
  `language` varchar(111) NOT NULL DEFAULT 'en',
  `date` varchar(20) NOT NULL,
  `sender_id` varchar(20) NOT NULL,
  `cost` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `api_id` varchar(200) NOT NULL DEFAULT '0',
  `dlr` varchar(100) NOT NULL DEFAULT 'pending',
  `notice` text NOT NULL,
  `last_dlr_check` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `datetime` varchar(44) NOT NULL ,
  `duration` int(11) NOT NULL DEFAULT '0',
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  `media` varchar(444) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `messagedetails`;
DROP TABLE IF EXISTS `modules`;
CREATE TABLE `modules` (
  `id` int(11) NOT NULL,
  `title` varchar(333) NOT NULL,
  `url` varchar(333) NOT NULL,
  `is_system` int(11) NOT NULL DEFAULT '1',
  `privileges` varchar(222) NOT NULL DEFAULT '1,',
  `parent_menu` varchar(333) NOT NULL DEFAULT 'root',
  `status` int(11) NOT NULL DEFAULT '1',
  `author` varchar(333) NOT NULL,
  `type` varchar(33) NOT NULL DEFAULT 'system',
  `module_id` varchar(999) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `modules`;
DROP TABLE IF EXISTS `notice`;
CREATE TABLE `notice` (
  `id` int(11) NOT NULL COMMENT 'id',
  `customer_id` int(11) NOT NULL DEFAULT '0' COMMENT 'customer_id',
  `note` varchar(4444) NOT NULL COMMENT 'note',
  `is_seen` int(11) NOT NULL DEFAULT '0' COMMENT 'is_seen',
  `date` varchar(77) NOT NULL COMMENT 'date',
  `link` varchar(333) NOT NULL DEFAULT 'index.php'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `notice`;
DROP TABLE IF EXISTS `paymentalerts`;
CREATE TABLE `paymentalerts` (
  `id` int(11) NOT NULL,
  `date` varchar(44) NOT NULL ,
  `depositor` varchar(200) NOT NULL,
  `transaction_id` int(11) NOT NULL DEFAULT '0',
  `paymentgateway_id` varchar(100) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `reference` varchar(100) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `paymentalerts`;
DROP TABLE IF EXISTS `paymentgateways`;
CREATE TABLE `paymentgateways` (
  `id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `type` varchar(300) NOT NULL DEFAULT 'custom',
  `enabled` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `image` varchar(444) NOT NULL,
  `param1` varchar(444) NOT NULL,
  `param2` mediumtext NOT NULL,
  `param3` varchar(300) NOT NULL,
  `param4` varchar(300) NOT NULL,
  `currency_id` varchar(10) NOT NULL DEFAULT '0',
  `minimum_order` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `maximum_order` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `charges_perc` varchar(33) NOT NULL DEFAULT '0.00',
  `charges_fix` varchar(55) NOT NULL DEFAULT '0.00'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `paymentgateways`;
DROP TABLE IF EXISTS `paymentgateway_templates`;
CREATE TABLE `paymentgateway_templates` (
  `id` int(11) NOT NULL,
  `title` varchar(200) NOT NULL,
  `alias` varchar(300) NOT NULL DEFAULT 'custom',
  `image` varchar(444) NOT NULL,
  `param3_label` varchar(500) NOT NULL,
  `param4_label` varchar(300) NOT NULL,
  `currency_id` varchar(5) NOT NULL DEFAULT '0',
  `param1_label` varchar(113) NOT NULL,
  `param2_label` varchar(113) NOT NULL,
  `hide_pay_button` int(11) NOT NULL DEFAULT '0',
  `module_id` varchar(999) NOT NULL DEFAULT '0',
  `status` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `paymentgateway_templates`;
INSERT INTO `paymentgateway_templates` (`id`, `title`, `alias`, `image`, `param3_label`, `param4_label`, `currency_id`, `param1_label`, `param2_label`, `hide_pay_button`, `module_id`, `status`) VALUES
(1, 'InterSwitch WebPay', 'webpay', '', '', '', 'NGN', 'Client ID', 'MAC Key', 0, '0', 1),
(2, 'GTPay', 'gtpay', '', '', '', 'NGN', 'Merchant ID', 'Hash Key', 0, '0', 1),
(3, 'PayPal', 'paypal', '', '', '', 'USD', 'PayPal Email', '', 0, '0', 1),
(4, 'Custom Gateway', 'custom', '', '', '', '0', '', '', 0, '0', 1),
(5, '2Checkout', '2checkout', '', '', '', 'USD', 'Account ID', 'API Secret', 0, '0', 1),
(6, 'Quickteller', 'quickteller', '', '', '', 'NGN', 'Payment Code', '', 0, '0', 1),
(7, 'Stripe', 'stripe', '', '', '', 'USD', 'Publishable Key', 'Secret Key', 0, '0', 1),
(8, 'PayStack', 'paystack', '', '', '', 'NGN', 'Public Key', 'Private Key', 0, '0', 1);

DROP TABLE IF EXISTS `phonebooks`;
CREATE TABLE `phonebooks` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `description` varchar(300) NOT NULL,
  `birthday_sms` varchar(500) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `phonebooks`;
DROP TABLE IF EXISTS `phonebook_owners`;
CREATE TABLE `phonebook_owners` (
  `id` int(11) NOT NULL,
  `phonebook_id` int(11) NOT NULL DEFAULT '0',
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `is_owner` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `phonebook_owners`;
DROP TABLE IF EXISTS `rates`;
CREATE TABLE `rates` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `country_code` int(11) NOT NULL DEFAULT '0',
  `operator_code` int(11) NOT NULL DEFAULT '0',
  `rate` decimal(11,6) NOT NULL DEFAULT '0.000000',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(333) NOT NULL DEFAULT 'sms',
  `reseller_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1 ROW_FORMAT=COMPACT;

TRUNCATE TABLE `rates`;
DROP TABLE IF EXISTS `routes`;
CREATE TABLE `routes` (
  `id` int(11) NOT NULL,
  `type` varchar(33) NOT NULL DEFAULT 'sms',
  `title` varchar(333) NOT NULL,
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `country_code` int(11) NOT NULL DEFAULT '0',
  `operator_code` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '1',
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `routes`;
DROP TABLE IF EXISTS `route_group`;
CREATE TABLE `route_group` (
  `id` int(11) NOT NULL,
  `title` varchar(333) NOT NULL,
  `description` varchar(1000) NOT NULL,
  `has_cost` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `route_group`;
INSERT INTO `route_group` (`id`, `title`, `description`, `has_cost`) VALUES
(1, 'Default Routs', 'Default routes allows you to assign a Gateway API to specific destination countries or operators. Routes under this group will only be used when the message recipients number matches the specified country or operator code.', 0),
(2, 'Special Routes', 'Special routes allows you to set special routes such as Transnational routes, Corporate Routes, etc.<br>Customers will be able to choose from these routes when sending a message. You can set custom rates for each routes. ', 1);

DROP TABLE IF EXISTS `scheduledmessages`;
CREATE TABLE `scheduledmessages` (
  `message` text NOT NULL,
  `sender_id` varchar(15) NOT NULL,
  `recipients` mediumtext NOT NULL,
  `date` varchar(44) NOT NULL ,
  `customer_id` int(11) NOT NULL,
  `phonebook_id` varchar(2500) NOT NULL DEFAULT '0',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `marketinglist_id` varchar(2500) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `speed` varchar(300) NOT NULL,
  `media` varchar(500) NOT NULL DEFAULT '',
  `file` varchar(333) NOT NULL,
  `schedule_date` varchar(44) NOT NULL,
  `retry` varchar(30) NOT NULL,
  `language` varchar(111) NOT NULL DEFAULT 'en',
  `repeats` varchar(30) NOT NULL DEFAULT '0',
  `day` varchar(30) NOT NULL,
  `id` int(11) NOT NULL,
  `duration` int(11) NOT NULL DEFAULT '0',
  `country` int(11) NOT NULL DEFAULT '0',
  `to_count` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `scheduledmessages`;
DROP TABLE IF EXISTS `sender_id`;
CREATE TABLE `sender_id` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `sender_id` varchar(20) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'pending',
  `resold` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `sender_id`;
DROP TABLE IF EXISTS `sentmessages`;
CREATE TABLE `sentmessages` (
  `id` int(11) NOT NULL,
  `message` text NOT NULL,
  `sender_id` varchar(29) NOT NULL,
  `recipients` mediumtext NOT NULL,
  `date` varchar(44) NOT NULL ,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `language` varchar(111) NOT NULL DEFAULT 'en',
  `phonebook_id` varchar(111) NOT NULL DEFAULT '',
  `marketinglist_id` varchar(111) NOT NULL DEFAULT '',
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `sent_from` varchar(50) NOT NULL DEFAULT 'portal',
  `speed` varchar(110) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT 'Unknown',
  `media` varchar(500) NOT NULL DEFAULT '',
  `notice` varchar(100) NOT NULL DEFAULT '',
  `duration` int(11) NOT NULL,
  `file` varchar(333) NOT NULL,
  `country` int(11) NOT NULL DEFAULT '0',
  `sent_on` datetime NOT NULL,
  `to_count` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `sentmessages`;
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
  `id` int(11) NOT NULL,
  `field` varchar(100) NOT NULL,
  `value` text NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `settings`;
INSERT INTO `settings` (`id`, `field`, `value`, `customer_id`) VALUES
(1, 'siteBackground', 'background.jpg', 0),
(2, 'backgroundColor', '#f8f8f8', 0),
(3, 'headerColor', '#000000', 0),
(5, 'siteLogo', '', 0),
(6, 'siteName', 'Sendroid Ultimate', 0),
(8, 'activeGateway', '1', 0),
(13, 'businessName', 'Sendroid Ultimate', 0),
(14, 'companyAddress', '', 0),
(15, 'companyEmail', '', 0),
(16, 'companyPhone', '', 0),
(17, 'defaultCurrency', '1', 0),
(18, 'smsSender', 'SMS Centre', 0),
(19, 'emailSender', '', 0),
(20, 'newAccountSMS', '', 0),
(21, 'newAccountEmail', '', 0),
(22, 'newAccountEmailSubject', '', 0),
(23, 'newPasswordEmailSubject', '', 0),
(24, 'newPasswordSMS', '', 0),
(25, 'newPasswordEmail', '', 0),
(26, 'testUnits', '0', 0),
(27, 'timeZone', 'Africa/Lagos', 0),
(28, 'orderApproveSMS', '', 0),
(29, 'orderApproveEmail', '', 0),
(30, 'orderApproveEmailSubject', '', 0),
(32, 'newAdminPasswordEmail', '', 0),
(37, 'dynamicSender', '1', 0),
(38, 'invoiceSignature', '', 0),
(39, 'taxAmount', '0', 0),
(40, 'vatAmount', '0.00', 0),
(44, 'companyWebsite', '', 0),
(45, 'redirectToSite', '0', 0),
(47, 'smtpServer', '', 0),
(48, 'smtpUsername', '', 0),
(49, 'smtpPassword', '', 0),
(50, 'watsappEnabled', '1', 0),
(52, 'MMSEnabled', '1', 0),
(53, 'defaultLanguage', 'en', 0),
(54, 'param', '', 0),
(58, 'defaultCountry', '1', 0),
(60, 'headerFontColor', '#ffffff', 0),
(61, 'phone_verify', '0', 0),
(62, 'facebook_secrete', '', 0),
(63, 'blackListKeyword', '', 0),
(64, 'facebook_api', '', 0),
(65, 'email_verify', '0', 0),
(66, 'activeTheme', 'default', 0),
(71, 'smtpPort', '587', 0),
(72, 'smtpSecurity', 'tls', 0),
(73, 'GOOGLE_OAUTH_CLIENT_SECRET', '', 0),
(74, 'GOOGLE_OAUTH_CLIENT_ID', '', 0),
(75, 'lastMinuteCron', '0', 0),
(76, 'lastHourCron', '0', 0),
(77, 'google_recaptcha_sitekey', '', 0),
(78, 'google_recaptcha_secret', '', 0),
(79, 'use_facebook', '1', 0),
(80, 'use_google', '0', 0),
(81, 'unicodeEnabled', '1', 0),
(82, 'voiceEnabled', '1', 0),
(85, '2wayEnabled', '1', 0),
(86, 'flashEnabled', '1', 0),
(87, 'saleContactEnabled', '1', 0),
(88, 'affiliateEnabled', '1', 0),
(89, 'shareCreditEnabled', '1', 0),
(90, 'dynamicSenderEnabled', '1', 0),
(91, 'minCreditOrder', '0', 0),
(92, 'useSMSPackage', '1', 0),
(93, 'useSMSVoucher', '1', 0),
(94, 'affiliatePayType', 'percent', 0),
(95, 'affiliatePayValue', '0', 0),
(128, 'resellerDomain', '', 0);

DROP TABLE IF EXISTS `shortcodes`;
CREATE TABLE `shortcodes` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `shortcode` varchar(33) NOT NULL,
 `type` varchar(333) NOT NULL,
  `cost` decimal(11,4) NOT NULL DEFAULT '0.0000',
  `billing` int(11) NOT NULL DEFAULT '1',
  `is_public` int(11) NOT NULL DEFAULT '0',
  `date` datetime NOT NULL,
  `resold` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `shortcodes`;
DROP TABLE IF EXISTS `sms_gateways`;
CREATE TABLE `sms_gateways` (
  `id` int(11) NOT NULL,
  `title` varchar(100) NOT NULL,
  `base_url` text NOT NULL,
  `success_word` varchar(100) NOT NULL,
  `json_encode` int(11) NOT NULL,
  `request_type` varchar(20) NOT NULL DEFAULT 'GET',
  `sender_field` text NOT NULL,
  `recipient_field` text NOT NULL,
  `message_field` text NOT NULL,
  `param1_field` text NOT NULL,
  `param2_field` text NOT NULL,
  `param3_field` text NOT NULL,
  `param4_field` text NOT NULL,
  `param1_value` text NOT NULL,
  `param2_value` text NOT NULL,
  `param3_value` text NOT NULL,
  `param4_value` text NOT NULL,
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `language_field` text NOT NULL,
  `audio_field` text NOT NULL,
  `timeout_field` text NOT NULL,
  `speed_field` text NOT NULL,
  `authentication` text NOT NULL,
  `success_logic` varchar(333) NOT NULL DEFAULT 'contain',
  `dlr_enabled` int(11) NOT NULL DEFAULT '0',
  `group_id` int(11) NOT NULL DEFAULT '1',
  `dlr_callback` varchar(555) NOT NULL,
  `d_rate` varchar(5055) NOT NULL DEFAULT '0',
  `param5_field` varchar(555) NOT NULL,
  `param5_value` varchar(555) NOT NULL,
  `tts_enabled` int(11) NOT NULL DEFAULT '0',
  `file_enabled` int(11) NOT NULL DEFAULT '0',
  `cutting_limit` int(11) NOT NULL DEFAULT '0',
  `hour_limit` int(11) NOT NULL DEFAULT '0',
  `cutting_percent` int(11) NOT NULL DEFAULT '0',
  `alias` varchar(333) NOT NULL,
  `username` varchar(666) NOT NULL,
  `password` varchar(666) NOT NULL,
  `balance_url` varchar(555) NOT NULL,
  `nextStart` varchar(33) NOT NULL DEFAULT '0',
  `jobs` int(11) NOT NULL DEFAULT '0',
  `base64_encode` int(11) NOT NULL DEFAULT '1'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `sms_gateways`;
DROP TABLE IF EXISTS `sms_plans`;
CREATE TABLE `sms_plans` (
  `id` int(11) NOT NULL,
  `title` varchar(444) NOT NULL,
  `price` varchar(333) NOT NULL,
  `credits` varchar(44) NOT NULL,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `validity` int(11) NOT NULL DEFAULT '0',
  `recommend` int(11) NOT NULL DEFAULT '0'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `sms_plans`;
DROP TABLE IF EXISTS `temp_jobs`;
CREATE TABLE `temp_jobs` (
  `id` int(11) NOT NULL,
  `message` text NOT NULL,
  `sender_id` varchar(15) NOT NULL,
  `recipients` mediumtext NOT NULL,
  `date` datetime NOT NULL ,
  `customer_id` int(11) NOT NULL DEFAULT '0',
  `phonebook_id` int(11) NOT NULL DEFAULT '0',
  `marketinglist_id` int(11) NOT NULL DEFAULT '0',
  `status` varchar(50) NOT NULL DEFAULT 'queued',
  `type` varchar(11) NOT NULL DEFAULT 'sms',
  `sent_from` varchar(50) NOT NULL DEFAULT 'portal',
  `speed` varchar(110) NOT NULL DEFAULT '0',
  `gateway_id` int(11) NOT NULL DEFAULT '0',
  `ip` varchar(20) NOT NULL DEFAULT 'Unknown',
  `media` varchar(500) NOT NULL DEFAULT '',
  `notice` varchar(100) NOT NULL DEFAULT ''
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `temp_jobs`;
DROP TABLE IF EXISTS `themes`;
CREATE TABLE `themes` (
  `id` int(11) NOT NULL,
  `name` varchar(100) NOT NULL,
  `alias` varchar(100) NOT NULL,
  `author` varchar(100) NOT NULL,
  `image` varchar(300) NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `themes`;
DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets` (
  `id` int(11) NOT NULL,
  `customer_id` int(11) NOT NULL,
  `admin_reply` int(11) NOT NULL DEFAULT '0',
  `customer_reply` int(11) NOT NULL DEFAULT '0',
  `subject` varchar(200) NOT NULL,
  `message` text NOT NULL,
  `date` datetime NOT NULL ,
  `status` varchar(50) NOT NULL DEFAULT 'open',
  `department` varchar(200) NOT NULL,
  `media` varchar(600) NOT NULL,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `last_updated` datetime NOT NULL 
) ENGINE=InnoDB DEFAULT CHARSET=latin1;

TRUNCATE TABLE `tickets`;
DROP TABLE IF EXISTS `timezone`;
CREATE TABLE `timezone` (
  `zone_id` int(10) NOT NULL,
  `abbreviation` varchar(6) COLLATE utf8_bin NOT NULL,
  `time_start` decimal(11,0) NOT NULL,
  `gmt_offset` int(11) NOT NULL,
  `dst` char(1) COLLATE utf8_bin NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_bin;

TRUNCATE TABLE `timezone`;
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(1, 'LMT', '-2177453165', 364, '0'),
(1, 'WET', '-2177453164', 0, '0'),
(1, 'CET', '-733881600', 3600, '0'),
(1, 'CEST', '481078800', 7200, '1'),
(1, 'CET', '496803600', 3600, '0'),
(1, 'CEST', '512528400', 7200, '1'),
(1, 'CET', '528253200', 3600, '0'),
(1, 'CEST', '543978000', 7200, '1'),
(1, 'CET', '559702800', 3600, '0'),
(1, 'CEST', '575427600', 7200, '1'),
(1, 'CET', '591152400', 3600, '0'),
(1, 'CEST', '606877200', 7200, '1'),
(1, 'CET', '622602000', 3600, '0'),
(1, 'CEST', '638326800', 7200, '1'),
(1, 'CET', '654656400', 3600, '0'),
(1, 'CEST', '670381200', 7200, '1'),
(1, 'CET', '686106000', 3600, '0'),
(1, 'CEST', '701830800', 7200, '1'),
(1, 'CET', '717555600', 3600, '0'),
(1, 'CEST', '733280400', 7200, '1'),
(1, 'CET', '749005200', 3600, '0'),
(1, 'CEST', '764730000', 7200, '1'),
(1, 'CET', '780454800', 3600, '0'),
(1, 'CEST', '796179600', 7200, '1'),
(1, 'CET', '811904400', 3600, '0'),
(1, 'CEST', '828234000', 7200, '1'),
(1, 'CET', '846378000', 3600, '0'),
(1, 'CEST', '859683600', 7200, '1'),
(1, 'CET', '877827600', 3600, '0'),
(1, 'CEST', '891133200', 7200, '1'),
(1, 'CET', '909277200', 3600, '0'),
(1, 'CEST', '922582800', 7200, '1'),
(1, 'CET', '941331600', 3600, '0'),
(1, 'CEST', '954032400', 7200, '1'),
(1, 'CET', '972781200', 3600, '0'),
(1, 'CEST', '985482000', 7200, '1'),
(1, 'CET', '1004230800', 3600, '0'),
(1, 'CEST', '1017536400', 7200, '1'),
(1, 'CET', '1035680400', 3600, '0'),
(1, 'CEST', '1048986000', 7200, '1'),
(1, 'CET', '1067130000', 3600, '0'),
(1, 'CEST', '1080435600', 7200, '1'),
(1, 'CET', '1099184400', 3600, '0'),
(1, 'CEST', '1111885200', 7200, '1'),
(1, 'CET', '1130634000', 3600, '0'),
(1, 'CEST', '1143334800', 7200, '1'),
(1, 'CET', '1162083600', 3600, '0'),
(1, 'CEST', '1174784400', 7200, '1'),
(1, 'CET', '1193533200', 3600, '0'),
(1, 'CEST', '1206838800', 7200, '1'),
(1, 'CET', '1224982800', 3600, '0'),
(1, 'CEST', '1238288400', 7200, '1'),
(1, 'CET', '1256432400', 3600, '0'),
(1, 'CEST', '1269738000', 7200, '1'),
(1, 'CET', '1288486800', 3600, '0'),
(1, 'CEST', '1301187600', 7200, '1'),
(1, 'CET', '1319936400', 3600, '0'),
(1, 'CEST', '1332637200', 7200, '1'),
(1, 'CET', '1351386000', 3600, '0'),
(1, 'CEST', '1364691600', 7200, '1'),
(1, 'CET', '1382835600', 3600, '0'),
(1, 'CEST', '1396141200', 7200, '1'),
(1, 'CET', '1414285200', 3600, '0'),
(1, 'CEST', '1427590800', 7200, '1'),
(1, 'CET', '1445734800', 3600, '0'),
(1, 'CEST', '1459040400', 7200, '1'),
(1, 'CET', '1477789200', 3600, '0'),
(1, 'CEST', '1490490000', 7200, '1'),
(1, 'CET', '1509238800', 3600, '0'),
(1, 'CEST', '1521939600', 7200, '1'),
(1, 'CET', '1540688400', 3600, '0'),
(1, 'CEST', '1553994000', 7200, '1'),
(1, 'CET', '1572138000', 3600, '0'),
(1, 'CEST', '1585443600', 7200, '1'),
(1, 'CET', '1603587600', 3600, '0'),
(1, 'CEST', '1616893200', 7200, '1'),
(1, 'CET', '1635642000', 3600, '0'),
(1, 'CEST', '1648342800', 7200, '1'),
(1, 'CET', '1667091600', 3600, '0'),
(1, 'CEST', '1679792400', 7200, '1'),
(1, 'CET', '1698541200', 3600, '0'),
(1, 'CEST', '1711846800', 7200, '1'),
(1, 'CET', '1729990800', 3600, '0'),
(1, 'CEST', '1743296400', 7200, '1'),
(1, 'CET', '1761440400', 3600, '0'),
(1, 'CEST', '1774746000', 7200, '1'),
(1, 'CET', '1792890000', 3600, '0'),
(1, 'CEST', '1806195600', 7200, '1'),
(1, 'CET', '1824944400', 3600, '0'),
(1, 'CEST', '1837645200', 7200, '1'),
(1, 'CET', '1856394000', 3600, '0'),
(1, 'CEST', '1869094800', 7200, '1'),
(1, 'CET', '1887843600', 3600, '0'),
(1, 'CEST', '1901149200', 7200, '1'),
(1, 'CET', '1919293200', 3600, '0'),
(1, 'CEST', '1932598800', 7200, '1'),
(1, 'CET', '1950742800', 3600, '0'),
(1, 'CEST', '1964048400', 7200, '1'),
(1, 'CET', '1982797200', 3600, '0'),
(1, 'CEST', '1995498000', 7200, '1'),
(1, 'CET', '2014246800', 3600, '0'),
(1, 'CEST', '2026947600', 7200, '1'),
(1, 'CET', '2045696400', 3600, '0'),
(1, 'CEST', '2058397200', 7200, '1'),
(1, 'CET', '2077146000', 3600, '0'),
(1, 'CEST', '2090451600', 7200, '1'),
(1, 'CET', '2108595600', 3600, '0'),
(1, 'CEST', '2121901200', 7200, '1'),
(1, 'CET', '2140045200', 3600, '0'),
(1, 'CEST', '2153350800', 7200, '1'),
(1, 'CET', '2172099600', 3600, '0'),
(1, 'CEST', '2184800400', 7200, '1'),
(1, 'CET', '2203549200', 3600, '0'),
(1, 'CEST', '2216250000', 7200, '1'),
(1, 'CET', '2234998800', 3600, '0'),
(1, 'CEST', '2248304400', 7200, '1'),
(1, 'CET', '2266448400', 3600, '0'),
(1, 'CEST', '2279754000', 7200, '1'),
(1, 'CET', '2297898000', 3600, '0'),
(1, 'CEST', '2311203600', 7200, '1'),
(1, 'CET', '2329347600', 3600, '0'),
(1, 'CEST', '2342653200', 7200, '1'),
(1, 'CET', '2361402000', 3600, '0'),
(1, 'CEST', '2374102800', 7200, '1'),
(1, 'CET', '2392851600', 3600, '0'),
(1, 'CEST', '2405552400', 7200, '1'),
(1, 'CET', '2424301200', 3600, '0'),
(1, 'CEST', '2437606800', 7200, '1'),
(1, 'CET', '2455750800', 3600, '0'),
(1, 'CEST', '2469056400', 7200, '1'),
(1, 'CET', '2487200400', 3600, '0'),
(1, 'CEST', '2500506000', 7200, '1'),
(1, 'CET', '2519254800', 3600, '0'),
(1, 'CEST', '2531955600', 7200, '1'),
(1, 'CET', '2550704400', 3600, '0'),
(1, 'CEST', '2563405200', 7200, '1'),
(1, 'CET', '2582154000', 3600, '0'),
(1, 'CEST', '2595459600', 7200, '1'),
(1, 'CET', '2613603600', 3600, '0'),
(1, 'CEST', '2626909200', 7200, '1'),
(1, 'CET', '2645053200', 3600, '0'),
(1, 'CEST', '2658358800', 7200, '1'),
(1, 'CET', '2676502800', 3600, '0'),
(1, 'CEST', '2689808400', 7200, '1'),
(1, 'CET', '2708557200', 3600, '0'),
(1, 'CEST', '2721258000', 7200, '1'),
(1, 'CET', '2740006800', 3600, '0'),
(1, 'CEST', '2752707600', 7200, '1'),
(1, 'CET', '2771456400', 3600, '0'),
(1, 'CEST', '2784762000', 7200, '1'),
(1, 'CET', '2802906000', 3600, '0'),
(1, 'CEST', '2816211600', 7200, '1'),
(1, 'CET', '2834355600', 3600, '0'),
(1, 'CEST', '2847661200', 7200, '1'),
(1, 'CET', '2866410000', 3600, '0'),
(1, 'CEST', '2879110800', 7200, '1'),
(1, 'CET', '2897859600', 3600, '0'),
(1, 'CEST', '2910560400', 7200, '1'),
(1, 'CET', '2929309200', 3600, '0'),
(1, 'CEST', '2942010000', 7200, '1'),
(1, 'CET', '2960758800', 3600, '0'),
(1, 'CEST', '2974064400', 7200, '1'),
(1, 'CET', '2992208400', 3600, '0'),
(1, 'CEST', '3005514000', 7200, '1'),
(1, 'CET', '3023658000', 3600, '0'),
(1, 'CEST', '3036963600', 7200, '1'),
(1, 'CET', '3055712400', 3600, '0'),
(1, 'CEST', '3068413200', 7200, '1'),
(1, 'CET', '3087162000', 3600, '0'),
(1, 'CEST', '3099862800', 7200, '1'),
(1, 'CET', '3118611600', 3600, '0'),
(1, 'CEST', '3131917200', 7200, '1'),
(1, 'CET', '3150061200', 3600, '0'),
(1, 'CEST', '3163366800', 7200, '1'),
(1, 'CET', '3181510800', 3600, '0'),
(1, 'CEST', '3194816400', 7200, '1'),
(1, 'CET', '3212960400', 3600, '0'),
(1, 'CEST', '3226266000', 7200, '1'),
(1, 'CET', '3245014800', 3600, '0'),
(1, 'CEST', '3257715600', 7200, '1'),
(1, 'CET', '3276464400', 3600, '0'),
(1, 'CEST', '3289165200', 7200, '1'),
(1, 'CET', '3307914000', 3600, '0'),
(1, 'CEST', '3321219600', 7200, '1'),
(1, 'CET', '3339363600', 3600, '0'),
(1, 'CEST', '3352669200', 7200, '1'),
(1, 'CET', '3370813200', 3600, '0'),
(1, 'CEST', '3384118800', 7200, '1'),
(1, 'CET', '3402867600', 3600, '0'),
(1, 'CEST', '3415568400', 7200, '1'),
(1, 'CET', '3434317200', 3600, '0'),
(1, 'CEST', '3447018000', 7200, '1'),
(1, 'CET', '3465766800', 3600, '0'),
(1, 'CEST', '3479072400', 7200, '1'),
(1, 'CET', '3497216400', 3600, '0'),
(1, 'CEST', '3510522000', 7200, '1'),
(1, 'CET', '3528666000', 3600, '0'),
(1, 'CEST', '3541971600', 7200, '1'),
(1, 'CET', '3560115600', 3600, '0'),
(1, 'CEST', '3573421200', 7200, '1'),
(1, 'CET', '3592170000', 3600, '0'),
(1, 'CEST', '3604870800', 7200, '1'),
(1, 'CET', '3623619600', 3600, '0'),
(1, 'CEST', '3636320400', 7200, '1'),
(1, 'CET', '3655069200', 3600, '0'),
(1, 'CEST', '3668374800', 7200, '1'),
(1, 'CET', '3686518800', 3600, '0'),
(1, 'CEST', '3699824400', 7200, '1'),
(1, 'CET', '3717968400', 3600, '0'),
(1, 'CEST', '3731274000', 7200, '1'),
(1, 'CET', '3750022800', 3600, '0'),
(1, 'CEST', '3762723600', 7200, '1'),
(1, 'CET', '3781472400', 3600, '0'),
(1, 'CEST', '3794173200', 7200, '1'),
(1, 'CET', '3812922000', 3600, '0'),
(1, 'CEST', '3825622800', 7200, '1'),
(1, 'CET', '3844371600', 3600, '0'),
(1, 'CEST', '3857677200', 7200, '1'),
(1, 'CET', '3875821200', 3600, '0'),
(1, 'CEST', '3889126800', 7200, '1'),
(1, 'CET', '3907270800', 3600, '0'),
(1, 'CEST', '3920576400', 7200, '1'),
(1, 'CET', '3939325200', 3600, '0'),
(1, 'CEST', '3952026000', 7200, '1'),
(1, 'CET', '3970774800', 3600, '0'),
(1, 'CEST', '3983475600', 7200, '1'),
(1, 'CET', '4002224400', 3600, '0'),
(1, 'CEST', '4015530000', 7200, '1'),
(1, 'CET', '4033674000', 3600, '0'),
(1, 'CEST', '4046979600', 7200, '1'),
(1, 'CET', '4065123600', 3600, '0'),
(1, 'CEST', '4078429200', 7200, '1'),
(1, 'CET', '4096573200', 3600, '0'),
(1, 'CEST', '4109878800', 7200, '1'),
(1, 'CET', '4128627600', 3600, '0'),
(1, 'CEST', '4141328400', 7200, '1'),
(1, 'CET', '4160077200', 3600, '0'),
(1, 'CEST', '4172778000', 7200, '1'),
(1, 'CET', '4191526800', 3600, '0'),
(1, 'CEST', '4204227600', 7200, '1'),
(1, 'CET', '4222976400', 3600, '0'),
(1, 'CEST', '4236282000', 7200, '1'),
(1, 'CET', '4254426000', 3600, '0'),
(1, 'CEST', '4267731600', 7200, '1'),
(1, 'CET', '4285875600', 3600, '0'),
(1, 'CEST', '4299181200', 7200, '1'),
(1, 'CET', '4317930000', 3600, '0'),
(1, 'CEST', '4330630800', 7200, '1'),
(1, 'CET', '4349379600', 3600, '0'),
(1, 'CEST', '4362080400', 7200, '1'),
(1, 'CET', '4380829200', 3600, '0'),
(1, 'CEST', '4394134800', 7200, '1'),
(1, 'CET', '4412278800', 3600, '0'),
(1, 'CEST', '4425584400', 7200, '1'),
(1, 'CET', '4443728400', 3600, '0'),
(1, 'CEST', '4457034000', 7200, '1'),
(1, 'CET', '4475178000', 3600, '0'),
(1, 'CEST', '4488483600', 7200, '1'),
(1, 'CET', '4507232400', 3600, '0'),
(1, 'CEST', '4519933200', 7200, '1'),
(1, 'CET', '4538682000', 3600, '0'),
(1, 'CEST', '4551382800', 7200, '1'),
(1, 'CET', '4570131600', 3600, '0'),
(1, 'CEST', '4583437200', 7200, '1'),
(1, 'CET', '4601581200', 3600, '0'),
(1, 'CEST', '4614886800', 7200, '1'),
(1, 'CET', '4633030800', 3600, '0'),
(1, 'CEST', '4646336400', 7200, '1'),
(1, 'CET', '4665085200', 3600, '0'),
(1, 'CEST', '4677786000', 7200, '1'),
(1, 'CET', '4696534800', 3600, '0'),
(1, 'CEST', '4709235600', 7200, '1'),
(1, 'CET', '4727984400', 3600, '0'),
(1, 'CEST', '4741290000', 7200, '1'),
(1, 'CET', '4759434000', 3600, '0'),
(1, 'CEST', '4772739600', 7200, '1'),
(1, 'CET', '4790883600', 3600, '0'),
(1, 'CEST', '4804189200', 7200, '1'),
(1, 'CET', '4822333200', 3600, '0'),
(1, 'CEST', '4835638800', 7200, '1'),
(1, 'CET', '4854387600', 3600, '0'),
(1, 'CEST', '4867088400', 7200, '1'),
(1, 'CET', '4885837200', 3600, '0'),
(1, 'CEST', '4898538000', 7200, '1'),
(1, 'CET', '4917286800', 3600, '0'),
(1, 'CEST', '4930592400', 7200, '1'),
(1, 'CET', '4948736400', 3600, '0'),
(1, 'CEST', '4962042000', 7200, '1'),
(1, 'CET', '4980186000', 3600, '0'),
(1, 'CEST', '4993491600', 7200, '1'),
(1, 'CET', '5012240400', 3600, '0'),
(1, 'CEST', '5024941200', 7200, '1'),
(1, 'CET', '5043690000', 3600, '0'),
(1, 'CEST', '5056390800', 7200, '1'),
(1, 'CET', '5075139600', 3600, '0'),
(1, 'CEST', '5087840400', 7200, '1'),
(1, 'CET', '5106589200', 3600, '0'),
(1, 'CEST', '5119894800', 7200, '1'),
(1, 'CET', '5138038800', 3600, '0'),
(1, 'CEST', '5151344400', 7200, '1'),
(1, 'CET', '5169488400', 3600, '0'),
(1, 'CEST', '5182794000', 7200, '1'),
(1, 'CET', '5201542800', 3600, '0'),
(1, 'CEST', '5214243600', 7200, '1'),
(1, 'CET', '5232992400', 3600, '0'),
(1, 'CEST', '5245693200', 7200, '1'),
(1, 'CET', '5264442000', 3600, '0'),
(1, 'CEST', '5277747600', 7200, '1'),
(1, 'CET', '5295891600', 3600, '0'),
(1, 'CEST', '5309197200', 7200, '1'),
(1, 'CET', '5327341200', 3600, '0'),
(1, 'CEST', '5340646800', 7200, '1'),
(1, 'CET', '5358790800', 3600, '0'),
(1, 'CEST', '5372096400', 7200, '1'),
(1, 'CET', '5390845200', 3600, '0'),
(1, 'CEST', '5403546000', 7200, '1'),
(1, 'CET', '5422294800', 3600, '0'),
(1, 'CEST', '5434995600', 7200, '1'),
(1, 'CET', '5453744400', 3600, '0'),
(1, 'CEST', '5467050000', 7200, '1'),
(1, 'CET', '5485194000', 3600, '0'),
(1, 'CEST', '5498499600', 7200, '1'),
(1, 'CET', '5516643600', 3600, '0'),
(1, 'CEST', '5529949200', 7200, '1'),
(1, 'CET', '5548698000', 3600, '0'),
(1, 'CEST', '5561398800', 7200, '1'),
(1, 'CET', '5580147600', 3600, '0'),
(1, 'CEST', '5592848400', 7200, '1'),
(1, 'CET', '5611597200', 3600, '0'),
(1, 'CEST', '5624902800', 7200, '1'),
(1, 'CET', '5643046800', 3600, '0'),
(1, 'CEST', '5656352400', 7200, '1'),
(1, 'CET', '5674496400', 3600, '0'),
(1, 'CEST', '5687802000', 7200, '1'),
(1, 'CET', '5705946000', 3600, '0'),
(1, 'CEST', '5719251600', 7200, '1'),
(1, 'CET', '5738000400', 3600, '0'),
(1, 'CEST', '5750701200', 7200, '1'),
(1, 'CET', '5769450000', 3600, '0'),
(1, 'CEST', '5782150800', 7200, '1'),
(1, 'CET', '5800899600', 3600, '0'),
(1, 'CEST', '5814205200', 7200, '1'),
(1, 'CET', '5832349200', 3600, '0'),
(1, 'CEST', '5845654800', 7200, '1'),
(1, 'CET', '5863798800', 3600, '0'),
(1, 'CEST', '5877104400', 7200, '1'),
(1, 'CET', '5895853200', 3600, '0'),
(1, 'CEST', '5908554000', 7200, '1'),
(1, 'CET', '5927302800', 3600, '0'),
(1, 'CEST', '5940003600', 7200, '1'),
(1, 'CET', '5958752400', 3600, '0'),
(1, 'CEST', '5971453200', 7200, '1'),
(1, 'CET', '5990202000', 3600, '0'),
(1, 'CEST', '6003507600', 7200, '1'),
(1, 'CET', '6021651600', 3600, '0'),
(1, 'CEST', '6034957200', 7200, '1'),
(1, 'CET', '6053101200', 3600, '0'),
(1, 'CEST', '6066406800', 7200, '1'),
(1, 'CET', '6085155600', 3600, '0'),
(1, 'CEST', '6097856400', 7200, '1'),
(1, 'CET', '6116605200', 3600, '0'),
(1, 'CEST', '6129306000', 7200, '1'),
(1, 'CET', '6148054800', 3600, '0'),
(1, 'CEST', '6161360400', 7200, '1'),
(1, 'CET', '6179504400', 3600, '0'),
(1, 'CEST', '6192810000', 7200, '1'),
(1, 'CET', '6210954000', 3600, '0'),
(1, 'CEST', '6224259600', 7200, '1'),
(1, 'CET', '6242403600', 3600, '0'),
(1, 'CEST', '6255709200', 7200, '1'),
(1, 'CET', '6274458000', 3600, '0'),
(1, 'CEST', '6287158800', 7200, '1'),
(1, 'CET', '6305907600', 3600, '0'),
(1, 'CEST', '6318608400', 7200, '1'),
(1, 'CET', '6337357200', 3600, '0'),
(1, 'CEST', '6350662800', 7200, '1'),
(1, 'CET', '6368806800', 3600, '0'),
(1, 'CEST', '6382112400', 7200, '1'),
(1, 'CET', '6400256400', 3600, '0'),
(1, 'CEST', '6413562000', 7200, '1'),
(1, 'CET', '6432310800', 3600, '0'),
(1, 'CEST', '6445011600', 7200, '1'),
(1, 'CET', '6463760400', 3600, '0'),
(1, 'CEST', '6476461200', 7200, '1'),
(1, 'CET', '6495210000', 3600, '0'),
(1, 'CEST', '6508515600', 7200, '1'),
(1, 'CET', '6526659600', 3600, '0'),
(1, 'CEST', '6539965200', 7200, '1'),
(1, 'CET', '6558109200', 3600, '0'),
(1, 'CEST', '6571414800', 7200, '1'),
(1, 'CET', '6589558800', 3600, '0'),
(1, 'CEST', '6602864400', 7200, '1'),
(1, 'CET', '6621613200', 3600, '0'),
(1, 'CEST', '6634314000', 7200, '1'),
(1, 'CET', '6653062800', 3600, '0'),
(1, 'CEST', '6665763600', 7200, '1'),
(1, 'CET', '6684512400', 3600, '0'),
(1, 'CEST', '6697818000', 7200, '1'),
(1, 'CET', '6715962000', 3600, '0'),
(1, 'CEST', '6729267600', 7200, '1'),
(1, 'CET', '6747411600', 3600, '0'),
(1, 'CEST', '6760717200', 7200, '1'),
(1, 'CET', '6779466000', 3600, '0'),
(1, 'CEST', '6792166800', 7200, '1'),
(1, 'CET', '6810915600', 3600, '0'),
(1, 'CEST', '6823616400', 7200, '1'),
(1, 'CET', '6842365200', 3600, '0'),
(1, 'CEST', '6855066000', 7200, '1'),
(1, 'CET', '6873814800', 3600, '0'),
(1, 'CEST', '6887120400', 7200, '1'),
(1, 'CET', '6905264400', 3600, '0'),
(1, 'CEST', '6918570000', 7200, '1'),
(1, 'CET', '6936714000', 3600, '0'),
(1, 'CEST', '6950019600', 7200, '1'),
(1, 'CET', '6968768400', 3600, '0'),
(1, 'CEST', '6981469200', 7200, '1'),
(1, 'CET', '7000218000', 3600, '0'),
(1, 'CEST', '7012918800', 7200, '1'),
(1, 'CET', '7031667600', 3600, '0'),
(1, 'CEST', '7044973200', 7200, '1'),
(1, 'CET', '7063117200', 3600, '0'),
(1, 'CEST', '7076422800', 7200, '1'),
(1, 'CET', '7094566800', 3600, '0'),
(1, 'CEST', '7107872400', 7200, '1'),
(1, 'CET', '7126016400', 3600, '0'),
(1, 'CEST', '7139322000', 7200, '1'),
(1, 'CET', '7158070800', 3600, '0'),
(1, 'CEST', '7170771600', 7200, '1'),
(1, 'CET', '7189520400', 3600, '0'),
(1, 'CEST', '7202221200', 7200, '1'),
(1, 'CET', '7220970000', 3600, '0'),
(1, 'CEST', '7234275600', 7200, '1'),
(1, 'CET', '7252419600', 3600, '0'),
(1, 'CEST', '7265725200', 7200, '1'),
(1, 'CET', '7283869200', 3600, '0'),
(1, 'CEST', '7297174800', 7200, '1'),
(1, 'CET', '7315318800', 3600, '0'),
(1, 'CEST', '7328624400', 7200, '1'),
(1, 'CET', '7347373200', 3600, '0'),
(1, 'CEST', '7360074000', 7200, '1'),
(1, 'CET', '7378822800', 3600, '0'),
(1, 'CEST', '7391523600', 7200, '1'),
(1, 'CET', '7410272400', 3600, '0'),
(1, 'CEST', '7423578000', 7200, '1'),
(1, 'CET', '7441722000', 3600, '0'),
(1, 'CEST', '7455027600', 7200, '1'),
(1, 'CET', '7473171600', 3600, '0'),
(1, 'CEST', '7486477200', 7200, '1'),
(1, 'CET', '7504621200', 3600, '0'),
(1, 'CEST', '7517926800', 7200, '1'),
(1, 'CET', '7536675600', 3600, '0'),
(1, 'CEST', '7549376400', 7200, '1'),
(1, 'CET', '7568125200', 3600, '0'),
(1, 'CEST', '7580826000', 7200, '1'),
(1, 'CET', '7599574800', 3600, '0'),
(1, 'CEST', '7612880400', 7200, '1'),
(1, 'CET', '7631024400', 3600, '0'),
(1, 'CEST', '7644330000', 7200, '1'),
(1, 'CET', '7662474000', 3600, '0'),
(1, 'CEST', '7675779600', 7200, '1'),
(1, 'CET', '7694528400', 3600, '0'),
(1, 'CEST', '7707229200', 7200, '1'),
(1, 'CET', '7725978000', 3600, '0'),
(1, 'CEST', '7738678800', 7200, '1'),
(1, 'CET', '7757427600', 3600, '0'),
(1, 'CEST', '7770733200', 7200, '1'),
(1, 'CET', '7788877200', 3600, '0'),
(1, 'CEST', '7802182800', 7200, '1'),
(1, 'CET', '7820326800', 3600, '0'),
(1, 'CEST', '7833632400', 7200, '1'),
(1, 'CET', '7851776400', 3600, '0'),
(1, 'CEST', '7865082000', 7200, '1'),
(1, 'CET', '7883830800', 3600, '0'),
(1, 'CEST', '7896531600', 7200, '1'),
(1, 'CET', '7915280400', 3600, '0'),
(1, 'CEST', '7927981200', 7200, '1'),
(1, 'CET', '7946730000', 3600, '0'),
(1, 'CEST', '7960035600', 7200, '1'),
(1, 'CET', '7978179600', 3600, '0'),
(1, 'CEST', '7991485200', 7200, '1'),
(1, 'CET', '8009629200', 3600, '0'),
(1, 'CEST', '8022934800', 7200, '1'),
(1, 'CET', '8041683600', 3600, '0'),
(1, 'CEST', '8054384400', 7200, '1'),
(1, 'CET', '8073133200', 3600, '0'),
(1, 'CEST', '8085834000', 7200, '1'),
(1, 'CET', '8104582800', 3600, '0'),
(1, 'CEST', '8117283600', 7200, '1'),
(1, 'CET', '8136032400', 3600, '0'),
(1, 'CEST', '8149338000', 7200, '1'),
(1, 'CET', '8167482000', 3600, '0'),
(1, 'CEST', '8180787600', 7200, '1'),
(1, 'CET', '8198931600', 3600, '0'),
(1, 'CEST', '8212237200', 7200, '1'),
(1, 'CET', '8230986000', 3600, '0'),
(1, 'CEST', '8243686800', 7200, '1'),
(1, 'CET', '8262435600', 3600, '0'),
(1, 'CEST', '8275136400', 7200, '1'),
(1, 'CET', '8293885200', 3600, '0'),
(1, 'CEST', '8307190800', 7200, '1'),
(1, 'CET', '8325334800', 3600, '0'),
(1, 'CEST', '8338640400', 7200, '1'),
(1, 'CET', '8356784400', 3600, '0'),
(1, 'CEST', '8370090000', 7200, '1'),
(1, 'CET', '8388234000', 3600, '0'),
(1, 'CEST', '8401539600', 7200, '1'),
(1, 'CET', '8420288400', 3600, '0'),
(1, 'CEST', '8432989200', 7200, '1'),
(1, 'CET', '8451738000', 3600, '0'),
(1, 'CEST', '8464438800', 7200, '1'),
(1, 'CET', '8483187600', 3600, '0'),
(1, 'CEST', '8496493200', 7200, '1'),
(1, 'CET', '8514637200', 3600, '0'),
(1, 'CEST', '8527942800', 7200, '1'),
(1, 'CET', '8546086800', 3600, '0'),
(1, 'CEST', '8559392400', 7200, '1'),
(1, 'CET', '8578141200', 3600, '0'),
(1, 'CEST', '8590842000', 7200, '1'),
(1, 'CET', '8609590800', 3600, '0'),
(1, 'CEST', '8622291600', 7200, '1'),
(1, 'CET', '8641040400', 3600, '0'),
(1, 'CEST', '8654346000', 7200, '1'),
(1, 'CET', '8672490000', 3600, '0'),
(1, 'CEST', '8685795600', 7200, '1'),
(1, 'CET', '8703939600', 3600, '0'),
(1, 'CEST', '8717245200', 7200, '1'),
(1, 'CET', '8735389200', 3600, '0'),
(1, 'CEST', '8748694800', 7200, '1'),
(1, 'CET', '8767443600', 3600, '0'),
(1, 'CEST', '8780144400', 7200, '1'),
(1, 'CET', '8798893200', 3600, '0'),
(1, 'CEST', '8811594000', 7200, '1'),
(1, 'CET', '8830342800', 3600, '0'),
(1, 'CEST', '8843648400', 7200, '1'),
(1, 'CET', '8861792400', 3600, '0'),
(1, 'CEST', '8875098000', 7200, '1'),
(1, 'CET', '8893242000', 3600, '0'),
(1, 'CEST', '8906547600', 7200, '1'),
(1, 'CET', '8925296400', 3600, '0'),
(1, 'CEST', '8937997200', 7200, '1'),
(1, 'CET', '8956746000', 3600, '0'),
(1, 'CEST', '8969446800', 7200, '1'),
(1, 'CET', '8988195600', 3600, '0'),
(1, 'CEST', '9000896400', 7200, '1'),
(1, 'CET', '9019645200', 3600, '0'),
(1, 'CEST', '9032950800', 7200, '1'),
(1, 'CET', '9051094800', 3600, '0'),
(1, 'CEST', '9064400400', 7200, '1'),
(1, 'CET', '9082544400', 3600, '0'),
(1, 'CEST', '9095850000', 7200, '1'),
(1, 'CET', '9114598800', 3600, '0'),
(1, 'CEST', '9127299600', 7200, '1'),
(1, 'CET', '9146048400', 3600, '0'),
(1, 'CEST', '9158749200', 7200, '1'),
(1, 'CET', '9177498000', 3600, '0'),
(1, 'CEST', '9190803600', 7200, '1'),
(1, 'CET', '9208947600', 3600, '0'),
(1, 'CEST', '9222253200', 7200, '1'),
(1, 'CET', '9240397200', 3600, '0'),
(1, 'CEST', '9253702800', 7200, '1'),
(1, 'CET', '9271846800', 3600, '0'),
(1, 'CEST', '9285152400', 7200, '1'),
(1, 'CET', '9303901200', 3600, '0'),
(1, 'CEST', '9316602000', 7200, '1'),
(1, 'CET', '9335350800', 3600, '0'),
(1, 'CEST', '9348051600', 7200, '1'),
(1, 'CET', '9366800400', 3600, '0'),
(1, 'CEST', '9380106000', 7200, '1'),
(1, 'CET', '9398250000', 3600, '0'),
(1, 'CEST', '9411555600', 7200, '1'),
(1, 'CET', '9429699600', 3600, '0'),
(1, 'CEST', '9443005200', 7200, '1'),
(1, 'CET', '9461754000', 3600, '0'),
(1, 'CEST', '9474454800', 7200, '1'),
(1, 'CET', '9493203600', 3600, '0'),
(1, 'CEST', '9505904400', 7200, '1'),
(1, 'CET', '9524653200', 3600, '0'),
(1, 'CEST', '9537958800', 7200, '1'),
(1, 'CET', '9556102800', 3600, '0'),
(1, 'CEST', '9569408400', 7200, '1'),
(1, 'CET', '9587552400', 3600, '0'),
(1, 'CEST', '9600858000', 7200, '1'),
(1, 'CET', '9619002000', 3600, '0'),
(1, 'CEST', '9632307600', 7200, '1'),
(1, 'CET', '9651056400', 3600, '0'),
(1, 'CEST', '9663757200', 7200, '1'),
(1, 'CET', '9682506000', 3600, '0'),
(1, 'CEST', '9695206800', 7200, '1'),
(1, 'CET', '9713955600', 3600, '0'),
(1, 'CEST', '9727261200', 7200, '1'),
(1, 'CET', '9745405200', 3600, '0'),
(1, 'CEST', '9758710800', 7200, '1'),
(1, 'CET', '9776854800', 3600, '0'),
(1, 'CEST', '9790160400', 7200, '1'),
(1, 'CET', '9808909200', 3600, '0'),
(1, 'CEST', '9821610000', 7200, '1'),
(1, 'CET', '9840358800', 3600, '0'),
(1, 'CEST', '9853059600', 7200, '1'),
(1, 'CET', '9871808400', 3600, '0'),
(1, 'CEST', '9884509200', 7200, '1'),
(1, 'CET', '9903258000', 3600, '0'),
(1, 'CEST', '9916563600', 7200, '1'),
(1, 'CET', '9934707600', 3600, '0'),
(1, 'CEST', '9948013200', 7200, '1'),
(1, 'CET', '9966157200', 3600, '0'),
(1, 'CEST', '9979462800', 7200, '1'),
(1, 'CET', '9998211600', 3600, '0'),
(1, 'CEST', '10010912400', 7200, '1'),
(1, 'CET', '10029661200', 3600, '0'),
(1, 'CEST', '10042362000', 7200, '1'),
(1, 'CET', '10061110800', 3600, '0'),
(1, 'CEST', '10074416400', 7200, '1'),
(1, 'CET', '10092560400', 3600, '0'),
(1, 'CEST', '10105866000', 7200, '1'),
(1, 'CET', '10124010000', 3600, '0'),
(1, 'CEST', '10137315600', 7200, '1'),
(1, 'CET', '10155459600', 3600, '0'),
(1, 'CEST', '10168765200', 7200, '1'),
(1, 'CET', '10187514000', 3600, '0'),
(1, 'CEST', '10200214800', 7200, '1'),
(1, 'CET', '10218963600', 3600, '0'),
(1, 'CEST', '10231664400', 7200, '1'),
(1, 'CET', '10250413200', 3600, '0'),
(1, 'CEST', '10263718800', 7200, '1'),
(1, 'CET', '10281862800', 3600, '0'),
(1, 'CEST', '10295168400', 7200, '1'),
(1, 'CET', '10313312400', 3600, '0'),
(1, 'CEST', '10326618000', 7200, '1'),
(1, 'CET', '10345366800', 3600, '0'),
(1, 'CEST', '10358067600', 7200, '1'),
(1, 'CET', '10376816400', 3600, '0'),
(1, 'CEST', '10389517200', 7200, '1'),
(1, 'CET', '10408266000', 3600, '0'),
(1, 'CEST', '10420966800', 7200, '1'),
(1, 'CET', '10439715600', 3600, '0'),
(1, 'CEST', '10453021200', 7200, '1'),
(1, 'CET', '10471165200', 3600, '0'),
(1, 'CEST', '10484470800', 7200, '1'),
(1, 'CET', '10502614800', 3600, '0'),
(1, 'CEST', '10515920400', 7200, '1'),
(1, 'CET', '10534064400', 3600, '0'),
(1, 'CEST', '10547370000', 7200, '1'),
(1, 'CET', '10566118800', 3600, '0'),
(1, 'CEST', '10578819600', 7200, '1'),
(1, 'CET', '10597568400', 3600, '0'),
(1, 'CEST', '10610269200', 7200, '1'),
(1, 'CET', '10629018000', 3600, '0'),
(1, 'CEST', '10642323600', 7200, '1'),
(1, 'CET', '10660467600', 3600, '0'),
(1, 'CEST', '10673773200', 7200, '1'),
(1, 'CET', '10691917200', 3600, '0'),
(1, 'CEST', '10705222800', 7200, '1'),
(1, 'CET', '10723971600', 3600, '0'),
(1, 'CEST', '10736672400', 7200, '1'),
(1, 'CET', '10755421200', 3600, '0'),
(1, 'CEST', '10768122000', 7200, '1'),
(1, 'CET', '10786870800', 3600, '0'),
(1, 'CEST', '10800176400', 7200, '1'),
(1, 'CET', '10818320400', 3600, '0'),
(1, 'CEST', '10831626000', 7200, '1'),
(1, 'CET', '10849770000', 3600, '0'),
(1, 'CEST', '10863075600', 7200, '1'),
(1, 'CET', '10881219600', 3600, '0'),
(1, 'CEST', '10894525200', 7200, '1'),
(1, 'CET', '10913274000', 3600, '0'),
(1, 'CEST', '10925974800', 7200, '1'),
(1, 'CET', '10944723600', 3600, '0'),
(1, 'CEST', '10957424400', 7200, '1'),
(1, 'CET', '10976173200', 3600, '0'),
(1, 'CEST', '10989478800', 7200, '1'),
(1, 'CET', '11007622800', 3600, '0'),
(1, 'CEST', '11020928400', 7200, '1'),
(1, 'CET', '11039072400', 3600, '0'),
(1, 'CEST', '11052378000', 7200, '1'),
(1, 'CET', '11071126800', 3600, '0'),
(1, 'CEST', '11083827600', 7200, '1'),
(1, 'CET', '11102576400', 3600, '0'),
(1, 'CEST', '11115277200', 7200, '1'),
(1, 'CET', '11134026000', 3600, '0'),
(1, 'CEST', '11146726800', 7200, '1'),
(1, 'CET', '11165475600', 3600, '0'),
(1, 'CEST', '11178781200', 7200, '1'),
(1, 'CET', '11196925200', 3600, '0'),
(1, 'CEST', '11210230800', 7200, '1'),
(1, 'CET', '11228374800', 3600, '0'),
(1, 'CEST', '11241680400', 7200, '1'),
(1, 'CET', '11260429200', 3600, '0'),
(1, 'CEST', '11273130000', 7200, '1'),
(1, 'CET', '11291878800', 3600, '0'),
(1, 'CEST', '11304579600', 7200, '1'),
(1, 'CET', '11323328400', 3600, '0'),
(1, 'CEST', '11336634000', 7200, '1'),
(1, 'CET', '11354778000', 3600, '0'),
(1, 'CEST', '11368083600', 7200, '1'),
(1, 'CET', '11386227600', 3600, '0'),
(1, 'CEST', '11399533200', 7200, '1'),
(1, 'CET', '11417677200', 3600, '0'),
(1, 'CEST', '11430982800', 7200, '1'),
(1, 'CET', '11449731600', 3600, '0'),
(1, 'CEST', '11462432400', 7200, '1'),
(1, 'CET', '11481181200', 3600, '0'),
(1, 'CEST', '11493882000', 7200, '1'),
(1, 'CET', '11512630800', 3600, '0'),
(1, 'CEST', '11525936400', 7200, '1'),
(1, 'CET', '11544080400', 3600, '0'),
(1, 'CEST', '11557386000', 7200, '1'),
(1, 'CET', '11575530000', 3600, '0'),
(1, 'CEST', '11588835600', 7200, '1'),
(1, 'CET', '11607584400', 3600, '0'),
(1, 'CEST', '11620285200', 7200, '1'),
(1, 'CET', '11639034000', 3600, '0'),
(1, 'CEST', '11651734800', 7200, '1'),
(1, 'CET', '11670483600', 3600, '0'),
(1, 'CEST', '11683789200', 7200, '1'),
(1, 'CET', '11701933200', 3600, '0'),
(1, 'CEST', '11715238800', 7200, '1'),
(1, 'CET', '11733382800', 3600, '0'),
(1, 'CEST', '11746688400', 7200, '1'),
(1, 'CET', '11764832400', 3600, '0'),
(1, 'CEST', '11778138000', 7200, '1'),
(1, 'CET', '11796886800', 3600, '0'),
(1, 'CEST', '11809587600', 7200, '1'),
(1, 'CET', '11828336400', 3600, '0'),
(1, 'CEST', '11841037200', 7200, '1'),
(1, 'CET', '11859786000', 3600, '0'),
(1, 'CEST', '11873091600', 7200, '1'),
(1, 'CET', '11891235600', 3600, '0'),
(1, 'CEST', '11904541200', 7200, '1'),
(1, 'CET', '11922685200', 3600, '0'),
(1, 'CEST', '11935990800', 7200, '1'),
(1, 'CET', '11954739600', 3600, '0'),
(1, 'CEST', '11967440400', 7200, '1'),
(1, 'CET', '11986189200', 3600, '0'),
(1, 'CEST', '11998890000', 7200, '1'),
(1, 'CET', '12017638800', 3600, '0'),
(1, 'CEST', '12030339600', 7200, '1'),
(1, 'CET', '12049088400', 3600, '0'),
(1, 'CEST', '12062394000', 7200, '1'),
(1, 'CET', '12080538000', 3600, '0'),
(1, 'CEST', '12093843600', 7200, '1'),
(1, 'CET', '12111987600', 3600, '0'),
(1, 'CEST', '12125293200', 7200, '1'),
(1, 'CET', '12144042000', 3600, '0'),
(1, 'CEST', '12156742800', 7200, '1'),
(1, 'CET', '12175491600', 3600, '0'),
(1, 'CEST', '12188192400', 7200, '1'),
(1, 'CET', '12206941200', 3600, '0'),
(1, 'CEST', '12220246800', 7200, '1'),
(1, 'CET', '12238390800', 3600, '0'),
(1, 'CEST', '12251696400', 7200, '1'),
(1, 'CET', '12269840400', 3600, '0'),
(1, 'CEST', '12283146000', 7200, '1'),
(1, 'CET', '12301290000', 3600, '0'),
(1, 'CEST', '12314595600', 7200, '1'),
(1, 'CET', '12333344400', 3600, '0'),
(1, 'CEST', '12346045200', 7200, '1'),
(1, 'CET', '12364794000', 3600, '0'),
(1, 'CEST', '12377494800', 7200, '1'),
(1, 'CET', '12396243600', 3600, '0'),
(1, 'CEST', '12409549200', 7200, '1'),
(1, 'CET', '12427693200', 3600, '0'),
(1, 'CEST', '12440998800', 7200, '1'),
(1, 'CET', '12459142800', 3600, '0'),
(1, 'CEST', '12472448400', 7200, '1'),
(1, 'CET', '12491197200', 3600, '0'),
(1, 'CEST', '12503898000', 7200, '1'),
(1, 'CET', '12522646800', 3600, '0'),
(1, 'CEST', '12535347600', 7200, '1'),
(1, 'CET', '12554096400', 3600, '0'),
(1, 'CEST', '12567402000', 7200, '1'),
(1, 'CET', '12585546000', 3600, '0'),
(1, 'CEST', '12598851600', 7200, '1'),
(1, 'CET', '12616995600', 3600, '0'),
(1, 'CEST', '12630301200', 7200, '1'),
(1, 'CET', '12648445200', 3600, '0'),
(1, 'CEST', '12661750800', 7200, '1'),
(1, 'CET', '12680499600', 3600, '0'),
(1, 'CEST', '12693200400', 7200, '1'),
(1, 'CET', '12711949200', 3600, '0'),
(1, 'CEST', '12724650000', 7200, '1'),
(1, 'CET', '12743398800', 3600, '0'),
(1, 'CEST', '12756704400', 7200, '1'),
(1, 'CET', '12774848400', 3600, '0'),
(1, 'CEST', '12788154000', 7200, '1'),
(1, 'CET', '12806298000', 3600, '0'),
(1, 'CEST', '12819603600', 7200, '1'),
(1, 'CET', '12838352400', 3600, '0'),
(1, 'CEST', '12851053200', 7200, '1'),
(1, 'CET', '12869802000', 3600, '0'),
(1, 'CEST', '12882502800', 7200, '1'),
(1, 'CET', '12901251600', 3600, '0'),
(1, 'CEST', '12913952400', 7200, '1'),
(1, 'CET', '12932701200', 3600, '0'),
(1, 'CEST', '12946006800', 7200, '1'),
(1, 'CET', '12964150800', 3600, '0'),
(1, 'CEST', '12977456400', 7200, '1'),
(1, 'CET', '12995600400', 3600, '0'),
(1, 'CEST', '13008906000', 7200, '1'),
(1, 'CET', '13027654800', 3600, '0'),
(1, 'CEST', '13040355600', 7200, '1'),
(1, 'CET', '13059104400', 3600, '0'),
(1, 'CEST', '13071805200', 7200, '1'),
(1, 'CET', '13090554000', 3600, '0'),
(1, 'CEST', '13103859600', 7200, '1'),
(1, 'CET', '13122003600', 3600, '0'),
(1, 'CEST', '13135309200', 7200, '1'),
(1, 'CET', '13153453200', 3600, '0'),
(1, 'CEST', '13166758800', 7200, '1'),
(1, 'CET', '13184902800', 3600, '0'),
(1, 'CEST', '13198208400', 7200, '1'),
(1, 'CET', '13216957200', 3600, '0'),
(1, 'CEST', '13229658000', 7200, '1'),
(1, 'CET', '13248406800', 3600, '0'),
(1, 'CEST', '13261107600', 7200, '1'),
(1, 'CET', '13279856400', 3600, '0'),
(1, 'CEST', '13293162000', 7200, '1'),
(1, 'CET', '13311306000', 3600, '0'),
(1, 'CEST', '13324611600', 7200, '1'),
(1, 'CET', '13342755600', 3600, '0'),
(1, 'CEST', '13356061200', 7200, '1'),
(1, 'CET', '13374810000', 3600, '0'),
(1, 'CEST', '13387510800', 7200, '1'),
(1, 'CET', '13406259600', 3600, '0'),
(1, 'CEST', '13418960400', 7200, '1'),
(1, 'CET', '13437709200', 3600, '0'),
(1, 'CEST', '13451014800', 7200, '1'),
(1, 'CET', '13469158800', 3600, '0'),
(1, 'CEST', '13482464400', 7200, '1'),
(1, 'CET', '13500608400', 3600, '0'),
(1, 'CEST', '13513914000', 7200, '1'),
(1, 'CET', '13532058000', 3600, '0'),
(1, 'CEST', '13545363600', 7200, '1'),
(1, 'CET', '13564112400', 3600, '0'),
(1, 'CEST', '13576813200', 7200, '1'),
(1, 'CET', '13595562000', 3600, '0'),
(1, 'CEST', '13608262800', 7200, '1'),
(1, 'CET', '13627011600', 3600, '0'),
(1, 'CEST', '13640317200', 7200, '1'),
(1, 'CET', '13658461200', 3600, '0'),
(1, 'CEST', '13671766800', 7200, '1'),
(1, 'CET', '13689910800', 3600, '0'),
(1, 'CEST', '13703216400', 7200, '1'),
(1, 'CET', '13721965200', 3600, '0'),
(1, 'CEST', '13734666000', 7200, '1'),
(1, 'CET', '13753414800', 3600, '0'),
(1, 'CEST', '13766115600', 7200, '1'),
(1, 'CET', '13784864400', 3600, '0'),
(1, 'CEST', '13797565200', 7200, '1'),
(1, 'CET', '13816314000', 3600, '0'),
(1, 'CEST', '13829619600', 7200, '1'),
(1, 'CET', '13847763600', 3600, '0'),
(1, 'CEST', '13861069200', 7200, '1'),
(1, 'CET', '13879213200', 3600, '0'),
(1, 'CEST', '13892518800', 7200, '1'),
(1, 'CET', '13911267600', 3600, '0'),
(1, 'CEST', '13923968400', 7200, '1'),
(1, 'CET', '13942717200', 3600, '0'),
(1, 'CEST', '13955418000', 7200, '1'),
(1, 'CET', '13974166800', 3600, '0'),
(1, 'CEST', '13987472400', 7200, '1'),
(1, 'CET', '14005616400', 3600, '0'),
(1, 'CEST', '14018922000', 7200, '1'),
(1, 'CET', '14037066000', 3600, '0'),
(1, 'CEST', '14050371600', 7200, '1'),
(1, 'CET', '14068515600', 3600, '0'),
(1, 'CEST', '14081821200', 7200, '1'),
(1, 'CET', '14100570000', 3600, '0'),
(1, 'CEST', '14113270800', 7200, '1'),
(1, 'CET', '14132019600', 3600, '0'),
(1, 'CEST', '14144720400', 7200, '1'),
(1, 'CET', '14163469200', 3600, '0'),
(1, 'CEST', '14176774800', 7200, '1'),
(1, 'CET', '14194918800', 3600, '0'),
(1, 'CEST', '14208224400', 7200, '1'),
(1, 'CET', '14226368400', 3600, '0'),
(1, 'CEST', '14239674000', 7200, '1'),
(1, 'CET', '14258422800', 3600, '0'),
(1, 'CEST', '14271123600', 7200, '1'),
(1, 'CET', '14289872400', 3600, '0'),
(1, 'CEST', '14302573200', 7200, '1'),
(1, 'CET', '14321322000', 3600, '0'),
(1, 'CEST', '14334627600', 7200, '1'),
(1, 'CET', '14352771600', 3600, '0'),
(1, 'CEST', '14366077200', 7200, '1'),
(1, 'CET', '14384221200', 3600, '0'),
(1, 'CEST', '14397526800', 7200, '1'),
(1, 'CET', '14415670800', 3600, '0'),
(1, 'CEST', '14428976400', 7200, '1'),
(1, 'CET', '14447725200', 3600, '0'),
(1, 'CEST', '14460426000', 7200, '1'),
(1, 'CET', '14479174800', 3600, '0'),
(1, 'CEST', '14491875600', 7200, '1'),
(1, 'CET', '14510624400', 3600, '0'),
(1, 'CEST', '14523930000', 7200, '1'),
(1, 'CET', '14542074000', 3600, '0'),
(1, 'CEST', '14555379600', 7200, '1'),
(1, 'CET', '14573523600', 3600, '0'),
(1, 'CEST', '14586829200', 7200, '1'),
(1, 'CET', '14605578000', 3600, '0'),
(1, 'CEST', '14618278800', 7200, '1'),
(1, 'CET', '14637027600', 3600, '0'),
(1, 'CEST', '14649728400', 7200, '1'),
(1, 'CET', '14668477200', 3600, '0'),
(1, 'CEST', '14681178000', 7200, '1'),
(1, 'CET', '14699926800', 3600, '0'),
(1, 'CEST', '14713232400', 7200, '1'),
(1, 'CET', '14731376400', 3600, '0'),
(1, 'CEST', '14744682000', 7200, '1'),
(1, 'CET', '14762826000', 3600, '0'),
(1, 'CEST', '14776131600', 7200, '1'),
(1, 'CET', '14794880400', 3600, '0'),
(1, 'CEST', '14807581200', 7200, '1'),
(1, 'CET', '14826330000', 3600, '0'),
(1, 'CEST', '14839030800', 7200, '1'),
(1, 'CET', '14857779600', 3600, '0'),
(1, 'CEST', '14871085200', 7200, '1'),
(1, 'CET', '14889229200', 3600, '0'),
(1, 'CEST', '14902534800', 7200, '1'),
(1, 'CET', '14920678800', 3600, '0'),
(1, 'CEST', '14933984400', 7200, '1'),
(1, 'CET', '14952128400', 3600, '0'),
(1, 'CEST', '14965434000', 7200, '1'),
(1, 'CET', '14984182800', 3600, '0'),
(1, 'CEST', '14996883600', 7200, '1'),
(1, 'CET', '15015632400', 3600, '0'),
(1, 'CEST', '15028333200', 7200, '1'),
(1, 'CET', '15047082000', 3600, '0'),
(1, 'CEST', '15060387600', 7200, '1'),
(1, 'CET', '15078531600', 3600, '0'),
(1, 'CEST', '15091837200', 7200, '1'),
(1, 'CET', '15109981200', 3600, '0'),
(1, 'CEST', '15123286800', 7200, '1'),
(1, 'CET', '15142035600', 3600, '0'),
(1, 'CEST', '15154736400', 7200, '1'),
(1, 'CET', '15173485200', 3600, '0'),
(1, 'CEST', '15186186000', 7200, '1'),
(1, 'CET', '15204934800', 3600, '0'),
(1, 'CEST', '15218240400', 7200, '1'),
(1, 'CET', '15236384400', 3600, '0'),
(1, 'CEST', '15249690000', 7200, '1'),
(1, 'CET', '15267834000', 3600, '0'),
(1, 'CEST', '15281139600', 7200, '1'),
(1, 'CET', '15299283600', 3600, '0'),
(1, 'CEST', '15312589200', 7200, '1'),
(1, 'CET', '15331338000', 3600, '0'),
(1, 'CEST', '15344038800', 7200, '1'),
(1, 'CET', '15362787600', 3600, '0'),
(1, 'CEST', '15375488400', 7200, '1'),
(1, 'CET', '15394237200', 3600, '0'),
(1, 'CEST', '15407542800', 7200, '1'),
(1, 'CET', '15425686800', 3600, '0'),
(1, 'CEST', '15438992400', 7200, '1'),
(1, 'CET', '15457136400', 3600, '0'),
(1, 'CEST', '15470442000', 7200, '1'),
(1, 'CET', '15489190800', 3600, '0'),
(1, 'CEST', '15501891600', 7200, '1'),
(1, 'CET', '15520640400', 3600, '0'),
(1, 'CEST', '15533341200', 7200, '1'),
(1, 'CET', '15552090000', 3600, '0'),
(1, 'CEST', '15564790800', 7200, '1'),
(1, 'CET', '15583539600', 3600, '0'),
(1, 'CEST', '15596845200', 7200, '1'),
(1, 'CET', '15614989200', 3600, '0'),
(1, 'CEST', '15628294800', 7200, '1'),
(1, 'CET', '15646438800', 3600, '0'),
(1, 'CEST', '15659744400', 7200, '1'),
(1, 'CET', '15678493200', 3600, '0'),
(1, 'CEST', '15691194000', 7200, '1'),
(1, 'CET', '15709942800', 3600, '0'),
(1, 'CEST', '15722643600', 7200, '1'),
(1, 'CET', '15741392400', 3600, '0'),
(1, 'CEST', '15754698000', 7200, '1'),
(1, 'CET', '15772842000', 3600, '0'),
(1, 'CEST', '15786147600', 7200, '1'),
(1, 'CET', '15804291600', 3600, '0'),
(1, 'CEST', '15817597200', 7200, '1'),
(1, 'CET', '15835741200', 3600, '0'),
(1, 'CEST', '15849046800', 7200, '1'),
(1, 'CET', '15867795600', 3600, '0'),
(1, 'CEST', '15880496400', 7200, '1'),
(1, 'CET', '15899245200', 3600, '0'),
(1, 'CEST', '15911946000', 7200, '1'),
(1, 'CET', '15930694800', 3600, '0'),
(1, 'CEST', '15944000400', 7200, '1'),
(1, 'CET', '15962144400', 3600, '0'),
(1, 'CEST', '15975450000', 7200, '1'),
(1, 'CET', '15993594000', 3600, '0'),
(1, 'CEST', '16006899600', 7200, '1'),
(1, 'CET', '16025648400', 3600, '0'),
(1, 'CEST', '16038349200', 7200, '1'),
(1, 'CET', '16057098000', 3600, '0'),
(1, 'CEST', '16069798800', 7200, '1'),
(1, 'CET', '16088547600', 3600, '0'),
(1, 'CEST', '16101853200', 7200, '1'),
(1, 'CET', '16119997200', 3600, '0'),
(1, 'CEST', '16133302800', 7200, '1'),
(1, 'CET', '16151446800', 3600, '0'),
(1, 'CEST', '16164752400', 7200, '1'),
(1, 'CET', '16182896400', 3600, '0'),
(1, 'CEST', '16196202000', 7200, '1'),
(1, 'CET', '16214950800', 3600, '0'),
(1, 'CEST', '16227651600', 7200, '1'),
(1, 'CET', '16246400400', 3600, '0'),
(1, 'CEST', '16259101200', 7200, '1'),
(1, 'CET', '16277850000', 3600, '0'),
(1, 'CEST', '16291155600', 7200, '1'),
(1, 'CET', '16309299600', 3600, '0'),
(1, 'CEST', '16322605200', 7200, '1'),
(1, 'CET', '16340749200', 3600, '0'),
(1, 'CEST', '16354054800', 7200, '1'),
(1, 'CET', '16372803600', 3600, '0'),
(1, 'CEST', '16385504400', 7200, '1'),
(1, 'CET', '16404253200', 3600, '0'),
(1, 'CEST', '16416954000', 7200, '1'),
(1, 'CET', '16435702800', 3600, '0'),
(1, 'CEST', '16448403600', 7200, '1'),
(1, 'CET', '16467152400', 3600, '0'),
(1, 'CEST', '16480458000', 7200, '1'),
(1, 'CET', '16498602000', 3600, '0'),
(1, 'CEST', '16511907600', 7200, '1'),
(1, 'CET', '16530051600', 3600, '0'),
(1, 'CEST', '16543357200', 7200, '1'),
(1, 'CET', '16562106000', 3600, '0'),
(1, 'CEST', '16574806800', 7200, '1'),
(1, 'CET', '16593555600', 3600, '0'),
(1, 'CEST', '16606256400', 7200, '1'),
(1, 'CET', '16625005200', 3600, '0'),
(1, 'CEST', '16638310800', 7200, '1'),
(1, 'CET', '16656454800', 3600, '0'),
(1, 'CEST', '16669760400', 7200, '1'),
(1, 'CET', '16687904400', 3600, '0'),
(1, 'CEST', '16701210000', 7200, '1'),
(1, 'CET', '16719354000', 3600, '0'),
(2, 'LMT', '-1577936473', 13272, '0'),
(2, '+04', '-1577936472', 14400, '0'),
(3, 'LMT', '-2524538209', 16608, '0'),
(3, '+04', '-2524538208', 14400, '0'),
(3, '+0430', '-788932800', 16200, '0'),
(4, 'LMT', '-1825098837', -14764, '0'),
(4, 'AST', '-1825098836', -14400, '0'),
(5, 'LMT', '-1825098837', -14764, '0'),
(5, 'AST', '-1825098836', -14400, '0'),
(6, 'LMT', '-1767230361', 4760, '0'),
(6, 'CET', '-1767230360', 3600, '0'),
(6, 'CEST', '-932346000', 7200, '1'),
(6, 'CET', '-857257200', 3600, '0'),
(6, 'CEST', '-844556400', 7200, '1'),

(6, 'CET', '-843519600', 3600, '0'),
(6, 'CEST', '136854000', 7200, '1'),
(6, 'CET', '149896800', 3600, '0'),
(6, 'CEST', '168130800', 7200, '1'),
(6, 'CET', '181432800', 3600, '0'),
(6, 'CEST', '199839600', 7200, '1'),
(6, 'CET', '213141600', 3600, '0'),
(6, 'CEST', '231894000', 7200, '1'),
(6, 'CET', '244591200', 3600, '0'),
(6, 'CEST', '263257200', 7200, '1'),
(6, 'CET', '276040800', 3600, '0'),
(6, 'CEST', '294706800', 7200, '1'),
(6, 'CET', '307490400', 3600, '0'),
(6, 'CEST', '326156400', 7200, '1'),
(6, 'CET', '339458400', 3600, '0'),
(6, 'CEST', '357087600', 7200, '1'),
(6, 'CET', '370389600', 3600, '0'),
(6, 'CEST', '389142000', 7200, '1'),
(6, 'CET', '402444000', 3600, '0'),
(6, 'CEST', '419468400', 7200, '1'),
(6, 'CET', '433807200', 3600, '0'),
(6, 'CEST', '449622000', 7200, '1'),
(6, 'CET', '465354000', 3600, '0'),
(6, 'CEST', '481078800', 7200, '1'),
(6, 'CET', '496803600', 3600, '0'),
(6, 'CEST', '512528400', 7200, '1'),
(6, 'CET', '528253200', 3600, '0'),
(6, 'CEST', '543978000', 7200, '1'),
(6, 'CET', '559702800', 3600, '0'),
(6, 'CEST', '575427600', 7200, '1'),
(6, 'CET', '591152400', 3600, '0'),
(6, 'CEST', '606877200', 7200, '1'),
(6, 'CET', '622602000', 3600, '0'),
(6, 'CEST', '638326800', 7200, '1'),
(6, 'CET', '654656400', 3600, '0'),
(6, 'CEST', '670381200', 7200, '1'),
(6, 'CET', '686106000', 3600, '0'),
(6, 'CEST', '701830800', 7200, '1'),
(6, 'CET', '717555600', 3600, '0'),
(6, 'CEST', '733280400', 7200, '1'),
(6, 'CET', '749005200', 3600, '0'),
(6, 'CEST', '764730000', 7200, '1'),
(6, 'CET', '780454800', 3600, '0'),
(6, 'CEST', '796179600', 7200, '1'),
(6, 'CET', '811904400', 3600, '0'),
(6, 'CEST', '828234000', 7200, '1'),
(6, 'CET', '846378000', 3600, '0'),
(6, 'CEST', '859683600', 7200, '1'),
(6, 'CET', '877827600', 3600, '0'),
(6, 'CEST', '891133200', 7200, '1'),
(6, 'CET', '909277200', 3600, '0'),
(6, 'CEST', '922582800', 7200, '1'),
(6, 'CET', '941331600', 3600, '0'),
(6, 'CEST', '954032400', 7200, '1'),
(6, 'CET', '972781200', 3600, '0'),
(6, 'CEST', '985482000', 7200, '1'),
(6, 'CET', '1004230800', 3600, '0'),
(6, 'CEST', '1017536400', 7200, '1'),
(6, 'CET', '1035680400', 3600, '0'),
(6, 'CEST', '1048986000', 7200, '1'),
(6, 'CET', '1067130000', 3600, '0'),
(6, 'CEST', '1080435600', 7200, '1'),
(6, 'CET', '1099184400', 3600, '0'),
(6, 'CEST', '1111885200', 7200, '1'),
(6, 'CET', '1130634000', 3600, '0'),
(6, 'CEST', '1143334800', 7200, '1'),
(6, 'CET', '1162083600', 3600, '0'),
(6, 'CEST', '1174784400', 7200, '1'),
(6, 'CET', '1193533200', 3600, '0'),
(6, 'CEST', '1206838800', 7200, '1'),
(6, 'CET', '1224982800', 3600, '0'),
(6, 'CEST', '1238288400', 7200, '1'),
(6, 'CET', '1256432400', 3600, '0'),
(6, 'CEST', '1269738000', 7200, '1'),
(6, 'CET', '1288486800', 3600, '0'),
(6, 'CEST', '1301187600', 7200, '1'),
(6, 'CET', '1319936400', 3600, '0'),
(6, 'CEST', '1332637200', 7200, '1'),
(6, 'CET', '1351386000', 3600, '0'),
(6, 'CEST', '1364691600', 7200, '1'),
(6, 'CET', '1382835600', 3600, '0'),
(6, 'CEST', '1396141200', 7200, '1'),
(6, 'CET', '1414285200', 3600, '0'),
(6, 'CEST', '1427590800', 7200, '1'),
(6, 'CET', '1445734800', 3600, '0'),
(6, 'CEST', '1459040400', 7200, '1'),
(6, 'CET', '1477789200', 3600, '0'),
(6, 'CEST', '1490490000', 7200, '1'),
(6, 'CET', '1509238800', 3600, '0'),
(6, 'CEST', '1521939600', 7200, '1'),
(6, 'CET', '1540688400', 3600, '0'),
(6, 'CEST', '1553994000', 7200, '1'),
(6, 'CET', '1572138000', 3600, '0'),
(6, 'CEST', '1585443600', 7200, '1'),
(6, 'CET', '1603587600', 3600, '0'),
(6, 'CEST', '1616893200', 7200, '1'),
(6, 'CET', '1635642000', 3600, '0'),
(6, 'CEST', '1648342800', 7200, '1'),
(6, 'CET', '1667091600', 3600, '0'),
(6, 'CEST', '1679792400', 7200, '1'),
(6, 'CET', '1698541200', 3600, '0'),
(6, 'CEST', '1711846800', 7200, '1'),
(6, 'CET', '1729990800', 3600, '0'),
(6, 'CEST', '1743296400', 7200, '1'),
(6, 'CET', '1761440400', 3600, '0'),
(6, 'CEST', '1774746000', 7200, '1'),
(6, 'CET', '1792890000', 3600, '0'),
(6, 'CEST', '1806195600', 7200, '1'),
(6, 'CET', '1824944400', 3600, '0'),
(6, 'CEST', '1837645200', 7200, '1'),
(6, 'CET', '1856394000', 3600, '0'),
(6, 'CEST', '1869094800', 7200, '1'),
(6, 'CET', '1887843600', 3600, '0'),
(6, 'CEST', '1901149200', 7200, '1'),
(6, 'CET', '1919293200', 3600, '0'),
(6, 'CEST', '1932598800', 7200, '1'),
(6, 'CET', '1950742800', 3600, '0'),
(6, 'CEST', '1964048400', 7200, '1'),
(6, 'CET', '1982797200', 3600, '0'),
(6, 'CEST', '1995498000', 7200, '1'),
(6, 'CET', '2014246800', 3600, '0'),
(6, 'CEST', '2026947600', 7200, '1'),
(6, 'CET', '2045696400', 3600, '0'),
(6, 'CEST', '2058397200', 7200, '1'),
(6, 'CET', '2077146000', 3600, '0'),
(6, 'CEST', '2090451600', 7200, '1'),
(6, 'CET', '2108595600', 3600, '0'),
(6, 'CEST', '2121901200', 7200, '1'),
(6, 'CET', '2140045200', 3600, '0'),
(6, 'CEST', '2153350800', 7200, '1'),
(6, 'CET', '2172099600', 3600, '0'),
(6, 'CEST', '2184800400', 7200, '1'),
(6, 'CET', '2203549200', 3600, '0'),
(6, 'CEST', '2216250000', 7200, '1'),
(6, 'CET', '2234998800', 3600, '0'),
(6, 'CEST', '2248304400', 7200, '1'),
(6, 'CET', '2266448400', 3600, '0'),
(6, 'CEST', '2279754000', 7200, '1'),
(6, 'CET', '2297898000', 3600, '0'),
(6, 'CEST', '2311203600', 7200, '1'),
(6, 'CET', '2329347600', 3600, '0'),
(6, 'CEST', '2342653200', 7200, '1'),
(6, 'CET', '2361402000', 3600, '0'),
(6, 'CEST', '2374102800', 7200, '1'),
(6, 'CET', '2392851600', 3600, '0'),
(6, 'CEST', '2405552400', 7200, '1'),
(6, 'CET', '2424301200', 3600, '0'),
(6, 'CEST', '2437606800', 7200, '1'),
(6, 'CET', '2455750800', 3600, '0'),
(6, 'CEST', '2469056400', 7200, '1'),
(6, 'CET', '2487200400', 3600, '0'),
(6, 'CEST', '2500506000', 7200, '1'),
(6, 'CET', '2519254800', 3600, '0'),
(6, 'CEST', '2531955600', 7200, '1'),
(6, 'CET', '2550704400', 3600, '0'),
(6, 'CEST', '2563405200', 7200, '1'),
(6, 'CET', '2582154000', 3600, '0'),
(6, 'CEST', '2595459600', 7200, '1'),
(6, 'CET', '2613603600', 3600, '0'),
(6, 'CEST', '2626909200', 7200, '1'),
(6, 'CET', '2645053200', 3600, '0'),
(6, 'CEST', '2658358800', 7200, '1'),
(6, 'CET', '2676502800', 3600, '0'),
(6, 'CEST', '2689808400', 7200, '1'),
(6, 'CET', '2708557200', 3600, '0'),
(6, 'CEST', '2721258000', 7200, '1'),
(6, 'CET', '2740006800', 3600, '0'),
(6, 'CEST', '2752707600', 7200, '1'),
(6, 'CET', '2771456400', 3600, '0'),
(6, 'CEST', '2784762000', 7200, '1'),
(6, 'CET', '2802906000', 3600, '0'),
(6, 'CEST', '2816211600', 7200, '1'),
(6, 'CET', '2834355600', 3600, '0'),
(6, 'CEST', '2847661200', 7200, '1'),
(6, 'CET', '2866410000', 3600, '0'),
(6, 'CEST', '2879110800', 7200, '1'),
(6, 'CET', '2897859600', 3600, '0'),
(6, 'CEST', '2910560400', 7200, '1'),
(6, 'CET', '2929309200', 3600, '0'),
(6, 'CEST', '2942010000', 7200, '1'),
(6, 'CET', '2960758800', 3600, '0'),
(6, 'CEST', '2974064400', 7200, '1'),
(6, 'CET', '2992208400', 3600, '0'),
(6, 'CEST', '3005514000', 7200, '1'),
(6, 'CET', '3023658000', 3600, '0'),
(6, 'CEST', '3036963600', 7200, '1'),
(6, 'CET', '3055712400', 3600, '0'),
(6, 'CEST', '3068413200', 7200, '1'),
(6, 'CET', '3087162000', 3600, '0'),
(6, 'CEST', '3099862800', 7200, '1'),
(6, 'CET', '3118611600', 3600, '0'),
(6, 'CEST', '3131917200', 7200, '1'),
(6, 'CET', '3150061200', 3600, '0'),
(6, 'CEST', '3163366800', 7200, '1'),
(6, 'CET', '3181510800', 3600, '0'),
(6, 'CEST', '3194816400', 7200, '1'),
(6, 'CET', '3212960400', 3600, '0'),
(6, 'CEST', '3226266000', 7200, '1'),
(6, 'CET', '3245014800', 3600, '0'),
(6, 'CEST', '3257715600', 7200, '1'),
(6, 'CET', '3276464400', 3600, '0'),
(6, 'CEST', '3289165200', 7200, '1'),
(6, 'CET', '3307914000', 3600, '0'),
(6, 'CEST', '3321219600', 7200, '1'),
(6, 'CET', '3339363600', 3600, '0'),
(6, 'CEST', '3352669200', 7200, '1'),
(6, 'CET', '3370813200', 3600, '0'),
(6, 'CEST', '3384118800', 7200, '1'),
(6, 'CET', '3402867600', 3600, '0'),
(6, 'CEST', '3415568400', 7200, '1'),
(6, 'CET', '3434317200', 3600, '0'),
(6, 'CEST', '3447018000', 7200, '1'),
(6, 'CET', '3465766800', 3600, '0'),
(6, 'CEST', '3479072400', 7200, '1'),
(6, 'CET', '3497216400', 3600, '0'),
(6, 'CEST', '3510522000', 7200, '1'),
(6, 'CET', '3528666000', 3600, '0'),
(6, 'CEST', '3541971600', 7200, '1'),
(6, 'CET', '3560115600', 3600, '0'),
(6, 'CEST', '3573421200', 7200, '1'),
(6, 'CET', '3592170000', 3600, '0'),
(6, 'CEST', '3604870800', 7200, '1'),
(6, 'CET', '3623619600', 3600, '0'),
(6, 'CEST', '3636320400', 7200, '1'),
(6, 'CET', '3655069200', 3600, '0'),
(6, 'CEST', '3668374800', 7200, '1'),
(6, 'CET', '3686518800', 3600, '0'),
(6, 'CEST', '3699824400', 7200, '1'),
(6, 'CET', '3717968400', 3600, '0'),
(6, 'CEST', '3731274000', 7200, '1'),
(6, 'CET', '3750022800', 3600, '0'),
(6, 'CEST', '3762723600', 7200, '1'),
(6, 'CET', '3781472400', 3600, '0'),
(6, 'CEST', '3794173200', 7200, '1'),
(6, 'CET', '3812922000', 3600, '0'),
(6, 'CEST', '3825622800', 7200, '1'),
(6, 'CET', '3844371600', 3600, '0'),
(6, 'CEST', '3857677200', 7200, '1'),
(6, 'CET', '3875821200', 3600, '0'),
(6, 'CEST', '3889126800', 7200, '1'),
(6, 'CET', '3907270800', 3600, '0'),
(6, 'CEST', '3920576400', 7200, '1'),
(6, 'CET', '3939325200', 3600, '0'),
(6, 'CEST', '3952026000', 7200, '1'),
(6, 'CET', '3970774800', 3600, '0'),
(6, 'CEST', '3983475600', 7200, '1'),
(6, 'CET', '4002224400', 3600, '0'),
(6, 'CEST', '4015530000', 7200, '1'),
(6, 'CET', '4033674000', 3600, '0'),
(6, 'CEST', '4046979600', 7200, '1'),
(6, 'CET', '4065123600', 3600, '0'),
(6, 'CEST', '4078429200', 7200, '1'),
(6, 'CET', '4096573200', 3600, '0'),
(6, 'CEST', '4109878800', 7200, '1'),
(6, 'CET', '4128627600', 3600, '0'),
(6, 'CEST', '4141328400', 7200, '1'),
(6, 'CET', '4160077200', 3600, '0'),
(6, 'CEST', '4172778000', 7200, '1'),
(6, 'CET', '4191526800', 3600, '0'),
(6, 'CEST', '4204227600', 7200, '1'),
(6, 'CET', '4222976400', 3600, '0'),
(6, 'CEST', '4236282000', 7200, '1'),
(6, 'CET', '4254426000', 3600, '0'),
(6, 'CEST', '4267731600', 7200, '1'),
(6, 'CET', '4285875600', 3600, '0'),
(6, 'CEST', '4299181200', 7200, '1'),
(6, 'CET', '4317930000', 3600, '0'),
(6, 'CEST', '4330630800', 7200, '1'),
(6, 'CET', '4349379600', 3600, '0'),
(6, 'CEST', '4362080400', 7200, '1'),
(6, 'CET', '4380829200', 3600, '0'),
(6, 'CEST', '4394134800', 7200, '1'),
(6, 'CET', '4412278800', 3600, '0'),
(6, 'CEST', '4425584400', 7200, '1'),
(6, 'CET', '4443728400', 3600, '0'),
(6, 'CEST', '4457034000', 7200, '1'),
(6, 'CET', '4475178000', 3600, '0'),
(6, 'CEST', '4488483600', 7200, '1'),
(6, 'CET', '4507232400', 3600, '0'),
(6, 'CEST', '4519933200', 7200, '1'),
(6, 'CET', '4538682000', 3600, '0'),
(6, 'CEST', '4551382800', 7200, '1'),
(6, 'CET', '4570131600', 3600, '0'),
(6, 'CEST', '4583437200', 7200, '1'),
(6, 'CET', '4601581200', 3600, '0'),
(6, 'CEST', '4614886800', 7200, '1'),
(6, 'CET', '4633030800', 3600, '0'),
(6, 'CEST', '4646336400', 7200, '1'),
(6, 'CET', '4665085200', 3600, '0'),
(6, 'CEST', '4677786000', 7200, '1'),
(6, 'CET', '4696534800', 3600, '0'),
(6, 'CEST', '4709235600', 7200, '1'),
(6, 'CET', '4727984400', 3600, '0'),
(6, 'CEST', '4741290000', 7200, '1'),
(6, 'CET', '4759434000', 3600, '0'),
(6, 'CEST', '4772739600', 7200, '1'),
(6, 'CET', '4790883600', 3600, '0'),
(6, 'CEST', '4804189200', 7200, '1'),
(6, 'CET', '4822333200', 3600, '0'),
(6, 'CEST', '4835638800', 7200, '1'),
(6, 'CET', '4854387600', 3600, '0'),
(6, 'CEST', '4867088400', 7200, '1'),
(6, 'CET', '4885837200', 3600, '0'),
(6, 'CEST', '4898538000', 7200, '1'),
(6, 'CET', '4917286800', 3600, '0'),
(6, 'CEST', '4930592400', 7200, '1'),
(6, 'CET', '4948736400', 3600, '0'),
(6, 'CEST', '4962042000', 7200, '1'),
(6, 'CET', '4980186000', 3600, '0'),
(6, 'CEST', '4993491600', 7200, '1'),
(6, 'CET', '5012240400', 3600, '0'),
(6, 'CEST', '5024941200', 7200, '1'),
(6, 'CET', '5043690000', 3600, '0'),
(6, 'CEST', '5056390800', 7200, '1'),
(6, 'CET', '5075139600', 3600, '0'),
(6, 'CEST', '5087840400', 7200, '1'),
(6, 'CET', '5106589200', 3600, '0'),
(6, 'CEST', '5119894800', 7200, '1'),
(6, 'CET', '5138038800', 3600, '0'),
(6, 'CEST', '5151344400', 7200, '1'),
(6, 'CET', '5169488400', 3600, '0'),
(6, 'CEST', '5182794000', 7200, '1'),
(6, 'CET', '5201542800', 3600, '0'),
(6, 'CEST', '5214243600', 7200, '1'),
(6, 'CET', '5232992400', 3600, '0'),
(6, 'CEST', '5245693200', 7200, '1'),
(6, 'CET', '5264442000', 3600, '0'),
(6, 'CEST', '5277747600', 7200, '1'),
(6, 'CET', '5295891600', 3600, '0'),
(6, 'CEST', '5309197200', 7200, '1'),
(6, 'CET', '5327341200', 3600, '0'),
(6, 'CEST', '5340646800', 7200, '1'),
(6, 'CET', '5358790800', 3600, '0'),
(6, 'CEST', '5372096400', 7200, '1'),
(6, 'CET', '5390845200', 3600, '0'),
(6, 'CEST', '5403546000', 7200, '1'),
(6, 'CET', '5422294800', 3600, '0'),
(6, 'CEST', '5434995600', 7200, '1'),
(6, 'CET', '5453744400', 3600, '0'),
(6, 'CEST', '5467050000', 7200, '1'),
(6, 'CET', '5485194000', 3600, '0'),
(6, 'CEST', '5498499600', 7200, '1'),
(6, 'CET', '5516643600', 3600, '0'),
(6, 'CEST', '5529949200', 7200, '1'),
(6, 'CET', '5548698000', 3600, '0'),
(6, 'CEST', '5561398800', 7200, '1'),
(6, 'CET', '5580147600', 3600, '0'),
(6, 'CEST', '5592848400', 7200, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(6, 'CET', '5611597200', 3600, '0'),
(6, 'CEST', '5624902800', 7200, '1'),
(6, 'CET', '5643046800', 3600, '0'),
(6, 'CEST', '5656352400', 7200, '1'),
(6, 'CET', '5674496400', 3600, '0'),
(6, 'CEST', '5687802000', 7200, '1'),
(6, 'CET', '5705946000', 3600, '0'),
(6, 'CEST', '5719251600', 7200, '1'),
(6, 'CET', '5738000400', 3600, '0'),
(6, 'CEST', '5750701200', 7200, '1'),
(6, 'CET', '5769450000', 3600, '0'),
(6, 'CEST', '5782150800', 7200, '1'),
(6, 'CET', '5800899600', 3600, '0'),
(6, 'CEST', '5814205200', 7200, '1'),
(6, 'CET', '5832349200', 3600, '0'),
(6, 'CEST', '5845654800', 7200, '1'),
(6, 'CET', '5863798800', 3600, '0'),
(6, 'CEST', '5877104400', 7200, '1'),
(6, 'CET', '5895853200', 3600, '0'),
(6, 'CEST', '5908554000', 7200, '1'),
(6, 'CET', '5927302800', 3600, '0'),
(6, 'CEST', '5940003600', 7200, '1'),
(6, 'CET', '5958752400', 3600, '0'),
(6, 'CEST', '5971453200', 7200, '1'),
(6, 'CET', '5990202000', 3600, '0'),
(6, 'CEST', '6003507600', 7200, '1'),
(6, 'CET', '6021651600', 3600, '0'),
(6, 'CEST', '6034957200', 7200, '1'),
(6, 'CET', '6053101200', 3600, '0'),
(6, 'CEST', '6066406800', 7200, '1'),
(6, 'CET', '6085155600', 3600, '0'),
(6, 'CEST', '6097856400', 7200, '1'),
(6, 'CET', '6116605200', 3600, '0'),
(6, 'CEST', '6129306000', 7200, '1'),
(6, 'CET', '6148054800', 3600, '0'),
(6, 'CEST', '6161360400', 7200, '1'),
(6, 'CET', '6179504400', 3600, '0'),
(6, 'CEST', '6192810000', 7200, '1'),
(6, 'CET', '6210954000', 3600, '0'),
(6, 'CEST', '6224259600', 7200, '1'),
(6, 'CET', '6242403600', 3600, '0'),
(6, 'CEST', '6255709200', 7200, '1'),
(6, 'CET', '6274458000', 3600, '0'),
(6, 'CEST', '6287158800', 7200, '1'),
(6, 'CET', '6305907600', 3600, '0'),
(6, 'CEST', '6318608400', 7200, '1'),
(6, 'CET', '6337357200', 3600, '0'),
(6, 'CEST', '6350662800', 7200, '1'),
(6, 'CET', '6368806800', 3600, '0'),
(6, 'CEST', '6382112400', 7200, '1'),
(6, 'CET', '6400256400', 3600, '0'),
(6, 'CEST', '6413562000', 7200, '1'),
(6, 'CET', '6432310800', 3600, '0'),
(6, 'CEST', '6445011600', 7200, '1'),
(6, 'CET', '6463760400', 3600, '0'),
(6, 'CEST', '6476461200', 7200, '1'),
(6, 'CET', '6495210000', 3600, '0'),
(6, 'CEST', '6508515600', 7200, '1'),
(6, 'CET', '6526659600', 3600, '0'),
(6, 'CEST', '6539965200', 7200, '1'),
(6, 'CET', '6558109200', 3600, '0'),
(6, 'CEST', '6571414800', 7200, '1'),
(6, 'CET', '6589558800', 3600, '0'),
(6, 'CEST', '6602864400', 7200, '1'),
(6, 'CET', '6621613200', 3600, '0'),
(6, 'CEST', '6634314000', 7200, '1'),
(6, 'CET', '6653062800', 3600, '0'),
(6, 'CEST', '6665763600', 7200, '1'),
(6, 'CET', '6684512400', 3600, '0'),
(6, 'CEST', '6697818000', 7200, '1'),
(6, 'CET', '6715962000', 3600, '0'),
(6, 'CEST', '6729267600', 7200, '1'),
(6, 'CET', '6747411600', 3600, '0'),
(6, 'CEST', '6760717200', 7200, '1'),
(6, 'CET', '6779466000', 3600, '0'),
(6, 'CEST', '6792166800', 7200, '1'),
(6, 'CET', '6810915600', 3600, '0'),
(6, 'CEST', '6823616400', 7200, '1'),
(6, 'CET', '6842365200', 3600, '0'),
(6, 'CEST', '6855066000', 7200, '1'),
(6, 'CET', '6873814800', 3600, '0'),
(6, 'CEST', '6887120400', 7200, '1'),
(6, 'CET', '6905264400', 3600, '0'),
(6, 'CEST', '6918570000', 7200, '1'),
(6, 'CET', '6936714000', 3600, '0'),
(6, 'CEST', '6950019600', 7200, '1'),
(6, 'CET', '6968768400', 3600, '0'),
(6, 'CEST', '6981469200', 7200, '1'),
(6, 'CET', '7000218000', 3600, '0'),
(6, 'CEST', '7012918800', 7200, '1'),
(6, 'CET', '7031667600', 3600, '0'),
(6, 'CEST', '7044973200', 7200, '1'),
(6, 'CET', '7063117200', 3600, '0'),
(6, 'CEST', '7076422800', 7200, '1'),
(6, 'CET', '7094566800', 3600, '0'),
(6, 'CEST', '7107872400', 7200, '1'),
(6, 'CET', '7126016400', 3600, '0'),
(6, 'CEST', '7139322000', 7200, '1'),
(6, 'CET', '7158070800', 3600, '0'),
(6, 'CEST', '7170771600', 7200, '1'),
(6, 'CET', '7189520400', 3600, '0'),
(6, 'CEST', '7202221200', 7200, '1'),
(6, 'CET', '7220970000', 3600, '0'),
(6, 'CEST', '7234275600', 7200, '1'),
(6, 'CET', '7252419600', 3600, '0'),
(6, 'CEST', '7265725200', 7200, '1'),
(6, 'CET', '7283869200', 3600, '0'),
(6, 'CEST', '7297174800', 7200, '1'),
(6, 'CET', '7315318800', 3600, '0'),
(6, 'CEST', '7328624400', 7200, '1'),
(6, 'CET', '7347373200', 3600, '0'),
(6, 'CEST', '7360074000', 7200, '1'),
(6, 'CET', '7378822800', 3600, '0'),
(6, 'CEST', '7391523600', 7200, '1'),
(6, 'CET', '7410272400', 3600, '0'),
(6, 'CEST', '7423578000', 7200, '1'),
(6, 'CET', '7441722000', 3600, '0'),
(6, 'CEST', '7455027600', 7200, '1'),
(6, 'CET', '7473171600', 3600, '0'),
(6, 'CEST', '7486477200', 7200, '1'),
(6, 'CET', '7504621200', 3600, '0'),
(6, 'CEST', '7517926800', 7200, '1'),
(6, 'CET', '7536675600', 3600, '0'),
(6, 'CEST', '7549376400', 7200, '1'),
(6, 'CET', '7568125200', 3600, '0'),
(6, 'CEST', '7580826000', 7200, '1'),
(6, 'CET', '7599574800', 3600, '0'),
(6, 'CEST', '7612880400', 7200, '1'),
(6, 'CET', '7631024400', 3600, '0'),
(6, 'CEST', '7644330000', 7200, '1'),
(6, 'CET', '7662474000', 3600, '0'),
(6, 'CEST', '7675779600', 7200, '1'),
(6, 'CET', '7694528400', 3600, '0'),
(6, 'CEST', '7707229200', 7200, '1'),
(6, 'CET', '7725978000', 3600, '0'),
(6, 'CEST', '7738678800', 7200, '1'),
(6, 'CET', '7757427600', 3600, '0'),
(6, 'CEST', '7770733200', 7200, '1'),
(6, 'CET', '7788877200', 3600, '0'),
(6, 'CEST', '7802182800', 7200, '1'),
(6, 'CET', '7820326800', 3600, '0'),
(6, 'CEST', '7833632400', 7200, '1'),
(6, 'CET', '7851776400', 3600, '0'),
(6, 'CEST', '7865082000', 7200, '1'),
(6, 'CET', '7883830800', 3600, '0'),
(6, 'CEST', '7896531600', 7200, '1'),
(6, 'CET', '7915280400', 3600, '0'),
(6, 'CEST', '7927981200', 7200, '1'),
(6, 'CET', '7946730000', 3600, '0'),
(6, 'CEST', '7960035600', 7200, '1'),
(6, 'CET', '7978179600', 3600, '0'),
(6, 'CEST', '7991485200', 7200, '1'),
(6, 'CET', '8009629200', 3600, '0'),
(6, 'CEST', '8022934800', 7200, '1'),
(6, 'CET', '8041683600', 3600, '0'),
(6, 'CEST', '8054384400', 7200, '1'),
(6, 'CET', '8073133200', 3600, '0'),
(6, 'CEST', '8085834000', 7200, '1'),
(6, 'CET', '8104582800', 3600, '0'),
(6, 'CEST', '8117283600', 7200, '1'),
(6, 'CET', '8136032400', 3600, '0'),
(6, 'CEST', '8149338000', 7200, '1'),
(6, 'CET', '8167482000', 3600, '0'),
(6, 'CEST', '8180787600', 7200, '1'),
(6, 'CET', '8198931600', 3600, '0'),
(6, 'CEST', '8212237200', 7200, '1'),
(6, 'CET', '8230986000', 3600, '0'),
(6, 'CEST', '8243686800', 7200, '1'),
(6, 'CET', '8262435600', 3600, '0'),
(6, 'CEST', '8275136400', 7200, '1'),
(6, 'CET', '8293885200', 3600, '0'),
(6, 'CEST', '8307190800', 7200, '1'),
(6, 'CET', '8325334800', 3600, '0'),
(6, 'CEST', '8338640400', 7200, '1'),
(6, 'CET', '8356784400', 3600, '0'),
(6, 'CEST', '8370090000', 7200, '1'),
(6, 'CET', '8388234000', 3600, '0'),
(6, 'CEST', '8401539600', 7200, '1'),
(6, 'CET', '8420288400', 3600, '0'),
(6, 'CEST', '8432989200', 7200, '1'),
(6, 'CET', '8451738000', 3600, '0'),
(6, 'CEST', '8464438800', 7200, '1'),
(6, 'CET', '8483187600', 3600, '0'),
(6, 'CEST', '8496493200', 7200, '1'),
(6, 'CET', '8514637200', 3600, '0'),
(6, 'CEST', '8527942800', 7200, '1'),
(6, 'CET', '8546086800', 3600, '0'),
(6, 'CEST', '8559392400', 7200, '1'),
(6, 'CET', '8578141200', 3600, '0'),
(6, 'CEST', '8590842000', 7200, '1'),
(6, 'CET', '8609590800', 3600, '0'),
(6, 'CEST', '8622291600', 7200, '1'),
(6, 'CET', '8641040400', 3600, '0'),
(6, 'CEST', '8654346000', 7200, '1'),
(6, 'CET', '8672490000', 3600, '0'),
(6, 'CEST', '8685795600', 7200, '1'),
(6, 'CET', '8703939600', 3600, '0'),
(6, 'CEST', '8717245200', 7200, '1'),
(6, 'CET', '8735389200', 3600, '0'),
(6, 'CEST', '8748694800', 7200, '1'),
(6, 'CET', '8767443600', 3600, '0'),
(6, 'CEST', '8780144400', 7200, '1'),
(6, 'CET', '8798893200', 3600, '0'),
(6, 'CEST', '8811594000', 7200, '1'),
(6, 'CET', '8830342800', 3600, '0'),
(6, 'CEST', '8843648400', 7200, '1'),
(6, 'CET', '8861792400', 3600, '0'),
(6, 'CEST', '8875098000', 7200, '1'),
(6, 'CET', '8893242000', 3600, '0'),
(6, 'CEST', '8906547600', 7200, '1'),
(6, 'CET', '8925296400', 3600, '0'),
(6, 'CEST', '8937997200', 7200, '1'),
(6, 'CET', '8956746000', 3600, '0'),
(6, 'CEST', '8969446800', 7200, '1'),
(6, 'CET', '8988195600', 3600, '0'),
(6, 'CEST', '9000896400', 7200, '1'),
(6, 'CET', '9019645200', 3600, '0'),
(6, 'CEST', '9032950800', 7200, '1'),
(6, 'CET', '9051094800', 3600, '0'),
(6, 'CEST', '9064400400', 7200, '1'),
(6, 'CET', '9082544400', 3600, '0'),
(6, 'CEST', '9095850000', 7200, '1'),
(6, 'CET', '9114598800', 3600, '0'),
(6, 'CEST', '9127299600', 7200, '1'),
(6, 'CET', '9146048400', 3600, '0'),
(6, 'CEST', '9158749200', 7200, '1'),
(6, 'CET', '9177498000', 3600, '0'),
(6, 'CEST', '9190803600', 7200, '1'),
(6, 'CET', '9208947600', 3600, '0'),
(6, 'CEST', '9222253200', 7200, '1'),
(6, 'CET', '9240397200', 3600, '0'),
(6, 'CEST', '9253702800', 7200, '1'),
(6, 'CET', '9271846800', 3600, '0'),
(6, 'CEST', '9285152400', 7200, '1'),
(6, 'CET', '9303901200', 3600, '0'),
(6, 'CEST', '9316602000', 7200, '1'),
(6, 'CET', '9335350800', 3600, '0'),
(6, 'CEST', '9348051600', 7200, '1'),
(6, 'CET', '9366800400', 3600, '0'),
(6, 'CEST', '9380106000', 7200, '1'),
(6, 'CET', '9398250000', 3600, '0'),
(6, 'CEST', '9411555600', 7200, '1'),
(6, 'CET', '9429699600', 3600, '0'),
(6, 'CEST', '9443005200', 7200, '1'),
(6, 'CET', '9461754000', 3600, '0'),
(6, 'CEST', '9474454800', 7200, '1'),
(6, 'CET', '9493203600', 3600, '0'),
(6, 'CEST', '9505904400', 7200, '1'),
(6, 'CET', '9524653200', 3600, '0'),
(6, 'CEST', '9537958800', 7200, '1'),
(6, 'CET', '9556102800', 3600, '0'),
(6, 'CEST', '9569408400', 7200, '1'),
(6, 'CET', '9587552400', 3600, '0'),
(6, 'CEST', '9600858000', 7200, '1'),
(6, 'CET', '9619002000', 3600, '0'),
(6, 'CEST', '9632307600', 7200, '1'),
(6, 'CET', '9651056400', 3600, '0'),
(6, 'CEST', '9663757200', 7200, '1'),
(6, 'CET', '9682506000', 3600, '0'),
(6, 'CEST', '9695206800', 7200, '1'),
(6, 'CET', '9713955600', 3600, '0'),
(6, 'CEST', '9727261200', 7200, '1'),
(6, 'CET', '9745405200', 3600, '0'),
(6, 'CEST', '9758710800', 7200, '1'),
(6, 'CET', '9776854800', 3600, '0'),
(6, 'CEST', '9790160400', 7200, '1'),
(6, 'CET', '9808909200', 3600, '0'),
(6, 'CEST', '9821610000', 7200, '1'),
(6, 'CET', '9840358800', 3600, '0'),
(6, 'CEST', '9853059600', 7200, '1'),
(6, 'CET', '9871808400', 3600, '0'),
(6, 'CEST', '9884509200', 7200, '1'),
(6, 'CET', '9903258000', 3600, '0'),
(6, 'CEST', '9916563600', 7200, '1'),
(6, 'CET', '9934707600', 3600, '0'),
(6, 'CEST', '9948013200', 7200, '1'),
(6, 'CET', '9966157200', 3600, '0'),
(6, 'CEST', '9979462800', 7200, '1'),
(6, 'CET', '9998211600', 3600, '0'),
(6, 'CEST', '10010912400', 7200, '1'),
(6, 'CET', '10029661200', 3600, '0'),
(6, 'CEST', '10042362000', 7200, '1'),
(6, 'CET', '10061110800', 3600, '0'),
(6, 'CEST', '10074416400', 7200, '1'),
(6, 'CET', '10092560400', 3600, '0'),
(6, 'CEST', '10105866000', 7200, '1'),
(6, 'CET', '10124010000', 3600, '0'),
(6, 'CEST', '10137315600', 7200, '1'),
(6, 'CET', '10155459600', 3600, '0'),
(6, 'CEST', '10168765200', 7200, '1'),
(6, 'CET', '10187514000', 3600, '0'),
(6, 'CEST', '10200214800', 7200, '1'),
(6, 'CET', '10218963600', 3600, '0'),
(6, 'CEST', '10231664400', 7200, '1'),
(6, 'CET', '10250413200', 3600, '0'),
(6, 'CEST', '10263718800', 7200, '1'),
(6, 'CET', '10281862800', 3600, '0'),
(6, 'CEST', '10295168400', 7200, '1'),
(6, 'CET', '10313312400', 3600, '0'),
(6, 'CEST', '10326618000', 7200, '1'),
(6, 'CET', '10345366800', 3600, '0'),
(6, 'CEST', '10358067600', 7200, '1'),
(6, 'CET', '10376816400', 3600, '0'),
(6, 'CEST', '10389517200', 7200, '1'),
(6, 'CET', '10408266000', 3600, '0'),
(6, 'CEST', '10420966800', 7200, '1'),
(6, 'CET', '10439715600', 3600, '0'),
(6, 'CEST', '10453021200', 7200, '1'),
(6, 'CET', '10471165200', 3600, '0'),
(6, 'CEST', '10484470800', 7200, '1'),
(6, 'CET', '10502614800', 3600, '0'),
(6, 'CEST', '10515920400', 7200, '1'),
(6, 'CET', '10534064400', 3600, '0'),
(6, 'CEST', '10547370000', 7200, '1'),
(6, 'CET', '10566118800', 3600, '0'),
(6, 'CEST', '10578819600', 7200, '1'),
(6, 'CET', '10597568400', 3600, '0'),
(6, 'CEST', '10610269200', 7200, '1'),
(6, 'CET', '10629018000', 3600, '0'),
(6, 'CEST', '10642323600', 7200, '1'),
(6, 'CET', '10660467600', 3600, '0'),
(6, 'CEST', '10673773200', 7200, '1'),
(6, 'CET', '10691917200', 3600, '0'),
(6, 'CEST', '10705222800', 7200, '1'),
(6, 'CET', '10723971600', 3600, '0'),
(6, 'CEST', '10736672400', 7200, '1'),
(6, 'CET', '10755421200', 3600, '0'),
(6, 'CEST', '10768122000', 7200, '1'),
(6, 'CET', '10786870800', 3600, '0'),
(6, 'CEST', '10800176400', 7200, '1'),
(6, 'CET', '10818320400', 3600, '0'),
(6, 'CEST', '10831626000', 7200, '1'),
(6, 'CET', '10849770000', 3600, '0'),
(6, 'CEST', '10863075600', 7200, '1'),
(6, 'CET', '10881219600', 3600, '0'),
(6, 'CEST', '10894525200', 7200, '1'),
(6, 'CET', '10913274000', 3600, '0'),
(6, 'CEST', '10925974800', 7200, '1'),
(6, 'CET', '10944723600', 3600, '0'),
(6, 'CEST', '10957424400', 7200, '1'),
(6, 'CET', '10976173200', 3600, '0'),
(6, 'CEST', '10989478800', 7200, '1'),
(6, 'CET', '11007622800', 3600, '0'),
(6, 'CEST', '11020928400', 7200, '1'),
(6, 'CET', '11039072400', 3600, '0'),
(6, 'CEST', '11052378000', 7200, '1'),
(6, 'CET', '11071126800', 3600, '0'),
(6, 'CEST', '11083827600', 7200, '1'),
(6, 'CET', '11102576400', 3600, '0'),
(6, 'CEST', '11115277200', 7200, '1'),
(6, 'CET', '11134026000', 3600, '0'),
(6, 'CEST', '11146726800', 7200, '1'),
(6, 'CET', '11165475600', 3600, '0'),
(6, 'CEST', '11178781200', 7200, '1'),
(6, 'CET', '11196925200', 3600, '0'),
(6, 'CEST', '11210230800', 7200, '1'),
(6, 'CET', '11228374800', 3600, '0'),
(6, 'CEST', '11241680400', 7200, '1'),
(6, 'CET', '11260429200', 3600, '0'),
(6, 'CEST', '11273130000', 7200, '1'),
(6, 'CET', '11291878800', 3600, '0'),
(6, 'CEST', '11304579600', 7200, '1'),
(6, 'CET', '11323328400', 3600, '0'),
(6, 'CEST', '11336634000', 7200, '1'),
(6, 'CET', '11354778000', 3600, '0'),
(6, 'CEST', '11368083600', 7200, '1'),
(6, 'CET', '11386227600', 3600, '0'),
(6, 'CEST', '11399533200', 7200, '1'),
(6, 'CET', '11417677200', 3600, '0'),
(6, 'CEST', '11430982800', 7200, '1'),
(6, 'CET', '11449731600', 3600, '0'),
(6, 'CEST', '11462432400', 7200, '1'),
(6, 'CET', '11481181200', 3600, '0'),
(6, 'CEST', '11493882000', 7200, '1'),
(6, 'CET', '11512630800', 3600, '0'),
(6, 'CEST', '11525936400', 7200, '1'),
(6, 'CET', '11544080400', 3600, '0'),
(6, 'CEST', '11557386000', 7200, '1'),
(6, 'CET', '11575530000', 3600, '0'),
(6, 'CEST', '11588835600', 7200, '1'),
(6, 'CET', '11607584400', 3600, '0'),
(6, 'CEST', '11620285200', 7200, '1'),
(6, 'CET', '11639034000', 3600, '0'),
(6, 'CEST', '11651734800', 7200, '1'),
(6, 'CET', '11670483600', 3600, '0'),
(6, 'CEST', '11683789200', 7200, '1'),
(6, 'CET', '11701933200', 3600, '0'),
(6, 'CEST', '11715238800', 7200, '1'),
(6, 'CET', '11733382800', 3600, '0'),
(6, 'CEST', '11746688400', 7200, '1'),
(6, 'CET', '11764832400', 3600, '0'),
(6, 'CEST', '11778138000', 7200, '1'),
(6, 'CET', '11796886800', 3600, '0'),
(6, 'CEST', '11809587600', 7200, '1'),
(6, 'CET', '11828336400', 3600, '0'),
(6, 'CEST', '11841037200', 7200, '1'),
(6, 'CET', '11859786000', 3600, '0'),
(6, 'CEST', '11873091600', 7200, '1'),
(6, 'CET', '11891235600', 3600, '0'),
(6, 'CEST', '11904541200', 7200, '1'),
(6, 'CET', '11922685200', 3600, '0'),
(6, 'CEST', '11935990800', 7200, '1'),
(6, 'CET', '11954739600', 3600, '0'),
(6, 'CEST', '11967440400', 7200, '1'),
(6, 'CET', '11986189200', 3600, '0'),
(6, 'CEST', '11998890000', 7200, '1'),
(6, 'CET', '12017638800', 3600, '0'),
(6, 'CEST', '12030339600', 7200, '1'),
(6, 'CET', '12049088400', 3600, '0'),
(6, 'CEST', '12062394000', 7200, '1'),
(6, 'CET', '12080538000', 3600, '0'),
(6, 'CEST', '12093843600', 7200, '1'),
(6, 'CET', '12111987600', 3600, '0'),
(6, 'CEST', '12125293200', 7200, '1'),
(6, 'CET', '12144042000', 3600, '0'),
(6, 'CEST', '12156742800', 7200, '1'),
(6, 'CET', '12175491600', 3600, '0'),
(6, 'CEST', '12188192400', 7200, '1'),
(6, 'CET', '12206941200', 3600, '0'),
(6, 'CEST', '12220246800', 7200, '1'),
(6, 'CET', '12238390800', 3600, '0'),
(6, 'CEST', '12251696400', 7200, '1'),
(6, 'CET', '12269840400', 3600, '0'),
(6, 'CEST', '12283146000', 7200, '1'),
(6, 'CET', '12301290000', 3600, '0'),
(6, 'CEST', '12314595600', 7200, '1'),
(6, 'CET', '12333344400', 3600, '0'),
(6, 'CEST', '12346045200', 7200, '1'),
(6, 'CET', '12364794000', 3600, '0'),
(6, 'CEST', '12377494800', 7200, '1'),
(6, 'CET', '12396243600', 3600, '0'),
(6, 'CEST', '12409549200', 7200, '1'),
(6, 'CET', '12427693200', 3600, '0'),
(6, 'CEST', '12440998800', 7200, '1'),
(6, 'CET', '12459142800', 3600, '0'),
(6, 'CEST', '12472448400', 7200, '1'),
(6, 'CET', '12491197200', 3600, '0'),
(6, 'CEST', '12503898000', 7200, '1'),
(6, 'CET', '12522646800', 3600, '0'),
(6, 'CEST', '12535347600', 7200, '1'),
(6, 'CET', '12554096400', 3600, '0'),
(6, 'CEST', '12567402000', 7200, '1'),
(6, 'CET', '12585546000', 3600, '0'),
(6, 'CEST', '12598851600', 7200, '1'),
(6, 'CET', '12616995600', 3600, '0'),
(6, 'CEST', '12630301200', 7200, '1'),
(6, 'CET', '12648445200', 3600, '0'),
(6, 'CEST', '12661750800', 7200, '1'),
(6, 'CET', '12680499600', 3600, '0'),
(6, 'CEST', '12693200400', 7200, '1'),
(6, 'CET', '12711949200', 3600, '0'),
(6, 'CEST', '12724650000', 7200, '1'),
(6, 'CET', '12743398800', 3600, '0'),
(6, 'CEST', '12756704400', 7200, '1'),
(6, 'CET', '12774848400', 3600, '0'),
(6, 'CEST', '12788154000', 7200, '1'),
(6, 'CET', '12806298000', 3600, '0'),
(6, 'CEST', '12819603600', 7200, '1'),
(6, 'CET', '12838352400', 3600, '0'),
(6, 'CEST', '12851053200', 7200, '1'),
(6, 'CET', '12869802000', 3600, '0'),
(6, 'CEST', '12882502800', 7200, '1'),
(6, 'CET', '12901251600', 3600, '0'),
(6, 'CEST', '12913952400', 7200, '1'),
(6, 'CET', '12932701200', 3600, '0'),
(6, 'CEST', '12946006800', 7200, '1'),
(6, 'CET', '12964150800', 3600, '0'),
(6, 'CEST', '12977456400', 7200, '1'),
(6, 'CET', '12995600400', 3600, '0'),
(6, 'CEST', '13008906000', 7200, '1'),
(6, 'CET', '13027654800', 3600, '0'),
(6, 'CEST', '13040355600', 7200, '1'),
(6, 'CET', '13059104400', 3600, '0'),
(6, 'CEST', '13071805200', 7200, '1'),
(6, 'CET', '13090554000', 3600, '0'),
(6, 'CEST', '13103859600', 7200, '1'),
(6, 'CET', '13122003600', 3600, '0'),
(6, 'CEST', '13135309200', 7200, '1'),
(6, 'CET', '13153453200', 3600, '0'),
(6, 'CEST', '13166758800', 7200, '1'),
(6, 'CET', '13184902800', 3600, '0'),
(6, 'CEST', '13198208400', 7200, '1'),
(6, 'CET', '13216957200', 3600, '0'),
(6, 'CEST', '13229658000', 7200, '1'),
(6, 'CET', '13248406800', 3600, '0'),
(6, 'CEST', '13261107600', 7200, '1'),
(6, 'CET', '13279856400', 3600, '0'),
(6, 'CEST', '13293162000', 7200, '1'),
(6, 'CET', '13311306000', 3600, '0'),
(6, 'CEST', '13324611600', 7200, '1'),
(6, 'CET', '13342755600', 3600, '0'),
(6, 'CEST', '13356061200', 7200, '1'),
(6, 'CET', '13374810000', 3600, '0'),
(6, 'CEST', '13387510800', 7200, '1'),
(6, 'CET', '13406259600', 3600, '0'),
(6, 'CEST', '13418960400', 7200, '1'),
(6, 'CET', '13437709200', 3600, '0'),
(6, 'CEST', '13451014800', 7200, '1'),
(6, 'CET', '13469158800', 3600, '0'),
(6, 'CEST', '13482464400', 7200, '1'),
(6, 'CET', '13500608400', 3600, '0'),
(6, 'CEST', '13513914000', 7200, '1'),
(6, 'CET', '13532058000', 3600, '0'),
(6, 'CEST', '13545363600', 7200, '1'),
(6, 'CET', '13564112400', 3600, '0'),
(6, 'CEST', '13576813200', 7200, '1'),
(6, 'CET', '13595562000', 3600, '0'),
(6, 'CEST', '13608262800', 7200, '1'),
(6, 'CET', '13627011600', 3600, '0'),
(6, 'CEST', '13640317200', 7200, '1'),
(6, 'CET', '13658461200', 3600, '0'),
(6, 'CEST', '13671766800', 7200, '1'),
(6, 'CET', '13689910800', 3600, '0'),
(6, 'CEST', '13703216400', 7200, '1'),
(6, 'CET', '13721965200', 3600, '0'),
(6, 'CEST', '13734666000', 7200, '1'),
(6, 'CET', '13753414800', 3600, '0'),
(6, 'CEST', '13766115600', 7200, '1'),
(6, 'CET', '13784864400', 3600, '0'),
(6, 'CEST', '13797565200', 7200, '1'),
(6, 'CET', '13816314000', 3600, '0'),
(6, 'CEST', '13829619600', 7200, '1'),
(6, 'CET', '13847763600', 3600, '0'),
(6, 'CEST', '13861069200', 7200, '1'),
(6, 'CET', '13879213200', 3600, '0'),
(6, 'CEST', '13892518800', 7200, '1'),
(6, 'CET', '13911267600', 3600, '0'),
(6, 'CEST', '13923968400', 7200, '1'),
(6, 'CET', '13942717200', 3600, '0'),
(6, 'CEST', '13955418000', 7200, '1'),
(6, 'CET', '13974166800', 3600, '0'),
(6, 'CEST', '13987472400', 7200, '1'),
(6, 'CET', '14005616400', 3600, '0'),
(6, 'CEST', '14018922000', 7200, '1'),
(6, 'CET', '14037066000', 3600, '0'),
(6, 'CEST', '14050371600', 7200, '1'),
(6, 'CET', '14068515600', 3600, '0'),
(6, 'CEST', '14081821200', 7200, '1'),
(6, 'CET', '14100570000', 3600, '0'),
(6, 'CEST', '14113270800', 7200, '1'),
(6, 'CET', '14132019600', 3600, '0'),
(6, 'CEST', '14144720400', 7200, '1'),
(6, 'CET', '14163469200', 3600, '0'),
(6, 'CEST', '14176774800', 7200, '1'),
(6, 'CET', '14194918800', 3600, '0'),
(6, 'CEST', '14208224400', 7200, '1'),
(6, 'CET', '14226368400', 3600, '0'),
(6, 'CEST', '14239674000', 7200, '1'),
(6, 'CET', '14258422800', 3600, '0'),
(6, 'CEST', '14271123600', 7200, '1'),
(6, 'CET', '14289872400', 3600, '0'),
(6, 'CEST', '14302573200', 7200, '1'),
(6, 'CET', '14321322000', 3600, '0'),
(6, 'CEST', '14334627600', 7200, '1'),
(6, 'CET', '14352771600', 3600, '0'),
(6, 'CEST', '14366077200', 7200, '1'),
(6, 'CET', '14384221200', 3600, '0'),
(6, 'CEST', '14397526800', 7200, '1'),
(6, 'CET', '14415670800', 3600, '0'),
(6, 'CEST', '14428976400', 7200, '1'),
(6, 'CET', '14447725200', 3600, '0'),
(6, 'CEST', '14460426000', 7200, '1'),
(6, 'CET', '14479174800', 3600, '0'),
(6, 'CEST', '14491875600', 7200, '1'),
(6, 'CET', '14510624400', 3600, '0'),
(6, 'CEST', '14523930000', 7200, '1'),
(6, 'CET', '14542074000', 3600, '0'),
(6, 'CEST', '14555379600', 7200, '1'),
(6, 'CET', '14573523600', 3600, '0'),
(6, 'CEST', '14586829200', 7200, '1'),
(6, 'CET', '14605578000', 3600, '0'),
(6, 'CEST', '14618278800', 7200, '1'),
(6, 'CET', '14637027600', 3600, '0'),
(6, 'CEST', '14649728400', 7200, '1'),
(6, 'CET', '14668477200', 3600, '0'),
(6, 'CEST', '14681178000', 7200, '1'),
(6, 'CET', '14699926800', 3600, '0'),
(6, 'CEST', '14713232400', 7200, '1'),
(6, 'CET', '14731376400', 3600, '0'),
(6, 'CEST', '14744682000', 7200, '1'),
(6, 'CET', '14762826000', 3600, '0'),
(6, 'CEST', '14776131600', 7200, '1'),
(6, 'CET', '14794880400', 3600, '0'),
(6, 'CEST', '14807581200', 7200, '1'),
(6, 'CET', '14826330000', 3600, '0'),
(6, 'CEST', '14839030800', 7200, '1'),
(6, 'CET', '14857779600', 3600, '0'),
(6, 'CEST', '14871085200', 7200, '1'),
(6, 'CET', '14889229200', 3600, '0'),
(6, 'CEST', '14902534800', 7200, '1'),
(6, 'CET', '14920678800', 3600, '0'),
(6, 'CEST', '14933984400', 7200, '1'),
(6, 'CET', '14952128400', 3600, '0'),
(6, 'CEST', '14965434000', 7200, '1'),
(6, 'CET', '14984182800', 3600, '0'),
(6, 'CEST', '14996883600', 7200, '1'),
(6, 'CET', '15015632400', 3600, '0'),
(6, 'CEST', '15028333200', 7200, '1'),
(6, 'CET', '15047082000', 3600, '0'),
(6, 'CEST', '15060387600', 7200, '1'),
(6, 'CET', '15078531600', 3600, '0'),
(6, 'CEST', '15091837200', 7200, '1'),
(6, 'CET', '15109981200', 3600, '0'),
(6, 'CEST', '15123286800', 7200, '1'),
(6, 'CET', '15142035600', 3600, '0'),
(6, 'CEST', '15154736400', 7200, '1'),
(6, 'CET', '15173485200', 3600, '0'),
(6, 'CEST', '15186186000', 7200, '1'),
(6, 'CET', '15204934800', 3600, '0'),
(6, 'CEST', '15218240400', 7200, '1'),
(6, 'CET', '15236384400', 3600, '0'),
(6, 'CEST', '15249690000', 7200, '1'),
(6, 'CET', '15267834000', 3600, '0'),
(6, 'CEST', '15281139600', 7200, '1'),
(6, 'CET', '15299283600', 3600, '0'),
(6, 'CEST', '15312589200', 7200, '1'),
(6, 'CET', '15331338000', 3600, '0'),
(6, 'CEST', '15344038800', 7200, '1'),
(6, 'CET', '15362787600', 3600, '0'),
(6, 'CEST', '15375488400', 7200, '1'),
(6, 'CET', '15394237200', 3600, '0'),
(6, 'CEST', '15407542800', 7200, '1'),
(6, 'CET', '15425686800', 3600, '0'),
(6, 'CEST', '15438992400', 7200, '1'),
(6, 'CET', '15457136400', 3600, '0'),
(6, 'CEST', '15470442000', 7200, '1'),
(6, 'CET', '15489190800', 3600, '0'),
(6, 'CEST', '15501891600', 7200, '1'),
(6, 'CET', '15520640400', 3600, '0'),
(6, 'CEST', '15533341200', 7200, '1'),
(6, 'CET', '15552090000', 3600, '0'),
(6, 'CEST', '15564790800', 7200, '1'),
(6, 'CET', '15583539600', 3600, '0'),
(6, 'CEST', '15596845200', 7200, '1'),
(6, 'CET', '15614989200', 3600, '0'),
(6, 'CEST', '15628294800', 7200, '1'),
(6, 'CET', '15646438800', 3600, '0'),
(6, 'CEST', '15659744400', 7200, '1'),
(6, 'CET', '15678493200', 3600, '0'),
(6, 'CEST', '15691194000', 7200, '1'),
(6, 'CET', '15709942800', 3600, '0'),
(6, 'CEST', '15722643600', 7200, '1'),
(6, 'CET', '15741392400', 3600, '0'),
(6, 'CEST', '15754698000', 7200, '1'),
(6, 'CET', '15772842000', 3600, '0'),
(6, 'CEST', '15786147600', 7200, '1'),
(6, 'CET', '15804291600', 3600, '0'),
(6, 'CEST', '15817597200', 7200, '1'),
(6, 'CET', '15835741200', 3600, '0'),
(6, 'CEST', '15849046800', 7200, '1'),
(6, 'CET', '15867795600', 3600, '0'),
(6, 'CEST', '15880496400', 7200, '1'),
(6, 'CET', '15899245200', 3600, '0'),
(6, 'CEST', '15911946000', 7200, '1'),
(6, 'CET', '15930694800', 3600, '0'),
(6, 'CEST', '15944000400', 7200, '1'),
(6, 'CET', '15962144400', 3600, '0'),
(6, 'CEST', '15975450000', 7200, '1'),
(6, 'CET', '15993594000', 3600, '0'),
(6, 'CEST', '16006899600', 7200, '1'),
(6, 'CET', '16025648400', 3600, '0'),
(6, 'CEST', '16038349200', 7200, '1'),
(6, 'CET', '16057098000', 3600, '0'),
(6, 'CEST', '16069798800', 7200, '1'),
(6, 'CET', '16088547600', 3600, '0'),
(6, 'CEST', '16101853200', 7200, '1'),
(6, 'CET', '16119997200', 3600, '0'),
(6, 'CEST', '16133302800', 7200, '1'),
(6, 'CET', '16151446800', 3600, '0'),
(6, 'CEST', '16164752400', 7200, '1'),
(6, 'CET', '16182896400', 3600, '0'),
(6, 'CEST', '16196202000', 7200, '1'),
(6, 'CET', '16214950800', 3600, '0'),
(6, 'CEST', '16227651600', 7200, '1'),
(6, 'CET', '16246400400', 3600, '0'),
(6, 'CEST', '16259101200', 7200, '1'),
(6, 'CET', '16277850000', 3600, '0'),
(6, 'CEST', '16291155600', 7200, '1'),
(6, 'CET', '16309299600', 3600, '0'),
(6, 'CEST', '16322605200', 7200, '1'),
(6, 'CET', '16340749200', 3600, '0'),
(6, 'CEST', '16354054800', 7200, '1'),
(6, 'CET', '16372803600', 3600, '0'),
(6, 'CEST', '16385504400', 7200, '1'),
(6, 'CET', '16404253200', 3600, '0'),
(6, 'CEST', '16416954000', 7200, '1'),
(6, 'CET', '16435702800', 3600, '0'),
(6, 'CEST', '16448403600', 7200, '1'),
(6, 'CET', '16467152400', 3600, '0'),
(6, 'CEST', '16480458000', 7200, '1'),
(6, 'CET', '16498602000', 3600, '0'),
(6, 'CEST', '16511907600', 7200, '1'),
(6, 'CET', '16530051600', 3600, '0'),
(6, 'CEST', '16543357200', 7200, '1'),
(6, 'CET', '16562106000', 3600, '0'),
(6, 'CEST', '16574806800', 7200, '1'),
(6, 'CET', '16593555600', 3600, '0'),
(6, 'CEST', '16606256400', 7200, '1'),
(6, 'CET', '16625005200', 3600, '0'),
(6, 'CEST', '16638310800', 7200, '1'),
(6, 'CET', '16656454800', 3600, '0'),
(6, 'CEST', '16669760400', 7200, '1'),
(6, 'CET', '16687904400', 3600, '0'),
(6, 'CEST', '16701210000', 7200, '1'),
(6, 'CET', '16719354000', 3600, '0'),
(7, 'LMT', '-1441162681', 10680, '0'),
(7, '+03', '-1441162680', 10800, '0'),
(7, '+04', '-405140400', 14400, '0'),
(7, '+05', '354916800', 18000, '1'),
(7, '+04', '370724400', 14400, '0'),
(7, '+05', '386452800', 18000, '1'),
(7, '+04', '402260400', 14400, '0'),
(7, '+05', '417988800', 18000, '1'),
(7, '+04', '433796400', 14400, '0'),
(7, '+05', '449611200', 18000, '1'),
(7, '+04', '465343200', 14400, '0'),
(7, '+05', '481068000', 18000, '1'),
(7, '+04', '496792800', 14400, '0'),
(7, '+05', '512517600', 18000, '1'),
(7, '+04', '528242400', 14400, '0'),
(7, '+05', '543967200', 18000, '1'),
(7, '+04', '559692000', 14400, '0'),
(7, '+05', '575416800', 18000, '1'),
(7, '+04', '591141600', 14400, '0'),
(7, '+05', '606866400', 18000, '1'),
(7, '+04', '622591200', 14400, '0'),
(7, '+05', '638316000', 18000, '1'),
(7, '+04', '654645600', 14400, '0'),
(7, '+03', '686098800', 10800, '0'),
(7, '+04', '701823600', 14400, '1'),
(7, '+03', '717548400', 10800, '0'),
(7, '+04', '733273200', 14400, '1'),
(7, '+03', '748998000', 10800, '0'),
(7, '+04', '764722800', 14400, '1'),
(7, '+03', '780447600', 10800, '0'),
(7, '+04', '796172400', 14400, '1'),
(7, '+05', '859672800', 18000, '1'),
(7, '+04', '877816800', 14400, '0'),
(7, '+05', '891122400', 18000, '1'),
(7, '+04', '909266400', 14400, '0'),
(7, '+05', '922572000', 18000, '1'),
(7, '+04', '941320800', 14400, '0'),
(7, '+05', '954021600', 18000, '1'),
(7, '+04', '972770400', 14400, '0'),
(7, '+05', '985471200', 18000, '1'),
(7, '+04', '1004220000', 14400, '0'),
(7, '+05', '1017525600', 18000, '1'),
(7, '+04', '1035669600', 14400, '0'),
(7, '+05', '1048975200', 18000, '1'),
(7, '+04', '1067119200', 14400, '0'),
(7, '+05', '1080424800', 18000, '1'),
(7, '+04', '1099173600', 14400, '0'),
(7, '+05', '1111874400', 18000, '1'),
(7, '+04', '1130623200', 14400, '0'),
(7, '+05', '1143324000', 18000, '1'),
(7, '+04', '1162072800', 14400, '0'),
(7, '+05', '1174773600', 18000, '1'),
(7, '+04', '1193522400', 14400, '0'),
(7, '+05', '1206828000', 18000, '1'),
(7, '+04', '1224972000', 14400, '0'),
(7, '+05', '1238277600', 18000, '1'),
(7, '+04', '1256421600', 14400, '0'),
(7, '+05', '1269727200', 18000, '1'),
(7, '+04', '1288476000', 14400, '0'),
(7, '+05', '1301176800', 18000, '1'),
(7, '+04', '1319925600', 14400, '0'),
(8, 'LMT', '-1588464817', 816, '0'),
(8, 'WAT', '-1588464816', 3600, '0'),
(9, 'LMT', '-3192435545', 41944, '0'),
(9, 'NZMT', '-3192435544', 41400, '0'),
(9, 'NZST', '-1330335000', 45000, '1'),
(9, 'NZMT', '-1320057000', 41400, '0'),
(9, 'NZST', '-1300699800', 43200, '1'),
(9, 'NZMT', '-1287396000', 41400, '0'),
(9, 'NZST', '-1269250200', 43200, '1'),
(9, 'NZMT', '-1255946400', 41400, '0'),
(9, 'NZST', '-1237800600', 43200, '1'),
(9, 'NZMT', '-1224496800', 41400, '0'),
(9, 'NZST', '-1206351000', 43200, '1'),
(9, 'NZMT', '-1192442400', 41400, '0'),
(9, 'NZST', '-1174901400', 43200, '1'),
(9, 'NZMT', '-1160992800', 41400, '0'),
(9, 'NZST', '-1143451800', 43200, '1'),
(9, 'NZMT', '-1125914400', 41400, '0'),
(9, 'NZST', '-1112607000', 43200, '1'),
(9, 'NZMT', '-1094464800', 41400, '0'),
(9, 'NZST', '-1081157400', 43200, '1'),
(9, 'NZMT', '-1063015200', 41400, '0'),
(9, 'NZST', '-1049707800', 43200, '1'),
(9, 'NZMT', '-1031565600', 41400, '0'),
(9, 'NZST', '-1018258200', 43200, '1'),
(9, 'NZMT', '-1000116000', 41400, '0'),
(9, 'NZST', '-986808600', 43200, '1'),
(9, 'NZMT', '-968061600', 41400, '0'),
(9, 'NZST', '-955359000', 43200, '1'),
(9, 'NZMT', '-936612000', 41400, '0'),
(9, 'NZST', '-923304600', 43200, '1'),
(9, 'NZDT', '152632800', 46800, '1'),
(9, 'NZST', '162309600', 43200, '0'),
(9, 'NZDT', '183477600', 46800, '1'),
(9, 'NZST', '194968800', 43200, '0'),
(9, 'NZDT', '215532000', 46800, '1'),
(9, 'NZST', '226418400', 43200, '0'),
(9, 'NZDT', '246981600', 46800, '1'),
(9, 'NZST', '257868000', 43200, '0'),
(9, 'NZDT', '278431200', 46800, '1'),
(9, 'NZST', '289317600', 43200, '0'),
(9, 'NZDT', '309880800', 46800, '1'),
(9, 'NZST', '320767200', 43200, '0'),
(9, 'NZDT', '341330400', 46800, '1'),
(9, 'NZST', '352216800', 43200, '0'),
(9, 'NZDT', '372780000', 46800, '1'),
(9, 'NZST', '384271200', 43200, '0'),
(9, 'NZDT', '404834400', 46800, '1'),
(9, 'NZST', '415720800', 43200, '0'),
(9, 'NZDT', '436284000', 46800, '1'),
(9, 'NZST', '447170400', 43200, '0'),
(9, 'NZDT', '467733600', 46800, '1'),
(9, 'NZST', '478620000', 43200, '0'),
(9, 'NZDT', '499183200', 46800, '1'),
(9, 'NZST', '510069600', 43200, '0'),
(9, 'NZDT', '530632800', 46800, '1'),
(9, 'NZST', '541519200', 43200, '0'),
(9, 'NZDT', '562082400', 46800, '1'),
(9, 'NZST', '573573600', 43200, '0'),
(9, 'NZDT', '594136800', 46800, '1'),
(9, 'NZST', '605023200', 43200, '0'),
(9, 'NZDT', '623772000', 46800, '1'),
(9, 'NZST', '637682400', 43200, '0'),
(9, 'NZDT', '655221600', 46800, '1'),
(9, 'NZST', '669132000', 43200, '0'),
(9, 'NZDT', '686671200', 46800, '1'),
(9, 'NZST', '700581600', 43200, '0'),
(9, 'NZDT', '718120800', 46800, '1'),
(9, 'NZST', '732636000', 43200, '0'),
(9, 'NZDT', '749570400', 46800, '1'),
(9, 'NZST', '764085600', 43200, '0'),
(9, 'NZDT', '781020000', 46800, '1'),
(9, 'NZST', '795535200', 43200, '0'),
(9, 'NZDT', '812469600', 46800, '1'),
(9, 'NZST', '826984800', 43200, '0'),
(9, 'NZDT', '844524000', 46800, '1'),
(9, 'NZST', '858434400', 43200, '0'),
(9, 'NZDT', '875973600', 46800, '1'),
(9, 'NZST', '889884000', 43200, '0'),
(9, 'NZDT', '907423200', 46800, '1'),
(9, 'NZST', '921938400', 43200, '0'),
(9, 'NZDT', '938872800', 46800, '1'),
(9, 'NZST', '953388000', 43200, '0'),
(9, 'NZDT', '970322400', 46800, '1'),
(9, 'NZST', '984837600', 43200, '0'),
(9, 'NZDT', '1002376800', 46800, '1'),
(9, 'NZST', '1016287200', 43200, '0'),
(9, 'NZDT', '1033826400', 46800, '1'),
(9, 'NZST', '1047736800', 43200, '0'),
(9, 'NZDT', '1065276000', 46800, '1'),
(9, 'NZST', '1079791200', 43200, '0'),
(9, 'NZDT', '1096725600', 46800, '1'),
(9, 'NZST', '1111240800', 43200, '0'),
(9, 'NZDT', '1128175200', 46800, '1'),
(9, 'NZST', '1142690400', 43200, '0'),
(9, 'NZDT', '1159624800', 46800, '1'),
(9, 'NZST', '1174140000', 43200, '0'),
(9, 'NZDT', '1191074400', 46800, '1'),
(9, 'NZST', '1207404000', 43200, '0'),
(9, 'NZDT', '1222524000', 46800, '1'),
(9, 'NZST', '1238853600', 43200, '0'),
(9, 'NZDT', '1253973600', 46800, '1'),
(9, 'NZST', '1270303200', 43200, '0'),
(9, 'NZDT', '1285423200', 46800, '1'),
(9, 'NZST', '1301752800', 43200, '0'),
(9, 'NZDT', '1316872800', 46800, '1'),
(9, 'NZST', '1333202400', 43200, '0'),
(9, 'NZDT', '1348927200', 46800, '1'),
(9, 'NZST', '1365256800', 43200, '0'),
(9, 'NZDT', '1380376800', 46800, '1'),
(9, 'NZST', '1396706400', 43200, '0'),
(9, 'NZDT', '1411826400', 46800, '1'),
(9, 'NZST', '1428156000', 43200, '0'),
(9, 'NZDT', '1443276000', 46800, '1'),
(9, 'NZST', '1459605600', 43200, '0'),
(9, 'NZDT', '1474725600', 46800, '1'),
(9, 'NZST', '1491055200', 43200, '0'),
(9, 'NZDT', '1506175200', 46800, '1'),
(9, 'NZST', '1522504800', 43200, '0'),
(9, 'NZDT', '1538229600', 46800, '1'),
(9, 'NZST', '1554559200', 43200, '0'),
(9, 'NZDT', '1569679200', 46800, '1'),
(9, 'NZST', '1586008800', 43200, '0'),
(9, 'NZDT', '1601128800', 46800, '1'),
(9, 'NZST', '1617458400', 43200, '0'),
(9, 'NZDT', '1632578400', 46800, '1'),
(9, 'NZST', '1648908000', 43200, '0'),
(9, 'NZDT', '1664028000', 46800, '1'),
(9, 'NZST', '1680357600', 43200, '0'),
(9, 'NZDT', '1695477600', 46800, '1'),
(9, 'NZST', '1712412000', 43200, '0'),
(9, 'NZDT', '1727532000', 46800, '1'),
(9, 'NZST', '1743861600', 43200, '0'),
(9, 'NZDT', '1758981600', 46800, '1'),
(9, 'NZST', '1775311200', 43200, '0'),
(9, 'NZDT', '1790431200', 46800, '1'),
(9, 'NZST', '1806760800', 43200, '0'),
(9, 'NZDT', '1821880800', 46800, '1'),
(9, 'NZST', '1838210400', 43200, '0'),
(9, 'NZDT', '1853330400', 46800, '1'),
(9, 'NZST', '1869660000', 43200, '0'),
(9, 'NZDT', '1885384800', 46800, '1'),
(9, 'NZST', '1901714400', 43200, '0'),
(9, 'NZDT', '1916834400', 46800, '1'),
(9, 'NZST', '1933164000', 43200, '0'),
(9, 'NZDT', '1948284000', 46800, '1'),
(9, 'NZST', '1964613600', 43200, '0'),
(9, 'NZDT', '1979733600', 46800, '1'),
(9, 'NZST', '1996063200', 43200, '0'),
(9, 'NZDT', '2011183200', 46800, '1'),
(9, 'NZST', '2027512800', 43200, '0'),
(9, 'NZDT', '2042632800', 46800, '1'),
(9, 'NZST', '2058962400', 43200, '0'),
(9, 'NZDT', '2074687200', 46800, '1'),
(9, 'NZST', '2091016800', 43200, '0'),
(9, 'NZDT', '2106136800', 46800, '1'),
(9, 'NZST', '2122466400', 43200, '0'),
(9, 'NZDT', '2137586400', 46800, '1'),
(9, 'NZST', '2153916000', 43200, '0'),
(9, 'NZDT', '2169036000', 46800, '1'),
(9, 'NZST', '2185365600', 43200, '0'),
(9, 'NZDT', '2200485600', 46800, '1'),
(9, 'NZST', '2216815200', 43200, '0'),
(9, 'NZDT', '2232540000', 46800, '1'),
(9, 'NZST', '2248869600', 43200, '0'),
(9, 'NZDT', '2263989600', 46800, '1'),
(9, 'NZST', '2280319200', 43200, '0'),
(9, 'NZDT', '2295439200', 46800, '1'),
(9, 'NZST', '2311768800', 43200, '0'),
(9, 'NZDT', '2326888800', 46800, '1'),
(9, 'NZST', '2343218400', 43200, '0'),
(9, 'NZDT', '2358338400', 46800, '1'),
(9, 'NZST', '2374668000', 43200, '0'),
(9, 'NZDT', '2389788000', 46800, '1'),
(9, 'NZST', '2406117600', 43200, '0'),
(9, 'NZDT', '2421842400', 46800, '1'),
(9, 'NZST', '2438172000', 43200, '0'),
(9, 'NZDT', '2453292000', 46800, '1'),
(9, 'NZST', '2469621600', 43200, '0'),
(9, 'NZDT', '2484741600', 46800, '1'),
(9, 'NZST', '2501071200', 43200, '0'),
(9, 'NZDT', '2516191200', 46800, '1'),
(9, 'NZST', '2532520800', 43200, '0'),
(9, 'NZDT', '2547640800', 46800, '1'),
(9, 'NZST', '2563970400', 43200, '0'),
(9, 'NZDT', '2579090400', 46800, '1'),
(9, 'NZST', '2596024800', 43200, '0'),
(9, 'NZDT', '2611144800', 46800, '1'),
(9, 'NZST', '2627474400', 43200, '0'),
(9, 'NZDT', '2642594400', 46800, '1'),
(9, 'NZST', '2658924000', 43200, '0'),
(9, 'NZDT', '2674044000', 46800, '1'),
(9, 'NZST', '2690373600', 43200, '0'),
(9, 'NZDT', '2705493600', 46800, '1'),
(9, 'NZST', '2721823200', 43200, '0'),
(9, 'NZDT', '2736943200', 46800, '1'),
(9, 'NZST', '2753272800', 43200, '0'),
(9, 'NZDT', '2768997600', 46800, '1'),
(9, 'NZST', '2785327200', 43200, '0'),
(9, 'NZDT', '2800447200', 46800, '1'),
(9, 'NZST', '2816776800', 43200, '0'),
(9, 'NZDT', '2831896800', 46800, '1'),
(9, 'NZST', '2848226400', 43200, '0'),
(9, 'NZDT', '2863346400', 46800, '1'),
(9, 'NZST', '2879676000', 43200, '0'),
(9, 'NZDT', '2894796000', 46800, '1'),
(9, 'NZST', '2911125600', 43200, '0'),
(9, 'NZDT', '2926245600', 46800, '1'),
(9, 'NZST', '2942575200', 43200, '0'),
(9, 'NZDT', '2958300000', 46800, '1'),
(9, 'NZST', '2974629600', 43200, '0'),
(9, 'NZDT', '2989749600', 46800, '1'),
(9, 'NZST', '3006079200', 43200, '0'),
(9, 'NZDT', '3021199200', 46800, '1'),
(9, 'NZST', '3037528800', 43200, '0'),
(9, 'NZDT', '3052648800', 46800, '1'),
(9, 'NZST', '3068978400', 43200, '0'),
(9, 'NZDT', '3084098400', 46800, '1'),
(9, 'NZST', '3100428000', 43200, '0'),
(9, 'NZDT', '3116152800', 46800, '1'),
(9, 'NZST', '3132482400', 43200, '0'),
(9, 'NZDT', '3147602400', 46800, '1'),
(9, 'NZST', '3163932000', 43200, '0'),
(9, 'NZDT', '3179052000', 46800, '1'),
(9, 'NZST', '3195381600', 43200, '0'),
(9, 'NZDT', '3210501600', 46800, '1'),
(9, 'NZST', '3226831200', 43200, '0'),
(9, 'NZDT', '3241951200', 46800, '1'),
(9, 'NZST', '3258280800', 43200, '0'),
(9, 'NZDT', '3273400800', 46800, '1'),
(9, 'NZST', '3289730400', 43200, '0'),
(9, 'NZDT', '3305455200', 46800, '1'),
(9, 'NZST', '3321784800', 43200, '0'),
(9, 'NZDT', '3336904800', 46800, '1'),
(9, 'NZST', '3353234400', 43200, '0'),
(9, 'NZDT', '3368354400', 46800, '1'),
(9, 'NZST', '3384684000', 43200, '0'),
(9, 'NZDT', '3399804000', 46800, '1'),
(9, 'NZST', '3416133600', 43200, '0'),
(9, 'NZDT', '3431253600', 46800, '1'),
(9, 'NZST', '3447583200', 43200, '0'),
(9, 'NZDT', '3462703200', 46800, '1'),
(9, 'NZST', '3479637600', 43200, '0'),
(9, 'NZDT', '3494757600', 46800, '1'),
(9, 'NZST', '3511087200', 43200, '0'),
(9, 'NZDT', '3526207200', 46800, '1'),
(9, 'NZST', '3542536800', 43200, '0'),
(9, 'NZDT', '3557656800', 46800, '1'),
(9, 'NZST', '3573986400', 43200, '0'),
(9, 'NZDT', '3589106400', 46800, '1'),
(9, 'NZST', '3605436000', 43200, '0'),
(9, 'NZDT', '3620556000', 46800, '1'),
(9, 'NZST', '3636885600', 43200, '0'),
(9, 'NZDT', '3652610400', 46800, '1'),
(9, 'NZST', '3668940000', 43200, '0'),
(9, 'NZDT', '3684060000', 46800, '1'),
(9, 'NZST', '3700389600', 43200, '0'),
(9, 'NZDT', '3715509600', 46800, '1'),
(9, 'NZST', '3731839200', 43200, '0'),
(9, 'NZDT', '3746959200', 46800, '1'),
(9, 'NZST', '3763288800', 43200, '0'),
(9, 'NZDT', '3778408800', 46800, '1'),
(9, 'NZST', '3794738400', 43200, '0'),
(9, 'NZDT', '3809858400', 46800, '1'),
(9, 'NZST', '3826188000', 43200, '0'),
(9, 'NZDT', '3841912800', 46800, '1'),
(9, 'NZST', '3858242400', 43200, '0'),
(9, 'NZDT', '3873362400', 46800, '1'),
(9, 'NZST', '3889692000', 43200, '0'),
(9, 'NZDT', '3904812000', 46800, '1'),
(9, 'NZST', '3921141600', 43200, '0'),
(9, 'NZDT', '3936261600', 46800, '1'),
(9, 'NZST', '3952591200', 43200, '0'),
(9, 'NZDT', '3967711200', 46800, '1'),
(9, 'NZST', '3984040800', 43200, '0'),
(9, 'NZDT', '3999765600', 46800, '1'),
(9, 'NZST', '4016095200', 43200, '0'),
(9, 'NZDT', '4031215200', 46800, '1'),
(9, 'NZST', '4047544800', 43200, '0'),
(9, 'NZDT', '4062664800', 46800, '1'),
(9, 'NZST', '4078994400', 43200, '0'),
(9, 'NZDT', '4094114400', 46800, '1'),
(9, 'NZST', '4110444000', 43200, '0'),
(9, 'NZDT', '4125564000', 46800, '1'),
(9, 'NZST', '4141893600', 43200, '0'),
(9, 'NZDT', '4157013600', 46800, '1'),
(9, 'NZST', '4173343200', 43200, '0'),
(9, 'NZDT', '4188463200', 46800, '1'),
(9, 'NZST', '4204792800', 43200, '0'),
(9, 'NZDT', '4220517600', 46800, '1'),
(9, 'NZST', '4236847200', 43200, '0'),
(9, 'NZDT', '4251967200', 46800, '1'),
(9, 'NZST', '4268296800', 43200, '0'),
(9, 'NZDT', '4283416800', 46800, '1'),
(9, 'NZST', '4299746400', 43200, '0'),
(9, 'NZDT', '4314866400', 46800, '1'),
(9, 'NZST', '4331196000', 43200, '0'),
(9, 'NZDT', '4346316000', 46800, '1'),
(9, 'NZST', '4362645600', 43200, '0'),
(9, 'NZDT', '4378370400', 46800, '1'),
(9, 'NZST', '4394700000', 43200, '0'),
(9, 'NZDT', '4409820000', 46800, '1'),
(9, 'NZST', '4426149600', 43200, '0'),
(9, 'NZDT', '4441269600', 46800, '1'),
(9, 'NZST', '4457599200', 43200, '0'),
(9, 'NZDT', '4472719200', 46800, '1'),
(9, 'NZST', '4489048800', 43200, '0'),
(9, 'NZDT', '4504168800', 46800, '1'),
(9, 'NZST', '4520498400', 43200, '0'),
(9, 'NZDT', '4535618400', 46800, '1'),
(9, 'NZST', '4551948000', 43200, '0'),
(9, 'NZDT', '4567672800', 46800, '1'),
(9, 'NZST', '4584002400', 43200, '0'),
(9, 'NZDT', '4599122400', 46800, '1'),
(9, 'NZST', '4615452000', 43200, '0'),
(9, 'NZDT', '4630572000', 46800, '1'),
(9, 'NZST', '4646901600', 43200, '0'),
(9, 'NZDT', '4662021600', 46800, '1'),
(9, 'NZST', '4678351200', 43200, '0'),
(9, 'NZDT', '4693471200', 46800, '1'),
(9, 'NZST', '4709800800', 43200, '0'),
(9, 'NZDT', '4724920800', 46800, '1'),
(9, 'NZST', '4741855200', 43200, '0'),
(9, 'NZDT', '4756975200', 46800, '1'),
(9, 'NZST', '4773304800', 43200, '0'),
(9, 'NZDT', '4788424800', 46800, '1'),
(9, 'NZST', '4804754400', 43200, '0'),
(9, 'NZDT', '4819874400', 46800, '1'),
(9, 'NZST', '4836204000', 43200, '0'),
(9, 'NZDT', '4851324000', 46800, '1'),
(9, 'NZST', '4867653600', 43200, '0'),
(9, 'NZDT', '4882773600', 46800, '1'),
(9, 'NZST', '4899103200', 43200, '0'),
(9, 'NZDT', '4914828000', 46800, '1'),
(9, 'NZST', '4931157600', 43200, '0'),
(9, 'NZDT', '4946277600', 46800, '1'),
(9, 'NZST', '4962607200', 43200, '0'),
(9, 'NZDT', '4977727200', 46800, '1'),
(9, 'NZST', '4994056800', 43200, '0'),
(9, 'NZDT', '5009176800', 46800, '1'),
(9, 'NZST', '5025506400', 43200, '0'),
(9, 'NZDT', '5040626400', 46800, '1'),
(9, 'NZST', '5056956000', 43200, '0'),
(9, 'NZDT', '5072076000', 46800, '1'),
(9, 'NZST', '5088405600', 43200, '0'),
(9, 'NZDT', '5104130400', 46800, '1'),
(9, 'NZST', '5120460000', 43200, '0'),
(9, 'NZDT', '5135580000', 46800, '1'),
(9, 'NZST', '5151909600', 43200, '0'),
(9, 'NZDT', '5167029600', 46800, '1'),
(9, 'NZST', '5183359200', 43200, '0'),
(9, 'NZDT', '5198479200', 46800, '1'),
(9, 'NZST', '5214808800', 43200, '0'),
(9, 'NZDT', '5229928800', 46800, '1'),
(9, 'NZST', '5246258400', 43200, '0'),
(9, 'NZDT', '5261983200', 46800, '1'),
(9, 'NZST', '5278312800', 43200, '0'),
(9, 'NZDT', '5293432800', 46800, '1'),
(9, 'NZST', '5309762400', 43200, '0'),
(9, 'NZDT', '5324882400', 46800, '1'),
(9, 'NZST', '5341212000', 43200, '0'),
(9, 'NZDT', '5356332000', 46800, '1'),
(9, 'NZST', '5372661600', 43200, '0'),
(9, 'NZDT', '5387781600', 46800, '1'),
(9, 'NZST', '5404111200', 43200, '0'),
(9, 'NZDT', '5419231200', 46800, '1'),
(9, 'NZST', '5435560800', 43200, '0'),
(9, 'NZDT', '5451285600', 46800, '1'),
(9, 'NZST', '5467615200', 43200, '0'),
(9, 'NZDT', '5482735200', 46800, '1'),
(9, 'NZST', '5499064800', 43200, '0'),
(9, 'NZDT', '5514184800', 46800, '1'),
(9, 'NZST', '5530514400', 43200, '0'),
(9, 'NZDT', '5545634400', 46800, '1'),
(9, 'NZST', '5561964000', 43200, '0'),
(9, 'NZDT', '5577084000', 46800, '1'),
(9, 'NZST', '5593413600', 43200, '0'),
(9, 'NZDT', '5608533600', 46800, '1'),
(9, 'NZST', '5625468000', 43200, '0'),
(9, 'NZDT', '5640588000', 46800, '1'),
(9, 'NZST', '5656917600', 43200, '0'),
(9, 'NZDT', '5672037600', 46800, '1'),
(9, 'NZST', '5688367200', 43200, '0'),
(9, 'NZDT', '5703487200', 46800, '1'),
(9, 'NZST', '5719816800', 43200, '0'),
(9, 'NZDT', '5734936800', 46800, '1'),
(9, 'NZST', '5751266400', 43200, '0'),
(9, 'NZDT', '5766386400', 46800, '1'),
(9, 'NZST', '5782716000', 43200, '0'),
(9, 'NZDT', '5798440800', 46800, '1'),
(9, 'NZST', '5814770400', 43200, '0'),
(9, 'NZDT', '5829890400', 46800, '1'),
(9, 'NZST', '5846220000', 43200, '0'),
(9, 'NZDT', '5861340000', 46800, '1'),
(9, 'NZST', '5877669600', 43200, '0'),
(9, 'NZDT', '5892789600', 46800, '1'),
(9, 'NZST', '5909119200', 43200, '0'),
(9, 'NZDT', '5924239200', 46800, '1'),
(9, 'NZST', '5940568800', 43200, '0'),
(9, 'NZDT', '5955688800', 46800, '1'),
(9, 'NZST', '5972018400', 43200, '0'),
(9, 'NZDT', '5987743200', 46800, '1'),
(9, 'NZST', '6004072800', 43200, '0'),
(9, 'NZDT', '6019192800', 46800, '1'),
(9, 'NZST', '6035522400', 43200, '0'),
(9, 'NZDT', '6050642400', 46800, '1'),
(9, 'NZST', '6066972000', 43200, '0'),
(9, 'NZDT', '6082092000', 46800, '1'),
(9, 'NZST', '6098421600', 43200, '0'),
(9, 'NZDT', '6113541600', 46800, '1'),
(9, 'NZST', '6129871200', 43200, '0'),
(9, 'NZDT', '6145596000', 46800, '1'),
(9, 'NZST', '6161925600', 43200, '0'),
(9, 'NZDT', '6177045600', 46800, '1'),
(9, 'NZST', '6193375200', 43200, '0'),
(9, 'NZDT', '6208495200', 46800, '1'),
(9, 'NZST', '6224824800', 43200, '0'),
(9, 'NZDT', '6239944800', 46800, '1'),
(9, 'NZST', '6256274400', 43200, '0'),
(9, 'NZDT', '6271394400', 46800, '1'),
(9, 'NZST', '6287724000', 43200, '0'),
(9, 'NZDT', '6302844000', 46800, '1'),
(9, 'NZST', '6319173600', 43200, '0'),
(9, 'NZDT', '6334898400', 46800, '1'),
(9, 'NZST', '6351228000', 43200, '0'),
(9, 'NZDT', '6366348000', 46800, '1'),
(9, 'NZST', '6382677600', 43200, '0'),
(9, 'NZDT', '6397797600', 46800, '1'),
(9, 'NZST', '6414127200', 43200, '0'),
(9, 'NZDT', '6429247200', 46800, '1'),
(9, 'NZST', '6445576800', 43200, '0'),
(9, 'NZDT', '6460696800', 46800, '1'),
(9, 'NZST', '6477026400', 43200, '0'),
(9, 'NZDT', '6492146400', 46800, '1'),
(9, 'NZST', '6509080800', 43200, '0'),
(9, 'NZDT', '6524200800', 46800, '1'),
(9, 'NZST', '6540530400', 43200, '0'),
(9, 'NZDT', '6555650400', 46800, '1'),
(9, 'NZST', '6571980000', 43200, '0'),
(9, 'NZDT', '6587100000', 46800, '1'),
(9, 'NZST', '6603429600', 43200, '0'),
(9, 'NZDT', '6618549600', 46800, '1'),
(9, 'NZST', '6634879200', 43200, '0'),
(9, 'NZDT', '6649999200', 46800, '1'),
(9, 'NZST', '6666328800', 43200, '0'),
(9, 'NZDT', '6682053600', 46800, '1'),
(9, 'NZST', '6698383200', 43200, '0'),
(9, 'NZDT', '6713503200', 46800, '1'),
(9, 'NZST', '6729832800', 43200, '0'),
(9, 'NZDT', '6744952800', 46800, '1'),
(9, 'NZST', '6761282400', 43200, '0'),
(9, 'NZDT', '6776402400', 46800, '1'),
(9, 'NZST', '6792732000', 43200, '0'),
(9, 'NZDT', '6807852000', 46800, '1'),
(9, 'NZST', '6824181600', 43200, '0'),
(9, 'NZDT', '6839301600', 46800, '1'),
(9, 'NZST', '6855631200', 43200, '0'),
(9, 'NZDT', '6871356000', 46800, '1'),
(9, 'NZST', '6887685600', 43200, '0'),
(9, 'NZDT', '6902805600', 46800, '1'),
(9, 'NZST', '6919135200', 43200, '0'),
(9, 'NZDT', '6934255200', 46800, '1'),
(9, 'NZST', '6950584800', 43200, '0'),
(9, 'NZDT', '6965704800', 46800, '1'),
(9, 'NZST', '6982034400', 43200, '0'),
(9, 'NZDT', '6997154400', 46800, '1'),
(9, 'NZST', '7013484000', 43200, '0'),
(9, 'NZDT', '7029208800', 46800, '1'),
(9, 'NZST', '7045538400', 43200, '0'),
(9, 'NZDT', '7060658400', 46800, '1'),
(9, 'NZST', '7076988000', 43200, '0'),
(9, 'NZDT', '7092108000', 46800, '1'),
(9, 'NZST', '7108437600', 43200, '0'),
(9, 'NZDT', '7123557600', 46800, '1'),
(9, 'NZST', '7139887200', 43200, '0'),
(9, 'NZDT', '7155007200', 46800, '1'),
(9, 'NZST', '7171336800', 43200, '0'),
(9, 'NZDT', '7186456800', 46800, '1'),
(9, 'NZST', '7202786400', 43200, '0'),
(9, 'NZDT', '7218511200', 46800, '1'),
(9, 'NZST', '7234840800', 43200, '0'),
(9, 'NZDT', '7249960800', 46800, '1'),
(9, 'NZST', '7266290400', 43200, '0'),
(9, 'NZDT', '7281410400', 46800, '1'),
(9, 'NZST', '7297740000', 43200, '0'),
(9, 'NZDT', '7312860000', 46800, '1'),
(9, 'NZST', '7329189600', 43200, '0'),
(9, 'NZDT', '7344309600', 46800, '1'),
(9, 'NZST', '7360639200', 43200, '0'),
(9, 'NZDT', '7375759200', 46800, '1'),
(9, 'NZST', '7392088800', 43200, '0'),
(9, 'NZDT', '7407813600', 46800, '1'),
(9, 'NZST', '7424143200', 43200, '0'),
(9, 'NZDT', '7439263200', 46800, '1'),
(9, 'NZST', '7455592800', 43200, '0'),
(9, 'NZDT', '7470712800', 46800, '1'),
(9, 'NZST', '7487042400', 43200, '0'),
(9, 'NZDT', '7502162400', 46800, '1'),
(9, 'NZST', '7518492000', 43200, '0'),
(9, 'NZDT', '7533612000', 46800, '1'),
(9, 'NZST', '7549941600', 43200, '0'),
(9, 'NZDT', '7565061600', 46800, '1'),
(9, 'NZST', '7581391200', 43200, '0'),
(9, 'NZDT', '7597116000', 46800, '1'),
(9, 'NZST', '7613445600', 43200, '0'),
(9, 'NZDT', '7628565600', 46800, '1'),
(9, 'NZST', '7644895200', 43200, '0'),
(9, 'NZDT', '7660015200', 46800, '1'),
(9, 'NZST', '7676344800', 43200, '0'),
(9, 'NZDT', '7691464800', 46800, '1'),
(9, 'NZST', '7707794400', 43200, '0'),
(9, 'NZDT', '7722914400', 46800, '1'),
(9, 'NZST', '7739244000', 43200, '0'),
(9, 'NZDT', '7754364000', 46800, '1'),
(9, 'NZST', '7771298400', 43200, '0'),
(9, 'NZDT', '7786418400', 46800, '1'),
(9, 'NZST', '7802748000', 43200, '0'),
(9, 'NZDT', '7817868000', 46800, '1'),
(9, 'NZST', '7834197600', 43200, '0'),
(9, 'NZDT', '7849317600', 46800, '1'),
(9, 'NZST', '7865647200', 43200, '0'),
(9, 'NZDT', '7880767200', 46800, '1'),
(9, 'NZST', '7897096800', 43200, '0'),
(9, 'NZDT', '7912216800', 46800, '1'),
(9, 'NZST', '7928546400', 43200, '0'),
(9, 'NZDT', '7944271200', 46800, '1'),
(9, 'NZST', '7960600800', 43200, '0'),
(9, 'NZDT', '7975720800', 46800, '1'),
(9, 'NZST', '7992050400', 43200, '0'),
(9, 'NZDT', '8007170400', 46800, '1'),
(9, 'NZST', '8023500000', 43200, '0'),
(9, 'NZDT', '8038620000', 46800, '1'),
(9, 'NZST', '8054949600', 43200, '0'),
(9, 'NZDT', '8070069600', 46800, '1'),
(9, 'NZST', '8086399200', 43200, '0'),
(9, 'NZDT', '8101519200', 46800, '1'),
(9, 'NZST', '8117848800', 43200, '0'),
(9, 'NZDT', '8133573600', 46800, '1'),
(9, 'NZST', '8149903200', 43200, '0'),
(9, 'NZDT', '8165023200', 46800, '1'),
(9, 'NZST', '8181352800', 43200, '0'),
(9, 'NZDT', '8196472800', 46800, '1'),
(9, 'NZST', '8212802400', 43200, '0'),
(9, 'NZDT', '8227922400', 46800, '1'),
(9, 'NZST', '8244252000', 43200, '0'),
(9, 'NZDT', '8259372000', 46800, '1'),
(9, 'NZST', '8275701600', 43200, '0'),
(9, 'NZDT', '8291426400', 46800, '1'),
(9, 'NZST', '8307756000', 43200, '0'),
(9, 'NZDT', '8322876000', 46800, '1'),
(9, 'NZST', '8339205600', 43200, '0'),
(9, 'NZDT', '8354325600', 46800, '1'),
(9, 'NZST', '8370655200', 43200, '0'),
(9, 'NZDT', '8385775200', 46800, '1'),
(9, 'NZST', '8402104800', 43200, '0'),
(9, 'NZDT', '8417224800', 46800, '1'),
(9, 'NZST', '8433554400', 43200, '0'),
(9, 'NZDT', '8448674400', 46800, '1'),
(9, 'NZST', '8465004000', 43200, '0'),
(9, 'NZDT', '8480728800', 46800, '1'),
(9, 'NZST', '8497058400', 43200, '0'),
(9, 'NZDT', '8512178400', 46800, '1'),
(9, 'NZST', '8528508000', 43200, '0'),
(9, 'NZDT', '8543628000', 46800, '1'),
(9, 'NZST', '8559957600', 43200, '0'),
(9, 'NZDT', '8575077600', 46800, '1'),
(9, 'NZST', '8591407200', 43200, '0'),
(9, 'NZDT', '8606527200', 46800, '1'),
(9, 'NZST', '8622856800', 43200, '0'),
(9, 'NZDT', '8637976800', 46800, '1'),
(9, 'NZST', '8654911200', 43200, '0'),
(9, 'NZDT', '8670031200', 46800, '1'),
(9, 'NZST', '8686360800', 43200, '0'),
(9, 'NZDT', '8701480800', 46800, '1'),
(9, 'NZST', '8717810400', 43200, '0'),
(9, 'NZDT', '8732930400', 46800, '1'),
(9, 'NZST', '8749260000', 43200, '0'),
(9, 'NZDT', '8764380000', 46800, '1'),
(9, 'NZST', '8780709600', 43200, '0'),
(9, 'NZDT', '8795829600', 46800, '1'),
(9, 'NZST', '8812159200', 43200, '0'),
(9, 'NZDT', '8827884000', 46800, '1'),
(9, 'NZST', '8844213600', 43200, '0'),
(9, 'NZDT', '8859333600', 46800, '1'),
(9, 'NZST', '8875663200', 43200, '0'),
(9, 'NZDT', '8890783200', 46800, '1'),
(9, 'NZST', '8907112800', 43200, '0'),
(9, 'NZDT', '8922232800', 46800, '1'),
(9, 'NZST', '8938562400', 43200, '0'),
(9, 'NZDT', '8953682400', 46800, '1'),
(9, 'NZST', '8970012000', 43200, '0'),
(9, 'NZDT', '8985132000', 46800, '1'),
(9, 'NZST', '9001461600', 43200, '0'),
(9, 'NZDT', '9017186400', 46800, '1'),
(9, 'NZST', '9033516000', 43200, '0'),
(9, 'NZDT', '9048636000', 46800, '1'),
(9, 'NZST', '9064965600', 43200, '0'),
(9, 'NZDT', '9080085600', 46800, '1'),
(9, 'NZST', '9096415200', 43200, '0'),
(9, 'NZDT', '9111535200', 46800, '1'),
(9, 'NZST', '9127864800', 43200, '0'),
(9, 'NZDT', '9142984800', 46800, '1'),
(9, 'NZST', '9159314400', 43200, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(9, 'NZDT', '9175039200', 46800, '1'),
(9, 'NZST', '9191368800', 43200, '0'),
(9, 'NZDT', '9206488800', 46800, '1'),
(9, 'NZST', '9222818400', 43200, '0'),
(9, 'NZDT', '9237938400', 46800, '1'),
(9, 'NZST', '9254268000', 43200, '0'),
(9, 'NZDT', '9269388000', 46800, '1'),
(9, 'NZST', '9285717600', 43200, '0'),
(9, 'NZDT', '9300837600', 46800, '1'),
(9, 'NZST', '9317167200', 43200, '0'),
(9, 'NZDT', '9332287200', 46800, '1'),
(9, 'NZST', '9348616800', 43200, '0'),
(9, 'NZDT', '9364341600', 46800, '1'),
(9, 'NZST', '9380671200', 43200, '0'),
(9, 'NZDT', '9395791200', 46800, '1'),
(9, 'NZST', '9412120800', 43200, '0'),
(9, 'NZDT', '9427240800', 46800, '1'),
(9, 'NZST', '9443570400', 43200, '0'),
(9, 'NZDT', '9458690400', 46800, '1'),
(9, 'NZST', '9475020000', 43200, '0'),
(9, 'NZDT', '9490140000', 46800, '1'),
(9, 'NZST', '9506469600', 43200, '0'),
(9, 'NZDT', '9521589600', 46800, '1'),
(9, 'NZST', '9538524000', 43200, '0'),
(9, 'NZDT', '9553644000', 46800, '1'),
(9, 'NZST', '9569973600', 43200, '0'),
(9, 'NZDT', '9585093600', 46800, '1'),
(9, 'NZST', '9601423200', 43200, '0'),
(9, 'NZDT', '9616543200', 46800, '1'),
(9, 'NZST', '9632872800', 43200, '0'),
(9, 'NZDT', '9647992800', 46800, '1'),
(9, 'NZST', '9664322400', 43200, '0'),
(9, 'NZDT', '9679442400', 46800, '1'),
(9, 'NZST', '9695772000', 43200, '0'),
(9, 'NZDT', '9711496800', 46800, '1'),
(9, 'NZST', '9727826400', 43200, '0'),
(9, 'NZDT', '9742946400', 46800, '1'),
(9, 'NZST', '9759276000', 43200, '0'),
(9, 'NZDT', '9774396000', 46800, '1'),
(9, 'NZST', '9790725600', 43200, '0'),
(9, 'NZDT', '9805845600', 46800, '1'),
(9, 'NZST', '9822175200', 43200, '0'),
(9, 'NZDT', '9837295200', 46800, '1'),
(9, 'NZST', '9853624800', 43200, '0'),
(9, 'NZDT', '9868744800', 46800, '1'),
(9, 'NZST', '9885074400', 43200, '0'),
(9, 'NZDT', '9900799200', 46800, '1'),
(9, 'NZST', '9917128800', 43200, '0'),
(9, 'NZDT', '9932248800', 46800, '1'),
(9, 'NZST', '9948578400', 43200, '0'),
(9, 'NZDT', '9963698400', 46800, '1'),
(9, 'NZST', '9980028000', 43200, '0'),
(9, 'NZDT', '9995148000', 46800, '1'),
(9, 'NZST', '10011477600', 43200, '0'),
(9, 'NZDT', '10026597600', 46800, '1'),
(9, 'NZST', '10042927200', 43200, '0'),
(9, 'NZDT', '10058652000', 46800, '1'),
(9, 'NZST', '10074981600', 43200, '0'),
(9, 'NZDT', '10090101600', 46800, '1'),
(9, 'NZST', '10106431200', 43200, '0'),
(9, 'NZDT', '10121551200', 46800, '1'),
(9, 'NZST', '10137880800', 43200, '0'),
(9, 'NZDT', '10153000800', 46800, '1'),
(9, 'NZST', '10169330400', 43200, '0'),
(9, 'NZDT', '10184450400', 46800, '1'),
(9, 'NZST', '10200780000', 43200, '0'),
(9, 'NZDT', '10215900000', 46800, '1'),
(9, 'NZST', '10232229600', 43200, '0'),
(9, 'NZDT', '10247954400', 46800, '1'),
(9, 'NZST', '10264284000', 43200, '0'),
(9, 'NZDT', '10279404000', 46800, '1'),
(9, 'NZST', '10295733600', 43200, '0'),
(9, 'NZDT', '10310853600', 46800, '1'),
(9, 'NZST', '10327183200', 43200, '0'),
(9, 'NZDT', '10342303200', 46800, '1'),
(9, 'NZST', '10358632800', 43200, '0'),
(9, 'NZDT', '10373752800', 46800, '1'),
(9, 'NZST', '10390082400', 43200, '0'),
(9, 'NZDT', '10405202400', 46800, '1'),
(9, 'NZST', '10421532000', 43200, '0'),
(9, 'NZDT', '10437256800', 46800, '1'),
(9, 'NZST', '10453586400', 43200, '0'),
(9, 'NZDT', '10468706400', 46800, '1'),
(9, 'NZST', '10485036000', 43200, '0'),
(9, 'NZDT', '10500156000', 46800, '1'),
(9, 'NZST', '10516485600', 43200, '0'),
(9, 'NZDT', '10531605600', 46800, '1'),
(9, 'NZST', '10547935200', 43200, '0'),
(9, 'NZDT', '10563055200', 46800, '1'),
(9, 'NZST', '10579384800', 43200, '0'),
(9, 'NZDT', '10594504800', 46800, '1'),
(9, 'NZST', '10610834400', 43200, '0'),
(9, 'NZDT', '10626559200', 46800, '1'),
(9, 'NZST', '10642888800', 43200, '0'),
(9, 'NZDT', '10658008800', 46800, '1'),
(9, 'NZST', '10674338400', 43200, '0'),
(9, 'NZDT', '10689458400', 46800, '1'),
(9, 'NZST', '10705788000', 43200, '0'),
(9, 'NZDT', '10720908000', 46800, '1'),
(9, 'NZST', '10737237600', 43200, '0'),
(9, 'NZDT', '10752357600', 46800, '1'),
(9, 'NZST', '10768687200', 43200, '0'),
(9, 'NZDT', '10783807200', 46800, '1'),
(9, 'NZST', '10800741600', 43200, '0'),
(9, 'NZDT', '10815861600', 46800, '1'),
(9, 'NZST', '10832191200', 43200, '0'),
(9, 'NZDT', '10847311200', 46800, '1'),
(9, 'NZST', '10863640800', 43200, '0'),
(9, 'NZDT', '10878760800', 46800, '1'),
(9, 'NZST', '10895090400', 43200, '0'),
(9, 'NZDT', '10910210400', 46800, '1'),
(9, 'NZST', '10926540000', 43200, '0'),
(9, 'NZDT', '10941660000', 46800, '1'),
(9, 'NZST', '10957989600', 43200, '0'),
(9, 'NZDT', '10973714400', 46800, '1'),
(9, 'NZST', '10990044000', 43200, '0'),
(9, 'NZDT', '11005164000', 46800, '1'),
(9, 'NZST', '11021493600', 43200, '0'),
(9, 'NZDT', '11036613600', 46800, '1'),
(9, 'NZST', '11052943200', 43200, '0'),
(9, 'NZDT', '11068063200', 46800, '1'),
(9, 'NZST', '11084392800', 43200, '0'),
(9, 'NZDT', '11099512800', 46800, '1'),
(9, 'NZST', '11115842400', 43200, '0'),
(9, 'NZDT', '11130962400', 46800, '1'),
(9, 'NZST', '11147292000', 43200, '0'),
(9, 'NZDT', '11163016800', 46800, '1'),
(9, 'NZST', '11179346400', 43200, '0'),
(9, 'NZDT', '11194466400', 46800, '1'),
(9, 'NZST', '11210796000', 43200, '0'),
(9, 'NZDT', '11225916000', 46800, '1'),
(9, 'NZST', '11242245600', 43200, '0'),
(9, 'NZDT', '11257365600', 46800, '1'),
(9, 'NZST', '11273695200', 43200, '0'),
(9, 'NZDT', '11288815200', 46800, '1'),
(9, 'NZST', '11305144800', 43200, '0'),
(9, 'NZDT', '11320869600', 46800, '1'),
(9, 'NZST', '11337199200', 43200, '0'),
(9, 'NZDT', '11352319200', 46800, '1'),
(9, 'NZST', '11368648800', 43200, '0'),
(9, 'NZDT', '11383768800', 46800, '1'),
(9, 'NZST', '11400098400', 43200, '0'),
(9, 'NZDT', '11415218400', 46800, '1'),
(9, 'NZST', '11431548000', 43200, '0'),
(9, 'NZDT', '11446668000', 46800, '1'),
(9, 'NZST', '11462997600', 43200, '0'),
(9, 'NZDT', '11478117600', 46800, '1'),
(9, 'NZST', '11494447200', 43200, '0'),
(9, 'NZDT', '11510172000', 46800, '1'),
(9, 'NZST', '11526501600', 43200, '0'),
(9, 'NZDT', '11541621600', 46800, '1'),
(9, 'NZST', '11557951200', 43200, '0'),
(9, 'NZDT', '11573071200', 46800, '1'),
(9, 'NZST', '11589400800', 43200, '0'),
(9, 'NZDT', '11604520800', 46800, '1'),
(9, 'NZST', '11620850400', 43200, '0'),
(9, 'NZDT', '11635970400', 46800, '1'),
(9, 'NZST', '11652300000', 43200, '0'),
(9, 'NZDT', '11667420000', 46800, '1'),
(9, 'NZST', '11684354400', 43200, '0'),
(9, 'NZDT', '11699474400', 46800, '1'),
(9, 'NZST', '11715804000', 43200, '0'),
(9, 'NZDT', '11730924000', 46800, '1'),
(9, 'NZST', '11747253600', 43200, '0'),
(9, 'NZDT', '11762373600', 46800, '1'),
(9, 'NZST', '11778703200', 43200, '0'),
(9, 'NZDT', '11793823200', 46800, '1'),
(9, 'NZST', '11810152800', 43200, '0'),
(9, 'NZDT', '11825272800', 46800, '1'),
(9, 'NZST', '11841602400', 43200, '0'),
(9, 'NZDT', '11857327200', 46800, '1'),
(9, 'NZST', '11873656800', 43200, '0'),
(9, 'NZDT', '11888776800', 46800, '1'),
(9, 'NZST', '11905106400', 43200, '0'),
(9, 'NZDT', '11920226400', 46800, '1'),
(9, 'NZST', '11936556000', 43200, '0'),
(9, 'NZDT', '11951676000', 46800, '1'),
(9, 'NZST', '11968005600', 43200, '0'),
(9, 'NZDT', '11983125600', 46800, '1'),
(9, 'NZST', '11999455200', 43200, '0'),
(9, 'NZDT', '12014575200', 46800, '1'),
(9, 'NZST', '12030904800', 43200, '0'),
(9, 'NZDT', '12046629600', 46800, '1'),
(9, 'NZST', '12062959200', 43200, '0'),
(9, 'NZDT', '12078079200', 46800, '1'),
(9, 'NZST', '12094408800', 43200, '0'),
(9, 'NZDT', '12109528800', 46800, '1'),
(9, 'NZST', '12125858400', 43200, '0'),
(9, 'NZDT', '12140978400', 46800, '1'),
(9, 'NZST', '12157308000', 43200, '0'),
(9, 'NZDT', '12172428000', 46800, '1'),
(9, 'NZST', '12188757600', 43200, '0'),
(9, 'NZDT', '12204482400', 46800, '1'),
(9, 'NZST', '12220812000', 43200, '0'),
(9, 'NZDT', '12235932000', 46800, '1'),
(9, 'NZST', '12252261600', 43200, '0'),
(9, 'NZDT', '12267381600', 46800, '1'),
(9, 'NZST', '12283711200', 43200, '0'),
(9, 'NZDT', '12298831200', 46800, '1'),
(9, 'NZST', '12315160800', 43200, '0'),
(9, 'NZDT', '12330280800', 46800, '1'),
(9, 'NZST', '12346610400', 43200, '0'),
(9, 'NZDT', '12361730400', 46800, '1'),
(9, 'NZST', '12378060000', 43200, '0'),
(9, 'NZDT', '12393784800', 46800, '1'),
(9, 'NZST', '12410114400', 43200, '0'),
(9, 'NZDT', '12425234400', 46800, '1'),
(9, 'NZST', '12441564000', 43200, '0'),
(9, 'NZDT', '12456684000', 46800, '1'),
(9, 'NZST', '12473013600', 43200, '0'),
(9, 'NZDT', '12488133600', 46800, '1'),
(9, 'NZST', '12504463200', 43200, '0'),
(9, 'NZDT', '12519583200', 46800, '1'),
(9, 'NZST', '12535912800', 43200, '0'),
(9, 'NZDT', '12551032800', 46800, '1'),
(9, 'NZST', '12567967200', 43200, '0'),
(9, 'NZDT', '12583087200', 46800, '1'),
(9, 'NZST', '12599416800', 43200, '0'),
(9, 'NZDT', '12614536800', 46800, '1'),
(9, 'NZST', '12630866400', 43200, '0'),
(9, 'NZDT', '12645986400', 46800, '1'),
(9, 'NZST', '12662316000', 43200, '0'),
(9, 'NZDT', '12677436000', 46800, '1'),
(9, 'NZST', '12693765600', 43200, '0'),
(9, 'NZDT', '12708885600', 46800, '1'),
(9, 'NZST', '12725215200', 43200, '0'),
(9, 'NZDT', '12740940000', 46800, '1'),
(9, 'NZST', '12757269600', 43200, '0'),
(9, 'NZDT', '12772389600', 46800, '1'),
(9, 'NZST', '12788719200', 43200, '0'),
(9, 'NZDT', '12803839200', 46800, '1'),
(9, 'NZST', '12820168800', 43200, '0'),
(9, 'NZDT', '12835288800', 46800, '1'),
(9, 'NZST', '12851618400', 43200, '0'),
(9, 'NZDT', '12866738400', 46800, '1'),
(9, 'NZST', '12883068000', 43200, '0'),
(9, 'NZDT', '12898188000', 46800, '1'),
(9, 'NZST', '12914517600', 43200, '0'),
(9, 'NZDT', '12930242400', 46800, '1'),
(9, 'NZST', '12946572000', 43200, '0'),
(9, 'NZDT', '12961692000', 46800, '1'),
(9, 'NZST', '12978021600', 43200, '0'),
(9, 'NZDT', '12993141600', 46800, '1'),
(9, 'NZST', '13009471200', 43200, '0'),
(9, 'NZDT', '13024591200', 46800, '1'),
(9, 'NZST', '13040920800', 43200, '0'),
(9, 'NZDT', '13056040800', 46800, '1'),
(9, 'NZST', '13072370400', 43200, '0'),
(9, 'NZDT', '13088095200', 46800, '1'),
(9, 'NZST', '13104424800', 43200, '0'),
(9, 'NZDT', '13119544800', 46800, '1'),
(9, 'NZST', '13135874400', 43200, '0'),
(9, 'NZDT', '13150994400', 46800, '1'),
(9, 'NZST', '13167324000', 43200, '0'),
(9, 'NZDT', '13182444000', 46800, '1'),
(9, 'NZST', '13198773600', 43200, '0'),
(9, 'NZDT', '13213893600', 46800, '1'),
(9, 'NZST', '13230223200', 43200, '0'),
(9, 'NZDT', '13245343200', 46800, '1'),
(9, 'NZST', '13261672800', 43200, '0'),
(9, 'NZDT', '13277397600', 46800, '1'),
(9, 'NZST', '13293727200', 43200, '0'),
(9, 'NZDT', '13308847200', 46800, '1'),
(9, 'NZST', '13325176800', 43200, '0'),
(9, 'NZDT', '13340296800', 46800, '1'),
(9, 'NZST', '13356626400', 43200, '0'),
(9, 'NZDT', '13371746400', 46800, '1'),
(9, 'NZST', '13388076000', 43200, '0'),
(9, 'NZDT', '13403196000', 46800, '1'),
(9, 'NZST', '13419525600', 43200, '0'),
(9, 'NZDT', '13434645600', 46800, '1'),
(9, 'NZST', '13451580000', 43200, '0'),
(9, 'NZDT', '13466700000', 46800, '1'),
(9, 'NZST', '13483029600', 43200, '0'),
(9, 'NZDT', '13498149600', 46800, '1'),
(9, 'NZST', '13514479200', 43200, '0'),
(9, 'NZDT', '13529599200', 46800, '1'),
(9, 'NZST', '13545928800', 43200, '0'),
(9, 'NZDT', '13561048800', 46800, '1'),
(9, 'NZST', '13577378400', 43200, '0'),
(9, 'NZDT', '13592498400', 46800, '1'),
(9, 'NZST', '13608828000', 43200, '0'),
(9, 'NZDT', '13624552800', 46800, '1'),
(9, 'NZST', '13640882400', 43200, '0'),
(9, 'NZDT', '13656002400', 46800, '1'),
(9, 'NZST', '13672332000', 43200, '0'),
(9, 'NZDT', '13687452000', 46800, '1'),
(9, 'NZST', '13703781600', 43200, '0'),
(9, 'NZDT', '13718901600', 46800, '1'),
(9, 'NZST', '13735231200', 43200, '0'),
(9, 'NZDT', '13750351200', 46800, '1'),
(9, 'NZST', '13766680800', 43200, '0'),
(9, 'NZDT', '13781800800', 46800, '1'),
(9, 'NZST', '13798130400', 43200, '0'),
(9, 'NZDT', '13813855200', 46800, '1'),
(9, 'NZST', '13830184800', 43200, '0'),
(9, 'NZDT', '13845304800', 46800, '1'),
(9, 'NZST', '13861634400', 43200, '0'),
(9, 'NZDT', '13876754400', 46800, '1'),
(9, 'NZST', '13893084000', 43200, '0'),
(9, 'NZDT', '13908204000', 46800, '1'),
(9, 'NZST', '13924533600', 43200, '0'),
(9, 'NZDT', '13939653600', 46800, '1'),
(9, 'NZST', '13955983200', 43200, '0'),
(9, 'NZDT', '13971708000', 46800, '1'),
(9, 'NZST', '13988037600', 43200, '0'),
(9, 'NZDT', '14003157600', 46800, '1'),
(9, 'NZST', '14019487200', 43200, '0'),
(9, 'NZDT', '14034607200', 46800, '1'),
(9, 'NZST', '14050936800', 43200, '0'),
(9, 'NZDT', '14066056800', 46800, '1'),
(9, 'NZST', '14082386400', 43200, '0'),
(9, 'NZDT', '14097506400', 46800, '1'),
(9, 'NZST', '14113836000', 43200, '0'),
(9, 'NZDT', '14128956000', 46800, '1'),
(9, 'NZST', '14145285600', 43200, '0'),
(9, 'NZDT', '14161010400', 46800, '1'),
(9, 'NZST', '14177340000', 43200, '0'),
(9, 'NZDT', '14192460000', 46800, '1'),
(9, 'NZST', '14208789600', 43200, '0'),
(9, 'NZDT', '14223909600', 46800, '1'),
(9, 'NZST', '14240239200', 43200, '0'),
(9, 'NZDT', '14255359200', 46800, '1'),
(9, 'NZST', '14271688800', 43200, '0'),
(9, 'NZDT', '14286808800', 46800, '1'),
(9, 'NZST', '14303138400', 43200, '0'),
(9, 'NZDT', '14318258400', 46800, '1'),
(9, 'NZST', '14335192800', 43200, '0'),
(9, 'NZDT', '14350312800', 46800, '1'),
(9, 'NZST', '14366642400', 43200, '0'),
(9, 'NZDT', '14381762400', 46800, '1'),
(9, 'NZST', '14398092000', 43200, '0'),
(9, 'NZDT', '14413212000', 46800, '1'),
(9, 'NZST', '14429541600', 43200, '0'),
(9, 'NZDT', '14444661600', 46800, '1'),
(9, 'NZST', '14460991200', 43200, '0'),
(9, 'NZDT', '14476111200', 46800, '1'),
(9, 'NZST', '14492440800', 43200, '0'),
(9, 'NZDT', '14508165600', 46800, '1'),
(9, 'NZST', '14524495200', 43200, '0'),
(9, 'NZDT', '14539615200', 46800, '1'),
(9, 'NZST', '14555944800', 43200, '0'),
(9, 'NZDT', '14571064800', 46800, '1'),
(9, 'NZST', '14587394400', 43200, '0'),
(9, 'NZDT', '14602514400', 46800, '1'),
(9, 'NZST', '14618844000', 43200, '0'),
(9, 'NZDT', '14633964000', 46800, '1'),
(9, 'NZST', '14650293600', 43200, '0'),
(9, 'NZDT', '14665413600', 46800, '1'),
(9, 'NZST', '14681743200', 43200, '0'),
(9, 'NZDT', '14697468000', 46800, '1'),
(9, 'NZST', '14713797600', 43200, '0'),
(9, 'NZDT', '14728917600', 46800, '1'),
(9, 'NZST', '14745247200', 43200, '0'),
(9, 'NZDT', '14760367200', 46800, '1'),
(9, 'NZST', '14776696800', 43200, '0'),
(9, 'NZDT', '14791816800', 46800, '1'),
(9, 'NZST', '14808146400', 43200, '0'),
(9, 'NZDT', '14823266400', 46800, '1'),
(9, 'NZST', '14839596000', 43200, '0'),
(9, 'NZDT', '14855320800', 46800, '1'),
(9, 'NZST', '14871650400', 43200, '0'),
(9, 'NZDT', '14886770400', 46800, '1'),
(9, 'NZST', '14903100000', 43200, '0'),
(9, 'NZDT', '14918220000', 46800, '1'),
(9, 'NZST', '14934549600', 43200, '0'),
(9, 'NZDT', '14949669600', 46800, '1'),
(9, 'NZST', '14965999200', 43200, '0'),
(9, 'NZDT', '14981119200', 46800, '1'),
(9, 'NZST', '14997448800', 43200, '0'),
(9, 'NZDT', '15012568800', 46800, '1'),
(9, 'NZST', '15028898400', 43200, '0'),
(9, 'NZDT', '15044623200', 46800, '1'),
(9, 'NZST', '15060952800', 43200, '0'),
(9, 'NZDT', '15076072800', 46800, '1'),
(9, 'NZST', '15092402400', 43200, '0'),
(9, 'NZDT', '15107522400', 46800, '1'),
(9, 'NZST', '15123852000', 43200, '0'),
(9, 'NZDT', '15138972000', 46800, '1'),
(9, 'NZST', '15155301600', 43200, '0'),
(9, 'NZDT', '15170421600', 46800, '1'),
(9, 'NZST', '15186751200', 43200, '0'),
(9, 'NZDT', '15201871200', 46800, '1'),
(9, 'NZST', '15218805600', 43200, '0'),
(9, 'NZDT', '15233925600', 46800, '1'),
(9, 'NZST', '15250255200', 43200, '0'),
(9, 'NZDT', '15265375200', 46800, '1'),
(9, 'NZST', '15281704800', 43200, '0'),
(9, 'NZDT', '15296824800', 46800, '1'),
(9, 'NZST', '15313154400', 43200, '0'),
(9, 'NZDT', '15328274400', 46800, '1'),
(9, 'NZST', '15344604000', 43200, '0'),
(9, 'NZDT', '15359724000', 46800, '1'),
(9, 'NZST', '15376053600', 43200, '0'),
(9, 'NZDT', '15391778400', 46800, '1'),
(9, 'NZST', '15408108000', 43200, '0'),
(9, 'NZDT', '15423228000', 46800, '1'),
(9, 'NZST', '15439557600', 43200, '0'),
(9, 'NZDT', '15454677600', 46800, '1'),
(9, 'NZST', '15471007200', 43200, '0'),
(9, 'NZDT', '15486127200', 46800, '1'),
(9, 'NZST', '15502456800', 43200, '0'),
(9, 'NZDT', '15517576800', 46800, '1'),
(9, 'NZST', '15533906400', 43200, '0'),
(9, 'NZDT', '15549026400', 46800, '1'),
(9, 'NZST', '15565356000', 43200, '0'),
(9, 'NZDT', '15581080800', 46800, '1'),
(9, 'NZST', '15597410400', 43200, '0'),
(9, 'NZDT', '15612530400', 46800, '1'),
(9, 'NZST', '15628860000', 43200, '0'),
(9, 'NZDT', '15643980000', 46800, '1'),
(9, 'NZST', '15660309600', 43200, '0'),
(9, 'NZDT', '15675429600', 46800, '1'),
(9, 'NZST', '15691759200', 43200, '0'),
(9, 'NZDT', '15706879200', 46800, '1'),
(9, 'NZST', '15723208800', 43200, '0'),
(9, 'NZDT', '15738933600', 46800, '1'),
(9, 'NZST', '15755263200', 43200, '0'),
(9, 'NZDT', '15770383200', 46800, '1'),
(9, 'NZST', '15786712800', 43200, '0'),
(9, 'NZDT', '15801832800', 46800, '1'),
(9, 'NZST', '15818162400', 43200, '0'),
(9, 'NZDT', '15833282400', 46800, '1'),
(9, 'NZST', '15849612000', 43200, '0'),
(9, 'NZDT', '15864732000', 46800, '1'),
(9, 'NZST', '15881061600', 43200, '0'),
(9, 'NZDT', '15896181600', 46800, '1'),
(9, 'NZST', '15912511200', 43200, '0'),
(9, 'NZDT', '15928236000', 46800, '1'),
(9, 'NZST', '15944565600', 43200, '0'),
(9, 'NZDT', '15959685600', 46800, '1'),
(9, 'NZST', '15976015200', 43200, '0'),
(9, 'NZDT', '15991135200', 46800, '1'),
(9, 'NZST', '16007464800', 43200, '0'),
(9, 'NZDT', '16022584800', 46800, '1'),
(9, 'NZST', '16038914400', 43200, '0'),
(9, 'NZDT', '16054034400', 46800, '1'),
(9, 'NZST', '16070364000', 43200, '0'),
(9, 'NZDT', '16085484000', 46800, '1'),
(9, 'NZST', '16102418400', 43200, '0'),
(9, 'NZDT', '16117538400', 46800, '1'),
(9, 'NZST', '16133868000', 43200, '0'),
(9, 'NZDT', '16148988000', 46800, '1'),
(9, 'NZST', '16165317600', 43200, '0'),
(9, 'NZDT', '16180437600', 46800, '1'),
(9, 'NZST', '16196767200', 43200, '0'),
(9, 'NZDT', '16211887200', 46800, '1'),
(9, 'NZST', '16228216800', 43200, '0'),
(9, 'NZDT', '16243336800', 46800, '1'),
(9, 'NZST', '16259666400', 43200, '0'),
(9, 'NZDT', '16275391200', 46800, '1'),
(9, 'NZST', '16291720800', 43200, '0'),
(9, 'NZDT', '16306840800', 46800, '1'),
(9, 'NZST', '16323170400', 43200, '0'),
(9, 'NZDT', '16338290400', 46800, '1'),
(9, 'NZST', '16354620000', 43200, '0'),
(9, 'NZDT', '16369740000', 46800, '1'),
(9, 'NZST', '16386069600', 43200, '0'),
(9, 'NZDT', '16401189600', 46800, '1'),
(9, 'NZST', '16417519200', 43200, '0'),
(9, 'NZDT', '16432639200', 46800, '1'),
(9, 'NZST', '16448968800', 43200, '0'),
(9, 'NZDT', '16464693600', 46800, '1'),
(9, 'NZST', '16481023200', 43200, '0'),
(9, 'NZDT', '16496143200', 46800, '1'),
(9, 'NZST', '16512472800', 43200, '0'),
(9, 'NZDT', '16527592800', 46800, '1'),
(9, 'NZST', '16543922400', 43200, '0'),
(9, 'NZDT', '16559042400', 46800, '1'),
(9, 'NZST', '16575372000', 43200, '0'),
(9, 'NZDT', '16590492000', 46800, '1'),
(9, 'NZST', '16606821600', 43200, '0'),
(9, 'NZDT', '16622546400', 46800, '1'),
(9, 'NZST', '16638876000', 43200, '0'),
(9, 'NZDT', '16653996000', 46800, '1'),
(9, 'NZST', '16670325600', 43200, '0'),
(9, 'NZDT', '16685445600', 46800, '1'),
(9, 'NZST', '16701775200', 43200, '0'),
(9, 'NZDT', '16716895200', 46800, '1'),
(10, '+08', '-31536000', 28800, '0'),
(10, '+11', '1255802400', 39600, '0'),
(10, '+08', '1267714800', 28800, '0'),
(10, '+11', '1319738400', 39600, '0'),
(10, '+08', '1329843600', 28800, '0'),
(10, '+11', '1477065600', 39600, '0'),
(11, '+07', '-409190400', 25200, '0'),
(11, '+05', '1255806000', 18000, '0'),
(11, '+07', '1268251200', 25200, '0'),
(11, '+05', '1319742000', 18000, '0'),
(11, '+07', '1329854400', 25200, '0'),
(12, '+10', '-725846400', 36000, '0'),
(13, '+06', '-501206400', 21600, '0'),
(13, '+05', '1255809600', 18000, '0'),
(14, '-03', '-157766400', -10800, '1'),
(14, '-04', '-152658000', -14400, '0'),
(14, '-03', '-132955200', -10800, '1'),
(14, '-04', '-121122000', -14400, '0'),
(14, '-03', '-101419200', -10800, '1'),
(14, '-04', '-86821200', -14400, '0'),
(14, '-03', '-71092800', -10800, '1'),
(14, '-04', '-54766800', -14400, '0'),
(14, '-03', '-39038400', -10800, '1'),
(14, '-04', '-23317200', -14400, '0'),
(14, '-03', '-7588800', -10800, '0'),
(14, '-02', '128142000', -7200, '1'),
(14, '-03', '136605600', -10800, '0'),
(14, '-04', '389070000', -14400, '0'),
(14, '-03', '403070400', -10800, '1'),
(14, '-04', '416372400', -14400, '0'),
(14, '-03', '434520000', -10800, '1'),
(14, '-04', '447822000', -14400, '0'),
(14, '-03', '466574400', -10800, '1'),
(14, '-04', '479271600', -14400, '0'),
(14, '-03', '498024000', -10800, '1'),
(14, '-04', '510721200', -14400, '0'),
(14, '-03', '529473600', -10800, '1'),
(14, '-04', '545194800', -14400, '0'),
(14, '-03', '560923200', -10800, '1'),
(14, '-04', '574225200', -14400, '0'),
(14, '-03', '592372800', -10800, '1'),
(14, '-04', '605674800', -14400, '0'),
(14, '-03', '624427200', -10800, '1'),
(14, '-04', '637124400', -14400, '0'),
(14, '-03', '653457600', -10800, '1'),
(14, '-04', '668574000', -14400, '0'),
(14, '-03', '687326400', -10800, '1'),
(14, '-04', '700628400', -14400, '0'),
(14, '-03', '718776000', -10800, '1'),
(14, '-04', '732078000', -14400, '0'),
(14, '-03', '750225600', -10800, '1'),
(14, '-04', '763527600', -14400, '0'),
(14, '-03', '781675200', -10800, '1'),
(14, '-04', '794977200', -14400, '0'),
(14, '-03', '813729600', -10800, '1'),
(14, '-04', '826426800', -14400, '0'),
(14, '-03', '845179200', -10800, '1'),
(14, '-04', '859690800', -14400, '0'),
(14, '-03', '876628800', -10800, '1'),
(14, '-04', '889930800', -14400, '0'),
(14, '-03', '906868800', -10800, '1'),
(14, '-04', '923194800', -14400, '0'),
(14, '-03', '939528000', -10800, '1'),
(14, '-04', '952830000', -14400, '0'),
(14, '-03', '971582400', -10800, '1'),
(14, '-04', '984279600', -14400, '0'),
(14, '-03', '1003032000', -10800, '1'),
(14, '-04', '1015729200', -14400, '0'),
(14, '-03', '1034481600', -10800, '1'),
(14, '-04', '1047178800', -14400, '0'),
(14, '-03', '1065931200', -10800, '1'),
(14, '-04', '1079233200', -14400, '0'),
(14, '-03', '1097380800', -10800, '1'),
(14, '-04', '1110682800', -14400, '0'),
(14, '-03', '1128830400', -10800, '1'),
(14, '-04', '1142132400', -14400, '0'),
(14, '-03', '1160884800', -10800, '1'),
(14, '-04', '1173582000', -14400, '0'),
(14, '-03', '1192334400', -10800, '1'),
(14, '-04', '1206846000', -14400, '0'),
(14, '-03', '1223784000', -10800, '1'),
(14, '-04', '1237086000', -14400, '0'),
(14, '-03', '1255233600', -10800, '1'),
(14, '-04', '1270350000', -14400, '0'),
(14, '-03', '1286683200', -10800, '1'),
(14, '-04', '1304823600', -14400, '0'),
(14, '-03', '1313899200', -10800, '1'),
(14, '-04', '1335668400', -14400, '0'),
(14, '-03', '1346558400', -10800, '1'),
(14, '-04', '1367118000', -14400, '0'),
(14, '-03', '1378612800', -10800, '1'),
(14, '-04', '1398567600', -14400, '0'),
(14, '-03', '1410062400', -10800, '1'),
(14, '-04', '1463281200', -14400, '0'),
(14, '-03', '1471147200', -10800, '1'),
(15, '-03', '218246400', -10800, '0'),
(16, '+03', '-407808000', 10800, '0'),
(17, '+00', '1108166400', 0, '0'),
(17, '+02', '1111885200', 7200, '1'),
(17, '+00', '1130634000', 0, '0'),
(17, '+02', '1143334800', 7200, '1'),
(17, '+00', '1162083600', 0, '0'),
(17, '+02', '1174784400', 7200, '1'),
(17, '+00', '1193533200', 0, '0'),
(17, '+02', '1206838800', 7200, '1'),
(17, '+00', '1224982800', 0, '0'),
(17, '+02', '1238288400', 7200, '1'),
(17, '+00', '1256432400', 0, '0'),
(17, '+02', '1269738000', 7200, '1'),
(17, '+00', '1288486800', 0, '0'),
(17, '+02', '1301187600', 7200, '1'),
(17, '+00', '1319936400', 0, '0'),
(17, '+02', '1332637200', 7200, '1'),
(17, '+00', '1351386000', 0, '0'),
(17, '+02', '1364691600', 7200, '1'),
(17, '+00', '1382835600', 0, '0'),
(17, '+02', '1396141200', 7200, '1'),
(17, '+00', '1414285200', 0, '0'),
(17, '+02', '1427590800', 7200, '1'),
(17, '+00', '1445734800', 0, '0'),
(17, '+02', '1459040400', 7200, '1'),
(17, '+00', '1477789200', 0, '0'),
(17, '+02', '1490490000', 7200, '1'),
(17, '+00', '1509238800', 0, '0'),
(17, '+02', '1521939600', 7200, '1'),
(17, '+00', '1540688400', 0, '0'),
(17, '+02', '1553994000', 7200, '1'),
(17, '+00', '1572138000', 0, '0'),
(17, '+02', '1585443600', 7200, '1'),
(17, '+00', '1603587600', 0, '0'),
(17, '+02', '1616893200', 7200, '1'),
(17, '+00', '1635642000', 0, '0'),
(17, '+02', '1648342800', 7200, '1'),
(17, '+00', '1667091600', 0, '0'),
(17, '+02', '1679792400', 7200, '1'),
(17, '+00', '1698541200', 0, '0'),
(17, '+02', '1711846800', 7200, '1'),
(17, '+00', '1729990800', 0, '0'),
(17, '+02', '1743296400', 7200, '1'),
(17, '+00', '1761440400', 0, '0'),
(17, '+02', '1774746000', 7200, '1'),
(17, '+00', '1792890000', 0, '0'),
(17, '+02', '1806195600', 7200, '1'),
(17, '+00', '1824944400', 0, '0'),
(17, '+02', '1837645200', 7200, '1'),
(17, '+00', '1856394000', 0, '0'),
(17, '+02', '1869094800', 7200, '1'),
(17, '+00', '1887843600', 0, '0'),
(17, '+02', '1901149200', 7200, '1'),
(17, '+00', '1919293200', 0, '0'),
(17, '+02', '1932598800', 7200, '1'),
(17, '+00', '1950742800', 0, '0'),
(17, '+02', '1964048400', 7200, '1'),
(17, '+00', '1982797200', 0, '0'),
(17, '+02', '1995498000', 7200, '1'),
(17, '+00', '2014246800', 0, '0'),
(17, '+02', '2026947600', 7200, '1'),
(17, '+00', '2045696400', 0, '0'),
(17, '+02', '2058397200', 7200, '1'),
(17, '+00', '2077146000', 0, '0'),
(17, '+02', '2090451600', 7200, '1'),
(17, '+00', '2108595600', 0, '0'),
(17, '+02', '2121901200', 7200, '1'),
(17, '+00', '2140045200', 0, '0'),
(17, '+02', '2153350800', 7200, '1'),
(17, '+00', '2172099600', 0, '0'),
(17, '+02', '2184800400', 7200, '1'),
(17, '+00', '2203549200', 0, '0'),
(17, '+02', '2216250000', 7200, '1'),
(17, '+00', '2234998800', 0, '0'),
(17, '+02', '2248304400', 7200, '1'),
(17, '+00', '2266448400', 0, '0'),
(17, '+02', '2279754000', 7200, '1'),
(17, '+00', '2297898000', 0, '0'),
(17, '+02', '2311203600', 7200, '1'),
(17, '+00', '2329347600', 0, '0'),
(17, '+02', '2342653200', 7200, '1'),
(17, '+00', '2361402000', 0, '0'),
(17, '+02', '2374102800', 7200, '1'),
(17, '+00', '2392851600', 0, '0'),
(17, '+02', '2405552400', 7200, '1'),
(17, '+00', '2424301200', 0, '0'),
(17, '+02', '2437606800', 7200, '1'),
(17, '+00', '2455750800', 0, '0'),
(17, '+02', '2469056400', 7200, '1'),
(17, '+00', '2487200400', 0, '0'),
(17, '+02', '2500506000', 7200, '1'),
(17, '+00', '2519254800', 0, '0'),
(17, '+02', '2531955600', 7200, '1'),
(17, '+00', '2550704400', 0, '0'),
(17, '+02', '2563405200', 7200, '1'),
(17, '+00', '2582154000', 0, '0'),
(17, '+02', '2595459600', 7200, '1'),
(17, '+00', '2613603600', 0, '0'),
(17, '+02', '2626909200', 7200, '1'),
(17, '+00', '2645053200', 0, '0'),
(17, '+02', '2658358800', 7200, '1'),
(17, '+00', '2676502800', 0, '0'),
(17, '+02', '2689808400', 7200, '1'),
(17, '+00', '2708557200', 0, '0'),
(17, '+02', '2721258000', 7200, '1'),
(17, '+00', '2740006800', 0, '0'),
(17, '+02', '2752707600', 7200, '1'),
(17, '+00', '2771456400', 0, '0'),
(17, '+02', '2784762000', 7200, '1'),
(17, '+00', '2802906000', 0, '0'),
(17, '+02', '2816211600', 7200, '1'),
(17, '+00', '2834355600', 0, '0'),
(17, '+02', '2847661200', 7200, '1'),
(17, '+00', '2866410000', 0, '0'),
(17, '+02', '2879110800', 7200, '1'),
(17, '+00', '2897859600', 0, '0'),
(17, '+02', '2910560400', 7200, '1'),
(17, '+00', '2929309200', 0, '0'),
(17, '+02', '2942010000', 7200, '1'),
(17, '+00', '2960758800', 0, '0'),
(17, '+02', '2974064400', 7200, '1'),
(17, '+00', '2992208400', 0, '0'),
(17, '+02', '3005514000', 7200, '1'),
(17, '+00', '3023658000', 0, '0'),
(17, '+02', '3036963600', 7200, '1'),
(17, '+00', '3055712400', 0, '0'),
(17, '+02', '3068413200', 7200, '1'),
(17, '+00', '3087162000', 0, '0'),
(17, '+02', '3099862800', 7200, '1'),
(17, '+00', '3118611600', 0, '0'),
(17, '+02', '3131917200', 7200, '1'),
(17, '+00', '3150061200', 0, '0'),
(17, '+02', '3163366800', 7200, '1'),
(17, '+00', '3181510800', 0, '0'),
(17, '+02', '3194816400', 7200, '1'),
(17, '+00', '3212960400', 0, '0'),
(17, '+02', '3226266000', 7200, '1'),
(17, '+00', '3245014800', 0, '0'),
(17, '+02', '3257715600', 7200, '1'),
(17, '+00', '3276464400', 0, '0'),
(17, '+02', '3289165200', 7200, '1'),
(17, '+00', '3307914000', 0, '0'),
(17, '+02', '3321219600', 7200, '1'),
(17, '+00', '3339363600', 0, '0'),
(17, '+02', '3352669200', 7200, '1'),
(17, '+00', '3370813200', 0, '0'),
(17, '+02', '3384118800', 7200, '1'),
(17, '+00', '3402867600', 0, '0'),
(17, '+02', '3415568400', 7200, '1'),
(17, '+00', '3434317200', 0, '0'),
(17, '+02', '3447018000', 7200, '1'),
(17, '+00', '3465766800', 0, '0'),
(17, '+02', '3479072400', 7200, '1'),
(17, '+00', '3497216400', 0, '0'),
(17, '+02', '3510522000', 7200, '1'),
(17, '+00', '3528666000', 0, '0'),
(17, '+02', '3541971600', 7200, '1'),
(17, '+00', '3560115600', 0, '0'),
(17, '+02', '3573421200', 7200, '1'),
(17, '+00', '3592170000', 0, '0'),
(17, '+02', '3604870800', 7200, '1'),
(17, '+00', '3623619600', 0, '0'),
(17, '+02', '3636320400', 7200, '1'),
(17, '+00', '3655069200', 0, '0'),
(17, '+02', '3668374800', 7200, '1'),
(17, '+00', '3686518800', 0, '0'),
(17, '+02', '3699824400', 7200, '1'),
(17, '+00', '3717968400', 0, '0'),
(17, '+02', '3731274000', 7200, '1'),
(17, '+00', '3750022800', 0, '0'),
(17, '+02', '3762723600', 7200, '1'),
(17, '+00', '3781472400', 0, '0'),
(17, '+02', '3794173200', 7200, '1'),
(17, '+00', '3812922000', 0, '0'),
(17, '+02', '3825622800', 7200, '1'),
(17, '+00', '3844371600', 0, '0'),
(17, '+02', '3857677200', 7200, '1'),
(17, '+00', '3875821200', 0, '0'),
(17, '+02', '3889126800', 7200, '1'),
(17, '+00', '3907270800', 0, '0'),
(17, '+02', '3920576400', 7200, '1'),
(17, '+00', '3939325200', 0, '0'),
(17, '+02', '3952026000', 7200, '1'),
(17, '+00', '3970774800', 0, '0'),
(17, '+02', '3983475600', 7200, '1'),
(17, '+00', '4002224400', 0, '0'),
(17, '+02', '4015530000', 7200, '1'),
(17, '+00', '4033674000', 0, '0'),
(17, '+02', '4046979600', 7200, '1'),
(17, '+00', '4065123600', 0, '0'),
(17, '+02', '4078429200', 7200, '1'),
(17, '+00', '4096573200', 0, '0'),
(17, '+02', '4109878800', 7200, '1'),
(17, '+00', '4128627600', 0, '0'),
(17, '+02', '4141328400', 7200, '1'),
(17, '+00', '4160077200', 0, '0'),
(17, '+02', '4172778000', 7200, '1'),
(17, '+00', '4191526800', 0, '0'),
(17, '+02', '4204227600', 7200, '1'),
(17, '+00', '4222976400', 0, '0'),
(17, '+02', '4236282000', 7200, '1'),
(17, '+00', '4254426000', 0, '0'),
(17, '+02', '4267731600', 7200, '1'),
(17, '+00', '4285875600', 0, '0'),
(17, '+02', '4299181200', 7200, '1'),
(17, '+00', '4317930000', 0, '0'),
(17, '+02', '4330630800', 7200, '1'),
(17, '+00', '4349379600', 0, '0'),
(17, '+02', '4362080400', 7200, '1'),
(17, '+00', '4380829200', 0, '0'),
(17, '+02', '4394134800', 7200, '1'),
(17, '+00', '4412278800', 0, '0'),
(17, '+02', '4425584400', 7200, '1'),
(17, '+00', '4443728400', 0, '0'),
(17, '+02', '4457034000', 7200, '1'),
(17, '+00', '4475178000', 0, '0'),
(17, '+02', '4488483600', 7200, '1'),
(17, '+00', '4507232400', 0, '0'),
(17, '+02', '4519933200', 7200, '1'),
(17, '+00', '4538682000', 0, '0'),
(17, '+02', '4551382800', 7200, '1'),
(17, '+00', '4570131600', 0, '0'),
(17, '+02', '4583437200', 7200, '1'),
(17, '+00', '4601581200', 0, '0'),
(17, '+02', '4614886800', 7200, '1'),
(17, '+00', '4633030800', 0, '0'),
(17, '+02', '4646336400', 7200, '1'),
(17, '+00', '4665085200', 0, '0'),
(17, '+02', '4677786000', 7200, '1'),
(17, '+00', '4696534800', 0, '0'),
(17, '+02', '4709235600', 7200, '1'),
(17, '+00', '4727984400', 0, '0'),
(17, '+02', '4741290000', 7200, '1'),
(17, '+00', '4759434000', 0, '0'),
(17, '+02', '4772739600', 7200, '1'),
(17, '+00', '4790883600', 0, '0'),
(17, '+02', '4804189200', 7200, '1'),
(17, '+00', '4822333200', 0, '0'),
(17, '+02', '4835638800', 7200, '1'),
(17, '+00', '4854387600', 0, '0'),
(17, '+02', '4867088400', 7200, '1'),
(17, '+00', '4885837200', 0, '0'),
(17, '+02', '4898538000', 7200, '1'),
(17, '+00', '4917286800', 0, '0'),
(17, '+02', '4930592400', 7200, '1'),
(17, '+00', '4948736400', 0, '0'),
(17, '+02', '4962042000', 7200, '1'),
(17, '+00', '4980186000', 0, '0'),
(17, '+02', '4993491600', 7200, '1'),
(17, '+00', '5012240400', 0, '0'),
(17, '+02', '5024941200', 7200, '1'),
(17, '+00', '5043690000', 0, '0'),
(17, '+02', '5056390800', 7200, '1'),
(17, '+00', '5075139600', 0, '0'),
(17, '+02', '5087840400', 7200, '1'),
(17, '+00', '5106589200', 0, '0'),
(17, '+02', '5119894800', 7200, '1'),
(17, '+00', '5138038800', 0, '0'),
(17, '+02', '5151344400', 7200, '1'),
(17, '+00', '5169488400', 0, '0'),
(17, '+02', '5182794000', 7200, '1'),
(17, '+00', '5201542800', 0, '0'),
(17, '+02', '5214243600', 7200, '1'),
(17, '+00', '5232992400', 0, '0'),
(17, '+02', '5245693200', 7200, '1'),
(17, '+00', '5264442000', 0, '0'),
(17, '+02', '5277747600', 7200, '1'),
(17, '+00', '5295891600', 0, '0'),
(17, '+02', '5309197200', 7200, '1'),
(17, '+00', '5327341200', 0, '0'),
(17, '+02', '5340646800', 7200, '1'),
(17, '+00', '5358790800', 0, '0'),
(17, '+02', '5372096400', 7200, '1'),
(17, '+00', '5390845200', 0, '0'),
(17, '+02', '5403546000', 7200, '1'),
(17, '+00', '5422294800', 0, '0'),
(17, '+02', '5434995600', 7200, '1'),
(17, '+00', '5453744400', 0, '0'),
(17, '+02', '5467050000', 7200, '1'),
(17, '+00', '5485194000', 0, '0'),
(17, '+02', '5498499600', 7200, '1'),
(17, '+00', '5516643600', 0, '0'),
(17, '+02', '5529949200', 7200, '1'),
(17, '+00', '5548698000', 0, '0'),
(17, '+02', '5561398800', 7200, '1'),
(17, '+00', '5580147600', 0, '0'),
(17, '+02', '5592848400', 7200, '1'),
(17, '+00', '5611597200', 0, '0'),
(17, '+02', '5624902800', 7200, '1'),
(17, '+00', '5643046800', 0, '0'),
(17, '+02', '5656352400', 7200, '1'),
(17, '+00', '5674496400', 0, '0'),
(17, '+02', '5687802000', 7200, '1'),
(17, '+00', '5705946000', 0, '0'),
(17, '+02', '5719251600', 7200, '1'),
(17, '+00', '5738000400', 0, '0'),
(17, '+02', '5750701200', 7200, '1'),
(17, '+00', '5769450000', 0, '0'),
(17, '+02', '5782150800', 7200, '1'),
(17, '+00', '5800899600', 0, '0'),
(17, '+02', '5814205200', 7200, '1'),
(17, '+00', '5832349200', 0, '0'),
(17, '+02', '5845654800', 7200, '1'),
(17, '+00', '5863798800', 0, '0'),
(17, '+02', '5877104400', 7200, '1'),
(17, '+00', '5895853200', 0, '0'),
(17, '+02', '5908554000', 7200, '1'),
(17, '+00', '5927302800', 0, '0'),
(17, '+02', '5940003600', 7200, '1'),
(17, '+00', '5958752400', 0, '0'),
(17, '+02', '5971453200', 7200, '1'),
(17, '+00', '5990202000', 0, '0'),
(17, '+02', '6003507600', 7200, '1'),
(17, '+00', '6021651600', 0, '0'),
(17, '+02', '6034957200', 7200, '1'),
(17, '+00', '6053101200', 0, '0'),
(17, '+02', '6066406800', 7200, '1'),
(17, '+00', '6085155600', 0, '0'),
(17, '+02', '6097856400', 7200, '1'),
(17, '+00', '6116605200', 0, '0'),
(17, '+02', '6129306000', 7200, '1'),
(17, '+00', '6148054800', 0, '0'),
(17, '+02', '6161360400', 7200, '1'),
(17, '+00', '6179504400', 0, '0'),
(17, '+02', '6192810000', 7200, '1'),
(17, '+00', '6210954000', 0, '0'),
(17, '+02', '6224259600', 7200, '1'),
(17, '+00', '6242403600', 0, '0'),
(17, '+02', '6255709200', 7200, '1'),
(17, '+00', '6274458000', 0, '0'),
(17, '+02', '6287158800', 7200, '1'),
(17, '+00', '6305907600', 0, '0'),
(17, '+02', '6318608400', 7200, '1'),
(17, '+00', '6337357200', 0, '0'),
(17, '+02', '6350662800', 7200, '1'),
(17, '+00', '6368806800', 0, '0'),
(17, '+02', '6382112400', 7200, '1'),
(17, '+00', '6400256400', 0, '0'),
(17, '+02', '6413562000', 7200, '1'),
(17, '+00', '6432310800', 0, '0'),
(17, '+02', '6445011600', 7200, '1'),
(17, '+00', '6463760400', 0, '0'),
(17, '+02', '6476461200', 7200, '1'),
(17, '+00', '6495210000', 0, '0'),
(17, '+02', '6508515600', 7200, '1'),
(17, '+00', '6526659600', 0, '0'),
(17, '+02', '6539965200', 7200, '1'),
(17, '+00', '6558109200', 0, '0'),
(17, '+02', '6571414800', 7200, '1'),
(17, '+00', '6589558800', 0, '0'),
(17, '+02', '6602864400', 7200, '1'),
(17, '+00', '6621613200', 0, '0'),
(17, '+02', '6634314000', 7200, '1'),
(17, '+00', '6653062800', 0, '0'),
(17, '+02', '6665763600', 7200, '1'),
(17, '+00', '6684512400', 0, '0'),
(17, '+02', '6697818000', 7200, '1'),
(17, '+00', '6715962000', 0, '0'),
(17, '+02', '6729267600', 7200, '1'),
(17, '+00', '6747411600', 0, '0'),
(17, '+02', '6760717200', 7200, '1'),
(17, '+00', '6779466000', 0, '0'),
(17, '+02', '6792166800', 7200, '1'),
(17, '+00', '6810915600', 0, '0'),
(17, '+02', '6823616400', 7200, '1'),
(17, '+00', '6842365200', 0, '0'),
(17, '+02', '6855066000', 7200, '1'),
(17, '+00', '6873814800', 0, '0'),
(17, '+02', '6887120400', 7200, '1'),
(17, '+00', '6905264400', 0, '0'),
(17, '+02', '6918570000', 7200, '1'),
(17, '+00', '6936714000', 0, '0'),
(17, '+02', '6950019600', 7200, '1'),
(17, '+00', '6968768400', 0, '0'),
(17, '+02', '6981469200', 7200, '1'),
(17, '+00', '7000218000', 0, '0'),
(17, '+02', '7012918800', 7200, '1'),
(17, '+00', '7031667600', 0, '0'),
(17, '+02', '7044973200', 7200, '1'),
(17, '+00', '7063117200', 0, '0'),
(17, '+02', '7076422800', 7200, '1'),
(17, '+00', '7094566800', 0, '0'),
(17, '+02', '7107872400', 7200, '1'),
(17, '+00', '7126016400', 0, '0'),
(17, '+02', '7139322000', 7200, '1'),
(17, '+00', '7158070800', 0, '0'),
(17, '+02', '7170771600', 7200, '1'),
(17, '+00', '7189520400', 0, '0'),
(17, '+02', '7202221200', 7200, '1'),
(17, '+00', '7220970000', 0, '0'),
(17, '+02', '7234275600', 7200, '1'),
(17, '+00', '7252419600', 0, '0'),
(17, '+02', '7265725200', 7200, '1'),
(17, '+00', '7283869200', 0, '0'),
(17, '+02', '7297174800', 7200, '1'),
(17, '+00', '7315318800', 0, '0'),
(17, '+02', '7328624400', 7200, '1'),
(17, '+00', '7347373200', 0, '0'),
(17, '+02', '7360074000', 7200, '1'),
(17, '+00', '7378822800', 0, '0'),
(17, '+02', '7391523600', 7200, '1'),
(17, '+00', '7410272400', 0, '0'),
(17, '+02', '7423578000', 7200, '1'),
(17, '+00', '7441722000', 0, '0'),
(17, '+02', '7455027600', 7200, '1'),
(17, '+00', '7473171600', 0, '0'),
(17, '+02', '7486477200', 7200, '1'),
(17, '+00', '7504621200', 0, '0'),
(17, '+02', '7517926800', 7200, '1'),
(17, '+00', '7536675600', 0, '0'),
(17, '+02', '7549376400', 7200, '1'),
(17, '+00', '7568125200', 0, '0'),
(17, '+02', '7580826000', 7200, '1'),
(17, '+00', '7599574800', 0, '0'),
(17, '+02', '7612880400', 7200, '1'),
(17, '+00', '7631024400', 0, '0'),
(17, '+02', '7644330000', 7200, '1'),
(17, '+00', '7662474000', 0, '0'),
(17, '+02', '7675779600', 7200, '1'),
(17, '+00', '7694528400', 0, '0'),
(17, '+02', '7707229200', 7200, '1'),
(17, '+00', '7725978000', 0, '0'),
(17, '+02', '7738678800', 7200, '1'),
(17, '+00', '7757427600', 0, '0'),
(17, '+02', '7770733200', 7200, '1'),
(17, '+00', '7788877200', 0, '0'),
(17, '+02', '7802182800', 7200, '1'),
(17, '+00', '7820326800', 0, '0'),
(17, '+02', '7833632400', 7200, '1'),
(17, '+00', '7851776400', 0, '0'),
(17, '+02', '7865082000', 7200, '1'),
(17, '+00', '7883830800', 0, '0'),
(17, '+02', '7896531600', 7200, '1'),
(17, '+00', '7915280400', 0, '0'),
(17, '+02', '7927981200', 7200, '1'),
(17, '+00', '7946730000', 0, '0'),
(17, '+02', '7960035600', 7200, '1'),
(17, '+00', '7978179600', 0, '0'),
(17, '+02', '7991485200', 7200, '1'),
(17, '+00', '8009629200', 0, '0'),
(17, '+02', '8022934800', 7200, '1'),
(17, '+00', '8041683600', 0, '0'),
(17, '+02', '8054384400', 7200, '1'),
(17, '+00', '8073133200', 0, '0'),
(17, '+02', '8085834000', 7200, '1'),
(17, '+00', '8104582800', 0, '0'),
(17, '+02', '8117283600', 7200, '1'),
(17, '+00', '8136032400', 0, '0'),
(17, '+02', '8149338000', 7200, '1'),
(17, '+00', '8167482000', 0, '0'),
(17, '+02', '8180787600', 7200, '1'),
(17, '+00', '8198931600', 0, '0'),
(17, '+02', '8212237200', 7200, '1'),
(17, '+00', '8230986000', 0, '0'),
(17, '+02', '8243686800', 7200, '1'),
(17, '+00', '8262435600', 0, '0'),
(17, '+02', '8275136400', 7200, '1'),
(17, '+00', '8293885200', 0, '0'),
(17, '+02', '8307190800', 7200, '1'),
(17, '+00', '8325334800', 0, '0'),
(17, '+02', '8338640400', 7200, '1'),
(17, '+00', '8356784400', 0, '0'),
(17, '+02', '8370090000', 7200, '1'),
(17, '+00', '8388234000', 0, '0'),
(17, '+02', '8401539600', 7200, '1'),
(17, '+00', '8420288400', 0, '0'),
(17, '+02', '8432989200', 7200, '1'),
(17, '+00', '8451738000', 0, '0'),
(17, '+02', '8464438800', 7200, '1'),
(17, '+00', '8483187600', 0, '0'),
(17, '+02', '8496493200', 7200, '1'),
(17, '+00', '8514637200', 0, '0'),
(17, '+02', '8527942800', 7200, '1'),
(17, '+00', '8546086800', 0, '0'),
(17, '+02', '8559392400', 7200, '1'),
(17, '+00', '8578141200', 0, '0'),
(17, '+02', '8590842000', 7200, '1'),
(17, '+00', '8609590800', 0, '0'),
(17, '+02', '8622291600', 7200, '1'),
(17, '+00', '8641040400', 0, '0'),
(17, '+02', '8654346000', 7200, '1'),
(17, '+00', '8672490000', 0, '0'),
(17, '+02', '8685795600', 7200, '1'),
(17, '+00', '8703939600', 0, '0'),
(17, '+02', '8717245200', 7200, '1'),
(17, '+00', '8735389200', 0, '0'),
(17, '+02', '8748694800', 7200, '1'),
(17, '+00', '8767443600', 0, '0'),
(17, '+02', '8780144400', 7200, '1'),
(17, '+00', '8798893200', 0, '0'),
(17, '+02', '8811594000', 7200, '1'),
(17, '+00', '8830342800', 0, '0'),
(17, '+02', '8843648400', 7200, '1'),
(17, '+00', '8861792400', 0, '0'),
(17, '+02', '8875098000', 7200, '1'),
(17, '+00', '8893242000', 0, '0'),
(17, '+02', '8906547600', 7200, '1'),
(17, '+00', '8925296400', 0, '0'),
(17, '+02', '8937997200', 7200, '1'),
(17, '+00', '8956746000', 0, '0'),
(17, '+02', '8969446800', 7200, '1'),
(17, '+00', '8988195600', 0, '0'),
(17, '+02', '9000896400', 7200, '1'),
(17, '+00', '9019645200', 0, '0'),
(17, '+02', '9032950800', 7200, '1'),
(17, '+00', '9051094800', 0, '0'),
(17, '+02', '9064400400', 7200, '1'),
(17, '+00', '9082544400', 0, '0'),
(17, '+02', '9095850000', 7200, '1'),
(17, '+00', '9114598800', 0, '0'),
(17, '+02', '9127299600', 7200, '1'),
(17, '+00', '9146048400', 0, '0'),
(17, '+02', '9158749200', 7200, '1'),
(17, '+00', '9177498000', 0, '0'),
(17, '+02', '9190803600', 7200, '1'),
(17, '+00', '9208947600', 0, '0'),
(17, '+02', '9222253200', 7200, '1'),
(17, '+00', '9240397200', 0, '0'),
(17, '+02', '9253702800', 7200, '1'),
(17, '+00', '9271846800', 0, '0'),
(17, '+02', '9285152400', 7200, '1'),
(17, '+00', '9303901200', 0, '0'),
(17, '+02', '9316602000', 7200, '1'),
(17, '+00', '9335350800', 0, '0'),
(17, '+02', '9348051600', 7200, '1'),
(17, '+00', '9366800400', 0, '0'),
(17, '+02', '9380106000', 7200, '1'),
(17, '+00', '9398250000', 0, '0'),
(17, '+02', '9411555600', 7200, '1'),
(17, '+00', '9429699600', 0, '0'),
(17, '+02', '9443005200', 7200, '1'),
(17, '+00', '9461754000', 0, '0'),
(17, '+02', '9474454800', 7200, '1'),
(17, '+00', '9493203600', 0, '0'),
(17, '+02', '9505904400', 7200, '1'),
(17, '+00', '9524653200', 0, '0'),
(17, '+02', '9537958800', 7200, '1'),
(17, '+00', '9556102800', 0, '0'),
(17, '+02', '9569408400', 7200, '1'),
(17, '+00', '9587552400', 0, '0'),
(17, '+02', '9600858000', 7200, '1'),
(17, '+00', '9619002000', 0, '0'),
(17, '+02', '9632307600', 7200, '1'),
(17, '+00', '9651056400', 0, '0'),
(17, '+02', '9663757200', 7200, '1'),
(17, '+00', '9682506000', 0, '0'),
(17, '+02', '9695206800', 7200, '1'),
(17, '+00', '9713955600', 0, '0'),
(17, '+02', '9727261200', 7200, '1'),
(17, '+00', '9745405200', 0, '0'),
(17, '+02', '9758710800', 7200, '1'),
(17, '+00', '9776854800', 0, '0'),
(17, '+02', '9790160400', 7200, '1'),
(17, '+00', '9808909200', 0, '0'),
(17, '+02', '9821610000', 7200, '1'),
(17, '+00', '9840358800', 0, '0'),
(17, '+02', '9853059600', 7200, '1'),
(17, '+00', '9871808400', 0, '0'),
(17, '+02', '9884509200', 7200, '1'),
(17, '+00', '9903258000', 0, '0'),
(17, '+02', '9916563600', 7200, '1'),
(17, '+00', '9934707600', 0, '0'),
(17, '+02', '9948013200', 7200, '1'),
(17, '+00', '9966157200', 0, '0'),
(17, '+02', '9979462800', 7200, '1'),
(17, '+00', '9998211600', 0, '0'),
(17, '+02', '10010912400', 7200, '1'),
(17, '+00', '10029661200', 0, '0'),
(17, '+02', '10042362000', 7200, '1'),
(17, '+00', '10061110800', 0, '0'),
(17, '+02', '10074416400', 7200, '1'),
(17, '+00', '10092560400', 0, '0'),
(17, '+02', '10105866000', 7200, '1'),
(17, '+00', '10124010000', 0, '0'),
(17, '+02', '10137315600', 7200, '1'),
(17, '+00', '10155459600', 0, '0'),
(17, '+02', '10168765200', 7200, '1'),
(17, '+00', '10187514000', 0, '0'),
(17, '+02', '10200214800', 7200, '1'),
(17, '+00', '10218963600', 0, '0'),
(17, '+02', '10231664400', 7200, '1'),
(17, '+00', '10250413200', 0, '0'),
(17, '+02', '10263718800', 7200, '1'),
(17, '+00', '10281862800', 0, '0'),
(17, '+02', '10295168400', 7200, '1'),
(17, '+00', '10313312400', 0, '0'),
(17, '+02', '10326618000', 7200, '1'),
(17, '+00', '10345366800', 0, '0'),
(17, '+02', '10358067600', 7200, '1'),
(17, '+00', '10376816400', 0, '0'),
(17, '+02', '10389517200', 7200, '1'),
(17, '+00', '10408266000', 0, '0'),
(17, '+02', '10420966800', 7200, '1'),
(17, '+00', '10439715600', 0, '0'),
(17, '+02', '10453021200', 7200, '1'),
(17, '+00', '10471165200', 0, '0'),
(17, '+02', '10484470800', 7200, '1'),
(17, '+00', '10502614800', 0, '0'),
(17, '+02', '10515920400', 7200, '1'),
(17, '+00', '10534064400', 0, '0'),
(17, '+02', '10547370000', 7200, '1'),
(17, '+00', '10566118800', 0, '0'),
(17, '+02', '10578819600', 7200, '1'),
(17, '+00', '10597568400', 0, '0'),
(17, '+02', '10610269200', 7200, '1'),
(17, '+00', '10629018000', 0, '0'),
(17, '+02', '10642323600', 7200, '1'),
(17, '+00', '10660467600', 0, '0'),
(17, '+02', '10673773200', 7200, '1'),
(17, '+00', '10691917200', 0, '0'),
(17, '+02', '10705222800', 7200, '1'),
(17, '+00', '10723971600', 0, '0'),
(17, '+02', '10736672400', 7200, '1'),
(17, '+00', '10755421200', 0, '0'),
(17, '+02', '10768122000', 7200, '1'),
(17, '+00', '10786870800', 0, '0'),
(17, '+02', '10800176400', 7200, '1'),
(17, '+00', '10818320400', 0, '0'),
(17, '+02', '10831626000', 7200, '1'),
(17, '+00', '10849770000', 0, '0'),
(17, '+02', '10863075600', 7200, '1'),
(17, '+00', '10881219600', 0, '0'),
(17, '+02', '10894525200', 7200, '1'),
(17, '+00', '10913274000', 0, '0'),
(17, '+02', '10925974800', 7200, '1'),
(17, '+00', '10944723600', 0, '0'),
(17, '+02', '10957424400', 7200, '1'),
(17, '+00', '10976173200', 0, '0'),
(17, '+02', '10989478800', 7200, '1'),
(17, '+00', '11007622800', 0, '0'),
(17, '+02', '11020928400', 7200, '1'),
(17, '+00', '11039072400', 0, '0'),
(17, '+02', '11052378000', 7200, '1'),
(17, '+00', '11071126800', 0, '0'),
(17, '+02', '11083827600', 7200, '1'),
(17, '+00', '11102576400', 0, '0'),
(17, '+02', '11115277200', 7200, '1'),
(17, '+00', '11134026000', 0, '0'),
(17, '+02', '11146726800', 7200, '1'),
(17, '+00', '11165475600', 0, '0'),
(17, '+02', '11178781200', 7200, '1'),
(17, '+00', '11196925200', 0, '0'),
(17, '+02', '11210230800', 7200, '1'),
(17, '+00', '11228374800', 0, '0'),
(17, '+02', '11241680400', 7200, '1'),
(17, '+00', '11260429200', 0, '0'),
(17, '+02', '11273130000', 7200, '1'),
(17, '+00', '11291878800', 0, '0'),
(17, '+02', '11304579600', 7200, '1'),
(17, '+00', '11323328400', 0, '0'),
(17, '+02', '11336634000', 7200, '1'),
(17, '+00', '11354778000', 0, '0'),
(17, '+02', '11368083600', 7200, '1'),
(17, '+00', '11386227600', 0, '0'),
(17, '+02', '11399533200', 7200, '1'),
(17, '+00', '11417677200', 0, '0'),
(17, '+02', '11430982800', 7200, '1'),
(17, '+00', '11449731600', 0, '0'),
(17, '+02', '11462432400', 7200, '1'),
(17, '+00', '11481181200', 0, '0'),
(17, '+02', '11493882000', 7200, '1'),
(17, '+00', '11512630800', 0, '0'),
(17, '+02', '11525936400', 7200, '1'),
(17, '+00', '11544080400', 0, '0'),
(17, '+02', '11557386000', 7200, '1'),
(17, '+00', '11575530000', 0, '0'),
(17, '+02', '11588835600', 7200, '1'),
(17, '+00', '11607584400', 0, '0'),
(17, '+02', '11620285200', 7200, '1'),
(17, '+00', '11639034000', 0, '0'),
(17, '+02', '11651734800', 7200, '1'),
(17, '+00', '11670483600', 0, '0'),
(17, '+02', '11683789200', 7200, '1'),
(17, '+00', '11701933200', 0, '0'),
(17, '+02', '11715238800', 7200, '1'),
(17, '+00', '11733382800', 0, '0'),
(17, '+02', '11746688400', 7200, '1'),
(17, '+00', '11764832400', 0, '0'),
(17, '+02', '11778138000', 7200, '1'),
(17, '+00', '11796886800', 0, '0'),
(17, '+02', '11809587600', 7200, '1'),
(17, '+00', '11828336400', 0, '0'),
(17, '+02', '11841037200', 7200, '1'),
(17, '+00', '11859786000', 0, '0'),
(17, '+02', '11873091600', 7200, '1'),
(17, '+00', '11891235600', 0, '0'),
(17, '+02', '11904541200', 7200, '1'),
(17, '+00', '11922685200', 0, '0'),
(17, '+02', '11935990800', 7200, '1'),
(17, '+00', '11954739600', 0, '0'),
(17, '+02', '11967440400', 7200, '1'),
(17, '+00', '11986189200', 0, '0'),
(17, '+02', '11998890000', 7200, '1'),
(17, '+00', '12017638800', 0, '0'),
(17, '+02', '12030339600', 7200, '1'),
(17, '+00', '12049088400', 0, '0'),
(17, '+02', '12062394000', 7200, '1'),
(17, '+00', '12080538000', 0, '0'),
(17, '+02', '12093843600', 7200, '1'),
(17, '+00', '12111987600', 0, '0'),
(17, '+02', '12125293200', 7200, '1'),
(17, '+00', '12144042000', 0, '0'),
(17, '+02', '12156742800', 7200, '1'),
(17, '+00', '12175491600', 0, '0'),
(17, '+02', '12188192400', 7200, '1'),
(17, '+00', '12206941200', 0, '0'),
(17, '+02', '12220246800', 7200, '1'),
(17, '+00', '12238390800', 0, '0'),
(17, '+02', '12251696400', 7200, '1'),
(17, '+00', '12269840400', 0, '0'),
(17, '+02', '12283146000', 7200, '1'),
(17, '+00', '12301290000', 0, '0'),
(17, '+02', '12314595600', 7200, '1'),
(17, '+00', '12333344400', 0, '0'),
(17, '+02', '12346045200', 7200, '1'),
(17, '+00', '12364794000', 0, '0'),
(17, '+02', '12377494800', 7200, '1'),
(17, '+00', '12396243600', 0, '0'),
(17, '+02', '12409549200', 7200, '1'),
(17, '+00', '12427693200', 0, '0'),
(17, '+02', '12440998800', 7200, '1'),
(17, '+00', '12459142800', 0, '0'),
(17, '+02', '12472448400', 7200, '1'),
(17, '+00', '12491197200', 0, '0'),
(17, '+02', '12503898000', 7200, '1'),
(17, '+00', '12522646800', 0, '0'),
(17, '+02', '12535347600', 7200, '1'),
(17, '+00', '12554096400', 0, '0'),
(17, '+02', '12567402000', 7200, '1'),
(17, '+00', '12585546000', 0, '0'),
(17, '+02', '12598851600', 7200, '1'),
(17, '+00', '12616995600', 0, '0'),
(17, '+02', '12630301200', 7200, '1'),
(17, '+00', '12648445200', 0, '0'),
(17, '+02', '12661750800', 7200, '1'),
(17, '+00', '12680499600', 0, '0'),
(17, '+02', '12693200400', 7200, '1'),
(17, '+00', '12711949200', 0, '0'),
(17, '+02', '12724650000', 7200, '1'),
(17, '+00', '12743398800', 0, '0'),
(17, '+02', '12756704400', 7200, '1'),
(17, '+00', '12774848400', 0, '0'),
(17, '+02', '12788154000', 7200, '1'),
(17, '+00', '12806298000', 0, '0'),
(17, '+02', '12819603600', 7200, '1'),
(17, '+00', '12838352400', 0, '0'),
(17, '+02', '12851053200', 7200, '1'),
(17, '+00', '12869802000', 0, '0'),
(17, '+02', '12882502800', 7200, '1'),
(17, '+00', '12901251600', 0, '0'),
(17, '+02', '12913952400', 7200, '1'),
(17, '+00', '12932701200', 0, '0'),
(17, '+02', '12946006800', 7200, '1'),
(17, '+00', '12964150800', 0, '0'),
(17, '+02', '12977456400', 7200, '1'),
(17, '+00', '12995600400', 0, '0'),
(17, '+02', '13008906000', 7200, '1'),
(17, '+00', '13027654800', 0, '0'),
(17, '+02', '13040355600', 7200, '1'),
(17, '+00', '13059104400', 0, '0'),
(17, '+02', '13071805200', 7200, '1'),
(17, '+00', '13090554000', 0, '0'),
(17, '+02', '13103859600', 7200, '1'),
(17, '+00', '13122003600', 0, '0'),
(17, '+02', '13135309200', 7200, '1'),
(17, '+00', '13153453200', 0, '0'),
(17, '+02', '13166758800', 7200, '1'),
(17, '+00', '13184902800', 0, '0'),
(17, '+02', '13198208400', 7200, '1'),
(17, '+00', '13216957200', 0, '0'),
(17, '+02', '13229658000', 7200, '1'),
(17, '+00', '13248406800', 0, '0'),
(17, '+02', '13261107600', 7200, '1'),
(17, '+00', '13279856400', 0, '0'),
(17, '+02', '13293162000', 7200, '1'),
(17, '+00', '13311306000', 0, '0'),
(17, '+02', '13324611600', 7200, '1'),
(17, '+00', '13342755600', 0, '0'),
(17, '+02', '13356061200', 7200, '1'),
(17, '+00', '13374810000', 0, '0'),
(17, '+02', '13387510800', 7200, '1'),
(17, '+00', '13406259600', 0, '0'),
(17, '+02', '13418960400', 7200, '1'),
(17, '+00', '13437709200', 0, '0'),
(17, '+02', '13451014800', 7200, '1'),
(17, '+00', '13469158800', 0, '0'),
(17, '+02', '13482464400', 7200, '1'),
(17, '+00', '13500608400', 0, '0'),
(17, '+02', '13513914000', 7200, '1'),
(17, '+00', '13532058000', 0, '0'),
(17, '+02', '13545363600', 7200, '1'),
(17, '+00', '13564112400', 0, '0'),
(17, '+02', '13576813200', 7200, '1'),
(17, '+00', '13595562000', 0, '0'),
(17, '+02', '13608262800', 7200, '1'),
(17, '+00', '13627011600', 0, '0'),
(17, '+02', '13640317200', 7200, '1'),
(17, '+00', '13658461200', 0, '0'),
(17, '+02', '13671766800', 7200, '1'),
(17, '+00', '13689910800', 0, '0'),
(17, '+02', '13703216400', 7200, '1'),
(17, '+00', '13721965200', 0, '0'),
(17, '+02', '13734666000', 7200, '1'),
(17, '+00', '13753414800', 0, '0'),
(17, '+02', '13766115600', 7200, '1'),
(17, '+00', '13784864400', 0, '0'),
(17, '+02', '13797565200', 7200, '1'),
(17, '+00', '13816314000', 0, '0'),
(17, '+02', '13829619600', 7200, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(17, '+00', '13847763600', 0, '0'),
(17, '+02', '13861069200', 7200, '1'),
(17, '+00', '13879213200', 0, '0'),
(17, '+02', '13892518800', 7200, '1'),
(17, '+00', '13911267600', 0, '0'),
(17, '+02', '13923968400', 7200, '1'),
(17, '+00', '13942717200', 0, '0'),
(17, '+02', '13955418000', 7200, '1'),
(17, '+00', '13974166800', 0, '0'),
(17, '+02', '13987472400', 7200, '1'),
(17, '+00', '14005616400', 0, '0'),
(17, '+02', '14018922000', 7200, '1'),
(17, '+00', '14037066000', 0, '0'),
(17, '+02', '14050371600', 7200, '1'),
(17, '+00', '14068515600', 0, '0'),
(17, '+02', '14081821200', 7200, '1'),
(17, '+00', '14100570000', 0, '0'),
(17, '+02', '14113270800', 7200, '1'),
(17, '+00', '14132019600', 0, '0'),
(17, '+02', '14144720400', 7200, '1'),
(17, '+00', '14163469200', 0, '0'),
(17, '+02', '14176774800', 7200, '1'),
(17, '+00', '14194918800', 0, '0'),
(17, '+02', '14208224400', 7200, '1'),
(17, '+00', '14226368400', 0, '0'),
(17, '+02', '14239674000', 7200, '1'),
(17, '+00', '14258422800', 0, '0'),
(17, '+02', '14271123600', 7200, '1'),
(17, '+00', '14289872400', 0, '0'),
(17, '+02', '14302573200', 7200, '1'),
(17, '+00', '14321322000', 0, '0'),
(17, '+02', '14334627600', 7200, '1'),
(17, '+00', '14352771600', 0, '0'),
(17, '+02', '14366077200', 7200, '1'),
(17, '+00', '14384221200', 0, '0'),
(17, '+02', '14397526800', 7200, '1'),
(17, '+00', '14415670800', 0, '0'),
(17, '+02', '14428976400', 7200, '1'),
(17, '+00', '14447725200', 0, '0'),
(17, '+02', '14460426000', 7200, '1'),
(17, '+00', '14479174800', 0, '0'),
(17, '+02', '14491875600', 7200, '1'),
(17, '+00', '14510624400', 0, '0'),
(17, '+02', '14523930000', 7200, '1'),
(17, '+00', '14542074000', 0, '0'),
(17, '+02', '14555379600', 7200, '1'),
(17, '+00', '14573523600', 0, '0'),
(17, '+02', '14586829200', 7200, '1'),
(17, '+00', '14605578000', 0, '0'),
(17, '+02', '14618278800', 7200, '1'),
(17, '+00', '14637027600', 0, '0'),
(17, '+02', '14649728400', 7200, '1'),
(17, '+00', '14668477200', 0, '0'),
(17, '+02', '14681178000', 7200, '1'),
(17, '+00', '14699926800', 0, '0'),
(17, '+02', '14713232400', 7200, '1'),
(17, '+00', '14731376400', 0, '0'),
(17, '+02', '14744682000', 7200, '1'),
(17, '+00', '14762826000', 0, '0'),
(17, '+02', '14776131600', 7200, '1'),
(17, '+00', '14794880400', 0, '0'),
(17, '+02', '14807581200', 7200, '1'),
(17, '+00', '14826330000', 0, '0'),
(17, '+02', '14839030800', 7200, '1'),
(17, '+00', '14857779600', 0, '0'),
(17, '+02', '14871085200', 7200, '1'),
(17, '+00', '14889229200', 0, '0'),
(17, '+02', '14902534800', 7200, '1'),
(17, '+00', '14920678800', 0, '0'),
(17, '+02', '14933984400', 7200, '1'),
(17, '+00', '14952128400', 0, '0'),
(17, '+02', '14965434000', 7200, '1'),
(17, '+00', '14984182800', 0, '0'),
(17, '+02', '14996883600', 7200, '1'),
(17, '+00', '15015632400', 0, '0'),
(17, '+02', '15028333200', 7200, '1'),
(17, '+00', '15047082000', 0, '0'),
(17, '+02', '15060387600', 7200, '1'),
(17, '+00', '15078531600', 0, '0'),
(17, '+02', '15091837200', 7200, '1'),
(17, '+00', '15109981200', 0, '0'),
(17, '+02', '15123286800', 7200, '1'),
(17, '+00', '15142035600', 0, '0'),
(17, '+02', '15154736400', 7200, '1'),
(17, '+00', '15173485200', 0, '0'),
(17, '+02', '15186186000', 7200, '1'),
(17, '+00', '15204934800', 0, '0'),
(17, '+02', '15218240400', 7200, '1'),
(17, '+00', '15236384400', 0, '0'),
(17, '+02', '15249690000', 7200, '1'),
(17, '+00', '15267834000', 0, '0'),
(17, '+02', '15281139600', 7200, '1'),
(17, '+00', '15299283600', 0, '0'),
(17, '+02', '15312589200', 7200, '1'),
(17, '+00', '15331338000', 0, '0'),
(17, '+02', '15344038800', 7200, '1'),
(17, '+00', '15362787600', 0, '0'),
(17, '+02', '15375488400', 7200, '1'),
(17, '+00', '15394237200', 0, '0'),
(17, '+02', '15407542800', 7200, '1'),
(17, '+00', '15425686800', 0, '0'),
(17, '+02', '15438992400', 7200, '1'),
(17, '+00', '15457136400', 0, '0'),
(17, '+02', '15470442000', 7200, '1'),
(17, '+00', '15489190800', 0, '0'),
(17, '+02', '15501891600', 7200, '1'),
(17, '+00', '15520640400', 0, '0'),
(17, '+02', '15533341200', 7200, '1'),
(17, '+00', '15552090000', 0, '0'),
(17, '+02', '15564790800', 7200, '1'),
(17, '+00', '15583539600', 0, '0'),
(17, '+02', '15596845200', 7200, '1'),
(17, '+00', '15614989200', 0, '0'),
(17, '+02', '15628294800', 7200, '1'),
(17, '+00', '15646438800', 0, '0'),
(17, '+02', '15659744400', 7200, '1'),
(17, '+00', '15678493200', 0, '0'),
(17, '+02', '15691194000', 7200, '1'),
(17, '+00', '15709942800', 0, '0'),
(17, '+02', '15722643600', 7200, '1'),
(17, '+00', '15741392400', 0, '0'),
(17, '+02', '15754698000', 7200, '1'),
(17, '+00', '15772842000', 0, '0'),
(17, '+02', '15786147600', 7200, '1'),
(17, '+00', '15804291600', 0, '0'),
(17, '+02', '15817597200', 7200, '1'),
(17, '+00', '15835741200', 0, '0'),
(17, '+02', '15849046800', 7200, '1'),
(17, '+00', '15867795600', 0, '0'),
(17, '+02', '15880496400', 7200, '1'),
(17, '+00', '15899245200', 0, '0'),
(17, '+02', '15911946000', 7200, '1'),
(17, '+00', '15930694800', 0, '0'),
(17, '+02', '15944000400', 7200, '1'),
(17, '+00', '15962144400', 0, '0'),
(17, '+02', '15975450000', 7200, '1'),
(17, '+00', '15993594000', 0, '0'),
(17, '+02', '16006899600', 7200, '1'),

(17, '+00', '16025648400', 0, '0'),
(17, '+02', '16038349200', 7200, '1'),
(17, '+00', '16057098000', 0, '0'),
(17, '+02', '16069798800', 7200, '1'),
(17, '+00', '16088547600', 0, '0'),
(17, '+02', '16101853200', 7200, '1'),
(17, '+00', '16119997200', 0, '0'),
(17, '+02', '16133302800', 7200, '1'),
(17, '+00', '16151446800', 0, '0'),
(17, '+02', '16164752400', 7200, '1'),
(17, '+00', '16182896400', 0, '0'),
(17, '+02', '16196202000', 7200, '1'),
(17, '+00', '16214950800', 0, '0'),
(17, '+02', '16227651600', 7200, '1'),
(17, '+00', '16246400400', 0, '0'),
(17, '+02', '16259101200', 7200, '1'),
(17, '+00', '16277850000', 0, '0'),
(17, '+02', '16291155600', 7200, '1'),
(17, '+00', '16309299600', 0, '0'),
(17, '+02', '16322605200', 7200, '1'),
(17, '+00', '16340749200', 0, '0'),
(17, '+02', '16354054800', 7200, '1'),
(17, '+00', '16372803600', 0, '0'),
(17, '+02', '16385504400', 7200, '1'),
(17, '+00', '16404253200', 0, '0'),
(17, '+02', '16416954000', 7200, '1'),
(17, '+00', '16435702800', 0, '0'),
(17, '+02', '16448403600', 7200, '1'),
(17, '+00', '16467152400', 0, '0'),
(17, '+02', '16480458000', 7200, '1'),
(17, '+00', '16498602000', 0, '0'),
(17, '+02', '16511907600', 7200, '1'),
(17, '+00', '16530051600', 0, '0'),
(17, '+02', '16543357200', 7200, '1'),
(17, '+00', '16562106000', 0, '0'),
(17, '+02', '16574806800', 7200, '1'),
(17, '+00', '16593555600', 0, '0'),
(17, '+02', '16606256400', 7200, '1'),
(17, '+00', '16625005200', 0, '0'),
(17, '+02', '16638310800', 7200, '1'),
(17, '+00', '16656454800', 0, '0'),
(17, '+02', '16669760400', 7200, '1'),
(17, '+00', '16687904400', 0, '0'),
(17, '+02', '16701210000', 7200, '1'),
(17, '+00', '16719354000', 0, '0'),
(18, '+06', '-380073600', 21600, '0'),
(19, 'LMT', '-2372097973', -14028, '0'),
(19, 'CMT', '-2372097972', -15408, '0'),
(19, '-04', '-1567453392', -14400, '0'),
(19, '-03', '-1233432000', -10800, '1'),
(19, '-04', '-1222981200', -14400, '0'),
(19, '-03', '-1205956800', -10800, '1'),
(19, '-04', '-1194037200', -14400, '0'),
(19, '-03', '-1172865600', -10800, '1'),
(19, '-04', '-1162501200', -14400, '0'),
(19, '-03', '-1141329600', -10800, '1'),
(19, '-04', '-1130965200', -14400, '0'),
(19, '-03', '-1109793600', -10800, '1'),
(19, '-04', '-1099429200', -14400, '0'),
(19, '-03', '-1078257600', -10800, '1'),
(19, '-04', '-1067806800', -14400, '0'),
(19, '-03', '-1046635200', -10800, '1'),
(19, '-04', '-1036270800', -14400, '0'),
(19, '-03', '-1015099200', -10800, '1'),
(19, '-04', '-1004734800', -14400, '0'),
(19, '-03', '-983563200', -10800, '1'),
(19, '-04', '-973198800', -14400, '0'),
(19, '-03', '-952027200', -10800, '1'),
(19, '-04', '-941576400', -14400, '0'),
(19, '-03', '-931032000', -10800, '1'),
(19, '-04', '-900882000', -14400, '0'),
(19, '-03', '-890337600', -10800, '1'),
(19, '-04', '-833749200', -14400, '0'),
(19, '-03', '-827265600', -10800, '1'),
(19, '-04', '-752274000', -14400, '0'),
(19, '-03', '-733780800', -10800, '1'),
(19, '-04', '-197326800', -14400, '0'),
(19, '-03', '-190843200', -10800, '1'),
(19, '-04', '-184194000', -14400, '0'),
(19, '-03', '-164491200', -10800, '1'),
(19, '-04', '-152658000', -14400, '0'),
(19, '-03', '-132955200', -10800, '1'),
(19, '-04', '-121122000', -14400, '0'),
(19, '-03', '-101419200', -10800, '1'),
(19, '-04', '-86821200', -14400, '0'),
(19, '-03', '-71092800', -10800, '1'),
(19, '-04', '-54766800', -14400, '0'),
(19, '-03', '-39038400', -10800, '1'),
(19, '-04', '-23317200', -14400, '0'),
(19, '-03', '-7588800', -10800, '0'),
(19, '-02', '128142000', -7200, '1'),
(19, '-03', '136605600', -10800, '0'),
(19, '-02', '596948400', -7200, '1'),
(19, '-03', '605066400', -10800, '0'),
(19, '-02', '624423600', -7200, '1'),
(19, '-03', '636516000', -10800, '0'),
(19, '-02', '656478000', -7200, '1'),
(19, '-03', '667965600', -10800, '0'),
(19, '-02', '687927600', -7200, '1'),
(19, '-03', '699415200', -10800, '0'),
(19, '-02', '719377200', -7200, '1'),
(19, '-03', '731469600', -10800, '0'),
(19, '-02', '1198983600', -7200, '1'),
(19, '-03', '1205632800', -10800, '0'),
(19, '-02', '1224385200', -7200, '1'),
(19, '-03', '1237082400', -10800, '0'),
(20, 'LMT', '-2372096593', -15408, '0'),
(20, 'CMT', '-2372096592', -15408, '0'),
(20, '-04', '-1567453392', -14400, '0'),
(20, '-03', '-1233432000', -10800, '1'),
(20, '-04', '-1222981200', -14400, '0'),
(20, '-03', '-1205956800', -10800, '1'),
(20, '-04', '-1194037200', -14400, '0'),
(20, '-03', '-1172865600', -10800, '1'),
(20, '-04', '-1162501200', -14400, '0'),
(20, '-03', '-1141329600', -10800, '1'),
(20, '-04', '-1130965200', -14400, '0'),
(20, '-03', '-1109793600', -10800, '1'),
(20, '-04', '-1099429200', -14400, '0'),
(20, '-03', '-1078257600', -10800, '1'),
(20, '-04', '-1067806800', -14400, '0'),
(20, '-03', '-1046635200', -10800, '1'),
(20, '-04', '-1036270800', -14400, '0'),
(20, '-03', '-1015099200', -10800, '1'),
(20, '-04', '-1004734800', -14400, '0'),
(20, '-03', '-983563200', -10800, '1'),
(20, '-04', '-973198800', -14400, '0'),
(20, '-03', '-952027200', -10800, '1'),
(20, '-04', '-941576400', -14400, '0'),
(20, '-03', '-931032000', -10800, '1'),
(20, '-04', '-900882000', -14400, '0'),
(20, '-03', '-890337600', -10800, '1'),
(20, '-04', '-833749200', -14400, '0'),
(20, '-03', '-827265600', -10800, '1'),
(20, '-04', '-752274000', -14400, '0'),
(20, '-03', '-733780800', -10800, '1'),
(20, '-04', '-197326800', -14400, '0'),
(20, '-03', '-190843200', -10800, '1'),
(20, '-04', '-184194000', -14400, '0'),
(20, '-03', '-164491200', -10800, '1'),
(20, '-04', '-152658000', -14400, '0'),
(20, '-03', '-132955200', -10800, '1'),
(20, '-04', '-121122000', -14400, '0'),
(20, '-03', '-101419200', -10800, '1'),
(20, '-04', '-86821200', -14400, '0'),
(20, '-03', '-71092800', -10800, '1'),
(20, '-04', '-54766800', -14400, '0'),
(20, '-03', '-39038400', -10800, '1'),
(20, '-04', '-23317200', -14400, '0'),
(20, '-03', '-7588800', -10800, '0'),
(20, '-02', '128142000', -7200, '1'),
(20, '-03', '136605600', -10800, '0'),
(20, '-02', '596948400', -7200, '1'),
(20, '-03', '605066400', -10800, '0'),
(20, '-02', '624423600', -7200, '1'),
(20, '-03', '636516000', -10800, '0'),
(20, '-02', '656478000', -7200, '1'),
(20, '-04', '667965600', -14400, '0'),
(20, '-02', '687931200', -7200, '1'),
(20, '-03', '699415200', -10800, '0'),
(20, '-02', '719377200', -7200, '1'),
(20, '-03', '731469600', -10800, '0'),
(20, '-02', '1198983600', -7200, '1'),
(20, '-03', '1205632800', -10800, '0'),
(20, '-02', '1224385200', -7200, '1'),
(20, '-03', '1237082400', -10800, '0'),
(21, 'LMT', '-2372096301', -15700, '0'),
(21, 'CMT', '-2372096300', -15408, '0'),
(21, '-04', '-1567453392', -14400, '0'),
(21, '-03', '-1233432000', -10800, '1'),
(21, '-04', '-1222981200', -14400, '0'),
(21, '-03', '-1205956800', -10800, '1'),
(21, '-04', '-1194037200', -14400, '0'),
(21, '-03', '-1172865600', -10800, '1'),
(21, '-04', '-1162501200', -14400, '0'),
(21, '-03', '-1141329600', -10800, '1'),
(21, '-04', '-1130965200', -14400, '0'),
(21, '-03', '-1109793600', -10800, '1'),
(21, '-04', '-1099429200', -14400, '0'),
(21, '-03', '-1078257600', -10800, '1'),
(21, '-04', '-1067806800', -14400, '0'),
(21, '-03', '-1046635200', -10800, '1'),
(21, '-04', '-1036270800', -14400, '0'),
(21, '-03', '-1015099200', -10800, '1'),
(21, '-04', '-1004734800', -14400, '0'),
(21, '-03', '-983563200', -10800, '1'),
(21, '-04', '-973198800', -14400, '0'),
(21, '-03', '-952027200', -10800, '1'),
(21, '-04', '-941576400', -14400, '0'),
(21, '-03', '-931032000', -10800, '1'),
(21, '-04', '-900882000', -14400, '0'),
(21, '-03', '-890337600', -10800, '1'),
(21, '-04', '-833749200', -14400, '0'),
(21, '-03', '-827265600', -10800, '1'),
(21, '-04', '-752274000', -14400, '0'),
(21, '-03', '-733780800', -10800, '1'),
(21, '-04', '-197326800', -14400, '0'),
(21, '-03', '-190843200', -10800, '1'),
(21, '-04', '-184194000', -14400, '0'),
(21, '-03', '-164491200', -10800, '1'),
(21, '-04', '-152658000', -14400, '0'),
(21, '-03', '-132955200', -10800, '1'),
(21, '-04', '-121122000', -14400, '0'),
(21, '-03', '-101419200', -10800, '1'),
(21, '-04', '-86821200', -14400, '0'),
(21, '-03', '-71092800', -10800, '1'),
(21, '-04', '-54766800', -14400, '0'),
(21, '-03', '-39038400', -10800, '1'),
(21, '-04', '-23317200', -14400, '0'),
(21, '-03', '-7588800', -10800, '0'),
(21, '-02', '128142000', -7200, '1'),
(21, '-03', '136605600', -10800, '0'),
(21, '-02', '596948400', -7200, '1'),
(21, '-03', '605066400', -10800, '0'),
(21, '-02', '624423600', -7200, '1'),
(21, '-03', '636516000', -10800, '0'),
(21, '-02', '656478000', -7200, '1'),
(21, '-04', '667965600', -14400, '0'),
(21, '-02', '687931200', -7200, '1'),
(21, '-03', '699415200', -10800, '0'),
(21, '-02', '719377200', -7200, '1'),
(21, '-03', '731469600', -10800, '0'),
(21, '-02', '1198983600', -7200, '1'),
(21, '-03', '1205632800', -10800, '0'),
(22, 'LMT', '-2372096329', -15672, '0'),
(22, 'CMT', '-2372096328', -15408, '0'),
(22, '-04', '-1567453392', -14400, '0'),
(22, '-03', '-1233432000', -10800, '1'),
(22, '-04', '-1222981200', -14400, '0'),
(22, '-03', '-1205956800', -10800, '1'),
(22, '-04', '-1194037200', -14400, '0'),
(22, '-03', '-1172865600', -10800, '1'),
(22, '-04', '-1162501200', -14400, '0'),
(22, '-03', '-1141329600', -10800, '1'),
(22, '-04', '-1130965200', -14400, '0'),
(22, '-03', '-1109793600', -10800, '1'),
(22, '-04', '-1099429200', -14400, '0'),
(22, '-03', '-1078257600', -10800, '1'),
(22, '-04', '-1067806800', -14400, '0'),
(22, '-03', '-1046635200', -10800, '1'),
(22, '-04', '-1036270800', -14400, '0'),
(22, '-03', '-1015099200', -10800, '1'),
(22, '-04', '-1004734800', -14400, '0'),
(22, '-03', '-983563200', -10800, '1'),
(22, '-04', '-973198800', -14400, '0'),
(22, '-03', '-952027200', -10800, '1'),
(22, '-04', '-941576400', -14400, '0'),
(22, '-03', '-931032000', -10800, '1'),
(22, '-04', '-900882000', -14400, '0'),
(22, '-03', '-890337600', -10800, '1'),
(22, '-04', '-833749200', -14400, '0'),
(22, '-03', '-827265600', -10800, '1'),
(22, '-04', '-752274000', -14400, '0'),
(22, '-03', '-733780800', -10800, '1'),
(22, '-04', '-197326800', -14400, '0'),
(22, '-03', '-190843200', -10800, '1'),
(22, '-04', '-184194000', -14400, '0'),
(22, '-03', '-164491200', -10800, '1'),
(22, '-04', '-152658000', -14400, '0'),
(22, '-03', '-132955200', -10800, '1'),
(22, '-04', '-121122000', -14400, '0'),
(22, '-03', '-101419200', -10800, '1'),
(22, '-04', '-86821200', -14400, '0'),
(22, '-03', '-71092800', -10800, '1'),
(22, '-04', '-54766800', -14400, '0'),
(22, '-03', '-39038400', -10800, '1'),
(22, '-04', '-23317200', -14400, '0'),
(22, '-03', '-7588800', -10800, '0'),
(22, '-02', '128142000', -7200, '1'),
(22, '-03', '136605600', -10800, '0'),
(22, '-02', '596948400', -7200, '1'),
(22, '-03', '605066400', -10800, '0'),
(22, '-02', '624423600', -7200, '1'),
(22, '-04', '636516000', -14400, '0'),
(22, '-03', '657086400', -10800, '1'),
(22, '-04', '669178800', -14400, '0'),
(22, '-02', '686721600', -7200, '1'),
(22, '-03', '699415200', -10800, '0'),
(22, '-02', '719377200', -7200, '1'),
(22, '-03', '731469600', -10800, '0'),
(22, '-02', '1198983600', -7200, '1'),
(22, '-03', '1205632800', -10800, '0'),
(23, 'LMT', '-2372096349', -15652, '0'),
(23, 'CMT', '-2372096348', -15408, '0'),
(23, '-04', '-1567453392', -14400, '0'),
(23, '-03', '-1233432000', -10800, '1'),
(23, '-04', '-1222981200', -14400, '0'),
(23, '-03', '-1205956800', -10800, '1'),
(23, '-04', '-1194037200', -14400, '0'),
(23, '-03', '-1172865600', -10800, '1'),
(23, '-04', '-1162501200', -14400, '0'),
(23, '-03', '-1141329600', -10800, '1'),
(23, '-04', '-1130965200', -14400, '0'),
(23, '-03', '-1109793600', -10800, '1'),
(23, '-04', '-1099429200', -14400, '0'),
(23, '-03', '-1078257600', -10800, '1'),
(23, '-04', '-1067806800', -14400, '0'),
(23, '-03', '-1046635200', -10800, '1'),
(23, '-04', '-1036270800', -14400, '0'),
(23, '-03', '-1015099200', -10800, '1'),
(23, '-04', '-1004734800', -14400, '0'),
(23, '-03', '-983563200', -10800, '1'),
(23, '-04', '-973198800', -14400, '0'),
(23, '-03', '-952027200', -10800, '1'),
(23, '-04', '-941576400', -14400, '0'),
(23, '-03', '-931032000', -10800, '1'),
(23, '-04', '-900882000', -14400, '0'),
(23, '-03', '-890337600', -10800, '1'),
(23, '-04', '-833749200', -14400, '0'),
(23, '-03', '-827265600', -10800, '1'),
(23, '-04', '-752274000', -14400, '0'),
(23, '-03', '-733780800', -10800, '1'),
(23, '-04', '-197326800', -14400, '0'),
(23, '-03', '-190843200', -10800, '1'),
(23, '-04', '-184194000', -14400, '0'),
(23, '-03', '-164491200', -10800, '1'),
(23, '-04', '-152658000', -14400, '0'),
(23, '-03', '-132955200', -10800, '1'),
(23, '-04', '-121122000', -14400, '0'),
(23, '-03', '-101419200', -10800, '1'),
(23, '-04', '-86821200', -14400, '0'),
(23, '-03', '-71092800', -10800, '1'),
(23, '-04', '-54766800', -14400, '0'),
(23, '-03', '-39038400', -10800, '1'),
(23, '-04', '-23317200', -14400, '0'),
(23, '-03', '-7588800', -10800, '0'),
(23, '-02', '128142000', -7200, '1'),
(23, '-03', '136605600', -10800, '0'),
(23, '-02', '596948400', -7200, '1'),
(23, '-03', '605066400', -10800, '0'),
(23, '-02', '624423600', -7200, '1'),
(23, '-03', '636516000', -10800, '0'),
(23, '-02', '656478000', -7200, '1'),
(23, '-04', '667965600', -14400, '0'),
(23, '-02', '687931200', -7200, '1'),
(23, '-03', '699415200', -10800, '0'),
(23, '-02', '719377200', -7200, '1'),
(23, '-03', '731469600', -10800, '0'),
(23, '-04', '1086058800', -14400, '0'),
(23, '-03', '1087099200', -10800, '0'),
(23, '-02', '1198983600', -7200, '1'),
(23, '-03', '1205632800', -10800, '0'),
(23, '-02', '1224385200', -7200, '1'),
(23, '-03', '1237082400', -10800, '0'),
(24, 'LMT', '-2372096213', -15788, '0'),
(24, 'CMT', '-2372096212', -15408, '0'),
(24, '-04', '-1567453392', -14400, '0'),
(24, '-03', '-1233432000', -10800, '1'),
(24, '-04', '-1222981200', -14400, '0'),
(24, '-03', '-1205956800', -10800, '1'),
(24, '-04', '-1194037200', -14400, '0'),
(24, '-03', '-1172865600', -10800, '1'),
(24, '-04', '-1162501200', -14400, '0'),
(24, '-03', '-1141329600', -10800, '1'),
(24, '-04', '-1130965200', -14400, '0'),
(24, '-03', '-1109793600', -10800, '1'),
(24, '-04', '-1099429200', -14400, '0'),
(24, '-03', '-1078257600', -10800, '1'),
(24, '-04', '-1067806800', -14400, '0'),
(24, '-03', '-1046635200', -10800, '1'),
(24, '-04', '-1036270800', -14400, '0'),
(24, '-03', '-1015099200', -10800, '1'),
(24, '-04', '-1004734800', -14400, '0'),
(24, '-03', '-983563200', -10800, '1'),
(24, '-04', '-973198800', -14400, '0'),
(24, '-03', '-952027200', -10800, '1'),
(24, '-04', '-941576400', -14400, '0'),
(24, '-03', '-931032000', -10800, '1'),
(24, '-04', '-900882000', -14400, '0'),
(24, '-03', '-890337600', -10800, '1'),
(24, '-04', '-833749200', -14400, '0'),
(24, '-03', '-827265600', -10800, '1'),
(24, '-04', '-752274000', -14400, '0'),
(24, '-03', '-733780800', -10800, '1'),
(24, '-04', '-197326800', -14400, '0'),
(24, '-03', '-190843200', -10800, '1'),
(24, '-04', '-184194000', -14400, '0'),
(24, '-03', '-164491200', -10800, '1'),
(24, '-04', '-152658000', -14400, '0'),
(24, '-03', '-132955200', -10800, '1'),
(24, '-04', '-121122000', -14400, '0'),
(24, '-03', '-101419200', -10800, '1'),
(24, '-04', '-86821200', -14400, '0'),
(24, '-03', '-71092800', -10800, '1'),
(24, '-04', '-54766800', -14400, '0'),
(24, '-03', '-39038400', -10800, '1'),
(24, '-04', '-23317200', -14400, '0'),
(24, '-03', '-7588800', -10800, '0'),
(24, '-02', '128142000', -7200, '1'),
(24, '-03', '136605600', -10800, '0'),
(24, '-02', '596948400', -7200, '1'),
(24, '-03', '605066400', -10800, '0'),
(24, '-02', '624423600', -7200, '1'),
(24, '-03', '636516000', -10800, '0'),
(24, '-02', '656478000', -7200, '1'),
(24, '-04', '667965600', -14400, '0'),
(24, '-02', '687931200', -7200, '1'),
(24, '-03', '699415200', -10800, '0'),
(24, '-02', '719377200', -7200, '1'),
(24, '-03', '731469600', -10800, '0'),
(24, '-04', '1086058800', -14400, '0'),
(24, '-03', '1087704000', -10800, '0'),
(24, '-02', '1198983600', -7200, '1'),
(24, '-03', '1205632800', -10800, '0'),
(25, 'LMT', '-2372095957', -16044, '0'),
(25, 'CMT', '-2372095956', -15408, '0'),
(25, '-04', '-1567453392', -14400, '0'),
(25, '-03', '-1233432000', -10800, '1'),
(25, '-04', '-1222981200', -14400, '0'),
(25, '-03', '-1205956800', -10800, '1'),
(25, '-04', '-1194037200', -14400, '0'),
(25, '-03', '-1172865600', -10800, '1'),
(25, '-04', '-1162501200', -14400, '0'),
(25, '-03', '-1141329600', -10800, '1'),
(25, '-04', '-1130965200', -14400, '0'),
(25, '-03', '-1109793600', -10800, '1'),
(25, '-04', '-1099429200', -14400, '0'),
(25, '-03', '-1078257600', -10800, '1'),
(25, '-04', '-1067806800', -14400, '0'),
(25, '-03', '-1046635200', -10800, '1'),
(25, '-04', '-1036270800', -14400, '0'),
(25, '-03', '-1015099200', -10800, '1'),
(25, '-04', '-1004734800', -14400, '0'),
(25, '-03', '-983563200', -10800, '1'),
(25, '-04', '-973198800', -14400, '0'),
(25, '-03', '-952027200', -10800, '1'),
(25, '-04', '-941576400', -14400, '0'),
(25, '-03', '-931032000', -10800, '1'),
(25, '-04', '-900882000', -14400, '0'),
(25, '-03', '-890337600', -10800, '1'),
(25, '-04', '-833749200', -14400, '0'),
(25, '-03', '-827265600', -10800, '1'),
(25, '-04', '-752274000', -14400, '0'),
(25, '-03', '-733780800', -10800, '1'),
(25, '-04', '-197326800', -14400, '0'),
(25, '-03', '-190843200', -10800, '1'),
(25, '-04', '-184194000', -14400, '0'),
(25, '-03', '-164491200', -10800, '1'),
(25, '-04', '-152658000', -14400, '0'),
(25, '-03', '-132955200', -10800, '1'),
(25, '-04', '-121122000', -14400, '0'),
(25, '-03', '-101419200', -10800, '1'),
(25, '-04', '-86821200', -14400, '0'),
(25, '-03', '-71092800', -10800, '1'),
(25, '-04', '-54766800', -14400, '0'),
(25, '-03', '-39038400', -10800, '1'),
(25, '-04', '-23317200', -14400, '0'),
(25, '-03', '-7588800', -10800, '0'),
(25, '-02', '128142000', -7200, '1'),
(25, '-03', '136605600', -10800, '0'),
(25, '-02', '596948400', -7200, '1'),
(25, '-03', '605066400', -10800, '0'),
(25, '-02', '624423600', -7200, '1'),
(25, '-03', '636516000', -10800, '0'),
(25, '-02', '656478000', -7200, '1'),
(25, '-04', '667792800', -14400, '0'),
(25, '-03', '673588800', -10800, '0'),
(25, '-02', '687927600', -7200, '1'),
(25, '-03', '699415200', -10800, '0'),
(25, '-02', '719377200', -7200, '1'),
(25, '-03', '731469600', -10800, '0'),
(25, '-04', '1086058800', -14400, '0'),
(25, '-03', '1087704000', -10800, '0'),
(25, '-02', '1198983600', -7200, '1'),
(25, '-03', '1205632800', -10800, '0'),
(26, 'LMT', '-2372095557', -16444, '0'),
(26, 'CMT', '-2372095556', -15408, '0'),
(26, '-04', '-1567453392', -14400, '0'),
(26, '-03', '-1233432000', -10800, '1'),
(26, '-04', '-1222981200', -14400, '0'),
(26, '-03', '-1205956800', -10800, '1'),
(26, '-04', '-1194037200', -14400, '0'),
(26, '-03', '-1172865600', -10800, '1'),
(26, '-04', '-1162501200', -14400, '0'),
(26, '-03', '-1141329600', -10800, '1'),
(26, '-04', '-1130965200', -14400, '0'),
(26, '-03', '-1109793600', -10800, '1'),
(26, '-04', '-1099429200', -14400, '0'),
(26, '-03', '-1078257600', -10800, '1'),
(26, '-04', '-1067806800', -14400, '0'),
(26, '-03', '-1046635200', -10800, '1'),
(26, '-04', '-1036270800', -14400, '0'),
(26, '-03', '-1015099200', -10800, '1'),
(26, '-04', '-1004734800', -14400, '0'),
(26, '-03', '-983563200', -10800, '1'),
(26, '-04', '-973198800', -14400, '0'),
(26, '-03', '-952027200', -10800, '1'),
(26, '-04', '-941576400', -14400, '0'),
(26, '-03', '-931032000', -10800, '1'),
(26, '-04', '-900882000', -14400, '0'),
(26, '-03', '-890337600', -10800, '1'),
(26, '-04', '-833749200', -14400, '0'),
(26, '-03', '-827265600', -10800, '1'),
(26, '-04', '-752274000', -14400, '0'),
(26, '-03', '-733780800', -10800, '1'),
(26, '-04', '-197326800', -14400, '0'),
(26, '-03', '-190843200', -10800, '1'),
(26, '-04', '-184194000', -14400, '0'),
(26, '-03', '-164491200', -10800, '1'),
(26, '-04', '-152658000', -14400, '0'),
(26, '-03', '-132955200', -10800, '1'),
(26, '-04', '-121122000', -14400, '0'),
(26, '-03', '-101419200', -10800, '1'),
(26, '-04', '-86821200', -14400, '0'),
(26, '-03', '-71092800', -10800, '1'),
(26, '-04', '-54766800', -14400, '0'),
(26, '-03', '-39038400', -10800, '1'),
(26, '-04', '-23317200', -14400, '0'),
(26, '-03', '-7588800', -10800, '0'),
(26, '-02', '128142000', -7200, '1'),
(26, '-03', '136605600', -10800, '0'),
(26, '-02', '596948400', -7200, '1'),
(26, '-03', '605066400', -10800, '0'),
(26, '-02', '624423600', -7200, '1'),
(26, '-03', '636516000', -10800, '0'),
(26, '-02', '656478000', -7200, '1'),
(26, '-04', '667792800', -14400, '0'),
(26, '-03', '673588800', -10800, '0'),
(26, '-02', '687927600', -7200, '1'),
(26, '-03', '699415200', -10800, '0'),
(26, '-02', '719377200', -7200, '1'),
(26, '-03', '731469600', -10800, '0'),
(26, '-04', '1085972400', -14400, '0'),
(26, '-03', '1090728000', -10800, '0'),
(26, '-02', '1198983600', -7200, '1'),
(26, '-03', '1205632800', -10800, '0'),
(27, 'LMT', '-2372095485', -16516, '0'),
(27, 'CMT', '-2372095484', -15408, '0'),
(27, '-04', '-1567453392', -14400, '0'),
(27, '-03', '-1233432000', -10800, '1'),
(27, '-04', '-1222981200', -14400, '0'),
(27, '-03', '-1205956800', -10800, '1'),
(27, '-04', '-1194037200', -14400, '0'),
(27, '-03', '-1172865600', -10800, '1'),
(27, '-04', '-1162501200', -14400, '0'),
(27, '-03', '-1141329600', -10800, '1'),
(27, '-04', '-1130965200', -14400, '0'),
(27, '-03', '-1109793600', -10800, '1'),
(27, '-04', '-1099429200', -14400, '0'),
(27, '-03', '-1078257600', -10800, '1'),
(27, '-04', '-1067806800', -14400, '0'),
(27, '-03', '-1046635200', -10800, '1'),
(27, '-04', '-1036270800', -14400, '0'),
(27, '-03', '-1015099200', -10800, '1'),
(27, '-04', '-1004734800', -14400, '0'),
(27, '-03', '-983563200', -10800, '1'),
(27, '-04', '-973198800', -14400, '0'),
(27, '-03', '-952027200', -10800, '1'),
(27, '-04', '-941576400', -14400, '0'),
(27, '-03', '-931032000', -10800, '1'),
(27, '-04', '-900882000', -14400, '0'),
(27, '-03', '-890337600', -10800, '1'),
(27, '-04', '-833749200', -14400, '0'),
(27, '-03', '-827265600', -10800, '1'),
(27, '-04', '-752274000', -14400, '0'),
(27, '-03', '-733780800', -10800, '1'),
(27, '-04', '-197326800', -14400, '0'),
(27, '-03', '-190843200', -10800, '1'),
(27, '-04', '-184194000', -14400, '0'),
(27, '-03', '-164491200', -10800, '1'),
(27, '-04', '-152658000', -14400, '0'),
(27, '-03', '-132955200', -10800, '1'),
(27, '-04', '-121122000', -14400, '0'),
(27, '-03', '-101419200', -10800, '1'),
(27, '-04', '-86821200', -14400, '0'),
(27, '-03', '-71092800', -10800, '1'),
(27, '-04', '-54766800', -14400, '0'),
(27, '-03', '-39038400', -10800, '1'),
(27, '-04', '-23317200', -14400, '0'),
(27, '-03', '-7588800', -10800, '0'),
(27, '-02', '128142000', -7200, '1'),
(27, '-03', '136605600', -10800, '0'),
(27, '-02', '596948400', -7200, '1'),
(27, '-03', '605066400', -10800, '0'),
(27, '-02', '624423600', -7200, '1'),
(27, '-04', '636516000', -14400, '0'),
(27, '-03', '655963200', -10800, '1'),
(27, '-04', '667796400', -14400, '0'),
(27, '-03', '687499200', -10800, '1'),
(27, '-04', '699418800', -14400, '0'),
(27, '-02', '719380800', -7200, '1'),
(27, '-03', '731469600', -10800, '0'),
(27, '-04', '1085281200', -14400, '0'),
(27, '-03', '1096171200', -10800, '0'),
(27, '-02', '1198983600', -7200, '1'),
(27, '-03', '1205632800', -10800, '0'),
(28, 'LMT', '-2372096077', -15924, '0'),
(28, 'CMT', '-2372096076', -15408, '0'),
(28, '-04', '-1567453392', -14400, '0'),
(28, '-03', '-1233432000', -10800, '1'),
(28, '-04', '-1222981200', -14400, '0'),
(28, '-03', '-1205956800', -10800, '1'),
(28, '-04', '-1194037200', -14400, '0'),
(28, '-03', '-1172865600', -10800, '1'),
(28, '-04', '-1162501200', -14400, '0'),
(28, '-03', '-1141329600', -10800, '1'),
(28, '-04', '-1130965200', -14400, '0'),
(28, '-03', '-1109793600', -10800, '1'),
(28, '-04', '-1099429200', -14400, '0'),
(28, '-03', '-1078257600', -10800, '1'),
(28, '-04', '-1067806800', -14400, '0'),
(28, '-03', '-1046635200', -10800, '1'),
(28, '-04', '-1036270800', -14400, '0'),
(28, '-03', '-1015099200', -10800, '1'),
(28, '-04', '-1004734800', -14400, '0'),
(28, '-03', '-983563200', -10800, '1'),
(28, '-04', '-973198800', -14400, '0'),
(28, '-03', '-952027200', -10800, '1'),
(28, '-04', '-941576400', -14400, '0'),
(28, '-03', '-931032000', -10800, '1'),
(28, '-04', '-900882000', -14400, '0'),
(28, '-03', '-890337600', -10800, '1'),
(28, '-04', '-833749200', -14400, '0'),
(28, '-03', '-827265600', -10800, '1'),
(28, '-04', '-752274000', -14400, '0'),
(28, '-03', '-733780800', -10800, '1'),
(28, '-04', '-197326800', -14400, '0'),
(28, '-03', '-190843200', -10800, '1'),
(28, '-04', '-184194000', -14400, '0'),
(28, '-03', '-164491200', -10800, '1'),
(28, '-04', '-152658000', -14400, '0'),
(28, '-03', '-132955200', -10800, '1'),
(28, '-04', '-121122000', -14400, '0'),
(28, '-03', '-101419200', -10800, '1'),
(28, '-04', '-86821200', -14400, '0'),
(28, '-03', '-71092800', -10800, '1'),
(28, '-04', '-54766800', -14400, '0'),
(28, '-03', '-39038400', -10800, '1'),
(28, '-04', '-23317200', -14400, '0'),
(28, '-03', '-7588800', -10800, '0'),
(28, '-02', '128142000', -7200, '1'),
(28, '-03', '136605600', -10800, '0'),
(28, '-02', '596948400', -7200, '1'),
(28, '-03', '605066400', -10800, '0'),
(28, '-02', '624423600', -7200, '1'),
(28, '-04', '637380000', -14400, '0'),
(28, '-03', '655963200', -10800, '1'),
(28, '-04', '667796400', -14400, '0'),
(28, '-03', '675748800', -10800, '0'),
(28, '-04', '1085972400', -14400, '0'),
(28, '-03', '1090728000', -10800, '0'),
(28, '-02', '1198983600', -7200, '1'),
(28, '-03', '1200880800', -10800, '1'),
(28, '-04', '1205031600', -14400, '0'),
(28, '-03', '1223784000', -10800, '1'),
(28, '-04', '1236481200', -14400, '0'),
(28, '-03', '1255233600', -10800, '0'),
(29, 'LMT', '-2372095389', -16612, '0'),
(29, 'CMT', '-2372095388', -15408, '0'),
(29, '-04', '-1567453392', -14400, '0'),
(29, '-03', '-1233432000', -10800, '1'),
(29, '-04', '-1222981200', -14400, '0'),
(29, '-03', '-1205956800', -10800, '1'),
(29, '-04', '-1194037200', -14400, '0'),
(29, '-03', '-1172865600', -10800, '1'),
(29, '-04', '-1162501200', -14400, '0'),
(29, '-03', '-1141329600', -10800, '1'),
(29, '-04', '-1130965200', -14400, '0'),
(29, '-03', '-1109793600', -10800, '1'),
(29, '-04', '-1099429200', -14400, '0'),
(29, '-03', '-1078257600', -10800, '1'),
(29, '-04', '-1067806800', -14400, '0'),
(29, '-03', '-1046635200', -10800, '1'),
(29, '-04', '-1036270800', -14400, '0'),
(29, '-03', '-1015099200', -10800, '1'),
(29, '-04', '-1004734800', -14400, '0'),
(29, '-03', '-983563200', -10800, '1'),
(29, '-04', '-973198800', -14400, '0'),
(29, '-03', '-952027200', -10800, '1'),
(29, '-04', '-941576400', -14400, '0'),
(29, '-03', '-931032000', -10800, '1'),
(29, '-04', '-900882000', -14400, '0'),
(29, '-03', '-890337600', -10800, '1'),
(29, '-04', '-833749200', -14400, '0'),
(29, '-03', '-827265600', -10800, '1'),
(29, '-04', '-752274000', -14400, '0'),
(29, '-03', '-733780800', -10800, '1'),
(29, '-04', '-197326800', -14400, '0'),
(29, '-03', '-190843200', -10800, '1'),
(29, '-04', '-184194000', -14400, '0'),
(29, '-03', '-164491200', -10800, '1'),
(29, '-04', '-152658000', -14400, '0'),
(29, '-03', '-132955200', -10800, '1'),
(29, '-04', '-121122000', -14400, '0'),
(29, '-03', '-101419200', -10800, '1'),
(29, '-04', '-86821200', -14400, '0'),
(29, '-03', '-71092800', -10800, '1'),
(29, '-04', '-54766800', -14400, '0'),
(29, '-03', '-39038400', -10800, '1'),
(29, '-04', '-23317200', -14400, '0'),
(29, '-03', '-7588800', -10800, '0'),
(29, '-02', '128142000', -7200, '1'),
(29, '-03', '136605600', -10800, '0'),
(29, '-02', '596948400', -7200, '1'),
(29, '-03', '605066400', -10800, '0'),
(29, '-02', '624423600', -7200, '1'),
(29, '-03', '636516000', -10800, '0'),
(29, '-02', '656478000', -7200, '1'),
(29, '-03', '667965600', -10800, '0'),
(29, '-02', '687927600', -7200, '1'),
(29, '-03', '699415200', -10800, '0'),
(29, '-02', '719377200', -7200, '1'),
(29, '-03', '731469600', -10800, '0'),
(29, '-04', '1086058800', -14400, '0'),
(29, '-03', '1087704000', -10800, '0'),
(29, '-02', '1198983600', -7200, '1'),
(29, '-03', '1205632800', -10800, '0'),
(30, 'LMT', '-2372095609', -16392, '0'),
(30, 'CMT', '-2372095608', -15408, '0'),
(30, '-04', '-1567453392', -14400, '0'),
(30, '-03', '-1233432000', -10800, '1'),
(30, '-04', '-1222981200', -14400, '0'),
(30, '-03', '-1205956800', -10800, '1'),
(30, '-04', '-1194037200', -14400, '0'),
(30, '-03', '-1172865600', -10800, '1'),
(30, '-04', '-1162501200', -14400, '0'),
(30, '-03', '-1141329600', -10800, '1'),
(30, '-04', '-1130965200', -14400, '0'),
(30, '-03', '-1109793600', -10800, '1'),
(30, '-04', '-1099429200', -14400, '0'),
(30, '-03', '-1078257600', -10800, '1'),
(30, '-04', '-1067806800', -14400, '0'),
(30, '-03', '-1046635200', -10800, '1'),
(30, '-04', '-1036270800', -14400, '0'),
(30, '-03', '-1015099200', -10800, '1'),
(30, '-04', '-1004734800', -14400, '0'),
(30, '-03', '-983563200', -10800, '1'),
(30, '-04', '-973198800', -14400, '0'),
(30, '-03', '-952027200', -10800, '1'),
(30, '-04', '-941576400', -14400, '0'),
(30, '-03', '-931032000', -10800, '1'),
(30, '-04', '-900882000', -14400, '0'),
(30, '-03', '-890337600', -10800, '1'),
(30, '-04', '-833749200', -14400, '0'),
(30, '-03', '-827265600', -10800, '1'),
(30, '-04', '-752274000', -14400, '0'),
(30, '-03', '-733780800', -10800, '1'),
(30, '-04', '-197326800', -14400, '0'),
(30, '-03', '-190843200', -10800, '1'),
(30, '-04', '-184194000', -14400, '0'),
(30, '-03', '-164491200', -10800, '1'),
(30, '-04', '-152658000', -14400, '0'),
(30, '-03', '-132955200', -10800, '1'),
(30, '-04', '-121122000', -14400, '0'),
(30, '-03', '-101419200', -10800, '1'),
(30, '-04', '-86821200', -14400, '0'),
(30, '-03', '-71092800', -10800, '1'),
(30, '-04', '-54766800', -14400, '0'),
(30, '-03', '-39038400', -10800, '1'),
(30, '-04', '-23317200', -14400, '0'),
(30, '-03', '-7588800', -10800, '0'),
(30, '-02', '128142000', -7200, '1'),
(30, '-03', '136605600', -10800, '0'),
(30, '-02', '596948400', -7200, '1'),
(30, '-03', '605066400', -10800, '0'),
(30, '-02', '624423600', -7200, '1'),
(30, '-03', '636516000', -10800, '0'),
(30, '-02', '656478000', -7200, '1'),
(30, '-03', '667965600', -10800, '0'),
(30, '-02', '687927600', -7200, '1'),
(30, '-03', '699415200', -10800, '0'),
(30, '-02', '719377200', -7200, '1'),
(30, '-03', '731469600', -10800, '0'),
(30, '-04', '1085886000', -14400, '0'),
(30, '-03', '1087704000', -10800, '0'),
(30, '-02', '1198983600', -7200, '1'),
(30, '-03', '1205632800', -10800, '0'),
(31, 'LMT', '-2855738233', 45432, '0'),
(31, 'LMT', '-2855738232', -40968, '0'),
(31, 'SST', '-1861879032', -39600, '0'),
(32, 'LMT', '-2422055122', 3921, '0'),
(32, 'CET', '-2422055121', 3600, '0'),
(32, 'CEST', '-1693706400', 7200, '1'),
(32, 'CET', '-1680483600', 3600, '0'),
(32, 'CEST', '-1663455600', 7200, '1'),
(32, 'CET', '-1650150000', 3600, '0'),
(32, 'CEST', '-1632006000', 7200, '1'),
(32, 'CET', '-1618700400', 3600, '0'),
(32, 'CEST', '-1569711600', 7200, '1'),
(32, 'CET', '-1555801200', 3600, '0'),
(32, 'CEST', '-938905200', 7200, '1'),
(32, 'CET', '-857257200', 3600, '0'),
(32, 'CEST', '-844556400', 7200, '1'),
(32, 'CET', '-828226800', 3600, '0'),
(32, 'CEST', '-812502000', 7200, '1'),
(32, 'CET', '-796777200', 3600, '0'),
(32, 'CEST', '-781052400', 7200, '1'),
(32, 'CET', '-780188400', 3600, '0'),
(32, 'CEST', '-748479600', 7200, '1'),
(32, 'CET', '-733359600', 3600, '0'),
(32, 'CEST', '-717634800', 7200, '1'),
(32, 'CET', '-701910000', 3600, '0'),
(32, 'CEST', '-684975600', 7200, '1'),
(32, 'CET', '-670460400', 3600, '0'),
(32, 'CEST', '323823600', 7200, '1'),
(32, 'CET', '338940000', 3600, '0'),
(32, 'CEST', '354675600', 7200, '1'),
(32, 'CET', '370400400', 3600, '0'),
(32, 'CEST', '386125200', 7200, '1'),
(32, 'CET', '401850000', 3600, '0'),
(32, 'CEST', '417574800', 7200, '1'),
(32, 'CET', '433299600', 3600, '0'),
(32, 'CEST', '449024400', 7200, '1'),
(32, 'CET', '465354000', 3600, '0'),
(32, 'CEST', '481078800', 7200, '1'),
(32, 'CET', '496803600', 3600, '0'),
(32, 'CEST', '512528400', 7200, '1'),
(32, 'CET', '528253200', 3600, '0'),
(32, 'CEST', '543978000', 7200, '1'),
(32, 'CET', '559702800', 3600, '0'),
(32, 'CEST', '575427600', 7200, '1'),
(32, 'CET', '591152400', 3600, '0'),
(32, 'CEST', '606877200', 7200, '1'),
(32, 'CET', '622602000', 3600, '0'),
(32, 'CEST', '638326800', 7200, '1'),
(32, 'CET', '654656400', 3600, '0'),
(32, 'CEST', '670381200', 7200, '1'),
(32, 'CET', '686106000', 3600, '0'),
(32, 'CEST', '701830800', 7200, '1'),
(32, 'CET', '717555600', 3600, '0'),
(32, 'CEST', '733280400', 7200, '1'),
(32, 'CET', '749005200', 3600, '0'),
(32, 'CEST', '764730000', 7200, '1'),
(32, 'CET', '780454800', 3600, '0'),
(32, 'CEST', '796179600', 7200, '1'),
(32, 'CET', '811904400', 3600, '0'),
(32, 'CEST', '828234000', 7200, '1'),
(32, 'CET', '846378000', 3600, '0'),
(32, 'CEST', '859683600', 7200, '1'),
(32, 'CET', '877827600', 3600, '0'),
(32, 'CEST', '891133200', 7200, '1'),
(32, 'CET', '909277200', 3600, '0'),
(32, 'CEST', '922582800', 7200, '1'),
(32, 'CET', '941331600', 3600, '0'),
(32, 'CEST', '954032400', 7200, '1'),
(32, 'CET', '972781200', 3600, '0'),
(32, 'CEST', '985482000', 7200, '1'),
(32, 'CET', '1004230800', 3600, '0'),
(32, 'CEST', '1017536400', 7200, '1'),
(32, 'CET', '1035680400', 3600, '0'),
(32, 'CEST', '1048986000', 7200, '1'),
(32, 'CET', '1067130000', 3600, '0'),
(32, 'CEST', '1080435600', 7200, '1'),
(32, 'CET', '1099184400', 3600, '0'),
(32, 'CEST', '1111885200', 7200, '1'),
(32, 'CET', '1130634000', 3600, '0'),
(32, 'CEST', '1143334800', 7200, '1'),
(32, 'CET', '1162083600', 3600, '0'),
(32, 'CEST', '1174784400', 7200, '1'),
(32, 'CET', '1193533200', 3600, '0'),
(32, 'CEST', '1206838800', 7200, '1'),
(32, 'CET', '1224982800', 3600, '0'),
(32, 'CEST', '1238288400', 7200, '1'),
(32, 'CET', '1256432400', 3600, '0'),
(32, 'CEST', '1269738000', 7200, '1'),
(32, 'CET', '1288486800', 3600, '0'),
(32, 'CEST', '1301187600', 7200, '1'),
(32, 'CET', '1319936400', 3600, '0'),
(32, 'CEST', '1332637200', 7200, '1'),
(32, 'CET', '1351386000', 3600, '0'),
(32, 'CEST', '1364691600', 7200, '1'),
(32, 'CET', '1382835600', 3600, '0'),
(32, 'CEST', '1396141200', 7200, '1'),
(32, 'CET', '1414285200', 3600, '0'),
(32, 'CEST', '1427590800', 7200, '1'),
(32, 'CET', '1445734800', 3600, '0'),
(32, 'CEST', '1459040400', 7200, '1'),
(32, 'CET', '1477789200', 3600, '0'),
(32, 'CEST', '1490490000', 7200, '1'),
(32, 'CET', '1509238800', 3600, '0'),
(32, 'CEST', '1521939600', 7200, '1'),
(32, 'CET', '1540688400', 3600, '0'),
(32, 'CEST', '1553994000', 7200, '1'),
(32, 'CET', '1572138000', 3600, '0'),
(32, 'CEST', '1585443600', 7200, '1'),
(32, 'CET', '1603587600', 3600, '0'),
(32, 'CEST', '1616893200', 7200, '1'),
(32, 'CET', '1635642000', 3600, '0'),
(32, 'CEST', '1648342800', 7200, '1'),
(32, 'CET', '1667091600', 3600, '0'),
(32, 'CEST', '1679792400', 7200, '1'),
(32, 'CET', '1698541200', 3600, '0'),
(32, 'CEST', '1711846800', 7200, '1'),
(32, 'CET', '1729990800', 3600, '0'),
(32, 'CEST', '1743296400', 7200, '1'),
(32, 'CET', '1761440400', 3600, '0'),
(32, 'CEST', '1774746000', 7200, '1'),
(32, 'CET', '1792890000', 3600, '0'),
(32, 'CEST', '1806195600', 7200, '1'),
(32, 'CET', '1824944400', 3600, '0'),
(32, 'CEST', '1837645200', 7200, '1'),
(32, 'CET', '1856394000', 3600, '0'),
(32, 'CEST', '1869094800', 7200, '1'),
(32, 'CET', '1887843600', 3600, '0'),
(32, 'CEST', '1901149200', 7200, '1'),
(32, 'CET', '1919293200', 3600, '0'),
(32, 'CEST', '1932598800', 7200, '1'),
(32, 'CET', '1950742800', 3600, '0'),
(32, 'CEST', '1964048400', 7200, '1'),
(32, 'CET', '1982797200', 3600, '0'),
(32, 'CEST', '1995498000', 7200, '1'),
(32, 'CET', '2014246800', 3600, '0'),
(32, 'CEST', '2026947600', 7200, '1'),
(32, 'CET', '2045696400', 3600, '0'),
(32, 'CEST', '2058397200', 7200, '1'),
(32, 'CET', '2077146000', 3600, '0'),
(32, 'CEST', '2090451600', 7200, '1'),
(32, 'CET', '2108595600', 3600, '0'),
(32, 'CEST', '2121901200', 7200, '1'),
(32, 'CET', '2140045200', 3600, '0'),
(32, 'CEST', '2153350800', 7200, '1'),
(32, 'CET', '2172099600', 3600, '0'),
(32, 'CEST', '2184800400', 7200, '1'),
(32, 'CET', '2203549200', 3600, '0'),
(32, 'CEST', '2216250000', 7200, '1'),
(32, 'CET', '2234998800', 3600, '0'),
(32, 'CEST', '2248304400', 7200, '1'),
(32, 'CET', '2266448400', 3600, '0'),
(32, 'CEST', '2279754000', 7200, '1'),
(32, 'CET', '2297898000', 3600, '0'),
(32, 'CEST', '2311203600', 7200, '1'),
(32, 'CET', '2329347600', 3600, '0'),
(32, 'CEST', '2342653200', 7200, '1'),
(32, 'CET', '2361402000', 3600, '0'),
(32, 'CEST', '2374102800', 7200, '1'),
(32, 'CET', '2392851600', 3600, '0'),
(32, 'CEST', '2405552400', 7200, '1'),
(32, 'CET', '2424301200', 3600, '0'),
(32, 'CEST', '2437606800', 7200, '1'),
(32, 'CET', '2455750800', 3600, '0'),
(32, 'CEST', '2469056400', 7200, '1'),
(32, 'CET', '2487200400', 3600, '0'),
(32, 'CEST', '2500506000', 7200, '1'),
(32, 'CET', '2519254800', 3600, '0'),
(32, 'CEST', '2531955600', 7200, '1'),
(32, 'CET', '2550704400', 3600, '0'),
(32, 'CEST', '2563405200', 7200, '1'),
(32, 'CET', '2582154000', 3600, '0'),
(32, 'CEST', '2595459600', 7200, '1'),
(32, 'CET', '2613603600', 3600, '0'),
(32, 'CEST', '2626909200', 7200, '1'),
(32, 'CET', '2645053200', 3600, '0'),
(32, 'CEST', '2658358800', 7200, '1'),
(32, 'CET', '2676502800', 3600, '0'),
(32, 'CEST', '2689808400', 7200, '1'),
(32, 'CET', '2708557200', 3600, '0'),
(32, 'CEST', '2721258000', 7200, '1'),
(32, 'CET', '2740006800', 3600, '0'),
(32, 'CEST', '2752707600', 7200, '1'),
(32, 'CET', '2771456400', 3600, '0'),
(32, 'CEST', '2784762000', 7200, '1'),
(32, 'CET', '2802906000', 3600, '0'),
(32, 'CEST', '2816211600', 7200, '1'),
(32, 'CET', '2834355600', 3600, '0'),
(32, 'CEST', '2847661200', 7200, '1'),
(32, 'CET', '2866410000', 3600, '0'),
(32, 'CEST', '2879110800', 7200, '1'),
(32, 'CET', '2897859600', 3600, '0'),
(32, 'CEST', '2910560400', 7200, '1'),
(32, 'CET', '2929309200', 3600, '0'),
(32, 'CEST', '2942010000', 7200, '1'),
(32, 'CET', '2960758800', 3600, '0'),
(32, 'CEST', '2974064400', 7200, '1'),
(32, 'CET', '2992208400', 3600, '0'),
(32, 'CEST', '3005514000', 7200, '1'),
(32, 'CET', '3023658000', 3600, '0'),
(32, 'CEST', '3036963600', 7200, '1'),
(32, 'CET', '3055712400', 3600, '0'),
(32, 'CEST', '3068413200', 7200, '1'),
(32, 'CET', '3087162000', 3600, '0'),
(32, 'CEST', '3099862800', 7200, '1'),
(32, 'CET', '3118611600', 3600, '0'),
(32, 'CEST', '3131917200', 7200, '1'),
(32, 'CET', '3150061200', 3600, '0'),
(32, 'CEST', '3163366800', 7200, '1'),
(32, 'CET', '3181510800', 3600, '0'),
(32, 'CEST', '3194816400', 7200, '1'),
(32, 'CET', '3212960400', 3600, '0'),
(32, 'CEST', '3226266000', 7200, '1'),
(32, 'CET', '3245014800', 3600, '0'),
(32, 'CEST', '3257715600', 7200, '1'),
(32, 'CET', '3276464400', 3600, '0'),
(32, 'CEST', '3289165200', 7200, '1'),
(32, 'CET', '3307914000', 3600, '0'),
(32, 'CEST', '3321219600', 7200, '1'),
(32, 'CET', '3339363600', 3600, '0'),
(32, 'CEST', '3352669200', 7200, '1'),
(32, 'CET', '3370813200', 3600, '0'),
(32, 'CEST', '3384118800', 7200, '1'),
(32, 'CET', '3402867600', 3600, '0'),
(32, 'CEST', '3415568400', 7200, '1'),
(32, 'CET', '3434317200', 3600, '0'),
(32, 'CEST', '3447018000', 7200, '1'),
(32, 'CET', '3465766800', 3600, '0'),
(32, 'CEST', '3479072400', 7200, '1'),
(32, 'CET', '3497216400', 3600, '0'),
(32, 'CEST', '3510522000', 7200, '1'),
(32, 'CET', '3528666000', 3600, '0'),
(32, 'CEST', '3541971600', 7200, '1'),
(32, 'CET', '3560115600', 3600, '0'),
(32, 'CEST', '3573421200', 7200, '1'),
(32, 'CET', '3592170000', 3600, '0'),
(32, 'CEST', '3604870800', 7200, '1'),
(32, 'CET', '3623619600', 3600, '0'),
(32, 'CEST', '3636320400', 7200, '1'),
(32, 'CET', '3655069200', 3600, '0'),
(32, 'CEST', '3668374800', 7200, '1'),
(32, 'CET', '3686518800', 3600, '0'),
(32, 'CEST', '3699824400', 7200, '1'),
(32, 'CET', '3717968400', 3600, '0'),
(32, 'CEST', '3731274000', 7200, '1'),
(32, 'CET', '3750022800', 3600, '0'),
(32, 'CEST', '3762723600', 7200, '1'),
(32, 'CET', '3781472400', 3600, '0'),
(32, 'CEST', '3794173200', 7200, '1'),
(32, 'CET', '3812922000', 3600, '0'),
(32, 'CEST', '3825622800', 7200, '1'),
(32, 'CET', '3844371600', 3600, '0'),
(32, 'CEST', '3857677200', 7200, '1'),
(32, 'CET', '3875821200', 3600, '0'),
(32, 'CEST', '3889126800', 7200, '1'),
(32, 'CET', '3907270800', 3600, '0'),
(32, 'CEST', '3920576400', 7200, '1'),
(32, 'CET', '3939325200', 3600, '0'),
(32, 'CEST', '3952026000', 7200, '1'),
(32, 'CET', '3970774800', 3600, '0'),
(32, 'CEST', '3983475600', 7200, '1'),
(32, 'CET', '4002224400', 3600, '0'),
(32, 'CEST', '4015530000', 7200, '1'),
(32, 'CET', '4033674000', 3600, '0'),
(32, 'CEST', '4046979600', 7200, '1'),
(32, 'CET', '4065123600', 3600, '0'),
(32, 'CEST', '4078429200', 7200, '1'),
(32, 'CET', '4096573200', 3600, '0'),
(32, 'CEST', '4109878800', 7200, '1'),
(32, 'CET', '4128627600', 3600, '0'),
(32, 'CEST', '4141328400', 7200, '1'),
(32, 'CET', '4160077200', 3600, '0'),
(32, 'CEST', '4172778000', 7200, '1'),
(32, 'CET', '4191526800', 3600, '0'),
(32, 'CEST', '4204227600', 7200, '1'),
(32, 'CET', '4222976400', 3600, '0'),
(32, 'CEST', '4236282000', 7200, '1'),
(32, 'CET', '4254426000', 3600, '0'),
(32, 'CEST', '4267731600', 7200, '1'),
(32, 'CET', '4285875600', 3600, '0'),
(32, 'CEST', '4299181200', 7200, '1'),
(32, 'CET', '4317930000', 3600, '0'),
(32, 'CEST', '4330630800', 7200, '1'),
(32, 'CET', '4349379600', 3600, '0'),
(32, 'CEST', '4362080400', 7200, '1'),
(32, 'CET', '4380829200', 3600, '0'),
(32, 'CEST', '4394134800', 7200, '1'),
(32, 'CET', '4412278800', 3600, '0'),
(32, 'CEST', '4425584400', 7200, '1'),
(32, 'CET', '4443728400', 3600, '0'),
(32, 'CEST', '4457034000', 7200, '1'),
(32, 'CET', '4475178000', 3600, '0'),
(32, 'CEST', '4488483600', 7200, '1'),
(32, 'CET', '4507232400', 3600, '0'),
(32, 'CEST', '4519933200', 7200, '1'),
(32, 'CET', '4538682000', 3600, '0'),
(32, 'CEST', '4551382800', 7200, '1'),
(32, 'CET', '4570131600', 3600, '0'),
(32, 'CEST', '4583437200', 7200, '1'),
(32, 'CET', '4601581200', 3600, '0'),
(32, 'CEST', '4614886800', 7200, '1'),
(32, 'CET', '4633030800', 3600, '0'),
(32, 'CEST', '4646336400', 7200, '1'),
(32, 'CET', '4665085200', 3600, '0'),
(32, 'CEST', '4677786000', 7200, '1'),
(32, 'CET', '4696534800', 3600, '0'),
(32, 'CEST', '4709235600', 7200, '1'),
(32, 'CET', '4727984400', 3600, '0'),
(32, 'CEST', '4741290000', 7200, '1'),
(32, 'CET', '4759434000', 3600, '0'),
(32, 'CEST', '4772739600', 7200, '1'),
(32, 'CET', '4790883600', 3600, '0'),
(32, 'CEST', '4804189200', 7200, '1'),
(32, 'CET', '4822333200', 3600, '0'),
(32, 'CEST', '4835638800', 7200, '1'),
(32, 'CET', '4854387600', 3600, '0'),
(32, 'CEST', '4867088400', 7200, '1'),
(32, 'CET', '4885837200', 3600, '0'),
(32, 'CEST', '4898538000', 7200, '1'),
(32, 'CET', '4917286800', 3600, '0'),
(32, 'CEST', '4930592400', 7200, '1'),
(32, 'CET', '4948736400', 3600, '0'),
(32, 'CEST', '4962042000', 7200, '1'),
(32, 'CET', '4980186000', 3600, '0'),
(32, 'CEST', '4993491600', 7200, '1'),
(32, 'CET', '5012240400', 3600, '0'),
(32, 'CEST', '5024941200', 7200, '1'),
(32, 'CET', '5043690000', 3600, '0'),
(32, 'CEST', '5056390800', 7200, '1'),
(32, 'CET', '5075139600', 3600, '0'),
(32, 'CEST', '5087840400', 7200, '1'),
(32, 'CET', '5106589200', 3600, '0'),
(32, 'CEST', '5119894800', 7200, '1'),
(32, 'CET', '5138038800', 3600, '0'),
(32, 'CEST', '5151344400', 7200, '1'),
(32, 'CET', '5169488400', 3600, '0'),
(32, 'CEST', '5182794000', 7200, '1'),
(32, 'CET', '5201542800', 3600, '0'),
(32, 'CEST', '5214243600', 7200, '1'),
(32, 'CET', '5232992400', 3600, '0'),
(32, 'CEST', '5245693200', 7200, '1'),
(32, 'CET', '5264442000', 3600, '0'),
(32, 'CEST', '5277747600', 7200, '1'),
(32, 'CET', '5295891600', 3600, '0'),
(32, 'CEST', '5309197200', 7200, '1'),
(32, 'CET', '5327341200', 3600, '0'),
(32, 'CEST', '5340646800', 7200, '1'),
(32, 'CET', '5358790800', 3600, '0'),
(32, 'CEST', '5372096400', 7200, '1'),
(32, 'CET', '5390845200', 3600, '0'),
(32, 'CEST', '5403546000', 7200, '1'),
(32, 'CET', '5422294800', 3600, '0'),
(32, 'CEST', '5434995600', 7200, '1'),
(32, 'CET', '5453744400', 3600, '0'),
(32, 'CEST', '5467050000', 7200, '1'),
(32, 'CET', '5485194000', 3600, '0'),
(32, 'CEST', '5498499600', 7200, '1'),
(32, 'CET', '5516643600', 3600, '0'),
(32, 'CEST', '5529949200', 7200, '1'),
(32, 'CET', '5548698000', 3600, '0'),
(32, 'CEST', '5561398800', 7200, '1'),
(32, 'CET', '5580147600', 3600, '0'),
(32, 'CEST', '5592848400', 7200, '1'),
(32, 'CET', '5611597200', 3600, '0'),
(32, 'CEST', '5624902800', 7200, '1'),
(32, 'CET', '5643046800', 3600, '0'),
(32, 'CEST', '5656352400', 7200, '1'),
(32, 'CET', '5674496400', 3600, '0'),
(32, 'CEST', '5687802000', 7200, '1'),
(32, 'CET', '5705946000', 3600, '0'),
(32, 'CEST', '5719251600', 7200, '1'),
(32, 'CET', '5738000400', 3600, '0'),
(32, 'CEST', '5750701200', 7200, '1'),
(32, 'CET', '5769450000', 3600, '0'),
(32, 'CEST', '5782150800', 7200, '1'),
(32, 'CET', '5800899600', 3600, '0'),
(32, 'CEST', '5814205200', 7200, '1'),
(32, 'CET', '5832349200', 3600, '0'),
(32, 'CEST', '5845654800', 7200, '1'),
(32, 'CET', '5863798800', 3600, '0'),
(32, 'CEST', '5877104400', 7200, '1'),
(32, 'CET', '5895853200', 3600, '0'),
(32, 'CEST', '5908554000', 7200, '1'),
(32, 'CET', '5927302800', 3600, '0'),
(32, 'CEST', '5940003600', 7200, '1'),
(32, 'CET', '5958752400', 3600, '0'),
(32, 'CEST', '5971453200', 7200, '1'),
(32, 'CET', '5990202000', 3600, '0'),
(32, 'CEST', '6003507600', 7200, '1'),
(32, 'CET', '6021651600', 3600, '0'),
(32, 'CEST', '6034957200', 7200, '1'),
(32, 'CET', '6053101200', 3600, '0'),
(32, 'CEST', '6066406800', 7200, '1'),
(32, 'CET', '6085155600', 3600, '0'),
(32, 'CEST', '6097856400', 7200, '1'),
(32, 'CET', '6116605200', 3600, '0'),
(32, 'CEST', '6129306000', 7200, '1'),
(32, 'CET', '6148054800', 3600, '0'),
(32, 'CEST', '6161360400', 7200, '1'),
(32, 'CET', '6179504400', 3600, '0'),
(32, 'CEST', '6192810000', 7200, '1'),
(32, 'CET', '6210954000', 3600, '0'),
(32, 'CEST', '6224259600', 7200, '1'),
(32, 'CET', '6242403600', 3600, '0'),
(32, 'CEST', '6255709200', 7200, '1'),
(32, 'CET', '6274458000', 3600, '0'),
(32, 'CEST', '6287158800', 7200, '1'),
(32, 'CET', '6305907600', 3600, '0'),
(32, 'CEST', '6318608400', 7200, '1'),
(32, 'CET', '6337357200', 3600, '0'),
(32, 'CEST', '6350662800', 7200, '1'),
(32, 'CET', '6368806800', 3600, '0'),
(32, 'CEST', '6382112400', 7200, '1'),
(32, 'CET', '6400256400', 3600, '0'),
(32, 'CEST', '6413562000', 7200, '1'),
(32, 'CET', '6432310800', 3600, '0'),
(32, 'CEST', '6445011600', 7200, '1'),
(32, 'CET', '6463760400', 3600, '0'),
(32, 'CEST', '6476461200', 7200, '1'),
(32, 'CET', '6495210000', 3600, '0'),
(32, 'CEST', '6508515600', 7200, '1'),
(32, 'CET', '6526659600', 3600, '0'),
(32, 'CEST', '6539965200', 7200, '1'),
(32, 'CET', '6558109200', 3600, '0'),
(32, 'CEST', '6571414800', 7200, '1'),
(32, 'CET', '6589558800', 3600, '0'),
(32, 'CEST', '6602864400', 7200, '1'),
(32, 'CET', '6621613200', 3600, '0'),
(32, 'CEST', '6634314000', 7200, '1'),
(32, 'CET', '6653062800', 3600, '0'),
(32, 'CEST', '6665763600', 7200, '1'),
(32, 'CET', '6684512400', 3600, '0'),
(32, 'CEST', '6697818000', 7200, '1'),
(32, 'CET', '6715962000', 3600, '0'),
(32, 'CEST', '6729267600', 7200, '1'),
(32, 'CET', '6747411600', 3600, '0'),
(32, 'CEST', '6760717200', 7200, '1'),
(32, 'CET', '6779466000', 3600, '0'),
(32, 'CEST', '6792166800', 7200, '1'),
(32, 'CET', '6810915600', 3600, '0'),
(32, 'CEST', '6823616400', 7200, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(32, 'CET', '6842365200', 3600, '0'),
(32, 'CEST', '6855066000', 7200, '1'),
(32, 'CET', '6873814800', 3600, '0'),
(32, 'CEST', '6887120400', 7200, '1'),
(32, 'CET', '6905264400', 3600, '0'),
(32, 'CEST', '6918570000', 7200, '1'),
(32, 'CET', '6936714000', 3600, '0'),
(32, 'CEST', '6950019600', 7200, '1'),
(32, 'CET', '6968768400', 3600, '0'),
(32, 'CEST', '6981469200', 7200, '1'),
(32, 'CET', '7000218000', 3600, '0'),
(32, 'CEST', '7012918800', 7200, '1'),
(32, 'CET', '7031667600', 3600, '0'),
(32, 'CEST', '7044973200', 7200, '1'),
(32, 'CET', '7063117200', 3600, '0'),
(32, 'CEST', '7076422800', 7200, '1'),
(32, 'CET', '7094566800', 3600, '0'),
(32, 'CEST', '7107872400', 7200, '1'),
(32, 'CET', '7126016400', 3600, '0'),
(32, 'CEST', '7139322000', 7200, '1'),
(32, 'CET', '7158070800', 3600, '0'),
(32, 'CEST', '7170771600', 7200, '1'),
(32, 'CET', '7189520400', 3600, '0'),
(32, 'CEST', '7202221200', 7200, '1'),
(32, 'CET', '7220970000', 3600, '0'),
(32, 'CEST', '7234275600', 7200, '1'),
(32, 'CET', '7252419600', 3600, '0'),
(32, 'CEST', '7265725200', 7200, '1'),
(32, 'CET', '7283869200', 3600, '0'),
(32, 'CEST', '7297174800', 7200, '1'),
(32, 'CET', '7315318800', 3600, '0'),
(32, 'CEST', '7328624400', 7200, '1'),
(32, 'CET', '7347373200', 3600, '0'),
(32, 'CEST', '7360074000', 7200, '1'),
(32, 'CET', '7378822800', 3600, '0'),
(32, 'CEST', '7391523600', 7200, '1'),
(32, 'CET', '7410272400', 3600, '0'),
(32, 'CEST', '7423578000', 7200, '1'),
(32, 'CET', '7441722000', 3600, '0'),
(32, 'CEST', '7455027600', 7200, '1'),
(32, 'CET', '7473171600', 3600, '0'),
(32, 'CEST', '7486477200', 7200, '1'),
(32, 'CET', '7504621200', 3600, '0'),
(32, 'CEST', '7517926800', 7200, '1'),
(32, 'CET', '7536675600', 3600, '0'),
(32, 'CEST', '7549376400', 7200, '1'),
(32, 'CET', '7568125200', 3600, '0'),
(32, 'CEST', '7580826000', 7200, '1'),
(32, 'CET', '7599574800', 3600, '0'),
(32, 'CEST', '7612880400', 7200, '1'),
(32, 'CET', '7631024400', 3600, '0'),
(32, 'CEST', '7644330000', 7200, '1'),
(32, 'CET', '7662474000', 3600, '0'),
(32, 'CEST', '7675779600', 7200, '1'),
(32, 'CET', '7694528400', 3600, '0'),
(32, 'CEST', '7707229200', 7200, '1'),
(32, 'CET', '7725978000', 3600, '0'),
(32, 'CEST', '7738678800', 7200, '1'),
(32, 'CET', '7757427600', 3600, '0'),
(32, 'CEST', '7770733200', 7200, '1'),
(32, 'CET', '7788877200', 3600, '0'),
(32, 'CEST', '7802182800', 7200, '1'),
(32, 'CET', '7820326800', 3600, '0'),
(32, 'CEST', '7833632400', 7200, '1'),
(32, 'CET', '7851776400', 3600, '0'),
(32, 'CEST', '7865082000', 7200, '1'),
(32, 'CET', '7883830800', 3600, '0'),
(32, 'CEST', '7896531600', 7200, '1'),
(32, 'CET', '7915280400', 3600, '0'),
(32, 'CEST', '7927981200', 7200, '1'),
(32, 'CET', '7946730000', 3600, '0'),
(32, 'CEST', '7960035600', 7200, '1'),
(32, 'CET', '7978179600', 3600, '0'),
(32, 'CEST', '7991485200', 7200, '1'),
(32, 'CET', '8009629200', 3600, '0'),
(32, 'CEST', '8022934800', 7200, '1'),
(32, 'CET', '8041683600', 3600, '0'),
(32, 'CEST', '8054384400', 7200, '1'),
(32, 'CET', '8073133200', 3600, '0'),
(32, 'CEST', '8085834000', 7200, '1'),
(32, 'CET', '8104582800', 3600, '0'),
(32, 'CEST', '8117283600', 7200, '1'),
(32, 'CET', '8136032400', 3600, '0'),
(32, 'CEST', '8149338000', 7200, '1'),
(32, 'CET', '8167482000', 3600, '0'),
(32, 'CEST', '8180787600', 7200, '1'),
(32, 'CET', '8198931600', 3600, '0'),
(32, 'CEST', '8212237200', 7200, '1'),
(32, 'CET', '8230986000', 3600, '0'),
(32, 'CEST', '8243686800', 7200, '1'),
(32, 'CET', '8262435600', 3600, '0'),
(32, 'CEST', '8275136400', 7200, '1'),
(32, 'CET', '8293885200', 3600, '0'),
(32, 'CEST', '8307190800', 7200, '1'),
(32, 'CET', '8325334800', 3600, '0'),
(32, 'CEST', '8338640400', 7200, '1'),
(32, 'CET', '8356784400', 3600, '0'),
(32, 'CEST', '8370090000', 7200, '1'),
(32, 'CET', '8388234000', 3600, '0'),
(32, 'CEST', '8401539600', 7200, '1'),
(32, 'CET', '8420288400', 3600, '0'),
(32, 'CEST', '8432989200', 7200, '1'),
(32, 'CET', '8451738000', 3600, '0'),
(32, 'CEST', '8464438800', 7200, '1'),
(32, 'CET', '8483187600', 3600, '0'),
(32, 'CEST', '8496493200', 7200, '1'),
(32, 'CET', '8514637200', 3600, '0'),
(32, 'CEST', '8527942800', 7200, '1'),
(32, 'CET', '8546086800', 3600, '0'),
(32, 'CEST', '8559392400', 7200, '1'),
(32, 'CET', '8578141200', 3600, '0'),
(32, 'CEST', '8590842000', 7200, '1'),
(32, 'CET', '8609590800', 3600, '0'),
(32, 'CEST', '8622291600', 7200, '1'),
(32, 'CET', '8641040400', 3600, '0'),
(32, 'CEST', '8654346000', 7200, '1'),
(32, 'CET', '8672490000', 3600, '0'),
(32, 'CEST', '8685795600', 7200, '1'),
(32, 'CET', '8703939600', 3600, '0'),
(32, 'CEST', '8717245200', 7200, '1'),
(32, 'CET', '8735389200', 3600, '0'),
(32, 'CEST', '8748694800', 7200, '1'),
(32, 'CET', '8767443600', 3600, '0'),
(32, 'CEST', '8780144400', 7200, '1'),
(32, 'CET', '8798893200', 3600, '0'),
(32, 'CEST', '8811594000', 7200, '1'),
(32, 'CET', '8830342800', 3600, '0'),
(32, 'CEST', '8843648400', 7200, '1'),
(32, 'CET', '8861792400', 3600, '0'),
(32, 'CEST', '8875098000', 7200, '1'),
(32, 'CET', '8893242000', 3600, '0'),
(32, 'CEST', '8906547600', 7200, '1'),
(32, 'CET', '8925296400', 3600, '0'),
(32, 'CEST', '8937997200', 7200, '1'),
(32, 'CET', '8956746000', 3600, '0'),
(32, 'CEST', '8969446800', 7200, '1'),
(32, 'CET', '8988195600', 3600, '0'),
(32, 'CEST', '9000896400', 7200, '1'),
(32, 'CET', '9019645200', 3600, '0'),
(32, 'CEST', '9032950800', 7200, '1'),
(32, 'CET', '9051094800', 3600, '0'),
(32, 'CEST', '9064400400', 7200, '1'),
(32, 'CET', '9082544400', 3600, '0'),
(32, 'CEST', '9095850000', 7200, '1'),
(32, 'CET', '9114598800', 3600, '0'),
(32, 'CEST', '9127299600', 7200, '1'),
(32, 'CET', '9146048400', 3600, '0'),
(32, 'CEST', '9158749200', 7200, '1'),
(32, 'CET', '9177498000', 3600, '0'),
(32, 'CEST', '9190803600', 7200, '1'),
(32, 'CET', '9208947600', 3600, '0'),
(32, 'CEST', '9222253200', 7200, '1'),
(32, 'CET', '9240397200', 3600, '0'),
(32, 'CEST', '9253702800', 7200, '1'),
(32, 'CET', '9271846800', 3600, '0'),
(32, 'CEST', '9285152400', 7200, '1'),
(32, 'CET', '9303901200', 3600, '0'),
(32, 'CEST', '9316602000', 7200, '1'),
(32, 'CET', '9335350800', 3600, '0'),
(32, 'CEST', '9348051600', 7200, '1'),
(32, 'CET', '9366800400', 3600, '0'),
(32, 'CEST', '9380106000', 7200, '1'),
(32, 'CET', '9398250000', 3600, '0'),
(32, 'CEST', '9411555600', 7200, '1'),
(32, 'CET', '9429699600', 3600, '0'),
(32, 'CEST', '9443005200', 7200, '1'),
(32, 'CET', '9461754000', 3600, '0'),
(32, 'CEST', '9474454800', 7200, '1'),
(32, 'CET', '9493203600', 3600, '0'),
(32, 'CEST', '9505904400', 7200, '1'),
(32, 'CET', '9524653200', 3600, '0'),
(32, 'CEST', '9537958800', 7200, '1'),
(32, 'CET', '9556102800', 3600, '0'),
(32, 'CEST', '9569408400', 7200, '1'),
(32, 'CET', '9587552400', 3600, '0'),
(32, 'CEST', '9600858000', 7200, '1'),
(32, 'CET', '9619002000', 3600, '0'),
(32, 'CEST', '9632307600', 7200, '1'),
(32, 'CET', '9651056400', 3600, '0'),
(32, 'CEST', '9663757200', 7200, '1'),
(32, 'CET', '9682506000', 3600, '0'),
(32, 'CEST', '9695206800', 7200, '1'),
(32, 'CET', '9713955600', 3600, '0'),
(32, 'CEST', '9727261200', 7200, '1'),
(32, 'CET', '9745405200', 3600, '0'),
(32, 'CEST', '9758710800', 7200, '1'),
(32, 'CET', '9776854800', 3600, '0'),
(32, 'CEST', '9790160400', 7200, '1'),
(32, 'CET', '9808909200', 3600, '0'),
(32, 'CEST', '9821610000', 7200, '1'),
(32, 'CET', '9840358800', 3600, '0'),
(32, 'CEST', '9853059600', 7200, '1'),
(32, 'CET', '9871808400', 3600, '0'),
(32, 'CEST', '9884509200', 7200, '1'),
(32, 'CET', '9903258000', 3600, '0'),
(32, 'CEST', '9916563600', 7200, '1'),
(32, 'CET', '9934707600', 3600, '0'),
(32, 'CEST', '9948013200', 7200, '1'),
(32, 'CET', '9966157200', 3600, '0'),
(32, 'CEST', '9979462800', 7200, '1'),
(32, 'CET', '9998211600', 3600, '0'),
(32, 'CEST', '10010912400', 7200, '1'),
(32, 'CET', '10029661200', 3600, '0'),
(32, 'CEST', '10042362000', 7200, '1'),
(32, 'CET', '10061110800', 3600, '0'),
(32, 'CEST', '10074416400', 7200, '1'),
(32, 'CET', '10092560400', 3600, '0'),
(32, 'CEST', '10105866000', 7200, '1'),
(32, 'CET', '10124010000', 3600, '0'),
(32, 'CEST', '10137315600', 7200, '1'),
(32, 'CET', '10155459600', 3600, '0'),
(32, 'CEST', '10168765200', 7200, '1'),
(32, 'CET', '10187514000', 3600, '0'),
(32, 'CEST', '10200214800', 7200, '1'),
(32, 'CET', '10218963600', 3600, '0'),
(32, 'CEST', '10231664400', 7200, '1'),
(32, 'CET', '10250413200', 3600, '0'),
(32, 'CEST', '10263718800', 7200, '1'),
(32, 'CET', '10281862800', 3600, '0'),
(32, 'CEST', '10295168400', 7200, '1'),
(32, 'CET', '10313312400', 3600, '0'),
(32, 'CEST', '10326618000', 7200, '1'),
(32, 'CET', '10345366800', 3600, '0'),
(32, 'CEST', '10358067600', 7200, '1'),
(32, 'CET', '10376816400', 3600, '0'),
(32, 'CEST', '10389517200', 7200, '1'),
(32, 'CET', '10408266000', 3600, '0'),
(32, 'CEST', '10420966800', 7200, '1'),
(32, 'CET', '10439715600', 3600, '0'),
(32, 'CEST', '10453021200', 7200, '1'),
(32, 'CET', '10471165200', 3600, '0'),
(32, 'CEST', '10484470800', 7200, '1'),
(32, 'CET', '10502614800', 3600, '0'),
(32, 'CEST', '10515920400', 7200, '1'),
(32, 'CET', '10534064400', 3600, '0'),
(32, 'CEST', '10547370000', 7200, '1'),
(32, 'CET', '10566118800', 3600, '0'),
(32, 'CEST', '10578819600', 7200, '1'),
(32, 'CET', '10597568400', 3600, '0'),
(32, 'CEST', '10610269200', 7200, '1'),
(32, 'CET', '10629018000', 3600, '0'),
(32, 'CEST', '10642323600', 7200, '1'),
(32, 'CET', '10660467600', 3600, '0'),
(32, 'CEST', '10673773200', 7200, '1'),
(32, 'CET', '10691917200', 3600, '0'),
(32, 'CEST', '10705222800', 7200, '1'),
(32, 'CET', '10723971600', 3600, '0'),
(32, 'CEST', '10736672400', 7200, '1'),
(32, 'CET', '10755421200', 3600, '0'),
(32, 'CEST', '10768122000', 7200, '1'),
(32, 'CET', '10786870800', 3600, '0'),
(32, 'CEST', '10800176400', 7200, '1'),
(32, 'CET', '10818320400', 3600, '0'),
(32, 'CEST', '10831626000', 7200, '1'),
(32, 'CET', '10849770000', 3600, '0'),
(32, 'CEST', '10863075600', 7200, '1'),
(32, 'CET', '10881219600', 3600, '0'),
(32, 'CEST', '10894525200', 7200, '1'),
(32, 'CET', '10913274000', 3600, '0'),
(32, 'CEST', '10925974800', 7200, '1'),
(32, 'CET', '10944723600', 3600, '0'),
(32, 'CEST', '10957424400', 7200, '1'),
(32, 'CET', '10976173200', 3600, '0'),
(32, 'CEST', '10989478800', 7200, '1'),
(32, 'CET', '11007622800', 3600, '0'),
(32, 'CEST', '11020928400', 7200, '1'),
(32, 'CET', '11039072400', 3600, '0'),
(32, 'CEST', '11052378000', 7200, '1'),
(32, 'CET', '11071126800', 3600, '0'),
(32, 'CEST', '11083827600', 7200, '1'),
(32, 'CET', '11102576400', 3600, '0'),
(32, 'CEST', '11115277200', 7200, '1'),
(32, 'CET', '11134026000', 3600, '0'),
(32, 'CEST', '11146726800', 7200, '1'),
(32, 'CET', '11165475600', 3600, '0'),
(32, 'CEST', '11178781200', 7200, '1'),
(32, 'CET', '11196925200', 3600, '0'),
(32, 'CEST', '11210230800', 7200, '1'),
(32, 'CET', '11228374800', 3600, '0'),
(32, 'CEST', '11241680400', 7200, '1'),
(32, 'CET', '11260429200', 3600, '0'),
(32, 'CEST', '11273130000', 7200, '1'),
(32, 'CET', '11291878800', 3600, '0'),
(32, 'CEST', '11304579600', 7200, '1'),
(32, 'CET', '11323328400', 3600, '0'),
(32, 'CEST', '11336634000', 7200, '1'),
(32, 'CET', '11354778000', 3600, '0'),
(32, 'CEST', '11368083600', 7200, '1'),
(32, 'CET', '11386227600', 3600, '0'),
(32, 'CEST', '11399533200', 7200, '1'),
(32, 'CET', '11417677200', 3600, '0'),
(32, 'CEST', '11430982800', 7200, '1'),
(32, 'CET', '11449731600', 3600, '0'),
(32, 'CEST', '11462432400', 7200, '1'),
(32, 'CET', '11481181200', 3600, '0'),
(32, 'CEST', '11493882000', 7200, '1'),
(32, 'CET', '11512630800', 3600, '0'),
(32, 'CEST', '11525936400', 7200, '1'),
(32, 'CET', '11544080400', 3600, '0'),
(32, 'CEST', '11557386000', 7200, '1'),
(32, 'CET', '11575530000', 3600, '0'),
(32, 'CEST', '11588835600', 7200, '1'),
(32, 'CET', '11607584400', 3600, '0'),
(32, 'CEST', '11620285200', 7200, '1'),
(32, 'CET', '11639034000', 3600, '0'),
(32, 'CEST', '11651734800', 7200, '1'),
(32, 'CET', '11670483600', 3600, '0'),
(32, 'CEST', '11683789200', 7200, '1'),
(32, 'CET', '11701933200', 3600, '0'),
(32, 'CEST', '11715238800', 7200, '1'),
(32, 'CET', '11733382800', 3600, '0'),
(32, 'CEST', '11746688400', 7200, '1'),
(32, 'CET', '11764832400', 3600, '0'),
(32, 'CEST', '11778138000', 7200, '1'),
(32, 'CET', '11796886800', 3600, '0'),
(32, 'CEST', '11809587600', 7200, '1'),
(32, 'CET', '11828336400', 3600, '0'),
(32, 'CEST', '11841037200', 7200, '1'),
(32, 'CET', '11859786000', 3600, '0'),
(32, 'CEST', '11873091600', 7200, '1'),
(32, 'CET', '11891235600', 3600, '0'),
(32, 'CEST', '11904541200', 7200, '1'),
(32, 'CET', '11922685200', 3600, '0'),
(32, 'CEST', '11935990800', 7200, '1'),
(32, 'CET', '11954739600', 3600, '0'),
(32, 'CEST', '11967440400', 7200, '1'),
(32, 'CET', '11986189200', 3600, '0'),
(32, 'CEST', '11998890000', 7200, '1'),
(32, 'CET', '12017638800', 3600, '0'),
(32, 'CEST', '12030339600', 7200, '1'),
(32, 'CET', '12049088400', 3600, '0'),
(32, 'CEST', '12062394000', 7200, '1'),
(32, 'CET', '12080538000', 3600, '0'),
(32, 'CEST', '12093843600', 7200, '1'),
(32, 'CET', '12111987600', 3600, '0'),
(32, 'CEST', '12125293200', 7200, '1'),
(32, 'CET', '12144042000', 3600, '0'),
(32, 'CEST', '12156742800', 7200, '1'),
(32, 'CET', '12175491600', 3600, '0'),
(32, 'CEST', '12188192400', 7200, '1'),
(32, 'CET', '12206941200', 3600, '0'),
(32, 'CEST', '12220246800', 7200, '1'),
(32, 'CET', '12238390800', 3600, '0'),
(32, 'CEST', '12251696400', 7200, '1'),
(32, 'CET', '12269840400', 3600, '0'),
(32, 'CEST', '12283146000', 7200, '1'),
(32, 'CET', '12301290000', 3600, '0'),
(32, 'CEST', '12314595600', 7200, '1'),
(32, 'CET', '12333344400', 3600, '0'),
(32, 'CEST', '12346045200', 7200, '1'),
(32, 'CET', '12364794000', 3600, '0'),
(32, 'CEST', '12377494800', 7200, '1'),
(32, 'CET', '12396243600', 3600, '0'),
(32, 'CEST', '12409549200', 7200, '1'),
(32, 'CET', '12427693200', 3600, '0'),
(32, 'CEST', '12440998800', 7200, '1'),
(32, 'CET', '12459142800', 3600, '0'),
(32, 'CEST', '12472448400', 7200, '1'),
(32, 'CET', '12491197200', 3600, '0'),
(32, 'CEST', '12503898000', 7200, '1'),
(32, 'CET', '12522646800', 3600, '0'),
(32, 'CEST', '12535347600', 7200, '1'),
(32, 'CET', '12554096400', 3600, '0'),
(32, 'CEST', '12567402000', 7200, '1'),
(32, 'CET', '12585546000', 3600, '0'),
(32, 'CEST', '12598851600', 7200, '1'),
(32, 'CET', '12616995600', 3600, '0'),
(32, 'CEST', '12630301200', 7200, '1'),
(32, 'CET', '12648445200', 3600, '0'),
(32, 'CEST', '12661750800', 7200, '1'),
(32, 'CET', '12680499600', 3600, '0'),
(32, 'CEST', '12693200400', 7200, '1'),
(32, 'CET', '12711949200', 3600, '0'),
(32, 'CEST', '12724650000', 7200, '1'),
(32, 'CET', '12743398800', 3600, '0'),
(32, 'CEST', '12756704400', 7200, '1'),
(32, 'CET', '12774848400', 3600, '0'),
(32, 'CEST', '12788154000', 7200, '1'),
(32, 'CET', '12806298000', 3600, '0'),
(32, 'CEST', '12819603600', 7200, '1'),
(32, 'CET', '12838352400', 3600, '0'),
(32, 'CEST', '12851053200', 7200, '1'),
(32, 'CET', '12869802000', 3600, '0'),
(32, 'CEST', '12882502800', 7200, '1'),
(32, 'CET', '12901251600', 3600, '0'),
(32, 'CEST', '12913952400', 7200, '1'),
(32, 'CET', '12932701200', 3600, '0'),
(32, 'CEST', '12946006800', 7200, '1'),
(32, 'CET', '12964150800', 3600, '0'),
(32, 'CEST', '12977456400', 7200, '1'),
(32, 'CET', '12995600400', 3600, '0'),
(32, 'CEST', '13008906000', 7200, '1'),
(32, 'CET', '13027654800', 3600, '0'),
(32, 'CEST', '13040355600', 7200, '1'),
(32, 'CET', '13059104400', 3600, '0'),
(32, 'CEST', '13071805200', 7200, '1'),
(32, 'CET', '13090554000', 3600, '0'),
(32, 'CEST', '13103859600', 7200, '1'),
(32, 'CET', '13122003600', 3600, '0'),
(32, 'CEST', '13135309200', 7200, '1'),
(32, 'CET', '13153453200', 3600, '0'),
(32, 'CEST', '13166758800', 7200, '1'),
(32, 'CET', '13184902800', 3600, '0'),
(32, 'CEST', '13198208400', 7200, '1'),
(32, 'CET', '13216957200', 3600, '0'),
(32, 'CEST', '13229658000', 7200, '1'),
(32, 'CET', '13248406800', 3600, '0'),
(32, 'CEST', '13261107600', 7200, '1'),
(32, 'CET', '13279856400', 3600, '0'),
(32, 'CEST', '13293162000', 7200, '1'),
(32, 'CET', '13311306000', 3600, '0'),
(32, 'CEST', '13324611600', 7200, '1'),
(32, 'CET', '13342755600', 3600, '0'),
(32, 'CEST', '13356061200', 7200, '1'),
(32, 'CET', '13374810000', 3600, '0'),
(32, 'CEST', '13387510800', 7200, '1'),
(32, 'CET', '13406259600', 3600, '0'),
(32, 'CEST', '13418960400', 7200, '1'),
(32, 'CET', '13437709200', 3600, '0'),
(32, 'CEST', '13451014800', 7200, '1'),
(32, 'CET', '13469158800', 3600, '0'),
(32, 'CEST', '13482464400', 7200, '1'),
(32, 'CET', '13500608400', 3600, '0'),
(32, 'CEST', '13513914000', 7200, '1'),
(32, 'CET', '13532058000', 3600, '0'),
(32, 'CEST', '13545363600', 7200, '1'),
(32, 'CET', '13564112400', 3600, '0'),
(32, 'CEST', '13576813200', 7200, '1'),
(32, 'CET', '13595562000', 3600, '0'),
(32, 'CEST', '13608262800', 7200, '1'),
(32, 'CET', '13627011600', 3600, '0'),
(32, 'CEST', '13640317200', 7200, '1'),
(32, 'CET', '13658461200', 3600, '0'),
(32, 'CEST', '13671766800', 7200, '1'),
(32, 'CET', '13689910800', 3600, '0'),
(32, 'CEST', '13703216400', 7200, '1'),
(32, 'CET', '13721965200', 3600, '0'),
(32, 'CEST', '13734666000', 7200, '1'),
(32, 'CET', '13753414800', 3600, '0'),
(32, 'CEST', '13766115600', 7200, '1'),
(32, 'CET', '13784864400', 3600, '0'),
(32, 'CEST', '13797565200', 7200, '1'),
(32, 'CET', '13816314000', 3600, '0'),
(32, 'CEST', '13829619600', 7200, '1'),
(32, 'CET', '13847763600', 3600, '0'),
(32, 'CEST', '13861069200', 7200, '1'),
(32, 'CET', '13879213200', 3600, '0'),
(32, 'CEST', '13892518800', 7200, '1'),
(32, 'CET', '13911267600', 3600, '0'),
(32, 'CEST', '13923968400', 7200, '1'),
(32, 'CET', '13942717200', 3600, '0'),
(32, 'CEST', '13955418000', 7200, '1'),
(32, 'CET', '13974166800', 3600, '0'),
(32, 'CEST', '13987472400', 7200, '1'),
(32, 'CET', '14005616400', 3600, '0'),
(32, 'CEST', '14018922000', 7200, '1'),
(32, 'CET', '14037066000', 3600, '0'),
(32, 'CEST', '14050371600', 7200, '1'),
(32, 'CET', '14068515600', 3600, '0'),
(32, 'CEST', '14081821200', 7200, '1'),
(32, 'CET', '14100570000', 3600, '0'),
(32, 'CEST', '14113270800', 7200, '1'),
(32, 'CET', '14132019600', 3600, '0'),
(32, 'CEST', '14144720400', 7200, '1'),
(32, 'CET', '14163469200', 3600, '0'),
(32, 'CEST', '14176774800', 7200, '1'),
(32, 'CET', '14194918800', 3600, '0'),
(32, 'CEST', '14208224400', 7200, '1'),
(32, 'CET', '14226368400', 3600, '0'),
(32, 'CEST', '14239674000', 7200, '1'),
(32, 'CET', '14258422800', 3600, '0'),
(32, 'CEST', '14271123600', 7200, '1'),
(32, 'CET', '14289872400', 3600, '0'),
(32, 'CEST', '14302573200', 7200, '1'),
(32, 'CET', '14321322000', 3600, '0'),
(32, 'CEST', '14334627600', 7200, '1'),
(32, 'CET', '14352771600', 3600, '0'),
(32, 'CEST', '14366077200', 7200, '1'),
(32, 'CET', '14384221200', 3600, '0'),
(32, 'CEST', '14397526800', 7200, '1'),
(32, 'CET', '14415670800', 3600, '0'),
(32, 'CEST', '14428976400', 7200, '1'),
(32, 'CET', '14447725200', 3600, '0'),
(32, 'CEST', '14460426000', 7200, '1'),
(32, 'CET', '14479174800', 3600, '0'),
(32, 'CEST', '14491875600', 7200, '1'),
(32, 'CET', '14510624400', 3600, '0'),
(32, 'CEST', '14523930000', 7200, '1'),
(32, 'CET', '14542074000', 3600, '0'),
(32, 'CEST', '14555379600', 7200, '1'),
(32, 'CET', '14573523600', 3600, '0'),
(32, 'CEST', '14586829200', 7200, '1'),
(32, 'CET', '14605578000', 3600, '0'),
(32, 'CEST', '14618278800', 7200, '1'),
(32, 'CET', '14637027600', 3600, '0'),
(32, 'CEST', '14649728400', 7200, '1'),
(32, 'CET', '14668477200', 3600, '0'),
(32, 'CEST', '14681178000', 7200, '1'),
(32, 'CET', '14699926800', 3600, '0'),
(32, 'CEST', '14713232400', 7200, '1'),
(32, 'CET', '14731376400', 3600, '0'),
(32, 'CEST', '14744682000', 7200, '1'),
(32, 'CET', '14762826000', 3600, '0'),
(32, 'CEST', '14776131600', 7200, '1'),
(32, 'CET', '14794880400', 3600, '0'),
(32, 'CEST', '14807581200', 7200, '1'),
(32, 'CET', '14826330000', 3600, '0'),
(32, 'CEST', '14839030800', 7200, '1'),
(32, 'CET', '14857779600', 3600, '0'),
(32, 'CEST', '14871085200', 7200, '1'),
(32, 'CET', '14889229200', 3600, '0'),
(32, 'CEST', '14902534800', 7200, '1'),
(32, 'CET', '14920678800', 3600, '0'),
(32, 'CEST', '14933984400', 7200, '1'),
(32, 'CET', '14952128400', 3600, '0'),
(32, 'CEST', '14965434000', 7200, '1'),
(32, 'CET', '14984182800', 3600, '0'),
(32, 'CEST', '14996883600', 7200, '1'),
(32, 'CET', '15015632400', 3600, '0'),
(32, 'CEST', '15028333200', 7200, '1'),
(32, 'CET', '15047082000', 3600, '0'),
(32, 'CEST', '15060387600', 7200, '1'),
(32, 'CET', '15078531600', 3600, '0'),
(32, 'CEST', '15091837200', 7200, '1'),
(32, 'CET', '15109981200', 3600, '0'),
(32, 'CEST', '15123286800', 7200, '1'),
(32, 'CET', '15142035600', 3600, '0'),
(32, 'CEST', '15154736400', 7200, '1'),
(32, 'CET', '15173485200', 3600, '0'),
(32, 'CEST', '15186186000', 7200, '1'),
(32, 'CET', '15204934800', 3600, '0'),
(32, 'CEST', '15218240400', 7200, '1'),
(32, 'CET', '15236384400', 3600, '0'),
(32, 'CEST', '15249690000', 7200, '1'),
(32, 'CET', '15267834000', 3600, '0'),
(32, 'CEST', '15281139600', 7200, '1'),
(32, 'CET', '15299283600', 3600, '0'),
(32, 'CEST', '15312589200', 7200, '1'),
(32, 'CET', '15331338000', 3600, '0'),
(32, 'CEST', '15344038800', 7200, '1'),
(32, 'CET', '15362787600', 3600, '0'),
(32, 'CEST', '15375488400', 7200, '1'),
(32, 'CET', '15394237200', 3600, '0'),
(32, 'CEST', '15407542800', 7200, '1'),
(32, 'CET', '15425686800', 3600, '0'),
(32, 'CEST', '15438992400', 7200, '1'),
(32, 'CET', '15457136400', 3600, '0'),
(32, 'CEST', '15470442000', 7200, '1'),
(32, 'CET', '15489190800', 3600, '0'),
(32, 'CEST', '15501891600', 7200, '1'),
(32, 'CET', '15520640400', 3600, '0'),
(32, 'CEST', '15533341200', 7200, '1'),
(32, 'CET', '15552090000', 3600, '0'),
(32, 'CEST', '15564790800', 7200, '1'),
(32, 'CET', '15583539600', 3600, '0'),
(32, 'CEST', '15596845200', 7200, '1'),
(32, 'CET', '15614989200', 3600, '0'),
(32, 'CEST', '15628294800', 7200, '1'),
(32, 'CET', '15646438800', 3600, '0'),
(32, 'CEST', '15659744400', 7200, '1'),
(32, 'CET', '15678493200', 3600, '0'),
(32, 'CEST', '15691194000', 7200, '1'),
(32, 'CET', '15709942800', 3600, '0'),
(32, 'CEST', '15722643600', 7200, '1'),
(32, 'CET', '15741392400', 3600, '0'),
(32, 'CEST', '15754698000', 7200, '1'),
(32, 'CET', '15772842000', 3600, '0'),
(32, 'CEST', '15786147600', 7200, '1'),
(32, 'CET', '15804291600', 3600, '0'),
(32, 'CEST', '15817597200', 7200, '1'),
(32, 'CET', '15835741200', 3600, '0'),
(32, 'CEST', '15849046800', 7200, '1'),
(32, 'CET', '15867795600', 3600, '0'),
(32, 'CEST', '15880496400', 7200, '1'),
(32, 'CET', '15899245200', 3600, '0'),
(32, 'CEST', '15911946000', 7200, '1'),
(32, 'CET', '15930694800', 3600, '0'),
(32, 'CEST', '15944000400', 7200, '1'),
(32, 'CET', '15962144400', 3600, '0'),
(32, 'CEST', '15975450000', 7200, '1'),
(32, 'CET', '15993594000', 3600, '0'),
(32, 'CEST', '16006899600', 7200, '1'),
(32, 'CET', '16025648400', 3600, '0'),
(32, 'CEST', '16038349200', 7200, '1'),
(32, 'CET', '16057098000', 3600, '0'),
(32, 'CEST', '16069798800', 7200, '1'),
(32, 'CET', '16088547600', 3600, '0'),
(32, 'CEST', '16101853200', 7200, '1'),
(32, 'CET', '16119997200', 3600, '0'),
(32, 'CEST', '16133302800', 7200, '1'),
(32, 'CET', '16151446800', 3600, '0'),
(32, 'CEST', '16164752400', 7200, '1'),
(32, 'CET', '16182896400', 3600, '0'),
(32, 'CEST', '16196202000', 7200, '1'),
(32, 'CET', '16214950800', 3600, '0'),
(32, 'CEST', '16227651600', 7200, '1'),
(32, 'CET', '16246400400', 3600, '0'),
(32, 'CEST', '16259101200', 7200, '1'),
(32, 'CET', '16277850000', 3600, '0'),
(32, 'CEST', '16291155600', 7200, '1'),
(32, 'CET', '16309299600', 3600, '0'),
(32, 'CEST', '16322605200', 7200, '1'),
(32, 'CET', '16340749200', 3600, '0'),
(32, 'CEST', '16354054800', 7200, '1'),
(32, 'CET', '16372803600', 3600, '0'),
(32, 'CEST', '16385504400', 7200, '1'),
(32, 'CET', '16404253200', 3600, '0'),
(32, 'CEST', '16416954000', 7200, '1'),
(32, 'CET', '16435702800', 3600, '0'),
(32, 'CEST', '16448403600', 7200, '1'),
(32, 'CET', '16467152400', 3600, '0'),
(32, 'CEST', '16480458000', 7200, '1'),
(32, 'CET', '16498602000', 3600, '0'),
(32, 'CEST', '16511907600', 7200, '1'),
(32, 'CET', '16530051600', 3600, '0'),
(32, 'CEST', '16543357200', 7200, '1'),
(32, 'CET', '16562106000', 3600, '0'),
(32, 'CEST', '16574806800', 7200, '1'),
(32, 'CET', '16593555600', 3600, '0'),
(32, 'CEST', '16606256400', 7200, '1'),
(32, 'CET', '16625005200', 3600, '0'),
(32, 'CEST', '16638310800', 7200, '1'),
(32, 'CET', '16656454800', 3600, '0'),
(32, 'CEST', '16669760400', 7200, '1'),
(32, 'CET', '16687904400', 3600, '0'),
(32, 'CEST', '16701210000', 7200, '1'),
(32, 'CET', '16719354000', 3600, '0'),
(33, 'LMT', '-2364114981', 38180, '0'),
(33, 'AEST', '-2364114980', 36000, '0'),
(33, '+1030', '352216800', 37800, '0'),
(33, '+1130', '372785400', 41400, '1'),
(33, '+1030', '384273000', 37800, '0'),
(33, '+1130', '404839800', 41400, '1'),
(33, '+1030', '415722600', 37800, '0'),
(33, '+1130', '436289400', 41400, '1'),
(33, '+1030', '447172200', 37800, '0'),
(33, '+1130', '467739000', 41400, '1'),
(33, '+1030', '478621800', 37800, '0'),
(33, '+11', '499188600', 39600, '1'),
(33, '+1030', '511282800', 37800, '0'),
(33, '+11', '530033400', 39600, '1'),
(33, '+1030', '542732400', 37800, '0'),
(33, '+11', '562087800', 39600, '1'),
(33, '+1030', '574786800', 37800, '0'),
(33, '+11', '594142200', 39600, '1'),
(33, '+1030', '606236400', 37800, '0'),
(33, '+11', '625591800', 39600, '1'),
(33, '+1030', '636476400', 37800, '0'),
(33, '+11', '657041400', 39600, '1'),
(33, '+1030', '667926000', 37800, '0'),
(33, '+11', '688491000', 39600, '1'),
(33, '+1030', '699375600', 37800, '0'),
(33, '+11', '719940600', 39600, '1'),
(33, '+1030', '731430000', 37800, '0'),
(33, '+11', '751995000', 39600, '1'),
(33, '+1030', '762879600', 37800, '0'),
(33, '+11', '783444600', 39600, '1'),
(33, '+1030', '794329200', 37800, '0'),
(33, '+11', '814894200', 39600, '1'),
(33, '+1030', '828198000', 37800, '0'),
(33, '+11', '846343800', 39600, '1'),
(33, '+1030', '859647600', 37800, '0'),
(33, '+11', '877793400', 39600, '1'),
(33, '+1030', '891097200', 37800, '0'),
(33, '+11', '909243000', 39600, '1'),
(33, '+1030', '922546800', 37800, '0'),
(33, '+11', '941297400', 39600, '1'),
(33, '+1030', '953996400', 37800, '0'),
(33, '+11', '967303800', 39600, '1'),
(33, '+1030', '985446000', 37800, '0'),
(33, '+11', '1004196600', 39600, '1'),
(33, '+1030', '1017500400', 37800, '0'),
(33, '+11', '1035646200', 39600, '1'),
(33, '+1030', '1048950000', 37800, '0'),
(33, '+11', '1067095800', 39600, '1'),
(33, '+1030', '1080399600', 37800, '0'),
(33, '+11', '1099150200', 39600, '1'),
(33, '+1030', '1111849200', 37800, '0'),
(33, '+11', '1130599800', 39600, '1'),
(33, '+1030', '1143903600', 37800, '0'),
(33, '+11', '1162049400', 39600, '1'),
(33, '+1030', '1174748400', 37800, '0'),
(33, '+11', '1193499000', 39600, '1'),
(33, '+1030', '1207407600', 37800, '0'),
(33, '+11', '1223134200', 39600, '1'),
(33, '+1030', '1238857200', 37800, '0'),
(33, '+11', '1254583800', 39600, '1'),
(33, '+1030', '1270306800', 37800, '0'),
(33, '+11', '1286033400', 39600, '1'),
(33, '+1030', '1301756400', 37800, '0'),
(33, '+11', '1317483000', 39600, '1'),
(33, '+1030', '1333206000', 37800, '0'),
(33, '+11', '1349537400', 39600, '1'),
(33, '+1030', '1365260400', 37800, '0'),
(33, '+11', '1380987000', 39600, '1'),
(33, '+1030', '1396710000', 37800, '0'),
(33, '+11', '1412436600', 39600, '1'),
(33, '+1030', '1428159600', 37800, '0'),
(33, '+11', '1443886200', 39600, '1'),
(33, '+1030', '1459609200', 37800, '0'),
(33, '+11', '1475335800', 39600, '1'),
(33, '+1030', '1491058800', 37800, '0'),
(33, '+11', '1506785400', 39600, '1'),
(33, '+1030', '1522508400', 37800, '0'),
(33, '+11', '1538839800', 39600, '1'),
(33, '+1030', '1554562800', 37800, '0'),
(33, '+11', '1570289400', 39600, '1'),
(33, '+1030', '1586012400', 37800, '0'),
(33, '+11', '1601739000', 39600, '1'),
(33, '+1030', '1617462000', 37800, '0'),
(33, '+11', '1633188600', 39600, '1'),
(33, '+1030', '1648911600', 37800, '0'),
(33, '+11', '1664638200', 39600, '1'),
(33, '+1030', '1680361200', 37800, '0'),
(33, '+11', '1696087800', 39600, '1'),
(33, '+1030', '1712415600', 37800, '0'),
(33, '+11', '1728142200', 39600, '1'),
(33, '+1030', '1743865200', 37800, '0'),
(33, '+11', '1759591800', 39600, '1'),
(33, '+1030', '1775314800', 37800, '0'),
(33, '+11', '1791041400', 39600, '1'),
(33, '+1030', '1806764400', 37800, '0'),
(33, '+11', '1822491000', 39600, '1'),
(33, '+1030', '1838214000', 37800, '0'),
(33, '+11', '1853940600', 39600, '1'),
(33, '+1030', '1869663600', 37800, '0'),
(33, '+11', '1885995000', 39600, '1'),
(33, '+1030', '1901718000', 37800, '0'),
(33, '+11', '1917444600', 39600, '1'),
(33, '+1030', '1933167600', 37800, '0'),
(33, '+11', '1948894200', 39600, '1'),
(33, '+1030', '1964617200', 37800, '0'),
(33, '+11', '1980343800', 39600, '1'),
(33, '+1030', '1996066800', 37800, '0'),
(33, '+11', '2011793400', 39600, '1'),
(33, '+1030', '2027516400', 37800, '0'),
(33, '+11', '2043243000', 39600, '1'),
(33, '+1030', '2058966000', 37800, '0'),
(33, '+11', '2075297400', 39600, '1'),
(33, '+1030', '2091020400', 37800, '0'),
(33, '+11', '2106747000', 39600, '1'),
(33, '+1030', '2122470000', 37800, '0'),
(33, '+11', '2138196600', 39600, '1'),
(33, '+1030', '2153919600', 37800, '0'),
(33, '+11', '2169646200', 39600, '1'),
(33, '+1030', '2185369200', 37800, '0'),
(33, '+11', '2201095800', 39600, '1'),
(33, '+1030', '2216818800', 37800, '0'),
(33, '+11', '2233150200', 39600, '1'),
(33, '+1030', '2248873200', 37800, '0'),
(33, '+11', '2264599800', 39600, '1'),
(33, '+1030', '2280322800', 37800, '0'),
(33, '+11', '2296049400', 39600, '1'),
(33, '+1030', '2311772400', 37800, '0'),
(33, '+11', '2327499000', 39600, '1'),
(33, '+1030', '2343222000', 37800, '0'),
(33, '+11', '2358948600', 39600, '1'),
(33, '+1030', '2374671600', 37800, '0'),
(33, '+11', '2390398200', 39600, '1'),
(33, '+1030', '2406121200', 37800, '0'),
(33, '+11', '2422452600', 39600, '1'),
(33, '+1030', '2438175600', 37800, '0'),
(33, '+11', '2453902200', 39600, '1'),
(33, '+1030', '2469625200', 37800, '0'),
(33, '+11', '2485351800', 39600, '1'),
(33, '+1030', '2501074800', 37800, '0'),
(33, '+11', '2516801400', 39600, '1'),
(33, '+1030', '2532524400', 37800, '0'),
(33, '+11', '2548251000', 39600, '1'),
(33, '+1030', '2563974000', 37800, '0'),
(33, '+11', '2579700600', 39600, '1'),
(33, '+1030', '2596028400', 37800, '0'),
(33, '+11', '2611755000', 39600, '1'),
(33, '+1030', '2627478000', 37800, '0'),
(33, '+11', '2643204600', 39600, '1'),
(33, '+1030', '2658927600', 37800, '0'),
(33, '+11', '2674654200', 39600, '1'),
(33, '+1030', '2690377200', 37800, '0'),
(33, '+11', '2706103800', 39600, '1'),
(33, '+1030', '2721826800', 37800, '0'),
(33, '+11', '2737553400', 39600, '1'),
(33, '+1030', '2753276400', 37800, '0'),
(33, '+11', '2769607800', 39600, '1'),
(33, '+1030', '2785330800', 37800, '0'),
(33, '+11', '2801057400', 39600, '1'),
(33, '+1030', '2816780400', 37800, '0'),
(33, '+11', '2832507000', 39600, '1'),
(33, '+1030', '2848230000', 37800, '0'),
(33, '+11', '2863956600', 39600, '1'),
(33, '+1030', '2879679600', 37800, '0'),
(33, '+11', '2895406200', 39600, '1'),
(33, '+1030', '2911129200', 37800, '0'),
(33, '+11', '2926855800', 39600, '1'),
(33, '+1030', '2942578800', 37800, '0'),
(33, '+11', '2958910200', 39600, '1'),
(33, '+1030', '2974633200', 37800, '0'),
(33, '+11', '2990359800', 39600, '1'),
(33, '+1030', '3006082800', 37800, '0'),
(33, '+11', '3021809400', 39600, '1'),
(33, '+1030', '3037532400', 37800, '0'),
(33, '+11', '3053259000', 39600, '1'),
(33, '+1030', '3068982000', 37800, '0'),
(33, '+11', '3084708600', 39600, '1'),
(33, '+1030', '3100431600', 37800, '0'),
(33, '+11', '3116763000', 39600, '1'),
(33, '+1030', '3132486000', 37800, '0'),
(33, '+11', '3148212600', 39600, '1'),
(33, '+1030', '3163935600', 37800, '0'),
(33, '+11', '3179662200', 39600, '1'),
(33, '+1030', '3195385200', 37800, '0'),
(33, '+11', '3211111800', 39600, '1'),
(33, '+1030', '3226834800', 37800, '0'),
(33, '+11', '3242561400', 39600, '1'),
(33, '+1030', '3258284400', 37800, '0'),
(33, '+11', '3274011000', 39600, '1'),
(33, '+1030', '3289734000', 37800, '0'),
(33, '+11', '3306065400', 39600, '1'),
(33, '+1030', '3321788400', 37800, '0'),
(33, '+11', '3337515000', 39600, '1'),
(33, '+1030', '3353238000', 37800, '0'),
(33, '+11', '3368964600', 39600, '1'),
(33, '+1030', '3384687600', 37800, '0'),
(33, '+11', '3400414200', 39600, '1'),
(33, '+1030', '3416137200', 37800, '0'),
(33, '+11', '3431863800', 39600, '1'),
(33, '+1030', '3447586800', 37800, '0'),
(33, '+11', '3463313400', 39600, '1'),
(33, '+1030', '3479641200', 37800, '0'),
(33, '+11', '3495367800', 39600, '1'),
(33, '+1030', '3511090800', 37800, '0'),
(33, '+11', '3526817400', 39600, '1'),
(33, '+1030', '3542540400', 37800, '0'),
(33, '+11', '3558267000', 39600, '1'),
(33, '+1030', '3573990000', 37800, '0'),
(33, '+11', '3589716600', 39600, '1'),
(33, '+1030', '3605439600', 37800, '0'),
(33, '+11', '3621166200', 39600, '1'),
(33, '+1030', '3636889200', 37800, '0'),
(33, '+11', '3653220600', 39600, '1'),
(33, '+1030', '3668943600', 37800, '0'),
(33, '+11', '3684670200', 39600, '1'),
(33, '+1030', '3700393200', 37800, '0'),
(33, '+11', '3716119800', 39600, '1'),
(33, '+1030', '3731842800', 37800, '0'),
(33, '+11', '3747569400', 39600, '1'),
(33, '+1030', '3763292400', 37800, '0'),
(33, '+11', '3779019000', 39600, '1'),
(33, '+1030', '3794742000', 37800, '0'),
(33, '+11', '3810468600', 39600, '1'),
(33, '+1030', '3826191600', 37800, '0'),
(33, '+11', '3842523000', 39600, '1'),
(33, '+1030', '3858246000', 37800, '0'),
(33, '+11', '3873972600', 39600, '1'),
(33, '+1030', '3889695600', 37800, '0'),
(33, '+11', '3905422200', 39600, '1'),
(33, '+1030', '3921145200', 37800, '0'),
(33, '+11', '3936871800', 39600, '1'),
(33, '+1030', '3952594800', 37800, '0'),
(33, '+11', '3968321400', 39600, '1'),
(33, '+1030', '3984044400', 37800, '0'),
(33, '+11', '4000375800', 39600, '1'),
(33, '+1030', '4016098800', 37800, '0'),
(33, '+11', '4031825400', 39600, '1'),
(33, '+1030', '4047548400', 37800, '0'),
(33, '+11', '4063275000', 39600, '1'),
(33, '+1030', '4078998000', 37800, '0'),
(33, '+11', '4094724600', 39600, '1'),
(33, '+1030', '4110447600', 37800, '0'),
(33, '+11', '4126174200', 39600, '1'),
(33, '+1030', '4141897200', 37800, '0'),
(33, '+11', '4157623800', 39600, '1'),
(33, '+1030', '4173346800', 37800, '0'),
(33, '+11', '4189073400', 39600, '1'),
(33, '+1030', '4204796400', 37800, '0'),
(33, '+11', '4221127800', 39600, '1'),
(33, '+1030', '4236850800', 37800, '0'),
(33, '+11', '4252577400', 39600, '1'),
(33, '+1030', '4268300400', 37800, '0'),
(33, '+11', '4284027000', 39600, '1'),
(33, '+1030', '4299750000', 37800, '0'),
(33, '+11', '4315476600', 39600, '1'),
(33, '+1030', '4331199600', 37800, '0'),
(33, '+11', '4346926200', 39600, '1'),
(33, '+1030', '4362649200', 37800, '0'),
(33, '+11', '4378980600', 39600, '1'),
(33, '+1030', '4394703600', 37800, '0'),
(33, '+11', '4410430200', 39600, '1'),
(33, '+1030', '4426153200', 37800, '0'),
(33, '+11', '4441879800', 39600, '1'),
(33, '+1030', '4457602800', 37800, '0'),
(33, '+11', '4473329400', 39600, '1'),
(33, '+1030', '4489052400', 37800, '0'),
(33, '+11', '4504779000', 39600, '1'),
(33, '+1030', '4520502000', 37800, '0'),
(33, '+11', '4536228600', 39600, '1'),
(33, '+1030', '4551951600', 37800, '0'),
(33, '+11', '4568283000', 39600, '1'),
(33, '+1030', '4584006000', 37800, '0'),
(33, '+11', '4599732600', 39600, '1'),
(33, '+1030', '4615455600', 37800, '0'),
(33, '+11', '4631182200', 39600, '1'),
(33, '+1030', '4646905200', 37800, '0'),
(33, '+11', '4662631800', 39600, '1'),
(33, '+1030', '4678354800', 37800, '0'),
(33, '+11', '4694081400', 39600, '1'),
(33, '+1030', '4709804400', 37800, '0'),
(33, '+11', '4725531000', 39600, '1'),
(33, '+1030', '4741858800', 37800, '0'),
(33, '+11', '4757585400', 39600, '1'),
(33, '+1030', '4773308400', 37800, '0'),
(33, '+11', '4789035000', 39600, '1'),
(33, '+1030', '4804758000', 37800, '0'),
(33, '+11', '4820484600', 39600, '1'),
(33, '+1030', '4836207600', 37800, '0'),
(33, '+11', '4851934200', 39600, '1'),
(33, '+1030', '4867657200', 37800, '0'),
(33, '+11', '4883383800', 39600, '1'),
(33, '+1030', '4899106800', 37800, '0'),
(33, '+11', '4915438200', 39600, '1'),
(33, '+1030', '4931161200', 37800, '0'),
(33, '+11', '4946887800', 39600, '1'),
(33, '+1030', '4962610800', 37800, '0'),
(33, '+11', '4978337400', 39600, '1'),
(33, '+1030', '4994060400', 37800, '0'),
(33, '+11', '5009787000', 39600, '1'),
(33, '+1030', '5025510000', 37800, '0'),
(33, '+11', '5041236600', 39600, '1'),
(33, '+1030', '5056959600', 37800, '0'),
(33, '+11', '5072686200', 39600, '1'),
(33, '+1030', '5088409200', 37800, '0'),
(33, '+11', '5104740600', 39600, '1'),
(33, '+1030', '5120463600', 37800, '0'),
(33, '+11', '5136190200', 39600, '1'),
(33, '+1030', '5151913200', 37800, '0'),
(33, '+11', '5167639800', 39600, '1'),
(33, '+1030', '5183362800', 37800, '0'),
(33, '+11', '5199089400', 39600, '1'),
(33, '+1030', '5214812400', 37800, '0'),
(33, '+11', '5230539000', 39600, '1'),
(33, '+1030', '5246262000', 37800, '0'),
(33, '+11', '5262593400', 39600, '1'),
(33, '+1030', '5278316400', 37800, '0'),
(33, '+11', '5294043000', 39600, '1'),
(33, '+1030', '5309766000', 37800, '0'),
(33, '+11', '5325492600', 39600, '1'),
(33, '+1030', '5341215600', 37800, '0'),
(33, '+11', '5356942200', 39600, '1'),
(33, '+1030', '5372665200', 37800, '0'),
(33, '+11', '5388391800', 39600, '1'),
(33, '+1030', '5404114800', 37800, '0'),
(33, '+11', '5419841400', 39600, '1'),
(33, '+1030', '5435564400', 37800, '0'),
(33, '+11', '5451895800', 39600, '1'),
(33, '+1030', '5467618800', 37800, '0'),
(33, '+11', '5483345400', 39600, '1'),
(33, '+1030', '5499068400', 37800, '0'),
(33, '+11', '5514795000', 39600, '1'),
(33, '+1030', '5530518000', 37800, '0'),
(33, '+11', '5546244600', 39600, '1'),
(33, '+1030', '5561967600', 37800, '0'),
(33, '+11', '5577694200', 39600, '1'),
(33, '+1030', '5593417200', 37800, '0'),
(33, '+11', '5609143800', 39600, '1'),
(33, '+1030', '5625471600', 37800, '0'),
(33, '+11', '5641198200', 39600, '1'),
(33, '+1030', '5656921200', 37800, '0'),
(33, '+11', '5672647800', 39600, '1'),
(33, '+1030', '5688370800', 37800, '0'),
(33, '+11', '5704097400', 39600, '1'),
(33, '+1030', '5719820400', 37800, '0'),
(33, '+11', '5735547000', 39600, '1'),
(33, '+1030', '5751270000', 37800, '0'),
(33, '+11', '5766996600', 39600, '1'),
(33, '+1030', '5782719600', 37800, '0'),
(33, '+11', '5799051000', 39600, '1'),
(33, '+1030', '5814774000', 37800, '0'),
(33, '+11', '5830500600', 39600, '1'),
(33, '+1030', '5846223600', 37800, '0'),
(33, '+11', '5861950200', 39600, '1'),
(33, '+1030', '5877673200', 37800, '0'),
(33, '+11', '5893399800', 39600, '1'),
(33, '+1030', '5909122800', 37800, '0'),
(33, '+11', '5924849400', 39600, '1'),
(33, '+1030', '5940572400', 37800, '0'),
(33, '+11', '5956299000', 39600, '1'),
(33, '+1030', '5972022000', 37800, '0'),
(33, '+11', '5988353400', 39600, '1'),
(33, '+1030', '6004076400', 37800, '0'),
(33, '+11', '6019803000', 39600, '1'),
(33, '+1030', '6035526000', 37800, '0'),
(33, '+11', '6051252600', 39600, '1'),
(33, '+1030', '6066975600', 37800, '0'),
(33, '+11', '6082702200', 39600, '1'),
(33, '+1030', '6098425200', 37800, '0'),
(33, '+11', '6114151800', 39600, '1'),
(33, '+1030', '6129874800', 37800, '0'),
(33, '+11', '6146206200', 39600, '1'),
(33, '+1030', '6161929200', 37800, '0'),
(33, '+11', '6177655800', 39600, '1'),
(33, '+1030', '6193378800', 37800, '0'),
(33, '+11', '6209105400', 39600, '1'),
(33, '+1030', '6224828400', 37800, '0'),
(33, '+11', '6240555000', 39600, '1'),
(33, '+1030', '6256278000', 37800, '0'),
(33, '+11', '6272004600', 39600, '1'),
(33, '+1030', '6287727600', 37800, '0'),
(33, '+11', '6303454200', 39600, '1'),
(33, '+1030', '6319177200', 37800, '0'),
(33, '+11', '6335508600', 39600, '1'),
(33, '+1030', '6351231600', 37800, '0'),
(33, '+11', '6366958200', 39600, '1'),
(33, '+1030', '6382681200', 37800, '0'),
(33, '+11', '6398407800', 39600, '1'),
(33, '+1030', '6414130800', 37800, '0'),
(33, '+11', '6429857400', 39600, '1'),
(33, '+1030', '6445580400', 37800, '0'),
(33, '+11', '6461307000', 39600, '1'),
(33, '+1030', '6477030000', 37800, '0'),
(33, '+11', '6492756600', 39600, '1'),
(33, '+1030', '6509084400', 37800, '0'),
(33, '+11', '6524811000', 39600, '1'),
(33, '+1030', '6540534000', 37800, '0'),
(33, '+11', '6556260600', 39600, '1'),
(33, '+1030', '6571983600', 37800, '0'),
(33, '+11', '6587710200', 39600, '1'),
(33, '+1030', '6603433200', 37800, '0'),
(33, '+11', '6619159800', 39600, '1'),
(33, '+1030', '6634882800', 37800, '0'),
(33, '+11', '6650609400', 39600, '1'),
(33, '+1030', '6666332400', 37800, '0'),
(33, '+11', '6682663800', 39600, '1'),
(33, '+1030', '6698386800', 37800, '0'),
(33, '+11', '6714113400', 39600, '1'),
(33, '+1030', '6729836400', 37800, '0'),
(33, '+11', '6745563000', 39600, '1'),
(33, '+1030', '6761286000', 37800, '0'),
(33, '+11', '6777012600', 39600, '1'),
(33, '+1030', '6792735600', 37800, '0'),
(33, '+11', '6808462200', 39600, '1'),
(33, '+1030', '6824185200', 37800, '0'),
(33, '+11', '6839911800', 39600, '1'),
(33, '+1030', '6855634800', 37800, '0'),
(33, '+11', '6871966200', 39600, '1'),
(33, '+1030', '6887689200', 37800, '0'),
(33, '+11', '6903415800', 39600, '1'),
(33, '+1030', '6919138800', 37800, '0'),
(33, '+11', '6934865400', 39600, '1'),
(33, '+1030', '6950588400', 37800, '0'),
(33, '+11', '6966315000', 39600, '1'),
(33, '+1030', '6982038000', 37800, '0'),
(33, '+11', '6997764600', 39600, '1'),
(33, '+1030', '7013487600', 37800, '0'),
(33, '+11', '7029819000', 39600, '1'),
(33, '+1030', '7045542000', 37800, '0'),
(33, '+11', '7061268600', 39600, '1'),
(33, '+1030', '7076991600', 37800, '0'),
(33, '+11', '7092718200', 39600, '1'),
(33, '+1030', '7108441200', 37800, '0'),
(33, '+11', '7124167800', 39600, '1'),
(33, '+1030', '7139890800', 37800, '0'),
(33, '+11', '7155617400', 39600, '1'),
(33, '+1030', '7171340400', 37800, '0'),
(33, '+11', '7187067000', 39600, '1'),
(33, '+1030', '7202790000', 37800, '0'),
(33, '+11', '7219121400', 39600, '1'),
(33, '+1030', '7234844400', 37800, '0'),
(33, '+11', '7250571000', 39600, '1'),
(33, '+1030', '7266294000', 37800, '0'),
(33, '+11', '7282020600', 39600, '1'),
(33, '+1030', '7297743600', 37800, '0'),
(33, '+11', '7313470200', 39600, '1'),
(33, '+1030', '7329193200', 37800, '0'),
(33, '+11', '7344919800', 39600, '1'),
(33, '+1030', '7360642800', 37800, '0'),
(33, '+11', '7376369400', 39600, '1'),
(33, '+1030', '7392092400', 37800, '0'),
(33, '+11', '7408423800', 39600, '1'),
(33, '+1030', '7424146800', 37800, '0'),
(33, '+11', '7439873400', 39600, '1'),
(33, '+1030', '7455596400', 37800, '0'),
(33, '+11', '7471323000', 39600, '1'),
(33, '+1030', '7487046000', 37800, '0'),
(33, '+11', '7502772600', 39600, '1'),
(33, '+1030', '7518495600', 37800, '0'),
(33, '+11', '7534222200', 39600, '1'),
(33, '+1030', '7549945200', 37800, '0'),
(33, '+11', '7565671800', 39600, '1'),
(33, '+1030', '7581394800', 37800, '0'),
(33, '+11', '7597726200', 39600, '1'),
(33, '+1030', '7613449200', 37800, '0'),
(33, '+11', '7629175800', 39600, '1'),
(33, '+1030', '7644898800', 37800, '0'),
(33, '+11', '7660625400', 39600, '1'),
(33, '+1030', '7676348400', 37800, '0'),
(33, '+11', '7692075000', 39600, '1'),
(33, '+1030', '7707798000', 37800, '0'),
(33, '+11', '7723524600', 39600, '1'),
(33, '+1030', '7739247600', 37800, '0'),
(33, '+11', '7754974200', 39600, '1'),
(33, '+1030', '7771302000', 37800, '0'),
(33, '+11', '7787028600', 39600, '1'),
(33, '+1030', '7802751600', 37800, '0'),
(33, '+11', '7818478200', 39600, '1'),
(33, '+1030', '7834201200', 37800, '0'),
(33, '+11', '7849927800', 39600, '1'),
(33, '+1030', '7865650800', 37800, '0'),
(33, '+11', '7881377400', 39600, '1'),
(33, '+1030', '7897100400', 37800, '0'),
(33, '+11', '7912827000', 39600, '1'),
(33, '+1030', '7928550000', 37800, '0'),
(33, '+11', '7944881400', 39600, '1'),
(33, '+1030', '7960604400', 37800, '0'),
(33, '+11', '7976331000', 39600, '1'),
(33, '+1030', '7992054000', 37800, '0'),
(33, '+11', '8007780600', 39600, '1'),
(33, '+1030', '8023503600', 37800, '0'),
(33, '+11', '8039230200', 39600, '1'),
(33, '+1030', '8054953200', 37800, '0'),
(33, '+11', '8070679800', 39600, '1'),
(33, '+1030', '8086402800', 37800, '0'),
(33, '+11', '8102129400', 39600, '1'),
(33, '+1030', '8117852400', 37800, '0'),
(33, '+11', '8134183800', 39600, '1'),
(33, '+1030', '8149906800', 37800, '0'),
(33, '+11', '8165633400', 39600, '1'),
(33, '+1030', '8181356400', 37800, '0'),
(33, '+11', '8197083000', 39600, '1'),
(33, '+1030', '8212806000', 37800, '0'),
(33, '+11', '8228532600', 39600, '1'),
(33, '+1030', '8244255600', 37800, '0'),
(33, '+11', '8259982200', 39600, '1'),
(33, '+1030', '8275705200', 37800, '0'),
(33, '+11', '8292036600', 39600, '1'),
(33, '+1030', '8307759600', 37800, '0'),
(33, '+11', '8323486200', 39600, '1'),
(33, '+1030', '8339209200', 37800, '0'),
(33, '+11', '8354935800', 39600, '1'),
(33, '+1030', '8370658800', 37800, '0'),
(33, '+11', '8386385400', 39600, '1'),
(33, '+1030', '8402108400', 37800, '0'),
(33, '+11', '8417835000', 39600, '1'),
(33, '+1030', '8433558000', 37800, '0'),
(33, '+11', '8449284600', 39600, '1'),
(33, '+1030', '8465007600', 37800, '0'),
(33, '+11', '8481339000', 39600, '1'),
(33, '+1030', '8497062000', 37800, '0'),
(33, '+11', '8512788600', 39600, '1'),
(33, '+1030', '8528511600', 37800, '0'),
(33, '+11', '8544238200', 39600, '1'),
(33, '+1030', '8559961200', 37800, '0'),
(33, '+11', '8575687800', 39600, '1'),
(33, '+1030', '8591410800', 37800, '0'),
(33, '+11', '8607137400', 39600, '1'),
(33, '+1030', '8622860400', 37800, '0'),
(33, '+11', '8638587000', 39600, '1'),
(33, '+1030', '8654914800', 37800, '0'),
(33, '+11', '8670641400', 39600, '1'),
(33, '+1030', '8686364400', 37800, '0'),
(33, '+11', '8702091000', 39600, '1'),
(33, '+1030', '8717814000', 37800, '0'),
(33, '+11', '8733540600', 39600, '1'),
(33, '+1030', '8749263600', 37800, '0'),
(33, '+11', '8764990200', 39600, '1'),
(33, '+1030', '8780713200', 37800, '0'),
(33, '+11', '8796439800', 39600, '1'),
(33, '+1030', '8812162800', 37800, '0'),
(33, '+11', '8828494200', 39600, '1'),
(33, '+1030', '8844217200', 37800, '0'),
(33, '+11', '8859943800', 39600, '1'),
(33, '+1030', '8875666800', 37800, '0'),
(33, '+11', '8891393400', 39600, '1'),
(33, '+1030', '8907116400', 37800, '0'),
(33, '+11', '8922843000', 39600, '1'),
(33, '+1030', '8938566000', 37800, '0'),
(33, '+11', '8954292600', 39600, '1'),
(33, '+1030', '8970015600', 37800, '0'),
(33, '+11', '8985742200', 39600, '1'),
(33, '+1030', '9001465200', 37800, '0'),
(33, '+11', '9017796600', 39600, '1'),
(33, '+1030', '9033519600', 37800, '0'),
(33, '+11', '9049246200', 39600, '1'),
(33, '+1030', '9064969200', 37800, '0'),
(33, '+11', '9080695800', 39600, '1'),
(33, '+1030', '9096418800', 37800, '0'),
(33, '+11', '9112145400', 39600, '1'),
(33, '+1030', '9127868400', 37800, '0'),
(33, '+11', '9143595000', 39600, '1'),
(33, '+1030', '9159318000', 37800, '0'),
(33, '+11', '9175649400', 39600, '1'),
(33, '+1030', '9191372400', 37800, '0'),
(33, '+11', '9207099000', 39600, '1'),
(33, '+1030', '9222822000', 37800, '0'),
(33, '+11', '9238548600', 39600, '1'),
(33, '+1030', '9254271600', 37800, '0'),
(33, '+11', '9269998200', 39600, '1'),
(33, '+1030', '9285721200', 37800, '0'),
(33, '+11', '9301447800', 39600, '1'),
(33, '+1030', '9317170800', 37800, '0'),
(33, '+11', '9332897400', 39600, '1'),
(33, '+1030', '9348620400', 37800, '0'),
(33, '+11', '9364951800', 39600, '1'),
(33, '+1030', '9380674800', 37800, '0'),
(33, '+11', '9396401400', 39600, '1'),
(33, '+1030', '9412124400', 37800, '0'),
(33, '+11', '9427851000', 39600, '1'),
(33, '+1030', '9443574000', 37800, '0'),
(33, '+11', '9459300600', 39600, '1'),
(33, '+1030', '9475023600', 37800, '0'),
(33, '+11', '9490750200', 39600, '1'),
(33, '+1030', '9506473200', 37800, '0'),
(33, '+11', '9522199800', 39600, '1'),
(33, '+1030', '9538527600', 37800, '0'),
(33, '+11', '9554254200', 39600, '1'),
(33, '+1030', '9569977200', 37800, '0'),
(33, '+11', '9585703800', 39600, '1'),
(33, '+1030', '9601426800', 37800, '0'),
(33, '+11', '9617153400', 39600, '1'),
(33, '+1030', '9632876400', 37800, '0'),
(33, '+11', '9648603000', 39600, '1'),
(33, '+1030', '9664326000', 37800, '0'),
(33, '+11', '9680052600', 39600, '1'),
(33, '+1030', '9695775600', 37800, '0'),
(33, '+11', '9712107000', 39600, '1'),
(33, '+1030', '9727830000', 37800, '0'),
(33, '+11', '9743556600', 39600, '1'),
(33, '+1030', '9759279600', 37800, '0'),
(33, '+11', '9775006200', 39600, '1'),
(33, '+1030', '9790729200', 37800, '0'),
(33, '+11', '9806455800', 39600, '1'),
(33, '+1030', '9822178800', 37800, '0'),
(33, '+11', '9837905400', 39600, '1'),
(33, '+1030', '9853628400', 37800, '0'),
(33, '+11', '9869355000', 39600, '1'),
(33, '+1030', '9885078000', 37800, '0'),
(33, '+11', '9901409400', 39600, '1'),
(33, '+1030', '9917132400', 37800, '0'),
(33, '+11', '9932859000', 39600, '1'),
(33, '+1030', '9948582000', 37800, '0'),
(33, '+11', '9964308600', 39600, '1'),
(33, '+1030', '9980031600', 37800, '0'),
(33, '+11', '9995758200', 39600, '1'),
(33, '+1030', '10011481200', 37800, '0'),
(33, '+11', '10027207800', 39600, '1'),
(33, '+1030', '10042930800', 37800, '0'),
(33, '+11', '10059262200', 39600, '1'),
(33, '+1030', '10074985200', 37800, '0'),
(33, '+11', '10090711800', 39600, '1'),
(33, '+1030', '10106434800', 37800, '0'),
(33, '+11', '10122161400', 39600, '1'),
(33, '+1030', '10137884400', 37800, '0'),
(33, '+11', '10153611000', 39600, '1'),
(33, '+1030', '10169334000', 37800, '0'),
(33, '+11', '10185060600', 39600, '1'),
(33, '+1030', '10200783600', 37800, '0'),
(33, '+11', '10216510200', 39600, '1'),
(33, '+1030', '10232233200', 37800, '0'),
(33, '+11', '10248564600', 39600, '1'),
(33, '+1030', '10264287600', 37800, '0'),
(33, '+11', '10280014200', 39600, '1'),
(33, '+1030', '10295737200', 37800, '0'),
(33, '+11', '10311463800', 39600, '1'),
(33, '+1030', '10327186800', 37800, '0'),
(33, '+11', '10342913400', 39600, '1'),
(33, '+1030', '10358636400', 37800, '0'),
(33, '+11', '10374363000', 39600, '1'),
(33, '+1030', '10390086000', 37800, '0'),
(33, '+11', '10405812600', 39600, '1'),
(33, '+1030', '10421535600', 37800, '0'),
(33, '+11', '10437867000', 39600, '1'),
(33, '+1030', '10453590000', 37800, '0'),
(33, '+11', '10469316600', 39600, '1'),
(33, '+1030', '10485039600', 37800, '0'),
(33, '+11', '10500766200', 39600, '1'),
(33, '+1030', '10516489200', 37800, '0'),
(33, '+11', '10532215800', 39600, '1'),
(33, '+1030', '10547938800', 37800, '0'),
(33, '+11', '10563665400', 39600, '1'),
(33, '+1030', '10579388400', 37800, '0'),
(33, '+11', '10595115000', 39600, '1'),
(33, '+1030', '10610838000', 37800, '0'),
(33, '+11', '10627169400', 39600, '1'),
(33, '+1030', '10642892400', 37800, '0'),
(33, '+11', '10658619000', 39600, '1'),
(33, '+1030', '10674342000', 37800, '0'),
(33, '+11', '10690068600', 39600, '1'),
(33, '+1030', '10705791600', 37800, '0'),
(33, '+11', '10721518200', 39600, '1'),
(33, '+1030', '10737241200', 37800, '0'),
(33, '+11', '10752967800', 39600, '1'),
(33, '+1030', '10768690800', 37800, '0'),
(33, '+11', '10784417400', 39600, '1'),
(33, '+1030', '10800745200', 37800, '0'),
(33, '+11', '10816471800', 39600, '1'),
(33, '+1030', '10832194800', 37800, '0'),
(33, '+11', '10847921400', 39600, '1'),
(33, '+1030', '10863644400', 37800, '0'),
(33, '+11', '10879371000', 39600, '1'),
(33, '+1030', '10895094000', 37800, '0'),
(33, '+11', '10910820600', 39600, '1'),
(33, '+1030', '10926543600', 37800, '0'),
(33, '+11', '10942270200', 39600, '1'),
(33, '+1030', '10957993200', 37800, '0'),
(33, '+11', '10974324600', 39600, '1'),
(33, '+1030', '10990047600', 37800, '0'),
(33, '+11', '11005774200', 39600, '1'),
(33, '+1030', '11021497200', 37800, '0'),
(33, '+11', '11037223800', 39600, '1'),
(33, '+1030', '11052946800', 37800, '0'),
(33, '+11', '11068673400', 39600, '1'),
(33, '+1030', '11084396400', 37800, '0'),
(33, '+11', '11100123000', 39600, '1'),
(33, '+1030', '11115846000', 37800, '0'),
(33, '+11', '11131572600', 39600, '1'),
(33, '+1030', '11147295600', 37800, '0'),
(33, '+11', '11163627000', 39600, '1'),
(33, '+1030', '11179350000', 37800, '0'),
(33, '+11', '11195076600', 39600, '1'),
(33, '+1030', '11210799600', 37800, '0'),
(33, '+11', '11226526200', 39600, '1'),
(33, '+1030', '11242249200', 37800, '0'),
(33, '+11', '11257975800', 39600, '1'),
(33, '+1030', '11273698800', 37800, '0'),
(33, '+11', '11289425400', 39600, '1'),
(33, '+1030', '11305148400', 37800, '0'),
(33, '+11', '11321479800', 39600, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(33, '+1030', '11337202800', 37800, '0'),
(33, '+11', '11352929400', 39600, '1'),
(33, '+1030', '11368652400', 37800, '0'),
(33, '+11', '11384379000', 39600, '1'),
(33, '+1030', '11400102000', 37800, '0'),
(33, '+11', '11415828600', 39600, '1'),
(33, '+1030', '11431551600', 37800, '0'),
(33, '+11', '11447278200', 39600, '1'),
(33, '+1030', '11463001200', 37800, '0'),
(33, '+11', '11478727800', 39600, '1'),
(33, '+1030', '11494450800', 37800, '0'),
(33, '+11', '11510782200', 39600, '1'),
(33, '+1030', '11526505200', 37800, '0'),
(33, '+11', '11542231800', 39600, '1'),
(33, '+1030', '11557954800', 37800, '0'),
(33, '+11', '11573681400', 39600, '1'),
(33, '+1030', '11589404400', 37800, '0'),
(33, '+11', '11605131000', 39600, '1'),
(33, '+1030', '11620854000', 37800, '0'),
(33, '+11', '11636580600', 39600, '1'),
(33, '+1030', '11652303600', 37800, '0'),
(33, '+11', '11668030200', 39600, '1'),
(33, '+1030', '11684358000', 37800, '0'),
(33, '+11', '11700084600', 39600, '1'),
(33, '+1030', '11715807600', 37800, '0'),
(33, '+11', '11731534200', 39600, '1'),
(33, '+1030', '11747257200', 37800, '0'),
(33, '+11', '11762983800', 39600, '1'),
(33, '+1030', '11778706800', 37800, '0'),
(33, '+11', '11794433400', 39600, '1'),
(33, '+1030', '11810156400', 37800, '0'),
(33, '+11', '11825883000', 39600, '1'),
(33, '+1030', '11841606000', 37800, '0'),
(33, '+11', '11857937400', 39600, '1'),
(33, '+1030', '11873660400', 37800, '0'),
(33, '+11', '11889387000', 39600, '1'),
(33, '+1030', '11905110000', 37800, '0'),
(33, '+11', '11920836600', 39600, '1'),
(33, '+1030', '11936559600', 37800, '0'),
(33, '+11', '11952286200', 39600, '1'),
(33, '+1030', '11968009200', 37800, '0'),
(33, '+11', '11983735800', 39600, '1'),
(33, '+1030', '11999458800', 37800, '0'),
(33, '+11', '12015185400', 39600, '1'),
(33, '+1030', '12030908400', 37800, '0'),
(33, '+11', '12047239800', 39600, '1'),
(33, '+1030', '12062962800', 37800, '0'),
(33, '+11', '12078689400', 39600, '1'),
(33, '+1030', '12094412400', 37800, '0'),
(33, '+11', '12110139000', 39600, '1'),
(33, '+1030', '12125862000', 37800, '0'),
(33, '+11', '12141588600', 39600, '1'),
(33, '+1030', '12157311600', 37800, '0'),
(33, '+11', '12173038200', 39600, '1'),
(33, '+1030', '12188761200', 37800, '0'),
(33, '+11', '12205092600', 39600, '1'),
(33, '+1030', '12220815600', 37800, '0'),
(33, '+11', '12236542200', 39600, '1'),
(33, '+1030', '12252265200', 37800, '0'),
(33, '+11', '12267991800', 39600, '1'),
(33, '+1030', '12283714800', 37800, '0'),
(33, '+11', '12299441400', 39600, '1'),
(33, '+1030', '12315164400', 37800, '0'),
(33, '+11', '12330891000', 39600, '1'),
(33, '+1030', '12346614000', 37800, '0'),
(33, '+11', '12362340600', 39600, '1'),
(33, '+1030', '12378063600', 37800, '0'),
(33, '+11', '12394395000', 39600, '1'),
(33, '+1030', '12410118000', 37800, '0'),
(33, '+11', '12425844600', 39600, '1'),
(33, '+1030', '12441567600', 37800, '0'),
(33, '+11', '12457294200', 39600, '1'),
(33, '+1030', '12473017200', 37800, '0'),
(33, '+11', '12488743800', 39600, '1'),
(33, '+1030', '12504466800', 37800, '0'),
(33, '+11', '12520193400', 39600, '1'),
(33, '+1030', '12535916400', 37800, '0'),
(33, '+11', '12551643000', 39600, '1'),
(33, '+1030', '12567970800', 37800, '0'),
(33, '+11', '12583697400', 39600, '1'),
(33, '+1030', '12599420400', 37800, '0'),
(33, '+11', '12615147000', 39600, '1'),
(33, '+1030', '12630870000', 37800, '0'),
(33, '+11', '12646596600', 39600, '1'),
(33, '+1030', '12662319600', 37800, '0'),
(33, '+11', '12678046200', 39600, '1'),
(33, '+1030', '12693769200', 37800, '0'),
(33, '+11', '12709495800', 39600, '1'),
(33, '+1030', '12725218800', 37800, '0'),
(33, '+11', '12741550200', 39600, '1'),
(33, '+1030', '12757273200', 37800, '0'),
(33, '+11', '12772999800', 39600, '1'),
(33, '+1030', '12788722800', 37800, '0'),
(33, '+11', '12804449400', 39600, '1'),
(33, '+1030', '12820172400', 37800, '0'),
(33, '+11', '12835899000', 39600, '1'),
(33, '+1030', '12851622000', 37800, '0'),
(33, '+11', '12867348600', 39600, '1'),
(33, '+1030', '12883071600', 37800, '0'),
(33, '+11', '12898798200', 39600, '1'),
(33, '+1030', '12914521200', 37800, '0'),
(33, '+11', '12930852600', 39600, '1'),
(33, '+1030', '12946575600', 37800, '0'),
(33, '+11', '12962302200', 39600, '1'),
(33, '+1030', '12978025200', 37800, '0'),
(33, '+11', '12993751800', 39600, '1'),
(33, '+1030', '13009474800', 37800, '0'),
(33, '+11', '13025201400', 39600, '1'),
(33, '+1030', '13040924400', 37800, '0'),
(33, '+11', '13056651000', 39600, '1'),
(33, '+1030', '13072374000', 37800, '0'),
(33, '+11', '13088705400', 39600, '1'),
(33, '+1030', '13104428400', 37800, '0'),
(33, '+11', '13120155000', 39600, '1'),
(33, '+1030', '13135878000', 37800, '0'),
(33, '+11', '13151604600', 39600, '1'),
(33, '+1030', '13167327600', 37800, '0'),
(33, '+11', '13183054200', 39600, '1'),
(33, '+1030', '13198777200', 37800, '0'),
(33, '+11', '13214503800', 39600, '1'),
(33, '+1030', '13230226800', 37800, '0'),
(33, '+11', '13245953400', 39600, '1'),
(33, '+1030', '13261676400', 37800, '0'),
(33, '+11', '13278007800', 39600, '1'),
(33, '+1030', '13293730800', 37800, '0'),
(33, '+11', '13309457400', 39600, '1'),
(33, '+1030', '13325180400', 37800, '0'),
(33, '+11', '13340907000', 39600, '1'),
(33, '+1030', '13356630000', 37800, '0'),
(33, '+11', '13372356600', 39600, '1'),
(33, '+1030', '13388079600', 37800, '0'),
(33, '+11', '13403806200', 39600, '1'),
(33, '+1030', '13419529200', 37800, '0'),
(33, '+11', '13435255800', 39600, '1'),
(33, '+1030', '13451583600', 37800, '0'),
(33, '+11', '13467310200', 39600, '1'),
(33, '+1030', '13483033200', 37800, '0'),
(33, '+11', '13498759800', 39600, '1'),
(33, '+1030', '13514482800', 37800, '0'),
(33, '+11', '13530209400', 39600, '1'),
(33, '+1030', '13545932400', 37800, '0'),
(33, '+11', '13561659000', 39600, '1'),
(33, '+1030', '13577382000', 37800, '0'),
(33, '+11', '13593108600', 39600, '1'),
(33, '+1030', '13608831600', 37800, '0'),
(33, '+11', '13625163000', 39600, '1'),
(33, '+1030', '13640886000', 37800, '0'),
(33, '+11', '13656612600', 39600, '1'),
(33, '+1030', '13672335600', 37800, '0'),
(33, '+11', '13688062200', 39600, '1'),
(33, '+1030', '13703785200', 37800, '0'),
(33, '+11', '13719511800', 39600, '1'),
(33, '+1030', '13735234800', 37800, '0'),
(33, '+11', '13750961400', 39600, '1'),
(33, '+1030', '13766684400', 37800, '0'),
(33, '+11', '13782411000', 39600, '1'),
(33, '+1030', '13798134000', 37800, '0'),
(33, '+11', '13814465400', 39600, '1'),
(33, '+1030', '13830188400', 37800, '0'),
(33, '+11', '13845915000', 39600, '1'),
(33, '+1030', '13861638000', 37800, '0'),
(33, '+11', '13877364600', 39600, '1'),
(33, '+1030', '13893087600', 37800, '0'),
(33, '+11', '13908814200', 39600, '1'),
(33, '+1030', '13924537200', 37800, '0'),
(33, '+11', '13940263800', 39600, '1'),
(33, '+1030', '13955986800', 37800, '0'),
(33, '+11', '13972318200', 39600, '1'),
(33, '+1030', '13988041200', 37800, '0'),
(33, '+11', '14003767800', 39600, '1'),
(33, '+1030', '14019490800', 37800, '0'),
(33, '+11', '14035217400', 39600, '1'),
(33, '+1030', '14050940400', 37800, '0'),
(33, '+11', '14066667000', 39600, '1'),
(33, '+1030', '14082390000', 37800, '0'),
(33, '+11', '14098116600', 39600, '1'),
(33, '+1030', '14113839600', 37800, '0'),
(33, '+11', '14129566200', 39600, '1'),
(33, '+1030', '14145289200', 37800, '0'),
(33, '+11', '14161620600', 39600, '1'),
(33, '+1030', '14177343600', 37800, '0'),
(33, '+11', '14193070200', 39600, '1'),
(33, '+1030', '14208793200', 37800, '0'),
(33, '+11', '14224519800', 39600, '1'),
(33, '+1030', '14240242800', 37800, '0'),
(33, '+11', '14255969400', 39600, '1'),
(33, '+1030', '14271692400', 37800, '0'),
(33, '+11', '14287419000', 39600, '1'),
(33, '+1030', '14303142000', 37800, '0'),
(33, '+11', '14318868600', 39600, '1'),
(33, '+1030', '14335196400', 37800, '0'),
(33, '+11', '14350923000', 39600, '1'),
(33, '+1030', '14366646000', 37800, '0'),
(33, '+11', '14382372600', 39600, '1'),
(33, '+1030', '14398095600', 37800, '0'),
(33, '+11', '14413822200', 39600, '1'),
(33, '+1030', '14429545200', 37800, '0'),
(33, '+11', '14445271800', 39600, '1'),
(33, '+1030', '14460994800', 37800, '0'),
(33, '+11', '14476721400', 39600, '1'),
(33, '+1030', '14492444400', 37800, '0'),
(33, '+11', '14508775800', 39600, '1'),
(33, '+1030', '14524498800', 37800, '0'),
(33, '+11', '14540225400', 39600, '1'),
(33, '+1030', '14555948400', 37800, '0'),
(33, '+11', '14571675000', 39600, '1'),
(33, '+1030', '14587398000', 37800, '0'),
(33, '+11', '14603124600', 39600, '1'),
(33, '+1030', '14618847600', 37800, '0'),
(33, '+11', '14634574200', 39600, '1'),
(33, '+1030', '14650297200', 37800, '0'),
(33, '+11', '14666023800', 39600, '1'),
(33, '+1030', '14681746800', 37800, '0'),
(33, '+11', '14698078200', 39600, '1'),
(33, '+1030', '14713801200', 37800, '0'),
(33, '+11', '14729527800', 39600, '1'),
(33, '+1030', '14745250800', 37800, '0'),
(33, '+11', '14760977400', 39600, '1'),
(33, '+1030', '14776700400', 37800, '0'),
(33, '+11', '14792427000', 39600, '1'),
(33, '+1030', '14808150000', 37800, '0'),
(33, '+11', '14823876600', 39600, '1'),
(33, '+1030', '14839599600', 37800, '0'),
(33, '+11', '14855931000', 39600, '1'),
(33, '+1030', '14871654000', 37800, '0'),
(33, '+11', '14887380600', 39600, '1'),
(33, '+1030', '14903103600', 37800, '0'),
(33, '+11', '14918830200', 39600, '1'),
(33, '+1030', '14934553200', 37800, '0'),
(33, '+11', '14950279800', 39600, '1'),
(33, '+1030', '14966002800', 37800, '0'),
(33, '+11', '14981729400', 39600, '1'),
(33, '+1030', '14997452400', 37800, '0'),
(33, '+11', '15013179000', 39600, '1'),
(33, '+1030', '15028902000', 37800, '0'),
(33, '+11', '15045233400', 39600, '1'),
(33, '+1030', '15060956400', 37800, '0'),
(33, '+11', '15076683000', 39600, '1'),
(33, '+1030', '15092406000', 37800, '0'),
(33, '+11', '15108132600', 39600, '1'),
(33, '+1030', '15123855600', 37800, '0'),
(33, '+11', '15139582200', 39600, '1'),
(33, '+1030', '15155305200', 37800, '0'),
(33, '+11', '15171031800', 39600, '1'),
(33, '+1030', '15186754800', 37800, '0'),
(33, '+11', '15202481400', 39600, '1'),
(33, '+1030', '15218809200', 37800, '0'),
(33, '+11', '15234535800', 39600, '1'),
(33, '+1030', '15250258800', 37800, '0'),
(33, '+11', '15265985400', 39600, '1'),
(33, '+1030', '15281708400', 37800, '0'),
(33, '+11', '15297435000', 39600, '1'),
(33, '+1030', '15313158000', 37800, '0'),
(33, '+11', '15328884600', 39600, '1'),
(33, '+1030', '15344607600', 37800, '0'),
(33, '+11', '15360334200', 39600, '1'),
(33, '+1030', '15376057200', 37800, '0'),
(33, '+11', '15392388600', 39600, '1'),
(33, '+1030', '15408111600', 37800, '0'),
(33, '+11', '15423838200', 39600, '1'),
(33, '+1030', '15439561200', 37800, '0'),
(33, '+11', '15455287800', 39600, '1'),
(33, '+1030', '15471010800', 37800, '0'),
(33, '+11', '15486737400', 39600, '1'),
(33, '+1030', '15502460400', 37800, '0'),
(33, '+11', '15518187000', 39600, '1'),
(33, '+1030', '15533910000', 37800, '0'),
(33, '+11', '15549636600', 39600, '1'),
(33, '+1030', '15565359600', 37800, '0'),
(33, '+11', '15581691000', 39600, '1'),
(33, '+1030', '15597414000', 37800, '0'),
(33, '+11', '15613140600', 39600, '1'),
(33, '+1030', '15628863600', 37800, '0'),
(33, '+11', '15644590200', 39600, '1'),
(33, '+1030', '15660313200', 37800, '0'),
(33, '+11', '15676039800', 39600, '1'),
(33, '+1030', '15691762800', 37800, '0'),
(33, '+11', '15707489400', 39600, '1'),
(33, '+1030', '15723212400', 37800, '0'),
(33, '+11', '15739543800', 39600, '1'),
(33, '+1030', '15755266800', 37800, '0'),
(33, '+11', '15770993400', 39600, '1'),
(33, '+1030', '15786716400', 37800, '0'),
(33, '+11', '15802443000', 39600, '1'),
(33, '+1030', '15818166000', 37800, '0'),
(33, '+11', '15833892600', 39600, '1'),
(33, '+1030', '15849615600', 37800, '0'),
(33, '+11', '15865342200', 39600, '1'),
(33, '+1030', '15881065200', 37800, '0'),
(33, '+11', '15896791800', 39600, '1'),
(33, '+1030', '15912514800', 37800, '0'),
(33, '+11', '15928846200', 39600, '1'),
(33, '+1030', '15944569200', 37800, '0'),
(33, '+11', '15960295800', 39600, '1'),
(33, '+1030', '15976018800', 37800, '0'),
(33, '+11', '15991745400', 39600, '1'),
(33, '+1030', '16007468400', 37800, '0'),
(33, '+11', '16023195000', 39600, '1'),
(33, '+1030', '16038918000', 37800, '0'),
(33, '+11', '16054644600', 39600, '1'),
(33, '+1030', '16070367600', 37800, '0'),
(33, '+11', '16086094200', 39600, '1'),
(33, '+1030', '16102422000', 37800, '0'),
(33, '+11', '16118148600', 39600, '1'),
(33, '+1030', '16133871600', 37800, '0'),
(33, '+11', '16149598200', 39600, '1'),
(33, '+1030', '16165321200', 37800, '0'),
(33, '+11', '16181047800', 39600, '1'),
(33, '+1030', '16196770800', 37800, '0'),
(33, '+11', '16212497400', 39600, '1'),
(33, '+1030', '16228220400', 37800, '0'),
(33, '+11', '16243947000', 39600, '1'),
(33, '+1030', '16259670000', 37800, '0'),
(33, '+11', '16276001400', 39600, '1'),
(33, '+1030', '16291724400', 37800, '0'),
(33, '+11', '16307451000', 39600, '1'),
(33, '+1030', '16323174000', 37800, '0'),
(33, '+11', '16338900600', 39600, '1'),
(33, '+1030', '16354623600', 37800, '0'),
(33, '+11', '16370350200', 39600, '1'),
(33, '+1030', '16386073200', 37800, '0'),
(33, '+11', '16401799800', 39600, '1'),
(33, '+1030', '16417522800', 37800, '0'),
(33, '+11', '16433249400', 39600, '1'),
(33, '+1030', '16448972400', 37800, '0'),
(33, '+11', '16465303800', 39600, '1'),
(33, '+1030', '16481026800', 37800, '0'),
(33, '+11', '16496753400', 39600, '1'),
(33, '+1030', '16512476400', 37800, '0'),
(33, '+11', '16528203000', 39600, '1'),
(33, '+1030', '16543926000', 37800, '0'),
(33, '+11', '16559652600', 39600, '1'),
(33, '+1030', '16575375600', 37800, '0'),
(33, '+11', '16591102200', 39600, '1'),
(33, '+1030', '16606825200', 37800, '0'),
(33, '+11', '16623156600', 39600, '1'),
(33, '+1030', '16638879600', 37800, '0'),
(33, '+11', '16654606200', 39600, '1'),
(33, '+1030', '16670329200', 37800, '0'),
(33, '+11', '16686055800', 39600, '1'),
(33, '+1030', '16701778800', 37800, '0'),
(33, '+11', '16717505400', 39600, '1'),
(34, 'AEST', '-2214259200', 36000, '0'),
(34, 'AEDT', '-1680508800', 39600, '1'),
(34, 'AEST', '-1665392400', 36000, '0'),
(34, 'AEDT', '-71136000', 39600, '1'),
(34, 'AEST', '-55411200', 36000, '0'),
(34, 'AEDT', '-37267200', 39600, '1'),
(34, 'AEST', '-25776000', 36000, '0'),
(34, 'AEDT', '-5817600', 39600, '1'),
(34, 'AEST', '5673600', 36000, '0'),
(34, 'AEDT', '25632000', 39600, '1'),
(34, 'AEST', '37728000', 36000, '0'),
(34, 'AEDT', '57686400', 39600, '1'),
(34, 'AEST', '67968000', 36000, '0'),
(34, 'AEDT', '89136000', 39600, '1'),
(34, 'AEST', '100022400', 36000, '0'),
(34, 'AEDT', '120585600', 39600, '1'),
(34, 'AEST', '131472000', 36000, '0'),
(34, 'AEDT', '152035200', 39600, '1'),
(34, 'AEST', '162921600', 36000, '0'),
(34, 'AEDT', '183484800', 39600, '1'),
(34, 'AEST', '194976000', 36000, '0'),
(34, 'AEDT', '215539200', 39600, '1'),
(34, 'AEST', '226425600', 36000, '0'),
(34, 'AEDT', '246988800', 39600, '1'),
(34, 'AEST', '257875200', 36000, '0'),
(34, 'AEDT', '278438400', 39600, '1'),
(34, 'AEST', '289324800', 36000, '0'),
(34, 'AEDT', '309888000', 39600, '1'),
(34, 'AEST', '320774400', 36000, '0'),
(34, 'AEDT', '341337600', 39600, '1'),
(34, 'AEST', '352224000', 36000, '0'),
(34, 'AEDT', '372787200', 39600, '1'),
(34, 'AEST', '386092800', 36000, '0'),
(34, 'AEDT', '404841600', 39600, '1'),
(34, 'AEST', '417542400', 36000, '0'),
(34, 'AEDT', '436291200', 39600, '1'),
(34, 'AEST', '447177600', 36000, '0'),
(34, 'AEDT', '467740800', 39600, '1'),
(34, 'AEST', '478627200', 36000, '0'),
(34, 'AEDT', '499190400', 39600, '1'),
(34, 'AEST', '510076800', 36000, '0'),
(34, 'AEDT', '530035200', 39600, '1'),
(34, 'AEST', '542736000', 36000, '0'),
(34, 'AEDT', '562089600', 39600, '1'),
(34, 'AEST', '574790400', 36000, '0'),
(34, 'AEDT', '594144000', 39600, '1'),
(34, 'AEST', '606240000', 36000, '0'),
(34, 'AEDT', '625593600', 39600, '1'),
(34, 'AEST', '637689600', 36000, '0'),
(34, 'AEDT', '657043200', 39600, '1'),
(34, 'AEST', '670348800', 36000, '0'),
(34, 'AEDT', '686678400', 39600, '1'),
(34, 'AEST', '701798400', 36000, '0'),
(34, 'AEDT', '718128000', 39600, '1'),
(34, 'AEST', '733248000', 36000, '0'),
(34, 'AEDT', '749577600', 39600, '1'),
(34, 'AEST', '764697600', 36000, '0'),
(34, 'AEDT', '781027200', 39600, '1'),
(34, 'AEST', '796147200', 36000, '0'),
(34, 'AEDT', '812476800', 39600, '1'),
(34, 'AEST', '828201600', 36000, '0'),
(34, 'AEDT', '844531200', 39600, '1'),
(34, 'AEST', '859651200', 36000, '0'),
(34, 'AEDT', '875980800', 39600, '1'),
(34, 'AEST', '891100800', 36000, '0'),
(34, 'AEDT', '907430400', 39600, '1'),
(34, 'AEST', '922550400', 36000, '0'),
(34, 'AEDT', '938880000', 39600, '1'),
(34, 'AEST', '954000000', 36000, '0'),
(34, 'AEDT', '967305600', 39600, '1'),
(34, 'AEST', '985449600', 36000, '0'),
(34, 'AEDT', '1002384000', 39600, '1'),
(34, 'AEST', '1017504000', 36000, '0'),
(34, 'AEDT', '1033833600', 39600, '1'),
(34, 'AEST', '1048953600', 36000, '0'),
(34, 'AEDT', '1065283200', 39600, '1'),
(34, 'AEST', '1080403200', 36000, '0'),
(34, 'AEDT', '1096732800', 39600, '1'),
(34, 'AEST', '1111852800', 36000, '0'),
(34, 'AEDT', '1128182400', 39600, '1'),
(34, 'AEST', '1143907200', 36000, '0'),
(34, 'AEDT', '1159632000', 39600, '1'),
(34, 'AEST', '1174752000', 36000, '0'),
(34, 'AEDT', '1191686400', 39600, '1'),
(34, 'AEST', '1207411200', 36000, '0'),
(34, 'AEDT', '1223136000', 39600, '1'),
(34, 'AEST', '1238860800', 36000, '0'),
(34, 'AEDT', '1254585600', 39600, '1'),
(34, '+11', '1270310400', 39600, '0'),
(35, 'LMT', '-2345795357', 35356, '0'),
(35, 'AEST', '-2345795356', 36000, '0'),
(35, 'AEDT', '-1680508800', 39600, '1'),
(35, 'AEST', '-1665392400', 36000, '0'),
(35, 'AEDT', '-883641600', 39600, '1'),
(35, 'AEST', '-876128400', 36000, '0'),
(35, 'AEDT', '-860400000', 39600, '1'),
(35, 'AEST', '-844678800', 36000, '0'),
(35, 'AEDT', '-828345600', 39600, '1'),
(35, 'AEST', '-813229200', 36000, '0'),
(35, 'AEDT', '-71136000', 39600, '1'),
(35, 'AEST', '-55411200', 36000, '0'),
(35, 'AEDT', '-37267200', 39600, '1'),
(35, 'AEST', '-25776000', 36000, '0'),
(35, 'AEDT', '-5817600', 39600, '1'),
(35, 'AEST', '5673600', 36000, '0'),
(35, 'AEDT', '25632000', 39600, '1'),
(35, 'AEST', '37728000', 36000, '0'),
(35, 'AEDT', '57686400', 39600, '1'),
(35, 'AEST', '67968000', 36000, '0'),
(35, 'AEDT', '89136000', 39600, '1'),
(35, 'AEST', '100022400', 36000, '0'),
(35, 'AEDT', '120585600', 39600, '1'),
(35, 'AEST', '131472000', 36000, '0'),
(35, 'AEDT', '152035200', 39600, '1'),
(35, 'AEST', '162921600', 36000, '0'),
(35, 'AEDT', '183484800', 39600, '1'),
(35, 'AEST', '194976000', 36000, '0'),
(35, 'AEDT', '215539200', 39600, '1'),
(35, 'AEST', '226425600', 36000, '0'),
(35, 'AEDT', '246988800', 39600, '1'),
(35, 'AEST', '257875200', 36000, '0'),
(35, 'AEDT', '278438400', 39600, '1'),
(35, 'AEST', '289324800', 36000, '0'),
(35, 'AEDT', '309888000', 39600, '1'),
(35, 'AEST', '320774400', 36000, '0'),
(35, 'AEDT', '341337600', 39600, '1'),
(35, 'AEST', '352224000', 36000, '0'),
(35, 'AEDT', '372787200', 39600, '1'),
(35, 'AEST', '386092800', 36000, '0'),
(35, 'AEDT', '404841600', 39600, '1'),
(35, 'AEST', '417542400', 36000, '0'),
(35, 'AEDT', '436291200', 39600, '1'),
(35, 'AEST', '447177600', 36000, '0'),
(35, 'AEDT', '467740800', 39600, '1'),
(35, 'AEST', '478627200', 36000, '0'),
(35, 'AEDT', '499190400', 39600, '1'),
(35, 'AEST', '510076800', 36000, '0'),
(35, 'AEDT', '530035200', 39600, '1'),
(35, 'AEST', '542736000', 36000, '0'),
(35, 'AEDT', '562089600', 39600, '1'),
(35, 'AEST', '574790400', 36000, '0'),
(35, 'AEDT', '594144000', 39600, '1'),
(35, 'AEST', '606240000', 36000, '0'),
(35, 'AEDT', '625593600', 39600, '1'),
(35, 'AEST', '637689600', 36000, '0'),
(35, 'AEDT', '657043200', 39600, '1'),
(35, 'AEST', '670348800', 36000, '0'),
(35, 'AEDT', '686678400', 39600, '1'),
(35, 'AEST', '701798400', 36000, '0'),
(35, 'AEDT', '718128000', 39600, '1'),
(35, 'AEST', '733248000', 36000, '0'),
(35, 'AEDT', '749577600', 39600, '1'),
(35, 'AEST', '764697600', 36000, '0'),
(35, 'AEDT', '781027200', 39600, '1'),
(35, 'AEST', '796147200', 36000, '0'),
(35, 'AEDT', '812476800', 39600, '1'),
(35, 'AEST', '828201600', 36000, '0'),
(35, 'AEDT', '844531200', 39600, '1'),
(35, 'AEST', '859651200', 36000, '0'),
(35, 'AEDT', '875980800', 39600, '1'),
(35, 'AEST', '891100800', 36000, '0'),
(35, 'AEDT', '907430400', 39600, '1'),
(35, 'AEST', '922550400', 36000, '0'),
(35, 'AEDT', '938880000', 39600, '1'),
(35, 'AEST', '954000000', 36000, '0'),
(35, 'AEDT', '967305600', 39600, '1'),
(35, 'AEST', '985449600', 36000, '0'),
(35, 'AEDT', '1002384000', 39600, '1'),
(35, 'AEST', '1017504000', 36000, '0'),
(35, 'AEDT', '1033833600', 39600, '1'),
(35, 'AEST', '1048953600', 36000, '0'),
(35, 'AEDT', '1065283200', 39600, '1'),
(35, 'AEST', '1080403200', 36000, '0'),
(35, 'AEDT', '1096732800', 39600, '1'),
(35, 'AEST', '1111852800', 36000, '0'),
(35, 'AEDT', '1128182400', 39600, '1'),
(35, 'AEST', '1143907200', 36000, '0'),
(35, 'AEDT', '1159632000', 39600, '1'),
(35, 'AEST', '1174752000', 36000, '0'),
(35, 'AEDT', '1191686400', 39600, '1'),
(35, 'AEST', '1207411200', 36000, '0'),
(35, 'AEDT', '1223136000', 39600, '1'),
(35, 'AEST', '1238860800', 36000, '0'),
(35, 'AEDT', '1254585600', 39600, '1'),
(35, 'AEST', '1270310400', 36000, '0'),
(35, 'AEDT', '1286035200', 39600, '1'),
(35, 'AEST', '1301760000', 36000, '0'),
(35, 'AEDT', '1317484800', 39600, '1'),
(35, 'AEST', '1333209600', 36000, '0'),
(35, 'AEDT', '1349539200', 39600, '1'),
(35, 'AEST', '1365264000', 36000, '0'),
(35, 'AEDT', '1380988800', 39600, '1'),
(35, 'AEST', '1396713600', 36000, '0'),
(35, 'AEDT', '1412438400', 39600, '1'),
(35, 'AEST', '1428163200', 36000, '0'),
(35, 'AEDT', '1443888000', 39600, '1'),
(35, 'AEST', '1459612800', 36000, '0'),
(35, 'AEDT', '1475337600', 39600, '1'),
(35, 'AEST', '1491062400', 36000, '0'),
(35, 'AEDT', '1506787200', 39600, '1'),
(35, 'AEST', '1522512000', 36000, '0'),
(35, 'AEDT', '1538841600', 39600, '1'),
(35, 'AEST', '1554566400', 36000, '0'),
(35, 'AEDT', '1570291200', 39600, '1'),
(35, 'AEST', '1586016000', 36000, '0'),
(35, 'AEDT', '1601740800', 39600, '1'),
(35, 'AEST', '1617465600', 36000, '0'),
(35, 'AEDT', '1633190400', 39600, '1'),
(35, 'AEST', '1648915200', 36000, '0'),
(35, 'AEDT', '1664640000', 39600, '1'),
(35, 'AEST', '1680364800', 36000, '0'),
(35, 'AEDT', '1696089600', 39600, '1'),
(35, 'AEST', '1712419200', 36000, '0'),
(35, 'AEDT', '1728144000', 39600, '1'),
(35, 'AEST', '1743868800', 36000, '0'),
(35, 'AEDT', '1759593600', 39600, '1'),
(35, 'AEST', '1775318400', 36000, '0'),
(35, 'AEDT', '1791043200', 39600, '1'),
(35, 'AEST', '1806768000', 36000, '0'),
(35, 'AEDT', '1822492800', 39600, '1'),
(35, 'AEST', '1838217600', 36000, '0'),
(35, 'AEDT', '1853942400', 39600, '1'),
(35, 'AEST', '1869667200', 36000, '0'),
(35, 'AEDT', '1885996800', 39600, '1'),
(35, 'AEST', '1901721600', 36000, '0'),
(35, 'AEDT', '1917446400', 39600, '1'),
(35, 'AEST', '1933171200', 36000, '0'),
(35, 'AEDT', '1948896000', 39600, '1'),
(35, 'AEST', '1964620800', 36000, '0'),
(35, 'AEDT', '1980345600', 39600, '1'),
(35, 'AEST', '1996070400', 36000, '0'),
(35, 'AEDT', '2011795200', 39600, '1'),
(35, 'AEST', '2027520000', 36000, '0'),
(35, 'AEDT', '2043244800', 39600, '1'),
(35, 'AEST', '2058969600', 36000, '0'),
(35, 'AEDT', '2075299200', 39600, '1'),
(35, 'AEST', '2091024000', 36000, '0'),
(35, 'AEDT', '2106748800', 39600, '1'),
(35, 'AEST', '2122473600', 36000, '0'),
(35, 'AEDT', '2138198400', 39600, '1'),
(35, 'AEST', '2153923200', 36000, '0'),
(35, 'AEDT', '2169648000', 39600, '1'),
(35, 'AEST', '2185372800', 36000, '0'),
(35, 'AEDT', '2201097600', 39600, '1'),
(35, 'AEST', '2216822400', 36000, '0'),
(35, 'AEDT', '2233152000', 39600, '1'),
(35, 'AEST', '2248876800', 36000, '0'),
(35, 'AEDT', '2264601600', 39600, '1'),
(35, 'AEST', '2280326400', 36000, '0'),
(35, 'AEDT', '2296051200', 39600, '1'),
(35, 'AEST', '2311776000', 36000, '0'),
(35, 'AEDT', '2327500800', 39600, '1'),
(35, 'AEST', '2343225600', 36000, '0'),
(35, 'AEDT', '2358950400', 39600, '1'),
(35, 'AEST', '2374675200', 36000, '0'),
(35, 'AEDT', '2390400000', 39600, '1'),
(35, 'AEST', '2406124800', 36000, '0'),
(35, 'AEDT', '2422454400', 39600, '1'),
(35, 'AEST', '2438179200', 36000, '0'),
(35, 'AEDT', '2453904000', 39600, '1'),
(35, 'AEST', '2469628800', 36000, '0'),
(35, 'AEDT', '2485353600', 39600, '1'),
(35, 'AEST', '2501078400', 36000, '0'),
(35, 'AEDT', '2516803200', 39600, '1'),
(35, 'AEST', '2532528000', 36000, '0'),
(35, 'AEDT', '2548252800', 39600, '1'),
(35, 'AEST', '2563977600', 36000, '0'),
(35, 'AEDT', '2579702400', 39600, '1'),
(35, 'AEST', '2596032000', 36000, '0'),
(35, 'AEDT', '2611756800', 39600, '1'),
(35, 'AEST', '2627481600', 36000, '0'),
(35, 'AEDT', '2643206400', 39600, '1'),
(35, 'AEST', '2658931200', 36000, '0'),
(35, 'AEDT', '2674656000', 39600, '1'),
(35, 'AEST', '2690380800', 36000, '0'),
(35, 'AEDT', '2706105600', 39600, '1'),
(35, 'AEST', '2721830400', 36000, '0'),
(35, 'AEDT', '2737555200', 39600, '1'),
(35, 'AEST', '2753280000', 36000, '0'),
(35, 'AEDT', '2769609600', 39600, '1'),
(35, 'AEST', '2785334400', 36000, '0'),
(35, 'AEDT', '2801059200', 39600, '1'),
(35, 'AEST', '2816784000', 36000, '0'),
(35, 'AEDT', '2832508800', 39600, '1'),
(35, 'AEST', '2848233600', 36000, '0'),
(35, 'AEDT', '2863958400', 39600, '1'),
(35, 'AEST', '2879683200', 36000, '0'),
(35, 'AEDT', '2895408000', 39600, '1'),
(35, 'AEST', '2911132800', 36000, '0'),
(35, 'AEDT', '2926857600', 39600, '1'),
(35, 'AEST', '2942582400', 36000, '0'),
(35, 'AEDT', '2958912000', 39600, '1'),
(35, 'AEST', '2974636800', 36000, '0'),
(35, 'AEDT', '2990361600', 39600, '1'),
(35, 'AEST', '3006086400', 36000, '0'),
(35, 'AEDT', '3021811200', 39600, '1'),
(35, 'AEST', '3037536000', 36000, '0'),
(35, 'AEDT', '3053260800', 39600, '1'),
(35, 'AEST', '3068985600', 36000, '0'),
(35, 'AEDT', '3084710400', 39600, '1'),
(35, 'AEST', '3100435200', 36000, '0'),
(35, 'AEDT', '3116764800', 39600, '1'),
(35, 'AEST', '3132489600', 36000, '0'),
(35, 'AEDT', '3148214400', 39600, '1'),
(35, 'AEST', '3163939200', 36000, '0'),
(35, 'AEDT', '3179664000', 39600, '1'),
(35, 'AEST', '3195388800', 36000, '0'),
(35, 'AEDT', '3211113600', 39600, '1'),
(35, 'AEST', '3226838400', 36000, '0'),
(35, 'AEDT', '3242563200', 39600, '1'),
(35, 'AEST', '3258288000', 36000, '0'),
(35, 'AEDT', '3274012800', 39600, '1'),
(35, 'AEST', '3289737600', 36000, '0'),
(35, 'AEDT', '3306067200', 39600, '1'),
(35, 'AEST', '3321792000', 36000, '0'),
(35, 'AEDT', '3337516800', 39600, '1'),
(35, 'AEST', '3353241600', 36000, '0'),
(35, 'AEDT', '3368966400', 39600, '1'),
(35, 'AEST', '3384691200', 36000, '0'),
(35, 'AEDT', '3400416000', 39600, '1'),
(35, 'AEST', '3416140800', 36000, '0'),
(35, 'AEDT', '3431865600', 39600, '1'),
(35, 'AEST', '3447590400', 36000, '0'),
(35, 'AEDT', '3463315200', 39600, '1'),
(35, 'AEST', '3479644800', 36000, '0'),
(35, 'AEDT', '3495369600', 39600, '1'),
(35, 'AEST', '3511094400', 36000, '0'),
(35, 'AEDT', '3526819200', 39600, '1'),
(35, 'AEST', '3542544000', 36000, '0'),
(35, 'AEDT', '3558268800', 39600, '1'),
(35, 'AEST', '3573993600', 36000, '0'),
(35, 'AEDT', '3589718400', 39600, '1'),
(35, 'AEST', '3605443200', 36000, '0'),
(35, 'AEDT', '3621168000', 39600, '1'),
(35, 'AEST', '3636892800', 36000, '0'),
(35, 'AEDT', '3653222400', 39600, '1'),
(35, 'AEST', '3668947200', 36000, '0'),
(35, 'AEDT', '3684672000', 39600, '1'),
(35, 'AEST', '3700396800', 36000, '0'),
(35, 'AEDT', '3716121600', 39600, '1'),
(35, 'AEST', '3731846400', 36000, '0'),
(35, 'AEDT', '3747571200', 39600, '1'),
(35, 'AEST', '3763296000', 36000, '0'),
(35, 'AEDT', '3779020800', 39600, '1'),
(35, 'AEST', '3794745600', 36000, '0'),
(35, 'AEDT', '3810470400', 39600, '1'),
(35, 'AEST', '3826195200', 36000, '0'),
(35, 'AEDT', '3842524800', 39600, '1'),
(35, 'AEST', '3858249600', 36000, '0'),
(35, 'AEDT', '3873974400', 39600, '1'),
(35, 'AEST', '3889699200', 36000, '0'),
(35, 'AEDT', '3905424000', 39600, '1'),
(35, 'AEST', '3921148800', 36000, '0'),
(35, 'AEDT', '3936873600', 39600, '1'),
(35, 'AEST', '3952598400', 36000, '0'),
(35, 'AEDT', '3968323200', 39600, '1'),
(35, 'AEST', '3984048000', 36000, '0'),
(35, 'AEDT', '4000377600', 39600, '1'),
(35, 'AEST', '4016102400', 36000, '0'),
(35, 'AEDT', '4031827200', 39600, '1'),
(35, 'AEST', '4047552000', 36000, '0'),
(35, 'AEDT', '4063276800', 39600, '1'),
(35, 'AEST', '4079001600', 36000, '0'),
(35, 'AEDT', '4094726400', 39600, '1'),
(35, 'AEST', '4110451200', 36000, '0'),
(35, 'AEDT', '4126176000', 39600, '1'),
(35, 'AEST', '4141900800', 36000, '0'),
(35, 'AEDT', '4157625600', 39600, '1'),
(35, 'AEST', '4173350400', 36000, '0'),
(35, 'AEDT', '4189075200', 39600, '1'),
(35, 'AEST', '4204800000', 36000, '0'),
(35, 'AEDT', '4221129600', 39600, '1'),
(35, 'AEST', '4236854400', 36000, '0'),
(35, 'AEDT', '4252579200', 39600, '1'),
(35, 'AEST', '4268304000', 36000, '0'),
(35, 'AEDT', '4284028800', 39600, '1'),
(35, 'AEST', '4299753600', 36000, '0'),
(35, 'AEDT', '4315478400', 39600, '1'),
(35, 'AEST', '4331203200', 36000, '0'),
(35, 'AEDT', '4346928000', 39600, '1'),
(35, 'AEST', '4362652800', 36000, '0'),
(35, 'AEDT', '4378982400', 39600, '1'),
(35, 'AEST', '4394707200', 36000, '0'),
(35, 'AEDT', '4410432000', 39600, '1'),
(35, 'AEST', '4426156800', 36000, '0'),
(35, 'AEDT', '4441881600', 39600, '1'),
(35, 'AEST', '4457606400', 36000, '0'),
(35, 'AEDT', '4473331200', 39600, '1'),
(35, 'AEST', '4489056000', 36000, '0'),
(35, 'AEDT', '4504780800', 39600, '1'),
(35, 'AEST', '4520505600', 36000, '0'),
(35, 'AEDT', '4536230400', 39600, '1'),
(35, 'AEST', '4551955200', 36000, '0'),
(35, 'AEDT', '4568284800', 39600, '1'),
(35, 'AEST', '4584009600', 36000, '0'),
(35, 'AEDT', '4599734400', 39600, '1'),
(35, 'AEST', '4615459200', 36000, '0'),
(35, 'AEDT', '4631184000', 39600, '1'),
(35, 'AEST', '4646908800', 36000, '0'),
(35, 'AEDT', '4662633600', 39600, '1'),
(35, 'AEST', '4678358400', 36000, '0'),
(35, 'AEDT', '4694083200', 39600, '1'),
(35, 'AEST', '4709808000', 36000, '0'),
(35, 'AEDT', '4725532800', 39600, '1'),
(35, 'AEST', '4741862400', 36000, '0'),
(35, 'AEDT', '4757587200', 39600, '1'),
(35, 'AEST', '4773312000', 36000, '0'),
(35, 'AEDT', '4789036800', 39600, '1'),
(35, 'AEST', '4804761600', 36000, '0'),
(35, 'AEDT', '4820486400', 39600, '1'),
(35, 'AEST', '4836211200', 36000, '0'),
(35, 'AEDT', '4851936000', 39600, '1'),
(35, 'AEST', '4867660800', 36000, '0'),
(35, 'AEDT', '4883385600', 39600, '1'),
(35, 'AEST', '4899110400', 36000, '0'),
(35, 'AEDT', '4915440000', 39600, '1'),
(35, 'AEST', '4931164800', 36000, '0'),
(35, 'AEDT', '4946889600', 39600, '1'),
(35, 'AEST', '4962614400', 36000, '0'),
(35, 'AEDT', '4978339200', 39600, '1'),
(35, 'AEST', '4994064000', 36000, '0'),
(35, 'AEDT', '5009788800', 39600, '1'),
(35, 'AEST', '5025513600', 36000, '0'),
(35, 'AEDT', '5041238400', 39600, '1'),
(35, 'AEST', '5056963200', 36000, '0'),
(35, 'AEDT', '5072688000', 39600, '1'),
(35, 'AEST', '5088412800', 36000, '0'),
(35, 'AEDT', '5104742400', 39600, '1'),
(35, 'AEST', '5120467200', 36000, '0'),
(35, 'AEDT', '5136192000', 39600, '1'),
(35, 'AEST', '5151916800', 36000, '0'),
(35, 'AEDT', '5167641600', 39600, '1'),
(35, 'AEST', '5183366400', 36000, '0'),
(35, 'AEDT', '5199091200', 39600, '1'),
(35, 'AEST', '5214816000', 36000, '0'),
(35, 'AEDT', '5230540800', 39600, '1'),
(35, 'AEST', '5246265600', 36000, '0'),
(35, 'AEDT', '5262595200', 39600, '1'),
(35, 'AEST', '5278320000', 36000, '0'),
(35, 'AEDT', '5294044800', 39600, '1'),
(35, 'AEST', '5309769600', 36000, '0'),
(35, 'AEDT', '5325494400', 39600, '1'),
(35, 'AEST', '5341219200', 36000, '0'),
(35, 'AEDT', '5356944000', 39600, '1'),
(35, 'AEST', '5372668800', 36000, '0'),
(35, 'AEDT', '5388393600', 39600, '1'),
(35, 'AEST', '5404118400', 36000, '0'),
(35, 'AEDT', '5419843200', 39600, '1'),
(35, 'AEST', '5435568000', 36000, '0'),
(35, 'AEDT', '5451897600', 39600, '1'),
(35, 'AEST', '5467622400', 36000, '0'),
(35, 'AEDT', '5483347200', 39600, '1'),
(35, 'AEST', '5499072000', 36000, '0'),
(35, 'AEDT', '5514796800', 39600, '1'),
(35, 'AEST', '5530521600', 36000, '0'),
(35, 'AEDT', '5546246400', 39600, '1'),
(35, 'AEST', '5561971200', 36000, '0'),
(35, 'AEDT', '5577696000', 39600, '1'),
(35, 'AEST', '5593420800', 36000, '0'),
(35, 'AEDT', '5609145600', 39600, '1'),
(35, 'AEST', '5625475200', 36000, '0'),
(35, 'AEDT', '5641200000', 39600, '1'),
(35, 'AEST', '5656924800', 36000, '0'),
(35, 'AEDT', '5672649600', 39600, '1'),
(35, 'AEST', '5688374400', 36000, '0'),
(35, 'AEDT', '5704099200', 39600, '1'),
(35, 'AEST', '5719824000', 36000, '0'),
(35, 'AEDT', '5735548800', 39600, '1'),
(35, 'AEST', '5751273600', 36000, '0'),
(35, 'AEDT', '5766998400', 39600, '1'),
(35, 'AEST', '5782723200', 36000, '0'),
(35, 'AEDT', '5799052800', 39600, '1'),
(35, 'AEST', '5814777600', 36000, '0'),
(35, 'AEDT', '5830502400', 39600, '1'),
(35, 'AEST', '5846227200', 36000, '0'),
(35, 'AEDT', '5861952000', 39600, '1'),
(35, 'AEST', '5877676800', 36000, '0'),
(35, 'AEDT', '5893401600', 39600, '1'),
(35, 'AEST', '5909126400', 36000, '0'),
(35, 'AEDT', '5924851200', 39600, '1'),
(35, 'AEST', '5940576000', 36000, '0'),
(35, 'AEDT', '5956300800', 39600, '1'),
(35, 'AEST', '5972025600', 36000, '0'),
(35, 'AEDT', '5988355200', 39600, '1'),
(35, 'AEST', '6004080000', 36000, '0'),
(35, 'AEDT', '6019804800', 39600, '1'),
(35, 'AEST', '6035529600', 36000, '0'),
(35, 'AEDT', '6051254400', 39600, '1'),
(35, 'AEST', '6066979200', 36000, '0'),
(35, 'AEDT', '6082704000', 39600, '1'),
(35, 'AEST', '6098428800', 36000, '0'),
(35, 'AEDT', '6114153600', 39600, '1'),
(35, 'AEST', '6129878400', 36000, '0'),
(35, 'AEDT', '6146208000', 39600, '1'),
(35, 'AEST', '6161932800', 36000, '0'),
(35, 'AEDT', '6177657600', 39600, '1'),
(35, 'AEST', '6193382400', 36000, '0'),
(35, 'AEDT', '6209107200', 39600, '1'),
(35, 'AEST', '6224832000', 36000, '0'),
(35, 'AEDT', '6240556800', 39600, '1'),
(35, 'AEST', '6256281600', 36000, '0'),
(35, 'AEDT', '6272006400', 39600, '1'),
(35, 'AEST', '6287731200', 36000, '0'),
(35, 'AEDT', '6303456000', 39600, '1'),
(35, 'AEST', '6319180800', 36000, '0'),
(35, 'AEDT', '6335510400', 39600, '1'),
(35, 'AEST', '6351235200', 36000, '0'),
(35, 'AEDT', '6366960000', 39600, '1'),
(35, 'AEST', '6382684800', 36000, '0'),
(35, 'AEDT', '6398409600', 39600, '1'),
(35, 'AEST', '6414134400', 36000, '0'),
(35, 'AEDT', '6429859200', 39600, '1'),
(35, 'AEST', '6445584000', 36000, '0'),
(35, 'AEDT', '6461308800', 39600, '1'),
(35, 'AEST', '6477033600', 36000, '0'),
(35, 'AEDT', '6492758400', 39600, '1'),
(35, 'AEST', '6509088000', 36000, '0'),
(35, 'AEDT', '6524812800', 39600, '1'),
(35, 'AEST', '6540537600', 36000, '0'),
(35, 'AEDT', '6556262400', 39600, '1'),
(35, 'AEST', '6571987200', 36000, '0'),
(35, 'AEDT', '6587712000', 39600, '1'),
(35, 'AEST', '6603436800', 36000, '0'),
(35, 'AEDT', '6619161600', 39600, '1'),
(35, 'AEST', '6634886400', 36000, '0'),
(35, 'AEDT', '6650611200', 39600, '1'),
(35, 'AEST', '6666336000', 36000, '0'),
(35, 'AEDT', '6682665600', 39600, '1'),
(35, 'AEST', '6698390400', 36000, '0'),
(35, 'AEDT', '6714115200', 39600, '1'),
(35, 'AEST', '6729840000', 36000, '0'),
(35, 'AEDT', '6745564800', 39600, '1'),
(35, 'AEST', '6761289600', 36000, '0'),
(35, 'AEDT', '6777014400', 39600, '1'),
(35, 'AEST', '6792739200', 36000, '0'),
(35, 'AEDT', '6808464000', 39600, '1'),
(35, 'AEST', '6824188800', 36000, '0'),
(35, 'AEDT', '6839913600', 39600, '1'),
(35, 'AEST', '6855638400', 36000, '0'),
(35, 'AEDT', '6871968000', 39600, '1'),
(35, 'AEST', '6887692800', 36000, '0'),
(35, 'AEDT', '6903417600', 39600, '1'),
(35, 'AEST', '6919142400', 36000, '0'),
(35, 'AEDT', '6934867200', 39600, '1'),
(35, 'AEST', '6950592000', 36000, '0'),
(35, 'AEDT', '6966316800', 39600, '1'),
(35, 'AEST', '6982041600', 36000, '0'),
(35, 'AEDT', '6997766400', 39600, '1'),
(35, 'AEST', '7013491200', 36000, '0'),
(35, 'AEDT', '7029820800', 39600, '1'),
(35, 'AEST', '7045545600', 36000, '0'),
(35, 'AEDT', '7061270400', 39600, '1'),
(35, 'AEST', '7076995200', 36000, '0'),
(35, 'AEDT', '7092720000', 39600, '1'),
(35, 'AEST', '7108444800', 36000, '0'),
(35, 'AEDT', '7124169600', 39600, '1'),
(35, 'AEST', '7139894400', 36000, '0'),
(35, 'AEDT', '7155619200', 39600, '1'),
(35, 'AEST', '7171344000', 36000, '0'),
(35, 'AEDT', '7187068800', 39600, '1'),
(35, 'AEST', '7202793600', 36000, '0'),
(35, 'AEDT', '7219123200', 39600, '1'),
(35, 'AEST', '7234848000', 36000, '0'),
(35, 'AEDT', '7250572800', 39600, '1'),
(35, 'AEST', '7266297600', 36000, '0'),
(35, 'AEDT', '7282022400', 39600, '1'),
(35, 'AEST', '7297747200', 36000, '0'),
(35, 'AEDT', '7313472000', 39600, '1'),
(35, 'AEST', '7329196800', 36000, '0'),
(35, 'AEDT', '7344921600', 39600, '1'),
(35, 'AEST', '7360646400', 36000, '0'),
(35, 'AEDT', '7376371200', 39600, '1'),
(35, 'AEST', '7392096000', 36000, '0'),
(35, 'AEDT', '7408425600', 39600, '1'),
(35, 'AEST', '7424150400', 36000, '0'),
(35, 'AEDT', '7439875200', 39600, '1'),
(35, 'AEST', '7455600000', 36000, '0'),
(35, 'AEDT', '7471324800', 39600, '1'),
(35, 'AEST', '7487049600', 36000, '0'),
(35, 'AEDT', '7502774400', 39600, '1'),
(35, 'AEST', '7518499200', 36000, '0'),
(35, 'AEDT', '7534224000', 39600, '1'),
(35, 'AEST', '7549948800', 36000, '0'),
(35, 'AEDT', '7565673600', 39600, '1'),
(35, 'AEST', '7581398400', 36000, '0'),
(35, 'AEDT', '7597728000', 39600, '1'),
(35, 'AEST', '7613452800', 36000, '0'),
(35, 'AEDT', '7629177600', 39600, '1'),
(35, 'AEST', '7644902400', 36000, '0'),
(35, 'AEDT', '7660627200', 39600, '1'),
(35, 'AEST', '7676352000', 36000, '0'),
(35, 'AEDT', '7692076800', 39600, '1'),
(35, 'AEST', '7707801600', 36000, '0'),
(35, 'AEDT', '7723526400', 39600, '1'),
(35, 'AEST', '7739251200', 36000, '0'),
(35, 'AEDT', '7754976000', 39600, '1'),
(35, 'AEST', '7771305600', 36000, '0'),
(35, 'AEDT', '7787030400', 39600, '1'),
(35, 'AEST', '7802755200', 36000, '0'),
(35, 'AEDT', '7818480000', 39600, '1'),
(35, 'AEST', '7834204800', 36000, '0'),
(35, 'AEDT', '7849929600', 39600, '1'),
(35, 'AEST', '7865654400', 36000, '0'),
(35, 'AEDT', '7881379200', 39600, '1'),
(35, 'AEST', '7897104000', 36000, '0'),
(35, 'AEDT', '7912828800', 39600, '1'),
(35, 'AEST', '7928553600', 36000, '0'),
(35, 'AEDT', '7944883200', 39600, '1'),
(35, 'AEST', '7960608000', 36000, '0'),
(35, 'AEDT', '7976332800', 39600, '1'),
(35, 'AEST', '7992057600', 36000, '0'),
(35, 'AEDT', '8007782400', 39600, '1'),
(35, 'AEST', '8023507200', 36000, '0'),
(35, 'AEDT', '8039232000', 39600, '1'),
(35, 'AEST', '8054956800', 36000, '0'),
(35, 'AEDT', '8070681600', 39600, '1'),
(35, 'AEST', '8086406400', 36000, '0'),
(35, 'AEDT', '8102131200', 39600, '1'),
(35, 'AEST', '8117856000', 36000, '0'),
(35, 'AEDT', '8134185600', 39600, '1'),
(35, 'AEST', '8149910400', 36000, '0'),
(35, 'AEDT', '8165635200', 39600, '1'),
(35, 'AEST', '8181360000', 36000, '0'),
(35, 'AEDT', '8197084800', 39600, '1'),
(35, 'AEST', '8212809600', 36000, '0'),
(35, 'AEDT', '8228534400', 39600, '1'),
(35, 'AEST', '8244259200', 36000, '0'),
(35, 'AEDT', '8259984000', 39600, '1'),
(35, 'AEST', '8275708800', 36000, '0'),
(35, 'AEDT', '8292038400', 39600, '1'),
(35, 'AEST', '8307763200', 36000, '0'),
(35, 'AEDT', '8323488000', 39600, '1'),
(35, 'AEST', '8339212800', 36000, '0'),
(35, 'AEDT', '8354937600', 39600, '1'),
(35, 'AEST', '8370662400', 36000, '0'),
(35, 'AEDT', '8386387200', 39600, '1'),
(35, 'AEST', '8402112000', 36000, '0'),
(35, 'AEDT', '8417836800', 39600, '1'),
(35, 'AEST', '8433561600', 36000, '0'),
(35, 'AEDT', '8449286400', 39600, '1'),
(35, 'AEST', '8465011200', 36000, '0'),
(35, 'AEDT', '8481340800', 39600, '1'),
(35, 'AEST', '8497065600', 36000, '0'),
(35, 'AEDT', '8512790400', 39600, '1'),
(35, 'AEST', '8528515200', 36000, '0'),
(35, 'AEDT', '8544240000', 39600, '1'),
(35, 'AEST', '8559964800', 36000, '0'),
(35, 'AEDT', '8575689600', 39600, '1'),
(35, 'AEST', '8591414400', 36000, '0'),
(35, 'AEDT', '8607139200', 39600, '1'),
(35, 'AEST', '8622864000', 36000, '0'),
(35, 'AEDT', '8638588800', 39600, '1'),
(35, 'AEST', '8654918400', 36000, '0'),
(35, 'AEDT', '8670643200', 39600, '1'),
(35, 'AEST', '8686368000', 36000, '0'),
(35, 'AEDT', '8702092800', 39600, '1'),
(35, 'AEST', '8717817600', 36000, '0'),
(35, 'AEDT', '8733542400', 39600, '1'),
(35, 'AEST', '8749267200', 36000, '0'),
(35, 'AEDT', '8764992000', 39600, '1'),
(35, 'AEST', '8780716800', 36000, '0'),
(35, 'AEDT', '8796441600', 39600, '1'),
(35, 'AEST', '8812166400', 36000, '0'),
(35, 'AEDT', '8828496000', 39600, '1'),
(35, 'AEST', '8844220800', 36000, '0'),
(35, 'AEDT', '8859945600', 39600, '1'),
(35, 'AEST', '8875670400', 36000, '0'),
(35, 'AEDT', '8891395200', 39600, '1'),
(35, 'AEST', '8907120000', 36000, '0'),
(35, 'AEDT', '8922844800', 39600, '1'),
(35, 'AEST', '8938569600', 36000, '0'),
(35, 'AEDT', '8954294400', 39600, '1'),
(35, 'AEST', '8970019200', 36000, '0'),
(35, 'AEDT', '8985744000', 39600, '1'),
(35, 'AEST', '9001468800', 36000, '0'),
(35, 'AEDT', '9017798400', 39600, '1'),
(35, 'AEST', '9033523200', 36000, '0'),
(35, 'AEDT', '9049248000', 39600, '1'),
(35, 'AEST', '9064972800', 36000, '0'),
(35, 'AEDT', '9080697600', 39600, '1'),
(35, 'AEST', '9096422400', 36000, '0'),
(35, 'AEDT', '9112147200', 39600, '1'),
(35, 'AEST', '9127872000', 36000, '0'),
(35, 'AEDT', '9143596800', 39600, '1'),
(35, 'AEST', '9159321600', 36000, '0'),
(35, 'AEDT', '9175651200', 39600, '1'),
(35, 'AEST', '9191376000', 36000, '0'),
(35, 'AEDT', '9207100800', 39600, '1'),
(35, 'AEST', '9222825600', 36000, '0'),
(35, 'AEDT', '9238550400', 39600, '1'),
(35, 'AEST', '9254275200', 36000, '0'),
(35, 'AEDT', '9270000000', 39600, '1'),
(35, 'AEST', '9285724800', 36000, '0'),
(35, 'AEDT', '9301449600', 39600, '1'),
(35, 'AEST', '9317174400', 36000, '0'),
(35, 'AEDT', '9332899200', 39600, '1'),
(35, 'AEST', '9348624000', 36000, '0'),
(35, 'AEDT', '9364953600', 39600, '1'),
(35, 'AEST', '9380678400', 36000, '0'),
(35, 'AEDT', '9396403200', 39600, '1'),
(35, 'AEST', '9412128000', 36000, '0'),
(35, 'AEDT', '9427852800', 39600, '1'),
(35, 'AEST', '9443577600', 36000, '0'),
(35, 'AEDT', '9459302400', 39600, '1'),
(35, 'AEST', '9475027200', 36000, '0'),
(35, 'AEDT', '9490752000', 39600, '1'),
(35, 'AEST', '9506476800', 36000, '0'),
(35, 'AEDT', '9522201600', 39600, '1'),
(35, 'AEST', '9538531200', 36000, '0'),
(35, 'AEDT', '9554256000', 39600, '1'),
(35, 'AEST', '9569980800', 36000, '0'),
(35, 'AEDT', '9585705600', 39600, '1'),
(35, 'AEST', '9601430400', 36000, '0'),
(35, 'AEDT', '9617155200', 39600, '1'),
(35, 'AEST', '9632880000', 36000, '0'),
(35, 'AEDT', '9648604800', 39600, '1'),
(35, 'AEST', '9664329600', 36000, '0'),
(35, 'AEDT', '9680054400', 39600, '1'),
(35, 'AEST', '9695779200', 36000, '0'),
(35, 'AEDT', '9712108800', 39600, '1'),
(35, 'AEST', '9727833600', 36000, '0'),
(35, 'AEDT', '9743558400', 39600, '1'),
(35, 'AEST', '9759283200', 36000, '0'),
(35, 'AEDT', '9775008000', 39600, '1'),
(35, 'AEST', '9790732800', 36000, '0'),
(35, 'AEDT', '9806457600', 39600, '1'),
(35, 'AEST', '9822182400', 36000, '0'),
(35, 'AEDT', '9837907200', 39600, '1'),
(35, 'AEST', '9853632000', 36000, '0'),
(35, 'AEDT', '9869356800', 39600, '1'),
(35, 'AEST', '9885081600', 36000, '0'),
(35, 'AEDT', '9901411200', 39600, '1'),
(35, 'AEST', '9917136000', 36000, '0'),
(35, 'AEDT', '9932860800', 39600, '1'),
(35, 'AEST', '9948585600', 36000, '0'),
(35, 'AEDT', '9964310400', 39600, '1'),
(35, 'AEST', '9980035200', 36000, '0'),
(35, 'AEDT', '9995760000', 39600, '1'),
(35, 'AEST', '10011484800', 36000, '0'),
(35, 'AEDT', '10027209600', 39600, '1'),
(35, 'AEST', '10042934400', 36000, '0'),
(35, 'AEDT', '10059264000', 39600, '1'),
(35, 'AEST', '10074988800', 36000, '0'),
(35, 'AEDT', '10090713600', 39600, '1'),
(35, 'AEST', '10106438400', 36000, '0'),
(35, 'AEDT', '10122163200', 39600, '1'),
(35, 'AEST', '10137888000', 36000, '0'),
(35, 'AEDT', '10153612800', 39600, '1'),
(35, 'AEST', '10169337600', 36000, '0'),
(35, 'AEDT', '10185062400', 39600, '1'),
(35, 'AEST', '10200787200', 36000, '0'),
(35, 'AEDT', '10216512000', 39600, '1'),
(35, 'AEST', '10232236800', 36000, '0'),
(35, 'AEDT', '10248566400', 39600, '1'),
(35, 'AEST', '10264291200', 36000, '0'),
(35, 'AEDT', '10280016000', 39600, '1'),
(35, 'AEST', '10295740800', 36000, '0'),
(35, 'AEDT', '10311465600', 39600, '1'),
(35, 'AEST', '10327190400', 36000, '0'),
(35, 'AEDT', '10342915200', 39600, '1'),
(35, 'AEST', '10358640000', 36000, '0'),
(35, 'AEDT', '10374364800', 39600, '1'),
(35, 'AEST', '10390089600', 36000, '0'),
(35, 'AEDT', '10405814400', 39600, '1'),
(35, 'AEST', '10421539200', 36000, '0'),
(35, 'AEDT', '10437868800', 39600, '1'),
(35, 'AEST', '10453593600', 36000, '0'),
(35, 'AEDT', '10469318400', 39600, '1'),
(35, 'AEST', '10485043200', 36000, '0'),
(35, 'AEDT', '10500768000', 39600, '1'),
(35, 'AEST', '10516492800', 36000, '0'),
(35, 'AEDT', '10532217600', 39600, '1'),
(35, 'AEST', '10547942400', 36000, '0'),
(35, 'AEDT', '10563667200', 39600, '1'),
(35, 'AEST', '10579392000', 36000, '0'),
(35, 'AEDT', '10595116800', 39600, '1'),
(35, 'AEST', '10610841600', 36000, '0'),
(35, 'AEDT', '10627171200', 39600, '1'),
(35, 'AEST', '10642896000', 36000, '0'),
(35, 'AEDT', '10658620800', 39600, '1'),
(35, 'AEST', '10674345600', 36000, '0'),
(35, 'AEDT', '10690070400', 39600, '1'),
(35, 'AEST', '10705795200', 36000, '0'),
(35, 'AEDT', '10721520000', 39600, '1'),
(35, 'AEST', '10737244800', 36000, '0'),
(35, 'AEDT', '10752969600', 39600, '1'),
(35, 'AEST', '10768694400', 36000, '0'),
(35, 'AEDT', '10784419200', 39600, '1'),
(35, 'AEST', '10800748800', 36000, '0'),
(35, 'AEDT', '10816473600', 39600, '1'),
(35, 'AEST', '10832198400', 36000, '0'),
(35, 'AEDT', '10847923200', 39600, '1'),
(35, 'AEST', '10863648000', 36000, '0'),
(35, 'AEDT', '10879372800', 39600, '1'),
(35, 'AEST', '10895097600', 36000, '0'),
(35, 'AEDT', '10910822400', 39600, '1'),
(35, 'AEST', '10926547200', 36000, '0'),
(35, 'AEDT', '10942272000', 39600, '1'),
(35, 'AEST', '10957996800', 36000, '0'),
(35, 'AEDT', '10974326400', 39600, '1'),
(35, 'AEST', '10990051200', 36000, '0'),
(35, 'AEDT', '11005776000', 39600, '1'),
(35, 'AEST', '11021500800', 36000, '0'),
(35, 'AEDT', '11037225600', 39600, '1'),
(35, 'AEST', '11052950400', 36000, '0'),
(35, 'AEDT', '11068675200', 39600, '1'),
(35, 'AEST', '11084400000', 36000, '0'),
(35, 'AEDT', '11100124800', 39600, '1'),
(35, 'AEST', '11115849600', 36000, '0'),
(35, 'AEDT', '11131574400', 39600, '1'),
(35, 'AEST', '11147299200', 36000, '0'),
(35, 'AEDT', '11163628800', 39600, '1'),
(35, 'AEST', '11179353600', 36000, '0'),
(35, 'AEDT', '11195078400', 39600, '1'),
(35, 'AEST', '11210803200', 36000, '0'),
(35, 'AEDT', '11226528000', 39600, '1'),
(35, 'AEST', '11242252800', 36000, '0'),
(35, 'AEDT', '11257977600', 39600, '1'),
(35, 'AEST', '11273702400', 36000, '0'),
(35, 'AEDT', '11289427200', 39600, '1'),
(35, 'AEST', '11305152000', 36000, '0'),
(35, 'AEDT', '11321481600', 39600, '1'),
(35, 'AEST', '11337206400', 36000, '0'),
(35, 'AEDT', '11352931200', 39600, '1'),
(35, 'AEST', '11368656000', 36000, '0'),
(35, 'AEDT', '11384380800', 39600, '1'),
(35, 'AEST', '11400105600', 36000, '0'),
(35, 'AEDT', '11415830400', 39600, '1'),
(35, 'AEST', '11431555200', 36000, '0'),
(35, 'AEDT', '11447280000', 39600, '1'),
(35, 'AEST', '11463004800', 36000, '0'),
(35, 'AEDT', '11478729600', 39600, '1'),
(35, 'AEST', '11494454400', 36000, '0'),
(35, 'AEDT', '11510784000', 39600, '1'),
(35, 'AEST', '11526508800', 36000, '0'),
(35, 'AEDT', '11542233600', 39600, '1'),
(35, 'AEST', '11557958400', 36000, '0'),
(35, 'AEDT', '11573683200', 39600, '1'),
(35, 'AEST', '11589408000', 36000, '0'),
(35, 'AEDT', '11605132800', 39600, '1'),
(35, 'AEST', '11620857600', 36000, '0'),
(35, 'AEDT', '11636582400', 39600, '1'),
(35, 'AEST', '11652307200', 36000, '0'),
(35, 'AEDT', '11668032000', 39600, '1'),
(35, 'AEST', '11684361600', 36000, '0'),
(35, 'AEDT', '11700086400', 39600, '1'),
(35, 'AEST', '11715811200', 36000, '0'),
(35, 'AEDT', '11731536000', 39600, '1'),
(35, 'AEST', '11747260800', 36000, '0'),
(35, 'AEDT', '11762985600', 39600, '1'),
(35, 'AEST', '11778710400', 36000, '0'),
(35, 'AEDT', '11794435200', 39600, '1'),
(35, 'AEST', '11810160000', 36000, '0'),
(35, 'AEDT', '11825884800', 39600, '1'),
(35, 'AEST', '11841609600', 36000, '0'),
(35, 'AEDT', '11857939200', 39600, '1'),
(35, 'AEST', '11873664000', 36000, '0'),
(35, 'AEDT', '11889388800', 39600, '1'),
(35, 'AEST', '11905113600', 36000, '0'),
(35, 'AEDT', '11920838400', 39600, '1'),
(35, 'AEST', '11936563200', 36000, '0'),
(35, 'AEDT', '11952288000', 39600, '1'),
(35, 'AEST', '11968012800', 36000, '0'),
(35, 'AEDT', '11983737600', 39600, '1'),
(35, 'AEST', '11999462400', 36000, '0'),
(35, 'AEDT', '12015187200', 39600, '1'),
(35, 'AEST', '12030912000', 36000, '0'),
(35, 'AEDT', '12047241600', 39600, '1'),
(35, 'AEST', '12062966400', 36000, '0'),
(35, 'AEDT', '12078691200', 39600, '1'),
(35, 'AEST', '12094416000', 36000, '0'),
(35, 'AEDT', '12110140800', 39600, '1'),
(35, 'AEST', '12125865600', 36000, '0'),
(35, 'AEDT', '12141590400', 39600, '1'),
(35, 'AEST', '12157315200', 36000, '0'),
(35, 'AEDT', '12173040000', 39600, '1'),
(35, 'AEST', '12188764800', 36000, '0'),
(35, 'AEDT', '12205094400', 39600, '1'),
(35, 'AEST', '12220819200', 36000, '0'),
(35, 'AEDT', '12236544000', 39600, '1'),
(35, 'AEST', '12252268800', 36000, '0'),
(35, 'AEDT', '12267993600', 39600, '1'),
(35, 'AEST', '12283718400', 36000, '0'),
(35, 'AEDT', '12299443200', 39600, '1'),
(35, 'AEST', '12315168000', 36000, '0'),
(35, 'AEDT', '12330892800', 39600, '1'),
(35, 'AEST', '12346617600', 36000, '0'),
(35, 'AEDT', '12362342400', 39600, '1'),
(35, 'AEST', '12378067200', 36000, '0'),
(35, 'AEDT', '12394396800', 39600, '1'),
(35, 'AEST', '12410121600', 36000, '0'),
(35, 'AEDT', '12425846400', 39600, '1'),
(35, 'AEST', '12441571200', 36000, '0'),
(35, 'AEDT', '12457296000', 39600, '1'),
(35, 'AEST', '12473020800', 36000, '0'),
(35, 'AEDT', '12488745600', 39600, '1'),
(35, 'AEST', '12504470400', 36000, '0'),
(35, 'AEDT', '12520195200', 39600, '1'),
(35, 'AEST', '12535920000', 36000, '0'),
(35, 'AEDT', '12551644800', 39600, '1'),
(35, 'AEST', '12567974400', 36000, '0'),
(35, 'AEDT', '12583699200', 39600, '1'),
(35, 'AEST', '12599424000', 36000, '0'),
(35, 'AEDT', '12615148800', 39600, '1'),
(35, 'AEST', '12630873600', 36000, '0'),
(35, 'AEDT', '12646598400', 39600, '1'),
(35, 'AEST', '12662323200', 36000, '0'),
(35, 'AEDT', '12678048000', 39600, '1'),
(35, 'AEST', '12693772800', 36000, '0'),
(35, 'AEDT', '12709497600', 39600, '1'),
(35, 'AEST', '12725222400', 36000, '0'),
(35, 'AEDT', '12741552000', 39600, '1'),
(35, 'AEST', '12757276800', 36000, '0'),
(35, 'AEDT', '12773001600', 39600, '1'),
(35, 'AEST', '12788726400', 36000, '0'),
(35, 'AEDT', '12804451200', 39600, '1'),
(35, 'AEST', '12820176000', 36000, '0'),
(35, 'AEDT', '12835900800', 39600, '1'),
(35, 'AEST', '12851625600', 36000, '0'),
(35, 'AEDT', '12867350400', 39600, '1'),
(35, 'AEST', '12883075200', 36000, '0'),
(35, 'AEDT', '12898800000', 39600, '1'),
(35, 'AEST', '12914524800', 36000, '0'),
(35, 'AEDT', '12930854400', 39600, '1'),
(35, 'AEST', '12946579200', 36000, '0'),
(35, 'AEDT', '12962304000', 39600, '1'),
(35, 'AEST', '12978028800', 36000, '0'),
(35, 'AEDT', '12993753600', 39600, '1'),
(35, 'AEST', '13009478400', 36000, '0'),
(35, 'AEDT', '13025203200', 39600, '1'),
(35, 'AEST', '13040928000', 36000, '0'),
(35, 'AEDT', '13056652800', 39600, '1'),
(35, 'AEST', '13072377600', 36000, '0'),
(35, 'AEDT', '13088707200', 39600, '1'),
(35, 'AEST', '13104432000', 36000, '0'),
(35, 'AEDT', '13120156800', 39600, '1'),
(35, 'AEST', '13135881600', 36000, '0'),
(35, 'AEDT', '13151606400', 39600, '1'),
(35, 'AEST', '13167331200', 36000, '0'),
(35, 'AEDT', '13183056000', 39600, '1'),
(35, 'AEST', '13198780800', 36000, '0'),
(35, 'AEDT', '13214505600', 39600, '1'),
(35, 'AEST', '13230230400', 36000, '0'),
(35, 'AEDT', '13245955200', 39600, '1'),
(35, 'AEST', '13261680000', 36000, '0'),
(35, 'AEDT', '13278009600', 39600, '1'),
(35, 'AEST', '13293734400', 36000, '0'),
(35, 'AEDT', '13309459200', 39600, '1'),
(35, 'AEST', '13325184000', 36000, '0'),
(35, 'AEDT', '13340908800', 39600, '1'),
(35, 'AEST', '13356633600', 36000, '0'),
(35, 'AEDT', '13372358400', 39600, '1'),
(35, 'AEST', '13388083200', 36000, '0'),
(35, 'AEDT', '13403808000', 39600, '1'),
(35, 'AEST', '13419532800', 36000, '0'),
(35, 'AEDT', '13435257600', 39600, '1'),
(35, 'AEST', '13451587200', 36000, '0'),
(35, 'AEDT', '13467312000', 39600, '1'),
(35, 'AEST', '13483036800', 36000, '0'),
(35, 'AEDT', '13498761600', 39600, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(35, 'AEST', '13514486400', 36000, '0'),
(35, 'AEDT', '13530211200', 39600, '1'),
(35, 'AEST', '13545936000', 36000, '0'),
(35, 'AEDT', '13561660800', 39600, '1'),
(35, 'AEST', '13577385600', 36000, '0'),
(35, 'AEDT', '13593110400', 39600, '1'),
(35, 'AEST', '13608835200', 36000, '0'),
(35, 'AEDT', '13625164800', 39600, '1'),
(35, 'AEST', '13640889600', 36000, '0'),
(35, 'AEDT', '13656614400', 39600, '1'),
(35, 'AEST', '13672339200', 36000, '0'),
(35, 'AEDT', '13688064000', 39600, '1'),
(35, 'AEST', '13703788800', 36000, '0'),
(35, 'AEDT', '13719513600', 39600, '1'),
(35, 'AEST', '13735238400', 36000, '0'),
(35, 'AEDT', '13750963200', 39600, '1'),
(35, 'AEST', '13766688000', 36000, '0'),
(35, 'AEDT', '13782412800', 39600, '1'),
(35, 'AEST', '13798137600', 36000, '0'),
(35, 'AEDT', '13814467200', 39600, '1'),
(35, 'AEST', '13830192000', 36000, '0'),
(35, 'AEDT', '13845916800', 39600, '1'),
(35, 'AEST', '13861641600', 36000, '0'),
(35, 'AEDT', '13877366400', 39600, '1'),
(35, 'AEST', '13893091200', 36000, '0'),
(35, 'AEDT', '13908816000', 39600, '1'),
(35, 'AEST', '13924540800', 36000, '0'),
(35, 'AEDT', '13940265600', 39600, '1'),
(35, 'AEST', '13955990400', 36000, '0'),
(35, 'AEDT', '13972320000', 39600, '1'),
(35, 'AEST', '13988044800', 36000, '0'),
(35, 'AEDT', '14003769600', 39600, '1'),
(35, 'AEST', '14019494400', 36000, '0'),
(35, 'AEDT', '14035219200', 39600, '1'),
(35, 'AEST', '14050944000', 36000, '0'),
(35, 'AEDT', '14066668800', 39600, '1'),
(35, 'AEST', '14082393600', 36000, '0'),
(35, 'AEDT', '14098118400', 39600, '1'),
(35, 'AEST', '14113843200', 36000, '0'),
(35, 'AEDT', '14129568000', 39600, '1'),
(35, 'AEST', '14145292800', 36000, '0'),
(35, 'AEDT', '14161622400', 39600, '1'),
(35, 'AEST', '14177347200', 36000, '0'),
(35, 'AEDT', '14193072000', 39600, '1'),
(35, 'AEST', '14208796800', 36000, '0'),
(35, 'AEDT', '14224521600', 39600, '1'),
(35, 'AEST', '14240246400', 36000, '0'),
(35, 'AEDT', '14255971200', 39600, '1'),
(35, 'AEST', '14271696000', 36000, '0'),
(35, 'AEDT', '14287420800', 39600, '1'),
(35, 'AEST', '14303145600', 36000, '0'),
(35, 'AEDT', '14318870400', 39600, '1'),
(35, 'AEST', '14335200000', 36000, '0'),
(35, 'AEDT', '14350924800', 39600, '1'),
(35, 'AEST', '14366649600', 36000, '0'),
(35, 'AEDT', '14382374400', 39600, '1'),
(35, 'AEST', '14398099200', 36000, '0'),
(35, 'AEDT', '14413824000', 39600, '1'),
(35, 'AEST', '14429548800', 36000, '0'),
(35, 'AEDT', '14445273600', 39600, '1'),
(35, 'AEST', '14460998400', 36000, '0'),
(35, 'AEDT', '14476723200', 39600, '1'),
(35, 'AEST', '14492448000', 36000, '0'),
(35, 'AEDT', '14508777600', 39600, '1'),
(35, 'AEST', '14524502400', 36000, '0'),
(35, 'AEDT', '14540227200', 39600, '1'),
(35, 'AEST', '14555952000', 36000, '0'),
(35, 'AEDT', '14571676800', 39600, '1'),
(35, 'AEST', '14587401600', 36000, '0'),
(35, 'AEDT', '14603126400', 39600, '1'),
(35, 'AEST', '14618851200', 36000, '0'),
(35, 'AEDT', '14634576000', 39600, '1'),
(35, 'AEST', '14650300800', 36000, '0'),
(35, 'AEDT', '14666025600', 39600, '1'),
(35, 'AEST', '14681750400', 36000, '0'),
(35, 'AEDT', '14698080000', 39600, '1'),
(35, 'AEST', '14713804800', 36000, '0'),
(35, 'AEDT', '14729529600', 39600, '1'),
(35, 'AEST', '14745254400', 36000, '0'),
(35, 'AEDT', '14760979200', 39600, '1'),
(35, 'AEST', '14776704000', 36000, '0'),
(35, 'AEDT', '14792428800', 39600, '1'),
(35, 'AEST', '14808153600', 36000, '0'),
(35, 'AEDT', '14823878400', 39600, '1'),
(35, 'AEST', '14839603200', 36000, '0'),
(35, 'AEDT', '14855932800', 39600, '1'),
(35, 'AEST', '14871657600', 36000, '0'),
(35, 'AEDT', '14887382400', 39600, '1'),
(35, 'AEST', '14903107200', 36000, '0'),
(35, 'AEDT', '14918832000', 39600, '1'),
(35, 'AEST', '14934556800', 36000, '0'),
(35, 'AEDT', '14950281600', 39600, '1'),
(35, 'AEST', '14966006400', 36000, '0'),
(35, 'AEDT', '14981731200', 39600, '1'),
(35, 'AEST', '14997456000', 36000, '0'),
(35, 'AEDT', '15013180800', 39600, '1'),
(35, 'AEST', '15028905600', 36000, '0'),
(35, 'AEDT', '15045235200', 39600, '1'),
(35, 'AEST', '15060960000', 36000, '0'),
(35, 'AEDT', '15076684800', 39600, '1'),
(35, 'AEST', '15092409600', 36000, '0'),
(35, 'AEDT', '15108134400', 39600, '1'),
(35, 'AEST', '15123859200', 36000, '0'),
(35, 'AEDT', '15139584000', 39600, '1'),
(35, 'AEST', '15155308800', 36000, '0'),
(35, 'AEDT', '15171033600', 39600, '1'),
(35, 'AEST', '15186758400', 36000, '0'),
(35, 'AEDT', '15202483200', 39600, '1'),
(35, 'AEST', '15218812800', 36000, '0'),
(35, 'AEDT', '15234537600', 39600, '1'),
(35, 'AEST', '15250262400', 36000, '0'),
(35, 'AEDT', '15265987200', 39600, '1'),
(35, 'AEST', '15281712000', 36000, '0'),
(35, 'AEDT', '15297436800', 39600, '1'),
(35, 'AEST', '15313161600', 36000, '0'),
(35, 'AEDT', '15328886400', 39600, '1'),
(35, 'AEST', '15344611200', 36000, '0'),
(35, 'AEDT', '15360336000', 39600, '1'),
(35, 'AEST', '15376060800', 36000, '0'),
(35, 'AEDT', '15392390400', 39600, '1'),
(35, 'AEST', '15408115200', 36000, '0'),
(35, 'AEDT', '15423840000', 39600, '1'),
(35, 'AEST', '15439564800', 36000, '0'),
(35, 'AEDT', '15455289600', 39600, '1'),
(35, 'AEST', '15471014400', 36000, '0'),
(35, 'AEDT', '15486739200', 39600, '1'),
(35, 'AEST', '15502464000', 36000, '0'),
(35, 'AEDT', '15518188800', 39600, '1'),
(35, 'AEST', '15533913600', 36000, '0'),
(35, 'AEDT', '15549638400', 39600, '1'),
(35, 'AEST', '15565363200', 36000, '0'),
(35, 'AEDT', '15581692800', 39600, '1'),
(35, 'AEST', '15597417600', 36000, '0'),
(35, 'AEDT', '15613142400', 39600, '1'),
(35, 'AEST', '15628867200', 36000, '0'),
(35, 'AEDT', '15644592000', 39600, '1'),
(35, 'AEST', '15660316800', 36000, '0'),
(35, 'AEDT', '15676041600', 39600, '1'),
(35, 'AEST', '15691766400', 36000, '0'),
(35, 'AEDT', '15707491200', 39600, '1'),
(35, 'AEST', '15723216000', 36000, '0'),
(35, 'AEDT', '15739545600', 39600, '1'),
(35, 'AEST', '15755270400', 36000, '0'),
(35, 'AEDT', '15770995200', 39600, '1'),
(35, 'AEST', '15786720000', 36000, '0'),
(35, 'AEDT', '15802444800', 39600, '1'),
(35, 'AEST', '15818169600', 36000, '0'),
(35, 'AEDT', '15833894400', 39600, '1'),
(35, 'AEST', '15849619200', 36000, '0'),
(35, 'AEDT', '15865344000', 39600, '1'),
(35, 'AEST', '15881068800', 36000, '0'),
(35, 'AEDT', '15896793600', 39600, '1'),
(35, 'AEST', '15912518400', 36000, '0'),
(35, 'AEDT', '15928848000', 39600, '1'),
(35, 'AEST', '15944572800', 36000, '0'),
(35, 'AEDT', '15960297600', 39600, '1'),
(35, 'AEST', '15976022400', 36000, '0'),
(35, 'AEDT', '15991747200', 39600, '1'),
(35, 'AEST', '16007472000', 36000, '0'),
(35, 'AEDT', '16023196800', 39600, '1'),
(35, 'AEST', '16038921600', 36000, '0'),
(35, 'AEDT', '16054646400', 39600, '1'),
(35, 'AEST', '16070371200', 36000, '0'),
(35, 'AEDT', '16086096000', 39600, '1'),
(35, 'AEST', '16102425600', 36000, '0'),
(35, 'AEDT', '16118150400', 39600, '1'),
(35, 'AEST', '16133875200', 36000, '0'),
(35, 'AEDT', '16149600000', 39600, '1'),
(35, 'AEST', '16165324800', 36000, '0'),
(35, 'AEDT', '16181049600', 39600, '1'),
(35, 'AEST', '16196774400', 36000, '0'),
(35, 'AEDT', '16212499200', 39600, '1'),
(35, 'AEST', '16228224000', 36000, '0'),
(35, 'AEDT', '16243948800', 39600, '1'),
(35, 'AEST', '16259673600', 36000, '0'),
(35, 'AEDT', '16276003200', 39600, '1'),
(35, 'AEST', '16291728000', 36000, '0'),
(35, 'AEDT', '16307452800', 39600, '1'),
(35, 'AEST', '16323177600', 36000, '0'),
(35, 'AEDT', '16338902400', 39600, '1'),
(35, 'AEST', '16354627200', 36000, '0'),
(35, 'AEDT', '16370352000', 39600, '1'),
(35, 'AEST', '16386076800', 36000, '0'),
(35, 'AEDT', '16401801600', 39600, '1'),
(35, 'AEST', '16417526400', 36000, '0'),
(35, 'AEDT', '16433251200', 39600, '1'),
(35, 'AEST', '16448976000', 36000, '0'),
(35, 'AEDT', '16465305600', 39600, '1'),
(35, 'AEST', '16481030400', 36000, '0'),
(35, 'AEDT', '16496755200', 39600, '1'),
(35, 'AEST', '16512480000', 36000, '0'),
(35, 'AEDT', '16528204800', 39600, '1'),
(35, 'AEST', '16543929600', 36000, '0'),
(35, 'AEDT', '16559654400', 39600, '1'),
(35, 'AEST', '16575379200', 36000, '0'),
(35, 'AEDT', '16591104000', 39600, '1'),
(35, 'AEST', '16606828800', 36000, '0'),
(35, 'AEDT', '16623158400', 39600, '1'),
(35, 'AEST', '16638883200', 36000, '0'),
(35, 'AEDT', '16654608000', 39600, '1'),
(35, 'AEST', '16670332800', 36000, '0'),
(35, 'AEDT', '16686057600', 39600, '1'),
(35, 'AEST', '16701782400', 36000, '0'),
(35, 'AEDT', '16717507200', 39600, '1'),
(36, 'LMT', '-2345794529', 34528, '0'),
(36, 'AEST', '-2345794528', 36000, '0'),
(36, 'AEDT', '-1680508800', 39600, '1'),
(36, 'AEST', '-1665392400', 36000, '0'),
(36, 'AEDT', '-883641600', 39600, '1'),
(36, 'AEST', '-876128400', 36000, '0'),
(36, 'AEDT', '-860400000', 39600, '1'),
(36, 'AEST', '-844678800', 36000, '0'),
(36, 'AEDT', '-828345600', 39600, '1'),
(36, 'AEST', '-813229200', 36000, '0'),
(36, 'AEDT', '57686400', 39600, '1'),
(36, 'AEST', '67968000', 36000, '0'),
(36, 'AEDT', '89136000', 39600, '1'),
(36, 'AEST', '100022400', 36000, '0'),
(36, 'AEDT', '120585600', 39600, '1'),
(36, 'AEST', '131472000', 36000, '0'),
(36, 'AEDT', '152035200', 39600, '1'),
(36, 'AEST', '162921600', 36000, '0'),
(36, 'AEDT', '183484800', 39600, '1'),
(36, 'AEST', '194976000', 36000, '0'),
(36, 'AEDT', '215539200', 39600, '1'),
(36, 'AEST', '226425600', 36000, '0'),
(36, 'AEDT', '246988800', 39600, '1'),
(36, 'AEST', '257875200', 36000, '0'),
(36, 'AEDT', '278438400', 39600, '1'),
(36, 'AEST', '289324800', 36000, '0'),
(36, 'AEDT', '309888000', 39600, '1'),
(36, 'AEST', '320774400', 36000, '0'),
(36, 'AEDT', '341337600', 39600, '1'),
(36, 'AEST', '352224000', 36000, '0'),
(36, 'AEDT', '372787200', 39600, '1'),
(36, 'AEST', '386092800', 36000, '0'),
(36, 'AEDT', '404841600', 39600, '1'),
(36, 'AEST', '417542400', 36000, '0'),
(36, 'AEDT', '436291200', 39600, '1'),
(36, 'AEST', '447177600', 36000, '0'),
(36, 'AEDT', '467740800', 39600, '1'),
(36, 'AEST', '478627200', 36000, '0'),
(36, 'AEDT', '499190400', 39600, '1'),
(36, 'AEST', '510076800', 36000, '0'),
(36, 'AEDT', '530035200', 39600, '1'),
(36, 'AEST', '542736000', 36000, '0'),
(36, 'AEDT', '562089600', 39600, '1'),
(36, 'AEST', '574790400', 36000, '0'),
(36, 'AEDT', '594144000', 39600, '1'),
(36, 'AEST', '606240000', 36000, '0'),
(36, 'AEDT', '625593600', 39600, '1'),
(36, 'AEST', '637689600', 36000, '0'),
(36, 'AEDT', '657043200', 39600, '1'),
(36, 'AEST', '670348800', 36000, '0'),
(36, 'AEDT', '686678400', 39600, '1'),
(36, 'AEST', '701798400', 36000, '0'),
(36, 'AEDT', '718128000', 39600, '1'),
(36, 'AEST', '733248000', 36000, '0'),
(36, 'AEDT', '749577600', 39600, '1'),
(36, 'AEST', '764697600', 36000, '0'),
(36, 'AEDT', '781027200', 39600, '1'),
(36, 'AEST', '796147200', 36000, '0'),
(36, 'AEDT', '812476800', 39600, '1'),
(36, 'AEST', '828201600', 36000, '0'),
(36, 'AEDT', '844531200', 39600, '1'),
(36, 'AEST', '859651200', 36000, '0'),
(36, 'AEDT', '875980800', 39600, '1'),
(36, 'AEST', '891100800', 36000, '0'),
(36, 'AEDT', '907430400', 39600, '1'),
(36, 'AEST', '922550400', 36000, '0'),
(36, 'AEDT', '938880000', 39600, '1'),
(36, 'AEST', '954000000', 36000, '0'),
(36, 'AEDT', '967305600', 39600, '1'),
(36, 'AEST', '985449600', 36000, '0'),
(36, 'AEDT', '1002384000', 39600, '1'),
(36, 'AEST', '1017504000', 36000, '0'),
(36, 'AEDT', '1033833600', 39600, '1'),
(36, 'AEST', '1048953600', 36000, '0'),
(36, 'AEDT', '1065283200', 39600, '1'),
(36, 'AEST', '1080403200', 36000, '0'),
(36, 'AEDT', '1096732800', 39600, '1'),
(36, 'AEST', '1111852800', 36000, '0'),
(36, 'AEDT', '1128182400', 39600, '1'),
(36, 'AEST', '1143907200', 36000, '0'),
(36, 'AEDT', '1159632000', 39600, '1'),
(36, 'AEST', '1174752000', 36000, '0'),
(36, 'AEDT', '1191686400', 39600, '1'),
(36, 'AEST', '1207411200', 36000, '0'),
(36, 'AEDT', '1223136000', 39600, '1'),
(36, 'AEST', '1238860800', 36000, '0'),
(36, 'AEDT', '1254585600', 39600, '1'),
(36, 'AEST', '1270310400', 36000, '0'),
(36, 'AEDT', '1286035200', 39600, '1'),
(36, 'AEST', '1301760000', 36000, '0'),
(36, 'AEDT', '1317484800', 39600, '1'),
(36, 'AEST', '1333209600', 36000, '0'),
(36, 'AEDT', '1349539200', 39600, '1'),
(36, 'AEST', '1365264000', 36000, '0'),
(36, 'AEDT', '1380988800', 39600, '1'),
(36, 'AEST', '1396713600', 36000, '0'),
(36, 'AEDT', '1412438400', 39600, '1'),
(36, 'AEST', '1428163200', 36000, '0'),
(36, 'AEDT', '1443888000', 39600, '1'),
(36, 'AEST', '1459612800', 36000, '0'),
(36, 'AEDT', '1475337600', 39600, '1'),
(36, 'AEST', '1491062400', 36000, '0'),
(36, 'AEDT', '1506787200', 39600, '1'),
(36, 'AEST', '1522512000', 36000, '0'),
(36, 'AEDT', '1538841600', 39600, '1'),
(36, 'AEST', '1554566400', 36000, '0'),
(36, 'AEDT', '1570291200', 39600, '1'),
(36, 'AEST', '1586016000', 36000, '0'),
(36, 'AEDT', '1601740800', 39600, '1'),
(36, 'AEST', '1617465600', 36000, '0'),
(36, 'AEDT', '1633190400', 39600, '1'),
(36, 'AEST', '1648915200', 36000, '0'),
(36, 'AEDT', '1664640000', 39600, '1'),
(36, 'AEST', '1680364800', 36000, '0'),
(36, 'AEDT', '1696089600', 39600, '1'),
(36, 'AEST', '1712419200', 36000, '0'),
(36, 'AEDT', '1728144000', 39600, '1'),
(36, 'AEST', '1743868800', 36000, '0'),
(36, 'AEDT', '1759593600', 39600, '1'),
(36, 'AEST', '1775318400', 36000, '0'),
(36, 'AEDT', '1791043200', 39600, '1'),
(36, 'AEST', '1806768000', 36000, '0'),
(36, 'AEDT', '1822492800', 39600, '1'),
(36, 'AEST', '1838217600', 36000, '0'),
(36, 'AEDT', '1853942400', 39600, '1'),
(36, 'AEST', '1869667200', 36000, '0'),
(36, 'AEDT', '1885996800', 39600, '1'),
(36, 'AEST', '1901721600', 36000, '0'),
(36, 'AEDT', '1917446400', 39600, '1'),
(36, 'AEST', '1933171200', 36000, '0'),
(36, 'AEDT', '1948896000', 39600, '1'),
(36, 'AEST', '1964620800', 36000, '0'),
(36, 'AEDT', '1980345600', 39600, '1'),
(36, 'AEST', '1996070400', 36000, '0'),
(36, 'AEDT', '2011795200', 39600, '1'),
(36, 'AEST', '2027520000', 36000, '0'),
(36, 'AEDT', '2043244800', 39600, '1'),
(36, 'AEST', '2058969600', 36000, '0'),
(36, 'AEDT', '2075299200', 39600, '1'),
(36, 'AEST', '2091024000', 36000, '0'),
(36, 'AEDT', '2106748800', 39600, '1'),
(36, 'AEST', '2122473600', 36000, '0'),
(36, 'AEDT', '2138198400', 39600, '1'),
(36, 'AEST', '2153923200', 36000, '0'),
(36, 'AEDT', '2169648000', 39600, '1'),
(36, 'AEST', '2185372800', 36000, '0'),
(36, 'AEDT', '2201097600', 39600, '1'),
(36, 'AEST', '2216822400', 36000, '0'),
(36, 'AEDT', '2233152000', 39600, '1'),
(36, 'AEST', '2248876800', 36000, '0'),
(36, 'AEDT', '2264601600', 39600, '1'),
(36, 'AEST', '2280326400', 36000, '0'),
(36, 'AEDT', '2296051200', 39600, '1'),
(36, 'AEST', '2311776000', 36000, '0'),
(36, 'AEDT', '2327500800', 39600, '1'),
(36, 'AEST', '2343225600', 36000, '0'),
(36, 'AEDT', '2358950400', 39600, '1'),
(36, 'AEST', '2374675200', 36000, '0'),
(36, 'AEDT', '2390400000', 39600, '1'),
(36, 'AEST', '2406124800', 36000, '0'),
(36, 'AEDT', '2422454400', 39600, '1'),
(36, 'AEST', '2438179200', 36000, '0'),
(36, 'AEDT', '2453904000', 39600, '1'),
(36, 'AEST', '2469628800', 36000, '0'),
(36, 'AEDT', '2485353600', 39600, '1'),
(36, 'AEST', '2501078400', 36000, '0'),
(36, 'AEDT', '2516803200', 39600, '1'),
(36, 'AEST', '2532528000', 36000, '0'),
(36, 'AEDT', '2548252800', 39600, '1'),
(36, 'AEST', '2563977600', 36000, '0'),
(36, 'AEDT', '2579702400', 39600, '1'),
(36, 'AEST', '2596032000', 36000, '0'),
(36, 'AEDT', '2611756800', 39600, '1'),
(36, 'AEST', '2627481600', 36000, '0'),
(36, 'AEDT', '2643206400', 39600, '1'),
(36, 'AEST', '2658931200', 36000, '0'),
(36, 'AEDT', '2674656000', 39600, '1'),
(36, 'AEST', '2690380800', 36000, '0'),
(36, 'AEDT', '2706105600', 39600, '1'),
(36, 'AEST', '2721830400', 36000, '0'),
(36, 'AEDT', '2737555200', 39600, '1'),
(36, 'AEST', '2753280000', 36000, '0'),
(36, 'AEDT', '2769609600', 39600, '1'),
(36, 'AEST', '2785334400', 36000, '0'),
(36, 'AEDT', '2801059200', 39600, '1'),
(36, 'AEST', '2816784000', 36000, '0'),
(36, 'AEDT', '2832508800', 39600, '1'),
(36, 'AEST', '2848233600', 36000, '0'),
(36, 'AEDT', '2863958400', 39600, '1'),
(36, 'AEST', '2879683200', 36000, '0'),
(36, 'AEDT', '2895408000', 39600, '1'),
(36, 'AEST', '2911132800', 36000, '0'),
(36, 'AEDT', '2926857600', 39600, '1'),
(36, 'AEST', '2942582400', 36000, '0'),
(36, 'AEDT', '2958912000', 39600, '1'),
(36, 'AEST', '2974636800', 36000, '0'),
(36, 'AEDT', '2990361600', 39600, '1'),
(36, 'AEST', '3006086400', 36000, '0'),
(36, 'AEDT', '3021811200', 39600, '1'),
(36, 'AEST', '3037536000', 36000, '0'),
(36, 'AEDT', '3053260800', 39600, '1'),
(36, 'AEST', '3068985600', 36000, '0'),
(36, 'AEDT', '3084710400', 39600, '1'),
(36, 'AEST', '3100435200', 36000, '0'),
(36, 'AEDT', '3116764800', 39600, '1'),
(36, 'AEST', '3132489600', 36000, '0'),
(36, 'AEDT', '3148214400', 39600, '1'),
(36, 'AEST', '3163939200', 36000, '0'),
(36, 'AEDT', '3179664000', 39600, '1'),
(36, 'AEST', '3195388800', 36000, '0'),
(36, 'AEDT', '3211113600', 39600, '1'),
(36, 'AEST', '3226838400', 36000, '0'),
(36, 'AEDT', '3242563200', 39600, '1'),
(36, 'AEST', '3258288000', 36000, '0'),
(36, 'AEDT', '3274012800', 39600, '1'),
(36, 'AEST', '3289737600', 36000, '0'),
(36, 'AEDT', '3306067200', 39600, '1'),
(36, 'AEST', '3321792000', 36000, '0'),
(36, 'AEDT', '3337516800', 39600, '1'),
(36, 'AEST', '3353241600', 36000, '0'),
(36, 'AEDT', '3368966400', 39600, '1'),
(36, 'AEST', '3384691200', 36000, '0'),
(36, 'AEDT', '3400416000', 39600, '1'),
(36, 'AEST', '3416140800', 36000, '0'),
(36, 'AEDT', '3431865600', 39600, '1'),
(36, 'AEST', '3447590400', 36000, '0'),
(36, 'AEDT', '3463315200', 39600, '1'),
(36, 'AEST', '3479644800', 36000, '0'),
(36, 'AEDT', '3495369600', 39600, '1'),
(36, 'AEST', '3511094400', 36000, '0'),
(36, 'AEDT', '3526819200', 39600, '1'),
(36, 'AEST', '3542544000', 36000, '0'),
(36, 'AEDT', '3558268800', 39600, '1'),
(36, 'AEST', '3573993600', 36000, '0'),
(36, 'AEDT', '3589718400', 39600, '1'),
(36, 'AEST', '3605443200', 36000, '0'),
(36, 'AEDT', '3621168000', 39600, '1'),
(36, 'AEST', '3636892800', 36000, '0'),
(36, 'AEDT', '3653222400', 39600, '1'),
(36, 'AEST', '3668947200', 36000, '0'),
(36, 'AEDT', '3684672000', 39600, '1'),
(36, 'AEST', '3700396800', 36000, '0'),
(36, 'AEDT', '3716121600', 39600, '1'),
(36, 'AEST', '3731846400', 36000, '0'),
(36, 'AEDT', '3747571200', 39600, '1'),
(36, 'AEST', '3763296000', 36000, '0'),
(36, 'AEDT', '3779020800', 39600, '1'),
(36, 'AEST', '3794745600', 36000, '0'),
(36, 'AEDT', '3810470400', 39600, '1'),
(36, 'AEST', '3826195200', 36000, '0'),
(36, 'AEDT', '3842524800', 39600, '1'),
(36, 'AEST', '3858249600', 36000, '0'),
(36, 'AEDT', '3873974400', 39600, '1'),
(36, 'AEST', '3889699200', 36000, '0'),
(36, 'AEDT', '3905424000', 39600, '1'),
(36, 'AEST', '3921148800', 36000, '0'),
(36, 'AEDT', '3936873600', 39600, '1'),
(36, 'AEST', '3952598400', 36000, '0'),
(36, 'AEDT', '3968323200', 39600, '1'),
(36, 'AEST', '3984048000', 36000, '0'),
(36, 'AEDT', '4000377600', 39600, '1'),
(36, 'AEST', '4016102400', 36000, '0'),
(36, 'AEDT', '4031827200', 39600, '1'),
(36, 'AEST', '4047552000', 36000, '0'),
(36, 'AEDT', '4063276800', 39600, '1'),
(36, 'AEST', '4079001600', 36000, '0'),
(36, 'AEDT', '4094726400', 39600, '1'),
(36, 'AEST', '4110451200', 36000, '0'),
(36, 'AEDT', '4126176000', 39600, '1'),
(36, 'AEST', '4141900800', 36000, '0'),
(36, 'AEDT', '4157625600', 39600, '1'),
(36, 'AEST', '4173350400', 36000, '0'),
(36, 'AEDT', '4189075200', 39600, '1'),
(36, 'AEST', '4204800000', 36000, '0'),
(36, 'AEDT', '4221129600', 39600, '1'),
(36, 'AEST', '4236854400', 36000, '0'),
(36, 'AEDT', '4252579200', 39600, '1'),
(36, 'AEST', '4268304000', 36000, '0'),
(36, 'AEDT', '4284028800', 39600, '1'),
(36, 'AEST', '4299753600', 36000, '0'),
(36, 'AEDT', '4315478400', 39600, '1'),
(36, 'AEST', '4331203200', 36000, '0'),
(36, 'AEDT', '4346928000', 39600, '1'),
(36, 'AEST', '4362652800', 36000, '0'),
(36, 'AEDT', '4378982400', 39600, '1'),
(36, 'AEST', '4394707200', 36000, '0'),
(36, 'AEDT', '4410432000', 39600, '1'),
(36, 'AEST', '4426156800', 36000, '0'),
(36, 'AEDT', '4441881600', 39600, '1'),
(36, 'AEST', '4457606400', 36000, '0'),
(36, 'AEDT', '4473331200', 39600, '1'),
(36, 'AEST', '4489056000', 36000, '0'),
(36, 'AEDT', '4504780800', 39600, '1'),
(36, 'AEST', '4520505600', 36000, '0'),
(36, 'AEDT', '4536230400', 39600, '1'),
(36, 'AEST', '4551955200', 36000, '0'),
(36, 'AEDT', '4568284800', 39600, '1'),
(36, 'AEST', '4584009600', 36000, '0'),
(36, 'AEDT', '4599734400', 39600, '1'),
(36, 'AEST', '4615459200', 36000, '0'),
(36, 'AEDT', '4631184000', 39600, '1'),
(36, 'AEST', '4646908800', 36000, '0'),
(36, 'AEDT', '4662633600', 39600, '1'),
(36, 'AEST', '4678358400', 36000, '0'),
(36, 'AEDT', '4694083200', 39600, '1'),
(36, 'AEST', '4709808000', 36000, '0'),
(36, 'AEDT', '4725532800', 39600, '1'),
(36, 'AEST', '4741862400', 36000, '0'),
(36, 'AEDT', '4757587200', 39600, '1'),
(36, 'AEST', '4773312000', 36000, '0'),
(36, 'AEDT', '4789036800', 39600, '1'),
(36, 'AEST', '4804761600', 36000, '0'),
(36, 'AEDT', '4820486400', 39600, '1'),
(36, 'AEST', '4836211200', 36000, '0'),
(36, 'AEDT', '4851936000', 39600, '1'),
(36, 'AEST', '4867660800', 36000, '0'),
(36, 'AEDT', '4883385600', 39600, '1'),
(36, 'AEST', '4899110400', 36000, '0'),
(36, 'AEDT', '4915440000', 39600, '1'),
(36, 'AEST', '4931164800', 36000, '0'),
(36, 'AEDT', '4946889600', 39600, '1'),
(36, 'AEST', '4962614400', 36000, '0'),
(36, 'AEDT', '4978339200', 39600, '1'),
(36, 'AEST', '4994064000', 36000, '0'),
(36, 'AEDT', '5009788800', 39600, '1'),
(36, 'AEST', '5025513600', 36000, '0'),
(36, 'AEDT', '5041238400', 39600, '1'),
(36, 'AEST', '5056963200', 36000, '0'),
(36, 'AEDT', '5072688000', 39600, '1'),
(36, 'AEST', '5088412800', 36000, '0'),
(36, 'AEDT', '5104742400', 39600, '1'),
(36, 'AEST', '5120467200', 36000, '0'),
(36, 'AEDT', '5136192000', 39600, '1'),
(36, 'AEST', '5151916800', 36000, '0'),
(36, 'AEDT', '5167641600', 39600, '1'),
(36, 'AEST', '5183366400', 36000, '0'),
(36, 'AEDT', '5199091200', 39600, '1'),
(36, 'AEST', '5214816000', 36000, '0'),
(36, 'AEDT', '5230540800', 39600, '1'),
(36, 'AEST', '5246265600', 36000, '0'),
(36, 'AEDT', '5262595200', 39600, '1'),
(36, 'AEST', '5278320000', 36000, '0'),
(36, 'AEDT', '5294044800', 39600, '1'),
(36, 'AEST', '5309769600', 36000, '0'),
(36, 'AEDT', '5325494400', 39600, '1'),
(36, 'AEST', '5341219200', 36000, '0'),
(36, 'AEDT', '5356944000', 39600, '1'),
(36, 'AEST', '5372668800', 36000, '0'),
(36, 'AEDT', '5388393600', 39600, '1'),
(36, 'AEST', '5404118400', 36000, '0'),
(36, 'AEDT', '5419843200', 39600, '1'),
(36, 'AEST', '5435568000', 36000, '0'),
(36, 'AEDT', '5451897600', 39600, '1'),
(36, 'AEST', '5467622400', 36000, '0'),
(36, 'AEDT', '5483347200', 39600, '1'),
(36, 'AEST', '5499072000', 36000, '0'),
(36, 'AEDT', '5514796800', 39600, '1'),
(36, 'AEST', '5530521600', 36000, '0'),
(36, 'AEDT', '5546246400', 39600, '1'),
(36, 'AEST', '5561971200', 36000, '0'),
(36, 'AEDT', '5577696000', 39600, '1'),
(36, 'AEST', '5593420800', 36000, '0'),
(36, 'AEDT', '5609145600', 39600, '1'),
(36, 'AEST', '5625475200', 36000, '0'),
(36, 'AEDT', '5641200000', 39600, '1'),
(36, 'AEST', '5656924800', 36000, '0'),
(36, 'AEDT', '5672649600', 39600, '1'),
(36, 'AEST', '5688374400', 36000, '0'),
(36, 'AEDT', '5704099200', 39600, '1'),
(36, 'AEST', '5719824000', 36000, '0'),
(36, 'AEDT', '5735548800', 39600, '1'),
(36, 'AEST', '5751273600', 36000, '0'),
(36, 'AEDT', '5766998400', 39600, '1'),
(36, 'AEST', '5782723200', 36000, '0'),
(36, 'AEDT', '5799052800', 39600, '1'),
(36, 'AEST', '5814777600', 36000, '0'),
(36, 'AEDT', '5830502400', 39600, '1'),
(36, 'AEST', '5846227200', 36000, '0'),
(36, 'AEDT', '5861952000', 39600, '1'),
(36, 'AEST', '5877676800', 36000, '0'),
(36, 'AEDT', '5893401600', 39600, '1'),
(36, 'AEST', '5909126400', 36000, '0'),
(36, 'AEDT', '5924851200', 39600, '1'),
(36, 'AEST', '5940576000', 36000, '0'),
(36, 'AEDT', '5956300800', 39600, '1'),
(36, 'AEST', '5972025600', 36000, '0'),
(36, 'AEDT', '5988355200', 39600, '1'),
(36, 'AEST', '6004080000', 36000, '0'),
(36, 'AEDT', '6019804800', 39600, '1'),
(36, 'AEST', '6035529600', 36000, '0'),
(36, 'AEDT', '6051254400', 39600, '1'),
(36, 'AEST', '6066979200', 36000, '0'),
(36, 'AEDT', '6082704000', 39600, '1'),
(36, 'AEST', '6098428800', 36000, '0'),
(36, 'AEDT', '6114153600', 39600, '1'),
(36, 'AEST', '6129878400', 36000, '0'),
(36, 'AEDT', '6146208000', 39600, '1'),
(36, 'AEST', '6161932800', 36000, '0'),
(36, 'AEDT', '6177657600', 39600, '1'),
(36, 'AEST', '6193382400', 36000, '0'),
(36, 'AEDT', '6209107200', 39600, '1'),
(36, 'AEST', '6224832000', 36000, '0'),
(36, 'AEDT', '6240556800', 39600, '1'),
(36, 'AEST', '6256281600', 36000, '0'),
(36, 'AEDT', '6272006400', 39600, '1'),
(36, 'AEST', '6287731200', 36000, '0'),
(36, 'AEDT', '6303456000', 39600, '1'),
(36, 'AEST', '6319180800', 36000, '0'),
(36, 'AEDT', '6335510400', 39600, '1'),
(36, 'AEST', '6351235200', 36000, '0'),
(36, 'AEDT', '6366960000', 39600, '1'),
(36, 'AEST', '6382684800', 36000, '0'),
(36, 'AEDT', '6398409600', 39600, '1'),
(36, 'AEST', '6414134400', 36000, '0'),
(36, 'AEDT', '6429859200', 39600, '1'),
(36, 'AEST', '6445584000', 36000, '0'),
(36, 'AEDT', '6461308800', 39600, '1'),
(36, 'AEST', '6477033600', 36000, '0'),
(36, 'AEDT', '6492758400', 39600, '1'),
(36, 'AEST', '6509088000', 36000, '0'),
(36, 'AEDT', '6524812800', 39600, '1'),
(36, 'AEST', '6540537600', 36000, '0'),
(36, 'AEDT', '6556262400', 39600, '1'),
(36, 'AEST', '6571987200', 36000, '0'),
(36, 'AEDT', '6587712000', 39600, '1'),
(36, 'AEST', '6603436800', 36000, '0'),
(36, 'AEDT', '6619161600', 39600, '1'),
(36, 'AEST', '6634886400', 36000, '0'),
(36, 'AEDT', '6650611200', 39600, '1'),
(36, 'AEST', '6666336000', 36000, '0'),
(36, 'AEDT', '6682665600', 39600, '1'),
(36, 'AEST', '6698390400', 36000, '0'),
(36, 'AEDT', '6714115200', 39600, '1'),
(36, 'AEST', '6729840000', 36000, '0'),
(36, 'AEDT', '6745564800', 39600, '1'),
(36, 'AEST', '6761289600', 36000, '0'),
(36, 'AEDT', '6777014400', 39600, '1'),
(36, 'AEST', '6792739200', 36000, '0'),
(36, 'AEDT', '6808464000', 39600, '1'),
(36, 'AEST', '6824188800', 36000, '0'),
(36, 'AEDT', '6839913600', 39600, '1'),
(36, 'AEST', '6855638400', 36000, '0'),
(36, 'AEDT', '6871968000', 39600, '1'),
(36, 'AEST', '6887692800', 36000, '0'),
(36, 'AEDT', '6903417600', 39600, '1'),
(36, 'AEST', '6919142400', 36000, '0'),
(36, 'AEDT', '6934867200', 39600, '1'),
(36, 'AEST', '6950592000', 36000, '0'),
(36, 'AEDT', '6966316800', 39600, '1'),
(36, 'AEST', '6982041600', 36000, '0'),
(36, 'AEDT', '6997766400', 39600, '1'),
(36, 'AEST', '7013491200', 36000, '0'),
(36, 'AEDT', '7029820800', 39600, '1'),
(36, 'AEST', '7045545600', 36000, '0'),
(36, 'AEDT', '7061270400', 39600, '1'),
(36, 'AEST', '7076995200', 36000, '0'),
(36, 'AEDT', '7092720000', 39600, '1'),
(36, 'AEST', '7108444800', 36000, '0'),
(36, 'AEDT', '7124169600', 39600, '1'),
(36, 'AEST', '7139894400', 36000, '0'),
(36, 'AEDT', '7155619200', 39600, '1'),
(36, 'AEST', '7171344000', 36000, '0'),
(36, 'AEDT', '7187068800', 39600, '1'),
(36, 'AEST', '7202793600', 36000, '0'),
(36, 'AEDT', '7219123200', 39600, '1'),
(36, 'AEST', '7234848000', 36000, '0'),
(36, 'AEDT', '7250572800', 39600, '1'),
(36, 'AEST', '7266297600', 36000, '0'),
(36, 'AEDT', '7282022400', 39600, '1'),
(36, 'AEST', '7297747200', 36000, '0'),
(36, 'AEDT', '7313472000', 39600, '1'),
(36, 'AEST', '7329196800', 36000, '0'),
(36, 'AEDT', '7344921600', 39600, '1'),
(36, 'AEST', '7360646400', 36000, '0'),
(36, 'AEDT', '7376371200', 39600, '1'),
(36, 'AEST', '7392096000', 36000, '0'),
(36, 'AEDT', '7408425600', 39600, '1'),
(36, 'AEST', '7424150400', 36000, '0'),
(36, 'AEDT', '7439875200', 39600, '1'),
(36, 'AEST', '7455600000', 36000, '0'),
(36, 'AEDT', '7471324800', 39600, '1'),
(36, 'AEST', '7487049600', 36000, '0'),
(36, 'AEDT', '7502774400', 39600, '1'),
(36, 'AEST', '7518499200', 36000, '0'),
(36, 'AEDT', '7534224000', 39600, '1'),
(36, 'AEST', '7549948800', 36000, '0'),
(36, 'AEDT', '7565673600', 39600, '1'),
(36, 'AEST', '7581398400', 36000, '0'),
(36, 'AEDT', '7597728000', 39600, '1'),
(36, 'AEST', '7613452800', 36000, '0'),
(36, 'AEDT', '7629177600', 39600, '1'),
(36, 'AEST', '7644902400', 36000, '0'),
(36, 'AEDT', '7660627200', 39600, '1'),
(36, 'AEST', '7676352000', 36000, '0'),
(36, 'AEDT', '7692076800', 39600, '1'),
(36, 'AEST', '7707801600', 36000, '0'),
(36, 'AEDT', '7723526400', 39600, '1'),
(36, 'AEST', '7739251200', 36000, '0'),
(36, 'AEDT', '7754976000', 39600, '1'),
(36, 'AEST', '7771305600', 36000, '0'),
(36, 'AEDT', '7787030400', 39600, '1'),
(36, 'AEST', '7802755200', 36000, '0'),
(36, 'AEDT', '7818480000', 39600, '1'),
(36, 'AEST', '7834204800', 36000, '0'),
(36, 'AEDT', '7849929600', 39600, '1'),
(36, 'AEST', '7865654400', 36000, '0'),
(36, 'AEDT', '7881379200', 39600, '1'),
(36, 'AEST', '7897104000', 36000, '0'),
(36, 'AEDT', '7912828800', 39600, '1'),
(36, 'AEST', '7928553600', 36000, '0'),
(36, 'AEDT', '7944883200', 39600, '1'),
(36, 'AEST', '7960608000', 36000, '0'),
(36, 'AEDT', '7976332800', 39600, '1'),
(36, 'AEST', '7992057600', 36000, '0'),
(36, 'AEDT', '8007782400', 39600, '1'),
(36, 'AEST', '8023507200', 36000, '0'),
(36, 'AEDT', '8039232000', 39600, '1'),
(36, 'AEST', '8054956800', 36000, '0'),
(36, 'AEDT', '8070681600', 39600, '1'),
(36, 'AEST', '8086406400', 36000, '0'),
(36, 'AEDT', '8102131200', 39600, '1'),
(36, 'AEST', '8117856000', 36000, '0'),
(36, 'AEDT', '8134185600', 39600, '1'),
(36, 'AEST', '8149910400', 36000, '0'),
(36, 'AEDT', '8165635200', 39600, '1'),
(36, 'AEST', '8181360000', 36000, '0'),
(36, 'AEDT', '8197084800', 39600, '1'),
(36, 'AEST', '8212809600', 36000, '0'),
(36, 'AEDT', '8228534400', 39600, '1'),
(36, 'AEST', '8244259200', 36000, '0'),
(36, 'AEDT', '8259984000', 39600, '1'),
(36, 'AEST', '8275708800', 36000, '0'),
(36, 'AEDT', '8292038400', 39600, '1'),
(36, 'AEST', '8307763200', 36000, '0'),
(36, 'AEDT', '8323488000', 39600, '1'),
(36, 'AEST', '8339212800', 36000, '0'),
(36, 'AEDT', '8354937600', 39600, '1'),
(36, 'AEST', '8370662400', 36000, '0'),
(36, 'AEDT', '8386387200', 39600, '1'),
(36, 'AEST', '8402112000', 36000, '0'),
(36, 'AEDT', '8417836800', 39600, '1'),
(36, 'AEST', '8433561600', 36000, '0'),
(36, 'AEDT', '8449286400', 39600, '1'),
(36, 'AEST', '8465011200', 36000, '0'),
(36, 'AEDT', '8481340800', 39600, '1'),
(36, 'AEST', '8497065600', 36000, '0'),
(36, 'AEDT', '8512790400', 39600, '1'),
(36, 'AEST', '8528515200', 36000, '0'),
(36, 'AEDT', '8544240000', 39600, '1'),
(36, 'AEST', '8559964800', 36000, '0'),
(36, 'AEDT', '8575689600', 39600, '1'),
(36, 'AEST', '8591414400', 36000, '0'),
(36, 'AEDT', '8607139200', 39600, '1'),
(36, 'AEST', '8622864000', 36000, '0'),
(36, 'AEDT', '8638588800', 39600, '1'),
(36, 'AEST', '8654918400', 36000, '0'),
(36, 'AEDT', '8670643200', 39600, '1'),
(36, 'AEST', '8686368000', 36000, '0'),
(36, 'AEDT', '8702092800', 39600, '1'),
(36, 'AEST', '8717817600', 36000, '0'),
(36, 'AEDT', '8733542400', 39600, '1'),
(36, 'AEST', '8749267200', 36000, '0'),
(36, 'AEDT', '8764992000', 39600, '1'),
(36, 'AEST', '8780716800', 36000, '0'),
(36, 'AEDT', '8796441600', 39600, '1'),
(36, 'AEST', '8812166400', 36000, '0'),
(36, 'AEDT', '8828496000', 39600, '1'),
(36, 'AEST', '8844220800', 36000, '0'),
(36, 'AEDT', '8859945600', 39600, '1'),
(36, 'AEST', '8875670400', 36000, '0'),
(36, 'AEDT', '8891395200', 39600, '1'),
(36, 'AEST', '8907120000', 36000, '0'),
(36, 'AEDT', '8922844800', 39600, '1'),
(36, 'AEST', '8938569600', 36000, '0'),
(36, 'AEDT', '8954294400', 39600, '1'),
(36, 'AEST', '8970019200', 36000, '0'),
(36, 'AEDT', '8985744000', 39600, '1'),
(36, 'AEST', '9001468800', 36000, '0'),
(36, 'AEDT', '9017798400', 39600, '1'),
(36, 'AEST', '9033523200', 36000, '0'),
(36, 'AEDT', '9049248000', 39600, '1'),
(36, 'AEST', '9064972800', 36000, '0'),
(36, 'AEDT', '9080697600', 39600, '1'),
(36, 'AEST', '9096422400', 36000, '0'),
(36, 'AEDT', '9112147200', 39600, '1'),
(36, 'AEST', '9127872000', 36000, '0'),
(36, 'AEDT', '9143596800', 39600, '1'),
(36, 'AEST', '9159321600', 36000, '0'),
(36, 'AEDT', '9175651200', 39600, '1'),
(36, 'AEST', '9191376000', 36000, '0'),
(36, 'AEDT', '9207100800', 39600, '1'),
(36, 'AEST', '9222825600', 36000, '0'),
(36, 'AEDT', '9238550400', 39600, '1'),
(36, 'AEST', '9254275200', 36000, '0'),
(36, 'AEDT', '9270000000', 39600, '1'),
(36, 'AEST', '9285724800', 36000, '0'),
(36, 'AEDT', '9301449600', 39600, '1'),
(36, 'AEST', '9317174400', 36000, '0'),
(36, 'AEDT', '9332899200', 39600, '1'),
(36, 'AEST', '9348624000', 36000, '0'),
(36, 'AEDT', '9364953600', 39600, '1'),
(36, 'AEST', '9380678400', 36000, '0'),
(36, 'AEDT', '9396403200', 39600, '1'),
(36, 'AEST', '9412128000', 36000, '0'),
(36, 'AEDT', '9427852800', 39600, '1'),
(36, 'AEST', '9443577600', 36000, '0'),
(36, 'AEDT', '9459302400', 39600, '1'),
(36, 'AEST', '9475027200', 36000, '0'),
(36, 'AEDT', '9490752000', 39600, '1'),
(36, 'AEST', '9506476800', 36000, '0'),
(36, 'AEDT', '9522201600', 39600, '1'),
(36, 'AEST', '9538531200', 36000, '0'),
(36, 'AEDT', '9554256000', 39600, '1'),
(36, 'AEST', '9569980800', 36000, '0'),
(36, 'AEDT', '9585705600', 39600, '1'),
(36, 'AEST', '9601430400', 36000, '0'),
(36, 'AEDT', '9617155200', 39600, '1'),
(36, 'AEST', '9632880000', 36000, '0'),
(36, 'AEDT', '9648604800', 39600, '1'),
(36, 'AEST', '9664329600', 36000, '0'),
(36, 'AEDT', '9680054400', 39600, '1'),
(36, 'AEST', '9695779200', 36000, '0'),
(36, 'AEDT', '9712108800', 39600, '1'),
(36, 'AEST', '9727833600', 36000, '0'),
(36, 'AEDT', '9743558400', 39600, '1'),
(36, 'AEST', '9759283200', 36000, '0'),
(36, 'AEDT', '9775008000', 39600, '1'),
(36, 'AEST', '9790732800', 36000, '0'),
(36, 'AEDT', '9806457600', 39600, '1'),
(36, 'AEST', '9822182400', 36000, '0'),
(36, 'AEDT', '9837907200', 39600, '1'),
(36, 'AEST', '9853632000', 36000, '0'),
(36, 'AEDT', '9869356800', 39600, '1'),
(36, 'AEST', '9885081600', 36000, '0'),
(36, 'AEDT', '9901411200', 39600, '1'),
(36, 'AEST', '9917136000', 36000, '0'),
(36, 'AEDT', '9932860800', 39600, '1'),
(36, 'AEST', '9948585600', 36000, '0'),
(36, 'AEDT', '9964310400', 39600, '1'),
(36, 'AEST', '9980035200', 36000, '0'),
(36, 'AEDT', '9995760000', 39600, '1'),
(36, 'AEST', '10011484800', 36000, '0'),
(36, 'AEDT', '10027209600', 39600, '1'),
(36, 'AEST', '10042934400', 36000, '0'),
(36, 'AEDT', '10059264000', 39600, '1'),
(36, 'AEST', '10074988800', 36000, '0'),
(36, 'AEDT', '10090713600', 39600, '1'),
(36, 'AEST', '10106438400', 36000, '0'),
(36, 'AEDT', '10122163200', 39600, '1'),
(36, 'AEST', '10137888000', 36000, '0'),
(36, 'AEDT', '10153612800', 39600, '1'),
(36, 'AEST', '10169337600', 36000, '0'),
(36, 'AEDT', '10185062400', 39600, '1'),
(36, 'AEST', '10200787200', 36000, '0'),
(36, 'AEDT', '10216512000', 39600, '1'),
(36, 'AEST', '10232236800', 36000, '0'),
(36, 'AEDT', '10248566400', 39600, '1'),
(36, 'AEST', '10264291200', 36000, '0'),
(36, 'AEDT', '10280016000', 39600, '1'),
(36, 'AEST', '10295740800', 36000, '0'),
(36, 'AEDT', '10311465600', 39600, '1'),
(36, 'AEST', '10327190400', 36000, '0'),
(36, 'AEDT', '10342915200', 39600, '1'),
(36, 'AEST', '10358640000', 36000, '0'),
(36, 'AEDT', '10374364800', 39600, '1'),
(36, 'AEST', '10390089600', 36000, '0'),
(36, 'AEDT', '10405814400', 39600, '1'),
(36, 'AEST', '10421539200', 36000, '0'),
(36, 'AEDT', '10437868800', 39600, '1'),
(36, 'AEST', '10453593600', 36000, '0'),
(36, 'AEDT', '10469318400', 39600, '1'),
(36, 'AEST', '10485043200', 36000, '0'),
(36, 'AEDT', '10500768000', 39600, '1'),
(36, 'AEST', '10516492800', 36000, '0'),
(36, 'AEDT', '10532217600', 39600, '1'),
(36, 'AEST', '10547942400', 36000, '0'),
(36, 'AEDT', '10563667200', 39600, '1'),
(36, 'AEST', '10579392000', 36000, '0'),
(36, 'AEDT', '10595116800', 39600, '1'),
(36, 'AEST', '10610841600', 36000, '0'),
(36, 'AEDT', '10627171200', 39600, '1'),
(36, 'AEST', '10642896000', 36000, '0'),
(36, 'AEDT', '10658620800', 39600, '1'),
(36, 'AEST', '10674345600', 36000, '0'),
(36, 'AEDT', '10690070400', 39600, '1'),
(36, 'AEST', '10705795200', 36000, '0'),
(36, 'AEDT', '10721520000', 39600, '1'),
(36, 'AEST', '10737244800', 36000, '0'),
(36, 'AEDT', '10752969600', 39600, '1'),
(36, 'AEST', '10768694400', 36000, '0'),
(36, 'AEDT', '10784419200', 39600, '1'),
(36, 'AEST', '10800748800', 36000, '0'),
(36, 'AEDT', '10816473600', 39600, '1'),
(36, 'AEST', '10832198400', 36000, '0'),
(36, 'AEDT', '10847923200', 39600, '1'),
(36, 'AEST', '10863648000', 36000, '0'),
(36, 'AEDT', '10879372800', 39600, '1'),
(36, 'AEST', '10895097600', 36000, '0'),
(36, 'AEDT', '10910822400', 39600, '1'),
(36, 'AEST', '10926547200', 36000, '0'),
(36, 'AEDT', '10942272000', 39600, '1'),
(36, 'AEST', '10957996800', 36000, '0'),
(36, 'AEDT', '10974326400', 39600, '1'),
(36, 'AEST', '10990051200', 36000, '0'),
(36, 'AEDT', '11005776000', 39600, '1'),
(36, 'AEST', '11021500800', 36000, '0'),
(36, 'AEDT', '11037225600', 39600, '1'),
(36, 'AEST', '11052950400', 36000, '0'),
(36, 'AEDT', '11068675200', 39600, '1'),
(36, 'AEST', '11084400000', 36000, '0'),
(36, 'AEDT', '11100124800', 39600, '1'),
(36, 'AEST', '11115849600', 36000, '0'),
(36, 'AEDT', '11131574400', 39600, '1'),
(36, 'AEST', '11147299200', 36000, '0'),
(36, 'AEDT', '11163628800', 39600, '1'),
(36, 'AEST', '11179353600', 36000, '0'),
(36, 'AEDT', '11195078400', 39600, '1'),
(36, 'AEST', '11210803200', 36000, '0'),
(36, 'AEDT', '11226528000', 39600, '1'),
(36, 'AEST', '11242252800', 36000, '0'),
(36, 'AEDT', '11257977600', 39600, '1'),
(36, 'AEST', '11273702400', 36000, '0'),
(36, 'AEDT', '11289427200', 39600, '1'),
(36, 'AEST', '11305152000', 36000, '0'),
(36, 'AEDT', '11321481600', 39600, '1'),
(36, 'AEST', '11337206400', 36000, '0'),
(36, 'AEDT', '11352931200', 39600, '1'),
(36, 'AEST', '11368656000', 36000, '0'),
(36, 'AEDT', '11384380800', 39600, '1'),
(36, 'AEST', '11400105600', 36000, '0'),
(36, 'AEDT', '11415830400', 39600, '1'),
(36, 'AEST', '11431555200', 36000, '0'),
(36, 'AEDT', '11447280000', 39600, '1'),
(36, 'AEST', '11463004800', 36000, '0'),
(36, 'AEDT', '11478729600', 39600, '1'),
(36, 'AEST', '11494454400', 36000, '0'),
(36, 'AEDT', '11510784000', 39600, '1'),
(36, 'AEST', '11526508800', 36000, '0'),
(36, 'AEDT', '11542233600', 39600, '1'),
(36, 'AEST', '11557958400', 36000, '0'),
(36, 'AEDT', '11573683200', 39600, '1'),
(36, 'AEST', '11589408000', 36000, '0'),
(36, 'AEDT', '11605132800', 39600, '1'),
(36, 'AEST', '11620857600', 36000, '0'),
(36, 'AEDT', '11636582400', 39600, '1'),
(36, 'AEST', '11652307200', 36000, '0'),
(36, 'AEDT', '11668032000', 39600, '1'),
(36, 'AEST', '11684361600', 36000, '0'),
(36, 'AEDT', '11700086400', 39600, '1'),
(36, 'AEST', '11715811200', 36000, '0'),
(36, 'AEDT', '11731536000', 39600, '1'),
(36, 'AEST', '11747260800', 36000, '0'),
(36, 'AEDT', '11762985600', 39600, '1'),
(36, 'AEST', '11778710400', 36000, '0'),
(36, 'AEDT', '11794435200', 39600, '1'),
(36, 'AEST', '11810160000', 36000, '0'),
(36, 'AEDT', '11825884800', 39600, '1'),
(36, 'AEST', '11841609600', 36000, '0'),
(36, 'AEDT', '11857939200', 39600, '1'),
(36, 'AEST', '11873664000', 36000, '0'),
(36, 'AEDT', '11889388800', 39600, '1'),
(36, 'AEST', '11905113600', 36000, '0'),
(36, 'AEDT', '11920838400', 39600, '1'),
(36, 'AEST', '11936563200', 36000, '0'),
(36, 'AEDT', '11952288000', 39600, '1'),
(36, 'AEST', '11968012800', 36000, '0'),
(36, 'AEDT', '11983737600', 39600, '1'),
(36, 'AEST', '11999462400', 36000, '0'),
(36, 'AEDT', '12015187200', 39600, '1'),
(36, 'AEST', '12030912000', 36000, '0'),
(36, 'AEDT', '12047241600', 39600, '1'),
(36, 'AEST', '12062966400', 36000, '0'),
(36, 'AEDT', '12078691200', 39600, '1'),
(36, 'AEST', '12094416000', 36000, '0'),
(36, 'AEDT', '12110140800', 39600, '1'),
(36, 'AEST', '12125865600', 36000, '0'),
(36, 'AEDT', '12141590400', 39600, '1'),
(36, 'AEST', '12157315200', 36000, '0'),
(36, 'AEDT', '12173040000', 39600, '1'),
(36, 'AEST', '12188764800', 36000, '0'),
(36, 'AEDT', '12205094400', 39600, '1'),
(36, 'AEST', '12220819200', 36000, '0'),
(36, 'AEDT', '12236544000', 39600, '1'),
(36, 'AEST', '12252268800', 36000, '0'),
(36, 'AEDT', '12267993600', 39600, '1'),
(36, 'AEST', '12283718400', 36000, '0'),
(36, 'AEDT', '12299443200', 39600, '1'),
(36, 'AEST', '12315168000', 36000, '0'),
(36, 'AEDT', '12330892800', 39600, '1'),
(36, 'AEST', '12346617600', 36000, '0'),
(36, 'AEDT', '12362342400', 39600, '1'),
(36, 'AEST', '12378067200', 36000, '0'),
(36, 'AEDT', '12394396800', 39600, '1'),
(36, 'AEST', '12410121600', 36000, '0'),
(36, 'AEDT', '12425846400', 39600, '1'),
(36, 'AEST', '12441571200', 36000, '0'),
(36, 'AEDT', '12457296000', 39600, '1'),
(36, 'AEST', '12473020800', 36000, '0'),
(36, 'AEDT', '12488745600', 39600, '1'),
(36, 'AEST', '12504470400', 36000, '0'),
(36, 'AEDT', '12520195200', 39600, '1'),
(36, 'AEST', '12535920000', 36000, '0'),
(36, 'AEDT', '12551644800', 39600, '1'),
(36, 'AEST', '12567974400', 36000, '0'),
(36, 'AEDT', '12583699200', 39600, '1'),
(36, 'AEST', '12599424000', 36000, '0'),
(36, 'AEDT', '12615148800', 39600, '1'),
(36, 'AEST', '12630873600', 36000, '0'),
(36, 'AEDT', '12646598400', 39600, '1'),
(36, 'AEST', '12662323200', 36000, '0'),
(36, 'AEDT', '12678048000', 39600, '1'),
(36, 'AEST', '12693772800', 36000, '0'),
(36, 'AEDT', '12709497600', 39600, '1'),
(36, 'AEST', '12725222400', 36000, '0'),
(36, 'AEDT', '12741552000', 39600, '1'),
(36, 'AEST', '12757276800', 36000, '0'),
(36, 'AEDT', '12773001600', 39600, '1'),
(36, 'AEST', '12788726400', 36000, '0'),
(36, 'AEDT', '12804451200', 39600, '1'),
(36, 'AEST', '12820176000', 36000, '0'),
(36, 'AEDT', '12835900800', 39600, '1'),
(36, 'AEST', '12851625600', 36000, '0'),
(36, 'AEDT', '12867350400', 39600, '1'),
(36, 'AEST', '12883075200', 36000, '0'),
(36, 'AEDT', '12898800000', 39600, '1'),
(36, 'AEST', '12914524800', 36000, '0'),
(36, 'AEDT', '12930854400', 39600, '1'),
(36, 'AEST', '12946579200', 36000, '0'),
(36, 'AEDT', '12962304000', 39600, '1'),
(36, 'AEST', '12978028800', 36000, '0'),
(36, 'AEDT', '12993753600', 39600, '1'),
(36, 'AEST', '13009478400', 36000, '0'),
(36, 'AEDT', '13025203200', 39600, '1'),
(36, 'AEST', '13040928000', 36000, '0'),
(36, 'AEDT', '13056652800', 39600, '1'),
(36, 'AEST', '13072377600', 36000, '0'),
(36, 'AEDT', '13088707200', 39600, '1'),
(36, 'AEST', '13104432000', 36000, '0'),
(36, 'AEDT', '13120156800', 39600, '1'),
(36, 'AEST', '13135881600', 36000, '0'),
(36, 'AEDT', '13151606400', 39600, '1'),
(36, 'AEST', '13167331200', 36000, '0'),
(36, 'AEDT', '13183056000', 39600, '1'),
(36, 'AEST', '13198780800', 36000, '0'),
(36, 'AEDT', '13214505600', 39600, '1'),
(36, 'AEST', '13230230400', 36000, '0'),
(36, 'AEDT', '13245955200', 39600, '1'),
(36, 'AEST', '13261680000', 36000, '0'),
(36, 'AEDT', '13278009600', 39600, '1'),
(36, 'AEST', '13293734400', 36000, '0'),
(36, 'AEDT', '13309459200', 39600, '1'),
(36, 'AEST', '13325184000', 36000, '0'),
(36, 'AEDT', '13340908800', 39600, '1'),
(36, 'AEST', '13356633600', 36000, '0'),
(36, 'AEDT', '13372358400', 39600, '1'),
(36, 'AEST', '13388083200', 36000, '0'),
(36, 'AEDT', '13403808000', 39600, '1'),
(36, 'AEST', '13419532800', 36000, '0'),
(36, 'AEDT', '13435257600', 39600, '1'),
(36, 'AEST', '13451587200', 36000, '0'),
(36, 'AEDT', '13467312000', 39600, '1'),
(36, 'AEST', '13483036800', 36000, '0'),
(36, 'AEDT', '13498761600', 39600, '1'),
(36, 'AEST', '13514486400', 36000, '0'),
(36, 'AEDT', '13530211200', 39600, '1'),
(36, 'AEST', '13545936000', 36000, '0'),
(36, 'AEDT', '13561660800', 39600, '1'),
(36, 'AEST', '13577385600', 36000, '0'),
(36, 'AEDT', '13593110400', 39600, '1'),
(36, 'AEST', '13608835200', 36000, '0'),
(36, 'AEDT', '13625164800', 39600, '1'),
(36, 'AEST', '13640889600', 36000, '0'),
(36, 'AEDT', '13656614400', 39600, '1'),
(36, 'AEST', '13672339200', 36000, '0'),
(36, 'AEDT', '13688064000', 39600, '1'),
(36, 'AEST', '13703788800', 36000, '0'),
(36, 'AEDT', '13719513600', 39600, '1'),
(36, 'AEST', '13735238400', 36000, '0'),
(36, 'AEDT', '13750963200', 39600, '1'),
(36, 'AEST', '13766688000', 36000, '0'),
(36, 'AEDT', '13782412800', 39600, '1'),
(36, 'AEST', '13798137600', 36000, '0'),
(36, 'AEDT', '13814467200', 39600, '1'),
(36, 'AEST', '13830192000', 36000, '0'),
(36, 'AEDT', '13845916800', 39600, '1'),
(36, 'AEST', '13861641600', 36000, '0'),
(36, 'AEDT', '13877366400', 39600, '1'),
(36, 'AEST', '13893091200', 36000, '0'),
(36, 'AEDT', '13908816000', 39600, '1'),
(36, 'AEST', '13924540800', 36000, '0'),
(36, 'AEDT', '13940265600', 39600, '1'),
(36, 'AEST', '13955990400', 36000, '0'),
(36, 'AEDT', '13972320000', 39600, '1'),
(36, 'AEST', '13988044800', 36000, '0'),
(36, 'AEDT', '14003769600', 39600, '1'),
(36, 'AEST', '14019494400', 36000, '0'),
(36, 'AEDT', '14035219200', 39600, '1'),
(36, 'AEST', '14050944000', 36000, '0'),
(36, 'AEDT', '14066668800', 39600, '1'),
(36, 'AEST', '14082393600', 36000, '0'),
(36, 'AEDT', '14098118400', 39600, '1'),
(36, 'AEST', '14113843200', 36000, '0'),
(36, 'AEDT', '14129568000', 39600, '1'),
(36, 'AEST', '14145292800', 36000, '0'),
(36, 'AEDT', '14161622400', 39600, '1'),
(36, 'AEST', '14177347200', 36000, '0'),
(36, 'AEDT', '14193072000', 39600, '1'),
(36, 'AEST', '14208796800', 36000, '0'),
(36, 'AEDT', '14224521600', 39600, '1'),
(36, 'AEST', '14240246400', 36000, '0'),
(36, 'AEDT', '14255971200', 39600, '1'),
(36, 'AEST', '14271696000', 36000, '0'),
(36, 'AEDT', '14287420800', 39600, '1'),
(36, 'AEST', '14303145600', 36000, '0'),
(36, 'AEDT', '14318870400', 39600, '1'),
(36, 'AEST', '14335200000', 36000, '0'),
(36, 'AEDT', '14350924800', 39600, '1'),
(36, 'AEST', '14366649600', 36000, '0'),
(36, 'AEDT', '14382374400', 39600, '1'),
(36, 'AEST', '14398099200', 36000, '0'),
(36, 'AEDT', '14413824000', 39600, '1'),
(36, 'AEST', '14429548800', 36000, '0'),
(36, 'AEDT', '14445273600', 39600, '1'),
(36, 'AEST', '14460998400', 36000, '0'),
(36, 'AEDT', '14476723200', 39600, '1'),
(36, 'AEST', '14492448000', 36000, '0'),
(36, 'AEDT', '14508777600', 39600, '1'),
(36, 'AEST', '14524502400', 36000, '0'),
(36, 'AEDT', '14540227200', 39600, '1'),
(36, 'AEST', '14555952000', 36000, '0'),
(36, 'AEDT', '14571676800', 39600, '1'),
(36, 'AEST', '14587401600', 36000, '0'),
(36, 'AEDT', '14603126400', 39600, '1'),
(36, 'AEST', '14618851200', 36000, '0'),
(36, 'AEDT', '14634576000', 39600, '1'),
(36, 'AEST', '14650300800', 36000, '0'),
(36, 'AEDT', '14666025600', 39600, '1'),
(36, 'AEST', '14681750400', 36000, '0'),
(36, 'AEDT', '14698080000', 39600, '1'),
(36, 'AEST', '14713804800', 36000, '0'),
(36, 'AEDT', '14729529600', 39600, '1'),
(36, 'AEST', '14745254400', 36000, '0'),
(36, 'AEDT', '14760979200', 39600, '1'),
(36, 'AEST', '14776704000', 36000, '0'),
(36, 'AEDT', '14792428800', 39600, '1'),
(36, 'AEST', '14808153600', 36000, '0'),
(36, 'AEDT', '14823878400', 39600, '1'),
(36, 'AEST', '14839603200', 36000, '0'),
(36, 'AEDT', '14855932800', 39600, '1'),
(36, 'AEST', '14871657600', 36000, '0'),
(36, 'AEDT', '14887382400', 39600, '1'),
(36, 'AEST', '14903107200', 36000, '0'),
(36, 'AEDT', '14918832000', 39600, '1'),
(36, 'AEST', '14934556800', 36000, '0'),
(36, 'AEDT', '14950281600', 39600, '1'),
(36, 'AEST', '14966006400', 36000, '0'),
(36, 'AEDT', '14981731200', 39600, '1'),
(36, 'AEST', '14997456000', 36000, '0'),
(36, 'AEDT', '15013180800', 39600, '1'),
(36, 'AEST', '15028905600', 36000, '0'),
(36, 'AEDT', '15045235200', 39600, '1'),
(36, 'AEST', '15060960000', 36000, '0'),
(36, 'AEDT', '15076684800', 39600, '1'),
(36, 'AEST', '15092409600', 36000, '0'),
(36, 'AEDT', '15108134400', 39600, '1'),
(36, 'AEST', '15123859200', 36000, '0'),
(36, 'AEDT', '15139584000', 39600, '1'),
(36, 'AEST', '15155308800', 36000, '0'),
(36, 'AEDT', '15171033600', 39600, '1'),
(36, 'AEST', '15186758400', 36000, '0'),
(36, 'AEDT', '15202483200', 39600, '1'),
(36, 'AEST', '15218812800', 36000, '0'),
(36, 'AEDT', '15234537600', 39600, '1'),
(36, 'AEST', '15250262400', 36000, '0'),
(36, 'AEDT', '15265987200', 39600, '1'),
(36, 'AEST', '15281712000', 36000, '0'),
(36, 'AEDT', '15297436800', 39600, '1'),
(36, 'AEST', '15313161600', 36000, '0'),
(36, 'AEDT', '15328886400', 39600, '1'),
(36, 'AEST', '15344611200', 36000, '0'),
(36, 'AEDT', '15360336000', 39600, '1'),
(36, 'AEST', '15376060800', 36000, '0'),
(36, 'AEDT', '15392390400', 39600, '1'),
(36, 'AEST', '15408115200', 36000, '0'),
(36, 'AEDT', '15423840000', 39600, '1'),
(36, 'AEST', '15439564800', 36000, '0'),
(36, 'AEDT', '15455289600', 39600, '1'),
(36, 'AEST', '15471014400', 36000, '0'),
(36, 'AEDT', '15486739200', 39600, '1'),
(36, 'AEST', '15502464000', 36000, '0'),
(36, 'AEDT', '15518188800', 39600, '1'),
(36, 'AEST', '15533913600', 36000, '0'),
(36, 'AEDT', '15549638400', 39600, '1'),
(36, 'AEST', '15565363200', 36000, '0'),
(36, 'AEDT', '15581692800', 39600, '1'),
(36, 'AEST', '15597417600', 36000, '0'),
(36, 'AEDT', '15613142400', 39600, '1'),
(36, 'AEST', '15628867200', 36000, '0'),
(36, 'AEDT', '15644592000', 39600, '1'),
(36, 'AEST', '15660316800', 36000, '0'),
(36, 'AEDT', '15676041600', 39600, '1'),
(36, 'AEST', '15691766400', 36000, '0'),
(36, 'AEDT', '15707491200', 39600, '1'),
(36, 'AEST', '15723216000', 36000, '0'),
(36, 'AEDT', '15739545600', 39600, '1'),
(36, 'AEST', '15755270400', 36000, '0'),
(36, 'AEDT', '15770995200', 39600, '1'),
(36, 'AEST', '15786720000', 36000, '0'),
(36, 'AEDT', '15802444800', 39600, '1'),
(36, 'AEST', '15818169600', 36000, '0'),
(36, 'AEDT', '15833894400', 39600, '1'),
(36, 'AEST', '15849619200', 36000, '0'),
(36, 'AEDT', '15865344000', 39600, '1'),
(36, 'AEST', '15881068800', 36000, '0'),
(36, 'AEDT', '15896793600', 39600, '1'),
(36, 'AEST', '15912518400', 36000, '0'),
(36, 'AEDT', '15928848000', 39600, '1'),
(36, 'AEST', '15944572800', 36000, '0'),
(36, 'AEDT', '15960297600', 39600, '1'),
(36, 'AEST', '15976022400', 36000, '0'),
(36, 'AEDT', '15991747200', 39600, '1'),
(36, 'AEST', '16007472000', 36000, '0'),
(36, 'AEDT', '16023196800', 39600, '1'),
(36, 'AEST', '16038921600', 36000, '0'),
(36, 'AEDT', '16054646400', 39600, '1'),
(36, 'AEST', '16070371200', 36000, '0'),
(36, 'AEDT', '16086096000', 39600, '1'),
(36, 'AEST', '16102425600', 36000, '0'),
(36, 'AEDT', '16118150400', 39600, '1'),
(36, 'AEST', '16133875200', 36000, '0'),
(36, 'AEDT', '16149600000', 39600, '1'),
(36, 'AEST', '16165324800', 36000, '0'),
(36, 'AEDT', '16181049600', 39600, '1'),
(36, 'AEST', '16196774400', 36000, '0'),
(36, 'AEDT', '16212499200', 39600, '1'),
(36, 'AEST', '16228224000', 36000, '0'),
(36, 'AEDT', '16243948800', 39600, '1'),
(36, 'AEST', '16259673600', 36000, '0'),
(36, 'AEDT', '16276003200', 39600, '1'),
(36, 'AEST', '16291728000', 36000, '0'),
(36, 'AEDT', '16307452800', 39600, '1'),
(36, 'AEST', '16323177600', 36000, '0'),
(36, 'AEDT', '16338902400', 39600, '1'),
(36, 'AEST', '16354627200', 36000, '0'),
(36, 'AEDT', '16370352000', 39600, '1'),
(36, 'AEST', '16386076800', 36000, '0'),
(36, 'AEDT', '16401801600', 39600, '1'),
(36, 'AEST', '16417526400', 36000, '0'),
(36, 'AEDT', '16433251200', 39600, '1'),
(36, 'AEST', '16448976000', 36000, '0'),
(36, 'AEDT', '16465305600', 39600, '1'),
(36, 'AEST', '16481030400', 36000, '0'),
(36, 'AEDT', '16496755200', 39600, '1'),
(36, 'AEST', '16512480000', 36000, '0'),
(36, 'AEDT', '16528204800', 39600, '1'),
(36, 'AEST', '16543929600', 36000, '0'),
(36, 'AEDT', '16559654400', 39600, '1'),
(36, 'AEST', '16575379200', 36000, '0'),
(36, 'AEDT', '16591104000', 39600, '1'),
(36, 'AEST', '16606828800', 36000, '0'),
(36, 'AEDT', '16623158400', 39600, '1'),
(36, 'AEST', '16638883200', 36000, '0'),
(36, 'AEDT', '16654608000', 39600, '1'),
(36, 'AEST', '16670332800', 36000, '0'),
(36, 'AEDT', '16686057600', 39600, '1'),
(36, 'AEST', '16701782400', 36000, '0'),
(36, 'AEDT', '16717507200', 39600, '1'),
(37, 'LMT', '-2364111593', 34792, '0'),
(37, 'AEST', '-2364111592', 36000, '0'),
(37, 'AEDT', '-1672567140', 39600, '1'),
(37, 'AEST', '-1665392400', 36000, '0'),
(37, 'AEDT', '-883641600', 39600, '1'),
(37, 'AEST', '-876128400', 36000, '0'),
(37, 'AEDT', '-860400000', 39600, '1'),
(37, 'AEST', '-844678800', 36000, '0'),
(37, 'AEDT', '-828345600', 39600, '1'),
(37, 'AEST', '-813229200', 36000, '0'),
(37, 'AEDT', '57686400', 39600, '1'),
(37, 'AEST', '67968000', 36000, '0'),
(37, 'AEDT', '89136000', 39600, '1'),
(37, 'AEST', '100022400', 36000, '0'),
(37, 'AEDT', '120585600', 39600, '1'),
(37, 'AEST', '131472000', 36000, '0'),
(37, 'AEDT', '152035200', 39600, '1'),
(37, 'AEST', '162921600', 36000, '0'),
(37, 'AEDT', '183484800', 39600, '1'),
(37, 'AEST', '194976000', 36000, '0'),
(37, 'AEDT', '215539200', 39600, '1'),
(37, 'AEST', '226425600', 36000, '0'),
(37, 'AEDT', '246988800', 39600, '1'),
(37, 'AEST', '257875200', 36000, '0'),
(37, 'AEDT', '278438400', 39600, '1'),
(37, 'AEST', '289324800', 36000, '0'),
(37, 'AEDT', '309888000', 39600, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(37, 'AEST', '320774400', 36000, '0'),
(37, 'AEDT', '341337600', 39600, '1'),
(37, 'AEST', '352224000', 36000, '0'),
(37, 'AEDT', '372787200', 39600, '1'),
(37, 'AEST', '384278400', 36000, '0'),
(37, 'AEDT', '404841600', 39600, '1'),
(37, 'AEST', '415728000', 36000, '0'),
(37, 'AEDT', '436291200', 39600, '1'),
(37, 'AEST', '447177600', 36000, '0'),
(37, 'AEDT', '467740800', 39600, '1'),
(37, 'AEST', '478627200', 36000, '0'),
(37, 'AEDT', '499190400', 39600, '1'),
(37, 'AEST', '511286400', 36000, '0'),
(37, 'AEDT', '530035200', 39600, '1'),
(37, 'AEST', '542736000', 36000, '0'),
(37, 'AEDT', '561484800', 39600, '1'),
(37, 'AEST', '574790400', 36000, '0'),
(37, 'AEDT', '594144000', 39600, '1'),
(37, 'AEST', '606240000', 36000, '0'),
(37, 'AEDT', '625593600', 39600, '1'),
(37, 'AEST', '637689600', 36000, '0'),
(37, 'AEDT', '657043200', 39600, '1'),
(37, 'AEST', '667929600', 36000, '0'),
(37, 'AEDT', '688492800', 39600, '1'),
(37, 'AEST', '699379200', 36000, '0'),
(37, 'AEDT', '719942400', 39600, '1'),
(37, 'AEST', '731433600', 36000, '0'),
(37, 'AEDT', '751996800', 39600, '1'),
(37, 'AEST', '762883200', 36000, '0'),
(37, 'AEDT', '783446400', 39600, '1'),
(37, 'AEST', '796147200', 36000, '0'),
(37, 'AEDT', '814896000', 39600, '1'),
(37, 'AEST', '828201600', 36000, '0'),
(37, 'AEDT', '846345600', 39600, '1'),
(37, 'AEST', '859651200', 36000, '0'),
(37, 'AEDT', '877795200', 39600, '1'),
(37, 'AEST', '891100800', 36000, '0'),
(37, 'AEDT', '909244800', 39600, '1'),
(37, 'AEST', '922550400', 36000, '0'),
(37, 'AEDT', '941299200', 39600, '1'),
(37, 'AEST', '954000000', 36000, '0'),
(37, 'AEDT', '967305600', 39600, '1'),
(37, 'AEST', '985449600', 36000, '0'),
(37, 'AEDT', '1004198400', 39600, '1'),
(37, 'AEST', '1017504000', 36000, '0'),
(37, 'AEDT', '1035648000', 39600, '1'),
(37, 'AEST', '1048953600', 36000, '0'),
(37, 'AEDT', '1067097600', 39600, '1'),
(37, 'AEST', '1080403200', 36000, '0'),
(37, 'AEDT', '1099152000', 39600, '1'),
(37, 'AEST', '1111852800', 36000, '0'),
(37, 'AEDT', '1130601600', 39600, '1'),
(37, 'AEST', '1143907200', 36000, '0'),
(37, 'AEDT', '1162051200', 39600, '1'),
(37, 'AEST', '1174752000', 36000, '0'),
(37, 'AEDT', '1193500800', 39600, '1'),
(37, 'AEST', '1207411200', 36000, '0'),
(37, 'AEDT', '1223136000', 39600, '1'),
(37, 'AEST', '1238860800', 36000, '0'),
(37, 'AEDT', '1254585600', 39600, '1'),
(37, 'AEST', '1270310400', 36000, '0'),
(37, 'AEDT', '1286035200', 39600, '1'),
(37, 'AEST', '1301760000', 36000, '0'),
(37, 'AEDT', '1317484800', 39600, '1'),
(37, 'AEST', '1333209600', 36000, '0'),
(37, 'AEDT', '1349539200', 39600, '1'),
(37, 'AEST', '1365264000', 36000, '0'),
(37, 'AEDT', '1380988800', 39600, '1'),
(37, 'AEST', '1396713600', 36000, '0'),
(37, 'AEDT', '1412438400', 39600, '1'),
(37, 'AEST', '1428163200', 36000, '0'),
(37, 'AEDT', '1443888000', 39600, '1'),
(37, 'AEST', '1459612800', 36000, '0'),
(37, 'AEDT', '1475337600', 39600, '1'),
(37, 'AEST', '1491062400', 36000, '0'),
(37, 'AEDT', '1506787200', 39600, '1'),
(37, 'AEST', '1522512000', 36000, '0'),
(37, 'AEDT', '1538841600', 39600, '1'),
(37, 'AEST', '1554566400', 36000, '0'),
(37, 'AEDT', '1570291200', 39600, '1'),
(37, 'AEST', '1586016000', 36000, '0'),
(37, 'AEDT', '1601740800', 39600, '1'),
(37, 'AEST', '1617465600', 36000, '0'),
(37, 'AEDT', '1633190400', 39600, '1'),
(37, 'AEST', '1648915200', 36000, '0'),
(37, 'AEDT', '1664640000', 39600, '1'),
(37, 'AEST', '1680364800', 36000, '0'),
(37, 'AEDT', '1696089600', 39600, '1'),
(37, 'AEST', '1712419200', 36000, '0'),
(37, 'AEDT', '1728144000', 39600, '1'),
(37, 'AEST', '1743868800', 36000, '0'),
(37, 'AEDT', '1759593600', 39600, '1'),
(37, 'AEST', '1775318400', 36000, '0'),
(37, 'AEDT', '1791043200', 39600, '1'),
(37, 'AEST', '1806768000', 36000, '0'),
(37, 'AEDT', '1822492800', 39600, '1'),
(37, 'AEST', '1838217600', 36000, '0'),
(37, 'AEDT', '1853942400', 39600, '1'),
(37, 'AEST', '1869667200', 36000, '0'),
(37, 'AEDT', '1885996800', 39600, '1'),
(37, 'AEST', '1901721600', 36000, '0'),
(37, 'AEDT', '1917446400', 39600, '1'),
(37, 'AEST', '1933171200', 36000, '0'),
(37, 'AEDT', '1948896000', 39600, '1'),
(37, 'AEST', '1964620800', 36000, '0'),
(37, 'AEDT', '1980345600', 39600, '1'),
(37, 'AEST', '1996070400', 36000, '0'),
(37, 'AEDT', '2011795200', 39600, '1'),
(37, 'AEST', '2027520000', 36000, '0'),
(37, 'AEDT', '2043244800', 39600, '1'),
(37, 'AEST', '2058969600', 36000, '0'),
(37, 'AEDT', '2075299200', 39600, '1'),
(37, 'AEST', '2091024000', 36000, '0'),
(37, 'AEDT', '2106748800', 39600, '1'),
(37, 'AEST', '2122473600', 36000, '0'),
(37, 'AEDT', '2138198400', 39600, '1'),
(37, 'AEST', '2153923200', 36000, '0'),
(37, 'AEDT', '2169648000', 39600, '1'),
(37, 'AEST', '2185372800', 36000, '0'),
(37, 'AEDT', '2201097600', 39600, '1'),
(37, 'AEST', '2216822400', 36000, '0'),
(37, 'AEDT', '2233152000', 39600, '1'),
(37, 'AEST', '2248876800', 36000, '0'),
(37, 'AEDT', '2264601600', 39600, '1'),
(37, 'AEST', '2280326400', 36000, '0'),
(37, 'AEDT', '2296051200', 39600, '1'),
(37, 'AEST', '2311776000', 36000, '0'),
(37, 'AEDT', '2327500800', 39600, '1'),
(37, 'AEST', '2343225600', 36000, '0'),
(37, 'AEDT', '2358950400', 39600, '1'),
(37, 'AEST', '2374675200', 36000, '0'),
(37, 'AEDT', '2390400000', 39600, '1'),
(37, 'AEST', '2406124800', 36000, '0'),
(37, 'AEDT', '2422454400', 39600, '1'),
(37, 'AEST', '2438179200', 36000, '0'),
(37, 'AEDT', '2453904000', 39600, '1'),
(37, 'AEST', '2469628800', 36000, '0'),
(37, 'AEDT', '2485353600', 39600, '1'),
(37, 'AEST', '2501078400', 36000, '0'),
(37, 'AEDT', '2516803200', 39600, '1'),
(37, 'AEST', '2532528000', 36000, '0'),
(37, 'AEDT', '2548252800', 39600, '1'),
(37, 'AEST', '2563977600', 36000, '0'),
(37, 'AEDT', '2579702400', 39600, '1'),
(37, 'AEST', '2596032000', 36000, '0'),
(37, 'AEDT', '2611756800', 39600, '1'),
(37, 'AEST', '2627481600', 36000, '0'),
(37, 'AEDT', '2643206400', 39600, '1'),
(37, 'AEST', '2658931200', 36000, '0'),
(37, 'AEDT', '2674656000', 39600, '1'),
(37, 'AEST', '2690380800', 36000, '0'),
(37, 'AEDT', '2706105600', 39600, '1'),
(37, 'AEST', '2721830400', 36000, '0'),
(37, 'AEDT', '2737555200', 39600, '1'),
(37, 'AEST', '2753280000', 36000, '0'),
(37, 'AEDT', '2769609600', 39600, '1'),
(37, 'AEST', '2785334400', 36000, '0'),
(37, 'AEDT', '2801059200', 39600, '1'),
(37, 'AEST', '2816784000', 36000, '0'),
(37, 'AEDT', '2832508800', 39600, '1'),
(37, 'AEST', '2848233600', 36000, '0'),
(37, 'AEDT', '2863958400', 39600, '1'),
(37, 'AEST', '2879683200', 36000, '0'),
(37, 'AEDT', '2895408000', 39600, '1'),
(37, 'AEST', '2911132800', 36000, '0'),
(37, 'AEDT', '2926857600', 39600, '1'),
(37, 'AEST', '2942582400', 36000, '0'),
(37, 'AEDT', '2958912000', 39600, '1'),
(37, 'AEST', '2974636800', 36000, '0'),
(37, 'AEDT', '2990361600', 39600, '1'),
(37, 'AEST', '3006086400', 36000, '0'),
(37, 'AEDT', '3021811200', 39600, '1'),
(37, 'AEST', '3037536000', 36000, '0'),
(37, 'AEDT', '3053260800', 39600, '1'),
(37, 'AEST', '3068985600', 36000, '0'),
(37, 'AEDT', '3084710400', 39600, '1'),
(37, 'AEST', '3100435200', 36000, '0'),
(37, 'AEDT', '3116764800', 39600, '1'),
(37, 'AEST', '3132489600', 36000, '0'),
(37, 'AEDT', '3148214400', 39600, '1'),
(37, 'AEST', '3163939200', 36000, '0'),
(37, 'AEDT', '3179664000', 39600, '1'),
(37, 'AEST', '3195388800', 36000, '0'),
(37, 'AEDT', '3211113600', 39600, '1'),
(37, 'AEST', '3226838400', 36000, '0'),
(37, 'AEDT', '3242563200', 39600, '1'),
(37, 'AEST', '3258288000', 36000, '0'),
(37, 'AEDT', '3274012800', 39600, '1'),
(37, 'AEST', '3289737600', 36000, '0'),
(37, 'AEDT', '3306067200', 39600, '1'),
(37, 'AEST', '3321792000', 36000, '0'),
(37, 'AEDT', '3337516800', 39600, '1'),
(37, 'AEST', '3353241600', 36000, '0'),
(37, 'AEDT', '3368966400', 39600, '1'),
(37, 'AEST', '3384691200', 36000, '0'),
(37, 'AEDT', '3400416000', 39600, '1'),
(37, 'AEST', '3416140800', 36000, '0'),
(37, 'AEDT', '3431865600', 39600, '1'),
(37, 'AEST', '3447590400', 36000, '0'),
(37, 'AEDT', '3463315200', 39600, '1'),
(37, 'AEST', '3479644800', 36000, '0'),
(37, 'AEDT', '3495369600', 39600, '1'),
(37, 'AEST', '3511094400', 36000, '0'),
(37, 'AEDT', '3526819200', 39600, '1'),
(37, 'AEST', '3542544000', 36000, '0'),
(37, 'AEDT', '3558268800', 39600, '1'),
(37, 'AEST', '3573993600', 36000, '0'),
(37, 'AEDT', '3589718400', 39600, '1'),
(37, 'AEST', '3605443200', 36000, '0'),
(37, 'AEDT', '3621168000', 39600, '1'),
(37, 'AEST', '3636892800', 36000, '0'),
(37, 'AEDT', '3653222400', 39600, '1'),
(37, 'AEST', '3668947200', 36000, '0'),
(37, 'AEDT', '3684672000', 39600, '1'),
(37, 'AEST', '3700396800', 36000, '0'),
(37, 'AEDT', '3716121600', 39600, '1'),
(37, 'AEST', '3731846400', 36000, '0'),
(37, 'AEDT', '3747571200', 39600, '1'),
(37, 'AEST', '3763296000', 36000, '0'),
(37, 'AEDT', '3779020800', 39600, '1'),
(37, 'AEST', '3794745600', 36000, '0'),
(37, 'AEDT', '3810470400', 39600, '1'),
(37, 'AEST', '3826195200', 36000, '0'),
(37, 'AEDT', '3842524800', 39600, '1'),
(37, 'AEST', '3858249600', 36000, '0'),
(37, 'AEDT', '3873974400', 39600, '1'),
(37, 'AEST', '3889699200', 36000, '0'),
(37, 'AEDT', '3905424000', 39600, '1'),
(37, 'AEST', '3921148800', 36000, '0'),
(37, 'AEDT', '3936873600', 39600, '1'),
(37, 'AEST', '3952598400', 36000, '0'),
(37, 'AEDT', '3968323200', 39600, '1'),
(37, 'AEST', '3984048000', 36000, '0'),
(37, 'AEDT', '4000377600', 39600, '1'),
(37, 'AEST', '4016102400', 36000, '0'),
(37, 'AEDT', '4031827200', 39600, '1'),
(37, 'AEST', '4047552000', 36000, '0'),
(37, 'AEDT', '4063276800', 39600, '1'),
(37, 'AEST', '4079001600', 36000, '0'),
(37, 'AEDT', '4094726400', 39600, '1'),
(37, 'AEST', '4110451200', 36000, '0'),
(37, 'AEDT', '4126176000', 39600, '1'),
(37, 'AEST', '4141900800', 36000, '0'),
(37, 'AEDT', '4157625600', 39600, '1'),
(37, 'AEST', '4173350400', 36000, '0'),
(37, 'AEDT', '4189075200', 39600, '1'),
(37, 'AEST', '4204800000', 36000, '0'),
(37, 'AEDT', '4221129600', 39600, '1'),
(37, 'AEST', '4236854400', 36000, '0'),
(37, 'AEDT', '4252579200', 39600, '1'),
(37, 'AEST', '4268304000', 36000, '0'),
(37, 'AEDT', '4284028800', 39600, '1'),
(37, 'AEST', '4299753600', 36000, '0'),
(37, 'AEDT', '4315478400', 39600, '1'),
(37, 'AEST', '4331203200', 36000, '0'),
(37, 'AEDT', '4346928000', 39600, '1'),
(37, 'AEST', '4362652800', 36000, '0'),
(37, 'AEDT', '4378982400', 39600, '1'),
(37, 'AEST', '4394707200', 36000, '0'),
(37, 'AEDT', '4410432000', 39600, '1'),
(37, 'AEST', '4426156800', 36000, '0'),
(37, 'AEDT', '4441881600', 39600, '1'),
(37, 'AEST', '4457606400', 36000, '0'),
(37, 'AEDT', '4473331200', 39600, '1'),
(37, 'AEST', '4489056000', 36000, '0'),
(37, 'AEDT', '4504780800', 39600, '1'),
(37, 'AEST', '4520505600', 36000, '0'),
(37, 'AEDT', '4536230400', 39600, '1'),
(37, 'AEST', '4551955200', 36000, '0'),
(37, 'AEDT', '4568284800', 39600, '1'),
(37, 'AEST', '4584009600', 36000, '0'),
(37, 'AEDT', '4599734400', 39600, '1'),
(37, 'AEST', '4615459200', 36000, '0'),
(37, 'AEDT', '4631184000', 39600, '1'),
(37, 'AEST', '4646908800', 36000, '0'),
(37, 'AEDT', '4662633600', 39600, '1'),
(37, 'AEST', '4678358400', 36000, '0'),
(37, 'AEDT', '4694083200', 39600, '1'),
(37, 'AEST', '4709808000', 36000, '0'),
(37, 'AEDT', '4725532800', 39600, '1'),
(37, 'AEST', '4741862400', 36000, '0'),
(37, 'AEDT', '4757587200', 39600, '1'),
(37, 'AEST', '4773312000', 36000, '0'),
(37, 'AEDT', '4789036800', 39600, '1'),
(37, 'AEST', '4804761600', 36000, '0'),
(37, 'AEDT', '4820486400', 39600, '1'),
(37, 'AEST', '4836211200', 36000, '0'),
(37, 'AEDT', '4851936000', 39600, '1'),
(37, 'AEST', '4867660800', 36000, '0'),
(37, 'AEDT', '4883385600', 39600, '1'),
(37, 'AEST', '4899110400', 36000, '0'),
(37, 'AEDT', '4915440000', 39600, '1'),
(37, 'AEST', '4931164800', 36000, '0'),
(37, 'AEDT', '4946889600', 39600, '1'),
(37, 'AEST', '4962614400', 36000, '0'),
(37, 'AEDT', '4978339200', 39600, '1'),
(37, 'AEST', '4994064000', 36000, '0'),
(37, 'AEDT', '5009788800', 39600, '1'),
(37, 'AEST', '5025513600', 36000, '0'),
(37, 'AEDT', '5041238400', 39600, '1'),
(37, 'AEST', '5056963200', 36000, '0'),
(37, 'AEDT', '5072688000', 39600, '1'),
(37, 'AEST', '5088412800', 36000, '0'),
(37, 'AEDT', '5104742400', 39600, '1'),
(37, 'AEST', '5120467200', 36000, '0'),
(37, 'AEDT', '5136192000', 39600, '1'),
(37, 'AEST', '5151916800', 36000, '0'),
(37, 'AEDT', '5167641600', 39600, '1'),
(37, 'AEST', '5183366400', 36000, '0'),
(37, 'AEDT', '5199091200', 39600, '1'),
(37, 'AEST', '5214816000', 36000, '0'),
(37, 'AEDT', '5230540800', 39600, '1'),
(37, 'AEST', '5246265600', 36000, '0'),
(37, 'AEDT', '5262595200', 39600, '1'),
(37, 'AEST', '5278320000', 36000, '0'),
(37, 'AEDT', '5294044800', 39600, '1'),
(37, 'AEST', '5309769600', 36000, '0'),
(37, 'AEDT', '5325494400', 39600, '1'),
(37, 'AEST', '5341219200', 36000, '0'),
(37, 'AEDT', '5356944000', 39600, '1'),
(37, 'AEST', '5372668800', 36000, '0'),
(37, 'AEDT', '5388393600', 39600, '1'),
(37, 'AEST', '5404118400', 36000, '0'),
(37, 'AEDT', '5419843200', 39600, '1'),
(37, 'AEST', '5435568000', 36000, '0'),
(37, 'AEDT', '5451897600', 39600, '1'),
(37, 'AEST', '5467622400', 36000, '0'),
(37, 'AEDT', '5483347200', 39600, '1'),
(37, 'AEST', '5499072000', 36000, '0'),
(37, 'AEDT', '5514796800', 39600, '1'),
(37, 'AEST', '5530521600', 36000, '0'),
(37, 'AEDT', '5546246400', 39600, '1'),
(37, 'AEST', '5561971200', 36000, '0'),
(37, 'AEDT', '5577696000', 39600, '1'),
(37, 'AEST', '5593420800', 36000, '0'),
(37, 'AEDT', '5609145600', 39600, '1'),
(37, 'AEST', '5625475200', 36000, '0'),
(37, 'AEDT', '5641200000', 39600, '1'),
(37, 'AEST', '5656924800', 36000, '0'),
(37, 'AEDT', '5672649600', 39600, '1'),
(37, 'AEST', '5688374400', 36000, '0'),
(37, 'AEDT', '5704099200', 39600, '1'),
(37, 'AEST', '5719824000', 36000, '0'),
(37, 'AEDT', '5735548800', 39600, '1'),
(37, 'AEST', '5751273600', 36000, '0'),
(37, 'AEDT', '5766998400', 39600, '1'),
(37, 'AEST', '5782723200', 36000, '0'),
(37, 'AEDT', '5799052800', 39600, '1'),
(37, 'AEST', '5814777600', 36000, '0'),
(37, 'AEDT', '5830502400', 39600, '1'),
(37, 'AEST', '5846227200', 36000, '0'),
(37, 'AEDT', '5861952000', 39600, '1'),
(37, 'AEST', '5877676800', 36000, '0'),
(37, 'AEDT', '5893401600', 39600, '1'),
(37, 'AEST', '5909126400', 36000, '0'),
(37, 'AEDT', '5924851200', 39600, '1'),
(37, 'AEST', '5940576000', 36000, '0'),
(37, 'AEDT', '5956300800', 39600, '1'),
(37, 'AEST', '5972025600', 36000, '0'),
(37, 'AEDT', '5988355200', 39600, '1'),
(37, 'AEST', '6004080000', 36000, '0'),
(37, 'AEDT', '6019804800', 39600, '1'),
(37, 'AEST', '6035529600', 36000, '0'),
(37, 'AEDT', '6051254400', 39600, '1'),
(37, 'AEST', '6066979200', 36000, '0'),
(37, 'AEDT', '6082704000', 39600, '1'),
(37, 'AEST', '6098428800', 36000, '0'),
(37, 'AEDT', '6114153600', 39600, '1'),
(37, 'AEST', '6129878400', 36000, '0'),
(37, 'AEDT', '6146208000', 39600, '1'),
(37, 'AEST', '6161932800', 36000, '0'),
(37, 'AEDT', '6177657600', 39600, '1'),
(37, 'AEST', '6193382400', 36000, '0'),
(37, 'AEDT', '6209107200', 39600, '1'),
(37, 'AEST', '6224832000', 36000, '0'),
(37, 'AEDT', '6240556800', 39600, '1'),
(37, 'AEST', '6256281600', 36000, '0'),
(37, 'AEDT', '6272006400', 39600, '1'),
(37, 'AEST', '6287731200', 36000, '0'),
(37, 'AEDT', '6303456000', 39600, '1'),
(37, 'AEST', '6319180800', 36000, '0'),
(37, 'AEDT', '6335510400', 39600, '1'),
(37, 'AEST', '6351235200', 36000, '0'),
(37, 'AEDT', '6366960000', 39600, '1'),
(37, 'AEST', '6382684800', 36000, '0'),
(37, 'AEDT', '6398409600', 39600, '1'),
(37, 'AEST', '6414134400', 36000, '0'),
(37, 'AEDT', '6429859200', 39600, '1'),
(37, 'AEST', '6445584000', 36000, '0'),
(37, 'AEDT', '6461308800', 39600, '1'),
(37, 'AEST', '6477033600', 36000, '0'),
(37, 'AEDT', '6492758400', 39600, '1'),
(37, 'AEST', '6509088000', 36000, '0'),
(37, 'AEDT', '6524812800', 39600, '1'),
(37, 'AEST', '6540537600', 36000, '0'),
(37, 'AEDT', '6556262400', 39600, '1'),
(37, 'AEST', '6571987200', 36000, '0'),
(37, 'AEDT', '6587712000', 39600, '1'),
(37, 'AEST', '6603436800', 36000, '0'),
(37, 'AEDT', '6619161600', 39600, '1'),
(37, 'AEST', '6634886400', 36000, '0'),
(37, 'AEDT', '6650611200', 39600, '1'),
(37, 'AEST', '6666336000', 36000, '0'),
(37, 'AEDT', '6682665600', 39600, '1'),
(37, 'AEST', '6698390400', 36000, '0'),
(37, 'AEDT', '6714115200', 39600, '1'),
(37, 'AEST', '6729840000', 36000, '0'),
(37, 'AEDT', '6745564800', 39600, '1'),
(37, 'AEST', '6761289600', 36000, '0'),
(37, 'AEDT', '6777014400', 39600, '1'),
(37, 'AEST', '6792739200', 36000, '0'),
(37, 'AEDT', '6808464000', 39600, '1'),
(37, 'AEST', '6824188800', 36000, '0'),
(37, 'AEDT', '6839913600', 39600, '1'),
(37, 'AEST', '6855638400', 36000, '0'),
(37, 'AEDT', '6871968000', 39600, '1'),
(37, 'AEST', '6887692800', 36000, '0'),
(37, 'AEDT', '6903417600', 39600, '1'),
(37, 'AEST', '6919142400', 36000, '0'),
(37, 'AEDT', '6934867200', 39600, '1'),
(37, 'AEST', '6950592000', 36000, '0'),
(37, 'AEDT', '6966316800', 39600, '1'),
(37, 'AEST', '6982041600', 36000, '0'),
(37, 'AEDT', '6997766400', 39600, '1'),
(37, 'AEST', '7013491200', 36000, '0'),
(37, 'AEDT', '7029820800', 39600, '1'),
(37, 'AEST', '7045545600', 36000, '0'),
(37, 'AEDT', '7061270400', 39600, '1'),
(37, 'AEST', '7076995200', 36000, '0'),
(37, 'AEDT', '7092720000', 39600, '1'),
(37, 'AEST', '7108444800', 36000, '0'),
(37, 'AEDT', '7124169600', 39600, '1'),
(37, 'AEST', '7139894400', 36000, '0'),
(37, 'AEDT', '7155619200', 39600, '1'),
(37, 'AEST', '7171344000', 36000, '0'),
(37, 'AEDT', '7187068800', 39600, '1'),
(37, 'AEST', '7202793600', 36000, '0'),
(37, 'AEDT', '7219123200', 39600, '1'),
(37, 'AEST', '7234848000', 36000, '0'),
(37, 'AEDT', '7250572800', 39600, '1'),
(37, 'AEST', '7266297600', 36000, '0'),
(37, 'AEDT', '7282022400', 39600, '1'),
(37, 'AEST', '7297747200', 36000, '0'),
(37, 'AEDT', '7313472000', 39600, '1'),
(37, 'AEST', '7329196800', 36000, '0'),
(37, 'AEDT', '7344921600', 39600, '1'),
(37, 'AEST', '7360646400', 36000, '0'),
(37, 'AEDT', '7376371200', 39600, '1'),
(37, 'AEST', '7392096000', 36000, '0'),
(37, 'AEDT', '7408425600', 39600, '1'),
(37, 'AEST', '7424150400', 36000, '0'),
(37, 'AEDT', '7439875200', 39600, '1'),
(37, 'AEST', '7455600000', 36000, '0'),
(37, 'AEDT', '7471324800', 39600, '1'),
(37, 'AEST', '7487049600', 36000, '0'),
(37, 'AEDT', '7502774400', 39600, '1'),
(37, 'AEST', '7518499200', 36000, '0'),
(37, 'AEDT', '7534224000', 39600, '1'),
(37, 'AEST', '7549948800', 36000, '0'),
(37, 'AEDT', '7565673600', 39600, '1'),
(37, 'AEST', '7581398400', 36000, '0'),
(37, 'AEDT', '7597728000', 39600, '1'),
(37, 'AEST', '7613452800', 36000, '0'),
(37, 'AEDT', '7629177600', 39600, '1'),
(37, 'AEST', '7644902400', 36000, '0'),
(37, 'AEDT', '7660627200', 39600, '1'),
(37, 'AEST', '7676352000', 36000, '0'),
(37, 'AEDT', '7692076800', 39600, '1'),
(37, 'AEST', '7707801600', 36000, '0'),
(37, 'AEDT', '7723526400', 39600, '1'),
(37, 'AEST', '7739251200', 36000, '0'),
(37, 'AEDT', '7754976000', 39600, '1'),
(37, 'AEST', '7771305600', 36000, '0'),
(37, 'AEDT', '7787030400', 39600, '1'),
(37, 'AEST', '7802755200', 36000, '0'),
(37, 'AEDT', '7818480000', 39600, '1'),
(37, 'AEST', '7834204800', 36000, '0'),
(37, 'AEDT', '7849929600', 39600, '1'),
(37, 'AEST', '7865654400', 36000, '0'),
(37, 'AEDT', '7881379200', 39600, '1'),
(37, 'AEST', '7897104000', 36000, '0'),
(37, 'AEDT', '7912828800', 39600, '1'),
(37, 'AEST', '7928553600', 36000, '0'),
(37, 'AEDT', '7944883200', 39600, '1'),
(37, 'AEST', '7960608000', 36000, '0'),
(37, 'AEDT', '7976332800', 39600, '1'),
(37, 'AEST', '7992057600', 36000, '0'),
(37, 'AEDT', '8007782400', 39600, '1'),
(37, 'AEST', '8023507200', 36000, '0'),
(37, 'AEDT', '8039232000', 39600, '1'),
(37, 'AEST', '8054956800', 36000, '0'),
(37, 'AEDT', '8070681600', 39600, '1'),
(37, 'AEST', '8086406400', 36000, '0'),
(37, 'AEDT', '8102131200', 39600, '1'),
(37, 'AEST', '8117856000', 36000, '0'),
(37, 'AEDT', '8134185600', 39600, '1'),
(37, 'AEST', '8149910400', 36000, '0'),
(37, 'AEDT', '8165635200', 39600, '1'),
(37, 'AEST', '8181360000', 36000, '0'),
(37, 'AEDT', '8197084800', 39600, '1'),
(37, 'AEST', '8212809600', 36000, '0'),
(37, 'AEDT', '8228534400', 39600, '1'),
(37, 'AEST', '8244259200', 36000, '0'),
(37, 'AEDT', '8259984000', 39600, '1'),
(37, 'AEST', '8275708800', 36000, '0'),
(37, 'AEDT', '8292038400', 39600, '1'),
(37, 'AEST', '8307763200', 36000, '0'),
(37, 'AEDT', '8323488000', 39600, '1'),
(37, 'AEST', '8339212800', 36000, '0'),
(37, 'AEDT', '8354937600', 39600, '1'),
(37, 'AEST', '8370662400', 36000, '0'),
(37, 'AEDT', '8386387200', 39600, '1'),
(37, 'AEST', '8402112000', 36000, '0'),
(37, 'AEDT', '8417836800', 39600, '1'),
(37, 'AEST', '8433561600', 36000, '0'),
(37, 'AEDT', '8449286400', 39600, '1'),
(37, 'AEST', '8465011200', 36000, '0'),
(37, 'AEDT', '8481340800', 39600, '1'),
(37, 'AEST', '8497065600', 36000, '0'),
(37, 'AEDT', '8512790400', 39600, '1'),
(37, 'AEST', '8528515200', 36000, '0'),
(37, 'AEDT', '8544240000', 39600, '1'),
(37, 'AEST', '8559964800', 36000, '0'),
(37, 'AEDT', '8575689600', 39600, '1'),
(37, 'AEST', '8591414400', 36000, '0'),
(37, 'AEDT', '8607139200', 39600, '1'),
(37, 'AEST', '8622864000', 36000, '0'),
(37, 'AEDT', '8638588800', 39600, '1'),
(37, 'AEST', '8654918400', 36000, '0'),
(37, 'AEDT', '8670643200', 39600, '1'),
(37, 'AEST', '8686368000', 36000, '0'),
(37, 'AEDT', '8702092800', 39600, '1'),
(37, 'AEST', '8717817600', 36000, '0'),
(37, 'AEDT', '8733542400', 39600, '1'),
(37, 'AEST', '8749267200', 36000, '0'),
(37, 'AEDT', '8764992000', 39600, '1'),
(37, 'AEST', '8780716800', 36000, '0'),
(37, 'AEDT', '8796441600', 39600, '1'),
(37, 'AEST', '8812166400', 36000, '0'),
(37, 'AEDT', '8828496000', 39600, '1'),
(37, 'AEST', '8844220800', 36000, '0'),
(37, 'AEDT', '8859945600', 39600, '1'),
(37, 'AEST', '8875670400', 36000, '0'),
(37, 'AEDT', '8891395200', 39600, '1'),
(37, 'AEST', '8907120000', 36000, '0'),
(37, 'AEDT', '8922844800', 39600, '1'),
(37, 'AEST', '8938569600', 36000, '0'),
(37, 'AEDT', '8954294400', 39600, '1'),
(37, 'AEST', '8970019200', 36000, '0'),
(37, 'AEDT', '8985744000', 39600, '1'),
(37, 'AEST', '9001468800', 36000, '0'),
(37, 'AEDT', '9017798400', 39600, '1'),
(37, 'AEST', '9033523200', 36000, '0'),
(37, 'AEDT', '9049248000', 39600, '1'),
(37, 'AEST', '9064972800', 36000, '0'),
(37, 'AEDT', '9080697600', 39600, '1'),
(37, 'AEST', '9096422400', 36000, '0'),
(37, 'AEDT', '9112147200', 39600, '1'),
(37, 'AEST', '9127872000', 36000, '0'),
(37, 'AEDT', '9143596800', 39600, '1'),
(37, 'AEST', '9159321600', 36000, '0'),
(37, 'AEDT', '9175651200', 39600, '1'),
(37, 'AEST', '9191376000', 36000, '0'),
(37, 'AEDT', '9207100800', 39600, '1'),
(37, 'AEST', '9222825600', 36000, '0'),
(37, 'AEDT', '9238550400', 39600, '1'),
(37, 'AEST', '9254275200', 36000, '0'),
(37, 'AEDT', '9270000000', 39600, '1'),
(37, 'AEST', '9285724800', 36000, '0'),
(37, 'AEDT', '9301449600', 39600, '1'),
(37, 'AEST', '9317174400', 36000, '0'),
(37, 'AEDT', '9332899200', 39600, '1'),
(37, 'AEST', '9348624000', 36000, '0'),
(37, 'AEDT', '9364953600', 39600, '1'),
(37, 'AEST', '9380678400', 36000, '0'),
(37, 'AEDT', '9396403200', 39600, '1'),
(37, 'AEST', '9412128000', 36000, '0'),
(37, 'AEDT', '9427852800', 39600, '1'),
(37, 'AEST', '9443577600', 36000, '0'),
(37, 'AEDT', '9459302400', 39600, '1'),
(37, 'AEST', '9475027200', 36000, '0'),
(37, 'AEDT', '9490752000', 39600, '1'),
(37, 'AEST', '9506476800', 36000, '0'),
(37, 'AEDT', '9522201600', 39600, '1'),
(37, 'AEST', '9538531200', 36000, '0'),
(37, 'AEDT', '9554256000', 39600, '1'),
(37, 'AEST', '9569980800', 36000, '0'),
(37, 'AEDT', '9585705600', 39600, '1'),
(37, 'AEST', '9601430400', 36000, '0'),
(37, 'AEDT', '9617155200', 39600, '1'),
(37, 'AEST', '9632880000', 36000, '0'),
(37, 'AEDT', '9648604800', 39600, '1'),
(37, 'AEST', '9664329600', 36000, '0'),
(37, 'AEDT', '9680054400', 39600, '1'),
(37, 'AEST', '9695779200', 36000, '0'),
(37, 'AEDT', '9712108800', 39600, '1'),
(37, 'AEST', '9727833600', 36000, '0'),
(37, 'AEDT', '9743558400', 39600, '1'),
(37, 'AEST', '9759283200', 36000, '0'),
(37, 'AEDT', '9775008000', 39600, '1'),
(37, 'AEST', '9790732800', 36000, '0'),
(37, 'AEDT', '9806457600', 39600, '1'),
(37, 'AEST', '9822182400', 36000, '0'),
(37, 'AEDT', '9837907200', 39600, '1'),
(37, 'AEST', '9853632000', 36000, '0'),
(37, 'AEDT', '9869356800', 39600, '1'),
(37, 'AEST', '9885081600', 36000, '0'),
(37, 'AEDT', '9901411200', 39600, '1'),
(37, 'AEST', '9917136000', 36000, '0'),
(37, 'AEDT', '9932860800', 39600, '1'),
(37, 'AEST', '9948585600', 36000, '0'),
(37, 'AEDT', '9964310400', 39600, '1'),
(37, 'AEST', '9980035200', 36000, '0'),
(37, 'AEDT', '9995760000', 39600, '1'),
(37, 'AEST', '10011484800', 36000, '0'),
(37, 'AEDT', '10027209600', 39600, '1'),
(37, 'AEST', '10042934400', 36000, '0'),
(37, 'AEDT', '10059264000', 39600, '1'),
(37, 'AEST', '10074988800', 36000, '0'),
(37, 'AEDT', '10090713600', 39600, '1'),
(37, 'AEST', '10106438400', 36000, '0'),
(37, 'AEDT', '10122163200', 39600, '1'),
(37, 'AEST', '10137888000', 36000, '0'),
(37, 'AEDT', '10153612800', 39600, '1'),
(37, 'AEST', '10169337600', 36000, '0'),
(37, 'AEDT', '10185062400', 39600, '1'),
(37, 'AEST', '10200787200', 36000, '0'),
(37, 'AEDT', '10216512000', 39600, '1'),
(37, 'AEST', '10232236800', 36000, '0'),
(37, 'AEDT', '10248566400', 39600, '1'),
(37, 'AEST', '10264291200', 36000, '0'),
(37, 'AEDT', '10280016000', 39600, '1'),
(37, 'AEST', '10295740800', 36000, '0'),
(37, 'AEDT', '10311465600', 39600, '1'),
(37, 'AEST', '10327190400', 36000, '0'),
(37, 'AEDT', '10342915200', 39600, '1'),
(37, 'AEST', '10358640000', 36000, '0'),
(37, 'AEDT', '10374364800', 39600, '1'),
(37, 'AEST', '10390089600', 36000, '0'),
(37, 'AEDT', '10405814400', 39600, '1'),
(37, 'AEST', '10421539200', 36000, '0'),
(37, 'AEDT', '10437868800', 39600, '1'),
(37, 'AEST', '10453593600', 36000, '0'),
(37, 'AEDT', '10469318400', 39600, '1'),
(37, 'AEST', '10485043200', 36000, '0'),
(37, 'AEDT', '10500768000', 39600, '1'),
(37, 'AEST', '10516492800', 36000, '0'),
(37, 'AEDT', '10532217600', 39600, '1'),
(37, 'AEST', '10547942400', 36000, '0'),
(37, 'AEDT', '10563667200', 39600, '1'),
(37, 'AEST', '10579392000', 36000, '0'),
(37, 'AEDT', '10595116800', 39600, '1'),
(37, 'AEST', '10610841600', 36000, '0'),
(37, 'AEDT', '10627171200', 39600, '1'),
(37, 'AEST', '10642896000', 36000, '0'),
(37, 'AEDT', '10658620800', 39600, '1'),
(37, 'AEST', '10674345600', 36000, '0'),
(37, 'AEDT', '10690070400', 39600, '1'),
(37, 'AEST', '10705795200', 36000, '0'),
(37, 'AEDT', '10721520000', 39600, '1'),
(37, 'AEST', '10737244800', 36000, '0'),
(37, 'AEDT', '10752969600', 39600, '1'),
(37, 'AEST', '10768694400', 36000, '0'),
(37, 'AEDT', '10784419200', 39600, '1'),
(37, 'AEST', '10800748800', 36000, '0'),
(37, 'AEDT', '10816473600', 39600, '1'),
(37, 'AEST', '10832198400', 36000, '0'),
(37, 'AEDT', '10847923200', 39600, '1'),
(37, 'AEST', '10863648000', 36000, '0'),
(37, 'AEDT', '10879372800', 39600, '1'),
(37, 'AEST', '10895097600', 36000, '0'),
(37, 'AEDT', '10910822400', 39600, '1'),
(37, 'AEST', '10926547200', 36000, '0'),
(37, 'AEDT', '10942272000', 39600, '1'),
(37, 'AEST', '10957996800', 36000, '0'),
(37, 'AEDT', '10974326400', 39600, '1'),
(37, 'AEST', '10990051200', 36000, '0'),
(37, 'AEDT', '11005776000', 39600, '1'),
(37, 'AEST', '11021500800', 36000, '0'),
(37, 'AEDT', '11037225600', 39600, '1'),
(37, 'AEST', '11052950400', 36000, '0'),
(37, 'AEDT', '11068675200', 39600, '1'),
(37, 'AEST', '11084400000', 36000, '0'),
(37, 'AEDT', '11100124800', 39600, '1'),
(37, 'AEST', '11115849600', 36000, '0'),
(37, 'AEDT', '11131574400', 39600, '1'),
(37, 'AEST', '11147299200', 36000, '0'),
(37, 'AEDT', '11163628800', 39600, '1'),
(37, 'AEST', '11179353600', 36000, '0'),
(37, 'AEDT', '11195078400', 39600, '1'),
(37, 'AEST', '11210803200', 36000, '0'),
(37, 'AEDT', '11226528000', 39600, '1'),
(37, 'AEST', '11242252800', 36000, '0'),
(37, 'AEDT', '11257977600', 39600, '1'),
(37, 'AEST', '11273702400', 36000, '0'),
(37, 'AEDT', '11289427200', 39600, '1'),
(37, 'AEST', '11305152000', 36000, '0'),
(37, 'AEDT', '11321481600', 39600, '1'),
(37, 'AEST', '11337206400', 36000, '0'),
(37, 'AEDT', '11352931200', 39600, '1'),
(37, 'AEST', '11368656000', 36000, '0'),
(37, 'AEDT', '11384380800', 39600, '1'),
(37, 'AEST', '11400105600', 36000, '0'),
(37, 'AEDT', '11415830400', 39600, '1'),
(37, 'AEST', '11431555200', 36000, '0'),
(37, 'AEDT', '11447280000', 39600, '1'),
(37, 'AEST', '11463004800', 36000, '0'),
(37, 'AEDT', '11478729600', 39600, '1'),
(37, 'AEST', '11494454400', 36000, '0'),
(37, 'AEDT', '11510784000', 39600, '1'),
(37, 'AEST', '11526508800', 36000, '0'),
(37, 'AEDT', '11542233600', 39600, '1'),
(37, 'AEST', '11557958400', 36000, '0'),
(37, 'AEDT', '11573683200', 39600, '1'),
(37, 'AEST', '11589408000', 36000, '0'),
(37, 'AEDT', '11605132800', 39600, '1'),
(37, 'AEST', '11620857600', 36000, '0'),
(37, 'AEDT', '11636582400', 39600, '1'),
(37, 'AEST', '11652307200', 36000, '0'),
(37, 'AEDT', '11668032000', 39600, '1'),
(37, 'AEST', '11684361600', 36000, '0'),
(37, 'AEDT', '11700086400', 39600, '1'),
(37, 'AEST', '11715811200', 36000, '0'),
(37, 'AEDT', '11731536000', 39600, '1'),
(37, 'AEST', '11747260800', 36000, '0'),
(37, 'AEDT', '11762985600', 39600, '1'),
(37, 'AEST', '11778710400', 36000, '0'),
(37, 'AEDT', '11794435200', 39600, '1'),
(37, 'AEST', '11810160000', 36000, '0'),
(37, 'AEDT', '11825884800', 39600, '1'),
(37, 'AEST', '11841609600', 36000, '0'),
(37, 'AEDT', '11857939200', 39600, '1'),
(37, 'AEST', '11873664000', 36000, '0'),
(37, 'AEDT', '11889388800', 39600, '1'),
(37, 'AEST', '11905113600', 36000, '0'),
(37, 'AEDT', '11920838400', 39600, '1'),
(37, 'AEST', '11936563200', 36000, '0'),
(37, 'AEDT', '11952288000', 39600, '1'),
(37, 'AEST', '11968012800', 36000, '0'),
(37, 'AEDT', '11983737600', 39600, '1'),
(37, 'AEST', '11999462400', 36000, '0'),
(37, 'AEDT', '12015187200', 39600, '1'),
(37, 'AEST', '12030912000', 36000, '0'),
(37, 'AEDT', '12047241600', 39600, '1'),
(37, 'AEST', '12062966400', 36000, '0'),
(37, 'AEDT', '12078691200', 39600, '1'),
(37, 'AEST', '12094416000', 36000, '0'),
(37, 'AEDT', '12110140800', 39600, '1'),
(37, 'AEST', '12125865600', 36000, '0'),
(37, 'AEDT', '12141590400', 39600, '1'),
(37, 'AEST', '12157315200', 36000, '0'),
(37, 'AEDT', '12173040000', 39600, '1'),
(37, 'AEST', '12188764800', 36000, '0'),
(37, 'AEDT', '12205094400', 39600, '1'),
(37, 'AEST', '12220819200', 36000, '0'),
(37, 'AEDT', '12236544000', 39600, '1'),
(37, 'AEST', '12252268800', 36000, '0'),
(37, 'AEDT', '12267993600', 39600, '1'),
(37, 'AEST', '12283718400', 36000, '0'),
(37, 'AEDT', '12299443200', 39600, '1'),
(37, 'AEST', '12315168000', 36000, '0'),
(37, 'AEDT', '12330892800', 39600, '1'),
(37, 'AEST', '12346617600', 36000, '0'),
(37, 'AEDT', '12362342400', 39600, '1'),
(37, 'AEST', '12378067200', 36000, '0'),
(37, 'AEDT', '12394396800', 39600, '1'),
(37, 'AEST', '12410121600', 36000, '0'),
(37, 'AEDT', '12425846400', 39600, '1'),
(37, 'AEST', '12441571200', 36000, '0'),
(37, 'AEDT', '12457296000', 39600, '1'),
(37, 'AEST', '12473020800', 36000, '0'),
(37, 'AEDT', '12488745600', 39600, '1'),
(37, 'AEST', '12504470400', 36000, '0'),
(37, 'AEDT', '12520195200', 39600, '1'),
(37, 'AEST', '12535920000', 36000, '0'),
(37, 'AEDT', '12551644800', 39600, '1'),
(37, 'AEST', '12567974400', 36000, '0'),
(37, 'AEDT', '12583699200', 39600, '1'),
(37, 'AEST', '12599424000', 36000, '0'),
(37, 'AEDT', '12615148800', 39600, '1'),
(37, 'AEST', '12630873600', 36000, '0'),
(37, 'AEDT', '12646598400', 39600, '1'),
(37, 'AEST', '12662323200', 36000, '0'),
(37, 'AEDT', '12678048000', 39600, '1'),
(37, 'AEST', '12693772800', 36000, '0'),
(37, 'AEDT', '12709497600', 39600, '1'),
(37, 'AEST', '12725222400', 36000, '0'),
(37, 'AEDT', '12741552000', 39600, '1'),
(37, 'AEST', '12757276800', 36000, '0'),
(37, 'AEDT', '12773001600', 39600, '1'),
(37, 'AEST', '12788726400', 36000, '0'),
(37, 'AEDT', '12804451200', 39600, '1'),
(37, 'AEST', '12820176000', 36000, '0'),
(37, 'AEDT', '12835900800', 39600, '1'),
(37, 'AEST', '12851625600', 36000, '0'),
(37, 'AEDT', '12867350400', 39600, '1'),
(37, 'AEST', '12883075200', 36000, '0'),
(37, 'AEDT', '12898800000', 39600, '1'),
(37, 'AEST', '12914524800', 36000, '0'),
(37, 'AEDT', '12930854400', 39600, '1'),
(37, 'AEST', '12946579200', 36000, '0'),
(37, 'AEDT', '12962304000', 39600, '1'),
(37, 'AEST', '12978028800', 36000, '0'),
(37, 'AEDT', '12993753600', 39600, '1'),
(37, 'AEST', '13009478400', 36000, '0'),
(37, 'AEDT', '13025203200', 39600, '1'),
(37, 'AEST', '13040928000', 36000, '0'),
(37, 'AEDT', '13056652800', 39600, '1'),
(37, 'AEST', '13072377600', 36000, '0'),
(37, 'AEDT', '13088707200', 39600, '1'),
(37, 'AEST', '13104432000', 36000, '0'),
(37, 'AEDT', '13120156800', 39600, '1'),
(37, 'AEST', '13135881600', 36000, '0'),
(37, 'AEDT', '13151606400', 39600, '1'),
(37, 'AEST', '13167331200', 36000, '0'),
(37, 'AEDT', '13183056000', 39600, '1'),
(37, 'AEST', '13198780800', 36000, '0'),
(37, 'AEDT', '13214505600', 39600, '1'),
(37, 'AEST', '13230230400', 36000, '0'),
(37, 'AEDT', '13245955200', 39600, '1'),
(37, 'AEST', '13261680000', 36000, '0'),
(37, 'AEDT', '13278009600', 39600, '1'),
(37, 'AEST', '13293734400', 36000, '0'),
(37, 'AEDT', '13309459200', 39600, '1'),
(37, 'AEST', '13325184000', 36000, '0'),
(37, 'AEDT', '13340908800', 39600, '1'),
(37, 'AEST', '13356633600', 36000, '0'),
(37, 'AEDT', '13372358400', 39600, '1'),
(37, 'AEST', '13388083200', 36000, '0'),
(37, 'AEDT', '13403808000', 39600, '1'),
(37, 'AEST', '13419532800', 36000, '0'),
(37, 'AEDT', '13435257600', 39600, '1'),
(37, 'AEST', '13451587200', 36000, '0'),
(37, 'AEDT', '13467312000', 39600, '1'),
(37, 'AEST', '13483036800', 36000, '0'),
(37, 'AEDT', '13498761600', 39600, '1'),
(37, 'AEST', '13514486400', 36000, '0'),
(37, 'AEDT', '13530211200', 39600, '1'),
(37, 'AEST', '13545936000', 36000, '0'),
(37, 'AEDT', '13561660800', 39600, '1'),
(37, 'AEST', '13577385600', 36000, '0'),
(37, 'AEDT', '13593110400', 39600, '1'),
(37, 'AEST', '13608835200', 36000, '0'),
(37, 'AEDT', '13625164800', 39600, '1'),
(37, 'AEST', '13640889600', 36000, '0'),
(37, 'AEDT', '13656614400', 39600, '1'),
(37, 'AEST', '13672339200', 36000, '0'),
(37, 'AEDT', '13688064000', 39600, '1'),
(37, 'AEST', '13703788800', 36000, '0'),
(37, 'AEDT', '13719513600', 39600, '1'),
(37, 'AEST', '13735238400', 36000, '0'),
(37, 'AEDT', '13750963200', 39600, '1'),
(37, 'AEST', '13766688000', 36000, '0'),
(37, 'AEDT', '13782412800', 39600, '1'),
(37, 'AEST', '13798137600', 36000, '0'),
(37, 'AEDT', '13814467200', 39600, '1'),
(37, 'AEST', '13830192000', 36000, '0'),
(37, 'AEDT', '13845916800', 39600, '1'),
(37, 'AEST', '13861641600', 36000, '0'),
(37, 'AEDT', '13877366400', 39600, '1'),
(37, 'AEST', '13893091200', 36000, '0'),
(37, 'AEDT', '13908816000', 39600, '1'),
(37, 'AEST', '13924540800', 36000, '0'),
(37, 'AEDT', '13940265600', 39600, '1'),
(37, 'AEST', '13955990400', 36000, '0'),
(37, 'AEDT', '13972320000', 39600, '1'),
(37, 'AEST', '13988044800', 36000, '0'),
(37, 'AEDT', '14003769600', 39600, '1'),
(37, 'AEST', '14019494400', 36000, '0'),
(37, 'AEDT', '14035219200', 39600, '1'),
(37, 'AEST', '14050944000', 36000, '0'),
(37, 'AEDT', '14066668800', 39600, '1'),
(37, 'AEST', '14082393600', 36000, '0'),
(37, 'AEDT', '14098118400', 39600, '1'),
(37, 'AEST', '14113843200', 36000, '0'),
(37, 'AEDT', '14129568000', 39600, '1'),
(37, 'AEST', '14145292800', 36000, '0'),
(37, 'AEDT', '14161622400', 39600, '1'),
(37, 'AEST', '14177347200', 36000, '0'),
(37, 'AEDT', '14193072000', 39600, '1'),
(37, 'AEST', '14208796800', 36000, '0'),
(37, 'AEDT', '14224521600', 39600, '1'),
(37, 'AEST', '14240246400', 36000, '0'),
(37, 'AEDT', '14255971200', 39600, '1'),
(37, 'AEST', '14271696000', 36000, '0'),
(37, 'AEDT', '14287420800', 39600, '1'),
(37, 'AEST', '14303145600', 36000, '0'),
(37, 'AEDT', '14318870400', 39600, '1'),
(37, 'AEST', '14335200000', 36000, '0'),
(37, 'AEDT', '14350924800', 39600, '1'),
(37, 'AEST', '14366649600', 36000, '0'),
(37, 'AEDT', '14382374400', 39600, '1'),
(37, 'AEST', '14398099200', 36000, '0'),
(37, 'AEDT', '14413824000', 39600, '1'),
(37, 'AEST', '14429548800', 36000, '0'),
(37, 'AEDT', '14445273600', 39600, '1'),
(37, 'AEST', '14460998400', 36000, '0'),
(37, 'AEDT', '14476723200', 39600, '1'),
(37, 'AEST', '14492448000', 36000, '0'),
(37, 'AEDT', '14508777600', 39600, '1'),
(37, 'AEST', '14524502400', 36000, '0'),
(37, 'AEDT', '14540227200', 39600, '1'),
(37, 'AEST', '14555952000', 36000, '0'),
(37, 'AEDT', '14571676800', 39600, '1'),
(37, 'AEST', '14587401600', 36000, '0'),
(37, 'AEDT', '14603126400', 39600, '1'),
(37, 'AEST', '14618851200', 36000, '0'),
(37, 'AEDT', '14634576000', 39600, '1'),
(37, 'AEST', '14650300800', 36000, '0'),
(37, 'AEDT', '14666025600', 39600, '1'),
(37, 'AEST', '14681750400', 36000, '0'),
(37, 'AEDT', '14698080000', 39600, '1'),
(37, 'AEST', '14713804800', 36000, '0'),
(37, 'AEDT', '14729529600', 39600, '1'),
(37, 'AEST', '14745254400', 36000, '0'),
(37, 'AEDT', '14760979200', 39600, '1'),
(37, 'AEST', '14776704000', 36000, '0'),
(37, 'AEDT', '14792428800', 39600, '1'),
(37, 'AEST', '14808153600', 36000, '0'),
(37, 'AEDT', '14823878400', 39600, '1'),
(37, 'AEST', '14839603200', 36000, '0'),
(37, 'AEDT', '14855932800', 39600, '1'),
(37, 'AEST', '14871657600', 36000, '0'),
(37, 'AEDT', '14887382400', 39600, '1'),
(37, 'AEST', '14903107200', 36000, '0'),
(37, 'AEDT', '14918832000', 39600, '1'),
(37, 'AEST', '14934556800', 36000, '0'),
(37, 'AEDT', '14950281600', 39600, '1'),
(37, 'AEST', '14966006400', 36000, '0'),
(37, 'AEDT', '14981731200', 39600, '1'),
(37, 'AEST', '14997456000', 36000, '0'),
(37, 'AEDT', '15013180800', 39600, '1'),
(37, 'AEST', '15028905600', 36000, '0'),
(37, 'AEDT', '15045235200', 39600, '1'),
(37, 'AEST', '15060960000', 36000, '0'),
(37, 'AEDT', '15076684800', 39600, '1'),
(37, 'AEST', '15092409600', 36000, '0'),
(37, 'AEDT', '15108134400', 39600, '1'),
(37, 'AEST', '15123859200', 36000, '0'),
(37, 'AEDT', '15139584000', 39600, '1'),
(37, 'AEST', '15155308800', 36000, '0'),
(37, 'AEDT', '15171033600', 39600, '1'),
(37, 'AEST', '15186758400', 36000, '0'),
(37, 'AEDT', '15202483200', 39600, '1'),
(37, 'AEST', '15218812800', 36000, '0'),
(37, 'AEDT', '15234537600', 39600, '1'),
(37, 'AEST', '15250262400', 36000, '0'),
(37, 'AEDT', '15265987200', 39600, '1'),
(37, 'AEST', '15281712000', 36000, '0'),
(37, 'AEDT', '15297436800', 39600, '1'),
(37, 'AEST', '15313161600', 36000, '0'),
(37, 'AEDT', '15328886400', 39600, '1'),
(37, 'AEST', '15344611200', 36000, '0'),
(37, 'AEDT', '15360336000', 39600, '1'),
(37, 'AEST', '15376060800', 36000, '0'),
(37, 'AEDT', '15392390400', 39600, '1'),
(37, 'AEST', '15408115200', 36000, '0'),
(37, 'AEDT', '15423840000', 39600, '1'),
(37, 'AEST', '15439564800', 36000, '0'),
(37, 'AEDT', '15455289600', 39600, '1'),
(37, 'AEST', '15471014400', 36000, '0'),
(37, 'AEDT', '15486739200', 39600, '1'),
(37, 'AEST', '15502464000', 36000, '0'),
(37, 'AEDT', '15518188800', 39600, '1'),
(37, 'AEST', '15533913600', 36000, '0'),
(37, 'AEDT', '15549638400', 39600, '1'),
(37, 'AEST', '15565363200', 36000, '0'),
(37, 'AEDT', '15581692800', 39600, '1'),
(37, 'AEST', '15597417600', 36000, '0'),
(37, 'AEDT', '15613142400', 39600, '1'),
(37, 'AEST', '15628867200', 36000, '0'),
(37, 'AEDT', '15644592000', 39600, '1'),
(37, 'AEST', '15660316800', 36000, '0'),
(37, 'AEDT', '15676041600', 39600, '1'),
(37, 'AEST', '15691766400', 36000, '0'),
(37, 'AEDT', '15707491200', 39600, '1'),
(37, 'AEST', '15723216000', 36000, '0'),
(37, 'AEDT', '15739545600', 39600, '1'),
(37, 'AEST', '15755270400', 36000, '0'),
(37, 'AEDT', '15770995200', 39600, '1'),
(37, 'AEST', '15786720000', 36000, '0'),
(37, 'AEDT', '15802444800', 39600, '1'),
(37, 'AEST', '15818169600', 36000, '0'),
(37, 'AEDT', '15833894400', 39600, '1'),
(37, 'AEST', '15849619200', 36000, '0'),
(37, 'AEDT', '15865344000', 39600, '1'),
(37, 'AEST', '15881068800', 36000, '0'),
(37, 'AEDT', '15896793600', 39600, '1'),
(37, 'AEST', '15912518400', 36000, '0'),
(37, 'AEDT', '15928848000', 39600, '1'),
(37, 'AEST', '15944572800', 36000, '0'),
(37, 'AEDT', '15960297600', 39600, '1'),
(37, 'AEST', '15976022400', 36000, '0'),
(37, 'AEDT', '15991747200', 39600, '1'),
(37, 'AEST', '16007472000', 36000, '0'),
(37, 'AEDT', '16023196800', 39600, '1'),
(37, 'AEST', '16038921600', 36000, '0'),
(37, 'AEDT', '16054646400', 39600, '1'),
(37, 'AEST', '16070371200', 36000, '0'),
(37, 'AEDT', '16086096000', 39600, '1'),
(37, 'AEST', '16102425600', 36000, '0'),
(37, 'AEDT', '16118150400', 39600, '1'),
(37, 'AEST', '16133875200', 36000, '0'),
(37, 'AEDT', '16149600000', 39600, '1'),
(37, 'AEST', '16165324800', 36000, '0'),
(37, 'AEDT', '16181049600', 39600, '1'),
(37, 'AEST', '16196774400', 36000, '0'),
(37, 'AEDT', '16212499200', 39600, '1'),
(37, 'AEST', '16228224000', 36000, '0'),
(37, 'AEDT', '16243948800', 39600, '1'),
(37, 'AEST', '16259673600', 36000, '0'),
(37, 'AEDT', '16276003200', 39600, '1'),
(37, 'AEST', '16291728000', 36000, '0'),
(37, 'AEDT', '16307452800', 39600, '1'),
(37, 'AEST', '16323177600', 36000, '0'),
(37, 'AEDT', '16338902400', 39600, '1'),
(37, 'AEST', '16354627200', 36000, '0'),
(37, 'AEDT', '16370352000', 39600, '1'),
(37, 'AEST', '16386076800', 36000, '0'),
(37, 'AEDT', '16401801600', 39600, '1'),
(37, 'AEST', '16417526400', 36000, '0'),
(37, 'AEDT', '16433251200', 39600, '1'),
(37, 'AEST', '16448976000', 36000, '0'),
(37, 'AEDT', '16465305600', 39600, '1'),
(37, 'AEST', '16481030400', 36000, '0'),
(37, 'AEDT', '16496755200', 39600, '1'),
(37, 'AEST', '16512480000', 36000, '0'),
(37, 'AEDT', '16528204800', 39600, '1'),
(37, 'AEST', '16543929600', 36000, '0'),
(37, 'AEDT', '16559654400', 39600, '1'),
(37, 'AEST', '16575379200', 36000, '0'),
(37, 'AEDT', '16591104000', 39600, '1'),
(37, 'AEST', '16606828800', 36000, '0'),
(37, 'AEDT', '16623158400', 39600, '1'),
(37, 'AEST', '16638883200', 36000, '0'),
(37, 'AEDT', '16654608000', 39600, '1'),
(37, 'AEST', '16670332800', 36000, '0'),
(37, 'AEDT', '16686057600', 39600, '1'),
(37, 'AEST', '16701782400', 36000, '0'),
(37, 'AEDT', '16717507200', 39600, '1'),
(38, 'LMT', '-2364113093', 36292, '0'),
(38, 'AEST', '-2364113092', 36000, '0'),
(38, 'AEDT', '-1672567140', 39600, '1'),
(38, 'AEST', '-1665392400', 36000, '0'),
(38, 'AEDT', '-883641600', 39600, '1'),
(38, 'AEST', '-876128400', 36000, '0'),
(38, 'AEDT', '-860400000', 39600, '1'),
(38, 'AEST', '-844678800', 36000, '0'),
(38, 'AEDT', '-828345600', 39600, '1'),
(38, 'AEST', '-813229200', 36000, '0'),
(38, 'AEDT', '57686400', 39600, '1'),
(38, 'AEST', '67968000', 36000, '0'),
(38, 'AEDT', '89136000', 39600, '1'),
(38, 'AEST', '100022400', 36000, '0'),
(38, 'AEDT', '120585600', 39600, '1'),
(38, 'AEST', '131472000', 36000, '0'),
(38, 'AEDT', '152035200', 39600, '1'),
(38, 'AEST', '162921600', 36000, '0'),
(38, 'AEDT', '183484800', 39600, '1'),
(38, 'AEST', '194976000', 36000, '0'),
(38, 'AEDT', '215539200', 39600, '1'),
(38, 'AEST', '226425600', 36000, '0'),
(38, 'AEDT', '246988800', 39600, '1'),
(38, 'AEST', '257875200', 36000, '0'),
(38, 'AEDT', '278438400', 39600, '1'),
(38, 'AEST', '289324800', 36000, '0'),
(38, 'AEDT', '309888000', 39600, '1'),
(38, 'AEST', '320774400', 36000, '0'),
(38, 'AEDT', '341337600', 39600, '1'),
(38, 'AEST', '352224000', 36000, '0'),
(38, 'AEDT', '372787200', 39600, '1'),
(38, 'AEST', '386697600', 36000, '0'),
(38, 'AEDT', '404841600', 39600, '1'),
(38, 'AEST', '415728000', 36000, '0'),
(38, 'AEDT', '436291200', 39600, '1'),
(38, 'AEST', '447177600', 36000, '0'),
(38, 'AEDT', '467740800', 39600, '1'),
(38, 'AEST', '478627200', 36000, '0'),
(38, 'AEDT', '499190400', 39600, '1'),
(38, 'AEST', '511286400', 36000, '0'),
(38, 'AEDT', '530035200', 39600, '1'),
(38, 'AEST', '542736000', 36000, '0'),
(38, 'AEDT', '562089600', 39600, '1'),
(38, 'AEST', '574790400', 36000, '0'),
(38, 'AEDT', '594144000', 39600, '1'),
(38, 'AEST', '606240000', 36000, '0'),
(38, 'AEDT', '625593600', 39600, '1'),
(38, 'AEST', '636480000', 36000, '0'),
(38, 'AEDT', '657043200', 39600, '1'),
(38, 'AEST', '667929600', 36000, '0'),
(38, 'AEDT', '688492800', 39600, '1'),
(38, 'AEST', '699379200', 36000, '0'),
(38, 'AEDT', '719942400', 39600, '1'),
(38, 'AEST', '731433600', 36000, '0'),
(38, 'AEDT', '751996800', 39600, '1'),
(38, 'AEST', '762883200', 36000, '0'),
(38, 'AEDT', '783446400', 39600, '1'),
(38, 'AEST', '794332800', 36000, '0'),
(38, 'AEDT', '814896000', 39600, '1'),
(38, 'AEST', '828201600', 36000, '0'),
(38, 'AEDT', '846345600', 39600, '1'),
(38, 'AEST', '859651200', 36000, '0'),
(38, 'AEDT', '877795200', 39600, '1'),
(38, 'AEST', '891100800', 36000, '0'),
(38, 'AEDT', '909244800', 39600, '1'),
(38, 'AEST', '922550400', 36000, '0'),
(38, 'AEDT', '941299200', 39600, '1'),
(38, 'AEST', '954000000', 36000, '0'),
(38, 'AEDT', '967305600', 39600, '1'),
(38, 'AEST', '985449600', 36000, '0'),
(38, 'AEDT', '1004198400', 39600, '1'),
(38, 'AEST', '1017504000', 36000, '0'),
(38, 'AEDT', '1035648000', 39600, '1'),
(38, 'AEST', '1048953600', 36000, '0'),
(38, 'AEDT', '1067097600', 39600, '1'),
(38, 'AEST', '1080403200', 36000, '0'),
(38, 'AEDT', '1099152000', 39600, '1'),
(38, 'AEST', '1111852800', 36000, '0'),
(38, 'AEDT', '1130601600', 39600, '1'),
(38, 'AEST', '1143907200', 36000, '0'),
(38, 'AEDT', '1162051200', 39600, '1'),
(38, 'AEST', '1174752000', 36000, '0'),
(38, 'AEDT', '1193500800', 39600, '1'),
(38, 'AEST', '1207411200', 36000, '0'),
(38, 'AEDT', '1223136000', 39600, '1'),
(38, 'AEST', '1238860800', 36000, '0'),
(38, 'AEDT', '1254585600', 39600, '1'),
(38, 'AEST', '1270310400', 36000, '0'),
(38, 'AEDT', '1286035200', 39600, '1'),
(38, 'AEST', '1301760000', 36000, '0'),
(38, 'AEDT', '1317484800', 39600, '1'),
(38, 'AEST', '1333209600', 36000, '0'),
(38, 'AEDT', '1349539200', 39600, '1'),
(38, 'AEST', '1365264000', 36000, '0'),
(38, 'AEDT', '1380988800', 39600, '1'),
(38, 'AEST', '1396713600', 36000, '0'),
(38, 'AEDT', '1412438400', 39600, '1'),
(38, 'AEST', '1428163200', 36000, '0'),
(38, 'AEDT', '1443888000', 39600, '1'),
(38, 'AEST', '1459612800', 36000, '0'),
(38, 'AEDT', '1475337600', 39600, '1'),
(38, 'AEST', '1491062400', 36000, '0'),
(38, 'AEDT', '1506787200', 39600, '1'),
(38, 'AEST', '1522512000', 36000, '0'),
(38, 'AEDT', '1538841600', 39600, '1'),
(38, 'AEST', '1554566400', 36000, '0'),
(38, 'AEDT', '1570291200', 39600, '1'),
(38, 'AEST', '1586016000', 36000, '0'),
(38, 'AEDT', '1601740800', 39600, '1'),
(38, 'AEST', '1617465600', 36000, '0'),
(38, 'AEDT', '1633190400', 39600, '1'),
(38, 'AEST', '1648915200', 36000, '0'),
(38, 'AEDT', '1664640000', 39600, '1'),
(38, 'AEST', '1680364800', 36000, '0'),
(38, 'AEDT', '1696089600', 39600, '1'),
(38, 'AEST', '1712419200', 36000, '0'),
(38, 'AEDT', '1728144000', 39600, '1'),
(38, 'AEST', '1743868800', 36000, '0'),
(38, 'AEDT', '1759593600', 39600, '1'),
(38, 'AEST', '1775318400', 36000, '0'),
(38, 'AEDT', '1791043200', 39600, '1'),
(38, 'AEST', '1806768000', 36000, '0'),
(38, 'AEDT', '1822492800', 39600, '1'),
(38, 'AEST', '1838217600', 36000, '0'),
(38, 'AEDT', '1853942400', 39600, '1'),
(38, 'AEST', '1869667200', 36000, '0'),
(38, 'AEDT', '1885996800', 39600, '1'),
(38, 'AEST', '1901721600', 36000, '0'),
(38, 'AEDT', '1917446400', 39600, '1'),
(38, 'AEST', '1933171200', 36000, '0'),
(38, 'AEDT', '1948896000', 39600, '1'),
(38, 'AEST', '1964620800', 36000, '0'),
(38, 'AEDT', '1980345600', 39600, '1'),
(38, 'AEST', '1996070400', 36000, '0'),
(38, 'AEDT', '2011795200', 39600, '1'),
(38, 'AEST', '2027520000', 36000, '0'),
(38, 'AEDT', '2043244800', 39600, '1'),
(38, 'AEST', '2058969600', 36000, '0'),
(38, 'AEDT', '2075299200', 39600, '1'),
(38, 'AEST', '2091024000', 36000, '0'),
(38, 'AEDT', '2106748800', 39600, '1'),
(38, 'AEST', '2122473600', 36000, '0'),
(38, 'AEDT', '2138198400', 39600, '1'),
(38, 'AEST', '2153923200', 36000, '0'),
(38, 'AEDT', '2169648000', 39600, '1'),
(38, 'AEST', '2185372800', 36000, '0'),
(38, 'AEDT', '2201097600', 39600, '1'),
(38, 'AEST', '2216822400', 36000, '0'),
(38, 'AEDT', '2233152000', 39600, '1'),
(38, 'AEST', '2248876800', 36000, '0'),
(38, 'AEDT', '2264601600', 39600, '1'),
(38, 'AEST', '2280326400', 36000, '0'),
(38, 'AEDT', '2296051200', 39600, '1'),
(38, 'AEST', '2311776000', 36000, '0'),
(38, 'AEDT', '2327500800', 39600, '1'),
(38, 'AEST', '2343225600', 36000, '0'),
(38, 'AEDT', '2358950400', 39600, '1'),
(38, 'AEST', '2374675200', 36000, '0'),
(38, 'AEDT', '2390400000', 39600, '1'),
(38, 'AEST', '2406124800', 36000, '0'),
(38, 'AEDT', '2422454400', 39600, '1'),
(38, 'AEST', '2438179200', 36000, '0'),
(38, 'AEDT', '2453904000', 39600, '1'),
(38, 'AEST', '2469628800', 36000, '0'),
(38, 'AEDT', '2485353600', 39600, '1'),
(38, 'AEST', '2501078400', 36000, '0'),
(38, 'AEDT', '2516803200', 39600, '1'),
(38, 'AEST', '2532528000', 36000, '0'),
(38, 'AEDT', '2548252800', 39600, '1'),
(38, 'AEST', '2563977600', 36000, '0'),
(38, 'AEDT', '2579702400', 39600, '1'),
(38, 'AEST', '2596032000', 36000, '0'),
(38, 'AEDT', '2611756800', 39600, '1'),
(38, 'AEST', '2627481600', 36000, '0'),
(38, 'AEDT', '2643206400', 39600, '1'),
(38, 'AEST', '2658931200', 36000, '0'),
(38, 'AEDT', '2674656000', 39600, '1'),
(38, 'AEST', '2690380800', 36000, '0'),
(38, 'AEDT', '2706105600', 39600, '1'),
(38, 'AEST', '2721830400', 36000, '0'),
(38, 'AEDT', '2737555200', 39600, '1'),
(38, 'AEST', '2753280000', 36000, '0'),
(38, 'AEDT', '2769609600', 39600, '1'),
(38, 'AEST', '2785334400', 36000, '0'),
(38, 'AEDT', '2801059200', 39600, '1'),
(38, 'AEST', '2816784000', 36000, '0'),
(38, 'AEDT', '2832508800', 39600, '1'),
(38, 'AEST', '2848233600', 36000, '0'),
(38, 'AEDT', '2863958400', 39600, '1'),
(38, 'AEST', '2879683200', 36000, '0'),
(38, 'AEDT', '2895408000', 39600, '1'),
(38, 'AEST', '2911132800', 36000, '0'),
(38, 'AEDT', '2926857600', 39600, '1'),
(38, 'AEST', '2942582400', 36000, '0'),
(38, 'AEDT', '2958912000', 39600, '1'),
(38, 'AEST', '2974636800', 36000, '0'),
(38, 'AEDT', '2990361600', 39600, '1'),
(38, 'AEST', '3006086400', 36000, '0'),
(38, 'AEDT', '3021811200', 39600, '1'),
(38, 'AEST', '3037536000', 36000, '0'),
(38, 'AEDT', '3053260800', 39600, '1'),
(38, 'AEST', '3068985600', 36000, '0'),
(38, 'AEDT', '3084710400', 39600, '1'),
(38, 'AEST', '3100435200', 36000, '0'),
(38, 'AEDT', '3116764800', 39600, '1'),
(38, 'AEST', '3132489600', 36000, '0'),
(38, 'AEDT', '3148214400', 39600, '1'),
(38, 'AEST', '3163939200', 36000, '0'),
(38, 'AEDT', '3179664000', 39600, '1'),
(38, 'AEST', '3195388800', 36000, '0'),
(38, 'AEDT', '3211113600', 39600, '1'),
(38, 'AEST', '3226838400', 36000, '0'),
(38, 'AEDT', '3242563200', 39600, '1'),
(38, 'AEST', '3258288000', 36000, '0'),
(38, 'AEDT', '3274012800', 39600, '1'),
(38, 'AEST', '3289737600', 36000, '0'),
(38, 'AEDT', '3306067200', 39600, '1'),
(38, 'AEST', '3321792000', 36000, '0'),
(38, 'AEDT', '3337516800', 39600, '1'),
(38, 'AEST', '3353241600', 36000, '0'),
(38, 'AEDT', '3368966400', 39600, '1'),
(38, 'AEST', '3384691200', 36000, '0'),
(38, 'AEDT', '3400416000', 39600, '1'),
(38, 'AEST', '3416140800', 36000, '0'),
(38, 'AEDT', '3431865600', 39600, '1'),
(38, 'AEST', '3447590400', 36000, '0'),
(38, 'AEDT', '3463315200', 39600, '1'),
(38, 'AEST', '3479644800', 36000, '0'),
(38, 'AEDT', '3495369600', 39600, '1'),
(38, 'AEST', '3511094400', 36000, '0'),
(38, 'AEDT', '3526819200', 39600, '1'),
(38, 'AEST', '3542544000', 36000, '0'),
(38, 'AEDT', '3558268800', 39600, '1'),
(38, 'AEST', '3573993600', 36000, '0'),
(38, 'AEDT', '3589718400', 39600, '1'),
(38, 'AEST', '3605443200', 36000, '0'),
(38, 'AEDT', '3621168000', 39600, '1'),
(38, 'AEST', '3636892800', 36000, '0'),
(38, 'AEDT', '3653222400', 39600, '1'),
(38, 'AEST', '3668947200', 36000, '0'),
(38, 'AEDT', '3684672000', 39600, '1'),
(38, 'AEST', '3700396800', 36000, '0'),
(38, 'AEDT', '3716121600', 39600, '1'),
(38, 'AEST', '3731846400', 36000, '0'),
(38, 'AEDT', '3747571200', 39600, '1'),
(38, 'AEST', '3763296000', 36000, '0'),
(38, 'AEDT', '3779020800', 39600, '1'),
(38, 'AEST', '3794745600', 36000, '0'),
(38, 'AEDT', '3810470400', 39600, '1'),
(38, 'AEST', '3826195200', 36000, '0'),
(38, 'AEDT', '3842524800', 39600, '1'),
(38, 'AEST', '3858249600', 36000, '0'),
(38, 'AEDT', '3873974400', 39600, '1'),
(38, 'AEST', '3889699200', 36000, '0'),
(38, 'AEDT', '3905424000', 39600, '1'),
(38, 'AEST', '3921148800', 36000, '0'),
(38, 'AEDT', '3936873600', 39600, '1'),
(38, 'AEST', '3952598400', 36000, '0'),
(38, 'AEDT', '3968323200', 39600, '1'),
(38, 'AEST', '3984048000', 36000, '0'),
(38, 'AEDT', '4000377600', 39600, '1'),
(38, 'AEST', '4016102400', 36000, '0'),
(38, 'AEDT', '4031827200', 39600, '1'),
(38, 'AEST', '4047552000', 36000, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(38, 'AEDT', '4063276800', 39600, '1'),
(38, 'AEST', '4079001600', 36000, '0'),
(38, 'AEDT', '4094726400', 39600, '1'),
(38, 'AEST', '4110451200', 36000, '0'),
(38, 'AEDT', '4126176000', 39600, '1'),
(38, 'AEST', '4141900800', 36000, '0'),
(38, 'AEDT', '4157625600', 39600, '1'),
(38, 'AEST', '4173350400', 36000, '0'),
(38, 'AEDT', '4189075200', 39600, '1'),
(38, 'AEST', '4204800000', 36000, '0'),
(38, 'AEDT', '4221129600', 39600, '1'),
(38, 'AEST', '4236854400', 36000, '0'),
(38, 'AEDT', '4252579200', 39600, '1'),
(38, 'AEST', '4268304000', 36000, '0'),
(38, 'AEDT', '4284028800', 39600, '1'),
(38, 'AEST', '4299753600', 36000, '0'),
(38, 'AEDT', '4315478400', 39600, '1'),
(38, 'AEST', '4331203200', 36000, '0'),
(38, 'AEDT', '4346928000', 39600, '1'),
(38, 'AEST', '4362652800', 36000, '0'),
(38, 'AEDT', '4378982400', 39600, '1'),
(38, 'AEST', '4394707200', 36000, '0'),
(38, 'AEDT', '4410432000', 39600, '1'),
(38, 'AEST', '4426156800', 36000, '0'),
(38, 'AEDT', '4441881600', 39600, '1'),
(38, 'AEST', '4457606400', 36000, '0'),
(38, 'AEDT', '4473331200', 39600, '1'),
(38, 'AEST', '4489056000', 36000, '0'),
(38, 'AEDT', '4504780800', 39600, '1'),
(38, 'AEST', '4520505600', 36000, '0'),
(38, 'AEDT', '4536230400', 39600, '1'),
(38, 'AEST', '4551955200', 36000, '0'),
(38, 'AEDT', '4568284800', 39600, '1'),
(38, 'AEST', '4584009600', 36000, '0'),
(38, 'AEDT', '4599734400', 39600, '1'),
(38, 'AEST', '4615459200', 36000, '0'),
(38, 'AEDT', '4631184000', 39600, '1'),
(38, 'AEST', '4646908800', 36000, '0'),
(38, 'AEDT', '4662633600', 39600, '1'),
(38, 'AEST', '4678358400', 36000, '0'),
(38, 'AEDT', '4694083200', 39600, '1'),
(38, 'AEST', '4709808000', 36000, '0'),
(38, 'AEDT', '4725532800', 39600, '1'),
(38, 'AEST', '4741862400', 36000, '0'),
(38, 'AEDT', '4757587200', 39600, '1'),
(38, 'AEST', '4773312000', 36000, '0'),
(38, 'AEDT', '4789036800', 39600, '1'),
(38, 'AEST', '4804761600', 36000, '0'),
(38, 'AEDT', '4820486400', 39600, '1'),
(38, 'AEST', '4836211200', 36000, '0'),
(38, 'AEDT', '4851936000', 39600, '1'),
(38, 'AEST', '4867660800', 36000, '0'),
(38, 'AEDT', '4883385600', 39600, '1'),
(38, 'AEST', '4899110400', 36000, '0'),
(38, 'AEDT', '4915440000', 39600, '1'),
(38, 'AEST', '4931164800', 36000, '0'),
(38, 'AEDT', '4946889600', 39600, '1'),
(38, 'AEST', '4962614400', 36000, '0'),
(38, 'AEDT', '4978339200', 39600, '1'),
(38, 'AEST', '4994064000', 36000, '0'),
(38, 'AEDT', '5009788800', 39600, '1'),
(38, 'AEST', '5025513600', 36000, '0'),
(38, 'AEDT', '5041238400', 39600, '1'),
(38, 'AEST', '5056963200', 36000, '0'),
(38, 'AEDT', '5072688000', 39600, '1'),
(38, 'AEST', '5088412800', 36000, '0'),
(38, 'AEDT', '5104742400', 39600, '1'),
(38, 'AEST', '5120467200', 36000, '0'),
(38, 'AEDT', '5136192000', 39600, '1'),
(38, 'AEST', '5151916800', 36000, '0'),
(38, 'AEDT', '5167641600', 39600, '1'),
(38, 'AEST', '5183366400', 36000, '0'),
(38, 'AEDT', '5199091200', 39600, '1'),
(38, 'AEST', '5214816000', 36000, '0'),
(38, 'AEDT', '5230540800', 39600, '1'),
(38, 'AEST', '5246265600', 36000, '0'),
(38, 'AEDT', '5262595200', 39600, '1'),
(38, 'AEST', '5278320000', 36000, '0'),
(38, 'AEDT', '5294044800', 39600, '1'),
(38, 'AEST', '5309769600', 36000, '0'),
(38, 'AEDT', '5325494400', 39600, '1'),
(38, 'AEST', '5341219200', 36000, '0'),
(38, 'AEDT', '5356944000', 39600, '1'),
(38, 'AEST', '5372668800', 36000, '0'),
(38, 'AEDT', '5388393600', 39600, '1'),
(38, 'AEST', '5404118400', 36000, '0'),
(38, 'AEDT', '5419843200', 39600, '1'),
(38, 'AEST', '5435568000', 36000, '0'),
(38, 'AEDT', '5451897600', 39600, '1'),
(38, 'AEST', '5467622400', 36000, '0'),
(38, 'AEDT', '5483347200', 39600, '1'),
(38, 'AEST', '5499072000', 36000, '0'),
(38, 'AEDT', '5514796800', 39600, '1'),
(38, 'AEST', '5530521600', 36000, '0'),
(38, 'AEDT', '5546246400', 39600, '1'),
(38, 'AEST', '5561971200', 36000, '0'),
(38, 'AEDT', '5577696000', 39600, '1'),
(38, 'AEST', '5593420800', 36000, '0'),
(38, 'AEDT', '5609145600', 39600, '1'),
(38, 'AEST', '5625475200', 36000, '0'),
(38, 'AEDT', '5641200000', 39600, '1'),
(38, 'AEST', '5656924800', 36000, '0'),
(38, 'AEDT', '5672649600', 39600, '1'),
(38, 'AEST', '5688374400', 36000, '0'),
(38, 'AEDT', '5704099200', 39600, '1'),
(38, 'AEST', '5719824000', 36000, '0'),
(38, 'AEDT', '5735548800', 39600, '1'),
(38, 'AEST', '5751273600', 36000, '0'),
(38, 'AEDT', '5766998400', 39600, '1'),
(38, 'AEST', '5782723200', 36000, '0'),
(38, 'AEDT', '5799052800', 39600, '1'),
(38, 'AEST', '5814777600', 36000, '0'),
(38, 'AEDT', '5830502400', 39600, '1'),
(38, 'AEST', '5846227200', 36000, '0'),
(38, 'AEDT', '5861952000', 39600, '1'),
(38, 'AEST', '5877676800', 36000, '0'),
(38, 'AEDT', '5893401600', 39600, '1'),
(38, 'AEST', '5909126400', 36000, '0'),
(38, 'AEDT', '5924851200', 39600, '1'),
(38, 'AEST', '5940576000', 36000, '0'),
(38, 'AEDT', '5956300800', 39600, '1'),
(38, 'AEST', '5972025600', 36000, '0'),
(38, 'AEDT', '5988355200', 39600, '1'),
(38, 'AEST', '6004080000', 36000, '0'),
(38, 'AEDT', '6019804800', 39600, '1'),
(38, 'AEST', '6035529600', 36000, '0'),
(38, 'AEDT', '6051254400', 39600, '1'),
(38, 'AEST', '6066979200', 36000, '0'),
(38, 'AEDT', '6082704000', 39600, '1'),
(38, 'AEST', '6098428800', 36000, '0'),
(38, 'AEDT', '6114153600', 39600, '1'),
(38, 'AEST', '6129878400', 36000, '0'),
(38, 'AEDT', '6146208000', 39600, '1'),
(38, 'AEST', '6161932800', 36000, '0'),
(38, 'AEDT', '6177657600', 39600, '1'),
(38, 'AEST', '6193382400', 36000, '0'),
(38, 'AEDT', '6209107200', 39600, '1'),
(38, 'AEST', '6224832000', 36000, '0'),
(38, 'AEDT', '6240556800', 39600, '1'),
(38, 'AEST', '6256281600', 36000, '0'),
(38, 'AEDT', '6272006400', 39600, '1'),
(38, 'AEST', '6287731200', 36000, '0'),
(38, 'AEDT', '6303456000', 39600, '1'),
(38, 'AEST', '6319180800', 36000, '0'),
(38, 'AEDT', '6335510400', 39600, '1'),
(38, 'AEST', '6351235200', 36000, '0'),
(38, 'AEDT', '6366960000', 39600, '1'),
(38, 'AEST', '6382684800', 36000, '0'),
(38, 'AEDT', '6398409600', 39600, '1'),
(38, 'AEST', '6414134400', 36000, '0'),
(38, 'AEDT', '6429859200', 39600, '1'),
(38, 'AEST', '6445584000', 36000, '0'),
(38, 'AEDT', '6461308800', 39600, '1'),
(38, 'AEST', '6477033600', 36000, '0'),
(38, 'AEDT', '6492758400', 39600, '1'),
(38, 'AEST', '6509088000', 36000, '0'),
(38, 'AEDT', '6524812800', 39600, '1'),
(38, 'AEST', '6540537600', 36000, '0'),
(38, 'AEDT', '6556262400', 39600, '1'),
(38, 'AEST', '6571987200', 36000, '0'),
(38, 'AEDT', '6587712000', 39600, '1'),
(38, 'AEST', '6603436800', 36000, '0'),
(38, 'AEDT', '6619161600', 39600, '1'),
(38, 'AEST', '6634886400', 36000, '0'),
(38, 'AEDT', '6650611200', 39600, '1'),
(38, 'AEST', '6666336000', 36000, '0'),
(38, 'AEDT', '6682665600', 39600, '1'),
(38, 'AEST', '6698390400', 36000, '0'),
(38, 'AEDT', '6714115200', 39600, '1'),
(38, 'AEST', '6729840000', 36000, '0'),
(38, 'AEDT', '6745564800', 39600, '1'),
(38, 'AEST', '6761289600', 36000, '0'),
(38, 'AEDT', '6777014400', 39600, '1'),
(38, 'AEST', '6792739200', 36000, '0'),
(38, 'AEDT', '6808464000', 39600, '1'),
(38, 'AEST', '6824188800', 36000, '0'),
(38, 'AEDT', '6839913600', 39600, '1'),
(38, 'AEST', '6855638400', 36000, '0'),
(38, 'AEDT', '6871968000', 39600, '1'),
(38, 'AEST', '6887692800', 36000, '0'),
(38, 'AEDT', '6903417600', 39600, '1'),
(38, 'AEST', '6919142400', 36000, '0'),
(38, 'AEDT', '6934867200', 39600, '1'),
(38, 'AEST', '6950592000', 36000, '0'),
(38, 'AEDT', '6966316800', 39600, '1'),
(38, 'AEST', '6982041600', 36000, '0'),
(38, 'AEDT', '6997766400', 39600, '1'),
(38, 'AEST', '7013491200', 36000, '0'),
(38, 'AEDT', '7029820800', 39600, '1'),
(38, 'AEST', '7045545600', 36000, '0'),
(38, 'AEDT', '7061270400', 39600, '1'),
(38, 'AEST', '7076995200', 36000, '0'),
(38, 'AEDT', '7092720000', 39600, '1'),
(38, 'AEST', '7108444800', 36000, '0'),
(38, 'AEDT', '7124169600', 39600, '1'),
(38, 'AEST', '7139894400', 36000, '0'),
(38, 'AEDT', '7155619200', 39600, '1'),
(38, 'AEST', '7171344000', 36000, '0'),
(38, 'AEDT', '7187068800', 39600, '1'),
(38, 'AEST', '7202793600', 36000, '0'),
(38, 'AEDT', '7219123200', 39600, '1'),
(38, 'AEST', '7234848000', 36000, '0'),
(38, 'AEDT', '7250572800', 39600, '1'),
(38, 'AEST', '7266297600', 36000, '0'),
(38, 'AEDT', '7282022400', 39600, '1'),
(38, 'AEST', '7297747200', 36000, '0'),
(38, 'AEDT', '7313472000', 39600, '1'),
(38, 'AEST', '7329196800', 36000, '0'),
(38, 'AEDT', '7344921600', 39600, '1'),
(38, 'AEST', '7360646400', 36000, '0'),
(38, 'AEDT', '7376371200', 39600, '1'),
(38, 'AEST', '7392096000', 36000, '0'),
(38, 'AEDT', '7408425600', 39600, '1'),
(38, 'AEST', '7424150400', 36000, '0'),
(38, 'AEDT', '7439875200', 39600, '1'),
(38, 'AEST', '7455600000', 36000, '0'),
(38, 'AEDT', '7471324800', 39600, '1'),
(38, 'AEST', '7487049600', 36000, '0'),
(38, 'AEDT', '7502774400', 39600, '1'),
(38, 'AEST', '7518499200', 36000, '0'),
(38, 'AEDT', '7534224000', 39600, '1'),
(38, 'AEST', '7549948800', 36000, '0'),
(38, 'AEDT', '7565673600', 39600, '1'),
(38, 'AEST', '7581398400', 36000, '0'),
(38, 'AEDT', '7597728000', 39600, '1'),
(38, 'AEST', '7613452800', 36000, '0'),
(38, 'AEDT', '7629177600', 39600, '1'),
(38, 'AEST', '7644902400', 36000, '0'),
(38, 'AEDT', '7660627200', 39600, '1'),
(38, 'AEST', '7676352000', 36000, '0'),
(38, 'AEDT', '7692076800', 39600, '1'),
(38, 'AEST', '7707801600', 36000, '0'),
(38, 'AEDT', '7723526400', 39600, '1'),
(38, 'AEST', '7739251200', 36000, '0'),
(38, 'AEDT', '7754976000', 39600, '1'),
(38, 'AEST', '7771305600', 36000, '0'),
(38, 'AEDT', '7787030400', 39600, '1'),
(38, 'AEST', '7802755200', 36000, '0'),
(38, 'AEDT', '7818480000', 39600, '1'),
(38, 'AEST', '7834204800', 36000, '0'),
(38, 'AEDT', '7849929600', 39600, '1'),
(38, 'AEST', '7865654400', 36000, '0'),
(38, 'AEDT', '7881379200', 39600, '1'),
(38, 'AEST', '7897104000', 36000, '0'),
(38, 'AEDT', '7912828800', 39600, '1'),
(38, 'AEST', '7928553600', 36000, '0'),
(38, 'AEDT', '7944883200', 39600, '1'),
(38, 'AEST', '7960608000', 36000, '0'),
(38, 'AEDT', '7976332800', 39600, '1'),
(38, 'AEST', '7992057600', 36000, '0'),
(38, 'AEDT', '8007782400', 39600, '1'),
(38, 'AEST', '8023507200', 36000, '0'),
(38, 'AEDT', '8039232000', 39600, '1'),
(38, 'AEST', '8054956800', 36000, '0'),
(38, 'AEDT', '8070681600', 39600, '1'),
(38, 'AEST', '8086406400', 36000, '0'),
(38, 'AEDT', '8102131200', 39600, '1'),
(38, 'AEST', '8117856000', 36000, '0'),
(38, 'AEDT', '8134185600', 39600, '1'),
(38, 'AEST', '8149910400', 36000, '0'),
(38, 'AEDT', '8165635200', 39600, '1'),
(38, 'AEST', '8181360000', 36000, '0'),
(38, 'AEDT', '8197084800', 39600, '1'),
(38, 'AEST', '8212809600', 36000, '0'),
(38, 'AEDT', '8228534400', 39600, '1'),
(38, 'AEST', '8244259200', 36000, '0'),
(38, 'AEDT', '8259984000', 39600, '1'),
(38, 'AEST', '8275708800', 36000, '0'),
(38, 'AEDT', '8292038400', 39600, '1'),
(38, 'AEST', '8307763200', 36000, '0'),
(38, 'AEDT', '8323488000', 39600, '1'),
(38, 'AEST', '8339212800', 36000, '0'),
(38, 'AEDT', '8354937600', 39600, '1'),
(38, 'AEST', '8370662400', 36000, '0'),
(38, 'AEDT', '8386387200', 39600, '1'),
(38, 'AEST', '8402112000', 36000, '0'),
(38, 'AEDT', '8417836800', 39600, '1'),
(38, 'AEST', '8433561600', 36000, '0'),
(38, 'AEDT', '8449286400', 39600, '1'),
(38, 'AEST', '8465011200', 36000, '0'),
(38, 'AEDT', '8481340800', 39600, '1'),
(38, 'AEST', '8497065600', 36000, '0'),
(38, 'AEDT', '8512790400', 39600, '1'),
(38, 'AEST', '8528515200', 36000, '0'),
(38, 'AEDT', '8544240000', 39600, '1'),
(38, 'AEST', '8559964800', 36000, '0'),
(38, 'AEDT', '8575689600', 39600, '1'),
(38, 'AEST', '8591414400', 36000, '0'),
(38, 'AEDT', '8607139200', 39600, '1'),
(38, 'AEST', '8622864000', 36000, '0'),
(38, 'AEDT', '8638588800', 39600, '1'),
(38, 'AEST', '8654918400', 36000, '0'),
(38, 'AEDT', '8670643200', 39600, '1'),
(38, 'AEST', '8686368000', 36000, '0'),
(38, 'AEDT', '8702092800', 39600, '1'),
(38, 'AEST', '8717817600', 36000, '0'),
(38, 'AEDT', '8733542400', 39600, '1'),
(38, 'AEST', '8749267200', 36000, '0'),
(38, 'AEDT', '8764992000', 39600, '1'),
(38, 'AEST', '8780716800', 36000, '0'),
(38, 'AEDT', '8796441600', 39600, '1'),
(38, 'AEST', '8812166400', 36000, '0'),
(38, 'AEDT', '8828496000', 39600, '1'),
(38, 'AEST', '8844220800', 36000, '0'),
(38, 'AEDT', '8859945600', 39600, '1'),
(38, 'AEST', '8875670400', 36000, '0'),
(38, 'AEDT', '8891395200', 39600, '1'),
(38, 'AEST', '8907120000', 36000, '0'),
(38, 'AEDT', '8922844800', 39600, '1'),
(38, 'AEST', '8938569600', 36000, '0'),
(38, 'AEDT', '8954294400', 39600, '1'),
(38, 'AEST', '8970019200', 36000, '0'),
(38, 'AEDT', '8985744000', 39600, '1'),
(38, 'AEST', '9001468800', 36000, '0'),
(38, 'AEDT', '9017798400', 39600, '1'),
(38, 'AEST', '9033523200', 36000, '0'),
(38, 'AEDT', '9049248000', 39600, '1'),
(38, 'AEST', '9064972800', 36000, '0'),
(38, 'AEDT', '9080697600', 39600, '1'),
(38, 'AEST', '9096422400', 36000, '0'),
(38, 'AEDT', '9112147200', 39600, '1'),
(38, 'AEST', '9127872000', 36000, '0'),
(38, 'AEDT', '9143596800', 39600, '1'),
(38, 'AEST', '9159321600', 36000, '0'),
(38, 'AEDT', '9175651200', 39600, '1'),
(38, 'AEST', '9191376000', 36000, '0'),
(38, 'AEDT', '9207100800', 39600, '1'),
(38, 'AEST', '9222825600', 36000, '0'),
(38, 'AEDT', '9238550400', 39600, '1'),
(38, 'AEST', '9254275200', 36000, '0'),
(38, 'AEDT', '9270000000', 39600, '1'),
(38, 'AEST', '9285724800', 36000, '0'),
(38, 'AEDT', '9301449600', 39600, '1'),
(38, 'AEST', '9317174400', 36000, '0'),
(38, 'AEDT', '9332899200', 39600, '1'),
(38, 'AEST', '9348624000', 36000, '0'),
(38, 'AEDT', '9364953600', 39600, '1'),
(38, 'AEST', '9380678400', 36000, '0'),
(38, 'AEDT', '9396403200', 39600, '1'),
(38, 'AEST', '9412128000', 36000, '0'),
(38, 'AEDT', '9427852800', 39600, '1'),
(38, 'AEST', '9443577600', 36000, '0'),
(38, 'AEDT', '9459302400', 39600, '1'),
(38, 'AEST', '9475027200', 36000, '0'),
(38, 'AEDT', '9490752000', 39600, '1'),
(38, 'AEST', '9506476800', 36000, '0'),
(38, 'AEDT', '9522201600', 39600, '1'),
(38, 'AEST', '9538531200', 36000, '0'),
(38, 'AEDT', '9554256000', 39600, '1'),
(38, 'AEST', '9569980800', 36000, '0'),
(38, 'AEDT', '9585705600', 39600, '1'),
(38, 'AEST', '9601430400', 36000, '0'),
(38, 'AEDT', '9617155200', 39600, '1'),
(38, 'AEST', '9632880000', 36000, '0'),
(38, 'AEDT', '9648604800', 39600, '1'),
(38, 'AEST', '9664329600', 36000, '0'),
(38, 'AEDT', '9680054400', 39600, '1'),
(38, 'AEST', '9695779200', 36000, '0'),
(38, 'AEDT', '9712108800', 39600, '1'),
(38, 'AEST', '9727833600', 36000, '0'),
(38, 'AEDT', '9743558400', 39600, '1'),
(38, 'AEST', '9759283200', 36000, '0'),
(38, 'AEDT', '9775008000', 39600, '1'),
(38, 'AEST', '9790732800', 36000, '0'),
(38, 'AEDT', '9806457600', 39600, '1'),
(38, 'AEST', '9822182400', 36000, '0'),
(38, 'AEDT', '9837907200', 39600, '1'),
(38, 'AEST', '9853632000', 36000, '0'),
(38, 'AEDT', '9869356800', 39600, '1'),
(38, 'AEST', '9885081600', 36000, '0'),
(38, 'AEDT', '9901411200', 39600, '1'),
(38, 'AEST', '9917136000', 36000, '0'),
(38, 'AEDT', '9932860800', 39600, '1'),
(38, 'AEST', '9948585600', 36000, '0'),
(38, 'AEDT', '9964310400', 39600, '1'),
(38, 'AEST', '9980035200', 36000, '0'),
(38, 'AEDT', '9995760000', 39600, '1'),
(38, 'AEST', '10011484800', 36000, '0'),
(38, 'AEDT', '10027209600', 39600, '1'),
(38, 'AEST', '10042934400', 36000, '0'),
(38, 'AEDT', '10059264000', 39600, '1'),
(38, 'AEST', '10074988800', 36000, '0'),
(38, 'AEDT', '10090713600', 39600, '1'),
(38, 'AEST', '10106438400', 36000, '0'),
(38, 'AEDT', '10122163200', 39600, '1'),
(38, 'AEST', '10137888000', 36000, '0'),
(38, 'AEDT', '10153612800', 39600, '1'),
(38, 'AEST', '10169337600', 36000, '0'),
(38, 'AEDT', '10185062400', 39600, '1'),
(38, 'AEST', '10200787200', 36000, '0'),
(38, 'AEDT', '10216512000', 39600, '1'),
(38, 'AEST', '10232236800', 36000, '0'),
(38, 'AEDT', '10248566400', 39600, '1'),
(38, 'AEST', '10264291200', 36000, '0'),
(38, 'AEDT', '10280016000', 39600, '1'),
(38, 'AEST', '10295740800', 36000, '0'),
(38, 'AEDT', '10311465600', 39600, '1'),
(38, 'AEST', '10327190400', 36000, '0'),
(38, 'AEDT', '10342915200', 39600, '1'),
(38, 'AEST', '10358640000', 36000, '0'),
(38, 'AEDT', '10374364800', 39600, '1'),
(38, 'AEST', '10390089600', 36000, '0'),
(38, 'AEDT', '10405814400', 39600, '1'),
(38, 'AEST', '10421539200', 36000, '0'),
(38, 'AEDT', '10437868800', 39600, '1'),
(38, 'AEST', '10453593600', 36000, '0'),
(38, 'AEDT', '10469318400', 39600, '1'),
(38, 'AEST', '10485043200', 36000, '0'),
(38, 'AEDT', '10500768000', 39600, '1'),
(38, 'AEST', '10516492800', 36000, '0'),
(38, 'AEDT', '10532217600', 39600, '1'),
(38, 'AEST', '10547942400', 36000, '0'),
(38, 'AEDT', '10563667200', 39600, '1'),
(38, 'AEST', '10579392000', 36000, '0'),
(38, 'AEDT', '10595116800', 39600, '1'),
(38, 'AEST', '10610841600', 36000, '0'),
(38, 'AEDT', '10627171200', 39600, '1'),
(38, 'AEST', '10642896000', 36000, '0'),
(38, 'AEDT', '10658620800', 39600, '1'),
(38, 'AEST', '10674345600', 36000, '0'),
(38, 'AEDT', '10690070400', 39600, '1'),
(38, 'AEST', '10705795200', 36000, '0'),
(38, 'AEDT', '10721520000', 39600, '1'),
(38, 'AEST', '10737244800', 36000, '0'),
(38, 'AEDT', '10752969600', 39600, '1'),
(38, 'AEST', '10768694400', 36000, '0'),
(38, 'AEDT', '10784419200', 39600, '1'),
(38, 'AEST', '10800748800', 36000, '0'),
(38, 'AEDT', '10816473600', 39600, '1'),
(38, 'AEST', '10832198400', 36000, '0'),
(38, 'AEDT', '10847923200', 39600, '1'),
(38, 'AEST', '10863648000', 36000, '0'),
(38, 'AEDT', '10879372800', 39600, '1'),
(38, 'AEST', '10895097600', 36000, '0'),
(38, 'AEDT', '10910822400', 39600, '1'),
(38, 'AEST', '10926547200', 36000, '0'),
(38, 'AEDT', '10942272000', 39600, '1'),
(38, 'AEST', '10957996800', 36000, '0'),
(38, 'AEDT', '10974326400', 39600, '1'),
(38, 'AEST', '10990051200', 36000, '0'),
(38, 'AEDT', '11005776000', 39600, '1'),
(38, 'AEST', '11021500800', 36000, '0'),
(38, 'AEDT', '11037225600', 39600, '1'),
(38, 'AEST', '11052950400', 36000, '0'),
(38, 'AEDT', '11068675200', 39600, '1'),
(38, 'AEST', '11084400000', 36000, '0'),
(38, 'AEDT', '11100124800', 39600, '1'),
(38, 'AEST', '11115849600', 36000, '0'),
(38, 'AEDT', '11131574400', 39600, '1'),
(38, 'AEST', '11147299200', 36000, '0'),
(38, 'AEDT', '11163628800', 39600, '1'),
(38, 'AEST', '11179353600', 36000, '0'),
(38, 'AEDT', '11195078400', 39600, '1'),
(38, 'AEST', '11210803200', 36000, '0'),
(38, 'AEDT', '11226528000', 39600, '1'),
(38, 'AEST', '11242252800', 36000, '0'),
(38, 'AEDT', '11257977600', 39600, '1'),
(38, 'AEST', '11273702400', 36000, '0'),
(38, 'AEDT', '11289427200', 39600, '1'),
(38, 'AEST', '11305152000', 36000, '0'),
(38, 'AEDT', '11321481600', 39600, '1'),
(38, 'AEST', '11337206400', 36000, '0'),
(38, 'AEDT', '11352931200', 39600, '1'),
(38, 'AEST', '11368656000', 36000, '0'),
(38, 'AEDT', '11384380800', 39600, '1'),
(38, 'AEST', '11400105600', 36000, '0'),
(38, 'AEDT', '11415830400', 39600, '1'),
(38, 'AEST', '11431555200', 36000, '0'),
(38, 'AEDT', '11447280000', 39600, '1'),
(38, 'AEST', '11463004800', 36000, '0'),
(38, 'AEDT', '11478729600', 39600, '1'),
(38, 'AEST', '11494454400', 36000, '0'),
(38, 'AEDT', '11510784000', 39600, '1'),
(38, 'AEST', '11526508800', 36000, '0'),
(38, 'AEDT', '11542233600', 39600, '1'),
(38, 'AEST', '11557958400', 36000, '0'),
(38, 'AEDT', '11573683200', 39600, '1'),
(38, 'AEST', '11589408000', 36000, '0'),
(38, 'AEDT', '11605132800', 39600, '1'),
(38, 'AEST', '11620857600', 36000, '0'),
(38, 'AEDT', '11636582400', 39600, '1'),
(38, 'AEST', '11652307200', 36000, '0'),
(38, 'AEDT', '11668032000', 39600, '1'),
(38, 'AEST', '11684361600', 36000, '0'),
(38, 'AEDT', '11700086400', 39600, '1'),
(38, 'AEST', '11715811200', 36000, '0'),
(38, 'AEDT', '11731536000', 39600, '1'),
(38, 'AEST', '11747260800', 36000, '0'),
(38, 'AEDT', '11762985600', 39600, '1'),
(38, 'AEST', '11778710400', 36000, '0'),
(38, 'AEDT', '11794435200', 39600, '1'),
(38, 'AEST', '11810160000', 36000, '0'),
(38, 'AEDT', '11825884800', 39600, '1'),
(38, 'AEST', '11841609600', 36000, '0'),
(38, 'AEDT', '11857939200', 39600, '1'),
(38, 'AEST', '11873664000', 36000, '0'),
(38, 'AEDT', '11889388800', 39600, '1'),
(38, 'AEST', '11905113600', 36000, '0'),
(38, 'AEDT', '11920838400', 39600, '1'),
(38, 'AEST', '11936563200', 36000, '0'),
(38, 'AEDT', '11952288000', 39600, '1'),
(38, 'AEST', '11968012800', 36000, '0'),
(38, 'AEDT', '11983737600', 39600, '1'),
(38, 'AEST', '11999462400', 36000, '0'),
(38, 'AEDT', '12015187200', 39600, '1'),
(38, 'AEST', '12030912000', 36000, '0'),
(38, 'AEDT', '12047241600', 39600, '1'),
(38, 'AEST', '12062966400', 36000, '0'),
(38, 'AEDT', '12078691200', 39600, '1'),
(38, 'AEST', '12094416000', 36000, '0'),
(38, 'AEDT', '12110140800', 39600, '1'),
(38, 'AEST', '12125865600', 36000, '0'),
(38, 'AEDT', '12141590400', 39600, '1'),
(38, 'AEST', '12157315200', 36000, '0'),
(38, 'AEDT', '12173040000', 39600, '1'),
(38, 'AEST', '12188764800', 36000, '0'),
(38, 'AEDT', '12205094400', 39600, '1'),
(38, 'AEST', '12220819200', 36000, '0'),
(38, 'AEDT', '12236544000', 39600, '1'),
(38, 'AEST', '12252268800', 36000, '0'),
(38, 'AEDT', '12267993600', 39600, '1'),
(38, 'AEST', '12283718400', 36000, '0'),
(38, 'AEDT', '12299443200', 39600, '1'),
(38, 'AEST', '12315168000', 36000, '0'),
(38, 'AEDT', '12330892800', 39600, '1'),
(38, 'AEST', '12346617600', 36000, '0'),
(38, 'AEDT', '12362342400', 39600, '1'),
(38, 'AEST', '12378067200', 36000, '0'),
(38, 'AEDT', '12394396800', 39600, '1'),
(38, 'AEST', '12410121600', 36000, '0'),
(38, 'AEDT', '12425846400', 39600, '1'),
(38, 'AEST', '12441571200', 36000, '0'),
(38, 'AEDT', '12457296000', 39600, '1'),
(38, 'AEST', '12473020800', 36000, '0'),
(38, 'AEDT', '12488745600', 39600, '1'),
(38, 'AEST', '12504470400', 36000, '0'),
(38, 'AEDT', '12520195200', 39600, '1'),
(38, 'AEST', '12535920000', 36000, '0'),
(38, 'AEDT', '12551644800', 39600, '1'),
(38, 'AEST', '12567974400', 36000, '0'),
(38, 'AEDT', '12583699200', 39600, '1'),
(38, 'AEST', '12599424000', 36000, '0'),
(38, 'AEDT', '12615148800', 39600, '1'),
(38, 'AEST', '12630873600', 36000, '0'),
(38, 'AEDT', '12646598400', 39600, '1'),
(38, 'AEST', '12662323200', 36000, '0'),
(38, 'AEDT', '12678048000', 39600, '1'),
(38, 'AEST', '12693772800', 36000, '0'),
(38, 'AEDT', '12709497600', 39600, '1'),
(38, 'AEST', '12725222400', 36000, '0'),
(38, 'AEDT', '12741552000', 39600, '1'),
(38, 'AEST', '12757276800', 36000, '0'),
(38, 'AEDT', '12773001600', 39600, '1'),
(38, 'AEST', '12788726400', 36000, '0'),
(38, 'AEDT', '12804451200', 39600, '1'),
(38, 'AEST', '12820176000', 36000, '0'),
(38, 'AEDT', '12835900800', 39600, '1'),
(38, 'AEST', '12851625600', 36000, '0'),
(38, 'AEDT', '12867350400', 39600, '1'),
(38, 'AEST', '12883075200', 36000, '0'),
(38, 'AEDT', '12898800000', 39600, '1'),
(38, 'AEST', '12914524800', 36000, '0'),
(38, 'AEDT', '12930854400', 39600, '1'),
(38, 'AEST', '12946579200', 36000, '0'),
(38, 'AEDT', '12962304000', 39600, '1'),
(38, 'AEST', '12978028800', 36000, '0'),
(38, 'AEDT', '12993753600', 39600, '1'),
(38, 'AEST', '13009478400', 36000, '0'),
(38, 'AEDT', '13025203200', 39600, '1'),
(38, 'AEST', '13040928000', 36000, '0'),
(38, 'AEDT', '13056652800', 39600, '1'),
(38, 'AEST', '13072377600', 36000, '0'),
(38, 'AEDT', '13088707200', 39600, '1'),
(38, 'AEST', '13104432000', 36000, '0'),
(38, 'AEDT', '13120156800', 39600, '1'),
(38, 'AEST', '13135881600', 36000, '0'),
(38, 'AEDT', '13151606400', 39600, '1'),
(38, 'AEST', '13167331200', 36000, '0'),
(38, 'AEDT', '13183056000', 39600, '1'),
(38, 'AEST', '13198780800', 36000, '0'),
(38, 'AEDT', '13214505600', 39600, '1'),
(38, 'AEST', '13230230400', 36000, '0'),
(38, 'AEDT', '13245955200', 39600, '1'),
(38, 'AEST', '13261680000', 36000, '0'),
(38, 'AEDT', '13278009600', 39600, '1'),
(38, 'AEST', '13293734400', 36000, '0'),
(38, 'AEDT', '13309459200', 39600, '1'),
(38, 'AEST', '13325184000', 36000, '0'),
(38, 'AEDT', '13340908800', 39600, '1'),
(38, 'AEST', '13356633600', 36000, '0'),
(38, 'AEDT', '13372358400', 39600, '1'),
(38, 'AEST', '13388083200', 36000, '0'),
(38, 'AEDT', '13403808000', 39600, '1'),
(38, 'AEST', '13419532800', 36000, '0'),
(38, 'AEDT', '13435257600', 39600, '1'),
(38, 'AEST', '13451587200', 36000, '0'),
(38, 'AEDT', '13467312000', 39600, '1'),
(38, 'AEST', '13483036800', 36000, '0'),
(38, 'AEDT', '13498761600', 39600, '1'),
(38, 'AEST', '13514486400', 36000, '0'),
(38, 'AEDT', '13530211200', 39600, '1'),
(38, 'AEST', '13545936000', 36000, '0'),
(38, 'AEDT', '13561660800', 39600, '1'),
(38, 'AEST', '13577385600', 36000, '0'),
(38, 'AEDT', '13593110400', 39600, '1'),
(38, 'AEST', '13608835200', 36000, '0'),
(38, 'AEDT', '13625164800', 39600, '1'),
(38, 'AEST', '13640889600', 36000, '0'),
(38, 'AEDT', '13656614400', 39600, '1'),
(38, 'AEST', '13672339200', 36000, '0'),
(38, 'AEDT', '13688064000', 39600, '1'),
(38, 'AEST', '13703788800', 36000, '0'),
(38, 'AEDT', '13719513600', 39600, '1'),
(38, 'AEST', '13735238400', 36000, '0'),
(38, 'AEDT', '13750963200', 39600, '1'),
(38, 'AEST', '13766688000', 36000, '0'),
(38, 'AEDT', '13782412800', 39600, '1'),
(38, 'AEST', '13798137600', 36000, '0'),
(38, 'AEDT', '13814467200', 39600, '1'),
(38, 'AEST', '13830192000', 36000, '0'),
(38, 'AEDT', '13845916800', 39600, '1'),
(38, 'AEST', '13861641600', 36000, '0'),
(38, 'AEDT', '13877366400', 39600, '1'),
(38, 'AEST', '13893091200', 36000, '0'),
(38, 'AEDT', '13908816000', 39600, '1'),
(38, 'AEST', '13924540800', 36000, '0'),
(38, 'AEDT', '13940265600', 39600, '1'),
(38, 'AEST', '13955990400', 36000, '0'),
(38, 'AEDT', '13972320000', 39600, '1'),
(38, 'AEST', '13988044800', 36000, '0'),
(38, 'AEDT', '14003769600', 39600, '1'),
(38, 'AEST', '14019494400', 36000, '0'),
(38, 'AEDT', '14035219200', 39600, '1'),
(38, 'AEST', '14050944000', 36000, '0'),
(38, 'AEDT', '14066668800', 39600, '1'),
(38, 'AEST', '14082393600', 36000, '0'),
(38, 'AEDT', '14098118400', 39600, '1'),
(38, 'AEST', '14113843200', 36000, '0'),
(38, 'AEDT', '14129568000', 39600, '1'),
(38, 'AEST', '14145292800', 36000, '0'),
(38, 'AEDT', '14161622400', 39600, '1'),
(38, 'AEST', '14177347200', 36000, '0'),
(38, 'AEDT', '14193072000', 39600, '1'),
(38, 'AEST', '14208796800', 36000, '0'),
(38, 'AEDT', '14224521600', 39600, '1'),
(38, 'AEST', '14240246400', 36000, '0'),
(38, 'AEDT', '14255971200', 39600, '1'),
(38, 'AEST', '14271696000', 36000, '0'),
(38, 'AEDT', '14287420800', 39600, '1'),
(38, 'AEST', '14303145600', 36000, '0'),
(38, 'AEDT', '14318870400', 39600, '1'),
(38, 'AEST', '14335200000', 36000, '0'),
(38, 'AEDT', '14350924800', 39600, '1'),
(38, 'AEST', '14366649600', 36000, '0'),
(38, 'AEDT', '14382374400', 39600, '1'),
(38, 'AEST', '14398099200', 36000, '0'),
(38, 'AEDT', '14413824000', 39600, '1'),
(38, 'AEST', '14429548800', 36000, '0'),
(38, 'AEDT', '14445273600', 39600, '1'),
(38, 'AEST', '14460998400', 36000, '0'),
(38, 'AEDT', '14476723200', 39600, '1'),
(38, 'AEST', '14492448000', 36000, '0'),
(38, 'AEDT', '14508777600', 39600, '1'),
(38, 'AEST', '14524502400', 36000, '0'),
(38, 'AEDT', '14540227200', 39600, '1'),
(38, 'AEST', '14555952000', 36000, '0'),
(38, 'AEDT', '14571676800', 39600, '1'),
(38, 'AEST', '14587401600', 36000, '0'),
(38, 'AEDT', '14603126400', 39600, '1'),
(38, 'AEST', '14618851200', 36000, '0'),
(38, 'AEDT', '14634576000', 39600, '1'),
(38, 'AEST', '14650300800', 36000, '0'),
(38, 'AEDT', '14666025600', 39600, '1'),
(38, 'AEST', '14681750400', 36000, '0'),
(38, 'AEDT', '14698080000', 39600, '1'),
(38, 'AEST', '14713804800', 36000, '0'),
(38, 'AEDT', '14729529600', 39600, '1'),
(38, 'AEST', '14745254400', 36000, '0'),
(38, 'AEDT', '14760979200', 39600, '1'),
(38, 'AEST', '14776704000', 36000, '0'),
(38, 'AEDT', '14792428800', 39600, '1'),
(38, 'AEST', '14808153600', 36000, '0'),
(38, 'AEDT', '14823878400', 39600, '1'),
(38, 'AEST', '14839603200', 36000, '0'),
(38, 'AEDT', '14855932800', 39600, '1'),
(38, 'AEST', '14871657600', 36000, '0'),
(38, 'AEDT', '14887382400', 39600, '1'),
(38, 'AEST', '14903107200', 36000, '0'),
(38, 'AEDT', '14918832000', 39600, '1'),
(38, 'AEST', '14934556800', 36000, '0'),
(38, 'AEDT', '14950281600', 39600, '1'),
(38, 'AEST', '14966006400', 36000, '0'),
(38, 'AEDT', '14981731200', 39600, '1'),
(38, 'AEST', '14997456000', 36000, '0'),
(38, 'AEDT', '15013180800', 39600, '1'),
(38, 'AEST', '15028905600', 36000, '0'),
(38, 'AEDT', '15045235200', 39600, '1'),
(38, 'AEST', '15060960000', 36000, '0'),
(38, 'AEDT', '15076684800', 39600, '1'),
(38, 'AEST', '15092409600', 36000, '0'),
(38, 'AEDT', '15108134400', 39600, '1'),
(38, 'AEST', '15123859200', 36000, '0'),
(38, 'AEDT', '15139584000', 39600, '1'),
(38, 'AEST', '15155308800', 36000, '0'),
(38, 'AEDT', '15171033600', 39600, '1'),
(38, 'AEST', '15186758400', 36000, '0'),
(38, 'AEDT', '15202483200', 39600, '1'),
(38, 'AEST', '15218812800', 36000, '0'),
(38, 'AEDT', '15234537600', 39600, '1'),
(38, 'AEST', '15250262400', 36000, '0'),
(38, 'AEDT', '15265987200', 39600, '1'),
(38, 'AEST', '15281712000', 36000, '0'),
(38, 'AEDT', '15297436800', 39600, '1'),
(38, 'AEST', '15313161600', 36000, '0'),
(38, 'AEDT', '15328886400', 39600, '1'),
(38, 'AEST', '15344611200', 36000, '0'),
(38, 'AEDT', '15360336000', 39600, '1'),
(38, 'AEST', '15376060800', 36000, '0'),
(38, 'AEDT', '15392390400', 39600, '1'),
(38, 'AEST', '15408115200', 36000, '0'),
(38, 'AEDT', '15423840000', 39600, '1'),
(38, 'AEST', '15439564800', 36000, '0'),
(38, 'AEDT', '15455289600', 39600, '1'),
(38, 'AEST', '15471014400', 36000, '0'),
(38, 'AEDT', '15486739200', 39600, '1'),
(38, 'AEST', '15502464000', 36000, '0'),
(38, 'AEDT', '15518188800', 39600, '1'),
(38, 'AEST', '15533913600', 36000, '0'),
(38, 'AEDT', '15549638400', 39600, '1'),
(38, 'AEST', '15565363200', 36000, '0'),
(38, 'AEDT', '15581692800', 39600, '1'),
(38, 'AEST', '15597417600', 36000, '0'),
(38, 'AEDT', '15613142400', 39600, '1'),
(38, 'AEST', '15628867200', 36000, '0'),
(38, 'AEDT', '15644592000', 39600, '1'),
(38, 'AEST', '15660316800', 36000, '0'),
(38, 'AEDT', '15676041600', 39600, '1'),
(38, 'AEST', '15691766400', 36000, '0'),
(38, 'AEDT', '15707491200', 39600, '1'),
(38, 'AEST', '15723216000', 36000, '0'),
(38, 'AEDT', '15739545600', 39600, '1'),
(38, 'AEST', '15755270400', 36000, '0'),
(38, 'AEDT', '15770995200', 39600, '1'),
(38, 'AEST', '15786720000', 36000, '0'),
(38, 'AEDT', '15802444800', 39600, '1'),
(38, 'AEST', '15818169600', 36000, '0'),
(38, 'AEDT', '15833894400', 39600, '1'),
(38, 'AEST', '15849619200', 36000, '0'),
(38, 'AEDT', '15865344000', 39600, '1'),
(38, 'AEST', '15881068800', 36000, '0'),
(38, 'AEDT', '15896793600', 39600, '1'),
(38, 'AEST', '15912518400', 36000, '0'),
(38, 'AEDT', '15928848000', 39600, '1'),
(38, 'AEST', '15944572800', 36000, '0'),
(38, 'AEDT', '15960297600', 39600, '1'),
(38, 'AEST', '15976022400', 36000, '0'),
(38, 'AEDT', '15991747200', 39600, '1'),
(38, 'AEST', '16007472000', 36000, '0'),
(38, 'AEDT', '16023196800', 39600, '1'),
(38, 'AEST', '16038921600', 36000, '0'),
(38, 'AEDT', '16054646400', 39600, '1'),
(38, 'AEST', '16070371200', 36000, '0'),
(38, 'AEDT', '16086096000', 39600, '1'),
(38, 'AEST', '16102425600', 36000, '0'),
(38, 'AEDT', '16118150400', 39600, '1'),
(38, 'AEST', '16133875200', 36000, '0'),
(38, 'AEDT', '16149600000', 39600, '1'),
(38, 'AEST', '16165324800', 36000, '0'),
(38, 'AEDT', '16181049600', 39600, '1'),
(38, 'AEST', '16196774400', 36000, '0'),
(38, 'AEDT', '16212499200', 39600, '1'),
(38, 'AEST', '16228224000', 36000, '0'),
(38, 'AEDT', '16243948800', 39600, '1'),
(38, 'AEST', '16259673600', 36000, '0'),
(38, 'AEDT', '16276003200', 39600, '1'),
(38, 'AEST', '16291728000', 36000, '0'),
(38, 'AEDT', '16307452800', 39600, '1'),
(38, 'AEST', '16323177600', 36000, '0'),
(38, 'AEDT', '16338902400', 39600, '1'),
(38, 'AEST', '16354627200', 36000, '0'),
(38, 'AEDT', '16370352000', 39600, '1'),
(38, 'AEST', '16386076800', 36000, '0'),
(38, 'AEDT', '16401801600', 39600, '1'),
(38, 'AEST', '16417526400', 36000, '0'),
(38, 'AEDT', '16433251200', 39600, '1'),
(38, 'AEST', '16448976000', 36000, '0'),
(38, 'AEDT', '16465305600', 39600, '1'),
(38, 'AEST', '16481030400', 36000, '0'),
(38, 'AEDT', '16496755200', 39600, '1'),
(38, 'AEST', '16512480000', 36000, '0'),
(38, 'AEDT', '16528204800', 39600, '1'),
(38, 'AEST', '16543929600', 36000, '0'),
(38, 'AEDT', '16559654400', 39600, '1'),
(38, 'AEST', '16575379200', 36000, '0'),
(38, 'AEDT', '16591104000', 39600, '1'),
(38, 'AEST', '16606828800', 36000, '0'),
(38, 'AEDT', '16623158400', 39600, '1'),
(38, 'AEST', '16638883200', 36000, '0'),
(38, 'AEDT', '16654608000', 39600, '1'),
(38, 'AEST', '16670332800', 36000, '0'),
(38, 'AEDT', '16686057600', 39600, '1'),
(38, 'AEST', '16701782400', 36000, '0'),
(38, 'AEDT', '16717507200', 39600, '1'),
(39, 'LMT', '-2364110749', 33948, '0'),
(39, 'AEST', '-2364110748', 36000, '0'),
(39, 'ACST', '-2314951200', 32400, '0'),
(39, 'ACST', '-2230189200', 34200, '0'),
(39, 'ACDT', '-1672565340', 37800, '1'),
(39, 'ACST', '-1665390600', 34200, '0'),
(39, 'ACDT', '-883639800', 37800, '1'),
(39, 'ACST', '-876126600', 34200, '0'),
(39, 'ACDT', '-860398200', 37800, '1'),
(39, 'ACST', '-844677000', 34200, '0'),
(39, 'ACDT', '-828343800', 37800, '1'),
(39, 'ACST', '-813227400', 34200, '0'),
(39, 'ACDT', '57688200', 37800, '1'),
(39, 'ACST', '67969800', 34200, '0'),
(39, 'ACDT', '89137800', 37800, '1'),
(39, 'ACST', '100024200', 34200, '0'),
(39, 'ACDT', '120587400', 37800, '1'),
(39, 'ACST', '131473800', 34200, '0'),
(39, 'ACDT', '152037000', 37800, '1'),
(39, 'ACST', '162923400', 34200, '0'),
(39, 'ACDT', '183486600', 37800, '1'),
(39, 'ACST', '194977800', 34200, '0'),
(39, 'ACDT', '215541000', 37800, '1'),
(39, 'ACST', '226427400', 34200, '0'),
(39, 'ACDT', '246990600', 37800, '1'),
(39, 'ACST', '257877000', 34200, '0'),
(39, 'ACDT', '278440200', 37800, '1'),
(39, 'ACST', '289326600', 34200, '0'),
(39, 'ACDT', '309889800', 37800, '1'),
(39, 'ACST', '320776200', 34200, '0'),
(39, 'ACDT', '341339400', 37800, '1'),
(39, 'ACST', '352225800', 34200, '0'),
(39, 'ACDT', '372789000', 37800, '1'),
(39, 'ACST', '386699400', 34200, '0'),
(39, 'ACDT', '404843400', 37800, '1'),
(39, 'ACST', '415729800', 34200, '0'),
(39, 'ACDT', '436293000', 37800, '1'),
(39, 'ACST', '447179400', 34200, '0'),
(39, 'ACDT', '467742600', 37800, '1'),
(39, 'ACST', '478629000', 34200, '0'),
(39, 'ACDT', '499192200', 37800, '1'),
(39, 'ACST', '511288200', 34200, '0'),
(39, 'ACDT', '530037000', 37800, '1'),
(39, 'ACST', '542737800', 34200, '0'),
(39, 'ACDT', '562091400', 37800, '1'),
(39, 'ACST', '574792200', 34200, '0'),
(39, 'ACDT', '594145800', 37800, '1'),
(39, 'ACST', '606241800', 34200, '0'),
(39, 'ACDT', '625595400', 37800, '1'),
(39, 'ACST', '636481800', 34200, '0'),
(39, 'ACDT', '657045000', 37800, '1'),
(39, 'ACST', '667931400', 34200, '0'),
(39, 'ACDT', '688494600', 37800, '1'),
(39, 'ACST', '699381000', 34200, '0'),
(39, 'ACDT', '719944200', 37800, '1'),
(39, 'ACST', '731435400', 34200, '0'),
(39, 'ACDT', '751998600', 37800, '1'),
(39, 'ACST', '762885000', 34200, '0'),
(39, 'ACDT', '783448200', 37800, '1'),
(39, 'ACST', '794334600', 34200, '0'),
(39, 'ACDT', '814897800', 37800, '1'),
(39, 'ACST', '828203400', 34200, '0'),
(39, 'ACDT', '846347400', 37800, '1'),
(39, 'ACST', '859653000', 34200, '0'),
(39, 'ACDT', '877797000', 37800, '1'),
(39, 'ACST', '891102600', 34200, '0'),
(39, 'ACDT', '909246600', 37800, '1'),
(39, 'ACST', '922552200', 34200, '0'),
(39, 'ACDT', '941301000', 37800, '1'),
(39, 'ACST', '954001800', 34200, '0'),
(39, 'ACDT', '972750600', 37800, '1'),
(39, 'ACST', '985451400', 34200, '0'),
(39, 'ACDT', '1004200200', 37800, '1'),
(39, 'ACST', '1017505800', 34200, '0'),
(39, 'ACDT', '1035649800', 37800, '1'),
(39, 'ACST', '1048955400', 34200, '0'),
(39, 'ACDT', '1067099400', 37800, '1'),
(39, 'ACST', '1080405000', 34200, '0'),
(39, 'ACDT', '1099153800', 37800, '1'),
(39, 'ACST', '1111854600', 34200, '0'),
(39, 'ACDT', '1130603400', 37800, '1'),
(39, 'ACST', '1143909000', 34200, '0'),
(39, 'ACDT', '1162053000', 37800, '1'),
(39, 'ACST', '1174753800', 34200, '0'),
(39, 'ACDT', '1193502600', 37800, '1'),
(39, 'ACST', '1207413000', 34200, '0'),
(39, 'ACDT', '1223137800', 37800, '1'),
(39, 'ACST', '1238862600', 34200, '0'),
(39, 'ACDT', '1254587400', 37800, '1'),
(39, 'ACST', '1270312200', 34200, '0'),
(39, 'ACDT', '1286037000', 37800, '1'),
(39, 'ACST', '1301761800', 34200, '0'),
(39, 'ACDT', '1317486600', 37800, '1'),
(39, 'ACST', '1333211400', 34200, '0'),
(39, 'ACDT', '1349541000', 37800, '1'),
(39, 'ACST', '1365265800', 34200, '0'),
(39, 'ACDT', '1380990600', 37800, '1'),
(39, 'ACST', '1396715400', 34200, '0'),
(39, 'ACDT', '1412440200', 37800, '1'),
(39, 'ACST', '1428165000', 34200, '0'),
(39, 'ACDT', '1443889800', 37800, '1'),
(39, 'ACST', '1459614600', 34200, '0'),
(39, 'ACDT', '1475339400', 37800, '1'),
(39, 'ACST', '1491064200', 34200, '0'),
(39, 'ACDT', '1506789000', 37800, '1'),
(39, 'ACST', '1522513800', 34200, '0'),
(39, 'ACDT', '1538843400', 37800, '1'),
(39, 'ACST', '1554568200', 34200, '0'),
(39, 'ACDT', '1570293000', 37800, '1'),
(39, 'ACST', '1586017800', 34200, '0'),
(39, 'ACDT', '1601742600', 37800, '1'),
(39, 'ACST', '1617467400', 34200, '0'),
(39, 'ACDT', '1633192200', 37800, '1'),
(39, 'ACST', '1648917000', 34200, '0'),
(39, 'ACDT', '1664641800', 37800, '1'),
(39, 'ACST', '1680366600', 34200, '0'),
(39, 'ACDT', '1696091400', 37800, '1'),
(39, 'ACST', '1712421000', 34200, '0'),
(39, 'ACDT', '1728145800', 37800, '1'),
(39, 'ACST', '1743870600', 34200, '0'),
(39, 'ACDT', '1759595400', 37800, '1'),
(39, 'ACST', '1775320200', 34200, '0'),
(39, 'ACDT', '1791045000', 37800, '1'),
(39, 'ACST', '1806769800', 34200, '0'),
(39, 'ACDT', '1822494600', 37800, '1'),
(39, 'ACST', '1838219400', 34200, '0'),
(39, 'ACDT', '1853944200', 37800, '1'),
(39, 'ACST', '1869669000', 34200, '0'),
(39, 'ACDT', '1885998600', 37800, '1'),
(39, 'ACST', '1901723400', 34200, '0'),
(39, 'ACDT', '1917448200', 37800, '1'),
(39, 'ACST', '1933173000', 34200, '0'),
(39, 'ACDT', '1948897800', 37800, '1'),
(39, 'ACST', '1964622600', 34200, '0'),
(39, 'ACDT', '1980347400', 37800, '1'),
(39, 'ACST', '1996072200', 34200, '0'),
(39, 'ACDT', '2011797000', 37800, '1'),
(39, 'ACST', '2027521800', 34200, '0'),
(39, 'ACDT', '2043246600', 37800, '1'),
(39, 'ACST', '2058971400', 34200, '0'),
(39, 'ACDT', '2075301000', 37800, '1'),
(39, 'ACST', '2091025800', 34200, '0'),
(39, 'ACDT', '2106750600', 37800, '1'),
(39, 'ACST', '2122475400', 34200, '0'),
(39, 'ACDT', '2138200200', 37800, '1'),
(39, 'ACST', '2153925000', 34200, '0'),
(39, 'ACDT', '2169649800', 37800, '1'),
(39, 'ACST', '2185374600', 34200, '0'),
(39, 'ACDT', '2201099400', 37800, '1'),
(39, 'ACST', '2216824200', 34200, '0'),
(39, 'ACDT', '2233153800', 37800, '1'),
(39, 'ACST', '2248878600', 34200, '0'),
(39, 'ACDT', '2264603400', 37800, '1'),
(39, 'ACST', '2280328200', 34200, '0'),
(39, 'ACDT', '2296053000', 37800, '1'),
(39, 'ACST', '2311777800', 34200, '0'),
(39, 'ACDT', '2327502600', 37800, '1'),
(39, 'ACST', '2343227400', 34200, '0'),
(39, 'ACDT', '2358952200', 37800, '1'),
(39, 'ACST', '2374677000', 34200, '0'),
(39, 'ACDT', '2390401800', 37800, '1'),
(39, 'ACST', '2406126600', 34200, '0'),
(39, 'ACDT', '2422456200', 37800, '1'),
(39, 'ACST', '2438181000', 34200, '0'),
(39, 'ACDT', '2453905800', 37800, '1'),
(39, 'ACST', '2469630600', 34200, '0'),
(39, 'ACDT', '2485355400', 37800, '1'),
(39, 'ACST', '2501080200', 34200, '0'),
(39, 'ACDT', '2516805000', 37800, '1'),
(39, 'ACST', '2532529800', 34200, '0'),
(39, 'ACDT', '2548254600', 37800, '1'),
(39, 'ACST', '2563979400', 34200, '0'),
(39, 'ACDT', '2579704200', 37800, '1'),
(39, 'ACST', '2596033800', 34200, '0'),
(39, 'ACDT', '2611758600', 37800, '1'),
(39, 'ACST', '2627483400', 34200, '0'),
(39, 'ACDT', '2643208200', 37800, '1'),
(39, 'ACST', '2658933000', 34200, '0'),
(39, 'ACDT', '2674657800', 37800, '1'),
(39, 'ACST', '2690382600', 34200, '0'),
(39, 'ACDT', '2706107400', 37800, '1'),
(39, 'ACST', '2721832200', 34200, '0'),
(39, 'ACDT', '2737557000', 37800, '1'),
(39, 'ACST', '2753281800', 34200, '0'),
(39, 'ACDT', '2769611400', 37800, '1'),
(39, 'ACST', '2785336200', 34200, '0'),
(39, 'ACDT', '2801061000', 37800, '1'),
(39, 'ACST', '2816785800', 34200, '0'),
(39, 'ACDT', '2832510600', 37800, '1'),
(39, 'ACST', '2848235400', 34200, '0'),
(39, 'ACDT', '2863960200', 37800, '1'),
(39, 'ACST', '2879685000', 34200, '0'),
(39, 'ACDT', '2895409800', 37800, '1'),
(39, 'ACST', '2911134600', 34200, '0'),
(39, 'ACDT', '2926859400', 37800, '1'),
(39, 'ACST', '2942584200', 34200, '0'),
(39, 'ACDT', '2958913800', 37800, '1'),
(39, 'ACST', '2974638600', 34200, '0'),
(39, 'ACDT', '2990363400', 37800, '1'),
(39, 'ACST', '3006088200', 34200, '0'),
(39, 'ACDT', '3021813000', 37800, '1'),
(39, 'ACST', '3037537800', 34200, '0'),
(39, 'ACDT', '3053262600', 37800, '1'),
(39, 'ACST', '3068987400', 34200, '0'),
(39, 'ACDT', '3084712200', 37800, '1'),
(39, 'ACST', '3100437000', 34200, '0'),
(39, 'ACDT', '3116766600', 37800, '1'),
(39, 'ACST', '3132491400', 34200, '0'),
(39, 'ACDT', '3148216200', 37800, '1'),
(39, 'ACST', '3163941000', 34200, '0'),
(39, 'ACDT', '3179665800', 37800, '1'),
(39, 'ACST', '3195390600', 34200, '0'),
(39, 'ACDT', '3211115400', 37800, '1'),
(39, 'ACST', '3226840200', 34200, '0'),
(39, 'ACDT', '3242565000', 37800, '1'),
(39, 'ACST', '3258289800', 34200, '0'),
(39, 'ACDT', '3274014600', 37800, '1'),
(39, 'ACST', '3289739400', 34200, '0'),
(39, 'ACDT', '3306069000', 37800, '1'),
(39, 'ACST', '3321793800', 34200, '0'),
(39, 'ACDT', '3337518600', 37800, '1'),
(39, 'ACST', '3353243400', 34200, '0'),
(39, 'ACDT', '3368968200', 37800, '1'),
(39, 'ACST', '3384693000', 34200, '0'),
(39, 'ACDT', '3400417800', 37800, '1'),
(39, 'ACST', '3416142600', 34200, '0'),
(39, 'ACDT', '3431867400', 37800, '1'),
(39, 'ACST', '3447592200', 34200, '0'),
(39, 'ACDT', '3463317000', 37800, '1'),
(39, 'ACST', '3479646600', 34200, '0'),
(39, 'ACDT', '3495371400', 37800, '1'),
(39, 'ACST', '3511096200', 34200, '0'),
(39, 'ACDT', '3526821000', 37800, '1'),
(39, 'ACST', '3542545800', 34200, '0'),
(39, 'ACDT', '3558270600', 37800, '1'),
(39, 'ACST', '3573995400', 34200, '0'),
(39, 'ACDT', '3589720200', 37800, '1'),
(39, 'ACST', '3605445000', 34200, '0'),
(39, 'ACDT', '3621169800', 37800, '1'),
(39, 'ACST', '3636894600', 34200, '0'),
(39, 'ACDT', '3653224200', 37800, '1'),
(39, 'ACST', '3668949000', 34200, '0'),
(39, 'ACDT', '3684673800', 37800, '1'),
(39, 'ACST', '3700398600', 34200, '0'),
(39, 'ACDT', '3716123400', 37800, '1'),
(39, 'ACST', '3731848200', 34200, '0'),
(39, 'ACDT', '3747573000', 37800, '1'),
(39, 'ACST', '3763297800', 34200, '0'),
(39, 'ACDT', '3779022600', 37800, '1'),
(39, 'ACST', '3794747400', 34200, '0'),
(39, 'ACDT', '3810472200', 37800, '1'),
(39, 'ACST', '3826197000', 34200, '0'),
(39, 'ACDT', '3842526600', 37800, '1'),
(39, 'ACST', '3858251400', 34200, '0'),
(39, 'ACDT', '3873976200', 37800, '1'),
(39, 'ACST', '3889701000', 34200, '0'),
(39, 'ACDT', '3905425800', 37800, '1'),
(39, 'ACST', '3921150600', 34200, '0'),
(39, 'ACDT', '3936875400', 37800, '1'),
(39, 'ACST', '3952600200', 34200, '0'),
(39, 'ACDT', '3968325000', 37800, '1'),
(39, 'ACST', '3984049800', 34200, '0'),
(39, 'ACDT', '4000379400', 37800, '1'),
(39, 'ACST', '4016104200', 34200, '0'),
(39, 'ACDT', '4031829000', 37800, '1'),
(39, 'ACST', '4047553800', 34200, '0'),
(39, 'ACDT', '4063278600', 37800, '1'),
(39, 'ACST', '4079003400', 34200, '0'),
(39, 'ACDT', '4094728200', 37800, '1'),
(39, 'ACST', '4110453000', 34200, '0'),
(39, 'ACDT', '4126177800', 37800, '1'),
(39, 'ACST', '4141902600', 34200, '0'),
(39, 'ACDT', '4157627400', 37800, '1'),
(39, 'ACST', '4173352200', 34200, '0'),
(39, 'ACDT', '4189077000', 37800, '1'),
(39, 'ACST', '4204801800', 34200, '0'),
(39, 'ACDT', '4221131400', 37800, '1'),
(39, 'ACST', '4236856200', 34200, '0'),
(39, 'ACDT', '4252581000', 37800, '1'),
(39, 'ACST', '4268305800', 34200, '0'),
(39, 'ACDT', '4284030600', 37800, '1'),
(39, 'ACST', '4299755400', 34200, '0'),
(39, 'ACDT', '4315480200', 37800, '1'),
(39, 'ACST', '4331205000', 34200, '0'),
(39, 'ACDT', '4346929800', 37800, '1'),
(39, 'ACST', '4362654600', 34200, '0'),
(39, 'ACDT', '4378984200', 37800, '1'),
(39, 'ACST', '4394709000', 34200, '0'),
(39, 'ACDT', '4410433800', 37800, '1'),
(39, 'ACST', '4426158600', 34200, '0'),
(39, 'ACDT', '4441883400', 37800, '1'),
(39, 'ACST', '4457608200', 34200, '0'),
(39, 'ACDT', '4473333000', 37800, '1'),
(39, 'ACST', '4489057800', 34200, '0'),
(39, 'ACDT', '4504782600', 37800, '1'),
(39, 'ACST', '4520507400', 34200, '0'),
(39, 'ACDT', '4536232200', 37800, '1'),
(39, 'ACST', '4551957000', 34200, '0'),
(39, 'ACDT', '4568286600', 37800, '1'),
(39, 'ACST', '4584011400', 34200, '0'),
(39, 'ACDT', '4599736200', 37800, '1'),
(39, 'ACST', '4615461000', 34200, '0'),
(39, 'ACDT', '4631185800', 37800, '1'),
(39, 'ACST', '4646910600', 34200, '0'),
(39, 'ACDT', '4662635400', 37800, '1'),
(39, 'ACST', '4678360200', 34200, '0'),
(39, 'ACDT', '4694085000', 37800, '1'),
(39, 'ACST', '4709809800', 34200, '0'),
(39, 'ACDT', '4725534600', 37800, '1'),
(39, 'ACST', '4741864200', 34200, '0'),
(39, 'ACDT', '4757589000', 37800, '1'),
(39, 'ACST', '4773313800', 34200, '0'),
(39, 'ACDT', '4789038600', 37800, '1'),
(39, 'ACST', '4804763400', 34200, '0'),
(39, 'ACDT', '4820488200', 37800, '1'),
(39, 'ACST', '4836213000', 34200, '0'),
(39, 'ACDT', '4851937800', 37800, '1'),
(39, 'ACST', '4867662600', 34200, '0'),
(39, 'ACDT', '4883387400', 37800, '1'),
(39, 'ACST', '4899112200', 34200, '0'),
(39, 'ACDT', '4915441800', 37800, '1'),
(39, 'ACST', '4931166600', 34200, '0'),
(39, 'ACDT', '4946891400', 37800, '1'),
(39, 'ACST', '4962616200', 34200, '0'),
(39, 'ACDT', '4978341000', 37800, '1'),
(39, 'ACST', '4994065800', 34200, '0'),
(39, 'ACDT', '5009790600', 37800, '1'),
(39, 'ACST', '5025515400', 34200, '0'),
(39, 'ACDT', '5041240200', 37800, '1'),
(39, 'ACST', '5056965000', 34200, '0'),
(39, 'ACDT', '5072689800', 37800, '1'),
(39, 'ACST', '5088414600', 34200, '0'),
(39, 'ACDT', '5104744200', 37800, '1'),
(39, 'ACST', '5120469000', 34200, '0'),
(39, 'ACDT', '5136193800', 37800, '1'),
(39, 'ACST', '5151918600', 34200, '0'),
(39, 'ACDT', '5167643400', 37800, '1'),
(39, 'ACST', '5183368200', 34200, '0'),
(39, 'ACDT', '5199093000', 37800, '1'),
(39, 'ACST', '5214817800', 34200, '0'),
(39, 'ACDT', '5230542600', 37800, '1'),
(39, 'ACST', '5246267400', 34200, '0'),
(39, 'ACDT', '5262597000', 37800, '1'),
(39, 'ACST', '5278321800', 34200, '0'),
(39, 'ACDT', '5294046600', 37800, '1'),
(39, 'ACST', '5309771400', 34200, '0'),
(39, 'ACDT', '5325496200', 37800, '1'),
(39, 'ACST', '5341221000', 34200, '0'),
(39, 'ACDT', '5356945800', 37800, '1'),
(39, 'ACST', '5372670600', 34200, '0'),
(39, 'ACDT', '5388395400', 37800, '1'),
(39, 'ACST', '5404120200', 34200, '0'),
(39, 'ACDT', '5419845000', 37800, '1'),
(39, 'ACST', '5435569800', 34200, '0'),
(39, 'ACDT', '5451899400', 37800, '1'),
(39, 'ACST', '5467624200', 34200, '0'),
(39, 'ACDT', '5483349000', 37800, '1'),
(39, 'ACST', '5499073800', 34200, '0'),
(39, 'ACDT', '5514798600', 37800, '1'),
(39, 'ACST', '5530523400', 34200, '0'),
(39, 'ACDT', '5546248200', 37800, '1'),
(39, 'ACST', '5561973000', 34200, '0'),
(39, 'ACDT', '5577697800', 37800, '1'),
(39, 'ACST', '5593422600', 34200, '0'),
(39, 'ACDT', '5609147400', 37800, '1'),
(39, 'ACST', '5625477000', 34200, '0'),
(39, 'ACDT', '5641201800', 37800, '1'),
(39, 'ACST', '5656926600', 34200, '0'),
(39, 'ACDT', '5672651400', 37800, '1'),
(39, 'ACST', '5688376200', 34200, '0'),
(39, 'ACDT', '5704101000', 37800, '1'),
(39, 'ACST', '5719825800', 34200, '0'),
(39, 'ACDT', '5735550600', 37800, '1'),
(39, 'ACST', '5751275400', 34200, '0'),
(39, 'ACDT', '5767000200', 37800, '1'),
(39, 'ACST', '5782725000', 34200, '0'),
(39, 'ACDT', '5799054600', 37800, '1'),
(39, 'ACST', '5814779400', 34200, '0'),
(39, 'ACDT', '5830504200', 37800, '1'),
(39, 'ACST', '5846229000', 34200, '0'),
(39, 'ACDT', '5861953800', 37800, '1'),
(39, 'ACST', '5877678600', 34200, '0'),
(39, 'ACDT', '5893403400', 37800, '1'),
(39, 'ACST', '5909128200', 34200, '0'),
(39, 'ACDT', '5924853000', 37800, '1'),
(39, 'ACST', '5940577800', 34200, '0'),
(39, 'ACDT', '5956302600', 37800, '1'),
(39, 'ACST', '5972027400', 34200, '0'),
(39, 'ACDT', '5988357000', 37800, '1'),
(39, 'ACST', '6004081800', 34200, '0'),
(39, 'ACDT', '6019806600', 37800, '1'),
(39, 'ACST', '6035531400', 34200, '0'),
(39, 'ACDT', '6051256200', 37800, '1'),
(39, 'ACST', '6066981000', 34200, '0'),
(39, 'ACDT', '6082705800', 37800, '1'),
(39, 'ACST', '6098430600', 34200, '0'),
(39, 'ACDT', '6114155400', 37800, '1'),
(39, 'ACST', '6129880200', 34200, '0'),
(39, 'ACDT', '6146209800', 37800, '1'),
(39, 'ACST', '6161934600', 34200, '0'),
(39, 'ACDT', '6177659400', 37800, '1'),
(39, 'ACST', '6193384200', 34200, '0'),
(39, 'ACDT', '6209109000', 37800, '1'),
(39, 'ACST', '6224833800', 34200, '0'),
(39, 'ACDT', '6240558600', 37800, '1'),
(39, 'ACST', '6256283400', 34200, '0'),
(39, 'ACDT', '6272008200', 37800, '1'),
(39, 'ACST', '6287733000', 34200, '0'),
(39, 'ACDT', '6303457800', 37800, '1'),
(39, 'ACST', '6319182600', 34200, '0'),
(39, 'ACDT', '6335512200', 37800, '1'),
(39, 'ACST', '6351237000', 34200, '0'),
(39, 'ACDT', '6366961800', 37800, '1'),
(39, 'ACST', '6382686600', 34200, '0'),
(39, 'ACDT', '6398411400', 37800, '1'),
(39, 'ACST', '6414136200', 34200, '0'),
(39, 'ACDT', '6429861000', 37800, '1'),
(39, 'ACST', '6445585800', 34200, '0'),
(39, 'ACDT', '6461310600', 37800, '1'),
(39, 'ACST', '6477035400', 34200, '0'),
(39, 'ACDT', '6492760200', 37800, '1'),
(39, 'ACST', '6509089800', 34200, '0'),
(39, 'ACDT', '6524814600', 37800, '1'),
(39, 'ACST', '6540539400', 34200, '0'),
(39, 'ACDT', '6556264200', 37800, '1'),
(39, 'ACST', '6571989000', 34200, '0'),
(39, 'ACDT', '6587713800', 37800, '1'),
(39, 'ACST', '6603438600', 34200, '0'),
(39, 'ACDT', '6619163400', 37800, '1'),
(39, 'ACST', '6634888200', 34200, '0'),
(39, 'ACDT', '6650613000', 37800, '1'),
(39, 'ACST', '6666337800', 34200, '0'),
(39, 'ACDT', '6682667400', 37800, '1'),
(39, 'ACST', '6698392200', 34200, '0'),
(39, 'ACDT', '6714117000', 37800, '1'),
(39, 'ACST', '6729841800', 34200, '0'),
(39, 'ACDT', '6745566600', 37800, '1'),
(39, 'ACST', '6761291400', 34200, '0'),
(39, 'ACDT', '6777016200', 37800, '1'),
(39, 'ACST', '6792741000', 34200, '0'),
(39, 'ACDT', '6808465800', 37800, '1'),
(39, 'ACST', '6824190600', 34200, '0'),
(39, 'ACDT', '6839915400', 37800, '1'),
(39, 'ACST', '6855640200', 34200, '0'),
(39, 'ACDT', '6871969800', 37800, '1'),
(39, 'ACST', '6887694600', 34200, '0'),
(39, 'ACDT', '6903419400', 37800, '1'),
(39, 'ACST', '6919144200', 34200, '0'),
(39, 'ACDT', '6934869000', 37800, '1'),
(39, 'ACST', '6950593800', 34200, '0'),
(39, 'ACDT', '6966318600', 37800, '1'),
(39, 'ACST', '6982043400', 34200, '0'),
(39, 'ACDT', '6997768200', 37800, '1'),
(39, 'ACST', '7013493000', 34200, '0'),
(39, 'ACDT', '7029822600', 37800, '1'),
(39, 'ACST', '7045547400', 34200, '0'),
(39, 'ACDT', '7061272200', 37800, '1'),
(39, 'ACST', '7076997000', 34200, '0'),
(39, 'ACDT', '7092721800', 37800, '1'),
(39, 'ACST', '7108446600', 34200, '0'),
(39, 'ACDT', '7124171400', 37800, '1'),
(39, 'ACST', '7139896200', 34200, '0'),
(39, 'ACDT', '7155621000', 37800, '1'),
(39, 'ACST', '7171345800', 34200, '0'),
(39, 'ACDT', '7187070600', 37800, '1'),
(39, 'ACST', '7202795400', 34200, '0'),
(39, 'ACDT', '7219125000', 37800, '1'),
(39, 'ACST', '7234849800', 34200, '0'),
(39, 'ACDT', '7250574600', 37800, '1'),
(39, 'ACST', '7266299400', 34200, '0'),
(39, 'ACDT', '7282024200', 37800, '1'),
(39, 'ACST', '7297749000', 34200, '0'),
(39, 'ACDT', '7313473800', 37800, '1'),
(39, 'ACST', '7329198600', 34200, '0'),
(39, 'ACDT', '7344923400', 37800, '1'),
(39, 'ACST', '7360648200', 34200, '0'),
(39, 'ACDT', '7376373000', 37800, '1'),
(39, 'ACST', '7392097800', 34200, '0'),
(39, 'ACDT', '7408427400', 37800, '1'),
(39, 'ACST', '7424152200', 34200, '0'),
(39, 'ACDT', '7439877000', 37800, '1'),
(39, 'ACST', '7455601800', 34200, '0'),
(39, 'ACDT', '7471326600', 37800, '1'),
(39, 'ACST', '7487051400', 34200, '0'),
(39, 'ACDT', '7502776200', 37800, '1'),
(39, 'ACST', '7518501000', 34200, '0'),
(39, 'ACDT', '7534225800', 37800, '1'),
(39, 'ACST', '7549950600', 34200, '0'),
(39, 'ACDT', '7565675400', 37800, '1'),
(39, 'ACST', '7581400200', 34200, '0'),
(39, 'ACDT', '7597729800', 37800, '1'),
(39, 'ACST', '7613454600', 34200, '0'),
(39, 'ACDT', '7629179400', 37800, '1'),
(39, 'ACST', '7644904200', 34200, '0'),
(39, 'ACDT', '7660629000', 37800, '1'),
(39, 'ACST', '7676353800', 34200, '0'),
(39, 'ACDT', '7692078600', 37800, '1'),
(39, 'ACST', '7707803400', 34200, '0'),
(39, 'ACDT', '7723528200', 37800, '1'),
(39, 'ACST', '7739253000', 34200, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(39, 'ACDT', '7754977800', 37800, '1'),
(39, 'ACST', '7771307400', 34200, '0'),
(39, 'ACDT', '7787032200', 37800, '1'),
(39, 'ACST', '7802757000', 34200, '0'),
(39, 'ACDT', '7818481800', 37800, '1'),
(39, 'ACST', '7834206600', 34200, '0'),
(39, 'ACDT', '7849931400', 37800, '1'),
(39, 'ACST', '7865656200', 34200, '0'),
(39, 'ACDT', '7881381000', 37800, '1'),
(39, 'ACST', '7897105800', 34200, '0'),
(39, 'ACDT', '7912830600', 37800, '1'),
(39, 'ACST', '7928555400', 34200, '0'),
(39, 'ACDT', '7944885000', 37800, '1'),
(39, 'ACST', '7960609800', 34200, '0'),
(39, 'ACDT', '7976334600', 37800, '1'),
(39, 'ACST', '7992059400', 34200, '0'),
(39, 'ACDT', '8007784200', 37800, '1'),
(39, 'ACST', '8023509000', 34200, '0'),
(39, 'ACDT', '8039233800', 37800, '1'),
(39, 'ACST', '8054958600', 34200, '0'),
(39, 'ACDT', '8070683400', 37800, '1'),
(39, 'ACST', '8086408200', 34200, '0'),
(39, 'ACDT', '8102133000', 37800, '1'),
(39, 'ACST', '8117857800', 34200, '0'),
(39, 'ACDT', '8134187400', 37800, '1'),
(39, 'ACST', '8149912200', 34200, '0'),
(39, 'ACDT', '8165637000', 37800, '1'),
(39, 'ACST', '8181361800', 34200, '0'),
(39, 'ACDT', '8197086600', 37800, '1'),
(39, 'ACST', '8212811400', 34200, '0'),
(39, 'ACDT', '8228536200', 37800, '1'),
(39, 'ACST', '8244261000', 34200, '0'),
(39, 'ACDT', '8259985800', 37800, '1'),
(39, 'ACST', '8275710600', 34200, '0'),
(39, 'ACDT', '8292040200', 37800, '1'),
(39, 'ACST', '8307765000', 34200, '0'),
(39, 'ACDT', '8323489800', 37800, '1'),
(39, 'ACST', '8339214600', 34200, '0'),
(39, 'ACDT', '8354939400', 37800, '1'),
(39, 'ACST', '8370664200', 34200, '0'),
(39, 'ACDT', '8386389000', 37800, '1'),
(39, 'ACST', '8402113800', 34200, '0'),
(39, 'ACDT', '8417838600', 37800, '1'),
(39, 'ACST', '8433563400', 34200, '0'),
(39, 'ACDT', '8449288200', 37800, '1'),
(39, 'ACST', '8465013000', 34200, '0'),
(39, 'ACDT', '8481342600', 37800, '1'),
(39, 'ACST', '8497067400', 34200, '0'),
(39, 'ACDT', '8512792200', 37800, '1'),
(39, 'ACST', '8528517000', 34200, '0'),
(39, 'ACDT', '8544241800', 37800, '1'),
(39, 'ACST', '8559966600', 34200, '0'),
(39, 'ACDT', '8575691400', 37800, '1'),
(39, 'ACST', '8591416200', 34200, '0'),
(39, 'ACDT', '8607141000', 37800, '1'),
(39, 'ACST', '8622865800', 34200, '0'),
(39, 'ACDT', '8638590600', 37800, '1'),
(39, 'ACST', '8654920200', 34200, '0'),
(39, 'ACDT', '8670645000', 37800, '1'),
(39, 'ACST', '8686369800', 34200, '0'),
(39, 'ACDT', '8702094600', 37800, '1'),
(39, 'ACST', '8717819400', 34200, '0'),
(39, 'ACDT', '8733544200', 37800, '1'),
(39, 'ACST', '8749269000', 34200, '0'),
(39, 'ACDT', '8764993800', 37800, '1'),
(39, 'ACST', '8780718600', 34200, '0'),
(39, 'ACDT', '8796443400', 37800, '1'),
(39, 'ACST', '8812168200', 34200, '0'),
(39, 'ACDT', '8828497800', 37800, '1'),
(39, 'ACST', '8844222600', 34200, '0'),
(39, 'ACDT', '8859947400', 37800, '1'),
(39, 'ACST', '8875672200', 34200, '0'),
(39, 'ACDT', '8891397000', 37800, '1'),
(39, 'ACST', '8907121800', 34200, '0'),
(39, 'ACDT', '8922846600', 37800, '1'),
(39, 'ACST', '8938571400', 34200, '0'),
(39, 'ACDT', '8954296200', 37800, '1'),
(39, 'ACST', '8970021000', 34200, '0'),
(39, 'ACDT', '8985745800', 37800, '1'),
(39, 'ACST', '9001470600', 34200, '0'),
(39, 'ACDT', '9017800200', 37800, '1'),
(39, 'ACST', '9033525000', 34200, '0'),
(39, 'ACDT', '9049249800', 37800, '1'),
(39, 'ACST', '9064974600', 34200, '0'),
(39, 'ACDT', '9080699400', 37800, '1'),
(39, 'ACST', '9096424200', 34200, '0'),
(39, 'ACDT', '9112149000', 37800, '1'),
(39, 'ACST', '9127873800', 34200, '0'),
(39, 'ACDT', '9143598600', 37800, '1'),
(39, 'ACST', '9159323400', 34200, '0'),
(39, 'ACDT', '9175653000', 37800, '1'),
(39, 'ACST', '9191377800', 34200, '0'),
(39, 'ACDT', '9207102600', 37800, '1'),
(39, 'ACST', '9222827400', 34200, '0'),
(39, 'ACDT', '9238552200', 37800, '1'),
(39, 'ACST', '9254277000', 34200, '0'),
(39, 'ACDT', '9270001800', 37800, '1'),
(39, 'ACST', '9285726600', 34200, '0'),
(39, 'ACDT', '9301451400', 37800, '1'),
(39, 'ACST', '9317176200', 34200, '0'),
(39, 'ACDT', '9332901000', 37800, '1'),
(39, 'ACST', '9348625800', 34200, '0'),
(39, 'ACDT', '9364955400', 37800, '1'),
(39, 'ACST', '9380680200', 34200, '0'),
(39, 'ACDT', '9396405000', 37800, '1'),
(39, 'ACST', '9412129800', 34200, '0'),
(39, 'ACDT', '9427854600', 37800, '1'),
(39, 'ACST', '9443579400', 34200, '0'),
(39, 'ACDT', '9459304200', 37800, '1'),
(39, 'ACST', '9475029000', 34200, '0'),
(39, 'ACDT', '9490753800', 37800, '1'),
(39, 'ACST', '9506478600', 34200, '0'),
(39, 'ACDT', '9522203400', 37800, '1'),
(39, 'ACST', '9538533000', 34200, '0'),
(39, 'ACDT', '9554257800', 37800, '1'),
(39, 'ACST', '9569982600', 34200, '0'),
(39, 'ACDT', '9585707400', 37800, '1'),
(39, 'ACST', '9601432200', 34200, '0'),
(39, 'ACDT', '9617157000', 37800, '1'),
(39, 'ACST', '9632881800', 34200, '0'),
(39, 'ACDT', '9648606600', 37800, '1'),
(39, 'ACST', '9664331400', 34200, '0'),
(39, 'ACDT', '9680056200', 37800, '1'),
(39, 'ACST', '9695781000', 34200, '0'),
(39, 'ACDT', '9712110600', 37800, '1'),
(39, 'ACST', '9727835400', 34200, '0'),
(39, 'ACDT', '9743560200', 37800, '1'),
(39, 'ACST', '9759285000', 34200, '0'),
(39, 'ACDT', '9775009800', 37800, '1'),
(39, 'ACST', '9790734600', 34200, '0'),
(39, 'ACDT', '9806459400', 37800, '1'),
(39, 'ACST', '9822184200', 34200, '0'),
(39, 'ACDT', '9837909000', 37800, '1'),
(39, 'ACST', '9853633800', 34200, '0'),
(39, 'ACDT', '9869358600', 37800, '1'),
(39, 'ACST', '9885083400', 34200, '0'),
(39, 'ACDT', '9901413000', 37800, '1'),
(39, 'ACST', '9917137800', 34200, '0'),
(39, 'ACDT', '9932862600', 37800, '1'),
(39, 'ACST', '9948587400', 34200, '0'),
(39, 'ACDT', '9964312200', 37800, '1'),
(39, 'ACST', '9980037000', 34200, '0'),
(39, 'ACDT', '9995761800', 37800, '1'),
(39, 'ACST', '10011486600', 34200, '0'),
(39, 'ACDT', '10027211400', 37800, '1'),
(39, 'ACST', '10042936200', 34200, '0'),
(39, 'ACDT', '10059265800', 37800, '1'),
(39, 'ACST', '10074990600', 34200, '0'),
(39, 'ACDT', '10090715400', 37800, '1'),
(39, 'ACST', '10106440200', 34200, '0'),
(39, 'ACDT', '10122165000', 37800, '1'),
(39, 'ACST', '10137889800', 34200, '0'),
(39, 'ACDT', '10153614600', 37800, '1'),
(39, 'ACST', '10169339400', 34200, '0'),
(39, 'ACDT', '10185064200', 37800, '1'),
(39, 'ACST', '10200789000', 34200, '0'),
(39, 'ACDT', '10216513800', 37800, '1'),
(39, 'ACST', '10232238600', 34200, '0'),
(39, 'ACDT', '10248568200', 37800, '1'),
(39, 'ACST', '10264293000', 34200, '0'),
(39, 'ACDT', '10280017800', 37800, '1'),
(39, 'ACST', '10295742600', 34200, '0'),
(39, 'ACDT', '10311467400', 37800, '1'),
(39, 'ACST', '10327192200', 34200, '0'),
(39, 'ACDT', '10342917000', 37800, '1'),
(39, 'ACST', '10358641800', 34200, '0'),
(39, 'ACDT', '10374366600', 37800, '1'),
(39, 'ACST', '10390091400', 34200, '0'),
(39, 'ACDT', '10405816200', 37800, '1'),
(39, 'ACST', '10421541000', 34200, '0'),
(39, 'ACDT', '10437870600', 37800, '1'),
(39, 'ACST', '10453595400', 34200, '0'),
(39, 'ACDT', '10469320200', 37800, '1'),
(39, 'ACST', '10485045000', 34200, '0'),
(39, 'ACDT', '10500769800', 37800, '1'),
(39, 'ACST', '10516494600', 34200, '0'),
(39, 'ACDT', '10532219400', 37800, '1'),
(39, 'ACST', '10547944200', 34200, '0'),
(39, 'ACDT', '10563669000', 37800, '1'),
(39, 'ACST', '10579393800', 34200, '0'),
(39, 'ACDT', '10595118600', 37800, '1'),
(39, 'ACST', '10610843400', 34200, '0'),
(39, 'ACDT', '10627173000', 37800, '1'),
(39, 'ACST', '10642897800', 34200, '0'),
(39, 'ACDT', '10658622600', 37800, '1'),
(39, 'ACST', '10674347400', 34200, '0'),
(39, 'ACDT', '10690072200', 37800, '1'),
(39, 'ACST', '10705797000', 34200, '0'),
(39, 'ACDT', '10721521800', 37800, '1'),
(39, 'ACST', '10737246600', 34200, '0'),
(39, 'ACDT', '10752971400', 37800, '1'),
(39, 'ACST', '10768696200', 34200, '0'),
(39, 'ACDT', '10784421000', 37800, '1'),
(39, 'ACST', '10800750600', 34200, '0'),
(39, 'ACDT', '10816475400', 37800, '1'),
(39, 'ACST', '10832200200', 34200, '0'),
(39, 'ACDT', '10847925000', 37800, '1'),
(39, 'ACST', '10863649800', 34200, '0'),
(39, 'ACDT', '10879374600', 37800, '1'),
(39, 'ACST', '10895099400', 34200, '0'),
(39, 'ACDT', '10910824200', 37800, '1'),
(39, 'ACST', '10926549000', 34200, '0'),
(39, 'ACDT', '10942273800', 37800, '1'),
(39, 'ACST', '10957998600', 34200, '0'),
(39, 'ACDT', '10974328200', 37800, '1'),
(39, 'ACST', '10990053000', 34200, '0'),
(39, 'ACDT', '11005777800', 37800, '1'),
(39, 'ACST', '11021502600', 34200, '0'),
(39, 'ACDT', '11037227400', 37800, '1'),
(39, 'ACST', '11052952200', 34200, '0'),
(39, 'ACDT', '11068677000', 37800, '1'),
(39, 'ACST', '11084401800', 34200, '0'),
(39, 'ACDT', '11100126600', 37800, '1'),
(39, 'ACST', '11115851400', 34200, '0'),
(39, 'ACDT', '11131576200', 37800, '1'),
(39, 'ACST', '11147301000', 34200, '0'),
(39, 'ACDT', '11163630600', 37800, '1'),
(39, 'ACST', '11179355400', 34200, '0'),
(39, 'ACDT', '11195080200', 37800, '1'),
(39, 'ACST', '11210805000', 34200, '0'),
(39, 'ACDT', '11226529800', 37800, '1'),
(39, 'ACST', '11242254600', 34200, '0'),
(39, 'ACDT', '11257979400', 37800, '1'),
(39, 'ACST', '11273704200', 34200, '0'),
(39, 'ACDT', '11289429000', 37800, '1'),
(39, 'ACST', '11305153800', 34200, '0'),
(39, 'ACDT', '11321483400', 37800, '1'),
(39, 'ACST', '11337208200', 34200, '0'),
(39, 'ACDT', '11352933000', 37800, '1'),
(39, 'ACST', '11368657800', 34200, '0'),
(39, 'ACDT', '11384382600', 37800, '1'),
(39, 'ACST', '11400107400', 34200, '0'),
(39, 'ACDT', '11415832200', 37800, '1'),
(39, 'ACST', '11431557000', 34200, '0'),
(39, 'ACDT', '11447281800', 37800, '1'),
(39, 'ACST', '11463006600', 34200, '0'),
(39, 'ACDT', '11478731400', 37800, '1'),
(39, 'ACST', '11494456200', 34200, '0'),
(39, 'ACDT', '11510785800', 37800, '1'),
(39, 'ACST', '11526510600', 34200, '0'),
(39, 'ACDT', '11542235400', 37800, '1'),
(39, 'ACST', '11557960200', 34200, '0'),
(39, 'ACDT', '11573685000', 37800, '1'),
(39, 'ACST', '11589409800', 34200, '0'),
(39, 'ACDT', '11605134600', 37800, '1'),
(39, 'ACST', '11620859400', 34200, '0'),
(39, 'ACDT', '11636584200', 37800, '1'),
(39, 'ACST', '11652309000', 34200, '0'),
(39, 'ACDT', '11668033800', 37800, '1'),
(39, 'ACST', '11684363400', 34200, '0'),
(39, 'ACDT', '11700088200', 37800, '1'),
(39, 'ACST', '11715813000', 34200, '0'),
(39, 'ACDT', '11731537800', 37800, '1'),
(39, 'ACST', '11747262600', 34200, '0'),
(39, 'ACDT', '11762987400', 37800, '1'),
(39, 'ACST', '11778712200', 34200, '0'),
(39, 'ACDT', '11794437000', 37800, '1'),
(39, 'ACST', '11810161800', 34200, '0'),
(39, 'ACDT', '11825886600', 37800, '1'),
(39, 'ACST', '11841611400', 34200, '0'),
(39, 'ACDT', '11857941000', 37800, '1'),
(39, 'ACST', '11873665800', 34200, '0'),
(39, 'ACDT', '11889390600', 37800, '1'),
(39, 'ACST', '11905115400', 34200, '0'),
(39, 'ACDT', '11920840200', 37800, '1'),
(39, 'ACST', '11936565000', 34200, '0'),
(39, 'ACDT', '11952289800', 37800, '1'),
(39, 'ACST', '11968014600', 34200, '0'),
(39, 'ACDT', '11983739400', 37800, '1'),
(39, 'ACST', '11999464200', 34200, '0'),
(39, 'ACDT', '12015189000', 37800, '1'),
(39, 'ACST', '12030913800', 34200, '0'),
(39, 'ACDT', '12047243400', 37800, '1'),
(39, 'ACST', '12062968200', 34200, '0'),
(39, 'ACDT', '12078693000', 37800, '1'),
(39, 'ACST', '12094417800', 34200, '0'),
(39, 'ACDT', '12110142600', 37800, '1'),
(39, 'ACST', '12125867400', 34200, '0'),
(39, 'ACDT', '12141592200', 37800, '1'),
(39, 'ACST', '12157317000', 34200, '0'),
(39, 'ACDT', '12173041800', 37800, '1'),
(39, 'ACST', '12188766600', 34200, '0'),
(39, 'ACDT', '12205096200', 37800, '1'),
(39, 'ACST', '12220821000', 34200, '0'),
(39, 'ACDT', '12236545800', 37800, '1'),
(39, 'ACST', '12252270600', 34200, '0'),
(39, 'ACDT', '12267995400', 37800, '1'),
(39, 'ACST', '12283720200', 34200, '0'),
(39, 'ACDT', '12299445000', 37800, '1'),
(39, 'ACST', '12315169800', 34200, '0'),
(39, 'ACDT', '12330894600', 37800, '1'),
(39, 'ACST', '12346619400', 34200, '0'),
(39, 'ACDT', '12362344200', 37800, '1'),
(39, 'ACST', '12378069000', 34200, '0'),
(39, 'ACDT', '12394398600', 37800, '1'),
(39, 'ACST', '12410123400', 34200, '0'),
(39, 'ACDT', '12425848200', 37800, '1'),
(39, 'ACST', '12441573000', 34200, '0'),
(39, 'ACDT', '12457297800', 37800, '1'),
(39, 'ACST', '12473022600', 34200, '0'),
(39, 'ACDT', '12488747400', 37800, '1'),
(39, 'ACST', '12504472200', 34200, '0'),
(39, 'ACDT', '12520197000', 37800, '1'),
(39, 'ACST', '12535921800', 34200, '0'),
(39, 'ACDT', '12551646600', 37800, '1'),
(39, 'ACST', '12567976200', 34200, '0'),
(39, 'ACDT', '12583701000', 37800, '1'),
(39, 'ACST', '12599425800', 34200, '0'),
(39, 'ACDT', '12615150600', 37800, '1'),
(39, 'ACST', '12630875400', 34200, '0'),
(39, 'ACDT', '12646600200', 37800, '1'),
(39, 'ACST', '12662325000', 34200, '0'),
(39, 'ACDT', '12678049800', 37800, '1'),
(39, 'ACST', '12693774600', 34200, '0'),
(39, 'ACDT', '12709499400', 37800, '1'),
(39, 'ACST', '12725224200', 34200, '0'),
(39, 'ACDT', '12741553800', 37800, '1'),
(39, 'ACST', '12757278600', 34200, '0'),
(39, 'ACDT', '12773003400', 37800, '1'),
(39, 'ACST', '12788728200', 34200, '0'),
(39, 'ACDT', '12804453000', 37800, '1'),
(39, 'ACST', '12820177800', 34200, '0'),
(39, 'ACDT', '12835902600', 37800, '1'),
(39, 'ACST', '12851627400', 34200, '0'),
(39, 'ACDT', '12867352200', 37800, '1'),
(39, 'ACST', '12883077000', 34200, '0'),
(39, 'ACDT', '12898801800', 37800, '1'),
(39, 'ACST', '12914526600', 34200, '0'),
(39, 'ACDT', '12930856200', 37800, '1'),
(39, 'ACST', '12946581000', 34200, '0'),
(39, 'ACDT', '12962305800', 37800, '1'),
(39, 'ACST', '12978030600', 34200, '0'),
(39, 'ACDT', '12993755400', 37800, '1'),
(39, 'ACST', '13009480200', 34200, '0'),
(39, 'ACDT', '13025205000', 37800, '1'),
(39, 'ACST', '13040929800', 34200, '0'),
(39, 'ACDT', '13056654600', 37800, '1'),
(39, 'ACST', '13072379400', 34200, '0'),
(39, 'ACDT', '13088709000', 37800, '1'),
(39, 'ACST', '13104433800', 34200, '0'),
(39, 'ACDT', '13120158600', 37800, '1'),
(39, 'ACST', '13135883400', 34200, '0'),
(39, 'ACDT', '13151608200', 37800, '1'),
(39, 'ACST', '13167333000', 34200, '0'),
(39, 'ACDT', '13183057800', 37800, '1'),
(39, 'ACST', '13198782600', 34200, '0'),
(39, 'ACDT', '13214507400', 37800, '1'),
(39, 'ACST', '13230232200', 34200, '0'),
(39, 'ACDT', '13245957000', 37800, '1'),
(39, 'ACST', '13261681800', 34200, '0'),
(39, 'ACDT', '13278011400', 37800, '1'),
(39, 'ACST', '13293736200', 34200, '0'),
(39, 'ACDT', '13309461000', 37800, '1'),
(39, 'ACST', '13325185800', 34200, '0'),
(39, 'ACDT', '13340910600', 37800, '1'),
(39, 'ACST', '13356635400', 34200, '0'),
(39, 'ACDT', '13372360200', 37800, '1'),
(39, 'ACST', '13388085000', 34200, '0'),
(39, 'ACDT', '13403809800', 37800, '1'),
(39, 'ACST', '13419534600', 34200, '0'),
(39, 'ACDT', '13435259400', 37800, '1'),
(39, 'ACST', '13451589000', 34200, '0'),
(39, 'ACDT', '13467313800', 37800, '1'),
(39, 'ACST', '13483038600', 34200, '0'),
(39, 'ACDT', '13498763400', 37800, '1'),
(39, 'ACST', '13514488200', 34200, '0'),
(39, 'ACDT', '13530213000', 37800, '1'),
(39, 'ACST', '13545937800', 34200, '0'),
(39, 'ACDT', '13561662600', 37800, '1'),
(39, 'ACST', '13577387400', 34200, '0'),
(39, 'ACDT', '13593112200', 37800, '1'),
(39, 'ACST', '13608837000', 34200, '0'),
(39, 'ACDT', '13625166600', 37800, '1'),
(39, 'ACST', '13640891400', 34200, '0'),
(39, 'ACDT', '13656616200', 37800, '1'),
(39, 'ACST', '13672341000', 34200, '0'),
(39, 'ACDT', '13688065800', 37800, '1'),
(39, 'ACST', '13703790600', 34200, '0'),
(39, 'ACDT', '13719515400', 37800, '1'),
(39, 'ACST', '13735240200', 34200, '0'),
(39, 'ACDT', '13750965000', 37800, '1'),
(39, 'ACST', '13766689800', 34200, '0'),
(39, 'ACDT', '13782414600', 37800, '1'),
(39, 'ACST', '13798139400', 34200, '0'),
(39, 'ACDT', '13814469000', 37800, '1'),
(39, 'ACST', '13830193800', 34200, '0'),
(39, 'ACDT', '13845918600', 37800, '1'),
(39, 'ACST', '13861643400', 34200, '0'),
(39, 'ACDT', '13877368200', 37800, '1'),
(39, 'ACST', '13893093000', 34200, '0'),
(39, 'ACDT', '13908817800', 37800, '1'),
(39, 'ACST', '13924542600', 34200, '0'),
(39, 'ACDT', '13940267400', 37800, '1'),
(39, 'ACST', '13955992200', 34200, '0'),
(39, 'ACDT', '13972321800', 37800, '1'),
(39, 'ACST', '13988046600', 34200, '0'),
(39, 'ACDT', '14003771400', 37800, '1'),
(39, 'ACST', '14019496200', 34200, '0'),
(39, 'ACDT', '14035221000', 37800, '1'),
(39, 'ACST', '14050945800', 34200, '0'),
(39, 'ACDT', '14066670600', 37800, '1'),
(39, 'ACST', '14082395400', 34200, '0'),
(39, 'ACDT', '14098120200', 37800, '1'),
(39, 'ACST', '14113845000', 34200, '0'),
(39, 'ACDT', '14129569800', 37800, '1'),
(39, 'ACST', '14145294600', 34200, '0'),
(39, 'ACDT', '14161624200', 37800, '1'),
(39, 'ACST', '14177349000', 34200, '0'),
(39, 'ACDT', '14193073800', 37800, '1'),
(39, 'ACST', '14208798600', 34200, '0'),
(39, 'ACDT', '14224523400', 37800, '1'),
(39, 'ACST', '14240248200', 34200, '0'),
(39, 'ACDT', '14255973000', 37800, '1'),
(39, 'ACST', '14271697800', 34200, '0'),
(39, 'ACDT', '14287422600', 37800, '1'),
(39, 'ACST', '14303147400', 34200, '0'),
(39, 'ACDT', '14318872200', 37800, '1'),
(39, 'ACST', '14335201800', 34200, '0'),
(39, 'ACDT', '14350926600', 37800, '1'),
(39, 'ACST', '14366651400', 34200, '0'),
(39, 'ACDT', '14382376200', 37800, '1'),
(39, 'ACST', '14398101000', 34200, '0'),
(39, 'ACDT', '14413825800', 37800, '1'),
(39, 'ACST', '14429550600', 34200, '0'),
(39, 'ACDT', '14445275400', 37800, '1'),
(39, 'ACST', '14461000200', 34200, '0'),
(39, 'ACDT', '14476725000', 37800, '1'),
(39, 'ACST', '14492449800', 34200, '0'),
(39, 'ACDT', '14508779400', 37800, '1'),
(39, 'ACST', '14524504200', 34200, '0'),
(39, 'ACDT', '14540229000', 37800, '1'),
(39, 'ACST', '14555953800', 34200, '0'),
(39, 'ACDT', '14571678600', 37800, '1'),
(39, 'ACST', '14587403400', 34200, '0'),
(39, 'ACDT', '14603128200', 37800, '1'),
(39, 'ACST', '14618853000', 34200, '0'),
(39, 'ACDT', '14634577800', 37800, '1'),
(39, 'ACST', '14650302600', 34200, '0'),
(39, 'ACDT', '14666027400', 37800, '1'),
(39, 'ACST', '14681752200', 34200, '0'),
(39, 'ACDT', '14698081800', 37800, '1'),
(39, 'ACST', '14713806600', 34200, '0'),
(39, 'ACDT', '14729531400', 37800, '1'),
(39, 'ACST', '14745256200', 34200, '0'),
(39, 'ACDT', '14760981000', 37800, '1'),
(39, 'ACST', '14776705800', 34200, '0'),
(39, 'ACDT', '14792430600', 37800, '1'),
(39, 'ACST', '14808155400', 34200, '0'),
(39, 'ACDT', '14823880200', 37800, '1'),
(39, 'ACST', '14839605000', 34200, '0'),
(39, 'ACDT', '14855934600', 37800, '1'),
(39, 'ACST', '14871659400', 34200, '0'),
(39, 'ACDT', '14887384200', 37800, '1'),
(39, 'ACST', '14903109000', 34200, '0'),
(39, 'ACDT', '14918833800', 37800, '1'),
(39, 'ACST', '14934558600', 34200, '0'),
(39, 'ACDT', '14950283400', 37800, '1'),
(39, 'ACST', '14966008200', 34200, '0'),
(39, 'ACDT', '14981733000', 37800, '1'),
(39, 'ACST', '14997457800', 34200, '0'),
(39, 'ACDT', '15013182600', 37800, '1'),
(39, 'ACST', '15028907400', 34200, '0'),
(39, 'ACDT', '15045237000', 37800, '1'),
(39, 'ACST', '15060961800', 34200, '0'),
(39, 'ACDT', '15076686600', 37800, '1'),
(39, 'ACST', '15092411400', 34200, '0'),
(39, 'ACDT', '15108136200', 37800, '1'),
(39, 'ACST', '15123861000', 34200, '0'),
(39, 'ACDT', '15139585800', 37800, '1'),
(39, 'ACST', '15155310600', 34200, '0'),
(39, 'ACDT', '15171035400', 37800, '1'),
(39, 'ACST', '15186760200', 34200, '0'),
(39, 'ACDT', '15202485000', 37800, '1'),
(39, 'ACST', '15218814600', 34200, '0'),
(39, 'ACDT', '15234539400', 37800, '1'),
(39, 'ACST', '15250264200', 34200, '0'),
(39, 'ACDT', '15265989000', 37800, '1'),
(39, 'ACST', '15281713800', 34200, '0'),
(39, 'ACDT', '15297438600', 37800, '1'),
(39, 'ACST', '15313163400', 34200, '0'),
(39, 'ACDT', '15328888200', 37800, '1'),
(39, 'ACST', '15344613000', 34200, '0'),
(39, 'ACDT', '15360337800', 37800, '1'),
(39, 'ACST', '15376062600', 34200, '0'),
(39, 'ACDT', '15392392200', 37800, '1'),
(39, 'ACST', '15408117000', 34200, '0'),
(39, 'ACDT', '15423841800', 37800, '1'),
(39, 'ACST', '15439566600', 34200, '0'),
(39, 'ACDT', '15455291400', 37800, '1'),
(39, 'ACST', '15471016200', 34200, '0'),
(39, 'ACDT', '15486741000', 37800, '1'),
(39, 'ACST', '15502465800', 34200, '0'),
(39, 'ACDT', '15518190600', 37800, '1'),
(39, 'ACST', '15533915400', 34200, '0'),
(39, 'ACDT', '15549640200', 37800, '1'),
(39, 'ACST', '15565365000', 34200, '0'),
(39, 'ACDT', '15581694600', 37800, '1'),
(39, 'ACST', '15597419400', 34200, '0'),
(39, 'ACDT', '15613144200', 37800, '1'),
(39, 'ACST', '15628869000', 34200, '0'),
(39, 'ACDT', '15644593800', 37800, '1'),
(39, 'ACST', '15660318600', 34200, '0'),
(39, 'ACDT', '15676043400', 37800, '1'),
(39, 'ACST', '15691768200', 34200, '0'),
(39, 'ACDT', '15707493000', 37800, '1'),
(39, 'ACST', '15723217800', 34200, '0'),
(39, 'ACDT', '15739547400', 37800, '1'),
(39, 'ACST', '15755272200', 34200, '0'),
(39, 'ACDT', '15770997000', 37800, '1'),
(39, 'ACST', '15786721800', 34200, '0'),
(39, 'ACDT', '15802446600', 37800, '1'),
(39, 'ACST', '15818171400', 34200, '0'),
(39, 'ACDT', '15833896200', 37800, '1'),
(39, 'ACST', '15849621000', 34200, '0'),
(39, 'ACDT', '15865345800', 37800, '1'),
(39, 'ACST', '15881070600', 34200, '0'),
(39, 'ACDT', '15896795400', 37800, '1'),
(39, 'ACST', '15912520200', 34200, '0'),
(39, 'ACDT', '15928849800', 37800, '1'),
(39, 'ACST', '15944574600', 34200, '0'),
(39, 'ACDT', '15960299400', 37800, '1'),
(39, 'ACST', '15976024200', 34200, '0'),
(39, 'ACDT', '15991749000', 37800, '1'),
(39, 'ACST', '16007473800', 34200, '0'),
(39, 'ACDT', '16023198600', 37800, '1'),
(39, 'ACST', '16038923400', 34200, '0'),
(39, 'ACDT', '16054648200', 37800, '1'),
(39, 'ACST', '16070373000', 34200, '0'),
(39, 'ACDT', '16086097800', 37800, '1'),
(39, 'ACST', '16102427400', 34200, '0'),
(39, 'ACDT', '16118152200', 37800, '1'),
(39, 'ACST', '16133877000', 34200, '0'),
(39, 'ACDT', '16149601800', 37800, '1'),
(39, 'ACST', '16165326600', 34200, '0'),
(39, 'ACDT', '16181051400', 37800, '1'),
(39, 'ACST', '16196776200', 34200, '0'),
(39, 'ACDT', '16212501000', 37800, '1'),
(39, 'ACST', '16228225800', 34200, '0'),
(39, 'ACDT', '16243950600', 37800, '1'),
(39, 'ACST', '16259675400', 34200, '0'),
(39, 'ACDT', '16276005000', 37800, '1'),
(39, 'ACST', '16291729800', 34200, '0'),
(39, 'ACDT', '16307454600', 37800, '1'),
(39, 'ACST', '16323179400', 34200, '0'),
(39, 'ACDT', '16338904200', 37800, '1'),
(39, 'ACST', '16354629000', 34200, '0'),
(39, 'ACDT', '16370353800', 37800, '1'),
(39, 'ACST', '16386078600', 34200, '0'),
(39, 'ACDT', '16401803400', 37800, '1'),
(39, 'ACST', '16417528200', 34200, '0'),
(39, 'ACDT', '16433253000', 37800, '1'),
(39, 'ACST', '16448977800', 34200, '0'),
(39, 'ACDT', '16465307400', 37800, '1'),
(39, 'ACST', '16481032200', 34200, '0'),
(39, 'ACDT', '16496757000', 37800, '1'),
(39, 'ACST', '16512481800', 34200, '0'),
(39, 'ACDT', '16528206600', 37800, '1'),
(39, 'ACST', '16543931400', 34200, '0'),
(39, 'ACDT', '16559656200', 37800, '1'),
(39, 'ACST', '16575381000', 34200, '0'),
(39, 'ACDT', '16591105800', 37800, '1'),
(39, 'ACST', '16606830600', 34200, '0'),
(39, 'ACDT', '16623160200', 37800, '1'),
(39, 'ACST', '16638885000', 34200, '0'),
(39, 'ACDT', '16654609800', 37800, '1'),
(39, 'ACST', '16670334600', 34200, '0'),
(39, 'ACDT', '16686059400', 37800, '1'),
(39, 'ACST', '16701784200', 34200, '0'),
(39, 'ACDT', '16717509000', 37800, '1'),
(40, 'LMT', '-2366791929', 36728, '0'),
(40, 'AEST', '-2366791928', 36000, '0'),
(40, 'AEDT', '-1672567140', 39600, '1'),
(40, 'AEST', '-1665392400', 36000, '0'),
(40, 'AEDT', '-883641600', 39600, '1'),
(40, 'AEST', '-876128400', 36000, '0'),
(40, 'AEDT', '-860400000', 39600, '1'),
(40, 'AEST', '-844678800', 36000, '0'),
(40, 'AEDT', '-828345600', 39600, '1'),
(40, 'AEST', '-813229200', 36000, '0'),
(40, 'AEDT', '57686400', 39600, '1'),
(40, 'AEST', '67968000', 36000, '0'),
(40, 'AEDT', '625593600', 39600, '1'),
(40, 'AEST', '636480000', 36000, '0'),
(40, 'AEDT', '657043200', 39600, '1'),
(40, 'AEST', '667929600', 36000, '0'),
(40, 'AEDT', '688492800', 39600, '1'),
(40, 'AEST', '699379200', 36000, '0'),
(41, 'LMT', '-2366790957', 35756, '0'),
(41, 'AEST', '-2366790956', 36000, '0'),
(41, 'AEDT', '-1672567140', 39600, '1'),
(41, 'AEST', '-1665392400', 36000, '0'),
(41, 'AEDT', '-883641600', 39600, '1'),
(41, 'AEST', '-876128400', 36000, '0'),
(41, 'AEDT', '-860400000', 39600, '1'),
(41, 'AEST', '-844678800', 36000, '0'),
(41, 'AEDT', '-828345600', 39600, '1'),
(41, 'AEST', '-813229200', 36000, '0'),
(41, 'AEDT', '57686400', 39600, '1'),
(41, 'AEST', '67968000', 36000, '0'),
(41, 'AEDT', '625593600', 39600, '1'),
(41, 'AEST', '636480000', 36000, '0'),
(41, 'AEDT', '657043200', 39600, '1'),
(41, 'AEST', '667929600', 36000, '0'),
(41, 'AEDT', '688492800', 39600, '1'),
(41, 'AEST', '699379200', 36000, '0'),
(41, 'AEDT', '719942400', 39600, '1'),
(41, 'AEST', '731433600', 36000, '0'),
(41, 'AEDT', '751996800', 39600, '1'),
(41, 'AEST', '762883200', 36000, '0'),
(42, 'LMT', '-2364110061', 33260, '0'),
(42, 'ACST', '-2364110060', 32400, '0'),
(42, 'ACST', '-2230189200', 34200, '0'),
(42, 'ACDT', '-1672565340', 37800, '1'),
(42, 'ACST', '-1665390600', 34200, '0'),
(42, 'ACDT', '-883639800', 37800, '1'),
(42, 'ACST', '-876126600', 34200, '0'),
(42, 'ACDT', '-860398200', 37800, '1'),
(42, 'ACST', '-844677000', 34200, '0'),
(42, 'ACDT', '-828343800', 37800, '1'),
(42, 'ACST', '-813227400', 34200, '0'),
(42, 'ACDT', '57688200', 37800, '1'),
(42, 'ACST', '67969800', 34200, '0'),
(42, 'ACDT', '89137800', 37800, '1'),
(42, 'ACST', '100024200', 34200, '0'),
(42, 'ACDT', '120587400', 37800, '1'),
(42, 'ACST', '131473800', 34200, '0'),
(42, 'ACDT', '152037000', 37800, '1'),
(42, 'ACST', '162923400', 34200, '0'),
(42, 'ACDT', '183486600', 37800, '1'),
(42, 'ACST', '194977800', 34200, '0'),
(42, 'ACDT', '215541000', 37800, '1'),
(42, 'ACST', '226427400', 34200, '0'),
(42, 'ACDT', '246990600', 37800, '1'),
(42, 'ACST', '257877000', 34200, '0'),
(42, 'ACDT', '278440200', 37800, '1'),
(42, 'ACST', '289326600', 34200, '0'),
(42, 'ACDT', '309889800', 37800, '1'),
(42, 'ACST', '320776200', 34200, '0'),
(42, 'ACDT', '341339400', 37800, '1'),
(42, 'ACST', '352225800', 34200, '0'),
(42, 'ACDT', '372789000', 37800, '1'),
(42, 'ACST', '384280200', 34200, '0'),
(42, 'ACDT', '404843400', 37800, '1'),
(42, 'ACST', '415729800', 34200, '0'),
(42, 'ACDT', '436293000', 37800, '1'),
(42, 'ACST', '447179400', 34200, '0'),
(42, 'ACDT', '467742600', 37800, '1'),
(42, 'ACST', '478629000', 34200, '0'),
(42, 'ACDT', '499192200', 37800, '1'),
(42, 'ACST', '511288200', 34200, '0'),
(42, 'ACDT', '530037000', 37800, '1'),
(42, 'ACST', '542737800', 34200, '0'),
(42, 'ACDT', '562091400', 37800, '1'),
(42, 'ACST', '574792200', 34200, '0'),
(42, 'ACDT', '594145800', 37800, '1'),
(42, 'ACST', '606241800', 34200, '0'),
(42, 'ACDT', '625595400', 37800, '1'),
(42, 'ACST', '637691400', 34200, '0'),
(42, 'ACDT', '657045000', 37800, '1'),
(42, 'ACST', '667931400', 34200, '0'),
(42, 'ACDT', '688494600', 37800, '1'),
(42, 'ACST', '701195400', 34200, '0'),
(42, 'ACDT', '719944200', 37800, '1'),
(42, 'ACST', '731435400', 34200, '0'),
(42, 'ACDT', '751998600', 37800, '1'),
(42, 'ACST', '764094600', 34200, '0'),
(42, 'ACDT', '783448200', 37800, '1'),
(42, 'ACST', '796149000', 34200, '0'),
(42, 'ACDT', '814897800', 37800, '1'),
(42, 'ACST', '828203400', 34200, '0'),
(42, 'ACDT', '846347400', 37800, '1'),
(42, 'ACST', '859653000', 34200, '0'),
(42, 'ACDT', '877797000', 37800, '1'),
(42, 'ACST', '891102600', 34200, '0'),
(42, 'ACDT', '909246600', 37800, '1'),
(42, 'ACST', '922552200', 34200, '0'),
(42, 'ACDT', '941301000', 37800, '1'),
(42, 'ACST', '954001800', 34200, '0'),
(42, 'ACDT', '972750600', 37800, '1'),
(42, 'ACST', '985451400', 34200, '0'),
(42, 'ACDT', '1004200200', 37800, '1'),
(42, 'ACST', '1017505800', 34200, '0'),
(42, 'ACDT', '1035649800', 37800, '1'),
(42, 'ACST', '1048955400', 34200, '0'),
(42, 'ACDT', '1067099400', 37800, '1'),
(42, 'ACST', '1080405000', 34200, '0'),
(42, 'ACDT', '1099153800', 37800, '1'),
(42, 'ACST', '1111854600', 34200, '0'),
(42, 'ACDT', '1130603400', 37800, '1'),
(42, 'ACST', '1143909000', 34200, '0'),
(42, 'ACDT', '1162053000', 37800, '1'),
(42, 'ACST', '1174753800', 34200, '0'),
(42, 'ACDT', '1193502600', 37800, '1'),
(42, 'ACST', '1207413000', 34200, '0'),
(42, 'ACDT', '1223137800', 37800, '1'),
(42, 'ACST', '1238862600', 34200, '0'),
(42, 'ACDT', '1254587400', 37800, '1'),
(42, 'ACST', '1270312200', 34200, '0'),
(42, 'ACDT', '1286037000', 37800, '1'),
(42, 'ACST', '1301761800', 34200, '0'),
(42, 'ACDT', '1317486600', 37800, '1'),
(42, 'ACST', '1333211400', 34200, '0'),
(42, 'ACDT', '1349541000', 37800, '1'),
(42, 'ACST', '1365265800', 34200, '0'),
(42, 'ACDT', '1380990600', 37800, '1'),
(42, 'ACST', '1396715400', 34200, '0'),
(42, 'ACDT', '1412440200', 37800, '1'),
(42, 'ACST', '1428165000', 34200, '0'),
(42, 'ACDT', '1443889800', 37800, '1'),
(42, 'ACST', '1459614600', 34200, '0'),
(42, 'ACDT', '1475339400', 37800, '1'),
(42, 'ACST', '1491064200', 34200, '0'),
(42, 'ACDT', '1506789000', 37800, '1'),
(42, 'ACST', '1522513800', 34200, '0'),
(42, 'ACDT', '1538843400', 37800, '1'),
(42, 'ACST', '1554568200', 34200, '0'),
(42, 'ACDT', '1570293000', 37800, '1'),
(42, 'ACST', '1586017800', 34200, '0'),
(42, 'ACDT', '1601742600', 37800, '1'),
(42, 'ACST', '1617467400', 34200, '0'),
(42, 'ACDT', '1633192200', 37800, '1'),
(42, 'ACST', '1648917000', 34200, '0'),
(42, 'ACDT', '1664641800', 37800, '1'),
(42, 'ACST', '1680366600', 34200, '0'),
(42, 'ACDT', '1696091400', 37800, '1'),
(42, 'ACST', '1712421000', 34200, '0'),
(42, 'ACDT', '1728145800', 37800, '1'),
(42, 'ACST', '1743870600', 34200, '0'),
(42, 'ACDT', '1759595400', 37800, '1'),
(42, 'ACST', '1775320200', 34200, '0'),
(42, 'ACDT', '1791045000', 37800, '1'),
(42, 'ACST', '1806769800', 34200, '0'),
(42, 'ACDT', '1822494600', 37800, '1'),
(42, 'ACST', '1838219400', 34200, '0'),
(42, 'ACDT', '1853944200', 37800, '1'),
(42, 'ACST', '1869669000', 34200, '0'),
(42, 'ACDT', '1885998600', 37800, '1'),
(42, 'ACST', '1901723400', 34200, '0'),
(42, 'ACDT', '1917448200', 37800, '1'),
(42, 'ACST', '1933173000', 34200, '0'),
(42, 'ACDT', '1948897800', 37800, '1'),
(42, 'ACST', '1964622600', 34200, '0'),
(42, 'ACDT', '1980347400', 37800, '1'),
(42, 'ACST', '1996072200', 34200, '0'),
(42, 'ACDT', '2011797000', 37800, '1'),
(42, 'ACST', '2027521800', 34200, '0'),
(42, 'ACDT', '2043246600', 37800, '1'),
(42, 'ACST', '2058971400', 34200, '0'),
(42, 'ACDT', '2075301000', 37800, '1'),
(42, 'ACST', '2091025800', 34200, '0'),
(42, 'ACDT', '2106750600', 37800, '1'),
(42, 'ACST', '2122475400', 34200, '0'),
(42, 'ACDT', '2138200200', 37800, '1'),
(42, 'ACST', '2153925000', 34200, '0'),
(42, 'ACDT', '2169649800', 37800, '1'),
(42, 'ACST', '2185374600', 34200, '0'),
(42, 'ACDT', '2201099400', 37800, '1'),
(42, 'ACST', '2216824200', 34200, '0'),
(42, 'ACDT', '2233153800', 37800, '1'),
(42, 'ACST', '2248878600', 34200, '0'),
(42, 'ACDT', '2264603400', 37800, '1'),
(42, 'ACST', '2280328200', 34200, '0'),
(42, 'ACDT', '2296053000', 37800, '1'),
(42, 'ACST', '2311777800', 34200, '0'),
(42, 'ACDT', '2327502600', 37800, '1'),
(42, 'ACST', '2343227400', 34200, '0'),
(42, 'ACDT', '2358952200', 37800, '1'),
(42, 'ACST', '2374677000', 34200, '0'),
(42, 'ACDT', '2390401800', 37800, '1'),
(42, 'ACST', '2406126600', 34200, '0'),
(42, 'ACDT', '2422456200', 37800, '1'),
(42, 'ACST', '2438181000', 34200, '0'),
(42, 'ACDT', '2453905800', 37800, '1'),
(42, 'ACST', '2469630600', 34200, '0'),
(42, 'ACDT', '2485355400', 37800, '1'),
(42, 'ACST', '2501080200', 34200, '0'),
(42, 'ACDT', '2516805000', 37800, '1'),
(42, 'ACST', '2532529800', 34200, '0'),
(42, 'ACDT', '2548254600', 37800, '1'),
(42, 'ACST', '2563979400', 34200, '0'),
(42, 'ACDT', '2579704200', 37800, '1'),
(42, 'ACST', '2596033800', 34200, '0'),
(42, 'ACDT', '2611758600', 37800, '1'),
(42, 'ACST', '2627483400', 34200, '0'),
(42, 'ACDT', '2643208200', 37800, '1'),
(42, 'ACST', '2658933000', 34200, '0'),
(42, 'ACDT', '2674657800', 37800, '1'),
(42, 'ACST', '2690382600', 34200, '0'),
(42, 'ACDT', '2706107400', 37800, '1'),
(42, 'ACST', '2721832200', 34200, '0'),
(42, 'ACDT', '2737557000', 37800, '1'),
(42, 'ACST', '2753281800', 34200, '0'),
(42, 'ACDT', '2769611400', 37800, '1'),
(42, 'ACST', '2785336200', 34200, '0'),
(42, 'ACDT', '2801061000', 37800, '1'),
(42, 'ACST', '2816785800', 34200, '0'),
(42, 'ACDT', '2832510600', 37800, '1'),
(42, 'ACST', '2848235400', 34200, '0'),
(42, 'ACDT', '2863960200', 37800, '1'),
(42, 'ACST', '2879685000', 34200, '0'),
(42, 'ACDT', '2895409800', 37800, '1'),
(42, 'ACST', '2911134600', 34200, '0'),
(42, 'ACDT', '2926859400', 37800, '1'),
(42, 'ACST', '2942584200', 34200, '0'),
(42, 'ACDT', '2958913800', 37800, '1'),
(42, 'ACST', '2974638600', 34200, '0'),
(42, 'ACDT', '2990363400', 37800, '1'),
(42, 'ACST', '3006088200', 34200, '0'),
(42, 'ACDT', '3021813000', 37800, '1'),
(42, 'ACST', '3037537800', 34200, '0'),
(42, 'ACDT', '3053262600', 37800, '1'),
(42, 'ACST', '3068987400', 34200, '0'),
(42, 'ACDT', '3084712200', 37800, '1'),
(42, 'ACST', '3100437000', 34200, '0'),
(42, 'ACDT', '3116766600', 37800, '1'),
(42, 'ACST', '3132491400', 34200, '0'),
(42, 'ACDT', '3148216200', 37800, '1'),
(42, 'ACST', '3163941000', 34200, '0'),
(42, 'ACDT', '3179665800', 37800, '1'),
(42, 'ACST', '3195390600', 34200, '0'),
(42, 'ACDT', '3211115400', 37800, '1'),
(42, 'ACST', '3226840200', 34200, '0'),
(42, 'ACDT', '3242565000', 37800, '1'),
(42, 'ACST', '3258289800', 34200, '0'),
(42, 'ACDT', '3274014600', 37800, '1'),
(42, 'ACST', '3289739400', 34200, '0'),
(42, 'ACDT', '3306069000', 37800, '1'),
(42, 'ACST', '3321793800', 34200, '0'),
(42, 'ACDT', '3337518600', 37800, '1'),
(42, 'ACST', '3353243400', 34200, '0'),
(42, 'ACDT', '3368968200', 37800, '1'),
(42, 'ACST', '3384693000', 34200, '0'),
(42, 'ACDT', '3400417800', 37800, '1'),
(42, 'ACST', '3416142600', 34200, '0'),
(42, 'ACDT', '3431867400', 37800, '1'),
(42, 'ACST', '3447592200', 34200, '0'),
(42, 'ACDT', '3463317000', 37800, '1'),
(42, 'ACST', '3479646600', 34200, '0'),
(42, 'ACDT', '3495371400', 37800, '1'),
(42, 'ACST', '3511096200', 34200, '0'),
(42, 'ACDT', '3526821000', 37800, '1'),
(42, 'ACST', '3542545800', 34200, '0'),
(42, 'ACDT', '3558270600', 37800, '1'),
(42, 'ACST', '3573995400', 34200, '0'),
(42, 'ACDT', '3589720200', 37800, '1'),
(42, 'ACST', '3605445000', 34200, '0'),
(42, 'ACDT', '3621169800', 37800, '1'),
(42, 'ACST', '3636894600', 34200, '0'),
(42, 'ACDT', '3653224200', 37800, '1'),
(42, 'ACST', '3668949000', 34200, '0'),
(42, 'ACDT', '3684673800', 37800, '1'),
(42, 'ACST', '3700398600', 34200, '0'),
(42, 'ACDT', '3716123400', 37800, '1'),
(42, 'ACST', '3731848200', 34200, '0'),
(42, 'ACDT', '3747573000', 37800, '1'),
(42, 'ACST', '3763297800', 34200, '0'),
(42, 'ACDT', '3779022600', 37800, '1'),
(42, 'ACST', '3794747400', 34200, '0'),
(42, 'ACDT', '3810472200', 37800, '1'),
(42, 'ACST', '3826197000', 34200, '0'),
(42, 'ACDT', '3842526600', 37800, '1'),
(42, 'ACST', '3858251400', 34200, '0'),
(42, 'ACDT', '3873976200', 37800, '1'),
(42, 'ACST', '3889701000', 34200, '0'),
(42, 'ACDT', '3905425800', 37800, '1'),
(42, 'ACST', '3921150600', 34200, '0'),
(42, 'ACDT', '3936875400', 37800, '1'),
(42, 'ACST', '3952600200', 34200, '0'),
(42, 'ACDT', '3968325000', 37800, '1'),
(42, 'ACST', '3984049800', 34200, '0'),
(42, 'ACDT', '4000379400', 37800, '1'),
(42, 'ACST', '4016104200', 34200, '0'),
(42, 'ACDT', '4031829000', 37800, '1'),
(42, 'ACST', '4047553800', 34200, '0'),
(42, 'ACDT', '4063278600', 37800, '1'),
(42, 'ACST', '4079003400', 34200, '0'),
(42, 'ACDT', '4094728200', 37800, '1'),
(42, 'ACST', '4110453000', 34200, '0'),
(42, 'ACDT', '4126177800', 37800, '1'),
(42, 'ACST', '4141902600', 34200, '0'),
(42, 'ACDT', '4157627400', 37800, '1'),
(42, 'ACST', '4173352200', 34200, '0'),
(42, 'ACDT', '4189077000', 37800, '1'),
(42, 'ACST', '4204801800', 34200, '0'),
(42, 'ACDT', '4221131400', 37800, '1'),
(42, 'ACST', '4236856200', 34200, '0'),
(42, 'ACDT', '4252581000', 37800, '1'),
(42, 'ACST', '4268305800', 34200, '0'),
(42, 'ACDT', '4284030600', 37800, '1'),
(42, 'ACST', '4299755400', 34200, '0'),
(42, 'ACDT', '4315480200', 37800, '1'),
(42, 'ACST', '4331205000', 34200, '0'),
(42, 'ACDT', '4346929800', 37800, '1'),
(42, 'ACST', '4362654600', 34200, '0'),
(42, 'ACDT', '4378984200', 37800, '1'),
(42, 'ACST', '4394709000', 34200, '0'),
(42, 'ACDT', '4410433800', 37800, '1'),
(42, 'ACST', '4426158600', 34200, '0'),
(42, 'ACDT', '4441883400', 37800, '1'),
(42, 'ACST', '4457608200', 34200, '0'),
(42, 'ACDT', '4473333000', 37800, '1'),
(42, 'ACST', '4489057800', 34200, '0'),
(42, 'ACDT', '4504782600', 37800, '1'),
(42, 'ACST', '4520507400', 34200, '0'),
(42, 'ACDT', '4536232200', 37800, '1'),
(42, 'ACST', '4551957000', 34200, '0'),
(42, 'ACDT', '4568286600', 37800, '1'),
(42, 'ACST', '4584011400', 34200, '0'),
(42, 'ACDT', '4599736200', 37800, '1'),
(42, 'ACST', '4615461000', 34200, '0'),
(42, 'ACDT', '4631185800', 37800, '1'),
(42, 'ACST', '4646910600', 34200, '0'),
(42, 'ACDT', '4662635400', 37800, '1'),
(42, 'ACST', '4678360200', 34200, '0'),
(42, 'ACDT', '4694085000', 37800, '1'),
(42, 'ACST', '4709809800', 34200, '0'),
(42, 'ACDT', '4725534600', 37800, '1'),
(42, 'ACST', '4741864200', 34200, '0'),
(42, 'ACDT', '4757589000', 37800, '1'),
(42, 'ACST', '4773313800', 34200, '0'),
(42, 'ACDT', '4789038600', 37800, '1'),
(42, 'ACST', '4804763400', 34200, '0'),
(42, 'ACDT', '4820488200', 37800, '1'),
(42, 'ACST', '4836213000', 34200, '0'),
(42, 'ACDT', '4851937800', 37800, '1'),
(42, 'ACST', '4867662600', 34200, '0'),
(42, 'ACDT', '4883387400', 37800, '1'),
(42, 'ACST', '4899112200', 34200, '0'),
(42, 'ACDT', '4915441800', 37800, '1'),
(42, 'ACST', '4931166600', 34200, '0'),
(42, 'ACDT', '4946891400', 37800, '1'),
(42, 'ACST', '4962616200', 34200, '0'),
(42, 'ACDT', '4978341000', 37800, '1'),
(42, 'ACST', '4994065800', 34200, '0'),
(42, 'ACDT', '5009790600', 37800, '1'),
(42, 'ACST', '5025515400', 34200, '0'),
(42, 'ACDT', '5041240200', 37800, '1'),
(42, 'ACST', '5056965000', 34200, '0'),
(42, 'ACDT', '5072689800', 37800, '1'),
(42, 'ACST', '5088414600', 34200, '0'),
(42, 'ACDT', '5104744200', 37800, '1'),
(42, 'ACST', '5120469000', 34200, '0'),
(42, 'ACDT', '5136193800', 37800, '1'),
(42, 'ACST', '5151918600', 34200, '0'),
(42, 'ACDT', '5167643400', 37800, '1'),
(42, 'ACST', '5183368200', 34200, '0'),
(42, 'ACDT', '5199093000', 37800, '1'),
(42, 'ACST', '5214817800', 34200, '0'),
(42, 'ACDT', '5230542600', 37800, '1'),
(42, 'ACST', '5246267400', 34200, '0'),
(42, 'ACDT', '5262597000', 37800, '1'),
(42, 'ACST', '5278321800', 34200, '0'),
(42, 'ACDT', '5294046600', 37800, '1'),
(42, 'ACST', '5309771400', 34200, '0'),
(42, 'ACDT', '5325496200', 37800, '1'),
(42, 'ACST', '5341221000', 34200, '0'),
(42, 'ACDT', '5356945800', 37800, '1'),
(42, 'ACST', '5372670600', 34200, '0'),
(42, 'ACDT', '5388395400', 37800, '1'),
(42, 'ACST', '5404120200', 34200, '0'),
(42, 'ACDT', '5419845000', 37800, '1'),
(42, 'ACST', '5435569800', 34200, '0'),
(42, 'ACDT', '5451899400', 37800, '1'),
(42, 'ACST', '5467624200', 34200, '0'),
(42, 'ACDT', '5483349000', 37800, '1'),
(42, 'ACST', '5499073800', 34200, '0'),
(42, 'ACDT', '5514798600', 37800, '1'),
(42, 'ACST', '5530523400', 34200, '0'),
(42, 'ACDT', '5546248200', 37800, '1'),
(42, 'ACST', '5561973000', 34200, '0'),
(42, 'ACDT', '5577697800', 37800, '1'),
(42, 'ACST', '5593422600', 34200, '0'),
(42, 'ACDT', '5609147400', 37800, '1'),
(42, 'ACST', '5625477000', 34200, '0'),
(42, 'ACDT', '5641201800', 37800, '1'),
(42, 'ACST', '5656926600', 34200, '0'),
(42, 'ACDT', '5672651400', 37800, '1'),
(42, 'ACST', '5688376200', 34200, '0'),
(42, 'ACDT', '5704101000', 37800, '1'),
(42, 'ACST', '5719825800', 34200, '0'),
(42, 'ACDT', '5735550600', 37800, '1'),
(42, 'ACST', '5751275400', 34200, '0'),
(42, 'ACDT', '5767000200', 37800, '1'),
(42, 'ACST', '5782725000', 34200, '0'),
(42, 'ACDT', '5799054600', 37800, '1'),
(42, 'ACST', '5814779400', 34200, '0'),
(42, 'ACDT', '5830504200', 37800, '1'),
(42, 'ACST', '5846229000', 34200, '0'),
(42, 'ACDT', '5861953800', 37800, '1'),
(42, 'ACST', '5877678600', 34200, '0'),
(42, 'ACDT', '5893403400', 37800, '1'),
(42, 'ACST', '5909128200', 34200, '0'),
(42, 'ACDT', '5924853000', 37800, '1'),
(42, 'ACST', '5940577800', 34200, '0'),
(42, 'ACDT', '5956302600', 37800, '1'),
(42, 'ACST', '5972027400', 34200, '0'),
(42, 'ACDT', '5988357000', 37800, '1'),
(42, 'ACST', '6004081800', 34200, '0'),
(42, 'ACDT', '6019806600', 37800, '1'),
(42, 'ACST', '6035531400', 34200, '0'),
(42, 'ACDT', '6051256200', 37800, '1'),
(42, 'ACST', '6066981000', 34200, '0'),
(42, 'ACDT', '6082705800', 37800, '1'),
(42, 'ACST', '6098430600', 34200, '0'),
(42, 'ACDT', '6114155400', 37800, '1'),
(42, 'ACST', '6129880200', 34200, '0'),
(42, 'ACDT', '6146209800', 37800, '1'),
(42, 'ACST', '6161934600', 34200, '0'),
(42, 'ACDT', '6177659400', 37800, '1'),
(42, 'ACST', '6193384200', 34200, '0'),
(42, 'ACDT', '6209109000', 37800, '1'),
(42, 'ACST', '6224833800', 34200, '0'),
(42, 'ACDT', '6240558600', 37800, '1'),
(42, 'ACST', '6256283400', 34200, '0'),
(42, 'ACDT', '6272008200', 37800, '1'),
(42, 'ACST', '6287733000', 34200, '0'),
(42, 'ACDT', '6303457800', 37800, '1'),
(42, 'ACST', '6319182600', 34200, '0'),
(42, 'ACDT', '6335512200', 37800, '1'),
(42, 'ACST', '6351237000', 34200, '0'),
(42, 'ACDT', '6366961800', 37800, '1'),
(42, 'ACST', '6382686600', 34200, '0'),
(42, 'ACDT', '6398411400', 37800, '1'),
(42, 'ACST', '6414136200', 34200, '0'),
(42, 'ACDT', '6429861000', 37800, '1'),
(42, 'ACST', '6445585800', 34200, '0'),
(42, 'ACDT', '6461310600', 37800, '1'),
(42, 'ACST', '6477035400', 34200, '0'),
(42, 'ACDT', '6492760200', 37800, '1'),
(42, 'ACST', '6509089800', 34200, '0'),
(42, 'ACDT', '6524814600', 37800, '1'),
(42, 'ACST', '6540539400', 34200, '0'),
(42, 'ACDT', '6556264200', 37800, '1'),
(42, 'ACST', '6571989000', 34200, '0'),
(42, 'ACDT', '6587713800', 37800, '1'),
(42, 'ACST', '6603438600', 34200, '0'),
(42, 'ACDT', '6619163400', 37800, '1'),
(42, 'ACST', '6634888200', 34200, '0'),
(42, 'ACDT', '6650613000', 37800, '1'),
(42, 'ACST', '6666337800', 34200, '0'),
(42, 'ACDT', '6682667400', 37800, '1'),
(42, 'ACST', '6698392200', 34200, '0'),
(42, 'ACDT', '6714117000', 37800, '1'),
(42, 'ACST', '6729841800', 34200, '0'),
(42, 'ACDT', '6745566600', 37800, '1'),
(42, 'ACST', '6761291400', 34200, '0'),
(42, 'ACDT', '6777016200', 37800, '1'),
(42, 'ACST', '6792741000', 34200, '0'),
(42, 'ACDT', '6808465800', 37800, '1'),
(42, 'ACST', '6824190600', 34200, '0'),
(42, 'ACDT', '6839915400', 37800, '1'),
(42, 'ACST', '6855640200', 34200, '0'),
(42, 'ACDT', '6871969800', 37800, '1'),
(42, 'ACST', '6887694600', 34200, '0'),
(42, 'ACDT', '6903419400', 37800, '1'),
(42, 'ACST', '6919144200', 34200, '0'),
(42, 'ACDT', '6934869000', 37800, '1'),
(42, 'ACST', '6950593800', 34200, '0'),
(42, 'ACDT', '6966318600', 37800, '1'),
(42, 'ACST', '6982043400', 34200, '0'),
(42, 'ACDT', '6997768200', 37800, '1'),
(42, 'ACST', '7013493000', 34200, '0'),
(42, 'ACDT', '7029822600', 37800, '1'),
(42, 'ACST', '7045547400', 34200, '0'),
(42, 'ACDT', '7061272200', 37800, '1'),
(42, 'ACST', '7076997000', 34200, '0'),
(42, 'ACDT', '7092721800', 37800, '1'),
(42, 'ACST', '7108446600', 34200, '0'),
(42, 'ACDT', '7124171400', 37800, '1'),
(42, 'ACST', '7139896200', 34200, '0'),
(42, 'ACDT', '7155621000', 37800, '1'),
(42, 'ACST', '7171345800', 34200, '0'),
(42, 'ACDT', '7187070600', 37800, '1'),
(42, 'ACST', '7202795400', 34200, '0'),
(42, 'ACDT', '7219125000', 37800, '1'),
(42, 'ACST', '7234849800', 34200, '0'),
(42, 'ACDT', '7250574600', 37800, '1'),
(42, 'ACST', '7266299400', 34200, '0'),
(42, 'ACDT', '7282024200', 37800, '1'),
(42, 'ACST', '7297749000', 34200, '0'),
(42, 'ACDT', '7313473800', 37800, '1'),
(42, 'ACST', '7329198600', 34200, '0'),
(42, 'ACDT', '7344923400', 37800, '1'),
(42, 'ACST', '7360648200', 34200, '0'),
(42, 'ACDT', '7376373000', 37800, '1'),
(42, 'ACST', '7392097800', 34200, '0'),
(42, 'ACDT', '7408427400', 37800, '1'),
(42, 'ACST', '7424152200', 34200, '0'),
(42, 'ACDT', '7439877000', 37800, '1'),
(42, 'ACST', '7455601800', 34200, '0'),
(42, 'ACDT', '7471326600', 37800, '1'),
(42, 'ACST', '7487051400', 34200, '0'),
(42, 'ACDT', '7502776200', 37800, '1'),
(42, 'ACST', '7518501000', 34200, '0'),
(42, 'ACDT', '7534225800', 37800, '1'),
(42, 'ACST', '7549950600', 34200, '0'),
(42, 'ACDT', '7565675400', 37800, '1'),
(42, 'ACST', '7581400200', 34200, '0'),
(42, 'ACDT', '7597729800', 37800, '1'),
(42, 'ACST', '7613454600', 34200, '0'),
(42, 'ACDT', '7629179400', 37800, '1'),
(42, 'ACST', '7644904200', 34200, '0'),
(42, 'ACDT', '7660629000', 37800, '1'),
(42, 'ACST', '7676353800', 34200, '0'),
(42, 'ACDT', '7692078600', 37800, '1'),
(42, 'ACST', '7707803400', 34200, '0'),
(42, 'ACDT', '7723528200', 37800, '1'),
(42, 'ACST', '7739253000', 34200, '0'),
(42, 'ACDT', '7754977800', 37800, '1'),
(42, 'ACST', '7771307400', 34200, '0'),
(42, 'ACDT', '7787032200', 37800, '1'),
(42, 'ACST', '7802757000', 34200, '0'),
(42, 'ACDT', '7818481800', 37800, '1'),
(42, 'ACST', '7834206600', 34200, '0'),
(42, 'ACDT', '7849931400', 37800, '1'),
(42, 'ACST', '7865656200', 34200, '0'),
(42, 'ACDT', '7881381000', 37800, '1'),
(42, 'ACST', '7897105800', 34200, '0'),
(42, 'ACDT', '7912830600', 37800, '1'),
(42, 'ACST', '7928555400', 34200, '0'),
(42, 'ACDT', '7944885000', 37800, '1'),
(42, 'ACST', '7960609800', 34200, '0'),
(42, 'ACDT', '7976334600', 37800, '1'),
(42, 'ACST', '7992059400', 34200, '0'),
(42, 'ACDT', '8007784200', 37800, '1'),
(42, 'ACST', '8023509000', 34200, '0'),
(42, 'ACDT', '8039233800', 37800, '1'),
(42, 'ACST', '8054958600', 34200, '0'),
(42, 'ACDT', '8070683400', 37800, '1'),
(42, 'ACST', '8086408200', 34200, '0'),
(42, 'ACDT', '8102133000', 37800, '1'),
(42, 'ACST', '8117857800', 34200, '0'),
(42, 'ACDT', '8134187400', 37800, '1'),
(42, 'ACST', '8149912200', 34200, '0'),
(42, 'ACDT', '8165637000', 37800, '1'),
(42, 'ACST', '8181361800', 34200, '0'),
(42, 'ACDT', '8197086600', 37800, '1'),
(42, 'ACST', '8212811400', 34200, '0'),
(42, 'ACDT', '8228536200', 37800, '1'),
(42, 'ACST', '8244261000', 34200, '0'),
(42, 'ACDT', '8259985800', 37800, '1'),
(42, 'ACST', '8275710600', 34200, '0'),
(42, 'ACDT', '8292040200', 37800, '1'),
(42, 'ACST', '8307765000', 34200, '0'),
(42, 'ACDT', '8323489800', 37800, '1'),
(42, 'ACST', '8339214600', 34200, '0'),
(42, 'ACDT', '8354939400', 37800, '1'),
(42, 'ACST', '8370664200', 34200, '0'),
(42, 'ACDT', '8386389000', 37800, '1'),
(42, 'ACST', '8402113800', 34200, '0'),
(42, 'ACDT', '8417838600', 37800, '1'),
(42, 'ACST', '8433563400', 34200, '0'),
(42, 'ACDT', '8449288200', 37800, '1'),
(42, 'ACST', '8465013000', 34200, '0'),
(42, 'ACDT', '8481342600', 37800, '1'),
(42, 'ACST', '8497067400', 34200, '0'),
(42, 'ACDT', '8512792200', 37800, '1'),
(42, 'ACST', '8528517000', 34200, '0'),
(42, 'ACDT', '8544241800', 37800, '1'),
(42, 'ACST', '8559966600', 34200, '0'),
(42, 'ACDT', '8575691400', 37800, '1'),
(42, 'ACST', '8591416200', 34200, '0'),
(42, 'ACDT', '8607141000', 37800, '1'),
(42, 'ACST', '8622865800', 34200, '0'),
(42, 'ACDT', '8638590600', 37800, '1'),
(42, 'ACST', '8654920200', 34200, '0'),
(42, 'ACDT', '8670645000', 37800, '1'),
(42, 'ACST', '8686369800', 34200, '0'),
(42, 'ACDT', '8702094600', 37800, '1'),
(42, 'ACST', '8717819400', 34200, '0'),
(42, 'ACDT', '8733544200', 37800, '1'),
(42, 'ACST', '8749269000', 34200, '0'),
(42, 'ACDT', '8764993800', 37800, '1'),
(42, 'ACST', '8780718600', 34200, '0'),
(42, 'ACDT', '8796443400', 37800, '1'),
(42, 'ACST', '8812168200', 34200, '0'),
(42, 'ACDT', '8828497800', 37800, '1'),
(42, 'ACST', '8844222600', 34200, '0'),
(42, 'ACDT', '8859947400', 37800, '1'),
(42, 'ACST', '8875672200', 34200, '0'),
(42, 'ACDT', '8891397000', 37800, '1'),
(42, 'ACST', '8907121800', 34200, '0'),
(42, 'ACDT', '8922846600', 37800, '1'),
(42, 'ACST', '8938571400', 34200, '0'),
(42, 'ACDT', '8954296200', 37800, '1'),
(42, 'ACST', '8970021000', 34200, '0'),
(42, 'ACDT', '8985745800', 37800, '1'),
(42, 'ACST', '9001470600', 34200, '0'),
(42, 'ACDT', '9017800200', 37800, '1'),
(42, 'ACST', '9033525000', 34200, '0'),
(42, 'ACDT', '9049249800', 37800, '1'),
(42, 'ACST', '9064974600', 34200, '0'),
(42, 'ACDT', '9080699400', 37800, '1'),
(42, 'ACST', '9096424200', 34200, '0'),
(42, 'ACDT', '9112149000', 37800, '1'),
(42, 'ACST', '9127873800', 34200, '0'),
(42, 'ACDT', '9143598600', 37800, '1'),
(42, 'ACST', '9159323400', 34200, '0'),
(42, 'ACDT', '9175653000', 37800, '1'),
(42, 'ACST', '9191377800', 34200, '0'),
(42, 'ACDT', '9207102600', 37800, '1'),
(42, 'ACST', '9222827400', 34200, '0'),
(42, 'ACDT', '9238552200', 37800, '1'),
(42, 'ACST', '9254277000', 34200, '0'),
(42, 'ACDT', '9270001800', 37800, '1'),
(42, 'ACST', '9285726600', 34200, '0'),
(42, 'ACDT', '9301451400', 37800, '1'),
(42, 'ACST', '9317176200', 34200, '0'),
(42, 'ACDT', '9332901000', 37800, '1'),
(42, 'ACST', '9348625800', 34200, '0'),
(42, 'ACDT', '9364955400', 37800, '1'),
(42, 'ACST', '9380680200', 34200, '0'),
(42, 'ACDT', '9396405000', 37800, '1'),
(42, 'ACST', '9412129800', 34200, '0'),
(42, 'ACDT', '9427854600', 37800, '1'),
(42, 'ACST', '9443579400', 34200, '0'),
(42, 'ACDT', '9459304200', 37800, '1'),
(42, 'ACST', '9475029000', 34200, '0'),
(42, 'ACDT', '9490753800', 37800, '1'),
(42, 'ACST', '9506478600', 34200, '0'),
(42, 'ACDT', '9522203400', 37800, '1'),
(42, 'ACST', '9538533000', 34200, '0'),
(42, 'ACDT', '9554257800', 37800, '1'),
(42, 'ACST', '9569982600', 34200, '0'),
(42, 'ACDT', '9585707400', 37800, '1'),
(42, 'ACST', '9601432200', 34200, '0'),
(42, 'ACDT', '9617157000', 37800, '1'),
(42, 'ACST', '9632881800', 34200, '0'),
(42, 'ACDT', '9648606600', 37800, '1'),
(42, 'ACST', '9664331400', 34200, '0'),
(42, 'ACDT', '9680056200', 37800, '1'),
(42, 'ACST', '9695781000', 34200, '0'),
(42, 'ACDT', '9712110600', 37800, '1'),
(42, 'ACST', '9727835400', 34200, '0'),
(42, 'ACDT', '9743560200', 37800, '1'),
(42, 'ACST', '9759285000', 34200, '0'),
(42, 'ACDT', '9775009800', 37800, '1'),
(42, 'ACST', '9790734600', 34200, '0'),
(42, 'ACDT', '9806459400', 37800, '1'),
(42, 'ACST', '9822184200', 34200, '0'),
(42, 'ACDT', '9837909000', 37800, '1'),
(42, 'ACST', '9853633800', 34200, '0'),
(42, 'ACDT', '9869358600', 37800, '1'),
(42, 'ACST', '9885083400', 34200, '0'),
(42, 'ACDT', '9901413000', 37800, '1'),
(42, 'ACST', '9917137800', 34200, '0'),
(42, 'ACDT', '9932862600', 37800, '1'),
(42, 'ACST', '9948587400', 34200, '0'),
(42, 'ACDT', '9964312200', 37800, '1'),
(42, 'ACST', '9980037000', 34200, '0'),
(42, 'ACDT', '9995761800', 37800, '1'),
(42, 'ACST', '10011486600', 34200, '0'),
(42, 'ACDT', '10027211400', 37800, '1'),
(42, 'ACST', '10042936200', 34200, '0'),
(42, 'ACDT', '10059265800', 37800, '1'),
(42, 'ACST', '10074990600', 34200, '0'),
(42, 'ACDT', '10090715400', 37800, '1'),
(42, 'ACST', '10106440200', 34200, '0'),
(42, 'ACDT', '10122165000', 37800, '1'),
(42, 'ACST', '10137889800', 34200, '0'),
(42, 'ACDT', '10153614600', 37800, '1'),
(42, 'ACST', '10169339400', 34200, '0'),
(42, 'ACDT', '10185064200', 37800, '1'),
(42, 'ACST', '10200789000', 34200, '0'),
(42, 'ACDT', '10216513800', 37800, '1'),
(42, 'ACST', '10232238600', 34200, '0'),
(42, 'ACDT', '10248568200', 37800, '1'),
(42, 'ACST', '10264293000', 34200, '0'),
(42, 'ACDT', '10280017800', 37800, '1'),
(42, 'ACST', '10295742600', 34200, '0'),
(42, 'ACDT', '10311467400', 37800, '1'),
(42, 'ACST', '10327192200', 34200, '0'),
(42, 'ACDT', '10342917000', 37800, '1'),
(42, 'ACST', '10358641800', 34200, '0'),
(42, 'ACDT', '10374366600', 37800, '1'),
(42, 'ACST', '10390091400', 34200, '0'),
(42, 'ACDT', '10405816200', 37800, '1'),
(42, 'ACST', '10421541000', 34200, '0'),
(42, 'ACDT', '10437870600', 37800, '1'),
(42, 'ACST', '10453595400', 34200, '0'),
(42, 'ACDT', '10469320200', 37800, '1'),
(42, 'ACST', '10485045000', 34200, '0'),
(42, 'ACDT', '10500769800', 37800, '1'),
(42, 'ACST', '10516494600', 34200, '0'),
(42, 'ACDT', '10532219400', 37800, '1'),
(42, 'ACST', '10547944200', 34200, '0'),
(42, 'ACDT', '10563669000', 37800, '1'),
(42, 'ACST', '10579393800', 34200, '0'),
(42, 'ACDT', '10595118600', 37800, '1'),
(42, 'ACST', '10610843400', 34200, '0'),
(42, 'ACDT', '10627173000', 37800, '1'),
(42, 'ACST', '10642897800', 34200, '0'),
(42, 'ACDT', '10658622600', 37800, '1'),
(42, 'ACST', '10674347400', 34200, '0'),
(42, 'ACDT', '10690072200', 37800, '1'),
(42, 'ACST', '10705797000', 34200, '0'),
(42, 'ACDT', '10721521800', 37800, '1'),
(42, 'ACST', '10737246600', 34200, '0'),
(42, 'ACDT', '10752971400', 37800, '1'),
(42, 'ACST', '10768696200', 34200, '0'),
(42, 'ACDT', '10784421000', 37800, '1'),
(42, 'ACST', '10800750600', 34200, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(42, 'ACDT', '10816475400', 37800, '1'),
(42, 'ACST', '10832200200', 34200, '0'),
(42, 'ACDT', '10847925000', 37800, '1'),
(42, 'ACST', '10863649800', 34200, '0'),
(42, 'ACDT', '10879374600', 37800, '1'),
(42, 'ACST', '10895099400', 34200, '0'),
(42, 'ACDT', '10910824200', 37800, '1'),
(42, 'ACST', '10926549000', 34200, '0'),
(42, 'ACDT', '10942273800', 37800, '1'),
(42, 'ACST', '10957998600', 34200, '0'),
(42, 'ACDT', '10974328200', 37800, '1'),
(42, 'ACST', '10990053000', 34200, '0'),
(42, 'ACDT', '11005777800', 37800, '1'),
(42, 'ACST', '11021502600', 34200, '0'),
(42, 'ACDT', '11037227400', 37800, '1'),
(42, 'ACST', '11052952200', 34200, '0'),
(42, 'ACDT', '11068677000', 37800, '1'),
(42, 'ACST', '11084401800', 34200, '0'),
(42, 'ACDT', '11100126600', 37800, '1'),
(42, 'ACST', '11115851400', 34200, '0'),
(42, 'ACDT', '11131576200', 37800, '1'),
(42, 'ACST', '11147301000', 34200, '0'),
(42, 'ACDT', '11163630600', 37800, '1'),
(42, 'ACST', '11179355400', 34200, '0'),
(42, 'ACDT', '11195080200', 37800, '1'),
(42, 'ACST', '11210805000', 34200, '0'),
(42, 'ACDT', '11226529800', 37800, '1'),
(42, 'ACST', '11242254600', 34200, '0'),
(42, 'ACDT', '11257979400', 37800, '1'),
(42, 'ACST', '11273704200', 34200, '0'),
(42, 'ACDT', '11289429000', 37800, '1'),
(42, 'ACST', '11305153800', 34200, '0'),
(42, 'ACDT', '11321483400', 37800, '1'),
(42, 'ACST', '11337208200', 34200, '0'),
(42, 'ACDT', '11352933000', 37800, '1'),
(42, 'ACST', '11368657800', 34200, '0'),
(42, 'ACDT', '11384382600', 37800, '1'),
(42, 'ACST', '11400107400', 34200, '0'),
(42, 'ACDT', '11415832200', 37800, '1'),
(42, 'ACST', '11431557000', 34200, '0'),
(42, 'ACDT', '11447281800', 37800, '1'),
(42, 'ACST', '11463006600', 34200, '0'),
(42, 'ACDT', '11478731400', 37800, '1'),
(42, 'ACST', '11494456200', 34200, '0'),
(42, 'ACDT', '11510785800', 37800, '1'),
(42, 'ACST', '11526510600', 34200, '0'),
(42, 'ACDT', '11542235400', 37800, '1'),
(42, 'ACST', '11557960200', 34200, '0'),
(42, 'ACDT', '11573685000', 37800, '1'),
(42, 'ACST', '11589409800', 34200, '0'),
(42, 'ACDT', '11605134600', 37800, '1'),
(42, 'ACST', '11620859400', 34200, '0'),
(42, 'ACDT', '11636584200', 37800, '1'),
(42, 'ACST', '11652309000', 34200, '0'),
(42, 'ACDT', '11668033800', 37800, '1'),
(42, 'ACST', '11684363400', 34200, '0'),
(42, 'ACDT', '11700088200', 37800, '1'),
(42, 'ACST', '11715813000', 34200, '0'),
(42, 'ACDT', '11731537800', 37800, '1'),
(42, 'ACST', '11747262600', 34200, '0'),
(42, 'ACDT', '11762987400', 37800, '1'),
(42, 'ACST', '11778712200', 34200, '0'),
(42, 'ACDT', '11794437000', 37800, '1'),
(42, 'ACST', '11810161800', 34200, '0'),
(42, 'ACDT', '11825886600', 37800, '1'),
(42, 'ACST', '11841611400', 34200, '0'),
(42, 'ACDT', '11857941000', 37800, '1'),
(42, 'ACST', '11873665800', 34200, '0'),
(42, 'ACDT', '11889390600', 37800, '1'),
(42, 'ACST', '11905115400', 34200, '0'),
(42, 'ACDT', '11920840200', 37800, '1'),
(42, 'ACST', '11936565000', 34200, '0'),
(42, 'ACDT', '11952289800', 37800, '1'),
(42, 'ACST', '11968014600', 34200, '0'),
(42, 'ACDT', '11983739400', 37800, '1'),
(42, 'ACST', '11999464200', 34200, '0'),
(42, 'ACDT', '12015189000', 37800, '1'),
(42, 'ACST', '12030913800', 34200, '0'),
(42, 'ACDT', '12047243400', 37800, '1'),
(42, 'ACST', '12062968200', 34200, '0'),
(42, 'ACDT', '12078693000', 37800, '1'),
(42, 'ACST', '12094417800', 34200, '0'),
(42, 'ACDT', '12110142600', 37800, '1'),
(42, 'ACST', '12125867400', 34200, '0'),
(42, 'ACDT', '12141592200', 37800, '1'),
(42, 'ACST', '12157317000', 34200, '0'),
(42, 'ACDT', '12173041800', 37800, '1'),
(42, 'ACST', '12188766600', 34200, '0'),
(42, 'ACDT', '12205096200', 37800, '1'),
(42, 'ACST', '12220821000', 34200, '0'),
(42, 'ACDT', '12236545800', 37800, '1'),
(42, 'ACST', '12252270600', 34200, '0'),
(42, 'ACDT', '12267995400', 37800, '1'),
(42, 'ACST', '12283720200', 34200, '0'),
(42, 'ACDT', '12299445000', 37800, '1'),
(42, 'ACST', '12315169800', 34200, '0'),
(42, 'ACDT', '12330894600', 37800, '1'),
(42, 'ACST', '12346619400', 34200, '0'),
(42, 'ACDT', '12362344200', 37800, '1'),
(42, 'ACST', '12378069000', 34200, '0'),
(42, 'ACDT', '12394398600', 37800, '1'),
(42, 'ACST', '12410123400', 34200, '0'),
(42, 'ACDT', '12425848200', 37800, '1'),
(42, 'ACST', '12441573000', 34200, '0'),
(42, 'ACDT', '12457297800', 37800, '1'),
(42, 'ACST', '12473022600', 34200, '0'),
(42, 'ACDT', '12488747400', 37800, '1'),
(42, 'ACST', '12504472200', 34200, '0'),
(42, 'ACDT', '12520197000', 37800, '1'),
(42, 'ACST', '12535921800', 34200, '0'),
(42, 'ACDT', '12551646600', 37800, '1'),
(42, 'ACST', '12567976200', 34200, '0'),
(42, 'ACDT', '12583701000', 37800, '1'),
(42, 'ACST', '12599425800', 34200, '0'),
(42, 'ACDT', '12615150600', 37800, '1'),
(42, 'ACST', '12630875400', 34200, '0'),
(42, 'ACDT', '12646600200', 37800, '1'),
(42, 'ACST', '12662325000', 34200, '0'),
(42, 'ACDT', '12678049800', 37800, '1'),
(42, 'ACST', '12693774600', 34200, '0'),
(42, 'ACDT', '12709499400', 37800, '1'),
(42, 'ACST', '12725224200', 34200, '0'),
(42, 'ACDT', '12741553800', 37800, '1'),
(42, 'ACST', '12757278600', 34200, '0'),
(42, 'ACDT', '12773003400', 37800, '1'),
(42, 'ACST', '12788728200', 34200, '0'),
(42, 'ACDT', '12804453000', 37800, '1'),
(42, 'ACST', '12820177800', 34200, '0'),
(42, 'ACDT', '12835902600', 37800, '1'),
(42, 'ACST', '12851627400', 34200, '0'),
(42, 'ACDT', '12867352200', 37800, '1'),
(42, 'ACST', '12883077000', 34200, '0'),
(42, 'ACDT', '12898801800', 37800, '1'),
(42, 'ACST', '12914526600', 34200, '0'),
(42, 'ACDT', '12930856200', 37800, '1'),
(42, 'ACST', '12946581000', 34200, '0'),
(42, 'ACDT', '12962305800', 37800, '1'),
(42, 'ACST', '12978030600', 34200, '0'),
(42, 'ACDT', '12993755400', 37800, '1'),
(42, 'ACST', '13009480200', 34200, '0'),
(42, 'ACDT', '13025205000', 37800, '1'),
(42, 'ACST', '13040929800', 34200, '0'),
(42, 'ACDT', '13056654600', 37800, '1'),
(42, 'ACST', '13072379400', 34200, '0'),
(42, 'ACDT', '13088709000', 37800, '1'),
(42, 'ACST', '13104433800', 34200, '0'),
(42, 'ACDT', '13120158600', 37800, '1'),
(42, 'ACST', '13135883400', 34200, '0'),
(42, 'ACDT', '13151608200', 37800, '1'),
(42, 'ACST', '13167333000', 34200, '0'),
(42, 'ACDT', '13183057800', 37800, '1'),
(42, 'ACST', '13198782600', 34200, '0'),
(42, 'ACDT', '13214507400', 37800, '1'),
(42, 'ACST', '13230232200', 34200, '0'),
(42, 'ACDT', '13245957000', 37800, '1'),
(42, 'ACST', '13261681800', 34200, '0'),
(42, 'ACDT', '13278011400', 37800, '1'),
(42, 'ACST', '13293736200', 34200, '0'),
(42, 'ACDT', '13309461000', 37800, '1'),
(42, 'ACST', '13325185800', 34200, '0'),
(42, 'ACDT', '13340910600', 37800, '1'),
(42, 'ACST', '13356635400', 34200, '0'),
(42, 'ACDT', '13372360200', 37800, '1'),
(42, 'ACST', '13388085000', 34200, '0'),
(42, 'ACDT', '13403809800', 37800, '1'),
(42, 'ACST', '13419534600', 34200, '0'),
(42, 'ACDT', '13435259400', 37800, '1'),
(42, 'ACST', '13451589000', 34200, '0'),
(42, 'ACDT', '13467313800', 37800, '1'),
(42, 'ACST', '13483038600', 34200, '0'),
(42, 'ACDT', '13498763400', 37800, '1'),
(42, 'ACST', '13514488200', 34200, '0'),
(42, 'ACDT', '13530213000', 37800, '1'),
(42, 'ACST', '13545937800', 34200, '0'),
(42, 'ACDT', '13561662600', 37800, '1'),
(42, 'ACST', '13577387400', 34200, '0'),
(42, 'ACDT', '13593112200', 37800, '1'),
(42, 'ACST', '13608837000', 34200, '0'),
(42, 'ACDT', '13625166600', 37800, '1'),
(42, 'ACST', '13640891400', 34200, '0'),
(42, 'ACDT', '13656616200', 37800, '1'),
(42, 'ACST', '13672341000', 34200, '0'),
(42, 'ACDT', '13688065800', 37800, '1'),
(42, 'ACST', '13703790600', 34200, '0'),
(42, 'ACDT', '13719515400', 37800, '1'),
(42, 'ACST', '13735240200', 34200, '0'),
(42, 'ACDT', '13750965000', 37800, '1'),
(42, 'ACST', '13766689800', 34200, '0'),
(42, 'ACDT', '13782414600', 37800, '1'),
(42, 'ACST', '13798139400', 34200, '0'),
(42, 'ACDT', '13814469000', 37800, '1'),
(42, 'ACST', '13830193800', 34200, '0'),
(42, 'ACDT', '13845918600', 37800, '1'),
(42, 'ACST', '13861643400', 34200, '0'),
(42, 'ACDT', '13877368200', 37800, '1'),
(42, 'ACST', '13893093000', 34200, '0'),
(42, 'ACDT', '13908817800', 37800, '1'),
(42, 'ACST', '13924542600', 34200, '0'),
(42, 'ACDT', '13940267400', 37800, '1'),
(42, 'ACST', '13955992200', 34200, '0'),
(42, 'ACDT', '13972321800', 37800, '1'),
(42, 'ACST', '13988046600', 34200, '0'),
(42, 'ACDT', '14003771400', 37800, '1'),
(42, 'ACST', '14019496200', 34200, '0'),
(42, 'ACDT', '14035221000', 37800, '1'),
(42, 'ACST', '14050945800', 34200, '0'),
(42, 'ACDT', '14066670600', 37800, '1'),
(42, 'ACST', '14082395400', 34200, '0'),
(42, 'ACDT', '14098120200', 37800, '1'),
(42, 'ACST', '14113845000', 34200, '0'),
(42, 'ACDT', '14129569800', 37800, '1'),
(42, 'ACST', '14145294600', 34200, '0'),
(42, 'ACDT', '14161624200', 37800, '1'),
(42, 'ACST', '14177349000', 34200, '0'),
(42, 'ACDT', '14193073800', 37800, '1'),
(42, 'ACST', '14208798600', 34200, '0'),
(42, 'ACDT', '14224523400', 37800, '1'),
(42, 'ACST', '14240248200', 34200, '0'),
(42, 'ACDT', '14255973000', 37800, '1'),
(42, 'ACST', '14271697800', 34200, '0'),
(42, 'ACDT', '14287422600', 37800, '1'),
(42, 'ACST', '14303147400', 34200, '0'),
(42, 'ACDT', '14318872200', 37800, '1'),
(42, 'ACST', '14335201800', 34200, '0'),
(42, 'ACDT', '14350926600', 37800, '1'),
(42, 'ACST', '14366651400', 34200, '0'),
(42, 'ACDT', '14382376200', 37800, '1'),
(42, 'ACST', '14398101000', 34200, '0'),
(42, 'ACDT', '14413825800', 37800, '1'),
(42, 'ACST', '14429550600', 34200, '0'),
(42, 'ACDT', '14445275400', 37800, '1'),
(42, 'ACST', '14461000200', 34200, '0'),
(42, 'ACDT', '14476725000', 37800, '1'),
(42, 'ACST', '14492449800', 34200, '0'),
(42, 'ACDT', '14508779400', 37800, '1'),
(42, 'ACST', '14524504200', 34200, '0'),
(42, 'ACDT', '14540229000', 37800, '1'),
(42, 'ACST', '14555953800', 34200, '0'),
(42, 'ACDT', '14571678600', 37800, '1'),
(42, 'ACST', '14587403400', 34200, '0'),
(42, 'ACDT', '14603128200', 37800, '1'),
(42, 'ACST', '14618853000', 34200, '0'),
(42, 'ACDT', '14634577800', 37800, '1'),
(42, 'ACST', '14650302600', 34200, '0'),
(42, 'ACDT', '14666027400', 37800, '1'),
(42, 'ACST', '14681752200', 34200, '0'),
(42, 'ACDT', '14698081800', 37800, '1'),
(42, 'ACST', '14713806600', 34200, '0'),
(42, 'ACDT', '14729531400', 37800, '1'),
(42, 'ACST', '14745256200', 34200, '0'),
(42, 'ACDT', '14760981000', 37800, '1'),
(42, 'ACST', '14776705800', 34200, '0'),
(42, 'ACDT', '14792430600', 37800, '1'),
(42, 'ACST', '14808155400', 34200, '0'),
(42, 'ACDT', '14823880200', 37800, '1'),
(42, 'ACST', '14839605000', 34200, '0'),
(42, 'ACDT', '14855934600', 37800, '1'),
(42, 'ACST', '14871659400', 34200, '0'),
(42, 'ACDT', '14887384200', 37800, '1'),
(42, 'ACST', '14903109000', 34200, '0'),
(42, 'ACDT', '14918833800', 37800, '1'),
(42, 'ACST', '14934558600', 34200, '0'),
(42, 'ACDT', '14950283400', 37800, '1'),
(42, 'ACST', '14966008200', 34200, '0'),
(42, 'ACDT', '14981733000', 37800, '1'),
(42, 'ACST', '14997457800', 34200, '0'),
(42, 'ACDT', '15013182600', 37800, '1'),
(42, 'ACST', '15028907400', 34200, '0'),
(42, 'ACDT', '15045237000', 37800, '1'),
(42, 'ACST', '15060961800', 34200, '0'),
(42, 'ACDT', '15076686600', 37800, '1'),
(42, 'ACST', '15092411400', 34200, '0'),
(42, 'ACDT', '15108136200', 37800, '1'),
(42, 'ACST', '15123861000', 34200, '0'),
(42, 'ACDT', '15139585800', 37800, '1'),
(42, 'ACST', '15155310600', 34200, '0'),
(42, 'ACDT', '15171035400', 37800, '1'),
(42, 'ACST', '15186760200', 34200, '0'),
(42, 'ACDT', '15202485000', 37800, '1'),
(42, 'ACST', '15218814600', 34200, '0'),
(42, 'ACDT', '15234539400', 37800, '1'),
(42, 'ACST', '15250264200', 34200, '0'),
(42, 'ACDT', '15265989000', 37800, '1'),
(42, 'ACST', '15281713800', 34200, '0'),
(42, 'ACDT', '15297438600', 37800, '1'),
(42, 'ACST', '15313163400', 34200, '0'),
(42, 'ACDT', '15328888200', 37800, '1'),
(42, 'ACST', '15344613000', 34200, '0'),
(42, 'ACDT', '15360337800', 37800, '1'),
(42, 'ACST', '15376062600', 34200, '0'),
(42, 'ACDT', '15392392200', 37800, '1'),
(42, 'ACST', '15408117000', 34200, '0'),
(42, 'ACDT', '15423841800', 37800, '1'),
(42, 'ACST', '15439566600', 34200, '0'),
(42, 'ACDT', '15455291400', 37800, '1'),
(42, 'ACST', '15471016200', 34200, '0'),
(42, 'ACDT', '15486741000', 37800, '1'),
(42, 'ACST', '15502465800', 34200, '0'),
(42, 'ACDT', '15518190600', 37800, '1'),
(42, 'ACST', '15533915400', 34200, '0'),
(42, 'ACDT', '15549640200', 37800, '1'),
(42, 'ACST', '15565365000', 34200, '0'),
(42, 'ACDT', '15581694600', 37800, '1'),
(42, 'ACST', '15597419400', 34200, '0'),
(42, 'ACDT', '15613144200', 37800, '1'),
(42, 'ACST', '15628869000', 34200, '0'),
(42, 'ACDT', '15644593800', 37800, '1'),
(42, 'ACST', '15660318600', 34200, '0'),
(42, 'ACDT', '15676043400', 37800, '1'),
(42, 'ACST', '15691768200', 34200, '0'),
(42, 'ACDT', '15707493000', 37800, '1'),
(42, 'ACST', '15723217800', 34200, '0'),
(42, 'ACDT', '15739547400', 37800, '1'),
(42, 'ACST', '15755272200', 34200, '0'),
(42, 'ACDT', '15770997000', 37800, '1'),
(42, 'ACST', '15786721800', 34200, '0'),
(42, 'ACDT', '15802446600', 37800, '1'),
(42, 'ACST', '15818171400', 34200, '0'),
(42, 'ACDT', '15833896200', 37800, '1'),
(42, 'ACST', '15849621000', 34200, '0'),
(42, 'ACDT', '15865345800', 37800, '1'),
(42, 'ACST', '15881070600', 34200, '0'),
(42, 'ACDT', '15896795400', 37800, '1'),
(42, 'ACST', '15912520200', 34200, '0'),
(42, 'ACDT', '15928849800', 37800, '1'),
(42, 'ACST', '15944574600', 34200, '0'),
(42, 'ACDT', '15960299400', 37800, '1'),
(42, 'ACST', '15976024200', 34200, '0'),
(42, 'ACDT', '15991749000', 37800, '1'),
(42, 'ACST', '16007473800', 34200, '0'),
(42, 'ACDT', '16023198600', 37800, '1'),
(42, 'ACST', '16038923400', 34200, '0'),
(42, 'ACDT', '16054648200', 37800, '1'),
(42, 'ACST', '16070373000', 34200, '0'),
(42, 'ACDT', '16086097800', 37800, '1'),
(42, 'ACST', '16102427400', 34200, '0'),
(42, 'ACDT', '16118152200', 37800, '1'),
(42, 'ACST', '16133877000', 34200, '0'),
(42, 'ACDT', '16149601800', 37800, '1'),
(42, 'ACST', '16165326600', 34200, '0'),
(42, 'ACDT', '16181051400', 37800, '1'),
(42, 'ACST', '16196776200', 34200, '0'),
(42, 'ACDT', '16212501000', 37800, '1'),
(42, 'ACST', '16228225800', 34200, '0'),
(42, 'ACDT', '16243950600', 37800, '1'),
(42, 'ACST', '16259675400', 34200, '0'),
(42, 'ACDT', '16276005000', 37800, '1'),
(42, 'ACST', '16291729800', 34200, '0'),
(42, 'ACDT', '16307454600', 37800, '1'),
(42, 'ACST', '16323179400', 34200, '0'),
(42, 'ACDT', '16338904200', 37800, '1'),
(42, 'ACST', '16354629000', 34200, '0'),
(42, 'ACDT', '16370353800', 37800, '1'),
(42, 'ACST', '16386078600', 34200, '0'),
(42, 'ACDT', '16401803400', 37800, '1'),
(42, 'ACST', '16417528200', 34200, '0'),
(42, 'ACDT', '16433253000', 37800, '1'),
(42, 'ACST', '16448977800', 34200, '0'),
(42, 'ACDT', '16465307400', 37800, '1'),
(42, 'ACST', '16481032200', 34200, '0'),
(42, 'ACDT', '16496757000', 37800, '1'),
(42, 'ACST', '16512481800', 34200, '0'),
(42, 'ACDT', '16528206600', 37800, '1'),
(42, 'ACST', '16543931400', 34200, '0'),
(42, 'ACDT', '16559656200', 37800, '1'),
(42, 'ACST', '16575381000', 34200, '0'),
(42, 'ACDT', '16591105800', 37800, '1'),
(42, 'ACST', '16606830600', 34200, '0'),
(42, 'ACDT', '16623160200', 37800, '1'),
(42, 'ACST', '16638885000', 34200, '0'),
(42, 'ACDT', '16654609800', 37800, '1'),
(42, 'ACST', '16670334600', 34200, '0'),
(42, 'ACDT', '16686059400', 37800, '1'),
(42, 'ACST', '16701784200', 34200, '0'),
(42, 'ACDT', '16717509000', 37800, '1'),
(43, 'LMT', '-2364108201', 31400, '0'),
(43, 'ACST', '-2364108200', 32400, '0'),
(43, 'ACST', '-2230189200', 34200, '0'),
(43, 'ACDT', '-1672565340', 37800, '1'),
(43, 'ACST', '-1665390600', 34200, '0'),
(43, 'ACDT', '-883639800', 37800, '1'),
(43, 'ACST', '-876126600', 34200, '0'),
(43, 'ACDT', '-860398200', 37800, '1'),
(43, 'ACST', '-844677000', 34200, '0'),
(43, 'ACDT', '-828343800', 37800, '1'),
(43, 'ACST', '-813227400', 34200, '0'),
(44, 'LMT', '-2337925405', 27804, '0'),
(44, 'AWST', '-2337925404', 28800, '0'),
(44, 'AWDT', '-1672559940', 32400, '1'),
(44, 'AWST', '-1665385200', 28800, '0'),
(44, 'AWDT', '-883634400', 32400, '1'),
(44, 'AWST', '-876121200', 28800, '0'),
(44, 'AWDT', '-860392800', 32400, '1'),
(44, 'AWST', '-844671600', 28800, '0'),
(44, 'AWDT', '152042400', 32400, '1'),
(44, 'AWST', '162928800', 28800, '0'),
(44, 'AWDT', '436298400', 32400, '1'),
(44, 'AWST', '447184800', 28800, '0'),
(44, 'AWDT', '690314400', 32400, '1'),
(44, 'AWST', '699386400', 28800, '0'),
(44, 'AWDT', '1165082400', 32400, '1'),
(44, 'AWST', '1174759200', 28800, '0'),
(44, 'AWDT', '1193508000', 32400, '1'),
(44, 'AWST', '1206813600', 28800, '0'),
(44, 'AWDT', '1224957600', 32400, '1'),
(44, 'AWST', '1238263200', 28800, '0'),
(45, 'LMT', '-2337928529', 30928, '0'),
(45, '+0845', '-2337928528', 31500, '0'),
(45, '+0945', '-1672562640', 35100, '1'),
(45, '+0845', '-1665387900', 31500, '0'),
(45, '+0945', '-883637100', 35100, '1'),
(45, '+0845', '-876123900', 31500, '0'),
(45, '+0945', '-860395500', 35100, '1'),
(45, '+0845', '-844674300', 31500, '0'),
(45, '+0945', '152039700', 35100, '1'),
(45, '+0845', '162926100', 31500, '0'),
(45, '+0945', '436295700', 35100, '1'),
(45, '+0845', '447182100', 31500, '0'),
(45, '+0945', '690311700', 35100, '1'),
(45, '+0845', '699383700', 31500, '0'),
(45, '+0945', '1165079700', 35100, '1'),
(45, '+0845', '1174756500', 31500, '0'),
(45, '+0945', '1193505300', 35100, '1'),
(45, '+0845', '1206810900', 31500, '0'),
(45, '+0945', '1224954900', 35100, '1'),
(45, '+0845', '1238260500', 31500, '0'),
(46, 'LMT', '-1826738654', -16547, '0'),
(46, '-0430', '-1826738653', -16200, '0'),
(46, 'AST', '-157750200', -14400, '0'),
(47, 'LMT', '-2890258790', 5989, '0'),
(47, 'HMT', '-2890258789', 5989, '0'),
(47, 'EET', '-1535938789', 7200, '0'),
(47, 'EEST', '-875671200', 10800, '1'),
(47, 'EET', '-859773600', 7200, '0'),
(47, 'EEST', '354672000', 10800, '1'),
(47, 'EET', '370396800', 7200, '0'),
(47, 'EEST', '386121600', 10800, '1'),
(47, 'EET', '401846400', 7200, '0'),
(47, 'EEST', '417574800', 10800, '1'),
(47, 'EET', '433299600', 7200, '0'),
(47, 'EEST', '449024400', 10800, '1'),
(47, 'EET', '465354000', 7200, '0'),
(47, 'EEST', '481078800', 10800, '1'),
(47, 'EET', '496803600', 7200, '0'),
(47, 'EEST', '512528400', 10800, '1'),
(47, 'EET', '528253200', 7200, '0'),
(47, 'EEST', '543978000', 10800, '1'),
(47, 'EET', '559702800', 7200, '0'),
(47, 'EEST', '575427600', 10800, '1'),
(47, 'EET', '591152400', 7200, '0'),
(47, 'EEST', '606877200', 10800, '1'),
(47, 'EET', '622602000', 7200, '0'),
(47, 'EEST', '638326800', 10800, '1'),
(47, 'EET', '654656400', 7200, '0'),
(47, 'EEST', '670381200', 10800, '1'),
(47, 'EET', '686106000', 7200, '0'),
(47, 'EEST', '701830800', 10800, '1'),
(47, 'EET', '717555600', 7200, '0'),
(47, 'EEST', '733280400', 10800, '1'),
(47, 'EET', '749005200', 7200, '0'),
(47, 'EEST', '764730000', 10800, '1'),
(47, 'EET', '780454800', 7200, '0'),
(47, 'EEST', '796179600', 10800, '1'),
(47, 'EET', '811904400', 7200, '0'),
(47, 'EEST', '828234000', 10800, '1'),
(47, 'EET', '846378000', 7200, '0'),
(47, 'EEST', '859683600', 10800, '1'),
(47, 'EET', '877827600', 7200, '0'),
(47, 'EEST', '891133200', 10800, '1'),
(47, 'EET', '909277200', 7200, '0'),
(47, 'EEST', '922582800', 10800, '1'),
(47, 'EET', '941331600', 7200, '0'),
(47, 'EEST', '954032400', 10800, '1'),
(47, 'EET', '972781200', 7200, '0'),
(47, 'EEST', '985482000', 10800, '1'),
(47, 'EET', '1004230800', 7200, '0'),
(47, 'EEST', '1017536400', 10800, '1'),
(47, 'EET', '1035680400', 7200, '0'),
(47, 'EEST', '1048986000', 10800, '1'),
(47, 'EET', '1067130000', 7200, '0'),
(47, 'EEST', '1080435600', 10800, '1'),
(47, 'EET', '1099184400', 7200, '0'),
(47, 'EEST', '1111885200', 10800, '1'),
(47, 'EET', '1130634000', 7200, '0'),
(47, 'EEST', '1143334800', 10800, '1'),
(47, 'EET', '1162083600', 7200, '0'),
(47, 'EEST', '1174784400', 10800, '1'),
(47, 'EET', '1193533200', 7200, '0'),
(47, 'EEST', '1206838800', 10800, '1'),
(47, 'EET', '1224982800', 7200, '0'),
(47, 'EEST', '1238288400', 10800, '1'),
(47, 'EET', '1256432400', 7200, '0'),
(47, 'EEST', '1269738000', 10800, '1'),
(47, 'EET', '1288486800', 7200, '0'),
(47, 'EEST', '1301187600', 10800, '1'),
(47, 'EET', '1319936400', 7200, '0'),
(47, 'EEST', '1332637200', 10800, '1'),
(47, 'EET', '1351386000', 7200, '0'),
(47, 'EEST', '1364691600', 10800, '1'),
(47, 'EET', '1382835600', 7200, '0'),
(47, 'EEST', '1396141200', 10800, '1'),
(47, 'EET', '1414285200', 7200, '0'),
(47, 'EEST', '1427590800', 10800, '1'),
(47, 'EET', '1445734800', 7200, '0'),
(47, 'EEST', '1459040400', 10800, '1'),
(47, 'EET', '1477789200', 7200, '0'),
(47, 'EEST', '1490490000', 10800, '1'),
(47, 'EET', '1509238800', 7200, '0'),
(47, 'EEST', '1521939600', 10800, '1'),
(47, 'EET', '1540688400', 7200, '0'),
(47, 'EEST', '1553994000', 10800, '1'),
(47, 'EET', '1572138000', 7200, '0'),
(47, 'EEST', '1585443600', 10800, '1'),
(47, 'EET', '1603587600', 7200, '0'),
(47, 'EEST', '1616893200', 10800, '1'),
(47, 'EET', '1635642000', 7200, '0'),
(47, 'EEST', '1648342800', 10800, '1'),
(47, 'EET', '1667091600', 7200, '0'),
(47, 'EEST', '1679792400', 10800, '1'),
(47, 'EET', '1698541200', 7200, '0'),
(47, 'EEST', '1711846800', 10800, '1'),
(47, 'EET', '1729990800', 7200, '0'),
(47, 'EEST', '1743296400', 10800, '1'),
(47, 'EET', '1761440400', 7200, '0'),
(47, 'EEST', '1774746000', 10800, '1'),
(47, 'EET', '1792890000', 7200, '0'),
(47, 'EEST', '1806195600', 10800, '1'),
(47, 'EET', '1824944400', 7200, '0'),
(47, 'EEST', '1837645200', 10800, '1'),
(47, 'EET', '1856394000', 7200, '0'),
(47, 'EEST', '1869094800', 10800, '1'),
(47, 'EET', '1887843600', 7200, '0'),
(47, 'EEST', '1901149200', 10800, '1'),
(47, 'EET', '1919293200', 7200, '0'),
(47, 'EEST', '1932598800', 10800, '1'),
(47, 'EET', '1950742800', 7200, '0'),
(47, 'EEST', '1964048400', 10800, '1'),
(47, 'EET', '1982797200', 7200, '0'),
(47, 'EEST', '1995498000', 10800, '1'),
(47, 'EET', '2014246800', 7200, '0'),
(47, 'EEST', '2026947600', 10800, '1'),
(47, 'EET', '2045696400', 7200, '0'),
(47, 'EEST', '2058397200', 10800, '1'),
(47, 'EET', '2077146000', 7200, '0'),
(47, 'EEST', '2090451600', 10800, '1'),
(47, 'EET', '2108595600', 7200, '0'),
(47, 'EEST', '2121901200', 10800, '1'),
(47, 'EET', '2140045200', 7200, '0'),
(47, 'EEST', '2153350800', 10800, '1'),
(47, 'EET', '2172099600', 7200, '0'),
(47, 'EEST', '2184800400', 10800, '1'),
(47, 'EET', '2203549200', 7200, '0'),
(47, 'EEST', '2216250000', 10800, '1'),
(47, 'EET', '2234998800', 7200, '0'),
(47, 'EEST', '2248304400', 10800, '1'),
(47, 'EET', '2266448400', 7200, '0'),
(47, 'EEST', '2279754000', 10800, '1'),
(47, 'EET', '2297898000', 7200, '0'),
(47, 'EEST', '2311203600', 10800, '1'),
(47, 'EET', '2329347600', 7200, '0'),
(47, 'EEST', '2342653200', 10800, '1'),
(47, 'EET', '2361402000', 7200, '0'),
(47, 'EEST', '2374102800', 10800, '1'),
(47, 'EET', '2392851600', 7200, '0'),
(47, 'EEST', '2405552400', 10800, '1'),
(47, 'EET', '2424301200', 7200, '0'),
(47, 'EEST', '2437606800', 10800, '1'),
(47, 'EET', '2455750800', 7200, '0'),
(47, 'EEST', '2469056400', 10800, '1'),
(47, 'EET', '2487200400', 7200, '0'),
(47, 'EEST', '2500506000', 10800, '1'),
(47, 'EET', '2519254800', 7200, '0'),
(47, 'EEST', '2531955600', 10800, '1'),
(47, 'EET', '2550704400', 7200, '0'),
(47, 'EEST', '2563405200', 10800, '1'),
(47, 'EET', '2582154000', 7200, '0'),
(47, 'EEST', '2595459600', 10800, '1'),
(47, 'EET', '2613603600', 7200, '0'),
(47, 'EEST', '2626909200', 10800, '1'),
(47, 'EET', '2645053200', 7200, '0'),
(47, 'EEST', '2658358800', 10800, '1'),
(47, 'EET', '2676502800', 7200, '0'),
(47, 'EEST', '2689808400', 10800, '1'),
(47, 'EET', '2708557200', 7200, '0'),
(47, 'EEST', '2721258000', 10800, '1'),
(47, 'EET', '2740006800', 7200, '0'),
(47, 'EEST', '2752707600', 10800, '1'),
(47, 'EET', '2771456400', 7200, '0'),
(47, 'EEST', '2784762000', 10800, '1'),
(47, 'EET', '2802906000', 7200, '0'),
(47, 'EEST', '2816211600', 10800, '1'),
(47, 'EET', '2834355600', 7200, '0'),
(47, 'EEST', '2847661200', 10800, '1'),
(47, 'EET', '2866410000', 7200, '0'),
(47, 'EEST', '2879110800', 10800, '1'),
(47, 'EET', '2897859600', 7200, '0'),
(47, 'EEST', '2910560400', 10800, '1'),
(47, 'EET', '2929309200', 7200, '0'),
(47, 'EEST', '2942010000', 10800, '1'),
(47, 'EET', '2960758800', 7200, '0'),
(47, 'EEST', '2974064400', 10800, '1'),
(47, 'EET', '2992208400', 7200, '0'),
(47, 'EEST', '3005514000', 10800, '1'),
(47, 'EET', '3023658000', 7200, '0'),
(47, 'EEST', '3036963600', 10800, '1'),
(47, 'EET', '3055712400', 7200, '0'),
(47, 'EEST', '3068413200', 10800, '1'),
(47, 'EET', '3087162000', 7200, '0'),
(47, 'EEST', '3099862800', 10800, '1'),
(47, 'EET', '3118611600', 7200, '0'),
(47, 'EEST', '3131917200', 10800, '1'),
(47, 'EET', '3150061200', 7200, '0'),
(47, 'EEST', '3163366800', 10800, '1'),
(47, 'EET', '3181510800', 7200, '0'),
(47, 'EEST', '3194816400', 10800, '1'),
(47, 'EET', '3212960400', 7200, '0'),
(47, 'EEST', '3226266000', 10800, '1'),
(47, 'EET', '3245014800', 7200, '0'),
(47, 'EEST', '3257715600', 10800, '1'),
(47, 'EET', '3276464400', 7200, '0'),
(47, 'EEST', '3289165200', 10800, '1'),
(47, 'EET', '3307914000', 7200, '0'),
(47, 'EEST', '3321219600', 10800, '1'),
(47, 'EET', '3339363600', 7200, '0'),
(47, 'EEST', '3352669200', 10800, '1'),
(47, 'EET', '3370813200', 7200, '0'),
(47, 'EEST', '3384118800', 10800, '1'),
(47, 'EET', '3402867600', 7200, '0'),
(47, 'EEST', '3415568400', 10800, '1'),
(47, 'EET', '3434317200', 7200, '0'),
(47, 'EEST', '3447018000', 10800, '1'),
(47, 'EET', '3465766800', 7200, '0'),
(47, 'EEST', '3479072400', 10800, '1'),
(47, 'EET', '3497216400', 7200, '0'),
(47, 'EEST', '3510522000', 10800, '1'),
(47, 'EET', '3528666000', 7200, '0'),
(47, 'EEST', '3541971600', 10800, '1'),
(47, 'EET', '3560115600', 7200, '0'),
(47, 'EEST', '3573421200', 10800, '1'),
(47, 'EET', '3592170000', 7200, '0'),
(47, 'EEST', '3604870800', 10800, '1'),
(47, 'EET', '3623619600', 7200, '0'),
(47, 'EEST', '3636320400', 10800, '1'),
(47, 'EET', '3655069200', 7200, '0'),
(47, 'EEST', '3668374800', 10800, '1'),
(47, 'EET', '3686518800', 7200, '0'),
(47, 'EEST', '3699824400', 10800, '1'),
(47, 'EET', '3717968400', 7200, '0'),
(47, 'EEST', '3731274000', 10800, '1'),
(47, 'EET', '3750022800', 7200, '0'),
(47, 'EEST', '3762723600', 10800, '1'),
(47, 'EET', '3781472400', 7200, '0'),
(47, 'EEST', '3794173200', 10800, '1'),
(47, 'EET', '3812922000', 7200, '0'),
(47, 'EEST', '3825622800', 10800, '1'),
(47, 'EET', '3844371600', 7200, '0'),
(47, 'EEST', '3857677200', 10800, '1'),
(47, 'EET', '3875821200', 7200, '0'),
(47, 'EEST', '3889126800', 10800, '1'),
(47, 'EET', '3907270800', 7200, '0'),
(47, 'EEST', '3920576400', 10800, '1'),
(47, 'EET', '3939325200', 7200, '0'),
(47, 'EEST', '3952026000', 10800, '1'),
(47, 'EET', '3970774800', 7200, '0'),
(47, 'EEST', '3983475600', 10800, '1'),
(47, 'EET', '4002224400', 7200, '0'),
(47, 'EEST', '4015530000', 10800, '1'),
(47, 'EET', '4033674000', 7200, '0'),
(47, 'EEST', '4046979600', 10800, '1'),
(47, 'EET', '4065123600', 7200, '0'),
(47, 'EEST', '4078429200', 10800, '1'),
(47, 'EET', '4096573200', 7200, '0'),
(47, 'EEST', '4109878800', 10800, '1'),
(47, 'EET', '4128627600', 7200, '0'),
(47, 'EEST', '4141328400', 10800, '1'),
(47, 'EET', '4160077200', 7200, '0'),
(47, 'EEST', '4172778000', 10800, '1'),
(47, 'EET', '4191526800', 7200, '0'),
(47, 'EEST', '4204227600', 10800, '1'),
(47, 'EET', '4222976400', 7200, '0'),
(47, 'EEST', '4236282000', 10800, '1'),
(47, 'EET', '4254426000', 7200, '0'),
(47, 'EEST', '4267731600', 10800, '1'),
(47, 'EET', '4285875600', 7200, '0'),
(47, 'EEST', '4299181200', 10800, '1'),
(47, 'EET', '4317930000', 7200, '0'),
(47, 'EEST', '4330630800', 10800, '1'),
(47, 'EET', '4349379600', 7200, '0'),
(47, 'EEST', '4362080400', 10800, '1'),
(47, 'EET', '4380829200', 7200, '0'),
(47, 'EEST', '4394134800', 10800, '1'),
(47, 'EET', '4412278800', 7200, '0'),
(47, 'EEST', '4425584400', 10800, '1'),
(47, 'EET', '4443728400', 7200, '0'),
(47, 'EEST', '4457034000', 10800, '1'),
(47, 'EET', '4475178000', 7200, '0'),
(47, 'EEST', '4488483600', 10800, '1'),
(47, 'EET', '4507232400', 7200, '0'),
(47, 'EEST', '4519933200', 10800, '1'),
(47, 'EET', '4538682000', 7200, '0'),
(47, 'EEST', '4551382800', 10800, '1'),
(47, 'EET', '4570131600', 7200, '0'),
(47, 'EEST', '4583437200', 10800, '1'),
(47, 'EET', '4601581200', 7200, '0'),
(47, 'EEST', '4614886800', 10800, '1'),
(47, 'EET', '4633030800', 7200, '0'),
(47, 'EEST', '4646336400', 10800, '1'),
(47, 'EET', '4665085200', 7200, '0'),
(47, 'EEST', '4677786000', 10800, '1'),
(47, 'EET', '4696534800', 7200, '0'),
(47, 'EEST', '4709235600', 10800, '1'),
(47, 'EET', '4727984400', 7200, '0'),
(47, 'EEST', '4741290000', 10800, '1'),
(47, 'EET', '4759434000', 7200, '0'),
(47, 'EEST', '4772739600', 10800, '1'),
(47, 'EET', '4790883600', 7200, '0'),
(47, 'EEST', '4804189200', 10800, '1'),
(47, 'EET', '4822333200', 7200, '0'),
(47, 'EEST', '4835638800', 10800, '1'),
(47, 'EET', '4854387600', 7200, '0'),
(47, 'EEST', '4867088400', 10800, '1'),
(47, 'EET', '4885837200', 7200, '0'),
(47, 'EEST', '4898538000', 10800, '1'),
(47, 'EET', '4917286800', 7200, '0'),
(47, 'EEST', '4930592400', 10800, '1'),
(47, 'EET', '4948736400', 7200, '0'),
(47, 'EEST', '4962042000', 10800, '1'),
(47, 'EET', '4980186000', 7200, '0'),
(47, 'EEST', '4993491600', 10800, '1'),
(47, 'EET', '5012240400', 7200, '0'),
(47, 'EEST', '5024941200', 10800, '1'),
(47, 'EET', '5043690000', 7200, '0'),
(47, 'EEST', '5056390800', 10800, '1'),
(47, 'EET', '5075139600', 7200, '0'),
(47, 'EEST', '5087840400', 10800, '1'),
(47, 'EET', '5106589200', 7200, '0'),
(47, 'EEST', '5119894800', 10800, '1'),
(47, 'EET', '5138038800', 7200, '0'),
(47, 'EEST', '5151344400', 10800, '1'),
(47, 'EET', '5169488400', 7200, '0'),
(47, 'EEST', '5182794000', 10800, '1'),
(47, 'EET', '5201542800', 7200, '0'),
(47, 'EEST', '5214243600', 10800, '1'),
(47, 'EET', '5232992400', 7200, '0'),
(47, 'EEST', '5245693200', 10800, '1'),
(47, 'EET', '5264442000', 7200, '0'),
(47, 'EEST', '5277747600', 10800, '1'),
(47, 'EET', '5295891600', 7200, '0'),
(47, 'EEST', '5309197200', 10800, '1'),
(47, 'EET', '5327341200', 7200, '0'),
(47, 'EEST', '5340646800', 10800, '1'),
(47, 'EET', '5358790800', 7200, '0'),
(47, 'EEST', '5372096400', 10800, '1'),
(47, 'EET', '5390845200', 7200, '0'),
(47, 'EEST', '5403546000', 10800, '1'),
(47, 'EET', '5422294800', 7200, '0'),
(47, 'EEST', '5434995600', 10800, '1'),
(47, 'EET', '5453744400', 7200, '0'),
(47, 'EEST', '5467050000', 10800, '1'),
(47, 'EET', '5485194000', 7200, '0'),
(47, 'EEST', '5498499600', 10800, '1'),
(47, 'EET', '5516643600', 7200, '0'),
(47, 'EEST', '5529949200', 10800, '1'),
(47, 'EET', '5548698000', 7200, '0'),
(47, 'EEST', '5561398800', 10800, '1'),
(47, 'EET', '5580147600', 7200, '0'),
(47, 'EEST', '5592848400', 10800, '1'),
(47, 'EET', '5611597200', 7200, '0'),
(47, 'EEST', '5624902800', 10800, '1'),
(47, 'EET', '5643046800', 7200, '0'),
(47, 'EEST', '5656352400', 10800, '1'),
(47, 'EET', '5674496400', 7200, '0'),
(47, 'EEST', '5687802000', 10800, '1'),
(47, 'EET', '5705946000', 7200, '0'),
(47, 'EEST', '5719251600', 10800, '1'),
(47, 'EET', '5738000400', 7200, '0'),
(47, 'EEST', '5750701200', 10800, '1'),
(47, 'EET', '5769450000', 7200, '0'),
(47, 'EEST', '5782150800', 10800, '1'),
(47, 'EET', '5800899600', 7200, '0'),
(47, 'EEST', '5814205200', 10800, '1'),
(47, 'EET', '5832349200', 7200, '0'),
(47, 'EEST', '5845654800', 10800, '1'),
(47, 'EET', '5863798800', 7200, '0'),
(47, 'EEST', '5877104400', 10800, '1'),
(47, 'EET', '5895853200', 7200, '0'),
(47, 'EEST', '5908554000', 10800, '1'),
(47, 'EET', '5927302800', 7200, '0'),
(47, 'EEST', '5940003600', 10800, '1'),
(47, 'EET', '5958752400', 7200, '0'),
(47, 'EEST', '5971453200', 10800, '1'),
(47, 'EET', '5990202000', 7200, '0'),
(47, 'EEST', '6003507600', 10800, '1'),
(47, 'EET', '6021651600', 7200, '0'),
(47, 'EEST', '6034957200', 10800, '1'),
(47, 'EET', '6053101200', 7200, '0'),
(47, 'EEST', '6066406800', 10800, '1'),
(47, 'EET', '6085155600', 7200, '0'),
(47, 'EEST', '6097856400', 10800, '1'),
(47, 'EET', '6116605200', 7200, '0'),
(47, 'EEST', '6129306000', 10800, '1'),
(47, 'EET', '6148054800', 7200, '0'),
(47, 'EEST', '6161360400', 10800, '1'),
(47, 'EET', '6179504400', 7200, '0'),
(47, 'EEST', '6192810000', 10800, '1'),
(47, 'EET', '6210954000', 7200, '0'),
(47, 'EEST', '6224259600', 10800, '1'),
(47, 'EET', '6242403600', 7200, '0'),
(47, 'EEST', '6255709200', 10800, '1'),
(47, 'EET', '6274458000', 7200, '0'),
(47, 'EEST', '6287158800', 10800, '1'),
(47, 'EET', '6305907600', 7200, '0'),
(47, 'EEST', '6318608400', 10800, '1'),
(47, 'EET', '6337357200', 7200, '0'),
(47, 'EEST', '6350662800', 10800, '1'),
(47, 'EET', '6368806800', 7200, '0'),
(47, 'EEST', '6382112400', 10800, '1'),
(47, 'EET', '6400256400', 7200, '0'),
(47, 'EEST', '6413562000', 10800, '1'),
(47, 'EET', '6432310800', 7200, '0'),
(47, 'EEST', '6445011600', 10800, '1'),
(47, 'EET', '6463760400', 7200, '0'),
(47, 'EEST', '6476461200', 10800, '1'),
(47, 'EET', '6495210000', 7200, '0'),
(47, 'EEST', '6508515600', 10800, '1'),
(47, 'EET', '6526659600', 7200, '0'),
(47, 'EEST', '6539965200', 10800, '1'),
(47, 'EET', '6558109200', 7200, '0'),
(47, 'EEST', '6571414800', 10800, '1'),
(47, 'EET', '6589558800', 7200, '0'),
(47, 'EEST', '6602864400', 10800, '1'),
(47, 'EET', '6621613200', 7200, '0'),
(47, 'EEST', '6634314000', 10800, '1'),
(47, 'EET', '6653062800', 7200, '0'),
(47, 'EEST', '6665763600', 10800, '1'),
(47, 'EET', '6684512400', 7200, '0'),
(47, 'EEST', '6697818000', 10800, '1'),
(47, 'EET', '6715962000', 7200, '0'),
(47, 'EEST', '6729267600', 10800, '1'),
(47, 'EET', '6747411600', 7200, '0'),
(47, 'EEST', '6760717200', 10800, '1'),
(47, 'EET', '6779466000', 7200, '0'),
(47, 'EEST', '6792166800', 10800, '1'),
(47, 'EET', '6810915600', 7200, '0'),
(47, 'EEST', '6823616400', 10800, '1'),
(47, 'EET', '6842365200', 7200, '0'),
(47, 'EEST', '6855066000', 10800, '1'),
(47, 'EET', '6873814800', 7200, '0'),
(47, 'EEST', '6887120400', 10800, '1'),
(47, 'EET', '6905264400', 7200, '0'),
(47, 'EEST', '6918570000', 10800, '1'),
(47, 'EET', '6936714000', 7200, '0'),
(47, 'EEST', '6950019600', 10800, '1'),
(47, 'EET', '6968768400', 7200, '0'),
(47, 'EEST', '6981469200', 10800, '1'),
(47, 'EET', '7000218000', 7200, '0'),
(47, 'EEST', '7012918800', 10800, '1'),
(47, 'EET', '7031667600', 7200, '0'),
(47, 'EEST', '7044973200', 10800, '1'),
(47, 'EET', '7063117200', 7200, '0'),
(47, 'EEST', '7076422800', 10800, '1'),
(47, 'EET', '7094566800', 7200, '0'),
(47, 'EEST', '7107872400', 10800, '1'),
(47, 'EET', '7126016400', 7200, '0'),
(47, 'EEST', '7139322000', 10800, '1'),
(47, 'EET', '7158070800', 7200, '0'),
(47, 'EEST', '7170771600', 10800, '1'),
(47, 'EET', '7189520400', 7200, '0'),
(47, 'EEST', '7202221200', 10800, '1'),
(47, 'EET', '7220970000', 7200, '0'),
(47, 'EEST', '7234275600', 10800, '1'),
(47, 'EET', '7252419600', 7200, '0'),
(47, 'EEST', '7265725200', 10800, '1'),
(47, 'EET', '7283869200', 7200, '0'),
(47, 'EEST', '7297174800', 10800, '1'),
(47, 'EET', '7315318800', 7200, '0'),
(47, 'EEST', '7328624400', 10800, '1'),
(47, 'EET', '7347373200', 7200, '0'),
(47, 'EEST', '7360074000', 10800, '1'),
(47, 'EET', '7378822800', 7200, '0'),
(47, 'EEST', '7391523600', 10800, '1'),
(47, 'EET', '7410272400', 7200, '0'),
(47, 'EEST', '7423578000', 10800, '1'),
(47, 'EET', '7441722000', 7200, '0'),
(47, 'EEST', '7455027600', 10800, '1'),
(47, 'EET', '7473171600', 7200, '0'),
(47, 'EEST', '7486477200', 10800, '1'),
(47, 'EET', '7504621200', 7200, '0'),
(47, 'EEST', '7517926800', 10800, '1'),
(47, 'EET', '7536675600', 7200, '0'),
(47, 'EEST', '7549376400', 10800, '1'),
(47, 'EET', '7568125200', 7200, '0'),
(47, 'EEST', '7580826000', 10800, '1'),
(47, 'EET', '7599574800', 7200, '0'),
(47, 'EEST', '7612880400', 10800, '1'),
(47, 'EET', '7631024400', 7200, '0'),
(47, 'EEST', '7644330000', 10800, '1'),
(47, 'EET', '7662474000', 7200, '0'),
(47, 'EEST', '7675779600', 10800, '1'),
(47, 'EET', '7694528400', 7200, '0'),
(47, 'EEST', '7707229200', 10800, '1'),
(47, 'EET', '7725978000', 7200, '0'),
(47, 'EEST', '7738678800', 10800, '1'),
(47, 'EET', '7757427600', 7200, '0'),
(47, 'EEST', '7770733200', 10800, '1'),
(47, 'EET', '7788877200', 7200, '0'),
(47, 'EEST', '7802182800', 10800, '1'),
(47, 'EET', '7820326800', 7200, '0'),
(47, 'EEST', '7833632400', 10800, '1'),
(47, 'EET', '7851776400', 7200, '0'),
(47, 'EEST', '7865082000', 10800, '1'),
(47, 'EET', '7883830800', 7200, '0'),
(47, 'EEST', '7896531600', 10800, '1'),
(47, 'EET', '7915280400', 7200, '0'),
(47, 'EEST', '7927981200', 10800, '1'),
(47, 'EET', '7946730000', 7200, '0'),
(47, 'EEST', '7960035600', 10800, '1'),
(47, 'EET', '7978179600', 7200, '0'),
(47, 'EEST', '7991485200', 10800, '1'),

(47, 'EET', '8009629200', 7200, '0'),
(47, 'EEST', '8022934800', 10800, '1'),
(47, 'EET', '8041683600', 7200, '0'),
(47, 'EEST', '8054384400', 10800, '1'),
(47, 'EET', '8073133200', 7200, '0'),
(47, 'EEST', '8085834000', 10800, '1'),
(47, 'EET', '8104582800', 7200, '0'),
(47, 'EEST', '8117283600', 10800, '1'),
(47, 'EET', '8136032400', 7200, '0'),
(47, 'EEST', '8149338000', 10800, '1'),
(47, 'EET', '8167482000', 7200, '0'),
(47, 'EEST', '8180787600', 10800, '1'),
(47, 'EET', '8198931600', 7200, '0'),
(47, 'EEST', '8212237200', 10800, '1'),
(47, 'EET', '8230986000', 7200, '0'),
(47, 'EEST', '8243686800', 10800, '1'),
(47, 'EET', '8262435600', 7200, '0'),
(47, 'EEST', '8275136400', 10800, '1'),
(47, 'EET', '8293885200', 7200, '0'),
(47, 'EEST', '8307190800', 10800, '1'),
(47, 'EET', '8325334800', 7200, '0'),
(47, 'EEST', '8338640400', 10800, '1'),
(47, 'EET', '8356784400', 7200, '0'),
(47, 'EEST', '8370090000', 10800, '1'),
(47, 'EET', '8388234000', 7200, '0'),
(47, 'EEST', '8401539600', 10800, '1'),
(47, 'EET', '8420288400', 7200, '0'),
(47, 'EEST', '8432989200', 10800, '1'),
(47, 'EET', '8451738000', 7200, '0'),
(47, 'EEST', '8464438800', 10800, '1'),
(47, 'EET', '8483187600', 7200, '0'),
(47, 'EEST', '8496493200', 10800, '1'),
(47, 'EET', '8514637200', 7200, '0'),
(47, 'EEST', '8527942800', 10800, '1'),
(47, 'EET', '8546086800', 7200, '0'),
(47, 'EEST', '8559392400', 10800, '1'),
(47, 'EET', '8578141200', 7200, '0'),
(47, 'EEST', '8590842000', 10800, '1'),
(47, 'EET', '8609590800', 7200, '0'),
(47, 'EEST', '8622291600', 10800, '1'),
(47, 'EET', '8641040400', 7200, '0'),
(47, 'EEST', '8654346000', 10800, '1'),
(47, 'EET', '8672490000', 7200, '0'),
(47, 'EEST', '8685795600', 10800, '1'),
(47, 'EET', '8703939600', 7200, '0'),
(47, 'EEST', '8717245200', 10800, '1'),
(47, 'EET', '8735389200', 7200, '0'),
(47, 'EEST', '8748694800', 10800, '1'),
(47, 'EET', '8767443600', 7200, '0'),
(47, 'EEST', '8780144400', 10800, '1'),
(47, 'EET', '8798893200', 7200, '0'),
(47, 'EEST', '8811594000', 10800, '1'),
(47, 'EET', '8830342800', 7200, '0'),
(47, 'EEST', '8843648400', 10800, '1'),
(47, 'EET', '8861792400', 7200, '0'),
(47, 'EEST', '8875098000', 10800, '1'),
(47, 'EET', '8893242000', 7200, '0'),
(47, 'EEST', '8906547600', 10800, '1'),
(47, 'EET', '8925296400', 7200, '0'),
(47, 'EEST', '8937997200', 10800, '1'),
(47, 'EET', '8956746000', 7200, '0'),
(47, 'EEST', '8969446800', 10800, '1'),
(47, 'EET', '8988195600', 7200, '0'),
(47, 'EEST', '9000896400', 10800, '1'),
(47, 'EET', '9019645200', 7200, '0'),
(47, 'EEST', '9032950800', 10800, '1'),
(47, 'EET', '9051094800', 7200, '0'),
(47, 'EEST', '9064400400', 10800, '1'),
(47, 'EET', '9082544400', 7200, '0'),
(47, 'EEST', '9095850000', 10800, '1'),
(47, 'EET', '9114598800', 7200, '0'),
(47, 'EEST', '9127299600', 10800, '1'),
(47, 'EET', '9146048400', 7200, '0'),
(47, 'EEST', '9158749200', 10800, '1'),
(47, 'EET', '9177498000', 7200, '0'),
(47, 'EEST', '9190803600', 10800, '1'),
(47, 'EET', '9208947600', 7200, '0'),
(47, 'EEST', '9222253200', 10800, '1'),
(47, 'EET', '9240397200', 7200, '0'),
(47, 'EEST', '9253702800', 10800, '1'),
(47, 'EET', '9271846800', 7200, '0'),
(47, 'EEST', '9285152400', 10800, '1'),
(47, 'EET', '9303901200', 7200, '0'),
(47, 'EEST', '9316602000', 10800, '1'),
(47, 'EET', '9335350800', 7200, '0'),
(47, 'EEST', '9348051600', 10800, '1'),
(47, 'EET', '9366800400', 7200, '0'),
(47, 'EEST', '9380106000', 10800, '1'),
(47, 'EET', '9398250000', 7200, '0'),
(47, 'EEST', '9411555600', 10800, '1'),
(47, 'EET', '9429699600', 7200, '0'),
(47, 'EEST', '9443005200', 10800, '1'),
(47, 'EET', '9461754000', 7200, '0'),
(47, 'EEST', '9474454800', 10800, '1'),
(47, 'EET', '9493203600', 7200, '0'),
(47, 'EEST', '9505904400', 10800, '1'),
(47, 'EET', '9524653200', 7200, '0'),
(47, 'EEST', '9537958800', 10800, '1'),
(47, 'EET', '9556102800', 7200, '0'),
(47, 'EEST', '9569408400', 10800, '1'),
(47, 'EET', '9587552400', 7200, '0'),
(47, 'EEST', '9600858000', 10800, '1'),
(47, 'EET', '9619002000', 7200, '0'),
(47, 'EEST', '9632307600', 10800, '1'),
(47, 'EET', '9651056400', 7200, '0'),
(47, 'EEST', '9663757200', 10800, '1'),
(47, 'EET', '9682506000', 7200, '0'),
(47, 'EEST', '9695206800', 10800, '1'),
(47, 'EET', '9713955600', 7200, '0'),
(47, 'EEST', '9727261200', 10800, '1'),
(47, 'EET', '9745405200', 7200, '0'),
(47, 'EEST', '9758710800', 10800, '1'),
(47, 'EET', '9776854800', 7200, '0'),
(47, 'EEST', '9790160400', 10800, '1'),
(47, 'EET', '9808909200', 7200, '0'),
(47, 'EEST', '9821610000', 10800, '1'),
(47, 'EET', '9840358800', 7200, '0'),
(47, 'EEST', '9853059600', 10800, '1'),
(47, 'EET', '9871808400', 7200, '0'),
(47, 'EEST', '9884509200', 10800, '1'),
(47, 'EET', '9903258000', 7200, '0'),
(47, 'EEST', '9916563600', 10800, '1'),
(47, 'EET', '9934707600', 7200, '0'),
(47, 'EEST', '9948013200', 10800, '1'),
(47, 'EET', '9966157200', 7200, '0'),
(47, 'EEST', '9979462800', 10800, '1'),
(47, 'EET', '9998211600', 7200, '0'),
(47, 'EEST', '10010912400', 10800, '1'),
(47, 'EET', '10029661200', 7200, '0'),
(47, 'EEST', '10042362000', 10800, '1'),
(47, 'EET', '10061110800', 7200, '0'),
(47, 'EEST', '10074416400', 10800, '1'),
(47, 'EET', '10092560400', 7200, '0'),
(47, 'EEST', '10105866000', 10800, '1'),
(47, 'EET', '10124010000', 7200, '0'),
(47, 'EEST', '10137315600', 10800, '1'),
(47, 'EET', '10155459600', 7200, '0'),
(47, 'EEST', '10168765200', 10800, '1'),
(47, 'EET', '10187514000', 7200, '0'),
(47, 'EEST', '10200214800', 10800, '1'),
(47, 'EET', '10218963600', 7200, '0'),
(47, 'EEST', '10231664400', 10800, '1'),
(47, 'EET', '10250413200', 7200, '0'),
(47, 'EEST', '10263718800', 10800, '1'),
(47, 'EET', '10281862800', 7200, '0'),
(47, 'EEST', '10295168400', 10800, '1'),
(47, 'EET', '10313312400', 7200, '0'),
(47, 'EEST', '10326618000', 10800, '1'),
(47, 'EET', '10345366800', 7200, '0'),
(47, 'EEST', '10358067600', 10800, '1'),
(47, 'EET', '10376816400', 7200, '0'),
(47, 'EEST', '10389517200', 10800, '1'),
(47, 'EET', '10408266000', 7200, '0'),
(47, 'EEST', '10420966800', 10800, '1'),
(47, 'EET', '10439715600', 7200, '0'),
(47, 'EEST', '10453021200', 10800, '1'),
(47, 'EET', '10471165200', 7200, '0'),
(47, 'EEST', '10484470800', 10800, '1'),
(47, 'EET', '10502614800', 7200, '0'),
(47, 'EEST', '10515920400', 10800, '1'),
(47, 'EET', '10534064400', 7200, '0'),
(47, 'EEST', '10547370000', 10800, '1'),
(47, 'EET', '10566118800', 7200, '0'),
(47, 'EEST', '10578819600', 10800, '1'),
(47, 'EET', '10597568400', 7200, '0'),
(47, 'EEST', '10610269200', 10800, '1'),
(47, 'EET', '10629018000', 7200, '0'),
(47, 'EEST', '10642323600', 10800, '1'),
(47, 'EET', '10660467600', 7200, '0'),
(47, 'EEST', '10673773200', 10800, '1'),
(47, 'EET', '10691917200', 7200, '0'),
(47, 'EEST', '10705222800', 10800, '1'),
(47, 'EET', '10723971600', 7200, '0'),
(47, 'EEST', '10736672400', 10800, '1'),
(47, 'EET', '10755421200', 7200, '0'),
(47, 'EEST', '10768122000', 10800, '1'),
(47, 'EET', '10786870800', 7200, '0'),
(47, 'EEST', '10800176400', 10800, '1'),
(47, 'EET', '10818320400', 7200, '0'),
(47, 'EEST', '10831626000', 10800, '1'),
(47, 'EET', '10849770000', 7200, '0'),
(47, 'EEST', '10863075600', 10800, '1'),
(47, 'EET', '10881219600', 7200, '0'),
(47, 'EEST', '10894525200', 10800, '1'),
(47, 'EET', '10913274000', 7200, '0'),
(47, 'EEST', '10925974800', 10800, '1'),
(47, 'EET', '10944723600', 7200, '0'),
(47, 'EEST', '10957424400', 10800, '1'),
(47, 'EET', '10976173200', 7200, '0'),
(47, 'EEST', '10989478800', 10800, '1'),
(47, 'EET', '11007622800', 7200, '0'),
(47, 'EEST', '11020928400', 10800, '1'),
(47, 'EET', '11039072400', 7200, '0'),
(47, 'EEST', '11052378000', 10800, '1'),
(47, 'EET', '11071126800', 7200, '0'),
(47, 'EEST', '11083827600', 10800, '1'),
(47, 'EET', '11102576400', 7200, '0'),
(47, 'EEST', '11115277200', 10800, '1'),
(47, 'EET', '11134026000', 7200, '0'),
(47, 'EEST', '11146726800', 10800, '1'),
(47, 'EET', '11165475600', 7200, '0'),
(47, 'EEST', '11178781200', 10800, '1'),
(47, 'EET', '11196925200', 7200, '0'),
(47, 'EEST', '11210230800', 10800, '1'),
(47, 'EET', '11228374800', 7200, '0'),
(47, 'EEST', '11241680400', 10800, '1'),
(47, 'EET', '11260429200', 7200, '0'),
(47, 'EEST', '11273130000', 10800, '1'),
(47, 'EET', '11291878800', 7200, '0'),
(47, 'EEST', '11304579600', 10800, '1'),
(47, 'EET', '11323328400', 7200, '0'),
(47, 'EEST', '11336634000', 10800, '1'),
(47, 'EET', '11354778000', 7200, '0'),
(47, 'EEST', '11368083600', 10800, '1'),
(47, 'EET', '11386227600', 7200, '0'),
(47, 'EEST', '11399533200', 10800, '1'),
(47, 'EET', '11417677200', 7200, '0'),
(47, 'EEST', '11430982800', 10800, '1'),
(47, 'EET', '11449731600', 7200, '0'),
(47, 'EEST', '11462432400', 10800, '1'),
(47, 'EET', '11481181200', 7200, '0'),
(47, 'EEST', '11493882000', 10800, '1'),
(47, 'EET', '11512630800', 7200, '0'),
(47, 'EEST', '11525936400', 10800, '1'),
(47, 'EET', '11544080400', 7200, '0'),
(47, 'EEST', '11557386000', 10800, '1'),
(47, 'EET', '11575530000', 7200, '0'),
(47, 'EEST', '11588835600', 10800, '1'),
(47, 'EET', '11607584400', 7200, '0'),
(47, 'EEST', '11620285200', 10800, '1'),
(47, 'EET', '11639034000', 7200, '0'),
(47, 'EEST', '11651734800', 10800, '1'),
(47, 'EET', '11670483600', 7200, '0'),
(47, 'EEST', '11683789200', 10800, '1'),
(47, 'EET', '11701933200', 7200, '0'),
(47, 'EEST', '11715238800', 10800, '1'),
(47, 'EET', '11733382800', 7200, '0'),
(47, 'EEST', '11746688400', 10800, '1'),
(47, 'EET', '11764832400', 7200, '0'),
(47, 'EEST', '11778138000', 10800, '1'),
(47, 'EET', '11796886800', 7200, '0'),
(47, 'EEST', '11809587600', 10800, '1'),
(47, 'EET', '11828336400', 7200, '0'),
(47, 'EEST', '11841037200', 10800, '1'),
(47, 'EET', '11859786000', 7200, '0'),
(47, 'EEST', '11873091600', 10800, '1'),
(47, 'EET', '11891235600', 7200, '0'),
(47, 'EEST', '11904541200', 10800, '1'),
(47, 'EET', '11922685200', 7200, '0'),
(47, 'EEST', '11935990800', 10800, '1'),
(47, 'EET', '11954739600', 7200, '0'),
(47, 'EEST', '11967440400', 10800, '1'),
(47, 'EET', '11986189200', 7200, '0'),
(47, 'EEST', '11998890000', 10800, '1'),
(47, 'EET', '12017638800', 7200, '0'),
(47, 'EEST', '12030339600', 10800, '1'),
(47, 'EET', '12049088400', 7200, '0'),
(47, 'EEST', '12062394000', 10800, '1'),
(47, 'EET', '12080538000', 7200, '0'),
(47, 'EEST', '12093843600', 10800, '1'),
(47, 'EET', '12111987600', 7200, '0'),
(47, 'EEST', '12125293200', 10800, '1'),
(47, 'EET', '12144042000', 7200, '0'),
(47, 'EEST', '12156742800', 10800, '1'),
(47, 'EET', '12175491600', 7200, '0'),
(47, 'EEST', '12188192400', 10800, '1'),
(47, 'EET', '12206941200', 7200, '0'),
(47, 'EEST', '12220246800', 10800, '1'),
(47, 'EET', '12238390800', 7200, '0'),
(47, 'EEST', '12251696400', 10800, '1'),
(47, 'EET', '12269840400', 7200, '0'),
(47, 'EEST', '12283146000', 10800, '1'),
(47, 'EET', '12301290000', 7200, '0'),
(47, 'EEST', '12314595600', 10800, '1'),
(47, 'EET', '12333344400', 7200, '0'),
(47, 'EEST', '12346045200', 10800, '1'),
(47, 'EET', '12364794000', 7200, '0'),
(47, 'EEST', '12377494800', 10800, '1'),
(47, 'EET', '12396243600', 7200, '0'),
(47, 'EEST', '12409549200', 10800, '1'),
(47, 'EET', '12427693200', 7200, '0'),
(47, 'EEST', '12440998800', 10800, '1'),
(47, 'EET', '12459142800', 7200, '0'),
(47, 'EEST', '12472448400', 10800, '1'),
(47, 'EET', '12491197200', 7200, '0'),
(47, 'EEST', '12503898000', 10800, '1'),
(47, 'EET', '12522646800', 7200, '0'),
(47, 'EEST', '12535347600', 10800, '1'),
(47, 'EET', '12554096400', 7200, '0'),
(47, 'EEST', '12567402000', 10800, '1'),
(47, 'EET', '12585546000', 7200, '0'),
(47, 'EEST', '12598851600', 10800, '1'),
(47, 'EET', '12616995600', 7200, '0'),
(47, 'EEST', '12630301200', 10800, '1'),
(47, 'EET', '12648445200', 7200, '0'),
(47, 'EEST', '12661750800', 10800, '1'),
(47, 'EET', '12680499600', 7200, '0'),
(47, 'EEST', '12693200400', 10800, '1'),
(47, 'EET', '12711949200', 7200, '0'),
(47, 'EEST', '12724650000', 10800, '1'),
(47, 'EET', '12743398800', 7200, '0'),
(47, 'EEST', '12756704400', 10800, '1'),
(47, 'EET', '12774848400', 7200, '0'),
(47, 'EEST', '12788154000', 10800, '1'),
(47, 'EET', '12806298000', 7200, '0'),
(47, 'EEST', '12819603600', 10800, '1'),
(47, 'EET', '12838352400', 7200, '0'),
(47, 'EEST', '12851053200', 10800, '1'),
(47, 'EET', '12869802000', 7200, '0'),
(47, 'EEST', '12882502800', 10800, '1'),
(47, 'EET', '12901251600', 7200, '0'),
(47, 'EEST', '12913952400', 10800, '1'),
(47, 'EET', '12932701200', 7200, '0'),
(47, 'EEST', '12946006800', 10800, '1'),
(47, 'EET', '12964150800', 7200, '0'),
(47, 'EEST', '12977456400', 10800, '1'),
(47, 'EET', '12995600400', 7200, '0'),
(47, 'EEST', '13008906000', 10800, '1'),
(47, 'EET', '13027654800', 7200, '0'),
(47, 'EEST', '13040355600', 10800, '1'),
(47, 'EET', '13059104400', 7200, '0'),
(47, 'EEST', '13071805200', 10800, '1'),
(47, 'EET', '13090554000', 7200, '0'),
(47, 'EEST', '13103859600', 10800, '1'),
(47, 'EET', '13122003600', 7200, '0'),
(47, 'EEST', '13135309200', 10800, '1'),
(47, 'EET', '13153453200', 7200, '0'),
(47, 'EEST', '13166758800', 10800, '1'),
(47, 'EET', '13184902800', 7200, '0'),
(47, 'EEST', '13198208400', 10800, '1'),
(47, 'EET', '13216957200', 7200, '0'),
(47, 'EEST', '13229658000', 10800, '1'),
(47, 'EET', '13248406800', 7200, '0'),
(47, 'EEST', '13261107600', 10800, '1'),
(47, 'EET', '13279856400', 7200, '0'),
(47, 'EEST', '13293162000', 10800, '1'),
(47, 'EET', '13311306000', 7200, '0'),
(47, 'EEST', '13324611600', 10800, '1'),
(47, 'EET', '13342755600', 7200, '0'),
(47, 'EEST', '13356061200', 10800, '1'),
(47, 'EET', '13374810000', 7200, '0'),
(47, 'EEST', '13387510800', 10800, '1'),
(47, 'EET', '13406259600', 7200, '0'),
(47, 'EEST', '13418960400', 10800, '1'),
(47, 'EET', '13437709200', 7200, '0'),
(47, 'EEST', '13451014800', 10800, '1'),
(47, 'EET', '13469158800', 7200, '0'),
(47, 'EEST', '13482464400', 10800, '1'),
(47, 'EET', '13500608400', 7200, '0'),
(47, 'EEST', '13513914000', 10800, '1'),
(47, 'EET', '13532058000', 7200, '0'),
(47, 'EEST', '13545363600', 10800, '1'),
(47, 'EET', '13564112400', 7200, '0'),
(47, 'EEST', '13576813200', 10800, '1'),
(47, 'EET', '13595562000', 7200, '0'),
(47, 'EEST', '13608262800', 10800, '1'),
(47, 'EET', '13627011600', 7200, '0'),
(47, 'EEST', '13640317200', 10800, '1'),
(47, 'EET', '13658461200', 7200, '0'),
(47, 'EEST', '13671766800', 10800, '1'),
(47, 'EET', '13689910800', 7200, '0'),
(47, 'EEST', '13703216400', 10800, '1'),
(47, 'EET', '13721965200', 7200, '0'),
(47, 'EEST', '13734666000', 10800, '1'),
(47, 'EET', '13753414800', 7200, '0'),
(47, 'EEST', '13766115600', 10800, '1'),
(47, 'EET', '13784864400', 7200, '0'),
(47, 'EEST', '13797565200', 10800, '1'),
(47, 'EET', '13816314000', 7200, '0'),
(47, 'EEST', '13829619600', 10800, '1'),
(47, 'EET', '13847763600', 7200, '0'),
(47, 'EEST', '13861069200', 10800, '1'),
(47, 'EET', '13879213200', 7200, '0'),
(47, 'EEST', '13892518800', 10800, '1'),
(47, 'EET', '13911267600', 7200, '0'),
(47, 'EEST', '13923968400', 10800, '1'),
(47, 'EET', '13942717200', 7200, '0'),
(47, 'EEST', '13955418000', 10800, '1'),
(47, 'EET', '13974166800', 7200, '0'),
(47, 'EEST', '13987472400', 10800, '1'),
(47, 'EET', '14005616400', 7200, '0'),
(47, 'EEST', '14018922000', 10800, '1'),
(47, 'EET', '14037066000', 7200, '0'),
(47, 'EEST', '14050371600', 10800, '1'),
(47, 'EET', '14068515600', 7200, '0'),
(47, 'EEST', '14081821200', 10800, '1'),
(47, 'EET', '14100570000', 7200, '0'),
(47, 'EEST', '14113270800', 10800, '1'),
(47, 'EET', '14132019600', 7200, '0'),
(47, 'EEST', '14144720400', 10800, '1'),
(47, 'EET', '14163469200', 7200, '0'),
(47, 'EEST', '14176774800', 10800, '1'),
(47, 'EET', '14194918800', 7200, '0'),
(47, 'EEST', '14208224400', 10800, '1'),
(47, 'EET', '14226368400', 7200, '0'),
(47, 'EEST', '14239674000', 10800, '1'),
(47, 'EET', '14258422800', 7200, '0'),
(47, 'EEST', '14271123600', 10800, '1'),
(47, 'EET', '14289872400', 7200, '0'),
(47, 'EEST', '14302573200', 10800, '1'),
(47, 'EET', '14321322000', 7200, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(47, 'EEST', '14334627600', 10800, '1'),
(47, 'EET', '14352771600', 7200, '0'),
(47, 'EEST', '14366077200', 10800, '1'),
(47, 'EET', '14384221200', 7200, '0'),
(47, 'EEST', '14397526800', 10800, '1'),
(47, 'EET', '14415670800', 7200, '0'),
(47, 'EEST', '14428976400', 10800, '1'),
(47, 'EET', '14447725200', 7200, '0'),
(47, 'EEST', '14460426000', 10800, '1'),
(47, 'EET', '14479174800', 7200, '0'),
(47, 'EEST', '14491875600', 10800, '1'),
(47, 'EET', '14510624400', 7200, '0'),
(47, 'EEST', '14523930000', 10800, '1'),
(47, 'EET', '14542074000', 7200, '0'),
(47, 'EEST', '14555379600', 10800, '1'),
(47, 'EET', '14573523600', 7200, '0'),
(47, 'EEST', '14586829200', 10800, '1'),
(47, 'EET', '14605578000', 7200, '0'),
(47, 'EEST', '14618278800', 10800, '1'),
(47, 'EET', '14637027600', 7200, '0'),
(47, 'EEST', '14649728400', 10800, '1'),
(47, 'EET', '14668477200', 7200, '0'),
(47, 'EEST', '14681178000', 10800, '1'),
(47, 'EET', '14699926800', 7200, '0'),
(47, 'EEST', '14713232400', 10800, '1'),
(47, 'EET', '14731376400', 7200, '0'),
(47, 'EEST', '14744682000', 10800, '1'),
(47, 'EET', '14762826000', 7200, '0'),
(47, 'EEST', '14776131600', 10800, '1'),
(47, 'EET', '14794880400', 7200, '0'),
(47, 'EEST', '14807581200', 10800, '1'),
(47, 'EET', '14826330000', 7200, '0'),
(47, 'EEST', '14839030800', 10800, '1'),
(47, 'EET', '14857779600', 7200, '0'),
(47, 'EEST', '14871085200', 10800, '1'),
(47, 'EET', '14889229200', 7200, '0'),
(47, 'EEST', '14902534800', 10800, '1'),
(47, 'EET', '14920678800', 7200, '0'),
(47, 'EEST', '14933984400', 10800, '1'),
(47, 'EET', '14952128400', 7200, '0'),
(47, 'EEST', '14965434000', 10800, '1'),
(47, 'EET', '14984182800', 7200, '0'),
(47, 'EEST', '14996883600', 10800, '1'),
(47, 'EET', '15015632400', 7200, '0'),
(47, 'EEST', '15028333200', 10800, '1'),
(47, 'EET', '15047082000', 7200, '0'),
(47, 'EEST', '15060387600', 10800, '1'),
(47, 'EET', '15078531600', 7200, '0'),
(47, 'EEST', '15091837200', 10800, '1'),
(47, 'EET', '15109981200', 7200, '0'),
(47, 'EEST', '15123286800', 10800, '1'),
(47, 'EET', '15142035600', 7200, '0'),
(47, 'EEST', '15154736400', 10800, '1'),
(47, 'EET', '15173485200', 7200, '0'),
(47, 'EEST', '15186186000', 10800, '1'),
(47, 'EET', '15204934800', 7200, '0'),
(47, 'EEST', '15218240400', 10800, '1'),
(47, 'EET', '15236384400', 7200, '0'),
(47, 'EEST', '15249690000', 10800, '1'),
(47, 'EET', '15267834000', 7200, '0'),
(47, 'EEST', '15281139600', 10800, '1'),
(47, 'EET', '15299283600', 7200, '0'),
(47, 'EEST', '15312589200', 10800, '1'),
(47, 'EET', '15331338000', 7200, '0'),
(47, 'EEST', '15344038800', 10800, '1'),
(47, 'EET', '15362787600', 7200, '0'),
(47, 'EEST', '15375488400', 10800, '1'),
(47, 'EET', '15394237200', 7200, '0'),
(47, 'EEST', '15407542800', 10800, '1'),
(47, 'EET', '15425686800', 7200, '0'),
(47, 'EEST', '15438992400', 10800, '1'),
(47, 'EET', '15457136400', 7200, '0'),
(47, 'EEST', '15470442000', 10800, '1'),
(47, 'EET', '15489190800', 7200, '0'),
(47, 'EEST', '15501891600', 10800, '1'),
(47, 'EET', '15520640400', 7200, '0'),
(47, 'EEST', '15533341200', 10800, '1'),
(47, 'EET', '15552090000', 7200, '0'),
(47, 'EEST', '15564790800', 10800, '1'),
(47, 'EET', '15583539600', 7200, '0'),
(47, 'EEST', '15596845200', 10800, '1'),
(47, 'EET', '15614989200', 7200, '0'),
(47, 'EEST', '15628294800', 10800, '1'),
(47, 'EET', '15646438800', 7200, '0'),
(47, 'EEST', '15659744400', 10800, '1'),
(47, 'EET', '15678493200', 7200, '0'),
(47, 'EEST', '15691194000', 10800, '1'),
(47, 'EET', '15709942800', 7200, '0'),
(47, 'EEST', '15722643600', 10800, '1'),
(47, 'EET', '15741392400', 7200, '0'),
(47, 'EEST', '15754698000', 10800, '1'),
(47, 'EET', '15772842000', 7200, '0'),
(47, 'EEST', '15786147600', 10800, '1'),
(47, 'EET', '15804291600', 7200, '0'),
(47, 'EEST', '15817597200', 10800, '1'),
(47, 'EET', '15835741200', 7200, '0'),
(47, 'EEST', '15849046800', 10800, '1'),
(47, 'EET', '15867795600', 7200, '0'),
(47, 'EEST', '15880496400', 10800, '1'),
(47, 'EET', '15899245200', 7200, '0'),
(47, 'EEST', '15911946000', 10800, '1'),
(47, 'EET', '15930694800', 7200, '0'),
(47, 'EEST', '15944000400', 10800, '1'),
(47, 'EET', '15962144400', 7200, '0'),
(47, 'EEST', '15975450000', 10800, '1'),
(47, 'EET', '15993594000', 7200, '0'),
(47, 'EEST', '16006899600', 10800, '1'),
(47, 'EET', '16025648400', 7200, '0'),
(47, 'EEST', '16038349200', 10800, '1'),
(47, 'EET', '16057098000', 7200, '0'),
(47, 'EEST', '16069798800', 10800, '1'),
(47, 'EET', '16088547600', 7200, '0'),
(47, 'EEST', '16101853200', 10800, '1'),
(47, 'EET', '16119997200', 7200, '0'),
(47, 'EEST', '16133302800', 10800, '1'),
(47, 'EET', '16151446800', 7200, '0'),
(47, 'EEST', '16164752400', 10800, '1'),
(47, 'EET', '16182896400', 7200, '0'),
(47, 'EEST', '16196202000', 10800, '1'),
(47, 'EET', '16214950800', 7200, '0'),
(47, 'EEST', '16227651600', 10800, '1'),
(47, 'EET', '16246400400', 7200, '0'),
(47, 'EEST', '16259101200', 10800, '1'),
(47, 'EET', '16277850000', 7200, '0'),
(47, 'EEST', '16291155600', 10800, '1'),
(47, 'EET', '16309299600', 7200, '0'),
(47, 'EEST', '16322605200', 10800, '1'),
(47, 'EET', '16340749200', 7200, '0'),
(47, 'EEST', '16354054800', 10800, '1'),
(47, 'EET', '16372803600', 7200, '0'),
(47, 'EEST', '16385504400', 10800, '1'),
(47, 'EET', '16404253200', 7200, '0'),
(47, 'EEST', '16416954000', 10800, '1'),
(47, 'EET', '16435702800', 7200, '0'),
(47, 'EEST', '16448403600', 10800, '1'),
(47, 'EET', '16467152400', 7200, '0'),
(47, 'EEST', '16480458000', 10800, '1'),
(47, 'EET', '16498602000', 7200, '0'),
(47, 'EEST', '16511907600', 10800, '1'),
(47, 'EET', '16530051600', 7200, '0'),
(47, 'EEST', '16543357200', 10800, '1'),
(47, 'EET', '16562106000', 7200, '0'),
(47, 'EEST', '16574806800', 10800, '1'),
(47, 'EET', '16593555600', 7200, '0'),
(47, 'EEST', '16606256400', 10800, '1'),
(47, 'EET', '16625005200', 7200, '0'),
(47, 'EEST', '16638310800', 10800, '1'),
(47, 'EET', '16656454800', 7200, '0'),
(47, 'EEST', '16669760400', 10800, '1'),
(47, 'EET', '16687904400', 7200, '0'),
(47, 'EEST', '16701210000', 10800, '1'),
(47, 'EET', '16719354000', 7200, '0'),
(48, 'LMT', '-1441163965', 11964, '0'),
(48, '+03', '-1441163964', 10800, '0'),
(48, '+04', '-405140400', 14400, '0'),
(48, '+05', '354916800', 18000, '1'),
(48, '+04', '370724400', 14400, '0'),
(48, '+05', '386452800', 18000, '1'),
(48, '+04', '402260400', 14400, '0'),
(48, '+05', '417988800', 18000, '1'),
(48, '+04', '433796400', 14400, '0'),
(48, '+05', '449611200', 18000, '1'),
(48, '+04', '465343200', 14400, '0'),
(48, '+05', '481068000', 18000, '1'),
(48, '+04', '496792800', 14400, '0'),
(48, '+05', '512517600', 18000, '1'),
(48, '+04', '528242400', 14400, '0'),
(48, '+05', '543967200', 18000, '1'),
(48, '+04', '559692000', 14400, '0'),
(48, '+05', '575416800', 18000, '1'),
(48, '+04', '591141600', 14400, '0'),
(48, '+05', '606866400', 18000, '1'),
(48, '+04', '622591200', 14400, '0'),
(48, '+05', '638316000', 18000, '1'),
(48, '+04', '654645600', 14400, '0'),
(48, '+03', '686098800', 10800, '0'),
(48, '+04', '701823600', 14400, '1'),
(48, '+05', '828234000', 18000, '1'),
(48, '+04', '846378000', 14400, '0'),
(48, '+05', '859680000', 18000, '1'),
(48, '+04', '877824000', 14400, '0'),
(48, '+05', '891129600', 18000, '1'),
(48, '+04', '909273600', 14400, '0'),
(48, '+05', '922579200', 18000, '1'),
(48, '+04', '941328000', 14400, '0'),
(48, '+05', '954028800', 18000, '1'),
(48, '+04', '972777600', 14400, '0'),
(48, '+05', '985478400', 18000, '1'),
(48, '+04', '1004227200', 14400, '0'),
(48, '+05', '1017532800', 18000, '1'),
(48, '+04', '1035676800', 14400, '0'),
(48, '+05', '1048982400', 18000, '1'),
(48, '+04', '1067126400', 14400, '0'),
(48, '+05', '1080432000', 18000, '1'),
(48, '+04', '1099180800', 14400, '0'),
(48, '+05', '1111881600', 18000, '1'),
(48, '+04', '1130630400', 14400, '0'),
(48, '+05', '1143331200', 18000, '1'),
(48, '+04', '1162080000', 14400, '0'),
(48, '+05', '1174780800', 18000, '1'),
(48, '+04', '1193529600', 14400, '0'),
(48, '+05', '1206835200', 18000, '1'),
(48, '+04', '1224979200', 14400, '0'),
(48, '+05', '1238284800', 18000, '1'),
(48, '+04', '1256428800', 14400, '0'),
(48, '+05', '1269734400', 18000, '1'),
(48, '+04', '1288483200', 14400, '0'),
(48, '+05', '1301184000', 18000, '1'),
(48, '+04', '1319932800', 14400, '0'),
(48, '+05', '1332633600', 18000, '1'),
(48, '+04', '1351382400', 14400, '0'),
(48, '+05', '1364688000', 18000, '1'),
(48, '+04', '1382832000', 14400, '0'),
(48, '+05', '1396137600', 18000, '1'),
(48, '+04', '1414281600', 14400, '0'),
(48, '+05', '1427587200', 18000, '1'),
(48, '+04', '1445731200', 14400, '0'),
(49, 'LMT', '-2713915321', 4920, '0'),
(49, 'CET', '-2713915320', 3600, '0'),
(49, 'CEST', '-905824800', 7200, '1'),
(49, 'CET', '-857257200', 3600, '0'),
(49, 'CEST', '-844556400', 7200, '1'),
(49, 'CET', '-828226800', 3600, '0'),
(49, 'CEST', '-812502000', 7200, '1'),
(49, 'CET', '-796777200', 3600, '0'),
(49, 'CEST', '-777942000', 7200, '1'),
(49, 'CET', '-766623600', 3600, '0'),
(49, 'CEST', '417574800', 7200, '1'),
(49, 'CET', '433299600', 3600, '0'),
(49, 'CEST', '449024400', 7200, '1'),
(49, 'CET', '465354000', 3600, '0'),
(49, 'CEST', '481078800', 7200, '1'),
(49, 'CET', '496803600', 3600, '0'),
(49, 'CEST', '512528400', 7200, '1'),
(49, 'CET', '528253200', 3600, '0'),
(49, 'CEST', '543978000', 7200, '1'),
(49, 'CET', '559702800', 3600, '0'),
(49, 'CEST', '575427600', 7200, '1'),
(49, 'CET', '591152400', 3600, '0'),
(49, 'CEST', '606877200', 7200, '1'),
(49, 'CET', '622602000', 3600, '0'),
(49, 'CEST', '638326800', 7200, '1'),
(49, 'CET', '654656400', 3600, '0'),
(49, 'CEST', '670381200', 7200, '1'),
(49, 'CET', '686106000', 3600, '0'),
(49, 'CEST', '701830800', 7200, '1'),
(49, 'CET', '717555600', 3600, '0'),
(49, 'CEST', '733280400', 7200, '1'),
(49, 'CET', '749005200', 3600, '0'),
(49, 'CEST', '764730000', 7200, '1'),
(49, 'CET', '780454800', 3600, '0'),
(49, 'CEST', '796179600', 7200, '1'),
(49, 'CET', '811904400', 3600, '0'),
(49, 'CEST', '828234000', 7200, '1'),
(49, 'CET', '846378000', 3600, '0'),
(49, 'CEST', '859683600', 7200, '1'),
(49, 'CET', '877827600', 3600, '0'),
(49, 'CEST', '891133200', 7200, '1'),
(49, 'CET', '909277200', 3600, '0'),
(49, 'CEST', '922582800', 7200, '1'),
(49, 'CET', '941331600', 3600, '0'),
(49, 'CEST', '954032400', 7200, '1'),
(49, 'CET', '972781200', 3600, '0'),
(49, 'CEST', '985482000', 7200, '1'),
(49, 'CET', '1004230800', 3600, '0'),
(49, 'CEST', '1017536400', 7200, '1'),
(49, 'CET', '1035680400', 3600, '0'),
(49, 'CEST', '1048986000', 7200, '1'),
(49, 'CET', '1067130000', 3600, '0'),
(49, 'CEST', '1080435600', 7200, '1'),
(49, 'CET', '1099184400', 3600, '0'),
(49, 'CEST', '1111885200', 7200, '1'),
(49, 'CET', '1130634000', 3600, '0'),
(49, 'CEST', '1143334800', 7200, '1'),
(49, 'CET', '1162083600', 3600, '0'),
(49, 'CEST', '1174784400', 7200, '1'),
(49, 'CET', '1193533200', 3600, '0'),
(49, 'CEST', '1206838800', 7200, '1'),
(49, 'CET', '1224982800', 3600, '0'),
(49, 'CEST', '1238288400', 7200, '1'),
(49, 'CET', '1256432400', 3600, '0'),
(49, 'CEST', '1269738000', 7200, '1'),
(49, 'CET', '1288486800', 3600, '0'),
(49, 'CEST', '1301187600', 7200, '1'),
(49, 'CET', '1319936400', 3600, '0'),
(49, 'CEST', '1332637200', 7200, '1'),
(49, 'CET', '1351386000', 3600, '0'),
(49, 'CEST', '1364691600', 7200, '1'),
(49, 'CET', '1382835600', 3600, '0'),
(49, 'CEST', '1396141200', 7200, '1'),
(49, 'CET', '1414285200', 3600, '0'),
(49, 'CEST', '1427590800', 7200, '1'),
(49, 'CET', '1445734800', 3600, '0'),
(49, 'CEST', '1459040400', 7200, '1'),
(49, 'CET', '1477789200', 3600, '0'),
(49, 'CEST', '1490490000', 7200, '1'),
(49, 'CET', '1509238800', 3600, '0'),
(49, 'CEST', '1521939600', 7200, '1'),
(49, 'CET', '1540688400', 3600, '0'),
(49, 'CEST', '1553994000', 7200, '1'),
(49, 'CET', '1572138000', 3600, '0'),
(49, 'CEST', '1585443600', 7200, '1'),
(49, 'CET', '1603587600', 3600, '0'),
(49, 'CEST', '1616893200', 7200, '1'),
(49, 'CET', '1635642000', 3600, '0'),
(49, 'CEST', '1648342800', 7200, '1'),
(49, 'CET', '1667091600', 3600, '0'),
(49, 'CEST', '1679792400', 7200, '1'),
(49, 'CET', '1698541200', 3600, '0'),
(49, 'CEST', '1711846800', 7200, '1'),
(49, 'CET', '1729990800', 3600, '0'),
(49, 'CEST', '1743296400', 7200, '1'),
(49, 'CET', '1761440400', 3600, '0'),
(49, 'CEST', '1774746000', 7200, '1'),
(49, 'CET', '1792890000', 3600, '0'),
(49, 'CEST', '1806195600', 7200, '1'),
(49, 'CET', '1824944400', 3600, '0'),
(49, 'CEST', '1837645200', 7200, '1'),
(49, 'CET', '1856394000', 3600, '0'),
(49, 'CEST', '1869094800', 7200, '1'),
(49, 'CET', '1887843600', 3600, '0'),
(49, 'CEST', '1901149200', 7200, '1'),
(49, 'CET', '1919293200', 3600, '0'),
(49, 'CEST', '1932598800', 7200, '1'),
(49, 'CET', '1950742800', 3600, '0'),
(49, 'CEST', '1964048400', 7200, '1'),
(49, 'CET', '1982797200', 3600, '0'),
(49, 'CEST', '1995498000', 7200, '1'),
(49, 'CET', '2014246800', 3600, '0'),
(49, 'CEST', '2026947600', 7200, '1'),
(49, 'CET', '2045696400', 3600, '0'),
(49, 'CEST', '2058397200', 7200, '1'),
(49, 'CET', '2077146000', 3600, '0'),
(49, 'CEST', '2090451600', 7200, '1'),
(49, 'CET', '2108595600', 3600, '0'),
(49, 'CEST', '2121901200', 7200, '1'),
(49, 'CET', '2140045200', 3600, '0'),
(49, 'CEST', '2153350800', 7200, '1'),
(49, 'CET', '2172099600', 3600, '0'),
(49, 'CEST', '2184800400', 7200, '1'),
(49, 'CET', '2203549200', 3600, '0'),
(49, 'CEST', '2216250000', 7200, '1'),
(49, 'CET', '2234998800', 3600, '0'),
(49, 'CEST', '2248304400', 7200, '1'),
(49, 'CET', '2266448400', 3600, '0'),
(49, 'CEST', '2279754000', 7200, '1'),
(49, 'CET', '2297898000', 3600, '0'),
(49, 'CEST', '2311203600', 7200, '1'),
(49, 'CET', '2329347600', 3600, '0'),
(49, 'CEST', '2342653200', 7200, '1'),
(49, 'CET', '2361402000', 3600, '0'),
(49, 'CEST', '2374102800', 7200, '1'),
(49, 'CET', '2392851600', 3600, '0'),
(49, 'CEST', '2405552400', 7200, '1'),
(49, 'CET', '2424301200', 3600, '0'),
(49, 'CEST', '2437606800', 7200, '1'),
(49, 'CET', '2455750800', 3600, '0'),
(49, 'CEST', '2469056400', 7200, '1'),
(49, 'CET', '2487200400', 3600, '0'),
(49, 'CEST', '2500506000', 7200, '1'),
(49, 'CET', '2519254800', 3600, '0'),
(49, 'CEST', '2531955600', 7200, '1'),
(49, 'CET', '2550704400', 3600, '0'),
(49, 'CEST', '2563405200', 7200, '1'),
(49, 'CET', '2582154000', 3600, '0'),
(49, 'CEST', '2595459600', 7200, '1'),
(49, 'CET', '2613603600', 3600, '0'),
(49, 'CEST', '2626909200', 7200, '1'),
(49, 'CET', '2645053200', 3600, '0'),
(49, 'CEST', '2658358800', 7200, '1'),
(49, 'CET', '2676502800', 3600, '0'),
(49, 'CEST', '2689808400', 7200, '1'),
(49, 'CET', '2708557200', 3600, '0'),
(49, 'CEST', '2721258000', 7200, '1'),
(49, 'CET', '2740006800', 3600, '0'),
(49, 'CEST', '2752707600', 7200, '1'),
(49, 'CET', '2771456400', 3600, '0'),
(49, 'CEST', '2784762000', 7200, '1'),
(49, 'CET', '2802906000', 3600, '0'),
(49, 'CEST', '2816211600', 7200, '1'),
(49, 'CET', '2834355600', 3600, '0'),
(49, 'CEST', '2847661200', 7200, '1'),
(49, 'CET', '2866410000', 3600, '0'),
(49, 'CEST', '2879110800', 7200, '1'),
(49, 'CET', '2897859600', 3600, '0'),
(49, 'CEST', '2910560400', 7200, '1'),
(49, 'CET', '2929309200', 3600, '0'),
(49, 'CEST', '2942010000', 7200, '1'),
(49, 'CET', '2960758800', 3600, '0'),
(49, 'CEST', '2974064400', 7200, '1'),
(49, 'CET', '2992208400', 3600, '0'),
(49, 'CEST', '3005514000', 7200, '1'),
(49, 'CET', '3023658000', 3600, '0'),
(49, 'CEST', '3036963600', 7200, '1'),
(49, 'CET', '3055712400', 3600, '0'),
(49, 'CEST', '3068413200', 7200, '1'),
(49, 'CET', '3087162000', 3600, '0'),
(49, 'CEST', '3099862800', 7200, '1'),
(49, 'CET', '3118611600', 3600, '0'),
(49, 'CEST', '3131917200', 7200, '1'),
(49, 'CET', '3150061200', 3600, '0'),
(49, 'CEST', '3163366800', 7200, '1'),
(49, 'CET', '3181510800', 3600, '0'),
(49, 'CEST', '3194816400', 7200, '1'),
(49, 'CET', '3212960400', 3600, '0'),
(49, 'CEST', '3226266000', 7200, '1'),
(49, 'CET', '3245014800', 3600, '0'),
(49, 'CEST', '3257715600', 7200, '1'),
(49, 'CET', '3276464400', 3600, '0'),
(49, 'CEST', '3289165200', 7200, '1'),
(49, 'CET', '3307914000', 3600, '0'),
(49, 'CEST', '3321219600', 7200, '1'),
(49, 'CET', '3339363600', 3600, '0'),
(49, 'CEST', '3352669200', 7200, '1'),
(49, 'CET', '3370813200', 3600, '0'),
(49, 'CEST', '3384118800', 7200, '1'),
(49, 'CET', '3402867600', 3600, '0'),
(49, 'CEST', '3415568400', 7200, '1'),
(49, 'CET', '3434317200', 3600, '0'),
(49, 'CEST', '3447018000', 7200, '1'),
(49, 'CET', '3465766800', 3600, '0'),
(49, 'CEST', '3479072400', 7200, '1'),
(49, 'CET', '3497216400', 3600, '0'),
(49, 'CEST', '3510522000', 7200, '1'),
(49, 'CET', '3528666000', 3600, '0'),
(49, 'CEST', '3541971600', 7200, '1'),
(49, 'CET', '3560115600', 3600, '0'),
(49, 'CEST', '3573421200', 7200, '1'),
(49, 'CET', '3592170000', 3600, '0'),
(49, 'CEST', '3604870800', 7200, '1'),
(49, 'CET', '3623619600', 3600, '0'),
(49, 'CEST', '3636320400', 7200, '1'),
(49, 'CET', '3655069200', 3600, '0'),
(49, 'CEST', '3668374800', 7200, '1'),
(49, 'CET', '3686518800', 3600, '0'),
(49, 'CEST', '3699824400', 7200, '1'),
(49, 'CET', '3717968400', 3600, '0'),
(49, 'CEST', '3731274000', 7200, '1'),
(49, 'CET', '3750022800', 3600, '0'),
(49, 'CEST', '3762723600', 7200, '1'),
(49, 'CET', '3781472400', 3600, '0'),
(49, 'CEST', '3794173200', 7200, '1'),
(49, 'CET', '3812922000', 3600, '0'),
(49, 'CEST', '3825622800', 7200, '1'),
(49, 'CET', '3844371600', 3600, '0'),
(49, 'CEST', '3857677200', 7200, '1'),
(49, 'CET', '3875821200', 3600, '0'),
(49, 'CEST', '3889126800', 7200, '1'),
(49, 'CET', '3907270800', 3600, '0'),
(49, 'CEST', '3920576400', 7200, '1'),
(49, 'CET', '3939325200', 3600, '0'),
(49, 'CEST', '3952026000', 7200, '1'),
(49, 'CET', '3970774800', 3600, '0'),
(49, 'CEST', '3983475600', 7200, '1'),
(49, 'CET', '4002224400', 3600, '0'),
(49, 'CEST', '4015530000', 7200, '1'),
(49, 'CET', '4033674000', 3600, '0'),
(49, 'CEST', '4046979600', 7200, '1'),
(49, 'CET', '4065123600', 3600, '0'),
(49, 'CEST', '4078429200', 7200, '1'),
(49, 'CET', '4096573200', 3600, '0'),
(49, 'CEST', '4109878800', 7200, '1'),
(49, 'CET', '4128627600', 3600, '0'),
(49, 'CEST', '4141328400', 7200, '1'),
(49, 'CET', '4160077200', 3600, '0'),
(49, 'CEST', '4172778000', 7200, '1'),
(49, 'CET', '4191526800', 3600, '0'),
(49, 'CEST', '4204227600', 7200, '1'),
(49, 'CET', '4222976400', 3600, '0'),
(49, 'CEST', '4236282000', 7200, '1'),
(49, 'CET', '4254426000', 3600, '0'),
(49, 'CEST', '4267731600', 7200, '1'),
(49, 'CET', '4285875600', 3600, '0'),
(49, 'CEST', '4299181200', 7200, '1'),
(49, 'CET', '4317930000', 3600, '0'),
(49, 'CEST', '4330630800', 7200, '1'),
(49, 'CET', '4349379600', 3600, '0'),
(49, 'CEST', '4362080400', 7200, '1'),
(49, 'CET', '4380829200', 3600, '0'),
(49, 'CEST', '4394134800', 7200, '1'),
(49, 'CET', '4412278800', 3600, '0'),
(49, 'CEST', '4425584400', 7200, '1'),
(49, 'CET', '4443728400', 3600, '0'),
(49, 'CEST', '4457034000', 7200, '1'),
(49, 'CET', '4475178000', 3600, '0'),
(49, 'CEST', '4488483600', 7200, '1'),
(49, 'CET', '4507232400', 3600, '0'),
(49, 'CEST', '4519933200', 7200, '1'),
(49, 'CET', '4538682000', 3600, '0'),
(49, 'CEST', '4551382800', 7200, '1'),
(49, 'CET', '4570131600', 3600, '0'),
(49, 'CEST', '4583437200', 7200, '1'),
(49, 'CET', '4601581200', 3600, '0'),
(49, 'CEST', '4614886800', 7200, '1'),
(49, 'CET', '4633030800', 3600, '0'),
(49, 'CEST', '4646336400', 7200, '1'),
(49, 'CET', '4665085200', 3600, '0'),
(49, 'CEST', '4677786000', 7200, '1'),
(49, 'CET', '4696534800', 3600, '0'),
(49, 'CEST', '4709235600', 7200, '1'),
(49, 'CET', '4727984400', 3600, '0'),
(49, 'CEST', '4741290000', 7200, '1'),
(49, 'CET', '4759434000', 3600, '0'),
(49, 'CEST', '4772739600', 7200, '1'),
(49, 'CET', '4790883600', 3600, '0'),
(49, 'CEST', '4804189200', 7200, '1'),
(49, 'CET', '4822333200', 3600, '0'),
(49, 'CEST', '4835638800', 7200, '1'),
(49, 'CET', '4854387600', 3600, '0'),
(49, 'CEST', '4867088400', 7200, '1'),
(49, 'CET', '4885837200', 3600, '0'),
(49, 'CEST', '4898538000', 7200, '1'),
(49, 'CET', '4917286800', 3600, '0'),

(49, 'CEST', '4930592400', 7200, '1'),
(49, 'CET', '4948736400', 3600, '0'),
(49, 'CEST', '4962042000', 7200, '1'),
(49, 'CET', '4980186000', 3600, '0'),
(49, 'CEST', '4993491600', 7200, '1'),
(49, 'CET', '5012240400', 3600, '0'),
(49, 'CEST', '5024941200', 7200, '1'),
(49, 'CET', '5043690000', 3600, '0'),
(49, 'CEST', '5056390800', 7200, '1'),
(49, 'CET', '5075139600', 3600, '0'),
(49, 'CEST', '5087840400', 7200, '1'),
(49, 'CET', '5106589200', 3600, '0'),
(49, 'CEST', '5119894800', 7200, '1'),
(49, 'CET', '5138038800', 3600, '0'),
(49, 'CEST', '5151344400', 7200, '1'),
(49, 'CET', '5169488400', 3600, '0'),
(49, 'CEST', '5182794000', 7200, '1'),
(49, 'CET', '5201542800', 3600, '0'),
(49, 'CEST', '5214243600', 7200, '1'),
(49, 'CET', '5232992400', 3600, '0'),
(49, 'CEST', '5245693200', 7200, '1'),
(49, 'CET', '5264442000', 3600, '0'),
(49, 'CEST', '5277747600', 7200, '1'),
(49, 'CET', '5295891600', 3600, '0'),
(49, 'CEST', '5309197200', 7200, '1'),
(49, 'CET', '5327341200', 3600, '0'),
(49, 'CEST', '5340646800', 7200, '1'),
(49, 'CET', '5358790800', 3600, '0'),
(49, 'CEST', '5372096400', 7200, '1'),
(49, 'CET', '5390845200', 3600, '0'),
(49, 'CEST', '5403546000', 7200, '1'),
(49, 'CET', '5422294800', 3600, '0'),
(49, 'CEST', '5434995600', 7200, '1'),
(49, 'CET', '5453744400', 3600, '0'),
(49, 'CEST', '5467050000', 7200, '1'),
(49, 'CET', '5485194000', 3600, '0'),
(49, 'CEST', '5498499600', 7200, '1'),
(49, 'CET', '5516643600', 3600, '0'),
(49, 'CEST', '5529949200', 7200, '1'),
(49, 'CET', '5548698000', 3600, '0'),
(49, 'CEST', '5561398800', 7200, '1'),
(49, 'CET', '5580147600', 3600, '0'),
(49, 'CEST', '5592848400', 7200, '1'),
(49, 'CET', '5611597200', 3600, '0'),
(49, 'CEST', '5624902800', 7200, '1'),
(49, 'CET', '5643046800', 3600, '0'),
(49, 'CEST', '5656352400', 7200, '1'),
(49, 'CET', '5674496400', 3600, '0'),
(49, 'CEST', '5687802000', 7200, '1'),
(49, 'CET', '5705946000', 3600, '0'),
(49, 'CEST', '5719251600', 7200, '1'),
(49, 'CET', '5738000400', 3600, '0'),
(49, 'CEST', '5750701200', 7200, '1'),
(49, 'CET', '5769450000', 3600, '0'),
(49, 'CEST', '5782150800', 7200, '1'),
(49, 'CET', '5800899600', 3600, '0'),
(49, 'CEST', '5814205200', 7200, '1'),
(49, 'CET', '5832349200', 3600, '0'),
(49, 'CEST', '5845654800', 7200, '1'),
(49, 'CET', '5863798800', 3600, '0'),
(49, 'CEST', '5877104400', 7200, '1'),
(49, 'CET', '5895853200', 3600, '0'),
(49, 'CEST', '5908554000', 7200, '1'),
(49, 'CET', '5927302800', 3600, '0'),
(49, 'CEST', '5940003600', 7200, '1'),
(49, 'CET', '5958752400', 3600, '0'),
(49, 'CEST', '5971453200', 7200, '1'),
(49, 'CET', '5990202000', 3600, '0'),
(49, 'CEST', '6003507600', 7200, '1'),
(49, 'CET', '6021651600', 3600, '0'),
(49, 'CEST', '6034957200', 7200, '1'),
(49, 'CET', '6053101200', 3600, '0'),
(49, 'CEST', '6066406800', 7200, '1'),
(49, 'CET', '6085155600', 3600, '0'),
(49, 'CEST', '6097856400', 7200, '1'),
(49, 'CET', '6116605200', 3600, '0'),
(49, 'CEST', '6129306000', 7200, '1'),
(49, 'CET', '6148054800', 3600, '0'),
(49, 'CEST', '6161360400', 7200, '1'),
(49, 'CET', '6179504400', 3600, '0'),
(49, 'CEST', '6192810000', 7200, '1'),
(49, 'CET', '6210954000', 3600, '0'),
(49, 'CEST', '6224259600', 7200, '1'),
(49, 'CET', '6242403600', 3600, '0'),
(49, 'CEST', '6255709200', 7200, '1'),
(49, 'CET', '6274458000', 3600, '0'),
(49, 'CEST', '6287158800', 7200, '1'),
(49, 'CET', '6305907600', 3600, '0'),
(49, 'CEST', '6318608400', 7200, '1'),
(49, 'CET', '6337357200', 3600, '0'),
(49, 'CEST', '6350662800', 7200, '1'),
(49, 'CET', '6368806800', 3600, '0'),
(49, 'CEST', '6382112400', 7200, '1'),
(49, 'CET', '6400256400', 3600, '0'),
(49, 'CEST', '6413562000', 7200, '1'),
(49, 'CET', '6432310800', 3600, '0'),
(49, 'CEST', '6445011600', 7200, '1'),
(49, 'CET', '6463760400', 3600, '0'),
(49, 'CEST', '6476461200', 7200, '1'),
(49, 'CET', '6495210000', 3600, '0'),
(49, 'CEST', '6508515600', 7200, '1'),
(49, 'CET', '6526659600', 3600, '0'),
(49, 'CEST', '6539965200', 7200, '1'),
(49, 'CET', '6558109200', 3600, '0'),
(49, 'CEST', '6571414800', 7200, '1'),
(49, 'CET', '6589558800', 3600, '0'),
(49, 'CEST', '6602864400', 7200, '1'),
(49, 'CET', '6621613200', 3600, '0'),
(49, 'CEST', '6634314000', 7200, '1'),
(49, 'CET', '6653062800', 3600, '0'),
(49, 'CEST', '6665763600', 7200, '1'),
(49, 'CET', '6684512400', 3600, '0'),
(49, 'CEST', '6697818000', 7200, '1'),
(49, 'CET', '6715962000', 3600, '0'),
(49, 'CEST', '6729267600', 7200, '1'),
(49, 'CET', '6747411600', 3600, '0'),
(49, 'CEST', '6760717200', 7200, '1'),
(49, 'CET', '6779466000', 3600, '0'),
(49, 'CEST', '6792166800', 7200, '1'),
(49, 'CET', '6810915600', 3600, '0'),
(49, 'CEST', '6823616400', 7200, '1'),
(49, 'CET', '6842365200', 3600, '0'),
(49, 'CEST', '6855066000', 7200, '1'),
(49, 'CET', '6873814800', 3600, '0'),
(49, 'CEST', '6887120400', 7200, '1'),
(49, 'CET', '6905264400', 3600, '0'),
(49, 'CEST', '6918570000', 7200, '1'),
(49, 'CET', '6936714000', 3600, '0'),
(49, 'CEST', '6950019600', 7200, '1'),
(49, 'CET', '6968768400', 3600, '0'),
(49, 'CEST', '6981469200', 7200, '1'),
(49, 'CET', '7000218000', 3600, '0'),
(49, 'CEST', '7012918800', 7200, '1'),
(49, 'CET', '7031667600', 3600, '0'),
(49, 'CEST', '7044973200', 7200, '1'),
(49, 'CET', '7063117200', 3600, '0'),
(49, 'CEST', '7076422800', 7200, '1'),
(49, 'CET', '7094566800', 3600, '0'),
(49, 'CEST', '7107872400', 7200, '1'),
(49, 'CET', '7126016400', 3600, '0'),
(49, 'CEST', '7139322000', 7200, '1'),
(49, 'CET', '7158070800', 3600, '0'),
(49, 'CEST', '7170771600', 7200, '1'),
(49, 'CET', '7189520400', 3600, '0'),
(49, 'CEST', '7202221200', 7200, '1'),
(49, 'CET', '7220970000', 3600, '0'),
(49, 'CEST', '7234275600', 7200, '1'),
(49, 'CET', '7252419600', 3600, '0'),
(49, 'CEST', '7265725200', 7200, '1'),
(49, 'CET', '7283869200', 3600, '0'),
(49, 'CEST', '7297174800', 7200, '1'),
(49, 'CET', '7315318800', 3600, '0'),
(49, 'CEST', '7328624400', 7200, '1'),
(49, 'CET', '7347373200', 3600, '0'),
(49, 'CEST', '7360074000', 7200, '1'),
(49, 'CET', '7378822800', 3600, '0'),
(49, 'CEST', '7391523600', 7200, '1'),
(49, 'CET', '7410272400', 3600, '0'),
(49, 'CEST', '7423578000', 7200, '1'),
(49, 'CET', '7441722000', 3600, '0'),
(49, 'CEST', '7455027600', 7200, '1'),
(49, 'CET', '7473171600', 3600, '0'),
(49, 'CEST', '7486477200', 7200, '1'),
(49, 'CET', '7504621200', 3600, '0'),
(49, 'CEST', '7517926800', 7200, '1'),
(49, 'CET', '7536675600', 3600, '0'),
(49, 'CEST', '7549376400', 7200, '1'),
(49, 'CET', '7568125200', 3600, '0'),
(49, 'CEST', '7580826000', 7200, '1'),
(49, 'CET', '7599574800', 3600, '0'),
(49, 'CEST', '7612880400', 7200, '1'),
(49, 'CET', '7631024400', 3600, '0'),
(49, 'CEST', '7644330000', 7200, '1'),
(49, 'CET', '7662474000', 3600, '0'),
(49, 'CEST', '7675779600', 7200, '1'),
(49, 'CET', '7694528400', 3600, '0'),
(49, 'CEST', '7707229200', 7200, '1'),
(49, 'CET', '7725978000', 3600, '0'),
(49, 'CEST', '7738678800', 7200, '1'),
(49, 'CET', '7757427600', 3600, '0'),
(49, 'CEST', '7770733200', 7200, '1'),
(49, 'CET', '7788877200', 3600, '0'),
(49, 'CEST', '7802182800', 7200, '1'),
(49, 'CET', '7820326800', 3600, '0'),
(49, 'CEST', '7833632400', 7200, '1'),
(49, 'CET', '7851776400', 3600, '0'),
(49, 'CEST', '7865082000', 7200, '1'),
(49, 'CET', '7883830800', 3600, '0'),
(49, 'CEST', '7896531600', 7200, '1'),
(49, 'CET', '7915280400', 3600, '0'),
(49, 'CEST', '7927981200', 7200, '1'),
(49, 'CET', '7946730000', 3600, '0'),
(49, 'CEST', '7960035600', 7200, '1'),
(49, 'CET', '7978179600', 3600, '0'),
(49, 'CEST', '7991485200', 7200, '1'),
(49, 'CET', '8009629200', 3600, '0'),
(49, 'CEST', '8022934800', 7200, '1'),
(49, 'CET', '8041683600', 3600, '0'),
(49, 'CEST', '8054384400', 7200, '1'),
(49, 'CET', '8073133200', 3600, '0'),
(49, 'CEST', '8085834000', 7200, '1'),
(49, 'CET', '8104582800', 3600, '0'),
(49, 'CEST', '8117283600', 7200, '1'),
(49, 'CET', '8136032400', 3600, '0'),
(49, 'CEST', '8149338000', 7200, '1'),
(49, 'CET', '8167482000', 3600, '0'),
(49, 'CEST', '8180787600', 7200, '1'),
(49, 'CET', '8198931600', 3600, '0'),
(49, 'CEST', '8212237200', 7200, '1'),
(49, 'CET', '8230986000', 3600, '0'),
(49, 'CEST', '8243686800', 7200, '1'),
(49, 'CET', '8262435600', 3600, '0'),
(49, 'CEST', '8275136400', 7200, '1'),
(49, 'CET', '8293885200', 3600, '0'),
(49, 'CEST', '8307190800', 7200, '1'),
(49, 'CET', '8325334800', 3600, '0'),
(49, 'CEST', '8338640400', 7200, '1'),
(49, 'CET', '8356784400', 3600, '0'),
(49, 'CEST', '8370090000', 7200, '1'),
(49, 'CET', '8388234000', 3600, '0'),
(49, 'CEST', '8401539600', 7200, '1'),
(49, 'CET', '8420288400', 3600, '0'),
(49, 'CEST', '8432989200', 7200, '1'),
(49, 'CET', '8451738000', 3600, '0'),
(49, 'CEST', '8464438800', 7200, '1'),
(49, 'CET', '8483187600', 3600, '0'),
(49, 'CEST', '8496493200', 7200, '1'),
(49, 'CET', '8514637200', 3600, '0'),
(49, 'CEST', '8527942800', 7200, '1'),
(49, 'CET', '8546086800', 3600, '0'),
(49, 'CEST', '8559392400', 7200, '1'),
(49, 'CET', '8578141200', 3600, '0'),
(49, 'CEST', '8590842000', 7200, '1'),
(49, 'CET', '8609590800', 3600, '0'),
(49, 'CEST', '8622291600', 7200, '1'),
(49, 'CET', '8641040400', 3600, '0'),
(49, 'CEST', '8654346000', 7200, '1'),
(49, 'CET', '8672490000', 3600, '0'),
(49, 'CEST', '8685795600', 7200, '1'),
(49, 'CET', '8703939600', 3600, '0'),
(49, 'CEST', '8717245200', 7200, '1'),
(49, 'CET', '8735389200', 3600, '0'),
(49, 'CEST', '8748694800', 7200, '1'),
(49, 'CET', '8767443600', 3600, '0'),
(49, 'CEST', '8780144400', 7200, '1'),
(49, 'CET', '8798893200', 3600, '0'),
(49, 'CEST', '8811594000', 7200, '1'),
(49, 'CET', '8830342800', 3600, '0'),
(49, 'CEST', '8843648400', 7200, '1'),
(49, 'CET', '8861792400', 3600, '0'),
(49, 'CEST', '8875098000', 7200, '1'),
(49, 'CET', '8893242000', 3600, '0'),
(49, 'CEST', '8906547600', 7200, '1'),
(49, 'CET', '8925296400', 3600, '0'),
(49, 'CEST', '8937997200', 7200, '1'),
(49, 'CET', '8956746000', 3600, '0'),
(49, 'CEST', '8969446800', 7200, '1'),
(49, 'CET', '8988195600', 3600, '0'),
(49, 'CEST', '9000896400', 7200, '1'),
(49, 'CET', '9019645200', 3600, '0'),
(49, 'CEST', '9032950800', 7200, '1'),
(49, 'CET', '9051094800', 3600, '0'),
(49, 'CEST', '9064400400', 7200, '1'),
(49, 'CET', '9082544400', 3600, '0'),
(49, 'CEST', '9095850000', 7200, '1'),
(49, 'CET', '9114598800', 3600, '0'),
(49, 'CEST', '9127299600', 7200, '1'),
(49, 'CET', '9146048400', 3600, '0'),
(49, 'CEST', '9158749200', 7200, '1'),
(49, 'CET', '9177498000', 3600, '0'),
(49, 'CEST', '9190803600', 7200, '1'),
(49, 'CET', '9208947600', 3600, '0'),
(49, 'CEST', '9222253200', 7200, '1'),
(49, 'CET', '9240397200', 3600, '0'),
(49, 'CEST', '9253702800', 7200, '1'),
(49, 'CET', '9271846800', 3600, '0'),
(49, 'CEST', '9285152400', 7200, '1'),
(49, 'CET', '9303901200', 3600, '0'),
(49, 'CEST', '9316602000', 7200, '1'),
(49, 'CET', '9335350800', 3600, '0'),
(49, 'CEST', '9348051600', 7200, '1'),
(49, 'CET', '9366800400', 3600, '0'),
(49, 'CEST', '9380106000', 7200, '1'),
(49, 'CET', '9398250000', 3600, '0'),
(49, 'CEST', '9411555600', 7200, '1'),
(49, 'CET', '9429699600', 3600, '0'),
(49, 'CEST', '9443005200', 7200, '1'),
(49, 'CET', '9461754000', 3600, '0'),
(49, 'CEST', '9474454800', 7200, '1'),
(49, 'CET', '9493203600', 3600, '0'),
(49, 'CEST', '9505904400', 7200, '1'),
(49, 'CET', '9524653200', 3600, '0'),
(49, 'CEST', '9537958800', 7200, '1'),
(49, 'CET', '9556102800', 3600, '0'),
(49, 'CEST', '9569408400', 7200, '1'),
(49, 'CET', '9587552400', 3600, '0'),
(49, 'CEST', '9600858000', 7200, '1'),
(49, 'CET', '9619002000', 3600, '0'),
(49, 'CEST', '9632307600', 7200, '1'),
(49, 'CET', '9651056400', 3600, '0'),
(49, 'CEST', '9663757200', 7200, '1'),
(49, 'CET', '9682506000', 3600, '0'),
(49, 'CEST', '9695206800', 7200, '1'),
(49, 'CET', '9713955600', 3600, '0'),
(49, 'CEST', '9727261200', 7200, '1'),
(49, 'CET', '9745405200', 3600, '0'),
(49, 'CEST', '9758710800', 7200, '1'),
(49, 'CET', '9776854800', 3600, '0'),
(49, 'CEST', '9790160400', 7200, '1'),
(49, 'CET', '9808909200', 3600, '0'),
(49, 'CEST', '9821610000', 7200, '1'),
(49, 'CET', '9840358800', 3600, '0'),
(49, 'CEST', '9853059600', 7200, '1'),
(49, 'CET', '9871808400', 3600, '0'),
(49, 'CEST', '9884509200', 7200, '1'),
(49, 'CET', '9903258000', 3600, '0'),
(49, 'CEST', '9916563600', 7200, '1'),
(49, 'CET', '9934707600', 3600, '0'),
(49, 'CEST', '9948013200', 7200, '1'),
(49, 'CET', '9966157200', 3600, '0'),
(49, 'CEST', '9979462800', 7200, '1'),
(49, 'CET', '9998211600', 3600, '0'),
(49, 'CEST', '10010912400', 7200, '1'),
(49, 'CET', '10029661200', 3600, '0'),
(49, 'CEST', '10042362000', 7200, '1'),
(49, 'CET', '10061110800', 3600, '0'),
(49, 'CEST', '10074416400', 7200, '1'),
(49, 'CET', '10092560400', 3600, '0'),
(49, 'CEST', '10105866000', 7200, '1'),
(49, 'CET', '10124010000', 3600, '0'),
(49, 'CEST', '10137315600', 7200, '1'),
(49, 'CET', '10155459600', 3600, '0'),
(49, 'CEST', '10168765200', 7200, '1'),
(49, 'CET', '10187514000', 3600, '0'),
(49, 'CEST', '10200214800', 7200, '1'),
(49, 'CET', '10218963600', 3600, '0'),
(49, 'CEST', '10231664400', 7200, '1'),
(49, 'CET', '10250413200', 3600, '0'),
(49, 'CEST', '10263718800', 7200, '1'),
(49, 'CET', '10281862800', 3600, '0'),
(49, 'CEST', '10295168400', 7200, '1'),
(49, 'CET', '10313312400', 3600, '0'),
(49, 'CEST', '10326618000', 7200, '1'),
(49, 'CET', '10345366800', 3600, '0'),
(49, 'CEST', '10358067600', 7200, '1'),
(49, 'CET', '10376816400', 3600, '0'),
(49, 'CEST', '10389517200', 7200, '1'),
(49, 'CET', '10408266000', 3600, '0'),
(49, 'CEST', '10420966800', 7200, '1'),
(49, 'CET', '10439715600', 3600, '0'),
(49, 'CEST', '10453021200', 7200, '1'),
(49, 'CET', '10471165200', 3600, '0'),
(49, 'CEST', '10484470800', 7200, '1'),
(49, 'CET', '10502614800', 3600, '0'),
(49, 'CEST', '10515920400', 7200, '1'),
(49, 'CET', '10534064400', 3600, '0'),
(49, 'CEST', '10547370000', 7200, '1'),
(49, 'CET', '10566118800', 3600, '0'),
(49, 'CEST', '10578819600', 7200, '1'),
(49, 'CET', '10597568400', 3600, '0'),
(49, 'CEST', '10610269200', 7200, '1'),
(49, 'CET', '10629018000', 3600, '0'),
(49, 'CEST', '10642323600', 7200, '1'),
(49, 'CET', '10660467600', 3600, '0'),
(49, 'CEST', '10673773200', 7200, '1'),
(49, 'CET', '10691917200', 3600, '0'),
(49, 'CEST', '10705222800', 7200, '1'),
(49, 'CET', '10723971600', 3600, '0'),
(49, 'CEST', '10736672400', 7200, '1'),
(49, 'CET', '10755421200', 3600, '0'),
(49, 'CEST', '10768122000', 7200, '1'),
(49, 'CET', '10786870800', 3600, '0'),
(49, 'CEST', '10800176400', 7200, '1'),
(49, 'CET', '10818320400', 3600, '0'),
(49, 'CEST', '10831626000', 7200, '1'),
(49, 'CET', '10849770000', 3600, '0'),
(49, 'CEST', '10863075600', 7200, '1'),
(49, 'CET', '10881219600', 3600, '0'),
(49, 'CEST', '10894525200', 7200, '1'),
(49, 'CET', '10913274000', 3600, '0'),
(49, 'CEST', '10925974800', 7200, '1'),
(49, 'CET', '10944723600', 3600, '0'),
(49, 'CEST', '10957424400', 7200, '1'),
(49, 'CET', '10976173200', 3600, '0'),
(49, 'CEST', '10989478800', 7200, '1'),
(49, 'CET', '11007622800', 3600, '0'),
(49, 'CEST', '11020928400', 7200, '1'),
(49, 'CET', '11039072400', 3600, '0'),
(49, 'CEST', '11052378000', 7200, '1'),
(49, 'CET', '11071126800', 3600, '0'),
(49, 'CEST', '11083827600', 7200, '1'),
(49, 'CET', '11102576400', 3600, '0'),
(49, 'CEST', '11115277200', 7200, '1'),
(49, 'CET', '11134026000', 3600, '0'),
(49, 'CEST', '11146726800', 7200, '1'),
(49, 'CET', '11165475600', 3600, '0'),
(49, 'CEST', '11178781200', 7200, '1'),
(49, 'CET', '11196925200', 3600, '0'),
(49, 'CEST', '11210230800', 7200, '1'),
(49, 'CET', '11228374800', 3600, '0'),
(49, 'CEST', '11241680400', 7200, '1'),
(49, 'CET', '11260429200', 3600, '0'),
(49, 'CEST', '11273130000', 7200, '1'),
(49, 'CET', '11291878800', 3600, '0'),
(49, 'CEST', '11304579600', 7200, '1'),
(49, 'CET', '11323328400', 3600, '0'),
(49, 'CEST', '11336634000', 7200, '1'),
(49, 'CET', '11354778000', 3600, '0'),
(49, 'CEST', '11368083600', 7200, '1'),
(49, 'CET', '11386227600', 3600, '0'),
(49, 'CEST', '11399533200', 7200, '1'),
(49, 'CET', '11417677200', 3600, '0'),
(49, 'CEST', '11430982800', 7200, '1'),
(49, 'CET', '11449731600', 3600, '0'),
(49, 'CEST', '11462432400', 7200, '1'),
(49, 'CET', '11481181200', 3600, '0'),
(49, 'CEST', '11493882000', 7200, '1'),
(49, 'CET', '11512630800', 3600, '0'),
(49, 'CEST', '11525936400', 7200, '1'),
(49, 'CET', '11544080400', 3600, '0'),
(49, 'CEST', '11557386000', 7200, '1'),
(49, 'CET', '11575530000', 3600, '0'),
(49, 'CEST', '11588835600', 7200, '1'),
(49, 'CET', '11607584400', 3600, '0'),
(49, 'CEST', '11620285200', 7200, '1'),
(49, 'CET', '11639034000', 3600, '0'),
(49, 'CEST', '11651734800', 7200, '1'),
(49, 'CET', '11670483600', 3600, '0'),
(49, 'CEST', '11683789200', 7200, '1'),
(49, 'CET', '11701933200', 3600, '0'),
(49, 'CEST', '11715238800', 7200, '1'),
(49, 'CET', '11733382800', 3600, '0'),
(49, 'CEST', '11746688400', 7200, '1'),
(49, 'CET', '11764832400', 3600, '0'),
(49, 'CEST', '11778138000', 7200, '1'),
(49, 'CET', '11796886800', 3600, '0'),
(49, 'CEST', '11809587600', 7200, '1'),
(49, 'CET', '11828336400', 3600, '0'),
(49, 'CEST', '11841037200', 7200, '1'),
(49, 'CET', '11859786000', 3600, '0'),
(49, 'CEST', '11873091600', 7200, '1'),
(49, 'CET', '11891235600', 3600, '0'),
(49, 'CEST', '11904541200', 7200, '1'),
(49, 'CET', '11922685200', 3600, '0'),
(49, 'CEST', '11935990800', 7200, '1'),
(49, 'CET', '11954739600', 3600, '0'),
(49, 'CEST', '11967440400', 7200, '1'),
(49, 'CET', '11986189200', 3600, '0'),
(49, 'CEST', '11998890000', 7200, '1'),
(49, 'CET', '12017638800', 3600, '0'),
(49, 'CEST', '12030339600', 7200, '1'),
(49, 'CET', '12049088400', 3600, '0'),
(49, 'CEST', '12062394000', 7200, '1'),
(49, 'CET', '12080538000', 3600, '0'),
(49, 'CEST', '12093843600', 7200, '1'),
(49, 'CET', '12111987600', 3600, '0'),
(49, 'CEST', '12125293200', 7200, '1'),
(49, 'CET', '12144042000', 3600, '0'),
(49, 'CEST', '12156742800', 7200, '1'),
(49, 'CET', '12175491600', 3600, '0'),
(49, 'CEST', '12188192400', 7200, '1'),
(49, 'CET', '12206941200', 3600, '0'),
(49, 'CEST', '12220246800', 7200, '1'),
(49, 'CET', '12238390800', 3600, '0'),
(49, 'CEST', '12251696400', 7200, '1'),
(49, 'CET', '12269840400', 3600, '0'),
(49, 'CEST', '12283146000', 7200, '1'),
(49, 'CET', '12301290000', 3600, '0'),
(49, 'CEST', '12314595600', 7200, '1'),
(49, 'CET', '12333344400', 3600, '0'),
(49, 'CEST', '12346045200', 7200, '1'),
(49, 'CET', '12364794000', 3600, '0'),
(49, 'CEST', '12377494800', 7200, '1'),
(49, 'CET', '12396243600', 3600, '0'),
(49, 'CEST', '12409549200', 7200, '1'),
(49, 'CET', '12427693200', 3600, '0'),
(49, 'CEST', '12440998800', 7200, '1'),
(49, 'CET', '12459142800', 3600, '0'),
(49, 'CEST', '12472448400', 7200, '1'),
(49, 'CET', '12491197200', 3600, '0'),
(49, 'CEST', '12503898000', 7200, '1'),
(49, 'CET', '12522646800', 3600, '0'),
(49, 'CEST', '12535347600', 7200, '1'),
(49, 'CET', '12554096400', 3600, '0'),
(49, 'CEST', '12567402000', 7200, '1'),
(49, 'CET', '12585546000', 3600, '0'),
(49, 'CEST', '12598851600', 7200, '1'),
(49, 'CET', '12616995600', 3600, '0'),
(49, 'CEST', '12630301200', 7200, '1'),
(49, 'CET', '12648445200', 3600, '0'),
(49, 'CEST', '12661750800', 7200, '1'),
(49, 'CET', '12680499600', 3600, '0'),
(49, 'CEST', '12693200400', 7200, '1'),
(49, 'CET', '12711949200', 3600, '0'),
(49, 'CEST', '12724650000', 7200, '1'),
(49, 'CET', '12743398800', 3600, '0'),
(49, 'CEST', '12756704400', 7200, '1'),
(49, 'CET', '12774848400', 3600, '0'),
(49, 'CEST', '12788154000', 7200, '1'),
(49, 'CET', '12806298000', 3600, '0'),
(49, 'CEST', '12819603600', 7200, '1'),
(49, 'CET', '12838352400', 3600, '0'),
(49, 'CEST', '12851053200', 7200, '1'),
(49, 'CET', '12869802000', 3600, '0'),
(49, 'CEST', '12882502800', 7200, '1'),
(49, 'CET', '12901251600', 3600, '0'),
(49, 'CEST', '12913952400', 7200, '1'),
(49, 'CET', '12932701200', 3600, '0'),
(49, 'CEST', '12946006800', 7200, '1'),
(49, 'CET', '12964150800', 3600, '0'),
(49, 'CEST', '12977456400', 7200, '1'),
(49, 'CET', '12995600400', 3600, '0'),
(49, 'CEST', '13008906000', 7200, '1'),
(49, 'CET', '13027654800', 3600, '0'),
(49, 'CEST', '13040355600', 7200, '1'),
(49, 'CET', '13059104400', 3600, '0'),
(49, 'CEST', '13071805200', 7200, '1'),
(49, 'CET', '13090554000', 3600, '0'),
(49, 'CEST', '13103859600', 7200, '1'),
(49, 'CET', '13122003600', 3600, '0'),
(49, 'CEST', '13135309200', 7200, '1'),
(49, 'CET', '13153453200', 3600, '0'),
(49, 'CEST', '13166758800', 7200, '1'),
(49, 'CET', '13184902800', 3600, '0'),
(49, 'CEST', '13198208400', 7200, '1'),
(49, 'CET', '13216957200', 3600, '0'),
(49, 'CEST', '13229658000', 7200, '1'),
(49, 'CET', '13248406800', 3600, '0'),
(49, 'CEST', '13261107600', 7200, '1'),
(49, 'CET', '13279856400', 3600, '0'),
(49, 'CEST', '13293162000', 7200, '1'),
(49, 'CET', '13311306000', 3600, '0'),
(49, 'CEST', '13324611600', 7200, '1'),
(49, 'CET', '13342755600', 3600, '0'),
(49, 'CEST', '13356061200', 7200, '1'),
(49, 'CET', '13374810000', 3600, '0'),
(49, 'CEST', '13387510800', 7200, '1'),
(49, 'CET', '13406259600', 3600, '0'),
(49, 'CEST', '13418960400', 7200, '1'),
(49, 'CET', '13437709200', 3600, '0'),
(49, 'CEST', '13451014800', 7200, '1'),
(49, 'CET', '13469158800', 3600, '0'),
(49, 'CEST', '13482464400', 7200, '1'),
(49, 'CET', '13500608400', 3600, '0'),
(49, 'CEST', '13513914000', 7200, '1'),
(49, 'CET', '13532058000', 3600, '0'),
(49, 'CEST', '13545363600', 7200, '1'),
(49, 'CET', '13564112400', 3600, '0'),
(49, 'CEST', '13576813200', 7200, '1'),
(49, 'CET', '13595562000', 3600, '0'),
(49, 'CEST', '13608262800', 7200, '1'),
(49, 'CET', '13627011600', 3600, '0'),
(49, 'CEST', '13640317200', 7200, '1'),
(49, 'CET', '13658461200', 3600, '0'),
(49, 'CEST', '13671766800', 7200, '1'),
(49, 'CET', '13689910800', 3600, '0'),
(49, 'CEST', '13703216400', 7200, '1'),
(49, 'CET', '13721965200', 3600, '0'),
(49, 'CEST', '13734666000', 7200, '1'),
(49, 'CET', '13753414800', 3600, '0'),
(49, 'CEST', '13766115600', 7200, '1'),
(49, 'CET', '13784864400', 3600, '0'),
(49, 'CEST', '13797565200', 7200, '1'),
(49, 'CET', '13816314000', 3600, '0'),
(49, 'CEST', '13829619600', 7200, '1'),
(49, 'CET', '13847763600', 3600, '0'),
(49, 'CEST', '13861069200', 7200, '1'),
(49, 'CET', '13879213200', 3600, '0'),
(49, 'CEST', '13892518800', 7200, '1'),
(49, 'CET', '13911267600', 3600, '0'),
(49, 'CEST', '13923968400', 7200, '1'),
(49, 'CET', '13942717200', 3600, '0'),
(49, 'CEST', '13955418000', 7200, '1'),
(49, 'CET', '13974166800', 3600, '0'),
(49, 'CEST', '13987472400', 7200, '1'),
(49, 'CET', '14005616400', 3600, '0'),
(49, 'CEST', '14018922000', 7200, '1'),
(49, 'CET', '14037066000', 3600, '0'),
(49, 'CEST', '14050371600', 7200, '1'),
(49, 'CET', '14068515600', 3600, '0'),
(49, 'CEST', '14081821200', 7200, '1'),
(49, 'CET', '14100570000', 3600, '0'),
(49, 'CEST', '14113270800', 7200, '1'),
(49, 'CET', '14132019600', 3600, '0'),
(49, 'CEST', '14144720400', 7200, '1'),
(49, 'CET', '14163469200', 3600, '0'),
(49, 'CEST', '14176774800', 7200, '1'),
(49, 'CET', '14194918800', 3600, '0'),
(49, 'CEST', '14208224400', 7200, '1'),
(49, 'CET', '14226368400', 3600, '0'),
(49, 'CEST', '14239674000', 7200, '1'),
(49, 'CET', '14258422800', 3600, '0'),
(49, 'CEST', '14271123600', 7200, '1'),
(49, 'CET', '14289872400', 3600, '0'),
(49, 'CEST', '14302573200', 7200, '1'),
(49, 'CET', '14321322000', 3600, '0'),
(49, 'CEST', '14334627600', 7200, '1'),
(49, 'CET', '14352771600', 3600, '0'),
(49, 'CEST', '14366077200', 7200, '1'),
(49, 'CET', '14384221200', 3600, '0'),
(49, 'CEST', '14397526800', 7200, '1'),
(49, 'CET', '14415670800', 3600, '0'),
(49, 'CEST', '14428976400', 7200, '1'),
(49, 'CET', '14447725200', 3600, '0'),
(49, 'CEST', '14460426000', 7200, '1'),
(49, 'CET', '14479174800', 3600, '0'),
(49, 'CEST', '14491875600', 7200, '1'),
(49, 'CET', '14510624400', 3600, '0'),
(49, 'CEST', '14523930000', 7200, '1'),
(49, 'CET', '14542074000', 3600, '0'),
(49, 'CEST', '14555379600', 7200, '1'),
(49, 'CET', '14573523600', 3600, '0'),
(49, 'CEST', '14586829200', 7200, '1'),
(49, 'CET', '14605578000', 3600, '0'),
(49, 'CEST', '14618278800', 7200, '1'),
(49, 'CET', '14637027600', 3600, '0'),
(49, 'CEST', '14649728400', 7200, '1'),
(49, 'CET', '14668477200', 3600, '0'),
(49, 'CEST', '14681178000', 7200, '1'),
(49, 'CET', '14699926800', 3600, '0'),
(49, 'CEST', '14713232400', 7200, '1'),
(49, 'CET', '14731376400', 3600, '0'),
(49, 'CEST', '14744682000', 7200, '1'),
(49, 'CET', '14762826000', 3600, '0'),
(49, 'CEST', '14776131600', 7200, '1'),
(49, 'CET', '14794880400', 3600, '0'),
(49, 'CEST', '14807581200', 7200, '1'),
(49, 'CET', '14826330000', 3600, '0'),
(49, 'CEST', '14839030800', 7200, '1'),
(49, 'CET', '14857779600', 3600, '0'),
(49, 'CEST', '14871085200', 7200, '1'),
(49, 'CET', '14889229200', 3600, '0'),
(49, 'CEST', '14902534800', 7200, '1'),
(49, 'CET', '14920678800', 3600, '0'),
(49, 'CEST', '14933984400', 7200, '1'),
(49, 'CET', '14952128400', 3600, '0'),
(49, 'CEST', '14965434000', 7200, '1'),
(49, 'CET', '14984182800', 3600, '0'),
(49, 'CEST', '14996883600', 7200, '1'),
(49, 'CET', '15015632400', 3600, '0'),
(49, 'CEST', '15028333200', 7200, '1'),
(49, 'CET', '15047082000', 3600, '0'),
(49, 'CEST', '15060387600', 7200, '1'),
(49, 'CET', '15078531600', 3600, '0'),
(49, 'CEST', '15091837200', 7200, '1'),
(49, 'CET', '15109981200', 3600, '0'),
(49, 'CEST', '15123286800', 7200, '1'),
(49, 'CET', '15142035600', 3600, '0'),
(49, 'CEST', '15154736400', 7200, '1'),
(49, 'CET', '15173485200', 3600, '0'),
(49, 'CEST', '15186186000', 7200, '1'),
(49, 'CET', '15204934800', 3600, '0'),
(49, 'CEST', '15218240400', 7200, '1'),
(49, 'CET', '15236384400', 3600, '0'),
(49, 'CEST', '15249690000', 7200, '1'),
(49, 'CET', '15267834000', 3600, '0'),
(49, 'CEST', '15281139600', 7200, '1'),
(49, 'CET', '15299283600', 3600, '0'),
(49, 'CEST', '15312589200', 7200, '1'),
(49, 'CET', '15331338000', 3600, '0'),
(49, 'CEST', '15344038800', 7200, '1'),
(49, 'CET', '15362787600', 3600, '0'),
(49, 'CEST', '15375488400', 7200, '1'),
(49, 'CET', '15394237200', 3600, '0'),
(49, 'CEST', '15407542800', 7200, '1'),
(49, 'CET', '15425686800', 3600, '0'),
(49, 'CEST', '15438992400', 7200, '1'),
(49, 'CET', '15457136400', 3600, '0'),
(49, 'CEST', '15470442000', 7200, '1'),
(49, 'CET', '15489190800', 3600, '0'),
(49, 'CEST', '15501891600', 7200, '1'),
(49, 'CET', '15520640400', 3600, '0'),
(49, 'CEST', '15533341200', 7200, '1'),
(49, 'CET', '15552090000', 3600, '0'),
(49, 'CEST', '15564790800', 7200, '1'),
(49, 'CET', '15583539600', 3600, '0'),
(49, 'CEST', '15596845200', 7200, '1'),
(49, 'CET', '15614989200', 3600, '0'),
(49, 'CEST', '15628294800', 7200, '1'),
(49, 'CET', '15646438800', 3600, '0'),
(49, 'CEST', '15659744400', 7200, '1'),
(49, 'CET', '15678493200', 3600, '0'),
(49, 'CEST', '15691194000', 7200, '1'),
(49, 'CET', '15709942800', 3600, '0'),
(49, 'CEST', '15722643600', 7200, '1'),
(49, 'CET', '15741392400', 3600, '0'),
(49, 'CEST', '15754698000', 7200, '1'),
(49, 'CET', '15772842000', 3600, '0'),
(49, 'CEST', '15786147600', 7200, '1'),
(49, 'CET', '15804291600', 3600, '0'),
(49, 'CEST', '15817597200', 7200, '1'),
(49, 'CET', '15835741200', 3600, '0'),
(49, 'CEST', '15849046800', 7200, '1'),
(49, 'CET', '15867795600', 3600, '0'),
(49, 'CEST', '15880496400', 7200, '1'),
(49, 'CET', '15899245200', 3600, '0'),
(49, 'CEST', '15911946000', 7200, '1'),
(49, 'CET', '15930694800', 3600, '0'),
(49, 'CEST', '15944000400', 7200, '1'),
(49, 'CET', '15962144400', 3600, '0'),
(49, 'CEST', '15975450000', 7200, '1'),
(49, 'CET', '15993594000', 3600, '0'),
(49, 'CEST', '16006899600', 7200, '1'),
(49, 'CET', '16025648400', 3600, '0'),
(49, 'CEST', '16038349200', 7200, '1'),
(49, 'CET', '16057098000', 3600, '0'),
(49, 'CEST', '16069798800', 7200, '1'),
(49, 'CET', '16088547600', 3600, '0'),
(49, 'CEST', '16101853200', 7200, '1'),
(49, 'CET', '16119997200', 3600, '0'),
(49, 'CEST', '16133302800', 7200, '1'),
(49, 'CET', '16151446800', 3600, '0'),
(49, 'CEST', '16164752400', 7200, '1'),
(49, 'CET', '16182896400', 3600, '0'),
(49, 'CEST', '16196202000', 7200, '1'),
(49, 'CET', '16214950800', 3600, '0'),
(49, 'CEST', '16227651600', 7200, '1'),
(49, 'CET', '16246400400', 3600, '0'),
(49, 'CEST', '16259101200', 7200, '1'),
(49, 'CET', '16277850000', 3600, '0'),
(49, 'CEST', '16291155600', 7200, '1'),
(49, 'CET', '16309299600', 3600, '0'),
(49, 'CEST', '16322605200', 7200, '1'),
(49, 'CET', '16340749200', 3600, '0'),
(49, 'CEST', '16354054800', 7200, '1'),
(49, 'CET', '16372803600', 3600, '0'),
(49, 'CEST', '16385504400', 7200, '1'),
(49, 'CET', '16404253200', 3600, '0'),
(49, 'CEST', '16416954000', 7200, '1'),
(49, 'CET', '16435702800', 3600, '0'),
(49, 'CEST', '16448403600', 7200, '1'),
(49, 'CET', '16467152400', 3600, '0'),
(49, 'CEST', '16480458000', 7200, '1'),
(49, 'CET', '16498602000', 3600, '0'),
(49, 'CEST', '16511907600', 7200, '1'),
(49, 'CET', '16530051600', 3600, '0'),
(49, 'CEST', '16543357200', 7200, '1'),
(49, 'CET', '16562106000', 3600, '0'),
(49, 'CEST', '16574806800', 7200, '1'),
(49, 'CET', '16593555600', 3600, '0'),
(49, 'CEST', '16606256400', 7200, '1'),
(49, 'CET', '16625005200', 3600, '0'),
(49, 'CEST', '16638310800', 7200, '1'),
(49, 'CET', '16656454800', 3600, '0'),
(49, 'CEST', '16669760400', 7200, '1'),
(49, 'CET', '16687904400', 3600, '0'),
(49, 'CEST', '16701210000', 7200, '1'),
(49, 'CET', '16719354000', 3600, '0'),
(50, 'LMT', '-1451678492', -14309, '0'),
(50, 'BMT', '-1451678491', -14309, '0'),
(50, 'AST', '-1199217691', -14400, '0'),
(50, 'ADT', '234943200', -10800, '1'),
(50, 'AST', '244616400', -14400, '0'),
(50, 'ADT', '261554400', -10800, '1'),
(50, 'AST', '276066000', -14400, '0'),
(50, 'ADT', '293004000', -10800, '1'),
(50, 'AST', '307515600', -14400, '0'),
(50, 'ADT', '325058400', -10800, '1'),
(50, 'AST', '338706000', -14400, '0'),
(51, 'LMT', '-2524543301', 21700, '0'),
(51, 'HMT', '-2524543300', 21200, '0'),
(51, '+0630', '-891582800', 23400, '0'),
(51, '+0530', '-872058600', 19800, '0'),
(51, '+0630', '-862637400', 23400, '0'),
(51, '+06', '-576138600', 21600, '0'),
(51, '+07', '1245430800', 25200, '1'),
(51, '+06', '1262278800', 21600, '0'),
(52, 'LMT', '-2840141851', 1050, '0'),
(52, 'BMT', '-2840141850', 1050, '0'),
(52, 'WET', '-2450953050', 0, '0'),
(52, 'CET', '-1740355200', 3600, '0'),
(52, 'CEST', '-1693702800', 7200, '1'),
(52, 'CET', '-1680483600', 3600, '0'),
(52, 'CEST', '-1663455600', 7200, '1'),
(52, 'CET', '-1650150000', 3600, '0'),
(52, 'CEST', '-1632006000', 7200, '1'),
(52, 'CET', '-1618700400', 3600, '0'),
(52, 'WET', '-1613826000', 0, '0'),
(52, 'WEST', '-1604278800', 3600, '1'),
(52, 'WET', '-1585530000', 0, '0'),
(52, 'WEST', '-1574038800', 3600, '1'),
(52, 'WET', '-1552266000', 0, '0'),
(52, 'WEST', '-1539997200', 3600, '1'),
(52, 'WET', '-1520557200', 0, '0'),
(52, 'WEST', '-1507510800', 3600, '1'),
(52, 'WET', '-1490576400', 0, '0'),
(52, 'WEST', '-1473642000', 3600, '1'),
(52, 'WET', '-1459126800', 0, '0'),
(52, 'WEST', '-1444006800', 3600, '1'),
(52, 'WET', '-1427677200', 0, '0'),
(52, 'WEST', '-1411952400', 3600, '1'),
(52, 'WET', '-1396227600', 0, '0'),
(52, 'WEST', '-1379293200', 3600, '1'),
(52, 'WET', '-1364778000', 0, '0'),
(52, 'WEST', '-1348448400', 3600, '1'),
(52, 'WET', '-1333328400', 0, '0'),
(52, 'WEST', '-1316394000', 3600, '1'),
(52, 'WET', '-1301263200', 0, '0'),
(52, 'WEST', '-1284328800', 3600, '1'),
(52, 'WET', '-1269813600', 0, '0'),
(52, 'WEST', '-1253484000', 3600, '1'),
(52, 'WET', '-1238364000', 0, '0'),
(52, 'WEST', '-1221429600', 3600, '1'),
(52, 'WET', '-1206914400', 0, '0'),
(52, 'WEST', '-1191189600', 3600, '1'),
(52, 'WET', '-1175464800', 0, '0'),
(52, 'WEST', '-1160344800', 3600, '1'),
(52, 'WET', '-1143410400', 0, '0'),
(52, 'WEST', '-1127685600', 3600, '1'),
(52, 'WET', '-1111960800', 0, '0'),
(52, 'WEST', '-1096840800', 3600, '1'),
(52, 'WET', '-1080511200', 0, '0'),
(52, 'WEST', '-1063576800', 3600, '1'),
(52, 'WET', '-1049061600', 0, '0'),
(52, 'WEST', '-1033336800', 3600, '1'),
(52, 'WET', '-1017612000', 0, '0'),
(52, 'WEST', '-1002492000', 3600, '1'),
(52, 'WET', '-986162400', 0, '0'),
(52, 'WEST', '-969228000', 3600, '1'),
(52, 'WET', '-950479200', 0, '0'),
(52, 'WEST', '-942012000', 3600, '1'),
(52, 'CEST', '-934668000', 7200, '1'),
(52, 'CET', '-857257200', 3600, '0'),
(52, 'CEST', '-844556400', 7200, '1'),
(52, 'CET', '-828226800', 3600, '0'),
(52, 'CEST', '-812502000', 7200, '1'),
(52, 'CET', '-798073200', 3600, '0'),
(52, 'CEST', '-781052400', 7200, '1'),
(52, 'CET', '-766623600', 3600, '0'),
(52, 'CEST', '-745455600', 7200, '1'),
(52, 'CET', '-733273200', 3600, '0'),
(52, 'CEST', '228877200', 7200, '1'),
(52, 'CET', '243997200', 3600, '0'),
(52, 'CEST', '260326800', 7200, '1'),
(52, 'CET', '276051600', 3600, '0'),
(52, 'CEST', '291776400', 7200, '1'),
(52, 'CET', '307501200', 3600, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(52, 'CEST', '323830800', 7200, '1'),
(52, 'CET', '338950800', 3600, '0'),
(52, 'CEST', '354675600', 7200, '1'),
(52, 'CET', '370400400', 3600, '0'),
(52, 'CEST', '386125200', 7200, '1'),
(52, 'CET', '401850000', 3600, '0'),
(52, 'CEST', '417574800', 7200, '1'),
(52, 'CET', '433299600', 3600, '0'),
(52, 'CEST', '449024400', 7200, '1'),
(52, 'CET', '465354000', 3600, '0'),
(52, 'CEST', '481078800', 7200, '1'),
(52, 'CET', '496803600', 3600, '0'),
(52, 'CEST', '512528400', 7200, '1'),
(52, 'CET', '528253200', 3600, '0'),
(52, 'CEST', '543978000', 7200, '1'),
(52, 'CET', '559702800', 3600, '0'),
(52, 'CEST', '575427600', 7200, '1'),
(52, 'CET', '591152400', 3600, '0'),
(52, 'CEST', '606877200', 7200, '1'),
(52, 'CET', '622602000', 3600, '0'),
(52, 'CEST', '638326800', 7200, '1'),
(52, 'CET', '654656400', 3600, '0'),
(52, 'CEST', '670381200', 7200, '1'),
(52, 'CET', '686106000', 3600, '0'),
(52, 'CEST', '701830800', 7200, '1'),
(52, 'CET', '717555600', 3600, '0'),
(52, 'CEST', '733280400', 7200, '1'),
(52, 'CET', '749005200', 3600, '0'),
(52, 'CEST', '764730000', 7200, '1'),
(52, 'CET', '780454800', 3600, '0'),
(52, 'CEST', '796179600', 7200, '1'),
(52, 'CET', '811904400', 3600, '0'),
(52, 'CEST', '828234000', 7200, '1'),
(52, 'CET', '846378000', 3600, '0'),
(52, 'CEST', '859683600', 7200, '1'),
(52, 'CET', '877827600', 3600, '0'),
(52, 'CEST', '891133200', 7200, '1'),
(52, 'CET', '909277200', 3600, '0'),
(52, 'CEST', '922582800', 7200, '1'),
(52, 'CET', '941331600', 3600, '0'),
(52, 'CEST', '954032400', 7200, '1'),
(52, 'CET', '972781200', 3600, '0'),
(52, 'CEST', '985482000', 7200, '1'),
(52, 'CET', '1004230800', 3600, '0'),
(52, 'CEST', '1017536400', 7200, '1'),
(52, 'CET', '1035680400', 3600, '0'),
(52, 'CEST', '1048986000', 7200, '1'),
(52, 'CET', '1067130000', 3600, '0'),
(52, 'CEST', '1080435600', 7200, '1'),
(52, 'CET', '1099184400', 3600, '0'),
(52, 'CEST', '1111885200', 7200, '1'),
(52, 'CET', '1130634000', 3600, '0'),
(52, 'CEST', '1143334800', 7200, '1'),
(52, 'CET', '1162083600', 3600, '0'),
(52, 'CEST', '1174784400', 7200, '1'),
(52, 'CET', '1193533200', 3600, '0'),
(52, 'CEST', '1206838800', 7200, '1'),
(52, 'CET', '1224982800', 3600, '0'),
(52, 'CEST', '1238288400', 7200, '1'),
(52, 'CET', '1256432400', 3600, '0'),
(52, 'CEST', '1269738000', 7200, '1'),
(52, 'CET', '1288486800', 3600, '0'),
(52, 'CEST', '1301187600', 7200, '1'),
(52, 'CET', '1319936400', 3600, '0'),
(52, 'CEST', '1332637200', 7200, '1'),
(52, 'CET', '1351386000', 3600, '0'),
(52, 'CEST', '1364691600', 7200, '1'),
(52, 'CET', '1382835600', 3600, '0'),
(52, 'CEST', '1396141200', 7200, '1'),
(52, 'CET', '1414285200', 3600, '0'),
(52, 'CEST', '1427590800', 7200, '1'),
(52, 'CET', '1445734800', 3600, '0'),
(52, 'CEST', '1459040400', 7200, '1'),
(52, 'CET', '1477789200', 3600, '0'),
(52, 'CEST', '1490490000', 7200, '1'),
(52, 'CET', '1509238800', 3600, '0'),
(52, 'CEST', '1521939600', 7200, '1'),
(52, 'CET', '1540688400', 3600, '0'),
(52, 'CEST', '1553994000', 7200, '1'),
(52, 'CET', '1572138000', 3600, '0'),
(52, 'CEST', '1585443600', 7200, '1'),
(52, 'CET', '1603587600', 3600, '0'),
(52, 'CEST', '1616893200', 7200, '1'),
(52, 'CET', '1635642000', 3600, '0'),
(52, 'CEST', '1648342800', 7200, '1'),
(52, 'CET', '1667091600', 3600, '0'),
(52, 'CEST', '1679792400', 7200, '1'),
(52, 'CET', '1698541200', 3600, '0'),
(52, 'CEST', '1711846800', 7200, '1'),
(52, 'CET', '1729990800', 3600, '0'),
(52, 'CEST', '1743296400', 7200, '1'),
(52, 'CET', '1761440400', 3600, '0'),
(52, 'CEST', '1774746000', 7200, '1'),
(52, 'CET', '1792890000', 3600, '0'),
(52, 'CEST', '1806195600', 7200, '1'),
(52, 'CET', '1824944400', 3600, '0'),
(52, 'CEST', '1837645200', 7200, '1'),
(52, 'CET', '1856394000', 3600, '0'),
(52, 'CEST', '1869094800', 7200, '1'),
(52, 'CET', '1887843600', 3600, '0'),
(52, 'CEST', '1901149200', 7200, '1'),
(52, 'CET', '1919293200', 3600, '0'),
(52, 'CEST', '1932598800', 7200, '1'),
(52, 'CET', '1950742800', 3600, '0'),
(52, 'CEST', '1964048400', 7200, '1'),
(52, 'CET', '1982797200', 3600, '0'),
(52, 'CEST', '1995498000', 7200, '1'),
(52, 'CET', '2014246800', 3600, '0'),
(52, 'CEST', '2026947600', 7200, '1'),
(52, 'CET', '2045696400', 3600, '0'),
(52, 'CEST', '2058397200', 7200, '1'),
(52, 'CET', '2077146000', 3600, '0'),
(52, 'CEST', '2090451600', 7200, '1'),
(52, 'CET', '2108595600', 3600, '0'),
(52, 'CEST', '2121901200', 7200, '1'),
(52, 'CET', '2140045200', 3600, '0'),
(52, 'CEST', '2153350800', 7200, '1'),
(52, 'CET', '2172099600', 3600, '0'),
(52, 'CEST', '2184800400', 7200, '1'),
(52, 'CET', '2203549200', 3600, '0'),
(52, 'CEST', '2216250000', 7200, '1'),
(52, 'CET', '2234998800', 3600, '0'),
(52, 'CEST', '2248304400', 7200, '1'),
(52, 'CET', '2266448400', 3600, '0'),
(52, 'CEST', '2279754000', 7200, '1'),
(52, 'CET', '2297898000', 3600, '0'),
(52, 'CEST', '2311203600', 7200, '1'),
(52, 'CET', '2329347600', 3600, '0'),
(52, 'CEST', '2342653200', 7200, '1'),
(52, 'CET', '2361402000', 3600, '0'),
(52, 'CEST', '2374102800', 7200, '1'),
(52, 'CET', '2392851600', 3600, '0'),
(52, 'CEST', '2405552400', 7200, '1'),
(52, 'CET', '2424301200', 3600, '0'),
(52, 'CEST', '2437606800', 7200, '1'),
(52, 'CET', '2455750800', 3600, '0'),
(52, 'CEST', '2469056400', 7200, '1'),
(52, 'CET', '2487200400', 3600, '0'),
(52, 'CEST', '2500506000', 7200, '1'),
(52, 'CET', '2519254800', 3600, '0'),
(52, 'CEST', '2531955600', 7200, '1'),
(52, 'CET', '2550704400', 3600, '0'),
(52, 'CEST', '2563405200', 7200, '1'),
(52, 'CET', '2582154000', 3600, '0'),
(52, 'CEST', '2595459600', 7200, '1'),
(52, 'CET', '2613603600', 3600, '0'),
(52, 'CEST', '2626909200', 7200, '1'),
(52, 'CET', '2645053200', 3600, '0'),
(52, 'CEST', '2658358800', 7200, '1'),
(52, 'CET', '2676502800', 3600, '0'),
(52, 'CEST', '2689808400', 7200, '1'),
(52, 'CET', '2708557200', 3600, '0'),
(52, 'CEST', '2721258000', 7200, '1'),
(52, 'CET', '2740006800', 3600, '0'),
(52, 'CEST', '2752707600', 7200, '1'),
(52, 'CET', '2771456400', 3600, '0'),
(52, 'CEST', '2784762000', 7200, '1'),
(52, 'CET', '2802906000', 3600, '0'),
(52, 'CEST', '2816211600', 7200, '1'),
(52, 'CET', '2834355600', 3600, '0'),
(52, 'CEST', '2847661200', 7200, '1'),
(52, 'CET', '2866410000', 3600, '0'),
(52, 'CEST', '2879110800', 7200, '1'),
(52, 'CET', '2897859600', 3600, '0'),
(52, 'CEST', '2910560400', 7200, '1'),
(52, 'CET', '2929309200', 3600, '0'),
(52, 'CEST', '2942010000', 7200, '1'),
(52, 'CET', '2960758800', 3600, '0'),
(52, 'CEST', '2974064400', 7200, '1'),
(52, 'CET', '2992208400', 3600, '0'),
(52, 'CEST', '3005514000', 7200, '1'),
(52, 'CET', '3023658000', 3600, '0'),
(52, 'CEST', '3036963600', 7200, '1'),
(52, 'CET', '3055712400', 3600, '0'),
(52, 'CEST', '3068413200', 7200, '1'),
(52, 'CET', '3087162000', 3600, '0'),
(52, 'CEST', '3099862800', 7200, '1'),
(52, 'CET', '3118611600', 3600, '0'),
(52, 'CEST', '3131917200', 7200, '1'),
(52, 'CET', '3150061200', 3600, '0'),
(52, 'CEST', '3163366800', 7200, '1'),
(52, 'CET', '3181510800', 3600, '0'),
(52, 'CEST', '3194816400', 7200, '1'),
(52, 'CET', '3212960400', 3600, '0'),
(52, 'CEST', '3226266000', 7200, '1'),
(52, 'CET', '3245014800', 3600, '0'),
(52, 'CEST', '3257715600', 7200, '1'),
(52, 'CET', '3276464400', 3600, '0'),
(52, 'CEST', '3289165200', 7200, '1'),
(52, 'CET', '3307914000', 3600, '0'),
(52, 'CEST', '3321219600', 7200, '1'),
(52, 'CET', '3339363600', 3600, '0'),
(52, 'CEST', '3352669200', 7200, '1'),
(52, 'CET', '3370813200', 3600, '0'),
(52, 'CEST', '3384118800', 7200, '1'),
(52, 'CET', '3402867600', 3600, '0'),
(52, 'CEST', '3415568400', 7200, '1'),
(52, 'CET', '3434317200', 3600, '0'),
(52, 'CEST', '3447018000', 7200, '1'),
(52, 'CET', '3465766800', 3600, '0'),
(52, 'CEST', '3479072400', 7200, '1'),
(52, 'CET', '3497216400', 3600, '0'),
(52, 'CEST', '3510522000', 7200, '1'),
(52, 'CET', '3528666000', 3600, '0'),
(52, 'CEST', '3541971600', 7200, '1'),
(52, 'CET', '3560115600', 3600, '0'),
(52, 'CEST', '3573421200', 7200, '1'),
(52, 'CET', '3592170000', 3600, '0'),
(52, 'CEST', '3604870800', 7200, '1'),
(52, 'CET', '3623619600', 3600, '0'),
(52, 'CEST', '3636320400', 7200, '1'),
(52, 'CET', '3655069200', 3600, '0'),
(52, 'CEST', '3668374800', 7200, '1'),
(52, 'CET', '3686518800', 3600, '0'),
(52, 'CEST', '3699824400', 7200, '1'),
(52, 'CET', '3717968400', 3600, '0'),
(52, 'CEST', '3731274000', 7200, '1'),
(52, 'CET', '3750022800', 3600, '0'),
(52, 'CEST', '3762723600', 7200, '1'),
(52, 'CET', '3781472400', 3600, '0'),
(52, 'CEST', '3794173200', 7200, '1'),
(52, 'CET', '3812922000', 3600, '0'),
(52, 'CEST', '3825622800', 7200, '1'),
(52, 'CET', '3844371600', 3600, '0'),
(52, 'CEST', '3857677200', 7200, '1'),
(52, 'CET', '3875821200', 3600, '0'),
(52, 'CEST', '3889126800', 7200, '1'),
(52, 'CET', '3907270800', 3600, '0'),
(52, 'CEST', '3920576400', 7200, '1'),
(52, 'CET', '3939325200', 3600, '0'),
(52, 'CEST', '3952026000', 7200, '1'),
(52, 'CET', '3970774800', 3600, '0'),
(52, 'CEST', '3983475600', 7200, '1'),
(52, 'CET', '4002224400', 3600, '0'),
(52, 'CEST', '4015530000', 7200, '1'),
(52, 'CET', '4033674000', 3600, '0'),
(52, 'CEST', '4046979600', 7200, '1'),
(52, 'CET', '4065123600', 3600, '0'),
(52, 'CEST', '4078429200', 7200, '1'),
(52, 'CET', '4096573200', 3600, '0'),
(52, 'CEST', '4109878800', 7200, '1'),
(52, 'CET', '4128627600', 3600, '0'),
(52, 'CEST', '4141328400', 7200, '1'),
(52, 'CET', '4160077200', 3600, '0'),
(52, 'CEST', '4172778000', 7200, '1'),
(52, 'CET', '4191526800', 3600, '0'),
(52, 'CEST', '4204227600', 7200, '1'),
(52, 'CET', '4222976400', 3600, '0'),
(52, 'CEST', '4236282000', 7200, '1'),
(52, 'CET', '4254426000', 3600, '0'),
(52, 'CEST', '4267731600', 7200, '1'),
(52, 'CET', '4285875600', 3600, '0'),
(52, 'CEST', '4299181200', 7200, '1'),
(52, 'CET', '4317930000', 3600, '0'),
(52, 'CEST', '4330630800', 7200, '1'),
(52, 'CET', '4349379600', 3600, '0'),
(52, 'CEST', '4362080400', 7200, '1'),
(52, 'CET', '4380829200', 3600, '0'),
(52, 'CEST', '4394134800', 7200, '1'),
(52, 'CET', '4412278800', 3600, '0'),
(52, 'CEST', '4425584400', 7200, '1'),
(52, 'CET', '4443728400', 3600, '0'),
(52, 'CEST', '4457034000', 7200, '1'),
(52, 'CET', '4475178000', 3600, '0'),
(52, 'CEST', '4488483600', 7200, '1'),
(52, 'CET', '4507232400', 3600, '0'),
(52, 'CEST', '4519933200', 7200, '1'),
(52, 'CET', '4538682000', 3600, '0'),
(52, 'CEST', '4551382800', 7200, '1'),
(52, 'CET', '4570131600', 3600, '0'),
(52, 'CEST', '4583437200', 7200, '1'),
(52, 'CET', '4601581200', 3600, '0'),
(52, 'CEST', '4614886800', 7200, '1'),
(52, 'CET', '4633030800', 3600, '0'),
(52, 'CEST', '4646336400', 7200, '1'),
(52, 'CET', '4665085200', 3600, '0'),
(52, 'CEST', '4677786000', 7200, '1'),
(52, 'CET', '4696534800', 3600, '0'),
(52, 'CEST', '4709235600', 7200, '1'),
(52, 'CET', '4727984400', 3600, '0'),
(52, 'CEST', '4741290000', 7200, '1'),
(52, 'CET', '4759434000', 3600, '0'),
(52, 'CEST', '4772739600', 7200, '1'),
(52, 'CET', '4790883600', 3600, '0'),
(52, 'CEST', '4804189200', 7200, '1'),
(52, 'CET', '4822333200', 3600, '0'),
(52, 'CEST', '4835638800', 7200, '1'),
(52, 'CET', '4854387600', 3600, '0'),
(52, 'CEST', '4867088400', 7200, '1'),
(52, 'CET', '4885837200', 3600, '0'),
(52, 'CEST', '4898538000', 7200, '1'),
(52, 'CET', '4917286800', 3600, '0'),
(52, 'CEST', '4930592400', 7200, '1'),
(52, 'CET', '4948736400', 3600, '0'),
(52, 'CEST', '4962042000', 7200, '1'),
(52, 'CET', '4980186000', 3600, '0'),
(52, 'CEST', '4993491600', 7200, '1'),
(52, 'CET', '5012240400', 3600, '0'),
(52, 'CEST', '5024941200', 7200, '1'),
(52, 'CET', '5043690000', 3600, '0'),
(52, 'CEST', '5056390800', 7200, '1'),
(52, 'CET', '5075139600', 3600, '0'),
(52, 'CEST', '5087840400', 7200, '1'),
(52, 'CET', '5106589200', 3600, '0'),
(52, 'CEST', '5119894800', 7200, '1'),
(52, 'CET', '5138038800', 3600, '0'),
(52, 'CEST', '5151344400', 7200, '1'),
(52, 'CET', '5169488400', 3600, '0'),
(52, 'CEST', '5182794000', 7200, '1'),
(52, 'CET', '5201542800', 3600, '0'),
(52, 'CEST', '5214243600', 7200, '1'),
(52, 'CET', '5232992400', 3600, '0'),
(52, 'CEST', '5245693200', 7200, '1'),
(52, 'CET', '5264442000', 3600, '0'),
(52, 'CEST', '5277747600', 7200, '1'),
(52, 'CET', '5295891600', 3600, '0'),
(52, 'CEST', '5309197200', 7200, '1'),
(52, 'CET', '5327341200', 3600, '0'),
(52, 'CEST', '5340646800', 7200, '1'),
(52, 'CET', '5358790800', 3600, '0'),
(52, 'CEST', '5372096400', 7200, '1'),
(52, 'CET', '5390845200', 3600, '0'),
(52, 'CEST', '5403546000', 7200, '1'),
(52, 'CET', '5422294800', 3600, '0'),
(52, 'CEST', '5434995600', 7200, '1'),
(52, 'CET', '5453744400', 3600, '0'),
(52, 'CEST', '5467050000', 7200, '1'),
(52, 'CET', '5485194000', 3600, '0'),
(52, 'CEST', '5498499600', 7200, '1'),
(52, 'CET', '5516643600', 3600, '0'),
(52, 'CEST', '5529949200', 7200, '1'),
(52, 'CET', '5548698000', 3600, '0'),
(52, 'CEST', '5561398800', 7200, '1'),
(52, 'CET', '5580147600', 3600, '0'),
(52, 'CEST', '5592848400', 7200, '1'),
(52, 'CET', '5611597200', 3600, '0'),
(52, 'CEST', '5624902800', 7200, '1'),
(52, 'CET', '5643046800', 3600, '0'),
(52, 'CEST', '5656352400', 7200, '1'),
(52, 'CET', '5674496400', 3600, '0'),
(52, 'CEST', '5687802000', 7200, '1'),
(52, 'CET', '5705946000', 3600, '0'),
(52, 'CEST', '5719251600', 7200, '1'),
(52, 'CET', '5738000400', 3600, '0'),
(52, 'CEST', '5750701200', 7200, '1'),
(52, 'CET', '5769450000', 3600, '0'),
(52, 'CEST', '5782150800', 7200, '1'),
(52, 'CET', '5800899600', 3600, '0'),
(52, 'CEST', '5814205200', 7200, '1'),
(52, 'CET', '5832349200', 3600, '0'),
(52, 'CEST', '5845654800', 7200, '1'),
(52, 'CET', '5863798800', 3600, '0'),
(52, 'CEST', '5877104400', 7200, '1'),
(52, 'CET', '5895853200', 3600, '0'),
(52, 'CEST', '5908554000', 7200, '1'),
(52, 'CET', '5927302800', 3600, '0'),
(52, 'CEST', '5940003600', 7200, '1'),
(52, 'CET', '5958752400', 3600, '0'),
(52, 'CEST', '5971453200', 7200, '1'),
(52, 'CET', '5990202000', 3600, '0'),
(52, 'CEST', '6003507600', 7200, '1'),
(52, 'CET', '6021651600', 3600, '0'),
(52, 'CEST', '6034957200', 7200, '1'),
(52, 'CET', '6053101200', 3600, '0'),
(52, 'CEST', '6066406800', 7200, '1'),
(52, 'CET', '6085155600', 3600, '0'),
(52, 'CEST', '6097856400', 7200, '1'),
(52, 'CET', '6116605200', 3600, '0'),
(52, 'CEST', '6129306000', 7200, '1'),
(52, 'CET', '6148054800', 3600, '0'),
(52, 'CEST', '6161360400', 7200, '1'),
(52, 'CET', '6179504400', 3600, '0'),
(52, 'CEST', '6192810000', 7200, '1'),
(52, 'CET', '6210954000', 3600, '0'),
(52, 'CEST', '6224259600', 7200, '1'),
(52, 'CET', '6242403600', 3600, '0'),
(52, 'CEST', '6255709200', 7200, '1'),
(52, 'CET', '6274458000', 3600, '0'),
(52, 'CEST', '6287158800', 7200, '1'),
(52, 'CET', '6305907600', 3600, '0'),
(52, 'CEST', '6318608400', 7200, '1'),
(52, 'CET', '6337357200', 3600, '0'),
(52, 'CEST', '6350662800', 7200, '1'),
(52, 'CET', '6368806800', 3600, '0'),
(52, 'CEST', '6382112400', 7200, '1'),
(52, 'CET', '6400256400', 3600, '0'),
(52, 'CEST', '6413562000', 7200, '1'),
(52, 'CET', '6432310800', 3600, '0'),
(52, 'CEST', '6445011600', 7200, '1'),
(52, 'CET', '6463760400', 3600, '0'),
(52, 'CEST', '6476461200', 7200, '1'),
(52, 'CET', '6495210000', 3600, '0'),
(52, 'CEST', '6508515600', 7200, '1'),
(52, 'CET', '6526659600', 3600, '0'),
(52, 'CEST', '6539965200', 7200, '1'),
(52, 'CET', '6558109200', 3600, '0'),
(52, 'CEST', '6571414800', 7200, '1'),
(52, 'CET', '6589558800', 3600, '0'),
(52, 'CEST', '6602864400', 7200, '1'),
(52, 'CET', '6621613200', 3600, '0'),
(52, 'CEST', '6634314000', 7200, '1'),
(52, 'CET', '6653062800', 3600, '0'),
(52, 'CEST', '6665763600', 7200, '1'),
(52, 'CET', '6684512400', 3600, '0'),
(52, 'CEST', '6697818000', 7200, '1'),
(52, 'CET', '6715962000', 3600, '0'),
(52, 'CEST', '6729267600', 7200, '1'),
(52, 'CET', '6747411600', 3600, '0'),
(52, 'CEST', '6760717200', 7200, '1'),
(52, 'CET', '6779466000', 3600, '0'),
(52, 'CEST', '6792166800', 7200, '1'),
(52, 'CET', '6810915600', 3600, '0'),
(52, 'CEST', '6823616400', 7200, '1'),
(52, 'CET', '6842365200', 3600, '0'),
(52, 'CEST', '6855066000', 7200, '1'),
(52, 'CET', '6873814800', 3600, '0'),
(52, 'CEST', '6887120400', 7200, '1'),
(52, 'CET', '6905264400', 3600, '0'),
(52, 'CEST', '6918570000', 7200, '1'),
(52, 'CET', '6936714000', 3600, '0'),
(52, 'CEST', '6950019600', 7200, '1'),
(52, 'CET', '6968768400', 3600, '0'),
(52, 'CEST', '6981469200', 7200, '1'),
(52, 'CET', '7000218000', 3600, '0'),
(52, 'CEST', '7012918800', 7200, '1'),
(52, 'CET', '7031667600', 3600, '0'),
(52, 'CEST', '7044973200', 7200, '1'),
(52, 'CET', '7063117200', 3600, '0'),
(52, 'CEST', '7076422800', 7200, '1'),
(52, 'CET', '7094566800', 3600, '0'),
(52, 'CEST', '7107872400', 7200, '1'),
(52, 'CET', '7126016400', 3600, '0'),
(52, 'CEST', '7139322000', 7200, '1'),
(52, 'CET', '7158070800', 3600, '0'),
(52, 'CEST', '7170771600', 7200, '1'),
(52, 'CET', '7189520400', 3600, '0'),
(52, 'CEST', '7202221200', 7200, '1'),
(52, 'CET', '7220970000', 3600, '0'),
(52, 'CEST', '7234275600', 7200, '1'),
(52, 'CET', '7252419600', 3600, '0'),
(52, 'CEST', '7265725200', 7200, '1'),
(52, 'CET', '7283869200', 3600, '0'),
(52, 'CEST', '7297174800', 7200, '1'),
(52, 'CET', '7315318800', 3600, '0'),
(52, 'CEST', '7328624400', 7200, '1'),
(52, 'CET', '7347373200', 3600, '0'),
(52, 'CEST', '7360074000', 7200, '1'),
(52, 'CET', '7378822800', 3600, '0'),
(52, 'CEST', '7391523600', 7200, '1'),
(52, 'CET', '7410272400', 3600, '0'),
(52, 'CEST', '7423578000', 7200, '1'),
(52, 'CET', '7441722000', 3600, '0'),
(52, 'CEST', '7455027600', 7200, '1'),
(52, 'CET', '7473171600', 3600, '0'),
(52, 'CEST', '7486477200', 7200, '1'),
(52, 'CET', '7504621200', 3600, '0'),
(52, 'CEST', '7517926800', 7200, '1'),
(52, 'CET', '7536675600', 3600, '0'),
(52, 'CEST', '7549376400', 7200, '1'),
(52, 'CET', '7568125200', 3600, '0'),
(52, 'CEST', '7580826000', 7200, '1'),
(52, 'CET', '7599574800', 3600, '0'),
(52, 'CEST', '7612880400', 7200, '1'),
(52, 'CET', '7631024400', 3600, '0'),
(52, 'CEST', '7644330000', 7200, '1'),
(52, 'CET', '7662474000', 3600, '0'),
(52, 'CEST', '7675779600', 7200, '1'),
(52, 'CET', '7694528400', 3600, '0'),
(52, 'CEST', '7707229200', 7200, '1'),
(52, 'CET', '7725978000', 3600, '0'),
(52, 'CEST', '7738678800', 7200, '1'),
(52, 'CET', '7757427600', 3600, '0'),
(52, 'CEST', '7770733200', 7200, '1'),
(52, 'CET', '7788877200', 3600, '0'),
(52, 'CEST', '7802182800', 7200, '1'),
(52, 'CET', '7820326800', 3600, '0'),
(52, 'CEST', '7833632400', 7200, '1'),
(52, 'CET', '7851776400', 3600, '0'),
(52, 'CEST', '7865082000', 7200, '1'),
(52, 'CET', '7883830800', 3600, '0'),
(52, 'CEST', '7896531600', 7200, '1'),
(52, 'CET', '7915280400', 3600, '0'),
(52, 'CEST', '7927981200', 7200, '1'),
(52, 'CET', '7946730000', 3600, '0'),
(52, 'CEST', '7960035600', 7200, '1'),
(52, 'CET', '7978179600', 3600, '0'),
(52, 'CEST', '7991485200', 7200, '1'),
(52, 'CET', '8009629200', 3600, '0'),
(52, 'CEST', '8022934800', 7200, '1'),
(52, 'CET', '8041683600', 3600, '0'),
(52, 'CEST', '8054384400', 7200, '1'),
(52, 'CET', '8073133200', 3600, '0'),
(52, 'CEST', '8085834000', 7200, '1'),
(52, 'CET', '8104582800', 3600, '0'),
(52, 'CEST', '8117283600', 7200, '1'),
(52, 'CET', '8136032400', 3600, '0'),
(52, 'CEST', '8149338000', 7200, '1'),
(52, 'CET', '8167482000', 3600, '0'),
(52, 'CEST', '8180787600', 7200, '1'),
(52, 'CET', '8198931600', 3600, '0'),
(52, 'CEST', '8212237200', 7200, '1'),
(52, 'CET', '8230986000', 3600, '0'),
(52, 'CEST', '8243686800', 7200, '1'),
(52, 'CET', '8262435600', 3600, '0'),
(52, 'CEST', '8275136400', 7200, '1'),
(52, 'CET', '8293885200', 3600, '0'),
(52, 'CEST', '8307190800', 7200, '1'),
(52, 'CET', '8325334800', 3600, '0'),
(52, 'CEST', '8338640400', 7200, '1'),
(52, 'CET', '8356784400', 3600, '0'),
(52, 'CEST', '8370090000', 7200, '1'),
(52, 'CET', '8388234000', 3600, '0'),
(52, 'CEST', '8401539600', 7200, '1'),
(52, 'CET', '8420288400', 3600, '0'),
(52, 'CEST', '8432989200', 7200, '1'),
(52, 'CET', '8451738000', 3600, '0'),
(52, 'CEST', '8464438800', 7200, '1'),
(52, 'CET', '8483187600', 3600, '0'),
(52, 'CEST', '8496493200', 7200, '1'),
(52, 'CET', '8514637200', 3600, '0'),
(52, 'CEST', '8527942800', 7200, '1'),
(52, 'CET', '8546086800', 3600, '0'),
(52, 'CEST', '8559392400', 7200, '1'),
(52, 'CET', '8578141200', 3600, '0'),
(52, 'CEST', '8590842000', 7200, '1'),
(52, 'CET', '8609590800', 3600, '0'),
(52, 'CEST', '8622291600', 7200, '1'),
(52, 'CET', '8641040400', 3600, '0'),
(52, 'CEST', '8654346000', 7200, '1'),
(52, 'CET', '8672490000', 3600, '0'),
(52, 'CEST', '8685795600', 7200, '1'),
(52, 'CET', '8703939600', 3600, '0'),
(52, 'CEST', '8717245200', 7200, '1'),
(52, 'CET', '8735389200', 3600, '0'),
(52, 'CEST', '8748694800', 7200, '1'),
(52, 'CET', '8767443600', 3600, '0'),
(52, 'CEST', '8780144400', 7200, '1'),
(52, 'CET', '8798893200', 3600, '0'),
(52, 'CEST', '8811594000', 7200, '1'),
(52, 'CET', '8830342800', 3600, '0'),
(52, 'CEST', '8843648400', 7200, '1'),
(52, 'CET', '8861792400', 3600, '0'),
(52, 'CEST', '8875098000', 7200, '1'),
(52, 'CET', '8893242000', 3600, '0'),
(52, 'CEST', '8906547600', 7200, '1'),
(52, 'CET', '8925296400', 3600, '0'),
(52, 'CEST', '8937997200', 7200, '1'),
(52, 'CET', '8956746000', 3600, '0'),
(52, 'CEST', '8969446800', 7200, '1'),
(52, 'CET', '8988195600', 3600, '0'),
(52, 'CEST', '9000896400', 7200, '1'),
(52, 'CET', '9019645200', 3600, '0'),
(52, 'CEST', '9032950800', 7200, '1'),
(52, 'CET', '9051094800', 3600, '0'),
(52, 'CEST', '9064400400', 7200, '1'),
(52, 'CET', '9082544400', 3600, '0'),
(52, 'CEST', '9095850000', 7200, '1'),
(52, 'CET', '9114598800', 3600, '0'),
(52, 'CEST', '9127299600', 7200, '1'),
(52, 'CET', '9146048400', 3600, '0'),
(52, 'CEST', '9158749200', 7200, '1'),
(52, 'CET', '9177498000', 3600, '0'),
(52, 'CEST', '9190803600', 7200, '1'),
(52, 'CET', '9208947600', 3600, '0'),
(52, 'CEST', '9222253200', 7200, '1'),
(52, 'CET', '9240397200', 3600, '0'),
(52, 'CEST', '9253702800', 7200, '1'),
(52, 'CET', '9271846800', 3600, '0'),
(52, 'CEST', '9285152400', 7200, '1'),
(52, 'CET', '9303901200', 3600, '0'),
(52, 'CEST', '9316602000', 7200, '1'),
(52, 'CET', '9335350800', 3600, '0'),
(52, 'CEST', '9348051600', 7200, '1'),
(52, 'CET', '9366800400', 3600, '0'),
(52, 'CEST', '9380106000', 7200, '1'),
(52, 'CET', '9398250000', 3600, '0'),
(52, 'CEST', '9411555600', 7200, '1'),
(52, 'CET', '9429699600', 3600, '0'),
(52, 'CEST', '9443005200', 7200, '1'),
(52, 'CET', '9461754000', 3600, '0'),
(52, 'CEST', '9474454800', 7200, '1'),
(52, 'CET', '9493203600', 3600, '0'),
(52, 'CEST', '9505904400', 7200, '1'),
(52, 'CET', '9524653200', 3600, '0'),
(52, 'CEST', '9537958800', 7200, '1'),
(52, 'CET', '9556102800', 3600, '0'),
(52, 'CEST', '9569408400', 7200, '1'),
(52, 'CET', '9587552400', 3600, '0'),
(52, 'CEST', '9600858000', 7200, '1'),
(52, 'CET', '9619002000', 3600, '0'),
(52, 'CEST', '9632307600', 7200, '1'),
(52, 'CET', '9651056400', 3600, '0'),
(52, 'CEST', '9663757200', 7200, '1'),
(52, 'CET', '9682506000', 3600, '0'),
(52, 'CEST', '9695206800', 7200, '1'),
(52, 'CET', '9713955600', 3600, '0'),
(52, 'CEST', '9727261200', 7200, '1'),
(52, 'CET', '9745405200', 3600, '0'),
(52, 'CEST', '9758710800', 7200, '1'),
(52, 'CET', '9776854800', 3600, '0'),
(52, 'CEST', '9790160400', 7200, '1'),
(52, 'CET', '9808909200', 3600, '0'),
(52, 'CEST', '9821610000', 7200, '1'),
(52, 'CET', '9840358800', 3600, '0'),
(52, 'CEST', '9853059600', 7200, '1'),
(52, 'CET', '9871808400', 3600, '0'),
(52, 'CEST', '9884509200', 7200, '1'),
(52, 'CET', '9903258000', 3600, '0'),
(52, 'CEST', '9916563600', 7200, '1'),
(52, 'CET', '9934707600', 3600, '0'),
(52, 'CEST', '9948013200', 7200, '1'),
(52, 'CET', '9966157200', 3600, '0'),
(52, 'CEST', '9979462800', 7200, '1'),
(52, 'CET', '9998211600', 3600, '0'),
(52, 'CEST', '10010912400', 7200, '1'),
(52, 'CET', '10029661200', 3600, '0'),
(52, 'CEST', '10042362000', 7200, '1'),
(52, 'CET', '10061110800', 3600, '0'),
(52, 'CEST', '10074416400', 7200, '1'),
(52, 'CET', '10092560400', 3600, '0'),
(52, 'CEST', '10105866000', 7200, '1'),
(52, 'CET', '10124010000', 3600, '0'),
(52, 'CEST', '10137315600', 7200, '1'),
(52, 'CET', '10155459600', 3600, '0'),
(52, 'CEST', '10168765200', 7200, '1'),
(52, 'CET', '10187514000', 3600, '0'),
(52, 'CEST', '10200214800', 7200, '1'),
(52, 'CET', '10218963600', 3600, '0'),
(52, 'CEST', '10231664400', 7200, '1'),
(52, 'CET', '10250413200', 3600, '0'),
(52, 'CEST', '10263718800', 7200, '1'),
(52, 'CET', '10281862800', 3600, '0'),
(52, 'CEST', '10295168400', 7200, '1'),
(52, 'CET', '10313312400', 3600, '0'),
(52, 'CEST', '10326618000', 7200, '1'),
(52, 'CET', '10345366800', 3600, '0'),
(52, 'CEST', '10358067600', 7200, '1'),
(52, 'CET', '10376816400', 3600, '0'),
(52, 'CEST', '10389517200', 7200, '1'),
(52, 'CET', '10408266000', 3600, '0'),
(52, 'CEST', '10420966800', 7200, '1'),
(52, 'CET', '10439715600', 3600, '0'),
(52, 'CEST', '10453021200', 7200, '1'),
(52, 'CET', '10471165200', 3600, '0'),
(52, 'CEST', '10484470800', 7200, '1'),
(52, 'CET', '10502614800', 3600, '0'),
(52, 'CEST', '10515920400', 7200, '1'),
(52, 'CET', '10534064400', 3600, '0'),
(52, 'CEST', '10547370000', 7200, '1'),
(52, 'CET', '10566118800', 3600, '0'),
(52, 'CEST', '10578819600', 7200, '1'),
(52, 'CET', '10597568400', 3600, '0'),
(52, 'CEST', '10610269200', 7200, '1'),
(52, 'CET', '10629018000', 3600, '0'),
(52, 'CEST', '10642323600', 7200, '1'),
(52, 'CET', '10660467600', 3600, '0'),
(52, 'CEST', '10673773200', 7200, '1'),
(52, 'CET', '10691917200', 3600, '0'),
(52, 'CEST', '10705222800', 7200, '1'),
(52, 'CET', '10723971600', 3600, '0'),
(52, 'CEST', '10736672400', 7200, '1'),
(52, 'CET', '10755421200', 3600, '0'),
(52, 'CEST', '10768122000', 7200, '1'),
(52, 'CET', '10786870800', 3600, '0'),
(52, 'CEST', '10800176400', 7200, '1'),
(52, 'CET', '10818320400', 3600, '0'),
(52, 'CEST', '10831626000', 7200, '1'),
(52, 'CET', '10849770000', 3600, '0'),
(52, 'CEST', '10863075600', 7200, '1'),
(52, 'CET', '10881219600', 3600, '0'),
(52, 'CEST', '10894525200', 7200, '1'),
(52, 'CET', '10913274000', 3600, '0'),
(52, 'CEST', '10925974800', 7200, '1'),
(52, 'CET', '10944723600', 3600, '0'),
(52, 'CEST', '10957424400', 7200, '1'),
(52, 'CET', '10976173200', 3600, '0'),
(52, 'CEST', '10989478800', 7200, '1'),
(52, 'CET', '11007622800', 3600, '0'),
(52, 'CEST', '11020928400', 7200, '1'),
(52, 'CET', '11039072400', 3600, '0'),
(52, 'CEST', '11052378000', 7200, '1'),
(52, 'CET', '11071126800', 3600, '0'),
(52, 'CEST', '11083827600', 7200, '1'),
(52, 'CET', '11102576400', 3600, '0'),
(52, 'CEST', '11115277200', 7200, '1'),
(52, 'CET', '11134026000', 3600, '0'),
(52, 'CEST', '11146726800', 7200, '1'),
(52, 'CET', '11165475600', 3600, '0'),
(52, 'CEST', '11178781200', 7200, '1'),
(52, 'CET', '11196925200', 3600, '0'),
(52, 'CEST', '11210230800', 7200, '1'),
(52, 'CET', '11228374800', 3600, '0'),
(52, 'CEST', '11241680400', 7200, '1'),
(52, 'CET', '11260429200', 3600, '0'),
(52, 'CEST', '11273130000', 7200, '1'),
(52, 'CET', '11291878800', 3600, '0'),
(52, 'CEST', '11304579600', 7200, '1'),
(52, 'CET', '11323328400', 3600, '0'),
(52, 'CEST', '11336634000', 7200, '1'),
(52, 'CET', '11354778000', 3600, '0'),
(52, 'CEST', '11368083600', 7200, '1'),
(52, 'CET', '11386227600', 3600, '0'),
(52, 'CEST', '11399533200', 7200, '1'),
(52, 'CET', '11417677200', 3600, '0'),
(52, 'CEST', '11430982800', 7200, '1'),
(52, 'CET', '11449731600', 3600, '0'),
(52, 'CEST', '11462432400', 7200, '1'),
(52, 'CET', '11481181200', 3600, '0'),
(52, 'CEST', '11493882000', 7200, '1'),
(52, 'CET', '11512630800', 3600, '0'),
(52, 'CEST', '11525936400', 7200, '1'),
(52, 'CET', '11544080400', 3600, '0'),
(52, 'CEST', '11557386000', 7200, '1'),
(52, 'CET', '11575530000', 3600, '0'),
(52, 'CEST', '11588835600', 7200, '1'),
(52, 'CET', '11607584400', 3600, '0'),
(52, 'CEST', '11620285200', 7200, '1'),
(52, 'CET', '11639034000', 3600, '0'),
(52, 'CEST', '11651734800', 7200, '1'),
(52, 'CET', '11670483600', 3600, '0'),
(52, 'CEST', '11683789200', 7200, '1'),
(52, 'CET', '11701933200', 3600, '0'),
(52, 'CEST', '11715238800', 7200, '1'),
(52, 'CET', '11733382800', 3600, '0'),
(52, 'CEST', '11746688400', 7200, '1'),
(52, 'CET', '11764832400', 3600, '0'),
(52, 'CEST', '11778138000', 7200, '1'),
(52, 'CET', '11796886800', 3600, '0'),
(52, 'CEST', '11809587600', 7200, '1'),
(52, 'CET', '11828336400', 3600, '0'),
(52, 'CEST', '11841037200', 7200, '1'),
(52, 'CET', '11859786000', 3600, '0'),
(52, 'CEST', '11873091600', 7200, '1'),
(52, 'CET', '11891235600', 3600, '0'),
(52, 'CEST', '11904541200', 7200, '1'),
(52, 'CET', '11922685200', 3600, '0'),
(52, 'CEST', '11935990800', 7200, '1'),
(52, 'CET', '11954739600', 3600, '0'),
(52, 'CEST', '11967440400', 7200, '1'),
(52, 'CET', '11986189200', 3600, '0'),
(52, 'CEST', '11998890000', 7200, '1'),
(52, 'CET', '12017638800', 3600, '0'),
(52, 'CEST', '12030339600', 7200, '1'),
(52, 'CET', '12049088400', 3600, '0'),
(52, 'CEST', '12062394000', 7200, '1'),
(52, 'CET', '12080538000', 3600, '0'),
(52, 'CEST', '12093843600', 7200, '1'),
(52, 'CET', '12111987600', 3600, '0'),
(52, 'CEST', '12125293200', 7200, '1'),
(52, 'CET', '12144042000', 3600, '0'),
(52, 'CEST', '12156742800', 7200, '1'),
(52, 'CET', '12175491600', 3600, '0'),
(52, 'CEST', '12188192400', 7200, '1'),
(52, 'CET', '12206941200', 3600, '0'),
(52, 'CEST', '12220246800', 7200, '1'),
(52, 'CET', '12238390800', 3600, '0'),
(52, 'CEST', '12251696400', 7200, '1'),
(52, 'CET', '12269840400', 3600, '0'),
(52, 'CEST', '12283146000', 7200, '1'),
(52, 'CET', '12301290000', 3600, '0'),
(52, 'CEST', '12314595600', 7200, '1'),
(52, 'CET', '12333344400', 3600, '0'),
(52, 'CEST', '12346045200', 7200, '1'),
(52, 'CET', '12364794000', 3600, '0'),
(52, 'CEST', '12377494800', 7200, '1'),
(52, 'CET', '12396243600', 3600, '0'),
(52, 'CEST', '12409549200', 7200, '1'),
(52, 'CET', '12427693200', 3600, '0'),
(52, 'CEST', '12440998800', 7200, '1'),
(52, 'CET', '12459142800', 3600, '0'),
(52, 'CEST', '12472448400', 7200, '1'),
(52, 'CET', '12491197200', 3600, '0'),
(52, 'CEST', '12503898000', 7200, '1'),
(52, 'CET', '12522646800', 3600, '0'),
(52, 'CEST', '12535347600', 7200, '1'),
(52, 'CET', '12554096400', 3600, '0'),
(52, 'CEST', '12567402000', 7200, '1'),
(52, 'CET', '12585546000', 3600, '0'),
(52, 'CEST', '12598851600', 7200, '1'),
(52, 'CET', '12616995600', 3600, '0'),
(52, 'CEST', '12630301200', 7200, '1'),
(52, 'CET', '12648445200', 3600, '0'),
(52, 'CEST', '12661750800', 7200, '1'),
(52, 'CET', '12680499600', 3600, '0'),
(52, 'CEST', '12693200400', 7200, '1'),
(52, 'CET', '12711949200', 3600, '0'),
(52, 'CEST', '12724650000', 7200, '1'),
(52, 'CET', '12743398800', 3600, '0'),
(52, 'CEST', '12756704400', 7200, '1'),
(52, 'CET', '12774848400', 3600, '0'),
(52, 'CEST', '12788154000', 7200, '1'),
(52, 'CET', '12806298000', 3600, '0'),
(52, 'CEST', '12819603600', 7200, '1'),
(52, 'CET', '12838352400', 3600, '0'),
(52, 'CEST', '12851053200', 7200, '1'),
(52, 'CET', '12869802000', 3600, '0'),
(52, 'CEST', '12882502800', 7200, '1'),
(52, 'CET', '12901251600', 3600, '0'),
(52, 'CEST', '12913952400', 7200, '1'),
(52, 'CET', '12932701200', 3600, '0'),
(52, 'CEST', '12946006800', 7200, '1'),
(52, 'CET', '12964150800', 3600, '0'),
(52, 'CEST', '12977456400', 7200, '1'),
(52, 'CET', '12995600400', 3600, '0'),
(52, 'CEST', '13008906000', 7200, '1'),
(52, 'CET', '13027654800', 3600, '0'),
(52, 'CEST', '13040355600', 7200, '1'),
(52, 'CET', '13059104400', 3600, '0'),
(52, 'CEST', '13071805200', 7200, '1'),
(52, 'CET', '13090554000', 3600, '0'),
(52, 'CEST', '13103859600', 7200, '1'),
(52, 'CET', '13122003600', 3600, '0'),
(52, 'CEST', '13135309200', 7200, '1'),
(52, 'CET', '13153453200', 3600, '0'),
(52, 'CEST', '13166758800', 7200, '1'),
(52, 'CET', '13184902800', 3600, '0'),
(52, 'CEST', '13198208400', 7200, '1'),
(52, 'CET', '13216957200', 3600, '0'),
(52, 'CEST', '13229658000', 7200, '1'),
(52, 'CET', '13248406800', 3600, '0'),
(52, 'CEST', '13261107600', 7200, '1'),
(52, 'CET', '13279856400', 3600, '0'),
(52, 'CEST', '13293162000', 7200, '1'),
(52, 'CET', '13311306000', 3600, '0'),
(52, 'CEST', '13324611600', 7200, '1'),
(52, 'CET', '13342755600', 3600, '0'),
(52, 'CEST', '13356061200', 7200, '1'),
(52, 'CET', '13374810000', 3600, '0'),
(52, 'CEST', '13387510800', 7200, '1'),
(52, 'CET', '13406259600', 3600, '0'),
(52, 'CEST', '13418960400', 7200, '1'),
(52, 'CET', '13437709200', 3600, '0'),
(52, 'CEST', '13451014800', 7200, '1'),
(52, 'CET', '13469158800', 3600, '0'),
(52, 'CEST', '13482464400', 7200, '1'),
(52, 'CET', '13500608400', 3600, '0'),
(52, 'CEST', '13513914000', 7200, '1'),
(52, 'CET', '13532058000', 3600, '0'),
(52, 'CEST', '13545363600', 7200, '1'),
(52, 'CET', '13564112400', 3600, '0'),
(52, 'CEST', '13576813200', 7200, '1'),
(52, 'CET', '13595562000', 3600, '0'),
(52, 'CEST', '13608262800', 7200, '1'),
(52, 'CET', '13627011600', 3600, '0'),
(52, 'CEST', '13640317200', 7200, '1'),
(52, 'CET', '13658461200', 3600, '0'),
(52, 'CEST', '13671766800', 7200, '1'),
(52, 'CET', '13689910800', 3600, '0'),
(52, 'CEST', '13703216400', 7200, '1'),
(52, 'CET', '13721965200', 3600, '0'),
(52, 'CEST', '13734666000', 7200, '1'),
(52, 'CET', '13753414800', 3600, '0'),
(52, 'CEST', '13766115600', 7200, '1'),
(52, 'CET', '13784864400', 3600, '0'),
(52, 'CEST', '13797565200', 7200, '1'),
(52, 'CET', '13816314000', 3600, '0'),
(52, 'CEST', '13829619600', 7200, '1'),
(52, 'CET', '13847763600', 3600, '0'),
(52, 'CEST', '13861069200', 7200, '1'),
(52, 'CET', '13879213200', 3600, '0'),
(52, 'CEST', '13892518800', 7200, '1'),
(52, 'CET', '13911267600', 3600, '0'),
(52, 'CEST', '13923968400', 7200, '1'),
(52, 'CET', '13942717200', 3600, '0'),
(52, 'CEST', '13955418000', 7200, '1'),
(52, 'CET', '13974166800', 3600, '0'),
(52, 'CEST', '13987472400', 7200, '1'),
(52, 'CET', '14005616400', 3600, '0'),
(52, 'CEST', '14018922000', 7200, '1'),
(52, 'CET', '14037066000', 3600, '0'),
(52, 'CEST', '14050371600', 7200, '1'),
(52, 'CET', '14068515600', 3600, '0'),
(52, 'CEST', '14081821200', 7200, '1'),
(52, 'CET', '14100570000', 3600, '0'),
(52, 'CEST', '14113270800', 7200, '1'),
(52, 'CET', '14132019600', 3600, '0'),
(52, 'CEST', '14144720400', 7200, '1'),
(52, 'CET', '14163469200', 3600, '0'),
(52, 'CEST', '14176774800', 7200, '1'),
(52, 'CET', '14194918800', 3600, '0'),
(52, 'CEST', '14208224400', 7200, '1'),
(52, 'CET', '14226368400', 3600, '0'),
(52, 'CEST', '14239674000', 7200, '1'),
(52, 'CET', '14258422800', 3600, '0'),
(52, 'CEST', '14271123600', 7200, '1'),
(52, 'CET', '14289872400', 3600, '0'),
(52, 'CEST', '14302573200', 7200, '1'),
(52, 'CET', '14321322000', 3600, '0'),
(52, 'CEST', '14334627600', 7200, '1'),
(52, 'CET', '14352771600', 3600, '0'),
(52, 'CEST', '14366077200', 7200, '1'),
(52, 'CET', '14384221200', 3600, '0'),
(52, 'CEST', '14397526800', 7200, '1'),
(52, 'CET', '14415670800', 3600, '0'),
(52, 'CEST', '14428976400', 7200, '1'),
(52, 'CET', '14447725200', 3600, '0'),
(52, 'CEST', '14460426000', 7200, '1'),
(52, 'CET', '14479174800', 3600, '0'),
(52, 'CEST', '14491875600', 7200, '1'),
(52, 'CET', '14510624400', 3600, '0'),
(52, 'CEST', '14523930000', 7200, '1'),
(52, 'CET', '14542074000', 3600, '0'),
(52, 'CEST', '14555379600', 7200, '1'),
(52, 'CET', '14573523600', 3600, '0'),
(52, 'CEST', '14586829200', 7200, '1'),
(52, 'CET', '14605578000', 3600, '0'),
(52, 'CEST', '14618278800', 7200, '1'),
(52, 'CET', '14637027600', 3600, '0'),
(52, 'CEST', '14649728400', 7200, '1'),
(52, 'CET', '14668477200', 3600, '0'),
(52, 'CEST', '14681178000', 7200, '1'),
(52, 'CET', '14699926800', 3600, '0'),
(52, 'CEST', '14713232400', 7200, '1'),
(52, 'CET', '14731376400', 3600, '0'),
(52, 'CEST', '14744682000', 7200, '1'),
(52, 'CET', '14762826000', 3600, '0'),
(52, 'CEST', '14776131600', 7200, '1'),
(52, 'CET', '14794880400', 3600, '0'),
(52, 'CEST', '14807581200', 7200, '1'),
(52, 'CET', '14826330000', 3600, '0'),
(52, 'CEST', '14839030800', 7200, '1'),
(52, 'CET', '14857779600', 3600, '0'),
(52, 'CEST', '14871085200', 7200, '1'),
(52, 'CET', '14889229200', 3600, '0'),
(52, 'CEST', '14902534800', 7200, '1'),
(52, 'CET', '14920678800', 3600, '0'),
(52, 'CEST', '14933984400', 7200, '1'),
(52, 'CET', '14952128400', 3600, '0'),
(52, 'CEST', '14965434000', 7200, '1'),
(52, 'CET', '14984182800', 3600, '0'),
(52, 'CEST', '14996883600', 7200, '1'),
(52, 'CET', '15015632400', 3600, '0'),
(52, 'CEST', '15028333200', 7200, '1'),
(52, 'CET', '15047082000', 3600, '0'),
(52, 'CEST', '15060387600', 7200, '1'),
(52, 'CET', '15078531600', 3600, '0'),
(52, 'CEST', '15091837200', 7200, '1'),
(52, 'CET', '15109981200', 3600, '0'),
(52, 'CEST', '15123286800', 7200, '1'),
(52, 'CET', '15142035600', 3600, '0'),
(52, 'CEST', '15154736400', 7200, '1'),
(52, 'CET', '15173485200', 3600, '0'),
(52, 'CEST', '15186186000', 7200, '1'),
(52, 'CET', '15204934800', 3600, '0'),
(52, 'CEST', '15218240400', 7200, '1'),
(52, 'CET', '15236384400', 3600, '0'),
(52, 'CEST', '15249690000', 7200, '1'),
(52, 'CET', '15267834000', 3600, '0'),
(52, 'CEST', '15281139600', 7200, '1'),
(52, 'CET', '15299283600', 3600, '0'),
(52, 'CEST', '15312589200', 7200, '1'),
(52, 'CET', '15331338000', 3600, '0'),
(52, 'CEST', '15344038800', 7200, '1'),
(52, 'CET', '15362787600', 3600, '0'),
(52, 'CEST', '15375488400', 7200, '1'),
(52, 'CET', '15394237200', 3600, '0'),
(52, 'CEST', '15407542800', 7200, '1'),
(52, 'CET', '15425686800', 3600, '0'),
(52, 'CEST', '15438992400', 7200, '1'),
(52, 'CET', '15457136400', 3600, '0'),
(52, 'CEST', '15470442000', 7200, '1'),
(52, 'CET', '15489190800', 3600, '0'),
(52, 'CEST', '15501891600', 7200, '1'),
(52, 'CET', '15520640400', 3600, '0'),
(52, 'CEST', '15533341200', 7200, '1'),
(52, 'CET', '15552090000', 3600, '0'),
(52, 'CEST', '15564790800', 7200, '1'),
(52, 'CET', '15583539600', 3600, '0'),
(52, 'CEST', '15596845200', 7200, '1'),
(52, 'CET', '15614989200', 3600, '0'),
(52, 'CEST', '15628294800', 7200, '1'),
(52, 'CET', '15646438800', 3600, '0'),
(52, 'CEST', '15659744400', 7200, '1'),
(52, 'CET', '15678493200', 3600, '0'),
(52, 'CEST', '15691194000', 7200, '1'),
(52, 'CET', '15709942800', 3600, '0'),
(52, 'CEST', '15722643600', 7200, '1'),
(52, 'CET', '15741392400', 3600, '0'),
(52, 'CEST', '15754698000', 7200, '1'),
(52, 'CET', '15772842000', 3600, '0'),
(52, 'CEST', '15786147600', 7200, '1'),
(52, 'CET', '15804291600', 3600, '0'),
(52, 'CEST', '15817597200', 7200, '1'),
(52, 'CET', '15835741200', 3600, '0'),
(52, 'CEST', '15849046800', 7200, '1'),
(52, 'CET', '15867795600', 3600, '0'),
(52, 'CEST', '15880496400', 7200, '1'),
(52, 'CET', '15899245200', 3600, '0'),
(52, 'CEST', '15911946000', 7200, '1'),
(52, 'CET', '15930694800', 3600, '0'),
(52, 'CEST', '15944000400', 7200, '1'),
(52, 'CET', '15962144400', 3600, '0'),
(52, 'CEST', '15975450000', 7200, '1'),
(52, 'CET', '15993594000', 3600, '0'),
(52, 'CEST', '16006899600', 7200, '1'),
(52, 'CET', '16025648400', 3600, '0'),
(52, 'CEST', '16038349200', 7200, '1'),
(52, 'CET', '16057098000', 3600, '0'),
(52, 'CEST', '16069798800', 7200, '1'),
(52, 'CET', '16088547600', 3600, '0'),
(52, 'CEST', '16101853200', 7200, '1'),
(52, 'CET', '16119997200', 3600, '0'),
(52, 'CEST', '16133302800', 7200, '1'),
(52, 'CET', '16151446800', 3600, '0'),
(52, 'CEST', '16164752400', 7200, '1'),
(52, 'CET', '16182896400', 3600, '0'),
(52, 'CEST', '16196202000', 7200, '1'),
(52, 'CET', '16214950800', 3600, '0'),
(52, 'CEST', '16227651600', 7200, '1'),
(52, 'CET', '16246400400', 3600, '0'),
(52, 'CEST', '16259101200', 7200, '1'),
(52, 'CET', '16277850000', 3600, '0'),
(52, 'CEST', '16291155600', 7200, '1'),
(52, 'CET', '16309299600', 3600, '0'),
(52, 'CEST', '16322605200', 7200, '1'),
(52, 'CET', '16340749200', 3600, '0'),
(52, 'CEST', '16354054800', 7200, '1'),
(52, 'CET', '16372803600', 3600, '0'),
(52, 'CEST', '16385504400', 7200, '1'),
(52, 'CET', '16404253200', 3600, '0'),
(52, 'CEST', '16416954000', 7200, '1'),
(52, 'CET', '16435702800', 3600, '0'),
(52, 'CEST', '16448403600', 7200, '1'),
(52, 'CET', '16467152400', 3600, '0'),
(52, 'CEST', '16480458000', 7200, '1'),
(52, 'CET', '16498602000', 3600, '0'),
(52, 'CEST', '16511907600', 7200, '1'),
(52, 'CET', '16530051600', 3600, '0'),
(52, 'CEST', '16543357200', 7200, '1'),
(52, 'CET', '16562106000', 3600, '0'),
(52, 'CEST', '16574806800', 7200, '1'),
(52, 'CET', '16593555600', 3600, '0'),
(52, 'CEST', '16606256400', 7200, '1'),
(52, 'CET', '16625005200', 3600, '0'),
(52, 'CEST', '16638310800', 7200, '1'),
(52, 'CET', '16656454800', 3600, '0'),
(52, 'CEST', '16669760400', 7200, '1'),
(52, 'CET', '16687904400', 3600, '0'),
(52, 'CEST', '16701210000', 7200, '1'),
(52, 'CET', '16719354000', 3600, '0'),
(53, 'LMT', '-1830383033', -968, '0'),
(53, 'GMT', '-1830383032', 0, '0'),
(54, 'LMT', '-2840146397', 5596, '0'),
(54, 'IMT', '-2840146396', 7016, '0'),
(54, 'EET', '-2369527016', 7200, '0'),
(54, 'CET', '-857257200', 3600, '0'),
(54, 'CEST', '-844556400', 7200, '1'),
(54, 'CET', '-828226800', 3600, '0'),
(54, 'CEST', '-812502000', 7200, '1'),
(54, 'CET', '-796777200', 3600, '0'),
(54, 'EET', '-781048800', 7200, '0'),
(54, 'EEST', '291762000', 10800, '1'),
(54, 'EET', '307576800', 7200, '0'),
(54, 'EEST', '323816400', 10800, '1'),
(54, 'EET', '339026400', 7200, '0'),
(54, 'EEST', '355266000', 10800, '1'),
(54, 'EET', '370393200', 7200, '0'),
(54, 'EEST', '386715600', 10800, '1'),
(54, 'EET', '401846400', 7200, '0'),
(54, 'EEST', '417571200', 10800, '1'),
(54, 'EET', '433296000', 7200, '0'),
(54, 'EEST', '449020800', 10800, '1'),
(54, 'EET', '465350400', 7200, '0'),
(54, 'EEST', '481075200', 10800, '1'),
(54, 'EET', '496800000', 7200, '0'),
(54, 'EEST', '512524800', 10800, '1'),
(54, 'EET', '528249600', 7200, '0'),
(54, 'EEST', '543974400', 10800, '1'),
(54, 'EET', '559699200', 7200, '0'),
(54, 'EEST', '575424000', 10800, '1'),
(54, 'EET', '591148800', 7200, '0'),
(54, 'EEST', '606873600', 10800, '1'),
(54, 'EET', '622598400', 7200, '0'),
(54, 'EEST', '638323200', 10800, '1'),
(54, 'EET', '654652800', 7200, '0'),
(54, 'EEST', '670370400', 10800, '1'),
(54, 'EET', '686091600', 7200, '0'),
(54, 'EEST', '701820000', 10800, '1'),
(54, 'EET', '717541200', 7200, '0'),
(54, 'EEST', '733269600', 10800, '1'),
(54, 'EET', '748990800', 7200, '0'),
(54, 'EEST', '764719200', 10800, '1'),
(54, 'EET', '780440400', 7200, '0'),
(54, 'EEST', '796168800', 10800, '1'),
(54, 'EET', '811890000', 7200, '0'),
(54, 'EEST', '828223200', 10800, '1'),
(54, 'EET', '846363600', 7200, '0'),
(54, 'EEST', '859683600', 10800, '1'),
(54, 'EET', '877827600', 7200, '0'),
(54, 'EEST', '891133200', 10800, '1'),
(54, 'EET', '909277200', 7200, '0'),
(54, 'EEST', '922582800', 10800, '1'),
(54, 'EET', '941331600', 7200, '0'),
(54, 'EEST', '954032400', 10800, '1'),
(54, 'EET', '972781200', 7200, '0'),
(54, 'EEST', '985482000', 10800, '1'),
(54, 'EET', '1004230800', 7200, '0'),
(54, 'EEST', '1017536400', 10800, '1'),
(54, 'EET', '1035680400', 7200, '0'),
(54, 'EEST', '1048986000', 10800, '1'),
(54, 'EET', '1067130000', 7200, '0'),
(54, 'EEST', '1080435600', 10800, '1'),
(54, 'EET', '1099184400', 7200, '0'),
(54, 'EEST', '1111885200', 10800, '1'),
(54, 'EET', '1130634000', 7200, '0'),
(54, 'EEST', '1143334800', 10800, '1'),
(54, 'EET', '1162083600', 7200, '0'),
(54, 'EEST', '1174784400', 10800, '1'),
(54, 'EET', '1193533200', 7200, '0'),
(54, 'EEST', '1206838800', 10800, '1'),
(54, 'EET', '1224982800', 7200, '0'),
(54, 'EEST', '1238288400', 10800, '1'),
(54, 'EET', '1256432400', 7200, '0'),
(54, 'EEST', '1269738000', 10800, '1'),
(54, 'EET', '1288486800', 7200, '0'),
(54, 'EEST', '1301187600', 10800, '1'),
(54, 'EET', '1319936400', 7200, '0'),
(54, 'EEST', '1332637200', 10800, '1'),
(54, 'EET', '1351386000', 7200, '0'),
(54, 'EEST', '1364691600', 10800, '1'),
(54, 'EET', '1382835600', 7200, '0'),
(54, 'EEST', '1396141200', 10800, '1'),
(54, 'EET', '1414285200', 7200, '0'),
(54, 'EEST', '1427590800', 10800, '1'),
(54, 'EET', '1445734800', 7200, '0'),
(54, 'EEST', '1459040400', 10800, '1'),
(54, 'EET', '1477789200', 7200, '0'),
(54, 'EEST', '1490490000', 10800, '1'),
(54, 'EET', '1509238800', 7200, '0'),
(54, 'EEST', '1521939600', 10800, '1'),
(54, 'EET', '1540688400', 7200, '0'),
(54, 'EEST', '1553994000', 10800, '1'),
(54, 'EET', '1572138000', 7200, '0'),
(54, 'EEST', '1585443600', 10800, '1'),
(54, 'EET', '1603587600', 7200, '0'),
(54, 'EEST', '1616893200', 10800, '1'),
(54, 'EET', '1635642000', 7200, '0'),
(54, 'EEST', '1648342800', 10800, '1'),
(54, 'EET', '1667091600', 7200, '0'),
(54, 'EEST', '1679792400', 10800, '1'),
(54, 'EET', '1698541200', 7200, '0'),
(54, 'EEST', '1711846800', 10800, '1'),
(54, 'EET', '1729990800', 7200, '0'),
(54, 'EEST', '1743296400', 10800, '1'),
(54, 'EET', '1761440400', 7200, '0'),
(54, 'EEST', '1774746000', 10800, '1'),
(54, 'EET', '1792890000', 7200, '0'),
(54, 'EEST', '1806195600', 10800, '1'),
(54, 'EET', '1824944400', 7200, '0'),
(54, 'EEST', '1837645200', 10800, '1'),
(54, 'EET', '1856394000', 7200, '0'),
(54, 'EEST', '1869094800', 10800, '1'),
(54, 'EET', '1887843600', 7200, '0'),
(54, 'EEST', '1901149200', 10800, '1'),
(54, 'EET', '1919293200', 7200, '0'),
(54, 'EEST', '1932598800', 10800, '1'),
(54, 'EET', '1950742800', 7200, '0'),
(54, 'EEST', '1964048400', 10800, '1'),
(54, 'EET', '1982797200', 7200, '0'),
(54, 'EEST', '1995498000', 10800, '1'),
(54, 'EET', '2014246800', 7200, '0'),
(54, 'EEST', '2026947600', 10800, '1'),
(54, 'EET', '2045696400', 7200, '0'),
(54, 'EEST', '2058397200', 10800, '1'),
(54, 'EET', '2077146000', 7200, '0'),
(54, 'EEST', '2090451600', 10800, '1'),
(54, 'EET', '2108595600', 7200, '0'),
(54, 'EEST', '2121901200', 10800, '1'),
(54, 'EET', '2140045200', 7200, '0'),
(54, 'EEST', '2153350800', 10800, '1'),
(54, 'EET', '2172099600', 7200, '0'),
(54, 'EEST', '2184800400', 10800, '1'),
(54, 'EET', '2203549200', 7200, '0'),
(54, 'EEST', '2216250000', 10800, '1'),
(54, 'EET', '2234998800', 7200, '0'),
(54, 'EEST', '2248304400', 10800, '1'),
(54, 'EET', '2266448400', 7200, '0'),
(54, 'EEST', '2279754000', 10800, '1'),
(54, 'EET', '2297898000', 7200, '0'),
(54, 'EEST', '2311203600', 10800, '1'),
(54, 'EET', '2329347600', 7200, '0'),
(54, 'EEST', '2342653200', 10800, '1'),
(54, 'EET', '2361402000', 7200, '0'),
(54, 'EEST', '2374102800', 10800, '1'),
(54, 'EET', '2392851600', 7200, '0'),
(54, 'EEST', '2405552400', 10800, '1'),
(54, 'EET', '2424301200', 7200, '0'),
(54, 'EEST', '2437606800', 10800, '1'),
(54, 'EET', '2455750800', 7200, '0'),
(54, 'EEST', '2469056400', 10800, '1'),
(54, 'EET', '2487200400', 7200, '0'),
(54, 'EEST', '2500506000', 10800, '1'),
(54, 'EET', '2519254800', 7200, '0'),
(54, 'EEST', '2531955600', 10800, '1'),
(54, 'EET', '2550704400', 7200, '0'),
(54, 'EEST', '2563405200', 10800, '1'),
(54, 'EET', '2582154000', 7200, '0'),
(54, 'EEST', '2595459600', 10800, '1'),
(54, 'EET', '2613603600', 7200, '0'),
(54, 'EEST', '2626909200', 10800, '1'),
(54, 'EET', '2645053200', 7200, '0'),
(54, 'EEST', '2658358800', 10800, '1'),
(54, 'EET', '2676502800', 7200, '0'),
(54, 'EEST', '2689808400', 10800, '1'),
(54, 'EET', '2708557200', 7200, '0'),
(54, 'EEST', '2721258000', 10800, '1'),
(54, 'EET', '2740006800', 7200, '0'),
(54, 'EEST', '2752707600', 10800, '1'),
(54, 'EET', '2771456400', 7200, '0'),
(54, 'EEST', '2784762000', 10800, '1'),
(54, 'EET', '2802906000', 7200, '0'),
(54, 'EEST', '2816211600', 10800, '1'),
(54, 'EET', '2834355600', 7200, '0'),
(54, 'EEST', '2847661200', 10800, '1'),
(54, 'EET', '2866410000', 7200, '0'),
(54, 'EEST', '2879110800', 10800, '1'),
(54, 'EET', '2897859600', 7200, '0'),
(54, 'EEST', '2910560400', 10800, '1'),
(54, 'EET', '2929309200', 7200, '0'),
(54, 'EEST', '2942010000', 10800, '1'),
(54, 'EET', '2960758800', 7200, '0'),
(54, 'EEST', '2974064400', 10800, '1'),
(54, 'EET', '2992208400', 7200, '0'),
(54, 'EEST', '3005514000', 10800, '1'),
(54, 'EET', '3023658000', 7200, '0'),
(54, 'EEST', '3036963600', 10800, '1'),
(54, 'EET', '3055712400', 7200, '0'),
(54, 'EEST', '3068413200', 10800, '1'),
(54, 'EET', '3087162000', 7200, '0'),
(54, 'EEST', '3099862800', 10800, '1'),
(54, 'EET', '3118611600', 7200, '0'),
(54, 'EEST', '3131917200', 10800, '1'),
(54, 'EET', '3150061200', 7200, '0'),
(54, 'EEST', '3163366800', 10800, '1'),
(54, 'EET', '3181510800', 7200, '0'),
(54, 'EEST', '3194816400', 10800, '1'),
(54, 'EET', '3212960400', 7200, '0'),
(54, 'EEST', '3226266000', 10800, '1'),
(54, 'EET', '3245014800', 7200, '0'),
(54, 'EEST', '3257715600', 10800, '1'),
(54, 'EET', '3276464400', 7200, '0'),
(54, 'EEST', '3289165200', 10800, '1'),
(54, 'EET', '3307914000', 7200, '0'),
(54, 'EEST', '3321219600', 10800, '1'),
(54, 'EET', '3339363600', 7200, '0'),
(54, 'EEST', '3352669200', 10800, '1'),
(54, 'EET', '3370813200', 7200, '0'),
(54, 'EEST', '3384118800', 10800, '1'),
(54, 'EET', '3402867600', 7200, '0'),
(54, 'EEST', '3415568400', 10800, '1'),
(54, 'EET', '3434317200', 7200, '0'),
(54, 'EEST', '3447018000', 10800, '1'),
(54, 'EET', '3465766800', 7200, '0'),
(54, 'EEST', '3479072400', 10800, '1'),
(54, 'EET', '3497216400', 7200, '0'),
(54, 'EEST', '3510522000', 10800, '1'),
(54, 'EET', '3528666000', 7200, '0'),
(54, 'EEST', '3541971600', 10800, '1'),
(54, 'EET', '3560115600', 7200, '0'),
(54, 'EEST', '3573421200', 10800, '1'),
(54, 'EET', '3592170000', 7200, '0'),
(54, 'EEST', '3604870800', 10800, '1'),
(54, 'EET', '3623619600', 7200, '0'),
(54, 'EEST', '3636320400', 10800, '1'),
(54, 'EET', '3655069200', 7200, '0'),
(54, 'EEST', '3668374800', 10800, '1'),
(54, 'EET', '3686518800', 7200, '0'),
(54, 'EEST', '3699824400', 10800, '1'),
(54, 'EET', '3717968400', 7200, '0'),
(54, 'EEST', '3731274000', 10800, '1'),
(54, 'EET', '3750022800', 7200, '0'),
(54, 'EEST', '3762723600', 10800, '1'),
(54, 'EET', '3781472400', 7200, '0'),
(54, 'EEST', '3794173200', 10800, '1'),
(54, 'EET', '3812922000', 7200, '0'),
(54, 'EEST', '3825622800', 10800, '1'),
(54, 'EET', '3844371600', 7200, '0'),
(54, 'EEST', '3857677200', 10800, '1'),
(54, 'EET', '3875821200', 7200, '0'),
(54, 'EEST', '3889126800', 10800, '1'),
(54, 'EET', '3907270800', 7200, '0'),
(54, 'EEST', '3920576400', 10800, '1'),
(54, 'EET', '3939325200', 7200, '0'),
(54, 'EEST', '3952026000', 10800, '1'),
(54, 'EET', '3970774800', 7200, '0'),
(54, 'EEST', '3983475600', 10800, '1'),
(54, 'EET', '4002224400', 7200, '0'),
(54, 'EEST', '4015530000', 10800, '1'),
(54, 'EET', '4033674000', 7200, '0'),
(54, 'EEST', '4046979600', 10800, '1'),
(54, 'EET', '4065123600', 7200, '0'),
(54, 'EEST', '4078429200', 10800, '1'),
(54, 'EET', '4096573200', 7200, '0'),
(54, 'EEST', '4109878800', 10800, '1'),
(54, 'EET', '4128627600', 7200, '0'),
(54, 'EEST', '4141328400', 10800, '1'),
(54, 'EET', '4160077200', 7200, '0'),
(54, 'EEST', '4172778000', 10800, '1'),
(54, 'EET', '4191526800', 7200, '0'),
(54, 'EEST', '4204227600', 10800, '1'),
(54, 'EET', '4222976400', 7200, '0'),
(54, 'EEST', '4236282000', 10800, '1'),
(54, 'EET', '4254426000', 7200, '0'),
(54, 'EEST', '4267731600', 10800, '1'),
(54, 'EET', '4285875600', 7200, '0'),
(54, 'EEST', '4299181200', 10800, '1'),
(54, 'EET', '4317930000', 7200, '0'),
(54, 'EEST', '4330630800', 10800, '1'),
(54, 'EET', '4349379600', 7200, '0'),
(54, 'EEST', '4362080400', 10800, '1'),
(54, 'EET', '4380829200', 7200, '0'),
(54, 'EEST', '4394134800', 10800, '1'),
(54, 'EET', '4412278800', 7200, '0'),
(54, 'EEST', '4425584400', 10800, '1'),
(54, 'EET', '4443728400', 7200, '0'),
(54, 'EEST', '4457034000', 10800, '1'),
(54, 'EET', '4475178000', 7200, '0'),
(54, 'EEST', '4488483600', 10800, '1'),
(54, 'EET', '4507232400', 7200, '0'),
(54, 'EEST', '4519933200', 10800, '1'),
(54, 'EET', '4538682000', 7200, '0'),
(54, 'EEST', '4551382800', 10800, '1'),
(54, 'EET', '4570131600', 7200, '0'),
(54, 'EEST', '4583437200', 10800, '1'),
(54, 'EET', '4601581200', 7200, '0'),
(54, 'EEST', '4614886800', 10800, '1'),
(54, 'EET', '4633030800', 7200, '0'),
(54, 'EEST', '4646336400', 10800, '1'),
(54, 'EET', '4665085200', 7200, '0'),
(54, 'EEST', '4677786000', 10800, '1'),
(54, 'EET', '4696534800', 7200, '0'),
(54, 'EEST', '4709235600', 10800, '1'),
(54, 'EET', '4727984400', 7200, '0'),
(54, 'EEST', '4741290000', 10800, '1'),
(54, 'EET', '4759434000', 7200, '0'),
(54, 'EEST', '4772739600', 10800, '1'),
(54, 'EET', '4790883600', 7200, '0'),
(54, 'EEST', '4804189200', 10800, '1'),
(54, 'EET', '4822333200', 7200, '0'),
(54, 'EEST', '4835638800', 10800, '1'),
(54, 'EET', '4854387600', 7200, '0'),
(54, 'EEST', '4867088400', 10800, '1'),
(54, 'EET', '4885837200', 7200, '0'),
(54, 'EEST', '4898538000', 10800, '1'),
(54, 'EET', '4917286800', 7200, '0'),
(54, 'EEST', '4930592400', 10800, '1'),
(54, 'EET', '4948736400', 7200, '0'),
(54, 'EEST', '4962042000', 10800, '1'),
(54, 'EET', '4980186000', 7200, '0'),
(54, 'EEST', '4993491600', 10800, '1'),
(54, 'EET', '5012240400', 7200, '0'),
(54, 'EEST', '5024941200', 10800, '1'),
(54, 'EET', '5043690000', 7200, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(54, 'EEST', '5056390800', 10800, '1'),
(54, 'EET', '5075139600', 7200, '0'),
(54, 'EEST', '5087840400', 10800, '1'),
(54, 'EET', '5106589200', 7200, '0'),
(54, 'EEST', '5119894800', 10800, '1'),
(54, 'EET', '5138038800', 7200, '0'),
(54, 'EEST', '5151344400', 10800, '1'),
(54, 'EET', '5169488400', 7200, '0'),
(54, 'EEST', '5182794000', 10800, '1'),
(54, 'EET', '5201542800', 7200, '0'),
(54, 'EEST', '5214243600', 10800, '1'),
(54, 'EET', '5232992400', 7200, '0'),
(54, 'EEST', '5245693200', 10800, '1'),
(54, 'EET', '5264442000', 7200, '0'),
(54, 'EEST', '5277747600', 10800, '1'),
(54, 'EET', '5295891600', 7200, '0'),
(54, 'EEST', '5309197200', 10800, '1'),
(54, 'EET', '5327341200', 7200, '0'),
(54, 'EEST', '5340646800', 10800, '1'),
(54, 'EET', '5358790800', 7200, '0'),
(54, 'EEST', '5372096400', 10800, '1'),
(54, 'EET', '5390845200', 7200, '0'),
(54, 'EEST', '5403546000', 10800, '1'),
(54, 'EET', '5422294800', 7200, '0'),
(54, 'EEST', '5434995600', 10800, '1'),
(54, 'EET', '5453744400', 7200, '0'),
(54, 'EEST', '5467050000', 10800, '1'),
(54, 'EET', '5485194000', 7200, '0'),
(54, 'EEST', '5498499600', 10800, '1'),
(54, 'EET', '5516643600', 7200, '0'),
(54, 'EEST', '5529949200', 10800, '1'),
(54, 'EET', '5548698000', 7200, '0'),
(54, 'EEST', '5561398800', 10800, '1'),
(54, 'EET', '5580147600', 7200, '0'),
(54, 'EEST', '5592848400', 10800, '1'),
(54, 'EET', '5611597200', 7200, '0'),
(54, 'EEST', '5624902800', 10800, '1'),
(54, 'EET', '5643046800', 7200, '0'),
(54, 'EEST', '5656352400', 10800, '1'),
(54, 'EET', '5674496400', 7200, '0'),
(54, 'EEST', '5687802000', 10800, '1'),
(54, 'EET', '5705946000', 7200, '0'),
(54, 'EEST', '5719251600', 10800, '1'),
(54, 'EET', '5738000400', 7200, '0'),
(54, 'EEST', '5750701200', 10800, '1'),
(54, 'EET', '5769450000', 7200, '0'),
(54, 'EEST', '5782150800', 10800, '1'),
(54, 'EET', '5800899600', 7200, '0'),
(54, 'EEST', '5814205200', 10800, '1'),
(54, 'EET', '5832349200', 7200, '0'),
(54, 'EEST', '5845654800', 10800, '1'),
(54, 'EET', '5863798800', 7200, '0'),
(54, 'EEST', '5877104400', 10800, '1'),
(54, 'EET', '5895853200', 7200, '0'),
(54, 'EEST', '5908554000', 10800, '1'),
(54, 'EET', '5927302800', 7200, '0'),
(54, 'EEST', '5940003600', 10800, '1'),
(54, 'EET', '5958752400', 7200, '0'),
(54, 'EEST', '5971453200', 10800, '1'),
(54, 'EET', '5990202000', 7200, '0'),
(54, 'EEST', '6003507600', 10800, '1'),
(54, 'EET', '6021651600', 7200, '0'),
(54, 'EEST', '6034957200', 10800, '1'),
(54, 'EET', '6053101200', 7200, '0'),
(54, 'EEST', '6066406800', 10800, '1'),
(54, 'EET', '6085155600', 7200, '0'),
(54, 'EEST', '6097856400', 10800, '1'),
(54, 'EET', '6116605200', 7200, '0'),
(54, 'EEST', '6129306000', 10800, '1'),
(54, 'EET', '6148054800', 7200, '0'),
(54, 'EEST', '6161360400', 10800, '1'),
(54, 'EET', '6179504400', 7200, '0'),
(54, 'EEST', '6192810000', 10800, '1'),
(54, 'EET', '6210954000', 7200, '0'),
(54, 'EEST', '6224259600', 10800, '1'),
(54, 'EET', '6242403600', 7200, '0'),
(54, 'EEST', '6255709200', 10800, '1'),
(54, 'EET', '6274458000', 7200, '0'),
(54, 'EEST', '6287158800', 10800, '1'),
(54, 'EET', '6305907600', 7200, '0'),
(54, 'EEST', '6318608400', 10800, '1'),
(54, 'EET', '6337357200', 7200, '0'),
(54, 'EEST', '6350662800', 10800, '1'),
(54, 'EET', '6368806800', 7200, '0'),
(54, 'EEST', '6382112400', 10800, '1'),
(54, 'EET', '6400256400', 7200, '0'),
(54, 'EEST', '6413562000', 10800, '1'),
(54, 'EET', '6432310800', 7200, '0'),
(54, 'EEST', '6445011600', 10800, '1'),
(54, 'EET', '6463760400', 7200, '0'),
(54, 'EEST', '6476461200', 10800, '1'),
(54, 'EET', '6495210000', 7200, '0'),
(54, 'EEST', '6508515600', 10800, '1'),
(54, 'EET', '6526659600', 7200, '0'),
(54, 'EEST', '6539965200', 10800, '1'),
(54, 'EET', '6558109200', 7200, '0'),
(54, 'EEST', '6571414800', 10800, '1'),
(54, 'EET', '6589558800', 7200, '0'),
(54, 'EEST', '6602864400', 10800, '1'),
(54, 'EET', '6621613200', 7200, '0'),
(54, 'EEST', '6634314000', 10800, '1'),
(54, 'EET', '6653062800', 7200, '0'),
(54, 'EEST', '6665763600', 10800, '1'),
(54, 'EET', '6684512400', 7200, '0'),
(54, 'EEST', '6697818000', 10800, '1'),
(54, 'EET', '6715962000', 7200, '0'),
(54, 'EEST', '6729267600', 10800, '1'),
(54, 'EET', '6747411600', 7200, '0'),
(54, 'EEST', '6760717200', 10800, '1'),
(54, 'EET', '6779466000', 7200, '0'),
(54, 'EEST', '6792166800', 10800, '1'),
(54, 'EET', '6810915600', 7200, '0'),
(54, 'EEST', '6823616400', 10800, '1'),
(54, 'EET', '6842365200', 7200, '0'),
(54, 'EEST', '6855066000', 10800, '1'),
(54, 'EET', '6873814800', 7200, '0'),
(54, 'EEST', '6887120400', 10800, '1'),
(54, 'EET', '6905264400', 7200, '0'),
(54, 'EEST', '6918570000', 10800, '1'),
(54, 'EET', '6936714000', 7200, '0'),
(54, 'EEST', '6950019600', 10800, '1'),
(54, 'EET', '6968768400', 7200, '0'),
(54, 'EEST', '6981469200', 10800, '1'),
(54, 'EET', '7000218000', 7200, '0'),
(54, 'EEST', '7012918800', 10800, '1'),
(54, 'EET', '7031667600', 7200, '0'),
(54, 'EEST', '7044973200', 10800, '1'),
(54, 'EET', '7063117200', 7200, '0'),
(54, 'EEST', '7076422800', 10800, '1'),
(54, 'EET', '7094566800', 7200, '0'),
(54, 'EEST', '7107872400', 10800, '1'),
(54, 'EET', '7126016400', 7200, '0'),
(54, 'EEST', '7139322000', 10800, '1'),
(54, 'EET', '7158070800', 7200, '0'),
(54, 'EEST', '7170771600', 10800, '1'),
(54, 'EET', '7189520400', 7200, '0'),
(54, 'EEST', '7202221200', 10800, '1'),
(54, 'EET', '7220970000', 7200, '0'),
(54, 'EEST', '7234275600', 10800, '1'),
(54, 'EET', '7252419600', 7200, '0'),
(54, 'EEST', '7265725200', 10800, '1'),
(54, 'EET', '7283869200', 7200, '0'),
(54, 'EEST', '7297174800', 10800, '1'),
(54, 'EET', '7315318800', 7200, '0'),
(54, 'EEST', '7328624400', 10800, '1'),
(54, 'EET', '7347373200', 7200, '0'),
(54, 'EEST', '7360074000', 10800, '1'),
(54, 'EET', '7378822800', 7200, '0'),
(54, 'EEST', '7391523600', 10800, '1'),
(54, 'EET', '7410272400', 7200, '0'),
(54, 'EEST', '7423578000', 10800, '1'),
(54, 'EET', '7441722000', 7200, '0'),
(54, 'EEST', '7455027600', 10800, '1'),
(54, 'EET', '7473171600', 7200, '0'),
(54, 'EEST', '7486477200', 10800, '1'),
(54, 'EET', '7504621200', 7200, '0'),
(54, 'EEST', '7517926800', 10800, '1'),
(54, 'EET', '7536675600', 7200, '0'),
(54, 'EEST', '7549376400', 10800, '1'),
(54, 'EET', '7568125200', 7200, '0'),
(54, 'EEST', '7580826000', 10800, '1'),
(54, 'EET', '7599574800', 7200, '0'),
(54, 'EEST', '7612880400', 10800, '1'),
(54, 'EET', '7631024400', 7200, '0'),
(54, 'EEST', '7644330000', 10800, '1'),
(54, 'EET', '7662474000', 7200, '0'),
(54, 'EEST', '7675779600', 10800, '1'),
(54, 'EET', '7694528400', 7200, '0'),
(54, 'EEST', '7707229200', 10800, '1'),
(54, 'EET', '7725978000', 7200, '0'),
(54, 'EEST', '7738678800', 10800, '1'),
(54, 'EET', '7757427600', 7200, '0'),
(54, 'EEST', '7770733200', 10800, '1'),
(54, 'EET', '7788877200', 7200, '0'),
(54, 'EEST', '7802182800', 10800, '1'),
(54, 'EET', '7820326800', 7200, '0'),
(54, 'EEST', '7833632400', 10800, '1'),
(54, 'EET', '7851776400', 7200, '0'),
(54, 'EEST', '7865082000', 10800, '1'),
(54, 'EET', '7883830800', 7200, '0'),
(54, 'EEST', '7896531600', 10800, '1'),
(54, 'EET', '7915280400', 7200, '0'),
(54, 'EEST', '7927981200', 10800, '1'),
(54, 'EET', '7946730000', 7200, '0'),
(54, 'EEST', '7960035600', 10800, '1'),
(54, 'EET', '7978179600', 7200, '0'),
(54, 'EEST', '7991485200', 10800, '1'),
(54, 'EET', '8009629200', 7200, '0'),
(54, 'EEST', '8022934800', 10800, '1'),
(54, 'EET', '8041683600', 7200, '0'),
(54, 'EEST', '8054384400', 10800, '1'),
(54, 'EET', '8073133200', 7200, '0'),
(54, 'EEST', '8085834000', 10800, '1'),
(54, 'EET', '8104582800', 7200, '0'),
(54, 'EEST', '8117283600', 10800, '1'),
(54, 'EET', '8136032400', 7200, '0'),
(54, 'EEST', '8149338000', 10800, '1'),
(54, 'EET', '8167482000', 7200, '0'),
(54, 'EEST', '8180787600', 10800, '1'),
(54, 'EET', '8198931600', 7200, '0'),
(54, 'EEST', '8212237200', 10800, '1'),
(54, 'EET', '8230986000', 7200, '0'),
(54, 'EEST', '8243686800', 10800, '1'),
(54, 'EET', '8262435600', 7200, '0'),
(54, 'EEST', '8275136400', 10800, '1'),
(54, 'EET', '8293885200', 7200, '0'),
(54, 'EEST', '8307190800', 10800, '1'),
(54, 'EET', '8325334800', 7200, '0'),
(54, 'EEST', '8338640400', 10800, '1'),
(54, 'EET', '8356784400', 7200, '0'),
(54, 'EEST', '8370090000', 10800, '1'),
(54, 'EET', '8388234000', 7200, '0'),
(54, 'EEST', '8401539600', 10800, '1'),
(54, 'EET', '8420288400', 7200, '0'),
(54, 'EEST', '8432989200', 10800, '1'),
(54, 'EET', '8451738000', 7200, '0'),
(54, 'EEST', '8464438800', 10800, '1'),
(54, 'EET', '8483187600', 7200, '0'),
(54, 'EEST', '8496493200', 10800, '1'),
(54, 'EET', '8514637200', 7200, '0'),
(54, 'EEST', '8527942800', 10800, '1'),
(54, 'EET', '8546086800', 7200, '0'),
(54, 'EEST', '8559392400', 10800, '1'),
(54, 'EET', '8578141200', 7200, '0'),
(54, 'EEST', '8590842000', 10800, '1'),
(54, 'EET', '8609590800', 7200, '0'),
(54, 'EEST', '8622291600', 10800, '1'),
(54, 'EET', '8641040400', 7200, '0'),
(54, 'EEST', '8654346000', 10800, '1'),
(54, 'EET', '8672490000', 7200, '0'),
(54, 'EEST', '8685795600', 10800, '1'),
(54, 'EET', '8703939600', 7200, '0'),
(54, 'EEST', '8717245200', 10800, '1'),
(54, 'EET', '8735389200', 7200, '0'),
(54, 'EEST', '8748694800', 10800, '1'),
(54, 'EET', '8767443600', 7200, '0'),
(54, 'EEST', '8780144400', 10800, '1'),
(54, 'EET', '8798893200', 7200, '0'),
(54, 'EEST', '8811594000', 10800, '1'),
(54, 'EET', '8830342800', 7200, '0'),
(54, 'EEST', '8843648400', 10800, '1'),
(54, 'EET', '8861792400', 7200, '0'),
(54, 'EEST', '8875098000', 10800, '1'),
(54, 'EET', '8893242000', 7200, '0'),
(54, 'EEST', '8906547600', 10800, '1'),
(54, 'EET', '8925296400', 7200, '0'),
(54, 'EEST', '8937997200', 10800, '1'),
(54, 'EET', '8956746000', 7200, '0'),
(54, 'EEST', '8969446800', 10800, '1'),
(54, 'EET', '8988195600', 7200, '0'),
(54, 'EEST', '9000896400', 10800, '1'),
(54, 'EET', '9019645200', 7200, '0'),
(54, 'EEST', '9032950800', 10800, '1'),
(54, 'EET', '9051094800', 7200, '0'),
(54, 'EEST', '9064400400', 10800, '1'),
(54, 'EET', '9082544400', 7200, '0'),
(54, 'EEST', '9095850000', 10800, '1'),
(54, 'EET', '9114598800', 7200, '0'),
(54, 'EEST', '9127299600', 10800, '1'),
(54, 'EET', '9146048400', 7200, '0'),
(54, 'EEST', '9158749200', 10800, '1'),
(54, 'EET', '9177498000', 7200, '0'),
(54, 'EEST', '9190803600', 10800, '1'),
(54, 'EET', '9208947600', 7200, '0'),
(54, 'EEST', '9222253200', 10800, '1'),
(54, 'EET', '9240397200', 7200, '0'),
(54, 'EEST', '9253702800', 10800, '1'),
(54, 'EET', '9271846800', 7200, '0'),
(54, 'EEST', '9285152400', 10800, '1'),
(54, 'EET', '9303901200', 7200, '0'),
(54, 'EEST', '9316602000', 10800, '1'),
(54, 'EET', '9335350800', 7200, '0'),
(54, 'EEST', '9348051600', 10800, '1'),
(54, 'EET', '9366800400', 7200, '0'),
(54, 'EEST', '9380106000', 10800, '1'),
(54, 'EET', '9398250000', 7200, '0'),
(54, 'EEST', '9411555600', 10800, '1'),
(54, 'EET', '9429699600', 7200, '0'),
(54, 'EEST', '9443005200', 10800, '1'),
(54, 'EET', '9461754000', 7200, '0'),
(54, 'EEST', '9474454800', 10800, '1'),
(54, 'EET', '9493203600', 7200, '0'),
(54, 'EEST', '9505904400', 10800, '1'),
(54, 'EET', '9524653200', 7200, '0'),
(54, 'EEST', '9537958800', 10800, '1'),
(54, 'EET', '9556102800', 7200, '0'),
(54, 'EEST', '9569408400', 10800, '1'),
(54, 'EET', '9587552400', 7200, '0'),
(54, 'EEST', '9600858000', 10800, '1'),
(54, 'EET', '9619002000', 7200, '0'),
(54, 'EEST', '9632307600', 10800, '1'),
(54, 'EET', '9651056400', 7200, '0'),
(54, 'EEST', '9663757200', 10800, '1'),
(54, 'EET', '9682506000', 7200, '0'),
(54, 'EEST', '9695206800', 10800, '1'),
(54, 'EET', '9713955600', 7200, '0'),
(54, 'EEST', '9727261200', 10800, '1'),
(54, 'EET', '9745405200', 7200, '0'),
(54, 'EEST', '9758710800', 10800, '1'),
(54, 'EET', '9776854800', 7200, '0'),
(54, 'EEST', '9790160400', 10800, '1'),
(54, 'EET', '9808909200', 7200, '0'),
(54, 'EEST', '9821610000', 10800, '1'),
(54, 'EET', '9840358800', 7200, '0'),
(54, 'EEST', '9853059600', 10800, '1'),
(54, 'EET', '9871808400', 7200, '0'),
(54, 'EEST', '9884509200', 10800, '1'),
(54, 'EET', '9903258000', 7200, '0'),
(54, 'EEST', '9916563600', 10800, '1'),
(54, 'EET', '9934707600', 7200, '0'),
(54, 'EEST', '9948013200', 10800, '1'),
(54, 'EET', '9966157200', 7200, '0'),
(54, 'EEST', '9979462800', 10800, '1'),
(54, 'EET', '9998211600', 7200, '0'),
(54, 'EEST', '10010912400', 10800, '1'),
(54, 'EET', '10029661200', 7200, '0'),
(54, 'EEST', '10042362000', 10800, '1'),
(54, 'EET', '10061110800', 7200, '0'),
(54, 'EEST', '10074416400', 10800, '1'),
(54, 'EET', '10092560400', 7200, '0'),
(54, 'EEST', '10105866000', 10800, '1'),
(54, 'EET', '10124010000', 7200, '0'),
(54, 'EEST', '10137315600', 10800, '1'),
(54, 'EET', '10155459600', 7200, '0'),
(54, 'EEST', '10168765200', 10800, '1'),
(54, 'EET', '10187514000', 7200, '0'),
(54, 'EEST', '10200214800', 10800, '1'),
(54, 'EET', '10218963600', 7200, '0'),
(54, 'EEST', '10231664400', 10800, '1'),
(54, 'EET', '10250413200', 7200, '0'),
(54, 'EEST', '10263718800', 10800, '1'),
(54, 'EET', '10281862800', 7200, '0'),
(54, 'EEST', '10295168400', 10800, '1'),
(54, 'EET', '10313312400', 7200, '0'),
(54, 'EEST', '10326618000', 10800, '1'),
(54, 'EET', '10345366800', 7200, '0'),
(54, 'EEST', '10358067600', 10800, '1'),
(54, 'EET', '10376816400', 7200, '0'),
(54, 'EEST', '10389517200', 10800, '1'),
(54, 'EET', '10408266000', 7200, '0'),
(54, 'EEST', '10420966800', 10800, '1'),
(54, 'EET', '10439715600', 7200, '0'),
(54, 'EEST', '10453021200', 10800, '1'),
(54, 'EET', '10471165200', 7200, '0'),
(54, 'EEST', '10484470800', 10800, '1'),
(54, 'EET', '10502614800', 7200, '0'),
(54, 'EEST', '10515920400', 10800, '1'),
(54, 'EET', '10534064400', 7200, '0'),
(54, 'EEST', '10547370000', 10800, '1'),
(54, 'EET', '10566118800', 7200, '0'),
(54, 'EEST', '10578819600', 10800, '1'),
(54, 'EET', '10597568400', 7200, '0'),
(54, 'EEST', '10610269200', 10800, '1'),
(54, 'EET', '10629018000', 7200, '0'),
(54, 'EEST', '10642323600', 10800, '1'),
(54, 'EET', '10660467600', 7200, '0'),
(54, 'EEST', '10673773200', 10800, '1'),
(54, 'EET', '10691917200', 7200, '0'),
(54, 'EEST', '10705222800', 10800, '1'),
(54, 'EET', '10723971600', 7200, '0'),
(54, 'EEST', '10736672400', 10800, '1'),
(54, 'EET', '10755421200', 7200, '0'),
(54, 'EEST', '10768122000', 10800, '1'),
(54, 'EET', '10786870800', 7200, '0'),
(54, 'EEST', '10800176400', 10800, '1'),
(54, 'EET', '10818320400', 7200, '0'),
(54, 'EEST', '10831626000', 10800, '1'),
(54, 'EET', '10849770000', 7200, '0'),
(54, 'EEST', '10863075600', 10800, '1'),
(54, 'EET', '10881219600', 7200, '0'),
(54, 'EEST', '10894525200', 10800, '1'),
(54, 'EET', '10913274000', 7200, '0'),
(54, 'EEST', '10925974800', 10800, '1'),
(54, 'EET', '10944723600', 7200, '0'),
(54, 'EEST', '10957424400', 10800, '1'),
(54, 'EET', '10976173200', 7200, '0'),
(54, 'EEST', '10989478800', 10800, '1'),
(54, 'EET', '11007622800', 7200, '0'),
(54, 'EEST', '11020928400', 10800, '1'),
(54, 'EET', '11039072400', 7200, '0'),
(54, 'EEST', '11052378000', 10800, '1'),
(54, 'EET', '11071126800', 7200, '0'),
(54, 'EEST', '11083827600', 10800, '1'),
(54, 'EET', '11102576400', 7200, '0'),
(54, 'EEST', '11115277200', 10800, '1'),
(54, 'EET', '11134026000', 7200, '0'),
(54, 'EEST', '11146726800', 10800, '1'),
(54, 'EET', '11165475600', 7200, '0'),
(54, 'EEST', '11178781200', 10800, '1'),
(54, 'EET', '11196925200', 7200, '0'),
(54, 'EEST', '11210230800', 10800, '1'),
(54, 'EET', '11228374800', 7200, '0'),
(54, 'EEST', '11241680400', 10800, '1'),
(54, 'EET', '11260429200', 7200, '0'),
(54, 'EEST', '11273130000', 10800, '1'),
(54, 'EET', '11291878800', 7200, '0'),
(54, 'EEST', '11304579600', 10800, '1'),
(54, 'EET', '11323328400', 7200, '0'),
(54, 'EEST', '11336634000', 10800, '1'),
(54, 'EET', '11354778000', 7200, '0'),
(54, 'EEST', '11368083600', 10800, '1'),
(54, 'EET', '11386227600', 7200, '0'),
(54, 'EEST', '11399533200', 10800, '1'),
(54, 'EET', '11417677200', 7200, '0'),
(54, 'EEST', '11430982800', 10800, '1'),
(54, 'EET', '11449731600', 7200, '0'),
(54, 'EEST', '11462432400', 10800, '1'),
(54, 'EET', '11481181200', 7200, '0'),
(54, 'EEST', '11493882000', 10800, '1'),
(54, 'EET', '11512630800', 7200, '0'),
(54, 'EEST', '11525936400', 10800, '1'),
(54, 'EET', '11544080400', 7200, '0'),
(54, 'EEST', '11557386000', 10800, '1'),
(54, 'EET', '11575530000', 7200, '0'),
(54, 'EEST', '11588835600', 10800, '1'),
(54, 'EET', '11607584400', 7200, '0'),
(54, 'EEST', '11620285200', 10800, '1'),
(54, 'EET', '11639034000', 7200, '0'),
(54, 'EEST', '11651734800', 10800, '1'),
(54, 'EET', '11670483600', 7200, '0'),
(54, 'EEST', '11683789200', 10800, '1'),
(54, 'EET', '11701933200', 7200, '0'),
(54, 'EEST', '11715238800', 10800, '1'),
(54, 'EET', '11733382800', 7200, '0'),
(54, 'EEST', '11746688400', 10800, '1'),
(54, 'EET', '11764832400', 7200, '0'),
(54, 'EEST', '11778138000', 10800, '1'),
(54, 'EET', '11796886800', 7200, '0'),
(54, 'EEST', '11809587600', 10800, '1'),
(54, 'EET', '11828336400', 7200, '0'),
(54, 'EEST', '11841037200', 10800, '1'),
(54, 'EET', '11859786000', 7200, '0'),
(54, 'EEST', '11873091600', 10800, '1'),
(54, 'EET', '11891235600', 7200, '0'),
(54, 'EEST', '11904541200', 10800, '1'),
(54, 'EET', '11922685200', 7200, '0'),
(54, 'EEST', '11935990800', 10800, '1'),
(54, 'EET', '11954739600', 7200, '0'),
(54, 'EEST', '11967440400', 10800, '1'),
(54, 'EET', '11986189200', 7200, '0'),
(54, 'EEST', '11998890000', 10800, '1'),
(54, 'EET', '12017638800', 7200, '0'),
(54, 'EEST', '12030339600', 10800, '1'),
(54, 'EET', '12049088400', 7200, '0'),
(54, 'EEST', '12062394000', 10800, '1'),
(54, 'EET', '12080538000', 7200, '0'),
(54, 'EEST', '12093843600', 10800, '1'),
(54, 'EET', '12111987600', 7200, '0'),
(54, 'EEST', '12125293200', 10800, '1'),
(54, 'EET', '12144042000', 7200, '0'),
(54, 'EEST', '12156742800', 10800, '1'),
(54, 'EET', '12175491600', 7200, '0'),
(54, 'EEST', '12188192400', 10800, '1'),
(54, 'EET', '12206941200', 7200, '0'),
(54, 'EEST', '12220246800', 10800, '1'),
(54, 'EET', '12238390800', 7200, '0'),
(54, 'EEST', '12251696400', 10800, '1'),
(54, 'EET', '12269840400', 7200, '0'),
(54, 'EEST', '12283146000', 10800, '1'),
(54, 'EET', '12301290000', 7200, '0'),
(54, 'EEST', '12314595600', 10800, '1'),
(54, 'EET', '12333344400', 7200, '0'),
(54, 'EEST', '12346045200', 10800, '1'),
(54, 'EET', '12364794000', 7200, '0'),
(54, 'EEST', '12377494800', 10800, '1'),
(54, 'EET', '12396243600', 7200, '0'),
(54, 'EEST', '12409549200', 10800, '1'),
(54, 'EET', '12427693200', 7200, '0'),
(54, 'EEST', '12440998800', 10800, '1'),
(54, 'EET', '12459142800', 7200, '0'),
(54, 'EEST', '12472448400', 10800, '1'),
(54, 'EET', '12491197200', 7200, '0'),
(54, 'EEST', '12503898000', 10800, '1'),
(54, 'EET', '12522646800', 7200, '0'),
(54, 'EEST', '12535347600', 10800, '1'),
(54, 'EET', '12554096400', 7200, '0'),
(54, 'EEST', '12567402000', 10800, '1'),
(54, 'EET', '12585546000', 7200, '0'),
(54, 'EEST', '12598851600', 10800, '1'),
(54, 'EET', '12616995600', 7200, '0'),
(54, 'EEST', '12630301200', 10800, '1'),
(54, 'EET', '12648445200', 7200, '0'),
(54, 'EEST', '12661750800', 10800, '1'),
(54, 'EET', '12680499600', 7200, '0'),
(54, 'EEST', '12693200400', 10800, '1'),
(54, 'EET', '12711949200', 7200, '0'),
(54, 'EEST', '12724650000', 10800, '1'),
(54, 'EET', '12743398800', 7200, '0'),
(54, 'EEST', '12756704400', 10800, '1'),
(54, 'EET', '12774848400', 7200, '0'),
(54, 'EEST', '12788154000', 10800, '1'),
(54, 'EET', '12806298000', 7200, '0'),
(54, 'EEST', '12819603600', 10800, '1'),
(54, 'EET', '12838352400', 7200, '0'),
(54, 'EEST', '12851053200', 10800, '1'),
(54, 'EET', '12869802000', 7200, '0'),
(54, 'EEST', '12882502800', 10800, '1'),
(54, 'EET', '12901251600', 7200, '0'),
(54, 'EEST', '12913952400', 10800, '1'),
(54, 'EET', '12932701200', 7200, '0'),
(54, 'EEST', '12946006800', 10800, '1'),
(54, 'EET', '12964150800', 7200, '0'),
(54, 'EEST', '12977456400', 10800, '1'),
(54, 'EET', '12995600400', 7200, '0'),
(54, 'EEST', '13008906000', 10800, '1'),
(54, 'EET', '13027654800', 7200, '0'),
(54, 'EEST', '13040355600', 10800, '1'),
(54, 'EET', '13059104400', 7200, '0'),
(54, 'EEST', '13071805200', 10800, '1'),
(54, 'EET', '13090554000', 7200, '0'),
(54, 'EEST', '13103859600', 10800, '1'),
(54, 'EET', '13122003600', 7200, '0'),
(54, 'EEST', '13135309200', 10800, '1'),
(54, 'EET', '13153453200', 7200, '0'),
(54, 'EEST', '13166758800', 10800, '1'),
(54, 'EET', '13184902800', 7200, '0'),
(54, 'EEST', '13198208400', 10800, '1'),
(54, 'EET', '13216957200', 7200, '0'),
(54, 'EEST', '13229658000', 10800, '1'),
(54, 'EET', '13248406800', 7200, '0'),
(54, 'EEST', '13261107600', 10800, '1'),
(54, 'EET', '13279856400', 7200, '0'),
(54, 'EEST', '13293162000', 10800, '1'),
(54, 'EET', '13311306000', 7200, '0'),
(54, 'EEST', '13324611600', 10800, '1'),
(54, 'EET', '13342755600', 7200, '0'),
(54, 'EEST', '13356061200', 10800, '1'),
(54, 'EET', '13374810000', 7200, '0'),
(54, 'EEST', '13387510800', 10800, '1'),
(54, 'EET', '13406259600', 7200, '0'),
(54, 'EEST', '13418960400', 10800, '1'),
(54, 'EET', '13437709200', 7200, '0'),
(54, 'EEST', '13451014800', 10800, '1'),
(54, 'EET', '13469158800', 7200, '0'),
(54, 'EEST', '13482464400', 10800, '1'),
(54, 'EET', '13500608400', 7200, '0'),
(54, 'EEST', '13513914000', 10800, '1'),
(54, 'EET', '13532058000', 7200, '0'),
(54, 'EEST', '13545363600', 10800, '1'),
(54, 'EET', '13564112400', 7200, '0'),
(54, 'EEST', '13576813200', 10800, '1'),
(54, 'EET', '13595562000', 7200, '0'),
(54, 'EEST', '13608262800', 10800, '1'),
(54, 'EET', '13627011600', 7200, '0'),
(54, 'EEST', '13640317200', 10800, '1'),
(54, 'EET', '13658461200', 7200, '0'),
(54, 'EEST', '13671766800', 10800, '1'),
(54, 'EET', '13689910800', 7200, '0'),
(54, 'EEST', '13703216400', 10800, '1'),
(54, 'EET', '13721965200', 7200, '0'),
(54, 'EEST', '13734666000', 10800, '1'),
(54, 'EET', '13753414800', 7200, '0'),
(54, 'EEST', '13766115600', 10800, '1'),
(54, 'EET', '13784864400', 7200, '0'),
(54, 'EEST', '13797565200', 10800, '1'),
(54, 'EET', '13816314000', 7200, '0'),
(54, 'EEST', '13829619600', 10800, '1'),
(54, 'EET', '13847763600', 7200, '0'),
(54, 'EEST', '13861069200', 10800, '1'),
(54, 'EET', '13879213200', 7200, '0'),
(54, 'EEST', '13892518800', 10800, '1'),
(54, 'EET', '13911267600', 7200, '0'),
(54, 'EEST', '13923968400', 10800, '1'),
(54, 'EET', '13942717200', 7200, '0'),
(54, 'EEST', '13955418000', 10800, '1'),
(54, 'EET', '13974166800', 7200, '0'),
(54, 'EEST', '13987472400', 10800, '1'),
(54, 'EET', '14005616400', 7200, '0'),
(54, 'EEST', '14018922000', 10800, '1'),
(54, 'EET', '14037066000', 7200, '0'),
(54, 'EEST', '14050371600', 10800, '1'),
(54, 'EET', '14068515600', 7200, '0'),
(54, 'EEST', '14081821200', 10800, '1'),
(54, 'EET', '14100570000', 7200, '0'),
(54, 'EEST', '14113270800', 10800, '1'),
(54, 'EET', '14132019600', 7200, '0'),
(54, 'EEST', '14144720400', 10800, '1'),
(54, 'EET', '14163469200', 7200, '0'),
(54, 'EEST', '14176774800', 10800, '1'),
(54, 'EET', '14194918800', 7200, '0'),
(54, 'EEST', '14208224400', 10800, '1'),
(54, 'EET', '14226368400', 7200, '0'),
(54, 'EEST', '14239674000', 10800, '1'),
(54, 'EET', '14258422800', 7200, '0'),
(54, 'EEST', '14271123600', 10800, '1'),
(54, 'EET', '14289872400', 7200, '0'),
(54, 'EEST', '14302573200', 10800, '1'),
(54, 'EET', '14321322000', 7200, '0'),
(54, 'EEST', '14334627600', 10800, '1'),
(54, 'EET', '14352771600', 7200, '0'),
(54, 'EEST', '14366077200', 10800, '1'),
(54, 'EET', '14384221200', 7200, '0'),
(54, 'EEST', '14397526800', 10800, '1'),
(54, 'EET', '14415670800', 7200, '0'),
(54, 'EEST', '14428976400', 10800, '1'),
(54, 'EET', '14447725200', 7200, '0'),
(54, 'EEST', '14460426000', 10800, '1'),
(54, 'EET', '14479174800', 7200, '0'),
(54, 'EEST', '14491875600', 10800, '1'),
(54, 'EET', '14510624400', 7200, '0'),
(54, 'EEST', '14523930000', 10800, '1'),
(54, 'EET', '14542074000', 7200, '0'),
(54, 'EEST', '14555379600', 10800, '1'),
(54, 'EET', '14573523600', 7200, '0'),
(54, 'EEST', '14586829200', 10800, '1'),
(54, 'EET', '14605578000', 7200, '0'),
(54, 'EEST', '14618278800', 10800, '1'),
(54, 'EET', '14637027600', 7200, '0'),
(54, 'EEST', '14649728400', 10800, '1'),
(54, 'EET', '14668477200', 7200, '0'),
(54, 'EEST', '14681178000', 10800, '1'),
(54, 'EET', '14699926800', 7200, '0'),
(54, 'EEST', '14713232400', 10800, '1'),
(54, 'EET', '14731376400', 7200, '0'),
(54, 'EEST', '14744682000', 10800, '1'),
(54, 'EET', '14762826000', 7200, '0'),
(54, 'EEST', '14776131600', 10800, '1'),
(54, 'EET', '14794880400', 7200, '0'),
(54, 'EEST', '14807581200', 10800, '1'),
(54, 'EET', '14826330000', 7200, '0'),
(54, 'EEST', '14839030800', 10800, '1'),
(54, 'EET', '14857779600', 7200, '0'),
(54, 'EEST', '14871085200', 10800, '1'),
(54, 'EET', '14889229200', 7200, '0'),
(54, 'EEST', '14902534800', 10800, '1'),
(54, 'EET', '14920678800', 7200, '0'),
(54, 'EEST', '14933984400', 10800, '1'),
(54, 'EET', '14952128400', 7200, '0'),
(54, 'EEST', '14965434000', 10800, '1'),
(54, 'EET', '14984182800', 7200, '0'),
(54, 'EEST', '14996883600', 10800, '1'),
(54, 'EET', '15015632400', 7200, '0'),
(54, 'EEST', '15028333200', 10800, '1'),
(54, 'EET', '15047082000', 7200, '0'),
(54, 'EEST', '15060387600', 10800, '1'),
(54, 'EET', '15078531600', 7200, '0'),
(54, 'EEST', '15091837200', 10800, '1'),
(54, 'EET', '15109981200', 7200, '0'),
(54, 'EEST', '15123286800', 10800, '1'),
(54, 'EET', '15142035600', 7200, '0'),
(54, 'EEST', '15154736400', 10800, '1'),
(54, 'EET', '15173485200', 7200, '0'),
(54, 'EEST', '15186186000', 10800, '1'),
(54, 'EET', '15204934800', 7200, '0'),
(54, 'EEST', '15218240400', 10800, '1'),
(54, 'EET', '15236384400', 7200, '0'),
(54, 'EEST', '15249690000', 10800, '1'),
(54, 'EET', '15267834000', 7200, '0'),
(54, 'EEST', '15281139600', 10800, '1'),
(54, 'EET', '15299283600', 7200, '0'),
(54, 'EEST', '15312589200', 10800, '1'),
(54, 'EET', '15331338000', 7200, '0'),
(54, 'EEST', '15344038800', 10800, '1'),
(54, 'EET', '15362787600', 7200, '0'),
(54, 'EEST', '15375488400', 10800, '1'),
(54, 'EET', '15394237200', 7200, '0'),
(54, 'EEST', '15407542800', 10800, '1'),
(54, 'EET', '15425686800', 7200, '0'),
(54, 'EEST', '15438992400', 10800, '1'),
(54, 'EET', '15457136400', 7200, '0'),
(54, 'EEST', '15470442000', 10800, '1'),
(54, 'EET', '15489190800', 7200, '0'),
(54, 'EEST', '15501891600', 10800, '1'),
(54, 'EET', '15520640400', 7200, '0'),
(54, 'EEST', '15533341200', 10800, '1'),
(54, 'EET', '15552090000', 7200, '0'),
(54, 'EEST', '15564790800', 10800, '1'),
(54, 'EET', '15583539600', 7200, '0'),
(54, 'EEST', '15596845200', 10800, '1'),
(54, 'EET', '15614989200', 7200, '0'),
(54, 'EEST', '15628294800', 10800, '1'),
(54, 'EET', '15646438800', 7200, '0'),
(54, 'EEST', '15659744400', 10800, '1'),
(54, 'EET', '15678493200', 7200, '0'),
(54, 'EEST', '15691194000', 10800, '1'),
(54, 'EET', '15709942800', 7200, '0'),
(54, 'EEST', '15722643600', 10800, '1'),
(54, 'EET', '15741392400', 7200, '0'),
(54, 'EEST', '15754698000', 10800, '1'),
(54, 'EET', '15772842000', 7200, '0'),
(54, 'EEST', '15786147600', 10800, '1'),
(54, 'EET', '15804291600', 7200, '0'),
(54, 'EEST', '15817597200', 10800, '1'),
(54, 'EET', '15835741200', 7200, '0'),
(54, 'EEST', '15849046800', 10800, '1'),
(54, 'EET', '15867795600', 7200, '0'),
(54, 'EEST', '15880496400', 10800, '1'),
(54, 'EET', '15899245200', 7200, '0'),
(54, 'EEST', '15911946000', 10800, '1'),
(54, 'EET', '15930694800', 7200, '0'),
(54, 'EEST', '15944000400', 10800, '1'),
(54, 'EET', '15962144400', 7200, '0'),
(54, 'EEST', '15975450000', 10800, '1'),
(54, 'EET', '15993594000', 7200, '0'),
(54, 'EEST', '16006899600', 10800, '1'),
(54, 'EET', '16025648400', 7200, '0'),
(54, 'EEST', '16038349200', 10800, '1'),
(54, 'EET', '16057098000', 7200, '0'),
(54, 'EEST', '16069798800', 10800, '1'),
(54, 'EET', '16088547600', 7200, '0'),
(54, 'EEST', '16101853200', 10800, '1'),
(54, 'EET', '16119997200', 7200, '0'),
(54, 'EEST', '16133302800', 10800, '1'),
(54, 'EET', '16151446800', 7200, '0'),
(54, 'EEST', '16164752400', 10800, '1'),
(54, 'EET', '16182896400', 7200, '0'),
(54, 'EEST', '16196202000', 10800, '1'),
(54, 'EET', '16214950800', 7200, '0'),
(54, 'EEST', '16227651600', 10800, '1'),
(54, 'EET', '16246400400', 7200, '0'),
(54, 'EEST', '16259101200', 10800, '1'),
(54, 'EET', '16277850000', 7200, '0'),
(54, 'EEST', '16291155600', 10800, '1'),
(54, 'EET', '16309299600', 7200, '0'),
(54, 'EEST', '16322605200', 10800, '1'),
(54, 'EET', '16340749200', 7200, '0'),
(54, 'EEST', '16354054800', 10800, '1'),
(54, 'EET', '16372803600', 7200, '0'),
(54, 'EEST', '16385504400', 10800, '1'),
(54, 'EET', '16404253200', 7200, '0'),
(54, 'EEST', '16416954000', 10800, '1'),
(54, 'EET', '16435702800', 7200, '0'),
(54, 'EEST', '16448403600', 10800, '1'),
(54, 'EET', '16467152400', 7200, '0'),
(54, 'EEST', '16480458000', 10800, '1'),
(54, 'EET', '16498602000', 7200, '0'),
(54, 'EEST', '16511907600', 10800, '1'),
(54, 'EET', '16530051600', 7200, '0'),
(54, 'EEST', '16543357200', 10800, '1'),
(54, 'EET', '16562106000', 7200, '0'),
(54, 'EEST', '16574806800', 10800, '1'),
(54, 'EET', '16593555600', 7200, '0'),
(54, 'EEST', '16606256400', 10800, '1'),
(54, 'EET', '16625005200', 7200, '0'),
(54, 'EEST', '16638310800', 10800, '1'),
(54, 'EET', '16656454800', 7200, '0'),
(54, 'EEST', '16669760400', 10800, '1'),
(54, 'EET', '16687904400', 7200, '0'),
(54, 'EEST', '16701210000', 10800, '1'),
(54, 'EET', '16719354000', 7200, '0'),
(55, 'LMT', '-1577935569', 12368, '0'),
(55, '+04', '-1577935568', 14400, '0'),
(55, '+03', '76190400', 10800, '0'),
(56, 'LMT', '-2109291021', 7820, '0'),
(56, 'CAT', '-2109291020', 7200, '0'),
(57, 'LMT', '-1588464817', 816, '0'),
(57, 'WAT', '-1588464816', 3600, '0'),
(58, 'LMT', '-1825098837', -14764, '0'),
(58, 'AST', '-1825098836', -14400, '0'),
(59, 'LMT', '-1262281243', -15558, '0'),
(59, 'AST', '-1262281242', -14400, '0'),
(59, 'ADT', '136360800', -10800, '1'),
(59, 'AST', '152082000', -14400, '0'),
(59, 'ADT', '167810400', -10800, '1'),
(59, 'AST', '183531600', -14400, '0'),
(59, 'ADT', '199260000', -10800, '1'),
(59, 'AST', '215586000', -14400, '0'),
(59, 'ADT', '230709600', -10800, '1'),
(59, 'AST', '247035600', -14400, '0'),
(59, 'ADT', '262764000', -10800, '1'),
(59, 'AST', '278485200', -14400, '0'),
(59, 'ADT', '294213600', -10800, '1'),
(59, 'AST', '309934800', -14400, '0'),
(59, 'ADT', '325663200', -10800, '1'),
(59, 'AST', '341384400', -14400, '0'),
(59, 'ADT', '357112800', -10800, '1'),
(59, 'AST', '372834000', -14400, '0'),
(59, 'ADT', '388562400', -10800, '1'),
(59, 'AST', '404888400', -14400, '0'),
(59, 'ADT', '420012000', -10800, '1'),
(59, 'AST', '436338000', -14400, '0'),
(59, 'ADT', '452066400', -10800, '1'),
(59, 'AST', '467787600', -14400, '0'),
(59, 'ADT', '483516000', -10800, '1'),
(59, 'AST', '499237200', -14400, '0'),
(59, 'ADT', '514965600', -10800, '1'),
(59, 'AST', '530686800', -14400, '0'),
(59, 'ADT', '544600800', -10800, '1'),
(59, 'AST', '562136400', -14400, '0'),
(59, 'ADT', '576050400', -10800, '1'),
(59, 'AST', '594190800', -14400, '0'),
(59, 'ADT', '607500000', -10800, '1'),
(59, 'AST', '625640400', -14400, '0'),
(59, 'ADT', '638949600', -10800, '1'),
(59, 'AST', '657090000', -14400, '0'),
(59, 'ADT', '671004000', -10800, '1'),
(59, 'AST', '688539600', -14400, '0'),
(59, 'ADT', '702453600', -10800, '1'),
(59, 'AST', '719989200', -14400, '0'),
(59, 'ADT', '733903200', -10800, '1'),
(59, 'AST', '752043600', -14400, '0'),
(59, 'ADT', '765352800', -10800, '1'),
(59, 'AST', '783493200', -14400, '0'),
(59, 'ADT', '796802400', -10800, '1'),
(59, 'AST', '814942800', -14400, '0'),
(59, 'ADT', '828856800', -10800, '1'),
(59, 'AST', '846392400', -14400, '0'),
(59, 'ADT', '860306400', -10800, '1'),
(59, 'AST', '877842000', -14400, '0'),
(59, 'ADT', '891756000', -10800, '1'),
(59, 'AST', '909291600', -14400, '0'),
(59, 'ADT', '923205600', -10800, '1'),
(59, 'AST', '941346000', -14400, '0'),
(59, 'ADT', '954655200', -10800, '1'),
(59, 'AST', '972795600', -14400, '0'),
(59, 'ADT', '986104800', -10800, '1'),
(59, 'AST', '1004245200', -14400, '0'),
(59, 'ADT', '1018159200', -10800, '1'),
(59, 'AST', '1035694800', -14400, '0'),
(59, 'ADT', '1049608800', -10800, '1'),
(59, 'AST', '1067144400', -14400, '0'),
(59, 'ADT', '1081058400', -10800, '1'),
(59, 'AST', '1099198800', -14400, '0'),
(59, 'ADT', '1112508000', -10800, '1'),
(59, 'AST', '1130648400', -14400, '0'),
(59, 'ADT', '1143957600', -10800, '1'),
(59, 'AST', '1162098000', -14400, '0'),
(59, 'ADT', '1173592800', -10800, '1'),
(59, 'AST', '1194152400', -14400, '0'),
(59, 'ADT', '1205042400', -10800, '1'),
(59, 'AST', '1225602000', -14400, '0'),
(59, 'ADT', '1236492000', -10800, '1'),
(59, 'AST', '1257051600', -14400, '0'),
(59, 'ADT', '1268546400', -10800, '1'),
(59, 'AST', '1289106000', -14400, '0'),
(59, 'ADT', '1299996000', -10800, '1'),
(59, 'AST', '1320555600', -14400, '0'),
(59, 'ADT', '1331445600', -10800, '1'),
(59, 'AST', '1352005200', -14400, '0'),
(59, 'ADT', '1362895200', -10800, '1'),
(59, 'AST', '1383454800', -14400, '0'),
(59, 'ADT', '1394344800', -10800, '1'),
(59, 'AST', '1414904400', -14400, '0'),
(59, 'ADT', '1425794400', -10800, '1'),
(59, 'AST', '1446354000', -14400, '0'),
(59, 'ADT', '1457848800', -10800, '1'),
(59, 'AST', '1478408400', -14400, '0'),
(59, 'ADT', '1489298400', -10800, '1'),
(59, 'AST', '1509858000', -14400, '0'),
(59, 'ADT', '1520748000', -10800, '1'),
(59, 'AST', '1541307600', -14400, '0'),
(59, 'ADT', '1552197600', -10800, '1'),
(59, 'AST', '1572757200', -14400, '0'),
(59, 'ADT', '1583647200', -10800, '1'),
(59, 'AST', '1604206800', -14400, '0'),
(59, 'ADT', '1615701600', -10800, '1'),
(59, 'AST', '1636261200', -14400, '0'),
(59, 'ADT', '1647151200', -10800, '1'),
(59, 'AST', '1667710800', -14400, '0'),
(59, 'ADT', '1678600800', -10800, '1'),
(59, 'AST', '1699160400', -14400, '0'),
(59, 'ADT', '1710050400', -10800, '1'),
(59, 'AST', '1730610000', -14400, '0'),
(59, 'ADT', '1741500000', -10800, '1'),
(59, 'AST', '1762059600', -14400, '0'),
(59, 'ADT', '1772949600', -10800, '1'),
(59, 'AST', '1793509200', -14400, '0'),
(59, 'ADT', '1805004000', -10800, '1'),
(59, 'AST', '1825563600', -14400, '0'),
(59, 'ADT', '1836453600', -10800, '1'),
(59, 'AST', '1857013200', -14400, '0'),
(59, 'ADT', '1867903200', -10800, '1'),
(59, 'AST', '1888462800', -14400, '0'),
(59, 'ADT', '1899352800', -10800, '1'),
(59, 'AST', '1919912400', -14400, '0'),
(59, 'ADT', '1930802400', -10800, '1'),
(59, 'AST', '1951362000', -14400, '0'),
(59, 'ADT', '1962856800', -10800, '1'),
(59, 'AST', '1983416400', -14400, '0'),
(59, 'ADT', '1994306400', -10800, '1'),
(59, 'AST', '2014866000', -14400, '0'),
(59, 'ADT', '2025756000', -10800, '1'),
(59, 'AST', '2046315600', -14400, '0'),
(59, 'ADT', '2057205600', -10800, '1'),
(59, 'AST', '2077765200', -14400, '0'),
(59, 'ADT', '2088655200', -10800, '1'),
(59, 'AST', '2109214800', -14400, '0'),
(59, 'ADT', '2120104800', -10800, '1'),
(59, 'AST', '2140664400', -14400, '0'),
(59, 'ADT', '2152159200', -10800, '1'),
(59, 'AST', '2172718800', -14400, '0'),
(59, 'ADT', '2183608800', -10800, '1'),
(59, 'AST', '2204168400', -14400, '0'),
(59, 'ADT', '2215058400', -10800, '1'),
(59, 'AST', '2235618000', -14400, '0'),
(59, 'ADT', '2246508000', -10800, '1'),
(59, 'AST', '2267067600', -14400, '0'),
(59, 'ADT', '2277957600', -10800, '1'),
(59, 'AST', '2298517200', -14400, '0'),
(59, 'ADT', '2309407200', -10800, '1'),
(59, 'AST', '2329966800', -14400, '0'),
(59, 'ADT', '2341461600', -10800, '1'),
(59, 'AST', '2362021200', -14400, '0'),
(59, 'ADT', '2372911200', -10800, '1'),
(59, 'AST', '2393470800', -14400, '0'),
(59, 'ADT', '2404360800', -10800, '1'),
(59, 'AST', '2424920400', -14400, '0'),
(59, 'ADT', '2435810400', -10800, '1'),
(59, 'AST', '2456370000', -14400, '0'),
(59, 'ADT', '2467260000', -10800, '1'),
(59, 'AST', '2487819600', -14400, '0'),
(59, 'ADT', '2499314400', -10800, '1'),
(59, 'AST', '2519874000', -14400, '0'),
(59, 'ADT', '2530764000', -10800, '1'),
(59, 'AST', '2551323600', -14400, '0'),
(59, 'ADT', '2562213600', -10800, '1'),
(59, 'AST', '2582773200', -14400, '0'),
(59, 'ADT', '2593663200', -10800, '1'),
(59, 'AST', '2614222800', -14400, '0'),
(59, 'ADT', '2625112800', -10800, '1'),
(59, 'AST', '2645672400', -14400, '0'),
(59, 'ADT', '2656562400', -10800, '1'),
(59, 'AST', '2677122000', -14400, '0'),
(59, 'ADT', '2688616800', -10800, '1'),
(59, 'AST', '2709176400', -14400, '0'),
(59, 'ADT', '2720066400', -10800, '1'),
(59, 'AST', '2740626000', -14400, '0'),
(59, 'ADT', '2751516000', -10800, '1'),
(59, 'AST', '2772075600', -14400, '0'),
(59, 'ADT', '2782965600', -10800, '1'),
(59, 'AST', '2803525200', -14400, '0'),
(59, 'ADT', '2814415200', -10800, '1'),
(59, 'AST', '2834974800', -14400, '0'),
(59, 'ADT', '2846469600', -10800, '1'),
(59, 'AST', '2867029200', -14400, '0'),
(59, 'ADT', '2877919200', -10800, '1'),
(59, 'AST', '2898478800', -14400, '0'),
(59, 'ADT', '2909368800', -10800, '1'),
(59, 'AST', '2929928400', -14400, '0'),
(59, 'ADT', '2940818400', -10800, '1'),
(59, 'AST', '2961378000', -14400, '0'),
(59, 'ADT', '2972268000', -10800, '1'),
(59, 'AST', '2992827600', -14400, '0'),
(59, 'ADT', '3003717600', -10800, '1'),
(59, 'AST', '3024277200', -14400, '0'),
(59, 'ADT', '3035772000', -10800, '1'),
(59, 'AST', '3056331600', -14400, '0'),
(59, 'ADT', '3067221600', -10800, '1'),
(59, 'AST', '3087781200', -14400, '0'),
(59, 'ADT', '3098671200', -10800, '1'),
(59, 'AST', '3119230800', -14400, '0'),
(59, 'ADT', '3130120800', -10800, '1'),
(59, 'AST', '3150680400', -14400, '0'),
(59, 'ADT', '3161570400', -10800, '1'),
(59, 'AST', '3182130000', -14400, '0'),
(59, 'ADT', '3193020000', -10800, '1'),
(59, 'AST', '3213579600', -14400, '0'),
(59, 'ADT', '3225074400', -10800, '1'),
(59, 'AST', '3245634000', -14400, '0'),
(59, 'ADT', '3256524000', -10800, '1'),
(59, 'AST', '3277083600', -14400, '0'),
(59, 'ADT', '3287973600', -10800, '1'),
(59, 'AST', '3308533200', -14400, '0'),
(59, 'ADT', '3319423200', -10800, '1'),
(59, 'AST', '3339982800', -14400, '0'),
(59, 'ADT', '3350872800', -10800, '1'),
(59, 'AST', '3371432400', -14400, '0'),
(59, 'ADT', '3382927200', -10800, '1'),
(59, 'AST', '3403486800', -14400, '0'),
(59, 'ADT', '3414376800', -10800, '1'),
(59, 'AST', '3434936400', -14400, '0'),
(59, 'ADT', '3445826400', -10800, '1'),
(59, 'AST', '3466386000', -14400, '0'),
(59, 'ADT', '3477276000', -10800, '1'),
(59, 'AST', '3497835600', -14400, '0'),
(59, 'ADT', '3508725600', -10800, '1'),
(59, 'AST', '3529285200', -14400, '0'),
(59, 'ADT', '3540175200', -10800, '1'),
(59, 'AST', '3560734800', -14400, '0'),
(59, 'ADT', '3572229600', -10800, '1'),
(59, 'AST', '3592789200', -14400, '0'),
(59, 'ADT', '3603679200', -10800, '1'),
(59, 'AST', '3624238800', -14400, '0'),
(59, 'ADT', '3635128800', -10800, '1'),
(59, 'AST', '3655688400', -14400, '0'),
(59, 'ADT', '3666578400', -10800, '1'),
(59, 'AST', '3687138000', -14400, '0'),
(59, 'ADT', '3698028000', -10800, '1'),
(59, 'AST', '3718587600', -14400, '0'),
(59, 'ADT', '3730082400', -10800, '1'),
(59, 'AST', '3750642000', -14400, '0'),
(59, 'ADT', '3761532000', -10800, '1'),
(59, 'AST', '3782091600', -14400, '0'),
(59, 'ADT', '3792981600', -10800, '1'),
(59, 'AST', '3813541200', -14400, '0'),
(59, 'ADT', '3824431200', -10800, '1'),
(59, 'AST', '3844990800', -14400, '0'),
(59, 'ADT', '3855880800', -10800, '1'),
(59, 'AST', '3876440400', -14400, '0'),
(59, 'ADT', '3887330400', -10800, '1'),
(59, 'AST', '3907890000', -14400, '0'),
(59, 'ADT', '3919384800', -10800, '1'),
(59, 'AST', '3939944400', -14400, '0'),
(59, 'ADT', '3950834400', -10800, '1'),
(59, 'AST', '3971394000', -14400, '0'),
(59, 'ADT', '3982284000', -10800, '1'),
(59, 'AST', '4002843600', -14400, '0'),
(59, 'ADT', '4013733600', -10800, '1'),
(59, 'AST', '4034293200', -14400, '0'),
(59, 'ADT', '4045183200', -10800, '1'),
(59, 'AST', '4065742800', -14400, '0'),
(59, 'ADT', '4076632800', -10800, '1'),
(59, 'AST', '4097192400', -14400, '0'),
(59, 'ADT', '4108687200', -10800, '1'),
(59, 'AST', '4129246800', -14400, '0'),
(59, 'ADT', '4140136800', -10800, '1'),
(59, 'AST', '4160696400', -14400, '0'),
(59, 'ADT', '4171586400', -10800, '1'),
(59, 'AST', '4192146000', -14400, '0'),
(59, 'ADT', '4203036000', -10800, '1'),
(59, 'AST', '4223595600', -14400, '0'),
(59, 'ADT', '4234485600', -10800, '1'),
(59, 'AST', '4255045200', -14400, '0'),
(59, 'ADT', '4265935200', -10800, '1'),
(59, 'AST', '4286494800', -14400, '0'),
(59, 'ADT', '4297989600', -10800, '1'),
(59, 'AST', '4318549200', -14400, '0'),
(59, 'ADT', '4329439200', -10800, '1'),
(59, 'AST', '4349998800', -14400, '0'),
(59, 'ADT', '4360888800', -10800, '1'),
(59, 'AST', '4381448400', -14400, '0'),
(59, 'ADT', '4392338400', -10800, '1'),
(59, 'AST', '4412898000', -14400, '0'),
(59, 'ADT', '4423788000', -10800, '1'),
(59, 'AST', '4444347600', -14400, '0'),
(59, 'ADT', '4455237600', -10800, '1'),
(59, 'AST', '4475797200', -14400, '0'),
(59, 'ADT', '4487292000', -10800, '1'),
(59, 'AST', '4507851600', -14400, '0'),
(59, 'ADT', '4518741600', -10800, '1'),
(59, 'AST', '4539301200', -14400, '0'),
(59, 'ADT', '4550191200', -10800, '1'),
(59, 'AST', '4570750800', -14400, '0'),
(59, 'ADT', '4581640800', -10800, '1'),
(59, 'AST', '4602200400', -14400, '0'),
(59, 'ADT', '4613090400', -10800, '1'),
(59, 'AST', '4633650000', -14400, '0'),
(59, 'ADT', '4645144800', -10800, '1'),
(59, 'AST', '4665704400', -14400, '0'),
(59, 'ADT', '4676594400', -10800, '1'),
(59, 'AST', '4697154000', -14400, '0'),
(59, 'ADT', '4708044000', -10800, '1'),
(59, 'AST', '4728603600', -14400, '0'),
(59, 'ADT', '4739493600', -10800, '1'),
(59, 'AST', '4760053200', -14400, '0'),
(59, 'ADT', '4770943200', -10800, '1'),
(59, 'AST', '4791502800', -14400, '0'),
(59, 'ADT', '4802392800', -10800, '1'),
(59, 'AST', '4822952400', -14400, '0'),
(59, 'ADT', '4834447200', -10800, '1'),
(59, 'AST', '4855006800', -14400, '0'),
(59, 'ADT', '4865896800', -10800, '1'),
(59, 'AST', '4886456400', -14400, '0'),
(59, 'ADT', '4897346400', -10800, '1'),
(59, 'AST', '4917906000', -14400, '0'),
(59, 'ADT', '4928796000', -10800, '1'),
(59, 'AST', '4949355600', -14400, '0'),
(59, 'ADT', '4960245600', -10800, '1'),
(59, 'AST', '4980805200', -14400, '0'),
(59, 'ADT', '4992300000', -10800, '1'),
(59, 'AST', '5012859600', -14400, '0'),
(59, 'ADT', '5023749600', -10800, '1'),
(59, 'AST', '5044309200', -14400, '0'),
(59, 'ADT', '5055199200', -10800, '1'),
(59, 'AST', '5075758800', -14400, '0'),
(59, 'ADT', '5086648800', -10800, '1'),
(59, 'AST', '5107208400', -14400, '0'),
(59, 'ADT', '5118098400', -10800, '1'),
(59, 'AST', '5138658000', -14400, '0'),
(59, 'ADT', '5149548000', -10800, '1'),
(59, 'AST', '5170107600', -14400, '0'),
(59, 'ADT', '5181602400', -10800, '1'),
(59, 'AST', '5202162000', -14400, '0'),
(59, 'ADT', '5213052000', -10800, '1'),
(59, 'AST', '5233611600', -14400, '0'),
(59, 'ADT', '5244501600', -10800, '1'),
(59, 'AST', '5265061200', -14400, '0'),
(59, 'ADT', '5275951200', -10800, '1'),
(59, 'AST', '5296510800', -14400, '0'),
(59, 'ADT', '5307400800', -10800, '1'),
(59, 'AST', '5327960400', -14400, '0'),
(59, 'ADT', '5338850400', -10800, '1'),
(59, 'AST', '5359410000', -14400, '0'),
(59, 'ADT', '5370904800', -10800, '1'),
(59, 'AST', '5391464400', -14400, '0'),
(59, 'ADT', '5402354400', -10800, '1'),
(59, 'AST', '5422914000', -14400, '0'),
(59, 'ADT', '5433804000', -10800, '1'),
(59, 'AST', '5454363600', -14400, '0'),
(59, 'ADT', '5465253600', -10800, '1'),
(59, 'AST', '5485813200', -14400, '0'),
(59, 'ADT', '5496703200', -10800, '1'),
(59, 'AST', '5517262800', -14400, '0'),
(59, 'ADT', '5528757600', -10800, '1'),
(59, 'AST', '5549317200', -14400, '0'),
(59, 'ADT', '5560207200', -10800, '1'),
(59, 'AST', '5580766800', -14400, '0'),
(59, 'ADT', '5591656800', -10800, '1'),
(59, 'AST', '5612216400', -14400, '0'),
(59, 'ADT', '5623106400', -10800, '1'),
(59, 'AST', '5643666000', -14400, '0'),
(59, 'ADT', '5654556000', -10800, '1'),
(59, 'AST', '5675115600', -14400, '0'),
(59, 'ADT', '5686005600', -10800, '1'),
(59, 'AST', '5706565200', -14400, '0'),
(59, 'ADT', '5718060000', -10800, '1'),
(59, 'AST', '5738619600', -14400, '0'),
(59, 'ADT', '5749509600', -10800, '1'),
(59, 'AST', '5770069200', -14400, '0'),
(59, 'ADT', '5780959200', -10800, '1'),
(59, 'AST', '5801518800', -14400, '0'),
(59, 'ADT', '5812408800', -10800, '1'),
(59, 'AST', '5832968400', -14400, '0'),
(59, 'ADT', '5843858400', -10800, '1'),
(59, 'AST', '5864418000', -14400, '0'),
(59, 'ADT', '5875912800', -10800, '1'),
(59, 'AST', '5896472400', -14400, '0'),
(59, 'ADT', '5907362400', -10800, '1'),
(59, 'AST', '5927922000', -14400, '0'),
(59, 'ADT', '5938812000', -10800, '1'),
(59, 'AST', '5959371600', -14400, '0'),
(59, 'ADT', '5970261600', -10800, '1'),
(59, 'AST', '5990821200', -14400, '0'),
(59, 'ADT', '6001711200', -10800, '1'),
(59, 'AST', '6022270800', -14400, '0'),
(59, 'ADT', '6033160800', -10800, '1'),
(59, 'AST', '6053720400', -14400, '0'),
(59, 'ADT', '6065215200', -10800, '1'),
(59, 'AST', '6085774800', -14400, '0'),
(59, 'ADT', '6096664800', -10800, '1'),
(59, 'AST', '6117224400', -14400, '0'),
(59, 'ADT', '6128114400', -10800, '1'),
(59, 'AST', '6148674000', -14400, '0'),
(59, 'ADT', '6159564000', -10800, '1'),
(59, 'AST', '6180123600', -14400, '0'),
(59, 'ADT', '6191013600', -10800, '1'),
(59, 'AST', '6211573200', -14400, '0'),
(59, 'ADT', '6222463200', -10800, '1'),
(59, 'AST', '6243022800', -14400, '0'),
(59, 'ADT', '6254517600', -10800, '1'),
(59, 'AST', '6275077200', -14400, '0'),
(59, 'ADT', '6285967200', -10800, '1'),
(59, 'AST', '6306526800', -14400, '0'),
(59, 'ADT', '6317416800', -10800, '1'),
(59, 'AST', '6337976400', -14400, '0'),
(59, 'ADT', '6348866400', -10800, '1'),
(59, 'AST', '6369426000', -14400, '0'),
(59, 'ADT', '6380316000', -10800, '1'),
(59, 'AST', '6400875600', -14400, '0'),
(59, 'ADT', '6412370400', -10800, '1'),
(59, 'AST', '6432930000', -14400, '0'),
(59, 'ADT', '6443820000', -10800, '1'),
(59, 'AST', '6464379600', -14400, '0'),
(59, 'ADT', '6475269600', -10800, '1'),
(59, 'AST', '6495829200', -14400, '0'),
(59, 'ADT', '6506719200', -10800, '1'),
(59, 'AST', '6527278800', -14400, '0'),
(59, 'ADT', '6538168800', -10800, '1'),
(59, 'AST', '6558728400', -14400, '0'),
(59, 'ADT', '6569618400', -10800, '1'),
(59, 'AST', '6590178000', -14400, '0'),
(59, 'ADT', '6601672800', -10800, '1'),
(59, 'AST', '6622232400', -14400, '0'),
(59, 'ADT', '6633122400', -10800, '1'),
(59, 'AST', '6653682000', -14400, '0'),
(59, 'ADT', '6664572000', -10800, '1'),
(59, 'AST', '6685131600', -14400, '0'),
(59, 'ADT', '6696021600', -10800, '1'),
(59, 'AST', '6716581200', -14400, '0'),
(59, 'ADT', '6727471200', -10800, '1'),
(59, 'AST', '6748030800', -14400, '0'),
(59, 'ADT', '6759525600', -10800, '1'),
(59, 'AST', '6780085200', -14400, '0'),
(59, 'ADT', '6790975200', -10800, '1'),
(59, 'AST', '6811534800', -14400, '0'),
(59, 'ADT', '6822424800', -10800, '1'),
(59, 'AST', '6842984400', -14400, '0'),
(59, 'ADT', '6853874400', -10800, '1'),
(59, 'AST', '6874434000', -14400, '0'),
(59, 'ADT', '6885324000', -10800, '1'),
(59, 'AST', '6905883600', -14400, '0'),
(59, 'ADT', '6916773600', -10800, '1'),
(59, 'AST', '6937333200', -14400, '0'),
(59, 'ADT', '6948828000', -10800, '1'),
(59, 'AST', '6969387600', -14400, '0'),
(59, 'ADT', '6980277600', -10800, '1'),
(59, 'AST', '7000837200', -14400, '0'),
(59, 'ADT', '7011727200', -10800, '1'),
(59, 'AST', '7032286800', -14400, '0'),
(59, 'ADT', '7043176800', -10800, '1'),
(59, 'AST', '7063736400', -14400, '0'),
(59, 'ADT', '7074626400', -10800, '1'),
(59, 'AST', '7095186000', -14400, '0'),
(59, 'ADT', '7106076000', -10800, '1'),
(59, 'AST', '7126635600', -14400, '0'),
(59, 'ADT', '7138130400', -10800, '1'),
(59, 'AST', '7158690000', -14400, '0'),
(59, 'ADT', '7169580000', -10800, '1'),
(59, 'AST', '7190139600', -14400, '0'),
(59, 'ADT', '7201029600', -10800, '1'),
(59, 'AST', '7221589200', -14400, '0'),
(59, 'ADT', '7232479200', -10800, '1'),
(59, 'AST', '7253038800', -14400, '0'),
(59, 'ADT', '7263928800', -10800, '1'),
(59, 'AST', '7284488400', -14400, '0'),
(59, 'ADT', '7295378400', -10800, '1'),
(59, 'AST', '7315938000', -14400, '0'),
(59, 'ADT', '7327432800', -10800, '1'),
(59, 'AST', '7347992400', -14400, '0'),
(59, 'ADT', '7358882400', -10800, '1'),
(59, 'AST', '7379442000', -14400, '0'),
(59, 'ADT', '7390332000', -10800, '1'),
(59, 'AST', '7410891600', -14400, '0'),
(59, 'ADT', '7421781600', -10800, '1'),
(59, 'AST', '7442341200', -14400, '0'),
(59, 'ADT', '7453231200', -10800, '1'),
(59, 'AST', '7473790800', -14400, '0'),
(59, 'ADT', '7484680800', -10800, '1'),
(59, 'AST', '7505240400', -14400, '0'),
(59, 'ADT', '7516735200', -10800, '1'),
(59, 'AST', '7537294800', -14400, '0'),
(59, 'ADT', '7548184800', -10800, '1'),
(59, 'AST', '7568744400', -14400, '0'),
(59, 'ADT', '7579634400', -10800, '1'),
(59, 'AST', '7600194000', -14400, '0'),
(59, 'ADT', '7611084000', -10800, '1'),
(59, 'AST', '7631643600', -14400, '0'),
(59, 'ADT', '7642533600', -10800, '1'),
(59, 'AST', '7663093200', -14400, '0'),
(59, 'ADT', '7674588000', -10800, '1'),
(59, 'AST', '7695147600', -14400, '0'),
(59, 'ADT', '7706037600', -10800, '1'),
(59, 'AST', '7726597200', -14400, '0'),
(59, 'ADT', '7737487200', -10800, '1'),
(59, 'AST', '7758046800', -14400, '0'),
(59, 'ADT', '7768936800', -10800, '1'),
(59, 'AST', '7789496400', -14400, '0'),
(59, 'ADT', '7800386400', -10800, '1'),
(59, 'AST', '7820946000', -14400, '0'),
(59, 'ADT', '7831836000', -10800, '1'),
(59, 'AST', '7852395600', -14400, '0'),
(59, 'ADT', '7863890400', -10800, '1'),
(59, 'AST', '7884450000', -14400, '0'),
(59, 'ADT', '7895340000', -10800, '1'),
(59, 'AST', '7915899600', -14400, '0'),
(59, 'ADT', '7926789600', -10800, '1'),
(59, 'AST', '7947349200', -14400, '0'),
(59, 'ADT', '7958239200', -10800, '1'),
(59, 'AST', '7978798800', -14400, '0'),
(59, 'ADT', '7989688800', -10800, '1'),
(59, 'AST', '8010248400', -14400, '0'),
(59, 'ADT', '8021743200', -10800, '1'),
(59, 'AST', '8042302800', -14400, '0'),
(59, 'ADT', '8053192800', -10800, '1'),
(59, 'AST', '8073752400', -14400, '0'),
(59, 'ADT', '8084642400', -10800, '1'),
(59, 'AST', '8105202000', -14400, '0'),
(59, 'ADT', '8116092000', -10800, '1'),
(59, 'AST', '8136651600', -14400, '0'),
(59, 'ADT', '8147541600', -10800, '1'),
(59, 'AST', '8168101200', -14400, '0'),
(59, 'ADT', '8178991200', -10800, '1'),
(59, 'AST', '8199550800', -14400, '0'),
(59, 'ADT', '8211045600', -10800, '1'),
(59, 'AST', '8231605200', -14400, '0'),
(59, 'ADT', '8242495200', -10800, '1'),
(59, 'AST', '8263054800', -14400, '0'),
(59, 'ADT', '8273944800', -10800, '1'),
(59, 'AST', '8294504400', -14400, '0'),
(59, 'ADT', '8305394400', -10800, '1'),
(59, 'AST', '8325954000', -14400, '0'),
(59, 'ADT', '8336844000', -10800, '1'),
(59, 'AST', '8357403600', -14400, '0'),
(59, 'ADT', '8368293600', -10800, '1'),
(59, 'AST', '8388853200', -14400, '0'),
(59, 'ADT', '8400348000', -10800, '1'),
(59, 'AST', '8420907600', -14400, '0'),
(59, 'ADT', '8431797600', -10800, '1'),
(59, 'AST', '8452357200', -14400, '0'),
(59, 'ADT', '8463247200', -10800, '1'),
(59, 'AST', '8483806800', -14400, '0'),
(59, 'ADT', '8494696800', -10800, '1'),
(59, 'AST', '8515256400', -14400, '0'),
(59, 'ADT', '8526146400', -10800, '1'),
(59, 'AST', '8546706000', -14400, '0'),
(59, 'ADT', '8558200800', -10800, '1'),
(59, 'AST', '8578760400', -14400, '0'),
(59, 'ADT', '8589650400', -10800, '1'),
(59, 'AST', '8610210000', -14400, '0'),
(59, 'ADT', '8621100000', -10800, '1'),
(59, 'AST', '8641659600', -14400, '0'),
(59, 'ADT', '8652549600', -10800, '1'),
(59, 'AST', '8673109200', -14400, '0'),
(59, 'ADT', '8683999200', -10800, '1'),
(59, 'AST', '8704558800', -14400, '0'),
(59, 'ADT', '8715448800', -10800, '1'),
(59, 'AST', '8736008400', -14400, '0'),
(59, 'ADT', '8747503200', -10800, '1'),
(59, 'AST', '8768062800', -14400, '0'),
(59, 'ADT', '8778952800', -10800, '1'),
(59, 'AST', '8799512400', -14400, '0'),
(59, 'ADT', '8810402400', -10800, '1'),
(59, 'AST', '8830962000', -14400, '0'),
(59, 'ADT', '8841852000', -10800, '1'),
(59, 'AST', '8862411600', -14400, '0'),
(59, 'ADT', '8873301600', -10800, '1'),
(59, 'AST', '8893861200', -14400, '0'),
(59, 'ADT', '8905356000', -10800, '1'),
(59, 'AST', '8925915600', -14400, '0'),
(59, 'ADT', '8936805600', -10800, '1'),
(59, 'AST', '8957365200', -14400, '0'),
(59, 'ADT', '8968255200', -10800, '1'),
(59, 'AST', '8988814800', -14400, '0'),
(59, 'ADT', '8999704800', -10800, '1'),
(59, 'AST', '9020264400', -14400, '0'),
(59, 'ADT', '9031154400', -10800, '1'),
(59, 'AST', '9051714000', -14400, '0'),
(59, 'ADT', '9062604000', -10800, '1'),
(59, 'AST', '9083163600', -14400, '0'),
(59, 'ADT', '9094658400', -10800, '1'),
(59, 'AST', '9115218000', -14400, '0'),
(59, 'ADT', '9126108000', -10800, '1'),
(59, 'AST', '9146667600', -14400, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(59, 'ADT', '9157557600', -10800, '1'),
(59, 'AST', '9178117200', -14400, '0'),
(59, 'ADT', '9189007200', -10800, '1'),
(59, 'AST', '9209566800', -14400, '0'),
(59, 'ADT', '9220456800', -10800, '1'),
(59, 'AST', '9241016400', -14400, '0'),
(59, 'ADT', '9251906400', -10800, '1'),
(59, 'AST', '9272466000', -14400, '0'),
(59, 'ADT', '9283960800', -10800, '1'),
(59, 'AST', '9304520400', -14400, '0'),
(59, 'ADT', '9315410400', -10800, '1'),
(59, 'AST', '9335970000', -14400, '0'),
(59, 'ADT', '9346860000', -10800, '1'),
(59, 'AST', '9367419600', -14400, '0'),
(59, 'ADT', '9378309600', -10800, '1'),
(59, 'AST', '9398869200', -14400, '0'),
(59, 'ADT', '9409759200', -10800, '1'),
(59, 'AST', '9430318800', -14400, '0'),
(59, 'ADT', '9441813600', -10800, '1'),
(59, 'AST', '9462373200', -14400, '0'),
(59, 'ADT', '9473263200', -10800, '1'),
(59, 'AST', '9493822800', -14400, '0'),
(59, 'ADT', '9504712800', -10800, '1'),
(59, 'AST', '9525272400', -14400, '0'),
(59, 'ADT', '9536162400', -10800, '1'),
(59, 'AST', '9556722000', -14400, '0'),
(59, 'ADT', '9567612000', -10800, '1'),
(59, 'AST', '9588171600', -14400, '0'),
(59, 'ADT', '9599061600', -10800, '1'),
(59, 'AST', '9619621200', -14400, '0'),
(59, 'ADT', '9631116000', -10800, '1'),
(59, 'AST', '9651675600', -14400, '0'),
(59, 'ADT', '9662565600', -10800, '1'),
(59, 'AST', '9683125200', -14400, '0'),
(59, 'ADT', '9694015200', -10800, '1'),
(59, 'AST', '9714574800', -14400, '0'),
(59, 'ADT', '9725464800', -10800, '1'),
(59, 'AST', '9746024400', -14400, '0'),
(59, 'ADT', '9756914400', -10800, '1'),
(59, 'AST', '9777474000', -14400, '0'),
(59, 'ADT', '9788968800', -10800, '1'),
(59, 'AST', '9809528400', -14400, '0'),
(59, 'ADT', '9820418400', -10800, '1'),
(59, 'AST', '9840978000', -14400, '0'),
(59, 'ADT', '9851868000', -10800, '1'),
(59, 'AST', '9872427600', -14400, '0'),
(59, 'ADT', '9883317600', -10800, '1'),
(59, 'AST', '9903877200', -14400, '0'),
(59, 'ADT', '9914767200', -10800, '1'),
(59, 'AST', '9935326800', -14400, '0'),
(59, 'ADT', '9946216800', -10800, '1'),
(59, 'AST', '9966776400', -14400, '0'),
(59, 'ADT', '9978271200', -10800, '1'),
(59, 'AST', '9998830800', -14400, '0'),
(59, 'ADT', '10009720800', -10800, '1'),
(59, 'AST', '10030280400', -14400, '0'),
(59, 'ADT', '10041170400', -10800, '1'),
(59, 'AST', '10061730000', -14400, '0'),
(59, 'ADT', '10072620000', -10800, '1'),
(59, 'AST', '10093179600', -14400, '0'),
(59, 'ADT', '10104069600', -10800, '1'),
(59, 'AST', '10124629200', -14400, '0'),
(59, 'ADT', '10135519200', -10800, '1'),
(59, 'AST', '10156078800', -14400, '0'),
(59, 'ADT', '10167573600', -10800, '1'),
(59, 'AST', '10188133200', -14400, '0'),
(59, 'ADT', '10199023200', -10800, '1'),
(59, 'AST', '10219582800', -14400, '0'),
(59, 'ADT', '10230472800', -10800, '1'),
(59, 'AST', '10251032400', -14400, '0'),
(59, 'ADT', '10261922400', -10800, '1'),
(59, 'AST', '10282482000', -14400, '0'),
(59, 'ADT', '10293372000', -10800, '1'),
(59, 'AST', '10313931600', -14400, '0'),
(59, 'ADT', '10325426400', -10800, '1'),
(59, 'AST', '10345986000', -14400, '0'),
(59, 'ADT', '10356876000', -10800, '1'),
(59, 'AST', '10377435600', -14400, '0'),
(59, 'ADT', '10388325600', -10800, '1'),
(59, 'AST', '10408885200', -14400, '0'),
(59, 'ADT', '10419775200', -10800, '1'),
(59, 'AST', '10440334800', -14400, '0'),
(59, 'ADT', '10451224800', -10800, '1'),
(59, 'AST', '10471784400', -14400, '0'),
(59, 'ADT', '10482674400', -10800, '1'),
(59, 'AST', '10503234000', -14400, '0'),
(59, 'ADT', '10514124000', -10800, '1'),
(59, 'AST', '10534683600', -14400, '0'),
(59, 'ADT', '10546178400', -10800, '1'),
(59, 'AST', '10566738000', -14400, '0'),
(59, 'ADT', '10577628000', -10800, '1'),
(59, 'AST', '10598187600', -14400, '0'),
(59, 'ADT', '10609077600', -10800, '1'),
(59, 'AST', '10629637200', -14400, '0'),
(59, 'ADT', '10640527200', -10800, '1'),
(59, 'AST', '10661086800', -14400, '0'),
(59, 'ADT', '10671976800', -10800, '1'),
(59, 'AST', '10692536400', -14400, '0'),
(59, 'ADT', '10704031200', -10800, '1'),
(59, 'AST', '10724590800', -14400, '0'),
(59, 'ADT', '10735480800', -10800, '1'),
(59, 'AST', '10756040400', -14400, '0'),
(59, 'ADT', '10766930400', -10800, '1'),
(59, 'AST', '10787490000', -14400, '0'),
(59, 'ADT', '10798380000', -10800, '1'),
(59, 'AST', '10818939600', -14400, '0'),
(59, 'ADT', '10829829600', -10800, '1'),
(59, 'AST', '10850389200', -14400, '0'),
(59, 'ADT', '10861279200', -10800, '1'),
(59, 'AST', '10881838800', -14400, '0'),
(59, 'ADT', '10893333600', -10800, '1'),
(59, 'AST', '10913893200', -14400, '0'),
(59, 'ADT', '10924783200', -10800, '1'),
(59, 'AST', '10945342800', -14400, '0'),
(59, 'ADT', '10956232800', -10800, '1'),
(59, 'AST', '10976792400', -14400, '0'),
(59, 'ADT', '10987682400', -10800, '1'),
(59, 'AST', '11008242000', -14400, '0'),
(59, 'ADT', '11019132000', -10800, '1'),
(59, 'AST', '11039691600', -14400, '0'),
(59, 'ADT', '11051186400', -10800, '1'),
(59, 'AST', '11071746000', -14400, '0'),
(59, 'ADT', '11082636000', -10800, '1'),
(59, 'AST', '11103195600', -14400, '0'),
(59, 'ADT', '11114085600', -10800, '1'),
(59, 'AST', '11134645200', -14400, '0'),
(59, 'ADT', '11145535200', -10800, '1'),
(59, 'AST', '11166094800', -14400, '0'),
(59, 'ADT', '11176984800', -10800, '1'),
(59, 'AST', '11197544400', -14400, '0'),
(59, 'ADT', '11208434400', -10800, '1'),
(59, 'AST', '11228994000', -14400, '0'),
(59, 'ADT', '11240488800', -10800, '1'),
(59, 'AST', '11261048400', -14400, '0'),
(59, 'ADT', '11271938400', -10800, '1'),
(59, 'AST', '11292498000', -14400, '0'),
(59, 'ADT', '11303388000', -10800, '1'),
(59, 'AST', '11323947600', -14400, '0'),
(59, 'ADT', '11334837600', -10800, '1'),
(59, 'AST', '11355397200', -14400, '0'),
(59, 'ADT', '11366287200', -10800, '1'),
(59, 'AST', '11386846800', -14400, '0'),
(59, 'ADT', '11397736800', -10800, '1'),
(59, 'AST', '11418296400', -14400, '0'),
(59, 'ADT', '11429791200', -10800, '1'),
(59, 'AST', '11450350800', -14400, '0'),
(59, 'ADT', '11461240800', -10800, '1'),
(59, 'AST', '11481800400', -14400, '0'),
(59, 'ADT', '11492690400', -10800, '1'),
(59, 'AST', '11513250000', -14400, '0'),
(59, 'ADT', '11524140000', -10800, '1'),
(59, 'AST', '11544699600', -14400, '0'),
(59, 'ADT', '11555589600', -10800, '1'),
(59, 'AST', '11576149200', -14400, '0'),
(59, 'ADT', '11587644000', -10800, '1'),
(59, 'AST', '11608203600', -14400, '0'),
(59, 'ADT', '11619093600', -10800, '1'),
(59, 'AST', '11639653200', -14400, '0'),
(59, 'ADT', '11650543200', -10800, '1'),
(59, 'AST', '11671102800', -14400, '0'),
(59, 'ADT', '11681992800', -10800, '1'),
(59, 'AST', '11702552400', -14400, '0'),
(59, 'ADT', '11713442400', -10800, '1'),
(59, 'AST', '11734002000', -14400, '0'),
(59, 'ADT', '11744892000', -10800, '1'),
(59, 'AST', '11765451600', -14400, '0'),
(59, 'ADT', '11776946400', -10800, '1'),
(59, 'AST', '11797506000', -14400, '0'),
(59, 'ADT', '11808396000', -10800, '1'),
(59, 'AST', '11828955600', -14400, '0'),
(59, 'ADT', '11839845600', -10800, '1'),
(59, 'AST', '11860405200', -14400, '0'),
(59, 'ADT', '11871295200', -10800, '1'),
(59, 'AST', '11891854800', -14400, '0'),
(59, 'ADT', '11902744800', -10800, '1'),
(59, 'AST', '11923304400', -14400, '0'),
(59, 'ADT', '11934799200', -10800, '1'),
(59, 'AST', '11955358800', -14400, '0'),
(59, 'ADT', '11966248800', -10800, '1'),
(59, 'AST', '11986808400', -14400, '0'),
(59, 'ADT', '11997698400', -10800, '1'),
(59, 'AST', '12018258000', -14400, '0'),
(59, 'ADT', '12029148000', -10800, '1'),
(59, 'AST', '12049707600', -14400, '0'),
(59, 'ADT', '12060597600', -10800, '1'),
(59, 'AST', '12081157200', -14400, '0'),
(59, 'ADT', '12092047200', -10800, '1'),
(59, 'AST', '12112606800', -14400, '0'),
(59, 'ADT', '12124101600', -10800, '1'),
(59, 'AST', '12144661200', -14400, '0'),
(59, 'ADT', '12155551200', -10800, '1'),
(59, 'AST', '12176110800', -14400, '0'),
(59, 'ADT', '12187000800', -10800, '1'),
(59, 'AST', '12207560400', -14400, '0'),
(59, 'ADT', '12218450400', -10800, '1'),
(59, 'AST', '12239010000', -14400, '0'),
(59, 'ADT', '12249900000', -10800, '1'),
(59, 'AST', '12270459600', -14400, '0'),
(59, 'ADT', '12281349600', -10800, '1'),
(59, 'AST', '12301909200', -14400, '0'),
(59, 'ADT', '12313404000', -10800, '1'),
(59, 'AST', '12333963600', -14400, '0'),
(59, 'ADT', '12344853600', -10800, '1'),
(59, 'AST', '12365413200', -14400, '0'),
(59, 'ADT', '12376303200', -10800, '1'),
(59, 'AST', '12396862800', -14400, '0'),
(59, 'ADT', '12407752800', -10800, '1'),
(59, 'AST', '12428312400', -14400, '0'),
(59, 'ADT', '12439202400', -10800, '1'),
(59, 'AST', '12459762000', -14400, '0'),
(59, 'ADT', '12471256800', -10800, '1'),
(59, 'AST', '12491816400', -14400, '0'),
(59, 'ADT', '12502706400', -10800, '1'),
(59, 'AST', '12523266000', -14400, '0'),
(59, 'ADT', '12534156000', -10800, '1'),
(59, 'AST', '12554715600', -14400, '0'),
(59, 'ADT', '12565605600', -10800, '1'),
(59, 'AST', '12586165200', -14400, '0'),
(59, 'ADT', '12597055200', -10800, '1'),
(59, 'AST', '12617614800', -14400, '0'),
(59, 'ADT', '12628504800', -10800, '1'),
(59, 'AST', '12649064400', -14400, '0'),
(59, 'ADT', '12660559200', -10800, '1'),
(59, 'AST', '12681118800', -14400, '0'),
(59, 'ADT', '12692008800', -10800, '1'),
(59, 'AST', '12712568400', -14400, '0'),
(59, 'ADT', '12723458400', -10800, '1'),
(59, 'AST', '12744018000', -14400, '0'),
(59, 'ADT', '12754908000', -10800, '1'),
(59, 'AST', '12775467600', -14400, '0'),
(59, 'ADT', '12786357600', -10800, '1'),
(59, 'AST', '12806917200', -14400, '0'),
(59, 'ADT', '12818412000', -10800, '1'),
(59, 'AST', '12838971600', -14400, '0'),
(59, 'ADT', '12849861600', -10800, '1'),
(59, 'AST', '12870421200', -14400, '0'),
(59, 'ADT', '12881311200', -10800, '1'),
(59, 'AST', '12901870800', -14400, '0'),
(59, 'ADT', '12912760800', -10800, '1'),
(59, 'AST', '12933320400', -14400, '0'),
(59, 'ADT', '12944210400', -10800, '1'),
(59, 'AST', '12964770000', -14400, '0'),
(59, 'ADT', '12975660000', -10800, '1'),
(59, 'AST', '12996219600', -14400, '0'),
(59, 'ADT', '13007714400', -10800, '1'),
(59, 'AST', '13028274000', -14400, '0'),
(59, 'ADT', '13039164000', -10800, '1'),
(59, 'AST', '13059723600', -14400, '0'),
(59, 'ADT', '13070613600', -10800, '1'),
(59, 'AST', '13091173200', -14400, '0'),
(59, 'ADT', '13102063200', -10800, '1'),
(59, 'AST', '13122622800', -14400, '0'),
(59, 'ADT', '13133512800', -10800, '1'),
(59, 'AST', '13154072400', -14400, '0'),
(59, 'ADT', '13164962400', -10800, '1'),
(59, 'AST', '13185522000', -14400, '0'),
(59, 'ADT', '13197016800', -10800, '1'),
(59, 'AST', '13217576400', -14400, '0'),
(59, 'ADT', '13228466400', -10800, '1'),
(59, 'AST', '13249026000', -14400, '0'),
(59, 'ADT', '13259916000', -10800, '1'),
(59, 'AST', '13280475600', -14400, '0'),
(59, 'ADT', '13291365600', -10800, '1'),
(59, 'AST', '13311925200', -14400, '0'),
(59, 'ADT', '13322815200', -10800, '1'),
(59, 'AST', '13343374800', -14400, '0'),
(59, 'ADT', '13354869600', -10800, '1'),
(59, 'AST', '13375429200', -14400, '0'),
(59, 'ADT', '13386319200', -10800, '1'),
(59, 'AST', '13406878800', -14400, '0'),
(59, 'ADT', '13417768800', -10800, '1'),
(59, 'AST', '13438328400', -14400, '0'),
(59, 'ADT', '13449218400', -10800, '1'),
(59, 'AST', '13469778000', -14400, '0'),
(59, 'ADT', '13480668000', -10800, '1'),
(59, 'AST', '13501227600', -14400, '0'),
(59, 'ADT', '13512117600', -10800, '1'),
(59, 'AST', '13532677200', -14400, '0'),
(59, 'ADT', '13544172000', -10800, '1'),
(59, 'AST', '13564731600', -14400, '0'),
(59, 'ADT', '13575621600', -10800, '1'),
(59, 'AST', '13596181200', -14400, '0'),
(59, 'ADT', '13607071200', -10800, '1'),
(59, 'AST', '13627630800', -14400, '0'),
(59, 'ADT', '13638520800', -10800, '1'),
(59, 'AST', '13659080400', -14400, '0'),
(59, 'ADT', '13669970400', -10800, '1'),
(59, 'AST', '13690530000', -14400, '0'),
(59, 'ADT', '13702024800', -10800, '1'),
(59, 'AST', '13722584400', -14400, '0'),
(59, 'ADT', '13733474400', -10800, '1'),
(59, 'AST', '13754034000', -14400, '0'),
(59, 'ADT', '13764924000', -10800, '1'),
(59, 'AST', '13785483600', -14400, '0'),
(59, 'ADT', '13796373600', -10800, '1'),
(59, 'AST', '13816933200', -14400, '0'),
(59, 'ADT', '13827823200', -10800, '1'),
(59, 'AST', '13848382800', -14400, '0'),
(59, 'ADT', '13859272800', -10800, '1'),
(59, 'AST', '13879832400', -14400, '0'),
(59, 'ADT', '13891327200', -10800, '1'),
(59, 'AST', '13911886800', -14400, '0'),
(59, 'ADT', '13922776800', -10800, '1'),
(59, 'AST', '13943336400', -14400, '0'),
(59, 'ADT', '13954226400', -10800, '1'),
(59, 'AST', '13974786000', -14400, '0'),
(59, 'ADT', '13985676000', -10800, '1'),
(59, 'AST', '14006235600', -14400, '0'),
(59, 'ADT', '14017125600', -10800, '1'),
(59, 'AST', '14037685200', -14400, '0'),
(59, 'ADT', '14048575200', -10800, '1'),
(59, 'AST', '14069134800', -14400, '0'),
(59, 'ADT', '14080629600', -10800, '1'),
(59, 'AST', '14101189200', -14400, '0'),
(59, 'ADT', '14112079200', -10800, '1'),
(59, 'AST', '14132638800', -14400, '0'),
(59, 'ADT', '14143528800', -10800, '1'),
(59, 'AST', '14164088400', -14400, '0'),
(59, 'ADT', '14174978400', -10800, '1'),
(59, 'AST', '14195538000', -14400, '0'),
(59, 'ADT', '14206428000', -10800, '1'),
(59, 'AST', '14226987600', -14400, '0'),
(59, 'ADT', '14238482400', -10800, '1'),
(59, 'AST', '14259042000', -14400, '0'),
(59, 'ADT', '14269932000', -10800, '1'),
(59, 'AST', '14290491600', -14400, '0'),
(59, 'ADT', '14301381600', -10800, '1'),
(59, 'AST', '14321941200', -14400, '0'),
(59, 'ADT', '14332831200', -10800, '1'),
(59, 'AST', '14353390800', -14400, '0'),
(59, 'ADT', '14364280800', -10800, '1'),
(59, 'AST', '14384840400', -14400, '0'),
(59, 'ADT', '14395730400', -10800, '1'),
(59, 'AST', '14416290000', -14400, '0'),
(59, 'ADT', '14427784800', -10800, '1'),
(59, 'AST', '14448344400', -14400, '0'),
(59, 'ADT', '14459234400', -10800, '1'),
(59, 'AST', '14479794000', -14400, '0'),
(59, 'ADT', '14490684000', -10800, '1'),
(59, 'AST', '14511243600', -14400, '0'),
(59, 'ADT', '14522133600', -10800, '1'),
(59, 'AST', '14542693200', -14400, '0'),
(59, 'ADT', '14553583200', -10800, '1'),
(59, 'AST', '14574142800', -14400, '0'),
(59, 'ADT', '14585637600', -10800, '1'),
(59, 'AST', '14606197200', -14400, '0'),
(59, 'ADT', '14617087200', -10800, '1'),
(59, 'AST', '14637646800', -14400, '0'),
(59, 'ADT', '14648536800', -10800, '1'),
(59, 'AST', '14669096400', -14400, '0'),
(59, 'ADT', '14679986400', -10800, '1'),
(59, 'AST', '14700546000', -14400, '0'),
(59, 'ADT', '14711436000', -10800, '1'),
(59, 'AST', '14731995600', -14400, '0'),
(59, 'ADT', '14742885600', -10800, '1'),
(59, 'AST', '14763445200', -14400, '0'),
(59, 'ADT', '14774940000', -10800, '1'),
(59, 'AST', '14795499600', -14400, '0'),
(59, 'ADT', '14806389600', -10800, '1'),
(59, 'AST', '14826949200', -14400, '0'),
(59, 'ADT', '14837839200', -10800, '1'),
(59, 'AST', '14858398800', -14400, '0'),
(59, 'ADT', '14869288800', -10800, '1'),
(59, 'AST', '14889848400', -14400, '0'),
(59, 'ADT', '14900738400', -10800, '1'),
(59, 'AST', '14921298000', -14400, '0'),
(59, 'ADT', '14932188000', -10800, '1'),
(59, 'AST', '14952747600', -14400, '0'),
(59, 'ADT', '14964242400', -10800, '1'),
(59, 'AST', '14984802000', -14400, '0'),
(59, 'ADT', '14995692000', -10800, '1'),
(59, 'AST', '15016251600', -14400, '0'),
(59, 'ADT', '15027141600', -10800, '1'),
(59, 'AST', '15047701200', -14400, '0'),
(59, 'ADT', '15058591200', -10800, '1'),
(59, 'AST', '15079150800', -14400, '0'),
(59, 'ADT', '15090040800', -10800, '1'),
(59, 'AST', '15110600400', -14400, '0'),
(59, 'ADT', '15122095200', -10800, '1'),
(59, 'AST', '15142654800', -14400, '0'),
(59, 'ADT', '15153544800', -10800, '1'),
(59, 'AST', '15174104400', -14400, '0'),
(59, 'ADT', '15184994400', -10800, '1'),
(59, 'AST', '15205554000', -14400, '0'),
(59, 'ADT', '15216444000', -10800, '1'),
(59, 'AST', '15237003600', -14400, '0'),
(59, 'ADT', '15247893600', -10800, '1'),
(59, 'AST', '15268453200', -14400, '0'),
(59, 'ADT', '15279343200', -10800, '1'),
(59, 'AST', '15299902800', -14400, '0'),
(59, 'ADT', '15311397600', -10800, '1'),
(59, 'AST', '15331957200', -14400, '0'),
(59, 'ADT', '15342847200', -10800, '1'),
(59, 'AST', '15363406800', -14400, '0'),
(59, 'ADT', '15374296800', -10800, '1'),
(59, 'AST', '15394856400', -14400, '0'),
(59, 'ADT', '15405746400', -10800, '1'),
(59, 'AST', '15426306000', -14400, '0'),
(59, 'ADT', '15437196000', -10800, '1'),
(59, 'AST', '15457755600', -14400, '0'),
(59, 'ADT', '15469250400', -10800, '1'),
(59, 'AST', '15489810000', -14400, '0'),
(59, 'ADT', '15500700000', -10800, '1'),
(59, 'AST', '15521259600', -14400, '0'),
(59, 'ADT', '15532149600', -10800, '1'),
(59, 'AST', '15552709200', -14400, '0'),
(59, 'ADT', '15563599200', -10800, '1'),
(59, 'AST', '15584158800', -14400, '0'),
(59, 'ADT', '15595048800', -10800, '1'),
(59, 'AST', '15615608400', -14400, '0'),
(59, 'ADT', '15626498400', -10800, '1'),
(59, 'AST', '15647058000', -14400, '0'),
(59, 'ADT', '15658552800', -10800, '1'),
(59, 'AST', '15679112400', -14400, '0'),
(59, 'ADT', '15690002400', -10800, '1'),
(59, 'AST', '15710562000', -14400, '0'),
(59, 'ADT', '15721452000', -10800, '1'),
(59, 'AST', '15742011600', -14400, '0'),
(59, 'ADT', '15752901600', -10800, '1'),
(59, 'AST', '15773461200', -14400, '0'),
(59, 'ADT', '15784351200', -10800, '1'),
(59, 'AST', '15804910800', -14400, '0'),
(59, 'ADT', '15815800800', -10800, '1'),
(59, 'AST', '15836360400', -14400, '0'),
(59, 'ADT', '15847855200', -10800, '1'),
(59, 'AST', '15868414800', -14400, '0'),
(59, 'ADT', '15879304800', -10800, '1'),
(59, 'AST', '15899864400', -14400, '0'),
(59, 'ADT', '15910754400', -10800, '1'),
(59, 'AST', '15931314000', -14400, '0'),
(59, 'ADT', '15942204000', -10800, '1'),
(59, 'AST', '15962763600', -14400, '0'),
(59, 'ADT', '15973653600', -10800, '1'),
(59, 'AST', '15994213200', -14400, '0'),
(59, 'ADT', '16005708000', -10800, '1'),
(59, 'AST', '16026267600', -14400, '0'),
(59, 'ADT', '16037157600', -10800, '1'),
(59, 'AST', '16057717200', -14400, '0'),
(59, 'ADT', '16068607200', -10800, '1'),
(59, 'AST', '16089166800', -14400, '0'),
(59, 'ADT', '16100056800', -10800, '1'),
(59, 'AST', '16120616400', -14400, '0'),
(59, 'ADT', '16131506400', -10800, '1'),
(59, 'AST', '16152066000', -14400, '0'),
(59, 'ADT', '16162956000', -10800, '1'),
(59, 'AST', '16183515600', -14400, '0'),
(59, 'ADT', '16195010400', -10800, '1'),
(59, 'AST', '16215570000', -14400, '0'),
(59, 'ADT', '16226460000', -10800, '1'),
(59, 'AST', '16247019600', -14400, '0'),
(59, 'ADT', '16257909600', -10800, '1'),
(59, 'AST', '16278469200', -14400, '0'),
(59, 'ADT', '16289359200', -10800, '1'),
(59, 'AST', '16309918800', -14400, '0'),
(59, 'ADT', '16320808800', -10800, '1'),
(59, 'AST', '16341368400', -14400, '0'),
(59, 'ADT', '16352863200', -10800, '1'),
(59, 'AST', '16373422800', -14400, '0'),
(59, 'ADT', '16384312800', -10800, '1'),
(59, 'AST', '16404872400', -14400, '0'),
(59, 'ADT', '16415762400', -10800, '1'),
(59, 'AST', '16436322000', -14400, '0'),
(59, 'ADT', '16447212000', -10800, '1'),
(59, 'AST', '16467771600', -14400, '0'),
(59, 'ADT', '16478661600', -10800, '1'),
(59, 'AST', '16499221200', -14400, '0'),
(59, 'ADT', '16510111200', -10800, '1'),
(59, 'AST', '16530670800', -14400, '0'),
(59, 'ADT', '16542165600', -10800, '1'),
(59, 'AST', '16562725200', -14400, '0'),
(59, 'ADT', '16573615200', -10800, '1'),
(59, 'AST', '16594174800', -14400, '0'),
(59, 'ADT', '16605064800', -10800, '1'),
(59, 'AST', '16625624400', -14400, '0'),
(59, 'ADT', '16636514400', -10800, '1'),
(59, 'AST', '16657074000', -14400, '0'),
(59, 'ADT', '16667964000', -10800, '1'),
(59, 'AST', '16688523600', -14400, '0'),
(59, 'ADT', '16699413600', -10800, '1'),
(59, 'AST', '16719973200', -14400, '0'),
(60, 'LMT', '-1383464381', 27580, '0'),
(60, '+0730', '-1383464380', 27000, '0'),
(60, '+08', '-1167636600', 28800, '0'),
(61, 'LMT', '-2524505245', -16356, '0'),
(61, 'CMT', '-2524505244', -16356, '0'),
(61, 'BOST', '-1205954844', -12756, '1'),
(61, '-04', '-1192307244', -14400, '0'),
(62, 'LMT', '-1826738654', -16547, '0'),
(62, '-0430', '-1826738653', -16200, '0'),
(62, 'AST', '-157750200', -14400, '0'),
(63, 'LMT', '-1767217821', -7780, '0'),
(63, '-02', '-1767217820', -7200, '0'),
(63, '-01', '-1206961200', -3600, '1'),
(63, '-02', '-1191366000', -7200, '0'),
(63, '-01', '-1175378400', -3600, '1'),
(63, '-02', '-1159830000', -7200, '0'),
(63, '-01', '-633823200', -3600, '1'),
(63, '-02', '-622072800', -7200, '0'),
(63, '-01', '-602287200', -3600, '1'),
(63, '-02', '-591836400', -7200, '0'),
(63, '-01', '-570751200', -3600, '1'),
(63, '-02', '-560214000', -7200, '0'),
(63, '-01', '-539128800', -3600, '1'),
(63, '-02', '-531356400', -7200, '0'),
(63, '-01', '-191368800', -3600, '1'),
(63, '-02', '-184201200', -7200, '0'),
(63, '-01', '-155167200', -3600, '1'),
(63, '-02', '-150073200', -7200, '0'),
(63, '-01', '-128901600', -3600, '1'),
(63, '-02', '-121129200', -7200, '0'),
(63, '-01', '-99957600', -3600, '1'),
(63, '-02', '-89593200', -7200, '0'),
(63, '-01', '-68421600', -3600, '1'),
(63, '-02', '-57970800', -7200, '0'),
(63, '-01', '499744800', -3600, '1'),
(63, '-02', '511232400', -7200, '0'),
(63, '-01', '530589600', -3600, '1'),
(63, '-02', '540262800', -7200, '0'),
(63, '-01', '562125600', -3600, '1'),
(63, '-02', '571194000', -7200, '0'),
(63, '-01', '592970400', -3600, '1'),
(63, '-02', '602038800', -7200, '0'),
(63, '-01', '624420000', -3600, '1'),
(63, '-02', '634698000', -7200, '0'),
(63, '-01', '938916000', -3600, '1'),
(63, '-02', '951613200', -7200, '0'),
(63, '-01', '970970400', -3600, '1'),
(63, '-02', '971571600', -7200, '0'),
(63, '-01', '1003024800', -3600, '1'),
(63, '-02', '1013907600', -7200, '0'),
(64, 'LMT', '-1767213965', -11636, '0'),
(64, '-03', '-1767213964', -10800, '0'),
(64, '-02', '-1206957600', -7200, '1'),
(64, '-03', '-1191362400', -10800, '0'),
(64, '-02', '-1175374800', -7200, '1'),
(64, '-03', '-1159826400', -10800, '0'),
(64, '-02', '-633819600', -7200, '1'),
(64, '-03', '-622069200', -10800, '0'),
(64, '-02', '-602283600', -7200, '1'),
(64, '-03', '-591832800', -10800, '0'),
(64, '-02', '-570747600', -7200, '1'),
(64, '-03', '-560210400', -10800, '0'),
(64, '-02', '-539125200', -7200, '1'),
(64, '-03', '-531352800', -10800, '0'),
(64, '-02', '-191365200', -7200, '1'),
(64, '-03', '-184197600', -10800, '0'),
(64, '-02', '-155163600', -7200, '1'),
(64, '-03', '-150069600', -10800, '0'),
(64, '-02', '-128898000', -7200, '1'),
(64, '-03', '-121125600', -10800, '0'),
(64, '-02', '-99954000', -7200, '1'),
(64, '-03', '-89589600', -10800, '0'),
(64, '-02', '-68418000', -7200, '1'),
(64, '-03', '-57967200', -10800, '0'),
(64, '-02', '499748400', -7200, '1'),
(64, '-03', '511236000', -10800, '0'),
(64, '-02', '530593200', -7200, '1'),
(64, '-03', '540266400', -10800, '0'),
(64, '-02', '562129200', -7200, '1'),
(64, '-03', '571197600', -10800, '0'),
(65, 'LMT', '-1767216361', -9240, '0'),
(65, '-03', '-1767216360', -10800, '0'),
(65, '-02', '-1206957600', -7200, '1'),
(65, '-03', '-1191362400', -10800, '0'),
(65, '-02', '-1175374800', -7200, '1'),
(65, '-03', '-1159826400', -10800, '0'),
(65, '-02', '-633819600', -7200, '1'),
(65, '-03', '-622069200', -10800, '0'),
(65, '-02', '-602283600', -7200, '1'),
(65, '-03', '-591832800', -10800, '0'),
(65, '-02', '-570747600', -7200, '1'),
(65, '-03', '-560210400', -10800, '0'),
(65, '-02', '-539125200', -7200, '1'),
(65, '-03', '-531352800', -10800, '0'),
(65, '-02', '-191365200', -7200, '1'),
(65, '-03', '-184197600', -10800, '0'),
(65, '-02', '-155163600', -7200, '1'),
(65, '-03', '-150069600', -10800, '0'),
(65, '-02', '-128898000', -7200, '1'),
(65, '-03', '-121125600', -10800, '0'),
(65, '-02', '-99954000', -7200, '1'),
(65, '-03', '-89589600', -10800, '0'),
(65, '-02', '-68418000', -7200, '1'),
(65, '-03', '-57967200', -10800, '0'),
(65, '-02', '499748400', -7200, '1'),
(65, '-03', '511236000', -10800, '0'),
(65, '-02', '530593200', -7200, '1'),
(65, '-03', '540266400', -10800, '0'),
(65, '-02', '562129200', -7200, '1'),
(65, '-03', '571197600', -10800, '0'),
(65, '-02', '592974000', -7200, '1'),
(65, '-03', '602042400', -10800, '0'),
(65, '-02', '624423600', -7200, '1'),
(65, '-03', '634701600', -10800, '0'),
(65, '-02', '938919600', -7200, '1'),
(65, '-03', '951616800', -10800, '0'),
(65, '-02', '970974000', -7200, '1'),
(65, '-03', '972180000', -10800, '0'),
(65, '-02', '1003028400', -7200, '1'),
(65, '-03', '1013911200', -10800, '0'),
(66, 'LMT', '-1767217225', -8376, '0'),
(66, '-03', '-1767217224', -10800, '0'),
(66, '-02', '-1206957600', -7200, '1'),
(66, '-03', '-1191362400', -10800, '0'),
(66, '-02', '-1175374800', -7200, '1'),
(66, '-03', '-1159826400', -10800, '0'),
(66, '-02', '-633819600', -7200, '1'),
(66, '-03', '-622069200', -10800, '0'),
(66, '-02', '-602283600', -7200, '1'),
(66, '-03', '-591832800', -10800, '0'),
(66, '-02', '-570747600', -7200, '1'),
(66, '-03', '-560210400', -10800, '0'),
(66, '-02', '-539125200', -7200, '1'),
(66, '-03', '-531352800', -10800, '0'),
(66, '-02', '-191365200', -7200, '1'),
(66, '-03', '-184197600', -10800, '0'),
(66, '-02', '-155163600', -7200, '1'),
(66, '-03', '-150069600', -10800, '0'),
(66, '-02', '-128898000', -7200, '1'),
(66, '-03', '-121125600', -10800, '0'),
(66, '-02', '-99954000', -7200, '1'),
(66, '-03', '-89589600', -10800, '0'),
(66, '-02', '-68418000', -7200, '1'),
(66, '-03', '-57967200', -10800, '0'),
(66, '-02', '499748400', -7200, '1'),
(66, '-03', '511236000', -10800, '0'),
(66, '-02', '530593200', -7200, '1'),
(66, '-03', '540266400', -10800, '0'),
(66, '-02', '562129200', -7200, '1'),
(66, '-03', '571197600', -10800, '0'),
(66, '-02', '592974000', -7200, '1'),
(66, '-03', '602042400', -10800, '0'),
(66, '-02', '624423600', -7200, '1'),
(66, '-03', '634701600', -10800, '0'),
(66, '-02', '938919600', -7200, '1'),
(66, '-03', '951616800', -10800, '0'),
(66, '-02', '970974000', -7200, '1'),
(66, '-03', '971575200', -10800, '0'),
(66, '-02', '1003028400', -7200, '1'),
(66, '-03', '1013911200', -10800, '0'),
(67, 'LMT', '-1767214033', -11568, '0'),
(67, '-03', '-1767214032', -10800, '0'),
(67, '-02', '-1206957600', -7200, '1'),
(67, '-03', '-1191362400', -10800, '0'),
(67, '-02', '-1175374800', -7200, '1'),
(67, '-03', '-1159826400', -10800, '0'),
(67, '-02', '-633819600', -7200, '1'),
(67, '-03', '-622069200', -10800, '0'),
(67, '-02', '-602283600', -7200, '1'),
(67, '-03', '-591832800', -10800, '0'),
(67, '-02', '-570747600', -7200, '1'),
(67, '-03', '-560210400', -10800, '0'),
(67, '-02', '-539125200', -7200, '1'),
(67, '-03', '-531352800', -10800, '0'),
(67, '-02', '-191365200', -7200, '1'),
(67, '-03', '-184197600', -10800, '0'),
(67, '-02', '-155163600', -7200, '1'),
(67, '-03', '-150069600', -10800, '0'),
(67, '-02', '-128898000', -7200, '1'),
(67, '-03', '-121125600', -10800, '0'),
(67, '-02', '-99954000', -7200, '1'),
(67, '-03', '-89589600', -10800, '0'),
(67, '-02', '-68418000', -7200, '1'),
(67, '-03', '-57967200', -10800, '0'),
(67, '-02', '499748400', -7200, '1'),
(67, '-03', '511236000', -10800, '0'),
(67, '-02', '530593200', -7200, '1'),
(67, '-03', '540266400', -10800, '0'),
(67, '-02', '562129200', -7200, '1'),
(67, '-03', '571197600', -10800, '0'),
(67, '-02', '592974000', -7200, '1'),
(67, '-03', '602042400', -10800, '0'),
(67, '-02', '624423600', -7200, '1'),
(67, '-03', '634701600', -10800, '0'),
(67, '-02', '813726000', -7200, '1'),
(67, '-03', '824004000', -10800, '0'),
(67, '-02', '844570800', -7200, '1'),
(67, '-03', '856058400', -10800, '0'),
(67, '-02', '876106800', -7200, '1'),
(67, '-03', '888717600', -10800, '0'),
(67, '-02', '908074800', -7200, '1'),
(67, '-03', '919562400', -10800, '0'),
(67, '-02', '938919600', -7200, '1'),
(67, '-03', '951616800', -10800, '0'),
(67, '-02', '970974000', -7200, '1'),
(67, '-03', '982461600', -10800, '0'),
(67, '-02', '1003028400', -7200, '1'),
(67, '-03', '1013911200', -10800, '0'),
(67, '-02', '1036292400', -7200, '1'),
(67, '-03', '1045360800', -10800, '0'),
(67, '-02', '1350788400', -7200, '1'),
(67, '-03', '1361066400', -10800, '0'),
(68, 'LMT', '-1767217029', -8572, '0'),
(68, '-03', '-1767217028', -10800, '0'),
(68, '-02', '-1206957600', -7200, '1'),
(68, '-03', '-1191362400', -10800, '0'),
(68, '-02', '-1175374800', -7200, '1'),
(68, '-03', '-1159826400', -10800, '0'),
(68, '-02', '-633819600', -7200, '1'),
(68, '-03', '-622069200', -10800, '0'),
(68, '-02', '-602283600', -7200, '1'),
(68, '-03', '-591832800', -10800, '0'),
(68, '-02', '-570747600', -7200, '1'),
(68, '-03', '-560210400', -10800, '0'),
(68, '-02', '-539125200', -7200, '1'),
(68, '-03', '-531352800', -10800, '0'),
(68, '-02', '-191365200', -7200, '1'),
(68, '-03', '-184197600', -10800, '0'),
(68, '-02', '-155163600', -7200, '1'),
(68, '-03', '-150069600', -10800, '0'),
(68, '-02', '-128898000', -7200, '1'),
(68, '-03', '-121125600', -10800, '0'),
(68, '-02', '-99954000', -7200, '1'),
(68, '-03', '-89589600', -10800, '0'),
(68, '-02', '-68418000', -7200, '1'),
(68, '-03', '-57967200', -10800, '0'),
(68, '-02', '499748400', -7200, '1'),
(68, '-03', '511236000', -10800, '0'),
(68, '-02', '530593200', -7200, '1'),
(68, '-03', '540266400', -10800, '0'),
(68, '-02', '562129200', -7200, '1'),
(68, '-03', '571197600', -10800, '0'),
(68, '-02', '592974000', -7200, '1'),
(68, '-03', '602042400', -10800, '0'),
(68, '-02', '624423600', -7200, '1'),
(68, '-03', '634701600', -10800, '0'),
(68, '-02', '813726000', -7200, '1'),
(68, '-03', '824004000', -10800, '0'),
(68, '-02', '938919600', -7200, '1'),
(68, '-03', '951616800', -10800, '0'),
(68, '-02', '970974000', -7200, '1'),
(68, '-03', '972180000', -10800, '0'),
(68, '-02', '1003028400', -7200, '1'),
(68, '-03', '1013911200', -10800, '0'),
(69, 'LMT', '-1767216357', -9244, '0'),
(69, '-03', '-1767216356', -10800, '0'),
(69, '-02', '-1206957600', -7200, '1'),
(69, '-03', '-1191362400', -10800, '0'),
(69, '-02', '-1175374800', -7200, '1'),
(69, '-03', '-1159826400', -10800, '0'),
(69, '-02', '-633819600', -7200, '1'),
(69, '-03', '-622069200', -10800, '0'),
(69, '-02', '-602283600', -7200, '1'),
(69, '-03', '-591832800', -10800, '0'),
(69, '-02', '-570747600', -7200, '1'),
(69, '-03', '-560210400', -10800, '0'),
(69, '-02', '-539125200', -7200, '1'),
(69, '-03', '-531352800', -10800, '0'),
(69, '-02', '-191365200', -7200, '1'),
(69, '-03', '-184197600', -10800, '0'),
(69, '-02', '-155163600', -7200, '1'),
(69, '-03', '-150069600', -10800, '0'),
(69, '-02', '-128898000', -7200, '1'),
(69, '-03', '-121125600', -10800, '0'),
(69, '-02', '-99954000', -7200, '1'),
(69, '-03', '-89589600', -10800, '0'),
(69, '-02', '-68418000', -7200, '1'),
(69, '-03', '-57967200', -10800, '0'),
(69, '-02', '499748400', -7200, '1'),
(69, '-03', '511236000', -10800, '0'),
(69, '-02', '530593200', -7200, '1'),
(69, '-03', '540266400', -10800, '0'),
(69, '-02', '562129200', -7200, '1'),
(69, '-03', '571197600', -10800, '0'),
(69, '-02', '592974000', -7200, '1'),
(69, '-03', '602042400', -10800, '0'),
(69, '-02', '624423600', -7200, '1'),
(69, '-03', '634701600', -10800, '0'),
(69, '-02', '656478000', -7200, '1'),
(69, '-03', '666756000', -10800, '0'),
(69, '-02', '687927600', -7200, '1'),
(69, '-03', '697600800', -10800, '0'),
(69, '-02', '719982000', -7200, '1'),
(69, '-03', '728445600', -10800, '0'),
(69, '-02', '750826800', -7200, '1'),
(69, '-03', '761709600', -10800, '0'),
(69, '-02', '782276400', -7200, '1'),
(69, '-03', '793159200', -10800, '0'),
(69, '-02', '813726000', -7200, '1'),
(69, '-03', '824004000', -10800, '0'),
(69, '-02', '844570800', -7200, '1'),
(69, '-03', '856058400', -10800, '0'),
(69, '-02', '876106800', -7200, '1'),
(69, '-03', '888717600', -10800, '0'),
(69, '-02', '908074800', -7200, '1'),
(69, '-03', '919562400', -10800, '0'),
(69, '-02', '938919600', -7200, '1'),
(69, '-03', '951616800', -10800, '0'),
(69, '-02', '970974000', -7200, '1'),
(69, '-03', '982461600', -10800, '0'),
(69, '-02', '1003028400', -7200, '1'),
(69, '-03', '1013911200', -10800, '0'),
(69, '-02', '1036292400', -7200, '1'),
(69, '-03', '1045360800', -10800, '0'),
(69, '-02', '1318734000', -7200, '1'),
(69, '-03', '1330221600', -10800, '0'),
(70, 'LMT', '-1767214413', -11188, '0'),
(70, '-03', '-1767214412', -10800, '0'),
(70, '-02', '-1206957600', -7200, '1'),
(70, '-03', '-1191362400', -10800, '0'),
(70, '-02', '-1175374800', -7200, '1'),
(70, '-03', '-1159826400', -10800, '0'),
(70, '-02', '-633819600', -7200, '1'),
(70, '-03', '-622069200', -10800, '0'),
(70, '-02', '-602283600', -7200, '1'),
(70, '-03', '-591832800', -10800, '0'),
(70, '-02', '-570747600', -7200, '1'),
(70, '-03', '-560210400', -10800, '0'),
(70, '-02', '-539125200', -7200, '1'),
(70, '-03', '-531352800', -10800, '0'),
(70, '-02', '-195426000', -7200, '1'),
(70, '-03', '-184197600', -10800, '0'),
(70, '-02', '-155163600', -7200, '1'),
(70, '-03', '-150069600', -10800, '0'),
(70, '-02', '-128898000', -7200, '1'),
(70, '-03', '-121125600', -10800, '0'),
(70, '-02', '-99954000', -7200, '1'),
(70, '-03', '-89589600', -10800, '0'),
(70, '-02', '-68418000', -7200, '1'),
(70, '-03', '-57967200', -10800, '0'),
(70, '-02', '499748400', -7200, '1'),
(70, '-03', '511236000', -10800, '0'),
(70, '-02', '530593200', -7200, '1'),
(70, '-03', '540266400', -10800, '0'),
(70, '-02', '562129200', -7200, '1'),
(70, '-03', '571197600', -10800, '0'),
(70, '-02', '592974000', -7200, '1'),
(70, '-03', '602042400', -10800, '0'),
(70, '-02', '624423600', -7200, '1'),
(70, '-03', '634701600', -10800, '0'),
(70, '-02', '656478000', -7200, '1'),
(70, '-03', '666756000', -10800, '0'),
(70, '-02', '687927600', -7200, '1'),
(70, '-03', '697600800', -10800, '0'),
(70, '-02', '719982000', -7200, '1'),
(70, '-03', '728445600', -10800, '0'),
(70, '-02', '750826800', -7200, '1'),
(70, '-03', '761709600', -10800, '0'),
(70, '-02', '782276400', -7200, '1'),
(70, '-03', '793159200', -10800, '0'),
(70, '-02', '813726000', -7200, '1'),
(70, '-03', '824004000', -10800, '0'),
(70, '-02', '844570800', -7200, '1'),
(70, '-03', '856058400', -10800, '0'),
(70, '-02', '876106800', -7200, '1'),
(70, '-03', '888717600', -10800, '0'),
(70, '-02', '908074800', -7200, '1'),
(70, '-03', '919562400', -10800, '0'),
(70, '-02', '938919600', -7200, '1'),
(70, '-03', '951616800', -10800, '0'),
(70, '-02', '970974000', -7200, '1'),
(70, '-03', '982461600', -10800, '0'),
(70, '-02', '1003028400', -7200, '1'),
(70, '-03', '1013911200', -10800, '0'),
(70, '-02', '1036292400', -7200, '1'),
(70, '-03', '1045360800', -10800, '0'),
(70, '-02', '1066532400', -7200, '1'),
(70, '-03', '1076810400', -10800, '0'),
(70, '-02', '1099364400', -7200, '1'),
(70, '-03', '1108864800', -10800, '0'),
(70, '-02', '1129431600', -7200, '1'),
(70, '-03', '1140314400', -10800, '0'),
(70, '-02', '1162695600', -7200, '1'),
(70, '-03', '1172368800', -10800, '0'),
(70, '-02', '1192330800', -7200, '1'),
(70, '-03', '1203213600', -10800, '0'),
(70, '-02', '1224385200', -7200, '1'),
(70, '-03', '1234663200', -10800, '0'),
(70, '-02', '1255834800', -7200, '1'),
(70, '-03', '1266717600', -10800, '0'),
(70, '-02', '1287284400', -7200, '1'),
(70, '-03', '1298167200', -10800, '0'),
(70, '-02', '1318734000', -7200, '1'),
(70, '-03', '1330221600', -10800, '0'),
(70, '-02', '1350788400', -7200, '1'),
(70, '-03', '1361066400', -10800, '0'),
(70, '-02', '1382238000', -7200, '1'),
(70, '-03', '1392516000', -10800, '0'),
(70, '-02', '1413687600', -7200, '1'),
(70, '-03', '1424570400', -10800, '0'),
(70, '-02', '1445137200', -7200, '1'),
(70, '-03', '1456020000', -10800, '0'),
(70, '-02', '1476586800', -7200, '1'),
(70, '-03', '1487469600', -10800, '0'),
(70, '-02', '1508036400', -7200, '1'),
(70, '-03', '1518919200', -10800, '0'),
(70, '-02', '1540090800', -7200, '1'),
(70, '-03', '1550368800', -10800, '0'),
(70, '-02', '1571540400', -7200, '1'),
(70, '-03', '1581818400', -10800, '0'),
(70, '-02', '1602990000', -7200, '1'),
(70, '-03', '1613872800', -10800, '0'),
(70, '-02', '1634439600', -7200, '1'),
(70, '-03', '1645322400', -10800, '0'),
(70, '-02', '1665889200', -7200, '1'),
(70, '-03', '1677376800', -10800, '0'),
(70, '-02', '1697338800', -7200, '1'),
(70, '-03', '1708221600', -10800, '0'),
(70, '-02', '1729393200', -7200, '1'),
(70, '-03', '1739671200', -10800, '0'),
(70, '-02', '1760842800', -7200, '1'),
(70, '-03', '1771725600', -10800, '0'),
(70, '-02', '1792292400', -7200, '1'),
(70, '-03', '1803175200', -10800, '0'),
(70, '-02', '1823742000', -7200, '1'),
(70, '-03', '1834624800', -10800, '0'),
(70, '-02', '1855191600', -7200, '1'),
(70, '-03', '1866074400', -10800, '0'),
(70, '-02', '1887246000', -7200, '1'),
(70, '-03', '1897524000', -10800, '0'),
(70, '-02', '1918695600', -7200, '1'),
(70, '-03', '1928973600', -10800, '0'),
(70, '-02', '1950145200', -7200, '1'),
(70, '-03', '1960423200', -10800, '0'),
(70, '-02', '1981594800', -7200, '1'),
(70, '-03', '1992477600', -10800, '0'),
(70, '-02', '2013044400', -7200, '1'),
(70, '-03', '2024532000', -10800, '0'),
(70, '-02', '2044494000', -7200, '1'),
(70, '-03', '2055376800', -10800, '0'),
(70, '-02', '2076548400', -7200, '1'),
(70, '-03', '2086826400', -10800, '0'),
(70, '-02', '2107998000', -7200, '1'),
(70, '-03', '2118880800', -10800, '0'),
(70, '-02', '2139447600', -7200, '1'),
(70, '-03', '2150330400', -10800, '0'),
(70, '-02', '2170897200', -7200, '1'),
(70, '-03', '2181780000', -10800, '0'),
(70, '-02', '2202346800', -7200, '1'),
(70, '-03', '2213229600', -10800, '0'),
(70, '-02', '2234401200', -7200, '1'),
(70, '-03', '2244679200', -10800, '0'),
(70, '-02', '2265850800', -7200, '1'),
(70, '-03', '2276128800', -10800, '0'),
(70, '-02', '2297300400', -7200, '1'),
(70, '-03', '2307578400', -10800, '0'),
(70, '-02', '2328750000', -7200, '1'),
(70, '-03', '2339632800', -10800, '0'),
(70, '-02', '2360199600', -7200, '1'),
(70, '-03', '2371082400', -10800, '0'),
(70, '-02', '2391649200', -7200, '1'),
(70, '-03', '2402532000', -10800, '0'),
(70, '-02', '2423703600', -7200, '1'),
(70, '-03', '2433981600', -10800, '0'),
(70, '-02', '2455153200', -7200, '1'),
(70, '-03', '2465431200', -10800, '0'),
(70, '-02', '2486602800', -7200, '1'),
(70, '-03', '2497485600', -10800, '0'),
(70, '-02', '2518052400', -7200, '1'),
(70, '-03', '2528935200', -10800, '0'),
(70, '-02', '2549502000', -7200, '1'),
(70, '-03', '2560384800', -10800, '0'),
(70, '-02', '2580951600', -7200, '1'),
(70, '-03', '2591834400', -10800, '0'),
(70, '-02', '2613006000', -7200, '1'),
(70, '-03', '2623284000', -10800, '0'),
(70, '-02', '2644455600', -7200, '1'),
(70, '-03', '2654733600', -10800, '0'),
(70, '-02', '2675905200', -7200, '1'),
(70, '-03', '2686788000', -10800, '0'),
(70, '-02', '2707354800', -7200, '1'),
(70, '-03', '2718237600', -10800, '0'),
(70, '-02', '2738804400', -7200, '1'),
(70, '-03', '2749687200', -10800, '0'),
(70, '-02', '2770858800', -7200, '1'),
(70, '-03', '2781136800', -10800, '0'),
(70, '-02', '2802308400', -7200, '1'),
(70, '-03', '2812586400', -10800, '0'),
(70, '-02', '2833758000', -7200, '1'),
(70, '-03', '2844036000', -10800, '0'),
(70, '-02', '2865207600', -7200, '1'),
(70, '-03', '2876090400', -10800, '0'),
(70, '-02', '2896657200', -7200, '1'),
(70, '-03', '2907540000', -10800, '0'),
(70, '-02', '2928106800', -7200, '1'),
(70, '-03', '2938989600', -10800, '0'),
(70, '-02', '2960161200', -7200, '1'),
(70, '-03', '2970439200', -10800, '0'),
(70, '-02', '2991610800', -7200, '1'),
(70, '-03', '3001888800', -10800, '0'),
(70, '-02', '3023060400', -7200, '1'),
(70, '-03', '3033943200', -10800, '0'),
(70, '-02', '3054510000', -7200, '1'),
(70, '-03', '3065392800', -10800, '0'),
(70, '-02', '3085959600', -7200, '1'),
(70, '-03', '3096842400', -10800, '0'),
(70, '-02', '3118014000', -7200, '1'),
(70, '-03', '3128292000', -10800, '0'),
(70, '-02', '3149463600', -7200, '1'),
(70, '-03', '3159741600', -10800, '0'),
(70, '-02', '3180913200', -7200, '1'),
(70, '-03', '3191191200', -10800, '0'),
(70, '-02', '3212362800', -7200, '1'),
(70, '-03', '3223245600', -10800, '0'),
(70, '-02', '3243812400', -7200, '1'),
(70, '-03', '3254695200', -10800, '0'),
(70, '-02', '3275262000', -7200, '1'),
(70, '-03', '3286144800', -10800, '0'),
(70, '-02', '3307316400', -7200, '1'),
(70, '-03', '3317594400', -10800, '0'),
(70, '-02', '3338766000', -7200, '1'),
(70, '-03', '3349044000', -10800, '0'),
(70, '-02', '3370215600', -7200, '1'),
(70, '-03', '3381098400', -10800, '0'),
(70, '-02', '3401665200', -7200, '1'),
(70, '-03', '3412548000', -10800, '0'),
(70, '-02', '3433114800', -7200, '1'),
(70, '-03', '3443997600', -10800, '0'),
(70, '-02', '3464564400', -7200, '1'),
(70, '-03', '3475447200', -10800, '0'),
(70, '-02', '3496618800', -7200, '1'),
(70, '-03', '3506896800', -10800, '0'),
(70, '-02', '3528068400', -7200, '1'),
(70, '-03', '3538346400', -10800, '0'),
(70, '-02', '3559518000', -7200, '1'),
(70, '-03', '3570400800', -10800, '0'),
(70, '-02', '3590967600', -7200, '1'),
(70, '-03', '3601850400', -10800, '0'),
(70, '-02', '3622417200', -7200, '1'),
(70, '-03', '3633300000', -10800, '0'),
(70, '-02', '3654471600', -7200, '1'),
(70, '-03', '3664749600', -10800, '0'),
(70, '-02', '3685921200', -7200, '1'),
(70, '-03', '3696199200', -10800, '0'),
(70, '-02', '3717370800', -7200, '1'),
(70, '-03', '3727648800', -10800, '0'),
(70, '-02', '3748820400', -7200, '1'),
(70, '-03', '3759703200', -10800, '0'),
(70, '-02', '3780270000', -7200, '1'),
(70, '-03', '3791152800', -10800, '0'),
(70, '-02', '3811719600', -7200, '1'),
(70, '-03', '3822602400', -10800, '0'),
(70, '-02', '3843774000', -7200, '1'),
(70, '-03', '3854052000', -10800, '0'),
(70, '-02', '3875223600', -7200, '1'),
(70, '-03', '3885501600', -10800, '0'),
(70, '-02', '3906673200', -7200, '1'),
(70, '-03', '3917556000', -10800, '0'),
(70, '-02', '3938122800', -7200, '1'),
(70, '-03', '3949005600', -10800, '0'),
(70, '-02', '3969572400', -7200, '1'),
(70, '-03', '3980455200', -10800, '0'),
(70, '-02', '4001626800', -7200, '1'),
(70, '-03', '4011904800', -10800, '0'),
(70, '-02', '4033076400', -7200, '1'),
(70, '-03', '4043354400', -10800, '0'),
(70, '-02', '4064526000', -7200, '1'),
(70, '-03', '4074804000', -10800, '0'),
(70, '-02', '4095975600', -7200, '1'),
(70, '-03', '4106858400', -10800, '0'),
(70, '-02', '4127425200', -7200, '1'),
(70, '-03', '4138308000', -10800, '0'),
(70, '-02', '4158874800', -7200, '1'),
(70, '-03', '4169757600', -10800, '0'),
(70, '-02', '4190324400', -7200, '1'),
(70, '-03', '4201207200', -10800, '0'),
(70, '-02', '4222378800', -7200, '1'),
(70, '-03', '4232656800', -10800, '0'),
(70, '-02', '4253828400', -7200, '1'),
(70, '-03', '4264106400', -10800, '0'),
(70, '-02', '4285278000', -7200, '1'),
(70, '-03', '4296160800', -10800, '0'),
(70, '-02', '4316727600', -7200, '1'),
(70, '-03', '4327610400', -10800, '0'),
(70, '-02', '4348177200', -7200, '1'),
(70, '-03', '4359060000', -10800, '0'),
(70, '-02', '4380231600', -7200, '1'),
(70, '-03', '4390509600', -10800, '0'),
(70, '-02', '4411681200', -7200, '1'),
(70, '-03', '4421959200', -10800, '0'),
(70, '-02', '4443130800', -7200, '1'),
(70, '-03', '4453408800', -10800, '0'),
(70, '-02', '4474580400', -7200, '1'),
(70, '-03', '4485463200', -10800, '0'),
(70, '-02', '4506030000', -7200, '1'),
(70, '-03', '4516912800', -10800, '0'),
(70, '-02', '4537479600', -7200, '1'),
(70, '-03', '4548362400', -10800, '0'),
(70, '-02', '4569534000', -7200, '1'),
(70, '-03', '4579812000', -10800, '0'),
(70, '-02', '4600983600', -7200, '1'),
(70, '-03', '4611261600', -10800, '0'),
(70, '-02', '4632433200', -7200, '1'),
(70, '-03', '4643316000', -10800, '0'),
(70, '-02', '4663882800', -7200, '1'),
(70, '-03', '4674765600', -10800, '0'),
(70, '-02', '4695332400', -7200, '1'),
(70, '-03', '4706215200', -10800, '0'),
(70, '-02', '4726782000', -7200, '1'),
(70, '-03', '4737664800', -10800, '0'),
(70, '-02', '4758836400', -7200, '1'),
(70, '-03', '4769114400', -10800, '0'),
(70, '-02', '4790286000', -7200, '1'),
(70, '-03', '4800564000', -10800, '0'),
(70, '-02', '4821735600', -7200, '1'),
(70, '-03', '4832618400', -10800, '0'),
(70, '-02', '4853185200', -7200, '1'),
(70, '-03', '4864068000', -10800, '0'),
(70, '-02', '4884634800', -7200, '1'),
(70, '-03', '4895517600', -10800, '0'),
(70, '-02', '4916689200', -7200, '1'),
(70, '-03', '4926967200', -10800, '0'),
(70, '-02', '4948138800', -7200, '1'),
(70, '-03', '4958416800', -10800, '0'),
(70, '-02', '4979588400', -7200, '1'),
(70, '-03', '4989866400', -10800, '0'),
(70, '-02', '5011038000', -7200, '1'),
(70, '-03', '5021920800', -10800, '0'),
(70, '-02', '5042487600', -7200, '1'),
(70, '-03', '5053370400', -10800, '0'),
(70, '-02', '5073937200', -7200, '1'),
(70, '-03', '5084820000', -10800, '0'),
(70, '-02', '5105991600', -7200, '1'),
(70, '-03', '5116269600', -10800, '0'),
(70, '-02', '5137441200', -7200, '1'),
(70, '-03', '5147719200', -10800, '0'),
(70, '-02', '5168890800', -7200, '1'),
(70, '-03', '5179773600', -10800, '0'),
(70, '-02', '5200340400', -7200, '1'),
(70, '-03', '5211223200', -10800, '0'),
(70, '-02', '5231790000', -7200, '1'),
(70, '-03', '5242672800', -10800, '0'),
(70, '-02', '5263844400', -7200, '1'),
(70, '-03', '5274122400', -10800, '0'),
(70, '-02', '5295294000', -7200, '1'),
(70, '-03', '5305572000', -10800, '0'),
(70, '-02', '5326743600', -7200, '1'),
(70, '-03', '5337021600', -10800, '0'),
(70, '-02', '5358193200', -7200, '1'),
(70, '-03', '5369076000', -10800, '0'),
(70, '-02', '5389642800', -7200, '1'),
(70, '-03', '5400525600', -10800, '0'),
(70, '-02', '5421092400', -7200, '1'),
(70, '-03', '5431975200', -10800, '0'),
(70, '-02', '5453146800', -7200, '1'),
(70, '-03', '5463424800', -10800, '0'),
(70, '-02', '5484596400', -7200, '1'),
(70, '-03', '5494874400', -10800, '0'),
(70, '-02', '5516046000', -7200, '1'),
(70, '-03', '5526928800', -10800, '0'),
(70, '-02', '5547495600', -7200, '1'),
(70, '-03', '5558378400', -10800, '0'),
(70, '-02', '5578945200', -7200, '1'),
(70, '-03', '5589828000', -10800, '0'),
(70, '-02', '5610394800', -7200, '1'),
(70, '-03', '5621277600', -10800, '0'),
(70, '-02', '5642449200', -7200, '1'),
(70, '-03', '5652727200', -10800, '0'),
(70, '-02', '5673898800', -7200, '1'),
(70, '-03', '5684176800', -10800, '0'),
(70, '-02', '5705348400', -7200, '1'),
(70, '-03', '5716231200', -10800, '0'),
(70, '-02', '5736798000', -7200, '1'),
(70, '-03', '5747680800', -10800, '0'),
(70, '-02', '5768247600', -7200, '1'),
(70, '-03', '5779130400', -10800, '0'),
(70, '-02', '5800302000', -7200, '1'),
(70, '-03', '5810580000', -10800, '0'),
(70, '-02', '5831751600', -7200, '1'),
(70, '-03', '5842029600', -10800, '0'),
(70, '-02', '5863201200', -7200, '1'),
(70, '-03', '5873479200', -10800, '0'),
(70, '-02', '5894650800', -7200, '1'),
(70, '-03', '5905533600', -10800, '0'),
(70, '-02', '5926100400', -7200, '1'),
(70, '-03', '5936983200', -10800, '0'),
(70, '-02', '5957550000', -7200, '1'),
(70, '-03', '5968432800', -10800, '0'),
(70, '-02', '5989604400', -7200, '1'),
(70, '-03', '5999882400', -10800, '0'),
(70, '-02', '6021054000', -7200, '1'),
(70, '-03', '6031332000', -10800, '0'),
(70, '-02', '6052503600', -7200, '1'),
(70, '-03', '6063386400', -10800, '0'),
(70, '-02', '6083953200', -7200, '1'),
(70, '-03', '6094836000', -10800, '0'),
(70, '-02', '6115402800', -7200, '1'),
(70, '-03', '6126285600', -10800, '0'),
(70, '-02', '6147457200', -7200, '1'),
(70, '-03', '6157735200', -10800, '0'),
(70, '-02', '6178906800', -7200, '1'),
(70, '-03', '6189184800', -10800, '0'),
(70, '-02', '6210356400', -7200, '1'),
(70, '-03', '6220634400', -10800, '0'),
(70, '-02', '6241806000', -7200, '1'),
(70, '-03', '6252688800', -10800, '0'),
(70, '-02', '6273255600', -7200, '1'),
(70, '-03', '6284138400', -10800, '0'),
(70, '-02', '6304705200', -7200, '1'),
(70, '-03', '6315588000', -10800, '0'),
(70, '-02', '6336759600', -7200, '1'),
(70, '-03', '6347037600', -10800, '0'),
(70, '-02', '6368209200', -7200, '1'),
(70, '-03', '6378487200', -10800, '0'),
(70, '-02', '6399658800', -7200, '1'),
(70, '-03', '6410541600', -10800, '0'),
(70, '-02', '6431108400', -7200, '1'),
(70, '-03', '6441991200', -10800, '0'),
(70, '-02', '6462558000', -7200, '1'),
(70, '-03', '6473440800', -10800, '0'),
(70, '-02', '6494007600', -7200, '1'),
(70, '-03', '6504890400', -10800, '0'),
(70, '-02', '6526062000', -7200, '1'),
(70, '-03', '6536340000', -10800, '0'),
(70, '-02', '6557511600', -7200, '1'),
(70, '-03', '6567789600', -10800, '0'),
(70, '-02', '6588961200', -7200, '1'),
(70, '-03', '6599844000', -10800, '0'),
(70, '-02', '6620410800', -7200, '1'),
(70, '-03', '6631293600', -10800, '0'),
(70, '-02', '6651860400', -7200, '1'),
(70, '-03', '6662743200', -10800, '0'),
(70, '-02', '6683914800', -7200, '1'),
(70, '-03', '6694192800', -10800, '0'),
(70, '-02', '6715364400', -7200, '1'),
(70, '-03', '6725642400', -10800, '0'),
(70, '-02', '6746814000', -7200, '1'),
(70, '-03', '6757092000', -10800, '0'),
(70, '-02', '6778263600', -7200, '1'),
(70, '-03', '6789146400', -10800, '0'),
(70, '-02', '6809713200', -7200, '1'),
(70, '-03', '6820596000', -10800, '0'),
(70, '-02', '6841162800', -7200, '1'),
(70, '-03', '6852045600', -10800, '0'),
(70, '-02', '6873217200', -7200, '1'),
(70, '-03', '6883495200', -10800, '0'),
(70, '-02', '6904666800', -7200, '1'),
(70, '-03', '6914944800', -10800, '0'),
(70, '-02', '6936116400', -7200, '1'),
(70, '-03', '6946999200', -10800, '0'),
(70, '-02', '6967566000', -7200, '1'),
(70, '-03', '6978448800', -10800, '0'),
(70, '-02', '6999015600', -7200, '1'),
(70, '-03', '7009898400', -10800, '0'),
(70, '-02', '7031070000', -7200, '1'),
(70, '-03', '7041348000', -10800, '0'),
(70, '-02', '7062519600', -7200, '1'),
(70, '-03', '7072797600', -10800, '0'),
(70, '-02', '7093969200', -7200, '1'),
(70, '-03', '7104247200', -10800, '0'),
(70, '-02', '7125418800', -7200, '1'),
(70, '-03', '7136301600', -10800, '0'),
(70, '-02', '7156868400', -7200, '1'),
(70, '-03', '7167751200', -10800, '0'),
(70, '-02', '7188318000', -7200, '1'),
(70, '-03', '7199200800', -10800, '0'),
(70, '-02', '7220372400', -7200, '1'),
(70, '-03', '7230650400', -10800, '0'),
(70, '-02', '7251822000', -7200, '1'),
(70, '-03', '7262100000', -10800, '0'),
(70, '-02', '7283271600', -7200, '1'),
(70, '-03', '7293549600', -10800, '0'),
(70, '-02', '7314721200', -7200, '1'),
(70, '-03', '7325604000', -10800, '0'),
(70, '-02', '7346170800', -7200, '1'),
(70, '-03', '7357053600', -10800, '0'),
(70, '-02', '7377620400', -7200, '1'),
(70, '-03', '7388503200', -10800, '0'),
(70, '-02', '7409674800', -7200, '1'),
(70, '-03', '7419952800', -10800, '0'),
(70, '-02', '7441124400', -7200, '1'),
(70, '-03', '7451402400', -10800, '0'),
(70, '-02', '7472574000', -7200, '1'),
(70, '-03', '7482852000', -10800, '0'),
(70, '-02', '7504023600', -7200, '1'),
(70, '-03', '7514906400', -10800, '0'),
(70, '-02', '7535473200', -7200, '1'),
(70, '-03', '7546356000', -10800, '0'),
(70, '-02', '7566922800', -7200, '1'),
(70, '-03', '7577805600', -10800, '0'),
(70, '-02', '7598977200', -7200, '1'),
(70, '-03', '7609255200', -10800, '0'),
(70, '-02', '7630426800', -7200, '1'),
(70, '-03', '7640704800', -10800, '0'),
(70, '-02', '7661876400', -7200, '1'),
(70, '-03', '7672759200', -10800, '0'),
(70, '-02', '7693326000', -7200, '1'),
(70, '-03', '7704208800', -10800, '0'),
(70, '-02', '7724775600', -7200, '1'),
(70, '-03', '7735658400', -10800, '0'),
(70, '-02', '7756225200', -7200, '1'),
(70, '-03', '7767108000', -10800, '0'),
(70, '-02', '7788279600', -7200, '1'),
(70, '-03', '7798557600', -10800, '0'),
(70, '-02', '7819729200', -7200, '1'),
(70, '-03', '7830007200', -10800, '0'),
(70, '-02', '7851178800', -7200, '1'),
(70, '-03', '7862061600', -10800, '0'),
(70, '-02', '7882628400', -7200, '1'),
(70, '-03', '7893511200', -10800, '0'),
(70, '-02', '7914078000', -7200, '1'),
(70, '-03', '7924960800', -10800, '0'),
(70, '-02', '7946132400', -7200, '1'),
(70, '-03', '7956410400', -10800, '0'),
(70, '-02', '7977582000', -7200, '1'),
(70, '-03', '7987860000', -10800, '0'),
(70, '-02', '8009031600', -7200, '1'),
(70, '-03', '8019309600', -10800, '0'),
(70, '-02', '8040481200', -7200, '1'),
(70, '-03', '8051364000', -10800, '0'),
(70, '-02', '8071930800', -7200, '1'),
(70, '-03', '8082813600', -10800, '0'),
(70, '-02', '8103380400', -7200, '1'),
(70, '-03', '8114263200', -10800, '0'),
(70, '-02', '8135434800', -7200, '1'),
(70, '-03', '8145712800', -10800, '0'),
(70, '-02', '8166884400', -7200, '1'),
(70, '-03', '8177162400', -10800, '0'),
(70, '-02', '8198334000', -7200, '1'),
(70, '-03', '8209216800', -10800, '0'),
(70, '-02', '8229783600', -7200, '1'),
(70, '-03', '8240666400', -10800, '0'),
(70, '-02', '8261233200', -7200, '1'),
(70, '-03', '8272116000', -10800, '0'),
(70, '-02', '8293287600', -7200, '1'),
(70, '-03', '8303565600', -10800, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(70, '-02', '8324737200', -7200, '1'),
(70, '-03', '8335015200', -10800, '0'),
(70, '-02', '8356186800', -7200, '1'),
(70, '-03', '8366464800', -10800, '0'),
(70, '-02', '8387636400', -7200, '1'),
(70, '-03', '8398519200', -10800, '0'),
(70, '-02', '8419086000', -7200, '1'),
(70, '-03', '8429968800', -10800, '0'),
(70, '-02', '8450535600', -7200, '1'),
(70, '-03', '8461418400', -10800, '0'),
(70, '-02', '8482590000', -7200, '1'),
(70, '-03', '8492868000', -10800, '0'),
(70, '-02', '8514039600', -7200, '1'),
(70, '-03', '8524317600', -10800, '0'),
(70, '-02', '8545489200', -7200, '1'),
(70, '-03', '8556372000', -10800, '0'),
(70, '-02', '8576938800', -7200, '1'),
(70, '-03', '8587821600', -10800, '0'),
(70, '-02', '8608388400', -7200, '1'),
(70, '-03', '8619271200', -10800, '0'),
(70, '-02', '8639838000', -7200, '1'),
(70, '-03', '8650720800', -10800, '0'),
(70, '-02', '8671892400', -7200, '1'),
(70, '-03', '8682170400', -10800, '0'),
(70, '-02', '8703342000', -7200, '1'),
(70, '-03', '8713620000', -10800, '0'),
(70, '-02', '8734791600', -7200, '1'),
(70, '-03', '8745674400', -10800, '0'),
(70, '-02', '8766241200', -7200, '1'),
(70, '-03', '8777124000', -10800, '0'),
(70, '-02', '8797690800', -7200, '1'),
(70, '-03', '8808573600', -10800, '0'),
(70, '-02', '8829745200', -7200, '1'),
(70, '-03', '8840023200', -10800, '0'),
(70, '-02', '8861194800', -7200, '1'),
(70, '-03', '8871472800', -10800, '0'),
(70, '-02', '8892644400', -7200, '1'),
(70, '-03', '8902922400', -10800, '0'),
(70, '-02', '8924094000', -7200, '1'),
(70, '-03', '8934976800', -10800, '0'),
(70, '-02', '8955543600', -7200, '1'),
(70, '-03', '8966426400', -10800, '0'),
(70, '-02', '8986993200', -7200, '1'),
(70, '-03', '8997876000', -10800, '0'),
(70, '-02', '9019047600', -7200, '1'),
(70, '-03', '9029325600', -10800, '0'),
(70, '-02', '9050497200', -7200, '1'),
(70, '-03', '9060775200', -10800, '0'),
(70, '-02', '9081946800', -7200, '1'),
(70, '-03', '9092829600', -10800, '0'),
(70, '-02', '9113396400', -7200, '1'),
(70, '-03', '9124279200', -10800, '0'),
(70, '-02', '9144846000', -7200, '1'),
(70, '-03', '9155728800', -10800, '0'),
(70, '-02', '9176900400', -7200, '1'),
(70, '-03', '9187178400', -10800, '0'),
(70, '-02', '9208350000', -7200, '1'),
(70, '-03', '9218628000', -10800, '0'),
(70, '-02', '9239799600', -7200, '1'),
(70, '-03', '9250077600', -10800, '0'),
(70, '-02', '9271249200', -7200, '1'),
(70, '-03', '9282132000', -10800, '0'),
(70, '-02', '9302698800', -7200, '1'),
(70, '-03', '9313581600', -10800, '0'),
(70, '-02', '9334148400', -7200, '1'),
(70, '-03', '9345031200', -10800, '0'),
(70, '-02', '9366202800', -7200, '1'),
(70, '-03', '9376480800', -10800, '0'),
(70, '-02', '9397652400', -7200, '1'),
(70, '-03', '9407930400', -10800, '0'),
(70, '-02', '9429102000', -7200, '1'),
(70, '-03', '9439984800', -10800, '0'),
(70, '-02', '9460551600', -7200, '1'),
(70, '-03', '9471434400', -10800, '0'),
(70, '-02', '9492001200', -7200, '1'),
(70, '-03', '9502884000', -10800, '0'),
(70, '-02', '9523450800', -7200, '1'),
(70, '-03', '9534333600', -10800, '0'),
(70, '-02', '9555505200', -7200, '1'),
(70, '-03', '9565783200', -10800, '0'),
(70, '-02', '9586954800', -7200, '1'),
(70, '-03', '9597232800', -10800, '0'),
(70, '-02', '9618404400', -7200, '1'),
(70, '-03', '9629287200', -10800, '0'),
(70, '-02', '9649854000', -7200, '1'),
(70, '-03', '9660736800', -10800, '0'),
(70, '-02', '9681303600', -7200, '1'),
(70, '-03', '9692186400', -10800, '0'),
(70, '-02', '9713358000', -7200, '1'),
(70, '-03', '9723636000', -10800, '0'),
(70, '-02', '9744807600', -7200, '1'),
(70, '-03', '9755085600', -10800, '0'),
(70, '-02', '9776257200', -7200, '1'),
(70, '-03', '9786535200', -10800, '0'),
(70, '-02', '9807706800', -7200, '1'),
(70, '-03', '9818589600', -10800, '0'),
(70, '-02', '9839156400', -7200, '1'),
(70, '-03', '9850039200', -10800, '0'),
(70, '-02', '9870606000', -7200, '1'),
(70, '-03', '9881488800', -10800, '0'),
(70, '-02', '9902660400', -7200, '1'),
(70, '-03', '9912938400', -10800, '0'),
(70, '-02', '9934110000', -7200, '1'),
(70, '-03', '9944388000', -10800, '0'),
(70, '-02', '9965559600', -7200, '1'),
(70, '-03', '9976442400', -10800, '0'),
(70, '-02', '9997009200', -7200, '1'),
(70, '-03', '10007892000', -10800, '0'),
(70, '-02', '10028458800', -7200, '1'),
(70, '-03', '10039341600', -10800, '0'),
(70, '-02', '10060513200', -7200, '1'),
(70, '-03', '10070791200', -10800, '0'),
(70, '-02', '10091962800', -7200, '1'),
(70, '-03', '10102240800', -10800, '0'),
(70, '-02', '10123412400', -7200, '1'),
(70, '-03', '10133690400', -10800, '0'),
(70, '-02', '10154862000', -7200, '1'),
(70, '-03', '10165744800', -10800, '0'),
(70, '-02', '10186311600', -7200, '1'),
(70, '-03', '10197194400', -10800, '0'),
(70, '-02', '10217761200', -7200, '1'),
(70, '-03', '10228644000', -10800, '0'),
(70, '-02', '10249815600', -7200, '1'),
(70, '-03', '10260093600', -10800, '0'),
(70, '-02', '10281265200', -7200, '1'),
(70, '-03', '10291543200', -10800, '0'),
(70, '-02', '10312714800', -7200, '1'),
(70, '-03', '10323597600', -10800, '0'),
(70, '-02', '10344164400', -7200, '1'),
(70, '-03', '10355047200', -10800, '0'),
(70, '-02', '10375614000', -7200, '1'),
(70, '-03', '10386496800', -10800, '0'),
(70, '-02', '10407063600', -7200, '1'),
(70, '-03', '10417946400', -10800, '0'),
(70, '-02', '10439118000', -7200, '1'),
(70, '-03', '10449396000', -10800, '0'),
(70, '-02', '10470567600', -7200, '1'),
(70, '-03', '10480845600', -10800, '0'),
(70, '-02', '10502017200', -7200, '1'),
(70, '-03', '10512295200', -10800, '0'),
(70, '-02', '10533466800', -7200, '1'),
(70, '-03', '10544349600', -10800, '0'),
(70, '-02', '10564916400', -7200, '1'),
(70, '-03', '10575799200', -10800, '0'),
(70, '-02', '10596366000', -7200, '1'),
(70, '-03', '10607248800', -10800, '0'),
(70, '-02', '10628420400', -7200, '1'),
(70, '-03', '10638698400', -10800, '0'),
(70, '-02', '10659870000', -7200, '1'),
(70, '-03', '10670148000', -10800, '0'),
(70, '-02', '10691319600', -7200, '1'),
(70, '-03', '10702202400', -10800, '0'),
(70, '-02', '10722769200', -7200, '1'),
(70, '-03', '10733652000', -10800, '0'),
(70, '-02', '10754218800', -7200, '1'),
(70, '-03', '10765101600', -10800, '0'),
(70, '-02', '10785668400', -7200, '1'),
(70, '-03', '10796551200', -10800, '0'),
(70, '-02', '10817722800', -7200, '1'),
(70, '-03', '10828000800', -10800, '0'),
(70, '-02', '10849172400', -7200, '1'),
(70, '-03', '10859450400', -10800, '0'),
(70, '-02', '10880622000', -7200, '1'),
(70, '-03', '10891504800', -10800, '0'),
(70, '-02', '10912071600', -7200, '1'),
(70, '-03', '10922954400', -10800, '0'),
(70, '-02', '10943521200', -7200, '1'),
(70, '-03', '10954404000', -10800, '0'),
(70, '-02', '10975575600', -7200, '1'),
(70, '-03', '10985853600', -10800, '0'),
(70, '-02', '11007025200', -7200, '1'),
(70, '-03', '11017303200', -10800, '0'),
(70, '-02', '11038474800', -7200, '1'),
(70, '-03', '11048752800', -10800, '0'),
(70, '-02', '11069924400', -7200, '1'),
(70, '-03', '11080807200', -10800, '0'),
(70, '-02', '11101374000', -7200, '1'),
(70, '-03', '11112256800', -10800, '0'),
(70, '-02', '11132823600', -7200, '1'),
(70, '-03', '11143706400', -10800, '0'),
(70, '-02', '11164878000', -7200, '1'),
(70, '-03', '11175156000', -10800, '0'),
(70, '-02', '11196327600', -7200, '1'),
(70, '-03', '11206605600', -10800, '0'),
(70, '-02', '11227777200', -7200, '1'),
(70, '-03', '11238660000', -10800, '0'),
(70, '-02', '11259226800', -7200, '1'),
(70, '-03', '11270109600', -10800, '0'),
(70, '-02', '11290676400', -7200, '1'),
(70, '-03', '11301559200', -10800, '0'),
(70, '-02', '11322730800', -7200, '1'),
(70, '-03', '11333008800', -10800, '0'),
(70, '-02', '11354180400', -7200, '1'),
(70, '-03', '11364458400', -10800, '0'),
(70, '-02', '11385630000', -7200, '1'),
(70, '-03', '11395908000', -10800, '0'),
(70, '-02', '11417079600', -7200, '1'),
(70, '-03', '11427962400', -10800, '0'),
(70, '-02', '11448529200', -7200, '1'),
(70, '-03', '11459412000', -10800, '0'),
(70, '-02', '11479978800', -7200, '1'),
(70, '-03', '11490861600', -10800, '0'),
(70, '-02', '11512033200', -7200, '1'),
(70, '-03', '11522311200', -10800, '0'),
(70, '-02', '11543482800', -7200, '1'),
(70, '-03', '11553760800', -10800, '0'),
(70, '-02', '11574932400', -7200, '1'),
(70, '-03', '11585815200', -10800, '0'),
(70, '-02', '11606382000', -7200, '1'),
(70, '-03', '11617264800', -10800, '0'),
(70, '-02', '11637831600', -7200, '1'),
(70, '-03', '11648714400', -10800, '0'),
(70, '-02', '11669281200', -7200, '1'),
(70, '-03', '11680164000', -10800, '0'),
(70, '-02', '11701335600', -7200, '1'),
(70, '-03', '11711613600', -10800, '0'),
(70, '-02', '11732785200', -7200, '1'),
(70, '-03', '11743063200', -10800, '0'),
(70, '-02', '11764234800', -7200, '1'),
(70, '-03', '11775117600', -10800, '0'),
(70, '-02', '11795684400', -7200, '1'),
(70, '-03', '11806567200', -10800, '0'),
(70, '-02', '11827134000', -7200, '1'),
(70, '-03', '11838016800', -10800, '0'),
(70, '-02', '11859188400', -7200, '1'),
(70, '-03', '11869466400', -10800, '0'),
(70, '-02', '11890638000', -7200, '1'),
(70, '-03', '11900916000', -10800, '0'),
(70, '-02', '11922087600', -7200, '1'),
(70, '-03', '11932365600', -10800, '0'),
(70, '-02', '11953537200', -7200, '1'),
(70, '-03', '11964420000', -10800, '0'),
(70, '-02', '11984986800', -7200, '1'),
(70, '-03', '11995869600', -10800, '0'),
(70, '-02', '12016436400', -7200, '1'),
(70, '-03', '12027319200', -10800, '0'),
(70, '-02', '12048490800', -7200, '1'),
(70, '-03', '12058768800', -10800, '0'),
(70, '-02', '12079940400', -7200, '1'),
(70, '-03', '12090218400', -10800, '0'),
(70, '-02', '12111390000', -7200, '1'),
(70, '-03', '12122272800', -10800, '0'),
(70, '-02', '12142839600', -7200, '1'),
(70, '-03', '12153722400', -10800, '0'),
(70, '-02', '12174289200', -7200, '1'),
(70, '-03', '12185172000', -10800, '0'),
(70, '-02', '12206343600', -7200, '1'),
(70, '-03', '12216621600', -10800, '0'),
(70, '-02', '12237793200', -7200, '1'),
(70, '-03', '12248071200', -10800, '0'),
(70, '-02', '12269242800', -7200, '1'),
(70, '-03', '12279520800', -10800, '0'),
(70, '-02', '12300692400', -7200, '1'),
(70, '-03', '12311575200', -10800, '0'),
(70, '-02', '12332142000', -7200, '1'),
(70, '-03', '12343024800', -10800, '0'),
(70, '-02', '12363591600', -7200, '1'),
(70, '-03', '12374474400', -10800, '0'),
(70, '-02', '12395646000', -7200, '1'),
(70, '-03', '12405924000', -10800, '0'),
(70, '-02', '12427095600', -7200, '1'),
(70, '-03', '12437373600', -10800, '0'),
(70, '-02', '12458545200', -7200, '1'),
(70, '-03', '12469428000', -10800, '0'),
(70, '-02', '12489994800', -7200, '1'),
(70, '-03', '12500877600', -10800, '0'),
(70, '-02', '12521444400', -7200, '1'),
(70, '-03', '12532327200', -10800, '0'),
(70, '-02', '12552894000', -7200, '1'),
(70, '-03', '12563776800', -10800, '0'),
(70, '-02', '12584948400', -7200, '1'),
(70, '-03', '12595226400', -10800, '0'),
(70, '-02', '12616398000', -7200, '1'),
(70, '-03', '12626676000', -10800, '0'),
(70, '-02', '12647847600', -7200, '1'),
(70, '-03', '12658730400', -10800, '0'),
(70, '-02', '12679297200', -7200, '1'),
(70, '-03', '12690180000', -10800, '0'),
(70, '-02', '12710746800', -7200, '1'),
(70, '-03', '12721629600', -10800, '0'),
(70, '-02', '12742801200', -7200, '1'),
(70, '-03', '12753079200', -10800, '0'),
(70, '-02', '12774250800', -7200, '1'),
(70, '-03', '12784528800', -10800, '0'),
(70, '-02', '12805700400', -7200, '1'),
(70, '-03', '12815978400', -10800, '0'),
(70, '-02', '12837150000', -7200, '1'),
(70, '-03', '12848032800', -10800, '0'),
(70, '-02', '12868599600', -7200, '1'),
(70, '-03', '12879482400', -10800, '0'),
(70, '-02', '12900049200', -7200, '1'),
(70, '-03', '12910932000', -10800, '0'),
(70, '-02', '12932103600', -7200, '1'),
(70, '-03', '12942381600', -10800, '0'),
(70, '-02', '12963553200', -7200, '1'),
(70, '-03', '12973831200', -10800, '0'),
(70, '-02', '12995002800', -7200, '1'),
(70, '-03', '13005885600', -10800, '0'),
(70, '-02', '13026452400', -7200, '1'),
(70, '-03', '13037335200', -10800, '0'),
(70, '-02', '13057902000', -7200, '1'),
(70, '-03', '13068784800', -10800, '0'),
(70, '-02', '13089956400', -7200, '1'),
(70, '-03', '13100234400', -10800, '0'),
(70, '-02', '13121406000', -7200, '1'),
(70, '-03', '13131684000', -10800, '0'),
(70, '-02', '13152855600', -7200, '1'),
(70, '-03', '13163133600', -10800, '0'),
(70, '-02', '13184305200', -7200, '1'),
(70, '-03', '13195188000', -10800, '0'),
(70, '-02', '13215754800', -7200, '1'),
(70, '-03', '13226637600', -10800, '0'),
(70, '-02', '13247204400', -7200, '1'),
(70, '-03', '13258087200', -10800, '0'),
(70, '-02', '13279258800', -7200, '1'),
(70, '-03', '13289536800', -10800, '0'),
(70, '-02', '13310708400', -7200, '1'),
(70, '-03', '13320986400', -10800, '0'),
(70, '-02', '13342158000', -7200, '1'),
(70, '-03', '13353040800', -10800, '0'),
(70, '-02', '13373607600', -7200, '1'),
(70, '-03', '13384490400', -10800, '0'),
(70, '-02', '13405057200', -7200, '1'),
(70, '-03', '13415940000', -10800, '0'),
(70, '-02', '13436506800', -7200, '1'),
(70, '-03', '13447389600', -10800, '0'),
(70, '-02', '13468561200', -7200, '1'),
(70, '-03', '13478839200', -10800, '0'),
(70, '-02', '13500010800', -7200, '1'),
(70, '-03', '13510288800', -10800, '0'),
(70, '-02', '13531460400', -7200, '1'),
(70, '-03', '13542343200', -10800, '0'),
(70, '-02', '13562910000', -7200, '1'),
(70, '-03', '13573792800', -10800, '0'),
(70, '-02', '13594359600', -7200, '1'),
(70, '-03', '13605242400', -10800, '0'),
(70, '-02', '13626414000', -7200, '1'),
(70, '-03', '13636692000', -10800, '0'),
(70, '-02', '13657863600', -7200, '1'),
(70, '-03', '13668141600', -10800, '0'),
(70, '-02', '13689313200', -7200, '1'),
(70, '-03', '13699591200', -10800, '0'),
(70, '-02', '13720762800', -7200, '1'),
(70, '-03', '13731645600', -10800, '0'),
(70, '-02', '13752212400', -7200, '1'),
(70, '-03', '13763095200', -10800, '0'),
(70, '-02', '13783662000', -7200, '1'),
(70, '-03', '13794544800', -10800, '0'),
(70, '-02', '13815716400', -7200, '1'),
(70, '-03', '13825994400', -10800, '0'),
(70, '-02', '13847166000', -7200, '1'),
(70, '-03', '13857444000', -10800, '0'),
(70, '-02', '13878615600', -7200, '1'),
(70, '-03', '13889498400', -10800, '0'),
(70, '-02', '13910065200', -7200, '1'),
(70, '-03', '13920948000', -10800, '0'),
(70, '-02', '13941514800', -7200, '1'),
(70, '-03', '13952397600', -10800, '0'),
(70, '-02', '13973569200', -7200, '1'),
(70, '-03', '13983847200', -10800, '0'),
(70, '-02', '14005018800', -7200, '1'),
(70, '-03', '14015296800', -10800, '0'),
(70, '-02', '14036468400', -7200, '1'),
(70, '-03', '14046746400', -10800, '0'),
(70, '-02', '14067918000', -7200, '1'),
(70, '-03', '14078800800', -10800, '0'),
(70, '-02', '14099367600', -7200, '1'),
(70, '-03', '14110250400', -10800, '0'),
(70, '-02', '14130817200', -7200, '1'),
(70, '-03', '14141700000', -10800, '0'),
(70, '-02', '14162871600', -7200, '1'),
(70, '-03', '14173149600', -10800, '0'),
(70, '-02', '14194321200', -7200, '1'),
(70, '-03', '14204599200', -10800, '0'),
(70, '-02', '14225770800', -7200, '1'),
(70, '-03', '14236653600', -10800, '0'),
(70, '-02', '14257220400', -7200, '1'),
(70, '-03', '14268103200', -10800, '0'),
(70, '-02', '14288670000', -7200, '1'),
(70, '-03', '14299552800', -10800, '0'),
(70, '-02', '14320119600', -7200, '1'),
(70, '-03', '14331002400', -10800, '0'),
(70, '-02', '14352174000', -7200, '1'),
(70, '-03', '14362452000', -10800, '0'),
(70, '-02', '14383623600', -7200, '1'),
(70, '-03', '14393901600', -10800, '0'),
(70, '-02', '14415073200', -7200, '1'),
(70, '-03', '14425956000', -10800, '0'),
(70, '-02', '14446522800', -7200, '1'),
(70, '-03', '14457405600', -10800, '0'),
(70, '-02', '14477972400', -7200, '1'),
(70, '-03', '14488855200', -10800, '0'),
(70, '-02', '14510026800', -7200, '1'),
(70, '-03', '14520304800', -10800, '0'),
(70, '-02', '14541476400', -7200, '1'),
(70, '-03', '14551754400', -10800, '0'),
(70, '-02', '14572926000', -7200, '1'),
(70, '-03', '14583204000', -10800, '0'),
(70, '-02', '14604375600', -7200, '1'),
(70, '-03', '14615258400', -10800, '0'),
(70, '-02', '14635825200', -7200, '1'),
(70, '-03', '14646708000', -10800, '0'),
(70, '-02', '14667274800', -7200, '1'),
(70, '-03', '14678157600', -10800, '0'),
(70, '-02', '14699329200', -7200, '1'),
(70, '-03', '14709607200', -10800, '0'),
(70, '-02', '14730778800', -7200, '1'),
(70, '-03', '14741056800', -10800, '0'),
(70, '-02', '14762228400', -7200, '1'),
(70, '-03', '14773111200', -10800, '0'),
(70, '-02', '14793678000', -7200, '1'),
(70, '-03', '14804560800', -10800, '0'),
(70, '-02', '14825127600', -7200, '1'),
(70, '-03', '14836010400', -10800, '0'),
(70, '-02', '14857182000', -7200, '1'),
(70, '-03', '14867460000', -10800, '0'),
(70, '-02', '14888631600', -7200, '1'),
(70, '-03', '14898909600', -10800, '0'),
(70, '-02', '14920081200', -7200, '1'),
(70, '-03', '14930359200', -10800, '0'),
(70, '-02', '14951530800', -7200, '1'),
(70, '-03', '14962413600', -10800, '0'),
(70, '-02', '14982980400', -7200, '1'),
(70, '-03', '14993863200', -10800, '0'),
(70, '-02', '15014430000', -7200, '1'),
(70, '-03', '15025312800', -10800, '0'),
(70, '-02', '15046484400', -7200, '1'),
(70, '-03', '15056762400', -10800, '0'),
(70, '-02', '15077934000', -7200, '1'),
(70, '-03', '15088212000', -10800, '0'),
(70, '-02', '15109383600', -7200, '1'),
(70, '-03', '15120266400', -10800, '0'),
(70, '-02', '15140833200', -7200, '1'),
(70, '-03', '15151716000', -10800, '0'),
(70, '-02', '15172282800', -7200, '1'),
(70, '-03', '15183165600', -10800, '0'),
(70, '-02', '15203732400', -7200, '1'),
(70, '-03', '15214615200', -10800, '0'),
(70, '-02', '15235786800', -7200, '1'),
(70, '-03', '15246064800', -10800, '0'),
(70, '-02', '15267236400', -7200, '1'),
(70, '-03', '15277514400', -10800, '0'),
(70, '-02', '15298686000', -7200, '1'),
(70, '-03', '15309568800', -10800, '0'),
(70, '-02', '15330135600', -7200, '1'),
(70, '-03', '15341018400', -10800, '0'),
(70, '-02', '15361585200', -7200, '1'),
(70, '-03', '15372468000', -10800, '0'),
(70, '-02', '15393639600', -7200, '1'),
(70, '-03', '15403917600', -10800, '0'),
(70, '-02', '15425089200', -7200, '1'),
(70, '-03', '15435367200', -10800, '0'),
(70, '-02', '15456538800', -7200, '1'),
(70, '-03', '15466816800', -10800, '0'),
(70, '-02', '15487988400', -7200, '1'),
(70, '-03', '15498871200', -10800, '0'),
(70, '-02', '15519438000', -7200, '1'),
(70, '-03', '15530320800', -10800, '0'),
(70, '-02', '15550887600', -7200, '1'),
(70, '-03', '15561770400', -10800, '0'),
(70, '-02', '15582942000', -7200, '1'),
(70, '-03', '15593220000', -10800, '0'),
(70, '-02', '15614391600', -7200, '1'),
(70, '-03', '15624669600', -10800, '0'),
(70, '-02', '15645841200', -7200, '1'),
(70, '-03', '15656724000', -10800, '0'),
(70, '-02', '15677290800', -7200, '1'),
(70, '-03', '15688173600', -10800, '0'),
(70, '-02', '15708740400', -7200, '1'),
(70, '-03', '15719623200', -10800, '0'),
(70, '-02', '15740794800', -7200, '1'),
(70, '-03', '15751072800', -10800, '0'),
(70, '-02', '15772244400', -7200, '1'),
(70, '-03', '15782522400', -10800, '0'),
(70, '-02', '15803694000', -7200, '1'),
(70, '-03', '15813972000', -10800, '0'),
(70, '-02', '15835143600', -7200, '1'),
(70, '-03', '15846026400', -10800, '0'),
(70, '-02', '15866593200', -7200, '1'),
(70, '-03', '15877476000', -10800, '0'),
(70, '-02', '15898042800', -7200, '1'),
(70, '-03', '15908925600', -10800, '0'),
(70, '-02', '15930097200', -7200, '1'),
(70, '-03', '15940375200', -10800, '0'),
(70, '-02', '15961546800', -7200, '1'),
(70, '-03', '15971824800', -10800, '0'),
(70, '-02', '15992996400', -7200, '1'),
(70, '-03', '16003879200', -10800, '0'),
(70, '-02', '16024446000', -7200, '1'),
(70, '-03', '16035328800', -10800, '0'),
(70, '-02', '16055895600', -7200, '1'),
(70, '-03', '16066778400', -10800, '0'),
(70, '-02', '16087345200', -7200, '1'),
(70, '-03', '16098228000', -10800, '0'),
(70, '-02', '16119399600', -7200, '1'),
(70, '-03', '16129677600', -10800, '0'),
(70, '-02', '16150849200', -7200, '1'),
(70, '-03', '16161127200', -10800, '0'),
(70, '-02', '16182298800', -7200, '1'),
(70, '-03', '16193181600', -10800, '0'),
(70, '-02', '16213748400', -7200, '1'),
(70, '-03', '16224631200', -10800, '0'),
(70, '-02', '16245198000', -7200, '1'),
(70, '-03', '16256080800', -10800, '0'),
(70, '-02', '16277252400', -7200, '1'),
(70, '-03', '16287530400', -10800, '0'),
(70, '-02', '16308702000', -7200, '1'),
(70, '-03', '16318980000', -10800, '0'),
(70, '-02', '16340151600', -7200, '1'),
(70, '-03', '16350429600', -10800, '0'),
(70, '-02', '16371601200', -7200, '1'),
(70, '-03', '16382484000', -10800, '0'),
(70, '-02', '16403050800', -7200, '1'),
(70, '-03', '16413933600', -10800, '0'),
(70, '-02', '16434500400', -7200, '1'),
(70, '-03', '16445383200', -10800, '0'),
(70, '-02', '16466554800', -7200, '1'),
(70, '-03', '16476832800', -10800, '0'),
(70, '-02', '16498004400', -7200, '1'),
(70, '-03', '16508282400', -10800, '0'),
(70, '-02', '16529454000', -7200, '1'),
(70, '-03', '16540336800', -10800, '0'),
(70, '-02', '16560903600', -7200, '1'),
(70, '-03', '16571786400', -10800, '0'),
(70, '-02', '16592353200', -7200, '1'),
(70, '-03', '16603236000', -10800, '0'),
(70, '-02', '16624407600', -7200, '1'),
(70, '-03', '16634685600', -10800, '0'),
(70, '-02', '16655857200', -7200, '1'),
(70, '-03', '16666135200', -10800, '0'),
(70, '-02', '16687306800', -7200, '1'),
(70, '-03', '16697584800', -10800, '0'),
(70, '-02', '16718756400', -7200, '1'),
(71, 'LMT', '-1767212493', -13108, '0'),
(71, '-04', '-1767212492', -14400, '0'),
(71, '-03', '-1206954000', -10800, '1'),
(71, '-04', '-1191358800', -14400, '0'),
(71, '-03', '-1175371200', -10800, '1'),
(71, '-04', '-1159822800', -14400, '0'),
(71, '-03', '-633816000', -10800, '1'),
(71, '-04', '-622065600', -14400, '0'),
(71, '-03', '-602280000', -10800, '1'),
(71, '-04', '-591829200', -14400, '0'),
(71, '-03', '-570744000', -10800, '1'),
(71, '-04', '-560206800', -14400, '0'),
(71, '-03', '-539121600', -10800, '1'),
(71, '-04', '-531349200', -14400, '0'),
(71, '-03', '-191361600', -10800, '1'),
(71, '-04', '-184194000', -14400, '0'),
(71, '-03', '-155160000', -10800, '1'),
(71, '-04', '-150066000', -14400, '0'),
(71, '-03', '-128894400', -10800, '1'),
(71, '-04', '-121122000', -14400, '0'),
(71, '-03', '-99950400', -10800, '1'),
(71, '-04', '-89586000', -14400, '0'),
(71, '-03', '-68414400', -10800, '1'),
(71, '-04', '-57963600', -14400, '0'),
(71, '-03', '499752000', -10800, '1'),
(71, '-04', '511239600', -14400, '0'),
(71, '-03', '530596800', -10800, '1'),
(71, '-04', '540270000', -14400, '0'),
(71, '-03', '562132800', -10800, '1'),
(71, '-04', '571201200', -14400, '0'),
(71, '-03', '592977600', -10800, '1'),
(71, '-04', '602046000', -14400, '0'),
(71, '-03', '624427200', -10800, '1'),
(71, '-04', '634705200', -14400, '0'),
(71, '-03', '656481600', -10800, '1'),
(71, '-04', '666759600', -14400, '0'),
(71, '-03', '687931200', -10800, '1'),
(71, '-04', '697604400', -14400, '0'),
(71, '-03', '719985600', -10800, '1'),
(71, '-04', '728449200', -14400, '0'),
(71, '-03', '750830400', -10800, '1'),
(71, '-04', '761713200', -14400, '0'),
(71, '-03', '782280000', -10800, '1'),
(71, '-04', '793162800', -14400, '0'),
(71, '-03', '813729600', -10800, '1'),
(71, '-04', '824007600', -14400, '0'),
(71, '-03', '844574400', -10800, '1'),
(71, '-04', '856062000', -14400, '0'),
(71, '-03', '876110400', -10800, '1'),
(71, '-04', '888721200', -14400, '0'),
(71, '-03', '908078400', -10800, '1'),
(71, '-04', '919566000', -14400, '0'),
(71, '-03', '938923200', -10800, '1'),
(71, '-04', '951620400', -14400, '0'),
(71, '-03', '970977600', -10800, '1'),
(71, '-04', '982465200', -14400, '0'),
(71, '-03', '1003032000', -10800, '1'),
(71, '-04', '1013914800', -14400, '0'),
(71, '-03', '1036296000', -10800, '1'),
(71, '-04', '1045364400', -14400, '0'),
(71, '-03', '1066536000', -10800, '1'),
(71, '-04', '1076814000', -14400, '0'),
(71, '-03', '1099368000', -10800, '1'),
(71, '-04', '1108868400', -14400, '0'),
(71, '-03', '1129435200', -10800, '1'),
(71, '-04', '1140318000', -14400, '0'),
(71, '-03', '1162699200', -10800, '1'),
(71, '-04', '1172372400', -14400, '0'),
(71, '-03', '1192334400', -10800, '1'),
(71, '-04', '1203217200', -14400, '0'),
(71, '-03', '1224388800', -10800, '1'),
(71, '-04', '1234666800', -14400, '0'),
(71, '-03', '1255838400', -10800, '1'),
(71, '-04', '1266721200', -14400, '0'),
(71, '-03', '1287288000', -10800, '1'),
(71, '-04', '1298170800', -14400, '0'),
(71, '-03', '1318737600', -10800, '1'),
(71, '-04', '1330225200', -14400, '0'),
(71, '-03', '1350792000', -10800, '1'),
(71, '-04', '1361070000', -14400, '0'),
(71, '-03', '1382241600', -10800, '1'),
(71, '-04', '1392519600', -14400, '0'),
(71, '-03', '1413691200', -10800, '1'),
(71, '-04', '1424574000', -14400, '0'),
(71, '-03', '1445140800', -10800, '1'),
(71, '-04', '1456023600', -14400, '0'),
(71, '-03', '1476590400', -10800, '1'),
(71, '-04', '1487473200', -14400, '0'),
(71, '-03', '1508040000', -10800, '1'),
(71, '-04', '1518922800', -14400, '0'),
(71, '-03', '1540094400', -10800, '1'),
(71, '-04', '1550372400', -14400, '0'),
(71, '-03', '1571544000', -10800, '1'),
(71, '-04', '1581822000', -14400, '0'),
(71, '-03', '1602993600', -10800, '1'),
(71, '-04', '1613876400', -14400, '0'),
(71, '-03', '1634443200', -10800, '1'),
(71, '-04', '1645326000', -14400, '0'),
(71, '-03', '1665892800', -10800, '1'),
(71, '-04', '1677380400', -14400, '0'),
(71, '-03', '1697342400', -10800, '1'),
(71, '-04', '1708225200', -14400, '0'),
(71, '-03', '1729396800', -10800, '1'),
(71, '-04', '1739674800', -14400, '0'),
(71, '-03', '1760846400', -10800, '1'),
(71, '-04', '1771729200', -14400, '0'),
(71, '-03', '1792296000', -10800, '1'),
(71, '-04', '1803178800', -14400, '0'),
(71, '-03', '1823745600', -10800, '1'),
(71, '-04', '1834628400', -14400, '0'),
(71, '-03', '1855195200', -10800, '1'),
(71, '-04', '1866078000', -14400, '0'),
(71, '-03', '1887249600', -10800, '1'),
(71, '-04', '1897527600', -14400, '0'),
(71, '-03', '1918699200', -10800, '1'),
(71, '-04', '1928977200', -14400, '0'),
(71, '-03', '1950148800', -10800, '1'),
(71, '-04', '1960426800', -14400, '0'),
(71, '-03', '1981598400', -10800, '1'),
(71, '-04', '1992481200', -14400, '0'),
(71, '-03', '2013048000', -10800, '1'),
(71, '-04', '2024535600', -14400, '0'),
(71, '-03', '2044497600', -10800, '1'),
(71, '-04', '2055380400', -14400, '0'),
(71, '-03', '2076552000', -10800, '1'),
(71, '-04', '2086830000', -14400, '0'),
(71, '-03', '2108001600', -10800, '1'),
(71, '-04', '2118884400', -14400, '0'),
(71, '-03', '2139451200', -10800, '1'),
(71, '-04', '2150334000', -14400, '0'),
(71, '-03', '2170900800', -10800, '1'),
(71, '-04', '2181783600', -14400, '0'),
(71, '-03', '2202350400', -10800, '1'),
(71, '-04', '2213233200', -14400, '0'),
(71, '-03', '2234404800', -10800, '1'),
(71, '-04', '2244682800', -14400, '0'),
(71, '-03', '2265854400', -10800, '1'),
(71, '-04', '2276132400', -14400, '0'),
(71, '-03', '2297304000', -10800, '1'),
(71, '-04', '2307582000', -14400, '0'),
(71, '-03', '2328753600', -10800, '1'),
(71, '-04', '2339636400', -14400, '0'),
(71, '-03', '2360203200', -10800, '1'),
(71, '-04', '2371086000', -14400, '0'),
(71, '-03', '2391652800', -10800, '1'),
(71, '-04', '2402535600', -14400, '0'),
(71, '-03', '2423707200', -10800, '1'),
(71, '-04', '2433985200', -14400, '0'),
(71, '-03', '2455156800', -10800, '1'),
(71, '-04', '2465434800', -14400, '0'),
(71, '-03', '2486606400', -10800, '1'),
(71, '-04', '2497489200', -14400, '0'),
(71, '-03', '2518056000', -10800, '1'),
(71, '-04', '2528938800', -14400, '0'),
(71, '-03', '2549505600', -10800, '1'),
(71, '-04', '2560388400', -14400, '0'),
(71, '-03', '2580955200', -10800, '1'),
(71, '-04', '2591838000', -14400, '0'),
(71, '-03', '2613009600', -10800, '1'),
(71, '-04', '2623287600', -14400, '0'),
(71, '-03', '2644459200', -10800, '1'),
(71, '-04', '2654737200', -14400, '0'),
(71, '-03', '2675908800', -10800, '1'),
(71, '-04', '2686791600', -14400, '0'),
(71, '-03', '2707358400', -10800, '1'),
(71, '-04', '2718241200', -14400, '0'),
(71, '-03', '2738808000', -10800, '1'),
(71, '-04', '2749690800', -14400, '0'),
(71, '-03', '2770862400', -10800, '1'),
(71, '-04', '2781140400', -14400, '0'),
(71, '-03', '2802312000', -10800, '1'),
(71, '-04', '2812590000', -14400, '0'),
(71, '-03', '2833761600', -10800, '1'),
(71, '-04', '2844039600', -14400, '0'),
(71, '-03', '2865211200', -10800, '1'),
(71, '-04', '2876094000', -14400, '0'),
(71, '-03', '2896660800', -10800, '1'),
(71, '-04', '2907543600', -14400, '0'),
(71, '-03', '2928110400', -10800, '1'),
(71, '-04', '2938993200', -14400, '0'),
(71, '-03', '2960164800', -10800, '1'),
(71, '-04', '2970442800', -14400, '0'),
(71, '-03', '2991614400', -10800, '1'),
(71, '-04', '3001892400', -14400, '0'),
(71, '-03', '3023064000', -10800, '1'),
(71, '-04', '3033946800', -14400, '0'),
(71, '-03', '3054513600', -10800, '1'),
(71, '-04', '3065396400', -14400, '0'),
(71, '-03', '3085963200', -10800, '1'),
(71, '-04', '3096846000', -14400, '0'),
(71, '-03', '3118017600', -10800, '1'),
(71, '-04', '3128295600', -14400, '0'),
(71, '-03', '3149467200', -10800, '1'),
(71, '-04', '3159745200', -14400, '0'),
(71, '-03', '3180916800', -10800, '1'),
(71, '-04', '3191194800', -14400, '0'),
(71, '-03', '3212366400', -10800, '1'),
(71, '-04', '3223249200', -14400, '0'),
(71, '-03', '3243816000', -10800, '1'),
(71, '-04', '3254698800', -14400, '0'),
(71, '-03', '3275265600', -10800, '1'),
(71, '-04', '3286148400', -14400, '0'),
(71, '-03', '3307320000', -10800, '1'),
(71, '-04', '3317598000', -14400, '0'),
(71, '-03', '3338769600', -10800, '1'),
(71, '-04', '3349047600', -14400, '0'),
(71, '-03', '3370219200', -10800, '1'),
(71, '-04', '3381102000', -14400, '0'),
(71, '-03', '3401668800', -10800, '1'),
(71, '-04', '3412551600', -14400, '0'),
(71, '-03', '3433118400', -10800, '1'),
(71, '-04', '3444001200', -14400, '0'),
(71, '-03', '3464568000', -10800, '1'),
(71, '-04', '3475450800', -14400, '0'),
(71, '-03', '3496622400', -10800, '1'),
(71, '-04', '3506900400', -14400, '0'),
(71, '-03', '3528072000', -10800, '1'),
(71, '-04', '3538350000', -14400, '0'),
(71, '-03', '3559521600', -10800, '1'),
(71, '-04', '3570404400', -14400, '0'),
(71, '-03', '3590971200', -10800, '1'),
(71, '-04', '3601854000', -14400, '0'),
(71, '-03', '3622420800', -10800, '1'),
(71, '-04', '3633303600', -14400, '0'),
(71, '-03', '3654475200', -10800, '1'),
(71, '-04', '3664753200', -14400, '0'),
(71, '-03', '3685924800', -10800, '1'),
(71, '-04', '3696202800', -14400, '0'),
(71, '-03', '3717374400', -10800, '1'),
(71, '-04', '3727652400', -14400, '0'),
(71, '-03', '3748824000', -10800, '1'),
(71, '-04', '3759706800', -14400, '0'),
(71, '-03', '3780273600', -10800, '1'),
(71, '-04', '3791156400', -14400, '0'),
(71, '-03', '3811723200', -10800, '1'),
(71, '-04', '3822606000', -14400, '0'),
(71, '-03', '3843777600', -10800, '1'),
(71, '-04', '3854055600', -14400, '0'),
(71, '-03', '3875227200', -10800, '1'),
(71, '-04', '3885505200', -14400, '0'),
(71, '-03', '3906676800', -10800, '1'),
(71, '-04', '3917559600', -14400, '0'),
(71, '-03', '3938126400', -10800, '1'),
(71, '-04', '3949009200', -14400, '0'),
(71, '-03', '3969576000', -10800, '1'),
(71, '-04', '3980458800', -14400, '0'),
(71, '-03', '4001630400', -10800, '1'),
(71, '-04', '4011908400', -14400, '0'),
(71, '-03', '4033080000', -10800, '1'),
(71, '-04', '4043358000', -14400, '0'),
(71, '-03', '4064529600', -10800, '1'),
(71, '-04', '4074807600', -14400, '0'),
(71, '-03', '4095979200', -10800, '1'),
(71, '-04', '4106862000', -14400, '0'),
(71, '-03', '4127428800', -10800, '1'),
(71, '-04', '4138311600', -14400, '0'),
(71, '-03', '4158878400', -10800, '1'),
(71, '-04', '4169761200', -14400, '0'),
(71, '-03', '4190328000', -10800, '1'),
(71, '-04', '4201210800', -14400, '0'),
(71, '-03', '4222382400', -10800, '1'),
(71, '-04', '4232660400', -14400, '0'),
(71, '-03', '4253832000', -10800, '1'),
(71, '-04', '4264110000', -14400, '0'),
(71, '-03', '4285281600', -10800, '1'),
(71, '-04', '4296164400', -14400, '0'),
(71, '-03', '4316731200', -10800, '1'),
(71, '-04', '4327614000', -14400, '0'),
(71, '-03', '4348180800', -10800, '1'),
(71, '-04', '4359063600', -14400, '0'),
(71, '-03', '4380235200', -10800, '1'),
(71, '-04', '4390513200', -14400, '0'),
(71, '-03', '4411684800', -10800, '1'),
(71, '-04', '4421962800', -14400, '0'),
(71, '-03', '4443134400', -10800, '1'),
(71, '-04', '4453412400', -14400, '0'),
(71, '-03', '4474584000', -10800, '1'),
(71, '-04', '4485466800', -14400, '0'),
(71, '-03', '4506033600', -10800, '1'),
(71, '-04', '4516916400', -14400, '0'),
(71, '-03', '4537483200', -10800, '1'),
(71, '-04', '4548366000', -14400, '0'),
(71, '-03', '4569537600', -10800, '1'),
(71, '-04', '4579815600', -14400, '0'),
(71, '-03', '4600987200', -10800, '1'),
(71, '-04', '4611265200', -14400, '0'),
(71, '-03', '4632436800', -10800, '1'),
(71, '-04', '4643319600', -14400, '0'),
(71, '-03', '4663886400', -10800, '1'),
(71, '-04', '4674769200', -14400, '0'),
(71, '-03', '4695336000', -10800, '1'),
(71, '-04', '4706218800', -14400, '0'),
(71, '-03', '4726785600', -10800, '1'),
(71, '-04', '4737668400', -14400, '0'),
(71, '-03', '4758840000', -10800, '1'),
(71, '-04', '4769118000', -14400, '0'),
(71, '-03', '4790289600', -10800, '1'),
(71, '-04', '4800567600', -14400, '0'),
(71, '-03', '4821739200', -10800, '1'),
(71, '-04', '4832622000', -14400, '0'),
(71, '-03', '4853188800', -10800, '1'),
(71, '-04', '4864071600', -14400, '0'),
(71, '-03', '4884638400', -10800, '1'),
(71, '-04', '4895521200', -14400, '0'),
(71, '-03', '4916692800', -10800, '1'),
(71, '-04', '4926970800', -14400, '0'),
(71, '-03', '4948142400', -10800, '1'),
(71, '-04', '4958420400', -14400, '0'),
(71, '-03', '4979592000', -10800, '1'),
(71, '-04', '4989870000', -14400, '0'),
(71, '-03', '5011041600', -10800, '1'),
(71, '-04', '5021924400', -14400, '0'),
(71, '-03', '5042491200', -10800, '1'),
(71, '-04', '5053374000', -14400, '0'),
(71, '-03', '5073940800', -10800, '1'),
(71, '-04', '5084823600', -14400, '0'),
(71, '-03', '5105995200', -10800, '1'),
(71, '-04', '5116273200', -14400, '0'),
(71, '-03', '5137444800', -10800, '1'),
(71, '-04', '5147722800', -14400, '0'),
(71, '-03', '5168894400', -10800, '1'),
(71, '-04', '5179777200', -14400, '0'),
(71, '-03', '5200344000', -10800, '1'),
(71, '-04', '5211226800', -14400, '0'),
(71, '-03', '5231793600', -10800, '1'),
(71, '-04', '5242676400', -14400, '0'),
(71, '-03', '5263848000', -10800, '1'),
(71, '-04', '5274126000', -14400, '0'),
(71, '-03', '5295297600', -10800, '1'),
(71, '-04', '5305575600', -14400, '0'),
(71, '-03', '5326747200', -10800, '1'),
(71, '-04', '5337025200', -14400, '0'),
(71, '-03', '5358196800', -10800, '1'),
(71, '-04', '5369079600', -14400, '0'),
(71, '-03', '5389646400', -10800, '1'),
(71, '-04', '5400529200', -14400, '0'),
(71, '-03', '5421096000', -10800, '1'),
(71, '-04', '5431978800', -14400, '0'),
(71, '-03', '5453150400', -10800, '1'),
(71, '-04', '5463428400', -14400, '0'),
(71, '-03', '5484600000', -10800, '1'),
(71, '-04', '5494878000', -14400, '0'),
(71, '-03', '5516049600', -10800, '1'),
(71, '-04', '5526932400', -14400, '0'),
(71, '-03', '5547499200', -10800, '1'),
(71, '-04', '5558382000', -14400, '0'),
(71, '-03', '5578948800', -10800, '1'),
(71, '-04', '5589831600', -14400, '0'),
(71, '-03', '5610398400', -10800, '1'),
(71, '-04', '5621281200', -14400, '0'),
(71, '-03', '5642452800', -10800, '1'),
(71, '-04', '5652730800', -14400, '0'),
(71, '-03', '5673902400', -10800, '1'),
(71, '-04', '5684180400', -14400, '0'),
(71, '-03', '5705352000', -10800, '1'),
(71, '-04', '5716234800', -14400, '0'),
(71, '-03', '5736801600', -10800, '1'),
(71, '-04', '5747684400', -14400, '0'),
(71, '-03', '5768251200', -10800, '1'),
(71, '-04', '5779134000', -14400, '0'),
(71, '-03', '5800305600', -10800, '1'),
(71, '-04', '5810583600', -14400, '0'),
(71, '-03', '5831755200', -10800, '1'),
(71, '-04', '5842033200', -14400, '0'),
(71, '-03', '5863204800', -10800, '1'),
(71, '-04', '5873482800', -14400, '0'),
(71, '-03', '5894654400', -10800, '1'),
(71, '-04', '5905537200', -14400, '0'),
(71, '-03', '5926104000', -10800, '1'),
(71, '-04', '5936986800', -14400, '0'),
(71, '-03', '5957553600', -10800, '1'),
(71, '-04', '5968436400', -14400, '0'),
(71, '-03', '5989608000', -10800, '1'),
(71, '-04', '5999886000', -14400, '0'),
(71, '-03', '6021057600', -10800, '1'),
(71, '-04', '6031335600', -14400, '0'),
(71, '-03', '6052507200', -10800, '1'),
(71, '-04', '6063390000', -14400, '0'),
(71, '-03', '6083956800', -10800, '1'),
(71, '-04', '6094839600', -14400, '0'),
(71, '-03', '6115406400', -10800, '1'),
(71, '-04', '6126289200', -14400, '0'),
(71, '-03', '6147460800', -10800, '1'),
(71, '-04', '6157738800', -14400, '0'),
(71, '-03', '6178910400', -10800, '1'),
(71, '-04', '6189188400', -14400, '0'),
(71, '-03', '6210360000', -10800, '1'),
(71, '-04', '6220638000', -14400, '0'),
(71, '-03', '6241809600', -10800, '1'),
(71, '-04', '6252692400', -14400, '0'),
(71, '-03', '6273259200', -10800, '1'),
(71, '-04', '6284142000', -14400, '0'),
(71, '-03', '6304708800', -10800, '1'),
(71, '-04', '6315591600', -14400, '0'),
(71, '-03', '6336763200', -10800, '1'),
(71, '-04', '6347041200', -14400, '0'),
(71, '-03', '6368212800', -10800, '1'),
(71, '-04', '6378490800', -14400, '0'),
(71, '-03', '6399662400', -10800, '1'),
(71, '-04', '6410545200', -14400, '0'),
(71, '-03', '6431112000', -10800, '1'),
(71, '-04', '6441994800', -14400, '0'),
(71, '-03', '6462561600', -10800, '1'),
(71, '-04', '6473444400', -14400, '0'),
(71, '-03', '6494011200', -10800, '1'),
(71, '-04', '6504894000', -14400, '0'),
(71, '-03', '6526065600', -10800, '1'),
(71, '-04', '6536343600', -14400, '0'),
(71, '-03', '6557515200', -10800, '1'),
(71, '-04', '6567793200', -14400, '0'),
(71, '-03', '6588964800', -10800, '1'),
(71, '-04', '6599847600', -14400, '0'),
(71, '-03', '6620414400', -10800, '1'),
(71, '-04', '6631297200', -14400, '0'),
(71, '-03', '6651864000', -10800, '1'),
(71, '-04', '6662746800', -14400, '0'),
(71, '-03', '6683918400', -10800, '1'),
(71, '-04', '6694196400', -14400, '0'),
(71, '-03', '6715368000', -10800, '1'),
(71, '-04', '6725646000', -14400, '0'),
(71, '-03', '6746817600', -10800, '1'),
(71, '-04', '6757095600', -14400, '0'),
(71, '-03', '6778267200', -10800, '1'),
(71, '-04', '6789150000', -14400, '0'),
(71, '-03', '6809716800', -10800, '1'),
(71, '-04', '6820599600', -14400, '0'),
(71, '-03', '6841166400', -10800, '1'),
(71, '-04', '6852049200', -14400, '0'),
(71, '-03', '6873220800', -10800, '1'),
(71, '-04', '6883498800', -14400, '0'),
(71, '-03', '6904670400', -10800, '1'),
(71, '-04', '6914948400', -14400, '0'),
(71, '-03', '6936120000', -10800, '1'),
(71, '-04', '6947002800', -14400, '0'),
(71, '-03', '6967569600', -10800, '1'),
(71, '-04', '6978452400', -14400, '0'),
(71, '-03', '6999019200', -10800, '1'),
(71, '-04', '7009902000', -14400, '0'),
(71, '-03', '7031073600', -10800, '1'),
(71, '-04', '7041351600', -14400, '0'),
(71, '-03', '7062523200', -10800, '1'),
(71, '-04', '7072801200', -14400, '0'),
(71, '-03', '7093972800', -10800, '1'),
(71, '-04', '7104250800', -14400, '0'),
(71, '-03', '7125422400', -10800, '1'),
(71, '-04', '7136305200', -14400, '0'),
(71, '-03', '7156872000', -10800, '1'),
(71, '-04', '7167754800', -14400, '0'),
(71, '-03', '7188321600', -10800, '1'),
(71, '-04', '7199204400', -14400, '0'),
(71, '-03', '7220376000', -10800, '1'),
(71, '-04', '7230654000', -14400, '0'),
(71, '-03', '7251825600', -10800, '1'),
(71, '-04', '7262103600', -14400, '0'),
(71, '-03', '7283275200', -10800, '1'),
(71, '-04', '7293553200', -14400, '0'),
(71, '-03', '7314724800', -10800, '1'),
(71, '-04', '7325607600', -14400, '0'),
(71, '-03', '7346174400', -10800, '1'),
(71, '-04', '7357057200', -14400, '0'),
(71, '-03', '7377624000', -10800, '1'),
(71, '-04', '7388506800', -14400, '0'),
(71, '-03', '7409678400', -10800, '1'),
(71, '-04', '7419956400', -14400, '0'),
(71, '-03', '7441128000', -10800, '1'),
(71, '-04', '7451406000', -14400, '0'),
(71, '-03', '7472577600', -10800, '1'),
(71, '-04', '7482855600', -14400, '0'),
(71, '-03', '7504027200', -10800, '1'),
(71, '-04', '7514910000', -14400, '0'),
(71, '-03', '7535476800', -10800, '1'),
(71, '-04', '7546359600', -14400, '0'),
(71, '-03', '7566926400', -10800, '1'),
(71, '-04', '7577809200', -14400, '0'),
(71, '-03', '7598980800', -10800, '1'),
(71, '-04', '7609258800', -14400, '0'),
(71, '-03', '7630430400', -10800, '1'),
(71, '-04', '7640708400', -14400, '0'),
(71, '-03', '7661880000', -10800, '1'),
(71, '-04', '7672762800', -14400, '0'),
(71, '-03', '7693329600', -10800, '1'),
(71, '-04', '7704212400', -14400, '0'),
(71, '-03', '7724779200', -10800, '1'),
(71, '-04', '7735662000', -14400, '0'),
(71, '-03', '7756228800', -10800, '1'),
(71, '-04', '7767111600', -14400, '0'),
(71, '-03', '7788283200', -10800, '1'),
(71, '-04', '7798561200', -14400, '0'),
(71, '-03', '7819732800', -10800, '1'),
(71, '-04', '7830010800', -14400, '0'),
(71, '-03', '7851182400', -10800, '1'),
(71, '-04', '7862065200', -14400, '0'),
(71, '-03', '7882632000', -10800, '1'),
(71, '-04', '7893514800', -14400, '0'),
(71, '-03', '7914081600', -10800, '1'),
(71, '-04', '7924964400', -14400, '0'),
(71, '-03', '7946136000', -10800, '1'),
(71, '-04', '7956414000', -14400, '0'),
(71, '-03', '7977585600', -10800, '1'),
(71, '-04', '7987863600', -14400, '0'),
(71, '-03', '8009035200', -10800, '1'),
(71, '-04', '8019313200', -14400, '0'),
(71, '-03', '8040484800', -10800, '1'),
(71, '-04', '8051367600', -14400, '0'),
(71, '-03', '8071934400', -10800, '1'),
(71, '-04', '8082817200', -14400, '0'),
(71, '-03', '8103384000', -10800, '1'),
(71, '-04', '8114266800', -14400, '0'),
(71, '-03', '8135438400', -10800, '1'),
(71, '-04', '8145716400', -14400, '0'),
(71, '-03', '8166888000', -10800, '1'),
(71, '-04', '8177166000', -14400, '0'),
(71, '-03', '8198337600', -10800, '1'),
(71, '-04', '8209220400', -14400, '0'),
(71, '-03', '8229787200', -10800, '1'),
(71, '-04', '8240670000', -14400, '0'),
(71, '-03', '8261236800', -10800, '1'),
(71, '-04', '8272119600', -14400, '0'),
(71, '-03', '8293291200', -10800, '1'),
(71, '-04', '8303569200', -14400, '0'),
(71, '-03', '8324740800', -10800, '1'),
(71, '-04', '8335018800', -14400, '0'),
(71, '-03', '8356190400', -10800, '1'),
(71, '-04', '8366468400', -14400, '0'),
(71, '-03', '8387640000', -10800, '1'),
(71, '-04', '8398522800', -14400, '0'),
(71, '-03', '8419089600', -10800, '1'),
(71, '-04', '8429972400', -14400, '0'),
(71, '-03', '8450539200', -10800, '1'),
(71, '-04', '8461422000', -14400, '0'),
(71, '-03', '8482593600', -10800, '1'),
(71, '-04', '8492871600', -14400, '0'),
(71, '-03', '8514043200', -10800, '1'),
(71, '-04', '8524321200', -14400, '0'),
(71, '-03', '8545492800', -10800, '1'),
(71, '-04', '8556375600', -14400, '0'),
(71, '-03', '8576942400', -10800, '1'),
(71, '-04', '8587825200', -14400, '0'),
(71, '-03', '8608392000', -10800, '1'),
(71, '-04', '8619274800', -14400, '0'),
(71, '-03', '8639841600', -10800, '1'),
(71, '-04', '8650724400', -14400, '0'),
(71, '-03', '8671896000', -10800, '1'),
(71, '-04', '8682174000', -14400, '0'),
(71, '-03', '8703345600', -10800, '1'),
(71, '-04', '8713623600', -14400, '0'),
(71, '-03', '8734795200', -10800, '1'),
(71, '-04', '8745678000', -14400, '0'),
(71, '-03', '8766244800', -10800, '1'),
(71, '-04', '8777127600', -14400, '0'),
(71, '-03', '8797694400', -10800, '1'),
(71, '-04', '8808577200', -14400, '0'),
(71, '-03', '8829748800', -10800, '1'),
(71, '-04', '8840026800', -14400, '0'),
(71, '-03', '8861198400', -10800, '1'),
(71, '-04', '8871476400', -14400, '0'),
(71, '-03', '8892648000', -10800, '1'),
(71, '-04', '8902926000', -14400, '0'),
(71, '-03', '8924097600', -10800, '1'),
(71, '-04', '8934980400', -14400, '0'),
(71, '-03', '8955547200', -10800, '1'),
(71, '-04', '8966430000', -14400, '0'),
(71, '-03', '8986996800', -10800, '1'),
(71, '-04', '8997879600', -14400, '0'),
(71, '-03', '9019051200', -10800, '1'),
(71, '-04', '9029329200', -14400, '0'),
(71, '-03', '9050500800', -10800, '1'),
(71, '-04', '9060778800', -14400, '0'),
(71, '-03', '9081950400', -10800, '1'),
(71, '-04', '9092833200', -14400, '0'),
(71, '-03', '9113400000', -10800, '1'),
(71, '-04', '9124282800', -14400, '0'),
(71, '-03', '9144849600', -10800, '1'),
(71, '-04', '9155732400', -14400, '0'),
(71, '-03', '9176904000', -10800, '1'),
(71, '-04', '9187182000', -14400, '0'),
(71, '-03', '9208353600', -10800, '1'),
(71, '-04', '9218631600', -14400, '0'),
(71, '-03', '9239803200', -10800, '1'),
(71, '-04', '9250081200', -14400, '0'),
(71, '-03', '9271252800', -10800, '1'),
(71, '-04', '9282135600', -14400, '0'),
(71, '-03', '9302702400', -10800, '1'),
(71, '-04', '9313585200', -14400, '0'),
(71, '-03', '9334152000', -10800, '1'),
(71, '-04', '9345034800', -14400, '0'),
(71, '-03', '9366206400', -10800, '1'),
(71, '-04', '9376484400', -14400, '0'),
(71, '-03', '9397656000', -10800, '1'),
(71, '-04', '9407934000', -14400, '0'),
(71, '-03', '9429105600', -10800, '1'),
(71, '-04', '9439988400', -14400, '0'),
(71, '-03', '9460555200', -10800, '1'),
(71, '-04', '9471438000', -14400, '0'),
(71, '-03', '9492004800', -10800, '1'),
(71, '-04', '9502887600', -14400, '0'),
(71, '-03', '9523454400', -10800, '1'),
(71, '-04', '9534337200', -14400, '0'),
(71, '-03', '9555508800', -10800, '1'),
(71, '-04', '9565786800', -14400, '0'),
(71, '-03', '9586958400', -10800, '1'),
(71, '-04', '9597236400', -14400, '0'),
(71, '-03', '9618408000', -10800, '1'),
(71, '-04', '9629290800', -14400, '0'),
(71, '-03', '9649857600', -10800, '1'),
(71, '-04', '9660740400', -14400, '0'),
(71, '-03', '9681307200', -10800, '1'),
(71, '-04', '9692190000', -14400, '0'),
(71, '-03', '9713361600', -10800, '1'),
(71, '-04', '9723639600', -14400, '0'),
(71, '-03', '9744811200', -10800, '1'),
(71, '-04', '9755089200', -14400, '0'),
(71, '-03', '9776260800', -10800, '1'),
(71, '-04', '9786538800', -14400, '0'),
(71, '-03', '9807710400', -10800, '1'),
(71, '-04', '9818593200', -14400, '0'),
(71, '-03', '9839160000', -10800, '1'),
(71, '-04', '9850042800', -14400, '0'),
(71, '-03', '9870609600', -10800, '1'),
(71, '-04', '9881492400', -14400, '0'),
(71, '-03', '9902664000', -10800, '1'),
(71, '-04', '9912942000', -14400, '0'),
(71, '-03', '9934113600', -10800, '1'),
(71, '-04', '9944391600', -14400, '0'),
(71, '-03', '9965563200', -10800, '1'),
(71, '-04', '9976446000', -14400, '0'),
(71, '-03', '9997012800', -10800, '1'),
(71, '-04', '10007895600', -14400, '0'),
(71, '-03', '10028462400', -10800, '1'),
(71, '-04', '10039345200', -14400, '0'),
(71, '-03', '10060516800', -10800, '1'),
(71, '-04', '10070794800', -14400, '0'),
(71, '-03', '10091966400', -10800, '1'),
(71, '-04', '10102244400', -14400, '0'),
(71, '-03', '10123416000', -10800, '1'),
(71, '-04', '10133694000', -14400, '0'),
(71, '-03', '10154865600', -10800, '1'),
(71, '-04', '10165748400', -14400, '0'),
(71, '-03', '10186315200', -10800, '1'),
(71, '-04', '10197198000', -14400, '0'),
(71, '-03', '10217764800', -10800, '1'),
(71, '-04', '10228647600', -14400, '0'),
(71, '-03', '10249819200', -10800, '1'),
(71, '-04', '10260097200', -14400, '0'),
(71, '-03', '10281268800', -10800, '1'),
(71, '-04', '10291546800', -14400, '0'),
(71, '-03', '10312718400', -10800, '1'),
(71, '-04', '10323601200', -14400, '0'),
(71, '-03', '10344168000', -10800, '1'),
(71, '-04', '10355050800', -14400, '0'),
(71, '-03', '10375617600', -10800, '1'),
(71, '-04', '10386500400', -14400, '0'),
(71, '-03', '10407067200', -10800, '1'),
(71, '-04', '10417950000', -14400, '0'),
(71, '-03', '10439121600', -10800, '1'),
(71, '-04', '10449399600', -14400, '0'),
(71, '-03', '10470571200', -10800, '1'),
(71, '-04', '10480849200', -14400, '0'),
(71, '-03', '10502020800', -10800, '1'),
(71, '-04', '10512298800', -14400, '0'),
(71, '-03', '10533470400', -10800, '1'),
(71, '-04', '10544353200', -14400, '0'),
(71, '-03', '10564920000', -10800, '1'),
(71, '-04', '10575802800', -14400, '0'),
(71, '-03', '10596369600', -10800, '1'),
(71, '-04', '10607252400', -14400, '0'),
(71, '-03', '10628424000', -10800, '1'),
(71, '-04', '10638702000', -14400, '0'),
(71, '-03', '10659873600', -10800, '1'),
(71, '-04', '10670151600', -14400, '0'),
(71, '-03', '10691323200', -10800, '1'),
(71, '-04', '10702206000', -14400, '0'),
(71, '-03', '10722772800', -10800, '1'),
(71, '-04', '10733655600', -14400, '0'),
(71, '-03', '10754222400', -10800, '1'),
(71, '-04', '10765105200', -14400, '0'),
(71, '-03', '10785672000', -10800, '1'),
(71, '-04', '10796554800', -14400, '0'),
(71, '-03', '10817726400', -10800, '1'),
(71, '-04', '10828004400', -14400, '0'),
(71, '-03', '10849176000', -10800, '1'),
(71, '-04', '10859454000', -14400, '0'),
(71, '-03', '10880625600', -10800, '1'),
(71, '-04', '10891508400', -14400, '0'),
(71, '-03', '10912075200', -10800, '1'),
(71, '-04', '10922958000', -14400, '0'),
(71, '-03', '10943524800', -10800, '1'),
(71, '-04', '10954407600', -14400, '0'),
(71, '-03', '10975579200', -10800, '1'),
(71, '-04', '10985857200', -14400, '0'),
(71, '-03', '11007028800', -10800, '1'),
(71, '-04', '11017306800', -14400, '0'),
(71, '-03', '11038478400', -10800, '1'),
(71, '-04', '11048756400', -14400, '0'),
(71, '-03', '11069928000', -10800, '1'),
(71, '-04', '11080810800', -14400, '0'),
(71, '-03', '11101377600', -10800, '1'),
(71, '-04', '11112260400', -14400, '0'),
(71, '-03', '11132827200', -10800, '1'),
(71, '-04', '11143710000', -14400, '0'),
(71, '-03', '11164881600', -10800, '1'),
(71, '-04', '11175159600', -14400, '0'),
(71, '-03', '11196331200', -10800, '1'),
(71, '-04', '11206609200', -14400, '0'),
(71, '-03', '11227780800', -10800, '1'),
(71, '-04', '11238663600', -14400, '0'),
(71, '-03', '11259230400', -10800, '1'),
(71, '-04', '11270113200', -14400, '0'),
(71, '-03', '11290680000', -10800, '1'),
(71, '-04', '11301562800', -14400, '0'),
(71, '-03', '11322734400', -10800, '1'),
(71, '-04', '11333012400', -14400, '0'),
(71, '-03', '11354184000', -10800, '1'),
(71, '-04', '11364462000', -14400, '0'),
(71, '-03', '11385633600', -10800, '1'),
(71, '-04', '11395911600', -14400, '0'),
(71, '-03', '11417083200', -10800, '1'),
(71, '-04', '11427966000', -14400, '0'),
(71, '-03', '11448532800', -10800, '1'),
(71, '-04', '11459415600', -14400, '0'),
(71, '-03', '11479982400', -10800, '1'),
(71, '-04', '11490865200', -14400, '0'),
(71, '-03', '11512036800', -10800, '1'),
(71, '-04', '11522314800', -14400, '0'),
(71, '-03', '11543486400', -10800, '1'),
(71, '-04', '11553764400', -14400, '0'),
(71, '-03', '11574936000', -10800, '1'),
(71, '-04', '11585818800', -14400, '0'),
(71, '-03', '11606385600', -10800, '1'),
(71, '-04', '11617268400', -14400, '0'),
(71, '-03', '11637835200', -10800, '1'),
(71, '-04', '11648718000', -14400, '0'),
(71, '-03', '11669284800', -10800, '1'),
(71, '-04', '11680167600', -14400, '0'),
(71, '-03', '11701339200', -10800, '1'),
(71, '-04', '11711617200', -14400, '0'),
(71, '-03', '11732788800', -10800, '1'),
(71, '-04', '11743066800', -14400, '0'),
(71, '-03', '11764238400', -10800, '1'),
(71, '-04', '11775121200', -14400, '0'),
(71, '-03', '11795688000', -10800, '1'),
(71, '-04', '11806570800', -14400, '0'),
(71, '-03', '11827137600', -10800, '1'),
(71, '-04', '11838020400', -14400, '0'),
(71, '-03', '11859192000', -10800, '1'),
(71, '-04', '11869470000', -14400, '0'),
(71, '-03', '11890641600', -10800, '1'),
(71, '-04', '11900919600', -14400, '0'),
(71, '-03', '11922091200', -10800, '1'),
(71, '-04', '11932369200', -14400, '0'),
(71, '-03', '11953540800', -10800, '1'),
(71, '-04', '11964423600', -14400, '0'),
(71, '-03', '11984990400', -10800, '1'),
(71, '-04', '11995873200', -14400, '0'),
(71, '-03', '12016440000', -10800, '1'),
(71, '-04', '12027322800', -14400, '0'),
(71, '-03', '12048494400', -10800, '1'),
(71, '-04', '12058772400', -14400, '0'),
(71, '-03', '12079944000', -10800, '1'),
(71, '-04', '12090222000', -14400, '0'),
(71, '-03', '12111393600', -10800, '1'),
(71, '-04', '12122276400', -14400, '0'),
(71, '-03', '12142843200', -10800, '1'),
(71, '-04', '12153726000', -14400, '0'),
(71, '-03', '12174292800', -10800, '1'),
(71, '-04', '12185175600', -14400, '0'),
(71, '-03', '12206347200', -10800, '1'),
(71, '-04', '12216625200', -14400, '0'),
(71, '-03', '12237796800', -10800, '1'),
(71, '-04', '12248074800', -14400, '0'),
(71, '-03', '12269246400', -10800, '1'),
(71, '-04', '12279524400', -14400, '0'),
(71, '-03', '12300696000', -10800, '1');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(71, '-04', '12311578800', -14400, '0'),
(71, '-03', '12332145600', -10800, '1'),
(71, '-04', '12343028400', -14400, '0'),
(71, '-03', '12363595200', -10800, '1'),
(71, '-04', '12374478000', -14400, '0'),
(71, '-03', '12395649600', -10800, '1'),
(71, '-04', '12405927600', -14400, '0'),
(71, '-03', '12427099200', -10800, '1'),
(71, '-04', '12437377200', -14400, '0'),
(71, '-03', '12458548800', -10800, '1'),
(71, '-04', '12469431600', -14400, '0'),
(71, '-03', '12489998400', -10800, '1'),
(71, '-04', '12500881200', -14400, '0'),
(71, '-03', '12521448000', -10800, '1'),
(71, '-04', '12532330800', -14400, '0'),
(71, '-03', '12552897600', -10800, '1'),
(71, '-04', '12563780400', -14400, '0'),
(71, '-03', '12584952000', -10800, '1'),
(71, '-04', '12595230000', -14400, '0'),
(71, '-03', '12616401600', -10800, '1'),
(71, '-04', '12626679600', -14400, '0'),
(71, '-03', '12647851200', -10800, '1'),
(71, '-04', '12658734000', -14400, '0'),
(71, '-03', '12679300800', -10800, '1'),
(71, '-04', '12690183600', -14400, '0'),
(71, '-03', '12710750400', -10800, '1'),
(71, '-04', '12721633200', -14400, '0'),
(71, '-03', '12742804800', -10800, '1'),
(71, '-04', '12753082800', -14400, '0'),
(71, '-03', '12774254400', -10800, '1'),
(71, '-04', '12784532400', -14400, '0'),
(71, '-03', '12805704000', -10800, '1'),
(71, '-04', '12815982000', -14400, '0'),
(71, '-03', '12837153600', -10800, '1'),
(71, '-04', '12848036400', -14400, '0'),
(71, '-03', '12868603200', -10800, '1'),
(71, '-04', '12879486000', -14400, '0'),
(71, '-03', '12900052800', -10800, '1'),
(71, '-04', '12910935600', -14400, '0'),
(71, '-03', '12932107200', -10800, '1'),
(71, '-04', '12942385200', -14400, '0'),
(71, '-03', '12963556800', -10800, '1'),
(71, '-04', '12973834800', -14400, '0'),
(71, '-03', '12995006400', -10800, '1'),
(71, '-04', '13005889200', -14400, '0'),
(71, '-03', '13026456000', -10800, '1'),
(71, '-04', '13037338800', -14400, '0'),
(71, '-03', '13057905600', -10800, '1'),
(71, '-04', '13068788400', -14400, '0'),
(71, '-03', '13089960000', -10800, '1'),
(71, '-04', '13100238000', -14400, '0'),
(71, '-03', '13121409600', -10800, '1'),
(71, '-04', '13131687600', -14400, '0'),
(71, '-03', '13152859200', -10800, '1'),
(71, '-04', '13163137200', -14400, '0'),
(71, '-03', '13184308800', -10800, '1'),
(71, '-04', '13195191600', -14400, '0'),
(71, '-03', '13215758400', -10800, '1'),
(71, '-04', '13226641200', -14400, '0'),
(71, '-03', '13247208000', -10800, '1'),
(71, '-04', '13258090800', -14400, '0'),
(71, '-03', '13279262400', -10800, '1'),
(71, '-04', '13289540400', -14400, '0'),
(71, '-03', '13310712000', -10800, '1'),
(71, '-04', '13320990000', -14400, '0'),
(71, '-03', '13342161600', -10800, '1'),
(71, '-04', '13353044400', -14400, '0'),
(71, '-03', '13373611200', -10800, '1'),
(71, '-04', '13384494000', -14400, '0'),
(71, '-03', '13405060800', -10800, '1'),
(71, '-04', '13415943600', -14400, '0'),
(71, '-03', '13436510400', -10800, '1'),
(71, '-04', '13447393200', -14400, '0'),
(71, '-03', '13468564800', -10800, '1'),
(71, '-04', '13478842800', -14400, '0'),
(71, '-03', '13500014400', -10800, '1'),
(71, '-04', '13510292400', -14400, '0'),
(71, '-03', '13531464000', -10800, '1'),
(71, '-04', '13542346800', -14400, '0'),
(71, '-03', '13562913600', -10800, '1'),
(71, '-04', '13573796400', -14400, '0'),
(71, '-03', '13594363200', -10800, '1'),
(71, '-04', '13605246000', -14400, '0'),
(71, '-03', '13626417600', -10800, '1'),
(71, '-04', '13636695600', -14400, '0'),
(71, '-03', '13657867200', -10800, '1'),
(71, '-04', '13668145200', -14400, '0'),
(71, '-03', '13689316800', -10800, '1'),
(71, '-04', '13699594800', -14400, '0'),
(71, '-03', '13720766400', -10800, '1'),
(71, '-04', '13731649200', -14400, '0'),
(71, '-03', '13752216000', -10800, '1'),
(71, '-04', '13763098800', -14400, '0'),
(71, '-03', '13783665600', -10800, '1'),
(71, '-04', '13794548400', -14400, '0'),
(71, '-03', '13815720000', -10800, '1'),
(71, '-04', '13825998000', -14400, '0'),
(71, '-03', '13847169600', -10800, '1'),
(71, '-04', '13857447600', -14400, '0'),
(71, '-03', '13878619200', -10800, '1'),
(71, '-04', '13889502000', -14400, '0'),
(71, '-03', '13910068800', -10800, '1'),
(71, '-04', '13920951600', -14400, '0'),
(71, '-03', '13941518400', -10800, '1'),
(71, '-04', '13952401200', -14400, '0'),
(71, '-03', '13973572800', -10800, '1'),
(71, '-04', '13983850800', -14400, '0'),
(71, '-03', '14005022400', -10800, '1'),
(71, '-04', '14015300400', -14400, '0'),
(71, '-03', '14036472000', -10800, '1'),
(71, '-04', '14046750000', -14400, '0'),
(71, '-03', '14067921600', -10800, '1'),
(71, '-04', '14078804400', -14400, '0'),
(71, '-03', '14099371200', -10800, '1'),
(71, '-04', '14110254000', -14400, '0'),
(71, '-03', '14130820800', -10800, '1'),
(71, '-04', '14141703600', -14400, '0'),
(71, '-03', '14162875200', -10800, '1'),
(71, '-04', '14173153200', -14400, '0'),
(71, '-03', '14194324800', -10800, '1'),
(71, '-04', '14204602800', -14400, '0'),
(71, '-03', '14225774400', -10800, '1'),
(71, '-04', '14236657200', -14400, '0'),
(71, '-03', '14257224000', -10800, '1'),
(71, '-04', '14268106800', -14400, '0'),
(71, '-03', '14288673600', -10800, '1'),
(71, '-04', '14299556400', -14400, '0'),
(71, '-03', '14320123200', -10800, '1'),
(71, '-04', '14331006000', -14400, '0'),
(71, '-03', '14352177600', -10800, '1'),
(71, '-04', '14362455600', -14400, '0'),
(71, '-03', '14383627200', -10800, '1'),
(71, '-04', '14393905200', -14400, '0'),
(71, '-03', '14415076800', -10800, '1'),
(71, '-04', '14425959600', -14400, '0'),
(71, '-03', '14446526400', -10800, '1'),
(71, '-04', '14457409200', -14400, '0'),
(71, '-03', '14477976000', -10800, '1'),
(71, '-04', '14488858800', -14400, '0'),
(71, '-03', '14510030400', -10800, '1'),
(71, '-04', '14520308400', -14400, '0'),
(71, '-03', '14541480000', -10800, '1'),
(71, '-04', '14551758000', -14400, '0'),
(71, '-03', '14572929600', -10800, '1'),
(71, '-04', '14583207600', -14400, '0'),
(71, '-03', '14604379200', -10800, '1'),
(71, '-04', '14615262000', -14400, '0'),
(71, '-03', '14635828800', -10800, '1'),
(71, '-04', '14646711600', -14400, '0'),
(71, '-03', '14667278400', -10800, '1'),
(71, '-04', '14678161200', -14400, '0'),
(71, '-03', '14699332800', -10800, '1'),
(71, '-04', '14709610800', -14400, '0'),
(71, '-03', '14730782400', -10800, '1'),
(71, '-04', '14741060400', -14400, '0'),
(71, '-03', '14762232000', -10800, '1'),
(71, '-04', '14773114800', -14400, '0'),
(71, '-03', '14793681600', -10800, '1'),
(71, '-04', '14804564400', -14400, '0'),
(71, '-03', '14825131200', -10800, '1'),
(71, '-04', '14836014000', -14400, '0'),
(71, '-03', '14857185600', -10800, '1'),
(71, '-04', '14867463600', -14400, '0'),
(71, '-03', '14888635200', -10800, '1'),
(71, '-04', '14898913200', -14400, '0'),
(71, '-03', '14920084800', -10800, '1'),
(71, '-04', '14930362800', -14400, '0'),
(71, '-03', '14951534400', -10800, '1'),
(71, '-04', '14962417200', -14400, '0'),
(71, '-03', '14982984000', -10800, '1'),
(71, '-04', '14993866800', -14400, '0'),
(71, '-03', '15014433600', -10800, '1'),
(71, '-04', '15025316400', -14400, '0'),
(71, '-03', '15046488000', -10800, '1'),
(71, '-04', '15056766000', -14400, '0'),
(71, '-03', '15077937600', -10800, '1'),
(71, '-04', '15088215600', -14400, '0'),
(71, '-03', '15109387200', -10800, '1'),
(71, '-04', '15120270000', -14400, '0'),
(71, '-03', '15140836800', -10800, '1'),
(71, '-04', '15151719600', -14400, '0'),
(71, '-03', '15172286400', -10800, '1'),
(71, '-04', '15183169200', -14400, '0'),
(71, '-03', '15203736000', -10800, '1'),
(71, '-04', '15214618800', -14400, '0'),
(71, '-03', '15235790400', -10800, '1'),
(71, '-04', '15246068400', -14400, '0'),
(71, '-03', '15267240000', -10800, '1'),
(71, '-04', '15277518000', -14400, '0'),
(71, '-03', '15298689600', -10800, '1'),
(71, '-04', '15309572400', -14400, '0'),
(71, '-03', '15330139200', -10800, '1'),
(71, '-04', '15341022000', -14400, '0'),
(71, '-03', '15361588800', -10800, '1'),
(71, '-04', '15372471600', -14400, '0'),
(71, '-03', '15393643200', -10800, '1'),
(71, '-04', '15403921200', -14400, '0'),
(71, '-03', '15425092800', -10800, '1'),
(71, '-04', '15435370800', -14400, '0'),
(71, '-03', '15456542400', -10800, '1'),
(71, '-04', '15466820400', -14400, '0'),
(71, '-03', '15487992000', -10800, '1'),
(71, '-04', '15498874800', -14400, '0'),
(71, '-03', '15519441600', -10800, '1'),
(71, '-04', '15530324400', -14400, '0'),
(71, '-03', '15550891200', -10800, '1'),
(71, '-04', '15561774000', -14400, '0'),
(71, '-03', '15582945600', -10800, '1'),
(71, '-04', '15593223600', -14400, '0'),
(71, '-03', '15614395200', -10800, '1'),
(71, '-04', '15624673200', -14400, '0'),
(71, '-03', '15645844800', -10800, '1'),
(71, '-04', '15656727600', -14400, '0'),
(71, '-03', '15677294400', -10800, '1'),
(71, '-04', '15688177200', -14400, '0'),
(71, '-03', '15708744000', -10800, '1'),
(71, '-04', '15719626800', -14400, '0'),
(71, '-03', '15740798400', -10800, '1'),
(71, '-04', '15751076400', -14400, '0'),
(71, '-03', '15772248000', -10800, '1'),
(71, '-04', '15782526000', -14400, '0'),
(71, '-03', '15803697600', -10800, '1'),
(71, '-04', '15813975600', -14400, '0'),
(71, '-03', '15835147200', -10800, '1'),
(71, '-04', '15846030000', -14400, '0'),
(71, '-03', '15866596800', -10800, '1'),
(71, '-04', '15877479600', -14400, '0'),
(71, '-03', '15898046400', -10800, '1'),
(71, '-04', '15908929200', -14400, '0'),
(71, '-03', '15930100800', -10800, '1'),
(71, '-04', '15940378800', -14400, '0'),
(71, '-03', '15961550400', -10800, '1'),
(71, '-04', '15971828400', -14400, '0'),
(71, '-03', '15993000000', -10800, '1'),
(71, '-04', '16003882800', -14400, '0'),
(71, '-03', '16024449600', -10800, '1'),
(71, '-04', '16035332400', -14400, '0'),
(71, '-03', '16055899200', -10800, '1'),
(71, '-04', '16066782000', -14400, '0'),
(71, '-03', '16087348800', -10800, '1'),
(71, '-04', '16098231600', -14400, '0'),
(71, '-03', '16119403200', -10800, '1'),
(71, '-04', '16129681200', -14400, '0'),
(71, '-03', '16150852800', -10800, '1'),
(71, '-04', '16161130800', -14400, '0'),
(71, '-03', '16182302400', -10800, '1'),
(71, '-04', '16193185200', -14400, '0'),
(71, '-03', '16213752000', -10800, '1'),
(71, '-04', '16224634800', -14400, '0'),
(71, '-03', '16245201600', -10800, '1'),
(71, '-04', '16256084400', -14400, '0'),
(71, '-03', '16277256000', -10800, '1'),
(71, '-04', '16287534000', -14400, '0'),
(71, '-03', '16308705600', -10800, '1'),
(71, '-04', '16318983600', -14400, '0'),
(71, '-03', '16340155200', -10800, '1'),
(71, '-04', '16350433200', -14400, '0'),
(71, '-03', '16371604800', -10800, '1'),
(71, '-04', '16382487600', -14400, '0'),
(71, '-03', '16403054400', -10800, '1'),
(71, '-04', '16413937200', -14400, '0'),
(71, '-03', '16434504000', -10800, '1'),
(71, '-04', '16445386800', -14400, '0'),
(71, '-03', '16466558400', -10800, '1'),
(71, '-04', '16476836400', -14400, '0'),
(71, '-03', '16498008000', -10800, '1'),
(71, '-04', '16508286000', -14400, '0'),
(71, '-03', '16529457600', -10800, '1'),
(71, '-04', '16540340400', -14400, '0'),
(71, '-03', '16560907200', -10800, '1'),
(71, '-04', '16571790000', -14400, '0'),
(71, '-03', '16592356800', -10800, '1'),
(71, '-04', '16603239600', -14400, '0'),
(71, '-03', '16624411200', -10800, '1'),
(71, '-04', '16634689200', -14400, '0'),
(71, '-03', '16655860800', -10800, '1'),
(71, '-04', '16666138800', -14400, '0'),
(71, '-03', '16687310400', -10800, '1'),
(71, '-04', '16697588400', -14400, '0'),
(71, '-03', '16718760000', -10800, '1'),
(72, 'LMT', '-1767212141', -13460, '0'),
(72, '-04', '-1767212140', -14400, '0'),
(72, '-03', '-1206954000', -10800, '1'),
(72, '-04', '-1191358800', -14400, '0'),
(72, '-03', '-1175371200', -10800, '1'),
(72, '-04', '-1159822800', -14400, '0'),
(72, '-03', '-633816000', -10800, '1'),
(72, '-04', '-622065600', -14400, '0'),
(72, '-03', '-602280000', -10800, '1'),
(72, '-04', '-591829200', -14400, '0'),
(72, '-03', '-570744000', -10800, '1'),
(72, '-04', '-560206800', -14400, '0'),
(72, '-03', '-539121600', -10800, '1'),
(72, '-04', '-531349200', -14400, '0'),
(72, '-03', '-191361600', -10800, '1'),
(72, '-04', '-184194000', -14400, '0'),
(72, '-03', '-155160000', -10800, '1'),
(72, '-04', '-150066000', -14400, '0'),
(72, '-03', '-128894400', -10800, '1'),
(72, '-04', '-121122000', -14400, '0'),
(72, '-03', '-99950400', -10800, '1'),
(72, '-04', '-89586000', -14400, '0'),
(72, '-03', '-68414400', -10800, '1'),
(72, '-04', '-57963600', -14400, '0'),
(72, '-03', '499752000', -10800, '1'),
(72, '-04', '511239600', -14400, '0'),
(72, '-03', '530596800', -10800, '1'),
(72, '-04', '540270000', -14400, '0'),
(72, '-03', '562132800', -10800, '1'),
(72, '-04', '571201200', -14400, '0'),
(72, '-03', '592977600', -10800, '1'),
(72, '-04', '602046000', -14400, '0'),
(72, '-03', '624427200', -10800, '1'),
(72, '-04', '634705200', -14400, '0'),
(72, '-03', '656481600', -10800, '1'),
(72, '-04', '666759600', -14400, '0'),
(72, '-03', '687931200', -10800, '1'),
(72, '-04', '697604400', -14400, '0'),
(72, '-03', '719985600', -10800, '1'),
(72, '-04', '728449200', -14400, '0'),
(72, '-03', '750830400', -10800, '1'),
(72, '-04', '761713200', -14400, '0'),
(72, '-03', '782280000', -10800, '1'),
(72, '-04', '793162800', -14400, '0'),
(72, '-03', '813729600', -10800, '1'),
(72, '-04', '824007600', -14400, '0'),
(72, '-03', '844574400', -10800, '1'),
(72, '-04', '856062000', -14400, '0'),
(72, '-03', '876110400', -10800, '1'),
(72, '-04', '888721200', -14400, '0'),
(72, '-03', '908078400', -10800, '1'),
(72, '-04', '919566000', -14400, '0'),
(72, '-03', '938923200', -10800, '1'),
(72, '-04', '951620400', -14400, '0'),
(72, '-03', '970977600', -10800, '1'),
(72, '-04', '982465200', -14400, '0'),
(72, '-03', '1003032000', -10800, '1'),
(72, '-04', '1013914800', -14400, '0'),
(72, '-03', '1036296000', -10800, '1'),
(72, '-04', '1045364400', -14400, '0'),
(72, '-03', '1099368000', -10800, '1'),
(72, '-04', '1108868400', -14400, '0'),
(72, '-03', '1129435200', -10800, '1'),
(72, '-04', '1140318000', -14400, '0'),
(72, '-03', '1162699200', -10800, '1'),
(72, '-04', '1172372400', -14400, '0'),
(72, '-03', '1192334400', -10800, '1'),
(72, '-04', '1203217200', -14400, '0'),
(72, '-03', '1224388800', -10800, '1'),
(72, '-04', '1234666800', -14400, '0'),
(72, '-03', '1255838400', -10800, '1'),
(72, '-04', '1266721200', -14400, '0'),
(72, '-03', '1287288000', -10800, '1'),
(72, '-04', '1298170800', -14400, '0'),
(72, '-03', '1318737600', -10800, '1'),
(72, '-04', '1330225200', -14400, '0'),
(72, '-03', '1350792000', -10800, '1'),
(72, '-04', '1361070000', -14400, '0'),
(72, '-03', '1382241600', -10800, '1'),
(72, '-04', '1392519600', -14400, '0'),
(72, '-03', '1413691200', -10800, '1'),
(72, '-04', '1424574000', -14400, '0'),
(72, '-03', '1445140800', -10800, '1'),
(72, '-04', '1456023600', -14400, '0'),
(72, '-03', '1476590400', -10800, '1'),
(72, '-04', '1487473200', -14400, '0'),
(72, '-03', '1508040000', -10800, '1'),
(72, '-04', '1518922800', -14400, '0'),
(72, '-03', '1540094400', -10800, '1'),
(72, '-04', '1550372400', -14400, '0'),
(72, '-03', '1571544000', -10800, '1'),
(72, '-04', '1581822000', -14400, '0'),
(72, '-03', '1602993600', -10800, '1'),
(72, '-04', '1613876400', -14400, '0'),
(72, '-03', '1634443200', -10800, '1'),
(72, '-04', '1645326000', -14400, '0'),
(72, '-03', '1665892800', -10800, '1'),
(72, '-04', '1677380400', -14400, '0'),
(72, '-03', '1697342400', -10800, '1'),
(72, '-04', '1708225200', -14400, '0'),
(72, '-03', '1729396800', -10800, '1'),
(72, '-04', '1739674800', -14400, '0'),
(72, '-03', '1760846400', -10800, '1'),
(72, '-04', '1771729200', -14400, '0'),
(72, '-03', '1792296000', -10800, '1'),
(72, '-04', '1803178800', -14400, '0'),
(72, '-03', '1823745600', -10800, '1'),
(72, '-04', '1834628400', -14400, '0'),
(72, '-03', '1855195200', -10800, '1'),
(72, '-04', '1866078000', -14400, '0'),
(72, '-03', '1887249600', -10800, '1'),
(72, '-04', '1897527600', -14400, '0'),
(72, '-03', '1918699200', -10800, '1'),
(72, '-04', '1928977200', -14400, '0'),
(72, '-03', '1950148800', -10800, '1'),
(72, '-04', '1960426800', -14400, '0'),
(72, '-03', '1981598400', -10800, '1'),
(72, '-04', '1992481200', -14400, '0'),
(72, '-03', '2013048000', -10800, '1'),
(72, '-04', '2024535600', -14400, '0'),
(72, '-03', '2044497600', -10800, '1'),
(72, '-04', '2055380400', -14400, '0'),
(72, '-03', '2076552000', -10800, '1'),
(72, '-04', '2086830000', -14400, '0'),
(72, '-03', '2108001600', -10800, '1'),
(72, '-04', '2118884400', -14400, '0'),
(72, '-03', '2139451200', -10800, '1'),
(72, '-04', '2150334000', -14400, '0'),
(72, '-03', '2170900800', -10800, '1'),
(72, '-04', '2181783600', -14400, '0'),
(72, '-03', '2202350400', -10800, '1'),
(72, '-04', '2213233200', -14400, '0'),
(72, '-03', '2234404800', -10800, '1'),
(72, '-04', '2244682800', -14400, '0'),
(72, '-03', '2265854400', -10800, '1'),
(72, '-04', '2276132400', -14400, '0'),
(72, '-03', '2297304000', -10800, '1'),
(72, '-04', '2307582000', -14400, '0'),
(72, '-03', '2328753600', -10800, '1'),
(72, '-04', '2339636400', -14400, '0'),
(72, '-03', '2360203200', -10800, '1'),
(72, '-04', '2371086000', -14400, '0'),
(72, '-03', '2391652800', -10800, '1'),
(72, '-04', '2402535600', -14400, '0'),
(72, '-03', '2423707200', -10800, '1'),
(72, '-04', '2433985200', -14400, '0'),
(72, '-03', '2455156800', -10800, '1'),
(72, '-04', '2465434800', -14400, '0'),
(72, '-03', '2486606400', -10800, '1'),
(72, '-04', '2497489200', -14400, '0'),
(72, '-03', '2518056000', -10800, '1'),
(72, '-04', '2528938800', -14400, '0'),
(72, '-03', '2549505600', -10800, '1'),
(72, '-04', '2560388400', -14400, '0'),
(72, '-03', '2580955200', -10800, '1'),
(72, '-04', '2591838000', -14400, '0'),
(72, '-03', '2613009600', -10800, '1'),
(72, '-04', '2623287600', -14400, '0'),
(72, '-03', '2644459200', -10800, '1'),
(72, '-04', '2654737200', -14400, '0'),
(72, '-03', '2675908800', -10800, '1'),
(72, '-04', '2686791600', -14400, '0'),
(72, '-03', '2707358400', -10800, '1'),
(72, '-04', '2718241200', -14400, '0'),
(72, '-03', '2738808000', -10800, '1'),
(72, '-04', '2749690800', -14400, '0'),
(72, '-03', '2770862400', -10800, '1'),
(72, '-04', '2781140400', -14400, '0'),
(72, '-03', '2802312000', -10800, '1'),
(72, '-04', '2812590000', -14400, '0'),
(72, '-03', '2833761600', -10800, '1'),
(72, '-04', '2844039600', -14400, '0'),
(72, '-03', '2865211200', -10800, '1'),
(72, '-04', '2876094000', -14400, '0'),
(72, '-03', '2896660800', -10800, '1'),
(72, '-04', '2907543600', -14400, '0'),
(72, '-03', '2928110400', -10800, '1'),
(72, '-04', '2938993200', -14400, '0'),
(72, '-03', '2960164800', -10800, '1'),
(72, '-04', '2970442800', -14400, '0'),
(72, '-03', '2991614400', -10800, '1'),
(72, '-04', '3001892400', -14400, '0'),
(72, '-03', '3023064000', -10800, '1'),
(72, '-04', '3033946800', -14400, '0'),
(72, '-03', '3054513600', -10800, '1'),
(72, '-04', '3065396400', -14400, '0'),
(72, '-03', '3085963200', -10800, '1'),
(72, '-04', '3096846000', -14400, '0'),
(72, '-03', '3118017600', -10800, '1'),
(72, '-04', '3128295600', -14400, '0'),
(72, '-03', '3149467200', -10800, '1'),
(72, '-04', '3159745200', -14400, '0'),
(72, '-03', '3180916800', -10800, '1'),
(72, '-04', '3191194800', -14400, '0'),
(72, '-03', '3212366400', -10800, '1'),
(72, '-04', '3223249200', -14400, '0'),
(72, '-03', '3243816000', -10800, '1'),
(72, '-04', '3254698800', -14400, '0'),
(72, '-03', '3275265600', -10800, '1'),
(72, '-04', '3286148400', -14400, '0'),
(72, '-03', '3307320000', -10800, '1'),
(72, '-04', '3317598000', -14400, '0'),
(72, '-03', '3338769600', -10800, '1'),
(72, '-04', '3349047600', -14400, '0'),
(72, '-03', '3370219200', -10800, '1'),
(72, '-04', '3381102000', -14400, '0'),
(72, '-03', '3401668800', -10800, '1'),
(72, '-04', '3412551600', -14400, '0'),
(72, '-03', '3433118400', -10800, '1'),
(72, '-04', '3444001200', -14400, '0'),
(72, '-03', '3464568000', -10800, '1'),
(72, '-04', '3475450800', -14400, '0'),
(72, '-03', '3496622400', -10800, '1'),
(72, '-04', '3506900400', -14400, '0'),
(72, '-03', '3528072000', -10800, '1'),
(72, '-04', '3538350000', -14400, '0'),
(72, '-03', '3559521600', -10800, '1'),
(72, '-04', '3570404400', -14400, '0'),
(72, '-03', '3590971200', -10800, '1'),
(72, '-04', '3601854000', -14400, '0'),
(72, '-03', '3622420800', -10800, '1'),
(72, '-04', '3633303600', -14400, '0'),
(72, '-03', '3654475200', -10800, '1'),
(72, '-04', '3664753200', -14400, '0'),
(72, '-03', '3685924800', -10800, '1'),
(72, '-04', '3696202800', -14400, '0'),
(72, '-03', '3717374400', -10800, '1'),
(72, '-04', '3727652400', -14400, '0'),
(72, '-03', '3748824000', -10800, '1'),
(72, '-04', '3759706800', -14400, '0'),
(72, '-03', '3780273600', -10800, '1'),
(72, '-04', '3791156400', -14400, '0'),
(72, '-03', '3811723200', -10800, '1'),
(72, '-04', '3822606000', -14400, '0'),
(72, '-03', '3843777600', -10800, '1'),
(72, '-04', '3854055600', -14400, '0'),
(72, '-03', '3875227200', -10800, '1'),
(72, '-04', '3885505200', -14400, '0'),
(72, '-03', '3906676800', -10800, '1'),
(72, '-04', '3917559600', -14400, '0'),
(72, '-03', '3938126400', -10800, '1'),
(72, '-04', '3949009200', -14400, '0'),
(72, '-03', '3969576000', -10800, '1'),
(72, '-04', '3980458800', -14400, '0'),
(72, '-03', '4001630400', -10800, '1'),
(72, '-04', '4011908400', -14400, '0'),
(72, '-03', '4033080000', -10800, '1'),
(72, '-04', '4043358000', -14400, '0'),
(72, '-03', '4064529600', -10800, '1'),
(72, '-04', '4074807600', -14400, '0'),
(72, '-03', '4095979200', -10800, '1'),
(72, '-04', '4106862000', -14400, '0'),
(72, '-03', '4127428800', -10800, '1'),
(72, '-04', '4138311600', -14400, '0'),
(72, '-03', '4158878400', -10800, '1'),
(72, '-04', '4169761200', -14400, '0'),
(72, '-03', '4190328000', -10800, '1'),
(72, '-04', '4201210800', -14400, '0'),
(72, '-03', '4222382400', -10800, '1'),
(72, '-04', '4232660400', -14400, '0'),
(72, '-03', '4253832000', -10800, '1'),
(72, '-04', '4264110000', -14400, '0'),
(72, '-03', '4285281600', -10800, '1'),
(72, '-04', '4296164400', -14400, '0'),
(72, '-03', '4316731200', -10800, '1'),
(72, '-04', '4327614000', -14400, '0'),
(72, '-03', '4348180800', -10800, '1'),
(72, '-04', '4359063600', -14400, '0'),
(72, '-03', '4380235200', -10800, '1'),
(72, '-04', '4390513200', -14400, '0'),
(72, '-03', '4411684800', -10800, '1'),
(72, '-04', '4421962800', -14400, '0'),
(72, '-03', '4443134400', -10800, '1'),
(72, '-04', '4453412400', -14400, '0'),
(72, '-03', '4474584000', -10800, '1'),
(72, '-04', '4485466800', -14400, '0'),
(72, '-03', '4506033600', -10800, '1'),
(72, '-04', '4516916400', -14400, '0'),
(72, '-03', '4537483200', -10800, '1'),
(72, '-04', '4548366000', -14400, '0'),
(72, '-03', '4569537600', -10800, '1'),
(72, '-04', '4579815600', -14400, '0'),
(72, '-03', '4600987200', -10800, '1'),
(72, '-04', '4611265200', -14400, '0'),
(72, '-03', '4632436800', -10800, '1'),
(72, '-04', '4643319600', -14400, '0'),
(72, '-03', '4663886400', -10800, '1'),
(72, '-04', '4674769200', -14400, '0'),
(72, '-03', '4695336000', -10800, '1'),
(72, '-04', '4706218800', -14400, '0'),
(72, '-03', '4726785600', -10800, '1'),
(72, '-04', '4737668400', -14400, '0'),
(72, '-03', '4758840000', -10800, '1'),
(72, '-04', '4769118000', -14400, '0'),
(72, '-03', '4790289600', -10800, '1'),
(72, '-04', '4800567600', -14400, '0'),
(72, '-03', '4821739200', -10800, '1'),
(72, '-04', '4832622000', -14400, '0'),
(72, '-03', '4853188800', -10800, '1'),
(72, '-04', '4864071600', -14400, '0'),
(72, '-03', '4884638400', -10800, '1'),
(72, '-04', '4895521200', -14400, '0'),
(72, '-03', '4916692800', -10800, '1'),
(72, '-04', '4926970800', -14400, '0'),
(72, '-03', '4948142400', -10800, '1'),
(72, '-04', '4958420400', -14400, '0'),
(72, '-03', '4979592000', -10800, '1'),
(72, '-04', '4989870000', -14400, '0'),
(72, '-03', '5011041600', -10800, '1'),
(72, '-04', '5021924400', -14400, '0'),
(72, '-03', '5042491200', -10800, '1'),
(72, '-04', '5053374000', -14400, '0'),
(72, '-03', '5073940800', -10800, '1'),
(72, '-04', '5084823600', -14400, '0'),
(72, '-03', '5105995200', -10800, '1'),
(72, '-04', '5116273200', -14400, '0'),
(72, '-03', '5137444800', -10800, '1'),
(72, '-04', '5147722800', -14400, '0'),
(72, '-03', '5168894400', -10800, '1'),
(72, '-04', '5179777200', -14400, '0'),
(72, '-03', '5200344000', -10800, '1'),
(72, '-04', '5211226800', -14400, '0'),
(72, '-03', '5231793600', -10800, '1'),
(72, '-04', '5242676400', -14400, '0'),
(72, '-03', '5263848000', -10800, '1'),
(72, '-04', '5274126000', -14400, '0'),
(72, '-03', '5295297600', -10800, '1'),
(72, '-04', '5305575600', -14400, '0'),
(72, '-03', '5326747200', -10800, '1'),
(72, '-04', '5337025200', -14400, '0'),
(72, '-03', '5358196800', -10800, '1'),
(72, '-04', '5369079600', -14400, '0'),
(72, '-03', '5389646400', -10800, '1'),
(72, '-04', '5400529200', -14400, '0'),
(72, '-03', '5421096000', -10800, '1'),
(72, '-04', '5431978800', -14400, '0'),
(72, '-03', '5453150400', -10800, '1'),
(72, '-04', '5463428400', -14400, '0'),
(72, '-03', '5484600000', -10800, '1'),
(72, '-04', '5494878000', -14400, '0'),
(72, '-03', '5516049600', -10800, '1'),
(72, '-04', '5526932400', -14400, '0'),
(72, '-03', '5547499200', -10800, '1'),
(72, '-04', '5558382000', -14400, '0'),
(72, '-03', '5578948800', -10800, '1'),
(72, '-04', '5589831600', -14400, '0'),
(72, '-03', '5610398400', -10800, '1'),
(72, '-04', '5621281200', -14400, '0'),
(72, '-03', '5642452800', -10800, '1'),
(72, '-04', '5652730800', -14400, '0'),
(72, '-03', '5673902400', -10800, '1'),
(72, '-04', '5684180400', -14400, '0'),
(72, '-03', '5705352000', -10800, '1'),
(72, '-04', '5716234800', -14400, '0'),
(72, '-03', '5736801600', -10800, '1'),
(72, '-04', '5747684400', -14400, '0'),
(72, '-03', '5768251200', -10800, '1'),
(72, '-04', '5779134000', -14400, '0'),
(72, '-03', '5800305600', -10800, '1'),
(72, '-04', '5810583600', -14400, '0'),
(72, '-03', '5831755200', -10800, '1'),
(72, '-04', '5842033200', -14400, '0'),
(72, '-03', '5863204800', -10800, '1'),
(72, '-04', '5873482800', -14400, '0'),
(72, '-03', '5894654400', -10800, '1'),
(72, '-04', '5905537200', -14400, '0'),
(72, '-03', '5926104000', -10800, '1'),
(72, '-04', '5936986800', -14400, '0'),
(72, '-03', '5957553600', -10800, '1'),
(72, '-04', '5968436400', -14400, '0'),
(72, '-03', '5989608000', -10800, '1'),
(72, '-04', '5999886000', -14400, '0'),
(72, '-03', '6021057600', -10800, '1'),
(72, '-04', '6031335600', -14400, '0'),
(72, '-03', '6052507200', -10800, '1'),
(72, '-04', '6063390000', -14400, '0'),
(72, '-03', '6083956800', -10800, '1'),
(72, '-04', '6094839600', -14400, '0'),
(72, '-03', '6115406400', -10800, '1'),
(72, '-04', '6126289200', -14400, '0'),
(72, '-03', '6147460800', -10800, '1'),
(72, '-04', '6157738800', -14400, '0'),
(72, '-03', '6178910400', -10800, '1'),
(72, '-04', '6189188400', -14400, '0'),
(72, '-03', '6210360000', -10800, '1'),
(72, '-04', '6220638000', -14400, '0'),
(72, '-03', '6241809600', -10800, '1'),
(72, '-04', '6252692400', -14400, '0'),
(72, '-03', '6273259200', -10800, '1'),
(72, '-04', '6284142000', -14400, '0'),
(72, '-03', '6304708800', -10800, '1'),
(72, '-04', '6315591600', -14400, '0'),
(72, '-03', '6336763200', -10800, '1'),
(72, '-04', '6347041200', -14400, '0'),
(72, '-03', '6368212800', -10800, '1'),
(72, '-04', '6378490800', -14400, '0'),
(72, '-03', '6399662400', -10800, '1'),
(72, '-04', '6410545200', -14400, '0'),
(72, '-03', '6431112000', -10800, '1'),
(72, '-04', '6441994800', -14400, '0'),
(72, '-03', '6462561600', -10800, '1'),
(72, '-04', '6473444400', -14400, '0'),
(72, '-03', '6494011200', -10800, '1'),
(72, '-04', '6504894000', -14400, '0'),
(72, '-03', '6526065600', -10800, '1'),
(72, '-04', '6536343600', -14400, '0'),
(72, '-03', '6557515200', -10800, '1'),
(72, '-04', '6567793200', -14400, '0'),
(72, '-03', '6588964800', -10800, '1'),
(72, '-04', '6599847600', -14400, '0'),
(72, '-03', '6620414400', -10800, '1'),
(72, '-04', '6631297200', -14400, '0'),
(72, '-03', '6651864000', -10800, '1'),
(72, '-04', '6662746800', -14400, '0'),
(72, '-03', '6683918400', -10800, '1'),
(72, '-04', '6694196400', -14400, '0'),
(72, '-03', '6715368000', -10800, '1'),
(72, '-04', '6725646000', -14400, '0'),
(72, '-03', '6746817600', -10800, '1'),
(72, '-04', '6757095600', -14400, '0'),
(72, '-03', '6778267200', -10800, '1'),
(72, '-04', '6789150000', -14400, '0'),
(72, '-03', '6809716800', -10800, '1'),
(72, '-04', '6820599600', -14400, '0'),
(72, '-03', '6841166400', -10800, '1'),
(72, '-04', '6852049200', -14400, '0'),
(72, '-03', '6873220800', -10800, '1'),
(72, '-04', '6883498800', -14400, '0'),
(72, '-03', '6904670400', -10800, '1'),
(72, '-04', '6914948400', -14400, '0'),
(72, '-03', '6936120000', -10800, '1'),
(72, '-04', '6947002800', -14400, '0'),
(72, '-03', '6967569600', -10800, '1'),
(72, '-04', '6978452400', -14400, '0'),
(72, '-03', '6999019200', -10800, '1'),
(72, '-04', '7009902000', -14400, '0'),
(72, '-03', '7031073600', -10800, '1'),
(72, '-04', '7041351600', -14400, '0'),
(72, '-03', '7062523200', -10800, '1'),
(72, '-04', '7072801200', -14400, '0'),
(72, '-03', '7093972800', -10800, '1'),
(72, '-04', '7104250800', -14400, '0'),
(72, '-03', '7125422400', -10800, '1'),
(72, '-04', '7136305200', -14400, '0'),
(72, '-03', '7156872000', -10800, '1'),
(72, '-04', '7167754800', -14400, '0'),
(72, '-03', '7188321600', -10800, '1'),
(72, '-04', '7199204400', -14400, '0'),
(72, '-03', '7220376000', -10800, '1'),
(72, '-04', '7230654000', -14400, '0'),
(72, '-03', '7251825600', -10800, '1'),
(72, '-04', '7262103600', -14400, '0'),
(72, '-03', '7283275200', -10800, '1'),
(72, '-04', '7293553200', -14400, '0'),
(72, '-03', '7314724800', -10800, '1'),
(72, '-04', '7325607600', -14400, '0'),
(72, '-03', '7346174400', -10800, '1'),
(72, '-04', '7357057200', -14400, '0'),
(72, '-03', '7377624000', -10800, '1'),
(72, '-04', '7388506800', -14400, '0'),
(72, '-03', '7409678400', -10800, '1'),
(72, '-04', '7419956400', -14400, '0'),
(72, '-03', '7441128000', -10800, '1'),
(72, '-04', '7451406000', -14400, '0'),
(72, '-03', '7472577600', -10800, '1'),
(72, '-04', '7482855600', -14400, '0'),
(72, '-03', '7504027200', -10800, '1'),
(72, '-04', '7514910000', -14400, '0'),
(72, '-03', '7535476800', -10800, '1'),
(72, '-04', '7546359600', -14400, '0'),
(72, '-03', '7566926400', -10800, '1'),
(72, '-04', '7577809200', -14400, '0'),
(72, '-03', '7598980800', -10800, '1'),
(72, '-04', '7609258800', -14400, '0'),
(72, '-03', '7630430400', -10800, '1'),
(72, '-04', '7640708400', -14400, '0'),
(72, '-03', '7661880000', -10800, '1'),
(72, '-04', '7672762800', -14400, '0'),
(72, '-03', '7693329600', -10800, '1'),
(72, '-04', '7704212400', -14400, '0'),
(72, '-03', '7724779200', -10800, '1'),
(72, '-04', '7735662000', -14400, '0'),
(72, '-03', '7756228800', -10800, '1'),
(72, '-04', '7767111600', -14400, '0'),
(72, '-03', '7788283200', -10800, '1'),
(72, '-04', '7798561200', -14400, '0'),
(72, '-03', '7819732800', -10800, '1'),
(72, '-04', '7830010800', -14400, '0'),
(72, '-03', '7851182400', -10800, '1'),
(72, '-04', '7862065200', -14400, '0'),
(72, '-03', '7882632000', -10800, '1'),
(72, '-04', '7893514800', -14400, '0'),
(72, '-03', '7914081600', -10800, '1'),
(72, '-04', '7924964400', -14400, '0'),
(72, '-03', '7946136000', -10800, '1'),
(72, '-04', '7956414000', -14400, '0'),
(72, '-03', '7977585600', -10800, '1'),
(72, '-04', '7987863600', -14400, '0'),
(72, '-03', '8009035200', -10800, '1'),
(72, '-04', '8019313200', -14400, '0'),
(72, '-03', '8040484800', -10800, '1'),
(72, '-04', '8051367600', -14400, '0'),
(72, '-03', '8071934400', -10800, '1'),
(72, '-04', '8082817200', -14400, '0'),
(72, '-03', '8103384000', -10800, '1'),
(72, '-04', '8114266800', -14400, '0'),
(72, '-03', '8135438400', -10800, '1'),
(72, '-04', '8145716400', -14400, '0'),
(72, '-03', '8166888000', -10800, '1'),
(72, '-04', '8177166000', -14400, '0'),
(72, '-03', '8198337600', -10800, '1'),
(72, '-04', '8209220400', -14400, '0'),
(72, '-03', '8229787200', -10800, '1'),
(72, '-04', '8240670000', -14400, '0'),
(72, '-03', '8261236800', -10800, '1'),
(72, '-04', '8272119600', -14400, '0'),
(72, '-03', '8293291200', -10800, '1'),
(72, '-04', '8303569200', -14400, '0'),
(72, '-03', '8324740800', -10800, '1'),
(72, '-04', '8335018800', -14400, '0'),
(72, '-03', '8356190400', -10800, '1'),
(72, '-04', '8366468400', -14400, '0'),
(72, '-03', '8387640000', -10800, '1'),
(72, '-04', '8398522800', -14400, '0'),
(72, '-03', '8419089600', -10800, '1'),
(72, '-04', '8429972400', -14400, '0'),
(72, '-03', '8450539200', -10800, '1'),
(72, '-04', '8461422000', -14400, '0'),
(72, '-03', '8482593600', -10800, '1'),
(72, '-04', '8492871600', -14400, '0'),
(72, '-03', '8514043200', -10800, '1'),
(72, '-04', '8524321200', -14400, '0'),
(72, '-03', '8545492800', -10800, '1'),
(72, '-04', '8556375600', -14400, '0'),
(72, '-03', '8576942400', -10800, '1'),
(72, '-04', '8587825200', -14400, '0'),
(72, '-03', '8608392000', -10800, '1'),
(72, '-04', '8619274800', -14400, '0'),
(72, '-03', '8639841600', -10800, '1'),
(72, '-04', '8650724400', -14400, '0'),
(72, '-03', '8671896000', -10800, '1'),
(72, '-04', '8682174000', -14400, '0'),
(72, '-03', '8703345600', -10800, '1'),
(72, '-04', '8713623600', -14400, '0'),
(72, '-03', '8734795200', -10800, '1'),
(72, '-04', '8745678000', -14400, '0'),
(72, '-03', '8766244800', -10800, '1'),
(72, '-04', '8777127600', -14400, '0'),
(72, '-03', '8797694400', -10800, '1'),
(72, '-04', '8808577200', -14400, '0'),
(72, '-03', '8829748800', -10800, '1'),
(72, '-04', '8840026800', -14400, '0'),
(72, '-03', '8861198400', -10800, '1'),
(72, '-04', '8871476400', -14400, '0'),
(72, '-03', '8892648000', -10800, '1'),
(72, '-04', '8902926000', -14400, '0'),
(72, '-03', '8924097600', -10800, '1'),
(72, '-04', '8934980400', -14400, '0'),
(72, '-03', '8955547200', -10800, '1'),
(72, '-04', '8966430000', -14400, '0'),
(72, '-03', '8986996800', -10800, '1'),
(72, '-04', '8997879600', -14400, '0'),
(72, '-03', '9019051200', -10800, '1'),
(72, '-04', '9029329200', -14400, '0'),
(72, '-03', '9050500800', -10800, '1'),
(72, '-04', '9060778800', -14400, '0'),
(72, '-03', '9081950400', -10800, '1'),
(72, '-04', '9092833200', -14400, '0'),
(72, '-03', '9113400000', -10800, '1'),
(72, '-04', '9124282800', -14400, '0'),
(72, '-03', '9144849600', -10800, '1'),
(72, '-04', '9155732400', -14400, '0'),
(72, '-03', '9176904000', -10800, '1'),
(72, '-04', '9187182000', -14400, '0'),
(72, '-03', '9208353600', -10800, '1'),
(72, '-04', '9218631600', -14400, '0'),
(72, '-03', '9239803200', -10800, '1'),
(72, '-04', '9250081200', -14400, '0'),
(72, '-03', '9271252800', -10800, '1'),
(72, '-04', '9282135600', -14400, '0'),
(72, '-03', '9302702400', -10800, '1'),
(72, '-04', '9313585200', -14400, '0'),
(72, '-03', '9334152000', -10800, '1'),
(72, '-04', '9345034800', -14400, '0'),
(72, '-03', '9366206400', -10800, '1'),
(72, '-04', '9376484400', -14400, '0'),
(72, '-03', '9397656000', -10800, '1'),
(72, '-04', '9407934000', -14400, '0'),
(72, '-03', '9429105600', -10800, '1'),
(72, '-04', '9439988400', -14400, '0'),
(72, '-03', '9460555200', -10800, '1'),
(72, '-04', '9471438000', -14400, '0'),
(72, '-03', '9492004800', -10800, '1'),
(72, '-04', '9502887600', -14400, '0'),
(72, '-03', '9523454400', -10800, '1'),
(72, '-04', '9534337200', -14400, '0'),
(72, '-03', '9555508800', -10800, '1'),
(72, '-04', '9565786800', -14400, '0'),
(72, '-03', '9586958400', -10800, '1'),
(72, '-04', '9597236400', -14400, '0'),
(72, '-03', '9618408000', -10800, '1'),
(72, '-04', '9629290800', -14400, '0'),
(72, '-03', '9649857600', -10800, '1'),
(72, '-04', '9660740400', -14400, '0'),
(72, '-03', '9681307200', -10800, '1'),
(72, '-04', '9692190000', -14400, '0'),
(72, '-03', '9713361600', -10800, '1'),
(72, '-04', '9723639600', -14400, '0'),
(72, '-03', '9744811200', -10800, '1'),
(72, '-04', '9755089200', -14400, '0'),
(72, '-03', '9776260800', -10800, '1'),
(72, '-04', '9786538800', -14400, '0'),
(72, '-03', '9807710400', -10800, '1'),
(72, '-04', '9818593200', -14400, '0'),
(72, '-03', '9839160000', -10800, '1'),
(72, '-04', '9850042800', -14400, '0'),
(72, '-03', '9870609600', -10800, '1'),
(72, '-04', '9881492400', -14400, '0'),
(72, '-03', '9902664000', -10800, '1'),
(72, '-04', '9912942000', -14400, '0'),
(72, '-03', '9934113600', -10800, '1'),
(72, '-04', '9944391600', -14400, '0'),
(72, '-03', '9965563200', -10800, '1'),
(72, '-04', '9976446000', -14400, '0'),
(72, '-03', '9997012800', -10800, '1'),
(72, '-04', '10007895600', -14400, '0'),
(72, '-03', '10028462400', -10800, '1'),
(72, '-04', '10039345200', -14400, '0'),
(72, '-03', '10060516800', -10800, '1'),
(72, '-04', '10070794800', -14400, '0'),
(72, '-03', '10091966400', -10800, '1'),
(72, '-04', '10102244400', -14400, '0'),
(72, '-03', '10123416000', -10800, '1'),
(72, '-04', '10133694000', -14400, '0'),
(72, '-03', '10154865600', -10800, '1'),
(72, '-04', '10165748400', -14400, '0'),
(72, '-03', '10186315200', -10800, '1'),
(72, '-04', '10197198000', -14400, '0'),
(72, '-03', '10217764800', -10800, '1'),
(72, '-04', '10228647600', -14400, '0'),
(72, '-03', '10249819200', -10800, '1'),
(72, '-04', '10260097200', -14400, '0'),
(72, '-03', '10281268800', -10800, '1'),
(72, '-04', '10291546800', -14400, '0'),
(72, '-03', '10312718400', -10800, '1'),
(72, '-04', '10323601200', -14400, '0'),
(72, '-03', '10344168000', -10800, '1'),
(72, '-04', '10355050800', -14400, '0'),
(72, '-03', '10375617600', -10800, '1'),
(72, '-04', '10386500400', -14400, '0'),
(72, '-03', '10407067200', -10800, '1'),
(72, '-04', '10417950000', -14400, '0'),
(72, '-03', '10439121600', -10800, '1'),
(72, '-04', '10449399600', -14400, '0'),
(72, '-03', '10470571200', -10800, '1'),
(72, '-04', '10480849200', -14400, '0'),
(72, '-03', '10502020800', -10800, '1'),
(72, '-04', '10512298800', -14400, '0'),
(72, '-03', '10533470400', -10800, '1'),
(72, '-04', '10544353200', -14400, '0'),
(72, '-03', '10564920000', -10800, '1'),
(72, '-04', '10575802800', -14400, '0'),
(72, '-03', '10596369600', -10800, '1'),
(72, '-04', '10607252400', -14400, '0'),
(72, '-03', '10628424000', -10800, '1'),
(72, '-04', '10638702000', -14400, '0'),
(72, '-03', '10659873600', -10800, '1'),
(72, '-04', '10670151600', -14400, '0'),
(72, '-03', '10691323200', -10800, '1'),
(72, '-04', '10702206000', -14400, '0'),
(72, '-03', '10722772800', -10800, '1'),
(72, '-04', '10733655600', -14400, '0'),
(72, '-03', '10754222400', -10800, '1'),
(72, '-04', '10765105200', -14400, '0'),
(72, '-03', '10785672000', -10800, '1'),
(72, '-04', '10796554800', -14400, '0'),
(72, '-03', '10817726400', -10800, '1'),
(72, '-04', '10828004400', -14400, '0'),
(72, '-03', '10849176000', -10800, '1'),
(72, '-04', '10859454000', -14400, '0'),
(72, '-03', '10880625600', -10800, '1'),
(72, '-04', '10891508400', -14400, '0'),
(72, '-03', '10912075200', -10800, '1'),
(72, '-04', '10922958000', -14400, '0'),
(72, '-03', '10943524800', -10800, '1'),
(72, '-04', '10954407600', -14400, '0'),
(72, '-03', '10975579200', -10800, '1'),
(72, '-04', '10985857200', -14400, '0'),
(72, '-03', '11007028800', -10800, '1'),
(72, '-04', '11017306800', -14400, '0'),
(72, '-03', '11038478400', -10800, '1'),
(72, '-04', '11048756400', -14400, '0'),
(72, '-03', '11069928000', -10800, '1'),
(72, '-04', '11080810800', -14400, '0'),
(72, '-03', '11101377600', -10800, '1'),
(72, '-04', '11112260400', -14400, '0'),
(72, '-03', '11132827200', -10800, '1'),
(72, '-04', '11143710000', -14400, '0'),
(72, '-03', '11164881600', -10800, '1'),
(72, '-04', '11175159600', -14400, '0'),
(72, '-03', '11196331200', -10800, '1'),
(72, '-04', '11206609200', -14400, '0'),
(72, '-03', '11227780800', -10800, '1'),
(72, '-04', '11238663600', -14400, '0'),
(72, '-03', '11259230400', -10800, '1'),
(72, '-04', '11270113200', -14400, '0'),
(72, '-03', '11290680000', -10800, '1'),
(72, '-04', '11301562800', -14400, '0'),
(72, '-03', '11322734400', -10800, '1'),
(72, '-04', '11333012400', -14400, '0'),
(72, '-03', '11354184000', -10800, '1'),
(72, '-04', '11364462000', -14400, '0'),
(72, '-03', '11385633600', -10800, '1'),
(72, '-04', '11395911600', -14400, '0'),
(72, '-03', '11417083200', -10800, '1'),
(72, '-04', '11427966000', -14400, '0'),
(72, '-03', '11448532800', -10800, '1'),
(72, '-04', '11459415600', -14400, '0'),
(72, '-03', '11479982400', -10800, '1'),
(72, '-04', '11490865200', -14400, '0'),
(72, '-03', '11512036800', -10800, '1'),
(72, '-04', '11522314800', -14400, '0'),
(72, '-03', '11543486400', -10800, '1'),
(72, '-04', '11553764400', -14400, '0'),
(72, '-03', '11574936000', -10800, '1'),
(72, '-04', '11585818800', -14400, '0'),
(72, '-03', '11606385600', -10800, '1'),
(72, '-04', '11617268400', -14400, '0'),
(72, '-03', '11637835200', -10800, '1'),
(72, '-04', '11648718000', -14400, '0'),
(72, '-03', '11669284800', -10800, '1'),
(72, '-04', '11680167600', -14400, '0'),
(72, '-03', '11701339200', -10800, '1'),
(72, '-04', '11711617200', -14400, '0'),
(72, '-03', '11732788800', -10800, '1'),
(72, '-04', '11743066800', -14400, '0'),
(72, '-03', '11764238400', -10800, '1'),
(72, '-04', '11775121200', -14400, '0'),
(72, '-03', '11795688000', -10800, '1'),
(72, '-04', '11806570800', -14400, '0'),
(72, '-03', '11827137600', -10800, '1'),
(72, '-04', '11838020400', -14400, '0'),
(72, '-03', '11859192000', -10800, '1'),
(72, '-04', '11869470000', -14400, '0'),
(72, '-03', '11890641600', -10800, '1'),
(72, '-04', '11900919600', -14400, '0'),
(72, '-03', '11922091200', -10800, '1'),
(72, '-04', '11932369200', -14400, '0'),
(72, '-03', '11953540800', -10800, '1'),
(72, '-04', '11964423600', -14400, '0'),
(72, '-03', '11984990400', -10800, '1'),
(72, '-04', '11995873200', -14400, '0'),
(72, '-03', '12016440000', -10800, '1'),
(72, '-04', '12027322800', -14400, '0'),
(72, '-03', '12048494400', -10800, '1'),
(72, '-04', '12058772400', -14400, '0'),
(72, '-03', '12079944000', -10800, '1'),
(72, '-04', '12090222000', -14400, '0'),
(72, '-03', '12111393600', -10800, '1'),
(72, '-04', '12122276400', -14400, '0'),
(72, '-03', '12142843200', -10800, '1'),
(72, '-04', '12153726000', -14400, '0'),
(72, '-03', '12174292800', -10800, '1'),
(72, '-04', '12185175600', -14400, '0'),
(72, '-03', '12206347200', -10800, '1'),
(72, '-04', '12216625200', -14400, '0'),
(72, '-03', '12237796800', -10800, '1'),
(72, '-04', '12248074800', -14400, '0'),
(72, '-03', '12269246400', -10800, '1'),
(72, '-04', '12279524400', -14400, '0'),
(72, '-03', '12300696000', -10800, '1'),
(72, '-04', '12311578800', -14400, '0'),
(72, '-03', '12332145600', -10800, '1'),
(72, '-04', '12343028400', -14400, '0'),
(72, '-03', '12363595200', -10800, '1'),
(72, '-04', '12374478000', -14400, '0'),
(72, '-03', '12395649600', -10800, '1'),
(72, '-04', '12405927600', -14400, '0'),
(72, '-03', '12427099200', -10800, '1'),
(72, '-04', '12437377200', -14400, '0'),
(72, '-03', '12458548800', -10800, '1'),
(72, '-04', '12469431600', -14400, '0'),
(72, '-03', '12489998400', -10800, '1'),
(72, '-04', '12500881200', -14400, '0'),
(72, '-03', '12521448000', -10800, '1'),
(72, '-04', '12532330800', -14400, '0'),
(72, '-03', '12552897600', -10800, '1'),
(72, '-04', '12563780400', -14400, '0'),
(72, '-03', '12584952000', -10800, '1'),
(72, '-04', '12595230000', -14400, '0'),
(72, '-03', '12616401600', -10800, '1'),
(72, '-04', '12626679600', -14400, '0'),
(72, '-03', '12647851200', -10800, '1'),
(72, '-04', '12658734000', -14400, '0'),
(72, '-03', '12679300800', -10800, '1'),
(72, '-04', '12690183600', -14400, '0'),
(72, '-03', '12710750400', -10800, '1'),
(72, '-04', '12721633200', -14400, '0'),
(72, '-03', '12742804800', -10800, '1'),
(72, '-04', '12753082800', -14400, '0'),
(72, '-03', '12774254400', -10800, '1'),
(72, '-04', '12784532400', -14400, '0'),
(72, '-03', '12805704000', -10800, '1'),
(72, '-04', '12815982000', -14400, '0'),
(72, '-03', '12837153600', -10800, '1'),
(72, '-04', '12848036400', -14400, '0'),
(72, '-03', '12868603200', -10800, '1'),
(72, '-04', '12879486000', -14400, '0'),
(72, '-03', '12900052800', -10800, '1'),
(72, '-04', '12910935600', -14400, '0'),
(72, '-03', '12932107200', -10800, '1'),
(72, '-04', '12942385200', -14400, '0'),
(72, '-03', '12963556800', -10800, '1'),
(72, '-04', '12973834800', -14400, '0'),
(72, '-03', '12995006400', -10800, '1'),
(72, '-04', '13005889200', -14400, '0'),
(72, '-03', '13026456000', -10800, '1'),
(72, '-04', '13037338800', -14400, '0'),
(72, '-03', '13057905600', -10800, '1'),
(72, '-04', '13068788400', -14400, '0'),
(72, '-03', '13089960000', -10800, '1'),
(72, '-04', '13100238000', -14400, '0'),
(72, '-03', '13121409600', -10800, '1'),
(72, '-04', '13131687600', -14400, '0'),
(72, '-03', '13152859200', -10800, '1'),
(72, '-04', '13163137200', -14400, '0'),
(72, '-03', '13184308800', -10800, '1'),
(72, '-04', '13195191600', -14400, '0'),
(72, '-03', '13215758400', -10800, '1'),
(72, '-04', '13226641200', -14400, '0'),
(72, '-03', '13247208000', -10800, '1'),
(72, '-04', '13258090800', -14400, '0'),
(72, '-03', '13279262400', -10800, '1'),
(72, '-04', '13289540400', -14400, '0'),
(72, '-03', '13310712000', -10800, '1'),
(72, '-04', '13320990000', -14400, '0'),
(72, '-03', '13342161600', -10800, '1'),
(72, '-04', '13353044400', -14400, '0'),
(72, '-03', '13373611200', -10800, '1'),
(72, '-04', '13384494000', -14400, '0'),
(72, '-03', '13405060800', -10800, '1'),
(72, '-04', '13415943600', -14400, '0'),
(72, '-03', '13436510400', -10800, '1'),
(72, '-04', '13447393200', -14400, '0'),
(72, '-03', '13468564800', -10800, '1'),
(72, '-04', '13478842800', -14400, '0'),
(72, '-03', '13500014400', -10800, '1'),
(72, '-04', '13510292400', -14400, '0'),
(72, '-03', '13531464000', -10800, '1'),
(72, '-04', '13542346800', -14400, '0'),
(72, '-03', '13562913600', -10800, '1'),
(72, '-04', '13573796400', -14400, '0'),
(72, '-03', '13594363200', -10800, '1'),
(72, '-04', '13605246000', -14400, '0'),
(72, '-03', '13626417600', -10800, '1'),
(72, '-04', '13636695600', -14400, '0'),
(72, '-03', '13657867200', -10800, '1'),
(72, '-04', '13668145200', -14400, '0'),
(72, '-03', '13689316800', -10800, '1'),
(72, '-04', '13699594800', -14400, '0'),
(72, '-03', '13720766400', -10800, '1'),
(72, '-04', '13731649200', -14400, '0'),
(72, '-03', '13752216000', -10800, '1'),
(72, '-04', '13763098800', -14400, '0'),
(72, '-03', '13783665600', -10800, '1'),
(72, '-04', '13794548400', -14400, '0'),
(72, '-03', '13815720000', -10800, '1'),
(72, '-04', '13825998000', -14400, '0'),
(72, '-03', '13847169600', -10800, '1'),
(72, '-04', '13857447600', -14400, '0'),
(72, '-03', '13878619200', -10800, '1'),
(72, '-04', '13889502000', -14400, '0'),
(72, '-03', '13910068800', -10800, '1'),
(72, '-04', '13920951600', -14400, '0'),
(72, '-03', '13941518400', -10800, '1'),
(72, '-04', '13952401200', -14400, '0'),
(72, '-03', '13973572800', -10800, '1'),
(72, '-04', '13983850800', -14400, '0'),
(72, '-03', '14005022400', -10800, '1'),
(72, '-04', '14015300400', -14400, '0'),
(72, '-03', '14036472000', -10800, '1'),
(72, '-04', '14046750000', -14400, '0'),
(72, '-03', '14067921600', -10800, '1'),
(72, '-04', '14078804400', -14400, '0'),
(72, '-03', '14099371200', -10800, '1'),
(72, '-04', '14110254000', -14400, '0'),
(72, '-03', '14130820800', -10800, '1'),
(72, '-04', '14141703600', -14400, '0'),
(72, '-03', '14162875200', -10800, '1'),
(72, '-04', '14173153200', -14400, '0'),
(72, '-03', '14194324800', -10800, '1'),
(72, '-04', '14204602800', -14400, '0'),
(72, '-03', '14225774400', -10800, '1'),
(72, '-04', '14236657200', -14400, '0'),
(72, '-03', '14257224000', -10800, '1'),
(72, '-04', '14268106800', -14400, '0'),
(72, '-03', '14288673600', -10800, '1'),
(72, '-04', '14299556400', -14400, '0'),
(72, '-03', '14320123200', -10800, '1'),
(72, '-04', '14331006000', -14400, '0'),
(72, '-03', '14352177600', -10800, '1'),
(72, '-04', '14362455600', -14400, '0'),
(72, '-03', '14383627200', -10800, '1'),
(72, '-04', '14393905200', -14400, '0'),
(72, '-03', '14415076800', -10800, '1'),
(72, '-04', '14425959600', -14400, '0'),
(72, '-03', '14446526400', -10800, '1'),
(72, '-04', '14457409200', -14400, '0'),
(72, '-03', '14477976000', -10800, '1'),
(72, '-04', '14488858800', -14400, '0'),
(72, '-03', '14510030400', -10800, '1'),
(72, '-04', '14520308400', -14400, '0'),
(72, '-03', '14541480000', -10800, '1'),
(72, '-04', '14551758000', -14400, '0'),
(72, '-03', '14572929600', -10800, '1'),
(72, '-04', '14583207600', -14400, '0'),
(72, '-03', '14604379200', -10800, '1'),
(72, '-04', '14615262000', -14400, '0'),
(72, '-03', '14635828800', -10800, '1'),
(72, '-04', '14646711600', -14400, '0'),
(72, '-03', '14667278400', -10800, '1'),
(72, '-04', '14678161200', -14400, '0'),
(72, '-03', '14699332800', -10800, '1'),
(72, '-04', '14709610800', -14400, '0'),
(72, '-03', '14730782400', -10800, '1'),
(72, '-04', '14741060400', -14400, '0'),
(72, '-03', '14762232000', -10800, '1'),
(72, '-04', '14773114800', -14400, '0'),
(72, '-03', '14793681600', -10800, '1'),
(72, '-04', '14804564400', -14400, '0'),
(72, '-03', '14825131200', -10800, '1'),
(72, '-04', '14836014000', -14400, '0'),
(72, '-03', '14857185600', -10800, '1'),
(72, '-04', '14867463600', -14400, '0'),
(72, '-03', '14888635200', -10800, '1'),
(72, '-04', '14898913200', -14400, '0'),
(72, '-03', '14920084800', -10800, '1'),
(72, '-04', '14930362800', -14400, '0'),
(72, '-03', '14951534400', -10800, '1'),
(72, '-04', '14962417200', -14400, '0'),
(72, '-03', '14982984000', -10800, '1'),
(72, '-04', '14993866800', -14400, '0'),
(72, '-03', '15014433600', -10800, '1'),
(72, '-04', '15025316400', -14400, '0'),
(72, '-03', '15046488000', -10800, '1'),
(72, '-04', '15056766000', -14400, '0'),
(72, '-03', '15077937600', -10800, '1'),
(72, '-04', '15088215600', -14400, '0'),
(72, '-03', '15109387200', -10800, '1'),
(72, '-04', '15120270000', -14400, '0'),
(72, '-03', '15140836800', -10800, '1'),
(72, '-04', '15151719600', -14400, '0'),
(72, '-03', '15172286400', -10800, '1'),
(72, '-04', '15183169200', -14400, '0'),
(72, '-03', '15203736000', -10800, '1'),
(72, '-04', '15214618800', -14400, '0'),
(72, '-03', '15235790400', -10800, '1'),
(72, '-04', '15246068400', -14400, '0'),
(72, '-03', '15267240000', -10800, '1'),
(72, '-04', '15277518000', -14400, '0'),
(72, '-03', '15298689600', -10800, '1'),
(72, '-04', '15309572400', -14400, '0'),
(72, '-03', '15330139200', -10800, '1'),
(72, '-04', '15341022000', -14400, '0'),
(72, '-03', '15361588800', -10800, '1'),
(72, '-04', '15372471600', -14400, '0'),
(72, '-03', '15393643200', -10800, '1'),
(72, '-04', '15403921200', -14400, '0'),
(72, '-03', '15425092800', -10800, '1'),
(72, '-04', '15435370800', -14400, '0'),
(72, '-03', '15456542400', -10800, '1'),
(72, '-04', '15466820400', -14400, '0'),
(72, '-03', '15487992000', -10800, '1'),
(72, '-04', '15498874800', -14400, '0'),
(72, '-03', '15519441600', -10800, '1'),
(72, '-04', '15530324400', -14400, '0'),
(72, '-03', '15550891200', -10800, '1'),
(72, '-04', '15561774000', -14400, '0'),
(72, '-03', '15582945600', -10800, '1'),
(72, '-04', '15593223600', -14400, '0'),
(72, '-03', '15614395200', -10800, '1'),
(72, '-04', '15624673200', -14400, '0'),
(72, '-03', '15645844800', -10800, '1'),
(72, '-04', '15656727600', -14400, '0'),
(72, '-03', '15677294400', -10800, '1'),
(72, '-04', '15688177200', -14400, '0'),
(72, '-03', '15708744000', -10800, '1'),
(72, '-04', '15719626800', -14400, '0'),
(72, '-03', '15740798400', -10800, '1'),
(72, '-04', '15751076400', -14400, '0'),
(72, '-03', '15772248000', -10800, '1'),
(72, '-04', '15782526000', -14400, '0'),
(72, '-03', '15803697600', -10800, '1'),
(72, '-04', '15813975600', -14400, '0'),
(72, '-03', '15835147200', -10800, '1'),
(72, '-04', '15846030000', -14400, '0'),
(72, '-03', '15866596800', -10800, '1'),
(72, '-04', '15877479600', -14400, '0'),
(72, '-03', '15898046400', -10800, '1'),
(72, '-04', '15908929200', -14400, '0'),
(72, '-03', '15930100800', -10800, '1'),
(72, '-04', '15940378800', -14400, '0'),
(72, '-03', '15961550400', -10800, '1'),
(72, '-04', '15971828400', -14400, '0'),
(72, '-03', '15993000000', -10800, '1'),
(72, '-04', '16003882800', -14400, '0'),
(72, '-03', '16024449600', -10800, '1'),
(72, '-04', '16035332400', -14400, '0'),
(72, '-03', '16055899200', -10800, '1'),
(72, '-04', '16066782000', -14400, '0'),
(72, '-03', '16087348800', -10800, '1'),
(72, '-04', '16098231600', -14400, '0'),
(72, '-03', '16119403200', -10800, '1'),
(72, '-04', '16129681200', -14400, '0'),
(72, '-03', '16150852800', -10800, '1'),
(72, '-04', '16161130800', -14400, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(72, '-03', '16182302400', -10800, '1'),
(72, '-04', '16193185200', -14400, '0'),
(72, '-03', '16213752000', -10800, '1'),
(72, '-04', '16224634800', -14400, '0'),
(72, '-03', '16245201600', -10800, '1'),
(72, '-04', '16256084400', -14400, '0'),
(72, '-03', '16277256000', -10800, '1'),
(72, '-04', '16287534000', -14400, '0'),
(72, '-03', '16308705600', -10800, '1'),
(72, '-04', '16318983600', -14400, '0'),
(72, '-03', '16340155200', -10800, '1'),
(72, '-04', '16350433200', -14400, '0'),
(72, '-03', '16371604800', -10800, '1'),
(72, '-04', '16382487600', -14400, '0'),
(72, '-03', '16403054400', -10800, '1'),
(72, '-04', '16413937200', -14400, '0'),
(72, '-03', '16434504000', -10800, '1'),
(72, '-04', '16445386800', -14400, '0'),
(72, '-03', '16466558400', -10800, '1'),
(72, '-04', '16476836400', -14400, '0'),
(72, '-03', '16498008000', -10800, '1'),
(72, '-04', '16508286000', -14400, '0'),
(72, '-03', '16529457600', -10800, '1'),
(72, '-04', '16540340400', -14400, '0'),
(72, '-03', '16560907200', -10800, '1'),
(72, '-04', '16571790000', -14400, '0'),
(72, '-03', '16592356800', -10800, '1'),
(72, '-04', '16603239600', -14400, '0'),
(72, '-03', '16624411200', -10800, '1'),
(72, '-04', '16634689200', -14400, '0'),
(72, '-03', '16655860800', -10800, '1'),
(72, '-04', '16666138800', -14400, '0'),
(72, '-03', '16687310400', -10800, '1'),
(72, '-04', '16697588400', -14400, '0'),
(72, '-03', '16718760000', -10800, '1'),
(73, 'LMT', '-1767212473', -13128, '0'),
(73, '-04', '-1767212472', -14400, '0'),
(73, '-03', '-1206954000', -10800, '1'),
(73, '-04', '-1191358800', -14400, '0'),
(73, '-03', '-1175371200', -10800, '1'),
(73, '-04', '-1159822800', -14400, '0'),
(73, '-03', '-633816000', -10800, '1'),
(73, '-04', '-622065600', -14400, '0'),
(73, '-03', '-602280000', -10800, '1'),
(73, '-04', '-591829200', -14400, '0'),
(73, '-03', '-570744000', -10800, '1'),
(73, '-04', '-560206800', -14400, '0'),
(73, '-03', '-539121600', -10800, '1'),
(73, '-04', '-531349200', -14400, '0'),
(73, '-03', '-191361600', -10800, '1'),
(73, '-04', '-184194000', -14400, '0'),
(73, '-03', '-155160000', -10800, '1'),
(73, '-04', '-150066000', -14400, '0'),
(73, '-03', '-128894400', -10800, '1'),
(73, '-04', '-121122000', -14400, '0'),
(73, '-03', '-99950400', -10800, '1'),
(73, '-04', '-89586000', -14400, '0'),
(73, '-03', '-68414400', -10800, '1'),
(73, '-04', '-57963600', -14400, '0'),
(73, '-03', '499752000', -10800, '1'),
(73, '-04', '511239600', -14400, '0'),
(73, '-03', '530596800', -10800, '1'),
(73, '-04', '540270000', -14400, '0'),
(73, '-03', '562132800', -10800, '1'),
(73, '-04', '571201200', -14400, '0'),
(73, '-03', '1214280000', -10800, '0'),
(74, 'LMT', '-1767210265', -15336, '0'),
(74, '-04', '-1767210264', -14400, '0'),
(74, '-03', '-1206954000', -10800, '1'),
(74, '-04', '-1191358800', -14400, '0'),
(74, '-03', '-1175371200', -10800, '1'),
(74, '-04', '-1159822800', -14400, '0'),
(74, '-03', '-633816000', -10800, '1'),
(74, '-04', '-622065600', -14400, '0'),
(74, '-03', '-602280000', -10800, '1'),
(74, '-04', '-591829200', -14400, '0'),
(74, '-03', '-570744000', -10800, '1'),
(74, '-04', '-560206800', -14400, '0'),
(74, '-03', '-539121600', -10800, '1'),
(74, '-04', '-531349200', -14400, '0'),
(74, '-03', '-191361600', -10800, '1'),
(74, '-04', '-184194000', -14400, '0'),
(74, '-03', '-155160000', -10800, '1'),
(74, '-04', '-150066000', -14400, '0'),
(74, '-03', '-128894400', -10800, '1'),
(74, '-04', '-121122000', -14400, '0'),
(74, '-03', '-99950400', -10800, '1'),
(74, '-04', '-89586000', -14400, '0'),
(74, '-03', '-68414400', -10800, '1'),
(74, '-04', '-57963600', -14400, '0'),
(74, '-03', '499752000', -10800, '1'),
(74, '-04', '511239600', -14400, '0'),
(74, '-03', '530596800', -10800, '1'),
(74, '-04', '540270000', -14400, '0'),
(74, '-03', '562132800', -10800, '1'),
(74, '-04', '571201200', -14400, '0'),
(75, 'LMT', '-1767211041', -14560, '0'),
(75, '-04', '-1767211040', -14400, '0'),
(75, '-03', '-1206954000', -10800, '1'),
(75, '-04', '-1191358800', -14400, '0'),
(75, '-03', '-1175371200', -10800, '1'),
(75, '-04', '-1159822800', -14400, '0'),
(75, '-03', '-633816000', -10800, '1'),
(75, '-04', '-622065600', -14400, '0'),
(75, '-03', '-602280000', -10800, '1'),
(75, '-04', '-591829200', -14400, '0'),
(75, '-03', '-570744000', -10800, '1'),
(75, '-04', '-560206800', -14400, '0'),
(75, '-03', '-539121600', -10800, '1'),
(75, '-04', '-531349200', -14400, '0'),
(75, '-03', '-191361600', -10800, '1'),
(75, '-04', '-184194000', -14400, '0'),
(75, '-03', '-155160000', -10800, '1'),
(75, '-04', '-150066000', -14400, '0'),
(75, '-03', '-128894400', -10800, '1'),
(75, '-04', '-121122000', -14400, '0'),
(75, '-03', '-99950400', -10800, '1'),
(75, '-04', '-89586000', -14400, '0'),
(75, '-03', '-68414400', -10800, '1'),
(75, '-04', '-57963600', -14400, '0'),
(75, '-03', '499752000', -10800, '1'),
(75, '-04', '511239600', -14400, '0'),
(75, '-03', '530596800', -10800, '1'),
(75, '-04', '540270000', -14400, '0'),
(75, '-03', '562132800', -10800, '1'),
(75, '-04', '571201200', -14400, '0'),
(75, '-03', '938923200', -10800, '1'),
(75, '-04', '951620400', -14400, '0'),
(75, '-03', '970977600', -10800, '1'),
(75, '-04', '971578800', -14400, '0'),
(76, 'LMT', '-1767211197', -14404, '0'),
(76, '-04', '-1767211196', -14400, '0'),
(76, '-03', '-1206954000', -10800, '1'),
(76, '-04', '-1191358800', -14400, '0'),
(76, '-03', '-1175371200', -10800, '1'),
(76, '-04', '-1159822800', -14400, '0'),
(76, '-03', '-633816000', -10800, '1'),
(76, '-04', '-622065600', -14400, '0'),
(76, '-03', '-602280000', -10800, '1'),
(76, '-04', '-591829200', -14400, '0'),
(76, '-03', '-570744000', -10800, '1'),
(76, '-04', '-560206800', -14400, '0'),
(76, '-03', '-539121600', -10800, '1'),
(76, '-04', '-531349200', -14400, '0'),
(76, '-03', '-191361600', -10800, '1'),
(76, '-04', '-184194000', -14400, '0'),
(76, '-03', '-155160000', -10800, '1'),
(76, '-04', '-150066000', -14400, '0'),
(76, '-03', '-128894400', -10800, '1'),
(76, '-04', '-121122000', -14400, '0'),
(76, '-03', '-99950400', -10800, '1'),
(76, '-04', '-89586000', -14400, '0'),
(76, '-03', '-68414400', -10800, '1'),
(76, '-04', '-57963600', -14400, '0'),
(76, '-03', '499752000', -10800, '1'),
(76, '-04', '511239600', -14400, '0'),
(76, '-03', '530596800', -10800, '1'),
(76, '-04', '540270000', -14400, '0'),
(76, '-03', '562132800', -10800, '1'),
(76, '-04', '571201200', -14400, '0'),
(76, '-03', '750830400', -10800, '1'),
(76, '-04', '761713200', -14400, '0'),
(77, 'LMT', '-1767208833', -16768, '0'),
(77, '-05', '-1767208832', -18000, '0'),
(77, '-04', '-1206950400', -14400, '1'),
(77, '-05', '-1191355200', -18000, '0'),
(77, '-04', '-1175367600', -14400, '1'),
(77, '-05', '-1159819200', -18000, '0'),
(77, '-04', '-633812400', -14400, '1'),
(77, '-05', '-622062000', -18000, '0'),
(77, '-04', '-602276400', -14400, '1'),
(77, '-05', '-591825600', -18000, '0'),
(77, '-04', '-570740400', -14400, '1'),
(77, '-05', '-560203200', -18000, '0'),
(77, '-04', '-539118000', -14400, '1'),
(77, '-05', '-531345600', -18000, '0'),
(77, '-04', '-191358000', -14400, '1'),
(77, '-05', '-184190400', -18000, '0'),
(77, '-04', '-155156400', -14400, '1'),
(77, '-05', '-150062400', -18000, '0'),
(77, '-04', '-128890800', -14400, '1'),
(77, '-05', '-121118400', -18000, '0'),
(77, '-04', '-99946800', -14400, '1'),
(77, '-05', '-89582400', -18000, '0'),
(77, '-04', '-68410800', -14400, '1'),
(77, '-05', '-57960000', -18000, '0'),
(77, '-04', '499755600', -14400, '1'),
(77, '-05', '511243200', -18000, '0'),
(77, '-04', '530600400', -14400, '1'),
(77, '-05', '540273600', -18000, '0'),
(77, '-04', '562136400', -14400, '1'),
(77, '-05', '571204800', -18000, '0'),
(77, '-04', '750834000', -14400, '1'),
(77, '-05', '761716800', -18000, '0'),
(77, '-04', '1214283600', -14400, '0'),
(77, '-05', '1384056000', -18000, '0'),
(78, 'LMT', '-1767209329', -16272, '0'),
(78, '-05', '-1767209328', -18000, '0'),
(78, '-04', '-1206950400', -14400, '1'),
(78, '-05', '-1191355200', -18000, '0'),
(78, '-04', '-1175367600', -14400, '1'),
(78, '-05', '-1159819200', -18000, '0'),
(78, '-04', '-633812400', -14400, '1'),
(78, '-05', '-622062000', -18000, '0'),
(78, '-04', '-602276400', -14400, '1'),
(78, '-05', '-591825600', -18000, '0'),
(78, '-04', '-570740400', -14400, '1'),
(78, '-05', '-560203200', -18000, '0'),
(78, '-04', '-539118000', -14400, '1'),
(78, '-05', '-531345600', -18000, '0'),
(78, '-04', '-191358000', -14400, '1'),
(78, '-05', '-184190400', -18000, '0'),
(78, '-04', '-155156400', -14400, '1'),
(78, '-05', '-150062400', -18000, '0'),
(78, '-04', '-128890800', -14400, '1'),
(78, '-05', '-121118400', -18000, '0'),
(78, '-04', '-99946800', -14400, '1'),
(78, '-05', '-89582400', -18000, '0'),
(78, '-04', '-68410800', -14400, '1'),
(78, '-05', '-57960000', -18000, '0'),
(78, '-04', '499755600', -14400, '1'),
(78, '-05', '511243200', -18000, '0'),
(78, '-04', '530600400', -14400, '1'),
(78, '-05', '540273600', -18000, '0'),
(78, '-04', '562136400', -14400, '1'),
(78, '-05', '571204800', -18000, '0'),
(78, '-04', '1214283600', -14400, '0'),
(78, '-05', '1384056000', -18000, '0'),
(79, 'LMT', '-1825095031', -18570, '0'),
(79, 'EST', '-1825095030', -18000, '0'),
(79, 'EDT', '-179341200', -14400, '1'),
(79, 'EST', '-163620000', -18000, '0'),
(79, 'EDT', '-147891600', -14400, '1'),
(79, 'EST', '-131565600', -18000, '0'),
(79, 'EDT', '-116442000', -14400, '1'),
(79, 'EST', '-100116000', -18000, '0'),
(79, 'EDT', '-84387600', -14400, '1'),
(79, 'EST', '-68666400', -18000, '0'),
(79, 'EDT', '-52938000', -14400, '1'),
(79, 'EST', '-37216800', -18000, '0'),
(79, 'EDT', '-21488400', -14400, '1'),
(79, 'EST', '-5767200', -18000, '0'),
(79, 'EDT', '9961200', -14400, '1'),
(79, 'EST', '25682400', -18000, '0'),
(79, 'EDT', '41410800', -14400, '1'),
(79, 'EST', '57736800', -18000, '0'),
(79, 'EDT', '73465200', -14400, '1'),
(79, 'EST', '89186400', -18000, '0'),
(79, 'EDT', '104914800', -14400, '1'),
(79, 'EST', '120636000', -18000, '0'),
(79, 'EDT', '136364400', -14400, '1'),
(79, 'EST', '152085600', -18000, '0'),
(79, 'EDT', '167814000', -14400, '1'),
(79, 'EST', '183535200', -18000, '0'),
(79, 'EDT', '199263600', -14400, '1'),
(79, 'EST', '215589600', -18000, '0'),
(79, 'EDT', '230713200', -14400, '1'),
(79, 'EST', '247039200', -18000, '0'),
(79, 'EDT', '262767600', -14400, '1'),
(79, 'EST', '278488800', -18000, '0'),
(79, 'EDT', '294217200', -14400, '1'),
(79, 'EST', '309938400', -18000, '0'),
(79, 'EDT', '325666800', -14400, '1'),
(79, 'EST', '341388000', -18000, '0'),
(79, 'EDT', '357116400', -14400, '1'),
(79, 'EST', '372837600', -18000, '0'),
(79, 'EDT', '388566000', -14400, '1'),
(79, 'EST', '404892000', -18000, '0'),
(79, 'EDT', '420015600', -14400, '1'),
(79, 'EST', '436341600', -18000, '0'),
(79, 'EDT', '452070000', -14400, '1'),
(79, 'EST', '467791200', -18000, '0'),
(79, 'EDT', '483519600', -14400, '1'),
(79, 'EST', '499240800', -18000, '0'),
(79, 'EDT', '514969200', -14400, '1'),
(79, 'EST', '530690400', -18000, '0'),
(79, 'EDT', '544604400', -14400, '1'),
(79, 'EST', '562140000', -18000, '0'),
(79, 'EDT', '576054000', -14400, '1'),
(79, 'EST', '594194400', -18000, '0'),
(79, 'EDT', '607503600', -14400, '1'),
(79, 'EST', '625644000', -18000, '0'),
(79, 'EDT', '638953200', -14400, '1'),
(79, 'EST', '657093600', -18000, '0'),
(79, 'EDT', '671007600', -14400, '1'),
(79, 'EST', '688543200', -18000, '0'),
(79, 'EDT', '702457200', -14400, '1'),
(79, 'EST', '719992800', -18000, '0'),
(79, 'EDT', '733906800', -14400, '1'),
(79, 'EST', '752047200', -18000, '0'),
(79, 'EDT', '765356400', -14400, '1'),
(79, 'EST', '783496800', -18000, '0'),
(79, 'EDT', '796806000', -14400, '1'),
(79, 'EST', '814946400', -18000, '0'),
(79, 'EDT', '828860400', -14400, '1'),
(79, 'EST', '846396000', -18000, '0'),
(79, 'EDT', '860310000', -14400, '1'),
(79, 'EST', '877845600', -18000, '0'),
(79, 'EDT', '891759600', -14400, '1'),
(79, 'EST', '909295200', -18000, '0'),
(79, 'EDT', '923209200', -14400, '1'),
(79, 'EST', '941349600', -18000, '0'),
(79, 'EDT', '954658800', -14400, '1'),
(79, 'EST', '972799200', -18000, '0'),
(79, 'EDT', '986108400', -14400, '1'),
(79, 'EST', '1004248800', -18000, '0'),
(79, 'EDT', '1018162800', -14400, '1'),
(79, 'EST', '1035698400', -18000, '0'),
(79, 'EDT', '1049612400', -14400, '1'),
(79, 'EST', '1067148000', -18000, '0'),
(79, 'EDT', '1081062000', -14400, '1'),
(79, 'EST', '1099202400', -18000, '0'),
(79, 'EDT', '1112511600', -14400, '1'),
(79, 'EST', '1130652000', -18000, '0'),
(79, 'EDT', '1143961200', -14400, '1'),
(79, 'EST', '1162101600', -18000, '0'),
(79, 'EDT', '1173596400', -14400, '1'),
(79, 'EST', '1194156000', -18000, '0'),
(79, 'EDT', '1205046000', -14400, '1'),
(79, 'EST', '1225605600', -18000, '0'),
(79, 'EDT', '1236495600', -14400, '1'),
(79, 'EST', '1257055200', -18000, '0'),
(79, 'EDT', '1268550000', -14400, '1'),
(79, 'EST', '1289109600', -18000, '0'),
(79, 'EDT', '1299999600', -14400, '1'),
(79, 'EST', '1320559200', -18000, '0'),
(79, 'EDT', '1331449200', -14400, '1'),
(79, 'EST', '1352008800', -18000, '0'),
(79, 'EDT', '1362898800', -14400, '1'),
(79, 'EST', '1383458400', -18000, '0'),
(79, 'EDT', '1394348400', -14400, '1'),
(79, 'EST', '1414908000', -18000, '0'),
(79, 'EDT', '1425798000', -14400, '1'),
(79, 'EST', '1446357600', -18000, '0'),
(79, 'EDT', '1457852400', -14400, '1'),
(79, 'EST', '1478412000', -18000, '0'),
(79, 'EDT', '1489302000', -14400, '1'),
(79, 'EST', '1509861600', -18000, '0'),
(79, 'EDT', '1520751600', -14400, '1'),
(79, 'EST', '1541311200', -18000, '0'),
(79, 'EDT', '1552201200', -14400, '1'),
(79, 'EST', '1572760800', -18000, '0'),
(79, 'EDT', '1583650800', -14400, '1'),
(79, 'EST', '1604210400', -18000, '0'),
(79, 'EDT', '1615705200', -14400, '1'),
(79, 'EST', '1636264800', -18000, '0'),
(79, 'EDT', '1647154800', -14400, '1'),
(79, 'EST', '1667714400', -18000, '0'),
(79, 'EDT', '1678604400', -14400, '1'),
(79, 'EST', '1699164000', -18000, '0'),
(79, 'EDT', '1710054000', -14400, '1'),
(79, 'EST', '1730613600', -18000, '0'),
(79, 'EDT', '1741503600', -14400, '1'),
(79, 'EST', '1762063200', -18000, '0'),
(79, 'EDT', '1772953200', -14400, '1'),
(79, 'EST', '1793512800', -18000, '0'),
(79, 'EDT', '1805007600', -14400, '1'),
(79, 'EST', '1825567200', -18000, '0'),
(79, 'EDT', '1836457200', -14400, '1'),
(79, 'EST', '1857016800', -18000, '0'),
(79, 'EDT', '1867906800', -14400, '1'),
(79, 'EST', '1888466400', -18000, '0'),
(79, 'EDT', '1899356400', -14400, '1'),
(79, 'EST', '1919916000', -18000, '0'),
(79, 'EDT', '1930806000', -14400, '1'),
(79, 'EST', '1951365600', -18000, '0'),
(79, 'EDT', '1962860400', -14400, '1'),
(79, 'EST', '1983420000', -18000, '0'),
(79, 'EDT', '1994310000', -14400, '1'),
(79, 'EST', '2014869600', -18000, '0'),
(79, 'EDT', '2025759600', -14400, '1'),
(79, 'EST', '2046319200', -18000, '0'),
(79, 'EDT', '2057209200', -14400, '1'),
(79, 'EST', '2077768800', -18000, '0'),
(79, 'EDT', '2088658800', -14400, '1'),
(79, 'EST', '2109218400', -18000, '0'),
(79, 'EDT', '2120108400', -14400, '1'),
(79, 'EST', '2140668000', -18000, '0'),
(79, 'EDT', '2152162800', -14400, '1'),
(79, 'EST', '2172722400', -18000, '0'),
(79, 'EDT', '2183612400', -14400, '1'),
(79, 'EST', '2204172000', -18000, '0'),
(79, 'EDT', '2215062000', -14400, '1'),
(79, 'EST', '2235621600', -18000, '0'),
(79, 'EDT', '2246511600', -14400, '1'),
(79, 'EST', '2267071200', -18000, '0'),
(79, 'EDT', '2277961200', -14400, '1'),
(79, 'EST', '2298520800', -18000, '0'),
(79, 'EDT', '2309410800', -14400, '1'),
(79, 'EST', '2329970400', -18000, '0'),
(79, 'EDT', '2341465200', -14400, '1'),
(79, 'EST', '2362024800', -18000, '0'),
(79, 'EDT', '2372914800', -14400, '1'),
(79, 'EST', '2393474400', -18000, '0'),
(79, 'EDT', '2404364400', -14400, '1'),
(79, 'EST', '2424924000', -18000, '0'),
(79, 'EDT', '2435814000', -14400, '1'),
(79, 'EST', '2456373600', -18000, '0'),
(79, 'EDT', '2467263600', -14400, '1'),
(79, 'EST', '2487823200', -18000, '0'),
(79, 'EDT', '2499318000', -14400, '1'),
(79, 'EST', '2519877600', -18000, '0'),
(79, 'EDT', '2530767600', -14400, '1'),
(79, 'EST', '2551327200', -18000, '0'),
(79, 'EDT', '2562217200', -14400, '1'),
(79, 'EST', '2582776800', -18000, '0'),
(79, 'EDT', '2593666800', -14400, '1'),
(79, 'EST', '2614226400', -18000, '0'),
(79, 'EDT', '2625116400', -14400, '1'),
(79, 'EST', '2645676000', -18000, '0'),
(79, 'EDT', '2656566000', -14400, '1'),
(79, 'EST', '2677125600', -18000, '0'),
(79, 'EDT', '2688620400', -14400, '1'),
(79, 'EST', '2709180000', -18000, '0'),
(79, 'EDT', '2720070000', -14400, '1'),
(79, 'EST', '2740629600', -18000, '0'),
(79, 'EDT', '2751519600', -14400, '1'),
(79, 'EST', '2772079200', -18000, '0'),
(79, 'EDT', '2782969200', -14400, '1'),
(79, 'EST', '2803528800', -18000, '0'),
(79, 'EDT', '2814418800', -14400, '1'),
(79, 'EST', '2834978400', -18000, '0'),
(79, 'EDT', '2846473200', -14400, '1'),
(79, 'EST', '2867032800', -18000, '0'),
(79, 'EDT', '2877922800', -14400, '1'),
(79, 'EST', '2898482400', -18000, '0'),
(79, 'EDT', '2909372400', -14400, '1'),
(79, 'EST', '2929932000', -18000, '0'),
(79, 'EDT', '2940822000', -14400, '1'),
(79, 'EST', '2961381600', -18000, '0'),
(79, 'EDT', '2972271600', -14400, '1'),
(79, 'EST', '2992831200', -18000, '0'),
(79, 'EDT', '3003721200', -14400, '1'),
(79, 'EST', '3024280800', -18000, '0'),
(79, 'EDT', '3035775600', -14400, '1'),
(79, 'EST', '3056335200', -18000, '0'),
(79, 'EDT', '3067225200', -14400, '1'),
(79, 'EST', '3087784800', -18000, '0'),
(79, 'EDT', '3098674800', -14400, '1'),
(79, 'EST', '3119234400', -18000, '0'),
(79, 'EDT', '3130124400', -14400, '1'),
(79, 'EST', '3150684000', -18000, '0'),
(79, 'EDT', '3161574000', -14400, '1'),
(79, 'EST', '3182133600', -18000, '0'),
(79, 'EDT', '3193023600', -14400, '1'),
(79, 'EST', '3213583200', -18000, '0'),
(79, 'EDT', '3225078000', -14400, '1'),
(79, 'EST', '3245637600', -18000, '0'),
(79, 'EDT', '3256527600', -14400, '1'),
(79, 'EST', '3277087200', -18000, '0'),
(79, 'EDT', '3287977200', -14400, '1'),
(79, 'EST', '3308536800', -18000, '0'),
(79, 'EDT', '3319426800', -14400, '1'),
(79, 'EST', '3339986400', -18000, '0'),
(79, 'EDT', '3350876400', -14400, '1'),
(79, 'EST', '3371436000', -18000, '0'),
(79, 'EDT', '3382930800', -14400, '1'),
(79, 'EST', '3403490400', -18000, '0'),
(79, 'EDT', '3414380400', -14400, '1'),
(79, 'EST', '3434940000', -18000, '0'),
(79, 'EDT', '3445830000', -14400, '1'),
(79, 'EST', '3466389600', -18000, '0'),
(79, 'EDT', '3477279600', -14400, '1'),
(79, 'EST', '3497839200', -18000, '0'),
(79, 'EDT', '3508729200', -14400, '1'),
(79, 'EST', '3529288800', -18000, '0'),
(79, 'EDT', '3540178800', -14400, '1'),
(79, 'EST', '3560738400', -18000, '0'),
(79, 'EDT', '3572233200', -14400, '1'),
(79, 'EST', '3592792800', -18000, '0'),
(79, 'EDT', '3603682800', -14400, '1'),
(79, 'EST', '3624242400', -18000, '0'),
(79, 'EDT', '3635132400', -14400, '1'),
(79, 'EST', '3655692000', -18000, '0'),
(79, 'EDT', '3666582000', -14400, '1'),
(79, 'EST', '3687141600', -18000, '0'),
(79, 'EDT', '3698031600', -14400, '1'),
(79, 'EST', '3718591200', -18000, '0'),
(79, 'EDT', '3730086000', -14400, '1'),
(79, 'EST', '3750645600', -18000, '0'),
(79, 'EDT', '3761535600', -14400, '1'),
(79, 'EST', '3782095200', -18000, '0'),
(79, 'EDT', '3792985200', -14400, '1'),
(79, 'EST', '3813544800', -18000, '0'),
(79, 'EDT', '3824434800', -14400, '1'),
(79, 'EST', '3844994400', -18000, '0'),
(79, 'EDT', '3855884400', -14400, '1'),
(79, 'EST', '3876444000', -18000, '0'),
(79, 'EDT', '3887334000', -14400, '1'),
(79, 'EST', '3907893600', -18000, '0'),
(79, 'EDT', '3919388400', -14400, '1'),
(79, 'EST', '3939948000', -18000, '0'),
(79, 'EDT', '3950838000', -14400, '1'),
(79, 'EST', '3971397600', -18000, '0'),
(79, 'EDT', '3982287600', -14400, '1'),
(79, 'EST', '4002847200', -18000, '0'),
(79, 'EDT', '4013737200', -14400, '1'),
(79, 'EST', '4034296800', -18000, '0'),
(79, 'EDT', '4045186800', -14400, '1'),
(79, 'EST', '4065746400', -18000, '0'),
(79, 'EDT', '4076636400', -14400, '1'),
(79, 'EST', '4097196000', -18000, '0'),
(79, 'EDT', '4108690800', -14400, '1'),
(79, 'EST', '4129250400', -18000, '0'),
(79, 'EDT', '4140140400', -14400, '1'),
(79, 'EST', '4160700000', -18000, '0'),
(79, 'EDT', '4171590000', -14400, '1'),
(79, 'EST', '4192149600', -18000, '0'),
(79, 'EDT', '4203039600', -14400, '1'),
(79, 'EST', '4223599200', -18000, '0'),
(79, 'EDT', '4234489200', -14400, '1'),
(79, 'EST', '4255048800', -18000, '0'),
(79, 'EDT', '4265938800', -14400, '1'),
(79, 'EST', '4286498400', -18000, '0'),
(79, 'EDT', '4297993200', -14400, '1'),
(79, 'EST', '4318552800', -18000, '0'),
(79, 'EDT', '4329442800', -14400, '1'),
(79, 'EST', '4350002400', -18000, '0'),
(79, 'EDT', '4360892400', -14400, '1'),
(79, 'EST', '4381452000', -18000, '0'),
(79, 'EDT', '4392342000', -14400, '1'),
(79, 'EST', '4412901600', -18000, '0'),
(79, 'EDT', '4423791600', -14400, '1'),
(79, 'EST', '4444351200', -18000, '0'),
(79, 'EDT', '4455241200', -14400, '1'),
(79, 'EST', '4475800800', -18000, '0'),
(79, 'EDT', '4487295600', -14400, '1'),
(79, 'EST', '4507855200', -18000, '0'),
(79, 'EDT', '4518745200', -14400, '1'),
(79, 'EST', '4539304800', -18000, '0'),
(79, 'EDT', '4550194800', -14400, '1'),
(79, 'EST', '4570754400', -18000, '0'),
(79, 'EDT', '4581644400', -14400, '1'),
(79, 'EST', '4602204000', -18000, '0'),
(79, 'EDT', '4613094000', -14400, '1'),
(79, 'EST', '4633653600', -18000, '0'),
(79, 'EDT', '4645148400', -14400, '1'),
(79, 'EST', '4665708000', -18000, '0'),
(79, 'EDT', '4676598000', -14400, '1'),
(79, 'EST', '4697157600', -18000, '0'),
(79, 'EDT', '4708047600', -14400, '1'),
(79, 'EST', '4728607200', -18000, '0'),
(79, 'EDT', '4739497200', -14400, '1'),
(79, 'EST', '4760056800', -18000, '0'),
(79, 'EDT', '4770946800', -14400, '1'),
(79, 'EST', '4791506400', -18000, '0'),
(79, 'EDT', '4802396400', -14400, '1'),
(79, 'EST', '4822956000', -18000, '0'),
(79, 'EDT', '4834450800', -14400, '1'),
(79, 'EST', '4855010400', -18000, '0'),
(79, 'EDT', '4865900400', -14400, '1'),
(79, 'EST', '4886460000', -18000, '0'),
(79, 'EDT', '4897350000', -14400, '1'),
(79, 'EST', '4917909600', -18000, '0'),
(79, 'EDT', '4928799600', -14400, '1'),
(79, 'EST', '4949359200', -18000, '0'),
(79, 'EDT', '4960249200', -14400, '1'),
(79, 'EST', '4980808800', -18000, '0'),
(79, 'EDT', '4992303600', -14400, '1'),
(79, 'EST', '5012863200', -18000, '0'),
(79, 'EDT', '5023753200', -14400, '1'),
(79, 'EST', '5044312800', -18000, '0'),
(79, 'EDT', '5055202800', -14400, '1'),
(79, 'EST', '5075762400', -18000, '0'),
(79, 'EDT', '5086652400', -14400, '1'),
(79, 'EST', '5107212000', -18000, '0'),
(79, 'EDT', '5118102000', -14400, '1'),
(79, 'EST', '5138661600', -18000, '0'),
(79, 'EDT', '5149551600', -14400, '1'),
(79, 'EST', '5170111200', -18000, '0'),
(79, 'EDT', '5181606000', -14400, '1'),
(79, 'EST', '5202165600', -18000, '0'),
(79, 'EDT', '5213055600', -14400, '1'),
(79, 'EST', '5233615200', -18000, '0'),
(79, 'EDT', '5244505200', -14400, '1'),
(79, 'EST', '5265064800', -18000, '0'),
(79, 'EDT', '5275954800', -14400, '1'),
(79, 'EST', '5296514400', -18000, '0'),
(79, 'EDT', '5307404400', -14400, '1'),
(79, 'EST', '5327964000', -18000, '0'),
(79, 'EDT', '5338854000', -14400, '1'),
(79, 'EST', '5359413600', -18000, '0'),
(79, 'EDT', '5370908400', -14400, '1'),
(79, 'EST', '5391468000', -18000, '0'),
(79, 'EDT', '5402358000', -14400, '1'),
(79, 'EST', '5422917600', -18000, '0'),
(79, 'EDT', '5433807600', -14400, '1'),
(79, 'EST', '5454367200', -18000, '0'),
(79, 'EDT', '5465257200', -14400, '1'),
(79, 'EST', '5485816800', -18000, '0'),
(79, 'EDT', '5496706800', -14400, '1'),
(79, 'EST', '5517266400', -18000, '0'),
(79, 'EDT', '5528761200', -14400, '1'),
(79, 'EST', '5549320800', -18000, '0'),
(79, 'EDT', '5560210800', -14400, '1'),
(79, 'EST', '5580770400', -18000, '0'),
(79, 'EDT', '5591660400', -14400, '1'),
(79, 'EST', '5612220000', -18000, '0'),
(79, 'EDT', '5623110000', -14400, '1'),
(79, 'EST', '5643669600', -18000, '0'),
(79, 'EDT', '5654559600', -14400, '1'),
(79, 'EST', '5675119200', -18000, '0'),
(79, 'EDT', '5686009200', -14400, '1'),
(79, 'EST', '5706568800', -18000, '0'),
(79, 'EDT', '5718063600', -14400, '1'),
(79, 'EST', '5738623200', -18000, '0'),
(79, 'EDT', '5749513200', -14400, '1'),
(79, 'EST', '5770072800', -18000, '0'),
(79, 'EDT', '5780962800', -14400, '1'),
(79, 'EST', '5801522400', -18000, '0'),
(79, 'EDT', '5812412400', -14400, '1'),
(79, 'EST', '5832972000', -18000, '0'),
(79, 'EDT', '5843862000', -14400, '1'),
(79, 'EST', '5864421600', -18000, '0'),
(79, 'EDT', '5875916400', -14400, '1'),
(79, 'EST', '5896476000', -18000, '0'),
(79, 'EDT', '5907366000', -14400, '1'),
(79, 'EST', '5927925600', -18000, '0'),
(79, 'EDT', '5938815600', -14400, '1'),
(79, 'EST', '5959375200', -18000, '0'),
(79, 'EDT', '5970265200', -14400, '1'),
(79, 'EST', '5990824800', -18000, '0'),
(79, 'EDT', '6001714800', -14400, '1'),
(79, 'EST', '6022274400', -18000, '0'),
(79, 'EDT', '6033164400', -14400, '1'),
(79, 'EST', '6053724000', -18000, '0'),
(79, 'EDT', '6065218800', -14400, '1'),
(79, 'EST', '6085778400', -18000, '0'),
(79, 'EDT', '6096668400', -14400, '1'),
(79, 'EST', '6117228000', -18000, '0'),
(79, 'EDT', '6128118000', -14400, '1'),
(79, 'EST', '6148677600', -18000, '0'),
(79, 'EDT', '6159567600', -14400, '1'),
(79, 'EST', '6180127200', -18000, '0'),
(79, 'EDT', '6191017200', -14400, '1'),
(79, 'EST', '6211576800', -18000, '0'),
(79, 'EDT', '6222466800', -14400, '1'),
(79, 'EST', '6243026400', -18000, '0'),
(79, 'EDT', '6254521200', -14400, '1'),
(79, 'EST', '6275080800', -18000, '0'),
(79, 'EDT', '6285970800', -14400, '1'),
(79, 'EST', '6306530400', -18000, '0'),
(79, 'EDT', '6317420400', -14400, '1'),
(79, 'EST', '6337980000', -18000, '0'),
(79, 'EDT', '6348870000', -14400, '1'),
(79, 'EST', '6369429600', -18000, '0'),
(79, 'EDT', '6380319600', -14400, '1'),
(79, 'EST', '6400879200', -18000, '0'),
(79, 'EDT', '6412374000', -14400, '1'),
(79, 'EST', '6432933600', -18000, '0'),
(79, 'EDT', '6443823600', -14400, '1'),
(79, 'EST', '6464383200', -18000, '0'),
(79, 'EDT', '6475273200', -14400, '1'),
(79, 'EST', '6495832800', -18000, '0'),
(79, 'EDT', '6506722800', -14400, '1'),
(79, 'EST', '6527282400', -18000, '0'),
(79, 'EDT', '6538172400', -14400, '1'),
(79, 'EST', '6558732000', -18000, '0'),
(79, 'EDT', '6569622000', -14400, '1'),
(79, 'EST', '6590181600', -18000, '0'),
(79, 'EDT', '6601676400', -14400, '1'),
(79, 'EST', '6622236000', -18000, '0'),
(79, 'EDT', '6633126000', -14400, '1'),
(79, 'EST', '6653685600', -18000, '0'),
(79, 'EDT', '6664575600', -14400, '1'),
(79, 'EST', '6685135200', -18000, '0'),
(79, 'EDT', '6696025200', -14400, '1'),
(79, 'EST', '6716584800', -18000, '0'),
(79, 'EDT', '6727474800', -14400, '1'),
(79, 'EST', '6748034400', -18000, '0'),
(79, 'EDT', '6759529200', -14400, '1'),
(79, 'EST', '6780088800', -18000, '0'),
(79, 'EDT', '6790978800', -14400, '1'),
(79, 'EST', '6811538400', -18000, '0'),
(79, 'EDT', '6822428400', -14400, '1'),
(79, 'EST', '6842988000', -18000, '0'),
(79, 'EDT', '6853878000', -14400, '1'),
(79, 'EST', '6874437600', -18000, '0'),
(79, 'EDT', '6885327600', -14400, '1'),
(79, 'EST', '6905887200', -18000, '0'),
(79, 'EDT', '6916777200', -14400, '1'),
(79, 'EST', '6937336800', -18000, '0'),
(79, 'EDT', '6948831600', -14400, '1'),
(79, 'EST', '6969391200', -18000, '0'),
(79, 'EDT', '6980281200', -14400, '1'),
(79, 'EST', '7000840800', -18000, '0'),
(79, 'EDT', '7011730800', -14400, '1'),
(79, 'EST', '7032290400', -18000, '0'),
(79, 'EDT', '7043180400', -14400, '1'),
(79, 'EST', '7063740000', -18000, '0'),
(79, 'EDT', '7074630000', -14400, '1'),
(79, 'EST', '7095189600', -18000, '0'),
(79, 'EDT', '7106079600', -14400, '1'),
(79, 'EST', '7126639200', -18000, '0'),
(79, 'EDT', '7138134000', -14400, '1'),
(79, 'EST', '7158693600', -18000, '0'),
(79, 'EDT', '7169583600', -14400, '1'),
(79, 'EST', '7190143200', -18000, '0'),
(79, 'EDT', '7201033200', -14400, '1'),
(79, 'EST', '7221592800', -18000, '0'),
(79, 'EDT', '7232482800', -14400, '1'),
(79, 'EST', '7253042400', -18000, '0'),
(79, 'EDT', '7263932400', -14400, '1'),
(79, 'EST', '7284492000', -18000, '0'),
(79, 'EDT', '7295382000', -14400, '1'),
(79, 'EST', '7315941600', -18000, '0'),
(79, 'EDT', '7327436400', -14400, '1'),
(79, 'EST', '7347996000', -18000, '0'),
(79, 'EDT', '7358886000', -14400, '1'),
(79, 'EST', '7379445600', -18000, '0'),
(79, 'EDT', '7390335600', -14400, '1'),
(79, 'EST', '7410895200', -18000, '0'),
(79, 'EDT', '7421785200', -14400, '1'),
(79, 'EST', '7442344800', -18000, '0'),
(79, 'EDT', '7453234800', -14400, '1'),
(79, 'EST', '7473794400', -18000, '0'),
(79, 'EDT', '7484684400', -14400, '1'),
(79, 'EST', '7505244000', -18000, '0'),
(79, 'EDT', '7516738800', -14400, '1'),
(79, 'EST', '7537298400', -18000, '0'),
(79, 'EDT', '7548188400', -14400, '1'),
(79, 'EST', '7568748000', -18000, '0'),
(79, 'EDT', '7579638000', -14400, '1'),
(79, 'EST', '7600197600', -18000, '0'),
(79, 'EDT', '7611087600', -14400, '1'),
(79, 'EST', '7631647200', -18000, '0'),
(79, 'EDT', '7642537200', -14400, '1'),
(79, 'EST', '7663096800', -18000, '0'),
(79, 'EDT', '7674591600', -14400, '1'),
(79, 'EST', '7695151200', -18000, '0'),
(79, 'EDT', '7706041200', -14400, '1'),
(79, 'EST', '7726600800', -18000, '0'),
(79, 'EDT', '7737490800', -14400, '1'),
(79, 'EST', '7758050400', -18000, '0'),
(79, 'EDT', '7768940400', -14400, '1'),
(79, 'EST', '7789500000', -18000, '0'),
(79, 'EDT', '7800390000', -14400, '1'),
(79, 'EST', '7820949600', -18000, '0'),
(79, 'EDT', '7831839600', -14400, '1'),
(79, 'EST', '7852399200', -18000, '0'),
(79, 'EDT', '7863894000', -14400, '1'),
(79, 'EST', '7884453600', -18000, '0'),
(79, 'EDT', '7895343600', -14400, '1'),
(79, 'EST', '7915903200', -18000, '0'),
(79, 'EDT', '7926793200', -14400, '1'),
(79, 'EST', '7947352800', -18000, '0'),
(79, 'EDT', '7958242800', -14400, '1'),
(79, 'EST', '7978802400', -18000, '0'),
(79, 'EDT', '7989692400', -14400, '1'),
(79, 'EST', '8010252000', -18000, '0'),
(79, 'EDT', '8021746800', -14400, '1'),
(79, 'EST', '8042306400', -18000, '0'),
(79, 'EDT', '8053196400', -14400, '1'),
(79, 'EST', '8073756000', -18000, '0'),
(79, 'EDT', '8084646000', -14400, '1'),
(79, 'EST', '8105205600', -18000, '0'),
(79, 'EDT', '8116095600', -14400, '1'),
(79, 'EST', '8136655200', -18000, '0'),
(79, 'EDT', '8147545200', -14400, '1'),
(79, 'EST', '8168104800', -18000, '0'),
(79, 'EDT', '8178994800', -14400, '1'),
(79, 'EST', '8199554400', -18000, '0'),
(79, 'EDT', '8211049200', -14400, '1'),
(79, 'EST', '8231608800', -18000, '0'),
(79, 'EDT', '8242498800', -14400, '1'),
(79, 'EST', '8263058400', -18000, '0'),
(79, 'EDT', '8273948400', -14400, '1'),
(79, 'EST', '8294508000', -18000, '0'),
(79, 'EDT', '8305398000', -14400, '1'),
(79, 'EST', '8325957600', -18000, '0'),
(79, 'EDT', '8336847600', -14400, '1'),
(79, 'EST', '8357407200', -18000, '0'),
(79, 'EDT', '8368297200', -14400, '1'),
(79, 'EST', '8388856800', -18000, '0'),
(79, 'EDT', '8400351600', -14400, '1'),
(79, 'EST', '8420911200', -18000, '0'),
(79, 'EDT', '8431801200', -14400, '1'),
(79, 'EST', '8452360800', -18000, '0'),
(79, 'EDT', '8463250800', -14400, '1'),
(79, 'EST', '8483810400', -18000, '0'),
(79, 'EDT', '8494700400', -14400, '1'),
(79, 'EST', '8515260000', -18000, '0'),
(79, 'EDT', '8526150000', -14400, '1'),
(79, 'EST', '8546709600', -18000, '0'),
(79, 'EDT', '8558204400', -14400, '1'),
(79, 'EST', '8578764000', -18000, '0'),
(79, 'EDT', '8589654000', -14400, '1'),
(79, 'EST', '8610213600', -18000, '0'),
(79, 'EDT', '8621103600', -14400, '1'),
(79, 'EST', '8641663200', -18000, '0'),
(79, 'EDT', '8652553200', -14400, '1'),
(79, 'EST', '8673112800', -18000, '0'),
(79, 'EDT', '8684002800', -14400, '1'),
(79, 'EST', '8704562400', -18000, '0'),
(79, 'EDT', '8715452400', -14400, '1'),
(79, 'EST', '8736012000', -18000, '0'),
(79, 'EDT', '8747506800', -14400, '1'),
(79, 'EST', '8768066400', -18000, '0'),
(79, 'EDT', '8778956400', -14400, '1'),
(79, 'EST', '8799516000', -18000, '0'),
(79, 'EDT', '8810406000', -14400, '1'),
(79, 'EST', '8830965600', -18000, '0'),
(79, 'EDT', '8841855600', -14400, '1'),
(79, 'EST', '8862415200', -18000, '0'),
(79, 'EDT', '8873305200', -14400, '1'),
(79, 'EST', '8893864800', -18000, '0'),
(79, 'EDT', '8905359600', -14400, '1'),
(79, 'EST', '8925919200', -18000, '0'),
(79, 'EDT', '8936809200', -14400, '1'),
(79, 'EST', '8957368800', -18000, '0'),
(79, 'EDT', '8968258800', -14400, '1'),
(79, 'EST', '8988818400', -18000, '0'),
(79, 'EDT', '8999708400', -14400, '1'),
(79, 'EST', '9020268000', -18000, '0'),
(79, 'EDT', '9031158000', -14400, '1'),
(79, 'EST', '9051717600', -18000, '0'),
(79, 'EDT', '9062607600', -14400, '1'),
(79, 'EST', '9083167200', -18000, '0'),
(79, 'EDT', '9094662000', -14400, '1'),
(79, 'EST', '9115221600', -18000, '0'),
(79, 'EDT', '9126111600', -14400, '1'),
(79, 'EST', '9146671200', -18000, '0'),
(79, 'EDT', '9157561200', -14400, '1'),
(79, 'EST', '9178120800', -18000, '0'),
(79, 'EDT', '9189010800', -14400, '1'),
(79, 'EST', '9209570400', -18000, '0'),
(79, 'EDT', '9220460400', -14400, '1'),
(79, 'EST', '9241020000', -18000, '0'),
(79, 'EDT', '9251910000', -14400, '1'),
(79, 'EST', '9272469600', -18000, '0'),
(79, 'EDT', '9283964400', -14400, '1'),
(79, 'EST', '9304524000', -18000, '0'),
(79, 'EDT', '9315414000', -14400, '1'),
(79, 'EST', '9335973600', -18000, '0'),
(79, 'EDT', '9346863600', -14400, '1'),
(79, 'EST', '9367423200', -18000, '0'),
(79, 'EDT', '9378313200', -14400, '1'),
(79, 'EST', '9398872800', -18000, '0'),
(79, 'EDT', '9409762800', -14400, '1'),
(79, 'EST', '9430322400', -18000, '0'),
(79, 'EDT', '9441817200', -14400, '1'),
(79, 'EST', '9462376800', -18000, '0'),
(79, 'EDT', '9473266800', -14400, '1'),
(79, 'EST', '9493826400', -18000, '0'),
(79, 'EDT', '9504716400', -14400, '1'),
(79, 'EST', '9525276000', -18000, '0'),
(79, 'EDT', '9536166000', -14400, '1'),
(79, 'EST', '9556725600', -18000, '0'),
(79, 'EDT', '9567615600', -14400, '1'),
(79, 'EST', '9588175200', -18000, '0'),
(79, 'EDT', '9599065200', -14400, '1'),
(79, 'EST', '9619624800', -18000, '0'),
(79, 'EDT', '9631119600', -14400, '1'),
(79, 'EST', '9651679200', -18000, '0'),
(79, 'EDT', '9662569200', -14400, '1'),
(79, 'EST', '9683128800', -18000, '0'),
(79, 'EDT', '9694018800', -14400, '1'),
(79, 'EST', '9714578400', -18000, '0'),
(79, 'EDT', '9725468400', -14400, '1'),
(79, 'EST', '9746028000', -18000, '0'),
(79, 'EDT', '9756918000', -14400, '1'),
(79, 'EST', '9777477600', -18000, '0'),
(79, 'EDT', '9788972400', -14400, '1'),
(79, 'EST', '9809532000', -18000, '0'),
(79, 'EDT', '9820422000', -14400, '1'),
(79, 'EST', '9840981600', -18000, '0'),
(79, 'EDT', '9851871600', -14400, '1'),
(79, 'EST', '9872431200', -18000, '0'),
(79, 'EDT', '9883321200', -14400, '1'),
(79, 'EST', '9903880800', -18000, '0'),
(79, 'EDT', '9914770800', -14400, '1'),
(79, 'EST', '9935330400', -18000, '0'),
(79, 'EDT', '9946220400', -14400, '1'),
(79, 'EST', '9966780000', -18000, '0'),
(79, 'EDT', '9978274800', -14400, '1'),
(79, 'EST', '9998834400', -18000, '0'),
(79, 'EDT', '10009724400', -14400, '1'),
(79, 'EST', '10030284000', -18000, '0'),
(79, 'EDT', '10041174000', -14400, '1'),
(79, 'EST', '10061733600', -18000, '0'),
(79, 'EDT', '10072623600', -14400, '1'),
(79, 'EST', '10093183200', -18000, '0'),
(79, 'EDT', '10104073200', -14400, '1'),
(79, 'EST', '10124632800', -18000, '0'),
(79, 'EDT', '10135522800', -14400, '1'),
(79, 'EST', '10156082400', -18000, '0'),
(79, 'EDT', '10167577200', -14400, '1'),
(79, 'EST', '10188136800', -18000, '0'),
(79, 'EDT', '10199026800', -14400, '1'),
(79, 'EST', '10219586400', -18000, '0'),
(79, 'EDT', '10230476400', -14400, '1'),
(79, 'EST', '10251036000', -18000, '0'),
(79, 'EDT', '10261926000', -14400, '1'),
(79, 'EST', '10282485600', -18000, '0'),
(79, 'EDT', '10293375600', -14400, '1'),
(79, 'EST', '10313935200', -18000, '0'),
(79, 'EDT', '10325430000', -14400, '1'),
(79, 'EST', '10345989600', -18000, '0'),
(79, 'EDT', '10356879600', -14400, '1'),
(79, 'EST', '10377439200', -18000, '0'),
(79, 'EDT', '10388329200', -14400, '1'),
(79, 'EST', '10408888800', -18000, '0'),
(79, 'EDT', '10419778800', -14400, '1'),
(79, 'EST', '10440338400', -18000, '0'),
(79, 'EDT', '10451228400', -14400, '1'),
(79, 'EST', '10471788000', -18000, '0'),
(79, 'EDT', '10482678000', -14400, '1'),
(79, 'EST', '10503237600', -18000, '0'),
(79, 'EDT', '10514127600', -14400, '1'),
(79, 'EST', '10534687200', -18000, '0'),
(79, 'EDT', '10546182000', -14400, '1'),
(79, 'EST', '10566741600', -18000, '0'),
(79, 'EDT', '10577631600', -14400, '1'),
(79, 'EST', '10598191200', -18000, '0'),
(79, 'EDT', '10609081200', -14400, '1'),
(79, 'EST', '10629640800', -18000, '0'),
(79, 'EDT', '10640530800', -14400, '1'),
(79, 'EST', '10661090400', -18000, '0'),
(79, 'EDT', '10671980400', -14400, '1'),
(79, 'EST', '10692540000', -18000, '0'),
(79, 'EDT', '10704034800', -14400, '1'),
(79, 'EST', '10724594400', -18000, '0'),
(79, 'EDT', '10735484400', -14400, '1'),
(79, 'EST', '10756044000', -18000, '0'),
(79, 'EDT', '10766934000', -14400, '1'),
(79, 'EST', '10787493600', -18000, '0'),
(79, 'EDT', '10798383600', -14400, '1'),
(79, 'EST', '10818943200', -18000, '0'),
(79, 'EDT', '10829833200', -14400, '1'),
(79, 'EST', '10850392800', -18000, '0'),
(79, 'EDT', '10861282800', -14400, '1'),
(79, 'EST', '10881842400', -18000, '0'),
(79, 'EDT', '10893337200', -14400, '1'),
(79, 'EST', '10913896800', -18000, '0'),
(79, 'EDT', '10924786800', -14400, '1'),
(79, 'EST', '10945346400', -18000, '0'),
(79, 'EDT', '10956236400', -14400, '1'),
(79, 'EST', '10976796000', -18000, '0'),
(79, 'EDT', '10987686000', -14400, '1'),
(79, 'EST', '11008245600', -18000, '0'),
(79, 'EDT', '11019135600', -14400, '1'),
(79, 'EST', '11039695200', -18000, '0'),
(79, 'EDT', '11051190000', -14400, '1'),
(79, 'EST', '11071749600', -18000, '0'),
(79, 'EDT', '11082639600', -14400, '1'),
(79, 'EST', '11103199200', -18000, '0'),
(79, 'EDT', '11114089200', -14400, '1'),
(79, 'EST', '11134648800', -18000, '0'),
(79, 'EDT', '11145538800', -14400, '1'),
(79, 'EST', '11166098400', -18000, '0'),
(79, 'EDT', '11176988400', -14400, '1'),
(79, 'EST', '11197548000', -18000, '0'),
(79, 'EDT', '11208438000', -14400, '1'),
(79, 'EST', '11228997600', -18000, '0'),
(79, 'EDT', '11240492400', -14400, '1'),
(79, 'EST', '11261052000', -18000, '0'),
(79, 'EDT', '11271942000', -14400, '1'),
(79, 'EST', '11292501600', -18000, '0'),
(79, 'EDT', '11303391600', -14400, '1'),
(79, 'EST', '11323951200', -18000, '0'),
(79, 'EDT', '11334841200', -14400, '1'),
(79, 'EST', '11355400800', -18000, '0'),
(79, 'EDT', '11366290800', -14400, '1'),
(79, 'EST', '11386850400', -18000, '0'),
(79, 'EDT', '11397740400', -14400, '1'),
(79, 'EST', '11418300000', -18000, '0'),
(79, 'EDT', '11429794800', -14400, '1'),
(79, 'EST', '11450354400', -18000, '0'),
(79, 'EDT', '11461244400', -14400, '1'),
(79, 'EST', '11481804000', -18000, '0'),
(79, 'EDT', '11492694000', -14400, '1'),
(79, 'EST', '11513253600', -18000, '0'),
(79, 'EDT', '11524143600', -14400, '1'),
(79, 'EST', '11544703200', -18000, '0'),
(79, 'EDT', '11555593200', -14400, '1'),
(79, 'EST', '11576152800', -18000, '0'),
(79, 'EDT', '11587647600', -14400, '1'),
(79, 'EST', '11608207200', -18000, '0'),
(79, 'EDT', '11619097200', -14400, '1'),
(79, 'EST', '11639656800', -18000, '0'),
(79, 'EDT', '11650546800', -14400, '1'),
(79, 'EST', '11671106400', -18000, '0'),
(79, 'EDT', '11681996400', -14400, '1'),
(79, 'EST', '11702556000', -18000, '0'),
(79, 'EDT', '11713446000', -14400, '1'),
(79, 'EST', '11734005600', -18000, '0'),
(79, 'EDT', '11744895600', -14400, '1'),
(79, 'EST', '11765455200', -18000, '0'),
(79, 'EDT', '11776950000', -14400, '1'),
(79, 'EST', '11797509600', -18000, '0'),
(79, 'EDT', '11808399600', -14400, '1'),
(79, 'EST', '11828959200', -18000, '0'),
(79, 'EDT', '11839849200', -14400, '1'),
(79, 'EST', '11860408800', -18000, '0'),
(79, 'EDT', '11871298800', -14400, '1'),
(79, 'EST', '11891858400', -18000, '0'),
(79, 'EDT', '11902748400', -14400, '1'),
(79, 'EST', '11923308000', -18000, '0'),
(79, 'EDT', '11934802800', -14400, '1'),
(79, 'EST', '11955362400', -18000, '0'),
(79, 'EDT', '11966252400', -14400, '1'),
(79, 'EST', '11986812000', -18000, '0'),
(79, 'EDT', '11997702000', -14400, '1'),
(79, 'EST', '12018261600', -18000, '0'),
(79, 'EDT', '12029151600', -14400, '1'),
(79, 'EST', '12049711200', -18000, '0'),
(79, 'EDT', '12060601200', -14400, '1'),
(79, 'EST', '12081160800', -18000, '0'),
(79, 'EDT', '12092050800', -14400, '1'),
(79, 'EST', '12112610400', -18000, '0'),
(79, 'EDT', '12124105200', -14400, '1'),
(79, 'EST', '12144664800', -18000, '0'),
(79, 'EDT', '12155554800', -14400, '1'),
(79, 'EST', '12176114400', -18000, '0'),
(79, 'EDT', '12187004400', -14400, '1'),
(79, 'EST', '12207564000', -18000, '0'),
(79, 'EDT', '12218454000', -14400, '1'),
(79, 'EST', '12239013600', -18000, '0'),
(79, 'EDT', '12249903600', -14400, '1'),
(79, 'EST', '12270463200', -18000, '0'),
(79, 'EDT', '12281353200', -14400, '1'),
(79, 'EST', '12301912800', -18000, '0'),
(79, 'EDT', '12313407600', -14400, '1'),
(79, 'EST', '12333967200', -18000, '0'),
(79, 'EDT', '12344857200', -14400, '1'),
(79, 'EST', '12365416800', -18000, '0'),
(79, 'EDT', '12376306800', -14400, '1'),
(79, 'EST', '12396866400', -18000, '0'),
(79, 'EDT', '12407756400', -14400, '1'),
(79, 'EST', '12428316000', -18000, '0'),
(79, 'EDT', '12439206000', -14400, '1'),
(79, 'EST', '12459765600', -18000, '0'),
(79, 'EDT', '12471260400', -14400, '1'),
(79, 'EST', '12491820000', -18000, '0'),
(79, 'EDT', '12502710000', -14400, '1'),
(79, 'EST', '12523269600', -18000, '0'),
(79, 'EDT', '12534159600', -14400, '1'),
(79, 'EST', '12554719200', -18000, '0'),
(79, 'EDT', '12565609200', -14400, '1'),
(79, 'EST', '12586168800', -18000, '0'),
(79, 'EDT', '12597058800', -14400, '1'),
(79, 'EST', '12617618400', -18000, '0'),
(79, 'EDT', '12628508400', -14400, '1'),
(79, 'EST', '12649068000', -18000, '0'),
(79, 'EDT', '12660562800', -14400, '1'),
(79, 'EST', '12681122400', -18000, '0'),
(79, 'EDT', '12692012400', -14400, '1'),
(79, 'EST', '12712572000', -18000, '0'),
(79, 'EDT', '12723462000', -14400, '1'),
(79, 'EST', '12744021600', -18000, '0'),
(79, 'EDT', '12754911600', -14400, '1'),
(79, 'EST', '12775471200', -18000, '0'),
(79, 'EDT', '12786361200', -14400, '1'),
(79, 'EST', '12806920800', -18000, '0'),
(79, 'EDT', '12818415600', -14400, '1'),
(79, 'EST', '12838975200', -18000, '0'),
(79, 'EDT', '12849865200', -14400, '1'),
(79, 'EST', '12870424800', -18000, '0'),
(79, 'EDT', '12881314800', -14400, '1'),
(79, 'EST', '12901874400', -18000, '0'),
(79, 'EDT', '12912764400', -14400, '1'),
(79, 'EST', '12933324000', -18000, '0'),
(79, 'EDT', '12944214000', -14400, '1'),
(79, 'EST', '12964773600', -18000, '0'),
(79, 'EDT', '12975663600', -14400, '1'),
(79, 'EST', '12996223200', -18000, '0'),
(79, 'EDT', '13007718000', -14400, '1'),
(79, 'EST', '13028277600', -18000, '0'),
(79, 'EDT', '13039167600', -14400, '1'),
(79, 'EST', '13059727200', -18000, '0'),
(79, 'EDT', '13070617200', -14400, '1'),
(79, 'EST', '13091176800', -18000, '0'),
(79, 'EDT', '13102066800', -14400, '1'),
(79, 'EST', '13122626400', -18000, '0'),
(79, 'EDT', '13133516400', -14400, '1'),
(79, 'EST', '13154076000', -18000, '0'),
(79, 'EDT', '13164966000', -14400, '1'),
(79, 'EST', '13185525600', -18000, '0'),
(79, 'EDT', '13197020400', -14400, '1'),
(79, 'EST', '13217580000', -18000, '0'),
(79, 'EDT', '13228470000', -14400, '1'),
(79, 'EST', '13249029600', -18000, '0'),
(79, 'EDT', '13259919600', -14400, '1'),
(79, 'EST', '13280479200', -18000, '0'),
(79, 'EDT', '13291369200', -14400, '1'),
(79, 'EST', '13311928800', -18000, '0'),
(79, 'EDT', '13322818800', -14400, '1'),
(79, 'EST', '13343378400', -18000, '0'),
(79, 'EDT', '13354873200', -14400, '1'),
(79, 'EST', '13375432800', -18000, '0'),
(79, 'EDT', '13386322800', -14400, '1'),
(79, 'EST', '13406882400', -18000, '0'),
(79, 'EDT', '13417772400', -14400, '1'),
(79, 'EST', '13438332000', -18000, '0'),
(79, 'EDT', '13449222000', -14400, '1'),
(79, 'EST', '13469781600', -18000, '0'),
(79, 'EDT', '13480671600', -14400, '1'),
(79, 'EST', '13501231200', -18000, '0'),
(79, 'EDT', '13512121200', -14400, '1'),
(79, 'EST', '13532680800', -18000, '0'),
(79, 'EDT', '13544175600', -14400, '1'),
(79, 'EST', '13564735200', -18000, '0'),
(79, 'EDT', '13575625200', -14400, '1'),
(79, 'EST', '13596184800', -18000, '0'),
(79, 'EDT', '13607074800', -14400, '1'),
(79, 'EST', '13627634400', -18000, '0'),
(79, 'EDT', '13638524400', -14400, '1'),
(79, 'EST', '13659084000', -18000, '0'),
(79, 'EDT', '13669974000', -14400, '1'),
(79, 'EST', '13690533600', -18000, '0'),
(79, 'EDT', '13702028400', -14400, '1'),
(79, 'EST', '13722588000', -18000, '0'),
(79, 'EDT', '13733478000', -14400, '1'),
(79, 'EST', '13754037600', -18000, '0'),
(79, 'EDT', '13764927600', -14400, '1'),
(79, 'EST', '13785487200', -18000, '0'),
(79, 'EDT', '13796377200', -14400, '1'),
(79, 'EST', '13816936800', -18000, '0'),
(79, 'EDT', '13827826800', -14400, '1'),
(79, 'EST', '13848386400', -18000, '0'),
(79, 'EDT', '13859276400', -14400, '1'),
(79, 'EST', '13879836000', -18000, '0'),
(79, 'EDT', '13891330800', -14400, '1'),
(79, 'EST', '13911890400', -18000, '0'),
(79, 'EDT', '13922780400', -14400, '1'),
(79, 'EST', '13943340000', -18000, '0'),
(79, 'EDT', '13954230000', -14400, '1'),
(79, 'EST', '13974789600', -18000, '0'),
(79, 'EDT', '13985679600', -14400, '1'),
(79, 'EST', '14006239200', -18000, '0'),
(79, 'EDT', '14017129200', -14400, '1'),
(79, 'EST', '14037688800', -18000, '0'),
(79, 'EDT', '14048578800', -14400, '1'),
(79, 'EST', '14069138400', -18000, '0'),
(79, 'EDT', '14080633200', -14400, '1'),
(79, 'EST', '14101192800', -18000, '0'),
(79, 'EDT', '14112082800', -14400, '1'),
(79, 'EST', '14132642400', -18000, '0'),
(79, 'EDT', '14143532400', -14400, '1'),
(79, 'EST', '14164092000', -18000, '0'),
(79, 'EDT', '14174982000', -14400, '1'),
(79, 'EST', '14195541600', -18000, '0'),
(79, 'EDT', '14206431600', -14400, '1'),
(79, 'EST', '14226991200', -18000, '0'),
(79, 'EDT', '14238486000', -14400, '1'),
(79, 'EST', '14259045600', -18000, '0'),
(79, 'EDT', '14269935600', -14400, '1'),
(79, 'EST', '14290495200', -18000, '0'),
(79, 'EDT', '14301385200', -14400, '1'),
(79, 'EST', '14321944800', -18000, '0'),
(79, 'EDT', '14332834800', -14400, '1'),
(79, 'EST', '14353394400', -18000, '0'),
(79, 'EDT', '14364284400', -14400, '1'),
(79, 'EST', '14384844000', -18000, '0'),
(79, 'EDT', '14395734000', -14400, '1'),
(79, 'EST', '14416293600', -18000, '0'),
(79, 'EDT', '14427788400', -14400, '1'),
(79, 'EST', '14448348000', -18000, '0'),
(79, 'EDT', '14459238000', -14400, '1'),
(79, 'EST', '14479797600', -18000, '0'),
(79, 'EDT', '14490687600', -14400, '1'),
(79, 'EST', '14511247200', -18000, '0'),
(79, 'EDT', '14522137200', -14400, '1'),
(79, 'EST', '14542696800', -18000, '0'),
(79, 'EDT', '14553586800', -14400, '1'),
(79, 'EST', '14574146400', -18000, '0'),
(79, 'EDT', '14585641200', -14400, '1'),
(79, 'EST', '14606200800', -18000, '0'),
(79, 'EDT', '14617090800', -14400, '1'),
(79, 'EST', '14637650400', -18000, '0'),
(79, 'EDT', '14648540400', -14400, '1'),
(79, 'EST', '14669100000', -18000, '0'),
(79, 'EDT', '14679990000', -14400, '1'),
(79, 'EST', '14700549600', -18000, '0'),
(79, 'EDT', '14711439600', -14400, '1'),
(79, 'EST', '14731999200', -18000, '0'),
(79, 'EDT', '14742889200', -14400, '1'),
(79, 'EST', '14763448800', -18000, '0'),
(79, 'EDT', '14774943600', -14400, '1'),
(79, 'EST', '14795503200', -18000, '0'),
(79, 'EDT', '14806393200', -14400, '1'),
(79, 'EST', '14826952800', -18000, '0'),
(79, 'EDT', '14837842800', -14400, '1'),
(79, 'EST', '14858402400', -18000, '0'),
(79, 'EDT', '14869292400', -14400, '1'),
(79, 'EST', '14889852000', -18000, '0'),
(79, 'EDT', '14900742000', -14400, '1'),
(79, 'EST', '14921301600', -18000, '0'),
(79, 'EDT', '14932191600', -14400, '1'),
(79, 'EST', '14952751200', -18000, '0'),
(79, 'EDT', '14964246000', -14400, '1'),
(79, 'EST', '14984805600', -18000, '0'),
(79, 'EDT', '14995695600', -14400, '1'),
(79, 'EST', '15016255200', -18000, '0'),
(79, 'EDT', '15027145200', -14400, '1'),
(79, 'EST', '15047704800', -18000, '0'),
(79, 'EDT', '15058594800', -14400, '1'),
(79, 'EST', '15079154400', -18000, '0'),
(79, 'EDT', '15090044400', -14400, '1'),
(79, 'EST', '15110604000', -18000, '0'),
(79, 'EDT', '15122098800', -14400, '1'),
(79, 'EST', '15142658400', -18000, '0'),
(79, 'EDT', '15153548400', -14400, '1'),
(79, 'EST', '15174108000', -18000, '0'),
(79, 'EDT', '15184998000', -14400, '1'),
(79, 'EST', '15205557600', -18000, '0'),
(79, 'EDT', '15216447600', -14400, '1'),
(79, 'EST', '15237007200', -18000, '0'),
(79, 'EDT', '15247897200', -14400, '1'),
(79, 'EST', '15268456800', -18000, '0'),
(79, 'EDT', '15279346800', -14400, '1'),
(79, 'EST', '15299906400', -18000, '0'),
(79, 'EDT', '15311401200', -14400, '1'),
(79, 'EST', '15331960800', -18000, '0'),
(79, 'EDT', '15342850800', -14400, '1'),
(79, 'EST', '15363410400', -18000, '0'),
(79, 'EDT', '15374300400', -14400, '1'),
(79, 'EST', '15394860000', -18000, '0'),
(79, 'EDT', '15405750000', -14400, '1'),
(79, 'EST', '15426309600', -18000, '0'),
(79, 'EDT', '15437199600', -14400, '1'),
(79, 'EST', '15457759200', -18000, '0'),
(79, 'EDT', '15469254000', -14400, '1'),
(79, 'EST', '15489813600', -18000, '0'),
(79, 'EDT', '15500703600', -14400, '1'),
(79, 'EST', '15521263200', -18000, '0'),
(79, 'EDT', '15532153200', -14400, '1'),
(79, 'EST', '15552712800', -18000, '0'),
(79, 'EDT', '15563602800', -14400, '1'),
(79, 'EST', '15584162400', -18000, '0'),
(79, 'EDT', '15595052400', -14400, '1'),
(79, 'EST', '15615612000', -18000, '0'),
(79, 'EDT', '15626502000', -14400, '1'),
(79, 'EST', '15647061600', -18000, '0'),
(79, 'EDT', '15658556400', -14400, '1'),
(79, 'EST', '15679116000', -18000, '0'),
(79, 'EDT', '15690006000', -14400, '1'),
(79, 'EST', '15710565600', -18000, '0'),
(79, 'EDT', '15721455600', -14400, '1'),
(79, 'EST', '15742015200', -18000, '0'),
(79, 'EDT', '15752905200', -14400, '1'),
(79, 'EST', '15773464800', -18000, '0'),
(79, 'EDT', '15784354800', -14400, '1'),
(79, 'EST', '15804914400', -18000, '0'),
(79, 'EDT', '15815804400', -14400, '1'),
(79, 'EST', '15836364000', -18000, '0'),
(79, 'EDT', '15847858800', -14400, '1'),
(79, 'EST', '15868418400', -18000, '0'),
(79, 'EDT', '15879308400', -14400, '1'),
(79, 'EST', '15899868000', -18000, '0'),
(79, 'EDT', '15910758000', -14400, '1'),
(79, 'EST', '15931317600', -18000, '0'),
(79, 'EDT', '15942207600', -14400, '1'),
(79, 'EST', '15962767200', -18000, '0'),
(79, 'EDT', '15973657200', -14400, '1'),
(79, 'EST', '15994216800', -18000, '0'),
(79, 'EDT', '16005711600', -14400, '1'),
(79, 'EST', '16026271200', -18000, '0'),
(79, 'EDT', '16037161200', -14400, '1'),
(79, 'EST', '16057720800', -18000, '0'),
(79, 'EDT', '16068610800', -14400, '1'),
(79, 'EST', '16089170400', -18000, '0'),
(79, 'EDT', '16100060400', -14400, '1'),
(79, 'EST', '16120620000', -18000, '0'),
(79, 'EDT', '16131510000', -14400, '1'),
(79, 'EST', '16152069600', -18000, '0'),
(79, 'EDT', '16162959600', -14400, '1'),
(79, 'EST', '16183519200', -18000, '0'),
(79, 'EDT', '16195014000', -14400, '1'),
(79, 'EST', '16215573600', -18000, '0'),
(79, 'EDT', '16226463600', -14400, '1'),
(79, 'EST', '16247023200', -18000, '0'),
(79, 'EDT', '16257913200', -14400, '1'),
(79, 'EST', '16278472800', -18000, '0'),
(79, 'EDT', '16289362800', -14400, '1'),
(79, 'EST', '16309922400', -18000, '0'),
(79, 'EDT', '16320812400', -14400, '1'),
(79, 'EST', '16341372000', -18000, '0'),
(79, 'EDT', '16352866800', -14400, '1'),
(79, 'EST', '16373426400', -18000, '0'),
(79, 'EDT', '16384316400', -14400, '1'),
(79, 'EST', '16404876000', -18000, '0'),
(79, 'EDT', '16415766000', -14400, '1'),
(79, 'EST', '16436325600', -18000, '0'),
(79, 'EDT', '16447215600', -14400, '1'),
(79, 'EST', '16467775200', -18000, '0'),
(79, 'EDT', '16478665200', -14400, '1'),
(79, 'EST', '16499224800', -18000, '0'),
(79, 'EDT', '16510114800', -14400, '1'),
(79, 'EST', '16530674400', -18000, '0'),
(79, 'EDT', '16542169200', -14400, '1'),
(79, 'EST', '16562728800', -18000, '0'),
(79, 'EDT', '16573618800', -14400, '1'),
(79, 'EST', '16594178400', -18000, '0'),
(79, 'EDT', '16605068400', -14400, '1'),
(79, 'EST', '16625628000', -18000, '0'),
(79, 'EDT', '16636518000', -14400, '1'),
(79, 'EST', '16657077600', -18000, '0'),
(79, 'EDT', '16667967600', -14400, '1'),
(79, 'EST', '16688527200', -18000, '0'),
(79, 'EDT', '16699417200', -14400, '1'),
(79, 'EST', '16719976800', -18000, '0'),
(80, 'LMT', '-706341517', 21516, '0'),
(80, '+0530', '-706341516', 19800, '0');
INSERT INTO `timezone` (`zone_id`, `abbreviation`, `time_start`, `gmt_offset`, `dst`) VALUES
(80, '+06', '560025000', 21600, '0'),
(81, 'LMT', '-2109291021', 7820, '0'),
(81, 'CAT', '-2109291020', 7200, '0'),
(82, 'LMT', '-2840147417', 6616, '0'),
(82, 'MMT', '-2840147416', 6600, '0'),
(82, 'EET', '-1441158600', 7200, '0'),
(82, 'MSK', '-1247536800', 10800, '0'),
(82, 'CEST', '-899780400', 7200, '1'),
(82, 'CET', '-857257200', 3600, '0'),
(82, 'CEST', '-844556400', 7200, '1'),
(82, 'CET', '-828226800', 3600, '0'),
(82, 'CEST', '-812502000', 7200, '1'),
(82, 'MSK', '-804650400', 10800, '0'),
(82, 'MSD', '354920400', 14400, '1'),
(82, 'MSK', '370728000', 10800, '0'),
(82, 'MSD', '386456400', 14400, '1'),
(82, 'MSK', '402264000', 10800, '0'),
(82, 'MSD', '417992400', 14400, '1'),
(82, 'MSK', '433800000', 10800, '0'),
(82, 'MSD', '449614800', 14400, '1'),
(82, 'MSK', '465346800', 10800, '0'),
(82, 'MSD', '481071600', 14400, '1'),
(82, 'MSK', '496796400', 10800, '0'),
(82, 'MSD', '512521200', 14400, '1'),
(82, 'MSK', '528246000', 10800, '0'),
(82, 'MSD', '543970800', 14400, '1'),
(82, 'MSK', '559695600', 10800, '0'),
(82, 'MSD', '575420400', 14400, '1'),
(82, 'MSK', '591145200', 10800, '0'),
(82, 'MSD', '606870000', 14400, '1'),
(82, 'MSK', '622594800', 10800, '0'),
(82, 'EEST', '670374000', 10800, '1'),
(82, 'EET', '686102400', 7200, '0'),
(82, 'EEST', '701827200', 10800, '1'),
(82, 'EET', '717552000', 7200, '0'),
(82, 'EEST', '733276800', 10800, '1'),
(82, 'EET', '749001600', 7200, '0'),
(82, 'EEST', '764726400', 10800, '1'),
(82, 'EET', '780451200', 7200, '0'),
(82, 'EEST', '796176000', 10800, '1'),
(82, 'EET', '811900800', 7200, '0'),
(82, 'EEST', '828230400', 10800, '1'),
(82, 'EET', '846374400', 7200, '0'),
(82, 'EEST', '859680000', 10800, '1'),
(82, 'EET', '877824000', 7200, '0'),
(82, 'EEST', '891129600', 10800, '1'),
(82, 'EET', '909273600', 7200, '0'),
(82, 'EEST', '922579200', 10800, '1'),
(82, 'EET', '941328000', 7200, '0'),
(82, 'EEST', '954028800', 10800, '1'),
(82, 'EET', '972777600', 7200, '0'),
(82, 'EEST', '985478400', 10800, '1'),
(82, 'EET', '1004227200', 7200, '0'),
(82, 'EEST', '1017532800', 10800, '1'),
(82, 'EET', '1035676800', 7200, '0'),
(82, 'EEST', '1048982400', 10800, '1'),
(82, 'EET', '1067126400', 7200, '0'),
(82, 'EEST', '1080432000', 10800, '1'),
(82, 'EET', '1099180800', 7200, '0'),
(82, 'EEST', '1111881600', 10800, '1'),
(82, 'EET', '1130630400', 7200, '0'),
(82, 'EEST', '1143331200', 10800, '1'),
(82, 'EET', '1162080000', 7200, '0'),
(82, 'EEST', '1174780800', 10800, '1'),
(82, 'EET', '1193529600', 7200, '0'),
(82, 'EEST', '1206835200', 10800, '1'),
(82, 'EET', '1224979200', 7200, '0'),
(82, 'EEST', '1238284800', 10800, '1'),
(82, 'EET', '1256428800', 7200, '0'),
(82, 'EEST', '1269734400', 10800, '1'),
(82, 'EET', '1288483200', 7200, '0'),
(82, '+03', '1301184000', 10800, '0'),
(83, 'LMT', '-1822500433', -21168, '0'),
(83, 'CST', '-1822500432', -21600, '0'),
(83, '-0530', '-1616954400', -19800, '1'),
(83, 'CST', '-1606069800', -21600, '0'),
(83, '-0530', '-1585504800', -19800, '1'),
(83, 'CST', '-1574015400', -21600, '0'),
(83, '-0530', '-1554055200', -19800, '1'),
(83, 'CST', '-1542565800', -21600, '0'),
(83, '-0530', '-1522605600', -19800, '1'),
(83, 'CST', '-1511116200', -21600, '0'),
(83, '-0530', '-1490551200', -19800, '1'),
(83, 'CST', '-1479666600', -21600, '0'),
(83, '-0530', '-1459101600', -19800, '1'),
(83, 'CST', '-1448217000', -21600, '0'),
(83, '-0530', '-1427652000', -19800, '1'),
(83, 'CST', '-1416162600', -21600, '0'),
(83, '-0530', '-1396202400', -19800, '1'),
(83, 'CST', '-1384713000', -21600, '0'),
(83, '-0530', '-1364752800', -19800, '1'),
(83, 'CST', '-1353263400', -21600, '0'),
(83, '-0530', '-1333303200', -19800, '1'),
(83, 'CST', '-1321813800', -21600, '0'),
(83, '-0530', '-1301248800', -19800, '1'),
(83, 'CST', '-1290364200', -21600, '0'),
(83, '-0530', '-1269799200', -19800, '1'),
(83, 'CST', '-1258914600', -21600, '0'),
(83, '-0530', '-1238349600', -19800, '1'),
(83, 'CST', '-1226860200', -21600, '0'),
(83, '-0530', '-1206900000', -19800, '1'),
(83, 'CST', '-1195410600', -21600, '0'),
(83, '-0530', '-1175450400', -19800, '1'),
(83, 'CST', '-1163961000', -21600, '0'),
(83, '-0530', '-1143396000', -19800, '1'),
(83, 'CST', '-1132511400', -21600, '0'),
(83, '-0530', '-1111946400', -19800, '1'),
(83, 'CST', '-1101061800', -21600, '0'),
(83, '-0530', '-1080496800', -19800, '1'),
(83, 'CST', '-1069612200', -21600, '0'),
(83, '-0530', '-1049047200', -19800, '1'),
(83, 'CST', '-1037557800', -21600, '0'),
(83, '-0530', '-1017597600', -19800, '1'),
(83, 'CST', '-1006108200', -21600, '0'),
(83, '-0530', '-986148000', -19800, '1'),
(83, 'CST', '-974658600', -21600, '0'),
(83, '-0530', '-954093600', -19800, '1'),
(83, 'CST', '-943209000', -21600, '0'),
(83, '-0530', '-922644000', -19800, '1'),
(83, 'CST', '-911759400', -21600, '0'),
(83, '-0530', '-891194400', -19800, '1'),
(83, 'CST', '-879705000', -21600, '0'),
(83, '-0530', '-859744800', -19800, '1'),
(83, 'CST', '-848255400', -21600, '0'),
(83, 'CDT', '123919200', -18000, '1'),
(83, 'CST', '129618000', -21600, '0'),
(83, 'CDT', '409039200', -18000, '1'),
(83, 'CST', '413874000', -21600, '0'),
(84, 'LMT', '-2713897749', -12652, '0'),
(84, 'NST', '-2713897748', -12652, '0'),
(84, 'NDT', '-1664130548', -9052, '1'),
(84, 'NST', '-1650137348', -12652, '0'),
(84, 'NDT', '-1632076148', -9052, '1'),
(84, 'NST', '-1615145348', -12652, '0'),
(84, 'NDT', '-1598650148', -9052, '1'),
(84, 'NST', '-1590100148', -12652, '0'),
(84, 'NDT', '-1567286948', -9052, '1'),
(84, 'NST', '-1551565748', -12652, '0'),
(84, 'NDT', '-1535837348', -9052, '1'),
(84, 'NST', '-1520116148', -12652, '0'),
(84, 'NDT', '-1503782948', -9052, '1'),
(84, 'NST', '-1488666548', -12652, '0'),
(84, 'NDT', '-1472333348', -9052, '1'),
(84, 'NST', '-1457216948', -12652, '0'),
(84, 'NDT', '-1440883748', -9052, '1'),
(84, 'NST', '-1425767348', -12652, '0'),
(84, 'NDT', '-1409434148', -9052, '1'),
(84, 'NST', '-1394317748', -12652, '0'),
(84, 'NDT', '-1377984548', -9052, '1'),
(84, 'NST', '-1362263348', -12652, '0'),
(84, 'NDT', '-1346534948', -9052, '1'),
(84, 'NST', '-1330813748', -12652, '0'),
(84, 'NDT', '-1314480548', -9052, '1'),
(84, 'NST', '-1299364148', -12652, '0'),
(84, 'NDT', '-1283030948', -9052, '1'),
(84, 'NST', '-1267914548', -12652, '0'),
(84, 'NDT', '-1251581348', -9052, '1'),
(84, 'NST', '-1236464948', -12652, '0'),
(84, 'NDT', '-1220131748', -9052, '1'),
(84, 'NST', '-1205015348', -12652, '0'),
(84, 'NDT',