<?php
/*
	#	Developed by: Ynet Interactive
	#	Special thanks: Mr. White

*/
define('ENVIRONMENT', 'production');
ob_start();
session_start();
$URL = 'dashboard';
if(isset($_GET['url']))
{ 
	$URL = $_GET['url'];
}

if (defined('ENVIRONMENT'))
{
	switch (ENVIRONMENT)
	{
		case 'development':
			error_reporting(E_ALL);
		break;
	
		case 'testing':
		case 'production':
			error_reporting(0);
		break;

		default:
			exit('The application environment is not set correctly.');
	}
}
$system_path = '../../system';
$application_folder = 'hooks';
$module_folder = 'modules';
	// Set the current directory correctly for CLI requests
	if (defined('STDIN'))
	{
		chdir(dirname(__FILE__));
	}

	if (realpath($system_path) !== FALSE)
	{
		$system_path = realpath($system_path).'/';
	}

	// ensure there's a trailing slash
	$system_path = rtrim($system_path, '/').'/';
	// Is the system path correct?
	if ( ! is_dir($system_path))
	{
		exit("Your system folder path does not appear to be set correctly. Please open the following file and correct this: ".pathinfo(__FILE__, PATHINFO_BASENAME));
	}
	// The name of THIS file
	define('SELF', pathinfo(__FILE__, PATHINFO_BASENAME));
	// The PHP file extension
	// this global constant is deprecated.
	define('EXT', '.php');
	// Path to the system folder
	define('BASEPATH', str_replace("\\", "/", $system_path));
	// Path to the front controller (this file)
	define('FCPATH', str_replace(SELF, '', __FILE__));
	// Name of the "system folder"
	define('SYSDIR', trim(strrchr(trim(BASEPATH, '/'), '/'), '/'));

	// The path to the "application" folder
	if (is_dir($application_folder))
	{
		define('APPPATH', $application_folder.'/');
		define('MODPATH', $module_folder.'/');
	}
	else
	{
		if ( ! is_dir(BASEPATH.$application_folder.'/'))
		{
			exit("Your application folder path does not appear to be set correctly. Please open the following file and correct this: ".SELF);
		}

		define('APPPATH', BASEPATH.$application_folder.'/');
		define('MODPATH', BASEPATH.$module_folder.'/');
	}
define('COR', BASEPATH.'core/');	
define('LIB', BASEPATH.'libraries/');	
define('HELP', BASEPATH.'helpers/');	
require_once '../../root.php';
require_once BASEPATH.'core/Config.php';
foreach (glob(COR."/*.php") as $filename) { include $filename; }
foreach (glob(HELP."/*.php") as $filename) { include $filename; }
foreach (glob(LIB."/*.php") as $filename) { include $filename; }
$Config = new CI_Config();
setTimeZone();
require_once BASEPATH.'lang/'.setLang(1);
# ---------------------------------------------------------------------
#  THis is a cron script to update Infobip gateway message status
#----------------------------------------------------------------------

global $server;
$query="SELECT m.* FROM messagedetails m JOIN sms_gateways s ON m.gateway_id = s.id WHERE s.alias = 'infobip' AND m.status = 'sent' AND m.api_id != 0 AND m.dlr = 'sent' ORDER BY m.id DESC LIMIT 100";
$result = mysqli_query($server,$query) or die(mysqli_error($server));
while($rows = mysqli_fetch_assoc($result)) { 
	set_time_limit(0);
	$gatewayID = $rows['api_id'];
	$gateway_id = $rows['gateway_id'];
	$alias = smsGatewayData($gateway_id,'alias');
	$username = smsGatewayData($gateway_id,'username'); 
	$password = smsGatewayData($gateway_id,'password'); 
	if($gatewayID != '0' && $gatewayID != '') {
	    $curl = curl_init();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://api.infobip.com/sms/1/logs?messageId='.$gatewayID,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_SSL_VERIFYPEER, false,
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic '.base64_encode($username . ":" . $password),
                'Accept: application/json'
            ),
        ));
        $response = curl_exec($curl);
		$httpCode = curl_getinfo($curl, CURLINFO_HTTP_CODE);
		$responseBody = json_decode($response,true);
		curl_close($curl);
		$logs = $responseBody['results'];
		//if($logs)
		foreach ($logs as $log) {
			$messge_id = $log['messageId'];
			echo $sttus_temp = $log['status']['groupName'];
			if(!empty($sttus_temp) && $messge_id == $gatewayID ) {
				$dlr = $sttus_temp;
				mysqli_query($server,"UPDATE messagedetails SET dlr = '$dlr' WHERE api_id = '$gatewayID'") ;						
			}
		}
	    
	}
}
mysqli_close($server);